;-------------------------------------------------------------------------------
PRO traiter_poesn17_all,	$
;-------------------------------------------------------------------------------
	date1,			$	; LINT_PROTOTYPE input
	date2				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Cre les fichiers 'orbite', 'p90xxx', 'e90xxx', 'p0xxxx', 'e0xxxx', 'omnixx', 'p90cxx', 'e90cxx', 'p0cxxx', 'e0cxxx', en x86.
;-------------------------------------------------------------------------------

	FOR date=date1,date2,86400000 DO BEGIN

		top1 = nbsec()
		date_to_tu, date, annee, mois, jour, heure, minute, seconde

		YYYY = val_to_str(annee)
		MM = int_str_0(mois,2)
		DD = int_str_0(jour,2)
		YYYYMMDD = YYYY+MM+DD

		nom = '/DATA/POES/DATA/n17/'+YYYY+'/poes_n17_'+YYYYMMDD+'.cdf'

		IF fichier_existe(nom) THEN BEGIN
			code = read_cdf(nom,data,/quiet)
			IF code EQ 1 THEN BEGIN

				; MEPED
				; -----

				ind = WHERE (data.MEPED_0_DEGREE_PA_AT_THE_SATELLITE NE -1e31 AND data.MEPED_90_DEGREE_PA_AT_THE_SATELLITE NE -1e31)
				IF ind[0] NE -1 THEN BEGIN
					nom = '/DATA/POES/DATA/n17/'+YYYY+'/poes_n17_mpedxx_'+YYYYMMDD+'.x86'
					PRINT,'  '+nom
					OPENW, fd, nom, /GET_LUN, /SWAP_IF_BIG_ENDIAN
					FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
						WRITEU, fd, data[ind[i]].EPOCH
						WRITEU, fd, data[ind[i]].MEPED_0_DEGREE_PA_AT_THE_SATELLITE
						WRITEU, fd, data[ind[i]].MEPED_90_DEGREE_PA_AT_THE_SATELLITE
					END
					FREE_LUN, fd
				END


				; orbite
				; ------
				ind = WHERE (data.SUB_SATELLITE_LATITUDE NE -1e31 AND data.SUB_SATELLITE_LONGITUDE NE -1e31)
				IF ind[0] NE -1 THEN BEGIN
					nom = '/DATA/POES/DATA/n17/'+YYYY+'/poes_n17_orbite_'+YYYYMMDD+'.x86'
					PRINT,'  '+nom
					OPENW, fd, nom, /GET_LUN, /SWAP_IF_BIG_ENDIAN
					FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
						WRITEU, fd, data[ind[i]].EPOCH
						WRITEU, fd, data[ind[i]].SATELLITE_ALTITUDE
						WRITEU, fd, data[ind[i]].ORBIT_NUMBER
						;WRITEU, fd, data[ind[i]].SATELLITE_INCLINATION
						WRITEU, fd, data[ind[i]].SUB_SATELLITE_LATITUDE
						WRITEU, fd, data[ind[i]].SUB_SATELLITE_LONGITUDE
						;WRITEU, fd, data[ind[i]].RADIAL_COMPONENT_OF_B_AT_THE_SATELLITE
						;WRITEU, fd, data[ind[i]].EAST_COMPONENT_OF_B_AT_THE_SATELLITE
						;WRITEU, fd, data[ind[i]].SOUTH_COMPONENT_OF_B_AT_THE_SATELLITE
						WRITEU, fd, data[ind[i]].SCALAR_VALUE_OF_B_AT_THE_SATELLITE
						WRITEU, fd, data[ind[i]].TED_0_DEGREE_PA_AT_THE_SATELLITE
						WRITEU, fd, data[ind[i]].TED_30_DEGREE_PA_AT_THE_SATELLITE
						WRITEU, fd, data[ind[i]].MEPED_0_DEGREE_PA_AT_THE_SATELLITE
						WRITEU, fd, data[ind[i]].MEPED_90_DEGREE_PA_AT_THE_SATELLITE
						;WRITEU, fd, data[ind[i]].RADIAL_COMPONENT_OF_B_AT_THE_FOFL
						;WRITEU, fd, data[ind[i]].EAST_COMPONENT_OF_B_AT_THE_FOFL
						;WRITEU, fd, data[ind[i]].SOUTH_COMPONENT_OF_B_AT_THE_FOFL
						WRITEU, fd, data[ind[i]].SCALAR_VALUE_OF_B_AT_THE_FOFL
						WRITEU, fd, data[ind[i]].TED_0_DEGREE_PA_AT_THE_FOFL
						WRITEU, fd, data[ind[i]].TED_30_DEGREE_PA_AT_THE_FOFL
						WRITEU, fd, data[ind[i]].MEPED_0_PA_AT_THE_FOFL
						WRITEU, fd, data[ind[i]].MEPED_90_PA_AT_THE_FOFL
						WRITEU, fd, data[ind[i]].FOFL_GEOGRAPHIC_LATITUDE
						WRITEU, fd, data[ind[i]].FOFL_GEOGRAPHIC_LONGITUDE
						WRITEU, fd, data[ind[i]].FOFL_GEOMAGNETIC_LATITUDE
						WRITEU, fd, data[ind[i]].FOFL_GEOMAGNETIC_LONGITUDE
						WRITEU, fd, data[ind[i]].MCILWAIN_L_VALUE
						WRITEU, fd, data[ind[i]].CORRECTED_MAGNETIC_LATITUDE
						WRITEU, fd, data[ind[i]].SUB_SATELLITE_LOCAL_TIME
						WRITEU, fd, data[ind[i]].FOFL_MAGNETIC_LOCAL_TIME
						;WRITEU, fd, data[ind[i]].MEPED_ON_OFF
						;WRITEU, fd, data[ind[i]].TED_ON_OFF
						;WRITEU, fd, data[ind[i]].MEPED_IFC
						;WRITEU, fd, data[ind[i]].TED_IFC
						;WRITEU, fd, data[ind[i]].TED_ELECTRON_DISCRIMINATOR_LEVEL
						;WRITEU, fd, data[ind[i]].TED_PROTON_DISCRIMINATOR_LEVEL
						;WRITEU, fd, data[ind[i]].TED_ELECTRON_HV_SUPPLY
						;WRITEU, fd, data[ind[i]].TED_PROTON_HV_SUPPLY
						;WRITEU, fd, data[ind[i]].MU_PROCESSOR_IN_USE
						;WRITEU, fd, data[ind[i]].MU_PROCESSOR_ERROR_FLAG
					END
					FREE_LUN, fd
				END

				; p90
				; ---
				ind = WHERE (data.P1_90 NE -1e31)
				IF ind[0] NE -1 THEN BEGIN
					nom = '/DATA/POES/DATA/n17/'+YYYY+'/poes_n17_p90xxx_'+YYYYMMDD+'.x86'
					PRINT,'  '+nom
					OPENW, fd, nom, /GET_LUN, /SWAP_IF_BIG_ENDIAN
					FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
						WRITEU, fd, data[ind[i]].EPOCH
						WRITEU, fd, data[ind[i]].P1_90
						WRITEU, fd, data[ind[i]].P2_90
						WRITEU, fd, data[ind[i]].P3_90
						WRITEU, fd, data[ind[i]].P4_90
						WRITEU, fd, data[ind[i]].P5_90
						WRITEU, fd, data[ind[i]].P6_90
					END
					FREE_LUN, fd
				END

				; e90
				; ---
				ind = WHERE (data.E1_90 NE -1e31)
				IF ind[0] NE -1 THEN BEGIN
					nom = '/DATA/POES/DATA/n17/'+YYYY+'/poes_n17_e90xxx_'+YYYYMMDD+'.x86'
					PRINT,'  '+nom
					OPENW, fd, nom, /GET_LUN, /SWAP_IF_BIG_ENDIAN
					FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
						WRITEU, fd, data[ind[i]].EPOCH
						WRITEU, fd, data[ind[i]].E1_90
						WRITEU, fd, data[ind[i]].E2_90
						WRITEU, fd, data[ind[i]].E3_90
					END
					FREE_LUN, fd
				END

				; p0
				; --
				ind = WHERE (data.P1_0 NE -1e31)
				IF ind[0] NE -1 THEN BEGIN
					nom = '/DATA/POES/DATA/n17/'+YYYY+'/poes_n17_p0xxxx_'+YYYYMMDD+'.x86'
					PRINT,'  '+nom
					OPENW, fd, nom, /GET_LUN, /SWAP_IF_BIG_ENDIAN
					FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
						WRITEU, fd, data[ind[i]].EPOCH
						WRITEU, fd, data[ind[i]].P1_0
						WRITEU, fd, data[ind[i]].P2_0
						WRITEU, fd, data[ind[i]].P3_0
						WRITEU, fd, data[ind[i]].P4_0
						WRITEU, fd, data[ind[i]].P5_0
						WRITEU, fd, data[ind[i]].P6_0
					END
					FREE_LUN, fd
				END

				; e0
				; --
				ind = WHERE (data.E1_0 NE -1e31)
				IF ind[0] NE -1 THEN BEGIN
					nom = '/DATA/POES/DATA/n17/'+YYYY+'/poes_n17_e0xxxx_'+YYYYMMDD+'.x86'
					PRINT,'  '+nom
					OPENW, fd, nom, /GET_LUN, /SWAP_IF_BIG_ENDIAN
					FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
						WRITEU, fd, data[ind[i]].EPOCH
						WRITEU, fd, data[ind[i]].E1_0
						WRITEU, fd, data[ind[i]].E2_0
						WRITEU, fd, data[ind[i]].E3_0
					END
					FREE_LUN, fd
				END

				; omni
				; ---
				ind = WHERE (data.P6_OMNI_DIRECTIONAL NE -1e31)
				IF ind[0] NE -1 THEN BEGIN
					nom = '/DATA/POES/DATA/n17/'+YYYY+'/poes_n17_omnixx_'+YYYYMMDD+'.x86'
					PRINT,'  '+nom
					OPENW, fd, nom, /GET_LUN, /SWAP_IF_BIG_ENDIAN
					FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
						WRITEU, fd, data[ind[i]].EPOCH
						WRITEU, fd, data[ind[i]].P6_OMNI_DIRECTIONAL
						WRITEU, fd, data[ind[i]].P7_OMNI_DIRECTIONAL
						WRITEU, fd, data[ind[i]].P8_OMNI_DIRECTIONAL
						WRITEU, fd, data[ind[i]].P9_OMNI_DIRECTIONAL
					END
					FREE_LUN, fd
				END

				; p90c
				; ----
				ind = WHERE (data.P1_90_CORRECTED NE -1e31)
				IF ind[0] NE -1 THEN BEGIN
					nom = '/DATA/POES/DATA/n17/'+YYYY+'/poes_n17_p90cxx_'+YYYYMMDD+'.x86'
					PRINT,'  '+nom
					OPENW, fd, nom, /GET_LUN, /SWAP_IF_BIG_ENDIAN
					FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
						WRITEU, fd, data[ind[i]].EPOCH
						WRITEU, fd, data[ind[i]].P1_90_CORRECTED
						WRITEU, fd, data[ind[i]].P2_90_CORRECTED
						WRITEU, fd, data[ind[i]].P3_90_CORRECTED
						WRITEU, fd, data[ind[i]].P4_90_CORRECTED
						WRITEU, fd, data[ind[i]].P5_90_CORRECTED
					END
					FREE_LUN, fd
				END

				; e90c
				; ----
				ind = WHERE (data.E1_90_CORRECTED NE -1e31)
				IF ind[0] NE -1 THEN BEGIN
					nom = '/DATA/POES/DATA/n17/'+YYYY+'/poes_n17_e90cxx_'+YYYYMMDD+'.x86'
					PRINT,'  '+nom
					OPENW, fd, nom, /GET_LUN, /SWAP_IF_BIG_ENDIAN
					FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
						WRITEU, fd, data[ind[i]].EPOCH
						WRITEU, fd, data[ind[i]].E1_90_CORRECTED
						WRITEU, fd, data[ind[i]].E2_90_CORRECTED
						WRITEU, fd, data[ind[i]].E3_90_CORRECTED
					END
					FREE_LUN, fd
				END

				; p0c
				; ---
				ind = WHERE (data.P1_0_CORRECTED NE -1e31)
				IF ind[0] NE -1 THEN BEGIN
					nom = '/DATA/POES/DATA/n17/'+YYYY+'/poes_n17_p0cxxx_'+YYYYMMDD+'.x86'
					PRINT,'  '+nom
					OPENW, fd, nom, /GET_LUN, /SWAP_IF_BIG_ENDIAN
					FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
						WRITEU, fd, data[ind[i]].EPOCH
						WRITEU, fd, data[ind[i]].P1_0_CORRECTED
						WRITEU, fd, data[ind[i]].P2_0_CORRECTED
						WRITEU, fd, data[ind[i]].P3_0_CORRECTED
						WRITEU, fd, data[ind[i]].P4_0_CORRECTED
						WRITEU, fd, data[ind[i]].P5_0_CORRECTED
					END
					FREE_LUN, fd
				END

				; e0c
				; ---
				ind = WHERE (data.E1_0_CORRECTED NE -1e31)
				IF ind[0] NE -1 THEN BEGIN
					nom = '/DATA/POES/DATA/n17/'+YYYY+'/poes_n17_e0cxxx_'+YYYYMMDD+'.x86'
					PRINT,'  '+nom
					OPENW, fd, nom, /GET_LUN, /SWAP_IF_BIG_ENDIAN
					FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
						WRITEU, fd, data[ind[i]].EPOCH
						WRITEU, fd, data[ind[i]].E1_0_CORRECTED
						WRITEU, fd, data[ind[i]].E2_0_CORRECTED
						WRITEU, fd, data[ind[i]].E3_0_CORRECTED
					END
					FREE_LUN, fd
				END

			END

		END

		top2 = nbsec()

		PRINT, YYYYMMDD+' '+val_to_str_2decimales(top2-top1)

	END

END

;-------------------------------------------------------------------------------
PRO traiter_poesn17
;-------------------------------------------------------------------------------
; Traite les donnes POESN17 qui sont en CEF et cre les fichiers d'orbite et de comptages dans le format x86.
;-------------------------------------------------------------------------------

	traiter_poesn17_all,	tu_to_date(2004,1,1,0,0,0),	tu_to_date(2010,12,31,0,0,0)

END
