;-------------------------------------------------------------------------------
PRO traiter_one_dst_quicklook,	$
;-------------------------------------------------------------------------------
	YYYY,	$	; LINT_PROTOTYPE input
	MM		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Traite les données dst_quicklook pour une année et un mois donné.
;-------------------------------------------------------------------------------

	ON_IOERROR, error

	CD, '/DATA/INDICES/DATA/wdc.kugi.kyoto-u.ac.jp'

	file_http_copy, 'http://wdc.kugi.kyoto-u.ac.jp/dst_realtime/'+YYYY+MM+'/index.html', '.', localname=localname

	PRINT, 'Reading ' + localname + ' for ' + YYYY + MM

	OPENR, fd, localname, /GET_LUN
	ok = 0
	s = ''
	WHILE ~EOF(fd) DO BEGIN
		READF, fd, s
		tab = STRSPLIT (s, /EXTRACT)
		IF s[0] EQ 'DAY' THEN ok = 1
		IF ok EQ 0 THEN CONTINUE

		IF N_ELEMENTS(tab) NE 25 THEN CONTINUE
		DD = LONG(tab[0])
		nom = '/DATA/INDICES/DATA/L2/1H_DST/ind_1h_dst_'+YYYY+MM+int_str_0(DD,2)+'_v00.bin'
		nom_definitif = '/DATA/INDICES/DATA/L2/1H_DST/'+YYYY+'/'+MM+'/'+'ind_1h_dst_'+YYYY+MM+int_str_0(DD,2)+'_v00.bin'
		tabs = REPLICATE ({ date:0d, v1:7b, v2:0, dst:0, v4:0 }, 24)
		FOR HH=0L,23 DO BEGIN
			tabs[HH].date = tu_to_date (YYYY, MM, DD, HH, 0, 0)
			tabs[HH].dst = tab[HH+1]
		END
		mkdir_p, dirname(nom)
		OPENW, fd1, nom, /GET_LUN, /SWAP_IF_LITTLE_ENDIAN
		WRITEU, fd1, tabs
		FREE_LUN, fd1
		IF ~fichiers_idem (nom, nom_definitif) THEN BEGIN
			PRINT, '  Writing ' + nom_definitif
			mkdir_p, dirname(nom_definitif)
			lint_unused = copier (nom, nom_definitif)
		END
		lint_unused = detruire (nom)
	END
	FREE_LUN, fd

error:
	lint_unused = detruire (localname)

END

;-------------------------------------------------------------------------------
PRO traiter_dst_quicklook
;-------------------------------------------------------------------------------
; Traite les données dst_quicklook de 2007 jusqu'à l'anné actuelle.
;-------------------------------------------------------------------------------

	date = get_date()
	date_to_tu, date, annee, mois, jour, heure, minute, seconde

	FOR YYYY=2007L,annee DO BEGIN
		FOR MM=1L,12 DO BEGIN
			IF YYYY EQ annee THEN BEGIN
				IF MM GT mois THEN CONTINUE
			END
			traiter_one_dst_quicklook, val_to_str(YYYY), int_str_0(MM,2)
		END
	END
	EXIT

END
