;-------------------------------------------------------------------------------
PRO traiter_swid_count,	$
;-------------------------------------------------------------------------------
	AB,		$	; LINT_PROTOTYPE input
	date1,		$	; LINT_PROTOTYPE input
	date2,		$	; LINT_PROTOTYPE input
	cef,		$	; LINT_PROTOTYPE input
	cdf,		$	; LINT_PROTOTYPE input
	bin,		$	; LINT_PROTOTYPE input
	x86			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Cre les fichiers comptages de SWID dans les 4 formats cef, cdf, bin et x86.
;-------------------------------------------------------------------------------

	IF AB EQ 'A' THEN BEGIN
		energies = [40,88,167,216,277,316,358,407,463,480,512,547,581,619,662,705,747,796,852,907,962,1029,1091,1164,	$
				1238,1317,1409,1501,1593,1697,1814,1930,2053,2187,2328,2488,2647,2818,3002,3198,3627,4105,4669,5294,6004,8761,12805,16481]
	END ELSE BEGIN
		energies = [44,97,182,235,303,345,392,445,505,525,559,596,633,675,722,768,815,869,929,989,1049,1116,1189,1270,	$
				1350,1437,1537,1631,1737,1851,1971,2105,2239,2386,2539,2713,2887,3074,3274,3488,3956,4477,5092,5774,6549,9556,13966,17976]
	END

	thetas = [1.5,2.5,3.5,4.5,5.5,6.5,7.5,8.5,9.5,10.5,11.5,12.5]

	infos = PTRARR(4)

	infos_add, infos, 0, "",		'epoch'
	infos_add, infos, 0, "PARAMETER_TYPE",	'"Support_Data"'
	infos_add, infos, 0, "VALUE_TYPE",	'ISO_TIME'
	infos_add, infos, 0, "UNITS",		'"s"'

	infos_add, infos, 1, "",		'theta'
	infos_add, infos, 1, "SIZES",		'12'
	infos_add, infos, 1, "DATA",		data_to_cef(thetas)
	infos_add, infos, 1, "DELTA_PLUS",	'0.5'
	infos_add, infos, 1, "DELTA_MINUS",	'0.5'

	infos_add, infos, 2, "",		'energy'
	infos_add, infos, 2, "PARAMETER_TYPE",	'"Support_Data"'
	infos_add, infos, 2, "CATDESC",		'"Energy table"'
	infos_add, infos, 2, "FIELDNAM",	'"Energy table"'
	infos_add, infos, 2, "VALUE_TYPE",	'FLOAT'
	infos_add, infos, 2, "UNITS",		'"eV"'
	infos_add, infos, 2, "SI_CONVERSION",	'"1.60217646E-19>J"'
	infos_add, infos, 2, "SIZES",		'48'
	infos_add, infos, 2, "DATA",		data_to_cef(energies)

	infos_add, infos, 3, "",		'2d_data'
	infos_add, infos, 3, "CATDESC",		'"SWID'+AB+' 2D ion distribution"'
	infos_add, infos, 3, "FIELDNAM",	'"SWID'+AB+' 2D ion distribution"'
	infos_add, infos, 3, "PARAMETER_TYPE",	'"Data"'
	infos_add, infos, 3, "VALUE_TYPE",	'UINT2'
	infos_add, infos, 3, "SIZES",		'12,48'
	infos_add, infos, 3, "PROPERTY",	'"Raw_Particle_Counts"'
	infos_add, infos, 3, "UNITS",		'"Counts"'
	infos_add, infos, 3, "SI_CONVERSION",	'"1>(count)"'
	infos_add, infos, 3, "DEPEND_0",	'epoch'
	infos_add, infos, 3, "DEPEND_1",	'theta'
	infos_add, infos, 3, "DEPEND_2",	'energy'

		
	FOR date=date1,date2,86400000 DO BEGIN

		top1 = nbsec()
		date_to_tu, date, annee, mois, jour, heure, minute, seconde

		YYYY = val_to_str(annee)
		MM = int_str_0(mois,2)
		DD = int_str_0(jour,2)
		YYYYMMDD = YYYY+MM+DD

		nbmasses	= 1L
		nbcellules 	= 12L
		nbspectres	= 1L
		nbenergies 	= 48L

		msg = ''
		FOR icellule=0L,nbcellules-1 DO BEGIN

			nom = '/DATA/CHANGE2/DVD2_Reme/'+AB+'/01/CE2_CSSAR_SWID'+AB+'_SCI_'+YYYY+MM+'_ '+YYYY+' '+val_to_str(mois)+' '+val_to_str(jour)+'_P'+val_to_str(icellule+1)+'.01'
			IF fichier_existe(nom) THEN BEGIN
				code = read_cef(nom,tmp,/quiet)
				msg += code EQ 1 ? '2' : '1'
				IF icellule EQ 0 THEN BEGIN
					nbspins = N_ELEMENTS(tmp)
					output = { date: tmp.date, data: REPLICATE (0., nbspins, nbcellules, nbenergies) }
				END
				diff = output.date - tmp.date
				ind = WHERE(diff NE 0)
				IF ind[0] NE -1 THEN PRINT,'temps differents'
				IF ind[0] NE -1 THEN STOP

				FOR ienergie=0L,nbenergies-1 DO BEGIN
					tmpint = LONG64(tmp.(ienergie+1))
					diff = tmp.(ienergie+1) - tmpint
					ind = WHERE(diff NE 0)
					IF ind[0] NE -1 THEN PRINT,'comptages non entiers'
					IF ind[0] NE -1 THEN STOP
					output.data[*,icellule,ienergie] = tmp.(ienergie+1)
				END
			END ELSE BEGIN
				msg += '0'
				nbspins = 0L
			END

		END
		top2 = nbsec()

		IF msg EQ '000000000000' THEN BEGIN
			PRINT, YYYYMMDD+' '+msg+' no data'
			CONTINUE
		END

		; Passage heure en heure UTC car les donnes sont en temps Beijing Time (UTC+8)
		output.date -= 8*3600000d


		; 1) Fichier cef
		; --------------

		IF cef THEN BEGIN

			nom = '/DATA/CHANGE2/'+AB+'/SWID/'+YYYY+'/'+MM+'/'+'SWID'+AB+'_'+YYYYMMDD+'_V01.cef'
			FILE_MKDIR, dirname(nom)

			ecrire_entete_cxf, nom, infos, '";"', 1, 'CHANGE2', 'SOURCE_NAME', 'DESCRIPTOR', 'PI_NAME', 'PI_AFFILIATION', 'TXT_CEF'

			; 2.5 sec
			votable = 0L
			IF is_fdl() THEN BEGIN
				code = CALL_EXTERNAL (libname('write_ascii'), 'WRITE_DATE_TAB_AUTO_GLUE', nom, ',',';',			$
							nbspins,nbmasses,nbcellules,nbspectres,nbenergies,				$
							0L, 0, 0, 0,									$
							0L, 0L, 0, 0, 0,								$
							0L, 0, 0, 0,									$
							0L, 0,										$
							0L, 0, 0L, 0,									$
							output.date, output.data,							$
							date, date+86400000, date, date+86400000,					$
							"","","%.0f",ascii_time_format_string_to_val('YYYY-MM-DDTHH:MM:SS.MSCZ'),	$
							!VALUES.F_INFINITY, votable, /AUTO_GLUE)
			END ELSE BEGIN
				code = CALL_EXTERNAL (libname('write_ascii'), 'WRITE_DATE_TAB', nom, ',',';',				$
							nbspins,nbmasses,nbcellules,nbspectres,nbenergies,				$
							0L, 0, 0, 0,									$
							0L, 0L, 0, 0, 0,								$
							0L, 0, 0, 0,									$
							0L, 0,										$
							0L, 0, 0L, 0,									$
							output.date, output.data,							$
							date, date+86400000, date, date+86400000,					$
							"","","%.0f",ascii_time_format_string_to_val('YYYY-MM-DDTHH:MM:SS.MSCZ'),	$
							!VALUES.F_INFINITY, votable)
			END
							
			SPAWN, 'gzip -f '+nom

		END


		; 2) Fichier cdf
		; --------------

		IF cdf THEN BEGIN

			nom = '/DATA/CHANGE2/'+AB+'/SWID/'+YYYY+'/'+MM+'/'+'SWID'+AB+'_'+YYYYMMDD+'_V01.cdf'
			FILE_MKDIR, dirname(nom)

			ecrire_entete_cxf, nom, infos, '";"', 1, 'CHANGE2', 'SOURCE_NAME', 'DESCRIPTOR', 'PI_NAME', 'PI_AFFILIATION', 'TXT_CEF'

			fd = CDF_OPEN(nom)

			CDF_EPOCH, decalage, 1958, 1, 1, 0, 0, 0, /compute_epoch
			CDF_VARPUT, fd, 'epoch', output.date+decalage, /zvariable

			tab_data = output.data
			tab_data = TRANSPOSE(tab_data,[2,1,0])
			tab_data = UINT(tab_data)
			CDF_VARPUT, fd, '2d_data', tab_data, /zvariable

			CDF_CLOSE, fd

		END


		; 3) Fichier bin
		; --------------

		IF bin THEN BEGIN

			nom = '/DATA/CHANGE2/'+AB+'/SWID/'+YYYY+'/'+MM+'/'+'SWID'+AB+'_'+YYYYMMDD+'_V01.bin'
			FILE_MKDIR, dirname(nom)

			OPENW, fd, nom, /GET_LUN, /SWAP_IF_LITTLE_ENDIAN
			FOR ispin=0L,nbspins-1 DO BEGIN
				WRITEU, fd, output.date[ispin]
				data = output.data[ispin,*,*] 	; tableau [1,12,48]
				data = REFORM(data)		; tableau [12,48]
				data = REVERSE(data,1)		; pour inverser les nergies
				data = ROTATE(data,1)		; tableau [48,12]
				data = UINT(data)		; tableau d'entiers non signs sur 2 octets
			
				WRITEU, fd, data
			END
			FREE_LUN, fd

		END


		; 4) Fichier x86
		; --------------

		IF x86 THEN BEGIN

			nom = '/DATA/CHANGE2/'+AB+'/SWID/'+YYYY+'/'+MM+'/'+'SWID'+AB+'_'+YYYYMMDD+'_V01.x86'
			FILE_MKDIR, dirname(nom)

			OPENW, fd, nom, /GET_LUN, /SWAP_IF_BIG_ENDIAN
			FOR ispin=0L,nbspins-1 DO BEGIN
				WRITEU, fd, output.date[ispin]
				data = output.data[ispin,*,*] 	; tableau [1,12,48]
				data = REFORM(data)		; tableau [12,48]
				data = REVERSE(data,1)		; pour inverser les nergies
				data = ROTATE(data,1)		; tableau [48,12]
				data = UINT(data)		; tableau d'entiers non signs sur 2 octets
			
				WRITEU, fd, data
			END
			FREE_LUN, fd

		END

		top3 = nbsec()

		PRINT, YYYYMMDD+' '+msg+' '+val_to_str_2decimales(top2-top1)+'+' + val_to_str_2decimales(top3-top2)+'sec '+'MAX=['+val_to_str(MAX(output.data))+']'

	END

END

;-------------------------------------------------------------------------------
PRO traiter_swid_orbit,	$
;-------------------------------------------------------------------------------
	AB	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Cre les fichiers d'orbite dans les 4 formats cef, cdf, x86 et bin.
;-------------------------------------------------------------------------------
; LINT_VARIABLES infos nom_cdf fd_x86 fd_bin

	COMMON COMMON_CL, general

	liste = my_findfile ('/DATA/CHANGE2/DVD2_Reme/ORBIT'+AB+'/CE2_BMYK_SWID'+AB+'_SCI_P_*')
	nbfichiers = N_ELEMENTS(liste)

	MISSION		= 'CHANGE2'
	SOURCE_NAME	= ''
	DESCRIPTOR	= ''
	PI_NAME		= ''
	PI_AFFILIATION	= ''
	TXT_CEF		= ''

	nom_cef = ''

	nbtotal = 17L
	tabdatax = REPLICATE (0d,86400)
	tabdatay = REPLICATE (0.,nbtotal-1,86400)
	nbtabdata = 0L
	tab_datax = PTRARR(nbtotal-1)
	tab_datay = PTRARR(nbtotal-1)

	FOR ifichier=0L,nbfichiers-1 DO BEGIN

		nom_input = liste[ifichier]
		code = read_cef(nom_input,data,/quiet)
		IF code NE 1 THEN PRINT,'PB avec '+nom_input
		IF code NE 1 THEN STOP

		; Passage heure en heure UTC car les donnes sont en temps Beijing Time (UTC+8)
		data.date -= 8*3600000d

		; Transformer certaines valeurs par -1e31:
		;  - FIELD_1  FIELD_6: 	1.00000e+11
		;  - FIELD_7  FIELD_9: 	1.00000e+06
		;  - FIELD_10  FIELD_16:	10000.0

		ind = WHERE (data.field_1  EQ 1e11) & IF ind[0] NE -1 THEN data[ind].field_1  = -1e31
		ind = WHERE (data.field_2  EQ 1e11) & IF ind[0] NE -1 THEN data[ind].field_2  = -1e31
		ind = WHERE (data.field_3  EQ 1e11) & IF ind[0] NE -1 THEN data[ind].field_3  = -1e31
		ind = WHERE (data.field_4  EQ 1e11) & IF ind[0] NE -1 THEN data[ind].field_4  = -1e31
		ind = WHERE (data.field_5  EQ 1e11) & IF ind[0] NE -1 THEN data[ind].field_5  = -1e31
		ind = WHERE (data.field_6  EQ 1e11) & IF ind[0] NE -1 THEN data[ind].field_6  = -1e31
		ind = WHERE (data.field_7  EQ 1e6)  & IF ind[0] NE -1 THEN data[ind].field_7  = -1e31
		ind = WHERE (data.field_8  EQ 1e6)  & IF ind[0] NE -1 THEN data[ind].field_8  = -1e31
		ind = WHERE (data.field_9  EQ 1e6)  & IF ind[0] NE -1 THEN data[ind].field_9  = -1e31
		ind = WHERE (data.field_10 EQ 1e4)  & IF ind[0] NE -1 THEN data[ind].field_10 = -1e31
		ind = WHERE (data.field_11 EQ 1e4)  & IF ind[0] NE -1 THEN data[ind].field_11 = -1e31
		ind = WHERE (data.field_12 EQ 1e4)  & IF ind[0] NE -1 THEN data[ind].field_12 = -1e31
		ind = WHERE (data.field_13 EQ 1e4)  & IF ind[0] NE -1 THEN data[ind].field_13 = -1e31
		ind = WHERE (data.field_14 EQ 1e4)  & IF ind[0] NE -1 THEN data[ind].field_14 = -1e31
		ind = WHERE (data.field_15 EQ 1e4)  & IF ind[0] NE -1 THEN data[ind].field_15 = -1e31
		ind = WHERE (data.field_16 EQ 1e4)  & IF ind[0] NE -1 THEN data[ind].field_16 = -1e31

		; supprimer les lignes ne contenant que des FILLVAL
		ind = WHERE(	data.field_1  NE -1e31 OR	$
				data.field_2  NE -1e31 OR	$
				data.field_3  NE -1e31 OR	$
				data.field_4  NE -1e31 OR	$
				data.field_5  NE -1e31 OR	$
				data.field_6  NE -1e31 OR	$
				data.field_7  NE -1e31 OR	$
				data.field_8  NE -1e31 OR	$
				data.field_9  NE -1e31 OR	$
				data.field_10 NE -1e31 OR	$
				data.field_11 NE -1e31 OR	$
				data.field_12 NE -1e31 OR	$
				data.field_13 NE -1e31 OR	$
				data.field_14 NE -1e31 OR	$
				data.field_15 NE -1e31 OR	$
				data.field_16 NE -1e31)
		data = data[ind]

		nblignes = N_ELEMENTS(data)

		FOR iligne=0L,nblignes-1 DO BEGIN

			date_to_tu, data[iligne].date, annee, mois, jour, heure, minute, seconde
			YYYY = val_to_str(annee)
			MM = int_str_0(mois,2)
			DD = int_str_0(jour,2)
			YYYYMMDD = YYYY+MM+DD

			new_nom_cef = '/DATA/CHANGE2/'+AB+'/ORBIT/'+YYYY+'/'+MM+'/'+'ORBIT'+AB+'_'+YYYYMMDD+'_V01.cef'
			new_nom_cdf = '/DATA/CHANGE2/'+AB+'/ORBIT/'+YYYY+'/'+MM+'/'+'ORBIT'+AB+'_'+YYYYMMDD+'_V01.cdf'
			new_nom_bin = '/DATA/CHANGE2/'+AB+'/ORBIT/'+YYYY+'/'+MM+'/'+'ORBIT'+AB+'_'+YYYYMMDD+'_V01.bin'
			new_nom_x86 = '/DATA/CHANGE2/'+AB+'/ORBIT/'+YYYY+'/'+MM+'/'+'ORBIT'+AB+'_'+YYYYMMDD+'_V01.x86'
			IF nom_cef NE new_nom_cef THEN BEGIN

				PRINT, new_nom_cef

				IF nom_cef NE '' THEN BEGIN

					FOR i=0L,nbtotal-2 DO BEGIN
						tab_datax[i] = PTR_NEW(       tabdatax[  0:nbtabdata-1])
						tab_datay[i] = PTR_NEW(REFORM(tabdatay[i,0:nbtabdata-1]))
					END
					nbtabdata = 0L

					ecrire_cxf, nom_cef, 									$
							ascii_time_format=3,							$
							ascii_field_separator='comma',						$
							ascii_header='in data file',						$
							infos, nbtotal-1, tab_datax, tab_datay, 1L, -1e31, general, 'epoch',	$
							MISSION=MISSION, SOURCE_NAME=SOURCE_NAME, DESCRIPTOR=DESCRIPTOR,	$
							PI_NAME=PI_NAME, PI_AFFILIATION=PI_AFFILIATION, TXT_CEF=TXT_CEF,/nofree

					ecrire_cxf, nom_cdf, /cdf,								$
							ascii_time_format=3,							$
							ascii_field_separator='comma',						$
							ascii_header='in data file',						$
							infos, nbtotal-1, tab_datax, tab_datay, 1L, -1e31, general, 'epoch',	$
							MISSION=MISSION, SOURCE_NAME=SOURCE_NAME, DESCRIPTOR=DESCRIPTOR,	$
							PI_NAME=PI_NAME, PI_AFFILIATION=PI_AFFILIATION, TXT_CEF=TXT_CEF

					FOR i=0L,nbtotal-2 DO BEGIN
						PTR_FREE, tab_datax[i]
						PTR_FREE, tab_datay[i]
					END

					FREE_LUN, fd_x86
					FREE_LUN, fd_bin
					SPAWN, 'gzip -f '+nom_cef
				END

				infos = PTRARR(nbtotal)

				infos_add, infos, 0, "",		'epoch'
				infos_add, infos, 0, "PARAMETER_TYPE",	'"Support_Data"'
				infos_add, infos, 0, "VALUE_TYPE",	'ISO_TIME'
				infos_add, infos, 0, "UNITS",		'"s"'

				infos_add, infos, 1, "",		'Xgse_m'
				infos_add, infos, 1, "PARAMETER_TYPE",	'"Data"'
				infos_add, infos, 1, "VALUE_TYPE",	'FLOAT'
				infos_add, infos, 1, "UNITS",		'"m"'

				infos_add, infos, 2, "",		'Ygse_m'
				infos_add, infos, 2, "PARAMETER_TYPE",	'"Data"'
				infos_add, infos, 2, "VALUE_TYPE",	'FLOAT'
				infos_add, infos, 2, "UNITS",		'"m"'

				infos_add, infos, 3, "",		'Zgse_m'
				infos_add, infos, 3, "PARAMETER_TYPE",	'"Data"'
				infos_add, infos, 3, "VALUE_TYPE",	'FLOAT'
				infos_add, infos, 3, "UNITS",		'"m"'

				infos_add, infos, 4, "",		'Xmoon_center_m'
				infos_add, infos, 4, "PARAMETER_TYPE",	'"Data"'
				infos_add, infos, 4, "VALUE_TYPE",	'FLOAT'
				infos_add, infos, 4, "UNITS",		'"m"'

				infos_add, infos, 5, "",		'Ymoon_center_m'
				infos_add, infos, 5, "PARAMETER_TYPE",	'"Data"'
				infos_add, infos, 5, "VALUE_TYPE",	'FLOAT'
				infos_add, infos, 5, "UNITS",		'"m"'

				infos_add, infos, 6, "",		'Zmoon_center_m'
				infos_add, infos, 6, "PARAMETER_TYPE",	'"Data"'
				infos_add, infos, 6, "VALUE_TYPE",	'FLOAT'
				infos_add, infos, 6, "UNITS",		'"m"'

				infos_add, infos, 7, "",		'XSelenocentric_km'
				infos_add, infos, 7, "PARAMETER_TYPE",	'"Data"'
				infos_add, infos, 7, "VALUE_TYPE",	'FLOAT'
				infos_add, infos, 7, "UNITS",		'"km"'

				infos_add, infos, 8, "",		'YSelenocentric_km'
				infos_add, infos, 8, "PARAMETER_TYPE",	'"Data"'
				infos_add, infos, 8, "VALUE_TYPE",	'FLOAT'
				infos_add, infos, 8, "UNITS",		'"km"'

				infos_add, infos, 9, "",		'ZSelenocentric_km'
				infos_add, infos, 9, "PARAMETER_TYPE",	'"Data"'
				infos_add, infos, 9, "VALUE_TYPE",	'FLOAT'
				infos_add, infos, 9, "UNITS",		'"km"'

				infos_add, infos, 10, "",		'Solar_Zenith_Angle'
				infos_add, infos, 10, "PARAMETER_TYPE",	'"Data"'
				infos_add, infos, 10, "VALUE_TYPE",	'FLOAT'
				infos_add, infos, 10, "UNITS",		'"deg"'

				infos_add, infos, 11, "",		'X_Axis_GSE_long'
				infos_add, infos, 11, "PARAMETER_TYPE",	'"Data"'
				infos_add, infos, 11, "VALUE_TYPE",	'FLOAT'
				infos_add, infos, 11, "UNITS",		'"deg"'

				infos_add, infos, 12, "",		'X_Axis_GSE_lat'
				infos_add, infos, 12, "PARAMETER_TYPE",	'"Data"'
				infos_add, infos, 12, "VALUE_TYPE",	'FLOAT'
				infos_add, infos, 12, "UNITS",		'"deg"'

				infos_add, infos, 13, "",		'Y_axis_GSE_long'
				infos_add, infos, 13, "PARAMETER_TYPE",	'"Data"'
				infos_add, infos, 13, "VALUE_TYPE",	'FLOAT'
				infos_add, infos, 13, "UNITS",		'"deg"'

				infos_add, infos, 14, "",		'Y_axis_GSE_lat'
				infos_add, infos, 14, "PARAMETER_TYPE",	'"Data"'
				infos_add, infos, 14, "VALUE_TYPE",	'FLOAT'
				infos_add, infos, 14, "UNITS",		'"deg"'

				infos_add, infos, 15, "",		'Z_axis_GSE_long'
				infos_add, infos, 15, "PARAMETER_TYPE",	'"Data"'
				infos_add, infos, 15, "VALUE_TYPE",	'FLOAT'
				infos_add, infos, 15, "UNITS",		'"deg"'

				infos_add, infos, 16, "",		'Z_axis_GSE_lat'
				infos_add, infos, 16, "PARAMETER_TYPE",	'"Data"'
				infos_add, infos, 16, "VALUE_TYPE",	'FLOAT'
				infos_add, infos, 16, "UNITS",		'"deg"'

				nom_cef = new_nom_cef
				nom_cdf = new_nom_cdf
				nom_bin = new_nom_bin
				nom_x86 = new_nom_x86
				FILE_MKDIR, dirname(nom_cef)

				OPENW, fd_x86, nom_x86, /GET_LUN
				OPENW, fd_bin, nom_bin, /SWAP_IF_LITTLE_ENDIAN, /GET_LUN

			END

			tabdatax[nbtabdata] = data[iligne].date
			FOR ifield=0L,nbtotal-2 DO BEGIN
				tabdatay[ifield,nbtabdata] = data[iligne].(ifield+1)
			END
			nbtabdata++

			WRITEU, fd_x86, data[iligne]
			WRITEU, fd_bin, data[iligne]
		END


	END

	IF nom_cef NE '' THEN BEGIN
		FOR i=0L,nbtotal-2 DO BEGIN
			tab_datax[i] = PTR_NEW(       tabdatax[  0:nbtabdata-1])
			tab_datay[i] = PTR_NEW(REFORM(tabdatay[i,0:nbtabdata-1]))
		END
		ecrire_cxf, nom_cef, 									$
				ascii_time_format=3,							$
				ascii_field_separator='comma',						$
				ascii_header='in data file',						$
				infos, nbtotal-1, tab_datax, tab_datay, 1L, -1e31, general, 'epoch',	$
				MISSION=MISSION, SOURCE_NAME=SOURCE_NAME, DESCRIPTOR=DESCRIPTOR,	$
				PI_NAME=PI_NAME, PI_AFFILIATION=PI_AFFILIATION, TXT_CEF=TXT_CEF,/nofree

		ecrire_cxf, nom_cdf, /cdf,								$
				ascii_time_format=3,							$
				ascii_field_separator='comma',						$
				ascii_header='in data file',						$
				infos, nbtotal-1, tab_datax, tab_datay, 1L, -1e31, general, 'epoch',	$
				MISSION=MISSION, SOURCE_NAME=SOURCE_NAME, DESCRIPTOR=DESCRIPTOR,	$
				PI_NAME=PI_NAME, PI_AFFILIATION=PI_AFFILIATION, TXT_CEF=TXT_CEF

		FOR i=0L,nbtotal-2 DO BEGIN
			PTR_FREE, tab_datax[i]
			PTR_FREE, tab_datay[i]
		END

		FREE_LUN, fd_x86
		FREE_LUN, fd_bin
		SPAWN, 'gzip -f '+nom_cef
	END

END

;-------------------------------------------------------------------------------
PRO traiter_change2
;-------------------------------------------------------------------------------
; Traite les donnes CHANGE2 et cre les fichiers de comptages et d'orbite dans les formats cef, cdf, x86 et bin.
;-------------------------------------------------------------------------------

	traiter_swid_count,	'A',	tu_to_date(2010,10,10,0,0,0),	tu_to_date(2011, 4,18,0,0,0),	1,1,1,1
	traiter_swid_count,	'B',	tu_to_date(2010,10,10,0,0,0),	tu_to_date(2011, 4,18,0,0,0),	1,1,1,1

	traiter_swid_orbit,	'A'
	traiter_swid_orbit,	'B'

END
