;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: title__define.pro,v $, v $Revision: 1.27 $
;
;	Date	: $Date: 2014/03/13 11:27:12 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO title::compute
;-------------------------------------------------------------------------------
; Effectue toutes les opérations nécessaires pour afficher l'objet.
;-------------------------------------------------------------------------------

	fenetre = self.fenetre
	general = self.general

	hash = self -> gethash()
	hash_general = general -> gethash()

	ntrace = getq(general,hash_general.ntrace)
	IF ntrace GE 1 THEN BEGIN
		msg = self -> name()
		time_t1 = str_to_date(getq(self,hash.time_t1))
		str = STRING(msg,' ',date_to_str(time_t1), FORMAT='(A,A,A)')
		cl_msg, general, str_bas=" "
		cl_msg, general, str_bas=str
	END

	titre_rvb = { var_pal, r:getq (self, hash.titre_color_r), v:getq (self, hash.titre_color_v), b:getq (self, hash.titre_color_b) } & titre_coul = 0
	rvb = [titre_rvb]

	cube = getq(self,hash.palette_cube) 
	IF cube NE 'No' AND cube NE 'True color' THEN BEGIN
		; On va quantifier les couleurs avec COLOR_QUAN et cube
		r = rvb.r & v = rvb.v & b = rvb.b
		image = INDGEN(N_ELEMENTS(rvb))
		nbcube = (STRSPLIT(cube, /EXTRACT))[0]^(1./3)
		trans = COLOR_QUAN (r[image],v[image], b[image],r,v,b,cube=nbcube)
		rvb = REPLICATE ({ var_pal, r:0, v:0, b:0 }, N_ELEMENTS(r))
		rvb.r = r & rvb.v = v & rvb.b = b
	END ELSE BEGIN
		trans = INDGEN(N_ELEMENTS(rvb))
	END

	; on indique a fenetre les codes rvb dont on a besoin
	fenetre -> fsetproperty,rvb,/rvb

	; Titre
	; -----
	compute_title, self, fenetre, general, hash, hash_general, $
			trans, titre_coul

END

;-------------------------------------------------------------------------------
FUNCTION title::init,	$
;-------------------------------------------------------------------------------
	no,		$	; LINT_PROTOTYPE input
	container,	$	; LINT_PROTOTYPE input
	order,		$	; LINT_PROTOTYPE input
	general			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Constructeur de la classe "title".
;-------------------------------------------------------------------------------

	; Initialisation des champs qui ne doivent pas contenir 0

	exls = get_experiment_list()
	experiment_list = exls[WHERE(exls.title EQ 1)].experience
	experiment_list = experiment_list[SORT(experiment_list)]
	nosat_list = get_nosat_list()
	nosat_list = val_to_str(INDGEN(N_ELEMENTS(nosat_list))+1)

	param = [ $
		{ var_obj, 'Experiment: Experiment',	'nomcis',		2, PTR_NEW(['L1','2','30','LABEL_LEFT',experiment_list]),	'check_always_ok',		PTR_NEW(),	PTR_NEW ('CIS-CODIF')			},	$
		{ var_obj, 'Time:Start', 		'time_t1', 		3, PTR_NEW(['TE','2','23']), 					'check_strdate', 		PTR_NEW(), 	PTR_NEW ('29 06 1999 14 30 00.000')	}, 	$
		{ var_obj, 'Data: Left Winsize',	'yleft_winsize',	4, PTR_NEW(['FL','0','12']),					'check_supegal_infegal',	PTR_NEW([0,1]),	PTR_NEW (0.2)				}, 	$
		{ var_obj, 'Right Winsize',		'legend_winsize',	4, PTR_NEW(['FL','2','12']),					'check_supegal_infegal',	PTR_NEW([0,1]),	PTR_NEW (0.2)				},	$
		{ var_obj, 'Title:Spacecraft',		'nosat',		4, PTR_NEW(['DR','0','LABEL_LEFT',nosat_list]),			'check_always_ok',		PTR_NEW(),	PTR_NEW ('1')				}	]

	code = self -> obj::init (no, container, order, param, general=general, /saisissable, graphique=1, titre=4, palette=5, /shortpalette, /nonbcolors)

	set, self, 'nbmincolors',4
	set, self, 'palette_cube', 'No'
	set, self, 'noparam', 2

	RETURN, code

END


;-------------------------------------------------------------------------------
PRO title__define
;-------------------------------------------------------------------------------
; La classe "title" hérite de "obj".
;-------------------------------------------------------------------------------

	lint_unused = { title, 	$

		INHERITS obj 	$

	}

END
