;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: text__define.pro,v $, v $Revision: 1.14 $
;
;	Date	: $Date: 2014/03/13 11:26:54 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
FUNCTION text::check
;-------------------------------------------------------------------------------
; Retourne un message s'il y a un problème avec certaines variables.
;-------------------------------------------------------------------------------

	RETURN, self -> obj::check_gauche_droite_bas_haut()

END

;-------------------------------------------------------------------------------
PRO text::compute
;-------------------------------------------------------------------------------
; Effectue toutes les opérations nécessaires pour afficher l'objet.
;-------------------------------------------------------------------------------

	fenetre = self.fenetre
	general = self.general

	hash = self -> gethash()
	hash_general = general -> gethash()

	ntrace = getq (general, hash_general.ntrace)
	IF ntrace GE 1 THEN BEGIN
		msg = self -> name()
		str = STRING(msg, FORMAT='(A)')
		cl_msg, general, str_bas=" "
		cl_msg, general, str_bas=str
	END

	x         = getq(self,hash.x)
	y         = getq(self,hash.y)
	texte     = getq(self,hash.texte)
	alignment = getq(self,hash.alignment)
	taille    = getq(self,hash.taille)
	angle     = getq(self,hash.angle)
	thick     = getq(self,hash.thick)
	coulr     = getq(self,hash.coulr)
	coulv     = getq(self,hash.coulv)
	coulb     = getq(self,hash.coulb)

	; De quelles couleurs a t-on besoin ?
	rvb = { var_pal, r:coulr, v:coulv, b:coulb } & coul   = 0

	cube = getq(self,hash.palette_cube) 
	IF cube NE 'No' AND cube NE 'True color' THEN BEGIN
		; On va quantifier les couleurs avec COLOR_QUAN et cube
		r = rvb.r & v = rvb.v & b = rvb.b
		image = INDGEN(N_ELEMENTS(rvb))
		nbcube = (STRSPLIT(cube, /EXTRACT))[0]^(1./3)
		trans = COLOR_QUAN (r[image],v[image], b[image],r,v,b,cube=nbcube)
		rvb = REPLICATE ({ var_pal, r:0, v:0, b:0 }, N_ELEMENTS(r))
		rvb.r = r & rvb.v = v & rvb.b = b
	END ELSE BEGIN
		trans = INDGEN(N_ELEMENTS(rvb))
	END

	fenetre -> fsetproperty,rvb,/rvb

	fenetre -> ajouter_texte, x, y, texte, alignment, taille, trans[coul], angle, $
			thick

END

;-------------------------------------------------------------------------------
FUNCTION text::init,	$
;-------------------------------------------------------------------------------
	no,		$	; LINT_PROTOTYPE input
	container,	$	; LINT_PROTOTYPE input
	order,		$	; LINT_PROTOTYPE input
	general			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Construteur de la classe "text"
;-------------------------------------------------------------------------------

	param = [ $

		{ var_obj, 'Data:X', 		'x',		2, PTR_NEW(['FL','0','12']), 		'check_supegal_infegal',	PTR_NEW([0,1]),	PTR_NEW (0.5)	},	$
		{ var_obj, 'Y', 		'y',		2, PTR_NEW(['FL','2','12']), 		'check_supegal_infegal',	PTR_NEW([0,1]), PTR_NEW (0.5)	},	$
		{ var_obj, 'Text', 		'texte',	2, PTR_NEW(['TE','2','99']), 		'check_always_ok',		PTR_NEW(),	PTR_NEW ('')	},	$
		{ var_obj, 'Thick', 		'thick',	2, PTR_NEW(['FL','0','12']), 		'check_sup', 			PTR_NEW(0),	PTR_NEW (1.)	},	$
		{ var_obj, 'Alignment',		'alignment',	2, PTR_NEW(['FL','2','12']), 		'check_supegal', 		PTR_NEW([0]),	PTR_NEW (0.5)	},	$
		{ var_obj, 'Size', 		'taille',	2, PTR_NEW(['FL','0','12']), 		'check_supegal', 		PTR_NEW([0]),	PTR_NEW (1.0)	},	$
		{ var_obj, 'Angle (deg)',	'angle',	2, PTR_NEW(['FL','2','12']), 		'check_always_ok', 		PTR_NEW(),	PTR_NEW (0.)	},	$
		{ var_obj, 'Color R', 		'coulr',	2, PTR_NEW(['SL','0','150','0','255']),	'check_always_ok', 		PTR_NEW(),	PTR_NEW (0)	},	$
		{ var_obj, 'G', 		'coulv',	2, PTR_NEW(['SL','0','150','0','255']), 'check_always_ok', 		PTR_NEW(),	PTR_NEW (0)	},	$
		{ var_obj, 'B', 		'coulb',	2, PTR_NEW(['SL','2','150','0','255']), 'check_always_ok', 		PTR_NEW(),	PTR_NEW (0)	} 	$

	]

	code = self -> obj::init (no, container, order, param, general=general, /saisissable, graphique=1, palette=3, /shortpalette, /nonbcolors)

	set, self, 'nbmincolors', 1
	set, self, 'nbmaxcolors', 1
	set, self, 'noparam', 2

	RETURN, code

END


;-------------------------------------------------------------------------------
PRO text__define
;-------------------------------------------------------------------------------
; La classe "text" hérite de "obj".
;-------------------------------------------------------------------------------

	lint_unused = { text, 	$

		INHERITS obj 	$

	}

END
