;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: tev__define.pro,v $, v $Revision: 1.12 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
PRO tev::setproperty,		$
;-------------------------------------------------------------------------------
	nom,			$	; LINT_PROTOTYPE input
	val,			$	; LINT_PROTOTYPE input
	passaveold=passaveold		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Appellé pour modifier la valeur d'une variable (ce qui peut entrainer la modif d'autres variables).
;-------------------------------------------------------------------------------

	IF nom EQ 'time_t1t2' THEN BEGIN
		self -> obj::setproperty,'time_t1', val[0], passaveold=passaveold
		self -> obj::setproperty,'time_t2', val[1], passaveold=passaveold
	END ELSE BEGIN
		self -> obj::setproperty, nom, val, passaveold=passaveold
	END

END

;-------------------------------------------------------------------------------
FUNCTION tev::search_list_orbit,	$
;-------------------------------------------------------------------------------
	filename,		$	; LINT_PROTOTYPE input
	offset_orbit,		$	; LINT_PROTOTYPE input
	taille,			$	; LINT_PROTOTYPE input
	nb,			$	; LINT_PROTOTYPE input
	valeur				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne un tableau avec les numéros d'enregistrement dont le champ orbit vaut valeur, retourne -1 si valeur n'a pas été trouvé.
;-------------------------------------------------------------------------------

	; peut retourner 1, -1, -2
	no1 = -1L
	no2 = -1L
	IF is_fdl() THEN BEGIN
		lint_unused = CALL_EXTERNAL (libname('file'), 'TARANIS_SEARCH_LIST_ORBIT_AUTO_GLUE',		$
						filename, taille, nb, offset_orbit, LONG(valeur), no1, no2, /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('file'), 'TARANIS_SEARCH_LIST_ORBIT',		$
						filename, taille, nb, offset_orbit, LONG(valeur), no1, no2)
	END
	IF no1 EQ -1 THEN BEGIN
		RETURN, -1
	END ELSE BEGIN
		RETURN, no1 + LINDGEN(no2-no1+1)
	END

END

;-------------------------------------------------------------------------------
FUNCTION tev::search_list_date1,	$
;-------------------------------------------------------------------------------
	filename,		$	; LINT_PROTOTYPE input
	offset_date1,		$	; LINT_PROTOTYPE input
	taille,			$	; LINT_PROTOTYPE input
	nb,			$	; LINT_PROTOTYPE input
	valeur				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne s'il existe le plus grand numéro d'enregistrement avec enreg.date1 <= valeur, sinon retourne le premier numéro (-1 si nb==0)
;-------------------------------------------------------------------------------

	; peut retourner 1, -1, -2
	no = nb EQ 0 ? -1L : 0L
	IF is_fdl() THEN BEGIN
		lint_unused = CALL_EXTERNAL (libname('file'), 'TARANIS_SEARCH_LIST_DATE1_AUTO_GLUE',	$
						filename, taille, nb, offset_date1, valeur, no, /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('file'), 'TARANIS_SEARCH_LIST_DATE1',		$
						filename, taille, nb, offset_date1, valeur, no)
	END
	RETURN, no

END

;-------------------------------------------------------------------------------
FUNCTION tev::get_legende,	$
;-------------------------------------------------------------------------------
	experiment,		$	; LINT_PROTOTYPE input
	product,		$	; LINT_PROTOTYPE input
	tab_event_sensor,	$	; LINT_PROTOTYPE input
	tab_event_plane,	$	; LINT_PROTOTYPE input
	event_emin,		$	; LINT_PROTOTYPE input
	event_emax,		$	; LINT_PROTOTYPE input
	tab_event_type			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne la légende à afficher à droite des tracés
;-------------------------------------------------------------------------------

	legende = experiment + ' ' + product
	IF experiment EQ 'EPHEMERIS' THEN BEGIN
	END ELSE IF experiment EQ 'XGRE' THEN BEGIN
		ind = WHERE (tab_event_sensor EQ 1)
		legende += '!C' + 'sensor: ' + (ind[0] EQ -1 ? '?' : STRJOIN(val_to_str(ind),' '))
		ind = WHERE (tab_event_plane EQ 1)
		IF ind[0] NE -1 THEN BEGIN
			legende += '!C' + 'plane: '+STRJOIN(val_to_str(ind),'|')
			legende += '!C' + 'emin: '+STRJOIN(event_emin[ind],'|')
			legende += '!C' + 'emax: '+STRJOIN(event_emax[ind],'|')
		END ELSE BEGIN
			legende += '!C' + 'plane: ?'
			legende += '!C' + 'emin: ?'
			legende += '!C' + 'emax: ?'
		END
	END ELSE BEGIN
		ind = WHERE (tab_event_sensor EQ 1)
		legende += '!C' + 'sensor: ' + (ind[0] EQ -1 ? '?' : STRJOIN(val_to_str(ind),' '))
		ind = WHERE (tab_event_type EQ 1)
		legende += '!C' + 'type: ' + (ind[0] EQ -1 ? '?' : STRJOIN(val_to_str(ind),' '))
		legende += '!C' + 'emin: '+val_to_str(event_emin)
		legende += '!C' + 'emax: '+val_to_str(event_emax)
	END

	RETURN, legende

END

;-------------------------------------------------------------------------------
FUNCTION tev::val_to_tab,	$
;-------------------------------------------------------------------------------
	val,			$	; LINT_PROTOTYPE input
	nb				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne un tableau de valeur (ex: ['0 (PUP),'1 (LABR3'),'2 (PDOWN)'] en un tableau de nb bytes.
;-------------------------------------------------------------------------------

	tab = REPLICATE (0b, nb)
	FOR j=0L,N_ELEMENTS(val)-1 DO BEGIN
		tmp = STRSPLIT (val[j], /EXTRACT)
		IF is_number(tmp[0]) THEN tab[tmp[0]] = 1
	END

	RETURN, tab

END

;-------------------------------------------------------------------------------
FUNCTION tev::tev_get_data,	$
;-------------------------------------------------------------------------------
	date1,			$	; LINT_PROTOTYPE input
	date2,			$	; LINT_PROTOTYPE input
	tab_event_type,		$	; LINT_PROTOTYPE input
	tab_event_sensor,	$	; LINT_PROTOTYPE input
	event_emin,		$	; LINT_PROTOTYPE input
	event_emax,		$	; LINT_PROTOTYPE input
	event_dt,		$	; LINT_PROTOTYPE input
	tab_event_plane,	$	; LINT_PROTOTYPE input
	experiment,		$	; LINT_PROTOTYPE input
	product,		$	; LINT_PROTOTYPE input
	ascii,			$	; LINT_PROTOTYPE input
	nbtables,		$	; LINT_PROTOTYPE input
	spectreX,		$	; LINT_PROTOTYPE output
	spectreY,		$	; LINT_PROTOTYPE output
	courbeX,		$	; LINT_PROTOTYPE output
	courbeY,		$	; LINT_PROTOTYPE output
	use_raw_energy,		$	; LINT_PROTOTYPE output
	msg_erreur			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; ((1:ok -1:PB)) Calcule spectreX, spectreY, courbeX (nanosecondes depuis le début du premier jour) et courbeY.
;-------------------------------------------------------------------------------

	top1 = nbsec()

	msg_erreur = ''

	general = self.general
	p = get (general, 'p')

	CASE product OF
		'ORBIT':	noproduit =  0
		'XGA':		noproduit =  5
		'TGF':		noproduit =  6
		'GRB':		noproduit =  7
		'UNK':		noproduit =  8
		'BKG':		noproduit =  8
		'TEST':		noproduit =  9
		'PARTICLE':	noproduit = 10
		'RRE':		noproduit = 11
		'LEP':		noproduit = 12
	END
	nosat = 1
	produit = p[noproduit, nomcis_string_to_val(experiment), nosat]

	enreg = produit -> pgetproperty (/enreg)
	param = produit -> pgetproperty (/param)

	lint_unused = get_structure_infos (enreg, taille_enreg, nbchamps, nom_champ, type_champ, offset_champ, taille_champ, nb_champ)
	offset = 0L
	FOR i=0L,nbchamps-1 DO BEGIN
		IF nom_champ[i] EQ 'DATE'		THEN offset_date		= offset
		IF nom_champ[i] EQ 'CORRECTION'		THEN offset_correction		= offset
		IF nom_champ[i] EQ 'TYPE'		THEN offset_type		= offset
		IF nom_champ[i] EQ 'SENSOR'		THEN offset_sensor		= offset
		IF nom_champ[i] EQ 'RAW_ENERGY'		THEN offset_raw_energy		= offset
		IF nom_champ[i] EQ 'CONV_ENERGY'	THEN offset_conv_energy		= offset
		IF nom_champ[i] EQ 'RAW_ENERGY_PUP'	THEN offset_raw_energy_pup	= offset
		IF nom_champ[i] EQ 'CONV_ENERGY_PUP'	THEN offset_conv_energy_pup	= offset
		IF nom_champ[i] EQ 'RAW_ENERGY_LABR3'	THEN offset_raw_energy_labr3	= offset
		IF nom_champ[i] EQ 'CONV_ENERGY_LABR3'	THEN offset_conv_energy_labr3	= offset
		IF nom_champ[i] EQ 'RAW_ENERGY_PDOWN'	THEN offset_raw_energy_pdown	= offset
		IF nom_champ[i] EQ 'CONV_ENERGY_PDOWN'	THEN offset_conv_energy_pdown	= offset
		IF nom_champ[i] EQ 'SENSOR'		THEN offset_sensor		= offset
		IF nom_champ[i] EQ 'ORBIT_NUMBER'	THEN offset_orbit_number	= offset
		IF nom_champ[i] EQ 'EVENT_NUMBER'	THEN offset_event_number	= offset
		IF nom_champ[i] EQ 'ORBIT'		THEN offset_orbit		= offset
		CASE type_champ[i] OF
			 1:	offset += 1	; byte                            1 octet         unsigned char
			 2:	offset += 2	; entier                          2 octets        short
			 3:	offset += 4	; entier                          4 octets        int
			 4:	offset += 4	; float                           4 octets        float
			 5:	offset += 8	; double                          8 octets        double
			12:	offset += 2	; entier non signé                2 octets        unsigned short
			13:	offset += 4	; entier non signé                4 octets        unsigned int
		END
	END

	masque = param.version_masque
	http = get (general, 'use_local_or_nfs') EQ 'LOCAL_AND_HTTP'
	nfs = get (general, 'use_local_or_nfs') EQ 'LOCAL_AND_NFS'
	racine = param.racine
	http_racine = param.http_racine
	SC = 1
	taille = param.taille

	total_read_mbytes = 0.

	jour1 = date_to_nbjours (date1)
	jour2 = date_to_nbjours (date2)

	IF date2 LE date1 THEN BEGIN
		; date2 n'est pas supérieur à date1
		msg_erreur = 'End Time must be > Start Time'
		RETURN, -1
	END

	IF product EQ 'ORBIT' THEN BEGIN

		nbtemps = LONG64(86400) * (date_to_nbjours(date2) - date_to_nbjours(date1) + 1)
		IF nbtemps * 8. GT 1024. * 1024. * 1024. THEN BEGIN
			; courbeX utilisera plus de 1G de RAM
			msg_erreur = 'TOO MANY POINTS FOR ORBIT: PLEASE DECREASE TIME INTERVAL'
			RETURN, -1
		END

		date0 = nbjours_to_date (date_to_nbjours(date1))

		code_retour = 0

		courbeY		= REPLICATE (-1e31, nbtemps)
		courbeX		= date_to_nanoinday(date0,date1) + 1000000000LL * UL64INDGEN(nbtemps)

		nbenergies	= LONG(64) ; il faut bien mettre quelque chose
		spectreX	= REPLICATE (-1e31, nbenergies)
		spectreY	= REPLICATE (-1e31, nbenergies)

		FOR jour=jour1,jour2 DO BEGIN

			date = jour * 86400000d
			date_to_tu, date, ann, moi, jou, heu, min, sec
			YEAR = int_str_0(ann,4)
			MONTH = int_str_0(moi,2)
			DAY = int_str_0(jou,2)
			YYYYMMDD = YEAR + MONTH + DAY
			DOY = int_str_0(year_month_day_to_doy(YEAR,MONTH,DAY),3)
		
			; Déterminer filename
			code = chercher_dernier_fichier (general, http, nfs, racine, http_racine, masque, LONG(SC), YYYYMMDD, YEAR, MONTH, DAY, DOY, '', '', '', filename)
			IF code EQ 0 THEN CONTINUE ; pas de fichier

			; Déterminer no1 et no2
			lint_unused = get_filelengthc (filename, taille_fichier)
			nb = taille_fichier / taille
			lint_unused = ouvrir_lecture_ok (filename,fd)
			no1 = jour EQ jour1 ? dicho_file_sup_inf (0, 1, fd, 0, taille, enreg, nb, date1) : 0L
			no2 = jour EQ jour2 ? dicho_file_sup_inf (0, 2, fd, 0, taille, enreg, nb, date2) : nb - 1
			FREE_LUN, fd

			no1 = LONG(no1) ; pour éventuellement passer de LONG64 à LONG
			no2 = LONG(no2) ; pour éventuellement passer de LONG64 à LONG

			read_mbytes = (no2-no1+1)*taille/(1024.*1024.)
			PRINT, 'Reading ' + filename + ' (' + val_to_str_2decimales(read_mbytes) + ' Mbytes)'
			total_read_mbytes += read_mbytes

			; peut retourner 1, -1, -2
			IF is_fdl() THEN BEGIN
				code_retour = CALL_EXTERNAL (libname('file'), 'TARANIS_GET_DATA_ORBIT_AUTO_GLUE',		$
								filename, taille, no1, no2-no1+1,			$
								offset_date, offset_orbit,				$
								date0, courbeY, /AUTO_GLUE)
			END ELSE BEGIN
				code_retour = CALL_EXTERNAL (libname('file'), 'TARANIS_GET_DATA_ORBIT',		$
								filename, taille, no1, no2-no1+1,		$
								offset_date, offset_orbit,			$
								date0, courbeY)
			END
			
			IF code_retour NE 1 THEN BEGIN
				CASE code_retour OF
					-1: msg_erreur = 'CANNOT OPEN ' + filename
					-2: msg_erreur = 'CANNOT READ ' + filename
				END
				RETURN, code_retour
			END

		END

		; Ne garder que le premier et le dernier point de chaque orbite
		ind1 = WHERE (courbeY GT -1e30)
		IF ind1[0] NE -1 THEN BEGIN
			ind2 = UNIQ (courbeY[ind1])
			uniq = courbeY[ind1[ind2]]
			FOR i=0L, N_ELEMENTS(uniq)-1 DO BEGIN
				ind = WHERE (courbeY[ind1] EQ uniq[i])
				IF N_ELEMENTS(ind) GE 3 THEN courbeY[ind1[ind[1]]:ind1[ind[N_ELEMENTS(ind)-2]]] = -1
			END

			; Supprimer les points avec -1
			ind = WHERE (courbeY NE -1)
			IF ind[0] NE -1 THEN BEGIN
				courbeX = courbeX[ind]
				courbeY = courbeY[ind]
			END

		END

	END ELSE BEGIN

		event_dt_nanosec = LONG64 (event_dt * 1000000000)
		nanodate1 = date_to_nanodate (date1)
		nanodate2 = date_to_nanodate (date2)
		nbtemps = (nanodate2-nanodate1) / event_dt_nanosec
		IF nbtemps EQ 0 THEN nbtemps = 1LL ; sinon REPLICATE (-1e31,nbtemps) va planter

		TAILLE_MAX = 1024. * 1024. * 1024.	
		event_dt_min = 8 * (date2-date1) / (TAILLE_MAX * 1000d)
		IF nbtemps * 8. GT 1024. * 1024. * 1024. THEN BEGIN
			; courbeX utilisera plus de 1G de RAM
			msg_erreur = 'TOO MANY POINTS: PLEASE INCREASE DT (' + val_to_str(event_dt_min) + ' SEC MIN)'
			RETURN, -1
		END

		code_retour = 0

		event_dt_millisec = 0.000001d * event_dt_nanosec

		courbeY = REPLICATE (-1e31, nbtemps)
		courbeX = date_to_nanoinday(date1,date1) + event_dt_nanosec / 2 + event_dt_nanosec * UL64INDGEN(nbtemps)

		is_xgre = experiment EQ 'TARANIS_XGRE'

		IF is_xgre THEN BEGIN
			; Si on utilise un seul plan: on utilise les énergies exactes des particules
			; Si on utilise plusieurs plans: (Choix de Blelly du 18/02/2020) une table de 1024 valeurs entre 200000 et 30000000 eV
			nbenergies = LONG (1024)
			emin =   200000.
			emax = 30000000.
		END ELSE BEGIN
			nbenergies = LONG(64) * 4 ; LE + HE + LE/LEHE + HE/LEHE
		END

		IF FLOAT(nbenergies) * FLOAT(nbtables) * 4. GT 1024. * 1024. * 1024. THEN BEGIN ; FLOAT sinon nbenergies * nbtables peut ne pas rentrer dans un LONG
			; spectreX utilisera plus de 1G de RAM
			msg_erreur = 'TOO MANY ENERGY TABLES: PLEASE DECREASE THIS VALUE (' + val_to_str(nbtables) + ')'
			RETURN, -1
		END

		; Pour les spectres on va essayer avec nbtables * nbenergies points en abscisse
		spectreX	= REPLICATE (-1e31, nbenergies * nbtables)
		spectreY	= REPLICATE (-1e31, nbenergies * nbtables)

		output_ascii = LONG(ascii)
		filename_ascii = STRLOWCASE ('obj' + val_to_str(self.no) + '_' + experiment + '_' + product + '.txt') + '.gz'
		IF output_ascii THEN BEGIN
			lint_unused = detruire (filename_ascii)
			OPENW, fd_ascii, filename_ascii, /GET_LUN, COMPRESS=get_extension(filename_ascii) EQ 'gz'
			IF is_xgre THEN BEGIN
				PRINTF, fd_ascii, '#YYYY MM DD HH MM SS.SSSSSSSSS SENSOR RAW_ENERGY_PUP CONV_ENERGY_PUP RAW_ENERGY_LABR3 CONV_ENERGY_LABR3 RAW_ENERGY_PDOWN CONV_ENERGY_PDOWN ORBIT_NUMBER EVENT_NUMBER'
			END ELSE BEGIN
				PRINTF, fd_ascii, '#YYYY MM DD HH MM SS.SSSSSSSSS TYPE SENSOR RAW_ENERGY CONV_ENERGY ORBIT_NUMBER EVENT_NUMBER'
			END
			FREE_LUN, fd_ascii
		END

		FOR jour=jour1,jour2 DO BEGIN

			date = jour * 86400000d
			date_to_tu, date, ann, moi, jou, heu, min, sec
			YEAR = int_str_0(ann,4)
			MONTH = int_str_0(moi,2)
			DAY = int_str_0(jou,2)
			YYYYMMDD = YEAR + MONTH + DAY
			DOY = int_str_0(year_month_day_to_doy(YEAR,MONTH,DAY),3)
		
			; Déterminer filename
			code = chercher_dernier_fichier (general, http, nfs, racine, http_racine, masque, LONG(SC), YYYYMMDD, YEAR, MONTH, DAY, DOY, '', '', '', filename)
			IF code EQ 0 THEN CONTINUE ; pas de fichier

			; Déterminer no1 et no2
			lint_unused = get_filelengthc (filename, taille_fichier)
			nb = taille_fichier / taille
			lint_unused = ouvrir_lecture_ok (filename,fd)
			no1 = jour EQ jour1 ? dicho_file_sup_inf (0, 1, fd, 0, taille, enreg, nb, date1) : 0L
			no2 = jour EQ jour2 ? dicho_file_sup_inf (0, 2, fd, 0, taille, enreg, nb, date2) : nb - 1
			FREE_LUN, fd

			no1 = LONG(no1) ; pour éventuellement passer de LONG64 à LONG
			no2 = LONG(no2) ; pour éventuellement passer de LONG64 à LONG

			read_mbytes = (no2-no1+1)*taille/(1024.*1024.)
			PRINT, 'Reading ' + filename + ' (' + val_to_str_2decimales(read_mbytes) + ' Mbytes)'
			total_read_mbytes += read_mbytes

			correction1 = get_correction_date (date1)
			correction2 = get_correction_date (date2)
			IF is_xgre THEN BEGIN
				; peut retouner 1, -1, -2, -3
				IF is_fdl() THEN BEGIN
					code_retour = CALL_EXTERNAL (libname('file'), 'TARANIS_XGRE_GET_DATA_EVENT_AUTO_GLUE',							$
									filename, taille, no1, no2-no1+1,									$
									offset_date, offset_correction, offset_sensor,								$
									offset_raw_energy_pup, offset_conv_energy_pup,								$
									offset_raw_energy_labr3, offset_conv_energy_labr3,							$
									offset_raw_energy_pdown, offset_conv_energy_pdown,							$				
									offset_orbit_number, offset_event_number,								$
									nbtemps, nbenergies, nbtables, emin, emax, spectreX, spectreY, courbeY,					$
									tab_event_sensor, tab_event_plane, LONG(event_emin), LONG(event_emax), 					$
									date1, correction1, date2, correction2, event_dt_millisec, use_raw_energy, output_ascii, filename_ascii, /AUTO_GLUE)
				END ELSE BEGIN
					code_retour = CALL_EXTERNAL (libname('file'), 'TARANIS_XGRE_GET_DATA_EVENT',								$
									filename, taille, no1, no2-no1+1,									$
									offset_date, offset_correction, offset_sensor,								$
									offset_raw_energy_pup, offset_conv_energy_pup,								$
									offset_raw_energy_labr3, offset_conv_energy_labr3,							$
									offset_raw_energy_pdown, offset_conv_energy_pdown,							$				
									offset_orbit_number, offset_event_number,								$
									nbtemps, nbenergies, nbtables, emin, emax, spectreX, spectreY, courbeY,					$
									tab_event_sensor, tab_event_plane, LONG(event_emin), LONG(event_emax), 					$
									date1, correction1, date2, correction2, event_dt_millisec, use_raw_energy, output_ascii, filename_ascii)
				END
			END ELSE BEGIN
				; peut retouner 1, -1, -2, -3
				IF is_fdl() THEN BEGIN
					code_retour = CALL_EXTERNAL (libname('file'), 'TARANIS_IDEE_GET_DATA_EVENT_AUTO_GLUE',							$
									filename, taille, no1, no2-no1+1,									$
									offset_date, offset_correction, offset_type, offset_sensor, 						$
									offset_raw_energy, offset_conv_energy,									$
									offset_orbit_number, offset_event_number,								$
									nbtemps, nbenergies, nbtables, spectreX, spectreY, courbeY,						$
									tab_event_type, tab_event_sensor, LONG(event_emin), LONG(event_emax), 					$
									date1, correction1, date2, correction2, event_dt_millisec, use_raw_energy, output_ascii, filename_ascii, /AUTO_GLUE)
				END ELSE BEGIN
					code_retour = CALL_EXTERNAL (libname('file'), 'TARANIS_IDEE_GET_DATA_EVENT',								$
									filename, taille, no1, no2-no1+1,									$
									offset_date, offset_correction, offset_type, offset_sensor, 						$
									offset_raw_energy, offset_conv_energy,									$
									offset_orbit_number, offset_event_number,								$
									nbtemps, nbenergies, nbtables, spectreX, spectreY, courbeY,						$
									tab_event_type, tab_event_sensor, LONG(event_emin), LONG(event_emax), 					$
									date1, correction1, date2, correction2, event_dt_millisec, use_raw_energy, output_ascii, filename_ascii)
				END
			END

			IF code_retour NE 1 THEN BEGIN
				CASE code_retour OF
					-1: msg_erreur = 'CANNOT OPEN ' + filename
					-2: msg_erreur = 'CANNOT READ ' + filename
					-3: msg_erreur = 'TOO MANY ENERGY TABLES: PLEASE INCREASE THIS VALUE (' + val_to_str(nbtables) + ')'
				END
				RETURN, -1
			END


		END

		; Réduction de spectreX et spectreY
		ind = WHERE (spectreX NE -1e31)
		IF ind[0] NE -1 THEN BEGIN
			spectreX = spectreX[ind]
			spectreY = spectreY[ind]
			; Trier par énergies croissantes
			trie = SORT (spectreX)
			spectreX = spectreX[trie]
			spectreY = spectreY[trie]
		END

		IF ascii THEN PRINT, filename_ascii + ' has been created'

	END

	top2 = nbsec()
	PRINT, 'tev_get_data ' + val_to_str(total_read_mbytes) + ' Mbytes in ' + val_to_str_2decimales(top2-top1) + ' sec'

	RETURN, code_retour

END

;-----------------------------------------------------------------------------
PRO tev::compute
;-------------------------------------------------------------------------------
; Calcule puis visualise les données tev.
;-------------------------------------------------------------------------------

	fenetre = self.fenetre

	hash_general = self.general -> gethash()

	ntrace = getq (self.general, hash_general.ntrace)
	IF ntrace GE 1 THEN BEGIN
		msg = self -> name()
		str = STRING(msg, FORMAT='(A)')
		cl_msg, self.general, str_bas=" "
		cl_msg, self.general, str_bas=str
	END

	ascii = getq (self.general, hash_general.ascii)

	x1 = 0.0
	x2 = 1.0

	; colors to be used
	black_rvb	= { var_pal, r:0,   v:0, b:  0 } & black = 0
	blue_rvb	= { var_pal, r:  0, v:0, b:255 } & blue  = 1
	rvb = [black_rvb, blue_rvb]
	color = blue

	; Colors translation
	trans = INDGEN(N_ELEMENTS(rvb))

	; give rvb to fenetre
	fenetre -> fsetproperty,rvb,/rvb

	date1				= str_to_date(get(self,'time_t1'))
	date2				= str_to_date(get(self,'time_t2'))

	event_dt			= get(self,'event_dt')
	method				= get(self,'method')
	time_selection			= get(self,'time_selection')
	experiment_product_time_orbit	= get(self,'experiment_product_time_orbit')
	nbtables_idee			= LONG(get(self,'nbtables_idee'))
	nbtables_xgre			= LONG(get(self,'nbtables_xgre'))
	charsize			= get(self,'charsize')
	legend_charsize			= get(self,'legend_charsize')

	IF method EQ 'Simple' THEN BEGIN
		xlog_energy_simple		= get(self,'xlog_energy_simple')
		ylog_count_simple		= get(self,'ylog_count_simple')
		experiment_product_simple	= get(self,'experiment_product_simple')
		event_type_idee			= get(self,'event_type_idee')
		event_sensor_idee		= get(self,'event_sensor_idee')
		event_emin_idee			= get(self,'event_emin_idee')
		event_emax_idee			= get(self,'event_emax_idee')
		event_emin_xgre_pup		= get(self,'event_emin_xgre_pup')
		event_emax_xgre_pup		= get(self,'event_emax_xgre_pup')
		event_emin_xgre_labr3		= get(self,'event_emin_xgre_labr3')
		event_emax_xgre_labr3		= get(self,'event_emax_xgre_labr3')
		event_emin_xgre_pdown		= get(self,'event_emin_xgre_pdown')
		event_emax_xgre_pdown		= get(self,'event_emax_xgre_pdown')
		event_sensor_xgre		= get(self,'event_sensor_xgre')
		event_plane_xgre		= get(self,'event_plane_xgre')
		visu_top			= get(self,'visu_top')
		energy				= get(self,'energy')
	END


	IF method EQ 'Expert' THEN BEGIN
		plot				= get(self,'plot')
		nbplots				= N_ELEMENTS(plot)
		visu_nochamp			= get(self,'visu_nochamp')
		xlog_energy_nochamp		= get(self,'xlog_energy_nochamp')
		ylog_count_nochamp		= get(self,'ylog_count_nochamp')
		experiment_product_nochamp	= get(self,'experiment_product_nochamp')
		event_emin_idee_nochamp		= get(self,'event_emin_idee_nochamp')
		event_emax_idee_nochamp		= get(self,'event_emax_idee_nochamp')
		event_sensor_idee_nochamp	= get(self,'event_sensor_idee_nochamp')
		event_type_idee_nochamp		= get(self,'event_type_idee_nochamp')
		event_sensor_xgre_nochamp	= get(self,'event_sensor_xgre_nochamp')
		event_plane_xgre_nochamp	= get(self,'event_plane_xgre_nochamp')
		event_emin_xgre_pup_nochamp	= get(self,'event_emin_xgre_pup_nochamp')
		event_emax_xgre_pup_nochamp	= get(self,'event_emax_xgre_pup_nochamp')
		event_emin_xgre_labr3_nochamp	= get(self,'event_emin_xgre_labr3_nochamp')
		event_emax_xgre_labr3_nochamp	= get(self,'event_emax_xgre_labr3_nochamp')
		event_emin_xgre_pdown_nochamp	= get(self,'event_emin_xgre_pdown_nochamp')
		event_emax_xgre_pdown_nochamp	= get(self,'event_emax_xgre_pdown_nochamp')
		energy_nochamp			= get(self,'energy_nochamp')
	END


	tmp = STRSPLIT (experiment_product_time_orbit, '_', /EXTRACT)
	experiment = tmp[0]
	product = tmp[1]

	fenetre = self.fenetre
	device = get (self.general, 'device')
	self -> get_x0x1x2x3, fenetre, device, x0, x1, x2, x3

	titre_orbite1 = ''
	titre_orbite2 = ''

	filename = '/DATA/TARANIS/DATA/CL/LIST/TAR_' + experiment + '_' + product + '_LIST.x86'
	taille = 22L ; taille d'un enregistrement dans le fichier LIST
	lint_unused = get_filelengthc (filename, taille_fichier)
	;IF code_filelengthc EQ -1 THEN RETURN
	nb = taille_fichier / taille
	enreg = { orbit:0L, event_number:0, date1:0d, date2:0d }

	lint_unused = get_structure_infos (enreg, taille_enreg, nbchamps, nom_champ, type_champ, offset_champ, taille_champ, nb_champ)
	offset = 0L
	FOR i=0L,nbchamps-1 DO BEGIN
		IF nom_champ[i] EQ 'DATE1'		THEN offset_date1		= offset
		IF nom_champ[i] EQ 'ORBIT'		THEN offset_orbit		= offset
		CASE type_champ[i] OF
			 1:	offset += 1	; byte                            1 octet         unsigned char
			 2:	offset += 2	; entier                          2 octets        short
			 3:	offset += 4	; entier                          4 octets        int
			 4:	offset += 4	; float                           4 octets        float
			 5:	offset += 8	; double                          8 octets        double
			12:	offset += 2	; entier non signé                2 octets        unsigned short
			13:	offset += 4	; entier non signé                4 octets        unsigned int
		END
	END

	IF time_selection EQ 'Orbit number' THEN BEGIN

		orbit1	= get(self,'orbit1')
		orbit2	= get(self,'orbit2')

		IF is_number(orbit1) EQ 0 THEN orbit1 = '-1'
		IF is_number(orbit2) EQ 0 THEN orbit2 = '-1'

		top1 = nbsec()
		ind1 = self -> search_list_orbit (filename, offset_orbit, taille, nb, orbit1)
		ind2 = self -> search_list_orbit (filename, offset_orbit, taille, nb, orbit2)
		OPENR, fd, filename, /GET_LUN
		IF ind1[0] NE -1 THEN BEGIN
			infos1 = REPLICATE (enreg, N_ELEMENTS(ind1))
			positionner, fd, 0, taille, ind1[0]
			READU, fd, infos1
		END
		IF ind2[0] NE -1 THEN BEGIN
			infos2 = REPLICATE (enreg, N_ELEMENTS(ind2))
			positionner, fd, 0, taille, ind2[0]
			READU, fd, infos2
		END
		FREE_LUN, fd
		top2 = nbsec()
		PRINT, '*** ' + filename + ': in ' + val_to_str(top2-top1) + ' sec ***'
		PRINT

		IF ind1[0] NE -1 THEN BEGIN
			titre_orbite1 = orbit1

			event_number1 = get(self,'event_number1')
			IF is_number(event_number1) && event_number1 GE 1 && event_number1 LE N_ELEMENTS(infos1) THEN BEGIN
				; event_number1 est valide car entre 1 et N_ELEMENTS(infos1)
			END ELSE BEGIN
				; event_number1 n'est pas valide: on le fixe à 1
				event_number1 = val_to_str(1)
			END
			date1 = infos1[event_number1-1].date1
			titre_orbite1 += '(' + event_number1 + '/' + val_to_str(N_ELEMENTS(infos1)) + ')'
			IF ind2[0] EQ -1 THEN BEGIN
				date2 = infos1[event_number1-1].date2
				titre_orbite2  = orbit1
				titre_orbite2 += '(' + event_number1 + '/' + val_to_str(N_ELEMENTS(infos1)) + ')'
			END ELSE BEGIN
				event_number2 = get(self,'event_number2')
				IF is_number(event_number2) && event_number2 GE 1 && event_number2 LE N_ELEMENTS(infos2) THEN BEGIN
					; event_number2 est valide car entre 1 et N_ELEMENTS(infos2)
				END ELSE BEGIN
					; event_number2 n'est pas valide: on le fixe à N_ELEMENTS(infos2)
					event_number2 = val_to_str(N_ELEMENTS(infos2))
				END
				date2 = infos2[event_number2-1].date2
				titre_orbite2  = orbit2
				titre_orbite2 += '(' + event_number2 + '/' + val_to_str(N_ELEMENTS(infos2)) + ')'
			END
		END ELSE BEGIN
			titre_orbite1 = '?(?/?)'
			titre_orbite2 = '?(?/?)'
			date1 = tu_to_date (2020,1,1,0,0,0)
			date2 = tu_to_date (2020,1,2,0,0,0)
		END

		general = self.general
		graphics = get (general, 'graphics')
		code = graphics -> gettab (tab, nb, tabcontainer, taborder, tabno)
		IF code EQ 0 THEN BEGIN
			ind = WHERE (tabno EQ self.container)
			IF ind[0] NE -1 THEN BEGIN
				obj_container = tab[ind[0]].obj
				set, obj_container, 'time_t1', date_to_str(date1, FORMAT=1)
				set, obj_container, 'time_t2', date_to_str(date2, FORMAT=1)
			END
			set, self, 'time_t1', date_to_str(date1, FORMAT=1)
			set, self, 'time_t2', date_to_str(date2, FORMAT=1)
		END

	END ELSE BEGIN

		afficher = 0
		IF afficher THEN BEGIN
			; Affiche le contenu du fichier LIST
			OPENR, fd, filename, /GET_LUN
			positionner, fd, 0, taille,0
			all = REPLICATE (enreg, nb)
			READU, fd, all
			FOR i=0L,nb-1 DO BEGIN
				PRINT, basename(filename) + ' ' + val_to_str(all[i].orbit) + ' ' + STRING(all[i].event_number,FORMAT='(I3)') + ' ' + date_to_str(all[i].date1,FORMAT=9) + ' ' + date_to_str(all[i].date2,FORMAT=9)
			END
			FREE_LUN, fd
		END

		top1 = nbsec()
		no1 = self -> search_list_date1 (filename, offset_date1, taille, nb, date1)
		no2 = self -> search_list_date1 (filename, offset_date1, taille, nb, date2)

		OPENR, fd, filename, /GET_LUN
		IF no1 NE -1 THEN BEGIN
			positionner, fd, 0, taille, no1
			READU, fd, enreg
			IF enreg.date2 LT date1 AND no1+1 LT nb THEN BEGIN
				no1++
				positionner, fd, 0, taille, no1
				READU, fd, enreg
			END
			orbit1 = enreg.orbit
		END

		IF no2 NE -1 THEN BEGIN
			positionner, fd, 0, taille, no2
			READU, fd, enreg
			orbit2 = enreg.orbit
		END
		FREE_LUN, fd

		IF no1 NE -1 THEN ind1 = self -> search_list_orbit (filename, offset_orbit, taille, nb, orbit1)
		IF no2 NE -1 THEN ind2 = self -> search_list_orbit (filename, offset_orbit, taille, nb, orbit2)

		OPENR, fd, filename, /GET_LUN
		IF no1 EQ -1 THEN BEGIN
			titre_orbite1 = '?(?/?)'
		END ELSE IF ind1[0] NE -1 THEN BEGIN
			infos1 = REPLICATE (enreg, N_ELEMENTS(ind1))
			positionner, fd, 0, taille, ind1[0]
			READU, fd, infos1
			event_number1 = 1 + (WHERE (ind1 EQ no1))[0]
			titre_orbite1 = val_to_str(orbit1) + '(' + val_to_str(event_number1) + '/' + val_to_str(N_ELEMENTS(infos1)) + ')'
			set, self, 'orbit1', val_to_str(orbit1)
			set, self, 'event_number1', val_to_str(event_number1)
		END ELSE BEGIN
			titre_orbite1 = val_to_str(orbit1) + '(?/?)'
		END
		IF no2 EQ -1 THEN BEGIN
			titre_orbite2 = '?(?/?)'
		END ELSE IF ind2[0] NE -1 THEN BEGIN
			infos2 = REPLICATE (enreg, N_ELEMENTS(ind2))
			positionner, fd, 0, taille, ind2[0]
			READU, fd, infos2
			event_number2 = 1 + (WHERE (ind2 EQ no2))[0]
			titre_orbite2 = val_to_str(orbit2) + '(' + val_to_str(event_number2) + '/' + val_to_str(N_ELEMENTS(infos2)) + ')'
			set, self, 'orbit2', val_to_str(orbit2)
			set, self, 'event_number2', val_to_str(event_number2)
		END ELSE BEGIN
			titre_orbite2 = val_to_str(orbit2) + '(?/?)'
		END
		FREE_LUN, fd
		top2 = nbsec()
		PRINT, '*** ' + filename + ': in ' + val_to_str(top2-top1) + ' sec ***'
		PRINT
	END

	; -----
	; Titre
	; -----
	titre = 'TARANIS'
	titre += ' (dt=' + val_to_str(event_dt,/opt)+'s)'
	angle = 0.0
	thick = 1.0
	fenetre -> ajouter_texte, (x1+x2)/2, 0.95, titre, 0.5, charsize, trans[black], angle, thick

	tmp = date_to_str(date1,FORMAT=9)
	titre_gauche1 = STRMID(tmp,0,10)
	titre_gauche2 = STRMID(tmp,11,15)
	fenetre -> ajouter_texte, x1, 0.88, titre_gauche1, 0.5, charsize, trans[black], angle, thick
	fenetre -> ajouter_texte, x1, 0.85, titre_gauche2, 0.5, charsize, trans[black], angle, thick

	IF time_selection EQ 'Orbit number' THEN BEGIN
		titre_centre1 = titre_orbite1 + ' -> ' + experiment + ' ' + product + ': ' + date_to_str(date1,FORMAT=9)
		titre_centre2 = titre_orbite2 + ' -> ' + experiment + ' ' + product + ': ' + date_to_str(date2,FORMAT=9)
	END ELSE BEGIN
		titre_centre1 = date_to_str(date1,FORMAT=9) + ' -> ' + experiment + ' ' + product + ': ' + titre_orbite1
		titre_centre2 = date_to_str(date2,FORMAT=9) + ' -> ' + experiment + ' ' + product + ': ' + titre_orbite2
	END
	fenetre -> ajouter_texte, (x1+x2)/2, 0.88, titre_centre1, 0.5, charsize, trans[black], angle, thick
	fenetre -> ajouter_texte, (x1+x2)/2, 0.85, titre_centre2, 0.5, charsize, trans[black], angle, thick

	tmp = date_to_str(date2,FORMAT=9)
	titre_droite1 = STRMID(tmp,0,10)
	titre_droite2 = STRMID(tmp,11,15)
	fenetre -> ajouter_texte, x2, 0.88, titre_droite1, 0.5, charsize, trans[black], angle, thick
	fenetre -> ajouter_texte, x2, 0.85, titre_droite2, 0.5, charsize, trans[black], angle, thick

	; courbes de lumière de visu_top, s'il y en a
	; puis courbe de lumière
	; puis spectre

	IF method EQ 'Simple' THEN BEGIN
		nbrequettes = visu_top[0] EQ 'null' OR visu_top[0] EQ '' ? 0 : N_ELEMENTS(visu_top) ; 'null' dans cl et '' dans clweb
		nbrequettes++										; requette pour 'Curve and spectrum (bottom)'
		nbcurves = nbrequettes + 1
	END ELSE BEGIN
		nbrequettes = nbplots
		nbcurves = nbplots
	END

	FOR i=0L,nbrequettes-1 DO BEGIN

		IF method EQ 'Simple' THEN BEGIN

			experiment_product = i EQ nbrequettes-1 ? experiment_product_simple: visu_top[i]
			tmp = STRSPLIT (experiment_product, '_', /EXTRACT)
			experiment = tmp[0]
			product = tmp[1]

			IF experiment EQ 'XGRE' THEN BEGIN

				event_sensor = event_sensor_xgre
				event_plane = event_plane_xgre
				event_emin = [ event_emin_xgre_pup, event_emin_xgre_labr3, event_emin_xgre_pdown ]
				event_emax = [ event_emax_xgre_pup, event_emax_xgre_labr3, event_emax_xgre_pdown ]

			END ELSE BEGIN

				event_sensor = event_sensor_idee
				event_type = event_type_idee
				event_emin = event_emin_idee
				event_emax = event_emax_idee

			END
			visu = 'curve'
			use_raw_energy = energy EQ 'Raw' ? 1L : 0L
			xlog_energy = xlog_energy_simple EQ 'Log' ? 1 : 0
			ylog_count = ylog_count_simple EQ 'Log' ? 1 : 0

		END ELSE IF method EQ 'Expert' THEN BEGIN

			experiment_product = *(experiment_product_nochamp[plot[i]-1])
			tmp = STRSPLIT (experiment_product, '_', /EXTRACT)
			experiment = tmp[0]
			product = tmp[1]

			IF experiment EQ 'XGRE' THEN BEGIN

				event_sensor = *(event_sensor_xgre_nochamp[plot[i]-1])
				event_plane = *(event_plane_xgre_nochamp[plot[i]-1])
				event_emin = [	*(event_emin_xgre_pup_nochamp[plot[i]-1]),	$
						*(event_emin_xgre_labr3_nochamp[plot[i]-1]), 	$
						*(event_emin_xgre_pdown_nochamp[plot[i]-1])	]
				event_emax = [	*(event_emax_xgre_pup_nochamp[plot[i]-1]),	$
						*(event_emax_xgre_labr3_nochamp[plot[i]-1]),	$
						*(event_emax_xgre_pdown_nochamp[plot[i]-1])	]

			END ELSE BEGIN

				event_sensor = *(event_sensor_idee_nochamp[plot[i]-1])
				event_type = *(event_type_idee_nochamp[plot[i]-1])
				event_emin = *(event_emin_idee_nochamp[plot[i]-1])
				event_emax = *(event_emax_idee_nochamp[plot[i]-1])
			END

			visu = *(visu_nochamp[plot[i]-1])
			use_raw_energy = *(energy_nochamp[plot[i]-1]) EQ 'Raw' ? 1L : 0L
			xlog_energy = *(xlog_energy_nochamp[plot[i]-1]) EQ 'Log' ? 1 : 0
			ylog_count = *(ylog_count_nochamp[plot[i]-1]) EQ 'Log' ? 1 : 0
		END

		IF experiment EQ 'XGRE' THEN BEGIN

			tab_event_sensor = self -> val_to_tab (event_sensor, 4)
			tab_event_plane = self -> val_to_tab (event_plane, 3)
			nbtables = nbtables_xgre

		END ELSE BEGIN

			tab_event_sensor = self -> val_to_tab (event_sensor, 8)
			tab_event_type = self -> val_to_tab (event_type, 4)
			nbtables = nbtables_idee

		END


		code_data = self -> tev_get_data (date1, date2, tab_event_type, tab_event_sensor, event_emin, event_emax, event_dt, tab_event_plane, 'TARANIS_'+experiment, product, ascii, nbtables, spectreX, spectreY, courbeX, courbeY, use_raw_energy, msg_erreur)

		y2 = 0.8 - i * (0.8-0.1)/nbcurves
		y1 = y2 - (0.8-0.1)/nbcurves*0.75


		IF visu EQ 'curve' THEN BEGIN

			; ------------------------------------------------
			; Courbe de lumière ou ORBIT: en fonction du temps
			; ------------------------------------------------

			nopanel = i+1
			filename_ascii = 'obj' + val_to_str(self.no) + '_Panel' + int_str_0(nopanel,2) + '.txt'
			IF ascii THEN BEGIN
				OPENW, fd_ascii, filename_ascii, /GET_LUN
				PRINTF, fd_ascii, '#YYYY MM DD HH MM SS.SSSSSSSSS ' + (product EQ 'ORBIT' ? 'ORBIT' : 'COUNT')
				FREE_LUN, fd_ascii
			END

			ymin		= -1.0
			ymax		= 1.0

			psym1		= 4
			psym2		= -4
			ylog		= product EQ 'ORBIT' ? 0 : ylog_count
			symbolsize	= 1.0
			style		= 0
			xlog		= 0
			xmin		= date_to_nanoinday(date1,date1)
			xmax		= date_to_nanoinday(date2,date1)

			code_courbe = code_data
			IF code_courbe EQ 1 THEN BEGIN
				; Que des -1e31 ?
				ind = WHERE (courbeY NE -1e31)
				IF ind[0] EQ -1 THEN BEGIN
					msg_erreur = 'NO DATA'
					code_courbe = 0
				END
			END

			IF code_courbe NE 1 THEN BEGIN

				fenetre -> ajouter_texte, (x1+x2)/2, (y1+y2)/2, msg_erreur, 0.5, charsize, trans[color], angle, thick

			END ELSE BEGIN

				; Détermination de ymin et ymax en n'utilisant que les parties visibles du plot
				; Utile surtout pour l'orbite
				; Mais si on a juste 2 points, un point avant (invisible) et un point aprés (invisible): ca ne marche pas

				debut = 0L
				no1 = 0L
				no2 = 0L
				ymin = 1e31
				ymax = -1e31

				ok = 0
				WHILE 1 DO BEGIN

					IF is_fdl() THEN BEGIN
						lint_unused = CALL_EXTERNAL (libname('util'), 'CHERCHER_NONFILLVAL_AUTO_GLUE', courbeY, N_ELEMENTS(courbeY), debut, no1, no2, /AUTO_GLUE)
					END ELSE BEGIN
						lint_unused = CALL_EXTERNAL (libname('util'), 'CHERCHER_NONFILLVAL', courbeY, N_ELEMENTS(courbeY), debut, no1, no2)
					END
					IF no1 EQ -1 THEN BREAK

					; Y a t-il dans courbeX[no1:no2] au moins un point visible dans l'intervalle [xmin,xmax] ?
					X = courbeX[no1:no2]
					ind = WHERE (X GE xmin AND X LE xmax)
					IF ind[0] NE -1 THEN BEGIN
						Y = courbeY[no1:no2]
						min = MIN (Y, MAX=max)
						IF min LT ymin THEN ymin = min
						IF max GT ymax THEN ymax = max
						ok = 1
					END

					debut = no2+1

				END

				IF ok EQ 1 THEN BEGIN

					corriger_min_max, ymin, ymax, ylog

				END ELSE BEGIN

					; Détermination classique de ymin et ymax 
					ind = WHERE (courbeY GT -1e30)
					IF ind[0] NE -1 THEN BEGIN
						Y = courbeY[ind]
						ymin = MIN(Y, MAX=ymax)
						corriger_min_max, ymin, ymax, ylog
					END

				END

				debut = 0L
				no1 = 0L
				no2 = 0L

				WHILE 1 DO BEGIN

					IF is_fdl() THEN BEGIN
						lint_unused = CALL_EXTERNAL (libname('util'), 'CHERCHER_NONFILLVAL_AUTO_GLUE', courbeY, N_ELEMENTS(courbeY), debut, no1, no2, /AUTO_GLUE)
					END ELSE BEGIN
						lint_unused = CALL_EXTERNAL (libname('util'), 'CHERCHER_NONFILLVAL', courbeY, N_ELEMENTS(courbeY), debut, no1, no2)
					END
					IF no1 EQ -1 THEN BREAK

					X = courbeX[no1:no2]
					Y = courbeY[no1:no2]

					IF ascii THEN BEGIN
						nanodate = X + 86400000000000LL * date_to_nbjours(date1)
						IF is_fdl() THEN BEGIN
							lint_unused = CALL_EXTERNAL (libname('file'), 'TARANIS_ASCII_OUTPUT_TIME_Y_AUTO_GLUE',	$
										N_ELEMENTS(nanodate), nanodate, Y, filename_ascii, /AUTO_GLUE)
						END ELSE BEGIN
							lint_unused = CALL_EXTERNAL (libname('file'), 'TARANIS_ASCII_OUTPUT_TIME_Y',	$
										N_ELEMENTS(nanodate), nanodate, Y, filename_ascii)
						END
					END

					fenetre -> ajouter_courbe,							$
							X, Y,								$
							trans[color], psym1, psym2, symbolsize,				$
							style, thick,							$
							xmin,xmax,xlog,ymin,ymax,ylog,x1,x2,y1,y2,nocourbe,		$
							/NO_COPY


					debut = no2+1

				END

			END

			IF ascii THEN PRINT, filename_ascii + ' has been created'

			; ------------
			; Axe du temps
			; ------------
			ta = date_to_nanoinday(date1,date1)
			tb = date_to_nanoinday(date2,date1)
			jd = date_to_jd(date1)
			time_format = ''
			xticklen	= 1.0
			xcharsize	= charsize
			xthick		= 1.0
			fenetre -> ajouter_timeaxis, ta, tb, x1,x2,y1,y2,0, xticklen,'!3',xcharsize,trans[black],time_format,jd,xthick

			; ------
			; Axes Y
			; ------
			x0		= 0.025
			y0		= (y1+y2)/2
			titre		= product EQ 'ORBIT' ? 'ORBIT' : 'COUNT'
			datatitle	= ''
			yangle		= 90.0
			yticklen	= -0.03
			ytickv		= ''
			yticks		= 0
			yminor		= 0
			ytickname	= ''
			ycharsize	= charsize
			ythick		= 1.0
			ytickformat	= product EQ 'ORBIT' ? '(F8.1)' : ''
			alignment	= 0.5
			no		= 3 ; axey à gauche et à droite du tracé
			fenetre -> ajouter_axey, xmin,xmax,ymin,ymax,x0,y0,x1,x2,y1,y2,				$
				titre,datatitle,yangle,yticklen,ylog,						$
				ytickv, yticks, yminor, no, ytickname, trans[black],				$
				ycharsize,ythick,ytickformat,alignment

			; ----------------
			; Légende à droite
			; ----------------
			legende = self -> get_legende (experiment, product, tab_event_sensor, tab_event_plane, event_emin, event_emax, tab_event_type)
			fenetre -> ajouter_texte, (x2+1)/2, (y1+y2)/2, legende, 0.5, legend_charsize, trans[color], 0, 1.0

		END

		IF method EQ 'Simple' THEN BEGIN
			; Rustine pour le dernier panneau en mode 'Simple'
			IF i EQ nbrequettes-1 THEN visu = 'spectrum'
		END

		IF visu EQ 'spectrum' THEN BEGIN

			IF method EQ 'Simple' THEN BEGIN
				y2 = 0.8 - (i+1) * (0.8-0.1)/nbcurves
				y1 = y2 - (0.8-0.1)/nbcurves * 0.75
			END

			; -------
			; Spectre
			; -------

			nopanel = method EQ 'Simple' ? i+2 : i+1

			filename_ascii = 'obj' + val_to_str(self.no) + '_Panel' + int_str_0(nopanel,2) + '.txt'
			IF ascii THEN BEGIN
				OPENW, fd_ascii, filename_ascii, /GET_LUN
				PRINTF, fd_ascii, '#' + (use_raw_energy ? 'RAW_ENERGY' : 'CONV_ENERGY') + ' COUNT'
				FREE_LUN, fd_ascii
			END

			code_spectre = code_data
			IF code_spectre EQ 1 THEN BEGIN

				TABX = spectreX
				TABY = spectreY
				; Supprimer les -1e31
				ind = WHERE (TABY NE -1e31)
				IF ind[0] NE -1 THEN BEGIN
					TABX = TABX[ind]
					TABY = TABY[ind]
				END ELSE BEGIN
					msg_erreur = 'NO DATA'
					code_spectre = 0
				END
				IF ylog_count THEN BEGIN
					; Supprimer les 0
					ind = WHERE (TABY GT 0)
					IF ind[0] NE -1 THEN BEGIN
						TABX = TABX[ind]
						TABY = TABY[ind]
					END ELSE BEGIN
						msg_erreur = 'NO DATA'
						code_spectre = 0
					END
				END

			END

			psym1		= 4
			psym2		= -4
			symbolsize	= 1.0
			style		= 0
			thick		= 1.0
			xmin		= code_spectre EQ 1 ? MIN(TABX) : 1.0
			xmax		= code_spectre EQ 1 ? MAX(TABX) : 2.0
			xlog		= xlog_energy
			ylog		= ylog_count
			ymin 		= code_spectre EQ 1 ? MIN(TABY) : 1.0
			ymax 		= code_spectre EQ 1 ? MAX(TABY) : 2.0
			nocourbe	= 0

			corriger_min_max, xmin, xmax, xlog
			corriger_min_max, ymin, ymax, ylog

			IF code_spectre NE 1 THEN BEGIN

				fenetre -> ajouter_texte, (x1+x2)/2, (y1+y2)/2, msg_erreur, 0.5, charsize, trans[color], angle, thick

			END ELSE BEGIN

				IF ascii THEN BEGIN
					IF is_fdl() THEN BEGIN
						lint_unused = CALL_EXTERNAL (libname('file'), 'TARANIS_ASCII_OUTPUT_X_Y_AUTO_GLUE',	$
								N_ELEMENTS(TABX), TABX, TABY, filename_ascii, /AUTO_GLUE)
					END ELSE BEGIN
						lint_unused = CALL_EXTERNAL (libname('file'), 'TARANIS_ASCII_OUTPUT_X_Y',	$
								N_ELEMENTS(TABX), TABX, TABY, filename_ascii)
					END
				END

				fenetre -> ajouter_courbe, 							$
						TABX, TABY,							$
						trans[color], psym1, psym2, symbolsize,				$
						style, thick,							$
						xmin,xmax,xlog,ymin,ymax,ylog,x1,x2,y1,y2,nocourbe,		$
						/NO_COPY


			END

			IF ascii THEN PRINT, filename_ascii + ' has been created'

			titre		= use_raw_energy ? 'Energy channel number' : 'Energy (eV)'
			xticklen	= 1.0
			xtickv		= ''
			xticks		= 0
			xminor		= 0
			xtickname	= ''
			xcharsize	= charsize
			xthick		= 1.0
			xtickformat	= ''
			fenetre -> ajouter_axex, xmin, xmax, ymin, ymax, x1, x2, y1, y2,titre,			$
				xticklen, xlog, xtickv, xticks, xminor, xtickname, trans[black],		$
				xcharsize, xthick, xtickformat

			x0		= 0.025
			y0		= (y1+y2)/2
			titre		= 'COUNT'
			datatitle	= ''
			yangle		= 90.0
			yticklen	= -0.03
			ytickv		= ''
			yticks		= 0
			yminor		= 0
			ytickname	= ''
			ycharsize	= charsize
			ythick		= 1.0
			ytickformat	= ''
			alignment	= 0.5
			no		= 3 ; axey à gauche et à droite du tracé
			fenetre -> ajouter_axey, xmin,xmax,ymin,ymax,x0,y0,x1,x2,y1,y2,				$
				titre,datatitle,yangle,yticklen,ylog,						$
				ytickv, yticks, yminor, no, ytickname, trans[black],				$
				ycharsize,ythick,ytickformat,alignment

			; ----------------
			; Légende à droite
			; ----------------
			legende = self -> get_legende (experiment, product, tab_event_sensor, tab_event_plane, event_emin, event_emax, tab_event_type)
			fenetre -> ajouter_texte, (x2+1)/2, (y1+y2)/2, legende, 0.5, legend_charsize, trans[color], 0, 1.0

		END

	END

END

;-------------------------------------------------------------------------------
FUNCTION tev::init,	$
;-------------------------------------------------------------------------------
	no,		$	; LINT_PROTOTYPE input
	container,	$	; LINT_PROTOTYPE input
	order,		$	; LINT_PROTOTYPE input
	general			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Constructeur de la classe "tev".
;-------------------------------------------------------------------------------

	create_products, 'TARANIS-IDEEN'	; obligatoire
	create_products, 'TARANIS-IDEEZ'	; obligatoire
	create_products, 'TARANIS-XGRE'		; obligatoire

	STRING_START_END	= 'Start / End'
	STRING_ORBIT_NUMBER	= 'Orbit number'
	LINEAR_LOG		= ['Linear','Log']

	LIST1 = 'IDEEN_'+ [ 'BKG','TEST','PARTICLE','RRE','LEP']
	LIST2 = 'IDEEZ_'+ [ 'BKG','TEST','PARTICLE','RRE','LEP']
	LIST3 = [ 'XGRE_XGA', 'XGRE_TGF', 'XGRE_GRB', 'XGRE_UNK' ]
	LIST = [ LIST1, LIST2, LIST3 ]

	nbmax = 64 ; nombre de courbes maxi
	txtcourbe = val_to_str(LINDGEN(nbmax)+1)

	visu_list = ['curve','spectrum']
	visu_nochamp = PTRARR(nbmax)
	FOR i=0L,N_ELEMENTS(visu_nochamp)-1 DO visu_nochamp[i] = allocfree (visu_nochamp[i],visu_list[0])

	LIST0 = 'EPHEMERIS_ORBIT'
	experiment_product_list = [ LIST0, LIST1, LIST2, LIST3 ]
	experiment_product_nochamp = PTRARR(nbmax)
	FOR i=0L,N_ELEMENTS(experiment_product_nochamp)-1 DO experiment_product_nochamp[i] = allocfree (experiment_product_nochamp[i],experiment_product_list[0])

	energy_list = ['Raw','Conv']
	energy_nochamp = PTRARR(nbmax)
	FOR i=0L,N_ELEMENTS(energy_nochamp)-1 DO energy_nochamp[i] = allocfree (energy_nochamp[i],energy_list[0])

	xlog_energy_nochamp = PTRARR(nbmax)
	FOR i=0L,N_ELEMENTS(xlog_energy_nochamp)-1 DO xlog_energy_nochamp[i] = allocfree (xlog_energy_nochamp[i],LINEAR_LOG[0])

	ylog_count_nochamp = PTRARR(nbmax)
	FOR i=0L,N_ELEMENTS(ylog_count_nochamp)-1 DO ylog_count_nochamp[i] = allocfree (ylog_count_nochamp[i],LINEAR_LOG[0])

	sensor_idee_list = ['0','1','2','3','4','5 (Type 1/3 only ?)','6 (Type 1/3 only ?)','7 (Type 1/3 only ?)']
	event_sensor_idee_nochamp = PTRARR(nbmax)
	FOR i=0L,N_ELEMENTS(event_sensor_idee_nochamp)-1 DO event_sensor_idee_nochamp[i] = allocfree (event_sensor_idee_nochamp[i],sensor_idee_list)

	type_idee_list = ['0 (LE)','1 (HE)','2 (LE/LEHE)','3 (HE/LEHE)']
	event_type_idee_nochamp = PTRARR(nbmax)
	FOR i=0L,N_ELEMENTS(event_type_idee_nochamp)-1 DO event_type_idee_nochamp[i] = allocfree (event_type_idee_nochamp[i],type_idee_list)

	emin_idee_list = '0'
	event_emin_idee_nochamp = PTRARR(nbmax)
	FOR i=0L,N_ELEMENTS(event_emin_idee_nochamp)-1 DO event_emin_idee_nochamp[i] = allocfree (event_emin_idee_nochamp[i],emin_idee_list)

	emax_idee_list = '63'
	event_emax_idee_nochamp = PTRARR(nbmax)
	FOR i=0L,N_ELEMENTS(event_emax_idee_nochamp)-1 DO event_emax_idee_nochamp[i] = allocfree (event_emax_idee_nochamp[i],emax_idee_list)

	sensor_xgre_list = ['0 (???)','1 (XG1)','2 (XG2)','3 (XG3)']
	event_sensor_xgre_nochamp = PTRARR(nbmax)
	FOR i=0L,N_ELEMENTS(event_sensor_xgre_nochamp)-1 DO event_sensor_xgre_nochamp[i] = allocfree (event_sensor_xgre_nochamp[i],sensor_xgre_list)

	plane_xgre_list = ['0 (PUP)','1 (LABR3)', '2 (PDOWN)']
	event_plane_xgre_nochamp = PTRARR(nbmax)
	FOR i=0L,N_ELEMENTS(event_plane_xgre_nochamp)-1 DO event_plane_xgre_nochamp[i] = allocfree (event_plane_xgre_nochamp[i],plane_xgre_list)

	emin_xgre_pup_list = '0'
	event_emin_xgre_pup_nochamp = PTRARR(nbmax)
	FOR i=0L,N_ELEMENTS(event_emin_xgre_pup_nochamp)-1 DO event_emin_xgre_pup_nochamp[i] = allocfree (event_emin_xgre_pup_nochamp[i],emin_xgre_pup_list)

	emax_xgre_pup_list = '255'
	event_emax_xgre_pup_nochamp = PTRARR(nbmax)
	FOR i=0L,N_ELEMENTS(event_emax_xgre_pup_nochamp)-1 DO event_emax_xgre_pup_nochamp[i] = allocfree (event_emax_xgre_pup_nochamp[i],emax_xgre_pup_list)

	emin_xgre_labr3_list = '0'
	event_emin_xgre_labr3_nochamp = PTRARR(nbmax)
	FOR i=0L,N_ELEMENTS(event_emin_xgre_labr3_nochamp)-1 DO event_emin_xgre_labr3_nochamp[i] = allocfree (event_emin_xgre_labr3_nochamp[i],emin_xgre_labr3_list)

	emax_xgre_labr3_list = '1023'
	event_emax_xgre_labr3_nochamp = PTRARR(nbmax)
	FOR i=0L,N_ELEMENTS(event_emax_xgre_labr3_nochamp)-1 DO event_emax_xgre_labr3_nochamp[i] = allocfree (event_emax_xgre_labr3_nochamp[i],emax_xgre_labr3_list)

	emin_xgre_pdown_list = '0'
	event_emin_xgre_pdown_nochamp = PTRARR(nbmax)
	FOR i=0L,N_ELEMENTS(event_emin_xgre_pdown_nochamp)-1 DO event_emin_xgre_pdown_nochamp[i] = allocfree (event_emin_xgre_pdown_nochamp[i],emin_xgre_pdown_list)

	emax_xgre_pdown_list = '255'
	event_emax_xgre_pdown_nochamp = PTRARR(nbmax)
	FOR i=0L,N_ELEMENTS(event_emax_xgre_pdown_nochamp)-1 DO event_emax_xgre_pdown_nochamp[i] = allocfree (event_emax_xgre_pdown_nochamp[i],emax_xgre_pdown_list)

	nbenergies = 4 * LONG (64)
	nbtables = (1024. * 1024. * 1024) / (nbenergies * 4)
	msg_idee = '(max='+val_to_str(LONG(nbtables))+')'

	nbenergies = LONG (1 + 255 + 1023 + 255)
	nbtables = (1024. * 1024. * 1024) / (nbenergies * 4)
	msg_xgre = '(max='+val_to_str(LONG(nbtables))+')'

        param = [																																							$
			{ var_obj, '',						'time_t1t2',				0, PTR_NEW(),											'check_supegal_infegal',	PTR_NEW(),		PTR_NEW ('')					},	$

			{ var_obj, 'Time:Start time',				'time_t1',				2, PTR_NEW(['TE','0','26']),									'check_always_ok',		PTR_NEW(),		PTR_NEW ('15 08 2019 00 00 00.000')		},	$
			{ var_obj, 'End time',					'time_t2',				2, PTR_NEW(['TE','2','26']),									'check_always_ok',		PTR_NEW(),		PTR_NEW ('16 08 2019 00 00 00.000')		},	$
			{ var_obj, 'Time selection ?',				'time_selection',			2, PTR_NEW(['B1','2','LABEL_LEFT',STRING_START_END,STRING_ORBIT_NUMBER]),			'check_always_ok',		PTR_NEW(),		PTR_NEW (STRING_START_END)			},	$
			{ var_obj, 'Start orbit-event_number',			'orbit1',				2, PTR_NEW(['TE','0','6']),									'check_always_ok',		PTR_NEW(),		PTR_NEW ('000001')				},	$
			{ var_obj, '',						'event_number1',			2, PTR_NEW(['TE','0','3']),									'check_always_ok',		PTR_NEW(),		PTR_NEW ('1')					},	$
			{ var_obj, 'End orbit-event_number',			'orbit2',				2, PTR_NEW(['TE','0','6']),									'check_always_ok',		PTR_NEW(),		PTR_NEW ('000001')				},	$
			{ var_obj, '',						'event_number2',			2, PTR_NEW(['TE','2','3']),									'check_always_ok',		PTR_NEW(),		PTR_NEW ('1')					},	$
			{ var_obj, 'Use Time/Orbit from',			'experiment_product_time_orbit',	2, PTR_NEW(['L1','2','11','LABEL_TOP',LIST]),							'check_always_ok',		PTR_NEW(),		PTR_NEW (LIST[0])				},	$

			{ var_obj, 'Data:Left Winsize',				'yleft_winsize',			3, PTR_NEW(['FL','0','12']),									'check_supegal_infegal',	PTR_NEW([0,1]),		PTR_NEW (0.2)					},	$
			{ var_obj, 'Right Winsize',				'legend_winsize',			3, PTR_NEW(['FL','2','12']),									'check_supegal_infegal',	PTR_NEW([0,1]),		PTR_NEW (0.2)					},	$
			{ var_obj, 'Dt (sec) for curve',			'event_dt',				3, PTR_NEW(['FL','2','12']),									'check_supegal',		PTR_NEW([0.0000001]),	PTR_NEW (1.0)					},	$
			{ var_obj, 'Method',					'method',				3, PTR_NEW(['L1','2','11','LABEL_TOP','Simple','Expert']),					'check_always_ok',		PTR_NEW(),		PTR_NEW ('Simple')				},	$
			{ var_obj, 'Nb energy tables IDEE '+msg_idee,		'nbtables_idee',			3, PTR_NEW(['IN','2','7']),									'check_supegal',		PTR_NEW([1]),		PTR_NEW (999)					},	$
			{ var_obj, 'Nb energy tables XGRE '+msg_xgre,		'nbtables_xgre',			3, PTR_NEW(['IN','2','7']),									'check_supegal',		PTR_NEW([1]),		PTR_NEW (999)					},	$
			{ var_obj, 'Charsize',					'charsize',				3, PTR_NEW(['FL','2','12']),									'check_supegal',		PTR_NEW([0]),		PTR_NEW (1.5)					},	$
			{ var_obj, 'Legend Charsize',				'legend_charsize',			3, PTR_NEW(['FL','2','12']),									'check_supegal',		PTR_NEW([0]),		PTR_NEW (1.2)					},	$

			{ var_obj, 'Simple:Curve and spectrum (bottom)',	'experiment_product_simple',		4, PTR_NEW(['L1','0','11','LABEL_TOP',LIST]),							'check_always_ok',		PTR_NEW(),		PTR_NEW (LIST[0])				},	$
			{ var_obj, 'Curve (top)',				'visu_top',				4, PTR_NEW(['L2','0','10','LABEL_TOP','EPHEMERIS_ORBIT',LIST]),					'check_always_ok',		PTR_NEW(),		PTR_NEW (['EPHEMERIS_ORBIT'])			},	$
			{ var_obj, 'Energy',					'energy',				4, PTR_NEW(['L1','0','11','LABEL_TOP',energy_list]),						'check_always_ok',		PTR_NEW(),		PTR_NEW (energy_list[0])			},	$
			{ var_obj, 'Energy axis',				'xlog_energy_simple',			4, PTR_NEW(['L1','0','11','LABEL_TOP',LINEAR_LOG]),						'check_always_ok',		PTR_NEW(),		PTR_NEW (LINEAR_LOG[0])				},	$
			{ var_obj, 'Count axis',				'ylog_count_simple',			4, PTR_NEW(['L1','2','11','LABEL_TOP',LINEAR_LOG]),						'check_always_ok',		PTR_NEW(),		PTR_NEW (LINEAR_LOG[0])				},	$
			{ var_obj, 'IDEE Sensor',				'event_sensor_idee',			4, PTR_NEW(['L2','0','10','LABEL_TOP',sensor_idee_list]),					'check_always_ok',		PTR_NEW(),		PTR_NEW (sensor_idee_list)			},	$
			{ var_obj, 'IDEE Type',					'event_type_idee',			4, PTR_NEW(['L2','0','10','LABEL_TOP',type_idee_list]),						'check_always_ok',		PTR_NEW(),		PTR_NEW (type_idee_list)			},	$
			{ var_obj, 'IDEE Emin',					'event_emin_idee',			4, PTR_NEW(['TE','0','2','LABEL_TOP']),								'check_supegal_infegal',	PTR_NEW([0,63]),	PTR_NEW ('0')					},	$
			{ var_obj, 'IDEE Emax',					'event_emax_idee',			4, PTR_NEW(['TE','2','2','LABEL_TOP']),								'check_supegal_infegal',	PTR_NEW([0,63]),	PTR_NEW ('63')					},	$
			{ var_obj, 'XGRE Sensor',				'event_sensor_xgre',			4, PTR_NEW(['L2','0','10','LABEL_TOP',sensor_xgre_list]),					'check_always_ok',		PTR_NEW(),		PTR_NEW (sensor_xgre_list)			},	$
			{ var_obj, 'XGRE Plane',				'event_plane_xgre',			4, PTR_NEW(['L2','0','10','LABEL_TOP',plane_xgre_list]),					'check_always_ok',		PTR_NEW(),		PTR_NEW (plane_xgre_list)			},	$
			{ var_obj, 'PUP Emin',					'event_emin_xgre_pup',			4, PTR_NEW(['TE','0','3','LABEL_TOP']),								'check_supegal_infegal',	PTR_NEW([0,255]),	PTR_NEW ('0')					},	$
			{ var_obj, 'PUP Emax',					'event_emax_xgre_pup',			4, PTR_NEW(['TE','0','3','LABEL_TOP']),								'check_supegal_infegal',	PTR_NEW([0,255]),	PTR_NEW ('255')					},	$
			{ var_obj, 'LABR3 Emin',				'event_emin_xgre_labr3',		4, PTR_NEW(['TE','0','4','LABEL_TOP']),								'check_supegal_infegal',	PTR_NEW([0,1023]),	PTR_NEW ('0')					},	$
			{ var_obj, 'LABR3 Emax',				'event_emax_xgre_labr3',		4, PTR_NEW(['TE','0','4','LABEL_TOP']),								'check_supegal_infegal',	PTR_NEW([0,1023]),	PTR_NEW ('1023')				},	$
			{ var_obj, 'PDOWN Emin',				'event_emin_xgre_pdown',		4, PTR_NEW(['TE','0','3','LABEL_TOP']),								'check_supegal_infegal',	PTR_NEW([0,255]),	PTR_NEW ('0')					},	$
			{ var_obj, 'PDOWN Emax',				'event_emax_xgre_pdown',		4, PTR_NEW(['TE','2','3','LABEL_TOP']),								'check_supegal_infegal',	PTR_NEW([0,255]),	PTR_NEW ('255')					},	$

			{ var_obj, 'Expert:Plot',				'plot',					5, PTR_NEW(['L2','0','10','LABEL_TOP',txtcourbe]),						'check_always_ok',		PTR_NEW(),		PTR_NEW ([txtcourbe[0]])			},	$
			{ var_obj, 'Property',					'nochamp',				5, PTR_NEW(['L1','0','10','LABEL_TOP',txtcourbe]),						'check_always_ok',		PTR_NEW(),		PTR_NEW (txtcourbe[0])				},	$
			{ var_obj, 'Visu',					'visu_nochamp',				5, PTR_NEW(['L1','0','10','LABEL_TOP',visu_list]),						'check_always_ok',		PTR_NEW(),		PTR_NEW (visu_nochamp)				},	$
			{ var_obj, 'Energy',					'energy_nochamp',			5, PTR_NEW(['L1','0','11','LABEL_TOP',energy_list]),						'check_always_ok',		PTR_NEW(),		PTR_NEW (energy_nochamp)			},	$
			{ var_obj, 'Energy axis',				'xlog_energy_nochamp',			5, PTR_NEW(['L1','0','11','LABEL_TOP',LINEAR_LOG]),						'check_always_ok',		PTR_NEW(),		PTR_NEW (xlog_energy_nochamp)			},	$
			{ var_obj, 'Count axis',				'ylog_count_nochamp',			5, PTR_NEW(['L1','0','11','LABEL_TOP',LINEAR_LOG]),						'check_always_ok',		PTR_NEW(),		PTR_NEW (ylog_count_nochamp)			},	$
			{ var_obj, 'Experiment Product',			'experiment_product_nochamp',		5, PTR_NEW(['L1','2','10','LABEL_TOP',experiment_product_list]),				'check_always_ok',		PTR_NEW(),		PTR_NEW (experiment_product_nochamp)		},	$
			{ var_obj, 'IDEE Sensor',				'event_sensor_idee_nochamp',		5, PTR_NEW(['L2','0','10','LABEL_TOP',sensor_idee_list]),					'check_always_ok',		PTR_NEW(),		PTR_NEW (event_sensor_idee_nochamp)		},	$
			{ var_obj, 'IDEE Type',					'event_type_idee_nochamp',		5, PTR_NEW(['L2','0','10','LABEL_TOP',type_idee_list]),						'check_always_ok',		PTR_NEW(),		PTR_NEW (event_type_idee_nochamp)		},	$
			{ var_obj, 'IDEE Emin',					'event_emin_idee_nochamp',		5, PTR_NEW(['TE','0','2','LABEL_TOP']),								'check_supegal_infegal',	PTR_NEW([0,63]),	PTR_NEW (event_emin_idee_nochamp)		},	$
			{ var_obj, 'IDEE Emax',					'event_emax_idee_nochamp',		5, PTR_NEW(['TE','2','2','LABEL_TOP']),								'check_supegal_infegal',	PTR_NEW([0,63]),	PTR_NEW (event_emax_idee_nochamp)		},	$
			{ var_obj, 'XGRE Sensor',				'event_sensor_xgre_nochamp',		5, PTR_NEW(['L2','0','10','LABEL_TOP',sensor_xgre_list]),					'check_always_ok',		PTR_NEW(),		PTR_NEW (event_sensor_xgre_nochamp)		},	$
			{ var_obj, 'XGRE Plane',				'event_plane_xgre_nochamp',		5, PTR_NEW(['L2','0','10','LABEL_TOP',plane_xgre_list]),					'check_always_ok',		PTR_NEW(),		PTR_NEW (event_plane_xgre_nochamp)		},	$
			{ var_obj, 'PUP Emin',					'event_emin_xgre_pup_nochamp',		5, PTR_NEW(['TE','0','2','LABEL_TOP']),								'check_supegal_infegal',	PTR_NEW([0,255]),	PTR_NEW (event_emin_xgre_pup_nochamp)		},	$
			{ var_obj, 'PUP Emax',					'event_emax_xgre_pup_nochamp',		5, PTR_NEW(['TE','0','2','LABEL_TOP']),								'check_supegal_infegal',	PTR_NEW([0,255]),	PTR_NEW (event_emax_xgre_pup_nochamp)		},	$
			{ var_obj, 'LABR3 Emin',				'event_emin_xgre_labr3_nochamp',	5, PTR_NEW(['TE','0','2','LABEL_TOP']),								'check_supegal_infegal',	PTR_NEW([0,1023]),	PTR_NEW (event_emin_xgre_labr3_nochamp)		},	$
			{ var_obj, 'LABR3 Emax',				'event_emax_xgre_labr3_nochamp',	5, PTR_NEW(['TE','0','2','LABEL_TOP']),								'check_supegal_infegal',	PTR_NEW([0,1023]),	PTR_NEW (event_emax_xgre_labr3_nochamp)		},	$
			{ var_obj, 'PDOWN Emin',				'event_emin_xgre_pdown_nochamp',	5, PTR_NEW(['TE','0','2','LABEL_TOP']),								'check_supegal_infegal',	PTR_NEW([0,255]),	PTR_NEW (event_emin_xgre_pdown_nochamp)		},	$
			{ var_obj, 'PDOWN Emax',				'event_emax_xgre_pdown_nochamp',	5, PTR_NEW(['TE','2','2','LABEL_TOP']),								'check_supegal_infegal',	PTR_NEW([0,255]),	PTR_NEW (event_emax_xgre_pdown_nochamp)		}	]

	code = self -> obj::init (no, container, order, param, general=general, /saisissable, graphique=1, /nonbcolors)

	RETURN, code

END


;-------------------------------------------------------------------------------
PRO tev__define
;-------------------------------------------------------------------------------
; La classe "tev" hérite de "obj".
;-------------------------------------------------------------------------------

	lint_unused = { tev, 			$

		INHERITS	obj 		$

	}

END
