;-------------------------------------------------------------------------------
PRO test_libxml
;-------------------------------------------------------------------------------
; Test du module libxml
;-------------------------------------------------------------------------------

	top1 = nbsec()
	code = xml_to_noeud_variable_valeur ('CO2p_XY_12_08_12.xml',dataxml)
	top2 = nbsec()
	print,top2-top1

	PRINT,'test_libxml OK'
	help,dataxml

	top1 = nbsec()
	s = { X:0., Y: 0., Z: 0., Dens: 0., Ux: 0., Uy: 0., Uz: 0., Utot: 0., Temp: 0. }
	ind = WHERE (dataxml.noeud EQ 'TD',nbTD)
	data = REPLICATE (s, nbTd/9)
	data.X    = dataxml[ind[0+9*LINDGEN(nbTD/9)]].valeur
	data.Y    = dataxml[ind[1+9*LINDGEN(nbTD/9)]].valeur
	data.Z    = dataxml[ind[2+9*LINDGEN(nbTD/9)]].valeur
	data.Dens = dataxml[ind[3+9*LINDGEN(nbTD/9)]].valeur
	data.Ux   = dataxml[ind[4+9*LINDGEN(nbTD/9)]].valeur
	data.Uy   = dataxml[ind[5+9*LINDGEN(nbTD/9)]].valeur
	data.Uz   = dataxml[ind[6+9*LINDGEN(nbTD/9)]].valeur
	data.Utot = dataxml[ind[7+9*LINDGEN(nbTD/9)]].valeur
	data.Temp = dataxml[ind[8+9*LINDGEN(nbTD/9)]].valeur
	top2 = nbsec()
	print,top2-top1

	top1 = nbsec()
	code = xml_to_noeud_variable_valeur ('Vel_12_08_12_orbit_MeX_2007_07_12_90.0.xml',dataxml)
	ind_field = WHERE(dataxml.noeud EQ 'FIELD' AND dataxml.variable EQ 'name', nbchamps)

	FOR i=0L,nbchamps-1 DO BEGIN
		s = dataxml[ind_field[i]].valeur
		IF s EQ 'Time' THEN BEGIN
			s = 'date'
			val = 0d
		END ELSE BEGIN
			val = 0.
		END
		ajouter_champ, s, val, nom, enreg, taille, first=i EQ 0
	END
	ind = WHERE (dataxml.noeud EQ 'TD',nbTD)
	data = REPLICATE (enreg, nbTd/nbchamps)
	FOR i=0L,nbchamps-1 DO BEGIN
		IF nom[i] EQ 'date' THEN BEGIN
			data.(i) = str_to_date(dataxml[ind[i+nbchamps*LINDGEN(nbTD/nbchamps)]].valeur, format=7, /C)
		END ELSE BEGIN
			data.(i) = dataxml[ind[i+nbchamps*LINDGEN(nbTD/nbchamps)]].valeur
		END
	END
	top2 = nbsec()
	print,top2-top1

	filename = 'Vel_12_08_12_orbit_MeX_2007_07_12_90.0.xml'
	code=read_xml_get_symbols(filename,SYMBOLS,NBRECORDS)

	code = read_ascii_analyse_symbols_for_cl (SYMBOLS, VARNAMES, REALVARNAMES, TYPES, SIZES, FILLVALS, UNITS, FIELDNAMS, NAME_TIME, NAME_THETA, UNIT_THETA,         $
                                                  NAME_PHI, UNIT_PHI, NAME_ENERGY, UNIT_ENERGY, ENERGIES, THETA, PHI, DT, PROPERTY, UNIT123D, NAME123D,                 $
                                                  remove_ext=remove_ext, selection_date=selection_date, selection_data=selection_data, selection_type=selection_type)

	READNAMES = VARNAMES[WHERE (STRUPCASE(VARNAMES) NE 'DATAX')]
	code = read_ascii_get_structure (VARNAMES, REALVARNAMES, TYPES, SIZES, FILLVALS, noms, enreg, info, $
                                         READNAMES=READNAMES, /quiet, trans=trans)

	code = read_xml_get_data (filename, nbrecords, enreg, info, data,    $
                                    /MODIFY_FLOAT_FILLVAL,                     $
                                    quiet=0)



stop

END
