;-------------------------------------------------------------------------------
PRO test_libidl
;-------------------------------------------------------------------------------
; Test du module libidl
;-------------------------------------------------------------------------------

	IF is_fdl() EQ 0 AND libname('util') NE 'util.so' THEN STOP
	IF is_fdl() EQ 1 AND libname('util') NE GETENV('CL_ROOT')+'/lib/util.so' THEN STOP

	top1 = nbsec()
	top2 = nbsec()
	PRINT,'nbsec: top2 - top1 = ',top2-top1

	IF int_str_0(10,2) NE '10' THEN STOP
	IF int_str_0(10,3) NE '010' THEN STOP

	IF tableaux_nonidem(my_strsplit('  a, b,c', ','),['  a',' b','c']) THEN STOP
	IF tableaux_nonidem(my_strsplit('  a, b,c', ',', /TRIM),['a','b','c']) THEN STOP

	IF chaine_la_plus_courte('abc','de')  NE 'de' THEN STOP
	IF chaine_la_plus_courte('de','abc') NE 'de' THEN STOP
	IF chaine_la_plus_courte('de','') NE 'de' THEN STOP
	IF chaine_la_plus_courte('','de') NE 'de' THEN STOP

	IF supprimer_caractere('nerv','')  NE ' nerv  ' THEN STOP

	IF chiffre_to_str(1.2) NE '1.20000' THEN STOP
	IF chiffre_to_str(1.2, /opt) NE '1.2' THEN STOP

	IF val_to_str('9.2') NE '9.2' THEN STOP
	IF tableaux_nonidem (val_to_str(['9.2','8.3']),['9.2','8.3']) THEN STOP
	IF val_to_str(9.2) NE '9.20000' THEN STOP
	IF val_to_str(9.2,/opt) NE '9.2' THEN STOP
	IF tableaux_nonidem (val_to_str([9.2,8.3],/opt),['9.2','8.3']) THEN STOP

	IF val_to_str_1decimale(9.22)  NE '9.2' THEN STOP
	IF tableaux_nonidem (val_to_str_1decimale([9.22,8.33]),['9.2','8.3']) THEN STOP

	IF val_to_str_2decimales(9.23) NE '9.23' THEN STOP
	IF tableaux_nonidem (val_to_str_2decimales([9.23,8.34]),['9.23','8.34']) THEN STOP

	IF chaine_contient('chaine','ai') EQ 0 THEN STOP
	IF chaine_contient('chaine','chb') NE 0 THEN STOP

	s = ['abyaby','xxabyaby','xxabab'] & remplacer,s,'ab','AAA' & IF tableaux_nonidem(s,['AAAyAAAy','xxAAAyAAAy','xxAAAAAA']) THEN STOP
	s = ['abyaby','xxabyaby','xxabab'] & remplacer,s,'ab','AAA',/DEBUT & IF tableaux_nonidem(s,['AAAyaby','xxAAAyaby','xxAAAab']) THEN STOP

	IF int_str_(10,2) NE '10' THEN STOP
	IF int_str_(10,3) NE ' 10' THEN STOP

	IF chaine_contient_fin('abcd','cd') NE 1 THEN STOP
	IF chaine_contient_fin('abcd','xx') NE 0 THEN STOP

	IF tableaux_nonidem (proteger_escape(['toto,tata,titi','toto,tata'], ','), ['toto'+STRING(2b)+',tata'+STRING(2b)+',titi','toto'+STRING(2b)+',tata']) THEN STOP

	IF chercher_commencepar_terminepar(['TABLE_ENERGIE_20','TABLE_ENERGIE_21'],'TABLE','20') NE 0 THEN STOP
	IF chercher_commencepar_terminepar(['TABLE_ENERGIE_20','TABLE_ENERGIE_21'],'TABLE','21') NE 1 THEN STOP
	IF chercher_commencepar_terminepar(['TABLE_ENERGIE_1','TABLE_ENERGIE_21'],'TABLE','1') NE 0 THEN STOP

	IF tableaux_nonidem(string_to_data('1.2,4.5,6') ,[1.2,4.5,6]) THEN STOP

	IF corriger_nomchamp('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789') NE 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789' THEN STOP
	IF corriger_nomchamp('Bx_gse_nT') NE 'Bx_gse_nT' THEN STOP
	IF corriger_nomchamp('9ab##') NE '_9ab__' THEN STOP

	IF my_strcompress('  1 		2   3  ') NE '1 2 3' THEN STOP

	IF supprimer_quote_debut_fin('toto') NE 'toto' THEN STOP
	IF supprimer_quote_debut_fin('"toto"') NE 'toto' THEN STOP

	tab = ''
	ajouter_tabstring,tab,'toto'
	ajouter_tabstring,tab,'tata'
	IF tableaux_nonidem(tab,['toto','tata']) THEN STOP

	IF data_to_cef([1.23,23.45,345.671]) NE '1.23, 23.45, 345.67' THEN STOP

	IF modif_thunderbird('http://stereo.cesr.fr') NE 'http//stereo.cesr.fr' THEN STOP

	IF supprimer_tags('toto<tag>titi<tatata dhsqkjdq><aaa>tutu</a>') NE 'toto titi tutu' THEN STOP
	
	IF afficher_http('http://stereo.cesr.fr/penou/lint.html') NE '(http://stereo.cesr.fr) lint.html' THEN STOP

	IF enlever_slash_fin('/toto/titi///') NE '/toto/titi' THEN STOP
	IF enlever_slash_fin('g:\toto\titi\\\') NE 'g:\toto\titi' THEN STOP

	IF rajouter_slash_fin('/toto/titi') NE '/toto/titi/' THEN STOP
	IF rajouter_slash_fin('/toto/titi/') NE '/toto/titi/' THEN STOP

	IF is_string('toto') NE 1 THEN STOP
	IF is_string(1.2) NE 0 THEN STOP

	IF is_number(1234) NE 1 THEN STOP
	IF is_number('1') NE 1 THEN STOP
	IF is_number('a') NE 0 THEN STOP

	IF is_byte(1b) NE 1 THEN STOP
	IF is_byte(1) NE 0 THEN STOP

	IF is_float(1.1) NE 1 THEN STOP
	IF is_float(1) NE 0 THEN STOP

	IF is_double(1d1) NE 1 THEN STOP
	IF is_double(1) NE 0 THEN STOP

	IF is_structure({ x:1 }) NE 1 THEN STOP
	IF is_structure(1) NE 0 THEN STOP

	ajouter_champ, 'a',   0b,  nom, enreg, taille, /first
	ajouter_champ, 'b',   0,   nom, enreg, taille
	ajouter_champ, 'c',   0L,  nom, enreg, taille
	ajouter_champ, 'd',   0.,  nom, enreg, taille
	ajouter_champ, 'e',   0d,  nom, enreg, taille
	ajouter_champ, 'f',   0U,  nom, enreg, taille
	ajouter_champ, 'g',   0UL, nom, enreg, taille
	ajouter_champ, 'g',   '',  nom, enreg, taille
	ajouter_champ, '3d',  0,   nom, enreg, taille
	ajouter_champ, 'and', 0,   nom, enreg, taille

	IF tableaux_nonidem(nom,['a','b','c','d','e','f','g','g_','_3d','_and']) THEN STOP
	IF structures_idem(enreg,{ a:0b, b:0, c:0L, d:0., e:0d, f:0U, g:0UL, g_:'', _3d:0, _and:0 }) EQ 0 THEN STOP
	IF taille NE 45 THEN STOP

	lint_unused = get_structure_infos (enreg, taille_enreg, nbchamps, nom_champ, type_champ, offset_champ, taille_champ, nb_champ)
	IF nbchamps NE 10 THEN STOP
	IF tableaux_nonidem(nom_champ,['A','B','C','D','E','F','G','G_','_3D','_AND']) THEN STOP
	IF tableaux_nonidem(type_champ,[1,2,3,4,5,12,13,7,2,2]) THEN STOP
	IF tableaux_nonidem(nb_champ,[1,1,1,1,1,1,1,1,1,1]) THEN STOP

	IF tableaux_nonidem([1,2,3],[1,2,3]) THEN STOP
	IF ~tableaux_nonidem([1,2,3],[1,2,4]) THEN STOP
	IF ~tableaux_nonidem([1,2,3],[1,2]) THEN STOP

	IF get_typeval('unsigned char') NE 0b THEN STOP
	IF get_typeval('short') NE 0 THEN STOP
	IF get_typeval('int') NE 0L THEN STOP
	IF get_typeval('float') NE 0. THEN STOP
	IF get_typeval('double') NE 0d THEN STOP
	IF get_typeval('unsigned short') NE 0u THEN STOP
	IF get_typeval('unsigned int') NE 0ul THEN STOP

	IF type_to_val(1) NE 0b THEN STOP
	IF type_to_val(2) NE 0 THEN STOP
	IF type_to_val(3) NE 0l THEN STOP
	IF type_to_val(4) NE 0. THEN STOP
	IF type_to_val(5) NE 0d THEN STOP
	IF type_to_val(7) NE '' THEN STOP
	IF type_to_val(12) NE 0u THEN STOP
	IF type_to_val(13) NE 0ll THEN STOP
	IF type_to_val(14) NE 0ull THEN STOP

	tmp = compress_struct (enreg)
	lint_unused = valnbdimsdims_to_tab (1,0,[0])
	lint_unused = valnbdimsdims_to_tab (1,1,[1])
	lint_unused = valnbdimsdims_to_tab (1,2,[1,2])
	lint_unused = valnbdimsdims_to_tab (1,3,[1,2,3])
	lint_unused = valnbdimsdims_to_tab (1,4,[1,2,3,4])
	lint_unused = valnbdimsdims_to_tab (1,5,[1,2,3,4,5])
	lint_unused = valnbdimsdims_to_tab (1,6,[1,2,3,4,5,6])
	lint_unused = valnbdimsdims_to_tab (1,7,[1,2,3,4,5,6,7])
	lint_unused = valnbdimsdims_to_tab (1,8,[1,2,3,4,5,6,7,8])
	struct = uncompress_struct (tmp)

	IF structures_idem(enreg,struct) EQ 0 THEN STOP
	struct.e = 2
	IF structures_idem(enreg,struct) EQ 1 THEN STOP

	IF moyen([1.0,2.0,3.0,4.0,5.0]) NE 3.0 THEN STOP

	IF module_v1([1.0,2.0,3.0]) NE SQRT(1+4+9) THEN STOP

	IF module(1.0,2.0,3.0) NE SQRT(1+4+9) THEN STOP

	IF tableaux_nonidem (v1_vectoriel_v2([1,0,0],[0,1,0]), [0,0,1]) THEN STOP

	IF produit_scalaire_v1_v2 ([1.0,2.0,3.0],[4.0,5.0,6.0]) NE 1.0*4.0+2.0*5.0+3.0*6.0 THEN STOP

	A = [	[0.0000000,	 0.0000000,	0.0000000,	 0.0000000],	$
		[0.0000000,	-0.28685084,	0.0047219233,	-0.95796359],	$
		[0.0000000,	-0.87625778,	0.40284038,	 0.26437068],	$
		[0.0000000,	 0.38715473,	0.91525799,	-0.11141748]	]
	copieA = A

	res = [	[0.0000000,      0.000000,      0.000000,    0.0000000],	$
		[0.0000000,     -0.957964,      0.299438,   -0.00492913],	$
		[0.0000000,      0.264371,     -0.955420,   -0.422001],		$
		[0.0000000,     -0.111417,      0.420517,    1.09259]		]

	IF my_ludcmp(A, 3, INDX, D) NE 1 THEN STOP
	IF (WHERE(A-res GT 1e-5))[0] NE -1 THEN STOP
	IF tableaux_nonidem(INDX,[0,3,3,3]) THEN STOP
	IF D NE 1 THEN STOP

	IF ludcmp_v1_v2([-113.771,1.87281,-379.948],[-20.9494,9.63101,6.32051],Aorg,A1,INDX) NE 1 THEN STOP
	IF (WHERE(Aorg-copieA GT 1e-5))[0] NE -1 THEN STOP
	IF (WHERE(A1-A GT 1e-5))[0] NE -1 THEN STOP
	IF tableaux_nonidem(INDX,[0,3,3,3]) THEN STOP

	tabtdeb = [1000d,3000d]
	tabtfin = [2000d,4000d]
	date    = [1000d,1500d,2000d,3000d,3300d,3500d,4000d]
	x1      = [1.0,  2.0,  3.0,  4.0, -1e31,  6.0,  7.0]
	y1      = [11.0, 22.0, 33.0, 44.0, 55.0, 66.0, 77.0]
	z1      = [111.0,222.0,333.0,444.0,555.0,666.0,777.0]
	moyenner_vecteur, tabtdeb, tabtfin, date, x1, y1, z1, x2, y2, z2, -1e31
	IF tableaux_nonidem (x2, [(1.0+2.0+3.0)/3.0, (4.0+6.0+7.0)/3.0]) THEN STOP
	IF tableaux_nonidem (y2, [(11.0+22.0+33.0)/3.0, (44.0+66.0+77.0)/3.0]) THEN STOP
	IF tableaux_nonidem (z2, [(111.0+222.0+333.0)/3.0, (444.0+666.0+777.0)/3.0]) THEN STOP

	t1 = [1000d,2000d,3000d]
	x1 = [10.0,20.0,30.0]
	t2 = [ 500d,1500d,2500d,3500d,4500d]
	x2 = interpoler_tab (t2, t1, x1, -1e31, DTMAX=1000d) ; FLOAT
	IF tableaux_nonidem(x2,[5.0,15.0,25.0,35.0,-1e31]) THEN STOP

	x1 = [10d,20d,30d]
	x2 = interpoler_tab (t2, t1, x1, -1e31, DTMAX=1000d) ; DOUBLE
	IF tableaux_nonidem(x2,[5d,15d,25d,35d,-1e31]) THEN STOP

	z1 = [ { x:1.0, y:2.0, z:3.0 }, { x:4.0, y:5.0, z:6.0 }, { x:4.0, y:-1e31, z:6.0 } ]
	z2 = REPLICATE ( { module: 0.0 }, 3)
	xyz_to_module, z1, z2, 'x', 'y', 'z', 'module'
	IF structures_idem (z2, [ { module: SQRT(1+4+9) }, { module: SQRT(16+25+36) }, { module: -1e31 } ]) EQ 0 THEN STOP

	t = [1000d, 2000d, 3000d, 4000d, 5000d, 6000d, 7000d]
	y = [1.0,   2.0,   3.0,   11.0,  12.0,  13.0,  20.0]
	moyenner_tab, 1, 3, t, y ; moyenne tous les 3 points
	IF tableaux_nonidem (t,[2000d,5000d]) THEN STOP
	IF tableaux_nonidem (y,[2,12]) THEN STOP

	t = [1000d, 2000d, 3000d, 4000d, 5000d, 6000d, 7000d]
	y = [1.0,   2.0,   3.0,   11.0,  12.0,  13.0,  20.0]
	moyenner_tab, 6, 3, t, y ; moyenne histogramme tous les 3 points
	IF tableaux_nonidem (t,[1000d,2000d,3000d,4000d,5000d,6000d,7000d]) THEN STOP
	IF tableaux_nonidem (y,[2,2,2,12,12,12,20]) THEN STOP

	t = [1000d, 2000d, 3000d, 4000d, 5000d, 6000d, 7000d]
	y = [1.0,   2.0,   3.0,   11.0,  12.0,  13.0,  20.0]
	moyenner_tab, 3, 0, t, y ; maximum
	IF tableaux_nonidem (t,[7000d]) THEN STOP
	IF tableaux_nonidem (y,[20]) THEN STOP

	t = [1000d, 2000d, 3000d, 4000d, 5000d, 6000d, 7000d]
	y = [1.0,   2.0,   3.0,   11.0,  12.0,  13.0,  20.0]
	moyenner_tab, 4, 0, t, y ; minimum
	IF tableaux_nonidem (t,[1000d]) THEN STOP
	IF tableaux_nonidem (y,[1]) THEN STOP

	t = [1000d, 2000d, 3000d, 4000d, 5000d, 6000d, 7000d]
	y = [1.0,   2.0,   3.0,   11.0,  12.0,  13.0,  20.0]
	moyenner_tab, 2, 2, t, y ; moyenne glissante toutes les 2 secondes
	IF tableaux_nonidem (t,[1000d, 2000d, 3000d, 4000d, 5000d, 6000d, 7000d]) THEN STOP
	IF tableaux_nonidem (y,[(1+2)/2d,(1+2+3)/3d,(2+3+11)/3d,(3+11+12)/3d,(11+12+13)/3d,(12+13+20)/3d,(13+20)/2d]) THEN STOP

	tab_date = [1000d,2000d,2500d,4000d,5000d,5500d]
	dttrou = 800d
	trou_de_donnees, tab_date, dttrou, tab_deb, tab_fin ; DOUBLE
	IF tableaux_nonidem (tab_deb, [0,1,3,4]) THEN STOP
	IF tableaux_nonidem (tab_fin, [0,2,3,5]) THEN STOP

	tab_date = LONG([1000,2000,2500,4000,5000,5500])
	dttrou = LONG(800)
	trou_de_donnees, tab_date, dttrou, tab_deb, tab_fin ; LONG
	IF tableaux_nonidem (tab_deb, [0,1,3,4]) THEN STOP
	IF tableaux_nonidem (tab_fin, [0,2,3,5]) THEN STOP

	nbx = 2L
	nby = 5L
	Z    = REPLICATE (0., nbx, nby)
	Ymin = REPLICATE (0., nbx, nby)
	Ymax = REPLICATE (0., nbx, nby)
	Ymoy = REPLICATE (0., nbx, nby)
	FOR i=0L,nbx-1 DO Z[i,*]    = 1+i+LINDGEN(nby)
	FOR i=0L,nbx-1 DO Ymin[i,*] = FINDGEN(nby)
	FOR i=0L,nbx-1 DO Ymax[i,*] = FINDGEN(nby)+1
	FOR i=0L,nbx-1 DO Ymoy[i,*] = FINDGEN(nby)+0.5
	spectro_additiony, 2, nbx, nby, Ymin, Ymax, Ymoy, Z
	IF tableaux_nonidem (Ymin,[[ 0,  0],[  2,  2],[  4,  4]]) THEN STOP
	IF tableaux_nonidem (Ymax,[[ 2,  2],[  4,  4],[  5,  5]]) THEN STOP
	IF tableaux_nonidem (Ymoy,[[ 1,  1],[  3,  3],[4.5,4.5]]) THEN STOP
	IF tableaux_nonidem (Z,   [[1+2,2+3],[3+4,4+5],[5.0,6.0]]) THEN STOP

	IF ~check_tu(2012,1,1,0,0,0) THEN STOP
	IF  check_tu(999,1,1,0,0,0) THEN STOP
	IF  check_tu(2012,13,1,0,0,0) THEN STOP
	IF  check_tu(2012,1,32,0,0,0) THEN STOP
	IF  check_tu(2012,1,1,25,0,0) THEN STOP
	IF  check_tu(2012,1,1,0,60,0) THEN STOP
	IF  check_tu(2012,1,1,0,0,60) THEN STOP

	IF ~check_doy(2012,1,0,0,0) THEN STOP
	IF  check_doy(999,1,0,0,0) THEN STOP
	IF  check_doy(2012,367,0,0,0) THEN STOP
	IF  check_doy(2012,1,25,0,0) THEN STOP
	IF  check_doy(2012,1,0,60,0) THEN STOP
	IF  check_doy(2012,1,0,0,60) THEN STOP

	IF tableaux_nonidem (date_to_nbjours([86401*1000d,86401*1000d*10,-86300000d,-86500000d]), [1,10,-1,-2]) THEN STOP

	date1 = tu_to_date (1948,1,1,12,1,2.3) + LINDGEN(20000)*86400000d
	date_to_tu, date1, annee, mois, jour, heure, minute, seconde
	date2 = tu_to_date (annee, mois, jour, heure, minute, seconde)
	IF (WHERE(date2-date1 NE 0))[0] NE -1 THEN STOP

	year_doy_to_month_day, [2012,2012],[1,366],mois,jour
	IF tableaux_nonidem (mois, [1,12]) THEN STOP
	IF tableaux_nonidem (jour, [1,31]) THEN STOP

	IF tableaux_nonidem (year_month_day_to_doy([2012,2012],[1,12],[1,31]), [1,366]) THEN STOP

	IF tableaux_nonidem (mois_to_str([1,2,3,4,5,6,7,8,9,10,11,12]), ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']) THEN STOP

	IF tu_to_str(2012,12,20,1,2,3.4,format=0) NE '20/Dec/2012 01:02:03.400' THEN STOP
	IF tu_to_str(2012,12,20,1,2,3.4,format=1) NE '20 12 2012 01 02 03.400' THEN STOP
	IF tu_to_str(2012,12,20,1,2,3.4,format=2) NE '20/12/2012 01:02:03.400' THEN STOP
	IF tu_to_str(2012,12,20,1,2,3.4,format=3) NE '2012-12-20T01:02:03.400Z' THEN STOP
	IF tu_to_str(2012,12,20,1,2,3.4,format=4) NE '2012 12 20 01 02 03.400' THEN STOP
	IF tu_to_str(2012,12,20,1,2,3.4,format=5) NE '2012-12-20T01:02:03Z' THEN STOP
	IF tu_to_str(2012,12,20,1,2,3.4,format=6) NE '01:02' THEN STOP
	IF tu_to_str(2012,12,20,1,2,3.4,format=7) NE '2012-12-20T01:02:03.400' THEN STOP

	date = tu_to_date(2012,12,20,1,2,3.4)

	IF tableaux_nonidem(date_to_str([date,date], format=1),         ['20 12 2012 01 02 03.400','20 12 2012 01 02 03.400']) THEN STOP
	IF tableaux_nonidem(date_to_str([date,date], format=1, /C), 	['20 12 2012 01 02 03.400','20 12 2012 01 02 03.400']) THEN STOP
	IF tableaux_nonidem(date_to_str([date,date], format=2),         ['20/12/2012 01:02:03.400','20/12/2012 01:02:03.400']) THEN STOP
	IF tableaux_nonidem(date_to_str([date,date], format=3),    	['2012-12-20T01:02:03.400Z','2012-12-20T01:02:03.400Z']) THEN STOP
	IF tableaux_nonidem(date_to_str([date,date], format=3, /C),    	['2012-12-20T01:02:03.400Z','2012-12-20T01:02:03.400Z']) THEN STOP
	IF tableaux_nonidem(date_to_str([date,date], format=4),		['2012 12 20 01 02 03.400','2012 12 20 01 02 03.400']) THEN STOP
	IF tableaux_nonidem(date_to_str([date,date], format=5),		['2012-12-20T01:02:03Z','2012-12-20T01:02:03Z']) THEN STOP
	IF tableaux_nonidem(date_to_str([date,date], format=5, /C),	['2012-12-20T01:02:03Z','2012-12-20T01:02:03Z']) THEN STOP
	IF tableaux_nonidem(date_to_str([date,date], format=6),		['01:02','01:02']) THEN STOP
	IF tableaux_nonidem(date_to_str([date,date], format=7),		['2012-12-20T01:02:03.400','2012-12-20T01:02:03.400']) THEN STOP

	IF date_to_str(nbjours_to_date(1)) NE '02/Jan/1958 00:00:00.000' THEN STOP

	IF date_to_nanoinday(tu_to_date(2012,12,25,0,0,0),tu_to_date(2012,12,25,1,2,3.4)) NE 0 THEN STOP
	IF date_to_nanoinday(tu_to_date(2012,12,25,1,2,3),tu_to_date(2012,12,25,1,2,3.4)) NE 3600000000000LL+2*60000000000LL+3000000000LL THEN STOP
	IF date_to_nanoinday(tu_to_date(2012,12,26,1,2,3),tu_to_date(2012,12,25,1,2,3.4)) NE 86400000000000LL+3600000000000LL+2*60000000000LL+3000000000LL THEN STOP

	IF date_to_str(str_to_date('20 12 2012 01 02 03.400')) NE '20/Dec/2012 01:02:03.400' THEN STOP
	IF date_to_str(str_to_date('20 12 2012 01 02 03'))     NE '20/Dec/2012 01:02:03.000' THEN STOP
	IF date_to_str(str_to_date('20 12 2012 01 02'))        NE '20/Dec/2012 01:02:00.000' THEN STOP
	IF date_to_str(str_to_date('20 12 2012 01'))           NE '20/Dec/2012 01:00:00.000' THEN STOP
	IF date_to_str(str_to_date('20 12 2012'))              NE '20/Dec/2012 00:00:00.000' THEN STOP
	IF date_to_str(str_to_date('20 12 2012 01 02 03.400',format=1)) NE '20/Dec/2012 01:02:03.400' THEN STOP
	IF date_to_str(str_to_date('2012-12-20T01:02:03.400Z',format=3)) NE '20/Dec/2012 01:02:03.400' THEN STOP
	IF date_to_str(str_to_date('2012-12-20T01:02:03Z',format=5)) NE '20/Dec/2012 01:02:03.000' THEN STOP

	IF date_to_str(ccsds_to_date('2012-12-20T01:02:03.456Z')) NE '20/Dec/2012 01:02:03.456' THEN STOP
	IF date_to_str(ccsds_to_date('2012-12-20T01:02:03.456'))  NE '20/Dec/2012 01:02:03.456' THEN STOP
	IF date_to_str(ccsds_to_date('2012-12-20T01:02:03'))      NE '20/Dec/2012 01:02:03.000' THEN STOP
	IF date_to_str(ccsds_to_date('2012-366T01:02:03.456Z'))   NE '31/Dec/2012 01:02:03.456' THEN STOP
	IF date_to_str(ccsds_to_date('2012-366T01:02:03.456'))    NE '31/Dec/2012 01:02:03.456' THEN STOP
	IF date_to_str(ccsds_to_date('2012-366T01:02:03'))        NE '31/Dec/2012 01:02:03.000' THEN STOP

	init_carrington_rotation
	carrington_rotation_infos = get_carrington_rotation_infos()
	no = (WHERE (carrington_rotation_infos.no EQ 1968))[0]
	IF date_to_str(carrington_rotation_infos[no].start_time) NE '30/Sep/2000 06:01:43.680' THEN STOP
	IF date_to_str(carrington_rotation_infos[no].end_time)   NE '27/Oct/2000 13:00:20.160' THEN STOP
	tmp = get_carrington_rotation_best(tu_to_date(2000,10,1,0,0,0))
	IF tmp.no NE 1968 THEN STOP
	IF date_to_str(tmp.start_time) NE '30/Sep/2000 06:01:43.680' THEN STOP
	IF date_to_str(tmp.end_time)   NE '27/Oct/2000 13:00:20.160' THEN STOP

	IF get_carrington_rotation_number(tu_to_date(2000,9,30,6,1,43.680),tu_to_date(2000,10,27,13,0,20.160)) NE 1968 THEN STOP

	IF is_month_t1_t2(tu_to_date(2012,12,1,1,2,3.4),tu_to_date(2013,1,1,1,2,3.4)) NE 1 THEN STOP
	IF is_month_t1_t2(tu_to_date(2013,1,25,1,2,3.4),tu_to_date(2013,2,25,1,2,3.4)) NE 1 THEN STOP
	IF is_year_t1_t2(tu_to_date(2013,1,25,1,2,3.4),tu_to_date(2014,1,25,1,2,3.4)) NE 1 THEN STOP

	IF duree_to_str(1000000010d) NE '11 days, 13 hours, 46 minutes, 40.01 seconds' THEN STOP

	IF dernier_element([1,2,3]) NE 3 THEN STOP

	p = PTR_NEW()
	val = 99
	p = allocfree (p,val)
	IF *p NE 99 THEN STOP
	IF N_ELEMENTS(val) NE 1 THEN STOP

	p = PTR_NEW()
	val = 99
	p = allocfree (p,val,/NO_COPY)
	IF *p NE 99 THEN STOP
	IF N_ELEMENTS(val) NE 0 THEN STOP

	p = PTR_NEW([1,2])
	IF n_elements_p(p) NE 2 THEN STOP

	IF tableau_contient([1,2],1) EQ 0 THEN STOP
	IF tableau_contient([1,2],3) EQ 1 THEN STOP

	tab = [1,2,3,3,3,4]
	tab = supprimer_val(tab,3)
	IF tableaux_nonidem(tab,[1,2,4]) THEN STOP

	str1 = [{ x:1, y:2 },{ x:3, y:4 }]
	str2 = [{ z:5 }, { z:6 }]
	str3 = REPLICATE ({ x:0, y:0, z:0 },2)
	joindre_structure,str1,str2,0L,1L,str3
	IF tableaux_nonidem (str3.x,[1,3]) THEN STOP
	IF tableaux_nonidem (str3.y,[2,4]) THEN STOP
	IF tableaux_nonidem (str3.z,[5,6]) THEN STOP

	intervalle1 = [tu_to_date(2013,1,1,1,2,3),tu_to_date(2013,1,3,4,5,6)]
	intervalle2 = [tu_to_date(2013,1,2,7,8,9),tu_to_date(2013,1,4,10,11,12)]
	intervalle = joindre_intervalle (intervalle1, intervalle2, 'all')
	IF tableaux_nonidem(intervalle,[tu_to_date(2013,1,2,7,8,9),tu_to_date(2013,1,3,4,5,6)]) THEN STOP
	intervalle = joindre_intervalle (intervalle1, intervalle2, 'any')
	IF tableaux_nonidem(intervalle,[tu_to_date(2013,1,1,1,2,3),tu_to_date(2013,1,4,10,11,12)]) THEN STOP

	IF ~is_demeter(16) THEN STOP

	PRINT,'test_libidl OK'

END
