;-------------------------------------------------------------------------------
PRO stereo_mag_cdf2cef, $
;-------------------------------------------------------------------------------
	input_filename_cdf	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Lit le fichier input_filename_cdf et va crer dans /DATA/STEREO/DATA/CEF/MAG/$SC
; le fichier cef correspondant avec Bx, By, Bz et B en moyennant les donnes sur 1 minute
;-------------------------------------------------------------------------------

	COMMON COMMON_CL, general

	tmp = basename(input_filename_cdf)
	SC_court = STRMID(tmp,2,1)
	isahead = SC_court EQ 'A'
	SC_long = isahead ? 'ahead' : 'behind'
	YYYYMMDD = STRMID(tmp, 14,8)
	V = STRMID(tmp,23,3)

	output_filename_cef = '/DATA/STEREO/DATA/CEF/MAG/'+SC_long+'/'+'ST'+SC_court+'_MAG1MN_'+YYYYMMDD+'_'+V+'.cef'
	code = detruire (output_filename_cef)
	
	code = read_cdf_for_cl (input_filename_cdf, noms, enreg, DATA_CDF, nblignes, $
			VARNAMES,REALVARNAMES,TYPES,SIZES,FILLVALS,UNITS,FIELDNAMS,NAME_TIME,NAME_THETA,UNIT_THETA,NAME_PHI,UNIT_PHI,NAME_ENERGY,UNIT_ENERGY,NAME_MASS,UNIT_MASS,ENERGIES,THETA,PHI,DT,PROPERTY,UNIT123D,NAME123D,SYMBOLS,indY,$
			general=general,selection_date='Epoch',selection_type='timeseries')

	IF code EQ 0 THEN RETURN

	OPENW, fd, output_filename_cef, /GET_LUN
	PRINTF, fd, 'Start_variable = Epoch'
	PRINTF, fd, 'End_variable   = Epoch'
	PRINTF, fd, 'Start_variable = Bx_SC_nT'
	PRINTF, fd, 'End_variable   = Bx_SC_nT'
	PRINTF, fd, 'Start_variable = By_SC_nT'
	PRINTF, fd, 'End_variable   = By_SC_nT'
	PRINTF, fd, 'Start_variable = Bz_SC_nT'
	PRINTF, fd, 'End_variable   = Bz_SC_nT'
	PRINTF, fd, 'Start_variable = B_nT'
	PRINTF, fd, 'End_variable   = B_nT'

	date_to_tu, DATA_CDF[0].date, annee, mois, jour, heure, minute, seconde

	resolution = 60000d ; 1minute
	DATA_CEF = REPLICATE (DATA_CDF[0],86400*1000d/resolution) 

	dates = DATA_CDF.date
	Bxs = DATA_CDF.BFIELD_BX_S_C_
	Bys = DATA_CDF.BFIELD_BY_S_C_
	Bzs = DATA_CDF.BFIELD_BZ_S_C_
	Bs  = DATA_CDF.BFIELD_BTOTAL

	FOR i=0L,N_ELEMENTS(DATA_CEF)-1 DO BEGIN

		date = tu_to_date (annee, mois, jour, 0, 0, 0)
		date += resolution*i

		ind = WHERE (dates GE date AND dates LT date+resolution AND Bxs GT -1e30 AND Bys GT -1e30 AND Bzs GT -1e30 AND Bs GT -1e30, nbpoints)

		date += resolution*0.5
		date_to_tu, date, ann, moi, jou, heu, min, sec

		Bx = nbpoints GE 1 ? TOTAL(Bxs[ind]) / nbpoints : -1E31
		By = nbpoints GE 1 ? TOTAL(Bys[ind]) / nbpoints : -1E31
		Bz = nbpoints GE 1 ? TOTAL(Bzs[ind]) / nbpoints : -1E31
		B  = nbpoints GE 1 ? TOTAL(Bs[ind])  / nbpoints : -1E31

		IF (Bx NE -1E31) OR (By NE -1E31) OR (Bz NE -1E31) OR (B NE -1E31) THEN BEGIN

			s = date_to_str(date,format=4)
			s += '  ' + STRING(Bx, FORMAT='(E12.5)')
			s += '  ' + STRING(By, FORMAT='(E12.5)')
			s += '  ' + STRING(Bz, FORMAT='(E12.5)')
			s += '  ' + STRING(B,  FORMAT='(E12.5)')

			PRINTF, fd, s

		END

	END

	CLOSE, fd
	FREE_LUN, fd

	PRINT,output_filename_cef+' has been created'

END
