;-------------------------------------------------------------------------------
FUNCTION decompresse_log, n_in
;-------------------------------------------------------------------------------

	n = ULONG(n_in)

	IF n LT '20'XUL THEN RETURN, n

	IF n GE 'FF'XUL THEN RETURN, '80000'XUL

	range = ['30'XUL,'40'XUL,'50'XUL,'60'XUL,'70'XUL,'80'XUL,'90'XUL,$
			'A0'XUL,'B0'XUL,'C0'XUL,'D0'XUL,'E0'XUL,'F0'XUL,'100'XUL]

	a = range - '10'XUL

	b = ['20'XUL,'40'XUL,'80'XUL,'100'XUL,'200'XUL,'400'XUL,'800'XUL,'1000'XUL,$
			'2000'XUL,'4000'XUL,'8000'XUL,'10000'XUL,'20000'XUL,'40000'XUL]

	c = [2UL, 4UL, 8UL, '10'XUL, '20'XUL, '40'XUL, '80'XUL, '100'XUL, $
			'200'XUL, '400'XUL, '800'XUL, '1000'XUL, '2000'XUL, '4000'XUL]

	FOR i = 0, N_ELEMENTS(range)-1 DO $
		IF n LT range[i] THEN RETURN, b[i] + c[i] * (n - a[i])

END

;-------------------------------------------------------------------------------
PRO compare, general, annee, mois, jour, sat
;-------------------------------------------------------------------------------
	nbdico = 256L
	dico = REPLICATE (0L,nbdico)
	FOR i=0L,nbdico-1 DO dico[i] = decompresse_log (i)

	p = get (general, 'p')

	;code = p[1,4,1]->get_data3d(['All'],['All'],'y',0,'x','',str_to_date('1 1 2007'),str_to_date('2 1 2007'),3,999,'','',xmin_data,xmin_next,xmoy_data,xmax_data,ymin_data,ymoy_data,ymax_data,indy,zdata,produit1)
	produit_bin = p[ 1,4,sat] ; dist
	produit_cdf = p[ 9,4,sat] ; DIST
	;produit_bin = p[ 2,4,sat] ; disb
	;produit_cdf = p[10,4,sat] ; DISB
	date1 = val_to_str(jour)+' '+val_to_str(mois)+' '+val_to_str(annee)
	date2 = date1 + ' 23 59 59.999'
	code_bin = produit_bin->get_data(str_to_date(date1),str_to_date(date2),/exact1,/exact2,data_bin)
	code_cdf = produit_cdf->get_data(str_to_date(date1),str_to_date(date2),/exact1,/exact2,data_cdf)
	PRINT,date1 + ' : ' + 'code_bin='+val_to_str(code_bin)+'  code_cdf='+val_to_str(code_cdf), format='(A,$)'
	IF code_bin NE 1 OR code_cdf NE 1 THEN BEGIN
		PRINT, ''
		STOP
		RETURN
	END

	date_bin = data_bin.date
	date_cdf = data_cdf.date

	IF N_ELEMENTS(data_cdf) NE N_ELEMENTS(data_bin) THEN BEGIN
		PRINT, '  pb N_ELEMENTS'
		STOP
		RETURN
	END

	diff = date_bin - date_cdf
	indpb = WHERE (diff NE 0)
	IF indpb[0] EQ -1 THEN BEGIN
		PRINT,'  date=ok',format='(A,$)' 
	END ELSE BEGIN
		PRINT,'  date=pb'
		STOP
		RETURN
	END

	coups_bin = dico[data_bin.data]
	coups_cdf = data_cdf.data
	diff = coups_bin - coups_cdf
	IF indpb[0] EQ -1 THEN BEGIN
		PRINT,'  coups=ok',format='(A)' 
	END ELSE BEGIN
		PRINT,'  coups=pb'
		STOP
		RETURN
	END

	PRINT

END


;-------------------------------------------------------------------------------
PRO stereo_compare_cdf_bin
;------------------------------------------------------------------------------
	COMMON COMMON_CL, general
	;FOR sat=1L,2 DO BEGIN
	FOR sat=2L,2 DO BEGIN
		FOR tmp=str_to_date('28 10 2006'),str_to_date('1 2 2008'), 86400*1000d DO BEGIN
			date_to_tu, tmp, annee, mois, jour, heure, minute, seconde
			compare, general, annee, mois, jour, sat
		END
	END

END

