;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: spectro__define.pro,v $, v $Revision: 1.12 $
;
;	Date	: $Date: 2020/11/06 09:38:47 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO spectro::spectro_setproperty,	$
;-------------------------------------------------------------------------------
	zmin=zmin, 			$	; LINT_PROTOTYPE input
	zmax=zmax, 			$	; LINT_PROTOTYPE input
	zauto=zauto				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Utiliser pour modifier la proprit zmin, zmax ou zauto.
;-------------------------------------------------------------------------------

	IF N_ELEMENTS (zmin)  NE 0 THEN self.zmin  = zmin
	IF N_ELEMENTS (zmax)  NE 0 THEN self.zmax  = zmax
	IF N_ELEMENTS (zauto) NE 0 THEN self.zauto = zauto

END

;-------------------------------------------------------------------------------
FUNCTION spectro::spectro_getproperty,	$
;-------------------------------------------------------------------------------
	zmin=zmin, 			$	; LINT_PROTOTYPE input
	zmax=zmax				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne la proprit zmin ou zmax.
;-------------------------------------------------------------------------------

	IF N_ELEMENTS (zmin) NE 0 THEN RETURN, self.zmin
	IF N_ELEMENTS (zmax) NE 0 THEN RETURN, self.zmax

END


;-------------------------------------------------------------------------------
PRO spectro::spectro_ajouter,	$
;-------------------------------------------------------------------------------
	image,			$	; LINT_PROTOTYPE input
	produit,		$	; LINT_PROTOTYPE input
	utilise,		$	; LINT_PROTOTYPE input
	b1b2b3				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ajoute ou rajoute des donnes spectro.
;-------------------------------------------------------------------------------

	IF PTR_VALID(self.image) THEN BEGIN
		ind = WHERE(utilise EQ 1)
		IF ind[0] NE -1 THEN (*self.image)[ind,*] = image[ind,*]
		IF ind[0] NE -1 THEN (*self.produit)[ind] = produit[ind]
	END ELSE BEGIN
		self.image   = PTR_NEW (image)
		self.produit = PTR_NEW (produit)
		self.b1b2b3  = PTR_NEW (b1b2b3)
	END

END

;-------------------------------------------------------------------------------
PRO spectro::spectro_compute,	$
;-------------------------------------------------------------------------------
	diff=diff,		$	; LINT_PROTOTYPE input
	nb=nb				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Calcule le min et le max de l'image mmorise.
;-------------------------------------------------------------------------------

	IF ~PTR_VALID(self.image) THEN RETURN

	image = *self.image
	get_minmax, image, min, max, nb=nb, diff=diff

	self.zmin = min
	self.zmax = max

END

;-------------------------------------------------------------------------------
FUNCTION spectro::spectro_get_image,	$
;-------------------------------------------------------------------------------
	nb	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne l'image self.image.
;-------------------------------------------------------------------------------

	IF ~PTR_VALID(self.image) THEN RETURN, -1

	image = *self.image
	IF self.zauto THEN self -> spectro_compute, nb=nb, /diff	; indispensable ?

	RETURN, image

END


;-------------------------------------------------------------------------------
FUNCTION spectro::spectro_get_produit
;-------------------------------------------------------------------------------
; Retourne le produit self.produit.
;-------------------------------------------------------------------------------

	RETURN, PTR_VALID(self.image) ? *self.produit : -1

END

;-------------------------------------------------------------------------------
FUNCTION spectro::spectro_get_b1b2b3
;-------------------------------------------------------------------------------
; Retourne le b1b2b3 self.b1b2b3
;-------------------------------------------------------------------------------

	RETURN, PTR_VALID(self.image) ? *self.b1b2b3 : -1

END

;-------------------------------------------------------------------------------
PRO spectro::cleanup
;-------------------------------------------------------------------------------
; Supprime les donnes mmorises.
;-------------------------------------------------------------------------------

	PTR_FREE, self.image
	PTR_FREE, self.produit
	PTR_FREE, self.b1b2b3

END

;-------------------------------------------------------------------------------
FUNCTION spectro::init
;-------------------------------------------------------------------------------
; Constructeur de la classe "spectro".
;-------------------------------------------------------------------------------

	RETURN, 1

END

;-------------------------------------------------------------------------------
PRO spectro__define
;-------------------------------------------------------------------------------
; La classe "spectro" n'hrite pas.
;-------------------------------------------------------------------------------

	lint_unused = { spectro, 		$

		zmin:		0., 		$
		zmax:		0., 		$
		zauto:		0, 		$
		produit:	PTR_NEW (), 	$
		image:		PTR_NEW(), 	$
		b1b2b3:		PTR_NEW() 	$

	}

END
