;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: schemas__define.pro,v $, v $Revision: 1.12 $
;
;	Date	: $Date: 2015/09/10 14:15:59 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
PRO schemas::setproperty,  $
;-------------------------------------------------------------------------------
	nom,                    $       ; LINT_PROTOTYPE input
	val,                    $       ; LINT_PROTOTYPE input
	passaveold=passaveold           ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Permet de modifier la valeur d'une variable.
;-------------------------------------------------------------------------------

	IF nom EQ 'type' THEN BEGIN

		IF get(self,nom) EQ val THEN RETURN ; variable deja mise a jour

		info = get(self,val, /info)

		self -> obj::setproperty, 'schema', info, /info
		self -> obj::setproperty, 'schema', info[4]

        END

	self -> obj::setproperty, nom, val,passaveold=passaveold

END



;-------------------------------------------------------------------------------
FUNCTION schemas::init
;-------------------------------------------------------------------------------
; Constructeur de la classe "schemas".
;-------------------------------------------------------------------------------

	theta_cluster_codif = [ 									$
	'CLUSTER-CODIF Theta',										$
	' ',												$
	'                           ZGSE',								$
	' ',												$
	'                           /!\',								$
	'particles coming on         !      particles coming on',					$
	'anod 8 of g CODIF      \    !   /     anod 1 of G CODIF',					$
	'(-90<=ThetaGSE<=-67.5)  _/  !  \/     (-90<=ThetaGSE<=-67.5)',					$
	'                            !',								$
	'                          8 ! 1  ',								$
	'                        7   !   2 ',								$
	'                       6    !     3',								$
	'                      5     !      4',								$
	'       XGSE<----------------!--------',							$
	'                      4   / !      5',								$
	'                       3 /  !     6',								$
	'                        /2  !   7',								$
	'                       /  1 ! 8'  ,								$
	'                     !/_     ',								$
	'                   YGSE   /\   /\',								$
	'                          /     \ ',								$
	'    particles coming on           particles coming on',					$
	'    anod 1 of g CODIF             anod 8 of G CODIF',						$
	'    (67.5<=ThetaGSE<=90.0)        (67.5<=ThetaGSE<=90.0)',					$
	' ',												$
	'----------------------------------------------------------------------',			$
	'CODIF/g        Theta1 Theta2 Theta3 Theta4 Theta5 Theta6 Theta7 Theta8',			$
	'----------------------------------------------------------------------',			$
	'Thetamin GSE    67.50  45.00  22.50  00.00 -22.50 -45.00 -67.50 -90.00',			$
	'Thetamoy GSE    78.75  56.25  33.75  11.25 -11.25 -33.75 -56.25 -78.75',			$
	'Thetamax GSE    90.00  67.50  45.00  22.50  00.00 -22.50 -45.00 -67.50',			$
	'',												$
	'',												$
	'---------------------------------------------------------------------',			$
	'CODIF/G        Theta1 Theta2 Theta3 Theta4 Theta5 Theta6 Theta7 Theta8',			$
	'---------------------------------------------------------------------',			$
	'Thetamin GSE   -90.00 -67.50 -45.00 -22.50  00.00  22.50  45.00  67.50',			$
	'Thetamoy GSE   -78.75 -56.25 -33.75 -11.25  11.25  33.75  56.25  78.75',			$
	'Thetamax GSE   -67.50 -45.00 -22.50  00.00  22.50  45.00  67.50  90.00']


	phi_cluster_codif = [ 										$
	'CLUSTER-CODIF Phi',										$
	'With phase = 75/1024',										$
	'                                                                  ',				$
	'                                                                  ',				$ 
	'                                                                  ',				$
	'                             Dawn                                 ',				$
	'                              !                                   ',				$
	'                              D                                   ',				$
	'                         D    !    D                              ',				$
	'                      D      11       T                           ',				$
	'                           10 ! 12                                ',				$
	'                    S    09   !   13    T                         ',				$
	'  \!/                   08    !     14                            ',				$
	' --O--Sun XGSE<---S---07------!------15--T------------   Tail     ',				$
	'  /!\                   06    !     16                            ',				$
	'                    S    05   !   01    T  !/                     ',				$
	'                        /\ 04 ! 02          - sc rotation         ',				$
	'                      S /    03       D                           ',				$
	'  particles coming on     D   !    D                              ',				$
	'  phi 5 of G CODIF            D                                   ',				$
	'  (213<=PhiGSE<=235)          !                                   ',				$
	'                              !                                   ',				$
	'                             \!/                                  ',				$
	'                                                                  ',				$
	'                             YGSE                                 ',				$
	'                                                                  ',				$
	'                             Dusk                                 ',				$
	'                                                                  ',				$
	'----------------------------------------------------------------------',			$
	'CODIF/G          Phi5     Phi6     Phi7     Phi8',						$
	'----------------------------------------------------------------------',			$
	'Phi GSE MIN  213.3328 190.8328 168.3328 145.8328',						$
	'Phi GSE MOY  224.5828 202.0828 179.5828 157.0828',						$
	'Phi GSE MAX  235.8328 213.3328 190.8328 168.3328',						$
	' ', 												$
	'G and g are in opposite direction, so the difference between G and', 				$
	'g phi angle is 180deg.' ]

	theta_cluster_hia = [ 										$
	'CLUSTER-HIA Theta',										$
	' ',												$ 
	'                           ZGSE',								$
	' ',												$
	'                           /!\',								$
	'particles coming on         !      particles coming on',					$
	'anod 8 of g HIA             !   /     anod 1 of G HIA',					$
	'(-22.5<=ThetaGSE<=-16.875)  !  \/     (-90<=ThetaGSE<=-67.5)',					$
	'                            !',								$
	'                 \          ! 1  ',								$
	'                  _/        !   2 ',								$
	'                       7/8  !     3',								$
	'                      5/6   !      4',								$
	'       XGSE<----------------!--------',							$
	'                      3/4  /!      5',								$
	'                      1/2 / !     6',								$
	'                        /   !   7',								$
	'              /\       /    ! 8'  ,								$
	'              /      !/_     ',								$
	'                   YGSE        /\',								$
	'                                \ ',								$
	'    particles coming on           particles coming on',					$
	'    anod 1 of g HIA               anod 8 of G HIA',						$
	'    (16.875<=ThetaGSE<=22.5)        (67.5<=ThetaGSE<=90.0)',					$
	' ',												$
	'--------------------------------------------------------------------------------------',	$
	'HIA/g          Theta1   Theta2   Theta3   Theta4   Theta5   Theta6   Theta7   Theta8',		$
	'--------------------------------------------------------------------------------------',	$
	'Thetamin GSE    16.8750  11.2500  05.6250  00.0000 -05.6250 -11.2500 -16.8750 -22.5000',	$
	'Thetamoy GSE    19.6875  14.0625  08.4375  02.8125 -02.8125 -08.4375 -14.0625 -19.6875',	$
	'Thetamax GSE    22.5000  16.8750  11.2500  05.6250  00.0000 -05.6250 -11.2500 -16.8750',	$
	'',												$
	'',												$
	'--------------------------------------------------------------------------------------',	$
	'HIA/G          Theta1   Theta2   Theta3   Theta4   Theta5   Theta6   Theta7   Theta8',		$
	'--------------------------------------------------------------------------------------',	$
	'Thetamin GSE   -90.0000 -67.5000 -45.0000 -22.5000  00.0000  22.5000  45.0000  67.5000',	$
	'Thetamoy GSE   -78.7500 -56.2500 -33.7500 -11.2500  11.2500  33.7500  56.2500  78.7500',	$
	'Thetamax GSE   -67.5000 -45.0000 -22.5000  00.0000  22.5000  45.0000  67.5000  90.0000']

	phi_cluster_hia = [ 										$
	'CLUSTER-HIA Phi',										$
	'With phase = 75/1024                                           ',				$
	'                                                               ',				$
	'                                                               ',				$ 
	'                             Dawn                              ',				$
	'                                                               ',				$
	'                              !                                ',				$
	'                              D                                ',				$
	'                         D    !    D                           ',				$
	'                      D      03       T                        ',				$
	'                           02 ! 04                             ',				$
	'                    S    01   !   05    T                      ',				$
	'  \!/                  16     !     06                         ',				$
	' --O--Sun XGSE<---S---15------!------07--T------------   Tail  ',				$
	'  /!\                  14     !     08                         ',				$
	'                    S    13   !   09    T  !/                  ',				$
	'                        /\ 12 ! 10          - sc rotation      ',				$
	'                      S /    11       D                        ',				$
	'  particles coming on     D   !    D                           ',				$
	'  phi 13 of G HIA             D                                ',				$
	'  (213<=PhiGSE<=235)          !                                ',				$
	'                              !                                ',				$
	'                             \!/                               ',				$
	'                                                               ',				$
	'                             YGSE                              ',				$
	'                                                               ',				$
	'                             Dusk                              ',				$
	' ',												$
	'----------------------------------------------------------------------',			$
	'HIA/G           Phi13    Phi14    Phi15    Phi16',						$
	'----------------------------------------------------------------------',			$
	'Phi GSE MIN  213.3328 190.8328 168.3328 145.8328',						$
	'Phi GSE MOY  224.5828 202.0828 179.5828 157.0828',						$
	'Phi GSE MAX  235.8328 213.3328 190.8328 168.3328',						$
	' ']


	theta_dsp = [ 											$
	'DSP Theta',											$
	' ',												$ 
	'                           ZGSE',								$
	' ',												$
	'                           /!\',								$
	'particles coming on         !      particles coming on',					$
	'anod 1 of g HIA             !   /     anod 8 of G HIA',					$
	'(-22.5<=ThetaGSE<=-16.875)  !  \/     (-90<=ThetaGSE<=-67.5)',					$
	'                            !',								$
	'                 \          ! 8  ',								$
	'                  _/        !   7 ',								$
	'                       1/2  !     6',								$
	'                      3/4   !      5',								$
	'       XGSE<----------------!--------',							$
	'                      5/6  /!      4',								$
	'                      7/8 / !     3',								$
	'                        /   !   2',								$
	'              /\       /    ! 1'  ,								$
	'              /      !/_     ',								$
	'                   YGSE        /\',								$
	'                                \ ',								$
	'    particles coming on           particles coming on',					$
	'    anod 8 of g HIA               anod 1 of G HIA',						$
	'    (16.875<=ThetaGSE<=22.5)        (67.5<=ThetaGSE<=90.0)',					$
	' ',												$
	'--------------------------------------------------------------------------------------',	$
	'HIA/g          Theta8   Theta7   Theta6   Theta5   Theta4   Theta3   Theta2   Theta1',		$
	'--------------------------------------------------------------------------------------',	$
	'Thetamin GSE    16.8750  11.2500  05.6250  00.0000 -05.6250 -11.2500 -16.8750 -22.5000',	$
	'Thetamoy GSE    19.6875  14.0625  08.4375  02.8125 -02.8125 -08.4375 -14.0625 -19.6875',	$
	'Thetamax GSE    22.5000  16.8750  11.2500  05.6250  00.0000 -05.6250 -11.2500 -16.8750',	$
	'',												$
	'',												$
	'--------------------------------------------------------------------------------------',	$
	'HIA/G          Theta8   Theta7   Theta6   Theta5   Theta4   Theta3   Theta2   Theta1',		$
	'--------------------------------------------------------------------------------------',	$
	'Thetamin GSE   -90.0000 -67.5000 -45.0000 -22.5000  00.0000  22.5000  45.0000  67.5000',	$
	'Thetamoy GSE   -78.7500 -56.2500 -33.7500 -11.2500  11.2500  33.7500  56.2500  78.7500',	$
	'Thetamax GSE   -67.5000 -45.0000 -22.5000  00.0000  22.5000  45.0000  67.5000  90.0000']

	phi_dsp = [ 											$
	'DSP Phi',											$
	'With phase = 150/2048                                          ',				$
	'                                                               ',				$
	'                                                               ',				$ 
	'                             Dawn                              ',				$
	'                                                               ',				$
	'                              !                                ',				$
	'                              D                                ',				$
	'                         D    !    D                           ',				$
	'                      S      04       D                        ',				$
	'                           05 ! 03                             ',				$
	'                    S    06   !   02    T                      ',				$
	'  \!/                  07     !     01                         ',				$
	' --O--Sun XGSE<---S---08------!------16--T------------   Tail  ',				$
	'  /!\                  09     !     15     _                   ',				$
	'                    S    10   !   14    T   /!                 ',				$
	'                        /\ 11 ! 13            sc rotation      ',				$
	'                      D /    12       T                        ',				$
	'  particles coming on     D   !    D                           ',				$
	'  phi 10 of G HIA             D                                ',				$
	'  (213<=PhiGSE<=236)          !                                ',				$
	'                              !                                ',				$
	'                             \!/                               ',				$
	'                                                               ',				$
	'                             YGSE                              ',				$
	'                                                               ',				$
	'                             Dusk                              ',				$
	' ',												$
	'----------------------------------------------------------------------',			$
	'HIA/G           Phi10    Phi9     Phi8     Phi7',						$
	'----------------------------------------------------------------------',			$
	'Phi GSE MIN  213.867  191.367  167.867  146.367',						$
	'Phi GSE MOY  225.117  202.617  180.117  157.617',						$
	'Phi GSE MAX  236.367  213.867  191.367  168.867']

	frame_cluster_dsp = [										$
	'CLUSTER-CODIF Frame',										$
	'CLUSTER-HIA   Frame',										$
	'DSP           Frame',										$
	'                                                               ',				$
	'                              Z                                ',				$ 
	'                                                               ',				$
	'                             /!\                               ',				$
	'                              !                                ',				$
	'                              !                                ',				$
	'                              !                                ',				$
	'                              !     /|                         ',				$
	'                              !    / |                         ',				$
	'                              !   /  |                         ',				$
	'                              !  /   |                         ',				$
	'                              ! /_Theta (anode): latitude      ',				$
	'                              !/|\   |               \         ',				$
	'                              !--|---|---------------- Y       ',				$
	'                             / \/    |               /         ',				$
	'                            /__\\    |                         ',				$
	'                           /   / \   |                         ',				$
	'                          / Phi:  \  |                         ',				$
	'                         /longitude\ |                         ',				$
	'                        /           \|                         ',				$
	'                      |/_                                      ',				$
	'                                                               ',				$
	'                     X                                         ',				$
	'                                                               ',				$
	'                                                               ',				$
	' X = cos(Theta).cos(Phi)                                       ',				$
	' Y = cos(Theta).sin(Phi)                                       ',				$
	' Z = sin(Theta)                                                ']

	frame_stereo_swea = [										$
	'STEREO-SWEA Frame',										$
	'                                                               ',				$
	'                              X                                ',				$ 
	'                                                               ',				$
	'                             /!\                               ',				$
	'                              !                                ',				$
	'                              !                                ',				$
	'                              !                                ',				$
	'                              !     /|                         ',				$
	'                              !    / |                         ',				$
	'                              !   /  |                         ',				$
	'                              !  /   |                         ',				$
	'                              ! /_Phi: latitude                ',				$
	'                              !/|\   |               \         ',				$
	'                              !--|---|---------------- Z       ',				$
	'                             / \/    |               /         ',				$
	'                            /__\\    |                         ',				$
	'                           /   / \   |                         ',				$
	'                          / Theta:\  |                         ',				$
	'                         / (anode) \ |                         ',				$
	'                        / longitude \|                         ',				$
	'                      |/_                                      ',				$
	'                                                               ',				$
	'                     Y                                         ',				$
	'                                                               ',				$
	'                                                               ',				$
	' X = sin(Phi)                                                  ',				$
	' Y = cos(Phi).cos(Theta)                                       ',				$
	' Z = cos(Phi).sin(Theta)                                       ']

	frame_maven_swea = [										$
	'MAVEN-SWEA Frame',										$
	'                                                               ',				$
	'                              ZSWEA                            ',				$ 
	'                                                               ',				$
	'                             /!\                               ',				$
	'                              !                                ',				$
	'                              !                                ',				$
	'                              !                                ',				$
	'                              !     /|                         ',				$
	'                              !    / |                         ',				$
	'                              !   /  |                         ',				$
	'                              !  /   |                         ',				$
	'                              ! /_Phi: (deflection) latitude   ',				$
	'                              !/|\   |               \         ',				$
	'                              !--|---|---------------- YSWEA   ',				$
	'                             / \/    |               /         ',				$
	'                            /__\\    |                         ',				$
	'                           /   / \   |                         ',				$
	'                          / Theta:\  |                         ',				$
	'                         / (anode) \ |                         ',				$
	'                        / longitude \|                         ',				$
	'             anode15  |/_  anode0                              ',				$
	'                                                               ',				$
	'                     XSWEA                                     ',				$
	'                                                               ',				$
	'                                                               ',				$
	' X = cos(Phi).cos(Theta)                                       ',				$
	' Y = cos(Phi).sin(Theta)                                       ',				$
	' Z = sin(Phi)                                                  ']

	frame_maven_static = [										$
	'MAVEN-STATIC Frame',										$
	'                                                               ',				$
	'                              ZSTATIC                          ',				$ 
	'                                                               ',				$
	'                             /!\                               ',				$
	'                              !                                ',				$
	'                              !                                ',				$
	'                              !                                ',				$
	'                              !     /|                         ',				$
	'                              !    / |                         ',				$
	'                              !   /  |                         ',				$
	'                              !  /   |                         ',				$
	'                              ! /_Phi: (deflection) latitude   ',				$
	'                              !/|\   |               \         ',				$
	'                              !--|---|---------------- YSTATIC ',				$
	'                             / \/    |               /         ',				$
	'                            /__\\    |                         ',				$
	'                           /   / \   |                         ',				$
	'                          / Theta:\  |                         ',				$
	'                         / (anode) \ |                         ',				$
	'                        / longitude \|                         ',				$
	'                      |/_                                      ',				$
	'                                                               ',				$
	'                     XSTATIC                                   ',				$
	'                                                               ',				$
	'                                                               ',				$
	' X = cos(Phi).cos(Theta)                                       ',				$
	' Y = cos(Phi).sin(Theta)                                       ',				$
	' Z = sin(Phi)                                                  ']

	frame_maven_swia = [										$
	'MAVEN-SWIA Frame',										$
	'                                                               ',				$
	'                              ZSWIA                            ',				$ 
	'                                                               ',				$
	'                             /!\                               ',				$
	'                              !                                ',				$
	'                              !                                ',				$
	'                              !                                ',				$
	'                              !     /|                         ',				$
	'                              !    / |                         ',				$
	'                              !   /  |                         ',				$
	'                              !  /   |                         ',				$
	'                              ! /_Phi: (deflection) latitude   ',				$
	'                              !/|\   |               \         ',				$
	'                              !--|---|---------------- YSWIA   ',				$
	'                             / \/    |               /         ',				$
	'                            /__\\    |                         ',				$
	'                           /   / \   |                         ',				$
	'                          / Theta:\  |                         ',				$
	'                         / (anode) \ |                         ',				$
	'                        / longitude \|                         ',				$
	'                      |/_                                      ',				$
	'                                                               ',				$
	'                     XSWIA                                     ',				$
	'                                                               ',				$
	'                                                               ',				$
	' X = cos(Phi).cos(Theta)                                       ',				$
	' Y = cos(Phi).sin(Theta)                                       ',				$
	' Z = sin(Phi)                                                  ']

	frame_interball_electron = [									$
	'INTERBALL-ELECTRON Frame',									$
	'                                                               ',				$
	'                              X                                ',				$ 
	'                                                               ',				$
	'                             /!\                               ',				$
	'                              !                                ',				$
	'                              !                                ',				$
	'                              !                                ',				$
	'                              !     /|                         ',				$
	'                              !    / |                         ',				$
	'                              !   /  |                         ',				$
	'                              !  /   |                         ',				$
	'                              ! /_Theta (anode): latitude      ',				$
	'                              !/|\   |               \         ',				$
	'                              !--|---|---------------- Z       ',				$
	'                             / \/    |               /         ',				$
	'                            /__\\    |                         ',				$
	'                           /   / \   |                         ',				$
	'                          / Phi:  \  |                         ',				$
	'                         /longitude\ |                         ',				$
	'                        /           \|                         ',				$
	'                      |/_                                      ',				$
	'                                                               ',				$
	'                     Y                                         ',				$
	'                                                               ',				$
	'                                                               ',				$
	' X = sin(Theta)                                                ',				$
	' Y = cos(Theta).cos(Phi)                                       ',				$
	' Z = cos(Theta).sin(Phi)                                       ']

	frame_aspera_ima = [										$
	'ASPERA-IMA Frame',										$
	'                                                               ',				$
	'                              Ysc                              ',				$ 
	'                                                               ',				$
	'                             /!\                               ',				$
	'                              !                                ',				$
	'                              !                                ',				$
	'                              !                                ',				$
	'                              !     /|                         ',				$
	'                              !    / |                         ',				$
	'                              !   /  |                         ',				$
	'                              !  /   |                         ',				$
	'                              ! /_Phi|                         ',				$
	'                              !/|\   |               \         ',				$
	'                              !--|---|---------------- Xsc     ',				$
	'                             / \/  / |               /         ',				$
	'                            /   \|/_Theta                      ',				$
	'                           /     \   |                         ',				$
	'                          /       \  |                         ',				$
	'                         /         \ |                         ',				$
	'                        /           \|                         ',				$
	'                      |/_                                      ',				$
	'                                                               ',				$
	'                     Zsc                                       ',				$
	'                                                               ',				$
	'                                                               ',				$
	' X = cos(Phi)                                                  ',				$
	' Y = sin(Phi)                                                  ',				$
	' Z = cos(Phi).sin(Theta)                                       ']

	frame_mms_des = [										$
	'MMS-DES Frame (NGSE = Near GSE)',				$
	'                                                               ',				$
	'                              ZNGSE                            ',				$ 
	'                                                               ',				$
	'                             /!\                               ',				$
	'                              !                                ',				$
	'                              !                                ',				$
	'                              !                                ',				$
	'                              !     /|                         ',				$
	'                              !    / |                         ',				$
	'                              !   /  |                         ',				$
	'                              !  /   |                         ',				$
	'                              ! /_Theta (anode)                ',				$
	'                              !/|\   |               \         ',				$
	'                              !--|---|---------------- YNGSE   ',				$
	'                             / \/    |               /         ',				$
	'                            /__\\    |                         ',				$
	'                           /   / \   |                         ',				$
	'                          / Phi   \  |                         ',				$
	'                         /         \ |                         ',				$
	'                        /           \|                         ',				$
	'                      |/_                                      ',				$
	'                                                               ',				$
	'                     XNGSE                                     ',				$
	'                                                               ',				$
	'                                                               ',				$
	' X = cos(Theta).cos(Phi)                                       ',				$
	' Y = cos(Theta).sin(Phi)                                       ',				$
	' Z = sin(Theta)                                                ']


	types = [	'CLUSTER   CODIF      Theta',	$
			'CLUSTER   CODIF      Phi',	$
			'CLUSTER   CODIF      Frame',	$

			'CLUSTER   HIA        Theta',	$
			'CLUSTER   HIA        Phi',	$
			'CLUSTER   HIA        Frame',	$

			'DSP                  Theta',	$
			'DSP                  Phi',	$
			'DSP                  Frame',	$

			'STEREO    SWEA       Frame',	$

			'INTERBALL ELECTRON   Frame',	$

			'ASPERA    IMA        Frame',	$
			'MAVEN     SWEA       Frame',	$
			'MAVEN     STATIC     Frame',	$
			'MAVEN     SWIA       Frame',	$

			'MMS       DES        Frame']

	param = [ $

		{ var_obj, '',			types[ 0],	0,  PTR_NEW(['L2','2','30','LABEL_LEFT',theta_cluster_codif]),		'check_always_ok', PTR_NEW(), PTR_NEW(theta_cluster_codif[0])		},	$
		{ var_obj, '',			types[ 1],	0,  PTR_NEW(['L2','2','30','LABEL_LEFT',phi_cluster_codif]),		'check_always_ok', PTR_NEW(), PTR_NEW(phi_cluster_codif[0])		},	$
		{ var_obj, '',			types[ 2],	0,  PTR_NEW(['L2','2','30','LABEL_LEFT',frame_cluster_dsp]),		'check_always_ok', PTR_NEW(), PTR_NEW(frame_cluster_dsp[0])		},	$

		{ var_obj, '',			types[ 3],	0,  PTR_NEW(['L2','2','30','LABEL_LEFT',theta_cluster_hia]),		'check_always_ok', PTR_NEW(), PTR_NEW(theta_cluster_hia[0])		},	$
		{ var_obj, '',			types[ 4],	0,  PTR_NEW(['L2','2','30','LABEL_LEFT',phi_cluster_hia]),		'check_always_ok', PTR_NEW(), PTR_NEW(phi_cluster_hia[0])		},	$
		{ var_obj, '',			types[ 5],	0,  PTR_NEW(['L2','2','30','LABEL_LEFT',frame_cluster_dsp]),		'check_always_ok', PTR_NEW(), PTR_NEW(frame_cluster_dsp[0])		},	$

		{ var_obj, '',			types[ 6],	0,  PTR_NEW(['L2','2','30','LABEL_LEFT',theta_dsp]),			'check_always_ok', PTR_NEW(), PTR_NEW(theta_dsp[0])			},	$
		{ var_obj, '',			types[ 7],	0,  PTR_NEW(['L2','2','30','LABEL_LEFT',phi_dsp]),			'check_always_ok', PTR_NEW(), PTR_NEW(phi_dsp[0])			},	$
		{ var_obj, '',			types[ 8],	0,  PTR_NEW(['L2','2','30','LABEL_LEFT',frame_cluster_dsp]),		'check_always_ok', PTR_NEW(), PTR_NEW(frame_cluster_dsp[0])		},	$

		{ var_obj, '',			types[ 9],	0,  PTR_NEW(['L2','2','30','LABEL_LEFT',frame_stereo_swea]),		'check_always_ok', PTR_NEW(), PTR_NEW(frame_stereo_swea[0])		},	$

		{ var_obj, '',			types[10],	0,  PTR_NEW(['L2','2','30','LABEL_LEFT',frame_interball_electron]),	'check_always_ok', PTR_NEW(), PTR_NEW(frame_interball_electron[0])	},	$

		{ var_obj, '',			types[11],	0,  PTR_NEW(['L2','2','30','LABEL_LEFT',frame_aspera_ima]),		'check_always_ok', PTR_NEW(), PTR_NEW(frame_aspera_ima[0])		},	$
		{ var_obj, '',			types[12],	0,  PTR_NEW(['L2','2','30','LABEL_LEFT',frame_maven_swea]),		'check_always_ok', PTR_NEW(), PTR_NEW(frame_maven_swea[0])		},	$
		{ var_obj, '',			types[13],	0,  PTR_NEW(['L2','2','30','LABEL_LEFT',frame_maven_static]),		'check_always_ok', PTR_NEW(), PTR_NEW(frame_maven_static[0])		},	$
		{ var_obj, '',			types[14],	0,  PTR_NEW(['L2','2','30','LABEL_LEFT',frame_maven_swia]),		'check_always_ok', PTR_NEW(), PTR_NEW(frame_maven_swia[0])		},	$

		{ var_obj, '',			types[15],	0,  PTR_NEW(['L2','2','30','LABEL_LEFT',frame_mms_des]),		'check_always_ok', PTR_NEW(), PTR_NEW(frame_mms_des[0])		},	$

		{ var_obj, 'Type:Type',		'type',		1,  PTR_NEW(['L1','2','30','LABEL_LEFT',types]),			'check_always_ok', PTR_NEW(), PTR_NEW('???')				},	$
		{ var_obj, 'Schema:Schema',	'schema',	2,  PTR_NEW(),								'check_always_ok', PTR_NEW(), PTR_NEW('')				}]


	code = self -> obj::init (1, -1, -1, param,/saisissable,/nonbloquant)

	RETURN, code

END

;-------------------------------------------------------------------------------
PRO schemas__define
;-------------------------------------------------------------------------------
; La classe "schemas" hrite de "obj".
;-------------------------------------------------------------------------------

	lint_unused = { schemas,	$

		INHERITS obj 		$

	}

END
