;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: productsinfo__define.pro,v $, v $Revision: 1.19 $
;
;	Date	: $Date: 2014/03/12 17:12:38 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
PRO productsinfo::setproperty,	$
;-------------------------------------------------------------------------------
	nom,			$	; LINT_PROTOTYPE input
	val, 			$	; LINT_PROTOTYPE input
	passaveold=passaveold		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Permet de modifier une variable.
;-------------------------------------------------------------------------------

	IF nom EQ 'experiment' THEN BEGIN

		IF get(self,nom) EQ val THEN RETURN ; variable deja mise a jour

		info = get(self,val, /info)

		self -> obj::setproperty, 'products', info, /info
		self -> obj::setproperty, 'products', info[4]

	END

	self -> obj::setproperty, nom, val,passaveold=passaveold

END

;-------------------------------------------------------------------------------
PRO productsinfo::cleanup
;-------------------------------------------------------------------------------
; Destructeur de la classe "productinfos".
;-------------------------------------------------------------------------------

	self -> obj::cleanup

END

;-------------------------------------------------------------------------------
FUNCTION productsinfo::init,	$
;-------------------------------------------------------------------------------
	general	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Constructeur de la classe "productsinfo".
;-------------------------------------------------------------------------------

	exls = get_experiment_list()
	ind = WHERE(exls.productsinfo EQ 1)
	experiment_list = exls[ind]
	experiment_list = experiment_list[SORT(experiment_list.experience)]
	experiment_noms = REPLICATE ('', N_ELEMENTS(experiment_list))
	FOR k=0L,N_ELEMENTS(experiment_list)-1 DO experiment_noms[k] = corriger_nomchamp (experiment_list[k].experience)

	exp = 1
	param = [ $
		{ var_obj, 'Experiment: Experiment',	'experiment',	exp,	PTR_NEW(['L1','2','30','LABEL_LEFT',experiment_noms]),	'check_always_ok', PTR_NEW(), PTR_NEW('???')	},	$
		{ var_obj, 'Products: Products', 	'products', 	exp+1,	PTR_NEW(), 						'check_always_ok', PTR_NEW(), PTR_NEW('')	}	]

	chaine = ['L2','2','30','LABEL_LEFT']
	FOR k=0L,N_ELEMENTS(experiment_list)-1 DO BEGIN 
		exp = experiment_noms[k]
		comm = *experiment_list[k].commentaire
		ind = WHERE (comm NE '')
		IF ind[0] NE -1 THEN BEGIN
			comm = comm[ind]
			param = [ param, { var_obj, exp+':', exp, 0, PTR_NEW([chaine,comm]), 'check_always_ok', PTR_NEW(), PTR_NEW(comm[0]) }]
		END
	END

	code = self -> obj::init (1, -1, -1, param,/saisissable,/nonbloquant,general=general)

	set, self, 'experiment', experiment_noms[0]

	RETURN, code

END

;-------------------------------------------------------------------------------
PRO productsinfo__define
;-------------------------------------------------------------------------------
; La classe "produtcsinfo" hrite de "obj".
;-------------------------------------------------------------------------------

	lint_unused = { productsinfo, 	$

		INHERITS obj 		$

	}

END
