;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: printer__define.pro,v $, v $Revision: 1.8 $
;
;	Date	: $Date: 2014/03/12 17:12:25 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO printer::setproperty,	$
;-------------------------------------------------------------------------------
	nom,			$	; LINT_PROTOTYPE input
	val,			$	; LINT_PROTOTYPE input
	passaveold=passaveold		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affecte une nouvelle valeur  une variable.
;-------------------------------------------------------------------------------

	IF nom EQ 'nbvar' THEN BEGIN

		FOR i=1L,val DO BEGIN
			var = 'printer'+val_to_str(i)
			IF self -> getnovar(var) EQ -1 THEN self -> printer_add, i
		END
		FOR i=val+1,get(self,'nbvar') DO self -> remove, 'printer'+val_to_str(i)

	END

	self -> obj::setproperty, nom, val, passaveold=passaveold

END


;-------------------------------------------------------------------------------
PRO printer::printer_add,	$
;-------------------------------------------------------------------------------
	i	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Rajoute une variable printer"i".
;-------------------------------------------------------------------------------

	cmd = !VERSION.OS EQ 'linux' ? 'lpr -P xxx' : 'lp -c -d xxx'
	param = { var_obj, 'Printer'+val_to_str(i)+':Printer '+val_to_str(i), 'printer'+val_to_str(i), 1+i, PTR_NEW(['TE','2','30']), 'check_always_ok', PTR_NEW(), PTR_NEW(cmd) }
	self -> obj::add, param

END

;-------------------------------------------------------------------------------
FUNCTION printer::check
;-------------------------------------------------------------------------------
; Rien  vrifier.
;-------------------------------------------------------------------------------

	RETURN, ''

END

;-------------------------------------------------------------------------------
FUNCTION printer::init
;-------------------------------------------------------------------------------
; Constructeur de la classe "printer".
;-------------------------------------------------------------------------------

	param = [ $
		{ var_obj, 'Nbprinters: Nb Printers', 'nbvar', 1, PTR_NEW(['IN','2','2']), 'check_supegal', PTR_NEW([1]), PTR_NEW (1) } $
	]

	code = self -> obj::init (1,-1,-1,param,/saisissable)

	set, self, 'nbvar', 1

	RETURN, code

END

;-------------------------------------------------------------------------------
PRO printer__define
;-------------------------------------------------------------------------------
; La classe "printer" hrite de "obj".
;-------------------------------------------------------------------------------

	lint_unused = { printer, 	$

		INHERITS obj 		$

	}

END
