;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: para__define.pro,v $, v $Revision: 1.20 $
;
;	Date	: $Date: 2017/12/07 10:21:49 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
FUNCTION para::init,	$
;-------------------------------------------------------------------------------
	nomfichier	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Constructeur de la classe "para".
;-------------------------------------------------------------------------------

	IF ~ouvrir_lecture_ok (nomfichier,fd) THEN RETURN, 0

	param = [ $
		{ var_obj, '', 'Satellite'		, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('1')		}, $
		{ var_obj, '', 'Annee'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'Mois'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'Jour'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'Site'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'Niveau_trace'		, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'PPD_file'		, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'ORBIT_file'		, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'COD_12'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'COD_13'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'COD_15'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'COD_16'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'COD_17'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'COD_18'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'COD_19'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'COD_20'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'COD_21'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'COD_22'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'COD_29'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'COD_47'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'COD_49'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'HIA_05'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'HIA_06'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'HIA_08'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'HIA_10'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'HIA_14'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'HIA_15'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'HIA_16'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'HIA_17'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'HIA_21'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'HIA_22'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'HIA_23'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'HIA_24'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'COD_SPECTRO'		, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'HIA_SPECTRO'		, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $

		{ var_obj, '', 'Nomcl'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'Nomps'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'Temps_debut'		, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'Temps_fin'		, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'Nombre_de_vues'		, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('1')		}, $
		{ var_obj, '', 'Orientation'		, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'Ascii'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'Cef'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'Cdf'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'Netcdf'			, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'Votable'		, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'Jour_unique'		, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('0')		}, $
		{ var_obj, '', 'Local_directory'	, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('0')		}, $
		{ var_obj, '', 'Timeout'		, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('31536000')	}, $ ; nb de secondes dans une annee
		{ var_obj, '', 'Supprimer_image_vide'	, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('0')		}, $ 
		{ var_obj, '', 'Time_Table'		, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $ 
		{ var_obj, '', 'Getdata'		, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'Web_service'		, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'Parameter_id'		, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}, $
		{ var_obj, '', 'Time_Comment'		, 0, PTR_NEW(), '', PTR_NEW(), PTR_NEW ('*')		}  $
	]

	code = self -> obj::init (0,-1,-1,param)

	str = ''
	WHILE ~EOF(fd) DO BEGIN
		READF,fd,str
		res = STRSPLIT (str, /EXTRACT)
		ind = WHERE (res NE '')
		IF N_ELEMENTS(ind) GE 3 THEN BEGIN
			nom = res[ind[0]]
			val = N_ELEMENTS(ind) EQ 3 ? res[ind[2]] : res[ind[2:*]]
			set, self, nom, val
		END
	END
	FREE_LUN,fd

	RETURN, code

END

;-------------------------------------------------------------------------------
PRO para__define
;-------------------------------------------------------------------------------
; La classe "para" hrite de "obj".
;-------------------------------------------------------------------------------

	lint_unused = { para,	$

		INHERITS obj	$

	}

END
