;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: pal__define.pro,v $, v $Revision: 1.15 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
FUNCTION pal::true,	$
;-------------------------------------------------------------------------------
	nbcolors=nbcolors	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne 1 si on travaille avec des vraies couleurs, 0 si on travaille avec une table de couleurs.
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(nbcolors) NE 0 THEN BEGIN

		RETURN, libplot_get(/D_N_COLORS) GT 256

	END ELSE IF libplot_get(/D_NAME) EQ 'PS' THEN BEGIN

		RETURN, 0

	END ELSE BEGIN

		RETURN, get (self,'true')

	END

END

;-------------------------------------------------------------------------------
FUNCTION pal::code,	$
;-------------------------------------------------------------------------------
	i,		$	; LINT_PROTOTYPE input
	rvb=rvb			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne la couleur correspondant  une valeur.
;-------------------------------------------------------------------------------

	IF self -> true() THEN BEGIN
		RETURN, KEYWORD_SET(rvb) ? [(*self.rvb)[i].r,(*self.rvb)[i].v,(*self.rvb)[i].b] : (*self.codage)[i]
	END ELSE BEGIN
		RETURN, i
	END

END

;-------------------------------------------------------------------------------
PRO pal::majcodage,	$
;-------------------------------------------------------------------------------
	ind		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Met  jour la variable interne "codage".
;-------------------------------------------------------------------------------

	(*self.codage)[ind] = rvb2no ((*self.rvb)[ind].r, (*self.rvb)[ind].v, (*self.rvb)[ind].b)
END

;-------------------------------------------------------------------------------
PRO pal::free_rvb,	$
;-------------------------------------------------------------------------------
	translation	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Supprime les allocations des indices de couleurs dfinis dans translation.
;-------------------------------------------------------------------------------

	(*self.nb)[translation]--
	self -> majdispo

END


;-------------------------------------------------------------------------------
FUNCTION pal::pal_alloc_rvb,	$
;-------------------------------------------------------------------------------
	rvb,		$	; LINT_PROTOTYPE input
	shade_rvb,	$	; LINT_PROTOTYPE input
	translation		; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Rajoute  la palette les couleurs dfinies dans le tableau de structure rvb et retourne dans translation les indices de ces couleurs.
;
; shade_rvb: 
;   0 pour optimiser aux mieux les nouvelles couleurs
;   1 palette  utiliser avec SHADE_SURF. Toutes les couleurs alloues doivent
;     se trouver les unes apres les autres. C'est  dire que translation doit
;     valoir INDGEN(N_ELEMENTS(rvb))+translation[0]
;-------------------------------------------------------------------------------

	nb_ask = N_ELEMENTS(rvb)
	translation = REPLICATE (-1L,nb_ask)

	codage_new = rvb2no (rvb.r, rvb.v, rvb.b)

	; Recherche si certaines couleurs demandes ne sont pas dja alloues
	IF shade_rvb EQ 0 THEN BEGIN
		FOR i=0L,nb_ask-1 DO BEGIN
			ind = WHERE (*self.codage EQ codage_new[i] AND *self.nb GE 1)
			IF ind[0] NE -1 THEN BEGIN
				translation[i] = ind[0]
				(*self.nb)[ind[0]]++
			END
		END
	END ELSE BEGIN
		trouve = -1
		FOR deb=0L,N_ELEMENTS(*self.codage)-nb_ask DO BEGIN
			IF trouve EQ -1 THEN BEGIN
				tmp = (*self.nb)[deb:deb+nb_ask-1]
				ind = WHERE (tmp LT 1)
				IF ind[0] EQ -1 THEN BEGIN
					tmp = (*self.codage)[deb:deb+nb_ask-1]-codage_new
					ind = WHERE (tmp NE 0)
					IF ind[0] EQ -1 THEN trouve = deb
				END
			END
		END

		IF trouve EQ -1 THEN BEGIN
			translation = REPLICATE (-1L,nb_ask)
		END ELSE BEGIN
			translation = trouve+INDGEN(nb_ask)
			(*self.nb)[translation]++
		END
	END

	; Tableaux des nouvelles couleurs  rajouter dans la palette
	ind_new = WHERE (translation EQ -1L,nb_new) ; Il y en a nb_new

	IF nb_new GT 0 THEN BEGIN

		IF shade_rvb EQ 0 THEN BEGIN
			; Si une nouvelle couleur apparait plusieurs fois dans rvb, il ne faut la rajouter qu'une seule fois!
			codage = codage_new[ind_new]
			induniq = UNIQ (codage, SORT(codage))
			nb_new_optimise  = N_ELEMENTS(induniq)
			ind_new_optimise = ind_new[induniq[SORT(induniq)]]
		END ELSE BEGIN
			nb_new_optimise  = nb_new
			ind_new_optimise = ind_new
		END

		ind_vide = WHERE (*self.nb EQ 0,nb_vide)
		IF nb_new_optimise GT nb_vide THEN BEGIN
			translation[*] = 0L ; toutes les couleurs sont mises au Noir
			RETURN, 0
		END
		ind_modif = INDGEN(nb_new_optimise)
		(*self.rvb)[ind_vide[ind_modif]] = rvb[ind_new_optimise]

		self -> majcodage, ind_vide[ind_modif]
		translation[ind_new_optimise] = ind_vide[ind_modif]
		(*self.nb)[ind_vide[ind_modif]] = 1+(*self.nb)[ind_vide[ind_modif]]

		IF shade_rvb EQ 0 THEN BEGIN
			; on s'occupe maintenant des nouvelles couleurs dupliques
			indidem = WHERE (translation EQ -1L, nbidem)
			IF nbidem NE 0 THEN BEGIN
				FOR i=0L,nbidem-1 DO BEGIN
					ind = WHERE (*self.codage EQ codage_new[indidem[i]] AND *self.nb GE 1)
					translation[indidem[i]] = ind[0]
					(*self.nb)[ind[0]] = 1+(*self.nb)[ind[0]]
				END
			END
		END

		libplot_tvlct, (*self.rvb).r, (*self.rvb).v, (*self.rvb).b
		self -> majdispo
	END

	RETURN, 1

END

;-------------------------------------------------------------------------------
PRO pal::majdispo
;-------------------------------------------------------------------------------
; Met  jour la variable interne "dispo".
;-------------------------------------------------------------------------------

	hash = self -> gethash()

	IF PTR_VALID (self.nb) THEN lint_unused = WHERE (*self.nb NE 0,nb) ELSE nb = 0
	setq, self, 'dispo', hash.dispo, getq(self,hash.max)-nb

END

;-------------------------------------------------------------------------------
PRO pal::get_rvb,	$
;-------------------------------------------------------------------------------
	r,	$	; LINT_PROTOTYPE output
	v,	$	; LINT_PROTOTYPE output
	b		; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne les couleurs r, v et b de la palette.
;-------------------------------------------------------------------------------

	ind = WHERE (*self.codage NE -1)
	r = (*self.rvb)[ind].r
	v = (*self.rvb)[ind].v
	b = (*self.rvb)[ind].b

END

;-------------------------------------------------------------------------------
PRO pal::cleanup
;-------------------------------------------------------------------------------
; Destructeur de la classe "pal".
;-------------------------------------------------------------------------------

	PTR_FREE, self.rvb
	PTR_FREE, self.codage
	PTR_FREE, self.nb

	self -> obj::cleanup

END

;-------------------------------------------------------------------------------
FUNCTION pal::init,	$
;-------------------------------------------------------------------------------
	int	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Constructeur de la classe "pal" (ne fait pas d'allocations de couleurs si int==1).
;-------------------------------------------------------------------------------

	param = [ $
		{ var_obj, '', 	'true', 	0, PTR_NEW(), 	'', 	PTR_NEW(), PTR_NEW(0)	}, 	$
		{ var_obj, '', 	'max', 		0, PTR_NEW(), 	'', 	PTR_NEW(), PTR_NEW(0)	}, 	$
		{ var_obj, '', 	'private', 	0, PTR_NEW(), 	'', 	PTR_NEW(), PTR_NEW(0)	}, 	$
		{ var_obj, '', 	'dispo', 	0, PTR_NEW(), 	'', 	PTR_NEW(), PTR_NEW(0)	} 	$
	]

	lint_unused = self -> obj::init (1,-1,-1,param,/saisissable)

	IF int EQ 1 THEN RETURN, 1

	libplot_tvlct, [0], [0], [0] ; pour que !D.N_COLORS retourne une valeur correcte
	!P.COLOR = 1 ; Couleur par defaut pour les textes
	max = MIN([256,libplot_get(/D_N_COLORS)])
	set, self, 'max', max

	rvb = [ { var_pal, 255, 255, 255 }, $  ;  0	Blanc
		{ var_pal,   0,   0,   0 }, $  ;  1	Noir

		{ var_pal,   0,   0, 255 }, $  ;  2	Bleu fonce 	3D FONCE
		{ var_pal, 205,   0,   0 }, $  ;  3	Rouge		3D FONCE
		{ var_pal,   0, 154, 205 }, $  ;  4	Bleu clair	3D FONCE
	
		{ var_pal,  58,  95, 205 }, $  ;  5	Bleu fonce	3D NORMAL
		{ var_pal, 255,  20, 147 }, $  ;  6	Rouge		3D NORMAL
		{ var_pal,   0, 255, 255 }, $  ;  7	Bleu clair	3D NORMAL

		{ var_pal, 152, 152, 255 }, $  ;  8	Bleu fonce 	3D CLAIR
		{ var_pal, 255, 128, 192 }, $  ;  9	Rouge 		3D CLAIR
		{ var_pal, 128, 255, 255 }, $  ; 10	Bleu clair	3D CLAIR
		{ var_pal, 255, 255, 255 }]    ; 11	Blanc		cadre GDL pour forcer Bounding Box

	fichier_time_comment_config = (is_windows()  ? '.' : GETENV('HOME')) + "/.cl/time_comment.config"
	IF fichier_existe(fichier_time_comment_config) THEN BEGIN
		code = read_time_comment (fichier_time_comment_config, css1)
		css2 = ''
		IF code EQ 1 THEN BEGIN
			i1 = 0L
			l1 = 0L
			i2 = 0L
			l2 = 0L
			FOR i=0L,N_ELEMENTS(css1)-1 DO BEGIN
				ligne = css1[i]

				; Je vais mettre dans css2: type: variable1 valeur1 variable2 valeur2 ... variableN valeurN

				; 1er mot: type
				code = s_to_mot1 (ligne,i1,l1)
				IF code NE 0 THEN CONTINUE
				type = ""
				FOR j=i1,i1+l1-1 DO BEGIN ;  cause du fonctionnement de s_to_mot1
					c = STRMID(ligne,j,1)
					IF c EQ ':' THEN BEGIN
						type = STRMID(ligne,i1,j-i1)
						;PRINT, 'type=' + type
						css2 += type + ':' + STRING(2b)
						ligne = STRMID (ligne, j+1)
						BREAK
					END
				END
				IF type EQ "" THEN CONTINUE

				WHILE 1 DO BEGIN
					; mots suivants: mot = "valeur"
					code = s_to_mot1_egal_mot2 (ligne,i1,l1,i2,l2)
					IF code NE 0 THEN BREAK

					mot = STRMID(ligne,i1,l1)
					;PRINT, 'mot=' + mot

					valeur = STRMID(ligne,i2,l2)
					FOR j=i2,i2+l2-1 DO BEGIN ;  cause du fonctionnement de S_TO_MOT1_EGAL_MOT2
						c = STRMID(ligne,j,1)
						IF c EQ '"' THEN BEGIN
							l2 = j-i2
							BREAK
						END
					END
					valeur = STRMID(ligne,i2,l2)
					;PRINT, 'valeur=' + valeur

					FOR j=i2+l2+1,STRLEN(ligne)-1 DO BEGIN ; pour sauter le ','
						c = STRMID(ligne,j,1)
						IF c EQ ' ' OR c EQ STRING(9b) OR c EQ ',' THEN BEGIN
						END ELSE BEGIN
							BREAK
						END
					END
					ligne = STRMID (ligne, j)

					IF STRLOWCASE(mot) EQ "color" THEN BEGIN
						READS, valeur, format="(Z2,Z2,Z2)", r, g, b
						rvb = [ rvb, { var_pal, r, g, b } ]
						valeur = val_to_str(N_ELEMENTS(rvb)-1)
					END

					css2 += mot + STRING(2b)
					css2 += valeur + STRING(2b)
				END
				css2 += STRING(1b)
			END
			!TIME_COMMENT.css = css2
		END
	END

	nb_alloc = N_ELEMENTS(rvb)
	set, self, 'private', nb_alloc
	nb_max = get(self,'max')
	self.nb = PTR_NEW (REPLICATE(0L,nb_max))
	IF nb_alloc LE nb_max THEN (*self.nb)[0:nb_alloc-1] = 1

	self -> majdispo
	nb_free = get(self,'dispo')
	IF nb_free LT 0 THEN RETURN,0

	rvbfill = REPLICATE ({ var_pal, 0, 0, 0 }, nb_free)
	rvb = [rvb,rvbfill]
	self.rvb = PTR_NEW(rvb)
	self.codage = PTR_NEW(REPLICATE(-1L,nb_max))
	self -> majcodage, INDGEN(nb_alloc)

	libplot_tvlct, (*self.rvb).r, (*self.rvb).v, (*self.rvb).b

	RETURN, 1

END

;-------------------------------------------------------------------------------
PRO pal__define
;-------------------------------------------------------------------------------
; La classe "pal" hrite de "obj".
;-------------------------------------------------------------------------------

	; La structure var_pal est utilise dans init
	lint_unused = { var_pal,			$

			r:		0,		$
			v:		0,		$
			b:		0 		$

	}

	lint_unused = { pal, 				$

			INHERITS 	obj,		$
			rvb:		PTR_NEW(),	$
			codage:		PTR_NEW(),	$
			nb:		PTR_NEW()	$

	}

END
