;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: orbitogen__define.pro,v $, v $Revision: 1.19 $
;
;	Date	: $Date: 2016/04/22 08:48:00 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
FUNCTION orbitogen::check
;-------------------------------------------------------------------------------
; Vrifie les valeurs des variables.
;-------------------------------------------------------------------------------

	ret = self -> obj::check()
	IF ret NE '' THEN RETURN, ret

	ret = self -> obj::check_t1_t2('time_t1','time_t2')
	IF ret NE '' THEN RETURN, ret

	RETURN, ''

END

;-------------------------------------------------------------------------------
PRO orbitogen::setproperty,	$
;-------------------------------------------------------------------------------
	nom,			$	; LINT_PROTOTYPE input
	val,			$	; LINT_PROTOTYPE input
	passaveold=passaveold		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Appell pour modifier la valeur d'une variable.
;-------------------------------------------------------------------------------

	IF nom EQ 'nomcis' THEN BEGIN
		;PRINT, 'orbitogen::setproperty'
		create_products, val
	END

	IF nom EQ 'nomcis' OR nom EQ 'tabproduit' THEN BEGIN

		IF nom EQ 'tabproduit' THEN BEGIN
			IF N_ELEMENTS(val) NE 1 THEN val = get(self,'noproduit')
		END

		p = get (self.general, 'p')
		nbsat = N_ELEMENTS(p[0,0,*])-1
		nomcis = nom EQ 'nomcis' ? val : get(self,'nomcis')
		nocis = nomcis_string_to_val (nomcis)

		IF nom EQ 'nomcis' THEN BEGIN

			tabproduit = REPLICATE(0,N_ELEMENTS(p[*,nocis,1]))

			FOR i=0L,N_ELEMENTS(tabproduit)-1 DO BEGIN
				FOR j=1L,nbsat DO BEGIN
					produit = p[i,nocis,j]
					IF OBJ_VALID(produit) THEN BEGIN
						IF produit -> pgetproperty(/isorbito) THEN tabproduit[i] = 1
					END
				END
			END

			; On va essayer de retracer les mmes produits (sauf ceux qui n'existent plus)
			indok = WHERE(tabproduit EQ 1)
			IF indok[0] EQ -1 THEN RETURN

			ptr = val_to_str(indok)

			; Mise  jour de tabcommentaire
			; -----------------------------
			tabcommentaire = ['']
			FOR i=0L,N_ELEMENTS(indok)-1 DO BEGIN
				IF OBJ_VALID(p[LONG(indok[i]),nocis,1]) THEN BEGIN
					commentaire = p[LONG(indok[i]),nocis,1] -> pgetproperty (/commentaire)
					tabcommentaire = tabcommentaire[0] EQ '' ? [commentaire] : [tabcommentaire,commentaire]
				END
			END
			self -> obj::setproperty, 'tabcommentaire', tabcommentaire


			; Mise  jour de tabproduit
			; -------------------------
			info = [['L1','2','25','LABEL_LEFT'],ptr]
			self -> obj::setproperty, 'tabproduit', info, /info

			old_tabproduit = get (self,'tabproduit')
			new_tabproduit = ['null']
			FOR i=0L,N_ELEMENTS(old_tabproduit)-1 DO BEGIN
				old_tabproduit_ascii = STRSPLIT (old_tabproduit[i], /EXTRACT) ; transformation de la ligne en chaine de mots
				ind = WHERE (ptr EQ old_tabproduit_ascii[0])
				IF ind[0] NE -1 THEN BEGIN
					new_tabproduit = new_tabproduit[0] EQ 'null' ? [ptr[ind]] : [new_tabproduit,ptr[ind]]
				END
			END
			IF new_tabproduit[0] EQ 'null' THEN BEGIN
				new_tabproduit = ptr ; on retrace tous les produits dans tous les cas
			END
			self -> obj::setproperty, 'tabproduit', new_tabproduit[0]	; on prend un seul produit (Liste L1)

		END

		IF nom EQ 'nomcis' OR nom EQ 'tabproduit' THEN BEGIN

			; Quels champs peut-on tracer ?
			; -----------------------------

			produit = nom EQ 'tabproduit' ? val : get (self,'tabproduit') & produit = produit[0]
			cis = nomcis_string_to_val (nom EQ 'nomcis' ? val : get (self,'nomcis'))
			sat = 1
			IF OBJ_VALID(p[produit,cis,sat]) THEN BEGIN
				noms = p[produit,cis,sat] -> pgetproperty(/nom)
				IF N_ELEMENTS(noms) EQ 1 THEN BEGIN
					noms = ['Nothing']
				END ELSE BEGIN
					noms = noms[1:*] ; tous les champs sauf le premier (qui est le champ date)
				END
				noms = STRUPCASE (noms) ; noms en majuscule
				noms = '!3' + noms ; '!3' au debut de chaque nom
				self -> obj::setproperty, 'orbito_plot', [['L2','2','10','LABEL_LEFT'],noms], /info

				orbito_plot = get(self,'orbito_plot')
				; On ne va garder dans orbito_plot que les valeurs qui existent dans noms.
				; S'il n'en a aucune, on met tous les elements de noms dans orbito_plot
				indok = REPLICATE (0,N_ELEMENTS(orbito_plot))
				FOR i=0L,N_ELEMENTS(orbito_plot)-1 DO BEGIN
					ind = WHERE (noms EQ orbito_plot[i])
					indok[i] = ind[0] NE -1
				END
				indfinal = WHERE (indok EQ 1)
				orbito_plot = indfinal[0] EQ -1 ? noms : orbito_plot[indfinal]
				set, self, 'orbito_plot', orbito_plot
			END

		END

	END

	; Gestion fichiers ASCII_CEF_CDF: : traitement avant l'affectation de la valeur val  la variable nom
	; ---------------------------------------------------------------------------------------------------
	analyser_produit = nom EQ 'filename' OR nom EQ 'time_t1' OR nom EQ 'time_t2' OR nom EQ 'time_t1t2' OR nom EQ 'nosat' OR nom EQ 'remove_ext' OR nom EQ 'selection_date' OR nom EQ 'selection_data'
	IF analyser_produit THEN BEGIN
		filename = nom EQ 'filename' ? val : get(self,'filename')
		IF filename EQ '' OR filename EQ '.' THEN analyser_produit = 0 ; arrive pour les expriences ni ascii, ni cdf.
	END
	IF analyser_produit THEN BEGIN
		self -> update_produit_ascii_cef_cdf, 'timeseries', 0, nom, val
	END


	IF nom EQ 'time_t1t2' THEN BEGIN
		self -> obj::setproperty,'time_t1', val[0], passaveold=passaveold
		self -> obj::setproperty,'time_t2', val[1], passaveold=passaveold
	END ELSE BEGIN
		self -> obj::setproperty, nom, val,passaveold=passaveold
	END

	self -> obj::setproperty, nom, val,passaveold=passaveold

	; Gestion des fichiers ASCII_CDF_CDF: traitement aprs l'affectation de la valeur val  la variable nom
	; -----------------------------------------------------------------------------------------------------
	IF analyser_produit THEN BEGIN

		self -> finaliser_produit_ascii_cef_cdf, 0, 'filename'
	
	END

END

;-------------------------------------------------------------------------------
PRO orbitogen::compute
;-------------------------------------------------------------------------------
; Traitement effectu pour afficher un objet 'orbitogen'.
;-------------------------------------------------------------------------------

	fenetre = self.fenetre
	general = self.general

	hash = self -> gethash()
	hash_general = general -> gethash()

	p = getq(general,hash_general.p)
	nosat = LONG(getq(self,hash.nosat))

	ntrace = getq(general,hash_general.ntrace)
	IF ntrace GE 1 THEN BEGIN
		msg = self -> name()
		time_t1 = str_to_date(getq(self,hash.time_t1))
		time_t2 = str_to_date(getq(self,hash.time_t2))
		str = STRING(msg,' ',date_to_str(time_t1),' ',date_to_str(time_t2), FORMAT='(A,A,A,A,A)')
		cl_msg, general, str_bas=" "
		cl_msg, general, str_bas=str
	END

	orbito_rvb = { var_pal, r:getq(self,hash.orbito_color_r), v:getq(self,hash.orbito_color_v), b:getq(self,hash.orbito_color_b) } & orbito_coul = 0
	rvb = [orbito_rvb]

	cube = getq(self,hash.palette_cube) 
	IF cube NE 'No' AND cube NE 'True color' THEN BEGIN
		; On va quantifier les couleurs avec COLOR_QUAN et cube
		r = rvb.r & v = rvb.v & b = rvb.b
		image = INDGEN(N_ELEMENTS(rvb))
		nbcube = (STRSPLIT(cube,' ',/EXTRACT))[0]^(1./3)
		trans = COLOR_QUAN (r[image], v[image], b[image], r, v, b, cube=nbcube)
		rvb = REPLICATE ({ var_pal, r:0, v:0, b:0 }, N_ELEMENTS(r))
		rvb.r = r & rvb.v = v & rvb.b = b
	END ELSE BEGIN
		trans = INDGEN(N_ELEMENTS(rvb))
	END

	; on indique a fenetre les codes rvb dont on a besoin
	fenetre -> fsetproperty,rvb,/rvb

	; Orbitographie
	; -------------
	nom_output_sans_ext = get(general,'prefixe')+'obj'+val_to_str(self -> getno(/no))
	nomcis = getq(self,hash.nomcis)
	nocis = nomcis_string_to_val (nomcis)
	noproduit = getq(self,hash.tabproduit) & noproduit = noproduit[0]

	compute_orbito, self, fenetre, general, hash, hash_general, $
			p[noproduit,nocis,nosat], trans, orbito_coul, nom_output_sans_ext

END

;-------------------------------------------------------------------------------
PRO orbitogen::cleanup
;-------------------------------------------------------------------------------
; Destruction des donnes mmorises et des produits ASCII_CEF_CDF.
;-------------------------------------------------------------------------------

	nocis = nomcis_string_to_val (get (self, 'nomcis'))
	IF is_ascii (nocis) OR is_cdf (nocis) THEN BEGIN
		self -> obj::detruire_produit, nocis, 'noproduit'
	END

	self -> obj::cleanup

END

;-------------------------------------------------------------------------------
FUNCTION orbitogen::init,	$
;-------------------------------------------------------------------------------
	no,			$	; LINT_PROTOTYPE input
	container,		$	; LINT_PROTOTYPE input
	order,			$	; LINT_PROTOTYPE input
	general, 		$	; LINT_PROTOTYPE input
	orbtxt, 		$	; LINT_PROTOTYPE input
	noproduit			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Constructeur de la classe "orbitogen".
;-------------------------------------------------------------------------------

	; Initialisation des champs qui ne doivent pas contenir 0

	exls = get_experiment_list()
	experiment_list = exls[WHERE(exls.orbitogen EQ 1)].experience
	experiment_list = experiment_list[SORT(experiment_list)]
	nosat_list = get_nosat_list()
	nosat_list = val_to_str(INDGEN(N_ELEMENTS(nosat_list))+1)

	param = [ $
		{ var_obj, '',					'noproduit',		0,	PTR_NEW(),						'',				PTR_NEW(),	PTR_NEW (noproduit)			},	$
		{ var_obj, '', 					'tabcommentaire', 	0, 	PTR_NEW(), 						'check_always_ok', 		PTR_NEW(), 	PTR_NEW ([''])				},	$
		{ var_obj, '', 					'count2d', 		0, 	PTR_NEW(), 						'check_always_ok', 		PTR_NEW(), 	PTR_NEW (0)				}, 	$
		{ var_obj, '', 					'time_t1t2', 		0, 	PTR_NEW(), 						'check_always_ok', 		PTR_NEW(), 	PTR_NEW ('')				}, 	$
                { var_obj, 'ASCII_CEF_CDF:Remove extension ?',	'remove_ext', 		2, 	PTR_NEW(['DR','0','LABEL_TOP','CAA','THEMIS','No']),	'check_always_ok', 		PTR_NEW(), 	PTR_NEW ('No')				}, 	$
                { var_obj, 'Date selection', 			'selection_date',	2, 	PTR_NEW(['L1','0','5','LABEL_TOP','Automatic']), 	'check_always_ok', 		PTR_NEW(), 	PTR_NEW ('Automatic')			}, 	$
                { var_obj, '123D selection', 			'selection_data', 	2, 	PTR_NEW(['L2','2','5','LABEL_TOP','Automatic']), 	'check_always_ok', 		PTR_NEW(), 	PTR_NEW (['Automatic'])			}, 	$
                { var_obj, 'Input filename',			'filename', 		2, 	PTR_NEW(['CH','2','60']), 				'check_always_ok', 		PTR_NEW(), 	PTR_NEW ('')				},	$
                { var_obj, '',					'nbdata', 		2, 	PTR_NEW(['L1','0','15','LABEL_LEFT','0']), 		'check_always_ok', 		PTR_NEW(), 	PTR_NEW ('0')				},	$
                { var_obj, ' lines found between  ',		'firstdata', 		2, 	PTR_NEW(['L1','0','15','LABEL_LEFT','None']), 		'check_always_ok', 		PTR_NEW(), 	PTR_NEW ('None')			},	$
                { var_obj, ' and  ',				'lastdata', 		2, 	PTR_NEW(['L1','2','15','LABEL_LEFT','None']), 		'check_always_ok', 		PTR_NEW(), 	PTR_NEW ('None')			},	$
               ;{ var_obj, '', 					'noproduit', 		0, 	PTR_NEW(), 						'check_always_ok', 		PTR_NEW(), 	PTR_NEW (-1)				}, 	$
                { var_obj, 'Help',				'help_all', 		2, 	PTR_NEW(['L1','2','10','LABEL_LEFT','Nothing']), 	'check_always_ok', 		PTR_NEW(), 	PTR_NEW (['Nothing'])			},	$
		{ var_obj, 'Experiment: Experiment',		'nomcis',		3,	PTR_NEW(['L1','2','30','LABEL_LEFT',experiment_list]),	'check_always_ok',		PTR_NEW(),	PTR_NEW (experiment_list[0])		},	$
		{ var_obj, 'Products: Products', 		'tabproduit', 		4, 	PTR_NEW(['L1','2','20','LABEL_LEFT','1']), 		'check_always_ok', 		PTR_NEW(), 	PTR_NEW ('1')				},	$
		{ var_obj, 'Time:Start', 			'time_t1', 		5, 	PTR_NEW(['TE','0','23']), 				'check_strdate', 		PTR_NEW(), 	PTR_NEW ('29 06 1999 14 30 00.000')	}, 	$
		{ var_obj, 'End', 				'time_t2', 		5, 	PTR_NEW(['TE','2','23']), 				'check_strdate', 		PTR_NEW(), 	PTR_NEW ('29 06 1999 15 30 00.000')	},	$
		{ var_obj, 'Data: Left Winsize',		'yleft_winsize',	6,	PTR_NEW(['FL','0','12']),				'check_supegal_infegal',	PTR_NEW([0,1]),	PTR_NEW (0.2)				}, 	$
		{ var_obj, 'Right Winsize',			'legend_winsize',	6,	PTR_NEW(['FL','0','12']),				'check_supegal_infegal',	PTR_NEW([0,1]),	PTR_NEW (0.2)				},	$
		{ var_obj, 'Spacecraft',			'nosat',		6,	PTR_NEW(['DR','2','LABEL_LEFT',nosat_list]),		'check_always_ok',		PTR_NEW(),	PTR_NEW ('1')				}	]

	code = self -> obj::init (no, container, order, param, general=general,$
					/saisissable, graphique=1,$
					orbito=6,orbtxt=orbtxt,$
					palette=7,/shortpalette,/nonbcolors)

	set, self, 'nbmincolors',4
	set, self, 'palette_cube', 'No'
	set, self, 'noparam', 2
	set, self, 'nomcis', 'CIS-OTH'
	set, self, 'tabproduit', noproduit

	RETURN, code

END

;-------------------------------------------------------------------------------
PRO orbitogen__define
;-------------------------------------------------------------------------------
; La classe "orbitogen" hrite de "obj".
;-------------------------------------------------------------------------------

	lint_unused = { orbitogen, 	$

			INHERITS obj 	$

	}

END
