PRO maven_check_scpot

	COMMON COMMON_CL, general

	p = get (general,'p')
	nosat = 1

	date1 = tu_to_date(2014,1,1,0,0,0)
	date2 = get_date()

	FOR date=date1,date2, 86400*1000d DO BEGIN

		date_to_tu, date, annee, mois, jour, heure, minute, seconde

		p1 = p[0,nomcis_string_to_val('MAVEN-LPW'),nosat] ; l2_mrgscpot
		code1 = p1 -> get_data (date, date+86400*1000d-1, data1, /extendmax)

		p2 = p[2,nomcis_string_to_val('MAVEN-LPW'),nosat] ; l2_lpnt
		code2 = p2 -> get_data (date, date+86400*1000d-1, data2, /extendmax)

		IF code1 NE code2 THEN BEGIN
			PRINT,'AIE1'
			STOP
		END

		IF code1 eq -1 then continue

		nb1 = N_ELEMENTS(data1)
		nb2 = N_ELEMENTS(data2)
		IF nb1 NE nb2 THEN BEGIN
			PRINT,'AIE2'
			STOP
		END

		tab_date1 = data1.date
		tab_scpot1 = data1.scpot
		tab_date2 = data2.date
		tab_scpot2 = data2.Vsc

		IF tableaux_idem(tab_date1,tab_date2) EQ 0 THEN BEGIN
			PRINT,'AIE3'
			STOP
		END
		FOR i=0L,nb1-1 DO BEGIN
			IF FINITE(tab_scpot1[i]) EQ 0 AND FINITE(tab_scpot2[i]) EQ 0 THEN CONTINUE
			IF tab_scpot1[i] NE tab_scpot2[i] THEN BEGIN
				PRINT,'AIE4'
				STOP
			END
		END

	END


END
