;-------------------------------------------------------------------------------
FUNCTION corriger_nomchamp1, nom
;-------------------------------------------------------------------------------

        len = STRLEN(nom)
        nomcorrect = ''
        max = len-1
        FOR i=0L,max DO BEGIN
                c = STRMID(nom,i,1)
                IF (c GE 'a' AND c LE 'z') OR (c GE 'A' AND c LE 'Z') OR (c EQ '_') OR (c GE '0' AND c LE '9') THEN BEGIN
                        nomcorrect=nomcorrect+c
                END ELSE BEGIN
                        nomcorrect=nomcorrect+'_'
                END
        END

        ; Si le 1er car est un chiffre, rajouter '_' devant le nom
        car = STRMID(nomcorrect,0,1)
        IF car GE '0' AND car LE '9' THEN nomcorrect = '_' + nomcorrect

        RETURN, nomcorrect

END

;-------------------------------------------------------------------------------
PRO ajouter_champ1, s, val, nom, enreg, taille, first=first
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(first) EQ 0 THEN first=0

	champ = corriger_nomchamp1 (s)

	MOTS = [ 			$
		'AND', 			$
		'BEGIN', 		$
		'BREAK', 		$
		'CASE', 		$
		'COMMON', 		$
		'COMPILE_OPT',		$
		'CONTINUE', 		$
		'DO', 			$
		'ELSE', 		$
		'END', 			$
		'ENDCASE', 		$
		'ENDELSE', 		$
		'ENDFOR', 		$
		'ENDIF', 		$
		'ENDREP', 		$
		'ENDSWITCH', 		$
		'ENDWHILE', 		$
		'EQ', 			$
		'FOR', 			$
		'FORWARD_FUNCTION', 	$
		'FUNCTION', 		$
		'GE', 			$
		'GOTO', 		$
		'GT', 			$
		'IF', 			$
		'INHERITS', 		$
		'LE', 			$
		'LT', 			$
		'MOD', 			$
		'NE', 			$
		'NOT', 			$
		'OF', 			$
		'ON_IOERROR', 		$
		'OR', 			$
		'PRO', 			$
		'REPEAT', 		$
		'SWITCH', 		$
		'THEN', 		$
		'UNTIL', 		$
		'WHILE', 		$
		'XOR']

	ind = WHERE (MOTS EQ STRUPCASE(champ))
	IF ind[0] NE -1 THEN champ=champ+'_'

	IF first EQ 1 THEN BEGIN
		nom = [champ]
		taille = 0L
		enreg = CREATE_STRUCT (champ,val)
	END ELSE BEGIN
		; Le champ que l'on veut rajouter a la structure existe t-il dja ?
		; Si oui, on rajoute '_' au champ autant de fois que ncessaire.
		REPEAT BEGIN
			ind = WHERE (STRUPCASE(nom) EQ STRUPCASE(champ))
			IF ind[0] NE -1 THEN champ=champ+'_'
		END UNTIL ind[0] EQ -1
		nom = [nom,champ]
		enreg = CREATE_STRUCT (enreg,champ,val)
	END
	info = SIZE(val)
	CASE info[N_ELEMENTS(info)-2] OF
		1:	nb=1	; Byte
		2:	nb=2	; Integer
		3:	nb=4	; Longword integer
		4:	nb=4	; Floating point
		5:	nb=8	; Double-precision floating
		12:	nb=2	; Unsigned integer
		13:	nb=4	; Unsigned Longword integer
		7:	nb=12	; String comment estimer la taille d'un string ?
	END
	taille = taille + nb * info[N_ELEMENTS(info)-1]

	;IF s NE champ THEN PRINT,'WARNING: renaming field '+s+' to '+champ+' !'

END

;-------------------------------------------------------------------------------
FUNCTION get_typeval1, typeascii
;-------------------------------------------------------------------------------

        CASE typeascii OF
                'unsigned char':        RETURN, 0b
                'short':                RETURN, 0
                'int':                  RETURN, 0L
                'float':                RETURN, 0.
                'double':               RETURN, 0d
                'unsigned short':       RETURN, 0U
                'unsigned int':         RETURN, 0UL
        END

END

;-------------------------------------------------------------------------------
FUNCTION date_to_nbjours1, date
;-------------------------------------------------------------------------------

        nbjours = LONG(date / 86400000d)
        ind = WHERE (date LT 0)
        IF ind[0] NE -1 THEN BEGIN
                ; enlever un jour aux dates ngatives qui ne correspondent pas pile au dbut d'un jour
                tmp = date[ind] - nbjours[ind]*86400000d
                IF tmp[0] NE 0 THEN BEGIN
                        nbjours[ind[tmp]] = nbjours[ind[tmp]]-1
                END
        END

        RETURN, nbjours

END

;-------------------------------------------------------------------------------
PRO date_to_tu1, date, ann, moi, jou, heu, min, sec
;-------------------------------------------------------------------------------

        nbjours = date_to_nbjours1(date)
        nbms    = LONG(date - nbjours*86400000d)

        CALDAT, JULDAY (1, 1, 1958) + nbjours, moi, jou, ann, heu, min, sec

        heu = LONG(nbms/3600000d)
        tmp = nbms - heu*3600000d

        min = LONG(tmp/60000d)
        tmp = tmp - min*60000d

        sec = tmp/1000d

END

;-------------------------------------------------------------------------------
FUNCTION exp_all_022_get_repertoire,YYYYMMDD
;-------------------------------------------------------------------------------
	RETURN,'/DATA/DEMETER/DATA/L2/' + YYYYMMDD + '/'
END

;-------------------------------------------------------------------------------
FUNCTION exp_all_023_get_fichier,noproduit,YYYYMMDD
;-------------------------------------------------------------------------------
	tmp = [ 'BURSTx', 'SURVEY', 'CNTxxx', 'HKxxxx', 'ORBITO']
	RETURN, 'DEMETER_IDP_' + tmp[noproduit] + '_' + YYYYMMDD + '_V01.bin'
END

;-------------------------------------------------------------------------------
PRO exp_all_600_get_structure, noproduit, enreg, taille
;-------------------------------------------------------------------------------

	struct_exp_demeter_idp = { struct_exp_demeter_idp, nbenergies:0, nbangles:0, nbspectres:0, nbmasses:0}
	infos = REPLICATE (struct_exp_demeter_idp, 4)

        infos[0].nbenergies = 256
        infos[0].nbangles = 1
        infos[0].nbspectres = 1
        infos[0].nbmasses = 1
        infos[1].nbenergies = 128
        infos[1].nbangles = 1
        infos[1].nbspectres = 1
        infos[1].nbmasses = 1
        infos[2].nbenergies = 3
        infos[2].nbangles = 1
        infos[2].nbspectres = 1

	IF noproduit EQ 4 THEN BEGIN	;	ORBITO

		tab = [	['date',	'Temps en milli-secondes',							'double'	], 	$
			['orbit',	'orbit_number',									'unsigned short'], $
			['suborb',	'orbit_subnumber', 								'unsigned short'], $
			['XGEO',	'X_geo_m',									'float'		], $
			['YGEO',	'Y_geo_m',									'float'		], $
			['ZGEO',	'Z_geo_m',									'float'		], $
			['VXGEO',	'VX_geo_m_sec',									'float'		], $
			['VYGEO',	'VY_geo_m_sec', 								'float'		], $
			['VZGEO',	'VZ_geo_m_sec', 								'float'		], $
			['XVEIS',	'X_VEIS_m', 									'float'		], $
			['YVEIS',	'Y_VEIS_m', 									'float'		], $
			['ZVEIS',	'Z_VEIS_m', 									'float'		], $
			['VXVEIS',	'VX_VEIS_m_sec', 								'float'		], $
			['VYVEIS',	'VY_VEIS_m_sec', 								'float'		], $
			['VZVEIS',	'VZ_VEIS_m_sec', 								'float'		], $
			['RLAT',	'geocentric_latitude_deg',							'float'		], $
			['RLONG',	'geocentric_longitude_deg', 							'float'		], $
			['ALT',		'altitude_km', 									'float'		], $
			['LTI',		'local_time_of_the_first_point_of_the_data_array_hour', 			'float'		], $
			['XSUN', 	'Xsolar_geo', 									'float'		], $
			['YSUN', 	'Ysolar_geo', 									'float'		], $
			['ZSUN', 	'Zsolar_geo', 									'float'		], $
			['MLAT', 	'Geomagnetic_latitude_deg', 							'float'		], $
			['MLON', 	'Geomagnetic_longitude_deg', 							'float'		], $
			['MLT', 	'Magnetic_local_time_of_the_first_point_hour', 					'float'		], $
			['ILAT', 	'Invariant_latitude_deg', 							'float'		], $
			['L', 		'Mc_Ilwain_parameter_L', 							'float'		], $
			['RLATC', 	'Geocentric_latitude_of_the_conjugate_point_at_the_satellite_altitude_deg', 	'float'		], $
			['RLONC', 	'Geocentric_longitude_of_the_conjugate_point_at_the_satellite_altitude_deg', 	'float'		], $
			['RLATNC100', 	'Geocentric_latitude_of_North_conjugate_point_at_altitude_100km_deg', 		'float'		], $
			['RLONNC100', 	'Geocentric_longitude_of_North_conjugate_point_at_altitude_100km_deg', 		'float'		], $
			['RLATSC100', 	'Geocentric_latitude_of_South_conjugate_point_at_altitude_100km_deg', 		'float'		], $
			['RLONSC100', 	'Geocentric_longitude_of_South_conjugate_point_at_altitude_100km_deg', 		'float'		], $
			['BX', 		'Geographic_Bx_nT_model',							'float'		], $
			['BY', 		'Geographic_By_nT_model',							'float'		], $
			['BZ', 		'Geographic_Bz_nT_model', 							'float'		], $
			['B', 		'B_nT_model', 									'float'		], $
			['DB', 		'Difference_between_Bmodel_and_Bdipole_nT',					'float'		], $
			['Pf', 		'Proton_gyrofrequency_at_satellite_point_Hz', 					'float'		], $
			['S', 		'Lenght_dipolar_field_lines', 							'float'		], $
			['F', 		'1_over_S_square',								'float'		], $
			['PI', 		'Pitch_angle_IDP_deg',								'float'		]]

		unite = ''
		isorbito = 1
		libelle = REFORM (tab[1,*])


	END ELSE IF noproduit EQ 0 OR noproduit EQ 1 THEN BEGIN

		tab = [	['date',				'Temps en milli-secondes',		'double'	], $
			['burst',				'Mode burst',				'unsigned char'	]]

	END ELSE IF noproduit EQ 2 THEN BEGIN	;	CNT

		tab = [	['date',				'Temps en milli-secondes',		'double'	], $
			['table',				'table',				'unsigned char'	]]

	END ELSE IF noproduit EQ 3 THEN BEGIN	;	HK

		tab = [	['date',				'Temps en milli-secondes',		'double'	], $
			['Discri_level_keV',			'Discri_level_keV',			'float'		], $
			['Polar_voltage_Volt',			'Polar_voltage_Volt',			'float'		], $
			['Temperature_deg',			'Temperature_deg',			'float'		], $
			['Gene_test',				'Gene_test',				'float'		]]

	END ELSE BEGIN

		tab = [	['date',				'Temps en milli-secondes',		'double'	]]

	END

	FOR i=0L, N_ELEMENTS(tab[0,*])-1 DO ajouter_champ1, tab[0,i], get_typeval1(tab[2,i]), nom, enreg, taille, FIRST=(i EQ 0)

	IF noproduit EQ 0 OR noproduit EQ 1 OR noproduit EQ 2 THEN BEGIN ; BURST ou SURVEY ou CNT

		enreg    = CREATE_STRUCT (enreg, 'data', REPLICATE (0UL,infos[noproduit].nbenergies))
		taille   = taille + 4*infos[noproduit].nbenergies


	END

END

;-------------------------------------------------------------------------------
PRO exp_spe_014_calib_lire, $
	DEMETER_3_ENERGY=DEMETER_3_ENERGY, $
	DEMETER_256_ENERGY=DEMETER_256_ENERGY, $
	DEMETER_128_ENERGY=DEMETER_128_ENERGY
;-------------------------------------------------------------------------------
	IF N_ELEMENTS(DEMETER_256_ENERGY) NE 0 THEN BEGIN

		DEMETER_256_ENERGY = REPLICATE (0.,3,256,1) ; MAX-MOY-MIN/256 energies/1 table
		DEMETER_256_ENERGY[0,*,0] = REVERSE(1000. * (8.9 * (INDGEN(256)+1.0) + 72.9)) ; MAX
		DEMETER_256_ENERGY[2,*,0] = REVERSE(1000. * (8.9 * (INDGEN(256)+0.0) + 72.9)) ; MIN
		DEMETER_256_ENERGY[1,*,0] = REVERSE(1000. * (8.9 * (INDGEN(256)+0.5) + 72.9)) ; MOY

		; Si on veut tracer les numeros de paliers plutot que les energies
		; DEMETER_256_ENERGY[0,*,0] = REVERSE(INDGEN(256)+1.0) ; MAX
		; DEMETER_256_ENERGY[2,*,0] = REVERSE(INDGEN(256)+0.0) ; MIN
		; DEMETER_256_ENERGY[1,*,0] = REVERSE(INDGEN(256)+0.5) ; MOY

	END

	IF N_ELEMENTS(DEMETER_3_ENERGY) NE 0 THEN BEGIN

		tmp = REPLICATE (0.,3,256) ; MAX-MOY-MIN/256 energies/1 table
		tmp[0,*] = REVERSE(1000. * (8.9 * (INDGEN(256)+1.0) + 72.9)) ; MAX
		tmp[2,*] = REVERSE(1000. * (8.9 * (INDGEN(256)+0.0) + 72.9)) ; MIN
		tmp[1,*] = REVERSE(1000. * (8.9 * (INDGEN(256)+0.5) + 72.9)) ; MOY

		DEMETER_3_ENERGY = REPLICATE (0.,3,3,2) ; MAX-MOY-MIN/3 energies/2 tables

		; Table 0: 0-50  51-100  101-255 ordre energies croissantes, donc 255-205 204-155 154-0 ordre energies decroissantes
		DEMETER_3_ENERGY[0,*,0] = [ tmp[0,  0], tmp[0,155], tmp[0,205] ]	; MAX
		DEMETER_3_ENERGY[2,*,0] = [ tmp[2,154], tmp[2,204], tmp[2,255] ]	; MIN
		DEMETER_3_ENERGY[1,*,0] = (DEMETER_3_ENERGY[0,*,0] + DEMETER_3_ENERGY[2,*,0]) / 2.0

		; Table 1: 2-51  52-101  102-255 odre energies croissantes, donc 253-204 203-154 203-0 ordre energies decroissantes
		DEMETER_3_ENERGY[0,*,1] = [ tmp[0,  0], tmp[0,154], tmp[0,204] ]
		DEMETER_3_ENERGY[2,*,1] = [ tmp[2,203], tmp[2,203], tmp[2,253] ]
		DEMETER_3_ENERGY[1,*,1] = (DEMETER_3_ENERGY[0,*,1] + DEMETER_3_ENERGY[2,*,1]) / 2.0

	END

	IF N_ELEMENTS(DEMETER_128_ENERGY) NE 0 THEN BEGIN

		DEMETER_128_ENERGY = REPLICATE (0.,3,128,1) ; MAX-MOY-MIN/128 energies/1 table
		DEMETER_128_ENERGY[0,*,0] = REVERSE(1000. * (8.9 * (INDGEN(128)*2+2.0) + 72.9)) ; MAX
		DEMETER_128_ENERGY[2,*,0] = REVERSE(1000. * (8.9 * (INDGEN(128)*2+0.0) + 72.9)) ; MIN
		DEMETER_128_ENERGY[1,*,0] = REVERSE(1000. * (8.9 * (INDGEN(128)*2+1.0) + 72.9)) ; MOY

		; Si on veut tracer les numeros de paliers plutot que les energies
		; DEMETER_128_ENERGY[0,*,0] = REVERSE(INDGEN(128)*2+2.0) ; MAX
		; DEMETER_128_ENERGY[2,*,0] = REVERSE(INDGEN(128)*2+0.0) ; MIN
		; DEMETER_128_ENERGY[1,*,0] = REVERSE(INDGEN(128)*2+1.0) ; MOY

	END
END

;-------------------------------------------------------------------------------
PRO exp_spe_015_get_calib
;-------------------------------------------------------------------------------
	COMMON COMMON_exp_demeter_idp_calib, TABLE1, TABLE2, TABLE3

	nomcalib = ''
	t1_calib = t1
	t2_calib = t2
	DEMETER_256_ENERGY=1
	DEMETER_128_ENERGY=1
	DEMETER_3_ENERGY=1
	codecalib = self->EXP_SPE_014_CALIB_LIRE(DEMETER_256_ENERGY=DEMETER_256_ENERGY, DEMETER_128_ENERGY=DEMETER_128_ENERGY, DEMETER_3_ENERGY=DEMETER_3_ENERGY)

	nbtables = nbenergies EQ 3  ? 2L : 1L
	E = REPLICATE (0.,nbenergies,3,nbtables)

	IF nbenergies EQ 256 THEN BEGIN
		E[*,0,0] = DEMETER_256_ENERGY[2,*,0]
		E[*,1,0] = DEMETER_256_ENERGY[1,*,0]
		E[*,2,0] = DEMETER_256_ENERGY[0,*,0]
	END ELSE IF nbenergies EQ 128 THEN BEGIN
		E[*,0,0] = DEMETER_128_ENERGY[2,*,0]
		E[*,1,0] = DEMETER_128_ENERGY[1,*,0]
		E[*,2,0] = DEMETER_128_ENERGY[0,*,0]
	END ELSE IF nbenergies EQ 3 THEN BEGIN
		FOR table=0L,nbtables-1 DO BEGIN
			E[*,0,table] = DEMETER_3_ENERGY[2,*,table]
			E[*,1,table] = DEMETER_3_ENERGY[1,*,table]
			E[*,2,table] = DEMETER_3_ENERGY[0,*,table]
		END
	END

	; Accumulation: on utilise toujours 1
	nb_accumulation = REPLICATE (1L,nbspins)

	indY = REPLICATE (0L,nbspins) ; toujours table 0

	duree_comptage = REPLICATE (noproduit EQ 0 ? 1.0 : 4.0,nbspins) ; en sec

	facteurG   = REPLICATE (1d,1,nbcellules,nbtables,nbenergies) ; en m2.sr.(eV/eV)
	efficacite = REPLICATE (1d,1,nbcellules,nbtables,nbenergies,nbmasses)
	deadtimes  = REPLICATE (0d,1)

	; Formule Gangloff:	flux = coup_brut / T
	; Formule cl:		flux = coup_par_seconde / (G * E)

	; Donc G = (coup_par_seconde * T) / (coup_brut * E)

	; En mode BURST: coup_par_seconde = coup donc G = T / E
	; En mode SURVEY: coup_par_seconde = coup / 4.0 donc G = T / (4 * E)

	IF noproduit EQ 0 OR noproduit EQ 2 THEN BEGIN	; BURST ou CNT

		T_BURST=[	 5.33,  5.96,  6.59,  7.22,  7.52,  7.81,  8.10,  8.39,  8.68,  8.92, $
				 9.07,  9.22,  9.36,  9.51,  9.66,  9.74,  9.79,  9.85,  9.90,  9.95, $
				10.01, 10.06, 10.11, 10.17, 10.22, 10.27, 10.30, 10.31, 10.32, 10.33, $
				10.33, 10.34, 10.35, 10.36, 10.36, 10.37, 10.38, 10.38, 10.38, 10.38, $
				10.38, 10.37, 10.37, 10.37, 10.37, 10.36, 10.36, 10.36, 10.36, 10.35, $
				10.35, 10.34, 10.34, 10.33, 10.33, 10.32, 10.32, 10.31, 10.31, 10.31, $
				10.30, 10.30, 10.29, 10.29, 10.28, 10.28, 10.27, 10.27, 10.27, 10.26, $
				10.26, 10.18, 10.05,  9.93,  9.80,  9.67,  9.54,  9.41,  9.28,  9.15, $
				 9.02,  8.89,  8.75,  8.59,  8.44,  8.29,  8.13,  7.98,  7.82,  7.67, $
				 7.52,  7.36,  7.21,  7.06,  6.93,  6.81,  6.68,  6.56,  6.43,  6.31, $
				 6.19,  6.06,  5.94,  5.81,  5.69,  5.58,  5.47,  5.37,  5.26,  5.15, $
				 5.05,  4.94,  4.83,  4.73,  4.62,  4.52,  4.41,  4.30,  4.20,  4.09, $
				 3.99,  3.88,  3.77,  3.67,  3.56,  3.45,  3.35,  3.25,  3.16,  3.08, $
				 2.99,  2.91,  2.82,  2.73,  2.65,  2.56,  2.48,  2.39,  2.31,  2.26, $
				 2.21,  2.16,  2.10,  2.05,  2.00,  1.95,  1.90,  1.84,  1.79,  1.74, $
				 1.70,  1.66,  1.62,  1.58,  1.54,  1.51,  1.47,  1.43,  1.39,  1.35, $
				 1.31,  1.28,  1.25,  1.23,  1.20,  1.18,  1.15,  1.12,  1.10,  1.07, $
				 1.04,  1.02,  0.99,  0.97,  0.94,  0.91,  0.89,  0.86,  0.84,  0.81, $
				 0.78,  0.76,  0.73,  0.71,  0.70,  0.69,  0.67,  0.66,  0.65,  0.64, $
				 0.63,  0.62,  0.61,  0.60,  0.59,  0.58,  0.57,  0.56,  0.55,  0.53, $
				 0.52,  0.51,  0.50,  0.49,  0.48,  0.47,  0.46,  0.45,  0.44,  0.43, $
				 0.42,  0.41,  0.39,  0.38,  0.37,  0.36,  0.35,  0.34,  0.34,  0.33, $
				 0.33,  0.32,  0.31,  0.31,  0.30,  0.30,  0.29,  0.28,  0.28,  0.27, $
				 0.27,  0.26,  0.26,  0.25,  0.24,  0.24,  0.23,  0.23,  0.22,  0.21, $
				 0.21,  0.21,  0.21,  0.21,  0.20,  0.20,  0.20,  0.20,  0.20,  0.19, $
				 0.19,  0.19,  0.19,  0.18,  0.18,  0.18]

		IF use_Eproton THEN T_BURST[*] = 8.9*1.2

		IF noproduit EQ 2 THEN BEGIN

			Gtable0 = [ moyen (T_BURST[255-255:255-101]), moyen (T_BURST[255-100:255-51]), moyen (T_BURST[255-50: 255-0]) ] / E[*,1,0]
			Gtable1 = [ moyen (T_BURST[255-255:255-102]), moyen (T_BURST[255-101:255-52]), moyen (T_BURST[255-51: 255-0]) ] / E[*,1,0]

		END ELSE BEGIN

			G = REVERSE (T_BURST) /  E[*,1,0]

		END



	END ELSE IF noproduit EQ 1 THEN BEGIN	;	SURVEY

		T_SURVEY=[	42.67, 52.72, 60.18, 64.80, 69.43, 72.54, 74.91, 77.28, 78.35, 79.20, $
				80.05, 80.90, 81.75, 82.42, 82.54, 82.66, 82.79, 82.91, 83.03, 83.05, $
				83.01, 82.97, 82.93, 82.88, 82.84, 82.77, 82.70, 82.63, 82.56, 82.48, $
				82.41, 82.34, 82.27, 82.20, 82.13, 82.05, 80.44, 78.36, 76.28, 74.21, $
				72.13, 69.99, 67.53, 65.06, 62.60, 60.13, 57.67, 55.46, 53.47, 51.47, $
				49.48, 47.49, 45.50, 43.77, 42.07, 40.38, 38.68, 36.98, 35.28, 33.58, $
				31.88, 30.18, 28.48, 26.79, 25.31, 23.94, 22.57, 21.19, 19.82, 18.48, $
				17.66, 16.83, 16.00, 15.17, 14.34, 13.60, 12.98, 12.36, 11.73, 11.11, $
				10.48, 10.03,  9.61,  9.19,  8.77,  8.36,  7.94,  7.52,  7.10,  6.68, $
				 6.26,  5.85,  5.57,  5.40,  5.23,  5.05,  4.88,  4.71,  4.54,  4.36, $
				 4.19,  4.02,  3.85,  3.67,  3.50,  3.33,  3.16,  2.98,  2.81,  2.70, $
				 2.60,  2.51,  2.42,  2.32,  2.23,  2.13,  2.04,  1.95,  1.85,  1.76, $
				 1.70,  1.66,  1.63,  1.60,  1.57,  1.54,  1.50,  1.46]

		IF use_Eproton THEN T_SURVEY[*] = 71.2*1.2

		G = REVERSE (T_SURVEY) / (4 * E[*,1,0])

	END

	IF noproduit EQ 2 THEN BEGIN ; CNT
		facteurG[0,0,0,*] = Gtable0 / 10.0
		facteurG[0,0,1,*] = Gtable1 / 10.0
	END ELSE BEGIN
		facteurG[0,0,0,*] = G / 10.0
	END

	; Tables de correction Thomas Moreau (Janvier 2011)
	IF N_ELEMENTS(TABLE1) EQ 0 THEN BEGIN

		;Table de deconvolution Counts->flux[particles/(cm2.sr.MeV)] pour pic
		;d'e- absorbes en reponse a un spectre plat en energie 2.33795MeV->77.35keV
		TABLE1  = [	7818.96, 6081.41, 6133.84, 5880.37, 7489.74, 6649.77, 5647.02, $
				6241.45, 6241.45, 6776.43, 6468.41, 5738.11, 5784.76, 5692.20, $
				5832.17, 4975.70, 5647.03, 5784.76, 5738.11, 6029.87, 5738.11, $
				5515.70, 4873.46, 4907.07, 4807.60, 5515.70, 5558.79, 4975.70, $
				5309.89, 4807.60, 5231.80, 4941.15, 4160.97, 4561.06, 4112.86, $
				4681.09, 5118.89, 4907.07, 4650.49, 4941.15, 4286.30, 4338.57, $
				4210.21, 4042.76, 5349.81, 3667.66, 3744.87, 4042.76, 3952.92, $
				3705.86, 3611.80, 3263.88, 3420.79, 3356.25, 3234.21, 3420.79, $
				2880.67, 3219.57, 2892.38, 2928.09, 2834.76, 3066.92, 2834.76, $
				2541.16, 2880.67, 2420.15, 2664.89, 2685.00, 2453.54, 2387.67, $
				2244.56, 2062.39, 1954.74, 2032.93, 1928.25, 2080.48, 1787.75, $
				1761.20, 1981.96, 1588.23, 1756.85, 1824.42, 1706.30, 1567.24, $
				1501.11, 1476.19, 1494.80, 1440.33, 1305.55, 1384.29, 1228.89, $
				1158.84, 1248.29, 1212.14, 1113.50, 1020.84, 1026.73, 933.760, $
				1074.81, 895.000, 866.657, 902.951, 814.102, 805.804, 741.172, $
				759.365, 710.814, 725.306, 706.579, 641.014, 669.986, 604.524, $
				585.136, 558.936, 541.084, 538.626, 525.887, 508.232, 463.233, $
				436.251, 448.064, 414.400, 391.593, 382.540, 376.668, 359.175, $
				345.904, 321.521, 325.194, 305.507, 295.239, 285.066, 273.033, $
				264.409, 252.135, 252.583, 236.230, 220.560, 221.314, 212.777, $
				207.260, 191.837, 187.490, 185.390, 178.596, 169.129, 159.285, $
				162.226, 147.957, 146.495, 138.970, 135.632, 129.769, 125.978, $
				118.905, 119.484, 114.467, 110.795, 104.867, 102.658, 97.6431, $
				95.5067, 89.9640, 88.4651, 84.9684, 83.0348, 78.0780, 77.6774, $
				74.1327, 74.7165, 69.7095, 69.5324, 65.5300, 64.0206, 62.4035, $
				58.7746, 57.2012, 55.1613, 54.0221, 52.4144, 50.7073, 49.2814, $
				47.6223, 45.6926, 45.9731, 43.6867, 42.9483, 40.9700, 39.9217, $
				39.0841, 38.4754, 36.8075, 36.1658, 35.4734, 34.6696, 34.4498, $
				33.9971, 32.6118, 32.4261, 31.3144, 31.1158, 31.4417, 30.5428, $
				30.8996, 30.6217, 30.2134, 30.0044, 29.8321, 29.7162, 29.3934, $
				29.8146, 29.3837, 29.6592, 29.5251, 29.6382, 29.3328, 29.7299, $
				29.4396, 30.0070, 29.2040, 29.8133, 29.6481, 29.1394, 29.7249, $
				29.6074, 30.0716, 29.4737, 29.8609, 29.1585, 29.9804, 30.2674, $
				30.0501, 29.8659, 30.2725, 30.5218, 30.4500, 30.9332, 30.9790, $
				31.4876, 31.9887, 31.8427, 33.7216, 34.6713, 34.5652, 36.2875, $
				38.5818, 41.5878, 43.5743, 47.4255, 54.5146, 65.5119, 85.5713, $
							128.736, 223.329, 444.981 ]

		;Nbre de couts simules dans pic de pleine energie (absorption) en
		;reponse a un spectre plat en energie 2.33795MeV->77.35keV
		TABLE2  = [	91.0000, 117.000, 116.000, 121.000, 95.0000, 107.000, 126.000, $
				114.000, 114.000, 105.000, 110.000, 124.000, 123.000, 125.000, $
				122.000, 143.000, 126.000, 123.000, 124.000, 118.000, 124.000, $
				129.000, 146.000, 145.000, 148.000, 129.000, 128.000, 143.000, $
				134.000, 148.000, 136.000, 144.000, 171.000, 156.000, 173.000, $
				152.000, 139.000, 145.000, 153.000, 144.000, 166.000, 164.000, $
				169.000, 176.000, 133.000, 194.000, 190.000, 176.000, 180.000, $
				192.000, 197.000, 218.000, 208.000, 212.000, 220.000, 208.000, $
				247.000, 221.000, 246.000, 243.000, 251.000, 232.000, 251.000, $
				280.000, 247.000, 294.000, 267.000, 265.000, 290.000, 298.000, $
				317.000, 345.000, 364.000, 350.000, 369.000, 342.000, 398.000, $
				404.000, 359.000, 448.000, 405.000, 390.000, 417.000, 454.000, $
				474.000, 482.000, 476.000, 494.000, 545.000, 514.000, 579.000, $
				614.000, 570.000, 587.000, 639.000, 697.000, 693.000, 762.000, $
				662.000, 795.000, 821.000, 788.000, 874.000, 883.000, 960.000, $
				937.000, 1001.00, 981.000, 1007.00, 1110.00, 1062.00, 1177.00, $
				1216.00, 1273.00, 1315.00, 1321.00, 1353.00, 1400.00, 1536.00, $
				1631.00, 1588.00, 1717.00, 1817.00, 1860.00, 1889.00, 1981.00, $
				2057.00, 2213.00, 2188.00, 2329.00, 2410.00, 2496.00, 2606.00, $
				2691.00, 2822.00, 2817.00, 3012.00, 3226.00, 3215.00, 3344.00, $
				3433.00, 3709.00, 3795.00, 3838.00, 3984.00, 4207.00, 4467.00, $
				4386.00, 4809.00, 4857.00, 5120.00, 5246.00, 5483.00, 5648.00, $
				5984.00, 5955.00, 6216.00, 6422.00, 6785.00, 6931.00, 7287.00, $
				7450.00, 7909.00, 8043.00, 8374.00, 8569.00, 9113.00, 9160.00, $
				9598.00, 9523.00, 10207.0, 10233.0, 10858.0, 11114.0, 11402.0, $
				12106.0, 12439.0, 12899.0, 13171.0, 13575.0, 14032.0, 14438.0, $
				14941.0, 15572.0, 15477.0, 16287.0, 16567.0, 17367.0, 17823.0, $
				18205.0, 18493.0, 19331.0, 19674.0, 20058.0, 20523.0, 20654.0, $
				20929.0, 21818.0, 21943.0, 22722.0, 22867.0, 22630.0, 23296.0, $
				23027.0, 23236.0, 23550.0, 23714.0, 23851.0, 23944.0, 24207.0, $
				23865.0, 24215.0, 23990.0, 24099.0, 24007.0, 24257.0, 23933.0, $
				24169.0, 23712.0, 24364.0, 23866.0, 23999.0, 24418.0, 23937.0, $
				24032.0, 23661.0, 24141.0, 23828.0, 24402.0, 23733.0, 23508.0, $
				23678.0, 23824.0, 23504.0, 23312.0, 23367.0, 23002.0, 22968.0, $
				22597.0, 22243.0, 22345.0, 21100.0, 20522.0, 20585.0, 19608.0, $
				18442.0, 17109.0, 16329.0, 15003.0, 13052.0, 10861.0, 8315.00, $
				5527.00, 3186.00, 1599.00 ]

		TABLE3 = REPLICATE(0.,256,255)
		nom_txt = GETENV ('CL_ROOT') + '/resource/demeter_idp_correction.txt'
		PRINT, 'Reading ' + nom_txt + ' ...'
		OPENR, fd,nom_txt,/get_lun
		READF, fd,TABLE3
		FREE_LUN, fd
	END
	DEMETER_TAB_FULLNRJRATIO_IDP  = TABLE1
	DEMETER_TAB_FULLNRJCOUNT_IDP  = TABLE2
	DEMETER_HISTO_PER_ENERGY_SPEC = TABLE3
END

;-------------------------------------------------------------------------------
FUNCTION exp_spe_023_get_dureevaliditespin,noproduit
;-------------------------------------------------------------------------------
	RETURN, noproduit EQ 0 ? 1000d : 4000d
END

;-------------------------------------------------------------------------------
PRO lire_demeter
;-------------------------------------------------------------------------------

	;'0  BURSTx    256 ENERGIES                   1 sec        Priority = 2'     
	;'1  SURVEY    128 ENERGIES                   4 sec        Priority =  1 (best)'
	;'2  CNTxxx      3 ENERGIES                   1 sec        Priority = 99'
	;'3  HKxxxx      4 HOUSEKEEPING              28 sec        Priority = 99'
	;'4  ORBITO    Detailed spacecraft position  30 sec        Priority = 99'

	; Tables d'energies
	DEMETER_128_ENERGY=1
	exp_spe_014_calib_lire,DEMETER_128_ENERGY=DEMETER_128_ENERGY
	DEMETER_256_ENERGY=1
	exp_spe_014_calib_lire,DEMETER_256_ENERGY=DEMETER_256_ENERGY

	; Lecture des donnes
	
	YYYYMMDD='20080815'
	noproduit=4

	REPERTOIRE = exp_all_022_get_repertoire (YYYYMMDD)
	FICHIER = exp_all_023_get_fichier (noproduit,YYYYMMDD)
	nom = REPERTOIRE+FICHIER
	exp_all_600_get_structure, noproduit, enreg, taille_enreg


	OPENR,fd,nom,/get_lun,/SWAP_IF_LITTLE_ENDIAN
        status = FSTAT (fd)
        taille_fichier = status.SIZE
	nblignes = taille_fichier / taille_enreg

	data = REPLICATE (enreg, nblignes)
	READU,fd,data
	FREE_LUN,fd

	FOR i=0,nblignes-1 DO BEGIN
		date_to_tu1,data[i].date,annee,mois,jour,heure,minute,seconde
		PRINT,annee,mois,jour,heure,minute,seconde
	END

	STOP

END
