;-------------------------------------------------------------------------------
PRO get_cspice_prototypes,	$
;-------------------------------------------------------------------------------
	fichier		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Lit un fichier issu COPIER/COLLER de "http://naif.jpl.nasa.gov/pub/naif/toolkit_docs/IDL/icy/index.html" et affiche les prototypes trouvs.
;-------------------------------------------------------------------------------

	OPENR, fd, fichier, /GET_LUN
	s = ''
	WHILE ~EOF(fd) DO BEGIN
		READF, fd, s
BOUCLE:
		;PRINT,s
		tmp = STRSPLIT (s, /EXTRACT)
		nb = N_ELEMENTS(tmp)
		IF (nb GE 3) && (tmp[2] EQ '=') THEN BEGIN
			; FUNCTION
			IF STRMID(tmp[3], STRLEN(tmp[3])-2) EQ '()' THEN BEGIN
				; ex: "B1900: double = CSPICE_B1900()"
				name = STRMID(tmp[3], 0, STRLEN(tmp[3])-2)
				debut = nb
			END ELSE BEGIN
				name = STRMID(tmp[3], 0, STRLEN(tmp[3])-1)
				; ex: "BODFND: boolean = CSPICE_BODFND( body, `item` )"
				IF STRPOS(name, '(') NE -1 THEN BEGIN
					; 2 examples:
					;  "CELLD: cell = CSPICE_CELLD(size)"
					;  "CELLI: cell = CSPICE_CELLI(size)"
					pos1 = STRPOS (s, '(')
					pos2 = STRPOS (s, ')')
					s = STRMID(s, 0, pos1) + '( ' + STRMID(s, pos1+1, pos2-pos1-1) + ' ) ' + STRMID(s, pos2+1)
					; ex: "CELLD: cell = CSPICE_CELLD( size )"
					GOTO, BOUCLE
				END
				debut = 4L
			END
			ligne = STRING(9b) + STRING(9b) + STRING(9b) + '"' + name + STRING(9b) + STRING(9b) + STRING(9b) + STRING(9b) + ' (icy.dlm)' + STRING(9b) + 'F'
		END ELSE BEGIN
			; PRO
			; ex: "APPNDD: CSPICE_APPNDD, _item_, (CELL)"
			name = STRMID(tmp[1], 0, STRLEN(tmp[1])-1)
			debut = 2L
			ligne = STRING(9b) + STRING(9b) + STRING(9b) + '"' + name + STRING(9b) + STRING(9b) + STRING(9b) + STRING(9b) + ' (icy.dlm)' + STRING(9b) + 'P'
		END
		FOR i=debut,nb-1 DO BEGIN

			IF tmp[i] EQ ')' THEN CONTINUE

			len = STRLEN(tmp[i])
			premier = STRMID(tmp[i], 0, 1)
			dernier = STRMID(tmp[i], len-1, 1)
			IF dernier EQ ',' THEN BEGIN
				tmp[i] = STRMID(tmp[i], 0, len-1)
			END

			len = STRLEN(tmp[i])
			premier = STRMID(tmp[i], 0, 1)
			dernier = STRMID(tmp[i], len-1, 1)
			IF premier EQ '(' && dernier EQ ')' THEN BEGIN
				tmp[i] = STRMID(tmp[i], 1, len-2)
			END

			len = STRLEN(tmp[i])
			premier = STRMID(tmp[i], 0, 1)
			dernier = STRMID(tmp[i], len-1, 1)
			IF premier EQ '`' && dernier EQ '`' THEN BEGIN
				tmp[i] = STRMID(tmp[i], 1, len-2)
			END

			len = STRLEN(tmp[i])
			premier = STRMID(tmp[i], 0, 1)
			dernier = STRMID(tmp[i], len-1, 1)
			IF premier EQ '_' && dernier EQ '_' THEN BEGIN
				tmp[i] = STRMID(tmp[i], 1, len-2)
			END

			pos = STRPOS(tmp[i], '[')
			IF pos NE -1 THEN tmp[i] = STRMID(tmp[i], 0, pos)

			type = tmp[i] EQ STRLOWCASE(tmp[i]) ? 'input' : 'output'

			ligne += ' '+tmp[i]+':'+type
		END
		PRINT, ligne + '", $'
	END

	FREE_LUN, fd


END


;-------------------------------------------------------------------------------
PRO check_dlm,	$
;-------------------------------------------------------------------------------
	decls		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Lit les fichiers ".dlm"
;-------------------------------------------------------------------------------

	my_print, ''
	my_print, '---------'
	my_print, 'check_dlm'
	my_print, '---------'
	my_print, ''

	IDL_DIR      = GETENV ('IDL_DIR')

	infos = REPLICATE ( { function_pro:'', name: '', nb_params_min:0L, nb_params_max:0L, module:'' }, 20000)
	nbinfos = 0L

	liste = my_findfile (IDL_DIR + '/bin/bin.linux.x86_64/*.dlm')
	s = ''
	FOR i=0L,N_ELEMENTS(liste)-1 DO BEGIN

		OPENR, fd, liste[i], /GET_LUN
		module = 'SYSTEM/' + basename(liste[i])

		WHILE ~EOF(fd) DO BEGIN

			READF, fd, s
			tmp = STRSPLIT (s, /EXTRACT)
			IF STRUPCASE(tmp[0]) EQ 'FUNCTION' OR STRUPCASE(tmp[0]) EQ 'PROCEDURE' THEN BEGIN
				infos[nbinfos].function_pro  	= tmp[0] EQ 'PROCEDURE' ? 'PRO' : 'FUNCTION'
				infos[nbinfos].name  		= tmp[1]
				IF tmp[3] EQ 'IDL_MAXPARAMS'     THEN tmp[3] = 2000 ; 65535
				IF tmp[3] EQ 'IDL_MAX_ARRAY_DIM' THEN tmp[3] = 8
				infos[nbinfos].nb_params_min  	= tmp[2]
				infos[nbinfos].nb_params_max  	= tmp[3]
				IF STRPOS(infos[nbinfos].name, '::') NE -1 THEN BEGIN
					; IDL donne un argument de trop dans les DLM pour les mthodes
					infos[nbinfos].nb_params_min--
					infos[nbinfos].nb_params_max--
				END
				IF infos[nbinfos].nb_params_max GT 1000 THEN infos[nbinfos].nb_params_max = 1000
				infos[nbinfos].module  		= module
				nbinfos++

			END

		END

		FREE_LUN, fd
	END

	infos = infos[0:nbinfos-1]

	nbdecls = N_ELEMENTS(decls)
	decls_name 		= decls.name
	decls_function_pro 	= decls.function_pro
	decls_module		= decls.module
	decls_nb_params_min	= decls.nb_params_min
	decls_nb_params_max	= decls.nb_params_max
	FOR i=0L,nbdecls-1 DO BEGIN
		IF decls[i].object NE '' THEN decls_name[i] = decls[i].object + '::' + decls_name[i]
	END

	FOR i=0L,nbdecls-1 DO BEGIN

		name 		= decls_name[i]
		function_pro	= decls_function_pro[i]
		nb_params_min	= decls_nb_params_min[i]
		nb_params_max	= MIN([decls_nb_params_max[i],1000])
		module		= decls_module[i]

		j = WHERE (STRUPCASE(infos.name) EQ STRUPCASE(name) AND STRUPCASE(infos.function_pro) EQ STRUPCASE(function_pro), nb)
		IF nb NE 0 THEN BEGIN

			j = j[0]
			IF infos[j].module NE module THEN BEGIN
				PRINT, 'AIE1(' + val_to_str(i) + ') ' + infos[j].module + ' ' + function_pro + ' ' + STRUPCASE(name)
				;stop
			END ELSE BEGIN
				IF infos[j].nb_params_min NE nb_params_min OR infos[j].nb_params_max NE nb_params_max THEN BEGIN
					IF (WHERE (decls_name EQ STRLOWCASE(name)+'+1')) NE -1 THEN BEGIN
						; plusieurs dfinitions possibles ...
					END ELSE BEGIN
						PRINT, 'NB_PARAMS ' + STRUPCASE(name) + ' ' + val_to_str(nb_params_min)+' '+val_to_str(nb_params_max)+' -> ' + val_to_str(infos[j].nb_params_min)+' '+val_to_str(infos[j].nb_params_max)
					END
					;PRINT,'OK ' + module + ' ' + function_pro + ' ' + name
				END
			END
		END ELSE BEGIN
			j = WHERE (STRUPCASE(infos.name) EQ STRUPCASE(name), nb)
			IF nb NE 0 THEN BEGIN
				IF name EQ 'read_png' THEN BEGIN
					; ne rien dire car FUNCTION et PRO existent!
				END ELSE BEGIN
					PRINT, STRUPCASE(name) + ' ' + function_pro + ' -> ' + infos[j].function_pro
				END
			END
		END
		
	END


	;OPENW, fd, "MANQUE", /GET_LUN

	FOR i=0L,nbinfos -1 DO BEGIN

		info 		= infos[i]
		name 		= info.name
		function_pro	= info.function_pro
		module		= info.module
		nb_params_min	= info.nb_params_min
		nb_params_max	= info.nb_params_max

		IF module EQ '(???)' THEN BEGIN

			TAB = STRING(9B)
			s = TAB+TAB+TAB+'"'+STRUPCASE(name)+TAB+TAB+TAB+module+TAB+TAB+TAB+TAB+(function_pro EQ 'FUNCTION' ? 'F' : 'P')+TAB
			s1 = ''
			FOR k=0L,nb_params_min-1 DO BEGIN
				IF s1 NE '' THEN s1 += ' '
				s1 += 'unknow:output'
			END
			FOR k=nb_params_min+1,nb_params_max DO BEGIN
				IF s1 NE '' THEN s1 += ' '
				s1 += '[unknow:output]'
			END
			s += s1 + '",'+TAB+'$'
			PRINTF, fd, s
		END

		j = WHERE (STRUPCASE(decls_name) EQ STRUPCASE(name) AND STRUPCASE(decls_function_pro) EQ STRUPCASE(function_pro), nb)
		IF nb NE 0 THEN BEGIN
			j = j[0]
			IF decls[j].module NE module THEN BEGIN
				PRINT, 'AIE2(' + val_to_str(i) + ') ' + module + ' ' + function_pro + ' ' + STRUPCASE(name)
				;stop
			END ELSE BEGIN
				;PRINT,'OK ' + module + ' ' + function_pro + ' ' + name
			END
		END ELSE BEGIN
			j = WHERE (STRUPCASE(decls_name) EQ STRUPCASE(name), nb)
			IF nb NE 0 THEN BEGIN
				PRINT, STRUPCASE(name) + ' ' + function_pro + ' -> ' + infos[j].function_pro
			END ELSE BEGIN
				PRINT, 'MANQUE ' + module + ' ' + function_pro + ' ' + name
				;TAB = STRING(9B)
				;PRINTF, fd, TAB+TAB+TAB+'"'+name+TAB+TAB+TAB+module+TAB+TAB+TAB+TAB+(function_pro EQ 'FUNCTION' ? 'F' : 'P')+'",'+TAB+'$'
			END
		END

	END

	;FREE_LUN, fd

	;EXIT

END

;-------------------------------------------------------------------------------
PRO check_help,	$
;-------------------------------------------------------------------------------
	decls	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Lit le fichier "help/online_help/idl_catalog.xml"
;-------------------------------------------------------------------------------

	my_print, ''
	my_print, '----------'
	my_print, 'check_help'
	my_print, '----------'
	my_print, ''

	code = xml_to_noeud_variable_valeur ("/usr/local/rsi/idl/help/online_help/idl_catalog.xml", dataxml)
	IF code NE 1 THEN RETURN

	nbxml = N_ELEMENTS(dataxml)

	ind1 = WHERE (dataxml.noeud EQ 'ROUTINE' OR dataxml.noeud EQ 'METHOD')

	; juste les BAD
	FOR i=0L,N_ELEMENTS(ind1)-1 DO BEGIN
		IF dataxml[ind1[i]].variable EQ 'name' THEN BEGIN

			name = STRUPCASE(dataxml[ind1[i]].valeur)
			; Ne garder que les routines avec [A-Z] et '_'
			bad = 0
			FOR j=0L,STRLEN(name)-1 DO BEGIN
				c = STRMID(name, j, 1)
				IF (c GE 'A' && c LE 'Z') || (c GE '0' && c LE '9') || (c EQ ':') || (c EQ '_') THEN BEGIN
				END ELSE BEGIN
					PRINT, 'BAD ' + name
					BREAK
				END
			END
		END
	END

	; les autres
	FOR i=0L,N_ELEMENTS(ind1)-1 DO BEGIN
		IF dataxml[ind1[i]].variable EQ 'name' THEN BEGIN

			name = STRUPCASE(dataxml[ind1[i]].valeur)
			; Ne garder que les routines avec [A-Z] et '_'
			bad = 0
			FOR j=0L,STRLEN(name)-1 DO BEGIN
				c = STRMID(name, j, 1)
				IF (c GE 'A' && c LE 'Z') || (c GE '0' && c LE '9') || (c EQ ':') || (c EQ '_') THEN BEGIN
				END ELSE BEGIN
					bad = 1
					BREAK
				END
			END
			IF bad THEN CONTINUE

			IF ind1[i]+4 LT nbxml && dataxml[ind1[i]+4].noeud EQ 'SYNTAX' && dataxml[ind1[i]+4].variable EQ 'type' THEN BEGIN
				function_pro = STRUPCASE(dataxml[ind1[i]+4].valeur) ; 'pro' ou 'func'
				IF function_pro EQ 'FUNC' THEN function_pro = 'FUNCTION'
			END ELSE BEGIN
				CONTINUE
			END

			IF ind1[i]+3 LT nbxml && dataxml[ind1[i]+3].noeud EQ 'SYNTAX' && dataxml[ind1[i]+3].variable EQ 'name' THEN BEGIN
				syntax = dataxml[ind1[i]+3].valeur
			END ELSE BEGIN
				syntax = '???'
			END

			is_object = STRPOS(name, '::') NE -1
			IF is_object THEN BEGIN
				tmp = STRSPLIT (name, '::', /EXTRACT)
				object = tmp[0]
				name1   = tmp[1]
				ind2 = WHERE (STRUPCASE(decls.name) EQ STRUPCASE(name1) AND decls.function_pro EQ function_pro AND STRUPCASE(decls.object) EQ STRUPCASE(object))
				IF ind2[0] EQ - 1 THEN BEGIN
					PRINT, STRING(function_pro, FORMAT='(A-8)') +' ' +  STRING(name, FORMAT='(A-50)')
				END
			END ELSE BEGIN
				ind2 = WHERE (STRUPCASE(decls.name) EQ STRUPCASE(name) AND decls.function_pro EQ function_pro AND decls.object EQ '')
				IF ind2[0] EQ - 1 THEN BEGIN
					PRINT, STRING(function_pro, FORMAT='(A-8)') +' ' + STRING(name, FORMAT='(A-50)') + ' "' + syntax + '"'
				END
			END
			
		END
	END

END

;-------------------------------------------------------------------------------
PRO my_print,	$
;-------------------------------------------------------------------------------
	msg		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ecrit un message  l'ran et dans le fichier de log
;-------------------------------------------------------------------------------
	COMMON COMMON_LINT, common_lint_infos

	PRINT, msg
	PRINTF, common_lint_infos.fd_log, msg

END

;-------------------------------------------------------------------------------
PRO my_print_msg,	$
;-------------------------------------------------------------------------------
	data,		$	; LINT_PROTOTYPE input
	msg			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ecrit un message  l'ran et dans le fichier de log
;-------------------------------------------------------------------------------
	COMMON COMMON_LINT, common_lint_infos

	IF data.msg_on THEN BEGIN
		PRINT, msg
		PRINTF, common_lint_infos.fd_log, msg
	END

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_noline,	$
;-------------------------------------------------------------------------------
	data		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne le vrai numro de ligne
;-------------------------------------------------------------------------------
	RETURN, (*data.noline)[MIN([data.pos,N_ELEMENTS(*data.noline)-1])]
END


;-------------------------------------------------------------------------------
FUNCTION lint_get_nochar,	$
;-------------------------------------------------------------------------------
	data		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne le vrai numro de colonne
;-------------------------------------------------------------------------------
	RETURN, (*data.nochar)[MIN([data.pos,N_ELEMENTS(*data.nochar)-1])]
END


;-------------------------------------------------------------------------------
FUNCTION lint_get_message,	$
;-------------------------------------------------------------------------------
	data,			$	; LINT_PROTOTYPE [input]
	routine=routine,	$	; LINT_PROTOTYPE input
	module=module,		$	; LINT_PROTOTYPE input
	noligne=noligne			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne le texte a afficher au dbut d'un message d'erreur
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(module) NE 0 AND N_ELEMENTS(noligne) NE 0 THEN RETURN, STRING (          module +'(' + LINTC_INT_TO_STR(noligne)               + ') ', FORMAT=!FORMAT)
	IF N_ELEMENTS(module) NE 0 AND N_ELEMENTS(noligne) EQ 0 THEN RETURN, STRING (          module ,                                                      FORMAT=!FORMAT)
	IF N_ELEMENTS(routine) NE 0 THEN                             RETURN, STRING (data.decl.module ,                                                      FORMAT=!FORMAT)
	                                                             RETURN, STRING (data.decl.module +'(' + LINTC_INT_TO_STR(lint_get_noline(data)) + ') ', FORMAT=!FORMAT)

END

;-------------------------------------------------------------------------------
PRO lint_add_msg,		$
;-------------------------------------------------------------------------------
	data,			$	; LINT_PROTOTYPE input
	txt1,			$	; LINT_PROTOTYPE input
	txt2,			$	; LINT_PROTOTYPE input
	noligne=noligne,	$	; LINT_PROTOTYPE input
	nor=nor				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Rajoute un message  data.decls[data.nor].msg
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(noligne) EQ 0 THEN BEGIN
		noligne = lint_get_noline(data)
		nochar  = lint_get_nochar(data)
	END ELSE BEGIN
		nochar   = 0L
	END
	IF N_ELEMENTS(nor)     EQ 0 THEN nor     = data.nor

	IF data.msg_on THEN data.decls[nor].msg += LINTC_INT_TO_STR(noligne) + !SEP2 + LINTC_INT_TO_STR(nochar) + !SEP2 + txt1 + !SEP2 + txt2 + !SEP1

END

;-------------------------------------------------------------------------------
;PRO lint_add_ccc,	$
;-------------------------------------------------------------------------------
;	data,		$	; LINT_PROTOTYPE input
;	type,		$	; LINT_PROTOTYPE input
;	word,		$	; LINT_PROTOTYPE input
;	extra,		$	; LINT_PROTOTYPE [input]
;	link,		$	; LINT_PROTOTYPE [input]
;	noline=noline,	$	; LINT_PROTOTYPE input
;	nochar=nochar		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Rajoute un message  data.decls[data.nor].c
;-------------------------------------------------------------------------------
;
;	IF N_ELEMENTS(noline) EQ 0 THEN noline = lint_get_noline(data)
;	IF N_ELEMENTS(nochar) EQ 0 THEN nochar = lint_get_nochar(data)
;
;	IF data.cla_on THEN BEGIN
;		data.decls[data.nor].c += LINTC_INT_TO_STR(noline) + !SEP2 + LINTC_INT_TO_STR(nochar) + !SEP2 + type + !SEP2 + word
;		IF N_ELEMENTS(extra) NE 0 THEN data.decls[data.nor].c += !SEP2 + extra
;		IF N_ELEMENTS(link)  NE 0 THEN data.decls[data.nor].c += !SEP2 + link
;		data.decls[data.nor].c += !SEP1
;	END
;
;END


;-------------------------------------------------------------------------------
PRO lint_add_cla,	$
;-------------------------------------------------------------------------------
	data,		$	; LINT_PROTOTYPE input
	type,		$	; LINT_PROTOTYPE input
	word,		$	; LINT_PROTOTYPE input
	extra,		$	; LINT_PROTOTYPE input
	link			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Rajoute un message  data.decls[data.nor].cla
;-------------------------------------------------------------------------------

	IF data.cla_on THEN BEGIN
		nb_data_noline_nochar = N_ELEMENTS(*data.noline)
		IF data.pos GE nb_data_noline_nochar THEN BEGIN
			noline = (*data.noline)[nb_data_noline_nochar-1]
			nochar = (*data.nochar)[nb_data_noline_nochar-1]
		END ELSE BEGIN
			noline = (*data.noline)[data.pos]
			nochar = (*data.nochar)[data.pos]
		END

		IF data.decls[data.nor].nbclas EQ N_ELEMENTS(*(data.decls[data.nor].cla))-1 THEN BEGIN
			; doubler le nombre d'entres
			tmp1 = *(data.decls[data.nor].cla)
			nb1 = N_ELEMENTS(tmp1)
			nb2 = 2*nb1
			;PRINT, 'cla(' + data.decls[data.nor].module+' ' + data.decls[data.nor].name + ') -> ' + val_to_str(nb2)
			tmp2 = REPLICATE (tmp1[0], nb2)
			tmp2[0:nb1-1] = tmp1
			PTR_FREE, data.decls[data.nor].cla
			data.decls[data.nor].cla = PTR_NEW (tmp2, /NO_COPY)
			tmp1 = 0 ; librer mmoire
		END

		(*data.decls[data.nor].cla)[data.decls[data.nor].nbclas].noline = noline
		(*data.decls[data.nor].cla)[data.decls[data.nor].nbclas].nochar = nochar
		(*data.decls[data.nor].cla)[data.decls[data.nor].nbclas].type   = type
		(*data.decls[data.nor].cla)[data.decls[data.nor].nbclas].word   = word
		(*data.decls[data.nor].cla)[data.decls[data.nor].nbclas].extra  = extra
		(*data.decls[data.nor].cla)[data.decls[data.nor].nbclas].link  = link
		data.decls[data.nor].nbclas++


;		IF type EQ 'KEYWORD' THEN BEGIN
;	
;			CASE STRUPCASE(word) OF
;				'FOR':		lint_add_ccc, data, type, word, "for (",	noline=noline, nochar=nochar
;				'WHILE':	lint_add_ccc, data, type, word, "while (",	noline=noline, nochar=nochar
;				'REPEAT':	lint_add_ccc, data, type, word, "do ",		noline=noline, nochar=nochar
;				'DO':		lint_add_ccc, data, type, word, "",		noline=noline, nochar=nochar
;
;				'IF':		lint_add_ccc, data, type, word, "if (",		noline=noline, nochar=nochar
;				'EQ':		lint_add_ccc, data, type, word, "==",		noline=noline, nochar=nochar
;				'GT':		lint_add_ccc, data, type, word, ">",		noline=noline, nochar=nochar
;				'GE':		lint_add_ccc, data, type, word, ">=",		noline=noline, nochar=nochar
;				'LE':		lint_add_ccc, data, type, word, "<=",		noline=noline, nochar=nochar
;				'LT':		lint_add_ccc, data, type, word, "<",		noline=noline, nochar=nochar
;				'NE':		lint_add_ccc, data, type, word, "!=",		noline=noline, nochar=nochar
;				'MOD':		lint_add_ccc, data, type, word, "%",		noline=noline, nochar=nochar
;				'OR':		lint_add_ccc, data, type, word, "||",		noline=noline, nochar=nochar
;				'AND':		lint_add_ccc, data, type, word, "&&",		noline=noline, nochar=nochar
;				ELSE:
;			END
;
;		END ELSE IF type EQ 'CALL_SYSTEM' THEN BEGIN
;
;			CASE STRUPCASE(word) OF
;
;				'RETURN':	lint_add_ccc, data, type, word, 'return'
;				'CONTINUE':	lint_add_ccc, data, type, word, 'continue'
;				'BREAK':	lint_add_ccc, data, type, word, 'break'
;				'GOTO':		lint_add_ccc, data, type, word, 'goto'
;
;				'PRINT':	lint_add_ccc, data, type, word, 'printf'
;				'LONG':		lint_add_ccc, data, type, word, '(int)'
;				'DOUBLE':	lint_add_ccc, data, type, word, '(double)'
;				'FLOAT':	lint_add_ccc, data, type, word, '(float)'
;				'STRLEN':	lint_add_ccc, data, type, word, 'strlen'
;				ELSE:
;
;			END
;
;
;		END
	END

END


;-------------------------------------------------------------------------------
PRO lint_add_msg_decls,	$
;-------------------------------------------------------------------------------
	decls,		$	; LINT_PROTOTYPE input
	premier,	$	; LINT_PROTOTYPE input
	noligne,	$		; LINT_PROTOTYPE input
	txt1,		$	; LINT_PROTOTYPE input
	txt2			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Rajoute un message  decls[premier].msg
;-------------------------------------------------------------------------------

	decls[premier].msg += LINTC_INT_TO_STR(noligne) + !SEP2 + LINTC_INT_TO_STR(0L) + !SEP2 + txt1 + !SEP2 + txt2 + !SEP1

END


;-------------------------------------------------------------------------------
FUNCTION lint_is_keyword,	$
;-------------------------------------------------------------------------------
	x,			$	; LINT_PROTOTYPE input
	keyword,		$	; LINT_PROTOTYPE output
	keyword_type			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne 1 si x est une chaine de la forme keyword=...
; Met dans keyword le nom du keyword
;-------------------------------------------------------------------------------

	tmp = STRSPLIT(x, '=', /EXTRACT)
	IF N_ELEMENTS(tmp) LT 2 THEN RETURN, 0
	IF STRPOS(tmp[0], "'") NE -1 THEN RETURN, 0
	IF STRPOS(tmp[0], '"') NE -1 THEN RETURN, 0
	IF STRPOS(tmp[0], '(') NE -1 THEN RETURN, 0

	keyword		= tmp[0]

	tmp1 = STRSPLIT(x, ':', /EXTRACT)
	keyword_type	= N_ELEMENTS(tmp1) EQ 2 ? tmp1[1] : tmp[0]

	RETURN, 1

END

;-------------------------------------------------------------------------------
FUNCTION lint_analyser_prototype,	$
;-------------------------------------------------------------------------------
	prototype,			$	; LINT_PROTOTYPE input
	nb_params_min,			$	; LINT_PROTOTYPE output
	nb_params_max,			$	; LINT_PROTOTYPE output
	nb_keywords,			$	; LINT_PROTOTYPE output
	params,				$	; LINT_PROTOTYPE output
	params_type,			$	; LINT_PROTOTYPE output
	params_extra,			$	; LINT_PROTOTYPE output
	keywords,			$	; LINT_PROTOTYPE output
	keywords_type,			$	; LINT_PROTOTYPE output
	keywords_ambigus			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
;	Entres:	prototype		liste de paramtres et keywords spars par des blancs
;
;	Sorties:
;			nb_params:		nombre de paramtres trouvs dans prototype
;			nb_keywords:		nomre de keywords trouvs dans prototype
;			keywords_ambigus:	string contenant les keywords ambigus
;-------------------------------------------------------------------------------

	nb_params_min		= 0L
	nb_params_max		= 0L
	nb_keywords		= 0L
	keywords_ambigus	= ''
	params			= ''	; contiendra un tableau de params
	params_type		= ''	; contiendra un tableau de params_type
	params_extra		= ''	; contiendra un tableau de params_extra
	keywords		= ''	; contiendra un tableau de keywords
	keywords_type		= ''	; contiendra un tableau de keywords_type

	IF prototype EQ '' THEN RETURN, ''

	tmp = STRSPLIT(prototype, ' ', /EXTRACT)
	FOR i=0L,N_ELEMENTS(tmp)-1 DO BEGIN
		IF tmp[i] EQ '' THEN BREAK
		IF lint_is_keyword(tmp[i], keyword, keyword_type) THEN BEGIN
			nb_keywords++
			keywords += keyword + ' '
			; "keyword=keyword:type"
			tmp1 = STRSPLIT (tmp[i], ':', /EXTRACT)
			keyword_type = tmp1[1]
			SWITCH keyword_type OF
				'???':
				'input':
				'output':	BREAK
				ELSE:		RETURN, 'INCORRECT keyword_type: "' + keyword_type + '"'
			END
			keywords_type += keyword_type + ' '
		END ELSE BEGIN
			; "param:type" ou "para:[type]" "type" ou "[type]"
			tmp1 = STRSPLIT (tmp[i], ':', /EXTRACT)
			param = N_ELEMENTS(tmp1) EQ 1 ? '???' : tmp1[0]
			param_type = N_ELEMENTS(tmp1) EQ 1 ? tmp[i] : tmp1[1]
			IF STRMID(param_type, 0, 1) EQ '[' THEN BEGIN
				; [type]
				nb_params_max++
			END ELSE BEGIN
				; type
				nb_params_min++
				nb_params_max++
			END
			params += param + ' '

			tmp1 = STRSPLIT(param_type, '#', /EXTRACT)
			param_type = tmp1[0]
			param_extra = N_ELEMENTS(tmp1) EQ 1 ? '*' : STRJOIN(tmp1[1:*], '#')
			SWITCH param_type OF
				'???':
				'[???]':
				'input':
				'output':
				'[input]':
				'[output]':	BREAK
				ELSE: 		RETURN, 'INCORRECT param_type: "' + param_type + '"'
			END
			params_type += param_type  + ' '
			params_extra += param_extra  + ' '
		END
	END

	; Recherche des KEYWORD ambigus
	liste_keywords = STRSPLIT(keywords, /EXTRACT)
	FOR i=0L, nb_keywords-1 DO BEGIN
		keyword = liste_keywords[i]
		FOR j=0L,nb_keywords-1 DO BEGIN
			IF j EQ i THEN CONTINUE
			IF STRMID(STRUPCASE(liste_keywords[j]), 0, STRLEN(keyword)) EQ STRUPCASE(keyword) THEN BEGIN
				keywords_ambigus += (keywords_ambigus EQ '' ? '' : ' ') + keyword
				BREAK
			END
		END
	END

	; Recherche des paramtres optionnels qui ne sont pas  la fin
	tmp = STRSPLIT (params_type, /EXTRACT)
	premiere_lettre = STRMID(tmp, 0, 1)
	ind = WHERE (premiere_lettre EQ '[', nb)
	IF ind[0] NE -1 THEN BEGIN
		ind_attendu = N_ELEMENTS(tmp) - nb + LINDGEN(nb)
		IF ~ARRAY_EQUAL(ind, ind_attendu) THEN BEGIN
			RETURN, 'optional parameter must be at the end'
		END
	END

	RETURN, ''
END

;-------------------------------------------------------------------------------
FUNCTION lint_get_lint_prototype,	$
;-------------------------------------------------------------------------------
	ligne				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne ce qui se dans un commentaire aprs "LINT_PROTOTYPE"
;-------------------------------------------------------------------------------

	prototype = ''
	
	ligne1 = ligne
	pos = STRPOS(ligne1, ';')
	IF pos NE -1 THEN BEGIN
		ligne1 = STRMID(ligne1, pos+1)
		pos = STRPOS(ligne1, 'LINT_PROTOTYPE')
		IF pos NE -1 THEN BEGIN
			prototype = STRMID(ligne1, pos+STRLEN('LINT_PROTOTYPE'))
			prototype = STRTRIM(prototype, 2)
			pos = STRPOS(prototype, ' ')
			IF pos NE -1 THEN prototype = STRMID(prototype, 0, pos)
			pos = STRPOS(prototype, STRING(9b))
			IF pos NE -1 THEN prototype = STRMID(prototype, 0, pos)
		END
	END

	RETURN, prototype

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_lint_variables,	$
;-------------------------------------------------------------------------------
	ligne				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne ce qui se trouve dans un commentaire aprs "LINT_VARIABLES"
;-------------------------------------------------------------------------------

	ligne1 = ligne
	pos = STRPOS(ligne1, ';')
	IF pos NE -1 THEN BEGIN
		ligne1 = STRMID(ligne1, pos+1)
		FOR i=0L,STRLEN(ligne1)-1 DO BEGIN
			IF STRMID(ligne1, i, 1) EQ ' ' || STRMID(ligne1, i, 1) EQ STRING(9b) THEN CONTINUE
			IF STRMID(ligne1, i, STRLEN('LINT_VARIABLES')) EQ 'LINT_VARIABLES' THEN BEGIN
				RETURN, STRMID(ligne1, i+STRLEN('LINT_VARIABLES'))
			END ELSE BEGIN
				RETURN, ''
			END
		END
	END

	RETURN, ''

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_decls_by_name_passe1,	$
;-------------------------------------------------------------------------------
	decls,				$	; LINT_PROTOTYPE input
	hash,				$	; LINT_PROTOTYPE input
	name					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne WHERE(decls.name EQ name) en utilisant la table hash.name.
;-------------------------------------------------------------------------------

	cle = (BYTE(STRMID(name, 0, 1)))[0]
	p = hash.name[cle]

	IF ~PTR_VALID(p) THEN RETURN, -1

	liste = *p
	ind = WHERE (decls[liste].name EQ name)
	IF ind[0] EQ -1 THEN RETURN, ind

	RETURN, liste[ind]

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_decls_by_object,	$
;-------------------------------------------------------------------------------
	decls,				$	; LINT_PROTOTYPE input
	hash,				$	; LINT_PROTOTYPE input
	object					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne WHERE(decls.object EQ object) en utisant la table hash.object
;-------------------------------------------------------------------------------

	cle = (BYTE(STRMID(object, 0, 1)))[0]
	p = hash.object[cle]

	IF ~PTR_VALID(p) THEN RETURN, -1

	liste = *p
	ind = WHERE (decls[liste].object EQ object)
	IF ind[0] EQ -1 THEN RETURN, ind

	RETURN, liste[ind]

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_decls_by_module,	$
;-------------------------------------------------------------------------------
	decls,				$	; LINT_PROTOTYPE input
	hash,				$	; LINT_PROTOTYPE input
	module					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne WHERE(decls.module EQ module) en utisant la table hash.module
;-------------------------------------------------------------------------------

	cle = (BYTE(STRMID(module, 0, 1)))[0]
	p = hash.module[cle]

	IF ~PTR_VALID(p) THEN RETURN, -1

	liste = *p
	ind = WHERE (decls[liste].module EQ module)
	IF ind[0] EQ -1 THEN RETURN, ind

	RETURN, liste[ind]

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_decls_by_name_passe2,	$
;-------------------------------------------------------------------------------
	data,				$	; LINT_PROTOTYPE input
	name					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne WHERE(data.decls.name EQ name) en utilisant la table data.hash.name.
;-------------------------------------------------------------------------------

	cle = (BYTE(STRMID(name, 0, 1)))[0]
	p = data.hash.name[cle]

	IF ~PTR_VALID(p) THEN RETURN, -1

	liste = *p
	ind = WHERE (data.decls[liste].name EQ name)
	IF ind[0] EQ -1 THEN RETURN, ind

	RETURN, liste[ind]

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_nbchars_doc,	$
;-------------------------------------------------------------------------------
	ligne				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne le nombre de caractres autres que SPACE, TAB, ';' et '-'
;-------------------------------------------------------------------------------

	nb = 0L
	FOR i=0L,STRLEN(ligne)-1 DO BEGIN
		char = STRMID(ligne, i, 1)
		IF char NE ' ' && char NE STRING(9b) && char NE ';' && char NE '-' THEN nb++
	END

	RETURN, nb

END

;-------------------------------------------------------------------------------
FUNCTION lint_doc_to_html,		$
;-------------------------------------------------------------------------------
	s,				$	; LINT_PROTOTYPE input
	first=first,			$	; LINT_PROTOTYPE input
	rouge=rouge,			$	; LINT_PROTOTYPE input
	txt=txt					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; /first pour obtenir le "titre" de la doc qui sera affich dans index.html:
;	pour spdsoft: retourner les lignes contenant "CREATED BY" et "LastChangedBy"
;	sinon : retourner la premire ligne pour cl
;
; /txt pour ne pas convertir les caractres en html
;-------------------------------------------------------------------------------

	COMMON COMMON_LINT, common_lint_infos

	IF KEYWORD_SET(txt) THEN BEGIN
		s1 = s
	END ELSE BEGIN
		s1 = LINTC_GET_HTML (s)
	END

	target = common_lint_infos.target

	tmp1 = STRSPLIT (s1, STRING(10b), /EXTRACT)
	s2 = ''
	FOR i=0L,N_ELEMENTS(tmp1)-1 DO BEGIN
		IF tmp1[i] EQ ';-------------------------------------------------------------------------------' THEN CONTINUE
		tmp2 = tmp1[i]
		IF target EQ 'cl' && STRMID(tmp2, 0, 1) EQ ';' THEN tmp2 = STRMID(tmp2, 1)

		IF KEYWORD_SET(first) THEN BEGIN
			IF KEYWORD_SET(rouge) THEN BEGIN
				pos1 = STRPOS(tmp2, '((')
				IF pos1 NE -1 THEN BEGIN
					pos2 = STRPOS(tmp2, '))', pos1+2)
					RETURN, '<span class="COMMENT_CODE">('+STRMID(tmp2, pos1+2, pos2-pos1-2)+')</span>'
				END ELSE BEGIN
					RETURN, ''
				END
			END
			IF STRMID(tmp2, 1, 1) EQ '(' && STRMID(tmp2, 1, 2) NE '((' THEN BEGIN
				pos = STRPOS(tmp2, ')', 1)
				tmp2 = '<span class="COMMENT_CATEGORY">'+STRMID(tmp2, 2, pos-2)+'</span>'+STRMID(tmp2, pos+1)
			END
			pos1 = STRPOS(tmp2, '((')
			IF pos1 NE -1 THEN BEGIN
				pos2 = STRPOS(tmp2, '))', pos1+2)
				tmp2 = STRMID(tmp2, 0, pos1) + STRMID(tmp2, pos2+2)
			END
			IF target EQ 'spdsoft' THEN BEGIN
				IF STRPOS(tmp2, "CREATED BY") NE -1 THEN BEGIN			; svn spdsoft
				END ELSE IF STRPOS(tmp2, "$LastChangedBy") NE -1 THEN BEGIN	; svn spdsoft
				END ELSE BEGIN
					CONTINUE
				END
			END ELSE BEGIN
				RETURN, tmp2
			END
		END
		s2 += tmp2 + STRING(10b)
	END
	RETURN, s2

END


;-------------------------------------------------------------------------------
FUNCTION lint_supprimer_commentaire_c,	$
;-------------------------------------------------------------------------------
	line				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Traite une ligne de code C et retourne la ligne sans commentaire // et /* ... */
;-------------------------------------------------------------------------------

	COMMON COMMON_LINT_SUPPRIMER_COMMENTAIRE_C,	inside_string, inside_comment

	IF N_ELEMENTS(inside_string) EQ 0 THEN BEGIN
		inside_string = 0
		inside_comment = 0
	END

	ligne1 = ''

	pos = 0L

	len = STRLEN(line)

	WHILE pos LT len DO BEGIN

		IF inside_string THEN BEGIN
			ligne1 += STRMID(line, pos, 1)
			IF STRMID(line, pos, 1) EQ '"' && (STRMID(line, pos-1, 1) NE '\' || STRMID(line, pos-2, 1) EQ '\') THEN BEGIN
				inside_string = 0
				pos++
				CONTINUE
			END ELSE BEGIN
				pos++
				CONTINUE
			END
		END

		IF inside_comment THEN BEGIN
			IF STRMID(line, pos, 2) EQ '*/' THEN BEGIN
				inside_comment = 0
				pos += 2
				CONTINUE
			END ELSE BEGIN
				pos++
				CONTINUE
			END
		END


		IF STRMID(line, pos, 2) EQ '//' THEN BEGIN
			BREAK ; commentaire sur une ligne
		END

		IF STRMID(line, pos, 1) EQ '"' && STRMID(line, pos-1, 1) NE "'" THEN BEGIN
			inside_string = 1
		END

		IF inside_string EQ 0 && STRMID(line, pos, 2) EQ '/*' THEN BEGIN
			inside_comment = 1
		END

		IF inside_comment EQ 0 THEN BEGIN
			ligne1 += STRMID(line, pos, 1)
		END

		pos++

	END

	RETURN, ligne1

END



;-------------------------------------------------------------------------------
PRO lint_decl,				$
;-------------------------------------------------------------------------------
	liste,				$	; LINT_PROTOTYPE input
	noliste,			$	; LINT_PROTOTYPE input
	decls,				$	; LINT_PROTOTYPE input
	premier,			$	; LINT_PROTOTYPE input
	hash,				$	; LINT_PROTOTYPE input
	fdall,				$	; LINT_PROTOTYPE input
	repertoire,			$	; LINT_PROTOTYPE input
	special=special				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Analyse le fichier liste[noliste].filename et rajoute un lment dans decls par dclaration de FUNCTION/PRO trouves:
;
;							cl_interne	cl_externe	cl_themis	autre
;
; - ERROR AMBIGUOUS KEYWORDS				MSG+EXIT	MSG+EXIT	MSG+EXIT	MSG+EXIT
; - WARNING WORD "FUNCTION" OR "PRO" NOT IN UPPERCASE	MSG+EXIT	MSG+EXIT	-		-
; - WARNING FUNCTION OR PRO NAME NOT IN LOWERCASE	MSG+EXIT	MSG+EXIT	-		-
; - ERROR FUNCTION OR PRO NAME REDEFINED		MSG+EXIT	MSG+EXIT	MSG+EXIT	MSG+EXIT
;
; special=special: 1 si le module ne contient aucune "FUNCTION" ou "PRO"
;-------------------------------------------------------------------------------

	COMMON COMMON_NOLIGNE_ALL, noligne_all
	COMMON COMMON_LINT, common_lint_infos
	COMMON COMMON_TYPES, types, nb_types
	COMMON COMMON_INCLUDE, list_include_analysed

	IF N_ELEMENTS(special) EQ 0 THEN special = 0

	target = common_lint_infos.target

	doc_Berkeley = ''

	IF N_ELEMENTS(noligne_all) EQ 0 THEN noligne_all = 1L


	module			= liste[noliste].filename
	check_syntax		= liste[noliste].check_syntax
	check_space		= liste[noliste].check_space
	check_case_sensitive	= liste[noliste].check_case_sensitive
	check_unused		= liste[noliste].check_unused
	check_stop_debug	= liste[noliste].check_stop_debug
	check_doc		= liste[noliste].check_doc
	is_cl_interne		= liste[noliste].is_cl_interne
	is_cl_externe		= liste[noliste].is_cl_externe
	is_cl_other		= liste[noliste].is_cl_other
	is_c			= liste[noliste].is_c
	include_dir		= STRSPLIT (dirname(module)+' '+liste[noliste].include_dir, /EXTRACT)
	tout_premier		= premier
	courant			= -1
	inherits		= ''
	ligne			= ''
	noligne			= 0L

	is_Berkeley		= 0 ; car "general/misc/regplot.pro" est vide!

	nb1			= 0 ; nb '{' ouvertes
	nb2			= 0 ; nb '(' ouvertes
	inside_macroc		= 0 ; 1 si on est dans une macroc en cours avec des \
	inside_functionc	= 0 ; 1 si on est dans une functionc en cours
	inside_typec		= 0 ; 1 si on est dans un typec en cours

	module_org = module
	module_cpp = module
	is_system		= 0
	is_cpp			= 0
	
	IF STRMID(dirname(module), 0, 1) EQ '/' && STRMID(module, STRLEN(module)-2, 2) EQ '.h' THEN BEGIN

		FOR i=0L,N_ELEMENTS(!SYSTEM_INCLUDE_DIR)-1 DO BEGIN
			IF chaine_contient_debut(module, !SYSTEM_INCLUDE_DIR[i] + '/') THEN is_system = 1
		END

		module_cpp = 'slash/' + STRMID(dirname(module), 1) + '/' + basename(module)
		module1 = repertoire + '/slash/' + STRMID(dirname(module), 1) + '/cpp_' + basename(module)
		mkdir_p, dirname(module1)
		IF fichier_existe(module1) THEN BEGIN
			code = detruire (module1)
		END
		cmd = 'cpp -dD ' + module + ' > ' + module1
		SPAWN, cmd
		module = module1
		is_cpp = 1
	END

	IF N_ELEMENTS(types) EQ 0 THEN BEGIN
		types = ''
		nb_types = 0L
	END

	IF N_ELEMENTS(list_include_analysed) EQ 0 THEN BEGIN
		list_include_analysed = ''
	END

	OPENR, fd, module, /GET_LUN

	IF is_c THEN BEGIN
		; Crer une entre 'GLOBALC'
		premier++
		decls[premier].module			= module_cpp
		decls[premier].function_pro		= 'GLOBALC'
		decls[premier].name			= 'global'
		decls[premier].check_syntax		= check_syntax
		decls[premier].check_space		= check_space
		decls[premier].check_case_sensitive	= check_case_sensitive
		decls[premier].check_unused		= check_unused
		decls[premier].check_stop_debug		= check_stop_debug
		decls[premier].check_doc		= check_doc
		decls[premier].is_cl_interne		= is_cl_interne
		decls[premier].is_cl_externe		= is_cl_externe
		decls[premier].is_cl_other		= is_cl_other
		decls[premier].is_c			= is_c
		decls[premier].noligne1			= 1
		decls[premier].noligne2			= 1
		decls[premier].nblignes			= 0
		decls[premier].is_system		= is_system
		decls[premier].is_extern		= 0
		lint_ajouter_hash, decls, premier, hash
	END

	WHILE ~EOF(fd) DO BEGIN

		noligne++

		READF, fd, ligne

		IF noligne EQ 1 THEN BEGIN
			is_Berkeley = STRMID(ligne, 0, 2) EQ ';+'
		END

		IF ~special THEN PRINTF, fdall, STRING(noligne_all, FORMAT='(I6)') + ' ' + STRING(module, FORMAT='(A-50)') + (STRSPLIT(lint_doc_to_html(ligne), STRING(10b), /EXTRACT))[0]
		noligne_all++

		IF is_c THEN BEGIN

			; le module est ecrit en C

			ligne_nocomment = lint_supprimer_commentaire_c (ligne)

			mots = STRSPLIT (ligne_nocomment, /EXTRACT)
			IF mots[0] EQ '#include' || (mots[0] EQ '#' && mots[1] EQ 'include') THEN BEGIN

				pos = STRPOS (ligne_nocomment, 'include')
				nom_include = STRTRIM (STRMID(ligne_nocomment, pos+8), 2)
				nom_include = (STRSPLIT (nom_include, /EXTRACT))[0]
				possibilites = !SYSTEM_INCLUDE_DIR + '/' + STRMID(nom_include, 1, STRLEN(nom_include)-2)
				possibilites = [include_dir + '/' + STRMID(nom_include, 1, STRLEN(nom_include)-2), possibilites]

				FOR i=0L,N_ELEMENTS(possibilites)-1 DO BEGIN
					IF ~fichier_existe(possibilites[i]) THEN possibilites[i] = ''
				END

				; garder la possibilt qui a le plus de mots en commun avec module_org
				trouve = 0
				FOR i=STRLEN(module_org)-1,0,-1 DO BEGIN
					cherche = STRMID(module_org, 0, i)
					FOR k=0L,N_ELEMENTS(possibilites)-1 DO BEGIN
						IF possibilites[k] EQ '' THEN CONTINUE
						IF STRMID(possibilites[k], 0, i) EQ cherche THEN BEGIN
							notrouve = k
							trouve = 1
							BREAK
						END
					END
					IF trouve THEN BREAK
				END
				IF ~trouve THEN notrouve = -1

				IF trouve THEN BEGIN
					; rajouter ce fichier  liste (sauf s'il y est dja)
					IF (WHERE (liste.filename EQ possibilites[notrouve]))[0] EQ -1 THEN BEGIN
						elt = liste[noliste]
						elt.filename = possibilites[notrouve]
						liste = [liste , elt]
					END

					IF ~is_cpp THEN BEGIN
						; rajouter ce fichier  inherits
						tmp = possibilites[notrouve]
						IF STRMID(tmp, 0, 1) EQ '/' AND STRMID(tmp, STRLEN(tmp)-2, 2) EQ '.h' THEN tmp = 'slash/' + STRMID(tmp, 1)
						tmp1 = STRSPLIT(inherits, /EXTRACT)
						IF (WHERE(tmp1 EQ tmp))[0] EQ -1 THEN BEGIN
							inherits += ' ' + tmp
						END
					END
				END
				IF ~trouve THEN PRINT, nom_include + ' NOT FOUND IN ' + module
				CONTINUE
			END

			IF nb1 EQ 0 AND nb2 EQ 0 THEN BEGIN

				pos_parenthese		= STRPOS(ligne_nocomment, '(')
				pos_egal		= STRPOS(ligne_nocomment, '=')

				; garder ce qui se trouve avant la parenthese
				ligne1 = pos_parenthese EQ -1 ? ligne_nocomment : STRMID(ligne_nocomment, 0, pos_parenthese)

				; ok1: FUNCTIONC
				ok1 = (STRMID(mots[0], 0, 1) NE '#') && (pos_parenthese NE -1) && (pos_egal EQ -1) && ~inside_macroc && ~inside_functionc && ~inside_typec

				; ok2: MACROC
				ok2 = (mots[0] EQ '#define' || (mots[0] EQ '#' && mots[1] EQ 'define')) && ~inside_macroc && ~inside_functionc && ~inside_typec

				; ok3: TYPEC
				ok3 = (mots[0] EQ 'typedef') && ~inside_macroc && ~inside_functionc && ~inside_typec

				; ok4: en dehors de toutes dclarations: on met ca dans GLOBALC	
				ok4 = ~ok1 && ~ok2 && ~ok3 && ~inside_macroc && ~inside_functionc && ~inside_typec

				IF ok1 || ok2 || ok3 || ok4 THEN BEGIN	

					IF ok4 THEN BEGIN

						name = 'global'
						is_extern = 0
						function_pro = 'GLOBALC'

					END ELSE IF ok3 THEN BEGIN

						IF N_ELEMENTS(mots) GE 3 && STRMID(mots[2], 0, 2) EQ '(*' THEN BEGIN
							; ex: "typedef int (*__gconv_fct) (struct __gconv_step *, struct __gconv_step_data *,"
							; ex: "typedef      t_err   (* t_function) (char *)"
							tmp = STRJOIN (mots[2:*], ' ')
							name = STRTRIM(STRMID(tmp, 2), 2)
							pos = STRPOS(name, ')')
							IF pos NE -1 THEN name = STRMID (name, 0, pos)
						END ELSE BEGIN
							name = 'TYPE C' ; nom qui ne peut pas exister. On connaitra le vrai nom plus tard
						END
						is_extern = 0
						function_pro = 'TYPEC'
						inside_typec = 1

					END ELSE IF ok2 THEN BEGIN

						tmp = STRMID (ligne_nocomment, STRPOS(ligne_nocomment, 'define'))
						tmp = STRSPLIT (tmp, /EXTRACT)
						name = tmp[1]
						pos_parenthese = STRPOS(name, '(')

						IF pos_parenthese NE -1 THEN BEGIN
							; garder ce qui se trouve avant le '('
							name = STRMID(name, 0, pos_parenthese)
						END

						is_extern = 0
						function_pro = 'MACROC'
						inside_macroc = 1

					END ELSE IF ok1 THEN BEGIN

						; ex: "int EXPORT evaluer_tableau (int argc, void *argv[]) {"
						; ex: "double d_mod(double *x, double *y) {"

						; garder le nom avant le '('
						tmp = STRSPLIT(STRMID(ligne_nocomment, 0, pos_parenthese), /EXTRACT)
						name = tmp[N_ELEMENTS(tmp)-1]
						IF STRMID(name, 0, 1) EQ '*' THEN name = STRMID(name, 1)	; ex: "char *get_version_local ("

						function_pro = 'FUNCTIONC'
						is_extern = mots[0] EQ 'extern'
						inside_functionc = 1

					END

					IF name NE '' THEN BEGIN

						; dja dclar dans ce module ?
						ind1 = lint_get_decls_by_name_passe1 (decls, hash, name)
						IF ind1[0] NE -1 THEN BEGIN
							ind2 = WHERE (decls[ind1].function_pro EQ function_pro AND decls[ind1].module EQ module_cpp)
							ind1 = ind2[0] EQ -1 ? -1 : ind1[ind2]
						END

						IF ind1[0] NE -1 THEN BEGIN

							; ex: "FINITE" dans get_data3d.c
							; ex: "facteur" dans expression.c
							; le symbole est redfini: on utilise cette nouvelle dclaration

							IF function_pro EQ 'GLOBALC' THEN BEGIN
								courant = ind1[0]
								;IF decls[courant].noligne1 EQ -1 THEN BEGIN
									; ces valeurs taient inconnues  l'initialisation
									;decls[courant].noligne1			= noligne
									;decls[courant].noligne2			= noligne
								;END
							END ELSE BEGIN
								courant = ind1[0]
								decls[courant].code = ''
								PRINT, name+' REDEFINED ? IN ' + module_cpp
							END

						END ELSE BEGIN

							premier++
							courant = premier

						END

						IF ind1[0] NE -1 && function_pro EQ 'GLOBALC' THEN BEGIN
						END ELSE BEGIN
							;print,'ADD '+module+'*'+name
							decls[courant].module			= module_cpp
							decls[courant].function_pro		= function_pro
							decls[courant].name			= name
							decls[courant].check_syntax		= check_syntax
							decls[courant].check_space		= check_space
							decls[courant].check_case_sensitive	= check_case_sensitive
							decls[courant].check_unused		= check_unused
							decls[courant].check_stop_debug		= check_stop_debug
							decls[courant].check_doc		= check_doc
							decls[courant].is_cl_interne		= is_cl_interne
							decls[courant].is_cl_externe		= is_cl_externe
							decls[courant].is_cl_other		= is_cl_other
							decls[courant].is_c			= is_c
							decls[courant].noligne1			= noligne
							decls[courant].noligne2			= noligne
							decls[courant].nblignes			= 1
							decls[courant].is_system		= is_system
							decls[courant].is_extern		= is_extern
							IF name NE 'TYPE C' THEN BEGIN
								IF courant EQ premier THEN lint_ajouter_hash, decls, courant, hash
								IF function_pro EQ 'TYPEC' THEN BEGIN
									types = nb_types EQ 0 ? name : [types,name]
									nb_types++
									decls[courant].nblignes = noligne-decls[courant].noligne1+2
								END
							END

							;PRINT,'  ',decls[courant].function_pro+' '+decls[courant].name+' ()'
						END

					END

				END

			END 


			IF inside_macroc && STRMID(ligne, STRLEN(ligne)-1, 1) EQ '\' THEN BEGIN
				; MACROC qui continue
				decls[courant].nblignes = noligne-decls[courant].noligne1+2
			END ELSE BEGIN
				inside_macroc = 0
			END

			IF courant NE -1 THEN BEGIN
				decls[courant].code += ligne+STRING(10b) ; pour le code C
				IF function_pro EQ 'GLOBALC' THEN BEGIN
					decls[courant].nblignes++
				END
			END

			inside_string_simple = 0
			inside_string_double = 0
			FOR i=0L,STRLEN(ligne_nocomment)-1 DO BEGIN
				c = STRMID(ligne_nocomment, i, 1)
				IF inside_string_simple THEN BEGIN
					IF c EQ "'" &&  (STRMID(ligne_nocomment, i-1, 1) NE '\' || STRMID(ligne_nocomment, i-2, 1) EQ '\') THEN BEGIN
						inside_string_simple = 0
					END
					CONTINUE
				END
				IF inside_string_double THEN BEGIN
					IF c EQ '"' &&  (STRMID(ligne_nocomment, i-1, 1) NE '\' || STRMID(ligne_nocomment, i-2, 1) EQ '\') THEN BEGIN
						inside_string_double = 0
					END
					CONTINUE
				END
				IF c EQ '"' THEN BEGIN
					inside_string_double = 1
					CONTINUE
				END
				IF c EQ "'" THEN BEGIN
					inside_string_simple = 1
					CONTINUE
				END
				IF c EQ '{' THEN nb1++
				IF c EQ '}' THEN nb1--
				IF c EQ '(' THEN nb2++
				IF c EQ ')' THEN nb2--
			END

			IF inside_functionc || inside_typec THEN BEGIN
				IF nb1 EQ nb2 THEN BEGIN
					tmp = STRTRIM (ligne_nocomment, 2)
					IF mots[0] EQ '}' || STRMID (tmp, STRLEN(tmp)-1, 1) EQ ';' || STRMID (tmp, STRLEN(tmp)-1, 1) EQ '}' THEN BEGIN
						; fin de FUNCTIONC ou TYPEC
						decls[courant].nblignes = noligne-decls[courant].noligne1+1
						inside_functionc = 0
						inside_typec = 0
					END
				END
			END


			IF courant NE -1 && decls[courant].name EQ "TYPE C" THEN BEGIN
				IF nb1 EQ nb2 THEN BEGIN
					; on connait peut-tre maintenant le nom du type
					pos = STRPOS (ligne_nocomment, '}', /REVERSE_SEARCH)
					IF pos NE -1 THEN ligne_nocomment = STRMID(ligne_nocomment, pos+1)
					pos = STRPOS (ligne_nocomment, ';')
					IF pos NE -1 THEN BEGIN
						name = STRMID (ligne_nocomment, 0, pos)
						pos = STRPOS (name, '[')
						IF pos NE -1 THEN name = STRMID(name, 0, pos)
						name = STRSPLIT (name, /EXTRACT)
						name = name[N_ELEMENTS(name)-1]
						IF STRMID(name, 0, 1) EQ '*' THEN name = STRMID(name, 1)
						IF name NE '' THEN BEGIN
							decls[courant].name = name
							IF courant EQ premier THEN lint_ajouter_hash, decls, courant, hash
							types = nb_types EQ 0 ? name : [types,name]
							nb_types++
							; fin de TYPEC
							decls[courant].nblignes = noligne-decls[courant].noligne1+2
						END ELSE BEGIN
							;stop
						END
					END ELSE BEGIN
						;stop
					END
				END ELSE BEGIN
					;stop
				END
			END

			CONTINUE
		END

		mots = STRSPLIT (ligne, /EXTRACT)
		IF STRMID(mots[0], 0, 1) EQ '@' THEN BEGIN
			pos = STRPOS (ligne, '@')
			nom_include = STRTRIM (STRMID(ligne, pos+1), 2)
			possibilites = [ nom_include, nom_include+'.pro', dirname(module)+'/'+nom_include, dirname(module)+'/'+nom_include+'.pro' ]
			FOR i=0L,N_ELEMENTS(possibilites)-1 DO BEGIN
				IF fichier_existe(possibilites[i]) THEN BEGIN
					; rajouter ce fichier  liste (sauf s'il y est dja)
					IF (WHERE (liste.filename EQ possibilites[i]))[0] EQ -1 THEN BEGIN
						elt = liste[noliste]
						elt.filename = possibilites[i]
						liste = [liste , elt]
						BREAK
					END
				END
			END
		END


		premier_mot = STRUPCASE(mots[0])

		IF premier NE -1 THEN BEGIN
			IF STRMID(decls[premier].name, 7, 8, /REVERSE) EQ 'define' THEN BEGIN
				; Y a t-il inherits ? (pas dans les commentaires)
				ligne1 = ligne
				LINTC_SUPPRIMER_COMMENTAIRES_IDL, ligne1
				mots1 = STRSPLIT(ligne1, /EXTRACT)
				nbmots1 = N_ELEMENTS(mots1)
				FOR i=0L,nbmots1-2 DO BEGIN ; pas le dernier mot
					tmp = STRSPLIT (mots1[i], ',', /EXTRACT)
					IF STRUPCASE(tmp[N_ELEMENTS(tmp)-1]) EQ 'INHERITS' THEN BEGIN
						tmp = STRLOWCASE(mots1[i+1])
						len = 0L
						pos = LINTC_GET_NAME_IDL (tmp, 0, len)
						tmp = STRMID(tmp, pos, len)

						inherits += ' ' + tmp
					END
				END
			END
		END

		IF special THEN BEGIN
			IF STRMID(ligne, 0, 1) EQ ";" || STRCOMPRESS(ligne, /REMOVE_ALL) EQ '' THEN BEGIN
			END ELSE BEGIN
				IF premier EQ tout_premier THEN BEGIN
					name = STRLOWCASE(basename(module)) ; ex: "projects/maven/swea/mvn_swe_com.pro" -> "mvn_swe_com.pro"
					; L'include a t-il dja t dclar ?
					; pas de message pour les INCLUDEC
					redefined = ''
					IF ~is_c THEN BEGIN
						ind = WHERE (decls.function_pro EQ 'INCLUDE'+(is_c ? 'C':'') AND decls.name EQ name)
						IF ind[0] NE -1 THEN BEGIN
							redefined = ' (found in ' + decls[ind[0]].module+')'
						END
					END
					premier++
					decls[premier].module			= module
					decls[premier].function_pro		= 'INCLUDE'+(is_c ? 'C':'')
					decls[premier].object			= ''
					decls[premier].name			= STRLOWCASE(basename(module)) ; ex: "projects/maven/swea/mvn_swe_com.pro" -> "mvn_swe_com.pro"
					decls[premier].check_syntax		= check_syntax
					decls[premier].check_space		= check_space
					decls[premier].check_case_sensitive	= check_case_sensitive
					decls[premier].check_unused		= check_unused
					decls[premier].check_stop_debug		= check_stop_debug
					decls[premier].check_doc		= check_doc
					decls[premier].is_cl_interne		= is_cl_interne
					decls[premier].is_cl_externe		= is_cl_externe
					decls[premier].is_cl_other		= is_cl_other
					decls[premier].is_c			= is_c
					decls[premier].noligne1			= noligne-1
					decls[premier].noligne2			= noligne-1
					decls[premier].lint_variables		= ''
					decls[premier].nb_params_max		= 0
					decls[premier].nb_keywords		= 0
					decls[premier].prototype		= ''
					decls[premier].nb_prototypes		= 0
					decls[premier].nbchars_doc		= 0
					IF redefined THEN BEGIN
						my_print, lint_get_message(module=module, noligne=noligne) + 'INCLUDE'+(is_c ? 'C':'')+' NAME REDEFINED ' + '"' + name + '" ' + redefined
						lint_add_msg_decls, decls, premier, -2L, 'REDEFINED', '"' + decls[premier].name + '" ' + redefined
					END
				END
			END
		END

		IF premier_mot NE "FUNCTION" && premier_mot NE "PRO" && premier_mot NE "COMMON" THEN BEGIN

			; ni FUNCTION, ni PRO, ni COMMON

			IF premier NE tout_premier THEN BEGIN ; "FUNCTION", "PRO" ou "COMMON" a donc dja t trouv

				; Dclaration LINT_VARIABLES ?
				lint_variables = lint_get_lint_variables (ligne)
				IF lint_variables NE '' THEN BEGIN
					decls[premier].lint_variables += lint_variables
					;my_print, module+'('+name+') LINT_VARIABLES ' + lint_variables
				END

				; Nombre de lignes de doc
				; ligne commencant par ";" ou ligne vide
				IF STRMID(ligne, 0, 1) EQ ";" || STRCOMPRESS(ligne, /REMOVE_ALL) EQ '' THEN BEGIN
					IF noligne EQ decls[premier].noligne2+1+decls[premier].nblignes_doc THEN BEGIN
						decls[premier].nblignes_doc++
					
						; Y a t-il des caractres autres que SPACE TAB ';' '-' ? 

						decls[premier].nbchars_doc += lint_get_nbchars_doc (ligne)
						decls[premier].doc += ligne+STRING(10b)

					END ELSE BEGIN
						lint_unused = LINTC_GET_CORRECT_LINE (ligne)
						decls[premier].code += ligne+STRING(10b)
						tmp = ligne
						LINTC_SUPPRIMER_COMMENTAIRES_IDL, tmp
						decls[premier].code_nocomment += tmp+STRING(10b)
					END
				END ELSE BEGIN
					lint_unused = LINTC_GET_CORRECT_LINE (ligne)
					decls[premier].code += ligne+STRING(10b)
					tmp = ligne
					LINTC_SUPPRIMER_COMMENTAIRES_IDL, tmp
					decls[premier].code_nocomment += tmp+STRING(10b)
				END

				; Nombre de lignes de la routine

				; Cette ligne ne fonctionne que si la routine se termine par une ligne dommenacant par 'END
				;IF premier_mot EQ 'END' THEN decls[premier].nblignes = noligne-decls[premier].noligne1+1

				; Cette ligne fonctionne mme si la routine se termine par "return,tname & end"
				;IF decls[premier].nblignes EQ 0 THEN decls[premier].nblignes = noligne-decls[premier].noligne1+1

				; pour la SOLARSOFT
				IF STRPOS(STRUPCASE(ligne), 'END') NE -1 THEN decls[premier].nblignes = noligne-decls[premier].noligne1+1
			END

			IF is_Berkeley && ~special THEN IF STRMID(ligne, 0, 1) EQ ';' THEN doc_Berkeley += ligne+STRING(10b)

			CONTINUE
		END

		; soit FUNCTION, soit PRO, soit COMMON

		; Dterminer object et name  partir de mots[1] (peut contenir "::")
		; ------------------------------------------------------------------
		tmp = STRSPLIT (mots[1], "::", /EXTRACT)
		object = N_ELEMENTS(tmp) EQ 2 ? tmp[0] : ""
		name = N_ELEMENTS(tmp) EQ 2 ? tmp[1] : tmp[0]
		pos = STRPOS(name, ',')
		IF pos NE -1 THEN name = STRMID(name, 0, pos) ; ex: "pro nwin, x, y, x2, y2, to_data=data, to_normalized=norm, $"

		; Renommer object__define en object::define
		; -----------------------------------------
		IF STRLOWCASE(STRMID(name, STRLEN(name)-8)) EQ '__define' THEN BEGIN
			object = STRMID(name, 0, STRLEN(name)-8)
			name = STRMID(name, STRLEN(name)-6)
		END

		function_pro = mots[0]
		is_COMMON = STRUPCASE(function_pro) EQ 'COMMON'

		IF object NE '' THEN BEGIN
			tmp = basename(module)
			pos = STRPOS(tmp, '__define')
			IF STRMID(tmp, 0, pos) NE object THEN BEGIN
				; dans cl tous les modules objects  finissent par "__define.pro"
				; mais ce n'est pas une obligation en IDL
				IF target EQ 'cl' THEN my_print, lint_get_message(module=module, noligne=noligne) + 'INCORRECT OBJECT [' + ligne + ']'
			END
		END ELSE IF ~is_COMMON THEN BEGIN
			tmp = basename(module)
			pos = STRPOS(tmp, '__define')
			IF pos NE -1 THEN BEGIN
				; dans cl la mthode define est de la forme object__define
				; mais ce n'est pas une obligation dans IDL
				IF target EQ 'cl' THEN my_print, lint_get_message(module=module, noligne=noligne) + 'METHOD EXPECTED [' + ligne + ']'
			END
		END






		IF is_COMMON THEN BEGIN
			lint_unused = LINTC_GET_CORRECT_LINE (ligne)
			decls[premier].code += ligne+STRING(10b)
			tmp = ligne
			LINTC_SUPPRIMER_COMMENTAIRES_IDL, tmp
			decls[premier].code_nocomment += tmp+STRING(10b)
		END


		; dterminer le prototype de la routine ou du COMMON
		; --------------------------------------------------
		prototype	= ''
		nb_prototypes	= 0L
		noligne1	= noligne

		prototype_commentaire = lint_get_lint_prototype (ligne)
		IF prototype_commentaire NE '' THEN BEGIN
			;my_print, module+'('+name+') LINT_PROTOTYPE '+prototype_commentaire
			nb_prototypes++
		END ELSE BEGIN
			prototype_commentaire = '???'
		END
		prototype_commentaire = ':' + prototype_commentaire
		LINTC_SUPPRIMER_COMMENTAIRES_IDL, ligne
		lint_unused = LINTC_GET_CORRECT_LINE (ligne)
		prototype_code = STRSPLIT(ligne, ',', /EXTRACT)
		FOR i=1L,N_ELEMENTS(prototype_code)-1 DO BEGIN
			prototype_code[i] = STRCOMPRESS(prototype_code[i], /REMOVE_ALL)
			pos_ecommercial = STRPOS (prototype_code[i], '&')
			IF pos_ecommercial NE -1 THEN prototype_code[i] = STRMID(prototype_code[i], 0, pos_ecommercial)
			IF STRMID(prototype_code[i], 0, 1) EQ '$' THEN BREAK
			IF STRMID(prototype_code[i], STRLEN(prototype_code[i])-1, 1) EQ '$' THEN prototype_code[i] = STRMID(prototype_code[i], 0, STRLEN(prototype_code[i])-1) 
			prototype += (prototype EQ '' ? '' : ' ') + prototype_code[i] + (is_COMMON ? '' : prototype_commentaire)
			IF pos_ecommercial NE -1 THEN BREAK
		END
		premiere_ligne = 1
		; si la ligne se termine par '$'
		WHILE ~EOF(fd) && STRPOS(ligne, '$') NE -1 DO BEGIN
			ligne1 = ''
			REPEAT BEGIN
				noligne++

				READF, fd, ligne1
				IF STRMID(ligne, STRLEN(ligne)-1, 1) EQ '=' THEN BEGIN
					ligne += ligne1
				END ELSE BEGIN
					ligne = ligne1
				END

				lint_unused = LINTC_GET_CORRECT_LINE (ligne)
				IF is_COMMON THEN BEGIN
					decls[premier].code += ligne + STRING(10b)
					tmp = ligne
					LINTC_SUPPRIMER_COMMENTAIRES_IDL, tmp
					decls[premier].code_nocomment += tmp + STRING(10b)
				END
				ligne = STRTRIM (ligne, 1) ; supprimer les blancs  gauche
				prototype_commentaire = lint_get_lint_prototype (ligne)
				IF ~is_COMMON && premiere_ligne && STRMID(ligne, 0, 2) NE ';-' THEN BEGIN
					IF check_doc THEN BEGIN
						my_print, lint_get_message(module=module, noligne=noligne) + '";-" EXPECTED [' + ligne + ']'
					END
				END
				premiere_ligne = 0
				LINTC_SUPPRIMER_COMMENTAIRES_IDL, ligne
				IF STRMID(ligne, STRLEN(ligne)-1, 1) EQ '$' THEN BEGIN
					; ex: "Two_Way = Two, Interactions_Two_Way  = $"
					tmp = STRCOMPRESS(ligne, /REMOVE_ALL)
					IF STRMID(tmp, STRLEN(tmp)-2, 2) EQ '=$' THEN BEGIN
						ligne = STRMID(tmp, 0, STRLEN(tmp)-1)
					END
				END
			END UNTIL (ligne NE '' && STRMID(ligne, STRLEN(ligne)-1, 1) NE '=') || EOF(fd)
			IF prototype_commentaire NE '' THEN BEGIN
				;my_print, module+'('+name+') LINT_PROTOTYPE '+prototype_commentaire
				nb_prototypes++
			END ELSE BEGIN
				prototype_commentaire = '???'
			END
			prototype_commentaire = ':' + prototype_commentaire
			prototype_code = STRSPLIT(ligne, ',', /EXTRACT)
			FOR i=0L,N_ELEMENTS(prototype_code)-1 DO BEGIN
				prototype_code[i] = STRCOMPRESS(prototype_code[i], /REMOVE_ALL)
				pos_ecommercial = STRPOS (prototype_code[i], '&')
				IF pos_ecommercial NE -1 THEN prototype_code[i] = STRMID(prototype_code[i], 0, pos_ecommercial)
				IF STRMID(prototype_code[i], 0, 1) EQ '$' THEN BREAK
				IF STRMID(prototype_code[i], STRLEN(prototype_code[i])-1, 1) EQ '$' THEN prototype_code[i] = STRMID(prototype_code[i], 0, STRLEN(prototype_code[i])-1) 
				prototype += ' ' + prototype_code[i]+(is_COMMON ? '' : prototype_commentaire)
				IF pos_ecommercial NE -1 THEN BREAK
			END
		END
		noligne2 = noligne

		IF function_pro NE STRUPCASE(function_pro) THEN BEGIN
			IF check_syntax THEN BEGIN
				my_print, lint_get_message(module=module, noligne=noligne) + 'KEYWORD "FUNCTION" OR "PRO" OR "COMMON" NOT IN UPPERCASE ' + function_pro + ' [' + ligne + ']'
			END
		END

		IF is_COMMON THEN BEGIN
			IF name NE STRUPCASE(name) THEN BEGIN
				IF check_syntax THEN BEGIN
					my_print, lint_get_message(module=module, noligne=noligne) + 'COMMON NAME NOT IN UPPERCASE ' + name + ' [' + ligne + ']'
				END
			END
		END ELSE BEGIN
			IF name NE STRLOWCASE(name) THEN BEGIN
				IF check_syntax THEN BEGIN
					my_print, lint_get_message(module=module, noligne=noligne) + 'FUNCTION OR PRO NAME NOT IN LOWERCASE ' + name + ' [' + ligne + ']'
				END
			END
		END

		IF is_COMMON THEN BEGIN
			decls[premier].commons += (decls[premier].commons EQ '' ? '' : !SEP1) + name + !SEP2 + LINTC_INT_TO_STR(noligne) + !SEP2 + prototype
			CONTINUE
		END



		; La routine a t-elle dja t dclare ?
		; Faire la recherche en 2 fois, c'est beaucoup plus rapide qu'un seul WHERE avec 3 conditions ...
		; Il faut regarder les lments parmis 0..premier
		;ind1 = WHERE (decls[LINDGEN(premier+1)].name EQ STRLOWCASE(name))	; decls.name est en minsucule
		redefined = ''
		ind1 = lint_get_decls_by_name_passe1 (decls, hash, STRLOWCASE(name))
		IF ind1[0] NE -1 THEN BEGIN
			ind2 = WHERE (decls[ind1].function_pro EQ STRUPCASE(function_pro) AND decls[ind1].object EQ STRLOWCASE(object)) ; decls.function est en majuscule, decls.object est en minscule
			IF ind2[0] NE -1 THEN BEGIN
				old_no    = ind1[ind2[0]]
				redefined_name = object NE '' ? object+'::'+name : name
				redefined = ' (found in ' + decls[ind1[ind2[0]]].module+')'
				IF decls[ind1[ind2[0]]].is_system THEN BEGIN
					IF STRPOS(decls[ind1[ind2[0]]].module, module) EQ -1 THEN BEGIN
						my_print, STRUPCASE(name) + ' INCORRECT ' + redefined+': MUST CONTAINS ' + module + ' ???'
						;STOP
					END
				END
			END
			IF ~redefined THEN BEGIN
				ind2 = WHERE (decls[ind1].object EQ STRLOWCASE(object)) ; decls.function est en majuscule, decls.object est en minscule
				IF ind2[0] NE -1 THEN BEGIN
					PRINT, STRUPCASE(name) + ' -> ' + function_pro + ' ???'
					;STOP
				END
			END
		END

		; Dcortiquer le prototype juste pour obtenir keywords_ambigus
		; ------------------------------------------------------------
		code = lint_analyser_prototype (prototype, nb_params_min, nb_params_max, nb_keywords, params, params_type, params_extra, keywords, keywords_type, keywords_ambigus)

		IF code NE '' THEN BEGIN
			my_print, lint_get_message(module=module, noligne=noligne) + 'INCORRECT PROTOTYPE ' + code
			EXIT
		END

		IF nb_prototypes NE nb_params_max + nb_keywords THEN BEGIN
			IF check_syntax || nb_prototypes THEN BEGIN
				my_print, lint_get_message(module=module, noligne=noligne) + 'INCORRECT NUMBER OF LINT_PROTOTYPE'
			END
		END


		IF keywords_ambigus NE '' THEN BEGIN
			my_print, lint_get_message(module=module, noligne=noligne) + 'AMBIGUOUS KEYWORDS ' + keywords_ambigus
		END

		premier++
		decls[premier].module			= module
		decls[premier].function_pro		= STRUPCASE(function_pro)
		decls[premier].object			= STRLOWCASE(object)
		decls[premier].name			= STRLOWCASE(name)
		decls[premier].check_syntax		= check_syntax
		decls[premier].check_space		= check_space
		decls[premier].check_case_sensitive	= check_case_sensitive
		decls[premier].check_unused		= check_unused
		decls[premier].check_stop_debug		= check_stop_debug
		decls[premier].check_doc		= check_doc
		decls[premier].is_cl_interne		= is_cl_interne
		decls[premier].is_cl_externe		= is_cl_externe
		decls[premier].is_cl_other		= is_cl_other
		decls[premier].is_c			= is_c
		decls[premier].noligne1			= noligne1
		decls[premier].noligne2			= noligne2
		decls[premier].lint_variables		= ''
		decls[premier].nb_params_max		= nb_params_max	; juste pour le test en fin de routine "NO LINT_PROTOTYPE"
		decls[premier].nb_keywords		= nb_keywords	; juste pour le test en fin de routine "NO LINT_PROTOTYPE"
		decls[premier].prototype		= prototype
		decls[premier].nb_prototypes		= nb_prototypes
		decls[premier].nbchars_doc		= 0
		IF redefined THEN BEGIN
			my_print, lint_get_message(module=module, noligne=noligne) + 'FUNCTION OR PRO NAME REDEFINED ' + '"' + redefined_name + '" ' + redefined + ' ['+ligne + ']'
			lint_add_msg_decls, decls, premier, -2L, 'REDEFINED', '"' + redefined_name + '" ' + redefined

			premier_choix = decls[old_no].first_plus EQ -1 ? old_no : decls[old_no].first_plus
			dernier_choix = decls[old_no].last_plus  EQ -1 ? old_no : decls[old_no].last_plus
			old_somme_keywords = ''
			FOR no=premier_choix,dernier_choix DO BEGIN
				code = lint_analyser_prototype (decls[no].prototype, old_nb_params_min, old_nb_params_max, old_nb_keywords, old_params, old_params_type, old_params_extra, old_keywords, old_keywords_type, old_keywords_ambigus)
				problem = 0
				IF nb_params_min LT old_nb_params_min OR nb_params_max GT old_nb_params_max THEN BEGIN
					problem = 1
				END
				old_somme_keywords += ' ' + old_keywords
			END
			old_name = '('+decls[premier_choix].module+')'+(object EQ '' ? '' : object+'::') + STRUPCASE(decls[premier_choix].name)
			new_name = '('+module+')'+(object EQ '' ? '' : object+'::') + STRUPCASE(name)
			IF problem THEN BEGIN
				my_print, STRING (old_name, FORMAT='(A-60)') + ': nb_params_min=' + val_to_str(old_nb_params_min) + ' nb_params_max=' + val_to_str(old_nb_params_max)
				my_print, STRING (new_name, FORMAT='(A-60)') + ': nb_params_min=' + val_to_str(nb_params_min)     + ' nb_params_max=' + val_to_str(nb_params_max)
			END
			old_keywords = STRSPLIT (old_somme_keywords, /EXTRACT)
			new_keywords = STRSPLIT (keywords, /EXTRACT)
			FOR i1=0L,nb_keywords-1 DO BEGIN
				ind = WHERE (STRUPCASE(old_keywords) EQ STRUPCASE(new_keywords[i1]))
				IF ind[0] EQ -1 THEN BEGIN
					IF STRUPCASE(new_keywords[i1]) EQ '_REF_EXTRA' THEN BEGIN
					END ELSE IF STRUPCASE(new_keywords[i1]) EQ '_EXTRA' THEN BEGIN
					END ELSE BEGIN
						; keywords[i1] n'existait pas
						IF problem EQ 0 THEN PRINT
						my_print, '/' + STRING(new_keywords[i1], FORMAT='(A-30)') + ' NOT FOUND IN ' + old_name
						problem = 1
					END
				END
			END
			FOR i1=0L,old_nb_keywords-1 DO BEGIN
				ind = WHERE (STRUPCASE(new_keywords) EQ STRUPCASE(old_keywords[i1]))
				IF ind[0] EQ -1 THEN BEGIN
					has_extra = (WHERE (STRUPCASE(new_keywords) EQ '_EXTRA'))[0] NE -1
					has_ref_extra = (WHERE (STRUPCASE(new_keywords) EQ '_REF_EXTRA'))[0] NE -1
					; old_keywords[i1] n'existe plus
					IF problem EQ 0 THEN PRINT
					s = '/' + STRING(old_keywords[i1], FORMAT='(A-30)') + ' NOT FOUND IN ' + new_name
					IF has_extra THEN s += ' BUT HAS _EXTRA'
					IF has_ref_extra THEN s += ' BUT HAS _REF_EXTRA'
					my_print, s
					problem = 1
				END
			END
			IF problem THEN BEGIN
				my_print, ''
				my_print, old_name + ': ' + decls[old_no].prototype
				my_print, ''
				my_print, function_pro +' ' + new_name + ': ' + prototype
				;STOP
			END
		END
		IF keywords_ambigus NE '' THEN BEGIN
			tmp = STRSPLIT(keywords_ambigus, /EXTRACT)
			FOR i=0L,N_ELEMENTS(tmp)-1 DO BEGIN
				lint_add_msg_decls, decls, premier, -1L, 'AMBIGUOUS KEYWORD', tmp[i]
			END
		END

		IF is_Berkeley && decls[premier].doc EQ '' && doc_Berkeley NE '' THEN BEGIN
			decls[premier].doc = doc_Berkeley
		END

		lint_ajouter_hash, decls, premier, hash
		doc_Berkeley = ''

	END

	FREE_LUN, fd

	IF special THEN BEGIN
		IF premier EQ tout_premier THEN BEGIN
			; arrive avec "spedas/gui/Resources/findme.pro"
			name = STRLOWCASE(basename(module)) ; ex: "projects/maven/swea/mvn_swe_com.pro" -> "mvn_swe_com.pro"
			; L'include a t-il dja t dclar ?
			; pas de message pour le C
			redefined = ''
			IF ~is_c THEN BEGIN
				ind = WHERE (decls.function_pro EQ 'INCLUDE'+(is_c ? 'C':'') AND decls.name EQ name)
				IF ind[0] NE -1 THEN BEGIN
					redefined = ' (found in ' + decls[ind[0]].module+')'
				END
			END
			premier++
			decls[premier].module			= module
			decls[premier].function_pro		= 'INCLUDE'+(is_c ? 'C':'')
			decls[premier].object			= ''
			decls[premier].name			= STRLOWCASE(basename(module))
			decls[premier].check_syntax	  	= check_syntax
			decls[premier].check_space	  	= check_space
			decls[premier].check_case_sensitive	= check_case_sensitive
			decls[premier].check_unused		= check_unused
			decls[premier].check_stop_debug		= check_stop_debug
			decls[premier].check_doc		= check_doc
			decls[premier].is_cl_interne		= is_cl_interne
			decls[premier].is_cl_externe		= is_cl_externe
			decls[premier].is_cl_other		= is_cl_other
			decls[premier].is_c			= is_c
			decls[premier].noligne1			= 0
			decls[premier].noligne2			= 0
			decls[premier].lint_variables		= ''
			decls[premier].nb_params_max		= 0
			decls[premier].nb_keywords		= 0
			decls[premier].prototype		= ''
			decls[premier].nb_prototypes		= 0
			decls[premier].nbchars_doc		= 0
			IF redefined THEN BEGIN
				my_print, lint_get_message(module=module, noligne=noligne) + 'INCLUDE'+(is_c ? 'C':'')+' NAME REDEFINED ' + '"' + name + '" ' + redefined
				lint_add_msg_decls, decls, premier, -2L, 'REDEFINED', '"' + decls[premier].name + '" ' + redefined
			END
		END ELSE BEGIN
			IF decls[premier].noligne1 EQ 0 THEN BEGIN
				; INCLUDE sans doc au dbut
				decls[premier].noligne1 = 1
				decls[premier].noligne2 = 0
			END
			decls[premier].nblignes = noligne-decls[premier].noligne1+1
		END
		IF is_Berkeley && decls[premier].doc EQ '' && doc_Berkeley NE '' THEN BEGIN
			decls[premier].doc = doc_Berkeley
		END
		RETURN
	END

	IF premier EQ tout_premier THEN BEGIN
		lint_decl, liste, noliste, decls, premier, hash, fdall, repertoire, /special
	END

	; Routines sans doc ?
	FOR i=tout_premier+1,premier DO BEGIN

		IF decls[i].check_doc THEN BEGIN
			IF decls[i].nbchars_doc LT 10 THEN BEGIN
				IF decls[i].function_pro EQ 'FUNCTIONC' THEN CONTINUE
				IF decls[i].function_pro EQ 'MACROC' THEN CONTINUE
				IF chaine_contient(decls[i].module, 'pro/exp_') THEN BEGIN
					my_print, lint_get_message(module=module) + 'INCORRECT DOC ' + decls[i].name
					EXIT
				END ELSE IF decls[i].nbchars_doc LT 5 THEN BEGIN
					my_print, lint_get_message(module=module) + 'INCORRECT DOC ' + decls[i].name
				END
			END
		END

	END

	; Dclarations dans l'ordre "cleanup/init/__define" ?
	no_define	= -1L
	no_init		= -1L
	no_cleanup	= -1L
	FOR i=tout_premier+1,premier DO BEGIN

		IF decls[i].object NE '' && STRLOWCASE(decls[i].name) EQ 'define'	THEN no_define	= i
		IF decls[i].object NE '' && STRLOWCASE(decls[i].name) EQ 'cleanup'	THEN no_cleanup = i
		IF decls[i].object NE '' && STRLOWCASE(decls[i].name) EQ 'init'		THEN no_init	= i
	
	END

	IF no_define NE -1 THEN BEGIN
		IF no_init EQ -1 THEN BEGIN
			;my_print, module+'('+LINTC_INT_TO_STR(noligne1) + ') NO init ' + decls[i].name
		END
		IF no_cleanup EQ -1 THEN BEGIN
			;my_print, module+'('+LINTC_INT_TO_STR(noligne1) + ') NO cleanup ' + decls[i].name
		END

		IF (no_init NE -1) && (no_init NE no_define-1) THEN BEGIN
			; que pour cl
			IF target EQ 'cl' THEN my_print, lint_get_message(module=module) + 'NOT in order cleanup init define' + decls[i].name
;			EXIT
		END
		IF (no_cleanup NE -1) && (no_cleanup NE no_define - (no_init EQ -1 ? 1 : 2)) THEN BEGIN
			; que pour cl
			IF target EQ 'cl' THEN my_print, lint_get_message(module=module) + 'NOT in order cleanup init define' + decls[i].name
;			EXIT
		END
	END

	; toutes les routines du module hrite de la mme classe (inherits)
	FOR i=tout_premier+1,premier DO BEGIN
		IF decls[i].object EQ '' && ~decls[i].is_c THEN CONTINUE
		decls[i].inherits = inherits

	END

END

;-------------------------------------------------------------------------------
FUNCTION lint_is_digits,	$
;-------------------------------------------------------------------------------
	s				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne 1 si tous les caractres de s sont entre '0' et '9'
;-------------------------------------------------------------------------------

	IF s EQ '' THEN RETURN, 0

	len = STRLEN(s)
	FOR i=0L,len-1 DO BEGIN
		char = STRMID(s, i, 1)
		IF char GE '0' && char LE '9' THEN BEGIN
		END ELSE BEGIN
			RETURN, 0
		END
	END

	RETURN, 1

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_char,	$
;-------------------------------------------------------------------------------
	data,		$	; LINT_PROTOTYPE input
	mot			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Saute les blancs puis retourne 1 si on trouve mot
;-------------------------------------------------------------------------------

	data.pos = LINTC_SAUTER_ESPACES_TABULATIONS (data.line, data.pos)

	RETURN, STRMID(data.line, data.pos, STRLEN(mot)) EQ mot

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_egal,	$
;-------------------------------------------------------------------------------
	data 			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Saute les blancs puis retourne 1 si on trouve '='
;-------------------------------------------------------------------------------
	RETURN, lint_get_char (data, '=')
END

;-------------------------------------------------------------------------------
FUNCTION lint_is_egal,	$
;-------------------------------------------------------------------------------
	c			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne 1 si c vaut '='
;-------------------------------------------------------------------------------
	RETURN, c EQ '='
END

;-------------------------------------------------------------------------------
FUNCTION lint_get_parenthese_ouvrante,	$
;-------------------------------------------------------------------------------
	data					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Saute les blancs puis retourne 1 si on trouve '('
;-------------------------------------------------------------------------------
	RETURN, lint_get_char (data, '(')
END

;-------------------------------------------------------------------------------
FUNCTION lint_is_parenthese_ouvrante,	$
;-------------------------------------------------------------------------------
	c					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne 1 si c vaut '('
;-------------------------------------------------------------------------------
	RETURN, c EQ '('
END

;-------------------------------------------------------------------------------
FUNCTION lint_get_parenthese_fermante,	$
;-------------------------------------------------------------------------------
	data					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Saute les blancs puis retourne 1 si on trouve ')'
;-------------------------------------------------------------------------------
	RETURN, lint_get_char (data, ')')
END

;-------------------------------------------------------------------------------
FUNCTION lint_get_crochet_ouvrant,	$
;-------------------------------------------------------------------------------
	data					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Saute les blancs puis retourne 1 si on trouve '['
;-------------------------------------------------------------------------------
	RETURN, lint_get_char (data, '[')
END

;-------------------------------------------------------------------------------
FUNCTION lint_is_crochet_ouvrant,	$
;-------------------------------------------------------------------------------
	c					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne 1 si c vaut '['
;-------------------------------------------------------------------------------
	RETURN, c EQ '['
END

;-------------------------------------------------------------------------------
FUNCTION lint_get_crochet_fermant,	$
;-------------------------------------------------------------------------------
	data					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Saute les blanc puis retourne 1 si on trouve ']'
;-------------------------------------------------------------------------------
	RETURN, lint_get_char (data, ']')
END

;-------------------------------------------------------------------------------
FUNCTION lint_get_point,	$
;-------------------------------------------------------------------------------
	data					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Saute les blancs puis retourne 1 si on trouve '.'
;-------------------------------------------------------------------------------
	RETURN, lint_get_char (data, '.')
END

;-------------------------------------------------------------------------------
FUNCTION lint_is_point,	$
;-------------------------------------------------------------------------------
	c				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne 1 si c vaut '.'
;-------------------------------------------------------------------------------
	RETURN, c EQ '.'
END

;-------------------------------------------------------------------------------
FUNCTION lint_get_2points,	$
;-------------------------------------------------------------------------------
	data				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Saute les blancs puis retourne 1 si on trouve ':'
;-------------------------------------------------------------------------------
	RETURN, lint_get_char (data, ':')
END

;-------------------------------------------------------------------------------
FUNCTION lint_get_etoile,	$
;-------------------------------------------------------------------------------
	data				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Saute les blancs puis retourne 1 si on trouve '*'
;-------------------------------------------------------------------------------
	RETURN, lint_get_char (data, '*')
END

;-------------------------------------------------------------------------------
FUNCTION lint_get_etoile_subscript,	$
;-------------------------------------------------------------------------------
	data					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Saute les blancs puis retourne 1 si on trouve * suivi de ',' ou ']'
;-------------------------------------------------------------------------------

	tmp = data.pos
	code = lint_get_char (data, '*')
	IF code THEN BEGIN
		code = lint_get_char (data, ',') || lint_get_char (data, ']')
	END
	data.pos = tmp
	RETURN, code
END

;-------------------------------------------------------------------------------
FUNCTION lint_get_accolade_ouvrante,	$
;-------------------------------------------------------------------------------
	data					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Saute les blancs puis retourne 1 si on trouve '{'
;-------------------------------------------------------------------------------
	RETURN, lint_get_char (data, '{')
END

;-------------------------------------------------------------------------------
FUNCTION lint_get_accolade_fermante,	$
;-------------------------------------------------------------------------------
	data					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Saute les blancs puis retourne 1 si on trouve '}'
;-------------------------------------------------------------------------------
	RETURN, lint_get_char (data, '}')
END

;-------------------------------------------------------------------------------
FUNCTION lint_get_virgule,	$
;-------------------------------------------------------------------------------
	data				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Saute les blancs puis retourne 1 si on trouve ','
;-------------------------------------------------------------------------------
	RETURN, lint_get_char (data, ',')
END

;-------------------------------------------------------------------------------
FUNCTION lint_is_fleche,	$
;-------------------------------------------------------------------------------
	c				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne 1 si c vaut '->'
;-------------------------------------------------------------------------------
	RETURN, c EQ '->'
END

;-------------------------------------------------------------------------------
FUNCTION lint_get_name_idl,	$
;-------------------------------------------------------------------------------
	data,			$	; LINT_PROTOTYPE input
	name				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Se mettre en position data.pos
; Sauter les espaces et les tabulations
; Mettre dans name le nom de variable ou la constante trouv
; Renvoyer la position du dbut de name
;-------------------------------------------------------------------------------

	len = 0L
	pos = LINTC_GET_NAME_IDL (data.line, data.pos, len)
	name = STRMID(data.line, pos, len)
	RETURN, pos

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_name_c,	$
;-------------------------------------------------------------------------------
	data,			$	; LINT_PROTOTYPE input
	name				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Se mettre en position data.pos
; Sauter les espaces et les tabulations
; Mettre dans name le nom de variable
; Renvoyer la position du dbut de name
;-------------------------------------------------------------------------------

	len = 0L
	pos = LINTC_GET_NAME_C (data.line, data.pos, len)
	name = STRMID(data.line, pos, len)
	RETURN, pos

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_constant_c,	$
;-------------------------------------------------------------------------------
	data,			$	; LINT_PROTOTYPE input
	name				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Se mettre en position data.pos
; Sauter les espaces et les tabulations
; Mettre dans name la constante
; Renvoyer la position du dbut de name
;-------------------------------------------------------------------------------

	len = 0L
	pos = LINTC_GET_CONSTANT_C (data.line, data.pos, len)
	name = STRMID(data.line, pos, len)
	RETURN, pos

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_operator,	$
;-------------------------------------------------------------------------------
	data,			$	; LINT_PROTOTYPE input
	name				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne l'oprateur IDL trouv dans data.line en position data.pos.
;-------------------------------------------------------------------------------

	pos = LINTC_SAUTER_ESPACES_TABULATIONS (data.line, data.pos)
	data.pos = pos
	name = ''

	char3 = STRMID(data.line, pos, 3)

	SWITCH STRUPCASE(char3) OF
		'MOD':
		'NOT':
		'AND':
		'XOR':	BEGIN
				IF STRMID(data.line, pos+3, 1) EQ ' ' || STRMID(data.line, pos+3, 1) EQ STRING(9b) || STRMID(data.line, pos+3, 1) EQ '(' THEN BEGIN
					name = char3
				END ELSE BEGIN
					name = ''
				END
				BREAK
			END
		ELSE:	BEGIN
				char2 = STRMID(data.line, pos, 2)
				SWITCH STRUPCASE(char2) OF
					'OR':
					'LE':
					'EQ':
					'NE':
					'GT':
					'GE':
					'LT': 	BEGIN
							IF STRMID(data.line, pos+2, 1) EQ ' ' || STRMID(data.line, pos+2, 1) EQ STRING(9b) || STRMID(data.line, pos+2, 1) EQ '(' THEN BEGIN
								name = char2
							END ELSE BEGIN
								name = ''
							END
							BREAK
						END

					'->':
					'&&':
					'||':
					'++':
					'--':
					'+=':
					'-=':
					'*=':
					'/=': 	BEGIN
							name = char2
							BREAK
						END
					ELSE: BEGIN
						char1 = STRMID(data.line, pos, 1)
						SWITCH STRUPCASE(char1) OF
						
							; pour Berkeley spdsoft
							; ex: "./projects/themis/deprecated/thm_ui/thm_gui_original.pro(51)"
							; ex: "@tplot_com"
							'@':

							'~':
							'#':
							'<':
							'>':
							'^':
							'?':
							'[':
							'(':
							'+':
							'-':
							'*':
							'/': 	BEGIN
									name = char1
									BREAK
								END
							ELSE: 	BEGIN
									name = ''
									BREAK
								END
						END
					END
				END
			END
	END

	RETURN, pos

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_name_egal,	$
;-------------------------------------------------------------------------------
	data,			$	; LINT_PROTOTYPE input
	name				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne -1 si on ne trouve pas name suivi de '=' sinon met  jour name et retourne la position de "="
;-------------------------------------------------------------------------------

	code = lint_get_name_idl (data, name)
	FOR pos=code+STRLEN(name),STRLEN(data.line)-1 DO BEGIN
		char = STRMID(data.line, pos, 1)
		IF char NE ' ' && char NE STRING(9b) THEN BREAK
	END
	IF STRMID(data.line, pos, 1) EQ '=' THEN BEGIN
		RETURN, pos+1
	END ELSE BEGIN
		RETURN, -1
	END

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_keyword_egal,	$
;-------------------------------------------------------------------------------
	data,			$	; LINT_PROTOTYPE input
	name				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne -1 si on ne trouve pas name sinon met  jour name et retourne la position de "name".
;-------------------------------------------------------------------------------

	code = lint_get_name_egal (data, name)
	RETURN, code

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_parenthese_ouvrante_name_egal, $
;-------------------------------------------------------------------------------
	data,			$	; LINT_PROTOTYPE input
	name				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne -1 si on ne trouve pas '(' suivi de name suivi de '=' sinon met  jour name et retourne la position de "=".
;-------------------------------------------------------------------------------

	IF lint_get_parenthese_ouvrante(data) THEN BEGIN
		data.pos++
		code = lint_get_name_egal (data, name)
		data.pos--
		RETURN, code NE -1 ? code : -1
	END
	RETURN, -1

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_slash_keyword,	$
;-------------------------------------------------------------------------------

	data,				$	; LINT_PROTOTYPE input
	name					; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne -1 si on ne trouve pas '/' suivi de name sinon met  jour name et retourne la position de name.
;-------------------------------------------------------------------------------

	data.pos = LINTC_SAUTER_ESPACES_TABULATIONS (data.line, data.pos)

	IF STRMID(data.line, data.pos, 1) EQ '/' THEN BEGIN
		data.pos++
		code = lint_get_name_idl (data, name)
		data.pos--
		RETURN, code
	END ELSE BEGIN
		name = ''
		RETURN, -1
	END

END

;-------------------------------------------------------------------------------
PRO empiler,	$
;-------------------------------------------------------------------------------
	data,	$	; LINT_PROTOTYPE input
	x		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Empile x dans la pile data.
;-------------------------------------------------------------------------------
	data.pile += ' ' + x
END

;-------------------------------------------------------------------------------
PRO depiler,	$
;-------------------------------------------------------------------------------
	data		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Supprimer le dernier lment de la pile data.
;-------------------------------------------------------------------------------
	pile = STRSPLIT(data.pile, /EXTRACT)
	data.pile = N_ELEMENTS(pile) EQ 1 ? '' : STRJOIN(pile[0:N_ELEMENTS(pile)-2], ' ')
END

;-------------------------------------------------------------------------------
FUNCTION get_last_pile,	$
;-------------------------------------------------------------------------------
	data		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne le dernier lment de la pile data.
;-------------------------------------------------------------------------------
	pile = STRSPLIT(data.pile, /EXTRACT)
	RETURN, pile[N_ELEMENTS(pile)-1]
END

;-------------------------------------------------------------------------------
PRO put_last_pile,	$
;-------------------------------------------------------------------------------
	data,		$	; LINT_PROTOTYPE input
	x			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Remplace le dernier lment de la pile data par x.
;-------------------------------------------------------------------------------
	pile = STRSPLIT(data.pile, /EXTRACT)
	data.pile = N_ELEMENTS(pile) EQ 1 ? (x) : (STRJOIN(pile[0:N_ELEMENTS(pile)-2], ' ') + ' ' + x)
END

;-------------------------------------------------------------------------------
PRO set_data_statement,		$
;-------------------------------------------------------------------------------
	data,			$	; LINT_PROTOTYPE input
	statement			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Positionne data.statement  une certaine valeur
;-------------------------------------------------------------------------------

	MAJUSCULE = STRUPCASE(statement)

	data.statement = statement
	

	get_last = get_last_pile(data)

	CASE MAJUSCULE OF

		'FOR=':		BEGIN
				 	RETURN
				END

		'PARA':		BEGIN
					RETURN
				END

		'FIN_PARA':	BEGIN
					RETURN
				END

		'+=':		BEGIN
					RETURN
				END

		'-=':		BEGIN
					RETURN
				END

		'*=':		BEGIN
					RETURN
				END

		'/=' :		BEGIN
					RETURN
				END

		'=':		BEGIN
					IF get_last EQ 'SWITCH' THEN BEGIN
					; ex: switch = where(mlt GT 0.398517)
					depiler, data
					END ELSE BEGIN
						RETURN
					END
				END

		'FOR':		BEGIN
					empiler, data, statement
				END

		'IF':		BEGIN
					CASE get_last OF
						'ELSE':	put_last_pile, data, 'ELSE_IF'
						ELSE:	empiler, data, statement
					END
				END

		'WHILE': 	BEGIN
					empiler, data, statement
				 END

		'REPEAT': 	BEGIN
					empiler, data, statement
				  END
			
		'CASE':		BEGIN
					;lint_add_ccc, data, "KEYWORD_C", statement, "switch ("
					empiler, data, statement
				END

		'SWITCH': 	BEGIN
					empiler, data, statement
				  END

		'BEGIN': 	BEGIN
					CASE get_last OF
						'FOR_DO':	BEGIN
									;lint_add_ccc, data, "KEYWORD_C", statement, '{'
									put_last_pile, data, 'FOR_DO_BEGIN'
								END
						'IF_THEN':	BEGIN
									;lint_add_ccc, data, "KEYWORD_C", statement, "{"
									put_last_pile, data, 'IF_THEN_BEGIN'
								END
						'WHILE_DO':	BEGIN
									;lint_add_ccc, data, "KEYWORD_C", statement, "{"
									put_last_pile, data, 'WHILE_DO_BEGIN'
								END
						'ELSE':		put_last_pile, data, 'ELSE_BEGIN'
						'REPEAT':	BEGIN
									;lint_add_ccc, data, "KEYWORD_C", statement, "{"
									put_last_pile, data, 'REPEAT_BEGIN'
								END
						ELSE:		BEGIN
									;lint_add_ccc, data, "KEYWORD_C", statement, "{"
									empiler, data, statement
								END
					END
				 END
		
		'UNTIL': 	BEGIN
					CASE get_last OF
						'REPEAT_BEGIN_END':	BEGIN
										;lint_add_ccc, data, "KEYWORD_C", statement, " while (!("
										depiler, data
									END
						'REPEAT':		BEGIN
										;lint_add_ccc, data, "KEYWORD_C", statement, " while (!("
										depiler, data
									END
						ELSE:			BEGIN
										; ex: "repeat for until"
										my_print_msg, data, lint_get_message(data) + 'SYNTAX ERROR AT "' + statement + '" [' + data.line + ']'
										lint_add_msg, data, 'SYNTAX ERROR', ' AT "' + statement + '"'
										depiler, data
									END
					END
				END
		
		'DO':		BEGIN
					CASE get_last OF
						'FOR':		BEGIN
									;lint_add_ccc, data, "KEYWORD_C", statement, '; ' + data.for_variable+"++)"
									put_last_pile, data, 'FOR_DO'
								END
						'WHILE':	BEGIN
									;lint_add_ccc, data, "KEYWORD_C", statement, ')'
									put_last_pile, data, 'WHILE_DO'
								END
						ELSE:		BEGIN
									; ex: "repeat  do"
									my_print_msg, data, lint_get_message(data) + 'SYNTAX ERROR AT "' + statement + '" [' + data.line + ']'
									lint_add_msg, data, 'SYNTAX ERROR', ' AT "' + statement + '"'
									depiler, data
								END
					END
				END

		'OF':		BEGIN
					CASE get_last OF
						'CASE':		BEGIN
									;lint_add_ccc, data, "KEYWORD_C", statement, ") {"
									put_last_pile, data, 'CASE_OF'
								END
						'SWITCH': 	put_last_pile, data, 'SWITCH_OF'
						ELSE:		BEGIN
									; ex: "for   of"
									my_print_msg, data, lint_get_message(data) + 'SYNTAX ERROR AT "' + statement + '" [' + data.line + ']'
									lint_add_msg, data, 'SYNTAX ERROR', ' AT "' + statement + '"'
									depiler, data
								END
					END
				END

		'ELSE':		BEGIN
					CASE get_last OF
						'CASE_OF':	BEGIN
									;lint_add_ccc, data, "KEYWORD_C", statement, "break; default"
									RETURN
								END
						'SWITCH_OF':	RETURN
						ELSE:		BEGIN
									; ex: "IF ... THEN BEGIN END ELSE"
									;lint_add_ccc, data, "KEYWORD_C", statement, "else"
								END
					END
				END


		'THEN':		BEGIN
					CASE get_last OF
						'IF':		BEGIN
									;lint_add_ccc, data, "KEYWORD_C", statement, ")"
									put_last_pile, data, 'IF_THEN'
								END
						'ELSE_IF':	put_last_pile, data, 'ELSE_IF_THEN'
						ELSE:		BEGIN
									; ex: "repeat for then"
									my_print_msg, data, lint_get_message(data) + 'SYNTAX ERROR AT "' + statement + '" [' + data.line + ']'
									lint_add_msg, data, 'SYNTAX ERROR', ' AT "' + statement
									depiler, data
								END
					END
				END

		ELSE: 		BEGIN
					IF STRMID(MAJUSCULE, 0, 3) EQ 'END' THEN BEGIN
						CASE get_last OF
							'':			BEGIN
											;lint_add_ccc, data, "KEYWORD_C", statement, "}"
										END
							'FOR_DO_BEGIN':		BEGIN
											;lint_add_ccc, data, "KEYWORD_C", statement, "}"
											depiler, data
										END
							'IF_THEN_BEGIN': 	BEGIN
											;lint_add_ccc, data, "KEYWORD_C", statement, "}"
											depiler, data
										END
							'CASE_OF':		BEGIN
											;lint_add_ccc, data, "KEYWORD_C", statement, "}"
											depiler, data
										END
							'SWITCH_OF':		depiler, data
							'WHILE_DO_BEGIN': 	BEGIN
											;lint_add_ccc, data, "KEYWORD_C", statement, "}"
											depiler, data
										END
							'ELSE_BEGIN':		BEGIN
											;lint_add_ccc, data, "KEYWORD_C", statement, "}"
											depiler, data
										END
							'BEGIN':		BEGIN
											;lint_add_ccc, data, "KEYWORD_C", statement, "}"
											depiler, data
										END
							'REPEAT_BEGIN':		BEGIN
											;lint_add_ccc, data, "KEYWORD_C", statement, "}"
											put_last_pile, data, 'REPEAT_BEGIN_END'
										END
							ELSE:			BEGIN
											; ex: "for i=0,1 endif"
											my_print_msg, data, lint_get_message(data) + 'SYNTAX ERROR AT "' + statement + '" [' + data.line + ']'
											lint_add_msg, data, 'SYNTAX ERROR', ' AT "' + statement + '"'
											depiler, data
										END
						END

					END ELSE BEGIN

						; ex: "???"
						my_print_msg, data, lint_get_message(data) + 'SYNTAX ERROR AT "' + statement + '" [' + data.line + ']'
						lint_add_msg, data, 'SYNTAX ERROR', ' AT "' + statement + '"'
						depiler, data

					END
				END

	END

END

;-------------------------------------------------------------------------------
PRO lint_finaliser_variables_en_cours,	$
;-------------------------------------------------------------------------------
	data					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Change la catgories des variables 'local_en_cours ' en 'local'.
;-------------------------------------------------------------------------------

	ind = WHERE ((*data.vars).categorie EQ 'local_en_cours')
	IF ind[0] NE -1 THEN (*data.vars)[ind].categorie = 'local'

END

;-------------------------------------------------------------------------------
FUNCTION lint_is_string,	$
;-------------------------------------------------------------------------------
	name,			$	; LINT_PROTOTYPE input
	nb				; LINT_PROTOTYPE [output]
;-------------------------------------------------------------------------------
; Retourne 1 si name est une chaine de caractres ('...' ou "..."), 0 sinon.
;
; Met dans nb le nombre de caractres de la chaine + 2 (cad en comptant les ' et ").
;-------------------------------------------------------------------------------

	c = STRMID(name, 0, 1)
	IF c EQ "'" || c EQ '"' THEN BEGIN
		nb = STRPOS(name, c, 1) + 1
		RETURN, nb EQ 0 ? 0 : 1
	END ELSE BEGIN
		RETURN, 0
	END

END

;-------------------------------------------------------------------------------
FUNCTION lint_is_octal,	$
;-------------------------------------------------------------------------------
	name,			$	; LINT_PROTOTYPE input
	nb				; LINT_PROTOTYPE [output]
;-------------------------------------------------------------------------------
; Retourne 1 si name est une octal: "[0-8]
;
; Met dans nb le nombre de caractres de la chaine + 1 (cad en comptant ls ").
;-------------------------------------------------------------------------------

	c = STRMID(name, 0, 1)
	IF c EQ '"' THEN BEGIN
		c = STRMID(name, 1, 1)
		IF c LT '0' || c GT '8' THEN RETURN, 0
		len = STRLEN(name)
		nb = 2L
		FOR i=2L,len-1 DO BEGIN
			c = STRMID(name, i, 1)
			IF c LT '0' || c GT '8' THEN BREAK
			nb++
		END
		RETURN, 1
	END ELSE BEGIN
		RETURN, 0
	END

END

;-------------------------------------------------------------------------------
FUNCTION lint_is_string_or_constant,	$
;-------------------------------------------------------------------------------
	name,				$	; LINT_PROTOTYPE input
	is_string,			$	; LINT_PROTOTYPE output
	is_constant,			$	; LINT_PROTOTYPE output
	nb					; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne 1 si name est une string ou constante (et met  1 ou 0 is_string et is_constant), 0 sinon.
;
; Met is_string  1 si name est une string.
; Met is_constant  1 si name est une constante.
; Met dans nb le nombre de caractres de la chaine ou de la constante (en comptant les ' et ")
; 
;
; Si la constante commence par ' ou "", met dans nb le nombre de caractres de la chaine, avec les ' et "" plus les caractres qui suivent
;-------------------------------------------------------------------------------

	is_string = 0
	is_constant = 0

	c = STRMID(name, 0, 1)
	IF (c GE '0' && c LE '9') || (c EQ '-') || (c EQ '+') || (c EQ '-') || (c EQ '.') THEN BEGIN
		is_constant = 1
		nb = 1
		RETURN, 1
	END

	IF lint_is_octal(name, nb) || lint_is_string(name, nb) THEN BEGIN

		; On peut ensuite avoir:
		; 	B, S, U, US, L, UL, LL, ULL
		; 	XB, X, XU, XL, XUL, XLL, XULL
		; 	B, O, U, OU, L, OL, UL, OUL, LL, OLL, ULL, OULL

		; => sur 1: B S U L X O
		; => sur 2: US UL LL XB XU XL OU OL
		; => sur 3: ULL XUL XLL OUL OLL
		; => sur 4: XULL OULL


		tmp4 = STRUPCASE(STRMID(name, nb, 4))
		IF tmp4 EQ 'XULL' || tmp4 EQ 'OULL' THEN BEGIN
			nb += 4
			is_constant = 1
			RETURN, 1	; doc IDL
		END

		tmp3 = STRUPCASE(STRMID(name, nb, 3))
		IF tmp3 EQ 'ULL' || tmp3 EQ 'XUL' || tmp3 EQ 'XLL' || tmp3 EQ 'OUL' || tmp3 EQ 'OLL' THEN BEGIN
			nb += 3
			is_constant = 1
			RETURN, 1	; doc IDL
		END

		tmp2 = STRUPCASE(STRMID(name, nb, 2))
		IF tmp2 EQ 'US' || tmp2 EQ 'UL' || tmp2 EQ 'LL' || tmp2 EQ 'XB' || tmp2 EQ 'XU' || tmp2 EQ 'XL' || tmp2 EQ 'OU' || tmp2 EQ 'OL' THEN BEGIN
			nb += 2
			is_constant = 1
			RETURN, 1	; doc IDL
		END

		tmp1 = STRUPCASE(STRMID(name, nb, 1))
		IF tmp1 EQ 'B' || tmp1 EQ 'S' || tmp1 EQ 'U' || tmp1 EQ 'L' || tmp1 EQ 'X' || tmp1 EQ 'O' THEN BEGIN
			nb++
			is_constant = 1
			RETURN, 1	; doc IDL (sauf pour '111011'b)
		END

		is_string = 1
		RETURN, 1

	END

	RETURN, 0

END


;-------------------------------------------------------------------------------
PRO lint_traiter_lignec,	$
;-------------------------------------------------------------------------------
	data				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Rajoute des valeurs dans data.decl.cla pour coloriser la ligne de code en C data.line.
;-------------------------------------------------------------------------------

	COMMON COMMON_LINT_TRAITER_LIGNEC,	inside_string_simple, inside_string_double, inside_comment

	IF N_ELEMENTS(inside_string_simple) EQ 0 THEN BEGIN
		inside_string_simple = 0
		inside_string_double = 0
		inside_comment = 0
	END

	keywords = [				$
			'extern',		$
			'static',		$
			'typedef',		$
			'unsigned',		$
			'long',			$
			'char',			$
			'float',		$
			'short',		$
			'void',			$
			'double',		$
			'int',			$
			'switch',		$
			'case',			$
			'if',			$
			'else',			$
			'for',			$
			'while',		$
			'return',		$
			'struct',		$
			'break',		$
			'continue',		$
			'default',		$
			'goto',			$
			'enum',			$
			'union',		$
			'define',		$
			'defined',		$
			'ifdef',		$
			'ifndef',		$
			'endif'			$
	]

	calls = [				$
			'sizeof'		$
	]

	len = STRLEN(data.line)

	WHILE data.pos LT len DO BEGIN

		code = lint_get_name_c (data, name)

		data.pos = code

		premier_mot = STRTRIM (STRMID(data.line, 0, data.pos), 2) EQ '' ; 1 s'il n'y a que des blancs avant name

		IF inside_string_simple THEN BEGIN
			IF STRMID(data.line, data.pos, 1) EQ "'" &&  (STRMID(data.line, data.pos-1, 1) NE '\' || STRMID(data.line, data.pos-2, 1) EQ '\') THEN BEGIN
				inside_string_simple = 0
			END
			data.pos++
			CONTINUE
		END

		IF inside_string_double THEN BEGIN
			IF STRMID(data.line, data.pos, 1) EQ '"' &&  (STRMID(data.line, data.pos-1, 1) NE '\' || STRMID(data.line, data.pos-2, 1) EQ '\') THEN BEGIN
				inside_string_double = 0
			END
			data.pos++
			CONTINUE
		END

		IF inside_comment THEN BEGIN
			IF STRMID(data.line, data.pos, 2) EQ '*/' THEN BEGIN
				inside_comment = 0
				data.pos += 2
				CONTINUE
			END ELSE BEGIN
				data.pos++
				CONTINUE
			END
		END

		IF STRMID(data.line, data.pos, 1) EQ '"' THEN BEGIN
			inside_string_double = 1
			data.pos++
			CONTINUE
		END

		IF STRMID(data.line, data.pos, 1) EQ "'" THEN BEGIN
			inside_string_simple = 1
			data.pos++
			CONTINUE
		END

		IF ~inside_string_double && ~inside_string_simple && STRMID(data.line, data.pos, 2) EQ '/*' THEN BEGIN
			inside_comment = 1
			data.pos += 2
			CONTINUE
		END

		IF STRMID(data.line, data.pos, 2) EQ '//' THEN BEGIN
			lint_add_cla, data, 'COMMENT', STRMID(data.line, data.pos), '', ''
			BREAK ; commentaire sur une ligne
		END

		IF name EQ data.decl.name THEN BEGIN
			; pas de lien sur la fonction elle mme
			data.pos += STRLEN(name)
			CONTINUE
		END


		IF name EQ '' THEN BEGIN
			code = lint_get_constant_c (data, name)
			data.pos = code
			IF name NE '' THEN BEGIN
				lint_add_cla, data, 'CONSTANT', name, '', ''
				data.pos += STRLEN(name)
			END ELSE BEGIN
				; ex: "#include ..."
				data.pos++
			END
			CONTINUE
		END



		ind1 = lint_get_decls_by_name_passe2 (data, name)

		IF ind1[0] NE -1 THEN BEGIN
			; ne garder que les 'FUNCTIONC','MACROC' et 'TYPEC'

			; Y a t-il une parenthse aprs name ?
			; utilis pour savoir si on appelle une fonction
			; si has_parenthese alors FUNCTIONC ou MACROC sinon TYPEC ou MACRO
			tmp = LINTC_SAUTER_ESPACES_TABULATIONS (data.line, data.pos+STRLEN(name))
			char1 = STRMID(data.line, tmp, 1)
			has_parenthese	= lint_is_parenthese_ouvrante(char1)

			IF data.decl.name EQ 'IDL_Load' THEN BEGIN
				; Exception si data.decl.name == IDL_Load: on accepte tout, sinon lint va dire que les fonctions ne sont pas utilises.
				ind2 = WHERE (data.decls[ind1].function_pro EQ 'FUNCTIONC' OR data.decls[ind1].function_pro EQ 'MACROC' OR data.decls[ind1].function_pro EQ 'TYPEC')
			END ELSE IF data.decl.function_pro EQ 'TYPEC' AND premier_mot THEN BEGIN
				; Exception premier mot de chaque ligne  l'intrieur d'un typedef est un type
				ind2 = WHERE (data.decls[ind1].function_pro EQ 'TYPEC')
			END ELSE IF has_parenthese THEN BEGIN
				; ne garder que les 'FUNCTIONC' et 'MACROC'
				ind2 = WHERE (data.decls[ind1].function_pro EQ 'FUNCTIONC' OR data.decls[ind1].function_pro EQ 'MACROC')
			END ELSE BEGIN
				; ne garder que les 'TYPEC' et 'MACROC'
				ind2 = WHERE (data.decls[ind1].function_pro EQ 'TYPEC' OR data.decls[ind1].function_pro EQ 'MACROC')
			END
			ind1 = ind2[0] EQ -1 ? -1 : ind1[ind2]
		END

		IF ind1[0] NE -1 THEN BEGIN
			; garder toutes les FUNCTIONC
			; mais ne garder que les MACROC et les TYPEC qui sont dans inherits_full

			inherits_full = STRSPLIT (data.decl.inherits_full, /EXTRACT)
			FOR i=0L,N_ELEMENTS(ind1)-1 DO BEGIN
				IF data.decls[ind1[i]].function_pro EQ 'FUNCTIONC' THEN CONTINUE
				IF data.decls[ind1[i]].function_pro EQ 'MACROC' OR data.decls[ind1[i]].function_pro EQ 'TYPEC' THEN BEGIN
					ind2 = WHERE (inherits_full EQ data.decls[ind1[i]].module)
					IF ind2[0] EQ -1 THEN ind1[i] = -1
				END
			END
			ind2 = WHERE (ind1 NE -1)
			ind1 = ind2[0] EQ -1 ? -1 : ind1[ind2]
		END

		IF ind1[0] NE -1 THEN BEGIN
			IF N_ELEMENTS(ind1) GE 2 THEN BEGIN
				; garder les routines dont le champ is_extern vaut 0
				; => garder les vraies dfinitions plutot que les dclarations en "extern"
				ind2 = WHERE (data.decls[ind1].is_extern EQ 0)
				IF ind2[0] NE -1 THEN ind1 = ind1[ind2]

				; garder les ".c" plutot que les ".h"
				;ext = REPLICATE ('', N_ELEMENTS(ind1))
				;FOR i=0L,N_ELEMENTS(ind1)-1 DO ext[i] = STRMID(data.decls[ind1[i]].module, STRLEN(data.decls[ind1[i]].module)-2, 2)
				;ind2 = WHERE (ext EQ '.c')
			END
			IF N_ELEMENTS(ind1) GE 2 THEN BEGIN
				; garder celui qui a le plus de mots en commun avec data.decl.module
				trouve = 0
				FOR i=STRLEN(data.decl.module)-1,0,-1 DO BEGIN
					cherche = STRMID(data.decl.module, 0, i)
					FOR k=0L,N_ELEMENTS(ind1)-1 DO BEGIN
						IF STRMID(data.decls[ind1[k]].module, 0, i) EQ cherche THEN BEGIN
							ind1 = ind1[k]
							trouve = 1
							;PRINT,name+' '+data.decls[ind2].module
							BREAK
						END
					END
					IF trouve THEN BREAK
				END
				IF ~trouve THEN ind1 = -1
			END
		END

		IF ind1[0] NE -1 THEN BEGIN

			CASE data.decls[ind1[0]].function_pro OF

				'FUNCTIONC': 	call_user = ~data.decls[ind1[0]].is_system || !LINT_SYSTEM_FUNCTIONC
				'MACROC':	call_user = ~data.decls[ind1[0]].is_system || !LINT_SYSTEM_MACROC
				'TYPEC':	call_user = ~data.decls[ind1[0]].is_system || !LINT_SYSTEM_TYPEC

			END

			IF call_user THEN BEGIN
				link = data.decls[ind1[0]].module+'/'+data.decls[ind1[0]].function_pro+'_'+data.decls[ind1[0]].name+'.html'
				lint_add_cla, data, 'CALL_USER', name, '', link
			END ELSE BEGIN
				tmp = data.decls[ind1[0]].module
				IF STRMID(tmp, 0, 6) EQ 'slash/' THEN tmp = STRMID(tmp, 5)
				tmp += ': ' + data.decls[ind1[0]].function_pro
				tmp += STRING(10b) + STRING(10b) + data.decls[ind1[0]].code
				lint_add_cla, data, 'CALL_SYSTEM', name, '', tmp
			END
			data.pos += STRLEN(name)
			data.decls[data.nor].call += LINTC_INT_TO_STR(ind1[0]) + ' '
			data.decls[ind1[0]].calledby += LINTC_INT_TO_STR(data.nor) + ' '
			data.decls[ind1[0]].nb_use++
			CONTINUE
		END

		IF name EQ '' THEN BEGIN
			data.pos++
			CONTINUE
		END

		ind1 = WHERE (keywords EQ name)
		IF ind1[0] NE -1 THEN BEGIN
			lint_add_cla, data, 'KEYWORD', name, '', ''
		END

		ind1 = WHERE (calls EQ name)
		IF ind1[0] NE -1 THEN BEGIN
			lint_add_cla, data, 'CALL_SYSTEM', name, '', 'SYSTEM/built-in'
		END

		data.pos += STRLEN(name)

	END

END

;-------------------------------------------------------------------------------
PRO lint_traiter_expression,	$
;-------------------------------------------------------------------------------
	data,			$		; LINT_PROTOTYPE input
	type					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Traite l'expression qui se trouve dans data.line en position data.pos avec le type type.
;
; type peut valoir:
;	'debut'
;	'unknow'
;	'valeur_champ_structure'
;	'nom_champ_structure
;	'appel_methode ' + instance
;	'directive'
;	'subscript'
;	'field'
;	'para ' + numro + ' no_appels'
;	'para ' + keyword +' no_appels'
;-------------------------------------------------------------------------------

	IF !DEBUG THEN my_print, '  lint_traiter_expression type=[' + type + ']' + ' line=[' + STRMID(data.line, data.pos) + ']'

	IF type EQ 'subscript' && lint_get_etoile_subscript(data) THEN BEGIN
		code = lint_get_etoile(data)
		data.pos++
		RETURN
	END

	IF lint_get_accolade_ouvrante(data) THEN BEGIN

		; Dclaration de structure
		lint_check_space_tab_after, data, '{'
		data.pos++

		premier = 1

		WHILE 1 DO BEGIN

			; pour le premier nom;
			; soit nom		=> nom de la structure
			; soit nom:valeur	=> nom et valeur du premier champ

			; pour les suivants:
			; Soit nom:valeur	=> 'nom_champ_structure"
			; Soit valeur		=> valeur normale

			code = lint_get_name_idl (data, name)
			tmp = data.pos
			data.pos = code + STRLEN(name)
			is_2points = lint_get_2points(data)
			data.pos = tmp

			IF STRCMP(name, 'INHERITS', /FOLD_CASE) THEN BEGIN
				data.pos = code
				lint_add_cla, data, 'KEYWORD', name, '', ''
				data.pos += STRLEN(name)
				type = 'nom_inherits_structure'
			END ELSE BEGIN
				type = is_2points ? 'nom_champ_structure' : (premier ? 'nom_structure' : 'valeur_champ_structure')
			END
		
			;IF type EQ 'valeur_champ_structure' THEN BEGIN	
				lint_traiter_expression, data, type
			;END ELSE BEGIN
			;	data.pos = code + STRLEN(name)
			;	lint_traiter_name, data, name, type
			;END

			premier = 0

			IF lint_get_virgule(data) THEN BEGIN
				lint_check_space_tab_after, data, ','
				data.pos++
			END ELSE IF lint_get_2points(data) THEN BEGIN
				data.pos++
				lint_traiter_expression, data, 'valeur_champ_structure'
			END ELSE IF lint_get_accolade_fermante(data) THEN BEGIN
				lint_check_space_tab_before, data, '}'
				data.pos++
				BREAK
			END ELSE BEGIN
				data.pos++
				IF data.pos GE STRLEN(data.line) THEN BREAK
			END
		END
		RETURN
	END

	WHILE 1 DO BEGIN

		code = lint_get_operator (data, name)
		IF !DEBUG THEN my_print, 'lint_get_operator => [' + name+']'

		; Oprateur en majuscule
		IF name NE STRUPCASE(name) THEN BEGIN
			IF data.decl.check_syntax THEN BEGIN
				my_print_msg, data, lint_get_message(data) + '"' + name + '" NOT IN UPPERCASE ['+data.line+']'
			END
		END

		IF (name NE '') && (name NE '[') && (name NE '(') THEN BEGIN
			lint_add_cla, data, 'KEYWORD', name, '', ''
		END


		SWITCH name OF
			'->':
			'+=':
			'-=':
			'*=':
			'/=':
			'?':	lint_check_space_tab, data, name
		END

		IF name EQ '[' THEN BEGIN

			; ex: choix_nochamp = (get(obj,chaine_interpreteur,/INFO))[4:*]

			data.pos = code + STRLEN(name)
			IF type EQ 'debut' THEN type = 'unknow'

			WHILE 1 DO BEGIN

				IF data.instance NE '' THEN BEGIN
					lint_traiter_subscript, data
				END ELSE BEGIN
					lint_traiter_expression, data, type
				END
				IF lint_get_crochet_fermant(data) THEN BEGIN
					data.pos++
					BREAK
				END
				IF lint_get_virgule(data) THEN BEGIN
					data.pos++
				END ELSE BEGIN
					; ex: "print,[ tab"
					my_print_msg, data, lint_get_message(data) + 'SYNTAX ERROR "," EXPECTED [' + data.line + ']'
					lint_add_msg, data,  'SYNTAX ERROR', '"," EXPECTED'
					BREAK
				END

			END

		END ELSE IF name EQ '(' THEN BEGIN

			IF !DEBUG THEN my_print, 'parenthese_ouvrante'
			data.pos = code + STRLEN(name)

			IF type EQ 'debut' THEN type = 'unknow'

			; pour Berkeley spdsoft
			; ex: "./projects/themis/ground/thm_alt_stackplot.pro(146)"
			; ex: "themedian = strcompress(string(median(dd.y(index_time, 0), /even), format = '(f10.1)'), /remove_all)"
			is_subscript = 0

			WHILE 1 DO BEGIN

				; pour Berkeley spdsoft
				; ex: "./projects/themis/ground/thm_alt_stackplot.pro(146)"
				; ex: "themedian = strcompress(string(median(dd.y(index_time, 0), /even), format = '(f10.1)'), /remove_all)"
				pos = data.pos

				lint_traiter_expression, data, type

				IF lint_get_egal(data) THEN BEGIN
					;ex: "IF N_ELEMENTS((ind = WHERE (tab EQ 2))) EQ 1 THEN BEGIN"
					; ex: "    if n_elements((idx = where(tlm_conv eq alg_records[*,1],c))) ne 1 || c gt 0 then begin"
				END

				IF lint_get_parenthese_fermante(data) THEN BEGIN
					IF !DEBUG THEN my_print, 'parenthese_fermante'
					data.pos++
					BREAK
				END

				; pour Berkeley spdsoft
				; ex: "./projects/themis/ground/thm_alt_stackplot.pro(146)"
				; ex: "themedian = strcompress(string(median(dd.y(index_time, 0), /even), format = '(f10.1)'), /remove_all)"
				IF data.pos EQ pos THEN BEGIN
					is_subscript = 1
					BREAK
				END

			END

			; pour Berkeley spdsoft
			; ex: "./projects/themis/ground/thm_alt_stackplot.pro(146)"
			; ex: "themedian = strcompress(string(median(dd.y(index_time, 0), /even), format = '(f10.1)'), /remove_all)"
			IF is_subscript THEN BEGIN
				WHILE 1 DO BEGIN
			
					lint_traiter_subscript, data
					IF lint_get_parenthese_fermante(data) THEN BEGIN
						data.pos++
						BREAK
					END
					IF lint_get_virgule(data) THEN BEGIN
						data.pos++
					END ELSE BEGIN
						; ex: "print,[ tab"
						my_print_msg, data, lint_get_message(data) + 'SYNTAX ERROR "," EXPECTED [' + data.line + ']'
						lint_add_msg, data, 'SYNTAX ERROR', '"," EXPECTED'
						BREAK
					END
			
				END
			END

		END ELSE IF name EQ '?'  THEN BEGIN

			data.pos = code + STRLEN(name)
			IF type EQ 'debut' THEN type = 'unknow'
			lint_traiter_expression, data, type
			IF lint_get_2points(data) THEN BEGIN
				data.pos++
				lint_traiter_expression, data, type
			END ELSE BEGIN
				; ex: "print, x ? 1"
				my_print_msg, data, lint_get_message(data) + 'SYNTAX ERROR ":" EXPECTED [' + data.line + ']'
				lint_add_msg, data, 'SYNTAX ERROR', '":" EXPECTED'
			END

		END ELSE IF name EQ '--' || name EQ '++' THEN BEGIN

			data.pos = code + STRLEN(name)
			IF type EQ 'debut' THEN type = 'unknow'

		END ELSE IF name EQ '->' THEN BEGIN

			data.pos = code + STRLEN(name)	; sauter le '->'
			IF type EQ 'debut' THEN type = 'unknow'
			code = lint_get_name_idl (data, name)
			lint_traiter_expression, data, 'appel_methode ' + data.instance

		END ELSE IF name EQ '@' THEN BEGIN

			data.pos = code + STRLEN(name)	; sauter le '@'
			IF type EQ 'debut' THEN type = 'unknow'
			name = STRTRIM (STRMID(data.line, data.pos), 2) ; tout ce qui suit le '@' ex: "@thm_fgm_dac_corrections.dat"
			data.instance = name
			;print,'data.instance = [' + data.instance + ']'
			lint_traiter_name, data, name, 'appel_include'

		END ELSE IF name NE '' THEN BEGIN

			SWITCH name OF
				'+=':
				'-=':
				'*=':
				'/=':
				'++':
				'--': BEGIN
					set_data_statement, data, STRUPCASE(name)
				END
			END
			data.pos = code + STRLEN(name)
			IF type EQ 'debut' THEN type = 'unknow'
			lint_traiter_expression, data, type

		END ELSE BEGIN

			IF lint_get_point(data) && (STRMID(data.line, data.pos+1, 1) LT '0' || STRMID(data.line, data.pos+1, 1) GT '9') THEN BEGIN

				data.pos++
				is_directive = type EQ 'debut'
				IF type EQ 'debut' THEN type = 'unknow'
				lint_traiter_expression, data, is_directive ? 'directive' : 'nom_champ_structure'

			END ELSE BEGIN

				code = lint_get_name_idl (data, name)
				data.pos = code

				IF 	STRCMP(name, 'IF',	  /FOLD_CASE)	|| $
					STRCMP(name, 'THEN',	  /FOLD_CASE)	|| $
					STRCMP(name, 'ELSE',	  /FOLD_CASE)	|| $
					STRCMP(name, 'BEGIN',	  /FOLD_CASE)	|| $
					STRCMP(name, 'END',	  /FOLD_CASE)	|| $
					STRCMP(name, 'ENDIF',	  /FOLD_CASE)	|| $
					STRCMP(name, 'ENDELSE',   /FOLD_CASE)	|| $
					STRCMP(name, 'ENDFOR',	  /FOLD_CASE)	|| $
					STRCMP(name, 'ENDCASE',	  /FOLD_CASE)	|| $
					STRCMP(name, 'ENDWHILE',  /FOLD_CASE)	|| $
					STRCMP(name, 'ENDREP',	  /FOLD_CASE)	|| $
					STRCMP(name, 'ENDSWITCH', /FOLD_CASE)	|| $
					STRCMP(name, 'UNTIL',	  /FOLD_CASE)	|| $
					STRCMP(name, 'REPEAT',	  /FOLD_CASE)	|| $
					STRCMP(name, 'FOR',	  /FOLD_CASE)	|| $
					STRCMP(name, 'WHILE',	  /FOLD_CASE)	|| $
					STRCMP(name, 'SWITCH',	  /FOLD_CASE)	|| $
					STRCMP(name, 'CASE',	  /FOLD_CASE)	|| $
					STRCMP(name, 'OF',	  /FOLD_CASE)	|| $
					STRCMP(name, 'DO',	  /FOLD_CASE) 	THEN BEGIN

					IF STRMID(type, 0, 4) EQ 'para' THEN BEGIN
						; c'est le signe que l'on est arriv  la fin des paramtres
						; ex: "if keyword_set(unload) then cspice_unload,files         else cspice_unload,files"
						RETURN
					END

					lint_add_cla, data, 'KEYWORD', name, '', ''

					IF name NE STRUPCASE(name) THEN BEGIN
						IF data.decl.check_syntax THEN BEGIN
							my_print_msg, data, lint_get_message(data) + '"' + name + '" NOT IN UPPERCASE ['+data.line+']'
						END
					END

					IF 	STRCMP(name, 'ENDIF',	  /FOLD_CASE)	|| $
						STRCMP(name, 'ENDELSE',	  /FOLD_CASE)	|| $
						STRCMP(name, 'ENDFOR',	  /FOLD_CASE)	|| $
						STRCMP(name, 'ENDCASE',	  /FOLD_CASE)	|| $
						STRCMP(name, 'ENDWHILE',  /FOLD_CASE)	|| $
						STRCMP(name, 'ENDREP',	  /FOLD_CASE)	|| $
						STRCMP(name, 'ENDSWITCH', /FOLD_CASE)	THEN BEGIN
						IF data.decl.check_syntax THEN BEGIN
							my_print_msg, data, lint_get_message(data) + '"' + name + '" FOUND ['+data.line+']'
						END
					END

					IF STRCMP(name, 'FOR', /FOLD_CASE) THEN BEGIN
						IF data.decl.check_syntax THEN BEGIN
							tmp = (STRSPLIT(STRMID(data.line, data.pos), '=', /EXTRACT))[1]
							tmp1 = (STRSPLIT(tmp, ',', /EXTRACT))[0]
							i = 0
							IF lint_is_digits(STRMID(tmp1, i, 1)) THEN BEGIN
								WHILE lint_is_digits(STRMID(tmp1, i, 1)) DO i++
								IF STRMID(tmp1, i, 1) NE 'L' THEN BEGIN
									my_print_msg, data, lint_get_message(data) + 'FOR VARIABLE NOT LONG ['+data.line+']'
								END
							END
							;tmp2 = (STRSPLIT(tmp, ',', /EXTRACT))[1]
							;IF chaine_contient(STRUPCASE(tmp2),'N_ELEMENTS') THEN BEGIN
							;	my_print_msg, data, lint_get_message(data) + 'N_ELEMENTS() FOUND IN FOR VARIABLE ['+data.line+']'
							;END
						END
					END

					IF	STRCMP(name, 'THEN',	/FOLD_CASE)	|| $
						STRCMP(name, 'BEGIN',	/FOLD_CASE)	|| $
						STRCMP(name, 'ELSE',	/FOLD_CASE)	|| $
						STRCMP(name, 'DO',	/FOLD_CASE)	THEN BEGIN
 
						lint_finaliser_variables_en_cours, data
						type = 'debut'

					END ELSE BEGIN

						type = 'unknow'

					END

					set_data_statement, data, STRUPCASE(name)
					IF !DEBUG THEN my_print, 'statement = ['+data.statement +'] dans ' + data.line
					data.pos += STRLEN(name)

				END ELSE IF name NE '' THEN BEGIN

					data.instance = name
					;print,'data.instance = [' + data.instance + ']'
					IF name EQ 'self' && STRMID(data.line, data.pos+4, 1) EQ '.' THEN BEGIN
						; ex: "self.x -> methode" l'instance n'est pas self car self ne dfini pas forcment la mthode
						data.instance += '.'
					END
					lint_traiter_name, data, name, type
					IF STRMID(type, 0, 4) NE 'para' THEN type = 'unknow' ; fin de 'nom_champ_structure' par exemple

				END ELSE IF lint_is_string_or_constant(STRMID(data.line, data.pos), is_string, is_constant, nb) THEN BEGIN

					name = STRMID(data.line, data.pos, nb)
					data.instance = name
					;print,'data.instance = [' + data.instance + ']'
					lint_traiter_name, data, name, type
					IF STRMID(type, 0, 4) NE 'para' THEN type = 'unknow' ; fin de 'nom_champ_structure' par exemple

				END ELSE BEGIN

					IF STRMID(data.line, data.pos, 1) EQ ',' AND data.statement EQ 'FOR=' THEN BEGIN
						;lint_add_ccc, data, "KEYWORD_C", ',', ' ; ' + data.for_variable + '<='
					END

					IF STRMID(type, 0, 4) NE 'para' THEN type = 'unknow' ; fin de 'nom_champ_structure' par exemple
					BREAK

				END
			END

		END

	END

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_string,	$
;-------------------------------------------------------------------------------
	s				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne la premire sous-chaine de name qui se trouve entre '...' ou "..."
;-------------------------------------------------------------------------------

	s1 = s

	; 1) ne garder que ce qui est aprs '...' ou "...'
	pos = STRPOS(s1, "'") & IF pos EQ -1 THEN pos = STRPOS(s1, '"')
	IF pos NE -1 THEN s1 = STRMID(s1, pos+1)

	; 2) ne garder que ce qui est avant '...' ou "...'
	pos = STRPOS(s1, "'") & IF pos EQ -1 THEN pos = STRPOS(s1, '"')
	IF pos NE -1 THEN s1 = STRMID(s1, 0, pos)

	RETURN, s1

END


;-------------------------------------------------------------------------------
PRO lint_traiter_para,	$
;-------------------------------------------------------------------------------
	data,		$	; LINT_PROTOTYPE input
	nocalls			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Traite un paramtre (argument d'un appel de FUNCTION ou PRO)
;-------------------------------------------------------------------------------

	COMMON COMMON_LINT, common_lint_infos

	target = common_lint_infos.target

	set_data_statement, data, 'para'

	argv = '' ; pour mmoriser les paramtres de CALL_EXTERNAL

	nopara = 1L
	nbparams = 0L

	; Mmorisation des variables en_cours
	ind = WHERE ((*data.vars).categorie EQ 'para_en_cours')
	name_para_en_cours_old = ind[0] EQ -1 ? '' : (*data.vars)[ind].name


	FOR i=0L,N_ELEMENTS(nocalls)-1 DO BEGIN	
		; il faut appeller lint_dynamic_prototype une seule fois
		IF data.decls[nocalls[i]].is_system THEN BEGIN
			lint_dynamic_prototype, data, 0, nocalls[i], 'DEBUT', 'xxx'
			BREAK
		END
	END

	WHILE 1 DO BEGIN

		data.instance = ''
		;print,'data.instance = [' + data.instance + ']'

		pos = lint_get_slash_keyword(data, keyword)
		IF pos NE -1 THEN BEGIN

			lint_check_no_space_tab_after, data, '/'

			lint_add_cla, data, 'KEYWORD_ROUTINE', '/'+keyword, '', ''

			; Crer une variable temporaire
			vars = *data.vars
			var = { name: '/'+keyword, categorie: 'system', contexte: '', nb_use: 1L }
			vars = [ vars, var ]
			PTR_FREE, data.vars
			data.vars = PTR_NEW(vars, /NO_COPY)

			lint_traiter_name, data, '/' + keyword, 'para ' + keyword + ' ' + STRJOIN(val_to_str(nocalls), ' ')

			; Supprimer cette variable temporaire
			vars = *data.vars
			vars = vars[WHERE(vars.name NE '/'+keyword OR vars.categorie EQ 'system')]
			PTR_FREE, data.vars
			data.vars = PTR_NEW(vars, /NO_COPY)

			; rajouter les nouveaux KEYWORDS dans keywords_used
			FOR i=0L,N_ELEMENTS(nocalls)-1 DO BEGIN
				tmp = STRSPLIT(data.decls[nocalls[i]].keywords_used, /EXTRACT)
				IF (WHERE(STRUPCASE(tmp) EQ STRUPCASE(keyword)))[0] EQ -1 THEN data.decls[nocalls[i]].keywords_used += (data.decls[nocalls[i]].keywords_used EQ '' ? '' : ' ') + STRUPCASE(keyword)
			END

		END ELSE BEGIN

			pos = lint_get_keyword_egal(data, keyword)
			IF pos NE -1 THEN BEGIN
				lint_add_cla, data, 'KEYWORD_ROUTINE', keyword, '', ''
				data.pos = pos

				data.pos--
				lint_check_no_space_tab, data, '='
				data.pos++

				lint_traiter_expression, data, 'para ' + keyword + ' ' + STRJOIN(val_to_str(nocalls), ' ')
				; rajouter les nouveaux KEYWORDS dans keywords_used
				FOR i=0L,N_ELEMENTS(nocalls)-1 DO BEGIN
					tmp = STRSPLIT(data.decls[nocalls[i]].keywords_used, /EXTRACT)
					IF (WHERE(STRUPCASE(tmp) EQ STRUPCASE(keyword)))[0] EQ -1 THEN data.decls[nocalls[i]].keywords_used += (data.decls[nocalls[i]].keywords_used EQ '' ? '' : ' ') + STRUPCASE(keyword)
				END
	

			END ELSE BEGIN

				pos = lint_get_parenthese_ouvrante_name_egal(data, name)
				IF pos NE -1 THEN BEGIN

					PRINT, lint_get_message(data)+'parenthese_ouvrante_name_egal: ' + STRMID(data.line, data.pos) + ' [' + data.line + ']'

					; traitement (name=expression) comme argument
					IF !DEBUG THEN my_print, 'parenthese_ouvrante_name_egal'
					data.pos++
					data_pos_old = data.pos

					data.instance = name
					;print,'data.instance = [' + data.instance + ']'
					lint_traiter_expression, data, 'unknow'
					data_pos_new = data.pos

					data.pos = data_pos_old
					argv += ' ' + val_to_str(data.pos)
					lint_traiter_name, data, name, 'para ' + LINTC_INT_TO_STR(nopara) + ' ' + STRJOIN(val_to_str(nocalls), ' ')
					nopara++
					nbparams++
					data.pos = data_pos_new

					IF lint_get_parenthese_fermante(data) THEN BEGIN
						IF !DEBUG THEN my_print, 'parenthese_fermante'
						data.pos++
					END ELSE BEGIN
						my_print_msg, data, lint_get_message(data) + 'SYNTAX ERROR ")" EXPECTED [' + data.line +']'
						lint_add_msg, data, 'SYNTAX ERROR', '")" EXPECTED'
					END


				END ELSE IF ~lint_get_parenthese_fermante(data) THEN BEGIN

					argv += ' ' + val_to_str(data.pos)
					lint_traiter_expression, data, 'para ' + LINTC_INT_TO_STR(nopara) + ' ' + STRJOIN(val_to_str(nocalls), ' ')
					nopara++
					nbparams++

				END
			END

		END

		IF lint_get_virgule(data) THEN BEGIN
			IF data.decl.check_space THEN lint_check_space_tab_after, data, ',', /force
			data.pos++
		END ELSE BEGIN
			BREAK
		END

	END

	FOR i=0L,N_ELEMENTS(nocalls)-1 DO BEGIN	
		; il faut appeller lint_dynamic_prototype une seule fois
		IF data.decls[nocalls[i]].is_system THEN BEGIN
			lint_dynamic_prototype, data, 0, nocalls[i], 'FIN', 'xxx'
			BREAK
		END
	END

	; Quelles variables ont t crs ?
	ind_para_en_cours = WHERE ((*data.vars).categorie EQ 'para_en_cours', nb_para_en_cours)

	; finaliser ces variables
	; ex: "print, 'min=',min(tab,max=max),' max=',max" il faut finaliser max une fois que min() a t appel
	FOR i=0L,nb_para_en_cours-1 DO BEGIN
		IF (WHERE(name_para_en_cours_old EQ (*data.vars)[i].name))[0] EQ -1 THEN BEGIN
			(*data.vars)[ind_para_en_cours[i]].categorie = 'para'
		END
	END

	IF data.decls[nocalls[0]].name EQ 'call_external' THEN BEGIN
		tab_argv = STRSPLIT(argv, /EXTRACT) ; positions des arguments dans data.line
		; recherche dans tmp1 de noline + !SEP2 + nochar + !SEP2 + CALL_SYSTEM + !SEP2 + CALL_EXTERNAL' + !SEP2 + '' + !SEP2 + 'SYSTEM'
		; commencer par la fin pour aller plus vite
		; sortir ds qu'on a trouv
		FOR i=data.decls[data.nor].nbclas-1,0,-1 DO BEGIN
			IF ((*data.decls[data.nor].cla)[i].type EQ 'CALL_SYSTEM') && ((*data.decls[data.nor].cla)[i].word EQ 'CALL_EXTERNAL') && ((*data.decls[data.nor].cla)[i].extra EQ '') AND (~chaine_contient((*data.decls[data.nor].cla)[i].link, '.html')) THEN BEGIN

				module = lint_get_string(STRMID(data.line, tab_argv[0]))
				name   = lint_get_string(STRMID(data.line, tab_argv[1]))

				ind1 = lint_get_decls_by_name_passe2 (data, name)
				IF ind1[0] NE -1 THEN BEGIN
					; prendre celui dont le basename de module vaut module+'.c'
					FOR j=0L,N_ELEMENTS(ind1)-1 DO BEGIN
						IF basename(data.decls[ind1[j]].module) EQ module+'.c' THEN BEGIN
							(*data.decls[data.nor].cla)[i].link = data.decls[ind1[j]].module + '/' + data.decls[ind1[j]].function_pro + '_' + data.decls[ind1[j]].name + '.html'
							data.decls[data.nor].call += LINTC_INT_TO_STR(ind1[j]) + ' '
							data.decls[ind1[j]].calledby += LINTC_INT_TO_STR(data.nor) + ' '
							data.decls[ind1[j]].nb_use++
							BREAK
						END
					END
				END
			END
		END
		
	END

	data.instance = data.decls[nocalls[0]].name
	;print,'data.instance = [' + data.instance + ']'

	FOR i=0L,N_ELEMENTS(nocalls)-1 DO BEGIN

		IF N_ELEMENTS(nocalls) NE 1 && target NE 'cl' THEN BEGIN
			; plusieurs appels possibles: mieux vaut ne rien afficher
			CONTINUE
		END

		nocall = nocalls[i]

		nb_params_min = data.decls[nocall].nb_params_min
		nb_params_max = data.decls[nocall].nb_params_max

		IF data.decls[nocall].is_system THEN BEGIN
			name = STRUPCASE(data.decls[nocall].name)
			call = "SYSTEM CALL"
		END ELSE BEGIN
			name = data.decls[nocall].name
			call = "USER CALL"
		END

		IF nbparams LT nb_params_min THEN BEGIN
			my_print_msg, data, lint_get_message(data) + 'TOO FEW ARGUMENTS ('+LINTC_INT_TO_STR(nbparams)+' BUT MIN=' + LINTC_INT_TO_STR(nb_params_min) + ' MAX=' + LINTC_INT_TO_STR(nb_params_max) + ') IN ' + call + ' "' + name + '" ['+data.line+']'
			                                                         msg = '('+LINTC_INT_TO_STR(nbparams)+' BUT MIN=' + LINTC_INT_TO_STR(nb_params_min) + ' MAX=' + LINTC_INT_TO_STR(nb_params_max) + ') IN ' + call + ' "' + name + '"'
			lint_add_msg, data, 'TOO FEW ARGUMENTS', msg
		END

		IF nbparams GT nb_params_max THEN BEGIN
			my_print_msg, data, lint_get_message(data)+ 'TOO MANY ARGUMENTS ('+LINTC_INT_TO_STR(nbparams)+' BUT MIN=' + LINTC_INT_TO_STR(nb_params_min) + ' MAX=' + LINTC_INT_TO_STR(nb_params_max) + ') IN ' + call + ' "' + name + '" ['+data.line+']'
			msg =                                                          '('+LINTC_INT_TO_STR(nbparams)+' BUT MIN=' + LINTC_INT_TO_STR(nb_params_min) + ' MAX=' + LINTC_INT_TO_STR(nb_params_max) + ') IN ' + call + ' "' + name + '"'
			lint_add_msg, data, 'TOO MANY ARGUMENTS', msg
		END

	END

	set_data_statement, data, 'FIN_PARA'

END

;-------------------------------------------------------------------------------
PRO lint_traiter_call_pro,	$
;-------------------------------------------------------------------------------
	data,			$	; LINT_PROTOTYPE input
	nocalls				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Traite un appel de PRO "appel" ou "appel, arguments ...".
;-------------------------------------------------------------------------------

	data.decls[nocalls].nb_use++

	IF lint_get_virgule (data) THEN BEGIN
		IF data.decls[nocalls[0]].is_system && data.decls[nocalls[0]].name EQ 'print' THEN BEGIN
			;lint_add_ccc, data, 'debug1', ',', '("%f",'
		END ELSE IF data.decls[nocalls[0]].is_system && data.decls[nocalls[0]].name EQ 'goto' THEN BEGIN
			;lint_add_ccc, data, 'debug1', ',', ''
		END ELSE IF data.decls[nocalls[0]].is_system && data.decls[nocalls[0]].name EQ 'return' THEN BEGIN
			;lint_add_ccc, data, 'debug1', ',', ''
		END ELSE BEGIN
			;lint_add_ccc, data, 'debug1', ',', '('
		END
		IF data.decl.check_space THEN lint_check_space_tab_after, data, ',', /force
		data.pos++

		lint_traiter_para, data, nocalls
	END

	IF data.decls[nocalls[0]].is_system && data.decls[nocalls[0]].name EQ 'continue' THEN BEGIN
	END ELSE IF data.decls[nocalls[0]].is_system && data.decls[nocalls[0]].name EQ 'break' THEN BEGIN
	END ELSE IF data.decls[nocalls[0]].is_system && data.decls[nocalls[0]].name EQ 'goto' THEN BEGIN
	END ELSE IF data.decls[nocalls[0]].is_system && data.decls[nocalls[0]].name EQ 'return' THEN BEGIN
	END ELSE BEGIN
		;lint_add_ccc, data, 'debug2', '', ')', nochar=lint_get_nochar(data)+1
	END

END

;-------------------------------------------------------------------------------
PRO lint_traiter_call_function,	$
;-------------------------------------------------------------------------------
	data,			$	; LINT_PROTOTYPE input
	nocalls				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Traite un appel de FUNCTION "appel()" ou "appel(arguments...)".
;-------------------------------------------------------------------------------

	data.decls[nocalls].nb_use++

	IF lint_get_parenthese_ouvrante (data) THEN BEGIN

		data.pos++

		lint_traiter_para, data, nocalls

		WHILE 1 DO BEGIN	
	
			data_pos = data.pos

			IF lint_get_virgule (data) THEN BEGIN
				data.pos++
				lint_traiter_para, data, nocalls
			END

			IF lint_get_parenthese_fermante (data) THEN BEGIN
				data.pos++
				BREAK
			END

			IF data.pos EQ data_pos THEN BEGIN
				; boucle sans fin
				data.pos++
				IF data.pos GE STRLEN(data.line) THEN BREAK
			END

		END

	END

END

;-------------------------------------------------------------------------------
PRO lint_traiter_subscript,	$
;-------------------------------------------------------------------------------
	data				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Traite les subscripts de tableaux.
;
; On peut trouver:
;	expression
;	expression:expression
;	*
;-------------------------------------------------------------------------------

	lint_traiter_expression, data, 'subscript'

	; pour Berkeley spdsoft
	; ex: "./projects/themis/spacecraft/fields/LASP/thm_lsp_filter_highpass.pro(128)"
	; ex: "out = out[0:*:2]"
	WHILE 1 DO BEGIN

		IF lint_get_2points(data) THEN BEGIN
			data.pos++
			lint_traiter_expression, data, 'subscript'

		; pour Berkeley spdsoft
		; ex: "./projects/themis/spacecraft/fields/LASP/thm_lsp_filter_highpass.pro(128)"
		; ex: "out = out[0:*:2]"
		END ELSE BEGIN
			BREAK

		END

	; pour Berkeley spdsoft
	; ex: ./projects/themis/spacecraft/fields/LASP/thm_lsp_filter_highpass.pro(128)"
	; ex: "out = out[0:*:2]"
	END

END

;-------------------------------------------------------------------------------
PRO lint_traiter_variable,	$
;-------------------------------------------------------------------------------
	data,			$	; LINT_PROTOTYPE input
	name,			$	; LINT_PROTOTYPE input
	is_simple			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Traite uen expression commencant par un nom.
;
; on peut trouver [subscript1,subscript2,...] ou (subscript1,subscript2,...)
; puis .nom ou .(xxx)
;-------------------------------------------------------------------------------

	is_simple = 1

	IF lint_get_crochet_ouvrant(data) THEN BEGIN

		is_simple = 0

		data.pos++

		WHILE 1 DO BEGIN

			lint_traiter_subscript, data
			IF lint_get_crochet_fermant(data) THEN BEGIN
				data.pos++
				BREAK
			END
			IF lint_get_virgule(data) THEN BEGIN
				data.pos++
			END ELSE BEGIN
				; ex: "x = tab[1"
				my_print_msg, data, lint_get_message(data) + 'SYNTAX ERROR "," EXPECTED [' + data.line +']'
				lint_add_msg, data, 'SYNTAX ERROR', '"," EXPECTED'
				BREAK
			END

		END

	END ELSE IF lint_get_parenthese_ouvrante(data) THEN BEGIN

		is_simple = 0

		IF data.decl.check_syntax THEN BEGIN
			my_print_msg, data, lint_get_message(data) + 'ARRAY() "'+name+'" [' + data.line + ']'
		END

		data.pos++

		WHILE 1 DO BEGIN

			lint_traiter_subscript, data

			; pour berkely spdsoft
			;IF lint_get_accolade_ouvrante(data) THEN BEGIN
			;	lint_traiter_expression, data, 'unknow'
			;END

			IF lint_get_parenthese_fermante(data) THEN BEGIN
				data.pos++
				BREAK
			END
			IF lint_get_virgule(data) THEN BEGIN
				data.pos++
			END ELSE BEGIN
				; ex: "x = tab(1"
				my_print_msg, data, lint_get_message(data) + 'SYNTAX ERROR "," EXPECTED [' + data.line + ']'
				lint_add_msg, data, 'SYNTAX ERROR', '"," EXPECTED'
				BREAK
			END

		END

	END

	IF lint_get_point(data) THEN BEGIN

		is_simple = 0

		data.pos++

		IF lint_get_parenthese_ouvrante(data) THEN BEGIN
			data.pos++
			lint_traiter_expression, data, 'field'
			IF lint_get_parenthese_fermante(data) THEN BEGIN
				data.pos++
			END ELSE BEGIN
				my_print_msg, data, lint_get_message(data) + 'SYNTAX ERROR ")" EXPECTED [' + data.line + ']'
				lint_add_msg, data, 'SYNTAX ERROR', '")" EXPECTED'
			END

		END ELSE BEGIN

			code = lint_get_name_idl (data, name)
			lint_add_cla, data, 'STRUCT_FIELD', name, '', ''
			data.pos = code + STRLEN(name)

		END
	END

END

;-------------------------------------------------------------------------------
FUNCTION lint_is_space,	$
;-------------------------------------------------------------------------------
	x			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne 1 si x vaut SPACE.
;-------------------------------------------------------------------------------
	RETURN, x EQ ' '
END

;-------------------------------------------------------------------------------
FUNCTION lint_is_tab,	$
;-------------------------------------------------------------------------------
	x			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne 1 si x vaut TAB.
;-------------------------------------------------------------------------------
	RETURN, x EQ STRING(9b)
END

;-------------------------------------------------------------------------------
PRO lint_check_no_space_tab, 	$
;-------------------------------------------------------------------------------
	data,			$	; LINT_PROTOTYPE input
	name				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Vrifie qu'il n'y a pas de SPACE ou TAB avant et aprs name.
;-------------------------------------------------------------------------------

	IF ~data.decl.check_syntax THEN RETURN

	char_avant = STRMID(data.line, data.pos-1, 1)
	char_apres = STRMID(data.line, data.pos+STRLEN(name), 1)
	ok_avant = ~lint_is_space(char_avant) && ~lint_is_tab(char_avant)
	ok_apres = ~lint_is_space(char_apres) && ~lint_is_tab(char_apres)
	IF ~ok_avant THEN my_print_msg, data, lint_get_message(data) + 'SPACE OR TAB FOUND BEFORE "' + name + '" [' + data.line + ']'
	IF ~ok_apres THEN my_print_msg, data, lint_get_message(data) + 'SPACE OR TAB FOUND AFTER "'  + name + '" [' + data.line + ']'

END

;-------------------------------------------------------------------------------
PRO lint_check_no_space_tab_after,	$
;-------------------------------------------------------------------------------
	data,				$	; LINT_PROTOTYPE input
	name					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Vrifie qu'il n'y a pas de SPACE ou TAB aprs name.
;-------------------------------------------------------------------------------

	IF ~data.decl.check_syntax THEN RETURN

	char_apres = STRMID(data.line, data.pos+STRLEN(name), 1)
	ok_apres = ~lint_is_space(char_apres) && ~lint_is_tab(char_apres)
	IF ~ok_apres THEN my_print_msg, data, lint_get_message(data) + 'SPACE OR TAB FOUND AFTER "'+name+'" [' + data.line + ']'

END

;-------------------------------------------------------------------------------
PRO lint_check_space_tab, 		$
;-------------------------------------------------------------------------------
	data,				$	; LINT_PROTOTYPE input
	name					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Vrifie qu'il y a bien SPACE ou TAB avant et aprs name.
;-------------------------------------------------------------------------------

	IF ~data.decl.check_syntax THEN RETURN

	char_avant = STRMID(data.line, data.pos-1, 1)
	char_apres = STRMID(data.line, data.pos+STRLEN(name), 1)
	ok_avant = lint_is_space(char_avant) || lint_is_tab(char_avant) || char_avant EQ ''
	ok_apres = lint_is_space(char_apres) || lint_is_tab(char_apres) || char_apres EQ ''
	IF ~ok_avant || ~ok_apres THEN my_print_msg, data, lint_get_message(data) + 'NO SPACE OR TAB BEFORE AND AFTER "'+name+'" [' + data.line + ']'

END

;-------------------------------------------------------------------------------
PRO lint_check_space_tab_before,	$
;-------------------------------------------------------------------------------
	data,				$	; LINT_PROTOTYPE input
	name					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Vrifie qu'il y a bien SPACE ou TAB avant name.
;-------------------------------------------------------------------------------

	IF ~data.decl.check_syntax THEN RETURN

	char_avant = STRMID(data.line, data.pos-1, 1)
	ok_avant = lint_is_space(char_avant) || lint_is_tab(char_avant) || char_avant EQ ''
	IF ~ok_avant THEN my_print_msg, data, lint_get_message(data) + 'NO SPACE OR TAB BEFORE "' + name + '" [' + data.line + ']'

END

;-------------------------------------------------------------------------------
PRO lint_check_space_tab_after,	$
;-------------------------------------------------------------------------------
	data,			$	; LINT_PROTOTYPE input
	name,			$	; LINT_PROTOTYPE input
	force=force			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Vrifie qu'il y a bien SPACE ou TAB aprs name.
; /force pour vrifier mme si data.decl.check_syntax vaut 0
;-------------------------------------------------------------------------------

	IF ~KEYWORD_SET(force) THEN IF ~data.decl.check_syntax THEN RETURN

	char_apres = STRMID(data.line, data.pos+STRLEN(name), 1)
	ok_apres = lint_is_space(char_apres) || lint_is_tab(char_apres) || char_apres EQ ''
	IF ~ok_apres THEN my_print_msg, data, lint_get_message(data) + 'NO SPACE OR TAB AFTER "' + name + '" [' + data.line + ']'

END

;-------------------------------------------------------------------------------
PRO lint_dynamic_prototype,	$
;-------------------------------------------------------------------------------
	data,			$	; LINT_PROTOTYPE input
	nopara,			$	; LINT_PROTOTYPE input
	nocall,			$	; LINT_PROTOTYPE input
	what,			$	; LINT_PROTOTYPE input
	val				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Modification dynamique de certaines routines systeme au fur et  mesure que l'on rencontre des arguments ?
; On en profilte aussi pour faire des vrifications (ex: DEFSYSV)
;-------------------------------------------------------------------------------

	; pour se souvenir des paramtres: pile de !MAX_ARGS arguments
	COMMON COMMON_LINT_DYNAMIC_PROTOTYPE, str_params, str_keywords, nb

	; on analyse les paramtres et les les keywords.
	is_keyword = ~is_number(nopara)
	;IF ~is_number(nopara) THEN RETURN
	;print,'"'+what + '" ici1 ' + data.decls[nocall].object + '::' + data.decls[nocall].name

	IF ~data.decls[nocall].is_system THEN RETURN
	;print,'"'+what + '" ici2 ' + data.decls[nocall].object + '::' + data.decls[nocall].name

	IF data.decls[nocall].name EQ 'defsysv' THEN BEGIN

		IF nopara EQ '1' THEN BEGIN
			IF what EQ 'CONSTANT_STRING' THEN BEGIN
				IF STRMID(val, 1, 1) NE '!' THEN BEGIN
					; c'est une erreur
					my_print_msg, data, lint_get_message(data) + 'BAD ARGUMENT Illegal system variable name "'+val+'" ['+data.line+']'
					lint_add_msg, data, 'BAD ARGUMENT', 'Illegal system variable name "'+val+'"'
					RETURN
				END
			END
		END

	END

	IF N_ELEMENTS(str_params) EQ 0 THEN BEGIN
		str_params   = REPLICATE ('', !MAX_ARGS)
		str_keywords = REPLICATE ('', !MAX_ARGS) ; pour mmoriser les keywords
		nb = -1L
	END

	;print,'dynamic "', what,'" ',nb

	IF what EQ 'DEBUT' THEN BEGIN
		nb++
		;for i=0,2*nb do print,' ',format='(A,$)'
		;print,data.decls[nocall].name,' ',nopara,'=',what
		str_params[nb] = ''
		str_keywords[nb] = ''
		nb_params = 0
		; on ne sort pas
		; on va donner le premier prototype possible, au cas ou la FUNC/PRO serait appelle sans arguments
		;RETURN
	END ELSE IF what EQ 'FIN' THEN BEGIN
	END ELSE IF is_keyword THEN BEGIN
		str_keywords[nb] += ' /' + nopara + '=' + what
	END ELSE BEGIN
		;for i=0,2*nb do print,' ',format='(A,$)'
		;print,data.decls[nocall].name,' ',nopara,'=',what

		tmp = STRSPLIT(str_params[nb], /EXTRACT)
		nb_params = tmp[0] EQ '' ? 0 : N_ELEMENTS(tmp)
		IF nb_params EQ nopara THEN BEGIN
			; on a dja donn ce paramtre: ex: "OPENW, j+1, repertoire + '/' + infos[j].nom"
			; on est appell avec nopara=1 et j et nopara=1 et 1
			tmp[nopara-1] = what
			str_params[nb] = STRJOIN(tmp, ' ')
		END ELSE BEGIN
			str_params[nb] += ' ' + what
		END
		;for i=0,2*nb do print,' ',format='(A,$)'
		;print,'str_params['+val_to_str(nb)+'] = ',str_params[nb]
	END

	; La routine est-elle dfini avec d'autres signatures ?
	; ex:"qhull" et "qhull+1", "qhull+2", ... "qhull+7"
	premier_choix = data.decls[nocall].first_plus
	dernier_choix = data.decls[nocall].last_plus

	IF premier_choix NE -1 THEN BEGIN
		params = STRSPLIT (str_params[nb], /EXTRACT)
		nb_params = str_params[nb] EQ '' ? 0L : N_ELEMENTS(params)

		keywords = STRSPLIT (str_keywords[nb], /EXTRACT)
		nb_keywords = str_keywords[nb] EQ '' ? 0L : N_ELEMENTS(keywords)

		;print,'dynamic ', nopara, ' ', what,' ',params

		nooks = REPLICATE(0L, dernier_choix-premier_choix+1)
		nboks = 0L

		; pour chaque prototype possible
;help,nopara,what,premier_choix,dernier_choix 
		FOR i=premier_choix,dernier_choix DO BEGIN

			keywords_type  = STRSPLIT (data.decls[i].keywords_type, /EXTRACT)
			liste_keywords = STRSPLIT (data.decls[i].keywords,      /EXTRACT)

			ok_all = 1

			; pour chaque keywords
			FOR j=0L,nb_keywords-1 DO BEGIN

				; keywords[j] est-il compatible avec keywords_type[no_keyword] ?

				;												'input'			'output'
				;
				; 'CALL'											ok			-
				; 'CONSTANT'											ok			-
				; 'CONSTANT_STRING'										ok			-
				; 'UNDEFINED_SIMPLE_VARIABLE'	ex: "toto" avec toto indfini					-			ok
				; 'DEFINED_SIMPLE_VARIABLE'   	ex: "toto" avec toto dfini					ok			ok
				; 'UNDEFINED_COMPLEX_VARIABLE' 	ex: "toto[1]" "toto.A" avec toto indfini			-			-
				; 'DEFINED_COMPLEX_VARIABLE'	ex: "toto[1]" "toto.A" avec toto dfini				ok			-

				tmp = STRSPLIT(keywords[j], "=", /EXTRACT) ; ex : "/GET_LUN=DEFINED_SIMPLE_VARIABLE"
				keyword_name = STRMID(tmp[0], 1)
				keyword_val  = tmp[1]

				no_keyword = (WHERE (STRUPCASE(STRMID(liste_keywords, 0, STRLEN(keyword_name))) EQ STRUPCASE(keyword_name)))[0]

				IF no_keyword EQ -1 THEN BEGIN
					ok = 0
				END ELSE BEGIN
					CASE keyword_val OF
						'CALL':				ok = (keywords_type[no_keyword] EQ 'input'  OR keywords_type[no_keyword] EQ '[input]')
						'CONSTANT':			ok = (keywords_type[no_keyword] EQ 'input'  OR keywords_type[no_keyword] EQ '[input]')
						'CONSTANT_STRING':		ok = (keywords_type[no_keyword] EQ 'input'  OR keywords_type[no_keyword] EQ '[input]')
						'UNDEFINED_SIMPLE_VARIABLE':	ok =  keywords_type[no_keyword] EQ 'output' OR keywords_type[no_keyword] EQ '[output]'
						'DEFINED_SIMPLE_VARIABLE':	ok = 1
						'UNDEFINED_COMPLEX_VARIABLE':	ok = 1
						'DEFINED_COMPLEX_VARIABLE':	ok = keywords_type[no_keyword] EQ 'input' OR keywords_type[no_keyword] EQ  '[input]'
					END
				END

				IF ~ok THEN BEGIN
					ok_all = 0	
					;PRINT,data.decls[i].name +'('+keyword_val+') => echec au keyword '+keywords[j] + ' ' + data.decls[i].name
					BREAK ; pas la peine de regarder les keywords suivants
				END

			END

			IF ok_all THEN BEGIN

				params_type = STRSPLIT (data.decls[i].params_type, /EXTRACT)
				params_extra = STRSPLIT (data.decls[i].params_extra, /EXTRACT)
				nb_params_type = params_type[0] EQ '' ? 0L : N_ELEMENTS(params_type)

				IF nb_params EQ 0 THEN BEGIN

					IF what EQ 'FIN' THEN ok_all = nb_params_type EQ 0

				END ELSE BEGIN

					ok_all = 1

					; pour chaque parametre
					FOR no_param=0L,nb_params-1 DO BEGIN

						; params[j] est-il compatible avec params_type[i] et params_extra[i] ?

						;												'input'			'output'
						;
						; 'CALL'											ok			-
						; 'CONSTANT'											ok			-
						; 'CONSTANT_STRING'										ok			-
						; 'UNDEFINED_SIMPLE_VARIABLE'	ex: "toto" avec toto indfini					-			ok
						; 'DEFINED_SIMPLE_VARIABLE'   	ex: "toto" avec toto dfini					ok			ok
						; 'UNDEFINED_COMPLEX_VARIABLE' 	ex: "toto[1]" "toto.A" avec toto indfini			-			-
						; 'DEFINED_COMPLEX_VARIABLE'	ex: "toto[1]" "toto.A" avec toto dfini				ok			-

						IF no_param GE nb_params_type THEN BEGIN
							ok = 0
						END ELSE BEGIN
							CASE params[no_param] OF
								'CALL':				ok = (params_type[no_param] EQ 'input'  OR params_type[no_param] EQ  '[input]') ; on fait l'hypothse que la fonction peut renvoyer 'CONSTANT' ou 'CONSTANT_STRING' par exemple
								'CONSTANT':			ok = (params_type[no_param] EQ 'input'  OR params_type[no_param] EQ  '[input]') AND (params_extra[no_param] EQ '*' OR STRPOS(params_extra[no_param], 'CONSTANT') NE -1)
								'CONSTANT_STRING':		ok = (params_type[no_param] EQ 'input'  OR params_type[no_param] EQ  '[input]') AND (params_extra[no_param] EQ '*' OR STRPOS(params_extra[no_param], 'CONSTANT_STRING') NE -1)
								'UNDEFINED_SIMPLE_VARIABLE':	ok =  params_type[no_param] EQ 'output' OR params_type[no_param] EQ '[output]'
								'DEFINED_SIMPLE_VARIABLE':	ok = params_extra[no_param] EQ '*'
								'UNDEFINED_COMPLEX_VARIABLE':	ok = 1
								'DEFINED_COMPLEX_VARIABLE':	ok = (params_type[no_param] EQ 'input' OR params_type[no_param] EQ  '[input]') AND (params_extra[no_param] EQ '*')
							END
						END

						IF ~ok THEN BEGIN
							ok_all = 0	
							;PRINT,data.decls[i].name +'('+str_params[nb]+') => echec au parametre no_param='+val_to_str(no_param) + ' ' + data.decls[i].name
							BREAK ; pas la peine de regarder les paramtres suivants
						END
					
					END

				END

			END

			IF ok_all THEN BEGIN
				;PRINT,data.decls[i].name +'('+str_params[nb]+' '+str_keywords[nb]+') => ok pour ' + data.decls[i].name
				nooks[nboks++] = i
			END
		END

		IF nboks EQ 0 THEN BEGIN

			; il faut prendre si elle existe la possibilit avec un nombre d'arguments compatible: nb_params
			; sinon on aura "TOO MANY ARGUMENTS"
			ind = WHERE (data.decls[premier_choix:dernier_choix].nb_params_min LE nb_params AND data.decls[premier_choix:dernier_choix].nb_params_max GE nb_params)
			IF ind[0] NE -1 THEN BEGIN
				nooks[nboks++] = premier_choix+ind[0]
			END ELSE BEGIN
				; on prend la premire possibilit
				nooks[nboks++] = premier_choix
			END
			;PRINT,data.decls[nocall].name +'('+str_params[nb]+') => echec'

		END ELSE BEGIN

			; il faut prendre si elle existe la possibilit avec un nombre d'arguments compatible: nb_params
			; sinon on aura "TOO MANY ARGUMENTS"
			ind = WHERE (data.decls[nooks[0:nboks-1]].nb_params_min LE nb_params AND data.decls[nooks[0:nboks-1]].nb_params_max GE nb_params)
			IF ind[0] NE -1 THEN BEGIN
				nooks[0] = nooks[ind[0]]
			END

		END

		; il n'est pas indispensable de mettre  jour le prototype
		;data.decls[nocall].prototype     = data.decls[no_ok].prototype
		;data.decls[nocall].nb_prototypes = data.decls[no_ok].nb_prototypes

		; premiere possibilit pour les params et les keywords
		data.decls[nocall].nb_params_min = data.decls[nooks[0]].nb_params_min
		data.decls[nocall].nb_params_max = data.decls[nooks[0]].nb_params_max
		data.decls[nocall].params        = data.decls[nooks[0]].params
		data.decls[nocall].params_type   = data.decls[nooks[0]].params_type
		data.decls[nocall].params_extra  = data.decls[nooks[0]].params_extra

		data.decls[nocall].keywords       = data.decls[nooks[0]].keywords
		data.decls[nocall].keywords_type  = data.decls[nooks[0]].keywords_type
		data.decls[nocall].nb_keywords    = data.decls[nooks[0]].nb_keywords

	END ELSE IF data.decls[nocall].name EQ 'point_lun' THEN BEGIN

		; soit input input  si le premier argument est positif
		; soit input output si le premier argument est ngatif

		IF nopara EQ 1 THEN BEGIN

			; remonter pour voir si on trouve un '-'
			; sortir ds qu'on l'on trouve un ','
			moins_trouve = 0
			FOR pos=data.pos-1,0,-1 DO BEGIN
				c = STRMID(data.line, pos, 1)
				IF c EQ ',' THEN BREAK
				IF c EQ '-' THEN BEGIN
					moins_trouve = 1
					BREAK
				END
			END

			IF moins_trouve THEN BEGIN
				data.decls[nocall].params_type	= 'input output'
				data.decls[nocall].prototype_connu = 1
			END ELSE BEGIN
				data.decls[nocall].params_type	= 'input nput'
				data.decls[nocall].prototype_connu = 1
			END

		END

	END

	IF what EQ 'FIN' THEN BEGIN
		str_params[nb] = ''
		nb--
	END

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_undefined,	$
;-------------------------------------------------------------------------------
	type,			$	; LINT_PROTOTYPE input
	type_short,		$	; LINT_PROTOTYPE input
	has_parenthese,		$	; LINT_PROTOTYPE input
	has_egal,		$	; LINT_PROTOTYPE input
	has_point,		$	; LINT_PROTOTYPE input
	has_crochet,		$	; LINT_PROTOTYPE input
	has_2points,		$	; LINT_PROTOTYPE input
	has_fleche			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne une chaine undiquant ce qui est inconnu: 'UNDEFINED METHOD', 'UNDEFINED FUNCTION OR VARIABLE', 'UNDEFINED VARIABLE' ou 'UNDEFINED PRO'
;-------------------------------------------------------------------------------

	IF type_short EQ 'appel_methode' THEN BEGIN
		RETURN, 'UNDEFINED METHOD'
	END ELSE IF type_short EQ 'para' THEN BEGIN
		IF has_parenthese THEN BEGIN
			RETURN, 'UNDEFINED FUNCTION OR VARIABLE'
		END ELSE BEGIN
			RETURN, 'UNDEFINED VARIABLE'
		END
	END ELSE IF has_egal THEN BEGIN
		RETURN, 'UNDEFINED VARIABLE'
	END ELSE IF type EQ 'debut' THEN BEGIN
		IF has_parenthese THEN BEGIN
			RETURN, 'UNDEFINED FUNCTION OR VARIABLE'
		END ELSE IF has_point || has_crochet || has_2points || has_fleche THEN BEGIN
			RETURN, 'UNDEFINED VARIABLE'
		END ELSE BEGIN
			RETURN, 'UNDEFINED PRO'
		END
	END ELSE BEGIN
		IF has_parenthese THEN BEGIN
			RETURN, 'UNDEFINED FUNCTION OR VARIABLE'
			; ex: fr = pmod(r,1)
		END ELSE BEGIN
			RETURN, 'UNDEFINED VARIABLE'
		END
	END

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_inherits_recursif,	$
;-------------------------------------------------------------------------------
	decls,			$	; LINT_PROTOTYPE input
	hash,			$	; LINT_PROTOTYPE input
	vus,			$	; LINT_PROTOTYPE input
	inherits,		$	; LINT_PROTOTYPE input
	is_c				; LINT_PROTOTYPE input	
;-------------------------------------------------------------------------------
; Retourne toutes les classes dont hrite la classe inherits, ou '' s'il n'y en a pas.
;-------------------------------------------------------------------------------

	; Il n'y a qu'un lment dans inherits

	IF is_c THEN BEGIN
		ind = lint_get_decls_by_module (decls, hash, inherits)
	END ELSE BEGIN
		ind = lint_get_decls_by_object (decls, hash, STRLOWCASE(inherits))
	END

	; aucune routine trouv
	IF ind[0] EQ -1 THEN RETURN, ''

	; plusieurs routines: il peut s'agir de toutes les routines de l'objet inherits
	; mais pas forcment: arrive si on redfini une classe SYSTEME par exemple

	; modules avec des noms uniques
	unique = UNIQ (decls[ind].module, SORT(decls[ind].module))

	tabvus = STRSPLIT (vus, /EXTRACT)

	res = ''
	FOR j=0L,N_ELEMENTS(unique)-1 DO BEGIN

		IF decls[ind[unique[j]]].inherits_full NE '' THEN BEGIN
			tabinherits_full = STRSPLIT (decls[ind[unique[j]]].inherits_full, /EXTRACT)
			FOR k=0L,N_ELEMENTS(tabinherits_full)-1 DO BEGIN
				ind1 = WHERE (tabvus EQ tabinherits_full[k])
				IF ind1[0] EQ -1 THEN BEGIN
					res += ' ' + tabinherits_full[k]
				END
			END
		END ELSE BEGIN

			; le module
			ind1 = WHERE (tabvus EQ decls[ind[unique[j]]].module)
			IF ind1[0] EQ -1 THEN BEGIN
				res += ' ' + decls[ind[unique[j]]].module
			END


			; sa descendance
			IF decls[ind[unique[j]]].inherits NE '' THEN BEGIN
				tabinherits = STRSPLIT (decls[ind[unique[j]]].inherits, /EXTRACT)
				FOR k=0L,N_ELEMENTS(tabinherits)-1 DO BEGIN
					ind1 = WHERE (tabvus EQ tabinherits[k])
					IF ind1[0] EQ -1 THEN BEGIN
						res += ' ' + lint_get_inherits_recursif (decls, hash, vus + ' ' + inherits, tabinherits[k], is_c)
					END
				END
			END

			
		END

	END

	RETURN, res

END

;-------------------------------------------------------------------------------
PRO lint_traiter_name,	$
;-------------------------------------------------------------------------------
	data,		$	; LINT_PROTOTYPE input
	name,		$	; LINT_PROTOTYPE input
	type			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Il faut analyser name qui se trouve  la position data.pos de data.line.
;
; type donne le contexte dans lequel on se trouve:			STRING			CTE		variable_inconnue	variable_connue
;
;	- 'subscript'							ERREUR			OK		ERREUR			OK
;	- 'nom_structure'						ERREUR			ERREUR		OK			OK
;	- 'nom_champ_structure'			"nom_de_champ"
;	- 'valeur_champ_structure'					OK			OK		ERREUR			OK
;	- 'nom_inherits_structure'		"nom_de_module"
;	- 'appel_methode instance'		"function_pro"
;	- 'unknow'
;
;	- 'para no_para no_function_pro'
;			input						OK			OK		ERREUR			OK
;			sinon						ERREUR			ERREUR		OK			OK
;		
;	- 'para keyword no_function_pro'
;			input						OK			OK		ERREUR			OK
;			sinon						ERREUR			ERREUR		OK			OK
;-------------------------------------------------------------------------------

	COMMON COMMON_ETAT, instance_egal
	COMMON COMMON_LINT, common_lint_infos

	target = common_lint_infos.target

	IF !DEBUG THEN my_print, '  lint_traiter_name name=[' + name + ']' + ' type=[' + type + '] line=[' + STRMID(data.line, data.pos) + ']'

	IF type EQ 'appel_include' THEN BEGIN

		no_include = WHERE (data.decls.function_pro EQ 'INCLUDE' AND STRUPCASE(data.decls.name) EQ STRUPCASE(basename(name)))
		IF no_include[0] EQ -1 THEN BEGIN
			no_include = WHERE (data.decls.function_pro EQ 'INCLUDE' AND STRUPCASE(data.decls.name) EQ STRUPCASE(basename(name)+'.pro'))
		END
		IF no_include[0] EQ -1 THEN BEGIN
			my_print_msg, data, lint_get_message(data) + 'UNDEFINED INCLUDE "'+name+'" ['+data.line+']'
			lint_add_msg, data, 'UNDEFINED INCLUDE', '"'+name+'"'
			data.pos += STRLEN(name)
			RETURN
		END
		FOR j=0L,N_ELEMENTS(no_include)-1 DO BEGIN
			data.decls[data.nor].call += LINTC_INT_TO_STR(no_include[j]) + ' '
			data.decls[no_include[j]].calledby += LINTC_INT_TO_STR(data.nor) + ' '
		END
		FOR j=0L,N_ELEMENTS(no_include)-1 DO BEGIN
			; ou d'appel vers un INCLUDE dfini plusieurs fois -> afficher le nom du module

			IF N_ELEMENTS(no_include) EQ 1 THEN BEGIN
				tmp = ''
			END ELSE BEGIN
				tmp = '@'+ data.decls[no_include[j]].module
			END
			link = data.decls[no_include[j]].module+'/INCLUDE_'+data.decls[no_include[j]].name+'.html'

			IF j EQ 0 THEN BEGIN
				lint_add_cla, data, 'CALL_INCLUDE', name, tmp, link
			END ELSE BEGIN
				lint_add_cla, data, 'CALL_INCLUDE', '',   tmp, link
			END
		END
		data.pos += STRLEN(name)

		; il faut regarder ce qui se trouve dans le code data.decls[no_include[j]].module
		; Lecture de lignes, en supprimant les commentaires
		rajouter_lignes, data.decls[no_include[0]].module, lignes, nblignes
		IF nblignes GE 1 THEN BEGIN
			; ne pas coloriser sinon LINTC_CODE_TO_HTML ne va plus rien comprendre
			; ne pas non plus ecrire dans message

			old_data_cla_on = data.cla_on
			old_data_msg_on = data.msg_on
			old_data_nor    = data.nor
			old_data_line   = data.line
			old_data_pos    = data.pos
			old_data_noline = *data.noline
			old_data_nochar = *data.nochar
			
			data.cla_on = 0
			data.msg_on = 0
			data.nor = no_include[0]

			lint_plus, lignes[0 : nblignes-1], data

			PTR_FREE, data.noline & data.noline = PTR_NEW (old_data_noline, /NO_COPY)
			PTR_FREE, data.nochar & data.nochar = PTR_NEW (old_data_nochar, /NO_COPY)
			data.pos    = old_data_pos
			data.line   = old_data_line
			data.nor    = old_data_nor
			data.cla_on = old_data_cla_on
			data.msg_on = old_data_msg_on
		END
		RETURN

	END


	IF type EQ 'nom_champ_structure' || type EQ 'nom_structure' || type EQ 'nom_inherits_structure' THEN BEGIN
		IF type EQ 'nom_champ_structure' THEN BEGIN
			lint_add_cla, data, 'STRUCT_FIELD', name, '', ''
		END
		data.pos += STRLEN(name)
		RETURN
	END

	IF type EQ 'directive' THEN BEGIN
		IF STRCMP(name, 'COMPILE',		/FOLD_CASE) || $
		   STRCMP(name, 'CONTINUE',		/FOLD_CASE) || $
		   STRCMP(name, 'EDIT',			/FOLD_CASE) || $
		   STRCMP(name, 'FULL_RESET_SESSION',	/FOLD_CASE) || $
		   STRCMP(name, 'GO',			/FOLD_CASE) || $
		   STRCMP(name, 'OUT',			/FOLD_CASE) || $
		   STRCMP(name, 'RESET_SESSION',	/FOLD_CASE) || $
		   STRCMP(name, 'RETURN',		/FOLD_CASE) || $
		   STRCMP(name, 'RNEW',			/FOLD_CASE) || $
		   STRCMP(name, 'RUN',			/FOLD_CASE) || $
		   STRCMP(name, 'SKIP',			/FOLD_CASE) || $
		   STRCMP(name, 'STEP',			/FOLD_CASE) || $
		   STRCMP(name, 'STEPOVER',		/FOLD_CASE) || $
		   STRCMP(name, 'TRACE',		/FOLD_CASE) THEN BEGIN
			lint_add_cla, data, 'KEYWORD', name, '', ''
		END
		data.pos = STRLEN(data.line)
		RETURN
	END


	IF STRCMP(name, 'FUNCTION', /FOLD_CASE) || STRCMP(name, 'PRO', /FOLD_CASE) THEN BEGIN
		IF !DEBUG THEN my_print, '  declaration de FUNCTION ou PRO [' + STRMID(data.line, data.pos) + ']'
		mots = STRSPLIT(STRMID(data.line, data.pos), ',', /EXTRACT)
		IF N_ELEMENTS(mots) GE 2 THEN BEGIN
			; Cration variables 'param' et 'keyword'
			tmp = mots[1:*]
			vars = *data.vars
			FOR i=0L,N_ELEMENTS(tmp)-1 DO BEGIN
				tmp1 = STRSPLIT(tmp[i], '=', /EXTRACT)
				IF N_ELEMENTS(tmp1) EQ 2 THEN BEGIN
					tmp[i] = tmp1[1]
					categorie = 'keyword'
				END ELSE BEGIN
					categorie = 'param'
				END
				var = { name: STRCOMPRESS(tmp[i], /REMOVE_ALL), categorie: categorie, contexte: '', nb_use: 0L }
				vars = [ vars , var ]
			END
			PTR_FREE, data.vars
			data.vars = PTR_NEW (vars, /NO_COPY)
		END
		data.pos = STRLEN(data.line)
		RETURN
	END

	IF STRCMP(name, 'COMMON', /FOLD_CASE) THEN BEGIN
		lint_add_cla, data, 'KEYWORD', name, '', ''
		IF !DEBUG THEN my_print, '  declaration de COMMON [' + STRMID(data.line, data.pos) + ']'

		mots = STRSPLIT(STRMID(data.line, data.pos), ',', /EXTRACT)
		tmp = STRSPLIT(mots[0], /EXTRACT)
		nom_common = tmp[1]

		; ne pas rajouter cette dfinition mais celle de data.decls[data.nor].commons qui a peut-tre t "corrige" si elle tait vide
		
		tmp1 = STRSPLIT (data.decls[data.nor].commons, !SEP1, /EXTRACT)
		nb1 = N_ELEMENTS(tmp1)
		; Cration variables commons
		FOR i=0L,nb1-1 DO BEGIN
			tmp2 = STRSPLIT (tmp1[i], !SEP2, /EXTRACT) ; [nom_common][no_ligne][variables]
			IF tmp2[0] EQ nom_common THEN BEGIN
				liste = STRSPLIT (tmp2[2], /EXTRACT)
				vars = *data.vars
				FOR i=0L,N_ELEMENTS(liste)-1 DO BEGIN
					var = { name: liste[i], categorie: 'common', contexte: STRUPCASE(nom_common), nb_use: 0L }
					vars = [ vars , var ]
				END
				PTR_FREE, data.vars
				data.vars = PTR_NEW (vars, /NO_COPY)
				BREAK
			END
			
		END
		data.pos = STRLEN(data.line)
		RETURN
	END

	IF STRUPCASE(name) EQ 'COMPILE_OPT' THEN BEGIN
		lint_add_cla, data, 'KEYWORD', name, '', ''
		data.pos = STRLEN(data.line)
		RETURN
	END

	IF STRUPCASE(name) EQ 'FORWARD_FUNCTION' THEN BEGIN
		lint_add_cla, data, 'KEYWORD', name, '', ''
		data.pos = STRLEN(data.line)
		RETURN
	END

	; rapide car il n'y a pas beaucoup de variables
	; on cherche dans toutes les variables sauf 'local_en_cours' et 'para_en_cours', cad dans 'system', 'param', 'keyword', 'para' et 'local'
	no_variable = (WHERE(STRUPCASE((*data.vars).name) EQ STRUPCASE(name) AND (*data.vars).categorie NE 'local_en_cours' AND (*data.vars).categorie NE 'para_en_cours'))[0]


	data_pos_old = data.pos
	data_pos_msg = data.pos ; pour les messages d'erreur
	data.pos += STRLEN(name)

	data.pos = LINTC_SAUTER_ESPACES_TABULATIONS (data.line, data.pos)
	char1 = STRMID(data.line, data.pos, 1)
	char2 = STRMID(data.line, data.pos+1, 1)
	has_point	= lint_is_point(char1) AND (char2 LT '0' || char2 GE '9')
	has_crochet	= lint_is_crochet_ouvrant(char1)
	has_parenthese	= lint_is_parenthese_ouvrante(char1)
	has_egal	= lint_is_egal(char1)
	has_2points	= char1 EQ ':'
	is_pointer = STRMID(data.line, data_pos_old-1, 1) EQ '*'

	char2 = STRMID(data.line, data.pos, 2)
	has_fleche	= lint_is_fleche(char2)

	IF has_egal THEN instance_egal = 1

	data.pos = data_pos_old

	is_label = 0
	IF has_2points && data.statement EQ '' THEN BEGIN
		IF STRCOMPRESS(STRMID(data.line, 0, data.pos), /REMOVE_ALL) EQ '' THEN BEGIN
			IF get_last_pile(data) EQ 'CASE_OF' THEN BEGIN
			END ELSE BEGIN
				is_label = 1
			END
		END
	END

	IF has_2points && get_last_pile(data) EQ 'CASE_OF' THEN BEGIN
		;lint_add_ccc, data, 'KEYWORD_C', name, 'break; case '+name
	END


	;-------------------------------------------------------------------------------
	;
	; Si la FUNCTION y() existe et est dja compile (quelque soit le nombre d'arguments):
	;	- si la variable y existe:
	;		y(0)=1 donne une erreur		=> priorit  la FUNCTION
	;		y[0]=1 fonctione		=> variable car pas d'ambiguit
	;		y=1 foncionne			=> variable car pas d'ambiguit
	;
	; si la PRO x existe:
	;	- si la variable x existe:
	;		x=1 fonctione			=> variable car pas d'ambiguit
	;	- si la variable x n'existe pas:
	;		x=1 plante			=> variable car pas d'ambiguit
	;
	; donc:
	;	- name		= 1 	=> variable dans tous les cas
	;	- name[...]	= 1	=> variable dans tous les cas
	;	- name(...)	= 1 	=> priorit  la FUNCTION si ce n'est pas une fonction SYSTEME ".pro"
	;
	;-------------------------------------------------------------------------------

	;-------------------------------------------------------------------------------
	;														
	; type_short EQ 'appel_methode':
	;	- dans tous les cas		=> 						'FUNCTION/PRO'
	;
	; type_short EQ 'para' OR type_short EQ 'subscript':
	; 	- has_fleche			=> 						'VARIABLE'
	; 	- has_crochet			=>						'VARIABLE'
	;	- has_point			=> 						'VARIABLE'
	;	- has_parenthese		=> 						'FUNCTION/VARIABLE'
	;	- sinon				=> 						'VARIABLE'
	;
	; autre type_short:
	; 	- has_fleche			=> 						'VARIABLE'
	; 	- has_crochet			=> 						'VARIABLE'
	; 	- has_point			=> 						'VARIABLE'
	; 	- has_parenthese		=> 						'FUNCTION/VARIABLE'
	;	- has_egal			=> 						'VARIABLE'
	; 	- sinon				=> 
	;						statement = '='		=> 		'VARIABLE'
	;						statement = 'IF'	=> 		'VARIABLE'
	;						statement = 'UNTIL'	=> 		'VARIABLE'
	;						statement = 'FOR'	=> 		'VARIABLE'
	;						statement = 'WHILE'	=> 		'VARIABLE'
	;						statement = 'SWITCH'	=> 		'VARIABLE'
	;						statement = 'CASE'	=> 		'VARIABLE'
	;						sinon			=>		'PRO/VARIABLE'
	;
	;-------------------------------------------------------------------------------

	type_short = type
	tmp = STRSPLIT(type, /EXTRACT)
	instance = '' ; pour qu'il soit toujours dfini
	IF tmp[0] EQ 'appel_methode' THEN BEGIN
		type_short = tmp[0]
		instance = N_ELEMENTS(tmp) GE 2 ? tmp[1] : ''
	END ELSE IF tmp[0] EQ 'para' THEN BEGIN
		type_short = tmp[0]
		nopara = tmp[1]
		nocalls = tmp[2:*]
	END

	IF is_label THEN BEGIN

		priorite = ''

	END ELSE IF type_short EQ 'appel_methode' THEN BEGIN

		priorite = 'FUNCTION/PRO'

	END ELSE IF type_short EQ 'para' || type_short EQ 'subscript' THEN BEGIN

		IF has_fleche THEN BEGIN
			priorite = 'VARIABLE'
		END ELSE IF has_crochet THEN BEGIN
			priorite = 'VARIABLE'
		END ELSE IF has_point THEN BEGIN
			priorite = 'VARIABLE'
		END ELSE IF has_parenthese THEN BEGIN
			priorite = 'FUNCTION/VARIABLE'
		END ELSE BEGIN
			priorite = 'VARIABLE'
		END

	END ELSE BEGIN

		IF has_fleche THEN BEGIN
			priorite = 'VARIABLE'
		END ELSE IF has_crochet THEN BEGIN
			priorite = 'VARIABLE'
		END ELSE IF has_point THEN BEGIN
			priorite = 'VARIABLE'
		END ELSE IF has_parenthese THEN BEGIN
			priorite = 'FUNCTION/VARIABLE'
		END ELSE IF has_egal THEN BEGIN
			priorite = 'VARIABLE'
		END ELSE BEGIN
			SWITCH data.statement OF
				'FOR=':
				'=':
				'IF':
				'UNTIL':
				'FOR':
				'WHILE':
				'SWITCH':
				'CASE':		BEGIN
							priorite = 'VARIABLE'
							BREAK
						END
				ELSE:		BEGIN
							IF type EQ 'valeur_champ_structure' THEN BEGIN
								; pas d'appel de PRO dans la valeur du champ d'une structure
								priorite = 'VARIABLE'
							END ELSE BEGIN
								priorite = 'PRO/VARIABLE'
							END
						END
			END
		END
	END


	no_function_pro = -1 ; pour que la variable existe dans tous les cas
	IF STRPOS(priorite, 'FUNCTION') NE -1 || STRPOS(priorite, 'PRO') NE -1 THEN BEGIN	

		IF type_short EQ 'appel_methode' THEN BEGIN

			; Quel objet ?				instance	name			classe	methode		object
			;
			; self -> methode			self		methode			''	methode		self ou inherits
			; self -> classe::methode		self		classe::methode		classe	methode		pro/classe__define.pro
			; xxxx -> methode			xxxx		methode			''	methode		l'objet qui dfini methode (PB s'il y en a plusieurs)
			; xxxx -> classe::methode		xxxx		classe::methode		classe	methode		pro/classe__define.pro
			;

			IF STRMID(name, STRLEN(name)-2, 2) EQ '::' THEN BEGIN
				; verrue: "oContainer = self->IDLitContainer::             GetbyIdentifier("Current Style/" + folder)"
				; il y a des blancs en trop
				classe = STRMID(name, 0, STRLEN(name)-2)
				len = 0L
				pos = LINTC_GET_NAME_IDL (data.line, data.pos+STRLEN(name), len)
				name = STRMID(data.line, data.pos, pos-data.pos+len)
			END
			tmp = STRSPLIT (name, '::', /EXTRACT)
			IF N_ELEMENTS(tmp) EQ 2 THEN BEGIN
				classe = tmp[0]
				methode = STRTRIM(tmp[1], 2) ; TRIM  cause de la verrue du dessus
			END ELSE BEGIN
				classe = ''
				methode = name
			END

			; data.decls.name est en minuscle

			IF data.statement EQ '=' THEN BEGIN
				priorite = 'FUNCTION/VARIABLE'
			END ELSE IF data.statement EQ 'para' THEN BEGIN
				priorite = 'FUNCTION/VARIABLE'
			END ELSE IF has_parenthese THEN BEGIN
				priorite = 'FUNCTION/VARIABLE'
			END ELSE BEGIN
				priorite = 'PRO/VARIABLE'
			END

			IF classe NE '' THEN BEGIN

				; ex: "newobj -> obj::setproperty, 'noproduit', -1"
				; classe=obj methode=setproperty

				ind1 = lint_get_decls_by_name_passe2 (data, STRLOWCASE(methode))
				IF ind1[0] NE -1 THEN BEGIN

					inherits_full = STRSPLIT (data.decl.inherits_full, /EXTRACT)

					IF N_ELEMENTS(inherits_full) NE 1 && target NE 'cl' THEN BEGIN

						; La mthode peut se trouver dans l'objet lui mme mais aussi dans un des objets hrits.
						; Tous ces objets sont dcrits dans data.decl.inherits_full

						FOR i=0L,N_ELEMENTS(inherits_full)-1 DO BEGIN
							ind2 = WHERE (STRLOWCASE(data.decls[ind1].object) EQ STRLOWCASE(inherits_full[i]))
							IF ind2[0] NE -1 THEN BEGIN
								no_function_pro = no_function_pro[0] EQ -1 ? ind1[ind2] : [no_function_pro , ind1[ind2]]
							END
						END

					END ELSE BEGIN

						ind2 = WHERE (STRLOWCASE(data.decls[ind1].object) EQ STRLOWCASE(classe))
						IF ind2[0] NE -1 THEN no_function_pro = ind1[ind2]

						IF no_function_pro[0] EQ -1 && target EQ 'cl' THEN BEGIN
							FOR i=0L,N_ELEMENTS(inherits_full)-1 DO BEGIN
								ind2 = WHERE (STRLOWCASE(data.decls[ind1].object) EQ STRLOWCASE(inherits_full[i]))
								IF ind2[0] NE -1 THEN BEGIN
									no_function_pro = ind1[ind2]
									BREAK
								END
							END
						END

					END
				END

			END ELSE IF instance EQ 'self' THEN BEGIN


				; la mthode existe t-elle  ?
				ind1 = lint_get_decls_by_name_passe2 (data, STRLOWCASE(methode))
				IF ind1[0] NE -1 THEN BEGIN

					inherits_full = STRSPLIT (data.decl.inherits_full, /EXTRACT)

					IF N_ELEMENTS(inherits_full) NE 1 && target NE 'cl' THEN BEGIN

						; La mthode peut se trouver dans l'objet lui mme mais aussi dans un des objets hrits.
						; Tous ces objets sont dcrits dans data.decl.inherits_full

						FOR i=0L,N_ELEMENTS(inherits_full)-1 DO BEGIN
							ind2 = WHERE (data.decls[ind1].object EQ STRLOWCASE(inherits_full[i]))
							IF ind2[0] NE -1 THEN BEGIN
								no_function_pro = no_function_pro[0] EQ -1 ? ind1[ind2] : [no_function_pro , ind1[ind2]]
							END
						END

					END ELSE BEGIN

						ind2 = WHERE (data.decls[ind1].object EQ STRLOWCASE(data.decl.object))
						IF ind2[0] NE -1 THEN no_function_pro = ind1[ind2]

						IF no_function_pro[0] EQ -1 THEN BEGIN
							; Est-on dans une FUNC/PRO non object alors que son module dfini "object::init" ?
							; ex: routines utilises dans EVENT_FUNC, EVENT_PRO et  PRO_SET_VALUE de WIDGET_BASE
							IF data.decls[data.nor].object EQ '' THEN BEGIN
								module = data.decls[data.nor].module
								ind2 = WHERE (data.decls.module EQ module AND data.decls.name EQ 'init')
								IF ind2[0] NE -1 THEN BEGIN
									; oui: on peut accepter la methode trouve si elle est dans module
									ind2 = WHERE (data.decls[ind1].module EQ module)
									IF ind2[0] NE -1 THEN no_function_pro = ind1[ind2]
								END
							END
						END

						IF no_function_pro[0] EQ -1 && target EQ 'cl' THEN BEGIN
							FOR i=0L,N_ELEMENTS(inherits_full)-1 DO BEGIN
								ind2 = WHERE (data.decls[ind1].object EQ STRLOWCASE(inherits_full[i]))
								IF ind2[0] NE -1 THEN BEGIN
									no_function_pro = ind1[ind2]
									BREAK
								END
							END
						END
	
					END

				END

			END ELSE BEGIN

				ind1 = lint_get_decls_by_name_passe2 (data, STRLOWCASE(methode))
				IF ind1[0] NE -1 THEN BEGIN
					ind2 = WHERE (data.decls[ind1].object NE '')
					IF ind2[0] NE -1 THEN no_function_pro = ind1[ind2]
				END
			END


		END ELSE BEGIN

			ind1 = lint_get_decls_by_name_passe2 (data, STRLOWCASE(name))
			IF ind1[0] NE -1 THEN BEGIN
				ind2 = WHERE (data.decls[ind1].object EQ '')
				IF ind2[0] NE -1 THEN no_function_pro = ind1[ind2]
			END

		END

	END


	; Si une variable et une function_pro existent avec le nom name, que faire ?
	; Si "FUNCTION/VARIABLE": garder function_pro si c'est une FUNCTION, sauf si c'est une fonction SYSTEME ".pro" et que la variable existe
	; Si "PRO/VARIABLE":      garder function_pro si c'est une PRO

	use_function_pro = 0
	IF priorite EQ 'FUNCTION/PRO' THEN use_function_pro = 1
	IF priorite EQ 'FUNCTION/VARIABLE' && no_function_pro[0] NE -1 THEN BEGIN
		tmp = WHERE (data.decls[no_function_pro].function_pro EQ 'FUNCTION')
		use_function_pro = tmp[0] NE -1
		IF use_function_pro THEN BEGIN
			; Sauf si c'est une fonction SYSTEME ".pro" (et qu'il n'y en a qu'une) et que la variable existe
			IF no_variable[0] NE -1 && N_ELEMENTS(no_function_pro) EQ 1 && chaine_contient_debut(data.decls[no_function_pro].module, 'SYSTEM') && chaine_contient_fin(data.decls[no_function_pro].module, '.pro') THEN BEGIN
				; c'est une fonction SYSTEM en ".pro"
				use_function_pro = 0
			END ELSE BEGIN
				no_function_pro = no_function_pro[tmp]
			END
		END
	END ELSE IF priorite EQ 'PRO/VARIABLE' && no_function_pro[0] NE -1 THEN BEGIN
		tmp = WHERE (data.decls[no_function_pro].function_pro EQ 'PRO')
		use_function_pro = tmp[0] NE -1
		IF use_function_pro THEN no_function_pro = no_function_pro[tmp]
	END

	IF use_function_pro THEN BEGIN

		IF no_function_pro[0] EQ -1 THEN BEGIN
			my_print_msg, data, lint_get_message(data) + 'UNDEFINED FUNCTION_PRO "'+name+'" [ ' +data.line + ']'
			lint_add_msg, data, 'UNDEFINED FUNCTION_PRO', '"'+name+'"'
		END

		IF priorite EQ 'FUNCTION/VARIABLE' && no_variable[0] NE -1 THEN BEGIN
			;my_print, lint_get_message(data) + 'USE FUNCTION (NOT VARIABLE) "'+name+'" [ ' +data.line + ']'
		END

		IF priorite EQ 'PRO/VARIABLE' && no_variable[0] NE -1 THEN BEGIN
			;my_print, lint_get_message(data) + 'USE PRO (NOT VARIABLE) "'+name+'" [ ' +data.line + ']'
		END

		; appel de function ou pro que l'on connait
		; PRO: 		il faut trouver rien ou ",argument1,argument2,..."
		; FUNCTION:	il faut trouver () ou (argument1,argument2,...)"
		IF N_ELEMENTS(no_function_pro) GE 2 THEN BEGIN

			; les functions utilisateurs crasent les fonctions systemes ?
			; on ne garde que les fonctions utilisateurs
			; Mais pas pour les methodes!

			IF data.decls[no_function_pro[0]].object EQ '' THEN BEGIN
				IF !DEBUG THEN my_print, data.decls[no_function_pro].module
				ind = WHERE (data.decls[no_function_pro].is_system EQ 0)
				IF ind[0] NE -1 THEN no_function_pro = no_function_pro[ind]
				IF !DEBUG THEN my_print, data.decls[no_function_pro].module

			END

			;my_print, lint_get_message(data) + 'CHECK METHOD "'+name+'" [' + data.line + ']'
			;FOR i=0,N_ELEMENTS(no_function_pro)-1 DO BEGIN
			;	tmp = data.decls[no_function_pro[i]]
			;	my_print, '  | LINT_PLUS #'+(i+1 LT 10?'0':'')+LINTC_INT_TO_STR(i+1)+' in '+tmp.module+' nb_params=['+LINTC_INT_TO_STR(tmp.nb_params)+'] keywords=['+tmp.keywords+']'
			;END
		END

		IF no_function_pro[0] NE -1 THEN BEGIN

			IF data.decl.check_case_sensitive THEN BEGIN
				ind = WHERE (STRUPCASE((*data.vars).name) EQ STRUPCASE(instance))
				IF ind[0] NE -1 THEN BEGIN
					(*data.vars)[ind].nb_use++
					FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
						IF (*data.vars)[ind[i]].name NE instance THEN BEGIN
							my_print_msg, data, lint_get_message(data) + 'CASE SENSITIVE INSTANCE "' + instance +'" ['+data.line+']'
							lint_add_msg, data, 'CASE SENSITIVE INSTANCE', instance+'"&nbsp;"'+(*data.vars)[ind[i]].name+'"'
						END
					END
				END
			END

			is_function	= data.decls[no_function_pro[0]].function_pro EQ 'FUNCTION'
			is_pro		= data.decls[no_function_pro[0]].function_pro EQ 'PRO'

			IF data.decls[no_function_pro[0]].is_system THEN BEGIN
				IF STRUPCASE(name) EQ 'STOP' && data.decls[no_function_pro[0]].object EQ '' THEN BEGIN
					IF data.decl.check_stop_debug THEN BEGIN
						my_print_msg, data, lint_get_message(data) + 'INSTRUCTION "' + name +'" FOUND ['+data.line+']'
						lint_add_msg, data, 'INSTRUCTION STOP FOUND', '"'+name+'"'
					END
				END ELSE IF STRUPCASE(name) EQ 'EXECUTE' && data.decls[no_function_pro[0]].object EQ '' THEN BEGIN
					my_print_msg, data, lint_get_message(data) + 'INSTRUCTION "' + name +'" FOUND ['+data.line+']'
					noline = lint_get_noline(data)
					FOR j=noline,data.decls[data.nor].noligne1+data.decls[data.nor].nblignes-2 DO BEGIN ; pas la dernire ligne avec END
						lint_add_msg, data, noligne=j, 'INSTRUCTION EXECUTE FOUND', '"'+name+'"'
					END
					data.msg_on = 0 ; ne plus afficher aucun message d'erreur
				END ELSE IF STRUPCASE(name) EQ 'RESTORE' && data.decls[no_function_pro[0]].object EQ '' THEN BEGIN
					my_print_msg, data, lint_get_message(data) + 'INSTRUCTION "' + name +'" FOUND ['+data.line+']'
					noline = lint_get_noline(data)
					FOR j=noline,data.decls[data.nor].noligne1+data.decls[data.nor].nblignes-2 DO BEGIN ; pas la dernire ligne avec END
						lint_add_msg, data, noligne=j, 'INSTRUCTION RESTORE FOUND', '"'+name+'"'
					END
					data.msg_on = 0 ; ne plus afficher aucun message d'erreur
				END ELSE IF STRUPCASE(name) EQ 'CATCH' THEN BEGIN
					;my_print_msg, data, lint_get_message(data) + 'INSTRUCTION "' + name +'" FOUND ['+data.line+']'
					;lint_add_msg, data, 'INSTRUCTION CATCH FOUND', '"'+name+'"'
				END
			END

			IF target EQ 'cl' AND N_ELEMENTS(no_function_pro) NE 1 THEN BEGIN
				; s'il y a des appels USER, ne garder que ceux la sinon erreur dans "obj -> setproperty, name, val, passaveold=passaveold"
				;                           car les setproperty en SYSTEM n'ont pas les mmes signatures
				; sinon les garder tous
				ind = WHERE (data.decls[no_function_pro].is_system NE 1)
				IF ind[0] NE -1 THEN no_function_pro = no_function_pro[ind]
			END

			IF data.decl.check_syntax THEN BEGIN
				IF data.decls[no_function_pro[0]].is_system THEN BEGIN
					IF STRUPCASE(name) NE name THEN BEGIN
						my_print_msg, data, lint_get_message(data) + 'SYSTEM ROUTINE NOT IN UPPERCASE "' + name +'" ['+data.line+']'
					END
				END ELSE BEGIN
					IF STRLOWCASE(name) NE name THEN BEGIN
						my_print_msg, data, lint_get_message(data) + 'USER ROUTINE NOT IN LOWERCASE "' + name +'" ['+data.line+']'
					END
				END
			END


			FOR j=0L,N_ELEMENTS(no_function_pro)-1 DO BEGIN

				data.decls[data.nor].call += LINTC_INT_TO_STR(no_function_pro[j]) + ' '
				data.decls[no_function_pro[j]].calledby += LINTC_INT_TO_STR(data.nor) + ' '

			END

			FOR j=0L,N_ELEMENTS(no_function_pro)-1 DO BEGIN
				; cas d'appel vers une methode definie dans plusieurs objets -> afficher l'objet
				; ou d'appel vers une FUNC/PRO dfini plusieurs fois -> afficher le nom du module

				CALL_XXX = data.decls[no_function_pro[j]].is_system ? 'CALL_SYSTEM' : 'CALL_USER'
				FUNCTION_PRO = data.decls[no_function_pro[j]].function_pro

				; Si c'est un objet et qu'il y a plusieurs appels: afficher l'objet
				; Si ce n'est pas un object et qu'il y a  plusieurs appels: afficher le module
				IF N_ELEMENTS(no_function_pro) EQ 1 THEN BEGIN
					tmp = ''
				END ELSE IF data.decls[no_function_pro[j]].object NE '' THEN BEGIN
					tmp = '@' + data.decls[no_function_pro[j]].object
				END ELSE BEGIN
					tmp = '@'+ data.decls[no_function_pro[j]].module
				END
				IF CALL_XXX EQ 'CALL_SYSTEM' THEN BEGIN
					link = data.decls[no_function_pro[j]].definition
				END ELSE BEGIN
					link = data.decls[no_function_pro[j]].module+'/'+FUNCTION_PRO+'_'+data.decls[no_function_pro[j]].name+'.html'
				END
				IF j EQ 0 THEN BEGIN
					lint_add_cla, data, CALL_XXX, name, tmp, link
				END ELSE BEGIN
					lint_add_cla, data, CALL_XXX, '',   tmp, link
				END
			END

			IF is_function THEN BEGIN
				IF !DEBUG THEN my_print, '  call_function name=[' + name + ']'
				data.pos += STRLEN(name)
				lint_traiter_call_function, data, no_function_pro
			END ELSE IF is_pro THEN BEGIN
				IF !DEBUG THEN my_print, '  call_pro name=[' + name + '] dans ' + STRMID(data.line, data.pos)
				data.pos += STRLEN(name)
				lint_traiter_call_pro, data, no_function_pro
			END

		END

		IF N_ELEMENTS(nocalls) NE 0 THEN BEGIN

			; cet appel est un argument d'un autre appel

			FOR i=0L,N_ELEMENTS(nocalls)-1 DO BEGIN

				nocall = nocalls[i]

				lint_dynamic_prototype, data, nopara, nocall, 'CALL', ''

				module = data.decls[nocall].module
				nb_params_max = data.decls[nocall].nb_params_max
				params_type = STRSPLIT(data.decls[nocall].params_type, /EXTRACT)
				params_extra = STRSPLIT(data.decls[nocall].params_extra, /EXTRACT)
				keywords = STRSPLIT(data.decls[nocall].keywords, /EXTRACT)
				keywords_type = STRSPLIT(data.decls[nocall].keywords_type, /EXTRACT)

				; extra dans la dclaration
				keywords_with_extra = STRPOS(STRUPCASE(data.decls[nocall].keywords), '_EXTRA') NE -1 || STRPOS(STRUPCASE(data.decls[nocall].keywords), '_REF_EXTRA') NE -1

				call_name = data.decls[nocall].is_system ? STRUPCASE(data.decls[nocall].name) : STRLOWCASE(data.decls[nocall].name)
				call      = data.decls[nocall].is_system ? "SYSTEM CALL" : "USER CALL"


				IF call_name EQ 'OBJ_NEW' THEN BEGIN
					; trop compliqu car les paramtres dpendent de la classe
				END ELSE IF call_name EQ 'CALL_PROCEDURE' || call_name EQ 'CALL_FUNCTION' || call_name EQ 'CALL_METHOD' THEN BEGIN
					; trop compliqu car les paramtres dpendent de la la procdure
				END ELSE IF N_ELEMENTS(nocalls) NE 1 && target NE 'cl' THEN BEGIN
					; plusieurs appels possibles: mieux vaut ne rien afficher
				END ELSE IF lint_is_digits (nopara) THEN BEGIN
					; paramtres
					IF nopara LE nb_params_max THEN BEGIN
						param_type = params_type[nopara-1]
						param_extra = params_extra[nopara-1]
						IF param_type EQ 'input' || param_type EQ '[input]' THEN BEGIN
							IF param_extra EQ 'CONSTANT' THEN BEGIN
								my_print_msg, data, lint_get_message(data) + 'CONSTANT EXPECTED' + ' "' + name + '" [' + data.line + ']'
								lint_add_msg, data,                          'CONSTANT EXPECTED',   '"' + name + '"'
							END ELSE IF param_extra EQ 'LABEL"' THEN BEGIN
								my_print_msg, data, lint_get_message(data) + 'LABEL EXPECTED' + ' "' + name + '" [' + data.line + ']'
								lint_add_msg, data,                          'LABEL EXPECTED',   '"' + name + '"'
							END
						END ELSE IF param_type EQ 'output' || param_type EQ '[output]' THEN BEGIN
							my_print_msg, data, lint_get_message(data) + 'NAMED VARIABLE EXPECTED' +  ' "' + name + '" [' + data.line + ']'
							lint_add_msg, data,                          'NAMED VARIABLE EXPECTED',    '"' + name + '"'
						END
					END
				END ELSE BEGIN
					; keywords

					ind = (WHERE (STRUPCASE(keywords) EQ STRUPCASE(nopara)))[0]
					IF ind EQ -1 THEN BEGIN
						; BAD ou ABBREVIATED ?
						ind = (WHERE (STRUPCASE(STRMID(keywords, 0, STRLEN(nopara))) EQ STRUPCASE(nopara)))[0]
						IF ind[0] EQ -1 THEN BEGIN
							IF ~keywords_with_extra && STRUPCASE(nopara) NE '_EXTRA' && STRUPCASE(nopara) NE '_STRICT_EXTRA' THEN BEGIN
								my_print_msg, data, lint_get_message(data) + 'BAD KEYWORD "'    + nopara + '" IN ' + call + ' "' + call_name + '" [' + data.line + ']'
								lint_add_msg, data,                          'BAD KEYWORD', '"' + nopara + '" IN ' + call + ' "' + call_name + '"'
							END
						END ELSE IF ~data.decls[nocall].is_system && data.decl.check_syntax THEN BEGIN
							IF target EQ 'cl' THEN my_print_msg, data, lint_get_message(data) + call + ' ' + call_name + ' WITH ABBREVIATED KEYWORD('+nopara+' INSTEAD OF '+keywords[ind[0]]+') ['+data.line+']'
						END
					END
					IF ind[0] NE -1 THEN BEGIN
						IF keywords_type[ind] EQ 'input' || keywords_type[ind] EQ '[input]' THEN BEGIN
						END ELSE IF keywords_type[ind] EQ 'output' || keywords_type[ind] EQ '[output]' THEN BEGIN
							my_print_msg, data, lint_get_message(data) + 'NAMED VARIABLE EXPECTED' + ' "' + name + '" ['+data.line+']'
							lint_add_msg, data,                          'NAMED VARIABLE EXPECTED',   '"' + name + '"'
						END
					END
				END
			END
		END

		RETURN

	END

	IF lint_is_string_or_constant (name, is_string, is_constant, tmp) THEN BEGIN
		IF is_constant THEN BEGIN
			lint_add_cla, data, 'CONSTANT', name, '', ''
		END 
	END

	data_pos_old = data.pos

	data.pos += STRLEN(name)

	is_variable = 0
	is_variable_simple = 1
	IF is_constant THEN BEGIN
		no_variable = -1
	END ELSE IF is_string THEN BEGIN
		no_variable = -1
	END ELSE IF is_label THEN BEGIN
		no_variable = -1
	END ELSE BEGIN
		is_variable = 1
		name1 = name
		lint_traiter_variable, data, name1, is_variable_simple	; pour sauter les '[...]' et '(..)'
	END

	IF ~is_variable_simple && is_pointer THEN BEGIN
		; ex: "cd, current=*state.path"
		is_variable_simple = 1
	END

	has_egal = lint_get_egal (data)

	IF no_variable NE -1 THEN BEGIN

		IF data.decl.check_case_sensitive && (*data.vars)[no_variable].categorie NE 'system' THEN BEGIN
			IF (*data.vars)[no_variable].name NE name THEN BEGIN
				my_print_msg, data, lint_get_message(data) + 'CASE SENSITIVE VARIABLE "'+name+'" ['+data.line+']'
				lint_add_msg, data, 'CASE SENSITIVE VARIABLE ', '"'+name+'"&nbsp;"'+(*data.vars)[no_variable].name+'"'
			END
		END
		IF !DEBUG THEN my_print, '  variable name=[' + name + ']'
		IF has_egal THEN BEGIN
			IF data.statement EQ 'FOR' THEN data.for_variable = name
			IF data.statement NE 'FOR' THEN lint_check_space_tab, data, '='
			set_data_statement, data, data.statement EQ 'FOR' ? 'FOR=' : '='
			IF !DEBUG THEN my_print, 'statement = ['+data.statement +'] dans ' + data.line
			IF !DEBUG THEN my_print, '  AFFECTATION ANCIEN SYMBOLE ' + name

			IF data.decl.check_syntax THEN BEGIN
				; ex: "variable[1:2].x"
				name_complet = STRCOMPRESS(STRMID(data.line, data_pos_old, data.pos-data_pos_old), /REMOVE_ALL)
			END

			data.pos++

			IF data.decl.check_syntax THEN BEGIN
				; Chercher si on retrouve name_complet ensuite avec '+', '-',  '*' ou '/'
				apres = STRMID(data.line, data.pos)
				pos = STRPOS(apres, name_complet)
				IF pos NE -1 THEN BEGIN
					IF STRCOMPRESS(STRMID(apres, 0, pos), /REMOVE_ALL) EQ '' THEN BEGIN
						apres = STRMID(apres, pos+STRLEN(name_complet))

						operators = ['+','-','*','/']
						FOR i=0L,N_ELEMENTS(operators)-1 DO BEGIN
							pos = STRPOS(apres, operators[i])
							IF pos NE -1 THEN IF STRCOMPRESS(STRMID(apres, 0, pos), /REMOVE_ALL) EQ '' THEN BEGIN
								my_print_msg, data, lint_get_message(data) + 'OPERATOR "' + operators[i] + '=" CAN BE USED [' + data.line + ']'
							END
						END

					END
				END
			END

			; Pas vraiment besoin d'incrmenter nb_use s'il s'agit d'une variable locale. Sinon pour le code suivant:
			;	x=1
			;	x=1
			; on ne pourra jamais annoncer que x ne sert  rien

			; Mais ca ne s'applique pas aux variables de boucles

			IF (*data.vars)[no_variable].categorie NE 'local'  || (*data.vars)[no_variable].contexte EQ 'FOR=' THEN BEGIN
				(*data.vars)[no_variable].nb_use++
			END

			IF (*data.vars)[no_variable].categorie NE 'common' THEN BEGIN
				(*data.vars)[no_variable].contexte = ''
			END
			RETURN
		END

		IF type_short NE 'para' THEN BEGIN
			(*data.vars)[no_variable].nb_use++
			RETURN
		END
	END

	IF type_short NE 'para' THEN BEGIN

		IF has_egal && is_variable_simple THEN BEGIN
	
			; instruction "variable = ..." -> Creation de variable
			;
			; 	mais pas pour "variable.xxx = ..."
			; 	mais pas pour "variable[xxx] = ..."
			; 	mais pas pour "variable(xxx) = ..."

			IF data.statement EQ 'FOR' THEN data.for_variable = name
			IF data.statement NE 'FOR' THEN lint_check_space_tab, data, '='
			set_data_statement, data, data.statement EQ 'FOR' ? 'FOR=' : '='
			IF data.statement EQ 'FOR=' THEN data.for_variable = name
			IF !DEBUG THEN my_print, 'statement = ['+data.statement +'] dans ' + data.line
			data.pos++
			; affectation => cration du SYMBOLE name
			IF !DEBUG THEN my_print, '  AFFECTATION NOUVELLE VARIABLE ' + name + ' dans ' + data.line
			IF name EQ "DEBUG" THEN BEGIN
				IF data.decl.check_stop_debug THEN BEGIN
					IF STRCOMPRESS(STRMID(data.line, data.pos), /REMOVE_ALL) EQ 1 THEN BEGIN
						my_print_msg, data, lint_get_message(data) + 'INSTRUCTION DEBUG=1 FOUND [' + data.line + ']'
						lint_add_msg, data, 'INSTRUCTION DEBUG=1 FOUND', '"' + name + '"'
					END
				END
			END
			IF name EQ "akotova" THEN BEGIN
				IF data.decl.check_stop_debug THEN BEGIN
					IF STRCOMPRESS(STRMID(data.line, data.pos), /REMOVE_ALL) EQ 1 THEN BEGIN
						my_print_msg, data, lint_get_message(data) + 'INSTRUCTION akotova=1 FOUND [' + data.line + ']'
						lint_add_msg, data, 'INSTRUCTION akotova=1 FOUND', '"' + name + '"'
					END
				END
			END
			vars = *data.vars
			var = { name: name, categorie: 'local_en_cours', contexte: data.statement, nb_use: 1L }
			vars = [ vars, var ]
			PTR_FREE, data.vars
			data.vars = PTR_NEW(vars, /NO_COPY)

			RETURN

		END
		IF has_egal && ~is_variable_simple THEN BEGIN
			IF data.statement NE 'FOR' THEN lint_check_space_tab, data, '='
		END
	END

	IF type_short EQ 'para' THEN BEGIN

		FOR i=0L,N_ELEMENTS(nocalls)-1 DO BEGIN

			nocall = nocalls[i]

			IF is_string THEN lint_dynamic_prototype, data, nopara, nocall, 'CONSTANT_STRING', name
			IF is_constant THEN lint_dynamic_prototype, data, nopara, nocall, 'CONSTANT', name
			IF is_variable THEN BEGIN
				IF is_variable_simple THEN BEGIN
					lint_dynamic_prototype, data, nopara, nocall, no_variable EQ -1 ? 'UNDEFINED_SIMPLE_VARIABLE' : 'DEFINED_SIMPLE_VARIABLE', name
				END ELSE BEGIN
					lint_dynamic_prototype, data, nopara, nocall, no_variable EQ -1 ? 'UNDEFINED_COMPLEX_VARIABLE' : 'DEFINED_COMPLEX_VARIABLE', name
				END
			END

			; Creation de variable passe en paramtres ?
			;
			; instruction "fonction(variable)" ou "fonction(keyword=variable)" ou "pro,variable" ou "pro,keyword=variable"
			; pas pour fonction(variable[xxx])
			; pas pour fonction(variable[xxx])
			; pas pour fonction(variable(xxx))

			; has_point EQ 0:		pour ne pas crer les variables var.xxx
			; has_crochet_ouvrant EQ 0:	pour ne pas crer les variables var[xxx]
			; has_parenthese_ouvrante EQ 0:	pour ne pas crer les variables var(xxx)
			;
			; variable inconnue dans 'para' => cration du SYMBOLE name

			module = data.decls[nocall].module
			nb_params_max = data.decls[nocall].nb_params_max
			params_type = STRSPLIT(data.decls[nocall].params_type, /EXTRACT)
			params_extra = STRSPLIT(data.decls[nocall].params_extra, /EXTRACT)
			keywords = STRSPLIT(data.decls[nocall].keywords, /EXTRACT)
			keywords_type = STRSPLIT(data.decls[nocall].keywords_type, /EXTRACT)

			; extra dans la dclaration
			keywords_with_extra = STRPOS(STRUPCASE(data.decls[nocall].keywords), '_EXTRA') NE -1 || STRPOS(STRUPCASE(data.decls[nocall].keywords), '_REF_EXTRA') NE -1

			creer_variable = is_variable && no_variable EQ -1

			call_name = data.decls[nocall].is_system ? STRUPCASE(data.decls[nocall].name) : STRLOWCASE(data.decls[nocall].name)
			call      = data.decls[nocall].is_system ? "SYSTEM_CALL" : "USER_CALL"

			IF call_name EQ 'OBJ_NEW' THEN BEGIN
				; trop compliqu car les paramtres dpendent de la classe
			END ELSE IF call_name EQ 'CALL_PROCEDURE' || call_name EQ 'CALL_FUNCTION' || call_name EQ 'CALL_METHOD' THEN BEGIN
				; trop compliqu car les paramtres dpendent de la la procdure
			END ELSE IF N_ELEMENTS(nocalls) NE 1 && target NE 'cl' THEN BEGIN
				; plusieurs appels possibles: mieux vaut ne rien afficher
			END ELSE IF lint_is_digits (nopara) THEN BEGIN
				; paramtres
				IF nopara LE nb_params_max THEN BEGIN
					param_type = params_type[nopara-1]
					param_extra = params_extra[nopara-1]
					IF param_type EQ 'input' || param_type EQ '[input]' THEN BEGIN
						creer_variable = 0
						IF param_extra EQ 'CONSTANT' THEN BEGIN
							IF ~is_constant THEN BEGIN
								my_print_msg, data, lint_get_message(data) + 'CONSTANT EXPECTED' + ' "' + name + '" [' + data.line + ']'
								lint_add_msg, data,                          'CONSTANT EXPECTED',   '"' + name + '"'
							END
						END ELSE IF param_extra EQ 'LABEL' THEN BEGIN
							label = { nocall: nocall, name: name, noline: data.noline }
							IF PTR_VALID(data.labels_used) THEN BEGIN
								labels_used = *data.labels_used
								labels_used = [ labels_used, label ]
								PTR_FREE, data.labels_used
								data.labels_used = PTR_NEW(labels_used, /NO_COPY)
							END ELSE BEGIN
								labels_used = label
								data.labels_used = PTR_NEW(labels_used, /NO_COPY)
							END
						END ELSE IF is_variable && no_variable EQ -1 THEN BEGIN
							msg = lint_get_undefined (type, type_short, has_parenthese, has_egal, has_point, has_crochet, has_2points, has_fleche)
							IF param_extra EQ 'UNDEFINED' THEN BEGIN
								; ex: "N_ELEMENTS(variable_undefined)"
								; je prfre mettre un message car si x est UNDEFINED:
								; - IF N_ELEMENTS(x) est concevable
								; - FOR i=...,N_ELEMENTS(x) est surement une erreur!
								old_data_pos = data.pos
								data.pos = data_pos_msg
								my_print_msg, data, lint_get_message(data) + msg + ' "' + name + '" [' + data.line + ']'
								lint_add_msg, data,                          msg,   '"' + name + '"'
								lint_add_cla, data, 'UNDEFINED', name, '', ''
								data.pos = old_data_pos
							END ELSE BEGIN
								old_data_pos = data.pos
								data.pos = data_pos_msg
								my_print_msg, data, lint_get_message(data) + msg + ' "' + name + '" [' + data.line + ']'
								lint_add_msg, data,                          msg,   '"' + name + '"'
								lint_add_cla, data, 'UNDEFINED', name, '', ''
								data.pos = old_data_pos
							END
							IF msg EQ 'UNDEFINED VARIABLE' THEN BEGIN
								; On rajoute cette variable  vars_undefined (saut si elle y est dja)
								tmp = STRSPLIT (data.vars_undefined, /EXTRACT)
								IF (WHERE(STRUPCASE(tmp) EQ STRUPCASE(name)))[0] EQ -1 THEN data.vars_undefined += ' '+name
							END
						END
					END ELSE IF param_type EQ 'output' || param_type EQ '[output]' THEN BEGIN
						IF is_string || is_constant || ~is_variable_simple THEN BEGIN
							my_print_msg, data, lint_get_message(data) + 'NAMED VARIABLE EXPECTED' + ' "' + name + '" [' + data.line + ']'
							lint_add_msg, data,                          'NAMED VARIABLE EXPECTED',   '"' + name + '"'
						END
					END
				END
			END ELSE BEGIN
				; keywords

				ind = (WHERE (STRUPCASE(keywords) EQ STRUPCASE(nopara)))[0]
				IF ind EQ -1 THEN BEGIN
					; BAD ou ABBREVIATED ?
					ind = (WHERE (STRUPCASE(STRMID(keywords, 0, STRLEN(nopara))) EQ STRUPCASE(nopara)))[0]
					IF ind[0] EQ -1 THEN BEGIN
						IF ~keywords_with_extra && STRUPCASE(nopara) NE '_EXTRA' && STRUPCASE(nopara) NE '_STRICT_EXTRA' THEN BEGIN
							my_print_msg, data, lint_get_message(data) + 'BAD KEYWORD "'    + nopara + '" IN ' + call + ' " ' + call_name + '" [' + data.line + ']'
							lint_add_msg, data,                          'BAD KEYWORD', '"' + nopara + '" IN ' + call + ' " ' + call_name + '"'
						END
					END ELSE IF ~data.decls[nocall].is_system && data.decl.check_syntax THEN BEGIN
						IF target EQ 'cl' THEN my_print_msg, data, lint_get_message(data) + call + ' ' + call_name + ' WITH ABBREVIATED KEYWORD('+nopara+' INSTEAD OF '+keywords[ind[0]]+') ['+data.line+']'
					END
				END
				IF ind[0] NE -1 THEN BEGIN
					IF keywords_type[ind] EQ 'input' || keywords_type[ind] EQ '[input]' THEN BEGIN
						IF is_variable && no_variable EQ -1 THEN BEGIN
							msg = lint_get_undefined (type, type_short, has_parenthese, has_egal, has_point, has_crochet, has_2points, has_fleche)
							old_data_pos = data.pos
							data.pos = data_pos_msg
							my_print_msg, data, lint_get_message(data) + msg + ' "' + name + '" [' + data.line + ']'
							lint_add_msg, data,                          msg,   '"' + name + '"'
							lint_add_cla, data, 'UNDEFINED', name, '', ''
							data.pos = old_data_pos
							IF msg EQ 'UNDEFINED VARIABLE' THEN BEGIN
								; On rajoute cette variable  vars_undefined (saut si elle y est dja)
								tmp = STRSPLIT (data.vars_undefined, /EXTRACT)
								IF (WHERE(STRUPCASE(tmp) EQ STRUPCASE(name)))[0] EQ -1 THEN data.vars_undefined += ' '+name
							END
						END
					END ELSE IF keywords_type[ind] EQ 'output' || keywords_type[ind] EQ '[output]' THEN BEGIN
						IF is_string || is_constant || ~is_variable_simple  THEN BEGIN
							my_print_msg, data, lint_get_message(data) + 'NAMED VARIABLE EXPECTED' + ' "' + name + '" ['+data.line+']'
							lint_add_msg, data,                          'NAMED VARIABLE EXPECTED',  ' "' + name + '"'
						END
					END
				END
			END

			IF creer_variable THEN BEGIN

				IF !DEBUG THEN my_print, '  CREATION VARIABLE ' + name

				vars = *data.vars

				; pas besoin de vraiment crer la variable si une variable 'para_en_cours' existe dja
				IF (WHERE (vars.categorie EQ 'para_en_cours' AND vars.name EQ name))[0] EQ -1 THEN BEGIN
					var = { name: name, categorie: 'para_en_cours', ncontexte: '', nb_use: 1L }
					vars = [ vars, var ]
					PTR_FREE, data.vars
					data.vars = PTR_NEW(vars, /NO_COPY)
				END

			END ELSE IF no_variable NE -1 THEN BEGIN

				(*data.vars)[no_variable].nb_use++

			END

		END


		RETURN

	END

	IF has_egal THEN data.pos++

	IF is_constant THEN BEGIN
		RETURN
	END

	IF is_string THEN BEGIN
		RETURN
	END

	IF is_label THEN BEGIN
		; label
		label = { name: name, noline: data.noline, nb_use: 0L }
		IF PTR_VALID(data.labels_found) THEN BEGIN
			labels_found = *data.labels_found
			ind = WHERE (STRUPCASE(labels_found.name) EQ STRUPCASE(name))
			IF ind[0] EQ -1 THEN BEGIN
				labels_found = [ labels_found, label ]
				PTR_FREE, data.labels_found
				data.labels_found = PTR_NEW(labels_found, /NO_COPY)
			END
		END ELSE BEGIN
			labels_found = label
			data.labels_found = PTR_NEW(labels_found, /NO_COPY)
		END
		
		data.pos++
		RETURN
	END


	IF data.msg_on THEN BEGIN
		msg = lint_get_undefined (type, type_short, has_parenthese, has_egal, has_point, has_crochet, has_2points, has_fleche)
		; revenir en arrire au cas ou le fait d'aller jusqu' la fin du symbole nous ai fait changer de ligne
		old_data_pos = data.pos
		data.pos = data_pos_msg
		my_print_msg, data, lint_get_message(data) + msg + ' "' + name + '" ['+data.line + ']'
		lint_add_msg, data,                          msg, '"'   + name + '"'
		lint_add_cla, data, 'UNDEFINED', name, '', ''
		data.pos = old_data_pos

		IF msg EQ 'UNDEFINED VARIABLE' THEN BEGIN
			; On rajoute cette variable  vars_undefined (saut si elle y est dja)
			tmp = STRSPLIT (data.vars_undefined, /EXTRACT)
			IF (WHERE(STRUPCASE(tmp) EQ STRUPCASE(name)))[0] EQ -1 THEN data.vars_undefined += ' '+name
		END
	END

END

;-------------------------------------------------------------------------------
PRO lint_plus,	$
;-------------------------------------------------------------------------------
	lignes,	$	; LINT_PROTOTYPE input
	data		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Analyse le tableau de lignes de code 'lignes'.
;
; variable = ...
;
; procedure, v1, v2, v3, ...
;
; procedure
;
; variable = fonction (v1,v2,v3,...)
;-------------------------------------------------------------------------------

	COMMON COMMON_LINT, common_lint_infos

	; pour chercher s'il y a des keywords suivis de '$'
	keywords = ['IF','THEN','ELSE','BEGIN','END','UNTIL','REPEAT','FOR','WHILE','SWITCH','CASE','OF','DO']

	; On supprime les '$' en concatnant les lignes finissant par '$'
	; big est une grosse STRING, il suffira de la dcouper ensuite par !SEP1
	bigligne = ''

	; Il faut mmoriser les vrais numros de lignes
	bignoligne = ''
	bignochar  = ''

top1 = nbsec()

	FOR i=0L,N_ELEMENTS(lignes)-1 DO BEGIN

		ligne = lignes[i]

		IF STRTRIM(ligne, 2) EQ '' THEN CONTINUE

		pos_dollar = STRPOS (ligne, '$', /REVERSE_SEARCH)

		IF pos_dollar NE -1 && STRTRIM(STRMID(ligne, pos_dollar+1), 2) EQ '' THEN BEGIN	; attention  "INFO.SPIN$PHI_THETA"


			IF data.decl.check_syntax THEN BEGIN
				FOR j=0L,N_ELEMENTS(keywords)-1 DO BEGIN
					pos = STRPOS(ligne, keywords[j]) 
					IF pos NE -1 THEN BEGIN
						apres = STRMID(ligne, pos+STRLEN(keywords[j]))
						IF STRCOMPRESS(apres, /REMOVE_ALL) EQ '$' THEN BEGIN
							data.noline = data.decl.noligne1+i
							my_print_msg, data, lint_get_message(data) + keywords[j] + ' $ FOUND [' + ligne + ']'
						END
					END	
				END
			END

			ligne = STRMID(ligne, 0, pos_dollar)
			IF STRTRIM(ligne, 2) EQ '' THEN CONTINUE

			; Rechercher les '&'
			pos = 0L
			WHILE 1 DO BEGIN

				pos_e = -1
				j = pos
				len = STRLEN(ligne)
				WHILE j LT len DO BEGIN
					pos_e = STRPOS(ligne, '&', j)
					IF pos_e EQ -1 THEN BEGIN
						BREAK
					END ELSE IF STRMID(ligne, pos_e+1, 1) EQ '&' THEN BEGIN
						j = pos_e+2
						pos_e = -1
					END ELSE BEGIN
						BREAK
					END
				END

				IF pos_e EQ -1 THEN BEGIN

					elt_ligne = STRMID(ligne, pos)
					len = STRLEN(elt_ligne)

					bigligne += elt_ligne

					elt_noligne = len EQ 0 ? '' : STRJOIN(REPLICATE (LINTC_INT_TO_STR(i), len), ' ')
					bignoligne += elt_noligne  + ' '

					elt_nochar = len EQ 0 ? '' : STRJOIN(val_to_str(LINDGEN(len)+pos), ' ')
					bignochar += elt_nochar + ' '

					BREAK
				END

				elt_ligne = STRMID(ligne, pos, pos_e-pos)
				len = STRLEN(elt_ligne)

				bigligne += elt_ligne + !SEP1

				elt_noligne = len EQ 0 ? '' : STRJOIN(REPLICATE (LINTC_INT_TO_STR(i), len), ' ')
				bignoligne += elt_noligne + !SEP1

				elt_nochar = len EQ 0 ? '' : STRJOIN(val_to_str(LINDGEN(len)+pos), ' ')
				bignochar += elt_nochar + !SEP1

				pos = pos_e + 1
			END

		END ELSE BEGIN

			; Rechercher les '&'
			pos = 0L
			WHILE 1 DO BEGIN

				pos_e = -1
				j = pos
				len = STRLEN(ligne)
				WHILE j LT len DO BEGIN
					pos_e = STRPOS(ligne, '&', j)
					IF pos_e EQ -1 THEN BEGIN
						BREAK
					END ELSE IF STRMID(ligne, pos_e+1, 1) EQ '&' THEN BEGIN
						j = pos_e+2
						pos_e = -1
					END ELSE BEGIN
						BREAK
					END
				END

				IF pos_e EQ -1 THEN BEGIN

					elt_ligne = STRMID(ligne, pos)
					len = STRLEN(elt_ligne)

					bigligne += elt_ligne + !SEP1

					elt_noligne = len EQ 0 ? '' : STRJOIN(REPLICATE (LINTC_INT_TO_STR(i), len), ' ')
					bignoligne += elt_noligne + !SEP1

					elt_nochar = len EQ 0 ? '' : STRJOIN(val_to_str(LINDGEN(len)+pos), ' ')
					bignochar += elt_nochar + !SEP1

					BREAK
				END

				elt_ligne = STRMID(ligne, pos, pos_e-pos)
				len = STRLEN(elt_ligne)

				bigligne += elt_ligne + !SEP1

				elt_noligne = len EQ 0 ? '' : STRJOIN(REPLICATE (LINTC_INT_TO_STR(i), len), ' ')
				bignoligne += elt_noligne + !SEP1

				elt_nochar = len EQ 0 ? '' : STRJOIN(val_to_str(LINDGEN(len)+pos), ' ')
				bignochar += elt_nochar + !SEP1

				pos = pos_e + 1
			END
		END

	END
top2 = nbsec()
		common_lint_infos.duree_bigline += top2-top1


	lines   = STRSPLIT (bigligne,   !SEP1, /EXTRACT)
	nolines = STRSPLIT (bignoligne, !SEP1, /EXTRACT)
	nochars = STRSPLIT (bignochar,  !SEP1, /EXTRACT)


	IF !DEBUG THEN my_print, 'lint_plus '+data.decl.module+' '+data.decl.name


	; Recherche de blocs BEGIN END d'une seule ligne
	; ----------------------------------------------
	nblignes_bloc = 0L

	FOR i=0L,N_ELEMENTS(lines)-1 DO BEGIN

		data.line = lines[i]
		data.noline = PTR_NEW (LONG(STRSPLIT(nolines[i], /EXTRACT)) + data.decl.noligne1)
		data.nochar = PTR_NEW (LONG(STRSPLIT(nochars[i], /EXTRACT)))

		data.pos = 0L

		IF data.decl.check_syntax THEN BEGIN

			; Cherche si la ligne contient "IF condition THEN variable = ... ELSE variable = ..."
			tmp = STRSPLIT (data.line, /EXTRACT)
			ind_IF = (WHERE (tmp EQ 'IF'))[0]
			IF ind_IF[0] NE -1 THEN BEGIN
				ind_THEN = (WHERE (tmp EQ 'THEN'))[0]
				IF ind_THEN[0] NE 0 THEN BEGIN
					ind_ELSE = (WHERE (tmp EQ 'ELSE'))[0]
					IF ind_ELSE[0] NE -1 THEN BEGIN
						IF ind_ELSE+2 LT N_ELEMENTS(tmp) && ind_THEN+2 LT N_ELEMENTS(tmp) THEN BEGIN
							IF tmp[ind_THEN+2] EQ '=' && tmp[ind_ELSE+2] EQ '=' THEN BEGIN
								variable_THEN = tmp[ind_THEN+1]
								variable_ELSE = tmp[ind_ELSE+1]
								IF variable_THEN EQ variable_ELSE THEN BEGIN
									my_print_msg, data, lint_get_message(data) + 'OPERATOR "?" CAN BE USED ['+data.line+']'
								END
							END
						END
					END
				END
			END

		END

		; Recherche de blocs BEGIN END d'une seule ligne
		; ----------------------------------------------
		tmp = STRSPLIT (data.line, /EXTRACT)
		debut_bloc = tmp[N_ELEMENTS(tmp)-1] EQ 'BEGIN'
		fin_bloc   = tmp[0] EQ 'END' && N_ELEMENTS(tmp) EQ 1
		IF fin_bloc THEN BEGIN
			IF nblignes_bloc EQ 1 THEN BEGIN
				;my_print, lint_get_message(data) + 'ONE LINE BLOC ['+data.line+']'
			
			END
		END ELSE IF debut_bloc THEN BEGIN
			nblignes_bloc = 0
		END ELSE BEGIN
			nblignes_bloc++
		END


		type = 'debut'
		WHILE data.pos LT STRLEN(data.line) DO BEGIN

			IF lint_get_egal(data) THEN BEGIN
				; ex: IF ind[0] NE -1 THEN (*data.vars).type = _STRING_
				data.pos++
			END

			IF lint_get_2points(data) THEN BEGIN
				; element de SWICTH ou CASE
				data.pos++
			END

			IF lint_get_virgule(data) THEN BEGIN
				; ex: for j=0, num-1 do begin
				data.pos++
			END

			pos = lint_get_name_idl (data, name)
			data.pos = pos

			IF !DEBUG THEN my_print, 'initialisation statement = ['+data.statement +'] dans ' + data.line
			; Que contient name ?

			; pour CASE x OF
			;	a:	instruction
			; a n'est pas un label!


			data.statement = STRUPCASE(data.statement) EQ 'OF' ? 'OF' : ''
		
			old_data_pos = data.pos

			lint_traiter_expression, data, type
			; type sera modifi

			IF ~PTR_VALID(data.noline) THEN BEGIN
				; on a trouv un fichier INCLUDE qui a modifi data.line et libr data.noline et data.nochar
				data.line = lines[i]
				PTR_FREE, data.noline
				data.noline = PTR_NEW (LONG(STRSPLIT(nolines[i], /EXTRACT)) + data.decl.noligne1)
				PTR_FREE, data.nochar
				data.nochar  = PTR_NEW (LONG(STRSPLIT(nochars[i],  /EXTRACT)))
			END

			IF STRMID(data.line, data.pos) EQ '' THEN BEGIN
				WHILE 1 DO BEGIN
					CASE get_last_pile(data) OF
						'FOR_DO':	depiler, data
						'IF_THEN':	depiler, data
						'ELSE':		depiler, data
						'ELSE_IF_THEN':	depiler, data
						'WHILE_DO':	depiler, data
						ELSE:		GOTO, EOL
					END
				END
EOL:
				IF lint_get_noline(data) GT data.decl.noligne2 THEN BEGIN
					IF data.statement EQ 'BEGIN' THEN BEGIN
					END ELSE IF data.statement EQ 'END' THEN BEGIN
					END ELSE IF data.statement EQ 'OF' THEN BEGIN
					END ELSE IF data.statement EQ 'UNTIL' THEN BEGIN
						;lint_add_ccc, data, 'EOL', '', '));', nochar=lint_get_nochar(data)+1
					END ELSE BEGIN
						;lint_add_ccc, data, 'EOL', '', ';', nochar=lint_get_nochar(data)+1
					END
				END
			END

			lint_finaliser_variables_en_cours, data

			IF data.pos EQ old_data_pos THEN BEGIN
				; on va boucler sans fin
				data.pos++
			END

		END

		IF !DEBUG THEN my_print, '  TERMINE avec ' + lines[i]
		PTR_FREE, data.noline
		PTR_FREE, data.nochar

	END

	; Chercher les messages "UNDEFINED VARIABLE" "name"
	msg = STRSPLIT (data.decls[data.nor].msg, !SEP1, /EXTRACT)
	IF msg[0] NE '' THEN BEGIN
		modif = 0
		FOR i=0L, N_ELEMENTS(msg)-1 DO BEGIN
			tmp1 = STRSPLIT (msg[i], !SEP2, /EXTRACT, /PRESERVE_NULL)
			IF tmp1[2] EQ 'UNDEFINED VARIABLE' THEN BEGIN
				name = STRMID (tmp1[3], 1, STRPOS(tmp1[3], '"', 1)-1)
				; cette variable a t-elle t dclare plus tard ?
				ind = WHERE (((*data.vars).categorie EQ 'local' OR (*data.vars).categorie EQ 'para') AND (*data.vars).name EQ name)
				IF ind[0] NE -1 THEN BEGIN
					; c'est le cas

					; on modifie le message d'erreur
					msg[i] = tmp1[0] + !SEP2 + tmp1[1] + !SEP2 + "VARIABLE DEFINED AFTER" + !SEP2 + tmp1[3]
					modif = 1

					; on incrmente le champ nb_use de cette variable pour qu'on ne dise pas qu'elle est inutilise
					(*data.vars)[ind].nb_use++

					; on modifie le cla pour afficher les variables en violet
					noline = tmp1[0]
					nochar = tmp1[1]

					IF data.decls[data.nor].nbclas NE 0 THEN BEGIN
						FOR j=0L, data.decls[data.nor].nbclas-1 DO BEGIN
							IF (*data.decls[data.nor].cla)[j].noline EQ noline AND (*data.decls[data.nor].cla)[j].nochar EQ nochar AND (*data.decls[data.nor].cla)[j].type EQ 'UNDEFINED' THEN BEGIN
								(*data.decls[data.nor].cla)[j].type = 'DEFINED_AFTER'
							END
						END
					END
				END
			END
			
		END
		IF modif THEN BEGIN
			data.decls[data.nor].msg = STRJOIN (msg, !SEP1) + !SEP1
		END
	END

	IF data.decl.check_unused THEN BEGIN
		; Recherche variables 'local' inutilises
		ind = WHERE ((*data.vars).categorie EQ 'local' AND (*data.vars).nb_use LE 1)
		IF ind[0] NE -1 THEN BEGIN
			FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
				IF (*data.vars)[ind[i]].name EQ 'lint_unused' THEN CONTINUE
				IF (*data.vars)[ind[i]].contexte EQ 'FOR=' THEN BEGIN
					;my_print, lint_get_message(data) + 'UNUSED FOR VARIABLED: "'+(*data.vars)[ind[i]].name+'"'
				END ELSE IF (*data.vars)[ind[i]].nb_use EQ 1 THEN BEGIN
					my_print_msg, data, lint_get_message(data, /routine) + 'VARIABLE SET BUT NOT USED "'    + (*data.vars)[ind[i]].name + '" in ' + data.decl.name
					lint_add_msg, data, noligne=0L,                        'VARIABLE SET BUT NOT USED', '"' + (*data.vars)[ind[i]].name + '"'
				END
			END
		END
	END

	IF 0 && data.decl.check_unused THEN BEGIN
		; Recherche variables 'para' inutilises
		ind = WHERE ((*data.vars).categorie EQ 'para' AND (*data.vars).nb_use LE 1)
		IF ind[0] NE -1 THEN BEGIN
			FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
				IF (*data.vars)[ind[i]].name EQ 'lint_unused' THEN CONTINUE
				IF (*data.vars)[ind[i]].contexte EQ 'FOR=' THEN BEGIN
					;my_print, lint_get_message(data) + 'UNUSED FOR VARIABLED: "'+(*data.vars)[ind[i]].name+'"'
				END ELSE IF (*data.vars)[ind[i]].nb_use EQ 1 THEN BEGIN
					my_print_msg, data, lint_get_message(data, /routine) + 'VARIABLE CREATED BUT NOT USED "'    + (*data.vars)[ind[i]].name + '" in ' + data.decl.name
					lint_add_msg, data, noligne=0L,                        'VARIABLE CREATED BUT NOT USED', '"' + (*data.vars)[ind[i]].name + '"'
				END
			END
		END
	END

	IF data.decl.check_unused THEN BEGIN
		; Recherche 'param' inutilises
		ind = WHERE ((*data.vars).categorie EQ 'param' AND (*data.vars).nb_use LE 0)
		IF ind[0] NE -1 THEN BEGIN
			FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
				IF chaine_contient(data.decl.module, 'pro/exp_') THEN CONTINUE ; sinon trop de messages
				my_print_msg, data, lint_get_message(data, /routine) + 'UNUSED PARAM "'    + (*data.vars)[ind[i]].name + '" in ' + data.decl.name
				lint_add_msg, data, noligne=-1L,                       'UNUSED PARAM', '"' + (*data.vars)[ind[i]].name + '"'
			END
		END
	END

	IF data.decl.check_unused THEN BEGIN
		; Recherche 'keyword' inutilises
		ind = WHERE ((*data.vars).categorie EQ 'keyword' AND (*data.vars).nb_use LE 0)
		IF ind[0] NE -1 THEN BEGIN
			FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
				IF chaine_contient(data.decl.module, 'pro/exp_') THEN CONTINUE ; sinon trop de messages
				IF STRUPCASE((*data.vars)[ind[i]].name) EQ '_EXTRA' THEN CONTINUE
				my_print_msg, data, lint_get_message(data, /routine) + 'UNUSED KEYWORD "'    + (*data.vars)[ind[i]].name + '" in ' + data.decl.name
				lint_add_msg, data, noligne=-1L,                       'UNUSED KEYWORD', '"' + (*data.vars)[ind[i]].name + '"'
			END
		END
	END

	IF data.decl.check_unused THEN BEGIN
		; Recherche common inutilises
		ind = WHERE ((*data.vars).categorie EQ 'common' AND (*data.vars).nb_use LE 0)
		IF ind[0] NE -1 THEN BEGIN
			contexte = (*data.vars)[ind].contexte
			contexte = contexte[UNIQ (contexte, SORT(contexte))]
			FOR i=0L,N_ELEMENTS(contexte)-1 DO BEGIN
				; toutes les variables sont inutiles ?
				ind = WHERE ((*data.vars).categorie EQ 'common' AND (*data.vars).contexte EQ contexte[i] AND (*data.vars).nb_use GE 1)
				IF ind[0] EQ -1 THEN BEGIN
					my_print_msg, data, lint_get_message(data, /routine) + 'UNUSED COMMON "'    + contexte[i] + '" in ' + data.decl.name
					lint_add_msg, data, noligne=0L,                        'UNUSED COMMON', '"' + contexte[i] + '"'
				END
			END
		END
	END

	; Recherche labels inexistants
	IF PTR_VALID(data.labels_used) THEN BEGIN
		labels_used = *data.labels_used
		IF PTR_VALID(data.labels_found) THEN labels_found = *data.labels_found
		FOR i=0L,N_ELEMENTS(labels_used)-1 DO BEGIN
			IF N_ELEMENTS(labels_found) NE 0 THEN BEGIN
				ind = WHERE (STRUPCASE(labels_found.name) EQ STRUPCASE(labels_used[i].name))
			END ELSE BEGIN
				ind = -1
			END
			IF ind[0] EQ -1 THEN BEGIN
				IF data.decls[labels_used[i].nocall].name EQ 'on_ioerror' && STRUPCASE(labels_used[i].name) EQ 'NULL' THEN BEGIN
				END ELSE BEGIN
					my_print_msg, data, lint_get_message(data, /routine) + 'UNDEFINED LABEL "'    + labels_used[i].name + '" in ' + data.decl.name
					lint_add_msg, data, noligne=0L,                        'UNDEFINED LABEL', '"' + labels_used[i].name + '"'
				END
			END ELSE BEGIN
				labels_found[ind[0]].nb_use++
				IF labels_found[ind[0]].name NE labels_used[i].name THEN BEGIN
					IF data.decl.check_case_sensitive THEN BEGIN
						;my_print, lint_get_message(data,/routine) + '('+LINTC_INT_TO_STR(labels_used[i].noline)+') CASE SENSITIVE PB "'+labels_used[i].name
						my_print_msg, data, lint_get_message(data, /routine) + 'CASE SENSITIVE LABEL "'     + labels_used[i].name + '" in ' + data.decl.name
						lint_add_msg, data, noligne=0L,                        'CASE SENSITIVE LABEL ', '"' + labels_used[i].name + '"'
					END
				END
			END
		END
	END

	IF data.decl.check_unused THEN BEGIN
		; Recherche labels inutiliss
		IF N_ELEMENTS(labels_found) NE 0 THEN BEGIN
			FOR i=0L,N_ELEMENTS(labels_found)-1 DO BEGIN
				IF labels_found[i].nb_use EQ 0 THEN BEGIN
					my_print_msg, data, lint_get_message(data, /routine) + 'UNUSED LABEL "'     + labels_found[i].name + '" in ' + data.decl.name
					lint_add_msg, data, noligne=0L,                        'UNUSED LABEL ', '"' + labels_found[i].name + '"'
				END
			END
		END
	END

	IF PTR_VALID(data.labels_found) THEN BEGIN
		data.decls[data.nor].labels_found = STRJOIN((*data.labels_found).name, ' ')
		PTR_FREE, data.labels_found
	END
	IF PTR_VALID(data.labels_used)  THEN PTR_FREE, data.labels_used

END

;-------------------------------------------------------------------------------
PRO rajouter_lignes,	$
;-------------------------------------------------------------------------------
	nom,		$	; LINT_PROTOTYPE input
	lignes,		$	; LINT_PROTOTYPE output
	nblignes,	$	; LINT_PROTOTYPE output
	data=data		; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Lit le fichier nom et met a jour le tableau de lignes et le nombre de lignes.
;-------------------------------------------------------------------------------

	MAX = 20000

	isC = STRMID(nom, STRLEN(nom)-2, 2) EQ '.c' OR STRMID(nom, STRLEN(nom)-2, 2) EQ '.h'

	lignes = REPLICATE ('', MAX)
	nblignes = 0L

	; Lecture de lignes, en supprimant les commentaires
	ligne = ''
	OPENR, fd, nom, /GET_LUN
	noligne = 0L
	WHILE ~EOF(fd) DO BEGIN	
		noligne++

		READF, fd, ligne

		IF ~isC THEN BEGIN
			LINTC_SUPPRIMER_COMMENTAIRES_IDL, ligne
			code = LINTC_GET_CORRECT_LINE (ligne)
			IF code NE '' THEN BEGIN
				IF N_ELEMENTS(data) NE 0 THEN BEGIN
					my_print_msg, data, lint_get_message(module=nom, noligne=noligne) + code
					nos = WHERE (data.decls.module EQ nom)
					IF N_ELEMENTS(nos) EQ 1 THEN BEGIN
						no = nos[0]
					END ELSE BEGIN
						; ok mais dans quelle FUNCTION/PRO ?
						no = -1
						FOR i=0L,N_ELEMENTS(nos)-1 DO BEGIN
							debut = data.decls[nos[i]].noligne1
							fin = data.decls[nos[i]].noligne2 + 1 + data.decls[nos[i]].nblignes
							IF noligne GE debut && noligne LE fin THEN BEGIN
								no = nos[i]
								BREAK
							END
						END
					END
					IF no NE -1 THEN lint_add_msg, data, noligne=noligne, nor=no, code, ''
				END
				LINTC_SUPPRIMER_COMMENTAIRES_IDL, ligne
			END
		END
		IF nblignes EQ MAX THEN BEGIN
			; doubler le nombre de lignes MAX
			tmp = lignes
			MAX *= 2
			lignes = REPLICATE ('', MAX)
			lignes[0:nblignes-1] = tmp
			tmp = 0 ; supprimer tmp
		END
		lignes[nblignes++] = ligne
	END
	FREE_LUN, fd

END

;-------------------------------------------------------------------------------
PRO lint_pass2,		$
;-------------------------------------------------------------------------------
	liste,		$	; LINT_PROTOTYPE input
	decls,		$	; LINT_PROTOTYPE input
	hash			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Seconde passe: analyse du code en dtail.
;-------------------------------------------------------------------------------

	my_print, ''
	my_print, '------'
	my_print, 'pass#2'
	my_print, '------'
	my_print, ''

	vars_init = [	{ name:'!c',			categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!cpu',			categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!d',			categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!dir',			categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!dlm_path',		categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!dpi',			categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!dtor',			categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!edit_input',		categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!err',			categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!error',		categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!err_string',		categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!error_state',		categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!except',		categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!help_path',		categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!journal',		categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!make_dll',		categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!map',			categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!more',			categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!mouse',		categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!order',		categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!p',			categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!path',			categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!pi',			categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!prompt',		categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!quiet',		categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!radeg',		categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!stime',		categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!values',		categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!version',		categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!warn',			categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!x',			categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!y',			categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'!z',			categorie: 'system',		contexte: '',	nb_use:0L },	$
			{ name:'self',			categorie: 'system',		contexte: '',	nb_use:0L }	$
	]

	;top1 = nbsec()

	; chercher dans le champ code s'il y a des instructions DEFSYSV, '!nom' qui dfinissent des variables
	; mettre ces variables dans symboles
	table_symboles = ['']
	FOR i=0L,N_ELEMENTS(decls)-1 DO BEGIN

		code = STRUPCASE(decls[i].code_nocomment)

		motif = 'DEFSYSV'
		len = STRLEN(motif)
		pos = 0L
		WHILE 1 DO BEGIN

			pos = STRPOS(code, motif, pos)
			IF pos EQ -1 THEN BREAK
			pos += len

			; sauter SPACE et TAB
			WHILE 1 DO BEGIN
				c = STRMID(code, pos, 1)
				IF c NE ' ' && c NE STRING(9b) THEN BREAK
				pos++
			END

			; a t-on , ?
			c = STRMID(code, pos, 1)
			IF c NE ',' THEN BREAK
			pos++

			; sauter SPACE et TAB
			WHILE 1 DO BEGIN
				c = STRMID(code, pos, 1)
				IF c NE ' ' && c NE STRING(9b) THEN BREAK
				pos++
			END

			; a t-on ' ou " ?
			c = STRMID(code, pos, 1)
			IF c NE "'" AND c NE '"' THEN BREAK
			pos++

			; a t-on ! ?
			c = STRMID(code, pos, 1)
			IF c NE "!" THEN BREAK
			pos++

			symbole = '!'
			WHILE 1 DO BEGIN
				c = STRMID(code, pos, 1)
				IF c EQ "'" OR c EQ '"' THEN BREAK
				symbole += c
				pos++
			END

			symbole = STRUPCASE(symbole)
			IF (WHERE(table_symboles EQ symbole))[0] EQ -1 THEN BEGIN
				table_symboles = [ table_symboles, symbole ]
					my_print, lint_get_message(module=decls[i].module) + 'FOUND SYSTEM VARIABLE "' + symbole + '" in ' + decls[i].name
			END

		END

	END

	FOR i=0L,N_ELEMENTS(table_symboles)-1 DO BEGIN
		IF table_symboles[i] EQ '' THEN CONTINUE
		vars_init = [ vars_init, { name:table_symboles[i], categorie: 'system', contexte: '', nb_use:0L } ]
	END

	;top2 = nbsec()
	;my_print, 'SYSTEM VARIABLES in ' + val_to_str_2decimales(top2-top1)+' sec'

	data = { 	line:		'',			$
			cla_on:		0,			$	; 1 pour crire dans le champ "cla" de la routine
			msg_on:		0,			$	; 1 pour crire dans le champ "msg" de la routine
			noline:		PTR_NEW(),		$
			nochar:		PTR_NEW(),		$
			pos:		0L,			$
			decls:		decls,			$
			nb_decls:	N_ELEMENTS(decls),	$	; pour obtenir rapidement le nombre de decls (car N_ELEMENTS(data.decls) est trs lent)
			decl:		decls[0],		$
			nor:		0L,			$	; numro de la routine que l'on est en train d'analyser
			vars:		PTR_NEW(),		$	; variables utilises dans la routine:
									;	categorie= 'system' :		variables systemes (commencent par !)
									;	categorie= 'param'  :		variables trouves dans le prototype
									;	categorie= 'keyword':		keywords trouvs dans le prototype
									;	categorie= 'local_en_cours':	variables trouves avant signe '='
									;	categorie= 'local': 		variables 'local_en_cours' une fois finalises (aprs THEN BEGIN ELSE FO fin_de_ligne)
									;	categorie= 'para_en_cours':	variables crs lors d'appel de FUNC/PRO
									;	categorie= 'para': 		variables 'para_en_cours' une fois finalises (aprs l'appel de la FUNC/PRO)
			vars_undefined:	'',			$	; variables non dfinies mais utilises
			labels_used:	PTR_NEW(),		$	; tableau de labels utiliss dans les appels { name:'', noline:0L }
			labels_found:	PTR_NEW(),		$	; tableau de labels trouvs { name:'', noline:0L }
			instance:	'',			$
			statement:	'',			$
			for_variable:	'',			$	; nom de la variable de boucle FOR
			pile:		'',			$	; pile for instruction 'FOR', 'WHILE', 'IF', ...
			hash:		hash 			$
	}

	FOR i=0L,N_ELEMENTS(liste)-1 DO BEGIN

		; pour chaque fichier source

		;IF liste[i].filename NE 'pro/cl_msg.pro' THEN CONTINUE

		; pour Berkeley spdsoft
		;IF common_lint_infos.target NE 'cl' THEN my_print, ''
		;IF common_lint_infos.target NE 'cl' THEN my_print, 'pass#2 ' + LINTC_INT_TO_STR(i+1) + '/' + LINTC_INT_TO_STR(N_ELEMENTS(liste)) + ' ' + liste[i].filename

		
		; Lecture de lignes, en supprimant les commentaires
		data.msg_on = 1 ; pour voir les messages INCORRECT LINE
		data.cla_on = 1
		rajouter_lignes, liste[i].filename, lignes, nblignes, data=data

		IF nblignes EQ 0 THEN CONTINUE

		IF !DEBUG THEN my_print, liste[i].filename

		; pour chaque FUNCTION/PRO
		ind = WHERE (decls.module EQ liste[i].filename)
		IF ind[0] NE -1 THEN BEGIN
			FOR j=0L,N_ELEMENTS(ind)-1 DO BEGIN	

				data.decl = decls[ind[j]]
				data.nor = ind[j]

				IF liste[i].is_c THEN BEGIN

					IF data.decl.function_pro EQ 'GLOBALC' THEN BEGIN
						lignes_globalc = STRSPLIT(data.decl.code, STRING(10b), /PRESERVE_NULL, /EXTRACT)
					END

					FOR k=data.decl.noligne1-1,data.decl.noligne1-1+data.decl.nblignes-1 DO BEGIN
						data.line = data.decl.function_pro EQ 'GLOBALC' ? lignes_globalc[k] : lignes[k]
						data.pos = 0
						len = STRLEN(data.line)
						IF len GT 0 THEN data.noline = PTR_NEW(REPLICATE(k+1, len))
						IF len GT 0 THEN data.nochar = PTR_NEW(LINDGEN(len))
						lint_traiter_lignec, data
						PTR_FREE, data.noline
						PTR_FREE, data.nochar
					END
					; Redimensionner data.decls[ind[j]].cla
					nb = data.decls[ind[j]].nbclas
					IF nb EQ 0 THEN nb = 1
					tmp = *data.decls[ind[j]].cla
					tmp = tmp[0:nb-1]
					PTR_FREE, data.decls[ind[j]].cla
					data.decls[ind[j]].cla = PTR_NEW(tmp, /NO_COPY)
					CONTINUE
				END


				IF data.decl.nblignes EQ 0 THEN CONTINUE ; arrive avec "spedas/gui/Resources/findme.pro"

				vars = vars_init
				IF data.decl.lint_variables NE '' THEN BEGIN
					; rajouter les variables LINT
					tmp = STRSPLIT(data.decl.lint_variables, /EXTRACT)
					FOR k=0L,N_ELEMENTS(tmp)-1 DO BEGIN
						var = { name:tmp[k], categorie: 'local', contexte: '',	nb_use:1L }
						vars = [ vars , var ]
					END
				END
				data.vars = PTR_NEW(vars)
				data.vars_undefined = ''
				data.cla_on = 1 ; pour coloriser
				data.msg_on = 1 ; pour indiquer les erreurs et les warnings
				lint_plus, lignes[data.decl.noligne1-1 : data.decl.noligne1-1+data.decl.nblignes-1], data

				IF data.vars_undefined NE '' THEN BEGIN
					vars_undefined = STRSPLIT (data.vars_undefined, /EXTRACT)
					vars = *data.vars
					vars_names = STRUPCASE((*data.vars).name)
					FOR k=0L,N_ELEMENTS(vars_undefined)-1 DO BEGIN
						tmp = WHERE (vars_names EQ STRUPCASE(vars_undefined[k]))
						IF tmp[0] EQ -1 THEN BEGIN
							my_print_msg, data, lint_get_message(data, /routine) + 'VARIABLE USED BUT NOT DEFINED "'    + vars_undefined[k] + '" in ' + data.decl.name
							lint_add_msg, data, noligne=0L,                        'VARIABLE USED BUT NOT DEFINED', '"' + vars_undefined[k] + '"'
						END
					END
				END

				IF PTR_VALID(data.vars) THEN BEGIN
					ind1 = WHERE ((*data.vars).categorie EQ 'common')
					IF ind1[0] NE -1 THEN data.decls[ind[j]].vars_common = STRJOIN((*data.vars)[ind1].name, ' ')
					ind1 = WHERE ((*data.vars).categorie EQ 'para')
					IF ind1[0] NE -1 THEN data.decls[ind[j]].vars_para = STRJOIN((*data.vars)[ind1].name, ' ')
					ind1 = WHERE ((*data.vars).categorie EQ 'local' AND (*data.vars).contexte NE 'FOR=')
					IF ind1[0] NE -1 THEN data.decls[ind[j]].vars_local = STRJOIN((*data.vars)[ind1].name, ' ')
					ind1 = WHERE ((*data.vars).categorie EQ 'local' AND (*data.vars).contexte EQ 'FOR=')
					IF ind1[0] NE -1 THEN data.decls[ind[j]].vars_local_for = STRJOIN((*data.vars)[ind1].name, ' ')
					PTR_FREE, data.vars
				END

				; Redimensionner data.decls[ind[j]].cla
				nb = data.decls[ind[j]].nbclas
				IF nb EQ 0 THEN nb = 1
				tmp = *data.decls[ind[j]].cla
				tmp = tmp[0:nb-1]
				PTR_FREE, data.decls[ind[j]].cla
				data.decls[ind[j]].cla = PTR_NEW(tmp, /NO_COPY)

			END
		END
	END

	decls = data.decls ; pour rcupercuter les modifs sur nb_use et msg par exemple

END

;-------------------------------------------------------------------------------
PRO lint_get_numbers_of_lines,	$
;-------------------------------------------------------------------------------
	liste			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Dtermine le nombre de lignes.
;-------------------------------------------------------------------------------

	COMMON COMMON_LINT, common_lint_infos

	my_print, ''
	my_print, '--------------------'
	my_print, 'get_numbers_of_lines'
	my_print, '--------------------'

	ligne = ''

	FOR i=0L,N_ELEMENTS(liste)-1 DO BEGIN

		langage = liste[i].is_c ? 'C' : 'IDL'

		IF langage EQ 'C' THEN BEGIN

			; Compter le nombre de lignes pour obtenir:
			; - common_lint_infos.total_nblignes_C_code
			; - common_lint_infos.total_nblignes_C_all

			nblignes = 0L
			OPENR, fd, liste[i].filename, /GET_LUN
			WHILE ~EOF(fd) DO BEGIN	

				READF, fd, ligne
				ligne_nocomment = lint_supprimer_commentaire_c (ligne)

				IF ligne_nocomment NE '' THEN common_lint_infos.total_nblignes_C_code++
				nblignes++
			END
			FREE_LUN, fd
			common_lint_infos.total_nblignes_C_all += nblignes

		END ELSE BEGIN

			; Compter le nombre de lignes pour obtenir:
			; - common_lint_infos.total_nblignes_IDL_interne_code
			; - common_lint_infos.total_nblignes_IDL_externe_code
			; - common_lint_infos.total_nblignes_IDL_other_code
			; - common_lint_infos.total_nblignes_IDL_code
			; - common_lint_infos.total_nblignes_IDL_interne_all
			; - common_lint_infos.total_nblignes_IDL_externe_all
			; - common_lint_infos.total_nblignes_IDL_other_all
			; - common_lint_infos.total_nblignes_IDL_all

			nblignes = 0L
			OPENR, fd, liste[i].filename, /GET_LUN
			WHILE ~EOF(fd) DO BEGIN	

				READF, fd, ligne

				LINTC_SUPPRIMER_COMMENTAIRES_IDL, ligne
				nblignes++
				IF ligne NE '' THEN BEGIN
					IF liste[i].is_cl_interne THEN common_lint_infos.total_nblignes_IDL_interne_code++
					IF liste[i].is_cl_externe THEN common_lint_infos.total_nblignes_IDL_externe_code++
					IF liste[i].is_cl_other   THEN common_lint_infos.total_nblignes_IDL_other_code++
					common_lint_infos.total_nblignes_IDL_code++
				END
			END
			FREE_LUN, fd
			IF liste[i].is_cl_interne THEN common_lint_infos.total_nblignes_IDL_interne_all += nblignes
			IF liste[i].is_cl_externe THEN common_lint_infos.total_nblignes_IDL_externe_all += nblignes
			IF liste[i].is_cl_other   THEN common_lint_infos.total_nblignes_IDL_other_all += nblignes
			common_lint_infos.total_nblignes_IDL_all += nblignes

		END

	END

END

;-------------------------------------------------------------------------------
FUNCTION lint_get_list,	$
;-------------------------------------------------------------------------------
	filenames		; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne une tableau de structure avec les noms de modules a analyser.
;-------------------------------------------------------------------------------

	var = { type,						$
			filename:		"",		$
			check_syntax:		0,		$
			check_space:		0,		$	; pour vrifier que les arguments sont spars par des espaces
			check_case_sensitive:	0,		$
			check_unused:		0,		$
			check_stop_debug:	0,		$
			check_doc:		0,		$
			is_cl_interne:		0,		$
			is_cl_externe:		0,		$
			is_cl_other:		0,		$
			is_C:			0,		$
			lignes:			PTR_NEW(),	$
			include_dir:		""		}

	IF filenames[0] NE "" THEN BEGIN

		; filenames donns dans la ligne de commande

		; que l'on trie sinon on ne comprend pas bien la logique de l'ordre d'affichage
		filenames = filenames[SORT(filenames)]

		; supprimer l'excutable de la SOLARSOFT
		filenames = filenames[WHERE(filenames NE 'gen/idl/system/gzip_exe.pro')]

		liste = REPLICATE (var, N_ELEMENTS(filenames))
		liste.filename = filenames
		liste.is_c = STRMID(filenames, 1, 2, /REVERSE_OFFSET) EQ '.c' OR STRMID(filenames, 1, 2, /REVERSE_OFFSET) EQ '.h'

	END ELSE BEGIN

		I1 = 'CLUSTER/SOFT/CLL3/inc /home/penou/DATA/CLUSTER/SOFT/CDFLIB/cdf34_1-dist/include /home/penou/DATA/CLUSTER/SOFT/ZLIB /usr/local/rsi/idl_6.3/external'

		I2 = 'CLUSTER/SOFT/LIB/inc CLUSTER/SOFT/CALIB/inc /usr/local/rsi/idl_6.3/external'

		I3 = 'DOUBLE_STAR/SOFT/LIB/inc DOUBLE_STAR/SOFT/CALIB/inc usr/local/rsi/idl_6.3/external'

		liste = [	$

			;										check	check	check	check	check
			;	filename								syntax	space	case	unused	stop	doc	is_cl	is_cl	is_cl	is_C	lignes		include_dir
			;												sensi		debug		interne	externe	other
			;												tive	

			; les librairies
			{ type, 'CLUSTER/SOFT/CLL3/pro/libidl.pro',					1,	1,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/libplot.pro',					1,	1,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/libascii.pro',					1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/libcdf.pro',					1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/libnetcdf.pro',					1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/libxml.pro',					1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$

			; puis les modules non objets pour cl, dont il faut vrifier l'ordre de dclarations des routines
			{ type, 'CLUSTER/SOFT/CLL3/pro/libcl.pro',					1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/file_http_copy.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/cw_form_new.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/compute_orbito.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/compute_title.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/compute_timeseries.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/compute_count3d.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/cl.pro',						1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/clvm.pro',					1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/clweb.pro',					1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$

			; puis les objets: pas besoin de vrifier l'ordre de dclarations des mthodes (il n'y a pas d'erreur en IDL si l'ordre n'est pas le bon)

			; objets fenetres
			{ type, 'CLUSTER/SOFT/CLL3/pro/fen__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/fenetre__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/fenetre_axex__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/fenetre_axey__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/fenetre_courbe__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/fenetre_image__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/fenetre_orbito__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/fenetre_palette__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/fenetre_showdir__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/fenetre_texte__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/fenetre_timeaxis__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$

			; objets utiliss dans compute_timeseries et compute_count3d
			{ type, 'CLUSTER/SOFT/CLL3/pro/courbe__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/spectro__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$

			; classe mres
			{ type, 'CLUSTER/SOFT/CLL3/pro/obj__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/orbitogen__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/timeseries__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$

			; objets cres dans l'initialisation de cl
			{ type, 'CLUSTER/SOFT/CLL3/pro/general__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/cache__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/pal__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/global__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/printer__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/add__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/device__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/graphics__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/calculator__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/productsinfo__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/compress__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/schemas__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/doc__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/tree__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/para__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/produit__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$


			; objets graphiques que l'on peut ajouter n'importe o
			{ type, 'CLUSTER/SOFT/CLL3/pro/container__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/text__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/image__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/animation__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/line__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exemple__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$

			; objets graphiques que l'on peut ajouter  un panel composer
			{ type, 'CLUSTER/SOFT/CLL3/pro/count3d__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/count2d__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/header__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/vb__define.pro',					1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/current__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/currentie__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/gradpressmom__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/lawohm__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/oh__define.pro',					1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/orbite__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/ascii__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/cdf__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/title__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/copyright__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/orbito__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$

			; objets exp
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_ace__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_ascii__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_aspera3_els__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_aspera3_ima__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_aspera3_npd1__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_aspera3_npd2__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_aspera3_npi__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_aspera3_oth__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_aspera4_els__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_aspera4_ima__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_aspera4_npd1__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_aspera4_npd2__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_aspera4_npi__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_aspera4_oth__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_aspera4_mag1sec__define.pro',		1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_bepi_mea1__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_bepi_mea2__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_mpo_mag__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_bepi_mag__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_bepi_hk__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_bepi_ephemeris__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_bepi_msa__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_bepi_ena__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_bepi_mia__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_cdf__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_change2__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_cluster_codif__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_cluster_hia__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_cluster_oth__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_cluster_peace__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_demeter_ice__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_demeter_idp__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_demeter_imsc__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_demeter_isl__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_demeter_mag__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_dsp__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_dsp_oth__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_geotail__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_goes__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_imp8__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_indices__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_interball_elec1ch1__define.pro',		1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_interball_elec1ch2__define.pro',		1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_interball_elec2ch1__define.pro',		1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_interball_elec2ch2__define.pro',		1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_interball_electron__define.pro',		1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_interball_fm3i__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_interball_imap3__define.pro',		1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_interball_ion1ch1__define.pro',		1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_interball_ion1ch2__define.pro',		1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_interball_ion2ch1__define.pro',		1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_interball_ion2ch2__define.pro',		1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_interball_mifm__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_isee__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_jason3_ephemeris__define.pro',		1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_jason3_ambre__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_juno_ephemeris__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_juno_jadee__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_juno_jadei__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_juno_mag__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_mms_des__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_mms_dfg__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_mms_dis__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_mms_mec__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_mms_fpi__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_mms_edi__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_mms_edp__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_mms_feepse__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_mms_feepsi__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_mms_fgm__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_mms_hpca__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_mms_eis__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_mms_scm__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_mms_aspoc__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_mms_dsp__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_lightning__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_map__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_maven_ephemeris__define.pro',		1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_maven_mag__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_maven_models__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_maven_static__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_maven_swea__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_maven_swia__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_maven_lpw__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_maven_sep__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_maven_kp__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_maven_ngi__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_maven_euv__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_mgs__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_omni__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_plugin_caa__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_plugin_csa__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_poesn17__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_psp_spa__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_psp_spb__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_psp_spc__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_psp_spi__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_psp_mag__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_psp_formagonly__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_psp_kp__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_psp_spe__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_psp_ephemeris__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_rosina_cops__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_rosina_rtof__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_sacc__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_solar_pas__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_solar_mag__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_solar_formagonly__define.pro',		1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_solar_ephemeris__define.pro',		1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_stereo_let__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_stereo_plastic__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_stereo_sept__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_stereo_sit__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_stereo_ste__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_stereo_swea__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_taranis_ideen__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_taranis_ideez__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_taranis_xgre__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_taranis_ephemeris__define.pro',		1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_themis_eesa__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_themis_efi__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_themis_esst__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_themis_fbk__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_themis_fgm__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_themis_iesa__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_themis_isst__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_themis_oth__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_themis_scm__define.pro',			1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_wind__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/exp_xmm__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$

			{ type, 'CLUSTER/SOFT/CLL3/pro/tev__define.pro',				1,	0,	1,	1,	1,	1,	1,	0,	0,	0,	PTR_NEW(),	''	 },	$

			; modules de test 
			{ type, 'CLUSTER/SOFT/CLL3/pro/test_libidl.pro',				1,	0,	1,	1,	0,	1,	0,	0,	0,	0,	PTR_NEW(),	''	 },	$

			; modules externes  cl
			{ type, 'CLUSTER/SOFT/CLL3/pro/get_cldataset_starttime_endtime.pro',		1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/get_arbres_cl.pro',				1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/get_arbre_amda_clweb.pro',			1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/get_arbre_caa.pro',				1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/get_arbre_csa.pro',				1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/get_arbre_cdaweb.pro',				1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/get_arbre_impex.pro',				1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/get_arbre_plugin_caa.pro',			1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/aspera3_imaextra.pro',				1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/aspera3_imaparam.pro',				1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/aspera4_imaextra.pro',				1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/aspera4_imaparam.pro',				1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/stereo_mag_cdf2cef.pro',				1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/traiter_dst_quicklook.pro',			1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/traiter_change2.pro',				1,	0,	1,	1,	0,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/wget.pro',					1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/soap.pro',					1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/webservice.pro',					1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/lint.pro',					1,	1,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/cluster.pro',					1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/get_moments_swea.pro',				1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/get_pitch90_swea.pro',				1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/go_moments_swea.pro',				1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/pro/go_pitch90_swea.pro',				1,	0,	1,	1,	1,	1,	0,	1,	0,	0,	PTR_NEW(),	''	 },	$

			; modules en C
			{ type, 'CLUSTER/SOFT/CLL3/src/conf_borland.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/DSP_EXTERNAL.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I3	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/EXTERNAL.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I2	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/f2c.c',						0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/file.c',						0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/filecdf.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/get_data3d.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/interpoler2d_points.c',				0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/interpoler2dxy.c',				0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/interpoler2dy.c',				0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/libascii.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/libxml.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/lint.c',						0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglibc.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_geodip.c',				0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_geogsm.c',				0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_inigeo1.c',				0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_julg.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_promal.c',				0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_promat.c',				0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_rogdip.c',				0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_roggsm.c',				0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_rogse.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_rogsm.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_roig.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_roise.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_rosmgs.c',				0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_segeo.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_solter00.c',				0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_solter05.c',				0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_solter10.c',				0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_sun.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_util2_com.c',				0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_util_com.c',				0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/maglib_valfix.c',				0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/noninterpoler2d.c',				0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/rocotlibc.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/util.c',						0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/write_ascii.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/src/my_plplot.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I1	 },	$

			{ type, 'CLUSTER/SOFT/LIB/src/ARCH.c',						0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I2	 },	$
			{ type, 'CLUSTER/SOFT/LIB/src/ERRORS.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I2	 },	$
			{ type, 'CLUSTER/SOFT/LIB/src/FILES.c',						0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I2	 },	$
			{ type, 'CLUSTER/SOFT/LIB/src/HEADER.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I2	 },	$
			{ type, 'CLUSTER/SOFT/LIB/src/INTERFACE.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I2	 },	$
			{ type, 'CLUSTER/SOFT/LIB/src/LISTS.c',						0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I2	 },	$
			{ type, 'CLUSTER/SOFT/LIB/src/MATHS.c',						0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I2	 },	$
			{ type, 'CLUSTER/SOFT/LIB/src/SYMBOLS.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I2	 },	$
			{ type, 'CLUSTER/SOFT/LIB/src/TIMES.c',						0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I2	 },	$
			{ type, 'CLUSTER/SOFT/LIB/src/ZZLIB.c',						0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I2	 },	$

			{ type, 'CLUSTER/SOFT/CALIB/src/CALIB.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I2	 },	$
			{ type, 'CLUSTER/SOFT/CALIB/src/CATALOG.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I2	 },	$

			{ type, 'DOUBLE_STAR/SOFT/LIB/src/ARCH.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I3	 },	$
			{ type, 'DOUBLE_STAR/SOFT/LIB/src/ERREURS.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I3	 },	$
			{ type, 'DOUBLE_STAR/SOFT/LIB/src/FILES.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I3	 },	$
			{ type, 'DOUBLE_STAR/SOFT/LIB/src/HEADER.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I3	 },	$
			{ type, 'DOUBLE_STAR/SOFT/LIB/src/INTERFACE.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I3	 },	$
			{ type, 'DOUBLE_STAR/SOFT/LIB/src/LISTS.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I3	 },	$
			{ type, 'DOUBLE_STAR/SOFT/LIB/src/MATHS.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I3	 },	$
			{ type, 'DOUBLE_STAR/SOFT/LIB/src/SYMBOLS.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I3	 },	$
			{ type, 'DOUBLE_STAR/SOFT/LIB/src/TIMES.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I3	 },	$

			{ type, 'DOUBLE_STAR/SOFT/CALIB/src/CALIB.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I3	 },	$
			{ type, 'DOUBLE_STAR/SOFT/CALIB/src/HIA.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I3	 },	$
			{ type, 'DOUBLE_STAR/SOFT/CALIB/src/HSK.c',					0,	0,	0,	0,	0,	0,	0,	0,	0,	1,	PTR_NEW(),	I3	 },	$

			; modules themispro
			{ type, 'CLUSTER/SOFT/CLL3/themispro/append_array.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/average.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/cotrans_lib.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/day_to_year_doy.pro',			0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/dimen.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/doy_to_month_date.pro',			0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/dprint.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/file_copy2.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/file_retrieve.pro',			0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/fill_nan.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/get_thm_esa_cal.pro',			0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/interp.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/isdaylightsavingtime.pro',			0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/minjmin.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/minmax.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/ndimen.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/printdat.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/ptrace.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/str2time.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/strfilter.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/thm_esa_energy_steps.pro',			0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/thm_load_esa_cal.pro',			0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/thm_read_eesa_angle_reduced_mode.pro',	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/thm_read_esa_angle_burst_mode.pro',	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/thm_read_esa_angle_full_mode.pro',		0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/thm_read_esa_sweep_burst_mode.pro',	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/thm_read_esa_sweep_full_mode.pro',		0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/thm_read_esa_sweep_reduced_mode.pro',	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/thm_read_iesa_angle_reduced_mode.pro',	0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/time_double.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/time_string.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/themispro/time_struct.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$

			; modules libpro
			{ type, 'CLUSTER/SOFT/CLL3/libpro/nwin.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/pmod.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/strsub.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/strep.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/nearest.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/inrange.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/xprint.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/ver.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/tnaxes.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/sechms.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/jd2ymd.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/ymd2dn.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/weekday.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/stress.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/repchr.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/monthnames.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/monthdays.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/makei.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/dt_tm_mak.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/jdselect.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/jd2mdays.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/time_label.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/makex.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/getwrd.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/timeaxis.pro',				0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 },	$
			{ type, 'CLUSTER/SOFT/CLL3/libpro/ymd2jd.pro',					0,	0,	0,	0,	0,	0,	0,	0,	1,	0,	PTR_NEW(),	''	 }	$

		]

	END

	RETURN, liste

END

;-------------------------------------------------------------------------------
FUNCTION lint_check_mot,	$
;-------------------------------------------------------------------------------
	mot			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne 1 si mot ne contient que des '_', '0..9' 'A..Z'
;-------------------------------------------------------------------------------

	FOR l=0L,STRLEN(mot)-1 DO BEGIN
		c = STRMID(mot, l, 1)
		IF (c EQ '_') || (c GE '0' && c LE '9') || (c GE 'A' && c LE 'Z') THEN BEGIN
		END ELSE BEGIN
			IF STRMID (mot, l) EQ '[not_found_in_v6.3_documentation_but_OK]' THEN BEGIN
				RETURN, 1
			END ELSE BEGIN
				RETURN, 0
			END
		END
	END

	RETURN, 1

END

;-------------------------------------------------------------------------------
PRO lint_ajouter_hash,	$
;-------------------------------------------------------------------------------
	decls,		$	; LINT_PROTOTYPE input
	i,		$	; LINT_PROTOTYPE input
	hash			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Rajoute decls[i].name  la table hash.name, decls[i].object  la table hash.object et decls[i].module  la table hash.module.
;-------------------------------------------------------------------------------

	cle = (BYTE(STRMID(decls[i].name, 0, 1)))[0]
	IF PTR_VALID(hash.name[cle]) THEN BEGIN
		ind = [ *hash.name[cle] , i]
		PTR_FREE, hash.name[cle]
	END ELSE BEGIN
		ind = i
	END
	hash.name[cle] = PTR_NEW(ind)

	cle = (BYTE(STRMID(decls[i].object, 0, 1)))[0]
	IF PTR_VALID(hash.object[cle]) THEN BEGIN
		ind = [ *hash.object[cle] , i]
		PTR_FREE, hash.object[cle]
	END ELSE BEGIN
		ind = i
	END
	hash.object[cle] = PTR_NEW(ind)

	cle = (BYTE(STRMID(decls[i].module, 0, 1)))[0]
	IF PTR_VALID(hash.module[cle]) THEN BEGIN
		ind = [ *hash.module[cle] , i]
		PTR_FREE, hash.module[cle]
	END ELSE BEGIN
		ind = i
	END
	hash.module[cle] = PTR_NEW(ind)

END

;-------------------------------------------------------------------------------
PRO str_to_get_set_init,	$
;-------------------------------------------------------------------------------
	var_get,		$	; LINT_PROTOTYPE output
	var_set,		$	; LINT_PROTOTYPE output
	var_init,		$	; LINT_PROTOTYPE output
	str				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Cre les variables var_get, var_set et var_init  partir de str.
;-------------------------------------------------------------------------------
	; str contient 'NOM1:xyz NOM2:xyz ...'
	; Il faut mettre dans var_get  les noms dont le x vaut 1
	; Il faut mettre dans var_set  les noms dont le y vaut 1
	; Il faut mettre dans var_init les noms dont le z vaut 1

	var_get  = ''
	var_set  = ''
	var_init = ''

	tmp1 = STRSPLIT (str, /EXTRACT)
	FOR i=0L,N_ELEMENTS(tmp1)-1 DO BEGIN
		tmp2 = STRSPLIT(tmp1[i], ':', /EXTRACT)
		nom = tmp2[0]
		is_get  = STRMID (tmp2[1], 0, 1) EQ '1'
		is_set  = STRMID (tmp2[1], 1, 1) EQ '1'
		is_init = STRMID (tmp2[1], 2, 1) EQ '1'
		IF is_get  THEN var_get  += '/' + nom + ':output '
		IF is_set  THEN var_set  += '/' + nom + ':input '
		IF is_init THEN var_init += '/' + nom + ':input '
	END

END


;-------------------------------------------------------------------------------
PRO lint_add_system_routines,	$
;-------------------------------------------------------------------------------
	decls,				$	; LINT_PROTOTYPE output
	hash					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Rajoute dans decls les fonction systeme et les librairies externes (CSPICE, GEOPACK, ...)
;-------------------------------------------------------------------------------

	decl = {						$
		module:			"",			$	; nom du module (.pro)
		is_system:		0L,			$	; 1 si le module est SYSTEM, 0 sinon
		is_extern:		0L,			$	; 1 si la dclaration de la FUNCTIONC commence par "extern"
		function_pro:		"",			$	; "FUNCTION", "PRO", "INCLUDE", "FUNCTIONC", "MACROC"  ou "INCLUDEC"
		object:			"", 			$	; nom de l'objet ou ""
		inherits:		"", 			$	; noms des objets dont l'objet hrite
		inherits_full:		"", 			$	; noms des objets dont l'objet hrite aprs dveloppement rcursif
		name:			"",			$	; nom de la FUNCTION/PRO
		check_syntax:		0L,			$	; 1 si on doit vrifier la syntaxe
		check_space:		0L,			$	; 1 si on doit vrifier si les arguments sont spars par des espaces
		check_case_sensitive:	0L,			$	; 1 si on doit vrifier les CASE SENSITIVE
		check_unused:		0L,			$	; 1 si on doit indiquer:
									;	"VARIABLE SET BUT NOT USED"
									;	"UNUSED PARAM"
									;	"UNUSED KEYWORD"
									;	"UNUSED COMMON"
									;	"UNUSED LABEL"
		check_stop_debug:	0L,			$	; 1 si on doit vrifier qu'il n'y a pas de STOP ni de DEBUG
		check_doc:		0L,			$	; 1 si on doit vrifier la doc
		is_cl_interne:		0L,			$	; 1 si module interne de cl
		is_cl_externe:		0L,			$	; 1 si module externe de cl
		is_cl_other:		0L,			$	; 1 si module themis de cl
		is_c:			0L,			$	; 1 si la fonction est crite en C
		nblignes:		0L,			$	; nombre de lignes
		nblignes_doc:		0L,			$	; nombre de lignes de commentaires aprs la dclaration
		nbchars_doc:		0L,			$	; nombre de caractres dans la doc (autres que des SPACE TAB ';' ou '-')

		doc:			'',			$	; grosse ligne avec la doc
		code:			'',			$	; grosse ligne avec le code
		code_nocomment:		'',			$	; grosse ligne avec le code sans les commentaires

		noline_finished:	-1L,			$	; noligne ou RESTORE ou EXECUTE a t trouv en premier

		call:			'',			$	; numros des routines appelles
		calledby:		'',			$	; numros des routines qui appellent cette routine

		vars_common:		'',			$	; variables common
		vars_para:		'',			$	; variables para cres dynamiquement
		vars_local:		'',			$	; variables locales
		vars_local_for:		'',			$	; variables locales de boucle FOR
		labels_found:		'',			$	; labels trouvs

		noligne1:		0L,			$	; numro de ligne dbut de dclaration
		noligne2:		0L,			$	; numro de ligne fin de dclaration
		prototype:		"",			$	; liste des paramtres et keywords
		definition:		'',			$	; definition de la fonction donn sous forme d'une chaine de caractre
		first_plus:		-1L,			$	; numro de la premire dclaration possible en '+'
		last_plus:		-1L,			$	; numro de la dernire dclaration possible en '+'
		prototype_connu:	0L,			$	; 0 si un prototype dynamique n'"est pas encore connu (ex: CDF_ECOCH,a,... avec a variable connu)
		nb_prototypes:		0L,			$	; nombre de fois ou PROTOTYPE a t trouv
		lint_variables:		"",			$	; liste des variables dclares en commentaire
		params:			"",			$	; liste des params
		params_type:		"",			$	; type des params (input, output)
		params_extra:		"",			$	; type des extra (STRING, !STRING)
		keywords:		"",			$	; liste des keywords
		keywords_type:		"",			$	; type des keywords (input,output,unknow)
		nb_params_min:		0L,			$	; nombre de paramtres min de la FUNCTION/PRO
		nb_params_max:		0L,			$	; nombre de paramtres max de la FUNCTION/PRO
		nb_keywords:		0L,			$	; nombre de keywords de la FUNCTION/PRO
		nb_use:			0L,			$	; nomre de fois ou cette FUNCTION/PRO est appele
		keywords_used:		"",			$	; liste des keywords utiliss
		commons:		"",			$	; liste des commons

		nbclas:			0L,			$	; nombre d'lments dans cla
		cla:			PTR_NEW(),		$	; classe pour fichier html (mots cls, constantes, strings, liens vers routine, ...)
		msg:			'',			$	; warning et messages d'erreur
		c:			''			$	; infos pour fichier c (mots cls, constantes, strings, liens vers routine, ...)
	}

	decls = REPLICATE (decl, !MAX_ROUTINES)
	cla = REPLICATE ( { noline: 0L, nochar: 0L, type: '', word: '', extra: '', link: '' }, 100)
	FOR i=0L,N_ELEMENTS(decls)-1 DO BEGIN
		decls[i].cla = PTR_NEW(cla)
	END

	graphics_keywords = [																$
		[	"/BACKGROUND:input",		"CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_3DBOX PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],									$
		[	"/CHANNEL:input",		"ERASE TV TVSCL TVRD"],										$
		[	"/CHARSIZE:input",		"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE XYOUTS DENDRO_PLOT"],							$
		[	"/CHARTHICK:input",		"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE XYOUTS DENDRO_PLOT"],							$
		[	"/CLIP:input", 			"CONTOUR DRAW_ROI OPLOT PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO PLOTS POLYFILL SURFACE XYOUTS DENDRO_PLOT ERRPLOT"],					$
		[	"/COLOR:input", 		"AXIS CONTOUR DRAW_ROI ERASE OPLOT PLOT POLAR_CONTOUR PLOT_3DBOX VELOVECT PLOT_OI PLOT_IO PLOT_OO PLOTS POLYFILL SHADE_SURF SURFACE XYOUTS DENDRO_PLOT ERRPLOT"],		$
		[	"/DATA",			"AXIS CONTOUR CURSOR DRAW_ROI PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO PLOTS POLYFILL SHADE_SURF SURFACE TV TVSCL TVCRS XYOUTS DENDRO_PLOT ERRPLOT"],		$
		[	"/DEVICE",			"AXIS CONTOUR CURSOR DRAW_ROI PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO PLOTS POLYFILL SHADE_SURF SURFACE TV TVSCL TVCRS XYOUTS DENDRO_PLOT ERRPLOT"],		$
		[	"/FONT:input",			"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE XYOUTS DENDRO_PLOT"],							$
		[	"/LINESTYLE:input",		"DRAW_ROI POLYFILL OPLOT PLOT VELOVECT PLOT_3DBOX PLOT_OI PLOT_IO PLOT_OO PLOTS SURFACE DENDRO_PLOT ERRPLOT"],								$
		[	"/NOCLIP",			"CONTOUR DRAW_ROI OPLOT PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO PLOTS POLYFILL SURFACE XYOUTS DENDRO_PLOT ERRPLOT"],					$
		[	"/NODATA",			"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/NOERASE",			"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],									$
		[	"/NORMAL",			"AXIS CONTOUR CURSOR DRAW_ROI PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO PLOTS POLYFILL SHADE_SURF SURFACE TV TVSCL TVCRS XYOUTS DENDRO_PLOT ERRPLOT"],		$
		[	"/ORIENTATION:input",		"DRAW_ROI POLYFILL XYOUTS"],									$
		[	"/POSITION:input",		"CONTOUR MAP_SET PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/PSYM:input",			"DRAW_ROI OPLOT PLOT VELOVECT PLOT_OI PLOT_IO PLOT_OO PLOTS DENDRO_PLOT ERRPLOT"],									$
		[	"/SUBTITLE:input",		"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_3DBOX PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/SYMSIZE:input",		"DRAW_ROI OPLOT PLOT VELOVECT PLOT_OI PLOT_IO PLOT_OO PLOTS DENDRO_PLOT ERRPLOT"],									$
		[	"/T3D",				"AXIS CONTOUR DRAW_ROI MAP_SET OPLOT PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO PLOTS POLYFILL SHADE_SURF SURFACE TV TVSCL TVCRS XYOUTS DENDRO_PLOT ERRPLOT MAP_CONTINENTS MAP_GRID"],	$
		[	"/THICK:input",			"AXIS CONTOUR DRAW_ROI OPLOT PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO PLOTS POLYFILL SHADE_SURF SURFACE DENDRO_PLOT ERRPLOT"],					$
		[	"/TICKLEN:input",		"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/TITLE:input",			"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_3DBOX PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/{X|Y|Z}CHARSIZE:input",	"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/{X|Y|Z}GRIDSTYLE:input",	"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/{X|Y|Z}MARGIN:input",		"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/{X|Y|Z}MINOR:input",		"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/{X|Y|Z}RANGE:input",		"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/{X|Y|Z}STYLE:input",		"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/{X|Y|Z}THICK:input",		"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/{X|Y|Z}TICK_GET:output",	"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/{X|Y|Z}TICKFORMAT:input",	"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/{X|Y|Z}TICKINTERVAL:input",	"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/{X|Y|Z}TICKLAYOUT:input",	"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/{X|Y|Z}TICKLEN:input",	"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/{X|Y|Z}TICKNAME:input	",	"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/{X|Y|Z}TICKS:input",		"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/{X|Y|Z}TICKUNITS:input",	"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/{X|Y|Z}TICKV:input",		"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/{X|Y|Z}TITLE:input",		"AXIS CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_3DBOX PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT"],							$
		[	"/{X|Y}TYPE:input",		"CONTOUR PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO"],							$
		[	"/Z:input",			"PLOTS POLYFILL TV TVSCL TVCRS XYOUTS ERRPLOT"],							$
		[	"/ZVALUE:input",		"AXIS CONTOUR MAP_SET OPLOT PLOT POLAR_CONTOUR VELOVECT PLOT_OI PLOT_IO PLOT_OO SHADE_SURF SURFACE DENDRO_PLOT MAP_CONTINENTS MAP_GRID"],						$

		; rajout pour Berkeley
		[	"/{X|Y|Z}TYPE:input",		"AXIS"]												]

	itool_common_keywords   	= "/ASPECT_RATION:input /ASPECT_Z:input /AXIS_STYLE:input /BACKGROUND_COLOR:input /CURRENT /CURRENT_ZOOM:input /DEPTHCUE_BRIGHT:input /DEPTHCUE_DIM:input /DEVICE /DIMENSIONS:input /DISABLE_SPLASH_SCREEN /FIT_TO_VIEW /FONT_COLOR:input /FONT_NAME:input /FONT_SIZE:input /FONT_STYLE:input /IDENTIFIER:output /LAYOUT:input /LOCATION:input /MACRO_NAMES:input /MARGIN:input /NAME:input /NO_SAVEPROMPT /NORMAL /OVERPLOT:input /POSITION:input /RENDERER:input /STRETCH_TO_FIT /STYLE_NAME:input /TITLE:input /VIEW_GRID:input /VIEW_NEXT /VIEW_NUMBER:input /VIEW_TITLE:input /VIEW_ZOOM:input /WINDOW_TITLE:input /{X|Y|Z}GRIDSTYLE:input /{X|Y|Z}MAJOR:input /{X|Y|Z}MINOR:input /{X|Y|Z}RANGE:input /{X|Y|Z}STYLE:input /{X|Y|Z}SUBTICKLEN:input /{X|Y|Z}TEXT_COLOR:input /{X|Y|Z}TEXTPOS:input /{X|Y|Z}TICKDIR:input /{X|Y|Z}TICKFONT_INDEX:input /{X|Y|Z}TICKFONT_SIZE:input /{X|Y|Z}TICKFONT_STYLE:input /{X|Y|Z}TICKFORMAT:input /{X|Y|Z}TICKINTERVAL:input /{X|Y|Z}TICKLAYOUT:input /{X|Y|Z}TICKLEN:input  /{X|Y|Z}TICKNAME:input /{X|Y|Z}TICKUNITS:input /{X|Y|Z}TICKVALUES:input /{X|Y|Z}TITLE:input /ZOOM_ON_RESIZE"
	itool_vector_keywords		= "/ARROW_STYLE:input /ARROW_THICK:input /AUTO_COLOR:input /AUTO_SUBSAMPLE /COLOR:input /DATA_LOCATION:input /DIRECTION_CONVENTION:input /GRID_UNITS:input /HEAD_ANGLE:input /HEAD_INDENT:input /HEAD_PROPORTIONAL /HEAD_SIZE:input /HIDE /LENGTH_SCALE:input /MARK_POINTS /MAX_VALUE:input /MIN_VALUE:input /RGB_TABLE:input /STREAMLINES /STREAMLINE_NSTEPS:input /STREAMLINE_STEPSIZE:input /SUBSAMPLE_METHOD:input /THICK:input /VECTOR_COLORS:input /VECTOR_STYLE:input /X_STREAMPARTICLES:input /X_SUBSAMPLE:input /Y_STREAMPARTICLES:input /Y_SUBSAMPLE:input /Z_VALUE:input"
	itool_image_keywords   		= "/ALPHA_CHANNEL:input /BLUE_CHANNEL:input /CHANNEL:input /GREEN_CHANNEL:input /IMAGE_DIMENSIONS:input /IMAGE_LOCATION:input /INTERPOLATE /ORDER /RED_CHANNEL:input"
	itool_contour_keywords 		= "/AM_PM:input /ANISOTROPY:input /C_COLOR:input /C_FILL_PATTERN:input /C_LABEL_INTERVAL:input /C_LABEL_NOGAPS:input /C_LABEL_OBJECTS:input /C_LABEL_SHOW:input /C_LINESTYLE:input /C_THICK:input /C_USE_LABEL_COLOR:input /C_USE_LABEL_ORIENTATION:input /C_VALUE:input /COLOR:input /DAYS_OF_WEEK:input /DEPTH_OFFSET:input /DOWNHILL /FILL /LABEL_FONT:input /LABEL_FORMAT:input /LABEL_FRMTDATA:input /LABEL_UNITS:input /MAX_VALUE:input /MIN_VALUE:input /MONTHS:input /N_LEVELS:input /PLANAR /RGB_INDICES:input /SHADE_RANGE:input /SHADING:input /TICKINTERVAL:input /TICKLEN:input /USE_TEXT_ALIGNMENTS:input"
	itool_axis_keywords		= "/{X|Y|Z}GRIDSTYLED:input"
	itool_map_projection_keywords	= "/CENTER_LATITUDE:input /CENTER_LONGITUDE:input /DATUM:input /FALSE_EASTING:input /FALSE_NORTHING:input /HEIGHT:input /HOM_AZIM_LONGITUDE:input /HOM_AZIM_ANGLE:input /HOM_LATITUDE1:input /HOM_LATITUDE2:input /HOM_LONGITUDE1:input /HOM_LONGITUDE2:input /IS_ZONES:input /IS_JUSTIFY:input /LIMIT:input /MERCATOR_SCALE:input /OEA_ANGLE:input /OEA_SHAPEM:input /OEA_SHAPEN:input /SEMIMAJOR_AXIS:input /SEMIMINOR_AXIS:input /SOM_INCLINATION:input /SOM_LONGITUDE:input /SOM_PERIOD:input /SOM_RATIO:input /SOM_FLAG:input /SOM_LANDSAT_NUMBER:input /SOM_LANDSAT_PATH:input /SPHERE_RADIUS:input /STANDARD_PARALLEL:input /STANDARD_PAR1:input /STANDARD_PAR2:input /TRUE_SCALE_LATITUDE:input /ZONE:input"
	itool_plot_keywords		= "/CLIP_PLANES:input /COLOR:input /ERRORBAR_COLOR:input /ERRORBAR_CAPSIZE:input /FILL_BACKGROUND /FILL_COLOR:input /FILL_LEVEL:input /HIDE /HISTOGRAM /LINESTYLE:input /MAX_VALUE:input /MIN_VALUE:input /NSUM:input /RGB_TABLE:input /SCATTER /SYM_COLOR:input /SYM_INCREMENT:input /SYM_INDEX:input /SYM_SIZE:input /SYM_THICK:input /THICK:input /TRANSPARENCY:input /USE_DEFAULT_COLOR /VERT_COLORS:input /XY_SHADOW /{X|Y|Z}_ERRORBARS /{X|Y|Z}_LOG /{X|Y|Z}ERROR:input /XZ_SHADOW /YZ_SHADOW"
	itool_surface_keywords		= "/BOTTOM:input /CLIP_PLANES:input /COLOR:input /DEPTH_OFFSET:input /EXTENDED_LEGO /HIDDEN_LINES /HIDE /LINESTYLE:input /RGB_TABLE:input /SHADING:input /SHOW_SKIRT /SKIRT:input /STYLE:input /TEXTURE_ALPHA:input /TEXTURE_BLUE:input /TEXTURE_GREEN:input /TEXTURE_HIGHRES:input /TEXTURE_IMAGE:input /TEXTURE_INTERP /TEXTURE_RED:input /THICK:input /USE_TRIANGLES /VERT_COLORS:input /ZERO_OPACITY_SKIP:input /USER_INTERFACE:input"
	itool_volume_keywords		= "/AMBIENT:input /AUTO_RENDER /BOUNDS:input /CLIP_PLANES:input /COMPOSITE_FUNCTION:input /EXTENTS_TRANSPARENCY:input /DEPTH_CUE:input /HIDE /HINTS:input /INTERPOLATE /LIGHTING_MODEL /OPACITY_TABLE0:input /OPACITY_TABLE1:input /RENDER_EXTENTS:input /RENDER_STEP:input /RENDER_QUALITY:input /RGB_TABLE0:input /RGB_TABLE1:input /SUBVOLUME:input /TWO_SIDED /VOLUME_DIMENSIONS:input /VOLUME_LOCATION:input /ZBUFFER /ZERO_OPACITY_SKIP:input"

	str_to_get_set_init, IDLGRPALETTE_GETPROPERTY,      		IDLGRPALETTE_SETPROPERTY,      		IDLGRPALETTE_INIT,      	'ALL:100 BLUE_VALUES:111 BOTTOM_STRETCH:111 GAMMA:111 GREEN_VALUES:111 NAME:111 N_COLORS:100 RED_VALUES:111 TOP_STRETCH:111 UVALUE:111'
	str_to_get_set_init, IDLGRPRINTER_GETPROPERTY,      		IDLGRPRINTER_SETPROPERTY,      		IDLGRPRINTER_INIT,      	'ALL:100 COLOR_MODEL:101 DIMENSIONS:100 GAMMA:111 GRAPHICS_TREE:111 LANDSCAPE:111 N_COLORS:101 N_COPIES:111 NAME:111 PALETTE:111 PRINT_QUALITY:111 PRINTER_NAME:100 QUALITY:111 REGISTER_PROPERTIES:001 RESOLUTION:100 UNITS:111'
	str_to_get_set_init, IDLNETURL_GETPROPERTY,         		IDLNETURL_SETPROPERTY,         		IDLNETURL_INIT,         	'AUTHENTICATION:111 CALLBACK_DATA:111 CALLBACK_FUNCTION:111 CONNECT_TIMEOUT:111 CONTENT_TYPE:100 ENCODE:111 FTP_CONNECTION_MODE:111 PROXY_AUTHENTICATION:111 PROXY_HOSTNAME:111 PROXY_PASSWORD:011 PROXY_PORT:111 PROXY_USERNAME:111 RESPONSE_CODE:100 RESPONSE_FILENAME:100 RESPONSE_HEADER:100 SSL_CERTIFICATE_FILE:111 SSL_VERIFY_HOST:111 SSL_VERIFY_PEER:111 SSL_VERSION:111 TIMEOUT:111 URL_HOSTNAME:111 URL_PASSWORD:011 URL_PATH:111 URL_PORT:111 URL_QUERY:111 URL_SCHEME:111 URL_USERNAME:111 VERBOSE:111'
	str_to_get_set_init, IDLGRMODEL_GETPROPERTY,        		IDLGRMODEL_SETPROPERTY,        		IDLGRMODEL_INIT,        	'ACTIVE_POSITION:111 ALL:100 CLIP_PLANES:111 DEPTH_TEST_DISABLE:111 DEPTH_TEST_FUNCTION:111 DEPTH_WRITE_DISABLE:111 HIDE:111 LIGHTING:111 PARENT:100 REGISTER_PROPERTIES:001 RENDER_METHOD:111 SELECT_TARGET:111 TRANSFORM:111'
	str_to_get_set_init, IDLGRVIEW_GETPROPERTY,         		IDLGRVIEW_SETPROPERTY,         		IDLGRVIEW_INIT,         	'ALL:100 COLOR:111 DEPTH_CUE:111 DIMENSIONS:111 DOUBLE:111 EYE:111 HIDE:111 LOCATION:111 PARENT:100 PROJECTION:111 REGISTER_PROPERTIES:001 TRANSPARENT:111 UNITS:111 VIEWPLANE_RECT:111 ZCLIP:111'
	str_to_get_set_init, IDLGRVOLUME_GETPROPERTY,       		IDLGRVOLUME_SETPROPERTY,       		IDLGRVOLUME_INIT,       	'ALL:100 ALPHA_CHANNEL:111 AMBIENT:111 BOUNDS:111 CLIP_PLANES:111 COMPOSITE_FUNCTION:111 DATA0:111 DATA1:111 DATA2:111 DATA3:111 DEPTH_CUE:111 HIDE:111 HINTS:111 INTERPOLATE:111 LIGHTING_MODEL:111 OPACITY_TABLE0:111 OPACITY_TABLE1:111 PARENT:110 REGISTER_PROPERTIES:001 RENDER_STEP:111 RGB_TABLE0:111 RGB_TABLE1:111 TWO_SIDED:111 VALID_DATA:100 VOLUME_SELECT:111 XCOORD_CONV:111 XRANGE:100 YCOORD_CONV:111 YRANGE:100 ZBUFFER:111 ZCOORD_CONV:111 ZERO_OPACITY_SKIP:111 ZRANGE:100'
	str_to_get_set_init, IDLITWINDOW_GETPROPERTY,       		IDLITWINDOW_SETPROPERTY,       		IDLITWINDOW_INIT,       	'ALL:100 COLOR_MODEL:101 CURRENT_ZOOM:100 DIMENSIONS:111 DISPLAY_NAME:110 GRAPHICS_TREE:111 IMAGE_DATA:100 LOCATION:111 MINIMUM_VIRTUAL_DIMENSIONS:111 N_COLORS:101 PALETTE:111 QUALITY:111 REGISTER_PROPERTIES:001 RENDERER:101 RESOLUTION:100 RETAIN:101 SCREEN_DIMENSIONS:100 TITLE:111 UNITS:111 VIEWPORT_DIMENSIONS:100 VIRTUAL_DIMENSIONS:111 VISIBLE_LOCATION:111 ZBUFFER_DATA:100 ZOOM_BASE:111 ZOOM_NSTEP:100'
	str_to_get_set_init, IDLITCOMPONENT_GETPROPERTY,    		IDLITCOMPONENT_SETPROPERTY,    		IDLITCOMPONENT_INIT,   	 	'COMPONENT_VERSION:100 DESCRIPTION:111 HELP:111 ICON:111 IDENTIFIER:111 NAME:111 PRIVATE:111 UVALUE:111'
	str_to_get_set_init, IDLGRIMAGE_GETPROPERTY,        		IDLGRIMAGE_SETPROPERTY,        		IDLGRIMAGE_INIT,       		'ALL:100 ALPHA_CHANNEL:111 BLEND_FUNCTION:111 CHANNEL:111 CLIP_PLANES:111 DATA:111 DEPTH_OFFSET:111 DEPTH_TEST_DISABLE:111 DEPTH_TEST_FUNCTION:111 DEPTH_WRITE_DISABLE:111 DIMENSIONS:111 GREYSCALE:111 HIDE:111 INTERLEAVE:111 INTERPOLATE:111 LOCATION:111 ORDER:111 PALETTE:111 PARENT:100 REGISTER_PROPERTIES:001 RENDER_METHOD:111 RESET_DATA:011 SHARE_DATA:011 SUB_RECT:111 TILE_COLOR:111 TILE_CURRENT_LEVEL:111 TILE_DIMENSIONS:111 TILE_LEVEL_MODE:111 TILE_NUM_LEVELS:111 TILE_SHOW_BOUNDARIES:111 TILED_IMAGE_DIMENSIONS:111 TILING:111 TRANSFORM_MODE:111 XCOORD_CONV:111 XRANGE:100 YCOORD_CONV:111 YRANGE:100 ZCOORD_CONV:111 ZRANGE:100'
	str_to_get_set_init, IDLITDIRECTWINDOW_GETPROPERTY,		IDLITDIRECTWINDOW_SETPROPERTY, 		IDLITDIRECTWINDOW_INIT,		'WINDOW_INDEX:100'
	str_to_get_set_init, TRACKBALL_GETPROPERTY, 			TRACKBALL_SETPROPERTY, 			TRACKBALL_INIT, 		'AXIS:001 CONSTRAIN:001 MOUSE:001'
	str_to_get_set_init, IDLSYSMONITORINFO_GETPROPERTY,		IDLSYSMONITORINFO_SETPROPERTY, 		IDLSYSMONITORINFO_INIT, 	'DISPLAY_NAME:111'
	str_to_get_set_init, IDLGRSCENE_GETPROPERTY,			IDLGRSCENE_SETPROPERTY, 		IDLGRSCENE_INIT, 		'ALL:100 COLOR:111 HIDE:001 REGISTER_PROPERTIES:001 TRANSPARENT:110'
	str_to_get_set_init, IDLGRSURFACE_GETPROPERTY,			IDLGRSURFACE_SETPROPERTY, 		IDLGRSURFACE_INIT, 		'ALL:100 ALPHA_CHANNEL:111 AMBIENT:111 BOTTOM:111 CLIP_PLANES:111 COLOR:111 DATA:100 DATAX:011 DATAY:011 DATAZ:011 DEPTH_OFFSET:111 DEPTH_TEST_DISABLE:111 DEPTH_TEST_FUNCTION:111 DEPTH_WRITE_DISABLE:111 DIFFUSE:111 DOUBLE:111 EMISSION:111 EXTENDED_LEGO:111 HIDDEN_LINES:111 HIDE:111 LINESTYLE:111 MAX_VALUE:111 MIN_VALUE:111 PALETTE:111 PARENT:100 REGISTER_PROPERTIES:001 RESET_DATA:011 SHADE_RANGE:111 SHADING:111 SHARE_DATA:011 SHININESS:111 SHOW_SKIRT:111 SKIRT:111 SPECULAR:111 STYLE:111 TEXTURE_COORD:111 TEXTURE_HIGHRES:111 TEXTURE_INTERP:111 TEXTURE_MAP:111 THICK:111 USE_TRIANGLES:111 VERT_COLORS:111 XCOORD_CONV:111 XRANGE:100 YCOORD_CONV:111 YRANGE:100 ZCOORD_CONV:111 ZERO_OPACITY_SKIP:111 ZRANGE:100'
	str_to_get_set_init, IDLGRSYMBOL_GETPROPERTY,			IDLGRSYMBOL_SETPROPERTY, 		IDLGRSYMBOL_INIT, 		'ALL:100 ALPHA_CHANNEL:111 COLOR:111 DATA:111 NAME:111 SIZE:111 THICK:111 UVALUE:111'
	str_to_get_set_init, IDLGRTEXT_GETPROPERTY,			IDLGRTEXT_SETPROPERTY, 			IDLGRTEXT_INIT, 		'ALIGNMENT:111 ALL:100 ALPHA_CHANNEL:111 BASELINE:111 CHAR_DIMENSIONS:111 CLIP_PLANES:111 COLOR:111 DEPTH_TEST_DISABLE:111 DEPTH_TEST_FUNCTION:111 DEPTH_WRITE_DISABLE:111 ENABLE_FORMATTING:111 FILL_BACKGROUND:111 FILL_COLOR:111 FONT:111 HIDE:111 KERNING:111 LOCATIONS:111 ONGLASS:111 PALETTE:111 PARENT:100 RECOMPUTE_DIMENSIONS:111 REGISTER_PROPERTIES:001 RENDER_METHOD:111 STRINGS:111 UPDIR:111 VERTICAL_ALIGNMENT:111 XCOORD_CONV:111 XRANGE:100 YCOORD_CONV:111 YRANGE:100 ZCOORD_CONV:111 ZRANGE:100'
	str_to_get_set_init, IDLGRVIEWGROUP_GETPROPERTY,		IDLGRVIEWGROUP_SETPROPERTY,		IDLGRVIEWGROUP_INIT, 		'ALL:100 HIDE:111 PARENT:100 REGISTER_PROPERTIES:001'
	str_to_get_set_init, IDLGRVRML_GETPROPERTY,			IDLGRVRML_SETPROPERTY,			IDLGRVRML_INIT, 		'ALL:100 COLOR_MODEL:101 DIMENSIONS:111 FILENAME:111 GRAPHICS_TREE:111 N_COLORS:101 PALETTE:111 QUALITY:111 REGISTER_PROPERTIES:001 RESOLUTION:111 SCREEN_DIMENSIONS:100 UNITS:111 WORLDINFO:001 WORLDTITLE:001'
	str_to_get_set_init, IDLGRWINDOW_GETPROPERTY,			IDLGRWINDOW_SETPROPERTY,		IDLGRWINDOW_INIT, 		'ALL:100 COLOR_MODEL:101 CURRENT_ZOOM:100 DIMENSIONS:111 DISPLAY_NAME:110 GRAPHICS_TREE:111 IMAGE_DATA:100 LOCATION:111 MINIMUM_VIRTUAL_DIMENSIONS:111 N_COLORS:101 PALETTE:111 QUALITY:111 REGISTER_PROPERTIES:001 RENDERER:101 RESOLUTION:100 RETAIN:101 SCREEN_DIMENSIONS:100 TITLE:111 UNITS:111 VIEWPORT_DIMENSIONS:100 VIRTUAL_DIMENSIONS:111 VISIBLE_LOCATION:111 ZBUFFER_DATA:100 ZOOM_BASE:111 ZOOM_NSTEP:100'
	str_to_get_set_init, IDLANROI_GETPROPERTY,			IDLANROI_SETPROPERTY,			IDLANROI_INIT, 			'ALL:100 BLOCK_SIZE:111 DATA:111 DOUBLE:111 INTERIOR:111 N_VERTS:100 ROI_XRANGE:100 ROI_YRANGE:100 ROI_ZRANGE:100 TYPE:101'
	str_to_get_set_init, IDLANROIGROUP_GETPROPERTY,			IDLANROIGROUP_SETPROPERTY,		IDLANROIGROUP_INIT, 		'ALL:100 ROIGROUP_XRANGE:100 ROIGROUP_YRANGE:100 ROIGROUP_ZRANGE:100'
	str_to_get_set_init, IDLGRROI_GETPROPERTY,			IDLGRROI_SETPROPERTY,			IDLGRROI_INIT, 			'ALL:100 ALPHA_CHANNEL:111 CLIP_PLANES:111 COLOR:111 DEPTH_TEST_DISABLE:111 DEPTH_TEST_FUNCTION:111 DEPTH_WRITE_DISABLE:111 DOUBLE:111 HIDE:111 LINESTYLE:111 PALETTE:111 PARENT:100 REGISTER_PROPERTIES:001 STYLE:111 SYMBOL:111 THICK:111 XCOORD_CONV:111 XRANGE:100 YCOORD_CONV:111 YRANGE:100 ZCOORD_CONV:111 ZRANGE:100'
	str_to_get_set_init, IDLGRROIGROUP_GETPROPERTY,			IDLGRROIGROUP_SETPROPERTY,		IDLGRROIGROUP_INIT, 		'ALL:100 CLIP_PLANES:111 DEPTH_TEST_DISABLE:111 DEPTH_TEST_FUNCTION:111 DEPTH_WRITE_DISABLE:111 HIDE:111 PARENT:100 XCOORD_CONV:111 XRANGE:100 YCOORD_CONV:111 YRANGE:100 ZCOORD_CONV:111 ZRANGE:100'
	str_to_get_set_init, IDLITDATAOPERATION_GETPROPERTY,		IDLITDATAOPERATION_SETPROPERTY,		IDLITDATAOPERATION_INIT, 	'WITHIN_UI:100'
	str_to_get_set_init, IDLFFLANGCAT_GETPROPERTY,			IDLFFLANGCAT_SETPROPERTY,		IDLFFLANGCAT_INIT, 		'APP_NAME:101 APP_PATH:101 AVAILABLE_LANGUAGES:100 DEFAULT_KEYS:100 DEFAULT_LANGUAGE:101 DEFAULT_N_KEYS:100 FILENAME:101 KEYS:100 LANGUAGE:111 N_KEYS:100 VERBOSE:111'
	str_to_get_set_init, IDLITCOMMAND_GETPROPERTY,			IDLITCOMMAND_SETPROPERTY,		IDLITCOMMAND_INIT, 		'SKIP_REDO:111 SKIP_UNDO:111 TARGET_IDENTIFIER:111 OPERATION_IDENTIFIER:111'
	str_to_get_set_init, IDLITDATA_GETPROPERTY,			IDLITDATA_SETPROPERTY,			IDLITDATA_INIT, 		'HIDE:111 READ_ONLY:111 TYPE:101'
	str_to_get_set_init, IDLITMANIPULATOR_GETPROPERTY,		IDLITMANIPULATOR_SETPROPERTY,		IDLITMANIPULATOR_INIT, 		'BUTTON_EVENTS:111 DEFAULT_CURSOR:011 DESCRIPTION:111 DISABLE:111 KEYBOARD_EVENTS:111 MOTION_EVENTS:111 OPERATION_IDENTIFIER:111 PARAMETER_IDENTIFIER:111 TRANSIENT_DEFAULT:111 TRANSIENT_MOTION:111 TYPES:101 VIEWS_ONLY:001 VISUAL_TYPE:111'
	str_to_get_set_init, IDLITMANIPULATORCONTAINER_GETPROPERTY,	IDLITMANIPULATORCONTAINER_SETPROPERTY,	IDLITMANIPULATORCONTAINER_INIT,	'AUTO_SWITCH:001'
	str_to_get_set_init, IDLITMANIPULATORVISUAL_GETPROPERTY,	IDLITMANIPULATORVISUAL_SETPROPERTY,	IDLITMANIPULATORVISUAL_INIT,	'UNIFORM_SCALE:111 VISUAL_TYPE:111'
	str_to_get_set_init, IDLITOPERATION_GETPROPERTY,		IDLITOPERATION_SETPROPERTY,		IDLITOPERATION_INIT,		'EXPENSIVE_COMPUTATION:101 REVERSIBLE_OPERATION:101 SHOW_EXECUTION_UI:101 TYPES:111'
	str_to_get_set_init, IDLITTOOL_GETPROPERTY,			IDLITTOOL_SETPROPERTY,			IDLITTOOL_INIT,			'DESCRIPTION:111 ICON:111 NAME:111 TYPE:111 UPDATE_BYTYPE:011 VERBOSE:111 VERSION:101'
	str_to_get_set_init, IDLITUI_GETPROPERTY,			IDLITUI_SETPROPERTY,			IDLITUI_INIT,			'GROUP_LEADER:100'
	str_to_get_set_init, IDLITVISUALIZATION_GETPROPERTY,		IDLITVISUALIZATION_SETPROPERTY,		IDLITVISUALIZATION_INIT,	'CENTER_OF_ROTATION:111 IMPACTS_RANGE:111 ISOTROPIC:111 MANIPULATOR_TARGET:111 PROPERTY_INTERSECTION:101 SELECT_TARGET:111 TYPE:011'
	str_to_get_set_init, IDLITWRITER_GETPROPERTY,			IDLITWRITER_SETPROPERTY,		IDLITWRITER_INIT,		'TYPES:101'
	str_to_get_set_init, IDLGRAXIS_GETPROPERTY,			IDLGRAXIS_SETPROPERTY,			IDLGRAXIS_INIT,			'ALL:100 ALPHA_CHANNEL:111 AM_PM:111 CLIP_PLANES:111 COLOR:111 CRANGE:100 DAYS_OF_WEEK:111 DEPTH_TEST_DISABLE:111 DEPTH_TEST_FUNCTION:111 DEPTH_WRITE_DISABLE:111 DIRECTION:111 EXACT:111 EXTEND:111 GRIDSTYLE:111 HIDE:111 LOCATION:111 LOG:111 MAJOR:111 MINOR:111 MONTHS:111 NOTEXT:111 PALETTE:100 PARENT:100 RANGE:111 REGISTER_PROPERTIES:001 SUBTICKLEN:111 TEXTALIGNMENTS:111 TEXTBASELINE:111 TEXTPOS:111 TEXTUPDIR:111 THICK:111 TICKDIR:111 TICKFORMAT:111 TICKFRMTDATA:111 TICKINTERVAL:111 TICKLAYOUT:111 TICKLEN:111 TICKTEXT:111 TICKUNITS:111 TICKVALUES:111 TITLE:111 USE_TEXT_COLOR:111 XCOORD_CONV:111 XRANGE:100 YCOORD_CONV:111 YRANGE:100 ZCOORD_CONV:111 ZRANGE:100'
	str_to_get_set_init, IDLGRBUFFER_GETPROPERTY,			IDLGRBUFFER_SETPROPERTY,		IDLGRBUFFER_INIT,		'ALL:100 COLOR_MODEL:101 DIMENSIONS:111 GRAPHICS_TREE:111 IMAGE_DATA:100 N_COLORS:101 PALETTE:111 QUALITY:111 REGISTER_PROPERTIES:001 RESOLUTION:111 SCREEN_DIMENSIONS:100 UNITS:111 ZBUFFER_DATA:100'
	str_to_get_set_init, IDLGRCLIPBOARD_GETPROPERTY,		IDLGRCLIPBOARD_SETPROPERTY,		IDLGRCLIPBOARD_INIT,		'ALL:100 COLOR_MODEL:101 DIMENSIONS:111 GRAPHICS_TREE:111 N_COLORS:101 PALETTE:111 QUALITY:111 REGISTER_PROPERTIES:001 RESOLUTION:111 SCREEN_DIMENSIONS:100 UNITS:111'
	str_to_get_set_init, IDLGRCOLORBAR_GETPROPERTY,			IDLGRCOLORBAR_SETPROPERTY,		IDLGRCOLORBAR_INIT,		'ALL:100 BLUE_VALUES:111 COLOR:111 DIMENSIONS:111 GREEN_VALUES:111 HIDE:111 MAJOR:111 MINOR:111 PALETTE:111 PARENT:100 RED_VALUES:111 SHOW_AXIS:111 SHOW_OUTLINE:111 SUBTICKLEN:111 THICK:111 THREED:111 TICKFORMAT:111 TICKFRMTDATA:111 TICKLEN:111 TICKTEXT:111 TICKVALUES:111 TITLE:111 XCOORD_CONV:111 XRANGE:100 YCOORD_CONV:111 YRANGE:100 ZCOORD_CONV:111 ZRANGE:100'
	str_to_get_set_init, IDLGRCONTOUR_GETPROPERTY,			IDLGRCONTOUR_SETPROPERTY,		IDLGRCONTOUR_INIT,		'ALL:100 ALPHA_CHANNEL:111 AM_PM:111 ANISOTROPY:111 C_COLOR:111 C_FILL_PATTERN:111 C_LABEL_INTERVAL:111 C_LABEL_NOGAPS:111 C_LABEL_OBJECTS:111 C_LABEL_SHOW:111 C_LINESTYLE:111 C_THICK:111 C_USE_LABEL_COLOR:111 C_USE_LABEL_ORIENTATION:111 C_VALUE:111 CLIP_PLANES:111 COLOR:111 DATA_VALUES:111 DAYS_OF_WEEK:111 DEPTH_OFFSET:111 DEPTH_TEST_DISABLE:111 DEPTH_TEST_FUNCTION:111 DEPTH_WRITE_DISABLE:111 DOUBLE_DATA:111 DOUBLE_GEOM:111 DOWNHILL:111 FILL:111 GEOM:100 GEOMX:011 GEOMY:011 GEOMZ:011 HIDE:111 LABEL_FONT:111 LABEL_FORMAT:111 LABEL_FRMTDATA:001 LABEL_UNITS:111 MAX_VALUE:111 MONTHS:111 MIN_VALUE:111 N_LEVELS:111 PALETTE:001 PARENT:100 PLANAR:111 POLYGONS:111 REGISTER_PROPERTIES:001 SHADE_RANGE:111 SHADING:111 TICKINTERVAL:111 TICKLEN:111 USE_TEXT_ALIGNMENTS:111 XCOORD_CONV:111 XRANGE:100 YCOORD_CONV:111 YRANGE:100 ZCOORD_CONV:111 ZRANGE:100'
	str_to_get_set_init, IDLGRFONT_GETPROPERTY,			IDLGRFONT_SETPROPERTY,			IDLGRFONT_INIT,			'ALL:100 NAME:111 SIZE:111 SUBSTITUTE:111 THICK:111 UVALUE:111'
	str_to_get_set_init, IDLGRLEGEND_GETPROPERTY,			IDLGRLEGEND_SETPROPERTY,		IDLGRLEGEND_INIT,		'ALL:100 BORDER_GAP:111 COLUMNS:111 FILL_COLOR:111 FONT:111 GAP:111 GLYPH_WIDTH:111 HIDE:111 ITEM_COLOR:111 ITEM_LINESTYLE:111 ITEM_NAME:111 ITEM_OBJECT:111 ITEM_THICK:111 ITEM_TYPE:111 OUTLINE_COLOR:111 OUTLINE_THICK:111 PARENT:100 RECOMPUTE:010 SHOW_FILL:111 SHOW_OUTLINE:111 TEXT_COLOR:111 TITLE:111 XCOORD_CONV:111 XRANGE:100 YCOORD_CONV:111 YRANGE:100 ZCOORD_CONV:111 ZRANGE:100'
	str_to_get_set_init, IDLGRLIGHT_GETPROPERTY,			IDLGRLIGHT_SETPROPERTY,			IDLGRLIGHT_INIT,		'ALL:100 ATTENUATION:111 COLOR:111 CONEANGLE:111 DIRECTION:111 FOCUS:111 HIDE:111 INTENSITY:111 LOCATION:111 PALETTE:111 PARENT:100 REGISTER_PROPERTIES:001TYPE:111 XCOORD_CONV:111 YCOORD_CONV:111 ZCOORD_CONV:111'
	str_to_get_set_init, IDLGRPATTERN_GETPROPERTY,			IDLGRPATTERN_SETPROPERTY,		IDLGRPATTERN_INIT,		'ALL:100 NAME:111 ORIENTATION:111 PATTERN:111 SPACING:111 STYLE:111 THICK:001 UVALUE:111'
	str_to_get_set_init, IDLGRPLOT_GETPROPERTY,			IDLGRPLOT_SETPROPERTY,			IDLGRPLOT_INIT,			'ALL:100 ALPHA_CHANNEL:111 CLIP_PLANES:111 COLOR:111 DATA:100 DATAX:011 DATAY:011 DEPTH_TEST_DISABLE:111 DEPTH_TEST_FUNCTION:111 DEPTH_WRITE_DISABLE:111 DOUBLE:111 HIDE:111 HISTOGRAM:111 LINESTYLE:111 MAX_VALUE:111 MIN_VALUE:111 NSUM:111 PALETTE:111 PARENT:100 POLAR:111 REGISTER_PROPERTIES:001 RESET_DATA:011 SHARE_DATA:011 SYMBOL:111 THICK:111 USE_ZVALUE:001 VERT_COLORS:111 XCOORD_CONV:111 XRANGE:111 YCOORD_CONV:111 YRANGE:111 ZCOORD_CONV:111 ZRANGE:100 ZVALUE:111'
	str_to_get_set_init, IDLGRPOLYGON_GETPROPERTY,			IDLGRPOLYGON_SETPROPERTY,		IDLGRPOLYGON_INIT,		'ALL:100 ALPHA_CHANNEL:111 AMBIENT:111 BOTTOM:111 CLIP_PLANES:111 COLOR:111 DATA:111 DEPTH_OFFSET:111 DEPTH_TEST_DISABLE:111 DEPTH_TEST_FUNCTION:111 DEPTH_WRITE_DISABLE:111 DIFFUSE:111 DOUBLE:111 EMISSION:111 FILL_PATTERN:111 HIDDEN_LINES:001 HIDE:111 LINESTYLE:111 NORMALS:111 PALETTE:001 PARENT:100 POLYGONS:111 REGISTER_PROPERTIES:001 REJECT:111 RESET_DATA:011 SHADE_RANGE:111 SHADING:111 SHARE_DATA:011 SHININESS:111 SPECULAR:111 STYLE:111 TEXTURE_COORD:111 TEXTURE_INTERP:111 TEXTURE_MAP:111 THICK:111 VERT_COLORS:111 XCOORD_CONV:111 XRANGE:100 YCOORD_CONV:111 YRANGE:100 ZCOORD_CONV:111 ZERO_OPACITY_SKIP:111 ZRANGE:100'
	str_to_get_set_init, IDLGRPOLYLINE_GETPROPERTY,			IDLGRPOLYLINE_SETPROPERTY,		IDLGRPOLYLINE_INIT,		'ALL:100 ALPHA_CHANNEL:111 CLIP_PLANES:111 COLOR:111 DATA:111 DEPTH_TEST_DISABLE:111 DEPTH_TEST_FUNCTION:111 DEPTH_WRITE_DISABLE:111 DOUBLE:111 HIDE:111 LABEL_NOGAPS:111 LABEL_OFFSETS:111 LABEL_OBJECTS:111 LABEL_POLYLINES:111 LABEL_USE_VERTEX_COLOR:111 LINESTYLE:111 PALETTE:111 PARENT:100 POLYLINES:111 REGISTER_PROPERTIES:001 RESET_DATA:011 SHADING:111 SHARE_DATA:011 SYMBOL:111 THICK:111 USE_LABEL_COLOR:111 USE_LABEL_ORIENTATION:111 USE_TEXT_ALIGNMENTS:111 VERT_COLORS:111 XCOORD_CONV:111 XRANGE:100 YCOORD_CONV:111 YRANGE:100 ZCOORD_CONV:111 ZRANGE:100'
	str_to_get_set_init, IDLFFXMLDOMDOCUMENT_GETPROPERTY,		IDLFFXMLDOMDOCUMENT_SETPROPERTY,	IDLFFXMLDOMDOCUMENT_INIT,	'NODE_DESTRUCTION_POLICY:111'
	str_to_get_set_init, IDLFFXMLSAX_GETPROPERTY,			IDLFFXMLSAX_SETPROPERTY,		IDLFFXMLSAX_INIT,		'FILENAME:100 NAMESPACE_PREFIXES:111 PARSER_LOCATION:100 PARSER_PUBLICID:100 PARSER_URI:100 SCHEMA_CHECKING:111 VALIDATION_MODE:111'
	str_to_get_set_init, IDLGRMPEG_GETPROPERTY,			IDLGRMPEG_SETPROPERTY,			IDLGRMPEG_INIT,			'ALL:100 BITRATE:111 FILENAME:111 FORMAT:111 FRAME_RATEFRAME_RATE:111 IFRAME_GAP:111 IFRAME_GAPINTERLACED:111 MOTION_VEC_LENGTH:111 QUALITY:111 SCALE:111 STATISTICS:111 TEMP_DIRECTORY:001'
	str_to_get_set_init, IDLFFDICOM_GETPROPERTY,			IDLFFDICOM_SETPROPERTY,			IDLFFDICOM_INIT,		'VERBOSE:001'
	str_to_get_set_init, IDLFFDICOMEX_GETPROPERTY,			IDLFFDICOMEX_SETPROPERTY,		IDLFFDICOMEX_INIT,		'BITS_ALLOCATED:110 BITS_STORED:110 COLUMNS:110 FILENAME:100 HIGH_BIT:110 IMAGE_TYPE:110 INSTANCE_NUMBER:110 MODALITY:110 NO_PIXEL_DATA:111 NUMBER_OF_FRAMES:110 PHOTOMETRIC_INTERPRETATION:110 PIXEL_ASPECT_RATIO:110 PIXEL_MAX:110 PIXEL_MIN:110 PIXEL_REPRESENTATION:110 PIXEL_SPACING:110 PLANAR_CONFIGURATION:110 ROWS:110 SAMPLES_PER_PIXEL:110 SOP_CLASS_UID:110 SOP_INSTANCE_UID:110 TRANSFER_SYNTAX:110'
	str_to_get_set_init, IDLFFDICOMEXQUERY_GETPROPERTY,		IDLFFDICOMEXQUERY_SETPROPERTY,		IDLFFDICOMEXQUERY_INIT,		'ACCESSION_NUMBER:110 CALLBACK_DATA:110 CALLBACK_FUNCTION:110 FAMILY_NAME:110 GIVEN_NAME:110 INSTANCE_NUMBER:110 MIDDLE_NAME:110 MODALITY:110 PATIENT_ID:110 PATIENT_NAME:110 PREFIX:110 QUERY_LEVEL:110 QUERY_MODEL:110 QUERY_SCP:110 SERIES_INSTANCE_UID:110 SERIES_NUMBER:110 SOP_INSTANCE_UID:110 STORAGE_SCP:110 STUDY_DATE:110 STUDY_ID:110 STUDY_INSTANCE_UID:110 STUDY_TIME:110 SUFFIX:110'
	str_to_get_set_init, IDLFFDICOMEXSTORSCU_GETPROPERTY,		IDLFFDICOMEXSTORSCU_SETPROPERTY,	IDLFFDICOMEXSTORSCU_INIT,	'CALLBACK_DATA:110 CALLBACK_FUNCTION:110 STORAGE_SCP:110'
	str_to_get_set_init, IDL_IDLBRIDGE_GETPROPERTY,			IDL_IDLBRIDGE_SETPROPERTY,		IDL_IDLBRIDGE_INIT,		'CALLBACK:111 OUTPUT:111 USERDATA:111'
	str_to_get_set_init, IDLFFJPEG2000_GETPROPERTY,			IDLFFJPEG2000_SETPROPERTY,		IDLFFJPEG2000_INIT,		'BIT_DEPTH:111 BIT_RATE:011 COLOR_SPACE:100 COMMENT:111 DIMENSIONS:111 DISPLAY_RESOLUTION:111 FILENAME:100 JP2:100 N_COMPONENTS:111 N_LAYERS:111 N_LEVELS:111 N_TILES:100 OFFSET:111 PALETTE:111 PROGRESSION:111 QUIET:011 READ:101 REVERSIBLE:111 SIGNED:111 SUBSAMPLING:100 TILE_DIMENSIONS:111 TILE_OFFSET:111 TILE_RANGE:100 UUIDS:100 WRITE:101 XML:111 YCC:111'
	str_to_get_set_init, IDLFFMJPEG2000_GETPROPERTY,		IDLFFMJPEG2000_SETPROPERTY,		IDLFFMJPEG2000_INIT,		'BIT_DEPTH:111 BIT_RATE:011 COLOR_SPACE:111 COMMENT:111 CURRENT_FRAME:100 DIMENSIONS:111 DURATION:100 FILENAME:100 FRAME_BUFFER_LENGTH:111 FRAMES_IN_BUFFER:100 FRAME_PERIOD:111 N_COMPONENTS:111 N_FRAMES:100 N_LAYERS:111 N_LEVELS:111 N_TILES:100 PALETTE:111 PROGRESSION:111 REVERSIBLE:111 SCAN_MODE:100 SIGNED:111 STATE:100 TILE_DIMENSIONS:111 TIMESCALE:111 WRITE:101 XML:111 YCC:111'
	str_to_get_set_init, IDLFFMRSID_GETPROPERTY,			IDLFFMRSID_SETPROPERTY,			IDLFFMRSID_INIT,		'QUIET:001'
	str_to_get_set_init, IDLFFSHAPE_GETPROPERTY,			IDLFFSHAPE_SETPROPERTY,			IDLFFSHAPE_INIT,		'ATTRIBUTE_INFO:100 ATTRIBUTE_NAMES:100 DBF_ONLY:001 ENTITY_TYPE:1001 FILENAME:100 IS_OPEN:100 N_ATTRIBUTES:100 N_ENTITIES:100 N_RECORDS:100 UPDATE:001'
	str_to_get_set_init, IDLDBDATABASE_GETPROPERTY,			IDLDBDATABASE_SETPROPERTY,		IDLDBDATABASE_INIT,		'CAN_GET_TABLES:100 DBMS_NAME:100 DRIVER_ODBC_LEVEL:100 DBMS_VERSION:100 DRIVER_VERSION:100 IS_CONNECTED:100 IS_READONLY:100 MAX_CONNECTIONS:100 MAX_RECORDSETS:100 ODBC_LEVEL:100 SQL_LEVEL:100 SQL_SERVER_NAME:100 USE_CURSOR_LIB:110 USER_NAME:100 VERBOSE:010'
	str_to_get_set_init, IDLDBRECORDSET_GETPROPERTY,		IDLDBRECORDSET_SETPROPERTY,		IDLDBRECORDSET_INIT,		'CAN_MOVE_ABSOLUTE:100 CAN_MOVE_FIRST:100 CAN_MOVE_LAST:100 CAN_MOVE_NEXT:100 CAN_MOVE_PRIOR:100 CAN_MOVE_RELATIVE:100 FIELD_INFO:100 GET_DATABASE:100IS_READONLY:100 N_BUFFERS:101 RECORDSET_SOURCE:100'


	list_all = [									$

	; built-in
	; --------
	"ABS							(SYSTEM/built-in) 					F X:input",		$
	"ACOS							(SYSTEM/built-in) 					F X:input",		$
	"ALOG							(SYSTEM/built-in) 					F X:input",		$
	"ALOG10							(SYSTEM/built-in) 					F X:input",		$
	"APP_USER_DIR						(SYSTEM/built-in) 					F AuthorDirname:input AuthorDesc:input AppDirname:input AppDesc:input AppReadmeText:input AppReadmeVersion:input /AUTHOR_README_TEXT:input /AUTHOR_README_VERSION:input                   /RESTRICT_APPVERSION /RESTRICT_ARCH /RESTRICT_FAMILY /RESTRICT_OS /RESTRICT_FILE_OFFSET_BITS /RESTRICT_IDL_RELEASE /RESTRICT_MEMORY_BITS",	$
	"APP_USER_DIR_QUERY					(SYSTEM/built-in) 					F AuthorDirname:input AppDirname:input /COUNT:output /EXCLUDE_CURRENT /QUERY_APPVERSION /QUERY_ARCH /QUERY_FAMILY /QUERY_FILE_OFFSET_BITS /QUERY_IDL_RELEASE /QUERY_MEMORY_BITS /QUERY_OS /RESTRICT_APPVERSION /RESTRICT_ARCH /RESTRICT_FAMILY /RESTRICT_OS /RESTRICT_FILE_OFFSET_BITS /RESTRICT_IDL_RELEASE /RESTRICT_MEMORY_BITS",	$
	"ARG_PRESENT						(SYSTEM/built-in) 					F Variable:input#UNDEFINED",		$
	"ARRAY_EQUAL						(SYSTEM/built-in) 					F Op1:input Op2:input /NO_TYPECONV /GE",	$
	"ASIN							(SYSTEM/built-in) 					F X:input",		$
	"ASSOC							(SYSTEM/built-in) 					F Unit:input Array_Structure:input [Offset:input] /PACKED",	$
	"ATAN							(SYSTEM/built-in) 					F X:input [Y:input] /PHASE",	$
	"AXIS							(SYSTEM/built-in) 					P [X:input] [Y:input] [Z:input] /SAVE /{X|Y|Z}AXIS:input /XLOG /YNOZERO /YLOG",	$
	"BEEP							(SYSTEM/built-in) 					P",			$ ; non document
	"BESELI							(SYSTEM/built-in) 					F X:input N:input /DOUBLE /ITER:output",			$
	"BESELJ							(SYSTEM/built-in) 					F X:input N:input /DOUBLE /ITER:output",			$
	"BESELK							(SYSTEM/built-in) 					F X:input N:input /DOUBLE /ITER:output",			$
	"BESELY							(SYSTEM/built-in) 					F X:input N:input /DOUBLE /ITER:output",			$
	"BINDGEN						(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",			$
	"BIT_FFS						(SYSTEM/built-in)					F Value:input",	$
	"BIT_POPULATION						(SYSTEM/built-in)					F Value:input",	$
	"BREAKPOINT+1						(SYSTEM/built-in) 					P            Index:input /AFTER:input /CLEAR /CONDITION:input /DISABLE /ENABLE /ON_RECOMPILE /ONCE /SET",			$
	"BREAKPOINT+2						(SYSTEM/built-in) 					P File:input Index:input /AFTER:input /CLEAR /CONDITION:input /DISABLE /ENABLE /ON_RECOMPILE /ONCE /SET",			$
	"BROYDEN						(SYSTEM/built-in) 					F X:input Vecfunc:input /CHECK:output /DOUBLE /EPS:input /ITMAX:input /STEPMAX:input /TOLF:input /TOLMIN:input /TOLX:input",			$
	"BYTARR							(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /NOZERO",			$
	"BYTE							(SYSTEM/built-in) 					F Expression:input [Offset:input] [D1:input] [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]", $
	"BYTEORDER						(SYSTEM/built-in) 					P Variable1:input [Variablen:inputs] /DTOVAX:input /DTOXDR:input /FTOVAX:input /FTOXDR:input /HTONL:input /HTONS:input /L64SWAP:input /LSWAP:input /NTOHL:input /NTOHS:input /SSWAP:input /SWAP_IF_BIG_ENDIAN:input /SWAP_IF_LITTLE_ENDIAN:input /VAXTOD:input /VAXTOF:input /XDRTOD:input /XDRTOF:input",	$
	"BYTSCL							(SYSTEM/built-in) 					F Array:input [min:input] [max:input] /MAX:input /MIN:input /NAN /TOP:input",	$
	"BREAK							(SYSTEM/built-in) 					P",	$
	"CALL_EXTERNAL						(SYSTEM/built-in) 					F Image:input Entry:input [P:inputs] /ALL_VALUE /B_VALUE /D_VALUE /F_VALUE /I_VALUE /L64_VALUE /S_VALUE /UI_VALUE /UL_VALUE /UL64_VALUE /CDECL /RETURN_TYPE:input /UNLOAD /VALUE:input /WRITE_WRAPPER:input /AUTO_GLUE /CC:input /COMPILE_DIRECTORY:input /EXTRA_CFLAGS:input /EXTRA_LFLAGS:input /IGNORE_EXISTING_GLUE /LD:input /NOCLEANUP /SHOW_ALL_OUTPUT /VERBOSE",	$
	"CALL_FUNCTION						(SYSTEM/built-in) 					F Name:input [P:inputs]",	$
	"CALL_METHOD						(SYSTEM/built-in) 					F Name:input ObjRef:input [P:inputs]",$
	"CALL_METHOD						(SYSTEM/built-in) 					P Name:input ObjRef:input [P:inputs]",$
	"CALL_PROCEDURE						(SYSTEM/built-in) 					P Name:input [P:inputs]",	$
	"CATCH							(SYSTEM/built-in) 					P [Variable:output] /CANCEL",			$
	"CD							(SYSTEM/built-in) 					P [Directory:input] /CURRENT:output",			$
	"CEIL							(SYSTEM/built-in) 					F X:input /L64",		$
	"CHECK_MATH						(SYSTEM/built-in) 					F [input] [input] /MASK:input /NOCLEAR /PRINT /TRAP:input",			$
	"CHOLDC							(SYSTEM/built-in) 					P A:input P:output",			$
	"CHOLSOL						(SYSTEM/built-in) 					F A:input P:input B:input /DOUBLE",			$
	"CINDGEN						(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",	$
	"CLOSE							(SYSTEM/built-in) 					P [Unit:inputs] /ALL /EXIT_STATUS:output /FILE /FORCE",		$ 
	"COLOR_CONVERT						(SYSTEM/built-in) 					P I0:input I1:input I2:input O0:output O1:output O2:output /HLS_RGB /HSV_RGB /RGB_HLS /RGB_HSV",	$
	"COLOR_QUAN+1						(SYSTEM/built-in) 					F Image:input   Dim:input                   R:output G:output B:output         /COLORS:input /CUBE:input /GET_TRANSLATION:output /MAP_ALL:input /DITHER /ERROR:output /TRANSLATION:input",		$
	"COLOR_QUAN+2						(SYSTEM/built-in) 					F Image_R:input Image_G:input Image_B:input R:output G:output B:output         /COLORS:input /CUBE:input /GET_TRANSLATION:output /MAP_ALL:input /DITHER /ERROR:output /TRANSLATION:input",		$
	"COMMAND_LINE_ARGS					(SYSTEM/built-in)					F /COUNT:output",	$
	"COMPLEX+1						(SYSTEM/built-in) 					F Real:input [Imaginary:input] /DOUBLE",			$
	"COMPLEX+2						(SYSTEM/built-in) 					F Expression:input Offset:input D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /DOUBLE",			$
	"COMPLEXARR						(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /NOZERO",			$
	"COMPUTE_MESH_NORMALS					(SYSTEM/built-in) 					F fVerts:input [iConn:input] ",			$
	"CONJ							(SYSTEM/built-in) 					F X:input",			$
	"CONSTRAINED_MIN					(SYSTEM/built-in) 					P X:input Xbnd:input Gbnd:input Nobj:input Gcomp:input Inform:output /EPSTOP:input /LIMSER:input /MAXIMIZE /NSTOP:input /REPORT:input /TITLE:input",			$
	"CONTINUE						(SYSTEM/built-in) 					P",	$
	"CONTOUR						(SYSTEM/built-in) 					P Z:input [X:input] [Y:input] /C_ANNOTATION:input /C_CHARSIZE:input /C_CHARTHICK:input /C_COLORS:input /C_LABELS:input /C_LINESTYLE:input /CELL_FILL /FILL /C_ORIENTATION:input /C_SPACING:input /C_THICK:input /CLOSED /DOWNHILL /FOLLOW /IRREGULAR /ISOTROPIC /LEVELS:input /NLEVELS:input /MAX_VALUE:input /MIN_VALUE:input /OVERPLOT /PATH_DATA_COORDS /PATH_FILENAME:input /PATH_INFO:output /PATH_XY:output /TRIANGULATION:output /PATH_DOUBLE /XLOG /YLOG /ZAXIS:input",	$
	"CONVERT_COORD						(SYSTEM/built-in) 					F X:input [Y:input] [Z:input] /DATA /DEVICE /NORMAL /DOUBLE /T3D /TO_DATA /TO_DEVICE /TO_NORMAL",	$
	"CONVOL							(SYSTEM/built-in) 					F Array:input Kernel:input [Scale_Factor:input] /BIAS:input /CENTER /EDGE_TRUNCATE /EDGE_WRAP /EDGE_ZERO /INVALID:input /MISSING:input /NAN /NORMALIZE",	$
	"COPY_LUN						(SYSTEM/built-in) 					P FromUnit:input ToUnit:input [Num:input] /EOF /LINES /TRANSFER_COUNT",			$
	"COS							(SYSTEM/built-in) 					F X:input",		$
	"COSH							(SYSTEM/built-in)					F X:input",			$
	"CPU							(SYSTEM/built-in) 					P /RESET /RESTORE:input /TPOOL_MAX_ELTS:input /TPOOL_MIN_ELTS:input /TPOOL_NTHREADS:input /VECTOR_ENABLE",			$
	"CREATE_STRUCT						(SYSTEM/built-in) 					F [inputs:inputs] /NAME:input",			$
	"CURSOR							(SYSTEM/built-in) 					P X:output Y:output [Wait:input] /CHANGE /DOWN /NOWAIT /UP /WAIT",	$
	"DBLARR							(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /NOZERO",		$
	"DCINDGEN						(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",			$
	"DCOMPLEX+1						(SYSTEM/built-in) 					F Real:input [Imaginary:input]",			$
	"DCOMPLEX+2						(SYSTEM/built-in) 					F Expression:input Offset:input D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",			$
	"DCOMPLEXARR						(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /NOZERO",			$
	"DEFINE_KEY						(SYSTEM/built-in) 					P Key:input [Value:input] /MATCH_PREVIOUS /NOECHO /TERMINATE /BACK_CHARACTER /BACK_WORD /CONTROL /ESCAPE /DELETE_CHARACTER /DELETE_CURRENT /DELETE_EOL /DELETE_LINE /DELETE_WORD /END_OF_FILE /END_OF_LINE /ENTER_LINE /FORWARD_CHARACTER /FORWARD_WORD /INSERT_OVERSTRIKE_TOGGLE /NEXT_LINE /PREVIOUS_LINE /RECALL /REDRAW /START_OF_LINE",	$
	"DEFINE_MSGBLK						(SYSTEM/built-in) 					P BlockName:input ErrorNames:input ErrorFormats:input /IGNORE_DUPLICATE /PREFIX:input",	$
	"DEFSYSV+1						(SYSTEM/built-in) 					P Name:input             [Read_Only:input] /EXISTS:output",	$
	"DEFSYSV+2						(SYSTEM/built-in) 					P Name:input Value:input [Read_Only:input]",	$
	"DELVAR							(SYSTEM/built-in) 					P V1:input [Vn:inputs]",			$
	"DELLOG							(SYSTEM/built-in) 					P p1:input",	$
	"DEVICE							(SYSTEM/built-in) 					P /AVANTGARDE /BKMAN /COURIER /HELVETICA /ISOLATIN1 /PALATINO /SCHOOLBOOK /SYMBOL /TIMES /ZAPFCHANCERY /ZAPFDINGBATS /AVERAGE_LINES /BINARY /NCAR /TEXT /BITS_PER_PIXEL:input /BOLD /BOOK /BYPASS_TRANSLATION /CLOSE /CLOSE_DOCUMENT /CLOSE_FILE /CMYK /COLOR /COLORS:input /COPY:input /CURSOR_CROSSHAIR /CURSOR_IMAGE:input /CURSOR_MASK:input /CURSOR_ORIGINAL /CURSOR_STANDARD:input /CURSOR_XY:input /DECOMPOSED /DIRECT_COLOR /EJECT:input /ENCAPSULATED:input /ENCODING:input /FILENAME:input /FLOYD /FONT_INDEX:input /FONT_SIZE:input /GET_CURRENT_FONT:output /GET_DECOMPOSED:output /GET_FONTNAMES:output /GET_FONTNUM:output /GET_GRAPHICS_FUNCTION:output /GET_PAGE_SIZE:output /GET_SCREEN_SIZE:output /GET_VISUAL_DEPTH:output /GET_VISUAL_NAME:output /GET_WINDOW_POSITION:output /GET_WRITE_MASK:output /GIN_CHARS:input /GLYPH_CACHE:input /INCHES /INDEX_COLOR /ITALIC /LANDSCAPE /PORTRAIT /LANGUAGE_LEVEL:input /DEMI /LIGHT /MEDIUM /NARROW /OBLIQUE /OPTIMIZE:input /ORDERED /OUTPUT:input /PIXELS /PLOT_TO:input /PLOTTER_ON_OFF /POLYFILL /PRE_DEPTH:input /PRE_XSIZE:input /PRE_YSIZE:input /PREVIEW /PRINT_FILE:input /PSEUDO_COLOR:input /RESET_STRING:input /RESOLUTION:input /RETAIN:input /SCALE_FACTOR:input /SET_CHARACTER_SIZE:input /SET_COLORMAP:input /SET_COLORS:input /SET_FONT:input /SET_GRAPHICS_FUNCTION:input /SET_RESOLUTION:input /SET_STRING:input /SET_TRANSLATION:input /SET_WRITE_MASK:input /STATIC_COLOR:input /STATIC_GRAY:input /TEK4014 /TEK4100 /THRESHOLD:input /TRANSLATION:output /TRUE_COLOR:input /TT_FONT /TTY /VT240 /VT241 /VT340 /VT341 /WINDOW_STATE:output /XOFFSET:input /XON_XOFF:input /XSIZE:input /YOFFSET:input /YSIZE:input /Z_BUFFERING:input /DEPTH:input",	$
	"DFPMIN							(SYSTEM/built-in) 					P X:input Gtol:input Fmin:output Func:input Dfunc:input /DOUBLE /EPS:input /ITER:output /ITMAX:input /STEPMAX:input /TOLX:input",			$
	"DIAG_MATRIX						(SYSTEM/built-in) 					F A:input [Diag:input]",			$
	"DIALOG_MESSAGE						(SYSTEM/built-in) 					F Message_Text:input  /CANCEL /CENTER /DEFAULT_CANCEL /DEFAULT_NO /DIALOG_PARENT:input /DISPLAY_NAME:input /ERROR /INFORMATION /QUESTION /RESOURCE_NAME:input /TITLE:input",	$
	"DIALOG_PICKFILE					(SYSTEM/built-in) 					F /DEFAULT_EXTENSION:input /DIRECTORY /DIALOG_PARENT:input /DISPLAY_NAME:input /FILE:input /FILTER:input /FIX_FILTER /GET_PATH:output /GROUP:input /MULTIPLE_FILES /MUST_EXIST /OVERWRITE_PROMPT /PATH:input /READ /WRITE /RESOURCE_NAME:input /TITLE:input /NOCONFIRM",	$
	"DIALOG_PRINTERSETUP					(SYSTEM/built-in) 					F [PrintDestination:input] /DIALOG_PARENT:input /DISPLAY_NAME:input /RESOURCE_NAME:input /TITLE:input",	$
	"DIALOG_PRINTJOB					(SYSTEM/built-in) 					F [PrintDestination:input] /DIALOG_PARENT:input /DISPLAY_NAME:input /RESOURCE_NAME:input /TITLE:input",	$
	"DILATE							(SYSTEM/built-in) 					F Image:input Structure:input [X0:input] [Y0:input] [Z0:input] /CONSTRAINED /BACKGROUND:input /GRAY /PRESERVE_TYPE /UINT /ULONG /VALUES:input",	$
	"DINDGEN						(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",			$
	"DLM_LOAD						(SYSTEM/built-in) 					P DLMNameStr1:input [DLMNameStrn:inputs]",			$
	"DLM_REGISTER						(SYSTEM/built-in) 					P DLMDefFilePath1:input [DLMDefFilePathn:inputs]",			$
	"DOUBLE							(SYSTEM/built-in) 					F Expression:input [Offset:input] [D1:input] [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",		$
	"DRAW_ROI						(SYSTEM/built-in) 					P oROI:input  /LINE_FILL /SPACING:input",			$
	"ELMHES							(SYSTEM/built-in) 					F A:input /COLUMN /DOUBLE /NO_BALANCE",			$
	"EMPTY							(SYSTEM/built-in) 					P",			$
	"ENABLE_SYSRTN						(SYSTEM/built-in) 					P [Routines:input] /DISABLE /EXCLUSIVE /FUNCTIONS",			$
	"EOF							(SYSTEM/built-in) 					F Unit:input",		$
	"EOS_SW_WRITEGEOMETAA					(SYSTEM/built-in) 					F",			$
	"ERASE							(SYSTEM/built-in) 					P [Background_Color:input]",		$
	"ERF							(SYSTEM/built-in) 					F Z:input",			$
	"ERFC							(SYSTEM/built-in) 					F Z:input",			$
	"ERFCX							(SYSTEM/built-in) 					F Z:input",			$
	"ERODE							(SYSTEM/built-in) 					F Image:input Structure:input [X0:input] [Y0:input] [Z0:input] /GRAY /PRESERVE_TYPE /UINT /ULONG /VALUES:input",			$
	"ERRORF							(SYSTEM/built-in) 					F X:input",	$
	"EXECUTE						(SYSTEM/built-in) 					F String:input [QuietCompile:input] [QuietExecution:input]",			$
	"EXIT							(SYSTEM/built-in) 					P /NO_CONFIRM /STATUS:input",			$
	"EXP							(SYSTEM/built-in) 					F Expression:input",		$
	"EXPAND_PATH						(SYSTEM/built-in) 					F String:input /ALL_DIRS /ARRAY /COUNT:output /DLM /HELP",			$
	"EXPINT							(SYSTEM/built-in) 					F N:input X:input /DOUBLE /EPS:input /ITER:output /ITMAX:input",			$
	"FFT							(SYSTEM/built-in) 					F Array:input [Direction:input] /DIMENSION:input /DOUBLE /INVERSE /OVERWRITE",			$
	"FILE_BASENAME						(SYSTEM/built-in) 					F Path:input [RemoveSuffix:input] /FOLD_CASE",		$
	"FILE_CHMOD						(SYSTEM/built-in) 					P File:input [Mode:input] /A_EXECUTE /A_READ /A_WRITE /G_EXECUTE /G_READ /G_WRITE /NOEXPAND_PATH /O_EXECUTE /O_READ /O_WRITE /U_EXECUTE /U_READ /U_WRITE /SETGID /SETUID /STICKY_BIT",	$
	"FILE_COPY						(SYSTEM/built-in) 					P SourcePath:input DestPath:input /ALLOW_SAME /NOEXPAND_PATH /OVERWRITE /RECURSIVE /REQUIRE_DIRECTORY /VERBOSE /COPY_NAMED_PIPE /COPY_SYMLINK /FORCE",	$
	"FILE_DELETE						(SYSTEM/built-in)					P File1:input [Filen:inputs] /ALLOW_NONEXISTENT /NOEXPAND_PATH /QUIET /RECURSIVE /VERBOSE",	$
	"FILE_DIRNAME						(SYSTEM/built-in) 					F Path:input /MARK_DIRECTORY",	$
	"FILE_EXPAND_PATH					(SYSTEM/built-in) 					F Path:input",			$
	"FILE_INFO						(SYSTEM/built-in) 					F Path:input /NOEXPAND_PATH:input",		$
	"FILE_LINES						(SYSTEM/built-in) 					F Path:input /COMPRESS /NOEXPAND_PATH",	$
	"FILE_LINK						(SYSTEM/built-in) 					P SourcePath:input DestPath:input /ALLOW_SAME /HARDLINK /NOEXPAND_PATH /VERBOSE",			$
	"FILE_MKDIR						(SYSTEM/built-in) 					P File1:input [FileN:inputs] /NOEXPAND_PATH",	$
	"FILE_MOVE						(SYSTEM/built-in) 					P SourcePath:input DestPath:input /ALLOW_SAME /NOEXPAND_PATH /OVERWRITE /REQUIRE_DIRECTORY /VERBOSE",	$
	"FILE_POLL_INPUT					(SYSTEM/built-in) 					F Units:input /COUNT:output /TIMEOUT:input",			$
	"FILE_READLINK						(SYSTEM/built-in) 					F Path:input /ALLOW_NONEXISTENT /ALLOW_NONSYMLINK /NOEXPAND_PATH",			$
	"FILE_SAME						(SYSTEM/built-in) 					F Path1:input Path2:input /NOEXPAND_PATH",			$
	"FILE_SEARCH						(SYSTEM/built-in) 					F [Dir_Specification:input] [Recur_Pattern:input] /COUNT:output /EXPAND_ENVIRONMENT /EXPAND_TILDE /FOLD_CASE /FULLY_QUALIFY_PATH /ISSUE_ACCESS_ERROR /MARK_DIRECTORY /MATCH_ALL_INITIAL_DOT /MATCH_INITIAL_DOT /NOSORT /QUOTE /TEST_DIRECTORY /TEST_EXECUTABLE /TEST_READ /TEST_REGULAR /TEST_WRITE /TEST_ZERO_LENGTH /WINDOWS_SHORT_NAMES /TEST_BLOCK_SPECIAL /TEST_CHARACTER_SPECIAL /TEST_DANGLING_SYMLINK /TEST_GROUP /TEST_NAMED_PIPE /TEST_SETGID /TEST_SETUID /TEST_SOCKET /TEST_STICKY_BIT /TEST_SYMLINK /TEST_USER",	$
	"FILE_TEST						(SYSTEM/built-in) 					F File:input /DIRECTORY /EXECUTABLE /READ /REGULAR /WRITE /ZERO_LENGTH /GET_MODE:output /NOEXPAND_PATH /BLOCK_SPECIAL /CHARACTER_SPECIAL /DANGLING_SYMLINK /GROUP /NAMED_PIPE /SETGID /SETUID /SOCKET /STICKY_BIT /SYMLINK /USER",	$
	"FINDGEN						(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",			$
	"FINDFILE						(SYSTEM/built-in) 					F [File_Specification:input] /COUNT:output",			$
	"FINITE							(SYSTEM/built-in) 					F X:input /INFINITY /NAN /SIGN:input",		$
	"FIX							(SYSTEM/built-in) 					F Expression:input [Offset:input] [D1:input] [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /PRINT /TYPE:input",	$
	"FLOAT							(SYSTEM/built-in) 					F Expression:input [Offset:input] [D1:input] [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",	$
	"FLOOR							(SYSTEM/built-in) 					F X:input /L64:input",		$
	"FLTARR							(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /NOZERO",			$
	"FLUSH							(SYSTEM/built-in) 					P Unit1:input [Unitn:inputs]",	$
	"FORMAT_AXIS_VALUES					(SYSTEM/built-in) 					F Values:input",			$
	"FREE_LUN						(SYSTEM/built-in) 					P Unit1:input [Unitn:inputs] /EXIT_STATUS:input /FORCE",	$
	"FSTAT							(SYSTEM/built-in) 					F Unit:input",		$
	"FULSTR							(SYSTEM/built-in) 					F A:input",			$
	"FZ_ROOTS						(SYSTEM/built-in) 					F C:input /DOUBLE /EPS:input /NO_POLISH:input",			$
	"GAUSSINT						(SYSTEM/built-in) 					F X:input",			$
	"GET_DRIVE_LIST						(SYSTEM/built-in) 					F /COUNT:output /CDROM /FIXED /REMOTE /REMOVABLE",			$
	"GET_KBRD						(SYSTEM/built-in) 					F [Wait:input] /ESCAPE /KEY_NAME",			$
	"GET_LUN						(SYSTEM/built-in)	 				P Unit:output",			$
	"GET_LOGIN_INFO						(SYSTEM/built-in)	 				F",			$
	"GETENV							(SYSTEM/built-in) 					F [Name:input] /ENVIRONMENT",		$
	"GOTO							(SYSTEM/built-in) 					P label:input#LABEL",		$
	"GRID3							(SYSTEM/built-in) 					F X:input Y:input Z:input F:input [Gx:input] [Gy:input] [Gz:input] /DELTA:input /DTOL:input /GRID:input /NGRID:input /START",			$
	"HANDLE_CREATE						(SYSTEM/built-in) 					F [ID:input] /FIRST_CHILD /NO_COPY /SIBLING /VALUE:input",	$
	"HANDLE_FREE						(SYSTEM/built-in) 					P ID:input",			$
	"HANDLE_INFO						(SYSTEM/built-in) 					F ID:input /FIRST_CHILD /NUM_CHILDREN /PARENT /SIBLING /VALID_ID",			$
	"HANDLE_MOVE						(SYSTEM/built-in) 					P Static_ID:input Move_ID:input",			$
	"HANDLE_VALUE+1						(SYSTEM/built-in) 					P ID:input Value:input  /SET /NO_COPY",			$
	"HANDLE_VALUE+2						(SYSTEM/built-in) 					P ID:input Value:output      /NO_COPY",			$
	"HDF_READ						(SYSTEM/built-in) 					F [Filename:input] /DFR8:output /DF24:output /PREFIX:input /TEMPLATE:input",			$
	"HDF_BROWSER						(SYSTEM/built-in) 					F",			$
	"HEAP_FREE						(SYSTEM/built-in) 					P Var:input /OBJ /PTR /VERBOSE",	$
	"HEAP_GC						(SYSTEM/built-in) 					P /OBJ /PTR /VERBOSE",			$
	"HEAP_SAVE						(SYSTEM/built-in)					F HeapVar:input [Set:input]",	$
	"HEAP_NOSAVE						(SYSTEM/built-in) 					P HeapVar:input",	$
	"HELP							(SYSTEM/built-in) 					P [Expressionn:inputs] /BREAKPOINTS /BRIEF /DEVICE /DLM /FILES /FULL /FUNCTIONS /HEAP_VARIABLES /KEYS /LAST_MESSAGE /LEVEL:input /MEMORY /MESSAGES /NAMES:input /OBJECTS /OUTPUT:output /PATH_CACHE /PREFERENCES /PROCEDURES /RECALL_COMMANDS /ROUTINES /SHARED_MEMORY /SOURCE_FILES /STRUCTURES /SYSTEM_VARIABLES /TRACEBACK /CALLS[not_found_in_v6.3_documentation_but_OK]:output",	$
	"HISTOGRAM						(SYSTEM/built-in) 					F Array:input /BINSIZE:input /INPUT:input /LOCATIONS:output /MAX:input /MIN:input /NAN /NBINS:input /OMAX:output /OMIN:output /L64 /REVERSE_INDICES:output",	$
	"HOUGH+1						(SYSTEM/built-in) 					F Array:input /DOUBLE /DRHO:input /DX:input /DY:input /GRAY /NRHO:input /NTHETA:input /RHO:output /RMIN:input /THETA:output /XMIN:input /YMIN:input",	$
	"HOUGH+2						(SYSTEM/built-in) 					F Array:input /BACKPROJECT /RHO:output /THETA:output /DOUBLE /DX:input /DY:input /NX:input /NY:input /XMIN:input /YMIN:input",	$
	"HQR							(SYSTEM/built-in) 					F A:input /COLUMN /DOUBLE",			$
	"IDL_VALIDNAME						(SYSTEM/built-in) 					F String:input /CONVERT_ALL /CONVERT_SPACES",	$
	"IDL_IGAMMA						(SYSTEM/built-in) 					F p1:input p2:input",	$
	"IDLEXBR_ASSISTANT					(SYSTEM/built-in)					P /COLUMNHEIGHT:input /COLUMNWIDTH:input /COM /OBJECT_FILE:input /PROJECT_FILE:input /DRAWABLE_EVENTHANDLERS",	$
	"IMAGE_STATISTICS					(SYSTEM/built-in) 					P Data:input /COUNT:output /DATA_SUM:output /LABELED /LUT:input /MASK:input /MAXIMUM:output /MEAN:output /MINIMUM:output /STDDEV:output /SUM_OF_SQUARES:output /VARIANCE:output /VECTOR /WEIGHT_SUM:output /WEIGHTED",			$
	"IMAGINARY						(SYSTEM/built-in) 					F Complex_Expression:input",			$
	"INDGEN							(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /BYTE /COMPLEX /DCOMPLEX /DOUBLE /FLOAT /L64 /LONG /STRING /UINT /UL64 /ULONG /TYPE:input",	$
	"INTARR							(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /NOZERO",	$
	"INTERPOLATE						(SYSTEM/built-in) 					F P:input X:input [Y:input] [Z:input] /CUBIC:input /GRID /MISSING:input",	$
	"INTERVAL_VOLUME					(SYSTEM/built-in) 					P Data:input Value0:input Value1:input Outverts:output Outconn:output /AUXDATA_IN:input /AUXDATA_OUT:output /GEOM_XYZ:input /TETRAHEDRA:input /PROGRESS_CALLBACK:input /PROGRESS_METHOD:input /PROGRESS_OBJECT:input /PROGRESS_PERCENT:input /PROGRESS_USERDATA:input",			$
	"INVERT							(SYSTEM/built-in) 					F Array:input [Status:output] /DOUBLE",	$
	"IOCTL							(SYSTEM/built-in) 					F File_Unit:input [Request:input] [Arg:output] /BY_VALUE /MT_OFFLINE /MT_REWIND /MT_SKIP_FILE:input /MT_SKIP_RECORD:input /MT_WEOF /SUPPRESS_ERROR",	$
	"ISHFT							(SYSTEM/built-in) 					F P1:input P2:input",		$
	"ISOCONTOUR						(SYSTEM/built-in) 					P Values:input Outverts:output Outconn:output /AUXDATA_IN:input /AUXDATA_OUT:output /C_LABEL_INTERVAL:input /C_LABEL_SHOW:input /C_VALUE:input /DOUBLE /FILL /GEOMX:input /GEOMY:input /GEOMZ:input /LEVEL_VALUES:input /N_LEVELS:input /OUT_LABEL_OFFSETS:output /OUT_LABEL_POLYLINES:output /OUT_LABEL_STRINGS:output /OUTCONN_INDICES:output /POLYGONS:input",			$
	"ISOSURFACE						(SYSTEM/built-in) 					P Data:input Value:input Outverts:output Outconn:output /GEOM_XYZ:input /TETRAHEDRA:input /AUXDATA_IN:input /AUXDATA_OUT:output /PROGRESS_CALLBACK:input /PROGRESS_METHOD:input /PROGRESS_OBJECT:input /PROGRESS_PERCENT:input /PROGRESS_USERDATA:input",			$
	"JOURNAL						(SYSTEM/built-in) 					P [Arg:input]",			$
	"KEYWORD_SET						(SYSTEM/built-in) 					F Expression:input#UNDEFINED",		$
	"L64INDGEN						(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",	$
	"LABEL_REGION						(SYSTEM/built-in) 					F Data:input /ALL_NEIGHBORS /ULONG",			$
	"LEGENDRE						(SYSTEM/built-in) 					F X:input L:input [M:input] /DOUBLE",			$
	"LINBCG							(SYSTEM/built-in) 					F A:input B:input X:input /DOUBLE /ITOL:input /TOL:input /ITER:output /ITMAX:input",			$
	"LINDGEN						(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",	$
	"LINKIMAGE						(SYSTEM/built-in) 					P Name:input Image:input [Type:input] [Entry:input] /DEVICE /FUNCT /KEYWORDS /MAX_ARGS:input /MIN_ARGS:input",			$
	"LMGR							(SYSTEM/built-in) 					F [dlm:input] /CLIENTSERVER /DEMO /EMBEDDED /RUNTIME /STUDENT /TRIAL /VM /EXPIRE_DATE:output /FORCE_DEMO /INSTALL_NUM:output /LMHOSTID:output /SITE_NOTICE:output /VERSION:input",	$
	"LNGAMMA						(SYSTEM/built-in) 					F Z:input",			$
	"LNP_TEST						(SYSTEM/built-in) 					F X:input Y:input /DOUBLE /HIFAC:input /JMAX:output /OFAC:input /WK1:output /WK2:output",			$
	"LOCALE_GET						(SYSTEM/built-in) 					F",			$
	"LOGICAL_AND						(SYSTEM/built-in) 					F Arg1:input Arg2:input",			$
	"LOGICAL_OR						(SYSTEM/built-in) 					F Arg1:input Arg2:input",			$
	"LOGICAL_TRUE						(SYSTEM/built-in) 					F Arg:input",			$
	"LON64ARR						(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /NOZERO",	$
	"LONARR							(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /NOZERO",	$
	"LONG							(SYSTEM/built-in) 					F Expression:input [Offset:input] [D1:input] [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",	$
	"LONG64							(SYSTEM/built-in) 					F Expression:input [Offset:input] [D1:input] [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",	$
	"LSODE							(SYSTEM/built-in) 					F Y:input X:input H:input Derivs:input [Status:input] /ATOL:input /QUIET /RTOL:input",			$
	"LUDC							(SYSTEM/built-in) 					P A:input Index:output /COLUMN /DOUBLE /INTERCHANGES:output",			$
	"LUMPROVE						(SYSTEM/built-in) 					F A:input Alud:input Index:input B:input X:input /COLUMN /DOUBLE",			$
	"LUSOL							(SYSTEM/built-in) 					F A:input Index:input B:input /COLUMN /DOUBLE",			$
	"MACHAR							(SYSTEM/built-in) 					F /DOUBLE",			$
	"MAKE_ARRAY						(SYSTEM/built-in) 					F [D1:input] [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /BYTE /COMPLEX /DCOMPLEX /DOUBLE /FLOAT /INTEGER /L64 /LONG /OBJ /PTR /STRING /UINT /UL64 /ULONG /DIMENSION:input /INDEX /NOZERO /SIZE:input /TYPE:input /VALUE:input",	$
	"MAKE_EVENT_MASK					(SYSTEM/built-in) 					F /BUTTON_EVENTS /MOTION_EVENTS /KEYBOARD_EVENTS",	$
	"MAKE_DLL+1						(SYSTEM/built-in) 					P InputFiles:input                  ExportedRoutineNames:input /CC:input /COMPILE_DIRECTORY:input /DLL_PATH:output /EXPORTED_DATA:input /EXTRA_CFLAGS:input /EXTRA_LFLAGS:input /INPUT_DIRECTORY:input /LD:input /NOCLEANUP /OUTPUT_DIRECTORY:input /REUSE_EXISTING /SHOW_ALL_OUTPUT /VERBOSE",	$
	"MAKE_DLL+2						(SYSTEM/built-in) 					P InputFiles:input OutputFile:input ExportedRoutineNames:input /CC:input /COMPILE_DIRECTORY:input /DLL_PATH:output /EXPORTED_DATA:input /EXTRA_CFLAGS:input /EXTRA_LFLAGS:input /INPUT_DIRECTORY:input /LD:input /NOCLEANUP /OUTPUT_DIRECTORY:input /REUSE_EXISTING /SHOW_ALL_OUTPUT /VERBOSE",	$
	"MAP_PROJ_FORWARD					(SYSTEM/built-in) 					F Longitude:input [Latitude:input] /CONNECTIVITY:input /FILL /MAP_STRUCTURE:input /POLYGONS:output /POLYLINES:output /RADIANS",			$
	"MAP_PROJ_INVERSE					(SYSTEM/built-in) 					F X:input [Y:input] /MAP_STRUCTURE:input /RADIANS",			$
	"MATRIX_MULTIPLY					(SYSTEM/built-in) 					F A:input B:input /ATRANSPOSE /BTRANSPOSE",			$
	"MAP_CLIP_SET						(SYSTEM/built-in) 					P /MAP:input /CLIP_PLANE:input /RESET /TRANSFORM /CLIP_UV:input /SPLIT:input",	$
	"MAP_PROJ_GCTP_FORINIT					(SYSTEM/built-in) 					P p1:input p2:input p3:input p4:input",	$
	"MAP_PROJ_GCTP_REVINIT					(SYSTEM/built-in) 					P p1:input p2:input p3:input p4:input",	$
	"MAX							(SYSTEM/built-in) 					F Array:input [Max_Subscript:output] /ABSOLUTE /DIMENSION:input /MIN:output /NAN /SUBSCRIPT_MIN:output",	$
	"MEDIAN							(SYSTEM/built-in) 					F Array:input [Width:input] /DOUBLE /DIMENSION:input /EVEN",	$
	"MEMORY							(SYSTEM/built-in) 					F /CURRENT /HIGHWATER /NUM_ALLOC /NUM_FREE /STRUCTURE /L64",			$
	"MESH_CLIP						(SYSTEM/built-in) 					F Plane:input Vertsin:input Connin:input Vertsout:output Connout:output /AUXDATA_IN:input /AUXDATA_OUT:output /CUT_VERTS:output",			$
	"MESH_DECIMATE						(SYSTEM/built-in) 					F Verts:input Conn:input Connout:output /VERTICES:output /PERCENT_VERTICES:input /PERCENT_POLYGONS:input /PROGRESS_CALLBACK:input /PROGRESS_METHOD:input /PROGRESS_OBJECT:input /PROGRESS_PERCENT:input /PROGRESS_USERDATA:input",			$
	"MESH_ISSOLID						(SYSTEM/built-in) 					F Conn:input",			$
	"MESH_MERGE						(SYSTEM/built-in) 					F Verts:input Conn:input Verts1:input Conn1:input /COMBINE_VERTICES /TOLERANCE:input",			$
	"MESH_NUMTRIANGLES					(SYSTEM/built-in) 					F Conn:input",			$
	"MESH_SMOOTH						(SYSTEM/built-in) 					F Verts:input Conn:input /ITERATIONS:input /FIXED_VERTICES:input /FIXED_EDGE_VERTICES /LAMBDA:input",			$
	"MESH_SURFACEAREA					(SYSTEM/built-in) 					F Verts:input Conn:input /AUXDATA:input /MOMENT:output",			$
	"MESH_VALIDATE						(SYSTEM/built-in) 					F Verts:input Conn:input /REMOVE_NAN /PACK_VERTICES /COMBINE_VERTICES /TOLERANCE:input",			$
	"MESH_VOLUME						(SYSTEM/built-in) 					F Verts:input Conn:input /SIGNED",			$
	"MESSAGE						(SYSTEM/built-in) 					P [ArgN:inputs] /REISSUE_LAST  /NAME:input /BLOCK:input /CONTINUE /LEVEL:input /INFORMATIONAL /IOERROR /NONAME /NOPREFIX /NOPRINT /RESET /TRACEBACK",	$
	; trop compliqu
	;"MESSAGE+1						(SYSTEM/built-in) 					P /REISSUE_LAST",	$
	;"MESSAGE+2						(SYSTEM/built-in) 					P [Text:input#CONSTANT_STRING]                          /CONTINUE /LEVEL:input /INFORMATIONAL /IOERROR /NONAME /NOPREFIX /NOPRINT /RESET",	$
	;"MESSAGE+3						(SYSTEM/built-in) 					P [ArgN:inputs]                /NAME:input /BLOCK:input /CONTINUE /LEVEL:input /INFORMATIONAL /IOERROR /NONAME /NOPREFIX /NOPRINT /RESET",	$
	"MIN							(SYSTEM/built-in) 					F Array:input [Min_Subscript:output] /ABSOLUTE /DIMENSION:input /MAX:output /NAN /SUBSCRIPT_MAX:output",	$
	"MORPH_DISTANCE						(SYSTEM/built-in) 					F Data:input /BACKGROUND /NEIGHBOR_SAMPLING:input /NO_COPY",			$
	"MRQMIN							(SYSTEM/built-in)					P function_name:input xx:input yy:input ssig:input ndata:input a:output fita:output ma:output covar:output alpha:output chisq:output alambda:output /DOUBLE:input /ITMIN:input /ITMAX:input /TOLERANCE:input /NITER:input",	$
	"N_ELEMENTS						(SYSTEM/built-in) 					F Expression:input#UNDEFINED",		$					; la doc est fausse N_PARAMS		(
	"N_PARAMS						(SYSTEM/built-in)		 			F [xxx:input#UNDEFINED]",		$
	"N_TAGS							(SYSTEM/built-in) 					F Expression:input#UNDEFINED /DATA_LENGTH /LENGTH",	$
	"NEWTON							(SYSTEM/built-in) 					F X:input Vecfunc:input /CHECK:output /DOUBLE /ITMAX:input /STEPMAX:input /TOLF:input /TOLMIN:input /TOLX:input",			$
	"NR_GAMMA						(SYSTEM/built-in) 					F p1:input",	$
	"NR_TRED2						(SYSTEM/built-in) 					P A:input D:output E:output",		$
	"NR_TQLI						(SYSTEM/built-in) 					P D:input E:input A:output",		$
	"NR__SVDFIT						(SYSTEM/built-in)					P function_name:input xx:input yy:input ssig:input ndata:input a:output m:output covar:output chisq:output singular:output tol:output /DOUBLE:input",	$
	"OBJ_CLASS						(SYSTEM/built-in) 					F [Arg:input] /COUNT:output /SUPERCLASS",		$
	"OBJ_DESTROY						(SYSTEM/built-in) 					P ObjRef:input [Argn:inputs]",	$
	"OBJ_HASMETHOD						(SYSTEM/built-in) 					F ObjRef:input Method:input",	$
	"OBJ_ISA						(SYSTEM/built-in) 					F ObjectInstance:input ClassNameinput:input",			$
	"OBJ_NEW						(SYSTEM/built-in) 					F [ObjectClassName:input] [Argn:inputs]",		$
	"OBJ_VALID						(SYSTEM/built-in) 					F [input#UNDEFINED] /CAST /COUNT:output",		$
	"OBJARR							(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /NOZERO",			$
	"ON_ERROR						(SYSTEM/built-in) 					P N:input",		$
	"ON_IOERROR						(SYSTEM/built-in) 					P Label:input#LABEL",		$
	"ONLINE_HELP						(SYSTEM/built-in) 					P [Value:input] /BOOK:input /FULL_PATH /QUIT /CONTEXT",			$
	"OPENR+1						(SYSTEM/built-in) 					P Unit:input#CONSTANT_STRING#CONSTANT File:input [Record_Length:input] /APPEND /COMPRESS /BUFSIZE:input /DELETE /ERROR:output /F77_UNFORMATTED          /MORE /NOEXPAND_PATH /STDIO /SWAP_ENDIAN /SWAP_IF_BIG_ENDIAN /SWAP_IF_LITTLE_ENDIAN /VAX_FLOAT /WIDTH:input /XDR /RAWIO /BLOCK /STREAM /NONE /VARIABLE",	$
	"OPENR+2						(SYSTEM/built-in) 					P Unit:output                         File:input [Record_Length:input] /APPEND /COMPRESS /BUFSIZE:input /DELETE /ERROR:output /F77_UNFORMATTED /GET_LUN /MORE /NOEXPAND_PATH /STDIO /SWAP_ENDIAN /SWAP_IF_BIG_ENDIAN /SWAP_IF_LITTLE_ENDIAN /VAX_FLOAT /WIDTH:input /XDR /RAWIO /BLOCK /STREAM /NONE /VARIABLE",	$
	"OPENU+1						(SYSTEM/built-in) 					P Unit:input#CONSTANT_STRING#CONSTANT File:input [Record_Length:input] /APPEND /COMPRESS /BUFSIZE:input /DELETE /ERROR:output /F77_UNFORMATTED          /MORE /NOEXPAND_PATH /STDIO /SWAP_ENDIAN /SWAP_IF_BIG_ENDIAN /SWAP_IF_LITTLE_ENDIAN /VAX_FLOAT /WIDTH:input /XDR /RAWIO /BLOCK /STREAM /NONE /VARIABLE",	$
	"OPENU+2						(SYSTEM/built-in) 					P Unit:output                         File:input [Record_Length:input] /APPEND /COMPRESS /BUFSIZE:input /DELETE /ERROR:output /F77_UNFORMATTED /GET_LUN /MORE /NOEXPAND_PATH /STDIO /SWAP_ENDIAN /SWAP_IF_BIG_ENDIAN /SWAP_IF_LITTLE_ENDIAN /VAX_FLOAT /WIDTH:input /XDR /RAWIO /BLOCK /STREAM /NONE /VARIABLE",	$
	"OPENW+1						(SYSTEM/built-in) 					P Unit:input#CONSTANT_STRING#CONSTANT File:input [Record_Length:input] /APPEND /COMPRESS /BUFSIZE:input /DELETE /ERROR:output /F77_UNFORMATTED          /MORE /NOEXPAND_PATH /STDIO /SWAP_ENDIAN /SWAP_IF_BIG_ENDIAN /SWAP_IF_LITTLE_ENDIAN /VAX_FLOAT /WIDTH:input /XDR /RAWIO /BLOCK /STREAM /NONE /VARIABLE",	$
	"OPENW+2						(SYSTEM/built-in) 					P Unit:output                         File:input [Record_Length:input] /APPEND /COMPRESS /BUFSIZE:input /DELETE /ERROR:output /F77_UNFORMATTED /GET_LUN /MORE /NOEXPAND_PATH /STDIO /SWAP_ENDIAN /SWAP_IF_BIG_ENDIAN /SWAP_IF_LITTLE_ENDIAN /VAX_FLOAT /WIDTH:input /XDR /RAWIO /BLOCK /STREAM /NONE /VARIABLE",	$
	"OPLOT+1						(SYSTEM/built-in) 					P         Y:input /MAX_VALUE:input /MIN_VALUE:input /NSUM:input /POLAR",	$
	"OPLOT+2						(SYSTEM/built-in) 					P X:input Y:input /MAX_VALUE:input /MIN_VALUE:input /NSUM:input /POLAR",	$
	"PARTICLE_TRACE						(SYSTEM/built-in) 					P Data:input Seeds:input Verts:output Conn:output [Normals:output] /MAX_ITERATIONS:input /ANISOTROPY:input /INTEGRATION:input /SEED_NORMALS:input /TOLERANCE:input /MAX_STEPSIZE:input /UNIFORM",			$
	"PLOT+1							(SYSTEM/built-in) 					P         Y:input /ISOTROPIC /MAX_VALUE:input /MIN_VALUE:input /NSUM:input /POLAR /XLOG /YLOG /YNOZERO",	$
	"PLOT+2							(SYSTEM/built-in) 					P X:input Y:input /ISOTROPIC /MAX_VALUE:input /MIN_VALUE:input /NSUM:input /POLAR /XLOG /YLOG /YNOZERO",	$
	"PLOT_IO+1						(SYSTEM/built-in) 					P         Y:input /ISOTROPIC /MAX_VALUE:input /MIN_VALUE:input /NSUM:input /POLAR /XLOG /YLOG /YNOZERO",	$
	"PLOT_IO+2						(SYSTEM/built-in) 					P X:input Y:input /ISOTROPIC /MAX_VALUE:input /MIN_VALUE:input /NSUM:input /POLAR /XLOG /YLOG /YNOZERO",	$
	"PLOT_OI+1						(SYSTEM/built-in) 					P         Y:input /ISOTROPIC /MAX_VALUE:input /MIN_VALUE:input /NSUM:input /POLAR /XLOG /YLOG /YNOZERO",	$
	"PLOT_OI+2						(SYSTEM/built-in) 					P X:input Y:input /ISOTROPIC /MAX_VALUE:input /MIN_VALUE:input /NSUM:input /POLAR /XLOG /YLOG /YNOZERO",	$
	"PLOT_OO+1						(SYSTEM/built-in) 					P         Y:input /ISOTROPIC /MAX_VALUE:input /MIN_VALUE:input /NSUM:input /POLAR /XLOG /YLOG /YNOZERO",	$
	"PLOT_OO+2						(SYSTEM/built-in) 					P X:input Y:input /ISOTROPIC /MAX_VALUE:input /MIN_VALUE:input /NSUM:input /POLAR /XLOG /YLOG /YNOZERO",	$
	"PLOTS+1						(SYSTEM/built-in) 					P X:input                 /CONTINUE",	$
	"PLOTS+2						(SYSTEM/built-in) 					P X:input Y:input         /CONTINUE",	$
	"PLOTS+3						(SYSTEM/built-in) 					P X:input Y:input Z:input /CONTINUE",	$
	"POINT_LUN						(SYSTEM/built-in) 					P UNit:input Position:input",		$
	"POLY_2D						(SYSTEM/built-in) 					F Array:input P:input Q:input [Interp:input] [Dimx:input] [Dimy:input] /CUBIC:input /MISSING:input",	$
	"POLYFILL						(SYSTEM/built-in) 					P X:input [Y:input] [Z:input] /IMAGE_COORD:input /IMAGE_INTERP /LINE_FILL /PATTERN:input /SPACING:input /TRANSPARENT:input",	$
	"POLYFILLV						(SYSTEM/built-in) 					F X:input Y:input Sx:input Sy:input [Run_Length:input]",			$
	"POLYSHADE+1						(SYSTEM/built-in) 					F Vertices:input Polygons:input          /DATA /NORMAL /POLY_SHADES:input /SHADES:input /T3D /TOP:input /XSIZE:input /YSIZE:input",	$
	"POLYSHADE+2						(SYSTEM/built-in) 					F X:input Y:input Z:input Polygons:input /DATA /NORMAL /POLY_SHADES:input /SHADES:input /T3D /TOP:input /XSIZE:input /YSIZE:input",	$
	"POWELL							(SYSTEM/built-in) 					P P:input Xi:input Ftol:input Fmin:output Func:input /DOUBLE /ITER:output /ITMAX:input",			$
	"PREF_COMMIT						(SYSTEM/built-in)					P [PreferenceName:input] /RESET /RESIGNAL",	$
	"PREF_GET						(SYSTEM/built-in) 					F [PrefName:input] /NAMES_ALL /NUM_PENDING /STRUCTURE",			$
	"PREF_SET						(SYSTEM/built-in)					P [Prefs:inputs] /FILENAME:input /DEFAULT /COMMIT",	$
	"PRINT							(SYSTEM/built-in) 					P [Exprn:inputs] /AM_PM:input /DAYS_OF_WEEK:input /FORMAT:input /MONTHS:input /STDIO_NON_FINITE",	$
	"PRINTF							(SYSTEM/built-in) 					P [Unit:input] [Exprn:inputs] /AM_PM:input /DAYS_OF_WEEK:input /FORMAT:input /MONTHS:input /STDIO_NON_FINITE",	$
	"PRODUCT						(SYSTEM/built-in) 					F Array:input [Dimension:input] /CUMULATIVE /INTEGER /NAN /PRESERVE_TYPE",	$
	"PROFILER						(SYSTEM/built-in) 					P [Module:input] /CLEAR /DATA:output /OUTPUT:output /REPORT /RESET /SYSTEM",	$
	"PTR_FREE						(SYSTEM/built-in) 					P P1:input [Pn:inputs]",	$
	"PTR_NEW						(SYSTEM/built-in) 					F [[InitExpr:input] /ALLOCATE_HEAP /NO_COPY",	$
	"PTR_VALID						(SYSTEM/built-in) 					F [Arg:input] /CAST /COUNT:output",	$
	"PTRARR							(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /ALLOCATE_HEAP /NOZERO",	$
	"QROMB							(SYSTEM/built-in) 					F Func:input A:input B:input /DOUBLE /EPS:input /JMAX:input /K:input",			$
	"QROMO							(SYSTEM/built-in) 					F Func:input A:input [B:input] /DOUBLE /EPS:input /JMAX:input /K:input /MIDEXP /MIDINF /MIDPNT /MIDSQL /MIDSQU",			$
	"QSIMP							(SYSTEM/built-in) 					F Func:input A:input B:input /DOUBLE /EPS:input /JMAX:input",			$
	"QUERY_MRSID						(SYSTEM/built-in) 					F Func:input A:input B:input /DOUBLE /EPS:input /JMAX:input",			$
	"QUERY_EVENT_MASK					(SYSTEM/built-in)	 				P mask:input /BUTTON_EVENTS:input /MOTION_EVENTS:input /KEYBOARD_EVENTS:input",	$
	"RADON+1						(SYSTEM/built-in) 					F Array:input /DOUBLE /DRHO:input /DX:input /DY:input /GRAY /LINEAR /NRHO:input /NTHETA:input /RHO:output /RMIN:input /THETA:output /XMIN:input /YMIN:input",	$
	"RADON+2						(SYSTEM/built-in) 					F Array:input /BACKPROJECT /RHO:output /THETA:output /DOUBLE /DX:input /DY:input /LINEAR /NX:input /NY:input /XMIN:input /YMIN:input",	$
	"RANDOMN+1						(SYSTEM/built-in) 					F Seed:input  [D1:input] [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /BINOMIAL:input /DOUBLE /GAMMA:input /NORMAL /POISSON:input /UNIFORM /LONG",	$
	"RANDOMN+2						(SYSTEM/built-in) 					F Seed:output [D1:input] [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /BINOMIAL:input /DOUBLE /GAMMA:input /NORMAL /POISSON:input /UNIFORM /LONG",	$
	"RANDOMU+1						(SYSTEM/built-in) 					F Seed:input  [D1:input] [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /BINOMIAL:input /DOUBLE /GAMMA:input /NORMAL /POISSON:input /UNIFORM /LONG",	$
	"RANDOMU+2						(SYSTEM/built-in) 					F Seed:output [D1:input] [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /BINOMIAL:input /DOUBLE /GAMMA:input /NORMAL /POISSON:input /UNIFORM /LONG",	$
	"READ+1							(SYSTEM/built-in) 					P                              [Varn:outputs] /AM_PM:input /DAYS_OF_WEEK:input /FORMAT:input /MONTHS:input /PROMPT:input",	$
	"READ+2							(SYSTEM/built-in) 					P Prompt:input#CONSTANT_STRING [Varn:outputs] /AM_PM:input /DAYS_OF_WEEK:input /FORMAT:input /MONTHS:input /PROMPT:input",	$
	"READF+1						(SYSTEM/built-in) 					P                              Unit:input [Varn:outputs] /AM_PM:input /DAYS_OF_WEEK:input /FORMAT:input /MONTHS:input /PROMPT:input",	$
	"READF+2						(SYSTEM/built-in) 					P Prompt:input#CONSTANT_STRING Unit:input [Varn:outputs] /AM_PM:input /DAYS_OF_WEEK:input /FORMAT:input /MONTHS:input /PROMPT:input",	$
	"READ_MRSID						(SYSTEM/built-in) 					F Filename:input /LEVEL:input /SUB_RECT:input",			$
	"READS							(SYSTEM/built-in) 					P Input:input Var1:output [Varn:outputs] /AM_PM:input /DAYS_OF_WEEK:input /FORMAT:input /MONTHS:input",	$
	"READU							(SYSTEM/built-in) 					P Unit:input Var1:output [Varn:outputs] /TRANSFER_COUNT:output",	$
	"REBIN							(SYSTEM/built-in) 					F Array:input D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /SAMPLE",	$
	"RECALL_COMMANDS					(SYSTEM/built-in) 					F",			$
	"REFORM							(SYSTEM/built-in) 					F Array:input [D1:input] [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /OVERWRITE",	$
	"REGISTER_CURSOR					(SYSTEM/built-in) 					P Name:input Image:input /MASK:input /HOTSPOT:input /OVERWRITE",			$
	"REPLICATE						(SYSTEM/built-in) 					F Value:input D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",	$
	"REPLICATE_INPLACE					(SYSTEM/built-in) 					P X:input Value:input [D1:input] [Loc1:input] [D2:input] [Range:input]",			$
	"RESOLVE_ROUTINE					(SYSTEM/built-in) 					P Name:input /COMPILE_FULL_FILE /EITHER /IS_FUNCTION /NO_RECOMPILE",	$
	"RESTORE						(SYSTEM/built-in) 					P [Filename:input] /FILENAME:input /DESCRIPTION:output /RELAXED_STRUCTURE_ASSIGNMENT /RESTORED_OBJECTS:output /VERBOSE",	$
	"RETALL							(SYSTEM/built-in) 					P",	$
	"RETURN							(SYSTEM/built-in) 					P [Return_value:input]",		$
	"RK4							(SYSTEM/built-in) 					F Y:input Dydx:input X:input H:input Derivs:input /DOUBLE",	$
	"ROBERTS						(SYSTEM/built-in) 					F Image:input",			$
	"ROTATE							(SYSTEM/built-in) 					F Array:input Direction:input",		$
	"ROUND							(SYSTEM/built-in) 					F X:input /L64:input",		$
	"ROUTINE_INFO						(SYSTEM/built-in) 					F [Routine:input] /PARAMETERS /SOURCE /UNRESOLVED /VARIABLES /SYSTEM /DISABLED /ENABLED /FUNCTIONS",	$
	"ROUTINE_NAMES						(SYSTEM/built-in) 					F [name:input] /PROCEDURES /FUNCTIONS /S_PROCEDURES /S_FUNCTIONS /VARIABLES /LEVEL /FETCH",	$
	"SAVE							(SYSTEM/built-in) 					P [Varn:inputs] /ALL /COMM /VARIABLES /COMPRESS /DESCRIPTION:input /EMBEDDED /FILENAME:input /ROUTINES /SYSTEM_VARIABLES /VERBOSE",	$
	"SCOPE_LEVEL						(SYSTEM/built-in) 					F",			$
	"SCOPE_TRACEBACK					(SYSTEM/built-in) 					F /STRUCTURE /SYSTEM",	$
	"SCOPE_VARFETCH						(SYSTEM/built-in) 					F VarName:input /COMMON:input /ENTER /LEVEL:input /REF_EXTRA",	$
	"SCOPE_VARNAME						(SYSTEM/built-in) 					F [Varn:inputs] /COMMON:input /COUNT:output /LEVEL:input",	$
	"SET_PLOT						(SYSTEM/built-in) 					P Device:input /COPY /INTERPOLATE",	$
	"SETLOG							(SYSTEM/built-in) 					P o1:input p2:input /TABLE:input",	$
	"SET_SHADING						(SYSTEM/built-in) 					P /GOURAUD /LIGHT:input /REJECT /VALUES:input",	$
	"SETENV							(SYSTEM/built-in) 					P Environment_Expression:input",		$
	"SHADE_SURF						(SYSTEM/built-in) 					P Z:input [X:input] [Y:input] /AX:input /AZ:input /IMAGE:output /MAX_VALUE:input /MIN_VALUE:input /PIXELS:input /SAVE /SHADES:input /XLOG /YLOG /SKIRT:input /UPPER_ONLY",	$
	"SHADE_VOLUME						(SYSTEM/built-in) 					P Volume:input Value:input Vertex:input Poly:input /LOW /SHADES:input /VERBOSE /XRANGE:input /YRANGE:input /ZRANGE:input",			$
	"SHIFT							(SYSTEM/built-in) 					F Array:input S1:input [Sn:inputs]",$
	"SHMDEBUG						(SYSTEM/built-in) 					F Enable:input",			$
	"SHMMAP							(SYSTEM/built-in) 					P [SegmentName:input] [D1:input] [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /BYTE /COMPLEX /DCOMPLEX /DESTROY_SEGMENT /DIMENSION:input /DOUBLE /FILENAME:input /FLOAT /GET_NAME:output /GET_OS_HANDLE:output /INTEGER /L64 /LONG /OFFSET:input /OS_HANDLE:input /PRIVATE /SIZE:input /SYSV /TEMPLATE:input /TYPE:input /UINT /UL64 /ULONG",	$
	"SHMUNMAP						(SYSTEM/built-in) 					P SegmentName:input",			$
	"SHMVAR							(SYSTEM/built-in) 					F SegmentName:input [D1:input] [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /BYTE /COMPLEX /DCOMPLEX /DIMENSION:input /DOUBLE /FLOAT /INTEGER /L64 /LONG /SIZE:input /TEMPLATE:input /TYPE:input /UINT /UL64 /ULONG",	$
	"SIMPLEX						(SYSTEM/built-in) 					F Zequation:input Constraints:input M1:input M2:input M3:input [Tableau:output] [Izrov:output] [Iposv:output] /DOUBLE /EPS:input /STATUS:output",			$
	"SIN							(SYSTEM/built-in) 					F X:input",		$
	"SINDGEN						(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",			$
	"SINH							(SYSTEM/built-in) 					F X:input",			$
	"SIZE							(SYSTEM/built-in) 					F input#UNDEFINED /L64 /DIMENSIONS /FILE_LUN /FILE_OFFSET /N_DIMENSIONS /N_ELEMENTS /SNAME /STRUCTURE /TNAME /TYPE",	$
	"SKIP_LUN						(SYSTEM/built-in) 					P FromUnit:input [Num:input] /EOF /LINES /TRANSFER_COUNT:output",			$
	"SMOOTH							(SYSTEM/built-in) 					F Array:input Width:input /EDGE_TRUNCATE:input /MISSING:input /NAN",	$
	"SOBEL							(SYSTEM/built-in) 					F Image:input",			$
	"SOCKET+1						(SYSTEM/built-in) 					P Unit:output                         Host:input Port:input /CONNECT_TIMEOUT:input /ERROR:output /GET_LUN /RAWIO /READ_TIMEOUT:input /SWAP_ENDIAN /SWAP_IF_BIG_ENDIAN /SWAP_IF_LITTLE_ENDIAN /WIDTH:input /WRITE_TIMEOUT:input /STDIO",		$
	"SOCKET+2						(SYSTEM/built-in) 					P Unit:input#CONSTANT_STRING#CONSTANT Host:input Port:input /CONNECT_TIMEOUT:input /ERROR:output          /RAWIO /READ_TIMEOUT:input /SWAP_ENDIAN /SWAP_IF_BIG_ENDIAN /SWAP_IF_LITTLE_ENDIAN /WIDTH:input /WRITE_TIMEOUT:input /STDIO",		$
	"SORT							(SYSTEM/built-in) 					F Array:input /L64",	$
	"SPAWN							(SYSTEM/built-in) 					P [Command:input] [Result:output] [ErrResult:output] /COUNT:output /EXIT_STATUS:output /NOSHELL /NULL_STDIN /PID:output /STDERR /UNIT:output /NOTTYRESET /SH /HIDE /LOG_OUTPUT /NOWAIT",	$
	"SPL_INIT						(SYSTEM/built-in) 					F X:input Y:input /DOUBLE /YP0:input /YPN_1:input /YP1:input",	$
	"SPL_INTERP						(SYSTEM/built-in) 					F X:input Y:input Y2:input X2:input /DOUBLE",	$
	"SPRSAB							(SYSTEM/built-in) 					F A:input B:input /DOUBLE /THRESHOLD:input",			$
	"SPRSAX							(SYSTEM/built-in) 					F A:input X:input /DOUBLE",			$
	"SPRSIN+1						(SYSTEM/built-in) 					F A:input /COLUMN /DOUBLE /THRESHOLD:input",			$
	"SPRSIN+2						(SYSTEM/built-in) 					F Columns:input Rows:input Values:input N:input /DOUBLE /THRESHOLD:output",	$
	"SPRSTP							(SYSTEM/built-in) 					F A:input",			$
	"SQRT							(SYSTEM/built-in) 					F A:input",		$
	"STOP							(SYSTEM/built-in) 					P [Exprn:inputs]",			$
	"STRARR							(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",			$
	"STRCMP							(SYSTEM/built-in) 					F String1:input String2:input [N:input] /FOLD_CASE",		$
	"STRCOMPRESS						(SYSTEM/built-in) 					F String:input /REMOVE_ALL",		$
	"STREGEX						(SYSTEM/built-in) 					F StringExpression:input RegularExpression:input /BOOLEAN /EXTRACT /LENGTH:output /SUBEXPR /FOLD_CASE",	$
	"STRING							(SYSTEM/built-in) 					F Expression1:input [Expressionn:inputs] /AM_PM:input /DAYS_OF_WEEK:input /FORMAT:input /MONTHS:input /PRINT",	$
	"STRJOIN						(SYSTEM/built-in) 					F String:input [Delimiter:input] /SINGLE",			$
	"STRLEN							(SYSTEM/built-in) 					F Expression:input",			$
	"STRLOWCASE						(SYSTEM/built-in) 					F String:input",			$
	"STRMATCH						(SYSTEM/built-in) 					F String:input SearchString:input /FOLD_CASE",			$
	"STRMESSAGE						(SYSTEM/built-in) 					F Err:input /BLOCK /CODE /NAME",	$
	"STRMID							(SYSTEM/built-in) 					F Expression:input First_Character:input [Length:input] /REVERSE_OFFSET",	$
	"STRPOS							(SYSTEM/built-in) 					F Expression:input Search_String:input [Pos:input] /REVERSE_SEARCH",			$
	"STRPUT							(SYSTEM/built-in) 					P Destination:input Source:input [Position:input]",			$
	"STRTOK							(SYSTEM/built-in)		 			F String:input [Pattern:input] /COUNT:output /ESCAPE:input /REGEX /FOLD_CASE /EXTRACT /LENGTH:output /PRESERVE_NULL", $ ; idem STRSPLIT
	"STRTRIM						(SYSTEM/built-in) 					F String:input [Flag:input]",	$
	"STRUCT_ASSIGN						(SYSTEM/built-in) 					P Source:input Destination:input /NOZERO /VERBOSE",	$
	"STRUCT_HIDE						(SYSTEM/built-in) 					P Arg1:input [Argn:inputs]",			$
	"STRUPCASE						(SYSTEM/built-in) 					F String:input",		$
	"SURFACE						(SYSTEM/built-in) 					P Z:input [X:input] [Y:input] /AX:input /AZ:input /BOTTOM:input /HORIZONTAL /LEGO /LOWER_ONLY /UPPER_ONLY /MAX_VALUE:input /MIN_VALUE:input /SAVE /SHADES:input /SKIRT:input /XLOG /YLOG /ZAXIS:input /ZLOG",			$
	"SVDC							(SYSTEM/built-in) 					P A:input W:output U:output V:output /COLUMN /DOUBLE /ITMAX:input",			$
	"SVSOL							(SYSTEM/built-in) 					F U:input W:input V:input B:input /COLUMN /DOUBLE",			$
	"SYSTIME						(SYSTEM/built-in) 					F [inputs] /SECONDS /JULIAN /UTC",			$
	"TAG_NAMES						(SYSTEM/built-in) 					F Expression:input /STRUCTURE_NAME",	$
	"TAN							(SYSTEM/built-in) 					F X:input",			$
	"TANH							(SYSTEM/built-in) 					F X:input",			$
	"TEMPORARY						(SYSTEM/built-in) 					F Variable:input",		$
	"TETRA_CLIP						(SYSTEM/built-in) 					F Plane:input Vertsin:input Connin:input Vertsout:output Connout:output /AUXDATA_IN:input /AUXDATA_OUT:output /CUT_VERTS:output",			$
	"TETRA_SURFACE						(SYSTEM/built-in) 					F Verts:input Connin:input",			$
	"TETRA_VOLUME						(SYSTEM/built-in) 					F Verts:input Conn:input /AUXDATA:input /MOMENT:output",			$
	"THIN							(SYSTEM/built-in) 					F Image:input /NEIGHBOR_COUNT /PRUNE",			$
	"TOTAL							(SYSTEM/built-in) 					F Array:input [Dimension:input] /CUMULATIVE /DOUBLE /INTEGER /NAN /PRESERVE_TYPE",	$
	"TRANSPOSE						(SYSTEM/built-in) 					F Array:input [P:input]",	$
	"TRIANGULATE						(SYSTEM/built-in) 					P X:input Y:input [Triangles:output] [B:output] /CONNECTIVITY:output /SPHERE:output /DEGREES /FVALUE:input /REPEATS:output /TOLERANCE:input",	$
	"TRIDAG							(SYSTEM/built-in) 					P p1:input p2:input p3:input p4:input p5:output",	$
	"TRIGRID+1						(SYSTEM/built-in) 					F X:input Y:input Z:input Triangles:input [GS:input] [Limits:input] /SPHERE:output /DEGREES /EXTRAPOLATE:input /INPUT:output /MAX_VALUE:input /MIN_VALUE:input /MISSING:input /NX:input /NY:input /QUINTIC /XGRID:output /XOUT:input /YGRID:output /YOUT:input",	$
	"TRIGRID+2						(SYSTEM/built-in) 					F F:input GS:input Limits:input                                     /SPHERE:input  /DEGREES /EXTRAPOLATE:input /INPUT:output /MAX_VALUE:input /MIN_VALUE:input /MISSING:input /NX:input /NY:input /QUINTIC /XGRID:output /XOUT:input /YGRID:output /YOUT:input",	$
	"TRIQL							(SYSTEM/built-in) 					P D:input E:input A:input /DOUBLE",			$
	"TRIQL_NOVEC						(SYSTEM/built-in) 					P D:input E:input /DOUBLE",			$
	"TRIRED							(SYSTEM/built-in) 					P A:input D:output E:output /DOUBLE",			$
	"TRISOL							(SYSTEM/built-in) 					F A:input B:input C:input R:input /DOUBLE",			$
	"TRUNCATE_LUN						(SYSTEM/built-in) 					P Unit1:input [Unitn:inputs]",			$
	"TRNLOG							(SYSTEM/built-in) 					F p1:input p2:output /TABLE:input",	$
	"TV+1							(SYSTEM/built-in) 					P Image:input [Position:input]                    /CENTIMETERS /INCHES /ORDER /TRUE:input /WORDS /XSIZE:input /YSIZE:input",	$
	"TV+2							(SYSTEM/built-in) 					P Image:input [X:input] [Y:input] [Channel:input] /CENTIMETERS /INCHES /ORDER /TRUE:input /WORDS /XSIZE:input /YSIZE:input",	$
	"TVCRS+1						(SYSTEM/built-in) 					P [ON_OFF:input]      /CENTIMETERS /INCHES /HIDE_CURSOR",	$
	"TVCRS+2						(SYSTEM/built-in) 					P [X:input] [Y:input] /CENTIMETERS /INCHES /HIDE_CURSOR",	$
	"TVLCT+1						(SYSTEM/built-in) 					P V1:output V2:output V3:output [Start:input] /GET /HLS /HSV",	$
	"TVLCT+2						(SYSTEM/built-in) 					P V1:input  V2:input  V3:input  [Start:input]      /HLS /HSV",	$
	"TVLCT+3						(SYSTEM/built-in) 					P V:output                      [Start:input] /GET /HLS /HSV",	$
	"TVLCT+4						(SYSTEM/built-in) 					P V:input                       [Start:input]      /HLS /HSV",	$
	"TVRD							(SYSTEM/built-in) 					F [X0:input] [Y0:input] [Nx:input] [Ny:input] [Channel:input] /ORDER /TRUE:input /WORDS",	$
	"TVRDC							(SYSTEM/built-in) 					P p1:output p2:output [p3:input] /DEV /NORM",	$
	"TVSCL+1						(SYSTEM/built-in) 					P Image:input [Position:input]                    /CENTIMETERS /INCHES /NAN /ORDER /TOP:input /TRUE:input /WORDS /XSIZE:input /YSIZE:input",	$
	"TVSCL+2						(SYSTEM/built-in) 					P Image:input [X:input] [Y:input] [Channel:input] /CENTIMETERS /INCHES /NAN /ORDER /TOP:input /TRUE:input /WORDS /XSIZE:input /YSIZE:input",	$
	"UINDGEN						(SYSTEM/built-in) 					F",			$
	"UINT							(SYSTEM/built-in) 					F Expression:input [Offset:input] [D1:input] [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",			$
	"UINTARR						(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /NOZERO",			$
	"UL64INDGEN						(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",				$
	"ULINDGEN						(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",				$
	"ULON64ARR						(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /NOZERO",			$
	"ULONARR						(SYSTEM/built-in) 					F D1:input [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /NOZERO",			$
	"ULONG							(SYSTEM/built-in) 					F Expression:input [Offset:input] [D1:input] [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] ",	$
	"ULONG64						(SYSTEM/built-in) 					F Expression:input [Offset:input] [D1:input] [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input]",	$
	"USERSYM						(SYSTEM/built-in) 					P X:input [Y:input] /COLOR:input /FILL /THICK:input",	$
	"VALUE_LOCATE						(SYSTEM/built-in) 					F Vector:input Value:input /L64",	$
	"VOIGT							(SYSTEM/built-in)	 				F A:input U:input",			$
	"VOXEL_PROJ						(SYSTEM/built-in) 					F V:input [RGBO:input] /BACKGROUND:input /CUTTING_PLANE:input /INTERPOLATE /MAXIMUM_INTENSITY /STEP:input /XSIZE:input /YSIZE:input /ZBUFFER:input /ZPIXELS:input",	$
	"WAIT							(SYSTEM/built-in) 					P Seconds:input",		$
	"WATERSHED						(SYSTEM/built-in) 					F Image:input /CONNECTIVITY:input /LONG /NREGIONS:output",			$
	"WDE_IMPORT_MACROS					(SYSTEM/built-in) 					P p1:input /RETAIN_CURRENT",	$
	"WDELETE						(SYSTEM/built-in) 					P [Window_Index:inputs]",			$
	"WHERE							(SYSTEM/built-in) 					F Array_Expression:input [Count:output] /COMPLEMENT:output /L64 /NCOMPLEMENT:output",	$
	"WIDGET_ACTIVEX						(SYSTEM/built-in) 					F Parent:input COM_ID:input /ALIGN_BOTTOM /ALIGN_CENTER /ALIGN_LEFT /ALIGN_RIGHT /ALIGN_TOP /EVENT_FUNC:input /EVENT_PRO:input /FUNC_GET_VALUE:input /ID_TYPE:input /KILL_NOTIFY:input /NO_COPY /NOTIFY_REALIZE:input /PRO_SET_VALUE:input /SCR_XSIZE:input /SCR_YSIZE:input /SENSITIVE /UNAME:input /UNITS:input /UVALUE:input /XOFFSET:input /XSIZE:input /YOFFSET:input /YSIZE:input",			$
	"WIDGET_BASE						(SYSTEM/built-in) 					F [Parent:input] /ALIGN_BOTTOM /ALIGN_CENTER /ALIGN_LEFT /ALIGN_RIGHT /ALIGN_TOP /BASE_ALIGN_BOTTOM /BASE_ALIGN_CENTER /BASE_ALIGN_LEFT /BASE_ALIGN_RIGHT /BASE_ALIGN_TOP /COLUMN:input /ROW:input /CONTEXT_EVENTS /CONTEXT_MENU /EVENT_FUNC:input /EVENT_PRO:input /EXCLUSIVE /NONEXCLUSIVE /FLOATING /FRAME:input /FUNC_GET_VALUE:input /GRID_LAYOUT /GROUP_LEADER:input /KBRD_FOCUS_EVENTS /KILL_NOTIFY:input /MAP /MBAR:output /MODAL /NO_COPY /NOTIFY_REALIZE:input /PRO_SET_VALUE:input /SCR_XSIZE:input /SCR_YSIZE:input /SCROLL /SENSITIVE /SPACE:input /TAB_MODE:input /TITLE:input /TLB_FRAME_ATTR:input /TLB_ICONIFY_EVENTS /TLB_KILL_REQUEST_EVENTS /TLB_MOVE_EVENTS /TLB_SIZE_EVENTS /TOOLBAR /TRACKING_EVENTS /UNAME:input /UNITS:input /UVALUE:input /XOFFSET:input /XPAD:input /XSIZE:input /X_SCROLL_SIZE:input /YOFFSET:input /YPAD:input /YSIZE:input /Y_SCROLL_SIZE:input /DISPLAY_NAME:input /RESOURCE_NAME:input /RNAME_MBAR:input /APP_MBAR:input",	$
	"WIDGET_BUTTON						(SYSTEM/built-in) 					F Parent:input /ACCELERATOR:input /ALIGN_CENTER /ALIGN_LEFT /ALIGN_RIGHT /BITMAP /CHECKED_MENU /DYNAMIC_RESIZE /EVENT_FUNC:input /EVENT_PRO:input /FONT:input /FRAME:input /FUNC_GET_VALUE:input /GROUP_LEADER:input /HELP /KILL_NOTIFY:input /MENU /NO_COPY /NO_RELEASE /NOTIFY_REALIZE:input /PRO_SET_VALUE:input /PUSHBUTTON_EVENTS /SCR_XSIZE:input /SCR_YSIZE:input /SENSITIVE /SEPARATOR /TAB_MODE:input /TOOLTIP:input /TRACKING_EVENTS /UNAME:input /UNITS:input /UVALUE:input /VALUE:input /X_BITMAP_EXTRA:input /XOFFSET:input /XSIZE:input /YOFFSET:input /YSIZE:input /RESOURCE_NAME:input",	$
	"WIDGET_COMBOBOX					(SYSTEM/built-in) 					F Parent:input /ALIGN_BOTTOM /ALIGN_CENTER /ALIGN_LEFT /ALIGN_RIGHT /ALIGN_TOP /DYNAMIC_RESIZE /EDITABLE /EVENT_FUNC:input /EVENT_PRO:input /FONT:input /FRAME:input /FUNC_GET_VALUE:input /GROUP_LEADER:input /IGNORE_ACCELERATORS:input /KILL_NOTIFY:input /NO_COPY /NOTIFY_REALIZE:input /PRO_SET_VALUE:input /RESOURCE_NAME:input /SCR_XSIZE:input /SCR_YSIZE:input /SENSITIVE /TAB_MODE:input /TRACKING_EVENTS /UNAME:input /UNITS:input /UVALUE:input /VALUE:input /XOFFSET:input /XSIZE:input /YOFFSET:input /YSIZE:input",	$
	"WIDGET_CONTROL						(SYSTEM/built-in) 					P [Widget_ID:input] /BAD_ID:output /CLEAR_EVENTS /DEFAULT_FONT:input /DELAY_DESTROY /DESTROY /EVENT_FUNC:input /EVENT_PRO:input /FUNC_GET_VALUE:input /GET_UVALUE:output /GROUP_LEADER:input /HOURGLASS /KILL_NOTIFY:input /MAP /NO_COPY /NOTIFY_REALIZE:input /PRO_SET_VALUE:input /REALIZE /RESET /SCR_XSIZE:input /SCR_YSIZE:input /SEND_EVENT:input /SENSITIVE /SET_UNAME:input /SET_UVALUE:input /SHOW /TIMER:input /TLB_GET_OFFSET:output /TLB_GET_SIZE:output /TLB_KILL_REQUEST_EVENTS /TLB_SET_TITLE:input /TLB_SET_XOFFSET:input /TLB_SET_YOFFSET:input /TRACKING_EVENTS /UNITS:input /UPDATE /XOFFSET:input /XSIZE:input /YOFFSET:input /YSIZE:input " + $
																"/GET_VALUE:output " + $
																"/BASE_SET_TITLE:input /CONTEXT_EVENTS /ICONIFY /KBRD_FOCUS_EVENTS /TAB_MODE:input /TLB_ICONIFY_EVENTS /TLB_MOVE_EVENTS /TLB_SIZE_EVENTS " + $
																"/BITMAP /DYNAMIC_RESIZE /INPUT_FOCUS /PUSHBUTTON_EVENTS /SET_BUTTON /SET_VALUE:input /TOOLTIP:input /X_BITMAP_EXTRA:input " + $
																"/COMBOBOX_ADDITEM:input /COMBOBOX_DELETEITEM:input /COMBOBOX_INDEX:input /IGNORE_ACCELERATORS:input /SET_COMBOBOX_SELECT:input " + $
																"/DRAW_BUTTON_EVENTS /DRAW_EXPOSE_EVENTS /DRAW_KEYBOARD_EVENTS:input /DRAW_MOTION_EVENTS /DRAW_VIEWPORT_EVENTS /DRAW_WHEEL_EVENTS /DRAW_XSIZE:input /DRAW_YSIZE:input /GET_DRAW_VIEW:output /SET_DRAG_NOTIFY:input /SET_DRAW_VIEW:input /SET_DROP_EVENTS "+ $
																"/SET_DROPLIST_SELECT:input " + $
																"/SET_LIST_SELECT:input /SET_LIST_TO:input " + $
																"/EDITABLE /MULTIPLE_PROPERTIES /PROPERTYSHEET_SETSELECTED:input /REFRESH_PROPERTY:input " + $
																"/SET_SLIDER_MAX:input /SET_SLIDER_MIN:input " + $
																"/SET_TAB_CURRENT:input /SET_TAB_MULTILINE:input " + $
																"/ALIGNMENT:input /ALL_TABLE_EVENTS /AM_PM:input /BACKGROUND_COLOR:input /COLUMN_LABELS:input /COLUMN_WIDTHS:input /DAYS_OF_WEEK:input /DELETE_COLUMNS /DELETE_ROWS /EDIT_CELL:input /FONT:input /FOREGROUND_COLOR:input /FORMAT:input /INSERT_COLUMNS:input /INSERT_ROWS:input /MONTHS:input /ROW_LABELS:input /ROW_HEIGHTS:input /SET_TABLE_SELECT:input /SET_TABLE_VIEW:input /SET_TEXT_SELECT:input /TABLE_BLANK:input /TABLE_DISJOINT_SELECTION /TABLE_XSIZE:input /TABLE_YSIZE:input /USE_TABLE_SELECT:input /USE_TEXT_SELECT " + $
																"/ALL_TEXT_EVENTS /APPEND /NO_NEWLINE /SET_TEXT_TOP_LINE:input " + $
																"/SET_DRAGGABLE /SET_MASK /SET_TREE_BITMAP:input /SET_TREE_EXPANDED /SET_TREE_INDEX:input /SET_TREE_SELECT:input /SET_TREE_VISIBLE", $
	"WIDGET_DISPLAYCONTEXTMENU				(SYSTEM/built-in) 					P Parent:input X:input Y:input ContextBase_ID:input",	$
	"WIDGET_DRAW						(SYSTEM/built-in) 					F Parent:input /APP_SCROLL /BUTTON_EVENTS /CLASSNAME:input /COLOR_MODEL /COLORS:input /DRAG_NOTIFY:input /DROP_EVENTS /EVENT_FUNC:input /EVENT_PRO:input /EXPOSE_EVENTS /FRAME:input /FUNC_GET_VALUE:input /GRAPHICS_LEVEL:input /GROUP_LEADER:input /IGNORE_ACCELERATORS /KEYBOARD_EVENTS:input /KILL_NOTIFY /MOTION_EVENTS /NO_COPY /NOTIFY_REALIZE:input /PRO_SET_VALUE:input /RENDERER:input /RESOURCE_NAME:input /RETAIN:input /SCR_XSIZE:input /SCR_YSIZE:input /SCROLL /SENSITIVE /TOOLTIP:input /TRACKING_EVENTS /UNAME:input /UNITS:input /UVALUE:input /VIEWPORT_EVENTS /WHEEL_EVENTS /XOFFSET:input /XSIZE:input /X_SCROLL_SIZE:input /YOFFSET:input /YSIZE:input /Y_SCROLL_SIZE:input /ALIGN_CENTER",	$
	"WIDGET_DROPLIST					(SYSTEM/built-in) 					F Parent:input /ALIGN_BOTTOM /ALIGN_CENTER /ALIGN_LEFT /ALIGN_RIGHT /ALIGN_TOP /DYNAMIC_RESIZE /EVENT_FUNC:input /EVENT_PRO:input /FONT:input /FRAME:input /FUNC_GET_VALUE:input /GROUP_LEADER:input /KILL_NOTIFY:input /NO_COPY /NOTIFY_REALIZE:input /PRO_SET_VALUE:input /RESOURCE_NAME:input /SCR_XSIZE:input /SCR_YSIZE:input /SENSITIVE /TAB_MODE:input /TITLE:input /TRACKING_EVENTS /UNAME:input /UNITS:input /UVALUE:input /VALUE:input /XOFFSET:input /XSIZE:input /YOFFSET:input /YSIZE:input",	$
	"WIDGET_EVENT						(SYSTEM/built-in) 					F [Widget_ID:input] /BAD_ID:output /NOWAIT /SAVE_HOURGLASS /YIELD_TO_TTY",	$
	"WIDGET_INFO						(SYSTEM/built-in) 					F [Widget_ID:input] /ACTIVE /ALL_CHILDREN /CHILD /EVENT_FUNC /EVENT_PRO /FIND_BY_UNAME:input /FONTNAME /GEOMETRY /KBRD_FOCUS_EVENTS /MANAGED /MAP /N_CHILDREN /NAME /PARENT /REALIZED /SENSITIVE /SIBLING /STRING_SIZE:input /SYSTEM_COLORS /TAB_MODE /TRACKING_EVENTS /TYPE /UNITS:input /UNAME /UPDATE /VALID_ID /VERSION /VISIBLE " + $
																"/CONTEXT_EVENTS /MODAL /TLB_ICONIFY_EVENTS /TLB_KILL_REQUEST_EVENTS /TLB_MOVE_EVENTS /TLB_SIZE_EVENTS " + $
																"/BUTTON_SET /DYNAMIC_RESIZE /PUSHBUTTON_EVENTS /TOOLTIP " + $
																"/COMBOBOX_GETTEXT /COMBOBOX_NUMBER " + $
																"/DRAG_NOTIFY /DRAW_BUTTON_EVENTS /DRAW_EXPOSE_EVENTS /DRAW_KEYBOARD_EVENTS:input /DRAW_MOTION_EVENTS /DRAW_VIEWPORT_EVENTS /DRAW_WHEEL_EVENTS /DROP_EVENTS " + $
																"/DROPLIST_NUMBER /DROPLIST_SELECT " + $
																"/LIST_MULTIPLE /LIST_NUMBER /LIST_NUM_VISIBLE /LIST_SELECT /LIST_TOP " + $
																"/COMPONENT:input /MULTIPLE_PROPERTIES /PROPERTY_VALID:input /PROPERTY_VALUE:input /PROPERTYSHEET_NSELECTED /PROPERTYSHEET_SELECTED " + $
																"/SLIDER_MIN_MAX " + $
																"/TAB_CURRENT /TAB_MULTILINE /TAB_NUMBER " + $
																"/COLUMN_WIDTHS /ROW_HEIGHTS /TABLE_ALL_EVENTS /TABLE_BACKGROUND_COLOR /TABLE_DISJOINT_SELECTION /TABLE_EDITABLE /TABLE_EDIT_CELL /TABLE_FONT /TABLE_FOREGROUND_COLOR /TABLE_SELECT /TABLE_VIEW /TEXT_SELECT /USE_TABLE_SELECT " + $
																"/TEXT_ALL_EVENTS /TEXT_EDITABLE /TEXT_NUMBER /TEXT_OFFSET_TO_XY:input /TEXT_TOP_LINE /TEXT_XY_TO_OFFSET:input " + $	
																"/DRAGGABLE /MASK /TREE_BITMAP /TREE_DRAG_SELECT /TREE_EXPANDED /TREE_FOLDER /TREE_INDEX /TREE_ROOT /TREE_SELECT",	$
	"WIDGET_LABEL						(SYSTEM/built-in) 					F Parent:input /ALIGN_BOTTOM /ALIGN_CENTER /ALIGN_LEFT /ALIGN_RIGHT /ALIGN_TOP /DYNAMIC_RESIZE /FONT:input /FRAME:input /FUNC_GET_VALUE:input /GROUP_LEADER:input /KILL_NOTIFY:input /NO_COPY /NOTIFY_REALIZE:input /PRO_SET_VALUE:input /RESOURCE_NAME:input /SCR_XSIZE:input /SCR_YSIZE:input /SENSITIVE /SUNKEN_FRAME /TRACKING_EVENTS /UNAME:input /UNITS:input /UVALUE:input /VALUE:input /XOFFSET:input /XSIZE:input /YOFFSET:input /YSIZE",	$
	"WIDGET_LIST						(SYSTEM/built-in) 					F Parent:input /ALIGN_BOTTOM /ALIGN_CENTER /ALIGN_LEFT /ALIGN_RIGHT /ALIGN_TOP /CONTEXT_EVENTS /EVENT_FUNC:input /EVENT_PRO:input /FONT:input /FRAME:input /FUNC_GET_VALUE:input /GROUP_LEADER:input /KILL_NOTIFY:input /MULTIPLE /NO_COPY /NOTIFY_REALIZE:input /PRO_SET_VALUE:input /RESOURCE_NAME:input /SCR_XSIZE:input /SCR_YSIZE:input /SENSITIVE /TAB_MODE:input /TRACKING_EVENTS /UNAME:input /UNITS:input /UVALUE:input /VALUE:input /XOFFSET:input /XSIZE:input /YOFFSET:input /YSIZE:input",	$
	"WIDGET_MESSAGE						(SYSTEM/built-in) 					F Message_Text:input  /CANCEL /CENTER /DEFAULT_CANCEL /DEFAULT_NO /DIALOG_PARENT:input /DISPLAY_NAME:input /ERROR /INFORMATION /QUESTION /RESOURCE_NAME:input /TITLE:input",	$ ; idem DIALOG_MESSAGE
	"WIDGET_OLH						(SYSTEM/built-in) 					P p1:input",	$
	"WIDGET_PROPERTYSHEET					(SYSTEM/built-in) 					F Parent:input /ALIGN_BOTTOM /ALIGN_CENTER /ALIGN_LEFT /ALIGN_RIGHT /ALIGN_TOP /CONTEXT_EVENTS /EDITABLE /EVENT_FUNC:input /EVENT_PRO:input /FONT:input /FRAME:input /FUNC_GET_VALUE:input /IGNORE_ACCELERATORS:input /KILL_NOTIFY:input /MULTIPLE_PROPERTIES /NO_COPY /NOTIFY_REALIZE:input /PRO_SET_VALUE:input /SCR_XSIZE:input /SCR_YSIZE:input /SENSITIVE /SUNKEN_FRAME /TRACKING_EVENTS /UNAME:input /UNITS:input /UVALUE:input /VALUE:input /XOFFSET:input /XSIZE:input /YOFFSET:input /YSIZE:input",			$
	"WIDGET_SLIDER						(SYSTEM/built-in) 					F Parent:input /ALIGN_BOTTOM /ALIGN_CENTER /ALIGN_LEFT /ALIGN_RIGHT /ALIGN_TOP /DRAG /EVENT_FUNC:input /EVENT_PRO:input /FONT:input /FRAME:input /FUNC_GET_VALUE:input /GROUP_LEADER:input /KILL_NOTIFY:input /MAXIMUM:input /MINIMUM:input /NO_COPY /NOTIFY_REALIZE:input /PRO_SET_VALUE:input /RESOURCE_NAME:input /SCR_XSIZE:input /SCR_YSIZE:input /SCROLL /SENSITIVE /SUPPRESS_VALUE /TAB_MODE:input /TITLE:input /TRACKING_EVENTS /UNAME:input /UNITS:input /UVALUE:input /VALUE:input /VERTICAL /XOFFSET:input /XSIZE:input /YOFFSET:input /YSIZE:input",	$
	"WIDGET_STUB						(SYSTEM/built-in) 					F Parent:input /EVENT_FUNC:input /EVENT_PRO:input /FUNC_GET_VALUE:input /GROUP_LEADER:input /KILL_NOTIFY:input /NO_COPY /PRO_SET_VALUE:input /SCR_XSIZE:input /SCR_YSIZE:input /UVALUE:input /XOFFSET:input /XSIZE:input /YOFFSET:input /YSIZE:input",	$
	"WIDGET_TAB						(SYSTEM/built-in) 					F Parent:input /ALIGN_BOTTOM /ALIGN_CENTER /ALIGN_LEFT /ALIGN_RIGHT /ALIGN_TOP /EVENT_FUNC:input /EVENT_PRO:input /FUNC_GET_VALUE:input /GROUP_LEADER:input /KILL_NOTIFY:input /LOCATION:input /MULTILINE:input /NO_COPY /NOTIFY_REALIZE:input /PRO_SET_VALUE:input /SCR_XSIZE:input /SCR_YSIZE:input /SENSITIVE /TAB_MODE:input /TRACKING_EVENTS /UNAME:input /UNITS:input /UVALUE:input /XOFFSET:input /XSIZE:input /YOFFSET:input /YSIZE:input",	$
	"WIDGET_TABLE						(SYSTEM/built-in) 					F Parent:input /ALIGNMENT:input /ALL_EVENTS /AM_PM:input /BACKGROUND_COLOR:input /COLUMN_LABELS:input /COLUMN_MAJOR /ROW_MAJOR /COLUMN_WIDTHS:input /CONTEXT_EVENTS /DAYS_OF_WEEK:input /DISJOINT_SELECTION /EDITABLE /EVENT_FUNC:input /EVENT_PRO:input /FONT:input /FOREGROUND_COLOR:input /FORMAT:input /FRAME:input /FUNC_GET_VALUE:input /GROUP_LEADER:input /IGNORE_ACCELERATORS:input /KBRD_FOCUS_EVENTS /KILL_NOTIFY:input /MONTHS:input /NO_COLUMN_HEADERS /NO_COPY /NO_HEADERS /NO_ROW_HEADERS /NOTIFY_REALIZE:input /PRO_SET_VALUE:input /RESIZEABLE_COLUMNS /RESIZEABLE_ROWS /RESOURCE_NAME:input /ROW_HEIGHTS:input /ROW_LABELS:input /SCR_XSIZE:input /SCR_YSIZE:input /SCROLL /SENSITIVE /TAB_MODE:input /TRACKING_EVENTS /UNAME:input /UNITS:input /UVALUE:input /VALUE:input /XOFFSET:input /XSIZE:input /X_SCROLL_SIZE:input /YOFFSET:input /YSIZE:input /Y_SCROLL_SIZE:input",	$
	"WIDGET_TEXT						(SYSTEM/built-in) 					F Parent:input /ALIGN_BOTTOM /ALIGN_CENTER /ALIGN_LEFT /ALIGN_RIGHT /ALIGN_TOP /ALL_EVENTS /CONTEXT_EVENTS /EDITABLE /EVENT_FUNC:input /EVENT_PRO:input /FONT:input /FRAME:input /FUNC_GET_VALUE:input /GROUP_LEADER:input /IGNORE_ACCELERATORS:input /KBRD_FOCUS_EVENTS /KILL_NOTIFY:input /NO_COPY /NO_NEWLINE /NOTIFY_REALIZE:input /PRO_SET_VALUE:input /RESOURCE_NAME:input /SCR_XSIZE:input /SCR_YSIZE:input /SCROLL /SENSITIVE /TAB_MODE:input /TRACKING_EVENTS /UNAME:input /UNITS:input /UVALUE:input /VALUE:input /WRAP /XOFFSET:input /XSIZE:input /YOFFSET:input /YSIZE:input",	$
	"WIDGET_TREE						(SYSTEM/built-in) 					F Parent:input /ALIGN_BOTTOM /ALIGN_CENTER /ALIGN_LEFT /ALIGN_RIGHT /ALIGN_TOP /BITMAP:input /CONTEXT_EVENTS /DRAG_NOTIFY:input /DRAGGABLE /DROP_EVENTS /EVENT_FUNC:input /EVENT_PRO:input /EXPANDED /FOLDER:input /FUNC_GET_VALUE:input /GROUP_LEADER:input /INDEX:input /KILL_NOTIFY:input /MASK /MULTIPLE /NO_COPY /NOTIFY_REALIZE:input /PRO_SET_VALUE:input /SCR_XSIZE:input /SCR_YSIZE:input /SENSITIVE /TAB_MODE:input /TRACKING_EVENTS /UNAME:input /UNITS:input /UVALUE:input /VALUE:input /XOFFSET:input /XSIZE:input /YOFFSET:input /YSIZE:input",	$
	"WINDOW							(SYSTEM/built-in) 					P [Window_Index:input] /COLORS:input /FREE /PIXMAP /RETAIN:input /TITLE:input /XPOS:input /YPOS:input /XSIZE:input /YSIZE:input /GET_X_ID:output",	$
	"WMENU							(SYSTEM/built-in) 					F p1:input /TITLE /INITIAL:input",	$
	"WV_APPLET						(SYSTEM/built-in)					P [Input:input] /ARRAY:input /GROUP_LEADER:input /NO_SPLASH /TOOLS:input /WAVELETS:input",	$
	"WV_CW_WAVELET						(SYSTEM/built-in)					F [Parent:input] /DISCRETE /NO_COLOR /NO_DRAW_WINDOW /TITLE:input /UNAME:input /VALUE:input /WAVELETS:input",	$
	"WV_IMPORT_DATA						(SYSTEM/built-in)					P Data:input /MESSAGE_OUT:output /PARENT:input",	$
	"WV_IMPORT_WAVELET					(SYSTEM/built-in)					P [Wavelet:input] /RESET",	$
	"WV_PLOT_MULTIRES					(SYSTEM/built-in)					F Array:input [X:input] [Y:input] /GROUP_LEADER:input /TITLE:input /UNITS:input /XTITLE:input /XUNITS:input /YTITLE:input /YUNITS:input",	$
	"WV_PLOT3D_WPS						(SYSTEM/built-in)					F Array:input [X:input] [Y:input] /GROUP_LEADER:input /SURFACE_STYLE:input /TITLE:input /UNITS:input /XTITLE:input /XUNITS:input /YTITLE:input /YUNITS:input",	$
	"WV_TOOL_DENOISE					(SYSTEM/built-in)					F Array:input [X:input] [Y:input] /GROUP_LEADER:input /TITLE:input /UNITS:input /XTITLE:input /XUNITS:input /YTITLE:input /YUNITS:input",	$
	"WRITEU							(SYSTEM/built-in) 					P Unit:input Expr1:input [Exprn:inputs] /TRANSFER_COUNT:output",	$
	"WSET							(SYSTEM/built-in) 					P [Window_Index:input]",	$
	"WSHOW							(SYSTEM/built-in) 					P [Window_Index:input] [Show:input] /ICONIC",	$
	"WTN							(SYSTEM/built-in) 					F A:input Coef:input /COLUMN /DOUBLE /INVERSE /OVERWRITE",			$
	"XYOUTS+1						(SYSTEM/built-in) 					P                 String:input /ALIGNMENT:input /TEXT_AXES:input /WIDTH:output /SIZE:input",	$
	"XYOUTS+2						(SYSTEM/built-in) 					P X:input         String:input /ALIGNMENT:input /TEXT_AXES:input /WIDTH:output /SIZE:input",	$
	"XYOUTS+3						(SYSTEM/built-in) 					P X:input Y:input String:input /ALIGNMENT:input /TEXT_AXES:input /WIDTH:output /SIZE:input",	$


	; built-in obsolete ".pro"
	; ------------------------
	"ADDSYSVAR						(SYSTEM/lib/obsolete/addsysvar.pro)			P Name:input Type:input [String_length:input]",	$
	"ADJCT							(SYSTEM/lib/obsolete/adjct.pro)				P",	$
	"ANOVA							(SYSTEM/lib/obsolete/anova.pro)				P X1:??? /FCTEST:??? /FRTEST:??? /FRCTEST:??? /DFE:??? /DFC:??? /DFR:??? /DFFRC:??? /ONE_WAY:??? /UNEQUAL_ONE_WAY:??? /TWO_WAY:??? /INTERACTIONS_TWO_WAY:??? /MISSING:??? /LIST_NAME:??? /TCONTRAST:??? /BCONTRAST:??? /ICONTRAST:??? /TNAME:??? /BNAME:??? /TCNAME:??? /BCNAME:??? /ICNAME:??? /NO_PRINTOUT:???",	$
	"ANOVA_UNEQUAL						(SYSTEM/lib/obsolete/anova_unequal.pro)			P Data1:??? FT_Test:??? FB_Test:??? FI_Test:??? /TNAME:??? /BNAME:??? /INAME:??? /MISSING:??? /LISTNAME:??? /NO_PRINTOUT:???",	$
	"BASE_ALLOC						(SYSTEM/lib/obsolete/base_alloc.pro)			P Parent:??? Ptr:???",	$
	"BETAI							(SYSTEM/lib/obsolete/betai.pro)				F x:??? a:??? b:???",	$
	"BGROUP_ALLOC						(SYSTEM/lib/obsolete/bgroup_alloc.pro)			P Parent:??? Ptr:???",	$
	"BMPBTN_ALLOC						(SYSTEM/lib/obsolete/bmpbtn_alloc.pro)			P Parent:??? Ptr:???",	$
	"BUTTON_ALLOC						(SYSTEM/lib/obsolete/button_alloc.pro)			P Parent:??? Ptr:???",	$
	"C_EDIT							(SYSTEM/lib/obsolete/c_edit.pro)			P colors_out:??? hsv=hsv:??? hls=hls:???",	$
	"CHI_SQR1						(SYSTEM/lib/obsolete/chi_sqr1.pro)			F X:??? DF:???",	$
	"CHI_SQR						(SYSTEM/lib/obsolete/chi_sqr.pro)			F a:??? DF:???",	$
	"COLOR_EDIT						(SYSTEM/lib/obsolete/color_edit.pro)			P colors_out:??? hsv=hsv:??? hls=hls:???",	$
	"CONTINGENT						(SYSTEM/lib/obsolete/contingent.pro)			P X:??? ChiSqr:??? Prob:??? DF:??? /COLNAMES:??? /ROWNAMES:??? /LIST_NAME:???",	$
	"CONVERT_SR54						(SYSTEM/lib/obsolete/convert_sr54.pro)			P ExistingSRFile:??? NewSRFile:???",	$
	"CORREL_MATRIX						(SYSTEM/lib/obsolete/correl_matrix.pro)			F X:???",	$	
	"COSINES						(SYSTEM/lib/obsolete/cosines.pro)			F x:??? m:???",	$
	"CW_BSELECTOR						(SYSTEM/lib/obsolete/cw_bselector.pro)			F parent:??? names:??? /EVENT_FUNCT:??? /RETURN_UVALUE:??? /FONT:??? /FRAME:??? /IDS:??? /LABEL_TOP:??? /LABEL_LEFT:??? /MAP:??? /RETURN_ID:??? /RETURN_INDEX:??? /RETURN_NAME:??? /SET_VALUE:??? /UVALUE:??? /YOFFSET:??? /YSIZE:???",	$
	"CW_COLOR_INDEX						(SYSTEM/lib/obsolete/cw_color_index.pro)		F parent:???",	$
	"CW_LOADSTATE						(SYSTEM/lib/obsolete/cw_loadstate.pro)			P base:??? state_base:??? state_stash:??? state:???",	$
	"CW_SAVESTATE						(SYSTEM/lib/obsolete/cw_savestate.pro)			P base:??? state_base:??? new_state:???",	$
	"DEMO_MODE						(SYSTEM/lib/obsolete/demo_mode.pro)			F",	$
	"DIFFEQ_23						(SYSTEM/lib/obsolete/diffeq_23.pro)			P funct:??? init:??? start:??? finish:??? times:??? yvalues:??? /TOL:??? /REPORT:??? /PARAMS:??? /LISTNAME:??? /DEPVAR:???",	$
	"DIFFEQ_45						(SYSTEM/lib/obsolete/diffeq_45.pro)			P funct:??? init:??? start:??? finish:??? times:??? yvalues:??? /TOL:??? /REPORT:??? /PARAMS:??? /LISTNAME:??? /DEPVAR:???",	$
	"DISP_TXT						(SYSTEM/lib/obsolete/disp_txt.pro)			P strings:??? fonts:??? yspace:??? /XSTART:??? /YSTART:??? /DEF_FONT:??? /DEF_STYLE:??? /DEF_JUST:??? /DEF_SIZE:??? /DEF_COLOR:??? /COLORS:??? /W_ERASE:???",	$
	"DL_MAC							(SYSTEM/lib/obsolete/dl_mac.pro)			P NAME:??? /PRINT:??? /DIRECTORY:???",	$
	"DL_VMS							(SYSTEM/lib/obsolete/dl_vms.pro)			P NAME:??? /FILE:??? /PRINT:??? /PATH:??? /NOFILEMSG:???",	$
	"DRAW_ALLOC						(SYSTEM/lib/obsolete/draw_alloc.pro)			P Parent:??? Ptr:???",	$
	"EIGEN_II						(SYSTEM/lib/obsolete/eigen_ii.pro)			F a:??? eval:??? /DOUBLE:??? /ITMAX:???",	$
	"EQUAL_VARIANCE						(SYSTEM/lib/obsolete/equal_variance.pro)		P X1:??? FC:??? DF:??? P:??? /ONE_WAY:??? /UNEQUAL_ONE_WAY:??? /TWO_WAY:??? /INTERACTIONS_TWO_WAY:??? /HARTLEY:??? /BARTLETT:??? /BOX:??? /LEVENE:??? /MISSING:??? /GROUP_NO:??? /BLOCK:??? /TINTERACTION:???",	$
	"FIELD_ALLOC						(SYSTEM/lib/obsolete/field_alloc.pro)			P Parent:??? Ptr:???",	$
	"FILLCONTOUR						(SYSTEM/lib/obsolete/fillcontour.pro)			P data:??? x:??? y:???",	$
	"FRIEDMAN						(SYSTEM/lib/obsolete/friedman.pro)			P Data:??? Rank:??? F:??? Prob:??? DF:??? /NAMES:??? /LIST_NAME:??? /NOPRINT:???",	$
	"FSLID_ALLOC						(SYSTEM/lib/obsolete/fslid_alloc.pro)			P Parent:??? Ptr:???",	$
	"F_TEST1						(SYSTEM/lib/obsolete/f_test1.pro)			F X:??? DFN:??? DFD:???",	$
	"F_TEST							(SYSTEM/lib/obsolete/f_test.pro)			F a:??? DFN:??? DFD:???",	$
	"GAUSS							(SYSTEM/lib/obsolete/gauss.pro)				F a:???",	$
	"GETHELP						(SYSTEM/lib/obsolete/gethelp.pro) 			F [Variable:input] /ONELINE /PROCEDURES /FUNCTIONS /SYS_PROCS /SYS_FUNCS /FULLSTRING",			$
	"GOODFIT						(SYSTEM/lib/obsolete/goodfit.pro)			P Freq:??? A:??? B:??? ChiSqr:??? Prob:??? DF:??? /DISTR:???",	$
	"HELPFILES						(SYSTEM/lib/obsolete/helpfiles.pro)			P",	$
	"HELPSY							(SYSTEM/lib/obsolete/helpsy.pro)			P",	$
	"HELP_VM						(SYSTEM/lib/obsolete/help_vm.pro)			P",	$
	"HIST_EQUAL_CT						(SYSTEM/lib/obsolete/hist_equal_ct.pro)			P image:???",	$
	"HIST_EQUAL_INT						(SYSTEM/lib/obsolete/hist_equal_int.pro)		P image:???",	$
	"HSV_TO_RGB						(SYSTEM/lib/obsolete/hsv_to_rgb.pro)			P h:??? s:??? v:??? red:??? green:??? blue:???",	$
	"IBETA_PDF						(SYSTEM/lib/obsolete/ibeta_pdf.pro)			F x:??? a:??? b:???",	$
	"IDLDSSKIPLIST__DEFINE::INIT				(SYSTEM/lib/obsolete/idldsskiplist__define.pro)		F",	$
	"IDLDSSKIPLIST__DEFINE::CLEANUP				(SYSTEM/lib/obsolete/idldsskiplist__define.pro)		P",	$
	"IDLDSSKIPLIST__DEFINE::FIND				(SYSTEM/lib/obsolete/idldsskiplist__define.pro)		F",	$
	"IDLDSSKIPLIST__DEFINE::INSERT				(SYSTEM/lib/obsolete/idldsskiplist__define.pro)		F",	$
	"IDLDSSKIPLIST__DEFINE::SIZE				(SYSTEM/lib/obsolete/idldsskiplist__define.pro)		F",	$
	"IDLDSSKIPLIST__DEFINE::MAKEEMPTY			(SYSTEM/lib/obsolete/idldsskiplist__define.pro)		F",	$
	"IDLDSSKIPLIST__DEFINE::REMOVE				(SYSTEM/lib/obsolete/idldsskiplist__define.pro)		P",	$
	"IDLFFLANGUAGECAT__DEFINE				(SYSTEM/lib/obsolete/idlfflanguagecat__define.pro)	P",	$
	"IGAMMA_PDF						(SYSTEM/lib/obsolete/igamma_pdf.pro)			F a:??? x:???",	$
	"JOIN							(SYSTEM/lib/obsolete/join.pro)				P DataArray:??? pos:??? Imin:??? Sim:??? /CASENAME:??? /LIST_NAME:??? /NORM:??? /MISSING:??? /PAIR:??? /DISTANCE:??? /AMAL:??? /NOPRINT:??? /WIDTH:???",	$
	"KMEANS							(SYSTEM/lib/obsolete/kmeans.pro)			P Data1:??? CLuster:??? /VARNAME:??? /CASENAME:??? /ITER:??? /NUMBER:??? /NORM:??? /MISSING:??? /LIST_NAME:??? /CLUSTMEANS:??? /CLUSTSTD:??? /SSBETWEEN:??? /SSWITHIN:??? /NOPRINT:???",	$
	"KRUSKAL_WALLIS						(SYSTEM/lib/obsolete/kruskal_wallis.pro)		P Data:??? Rank:??? H:??? Prob:??? df:??? Pop:??? /NAMES:??? /LIST_NAME:??? /MISSING:??? /NOPRINT:???",	$
	"LABEL_ALLOC						(SYSTEM/lib/obsolete/label_alloc.pro)			P Parent:??? Ptr:???",	$
	"LATLON							(SYSTEM/lib/obsolete/latlon.pro)			P",	$
	"LEGO							(SYSTEM/lib/obsolete/lego.pro)				P data:??? xa:??? ya:??? /AX:??? /AZ:??? /CHARSIZE:??? /CHARTHICK:??? /FONT:??? /XMARGIN:??? /YMARGIN:??? /SUBTITLE:??? /TICKLEN:??? /TITLE:??? /XCHARSIZE:??? /YCHARSIZE:??? /ZCHARSIZE:??? /XMINOR:??? /YMINOR:??? /ZMINOR:??? /XRANGE:??? /YRANGE:??? /ZRANGE:??? /XSTYLE:??? /YSTYLE:??? /ZSTYLE:??? /XTICKNAME:??? /YTICKNAME:??? /ZTICKNAME:??? /XTICKS:??? /YTICKS:??? /ZTICKS:??? /XTICKV:??? /YTICKV:??? /ZTICKV:??? /XTITLE:??? /YTITLE:??? /ZTITLE:??? /BACKGROUND:??? /COLOR:??? /BARSPACE:??? /OUTLINE:??? /SHADES:??? /DELTA:???",	$
	"LIST_ALLOC						(SYSTEM/lib/obsolete/list_alloc.pro)			P Parent:??? Ptr:???",	$
	"LISTREP						(SYSTEM/lib/obsolete/listrep.pro)			P X:??? RowNum:??? Rows:??? here:???",	$
	"LISTWISE						(SYSTEM/lib/obsolete/listwise.pro)			F Data:??? MV:??? RowNum:??? Rows:??? here:???",	$
	"LJLCT							(SYSTEM/lib/obsolete/ljlct.pro)				P",	$
	"LN03							(SYSTEM/lib/obsolete/ln03.pro)				P Filename:??? To_terminal:???",	$
	"MAKETREE						(SYSTEM/lib/obsolete/maketree.pro)			P pos:??? Imin:??? Sim:??? unit:??? /CASENAME:??? /WIDTH:???",	$
	"MANN_WHITNEY						(SYSTEM/lib/obsolete/mann_whitney.pro)			P Pop:??? U0:??? U1:??? n1:??? n2:??? Z:??? Prob:??? /MISSING:???",	$
	"MAN_PROC						(SYSTEM/lib/obsolete/man_proc.pro)			P REQUEST:???",	$
	"MENUS							(SYSTEM/lib/obsolete/menus.pro)				F fcn:??? choices:??? help_str:???",	$
	"MIPSEB_DBLFIXUP					(SYSTEM/lib/obsolete/mipseb_dblfixup.pro)		P VAR:???",	$
	"MK_LIBRARY_HELP					(SYSTEM/lib/obsolete/mk_library_help.pro)		P source:??? outfile:??? /VERBOSE:??? /TITLE:???",	$
	"MOVIE							(SYSTEM/lib/obsolete/movie.pro) 			P images:input [rate:input] /ORDER:input",	$
	"MP_BASIC						(SYSTEM/lib/obsolete/mp_basic.pro)			P REQUEST:???",	$
	"MP_WIDGETS						(SYSTEM/lib/obsolete/mp_widgets.pro)			P request:??? /NO_BLOCK:???",	$
	"MSG_CAT_CLOSE						(SYSTEM/lib/obsolete/msg_cat_close.pro)			P object:???",	$
	"MSG_CAT_COMPILE					(SYSTEM/lib/obsolete/msg_cat_compile.pro)		P source:??? outfile:??? /VERBOSE:??? /MBCS:??? /LOCALE_ALIAS:???",	$
	"MSG_CAT_OPEN						(SYSTEM/lib/obsolete/msg_cat_open.pro)			F application:??? /FILENAME:??? /LOCALE:??? /PATH:??? /SUB_QUERY:??? /DEFAULT_FILENAME:??? /FOUND:???",	$
	"MULTICOMPARE						(SYSTEM/lib/obsolete/multicompare.pro)			P X:??? Contrast:??? a:??? ST:??? /ONE_WAY:??? /UNEQUAL_ONE_WAY:??? /TWO_WAY:??? /INTERACTIONS_TWO_WAY:??? /LSD:??? /BONFERRONI:??? /SCHEFFE:??? /TUKEY:??? /MISSING:??? /BLOCK:??? /TINTERACTION:???",	$
	"NR_ELMHES						(SYSTEM/lib/obsolete/nr_elmhes.pro)			F a:??? /DOUBLE:??? /NO_BALANCE:???",	$
	"NR_HQR							(SYSTEM/lib/obsolete/nr_hqr.pro)			F a:??? /DOUBLE:???",	$
	"NR_LUBKSB						(SYSTEM/lib/obsolete/nr_lubksb.pro)			F a:??? index:??? b:??? /DOUBLE:???",	$
	"NR_LUDCMP						(SYSTEM/lib/obsolete/nr_ludcmp.pro)			P a:??? index:??? /DOUBLE:??? /INTERCHANGES:???",	$
	"NR_MPROVE						(SYSTEM/lib/obsolete/nr_mprove.pro)			F a:??? alud:??? index:??? b:??? x:??? /DOUBLE:???",	$
	"NR_SPRSIN						(SYSTEM/lib/obsolete/nr_sprsin.pro)			F a:??? /DOUBLE:??? /THRESH:???",	$
	"NR_SVBKSB						(SYSTEM/lib/obsolete/nr_svbksb.pro)			F u:??? w:??? v:??? b:??? /DOUBLE:???",	$
	"NR_SVD							(SYSTEM/lib/obsolete/nr_svd.pro)			P a:??? w:??? u:??? v:??? /DOUBLE:???",	$
	"NR_WTN							(SYSTEM/lib/obsolete/nr_wtn.pro)			F a:??? coef:??? /DOUBLE:??? /INVERSE:??? /OVERWRITE:???",	$
	"ONLY_8BIT						(SYSTEM/lib/obsolete/only_8bit.pro)			P /MASK:??? /COLORS:???",	$
	"PAIRWISE						(SYSTEM/lib/obsolete/pairwise.pro)			P X:??? Missing:??? YR:??? YC:??? NotGood1:??? good:???",	$
	"PALETTE						(SYSTEM/lib/obsolete/palette.pro)			P",	$
	"PARTIAL2_COR						(SYSTEM/lib/obsolete/partial2_cor.pro)			F X:??? Y:??? C:???",	$
	"PARTIAL_COR						(SYSTEM/lib/obsolete/partial_cor.pro)			F X:??? Y:??? C:???",	$
	"PD_BISECTION						(SYSTEM/lib/obsolete/pd_bisection.pro)			F a:??? funct:??? U:??? L:??? del:???",	$
	"PDE_ADI						(SYSTEM/lib/obsolete/pde_adi.pro)			P",	$
	"PDMENU_ALLOC						(SYSTEM/lib/obsolete/pdmenu_alloc.pro)			P Parent:??? Ptr:??? N_ITEMS=NItem:???",	$
	"PHASER							(SYSTEM/lib/obsolete/phaser.pro)			P /LEGAL:??? /LETTER:??? /LANDSCAPE:??? /PORTRAIT:???",	$
	"PICKFILE						(SYSTEM/lib/obsolete/pickfile.pro) 			F /FILTER:input /PATH:input /GET_PATH:output /MUST_EXIST /GROUP:input /READ /WRITE /TITLE:input /NOCONFIRM /FIX_FILTER /FILE:input",			$
	"PMF							(SYSTEM/lib/obsolete/pmf.pro)				P unit:??? E1:??? E2:??? E3:??? E4:??? E5:??? E6:??? E7:??? E8:??? E9:??? E10:??? E11:??? E12:??? E13:??? E14:??? E15:??? E16:??? E17:??? E18:??? E19:??? E20:??? /FORMAT:??? /TITLE:???",	$
	"PM							(SYSTEM/lib/obsolete/pm.pro)				P E1:??? E2:??? E3:??? E4:??? E5:??? E6:??? E7:??? E8:??? E9:??? E10:??? E11:??? E12:??? E13:??? E14:??? E15:??? E16:??? E17:??? E18:??? E19:??? E20:??? /FORMAT:??? /TITLE:???",	$
	"POLYCONTOUR						(SYSTEM/lib/obsolete/polycontour.pro)			P filename:??? /COLOR_INDEX:??? /PATTERN:??? /DELETE_FILE:???",	$
	"POLYFITW						(SYSTEM/lib/obsolete/polyfitw.pro)			F X:input Y:input Weights:input NDegree:input [Yfit:output] [Yband:output] [Sigma:output] [Corrm:output] /DOUBLE /STATUS:output",	$
	"PROMPT							(SYSTEM/lib/obsolete/prompt.pro)			P String:???",	$
	"PWIDGET						(SYSTEM/lib/obsolete/pwidget.pro)			P x:??? y:??? /GROUP:??? /SAVE:??? /WINDOW_SIZE:??? /RESTORE:???",	$
	"READ_PNG						(SYSTEM/lib/obsolete/read_png.pro)			P Filename:input [R:output] [G:output] [B:output] /ORDER /VERBOSE /TRANSPARENT:output ",			$
	"REGRESS1						(SYSTEM/lib/obsolete/regress1.pro)			F X:??? Y:??? W:??? YFIT:??? A0:??? SIGMA:??? FTEST:??? R:??? RMUL:??? CHISQ:???",	$
	"REGRESSION						(SYSTEM/lib/obsolete/regression.pro)			P X1:??? Y1:??? W1:??? A0:??? COEFF:??? Resid:??? YFit:??? sigma:??? FTest:??? R:??? RMul:??? ChiSqr:??? /VARNAMES:??? /LISTNAME:??? /NOPRINT:??? /MISSING:??? /UNIT:???",	$
	"RGB_TO_HSV						(SYSTEM/lib/obsolete/rgb_to_hsv.pro)			P red:??? green:??? blue:??? h:??? s:??? v:???",	$
	"RMF							(SYSTEM/lib/obsolete/rmf.pro)				P unit:??? A:??? rows:??? columns:??? /DOUBLE:??? /COMPLEX:??? /FORMAT:???",	$
	"RM							(SYSTEM/lib/obsolete/rm.pro)				P A:??? rows:??? columns:??? /DOUBLE:??? /COMPLEX:???",	$
	"ROT_INT						(SYSTEM/lib/obsolete/rot_int.pro)			F A:??? ANGLE:??? MAG:??? X0:??? Y0:??? /CUBIC:???",	$
	"RSI_GAMMAI						(SYSTEM/lib/obsolete/rsi_gammai.pro)			F a:??? x:???",	$
	"RSTRPOS						(SYSTEM/lib/obsolete/rstrpos.pro) 			F Expression:input Search_String:input [Pos:input]",	$	; OBSOLETE
	"RUNS_TEST						(SYSTEM/lib/obsolete/runs_test.pro)			P Sequence1:??? RunNo:??? Prob:??? BinNo:??? Z:??? /LIST_NAME:???",	$
	"SET_NATIVE_PLOT					(SYSTEM/lib/obsolete/set_native_plot.pro)		P",	$
	"SET_SCREEN						(SYSTEM/lib/obsolete/set_screen.pro)			P xmin:??? xmax:??? ymin:??? ymax:???",	$
	"SETUP_KEYS						(SYSTEM/lib/obsolete/setup_keys.pro) 			P /ANSI /EIGHTBIT /SUN /VT200 /HP9000 /IBM /MIPS /SGI /APP_KEYPAD /NUM_KEYPAD",	$
	"SET_VIEWPORT						(SYSTEM/lib/obsolete/set_viewport.pro)			P xmin:??? xmax:??? ymin:??? ymax:???",	$
	"SET_XY							(SYSTEM/lib/obsolete/set_xy.pro)			P xmin:??? xmax:??? ymin:??? ymax:???",	$
	"SIGMA							(SYSTEM/lib/obsolete/sigma.pro)				F ARRAY:input [N_PAR:input] [DIMENSION:input]",	$
	"SIGN_TEST						(SYSTEM/lib/obsolete/sign_test.pro)			P Data:??? Diff:??? Prob:??? /NAMES:??? /LIST_NAME:??? /MISSING:??? /NOPRINT:???",	$
	"SIMPREGRESS						(SYSTEM/lib/obsolete/simpregress.pro)			F X:??? Y:??? W:??? YFit:??? A0:??? sigma:??? FTest:??? R:??? RMul:??? Chisqr:???",	$
	"SIMPSON						(SYSTEM/lib/obsolete/simpson.pro)			F funct:??? a:??? b:??? count:??? /TOL:??? /PLOT_IT:??? /COMPLEX:???",	$
	"SKEY_DEC						(SYSTEM/lib/obsolete/skey_dec.pro)			P /EIGHTBIT:??? /APP_KEYPAD:??? /NUM_KEYPAD:???",	$
	"SKEY_HP						(SYSTEM/lib/obsolete/skey_hp.pro)			P /APP_KEYPAD:??? /NUM_KEYPAD:???",	$
	"SKEY_IBM						(SYSTEM/lib/obsolete/skey_ibm.pro)			P",	$
	"SKEY_MIPS						(SYSTEM/lib/obsolete/skey_mips.pro)			P /APP_KEYPAD:??? /NUM_KEYPAD:???",	$
	"SKEY_SGI						(SYSTEM/lib/obsolete/skey_sgi.pro)			P",	$
	"SKEY_SUN						(SYSTEM/lib/obsolete/skey_sun.pro)			P /PSTERM:???",	$
	"SLICER							(SYSTEM/lib/obsolete/slicer.pro)			P /GROUP:??? /RANGE:??? /COMMANDS:??? /CMD_FILE:??? /RESOLUTION:??? /DETACHED:??? /MODAL:??? /NO_BLOCK:???",	$
	"SLIDER_ALLOC						(SYSTEM/lib/obsolete/slider_alloc.pro)			P Parent:??? Ptr:???",	$
	"SPEARMAN						(SYSTEM/lib/obsolete/spearman.pro)			P Data1:??? CorMatrix:??? /NAMES:??? /LIST_NAME:??? /MISSING:??? /NOPRINT:???",	$
	"STDEV							(SYSTEM/lib/obsolete/stdev.pro)				F Array:??? Mean:???",	$
	"STEPWISE						(SYSTEM/lib/obsolete/stepwise.pro)			P X1:??? Y1:??? InEQ:??? alpha:??? alphar:??? /VARNAMES:??? /REPORT:??? /LIST_NAME:??? /MISSING:???",	$
	"STR_SEP						(SYSTEM/lib/obsolete/str_sep.pro) 			F Str:input Separator:input /TRIM /REMOVE_ALL /ESC", $
	"STUDENT1_T						(SYSTEM/lib/obsolete/student1_t.pro)			F X:??? DF:???",	$
	"STUDENT_T						(SYSTEM/lib/obsolete/student_t.pro)			F a1:??? DF:???",	$
	"STUDRANGE						(SYSTEM/lib/obsolete/studrange.pro)			F P:??? V:??? R:???",	$
	"SURFACE_FIT						(SYSTEM/lib/obsolete/surface_fit.pro)			F surface:??? degree:???",	$
	"TESTCONTRAST						(SYSTEM/lib/obsolete/testcontrast.pro)			F A:??? unit:???",	$
	"TEXT_ALLOC						(SYSTEM/lib/obsolete/text_alloc.pro)			P Parent:??? Ptr:???",	$
	"TIFF_BYTE						(SYSTEM/lib/obsolete/tiff_byte.pro)			F a:??? i:??? /LEN:???",	$
	"TIFF_DUMP						(SYSTEM/lib/obsolete/tiff_dump.pro)			P file:input /PRIVATE:??? /TEXT:??? /GET_TAG_VALUE:??? /TAG_VALUE:???",	$
	"TIFF_READ						(SYSTEM/lib/obsolete/tiff_read.pro)			F File:input [R:output] [G:output] [B:output] /ORDER:output /PLANARCONFIG:output /UNSIGNED:???",	$
	"TIFF_WRITE						(SYSTEM/lib/obsolete/tiff_write.pro)			P File:input Array:input [Orientation:input] /RED:input /GREEN:input /BLUE:input /LONG:??? /SHORT:??? /PLANARCONFIG:input /XRESOL:input /YRESOL:input",	$
	"TPLT_ALLOC						(SYSTEM/lib/obsolete/tplt_alloc.pro)			P Parent:??? Ptr:???",	$
	"VMSCODE						(SYSTEM/lib/obsolete/vmscode.pro)			F CODE:??? /FROM_V1VMS:???",	$
	"WIDALLOC						(SYSTEM/lib/obsolete/widalloc.pro)			P",	$
	"WIDBUILD						(SYSTEM/lib/obsolete/widbuild.pro)			P",	$
	"WIDDEP							(SYSTEM/lib/obsolete/widdep.pro)			P",	$
	"WIDEDIT						(SYSTEM/lib/obsolete/widedit.pro)			P",	$
	"WIDED							(SYSTEM/lib/obsolete/wided.pro)	 			P File:???",	$
	"WIDFILE						(SYSTEM/lib/obsolete/widfile.pro)			P",	$
	"WIDMAIN						(SYSTEM/lib/obsolete/widmain.pro)			P",	$
	"WIDUTIL						(SYSTEM/lib/obsolete/widutil.pro)			P",	$
	"WILCOXON						(SYSTEM/lib/obsolete/wilcoxon.pro)			P Data:??? Rank:??? Prob:??? /NAMES:??? /LIST_NAME:??? /MISSING:??? /TAIL:??? /NOPRINT:???",	$
	"WMENU							(SYSTEM/lib/obsolete/wmenu.pro)				P GROUP=GROUP:???",	$
	"XANIMATE						(SYSTEM/lib/obsolete/xanimate.pro)			P rate:??? /SET:??? /IMAGE:??? /FRAME:??? /ORDER:??? /CLOSE:??? /TITLE:??? /WINDOW:???",	$
	"XDISTFILE						(SYSTEM/lib/obsolete/xdistfile.pro)			P FILENAME:??? SUBDIRECTORY:???",	$
	"XDL							(SYSTEM/lib/obsolete/xdl.pro)				P name:??? /GROUP:???",	$
	"XMANAGERTOOL						(SYSTEM/lib/obsolete/xmanagertool.pro)			P /GROUP:???",	$
	"XMENU							(SYSTEM/lib/obsolete/xmenu.pro)				P VALUES:??? PARENT:??? /BASE:??? /BUTTONS:??? /COLUMN:??? /EXCLUSIVE:??? /FONT:??? /FRAME:??? /NONEXCLUSIVE:??? /ROW:??? /SCROLL:??? /SPACE:??? /XPAD:??? /YPAD:??? /UVALUE:??? /X_SCROLL_SIZE:??? /Y_SCROLL_SIZE:??? /TITLE:??? /NO_RELEASE:???",	$
	"XPDMENU						(SYSTEM/lib/obsolete/xpdmenu.pro)			P DESC:??? PARENT:??? /BASE:??? /FRAME:??? /TITLE:??? /COLUMN:??? /FONT:???",	$


	; built-in ".pro"
	; ---------------
	"A_CORRELATE						(SYSTEM/lib/a_correlate.pro)				F X:input Lag:input /COVARIANCE /DOUBLE",			$
	"ADAPT_HIST_EQUAL					(SYSTEM/lib/adapt_hist_equal.pro)			F Image:input /CLIP:input /FCN:input /NREGIONS:input /TOP:input",			$
	"AMOEBA							(SYSTEM/lib/amoeba.pro)					F Ftol:input /FUNCTION_NAME:input /FUNCTION_VALUE:output /NCALLS:output /NMAX:input /P0:input /SCALE:input /SIMPLEX:input",			$
	"ANNOTATE						(SYSTEM/lib/annotate.pro)				P /COLOR_INDICES:input /DRAWABLE:input /WINDOW:input /LOAD_FILE:input /TEK_COLORS",			$
	"ARRAY_INDICES						(SYSTEM/lib/array_indices.pro)				F Array:input Index:input /DIMENSIONS",			$
	"ARROW							(SYSTEM/lib/arrow.pro)					P X0:input Y0:input X1:input Y1:input /DATA /NORMALIZED /HSIZE:input /COLOR:input /HTHICK:input /SOLID /THICK:input",	$
	"ASCII_TEMPLATE						(SYSTEM/lib/ascii_template.pro)				F [Filename:input] /BROWSE_LINES:input /CANCEL:output /GROUP:input",			$
	"BAR_PLOT						(SYSTEM/lib/bar_plot.pro) 				P Values:input /BACKGROUND:input /BARNAMES:input /BAROFFSET:input /BARSPACE:input /BARWIDTH:input /BASELINES:input /BASERANGE:input /COLORS:input /OUTLINE:input /OVERPLOT:input /ROTATE:input /TITLE:input /XTITLE:input /YTITLE:input",			$
	"BETA							(SYSTEM/lib/beta.pro)					F Z:input W:input /DOUBLE",			$
	"BILINEAR						(SYSTEM/lib/bilinear.pro)				F P:input IX:input JY:input /MISSING:input",			$
	"BIN_DATE						(SYSTEM/lib/bin_date.pro) 				F Ascii_Time:input",		$
	"BINARY_TEMPLATE					(SYSTEM/lib/binary_template.pro)			F [Filename:input] /CANCEL:output /GROUP:input /N_ROWS:input /TEMPLATE:input /DEBUG:input /NO_FILE:input",			$
	"BINOMIAL						(SYSTEM/lib/binomial.pro) 				F V:input N:input P:input /DOUBLE /GAUSSIAN",			$
	"BLK_CON						(SYSTEM/lib/blk_con.pro) 				F Filter:input Signal:input /B_LENGTH:input /DOUBLE",			$
	"BOX_CURSOR						(SYSTEM/lib/box_cursor.pro) 				P X0:input Y0:input NX:input NY:input /INIT /FIXED_SIZE /MESSAGE",			$
	"BUTTERWORTH						(SYSTEM/lib/butterworth.pro)				F X:input [Y:input] [Z:input] /CUTOFF:input /ORDER:input /ORIGIN /XDIM:input /YDIM:input /ZDIM:input",	$
	"C_CORRELATE						(SYSTEM/lib/c_correlate.pro)				F X:input Y:input Lag:input /COVARIANCE /DOUBLE",	$
	"CALDAT							(SYSTEM/lib/caldat.pro) 				P Julian:input Month:output [Day:output] [Year:output] [Hour:output] [Minute:output] [Second:output]",	$
	"CALENDAR						(SYSTEM/lib/calendar.pro) 				P [Month:input] [Year:input]",			$
	"CANNY							(SYSTEM/lib/canny.pro)					F Image:input /HIGH:input /LOW:input /SIGMA:input",	$
	"CDF_EXISTS						(SYSTEM/lib/cdf_exists.pro) 				F",			$
	"CHEBYSHEV						(SYSTEM/lib/chebyshev.pro) 				F D:input N:input",			$
	"CHISQR_CVF						(SYSTEM/lib/chisqr_cvf.pro)				F P:input Df:input",			$
	"CHISQR_PDF						(SYSTEM/lib/chisqr_pdf.pro)				F V:input Df:input",			$
	"CIR_3PNT						(SYSTEM/lib/cir_3pnt.pro) 				P X:input Y:input R:output X0:output Y0:output",		$
	"CLUST_WTS						(SYSTEM/lib/clust_wts.pro) 				F Array:input /DOUBLE /N_CLUSTERS:input /N_ITERATIONS:input /VARIABLE_WTS:input ",		$
	"CLUSTER						(SYSTEM/lib/cluster.pro) 				F Array:input Weights:input /DOUBLE /N_CLUSTERS:input",		$
	"CLUSTER_TREE						(SYSTEM/lib/cluster_tree.pro) 				F Pairdistance:input Linkdistance:input /LINKAGE:input /DATA:input /MEASURE:input /POWER_MEASURE:input",		$
	"CMYK_CONVERT+1						(SYSTEM/lib/cmyk_convert.pro)					P C:output M:output Y:output K:output R:input G:input B:input /TO_CMYK",	$
	"CMYK_CONVERT+2						(SYSTEM/lib/cmyk_convert.pro)					P C:input M:input Y:input K:input R:output G:output B:output",	$
	"COLORMAP_APPLICABLE					(SYSTEM/lib/colormap_applicable.pro) 			F redrawRequired:output",	$
	"COMFIT							(SYSTEM/lib/comfit.pro) 				F X:input Y:input A:input /EXPONENTIAL /GEOMETRIC /GOMPERTZ /HYPERBOLIC /LOGISTIC /LOGSQUARE /SIGMA:output /WEIGHTS:input /YFIT:output",				$
	"COMPLEXROUND						(SYSTEM/lib/complexround.pro) 				F Input:input",			$
	"COND							(SYSTEM/lib/cond.pro) 					F A:input /DOUBLE /LNORM:input",			$
	"CONGRID						(SYSTEM/lib/congrid.pro) 				F Array:input X:input [Y:input] [Z:input] /CENTER /CUBIC:input /INTERP /MINUS_ONE",	$
	"COORD2TO3						(SYSTEM/lib/coord2to3.pro) 				F Mx:input My:input Dim:input D0:input [PTI:input]",			$
	"CORRELATE						(SYSTEM/lib/correlate.pro)				F X:input [Y:input] /COVARIANCE /DOUBLE",			$
	"CRAMER							(SYSTEM/lib/cramer.pro) 				F A:input B:input /DOUBLE /ZERO:input",			$
	"CREATE_CURSOR						(SYSTEM/lib/itools/framework/create_cursor.pro)		F StringArray:input /HOTSPOT:output /MASK:output",			$
	"CREATE_VIEW						(SYSTEM/lib/create_view.pro) 				P /AX:input /AY:input /AZ:input /PERSP:input /RADIANS /WINX:input /WINY:input /XMAX:input /XMIN:input /YMAX:input /YMIN:input /ZFAC:input /ZMAX:input /ZMIN:input /ZOOM:input",			$
	"CROSSP							(SYSTEM/lib/crossp.pro) 				F V1:input V2:input",	$
	"CRVLENGTH						(SYSTEM/lib/crvlength.pro) 				F X:input Y:input /DOUBLE",			$
	"CT_LUMINANCE						(SYSTEM/lib/ct_luminance.pro) 				F [R:input] [G:input] [B:input] /BRIGHT:output /DARK:output /READ_TABLES",			$
	"CTI_TEST						(SYSTEM/lib/cti_test.pro)				F Obfreq:input /COEFF:output /CORRECTED /CRAMV:output /DF:output /EXFREQ:output /RESIDUAL:output",			$
	"CURVEFIT						(SYSTEM/lib/curvefit.pro)				F X:input Y:input Weights:input A:input [Sigma:output] /CHISQ:output /DOUBLE /FITA:input /FUNCTION_NAME:input /ITER:output /ITMAX:input /NODERIVATIVE /STATUS:output /TOL:input /YERROR:output /CHI2:output",	$	; CHI2 n'est pas dans la doc
	"CV_COORD						(SYSTEM/lib/cv_coord.pro) 				F /DEGREES /DOUBLE /FROM_CYLIN:input /FROM_POLAR:input /FROM_RECT:input /FROM_SPHERE:input /TO_CYLIN /TO_POLAR /TO_RECT /TO_SPHERE",	$
	"CVTTOBM						(SYSTEM/lib/cvttobm.pro) 				F Array:input /THRESHOLD:input",			$
	"CW_ANIMATE						(SYSTEM/lib/cw_animate.pro) 				F Parent:input Sizex:input Sizey:input Nframes:input /NO_KILL /OPEN_FUNC:input /PIXMAPS:input /TAB_MODE:input /TRACK /UNAME:input /UVALUE:input /CYCLE /DRAW:input /INFO_FILE:input",			$
	"CW_ANIMATE_GETP					(SYSTEM/lib/cw_animate.pro)				P Widget:input Pixmaps:input /KILL_ANYWAY",			$
	"CW_ANIMATE_LOAD					(SYSTEM/lib/cw_animate.pro)				P Widget:input /CYCLE /FRAME:input /IMAGE:input /ORDER /WINDOW:input /XOFFSET:input /YOFFSET:input /TRACK",			$
	"CW_ANIMATE_RUN						(SYSTEM/lib/cw_animate.pro) 				P Widget:input [Rate:input] /NFRAMES:input /STOP /DELTA:input /LASTFRAME",			$
	"CW_ARCBALL						(SYSTEM/lib/cw_arcball.pro) 				F Parent:input /COLORS:input /FRAME /LABEL:input /RETAIN:input /SIZE:input /TAB_MODE:input /UPDATE /UNAME:input /UVALUE:input /VALUE:input",			$
	"CW_BGROUP						(SYSTEM/lib/cw_bgroup.pro) 				F Parent:input Names:input /BUTTON_UVALUE:input /COLUMN:input /EVENT_FUNCT:input /EXCLUSIVE /NONEXCLUSIVE /SPACE:input /XPAD:input /YPAD:input /FONT:input /FRAME:input /IDS:output /LABEL_LEFT:input /LABEL_TOP:input /MAP /NO_RELEASE /RETURN_ID /RETURN_INDEX /RETURN_NAME /ROW:input /SCROLL /SET_VALUE:input /TAB_MODE:input /X_SCROLL_SIZE:input /Y_SCROLL_SIZE:input /UNAME:input /UVALUE:input /XOFFSET:input /XSIZE:input /YOFFSET:input /YSIZE:input",	$
	"CW_CLR_INDEX						(SYSTEM/lib/cw_clr_index.pro) 				F Parent:input /COLOR_VALUES:input /NCOLORS:input /START_COLOR:input /EVENT_FUNC:input /FRAME /LABEL:input /TAB_MODE:input /UNAME:input /UVALUE:input /VALUE:input /XSIZE:input /YSIZE:input",			$
	"CW_COLORSEL						(SYSTEM/lib/cw_colorsel.pro) 				F Parent:input /FRAME /TAB_MODE:input /UNAME:input /UVALUE:input /XOFFSET:input /YOFFSET:input",			$
	"CW_DEFROI						(SYSTEM/lib/cw_defroi.pro) 				F Draw:input /IMAGE_SIZE:input /OFFSET:input /ORDER /RESTORE /TAB_MODE:input /ZOOM:input",			$
	"CW_FIELD						(SYSTEM/lib/cw_field.pro) 				F Parent:input /ALL_EVENTS /COLUMN /FIELDFONT:input /FLOATING /INTEGER /LONG /STRING /FONT:input /FRAME:input /NOEDIT /RETURN_EVENTS /ROW /TAB_MODE:input /TEXT_FRAME:input /TITLE:input /UNAME:input /UVALUE:input /VALUE:input /XSIZE:input /YSIZE:input /EVENT_FUNC:input",			$
	"CW_FILESEL						(SYSTEM/lib/cw_filesel.pro)				F Parent:input /FILENAME /FILTER:input /FIX_FILTER /FRAME /IMAGE_FILTER /MULTIPLE /SAVE /PATH:input /TAB_MODE:input /UNAME:input /UVALUE:input /WARN_EXIST",			$
	"CW_FORM+1						(SYSTEM/lib/cw_form.pro) 				F Desc:input              /COLUMN /IDS:output /TAB_MODE:input /TITLE:input /UNAME:input /UVALUE:input /GROUP_LEADER:input",			$
	"CW_FORM+2						(SYSTEM/lib/cw_form.pro) 				F Parent:input Desc:input /COLUMN /IDS:output /TAB_MODE:input /TITLE:input /UNAME:input /UVALUE:input /GROUP_LEADER:input",			$
	"CW_FSLIDER						(SYSTEM/lib/cw_fslider.pro) 				F Parent:input /DOUBLE /DRAG /EDIT /FORMAT:input /FRAME /MAXIMUM:input /MINIMUM:input /SCROLL:input /SUPPRESS_VALUE /TAB_MODE:input /TITLE:input /UNAME:input /UVALUE:input /VALUE:input /XSIZE:input /VERTICAL /YSIZE:input /EVENT_FUNC:input",			$
	"CW_ITMENU						(SYSTEM/lib/itools/ui_widgets/cw_itmenu.pro)		F Parent:input UI:input Target:input /CONTEXT_MENU /UNAME:input /UVALUE:input",	$
	"CW_ITPANEL						(SYSTEM/lib/itools/ui_widgets/cw_itpanel.pro)		F Parent:input UI:input /ORIENTATION:input /UNAME:input /UVALUE:input",	$
	"CW_ITSTATUSBAR						(SYSTEM/lib/itools/ui_widgets/cw_itstatusbar.pro)	F Parent:input UI:input /UNAME:input /UVALUE:input /XSIZE:input",	$
	"CW_ITTOOLBAR						(SYSTEM/lib/itools/ui_widgets/cw_ittoolbar.pro)		F Parent:input UI:input Target:input /EXCLUSIVE /ROW:input /UNAME:input /UVALUE:input",	$
	"CW_ITWINDOW						(SYSTEM/lib/itools/ui_widgets/cw_itwindow.pro)		F Parent:input UI:input /DIMENSIONS:input /VIRTUAL_DIMENSIONS:input /APP_SCROLL /BUTTON_EVENTS /CLASSNAME:input /COLOR_MODEL /COLORS:input /DRAG_NOTIFY:input /DROP_EVENTS /EVENT_FUNC:input /EVENT_PRO:input /EXPOSE_EVENTS /FRAME:input /FUNC_GET_VALUE:input /GRAPHICS_LEVEL:input /GROUP_LEADER:input /IGNORE_ACCELERATORS /KEYBOARD_EVENTS:input /KILL_NOTIFY /MOTION_EVENTS /NO_COPY /NOTIFY_REALIZE:input /PRO_SET_VALUE:input /RENDERER:input /RESOURCE_NAME:input /RETAIN:input /SCR_XSIZE:input /SCR_YSIZE:input /SCROLL /SENSITIVE /TOOLTIP:input /TRACKING_EVENTS /UNAME:input /UNITS:input /UVALUE:input /VIEWPORT_EVENTS /WHEEL_EVENTS /XOFFSET:input /XSIZE:input /X_SCROLL_SIZE:input /YOFFSET:input /YSIZE:input /Y_SCROLL_SIZE:input",	$
	"CW_LIGHT_EDITOR					(SYSTEM/lib/cw_light_editor.pro) 			F Parent:input /DIRECTION_DISABLED /DRAG_EVENTS /FRAME:input /HIDE_DISABLED /LIGHT:input /LOCATION_DISABLED /TAB_MODE:input /TYPE_DISABLED /UNAME:input /UVALUE:input /XSIZE:input /YSIZE:input /XRANGE:input /YRANGE:input /ZRANGE:input",			$
	"CW_LIGHT_EDITOR_GET					(SYSTEM/lib/cw_light_editor.pro) 			P WidgetID:input /DIRECTION_DISABLED:output /DRAG_EVENTS:output /HIDE_DISABLED:output /LIGHT:output /LOCATION_DISABLED:output /TYPE_DISABLED:output /XSIZE:output /YSIZE:output /XRANGE:output /YRANGE:output /ZRANGE:output",			$
	"CW_LIGHT_EDITOR_SET					(SYSTEM/lib/cw_light_editor.pro) 			P WidgetID:input /DIRECTION_DISABLED /DRAG_EVENTS /HIDE_DISABLED /LIGHT:input /LOCATION_DISABLED /TYPE_DISABLED /XSIZE:input /YSIZE:input /XRANGE:input /YRANGE:input /ZRANGE:input",			$
	"CW_ORIENT						(SYSTEM/lib/cw_orient.pro) 				F Parent:input /AX:input /AZ:input /FRAME /TAB_MODE:input /TITLE:input /UNAME:input /UVALUE:input /XSIZE:input /YSIZE:input",			$
	"CW_PALETTE_EDITOR					(SYSTEM/lib/cw_palette_editor.pro) 			F Parent:input /DATA:input /FRAME:input /HISTOGRAM:input /HORIZONTAL /SELECTION:input /TAB_MODE:input /UNAME:input /UVALUE:input /XSIZE:input /YSIZE:input /DEBUG:input",			$
	"CW_PALETTE_EDITOR_GET					(SYSTEM/lib/cw_palette_editor.pro) 			P WidgetID:input /ALPHA:output /HISTOGRAM:output",			$
	"CW_PALETTE_EDITOR_SET					(SYSTEM/lib/cw_palette_editor.pro) 			P WidgetID:input /ALPHA:input /HISTOGRAM:input",			$
	"CW_PDMENU						(SYSTEM/lib/cw_pdmenu.pro) 				F Parent:input Desc:input /COLUMN /CONTEXT_MENU /DELIMITER:input /FONT:input /MBAR /HELP /IDS:output /RETURN_ID /RETURN_INDEX /RETURN_NAME /RETURN_FULL_NAME /TAB_MODE:input /UNAME:input /UVALUE:input /XOFFSET:input /YOFFSET:input",			$
	"CW_RGBSLIDER						(SYSTEM/lib/cw_rgbslider.pro) 				F Parent:input /CMY /HSV /HLS /RGB /COLOR_INDEX /GRAPHICS_LEVEL:input /DRAG /FRAME /LENGTH:input /TAB_MODE:input /UNAME:input /UVALUE:input /VALUE:input /VERTICAL",			$
	"CW_TMPL						(SYSTEM/lib/cw_tmpl.pro) 				F Parent:input /TAB_MODE:input /UNAME:input /UVALUE:input",			$
	"CW_ZOOM						(SYSTEM/lib/cw_zoom.pro) 				F Parent:input /FRAME /MAX:input /MIN:input /RETAIN:input /SAMPLE:input /SCALE:input /TAB_MODE:input /TRACK /UNAME:input /UVALUE:input /XSIZE:input /X_SCROLL_SIZE:input /X_ZSIZE:input /YSIZE:input /Y_SCROLL_SIZE:input /Y_ZSIZE:input",			$
	"DEFINE_MSGBLK_FROM_FILE				(SYSTEM/lib/define_msgblk_from_file.pro) 		P Filename:input /BLOCK:input /IGNORE_DUPLICATE /PREFIX:input /VERBOSE",			$
	"DEFROI							(SYSTEM/lib/defroi.pro) 				F Sx:input Sy:input [Xverts:output] [Yverts:output] /NOREGION /NOFILL /RESTORE /X0:input /Y0:input /ZOOM:input",			$
	"DENDRO_PLOT						(SYSTEM/lib/dendro_plot.pro) 				P Clusters:input Linkdistance:input /LABEL_CHARSIZE:input /LABEL_CHARTHICK:input /LABEL_COLOR:input /LABEL_NAMES:input /LABEL_ORIENTATION:input /LINECOLOR:input /ORIENTATION:input /OVERPLOT",			$
	"DENDROGRAM						(SYSTEM/lib/dendrogram.pro) 				P Clusters:input Linkdistance:input Outverts:output Outconn:output /LEAFNODES:output",			$
	"DERIV+1						(SYSTEM/lib/deriv.pro) 					F Y:input",			$
	"DERIV+2						(SYSTEM/lib/deriv.pro) 					F X:input Y:input",			$
	"DERIVSIG+1						(SYSTEM/lib/derivsig.pro) 				F Sigy:input",			$
	"DERIVSIG+2						(SYSTEM/lib/derivsig.pro) 				F X:input Y:input Sigx:input Sigy:input",	$
	"DETERM							(SYSTEM/lib/determ.pro) 				F A:input /CHECK /DOUBLE /ZERO:input",	$
	"DIALOG_READ_IMAGE					(SYSTEM/lib/dialog_read_image.pro) 			F [Filename:input] /BLUE:output /DIALOG_PARENT:input /FILE:output /FILTER_TYPE:input /FIX_FILTER /GET_PATH:output /GREEN:output /IMAGE:output /PATH:input /QUERY:output /RED:output /TITLE:input",			$
	"DIALOG_WRITE_IMAGE					(SYSTEM/lib/dialog_write_image.pro) 			F Image:input [R:input] [G:input] [B:input] /DIALOG_PARENT:input /FILENAME:input /FIX_TYPE /NOWRITE /OPTIONS:output /PATH:input /TITLE:input /TYPE:input /WARN_EXIST",			$
	"DICOMEX_GETCONFIGFILEPATH				(SYSTEM/lib/dicomex/dicomex_getconfigfilepath.pro)	F /SYSTEM",	$
	"DICOMEX_GETSTORSCPDIR					(SYSTEM/lib/dicomex/dicomex_getstorscpdir.pro)		F",	$
	"DICOMEX_NET						(SYSTEM/lib/dicomex/dicomex_net.pro)			P /SYSTEM",	$
	"DIGITAL_FILTER						(SYSTEM/lib/digital_filter.pro) 			F Flow:input Fhigh:input A:input Nterms:input /DOUBLE",	$
	"DISSOLVE						(SYSTEM/lib/dissolve.pro) 				P Image:input /DELAY:input /ORDER /SIZ:input /X0:input /Y0:input",			$
	"DIST							(SYSTEM/lib/dist.pro) 					F N:input [M:input]",			$
	"DISTANCE_MEASURE					(SYSTEM/lib/distance_measure.pro) 			F Array:input /DOUBLE /MATRIX /MEASURE:input /POWER_MEASURE:input",			$
	"DOC_LIBRARY						(SYSTEM/lib/doc_library.pro) 				P [name:input] /PRINT /DIRECTORY:input /MULTI /PATH:input /FILE:input",			$
	"EFONT							(SYSTEM/lib/efont.pro) 					P Init_Font:input /BLOCK /GROUP:input /FILE:input",			$
	"EIGENQL						(SYSTEM/lib/eigenql.pro) 				F A:input /ABSOLUTE /ASCENDING /DOUBLE /EIGENVECTORS:output /OVERWRITE /RESIDUAL:output",			$
	"EIGENVEC						(SYSTEM/lib/eigenvec.pro) 				F A:input Eval:input /DOUBLE /ITMAX:input /RESIDUAL:output",			$
	"EOS_EXISTS						(SYSTEM/lib/eos_exists.pro) 				F",														$
	"EOS_GD_QUERY						(SYSTEM/lib/eos_gd_query.pro) 				F Filename:input GridName:input [Info:output]",			$
	"EOS_PT_QUERY						(SYSTEM/lib/eos_pt_query.pro) 				F Filename:input PointName:input [Info:output]",			$
	"EOS_QUERY						(SYSTEM/lib/eos_query.pro) 				F Filename:input [Info:output]",			$
	"EOS_SW_QUERY						(SYSTEM/lib/eos_sw_query.pro) 				F Filename:input SwathName:input [Info:output]",			$
	"ERRPLOT+1						(SYSTEM/lib/errplot.pro) 				P         Low:input High:input /WIDTH:input",			$
	"ERRPLOT+2						(SYSTEM/lib/errplot.pro) 				P X:input Low:input High:input /WIDTH:input",			$
	"EXPAND							(SYSTEM/lib/expand.pro) 				P A:input Nx:input Ny:input Result:output /FILLVAL:input /MAXVAL:input",			$
	"EXTRAC							(SYSTEM/lib/extrac.pro) 				F Array:input [CnSn:inputs]",			$
	"EXTRACT_SLICE+1					(SYSTEM/lib/extract_slice.pro) 				F Vol:input Xsize:input Ysize:input Xcenter:input Ycenter:input Zcenter:input Xrot:input        Yrot:input Zrot:input   /ANISOTROPY:input /OUT_VAL:input /RADIANS /SAMPLE /VERTICES:output /CUBIC",	$
	"EXTRACT_SLICE+2					(SYSTEM/lib/extract_slice.pro) 				F Vol:input Xsize:input Ysize:input Xcenter:input Ycenter:input Zcenter:input PlaneNormal:input Xvec:input              /ANISOTROPY:input /OUT_VAL:input          /SAMPLE /VERTICES:output /CUBIC",	$
	"F_CVF							(SYSTEM/lib/f_cvf.pro) 					F P:input Dfn:input Dfd:input",			$
	"F_PDF							(SYSTEM/lib/f_pdf.pro) 					F V:input Dfn:input Dfd:input",			$
	"FACTORIAL						(SYSTEM/lib/factorial.pro) 				F N:input /STIRLING /UL64",			$
	"FILE_WHICH+1						(SYSTEM/lib/file_which.pro) 				F            File:input /INCLUDE_CURRENT_DIR",			$
	"FILE_WHICH+2						(SYSTEM/lib/file_which.pro) 				F Path:input File:input /INCLUDE_CURRENT_DIR",			$
	"FILEPATH+1						(SYSTEM/lib/filepath.pro) 				F                /ROOT_DIR:input /SUBDIRECTORY:input /TERMINAL /TMP",	$
	"FILEPATH+2						(SYSTEM/lib/filepath.pro) 				F Filename:input /ROOT_DIR:input /SUBDIRECTORY:input           /TMP",	$
	"FLICK							(SYSTEM/lib/flick.pro) 					P A:input B:input [Rate:input]",			$
	"FLOW3							(SYSTEM/lib/flow3.pro) 					P Vx:input Vy:input Vz:input /ARROWSIZE:input /BLOB /LEN:input /NSTEPS:input /NVECS:input /SX:input /SY:input /SZ:input",			$
	"FUNCT							(SYSTEM/lib/funct.pro) 					P X:input A:input F:output [Pder:output]",			$
	"FV_TEST						(SYSTEM/lib/fv_test.pro) 				F X:input Y:input",			$
	"FX_ROOT						(SYSTEM/lib/fx_root.pro) 				F X:input Func:input /DOUBLE /ITMAX:input /STOP /TOL:input",			$
	"GAMMA							(SYSTEM/lib/gamma.pro) 					F Z:input",			$
	"GAMMA_CT						(SYSTEM/lib/gamma_ct.pro) 				P Gamma:input /CURRENT /INTENSITY",			$
	"GAUSS2DFIT						(SYSTEM/lib/gauss2dfit.pro) 				F Z:input A:output [X:input] [Y:input] /NEGATIVE /TILT",			$
	"GAUSS_CVF						(SYSTEM/lib/gauss_cvf.pro) 				F P:input",			$
	"GAUSS_PDF						(SYSTEM/lib/gauss_pdf.pro) 				F V:input",			$
	"GAUSSFIT						(SYSTEM/lib/gaussfit.pro) 				F X:input Y:input [A:output] /CHISQ:output /ESTIMATES:input /MEASURE_ERRORS:input /NTERMS:input /SIGMA:output /YERROR:output",	$
	"GET_SCREEN_SIZE					(SYSTEM/lib/get_screen_size.pro) 			F [Display_name:input] /RESOLUTION:output /DISPLAY_NAME:input",			$
	"GS_ITER						(SYSTEM/lib/gs_iter.pro) 				F A:input B:input /CHECK /DOUBLE /LAMBDA:input /MAX_ITER:input /TOL:input /X_0:input",			$
	"H_EQ_CT						(SYSTEM/lib/h_eq_ct.pro)				P [Image:input]",			$
	"H_EQ_INT						(SYSTEM/lib/h_eq_int.pro)				P [Image:input]",			$
	"H5_CREATE						(SYSTEM/lib/h5_create.pro)				P Filename:input Structure:input",	$
	"H5T_ENUM_GET_DATA					(SYSTEM/lib/h5t_enum_get_data.pro)			F Datatype_id:input",	$
	"H5T_ENUM_SET_DATA					(SYSTEM/lib/h5t_enum_set_data.pro)			P Datatype_id:input Data:input Values:input",	$
	"H5T_ENUM_VALUES_TO_NAMES				(SYSTEM/lib/h5t_enum_values_to_names.pro)		F Datatype_id:input Values:input",	$
	"H5T_STR_TO_VLEN					(SYSTEM/lib/h5t_str_to_vlen.pro)			F Array:input /NO_COPY",	$
	"H5T_VLEN_TO_STR					(SYSTEM/lib/h5t_vlen_to_str.pro)			F Array:input /PTR_FREE",	$
	"H5_PARSE+1						(SYSTEM/lib/h5_parse.pro) 				F File:input /READ_DATA",			$
	"H5_PARSE+2						(SYSTEM/lib/h5_parse.pro) 				F Loc_id:input Name:input /FILE:input /PATH:input /READ_DATA /SHOW_HARDLINKS",			$
	"H5_BROWSER						(SYSTEM/lib/h5_browser.pro) 				F [Files:input] /DIALOG_READ /GROUP_LEADER /TITLE",			$
	"HANNING						(SYSTEM/lib/hanning.pro) 				F N1:input [N2:input] /ALPHA:input /DOUBLE",	$
	"HDF_EXISTS						(SYSTEM/lib/hdf_exists.pro)				F",			$
	"HILBERT						(SYSTEM/lib/hilbert.pro)				F X:input [D:input]",			$
	"HIST_2D						(SYSTEM/lib/hist_2d.pro)				F V1:input V2:input /BIN1:input /BIN2:input /MAX1:input /MAX2:input /MIN1:input /MIN2:input",			$
	"HIST_EQUAL						(SYSTEM/lib/hist_equal.pro) 				F A:input /BINSIZE:input /FCN:input /HISTOGRAM_ONLY /MAXV:input /MINV:input /OMAX:output /OMIN:output /PERCENT:input /TOP:input",			$
	"HLS							(SYSTEM/lib/hls.pro) 					P Litlo:input Lithi:input Satlo:input Sathi:input Hue:input Loops:input [Colr:input]",			$
	"HSV							(SYSTEM/lib/hsv.pro) 					P Vlo:input Vhi:input Satlo:input Sathi:input Hue:input Loops:input [Colr:input]",			$
	"IBETA							(SYSTEM/lib/ibeta.pro) 					F A:input B:input Z:input /DOUBLE /EPS:input /ITER:output /ITMAX:input",			$
	"ICONTOUR						(SYSTEM/lib/itools/icontour.pro) 			P Z:input [X:input] [Y:input] /GRID_UNITS:input /RGB_TABLE:input /ZVALUE:input " + itool_common_keywords + ' ' + itool_contour_keywords + ' ' + itool_axis_keywords,	$ 
	"IDENTITY						(SYSTEM/lib/identity.pro)	 			F N:input /DOUBLE",	$
	"IDLITSYS_CREATETOOL					(SYSTEM/lib/itools/framework/idlitsys_createtool.pro)	F StrTool:input /DIMENSIONS:input /DISABLE_SPLASH_SCREEN /IDENTIFIER:output /INITIAL_DATA:input /LOCATION:input /MACRO_NAMES:input /NO_SAVEPROMPT /OVERPLOT:input /STYLE_NAME:input /USER_INTERFACE:input /VIEW_GRID:input /VIEW_NEXT /VIEW_NUMBER:input /VISUALIZATION_TYPE:input /BACKGROUND_COLOR:input /DISABLE_UPDATES /MAP_PROJECTION:input /TOOLNAME:input /VIEW_TITLE",			$
	"IGAMMA							(SYSTEM/lib/igamma.pro) 				F A:input Z:input /DOUBLE /EPS:input /ITER:output /ITMAX:input /METHOD:output",			$
	"IIMAGE							(SYSTEM/lib/itools/iimage.pro) 				P Image:input [X:input] [Y:input] [parm4:input] /GRID_UNITS:input /CLIP_PLANES:input /HIDE /RGB_TABLE:input /ZVALUE:input /PALETTE:input " + itool_common_keywords + ' ' + itool_image_keywords,	$
	"IMAGE_CONT						(SYSTEM/lib/image_cont.pro) 				P A:input /ASPECT /INTERP /WINDOW_SCALE",			$
	"IMAP							(SYSTEM/lib/itools/imap.pro) 				P [Image_or_Z:input] [X:input] [Y:input] [parm4:input] /MAP_PROJECTION:input /GRID_UNITS:input /CONTOUR /CLIP_PLANES:input /HIDE /RGB_TABLE:input /ZVALUE:input " + itool_common_keywords + ' ' + itool_image_keywords + ' ' + itool_contour_keywords + ' ' + itool_map_projection_keywords + ' ' + itool_axis_keywords,	$
	"INT_2D							(SYSTEM/lib/int_2d.pro) 				F Fxy:input AB_Limits:input PQ_Limits:input Pts:input /DOUBLE /ORDER",			$
	"INT_3D							(SYSTEM/lib/int_3d.pro) 				F Fxyz:input AB_Limits:input PQ_Limits:input UV_Limits:input Pts:input /DOUBLE",			$
	"INT_TABULATED						(SYSTEM/lib/int_tabulated.pro) 				F X:input F:input /DOUBLE /SORT",	$
	"INTERPOL+1						(SYSTEM/lib/interpol.pro) 				F V:input N:input         /LSQUADRATIC /QUADRATIC /SPLINE",	$
	"INTERPOL+2						(SYSTEM/lib/interpol.pro) 				F V:input X:input U:input /LSQUADRATIC /QUADRATIC /SPLINE",	$
	"IPLOT							(SYSTEM/lib/itools/iplot.pro) 				P [X_or_R:input] [Y_or_Theta:input] [Z:input] /POLAR " + itool_common_keywords + ' ' + itool_plot_keywords,	$
	"ISURFACE						(SYSTEM/lib/itools/isurface.pro) 			P [Z:input] [X:input] [Y:input] " + itool_common_keywords + ' ' + itool_surface_keywords + ' ' + itool_axis_keywords,	$
	"ITCURRENT						(SYSTEM/lib/itools/itcurrent.pro) 			P iToolID:input",			$
	"ITDELETE						(SYSTEM/lib/itools/itdelete.pro) 			P [iToolID:input]",			$
	"ITGETCURRENT						(SYSTEM/lib/itools/itgetcurrent.pro) 			F /TOOL:output",			$
	"ITREGISTER						(SYSTEM/lib/itools/itregister.pro) 			P Name:input ItemName:input /ANNOTATION /DEFAULT /FILE_READER /FILE_WRITER /TYPES:input /UI_PANEL /UI_SERVICE /USER_INTERFACE /VISUALIZATION /TOOL",			$
	"ITRESET						(SYSTEM/lib/itools/itreset.pro) 			P /NO_PROMPT:input",			$
	"ITRESOLVE						(SYSTEM/lib/itools/itresolve.pro) 			P /PATH:input",			$
	"IVECTOR						(SYSTEM/lib/itools/ivector.pro)				P U:input V:input [X:input] [Y:input] " + itool_common_keywords + " " +itool_vector_keywords + " " + itool_axis_keywords,	$
	"IVOLUME						(SYSTEM/lib/itools/ivolume.pro) 			P [Vol0:input] [Vol1:input] [Vol2:input] [Vol3:input] " + itool_common_keywords + ' ' + itool_volume_keywords + ' ' + itool_axis_keywords,			$
	"JULDAY							(SYSTEM/lib/julday.pro) 				F Month:input Day:input Year:input [Hour:input] [Minute:input] [Second:input]",			$
	"KRIG2D							(SYSTEM/lib/krig2d.pro) 				F Z:input [X:input] [Y:input] /EXPONENTIAL:input /SPHERICAL:input /REGULAR /XGRID:input /XVALUES:input /YGRID:input /YVALUES:input /GS:input /BOUNDS:input /NX:input /NY:input",			$
	"KURTOSIS						(SYSTEM/lib/kurtosis.pro) 				F X:input /DOUBLE /NAN",			$
	"KW_TEST						(SYSTEM/lib/kw_test.pro) 				F X:input /DF:output /MISSING:input",			$
	"LA_DETERM						(SYSTEM/lib/la_determ.pro) 				F A:input /CHECK /DOUBLE /ZERO:input",			$
	"LA_LINEAR_EQUATION					(SYSTEM/lib/la_linear_equation.pro) 			F Array:input B:input /BACKWARD_ERROR:output /DOUBLE /FORWARD_ERROR:output /STATUS:output",			$
	"LABEL_DATE						(SYSTEM/lib/label_date.pro) 				F [axisIn:input] [indexIn:input] [valueIn:input] [levelIn:input] /DATE_FORMAT:input /AM_PM:input /DAYS_OF_WEEK:input /MONTHS:input /OFFSET:input /ROUND_UP",			$
	"LADFIT							(SYSTEM/lib/ladfit.pro) 				F X:input Y:input /ABSDEV:output /DOUBLE",			$
	"LAGUERRE						(SYSTEM/lib/laguerre.pro) 				F X:input N:input [K:input] /COEFFICIENTS:output /DOUBLE",			$
	"LEEFILT						(SYSTEM/lib/leefilt.pro) 				F A:input [N:input] [Sig:input] /DOUBLE /EXACT",			$
	"LINFIT							(SYSTEM/lib/linfit.pro) 				F X:input Y:input /CHISQR:output /COVAR:output /DOUBLE /MEASURE_ERRORS:input /PROB:output /SIGMA:output /YFIT:output /SIG_AB:output /SDEV:input",	$
	"LL_ARC_DISTANCE					(SYSTEM/lib/ll_arc_distance.pro) 			F Lon_lat0:input Arc_Dist:input Az:input /DEGREES",			$
	"LMFIT							(SYSTEM/lib/lmfit.pro) 					F X:input Y:input A:input /ALPHA:output /CHISQ:output /CONVERGENCE:output /COVAR:output /DOUBLE /FITA:input /FUNCTION_NAME:input /ITER:output /ITMAX:input /ITMIN:input /MEASURE_ERRORS:input /SIGMA:output /TOL:input /WEIGHTS:input",			$
	"LOADCT							(SYSTEM/lib/loadct.pro) 				P [Table:input] /BOTTOM:input /FILE:input /GET_NAMES:output /NCOLORS:input /SILENT",	$
	"LU_COMPLEX						(SYSTEM/lib/lu_complex.pro) 				F A:input B:input /DOUBLE /INVERSE /SPARSE",			$
	"M_CORRELATE						(SYSTEM/lib/m_correlate.pro) 				F X:input Y:input /DOUBLE",			$
	"MAP_2POINTS						(SYSTEM/lib/map_2points.pro)	 			F lon0:input lat0:input lon1:input lat1:input /DPATH:input /METERS /MILES /NPATH:input /PARAMETERS /RADIANS:input /RADIUS /RHUMB",			$
	"MAP_CONTINENTS						(SYSTEM/lib/map_continents.pro) 			P /COASTS /COLOR:input /CONTINENTS /COUNTRIES /FILL_CONTINENTS:input /ORIENTATION:input /HIRES /LIMITS:input /MAP_STRUCTURE:input /MLINESTYLE:input /MLINETHICK:input /RIVERS /SPACING:input /USA",	$
	"MAP_GRID						(SYSTEM/lib/map_grid.pro) 				P /BOX_AXES /CLIP_TEXT:input /LATALIGN:input /LONALIGN:input /LATLAB:input /LONLAB:input /ORIENTATION:input /CHARSIZE:input /COLOR:input /FILL_HORIZON /GLINESTYLE:input /GLINETHICK:input /HORIZON /INCREMENT:input /LABEL:input /LATDEL:input /LATNAMES:input /LATS:input /LONDEL:input /LONNAMES:input /LONS:input /MAP_STRUCTURE:input /NO_GRID /WHOLE_MAP",	$
	"MAP_IMAGE						(SYSTEM/lib/map_image.pro) 				F Image:input [Startx:output] [Starty:output] [Xsize:output] [Ysize:output] /LATMIN:input /LATMAX:input /LONMIN:input /LONMAX:input /BILINEAR /COMPRESS:input /SCALE:input /MAP_STRUCTURE:input /MASK:output /MAX_VALUE:input /MIN_VALUE:input /MISSING:input /WHOLE_MAP",	$ ; manque WHOLE_MAP dans la doc
	"MAP_PATCH						(SYSTEM/lib/map_patch.pro) 				F Image_Orig:input [Lons:input] [Lats:input] /LAT0:input /LAT1:input /LON0:input /LON1:input /MAX_VALUE:input /MISSING:input /TRIANGULATE /XSIZE:output /XSTART:output /YSIZE:output /YSTART:output /LATMIN:input /LATMAX:input /LONMIN:input /LONMAX:input /DEBUG",			$
	"MAP_PROJ_IMAGE						(SYSTEM/lib/map_proj_image.pro) 			F Image:input [Range:input] /BILINEAR /DIMENSIONS:input /IMAGE_STRUCTURE:input /MAP_STRUCTURE:input /MASK:output /MAX_VALUE:input /MIN_VALUE:input /MISSING:input /UVRANGE:output /XINDEX:output /YINDEX:output /AUTO_DIMENSIONS",			$
	"MAP_PROJ_INFO						(SYSTEM/lib/map_proj_info.pro) 				P [iproj:input] /AZIMUTHAL:output /CIRCLE:output /CYLINDRICAL:output /CURRENT /LL_LIMITS:output /NAME:output /PROJ_NAMES:output /UV_LIMITS:output /UV_RANGE:output /UVRANGE:input /SCALE:output /CONIC",	$
	"MAP_PROJ_INIT						(SYSTEM/lib/map_proj_init.pro) 				F Projection:input /DATUM:input /GCTP /LIMIT:input /RADIANS /RELAXED /CENTER_AZIMUTH:input /CENTER_LATITUDE:input /CENTER_LONGITUDE:input /FALSE_EASTING:input /FALSE_NORTHING:input /HEIGHT:input /HOM_AZIM_LONGITUDE:input /HOM_AZIM_ANGLE:input /HOM_LATITUDE1:input /HOM_LATITUDE2:input /HOM_LONGITUDE1:input /HOM_LONGITUDE2:input /IS_ZONES:input /IS_JUSTIFY:input /MERCATOR_SCALE:input /OEA_ANGLE:input /OEA_SHAPEM:input /OEA_SHAPEN:input /ROTATION:input /SEMIMAJOR_AXIS:input /SEMIMINOR_AXIS:input /SOM_INCLINATION:input /SOM_LONGITUDE:input /SOM_PERIOD:input /SOM_RATIO:input /SOM_FLAG:input /SOM_LANDSAT_NUMBER:input /SOM_LANDSAT_PATH:input /SPHERE_RADIUS:input /STANDARD_PARALLEL:input /STANDARD_PAR1:input /STANDARD_PAR2:input /SAT_TILT:input /TRUE_SCALE_LATITUDE:input /ZONE:input",			$
	"MAP_SET						(SYSTEM/lib/map_set.pro) 				P [P0lat:input] [P0lon:input] [Rot:input] /PROJECTION:input /WHOLE_MAP:input /AITOFF /ALBERS /AZIMUTHAL /CONIC /CYLINDRICAL /GNOMIC /GOODESHOMOLOSINE /HAMMER /LAMBERT /MERCATOR /MILLER_CYLINDRICAL /MOLLWEIDE /ORTHOGRAPHIC /ROBINSON /SATELLITE /SINUSOIDAL /STEREOGRAPHIC /TRANSVERSE_MERCATOR /NAME:input /ADVANCE /CHARSIZE:input /CLIP /COLOR:input /CONTINENTS /CON_COLOR:input /HIRES /E_CONTINENTS:input /E_GRID:input /E_HORIZON:input /GLINESTYLE:input /GLINETHICK:input /GRID /HORIZON /LABEL:input /LATALIGN:input /LATDEL:input /LATLAB:input /LONALIGN:input /LONDEL:input /LONLAB:input /MLINESTYLE:input /MLINETHICK:input /NOBORDER /NOERASE /REVERSE:input /TITLE:input /USA /XMARGIN:input /YMARGIN:input /CENTRAL_AZIMUTH:input /ELLIPSOID:input /ISOTROPIC /LIMIT:input /SAT_P:input /SCALE:input /STANDARD_PARALLELS:input",	$ ; manque PROJECTION et WHOLE_MAP dans la doc
	"MATRIX_POWER						(SYSTEM/lib/matrix_power.pro) 				F Array:input N:input /DOUBLE /STATUS:output",			$
	"MD_TEST						(SYSTEM/lib/md_test.pro) 				F X:input /ABOVE:output /BELOW:output /MDC:output",			$
	"MEAN							(SYSTEM/lib/mean.pro) 					F X:input /DOUBLE /NAN",	$
	"MEANABSDEV						(SYSTEM/lib/meanabsdev.pro) 				F X:input /DOUBLE /MEDIAN /NAN",			$
	"MESH_OBJ						(SYSTEM/lib/mesh_obj.pro)	 			P Type:input Vertex_List:output Polygon_List:output Array1:input [Array2:input] /CLOSED /DEGREES /P1:input /P2:input /P3:input /P4:input /P5:input",			$
	"MIN_CURVE_SURF						(SYSTEM/lib/min_curve_surf.pro) 			F Z:input [X:input] [Y:input] /DOUBLE /TPS /REGULAR /SPHERE /CONST /XGRID:input /XVALUES:input /YGRID:input /YVALUES:input /GS:input /BOUNDS:input /NX:input /NY:input /XOUT:output /YOUT:output /XPOUT:output /YPOUT:output",			$
	"MK_HTML_HELP						(SYSTEM/lib/mk_html_help.pro) 				P Sources:input Filename:input /STRICT /TITLE:input /VERBOSE",			$
	"MODIFYCT						(SYSTEM/lib/modifyct.pro) 				P Itab:input Name:input R:input G:input B:input /FILE:input",	$
	"MOMENT							(SYSTEM/lib/moment.pro) 				F X:input /DOUBLE /MDEV:output /NAN /SDEV:output /MAXMOMENT:input",			$
	"MORPH_CLOSE						(SYSTEM/lib/morph_close.pro) 				F Image:input Structure:input /GRAY /PRESERVE_TYPE:input /UINT /ULONG /VALUES:input",			$
	"MORPH_GRADIENT						(SYSTEM/lib/morph_gradient.pro) 			F Image:input Structure:input /PRESERVE_TYPE:input /UINT /ULONG /VALUES:input",			$
	"MORPH_HITORMISS					(SYSTEM/lib/morph_hitormiss.pro) 			F Image:input HitStructure:input MissStructure:input",			$
	"MORPH_OPEN						(SYSTEM/lib/morph_open.pro) 				F Image:input Structure:input /GRAY /PRESERVE_TYPE:input /UINT /ULONG /VALUES:input",			$
	"MORPH_THIN						(SYSTEM/lib/morph_thin.pro) 				F Image:input HitStructure:input MissStructure:input",			$
	"MORPH_TOPHAT						(SYSTEM/lib/morph_tophat.pro) 				F Image:input Structure:input /PRESERVE_TYPE:input /UINT /ULONG /VALUES:input",			$
	"MPEG_CLOSE						(SYSTEM/lib/mpeg_close.pro) 				P mpegID:input",			$
	"MPEG_OPEN						(SYSTEM/lib/mpeg_open.pro) 				F Dimensions:input /BITRATE:input /FILENAME:input /IFRAME_GAP:input /MOTION_VEC_LENGTH:input /QUALITY:input",	$
	"MPEG_PUT						(SYSTEM/lib/mpeg_put.pro) 				P mpegID:input /COLOR /FRAME:input /IMAGE:input /WINDOW /ORDER",	$
	"MPEG_SAVE						(SYSTEM/lib/mpeg_save.pro) 				P mpegID:input /FILENAME:input",	$
	"MULTI							(SYSTEM/lib/multi.pro) 					P N:input",			$
	"NCDF_EXISTS						(SYSTEM/lib/ncdf_exists.pro) 				F",			$
	"NORM							(SYSTEM/lib/norm.pro) 					F A:input /DOUBLE /LNORM:input",		$
	"OPLOTERR+1						(SYSTEM/lib/oploterr.pro) 				P         Y:input Err:input [Psym:input]",			$
	"OPLOTERR+2						(SYSTEM/lib/oploterr.pro) 				P X:input Y:input Err:input [Psym:input]",			$
	"P_CORRELATE						(SYSTEM/lib/p_correlate.pro) 				F X:input Y:input C:input /DOUBLE",			$
	"PATH_CACHE						(SYSTEM/lib/path_sep.pro) 				P /CLEAR /ENABLE /REBUILD",			$
	"PATH_SEP						(SYSTEM/lib/path_sep.pro) 					F /PARENT_DIRECTORY /SEARCH_PATH",			$
	"PCOMP							(SYSTEM/lib/pcomp.pro) 					F A:input /COEFFICIENTS:input /COVARIANCE /DOUBLE /EIGENVALUES:output /NVARIABLES:input /STANDARDIZE /VARIANCES:output",			$
	"PLOT_3DBOX						(SYSTEM/lib/plot_3dbox.pro) 				P X:input Y:input Z:input /AX:input /AZ:input /GRIDSTYLE:input /PSYM:input /SOLID_WALLS /XY_PLANE /XYSTYLE:input /XZ_PLANE /XZSTYLE:input /YZ_PLANE /YZSTYLE:input /ZAXIS:input",			$
	"PLOT_FIELD						(SYSTEM/lib/plot_field.pro) 				P U:input V:input /ASPECT:input /LENGTH:input /N:input /TITLE:input",			$
	"PLOTERR+1						(SYSTEM/lib/ploterr.pro) 				P         Y:input Err:input /TYPE:input /PSYM:input",			$
	"PLOTERR+2						(SYSTEM/lib/ploterr.pro) 				P X:input Y:input Err:input /TYPE:input /PSYM:input",			$
	"PNT_LINE						(SYSTEM/lib/pnt_line.pro) 				F P0:input L0:input L1:input [Pl:input] /INTERVAL",			$
	"POLAR_CONTOUR						(SYSTEM/lib/polar_contour.pro)			 	P Z:input Theta:input R:input /C_ANNOTATION:input /C_CHARSIZE:input /C_CHARTHICK:input /C_COLORS:input /C_LINESTYLE:input /FILL /CELL_FILL /C_ORIENTATION:input /C_SPACING:input /C_THICK:input /CLOSED /IRREGULAR /ISOTROPIC /LEVELS:input /NLEVELS:input /MAX_VALUE:input /MIN_VALUE:input /OVERPLOT /TRIANGULATION:output /XLOG /YLOG /ZAXIS /SHOW_TRIANGULATION:input /DITHER",	$
	"POLAR_SURFACE						(SYSTEM/lib/polar_surface.pro) 				F Z:input R:input Theta:input /GRID /SPACING:input /BOUNDS:input /QUINTIC /MISSING:input",	$
	"POLY							(SYSTEM/lib/poly.pro) 					F X:input C:input",			$
	"POLY_AREA						(SYSTEM/lib/poly_area.pro) 				F X:input Y:input /DOUBLE /SIGNED",			$
	"POLY_FIT						(SYSTEM/lib/poly_fit.pro)	 			F X:input Y:input Degree:input [yfit_old:output] [yband_old:output] [yerror_old:output] [corrm_old:output] /CHISQ:output /COVAR:output /DOUBLE /MEASURE_ERRORS:input /SIGMA:output /STATUS:output /YBAND:output /YERROR:output /YFIT:output",	$
	"POLYWARP						(SYSTEM/lib/polywarp.pro)	 			P Xi:input Yi:input Xo:input Yo:input Degree:input K:output Ky:output /DOUBLE /STATUS:output",			$
	"POPD							(SYSTEM/lib/popd.pro)		 			P",			$
	"PREF_MIGRATE						(SYSTEM/lib/pref_migrate.pro)				P /MACRO /PREFERENCE /STARTUP",	$
	"PRIMES							(SYSTEM/lib/primes.pro)	 				F K:input",			$
	"PRINTD							(SYSTEM/lib/printd.pro)	 				P",			$
	"PROFILE						(SYSTEM/lib/profile.pro)	 			F Image:input [XX:output] [YY:output] /NOMARK /XSTART:input /YSTART:input",			$
	"PROFILES						(SYSTEM/lib/profiles.pro)	 			P Image:input /ORDER /SX:input /SY:input /WSIZE:input",			$
	"PROJECT_VOL						(SYSTEM/lib/project_vol.pro)	 			F Vol:input X_Sample:input Y_Sample:input Z_Sample:input /AVG_INTENSITY /CUBIC /DEPTH_Q:input /OPAQUE:input /TRANS:input /XSIZE:input /YSIZE:input /Z_BUFFER",			$
	"PS_SHOW_FONTS						(SYSTEM/lib/ps_show_fonts.pro)	 			P /NOLATIN",			$
	"PSAFM							(SYSTEM/lib/psafm.pro)	 				P Input_Filename:input Output_Filename:input",			$
	"PSEUDO							(SYSTEM/lib/pseudo.pro)	 				P Litlo:input Lithi:input Satlo:input Sathi:input Hue:input Loops:input [Colr:input]",			$
	"PUSHD							(SYSTEM/lib/pushd.pro)		 			P Dir:input",		$
	"QUERY_ASCII						(SYSTEM/lib/query_ascii.pro)	 			F Filename:input [Info:output]",	$
	"QUERY_BMP						(SYSTEM/lib/query_bmp.pro)	 			F Filename:input [Info:output] /IMAGE_INDEX:input",	$
	"QUERY_DICOM						(SYSTEM/lib/query_dicom.pro)	 			F Filename:input [Info:output] /IMAGE_INDEX:input /DICOMEX",			$
	"QUERY_GIF						(SYSTEM/lib/query_gif.pro)	 			F Filename:input [Info:output] /IMAGE_INDEX:input",	$
	"QUERY_IMAGE						(SYSTEM/lib/query_image.pro)	 			F Filename:input [Info:output] /CHANNELS:output /DIMENSIONS:output /HAS_PALETTE:output /IMAGE_INDEX:input /NUM_IMAGES:output /PIXEL_TYPE:output /SUPPORTED_READ:output /SUPPORTED_WRITE:output /TYPE:output",			$
	"QUERY_JPEG2000						(SYSTEM/lib/query_jpeg2000.pro)		 		F Filename:input [Info:output] /IMAGE_INDEX:input",			$
	"QUERY_PICT						(SYSTEM/lib/query_pict.pro)	 			F Filename:input [Info:output] /IMAGE_INDEX:input",			$
	"QUERY_PPM						(SYSTEM/lib/query_ppm.pro)	 			F Filename:input [Info:output] /MAXVAL:output /IMAGE_INDEX:input",			$
	"QUERY_SRF						(SYSTEM/lib/query_srf.pro)	 			F Filename:input [Info:output] /IMAGE_INDEX:input",			$
	"QUERY_WAV						(SYSTEM/lib/query_wav.pro)	 			F Filename:input [Info:output] ",			$
	"R_CORRELATE						(SYSTEM/lib/r_correlate.pro)	 			F X:input Y:input /D:output /KENDALL /PROBD:output /ZD:output",			$
	"R_TEST							(SYSTEM/lib/r_test.pro)	 				F X:input /N0:output /N1:output /R:output",			$
	"RANKS							(SYSTEM/lib/ranks.pro)		 			F X:input",			$
	"RDPIX							(SYSTEM/lib/rdpix.pro)		 			P Image:input [X0:input] [Y0:input]",			$
	"READ_ASCII						(SYSTEM/lib/read_ascii.pro)	 			F [Filename:input] /COMMENT_SYMBOL:input /COUNT:output /DATA_START:input /DELIMITER:input /HEADER:output /MISSING_VALUE:input /NUM_RECORDS:input /RECORD_START:input /TEMPLATE:input /VERBOSE",			$
	"READ_BINARY						(SYSTEM/lib/read_binary.pro)	 			F [Filename:input] [FileUnit:input] /TEMPLATE:input /DATA_START:input /DATA_TYPE:input /DATA_DIMS:input /ENDIAN:input /DEBUG",	$
	"READ_BMP						(SYSTEM/lib/read_bmp.pro)	 			F Filename:input [R:output] [G:output] [B:output] [lhdr:output] /RGB",			$
	"READ_DICOM						(SYSTEM/lib/read_dicom.pro)	 			F Filename:input [Red:output] [Green:output] [Blue:output] /IMAGE_INDEX:input /DICOMEX",			$
	"READ_GIF						(SYSTEM/lib/read_gif.pro)	 			P Filename:input Image:output [R:output] [G:output] [B:output] /CLOSE /MULTIPLE",	$
	"READ_IMAGE						(SYSTEM/lib/read_image.pro)	 			F Filename:input [Red:output] [Green:output] [Blue:output] /IMAGE_INDEX:input /PLANARCONFIG:output",	$
	"READ_INTERFILE						(SYSTEM/lib/read_interfile.pro)		 		P File:input Data:output",			$
	"READ_JPEG2000						(SYSTEM/lib/read_jpeg2000.pro)	 			F Filename:input [Red:output] [Green:output] [Blue:output] /DISCARD_LEVELS:input /MAX_LAYERS:input /ORDER /REGION:input",			$
	"READ_PICT						(SYSTEM/lib/read_pict.pro)	 			P Filename:input Image:output [R:output] [G:output] [B:output] /DEBUG",			$
	"READ_PPM						(SYSTEM/lib/read_ppm.pro)	 			P Filename:input Image:output /MAXVAL:output",			$
	"READ_SPR						(SYSTEM/lib/read_spr.pro)	 			F Filename:input",			$
	"READ_SRF						(SYSTEM/lib/read_srf.pro)	 			P Filename:input Image:output [R:output] [G:output] [B:output]",			$
	"READ_SYLK						(SYSTEM/lib/read_sylk.pro)	 			F File:input /ARRAY /COLMAJOR /NCOLS:input /NROWS:input /STARTCOL:input /STARTROW:input /USEDOUBLES /USELONGS",			$
	"READ_WAV						(SYSTEM/lib/read_wav.pro)	 			F Filename:input [Rate:output]",			$
	"READ_WAVE						(SYSTEM/lib/read_wave.pro)	 			P File:input Variables:output Names:output Dimensions:output /MESHNAMES:output",			$
	"READ_X11_BITMAP					(SYSTEM/lib/read_x11_bitmap.pro)	 		P File:input Bitmap:output [X:output] [Y:output] /EXPAND_TO_BYTES",			$
	"READ_XWD						(SYSTEM/lib/read_xwd.pro)	 			F Filename:input [R:output] [G:output] [B:output] ",			$
	"REAL_PART						(SYSTEM/lib/real_part.pro)		 		F Z:input",			$
	"RECON3							(SYSTEM/lib/recon3.pro)		 			F Images:input Obj_Rot:input Obj_Pos:input Focal:input Dist:input Vol_Pos:input Img_Ref:input Img_Mag:input Vol_Size:input /CUBIC /MISSING:input /MODE:input /QUIET",			$
	"REDUCE_COLORS						(SYSTEM/lib/reduce_colors.pro)		 		P Image:input values:output",			$
	"REGION_GROW						(SYSTEM/lib/region_grow.pro)		 		F Array:input ROIPixels:input /ALL_NEIGHBORS /NAN /STDDEV_MULTIPLIER:input /THRESHOLD:input",			$
	"REGRESS						(SYSTEM/lib/regress.pro)		 		F X:input Y:input [weights_old:input] [yfit_old:output] [const_old:output] [sigma_old:output] [ftest_old:output] [r_old:output] [rmul_old:output] [chisq_old:output] [status_old:output] /CHISQ:output /CONST:output /CORRELATION:output /DOUBLE /FTEST:output /MCORRELATION:output /MEASURE_ERRORS:input /SIGMA:output /STATUS:output /YFIT:output /RELATIVE_WEIGHT",			$
	"RESOLVE_ALL						(SYSTEM/lib/resolve_all.pro)		 		P /CLASS:input /CONTINUE_ON_ERROR /QUIET /RESOLVE_EITHER:input /RESOLVE_FUNCTION:input /RESOLVE_PROCEDURE:input /SKIP_ROUTINES:input /UNRESOLVED:output",	$
	"REVERSE						(SYSTEM/lib/reverse.pro)		 		F Array:input [Subscript_Index:input] /OVERWRITE",	$
	"ROT							(SYSTEM/lib/rot.pro)		 			F A:input Angle:input [Mag:input] [X0:input] [Y0:input] /INTERP /CUBIC:input /MISSING:input /PIVOT",			$
	"RS_TEST						(SYSTEM/lib/rs_test.pro)		 		F X:input Y:input /UX:output /UY:output",			$
	"SCALE3D						(SYSTEM/lib/scale3d.pro)		 		P",			$
	"SEARCH2D						(SYSTEM/lib/search2d.pro)		 		F Array:input Xpos:input Ypos:input Min_Val:input Max_Val:input /DECREASE:input /INCREASE:input /LPF_BAND:input /DIAGONAL",			$
	"SEARCH3D						(SYSTEM/lib/search3d.pro)		 		F Array:input Xpos:input Ypos:input Zpos:input Min_Val:input Max_Val:input /DECREASE:input /INCREASE:input /LPF_BAND:input /DIAGONAL",			$
	"SFIT							(SYSTEM/lib/sfit.pro)		 			F Data:input Degree:input /IRREGULAR /KX:output /MAX_DEGREE",			$
	"SHADE_SURF_IRR						(SYSTEM/lib/shade_surf_irr.pro)	 			P Z:input X:input Y:input /AX:input /AZ:input /IMAGE:output /PLIST:output /T3D /SHADES:input",			$
	"S_TEST							(SYSTEM/lib/s_test.pro)		 			F X:input Y:input /ZDIFF:output",			$
	"SAVGOL							(SYSTEM/lib/savgol.pro)		 			F Nleft:input Nright:input Order:input Degree:input /DOUBLE",			$
	"SCALE3							(SYSTEM/lib/scale3.pro)		 			P /XRANGE:input /YRANGE:input /ZRANGE:input /AX:input /AZ:input",			$
	"SHOW3							(SYSTEM/lib/show3.pro)		 			P Image:input [X:input] [Y:input] /INTERP /E_CONTOUR:input /E_SURFACE:input /SSCALE:input",			$
	"SHOWFONT						(SYSTEM/lib/showfont.pro)	 			P Font:input Name:input /ENCAPSULATED /TT_FONT",			$
	"SKEWNESS						(SYSTEM/lib/skewness.pro)		 		F X:input /DOUBLE /NAN",			$
	"SLICER3						(SYSTEM/lib/slicer3.pro)		 		P [hData3D:input] /DATA_NAMES:input /DETACH /GROUP_LEADER:input /MODAL",			$
	"SLIDE_IMAGE						(SYSTEM/lib/slide_image.pro)		 		P [Image:input] /BLOCK /CONGRID:input /FULL_WINDOW:output /GROUP:input /ORDER /REGISTER /RETAIN:input /SLIDE_WINDOW:output /SHOW_FULL:input /TITLE:input /TOP_ID:output /XSIZE:input /XVISIBLE:input /YSIZE:input /YVISIBLE:input",			$
	"SPH_4PNT						(SYSTEM/lib/sph_4pnt.pro)		 		P X:input Y:input Z:input Xc:output Yc:output Zc:output R:output /DOUBLE",			$
	"SPH_SCAT						(SYSTEM/lib/sph_scat.pro)		 		F Lon:input Lat:input F:input /BOUNDS:input /BOUT:output /GOUT:output /GS:input /NLON:input /NLAT:input /NX:input /NY:input",			$
	"SPHER_HARM						(SYSTEM/lib/spher_harm.pro)		 		F Theta:input Phi:input L:input M:input /DOUBLE",			$
	"SPLINE							(SYSTEM/lib/spline.pro)		 			F X:input Y:input T:input [Sigma:input] /DOUBLE",			$
	"SPLINE_P						(SYSTEM/lib/spline_p.pro)		 		P X:input Y:input Xr:output Yr:output /DOUBLE /INTERVAL:input /TAN0:input /TAN1:input",			$
	"STANDARDIZE						(SYSTEM/lib/standardize.pro)		 		F A:input /DOUBLE",			$
	"STDDEV							(SYSTEM/lib/stddev.pro)	 				F X:input /DOUBLE:input /NAN:input",			$
	"STREAMLINE						(SYSTEM/lib/streamline.pro)		 		P Verts:input Conn:input Normals:input Outverts:output Outconn:output /ANISOTROPY:input /SIZE:input /PROFILE:input",			$
	"STRETCH						(SYSTEM/lib/stretch.pro)		 		P Low:input High:input [Gamma:input] /CHOP",			$
	"STRSPLIT						(SYSTEM/lib/strsplit.pro)		 		F String:input [Pattern:input] /COUNT:output /ESCAPE:input /REGEX /FOLD_CASE /EXTRACT /LENGTH:output /PRESERVE_NULL", $
	"SURFR							(SYSTEM/lib/surfr.pro)		 			P /AX:input /AZ:input",			$
	"SVDFIT							(SYSTEM/lib/svdfit.pro)		 			F X:input Y:input [M:input] /A:input /CHISQ:output /COVAR:output /DOUBLE /FUNCTION_NAME:input /LEGENDRE /MEASURE_ERRORS:input /SIGMA:output /SING_VALUES:output /SINGULAR:output /STATUS:output /TOL:input /VARIANCE:output /YFIT:output /WEIGHTS:input",	$
	"SWAP_ENDIAN						(SYSTEM/lib/swap_endian.pro)		 		F Variable:input /SWAP_IF_BIG_ENDIAN /SWAP_IF_LITTLE_ENDIAN",			$
	"SWAP_ENDIAN_INPLACE					(SYSTEM/lib/swap_endian_inplace.pro)	 		P Variable:input /SWAP_IF_BIG_ENDIAN /SWAP_IF_LITTLE_ENDIAN",	$
	"T_CVF							(SYSTEM/lib/t_cvf.pro)		 			F P:input Df:input",			$
	"T_PDF							(SYSTEM/lib/t_pdf.pro)		 			F V:input Df:input",			$
	"T3D							(SYSTEM/lib/t3d.pro)		 			P [Array:input] /RESET /MATRIX:output /OBLIQUE:input /PERSPECTIVE:input /ROTATE:input /SCALE:input /TRANSLATE:input /XYEXCH /XZEXCH /YZEXCH",	$
	"TEK_COLOR						(SYSTEM/lib/tek_color.pro)		 		P [Start_Index:input] [Colors:input]",			$
	"THREED							(SYSTEM/lib/threed.pro)		 			P A:input [Sp:input] /TITLE:input /XTITLE:input /YTITLE:input",			$
	"TIME_TEST2						(SYSTEM/lib/time_test2.pro)		 		P [Filename:input]",			$
	"TIMEGEN						(SYSTEM/lib/timegen.pro)		 		F [D1:input] [D2:input] [D3:input] [D4:input] [D5:input] [D6:input] [D7:input] [D8:input] /FINAL:input /DAYS:input /HOURS:input /MINUTES:input /MONTHS:input /SECONDS:input /START:input /STEP_SIZE:input /UNITS:input /YEAR:input",	$
	"TM_TEST						(SYSTEM/lib/tm_test.pro)		 		F X:input Y:input /PAIRED /UNEQUAL",			$
	"TRACE							(SYSTEM/lib/trace.pro)		 			F A:input /DOUBLE",			$
	"TRI_SURF						(SYSTEM/lib/tri_surf.pro)		 		F Z:input [X:input] [Y:input] /EXTRAPOLATE /LINEAR /MISSING:input /REGULAR /XGRID:input /XVALUES:input /YGRID:input /YVALUES:input /GS:input /BOUNDS:input /NX:input /NY:input",			$
	"TS_COEF						(SYSTEM/lib/ts_coef.pro)		 		F X:input P:input /DOUBLE /MSE:output",			$
	"TS_DIFF						(SYSTEM/lib/ts_diff.pro)		 		F X:input K:input /DOUBLE",	$
	"TS_FCAST						(SYSTEM/lib/ts_fcast.pro)		 		F X:input P:input Nvalues:input /BACKCAST /DOUBLE /REFLECT",			$
	"TS_SMOOTH						(SYSTEM/lib/ts_smooth.pro)		 		F X:input Nvalues:input /BACKWARD /DOUBLE /FORWARD /ORDER:input /NAN",			$
	"UNIQ							(SYSTEM/lib/uniq.pro)		 			F Array:input [INdex:input]",			$
	"UNSHARP_MASK						(SYSTEM/lib/unsharp_mask.pro)	 			F Image:input /AMOUNT:input /RADIUS:input /THRESHOLD:input /TRUE:input",			$
	"VARIANCE						(SYSTEM/lib/variance.pro)	 			F X:input /DOUBLE /NAN",			$
	"VECTOR_FIELD						(SYSTEM/lib/vector_field.pro)	 			P Field:input Outverts:output Outconn:output /ANISOTROPY:input /SCALE:input /VERTICES:input",			$
	"VEL							(SYSTEM/lib/vel.pro)		 			P U:input V:input /NVECS:input /XMAX:input /LENGTH:input /NSTEPS:input /TITLE:input",			$
	"VELOVECT						(SYSTEM/lib/velovect.pro)	 			P U:input V:input [X:input] [Y:input] /MISSING:input /DOTS /LENGTH:input /OVERPLOT",			$
	"VERT_T3D						(SYSTEM/lib/vert_t3d.pro)	 			F Vertex_List:input /DOUBLE /MATRIX:input /NO_COPY /NO_DIVIDE /SAVE_DIVIDE:output",			$
	"VORONOI						(SYSTEM/lib/voronoi.pro)	 			P X:input Y:input I0:input C:input Xp:output Yp:output Rect:input",			$
	"WARP_TRI						(SYSTEM/lib/warp_tri.pro)		 		F Xo:input Yo:input Xi:input Yi:input Image:input /OUTPUT_SIZE:input /QUINTIC /EXTRAPOLATE /TPS",			$
	"WF_DRAW						(SYSTEM/lib/wf_draw.pro)	 			P X:input Y:input /COLD /FRONT_TYPE:input /WARM /OCCLUDED /STATIONARY /CONVERGENCE /COLOR:input /DATA /DEVICE /NORMAL /INTERVAL:input /PSYM:input /SYM_HT:input /SYM_LEN:input /THICK:input",			$
	"WIDGET_TREE_MOVE					(SYSTEM/lib/widget_tree_move.pro)	 		P wMoveNodes:input wDestFolder:output /CALLBACK_FUNC:input /COPY /INDEX:input /SELECT /UPDATE /USERDATA:input",	$
	"WRITE_BMP						(SYSTEM/lib/write_bmp.pro)		 		P Filename:input Image:input [R:input] [G:input] [B:input] /FOUR_BIT /IHDR:input /HEADER_DEFINE:input /RGB",	$
	"WRITE_GIF						(SYSTEM/lib/write_gif.pro)		 		P [Filename:input] [Image:input] [R:input] [G:input] [B:input] /MULTIPLE /CLOSE",	$
	"WRITE_IMAGE						(SYSTEM/lib/write_image.pro)		 		P Filename:input Format:input Data:input [Red:input] [Green:input] [Blue:input] /APPEND",			$
	"WRITE_JPEG2000						(SYSTEM/lib/write_jpeg2000.pro)				P Filename:input Image:input [Red:input] [Green:input] [Blue:input] /N_LAYERS:input /N_LEVELS:input /ORDER /REVERSIBLE",	$
	"WRITE_NRIF						(SYSTEM/lib/write_nrif.pro)		 		P File:input Image:input [R:input] [G:input] [B:input] ",			$
	"WRITE_PICT						(SYSTEM/lib/write_pict.pro)		 		P Filename:input [Image:input] [R:input] [G:input] [B:input]",	$
	"WRITE_PPM						(SYSTEM/lib/write_ppm.pro)		 		P Filename:input Image:input /ASCII",			$
	"WRITE_SPR						(SYSTEM/lib/write_spr.pro)		 		P AS:input Filename:input",			$
	"WRITE_SRF						(SYSTEM/lib/write_srf.pro)				P Filename:input [Image:input] [R:input] [G:input] [B:input] /ORDER /WRITE_32",			$
	"WRITE_SYLK						(SYSTEM/lib/write_sylk.pro) 				F File:input Data:input /STARTCOL:input /STARTROW:input",			$
	"WRITE_WAV						(SYSTEM/lib/write_wav.pro)	 			P Filename:input Data:input Rate:input",	$
	"WRITE_WAVE						(SYSTEM/lib/write_wave.pro)	 			P File:input Array:input /BIN /DATANAME:input /MESHNAME:input /NOMESHDEF /VECTOR",			$
	"WV_CWT							(SYSTEM/lib/wavelet/source/wv_cwt.pro)			F Array:input Family:input Order:input /DOUBLE /DSCALE:input /NSCALE:input /PAD /SCALE:output /START_SCALE:input",	$
	"WV_DENOISE						(SYSTEM/lib/wavelet/source/wv_denoise.pro)		F Array:input [Family:input] [Order:input] /COEFFICIENTS:input /CUTOFF:output /DENOISE_STATE:input /DOUBLE /DWT_FILTERED:output /PERCENT:input /THRESHOLD:input /WPS_FILTERED:output",	$
	"WV_FN_COIFLET						(SYSTEM/lib/wavelet/source/wv_fn_coiflet.pro)		F [Order:input] [Scaling:output] [Wavelet:output] [Ioff:output] [Joff:output]",	$
	"WV_FN_DAUBECHIES					(SYSTEM/lib/wavelet/source/wv_fn_daubechies.pro)	F [Order:input] [Scaling:output] [Wavelet:output] [Ioff:output] [Joff:output]",	$
	"WV_FN_GAUSSIAN						(SYSTEM/lib/wavelet/source/wv_fn_gaussian.pro)		F [Order:input] [Scale:input] [N:input] /DOUBLE /FREQUENCY:output /SPATIAL /WAVELET:output",	$
	"WV_FN_HAAR						(SYSTEM/lib/wavelet/source/wv_fn_haar.pro)		F [Order:input] [Scaling:output] [Wavelet:output] [Ioff:output] [Joff:output]",	$
	"WV_FN_MORLET						(SYSTEM/lib/wavelet/source/wv_fn_morlet.pro)		F [Order:input] [Scale:input] [N:input] /DOUBLE /FREQUENCY:output /SPATIAL /WAVELET:output",	$
	"WV_FN_PAUL						(SYSTEM/lib/wavelet/source/wv_fn_paul.pro)		F [Order:input] [Scale:input] [N:input] /DOUBLE /FREQUENCY:output /SPATIAL /WAVELET:output",	$
	"WV_FN_SYMLET						(SYSTEM/lib/wavelet/source/wv_fn_symlet.pro)		F [Order:input] [Scaling:output] [Wavelet:output] [Ioff:output] [Joff:output]",	$
	"XBM_EDIT						(SYSTEM/lib/utilities/xbm_edit.pro)	 		P /BLOCK /FILENAME:input /GROUP:input /XSIZE:input /YSIZE:input",			$
	"XDISPLAYFILE						(SYSTEM/lib/utilities/xdisplayfile.pro)			P [Filename:input] /BLOCK /DONE_BUTTON:input /EDITABLE /FONT:input /GROUP:input /GROW_TO_SCREEN /HEIGHT:input /MODAL /RETURN_ID:output /TEXT:input /TITLE:input /WIDTH:input /WTEXT:output",	$
	"XDXF							(SYSTEM/lib/utilities/xdxf.pro)	 			P Filename:input /BLOCK /GROUP:input /SCALE:input /TEST /BACKGROUND:input /DOUBLE_VIEW /JUST_REG /MODAL /REFRESH:input /RENDERER:input /STATIONARY:input /TITLE:input /TLB:output /XOFFSET:input /XSIZE:input /YOFFSET:input /YSIZE:input /USE_INSTANCING /DEBUG",			$
	"XFONT							(SYSTEM/lib/utilities/xfont.pro)	 		F /GROUP:input /PRESERVE_FONT_INFO",			$
	"XINTERANIMATE						(SYSTEM/lib/utilities/xinteranimate.pro)		P [Rate:input] /SET:input /BLOCK /CYCLE /GROUP:input /MODAL /MPEG_BITRATE:input /MPEG_IFRAME_GAP:input /MPEG_MOTION_VEC_LENGTH:input /MPEG_OPEN /MPEG_FILENAME:input /MPEG_QUALITY:input /SHOWLOAD /TRACK /TITLE:input /FRAME:input /IMAGE:input /ORDER /WINDOW:input /CLOSE /KEEP_PIXMAPS /MPEG_CLOSE /XOFFSET:input /YOFFSET:input",	$
	"XLOADCT						(SYSTEM/lib/utilities/xloadct.pro)	 		P /BLOCK /BOTTOM:input /FILE:input /GROUP:input /MODAL /NCOLORS:input /SILENT /UPDATECALLBACK:input /UPDATECBDATA:input /USE_CURRENT",			$
	"XMANAGER						(SYSTEM/lib/xmanager.pro)		 		P [Name:input] [ID:input] /CATCH /CLEANUP:input /EVENT_HANDLER:input /GROUP_LEADER:input /JUST_REG /NO_BLOCK /BACKGROUND:input /MODAL",	$
	"XMNG_TMPL						(SYSTEM/lib/xmng_tmpl.pro)			 	P /BLOCK /GROUP:input",			$
	"XMTOOL							(SYSTEM/lib/utilities/xmtool.pro)	 		P /BLOCK /GROUP:input",			$
	"XOBJVIEW						(SYSTEM/lib/utilities/xobjview.pro)	 		P Obj:input /BACKGROUND:input /BLOCK /DOUBLE_VIEW /GROUP:input /JUST_REG /MODAL /REFRESH:input /RENDERER:input /SCALE:input /STATIONARY:input /TEST /TITLE:input /TLB:output /XOFFSET:input /XSIZE:input /YOFFSET:input /YSIZE:input /USE_INSTANCING /DEBUG",			$
	"XOBJVIEW_ROTATE					(SYSTEM/lib/utilities/xobjview_rotate.pro)		P Axis:input Angle:input /PREMULTIPLY /TLB:input",			$
	"XOBJVIEW_WRITE_IMAGE					(SYSTEM/lib/utilities/xobjview_write_image.pro)		P Filename:input Format:input /DIMENSIONS:input /TLB:input",	$
	"XPALETTE						(SYSTEM/lib/utilities/xpalette.pro)		 	P /BLOCK /GROUP:input /UPDATECALLBACK:input /UPDATECBDATA:input",			$
	"XPCOLOR						(SYSTEM/lib/utilities/xpcolor.pro)	 		P /GROUP:input",			$
	"XPLOT3D						(SYSTEM/lib/utilities/xplot3d.pro)	 		P X:input Y:input Z:input /BLOCK /COLOR:input /DOUBLE_VIEW /GROUP:input /LINESTYLE:input /MODAL /NAME:input /OVERPLOT /SYMBOL:input /TEST /THICK:input /TITLE:input /XRANGE:input /XTITLE:input /YRANGE:input /YTITLE:input /ZRANGE:input /ZTITLE:input /JUST_REG",			$
	"XREGISTERED						(SYSTEM/lib/xregistered.pro)		 		F Name:input /NOSHOW",			$
	"XROI							(SYSTEM/lib/utilities/xroi.pro)		 		P [ImageData:input] [R:input] [G:input] [B:input] /BLOCK /FLOATING /GROUP:input /MODAL /REGIONS_IN:input /REGIONS_OUT:output /REJECTED:output /RENDERER:input /ROI_COLOR:input /ROI_GEOMETRY:output /ROI_SELECT_COLOR:input /STATISTICS:output /TITLE:input /TOOLS:input /X_SCROLL_SIZE:input /Y_SCROLL_SIZE:input /UNAME:input /TEST /APPTLB:input /RECORD_TO_FILENAME /DEBUG",			$
	"XSQ_TEST						(SYSTEM/lib/xsq_test.pro)		 		F Obfreq:input Exfreq:input /EXCELL:output /OBCELL:output /RESIDUAL:output",			$
	"XSURFACE						(SYSTEM/lib/utilities/xsurface.pro)		 	P Data:input /BLOCK /GROUP:input",			$
	"XVAREDIT						(SYSTEM/lib/utilities/xvaredit.pro)		 	P Var:input /NAME:input /GROUP:input /X_SCROLL_SIZE:input /Y_SCROLL_SIZE:input",			$
	"XVOLUME						(SYSTEM/lib/utilities/xvolume.pro)		 	P Vol:input /BLOCK /GROUP:input /INTERPOLATE /MODAL /RENDERER:input /REPLACE /SCALE:input /TEST /XSIZE:input /YSIZE:input /DEBUG",			$
	"XVOLUME_ROTATE						(SYSTEM/lib/utilities/xvolume_rotate.pro)	 	P Axis:input Angle:input /PREMULTIPLY /TLB:input",			$
	"XVOLUME_WRITE_IMAGE					(SYSTEM/lib/utilities/xvolume_write_image.pro)	 	P Filename:input Format:input /DIMENSIONS:input /TLB:input",			$
	"ZOOM							(SYSTEM/lib/zoom.pro)		 			P /CONTINUOUS /FACT:input /INTERP /KEEP /NEW_WINDOW /XSIZE:input /YSIZE:input /ZOOM_WINDOW:output",	$
	"ZOOM_24						(SYSTEM/lib/zoom_24.pro)	 			P /FACT:input /RIGHT /XSIZE:input /YSIZE:input",			$


	; IDLANROI
	; --------
	"IDLANROI::APPENDDATA			(SYSTEM/built-in/IDLANROI)	P X:input [Y:input] [Z:input] /XRANGE:output /YRANGE:output /ZRANGE:output",	$
	"IDLANROI::CLEANUP			(SYSTEM/built-in/IDLANROI)	P",	$
	"IDLANROI::COMPUTEGEOMETRY		(SYSTEM/built-in/IDLANROI)	F /AREA:output /CENTROID:output /PERIMETER:output /SPATIAL_OFFSET:output /SPATIAL_SCALE:output",	$
	"IDLANROI::COMPUTEMASK			(SYSTEM/built-in/IDLANROI)	F /INITIALIZE:input /DIMENSIONS:input /MASK_IN:input /LOCATION:input /MASK_RULE:input /PIXEL_CENTER:input /PLANE_NORMAL:input /PLANE_XAXIS:input /RUN_LENGTH",	$
	"IDLANROI::CONTAINSPOINTS		(SYSTEM/built-in/IDLANROI)	F X:input [Y:input] [Z:input] ",	$
	"IDLANROI::GETPROPERTY			(SYSTEM/built-in/IDLANROI)	P " + IDLANROI_GETPROPERTY,	$
	"IDLANROI::INIT 			(SYSTEM/built-in/IDLANROI)	F X:input [Y:input] [Z:input] " + IDLANROI_INIT,	$
	"IDLANROI::REMOVEDATA 			(SYSTEM/built-in/IDLANROI)	P /COUNT:input /START:input /XRANGE:output /YRANGE:output /ZRANGE:output",	$
	"IDLANROI::REPLACEDATA 			(SYSTEM/built-in/IDLANROI)	P X:input [Y:input] [Z:input] /START:input /FINISH:input /XRANGE:output /YRANGE:output /ZRANGE:output",	$
	"IDLANROI::ROTATE 			(SYSTEM/built-in/IDLANROI)	P Axis:input Angle:input /CENTER:input",	$
	"IDLANROI::SCALE 			(SYSTEM/built-in/IDLANROI)	P Sx:input [Sy:input] [Sz:input]",	$
	"IDLANROI::SETPROPERTY 			(SYSTEM/built-in/IDLANROI)	P " + IDLANROI_SETPROPERTY,	$
	"IDLANROI::TRANSLATE 			(SYSTEM/built-in/IDLANROI)	P Tx:input [Ty:input] [Tz:input]",	$


	; IDL_CONTAINER
	; -------------
	"IDL_CONTAINER::ADD			(SYSTEM/built-in/IDLCONTAINER) 				P Objects:input /POSITION:input",			$
	"IDL_CONTAINER::CLEANUP			(SYSTEM/built-in/IDLCONTAINER) 				P",							$
	"IDL_CONTAINER::COUNT 			(SYSTEM/built-in/IDLCONTAINER) 				F",							$
	"IDL_CONTAINER::GET			(SYSTEM/built-in/IDLCONTAINER) 				F /ALL /ISA:input /POSITION:input /COUNT:output",	$
	"IDL_CONTAINER::INIT			(SYSTEM/built-in/IDLCONTAINER) 				F",							$
	"IDL_CONTAINER::ISCONTAINED 		(SYSTEM/built-in/IDLCONTAINER) 				F Object:input /POSITION:output",			$
	"IDL_CONTAINER::MOVE			(SYSTEM/built-in/IDLCONTAINER) 				P Source:input Destination:input",			$
	"IDL_CONTAINER::REMOVE			(SYSTEM/built-in/IDLCONTAINER) 				P [Child_object:input] /POSITION:input /ALL",		$



	; IDLANROIGROUP
	; -------------
	"IDLANROIGROUP(IDL_CONTAINER)::ADD 		(SYSTEM/built-in/IDLANROIGROUP)	P ROI:input",	$
	"IDLANROIGROUP(IDL_CONTAINER)::CLEANUP 		(SYSTEM/built-in/IDLANROIGROUP)	P",	$
	"IDLANROIGROUP(IDL_CONTAINER)::COMPUTEMASK 	(SYSTEM/built-in/IDLANROIGROUP)	F /INITIALIZE:input /DIMENSIONS:input /MASK_IN:input /LOCATION:input /MASK_RULE:input /PLANE_NORMAL:input /PLANE_XAXIS:input /RUN_LENGTH",	$
	"IDLANROIGROUP(IDL_CONTAINER)::COMPUTEMESH 	(SYSTEM/built-in/IDLANROIGROUP)	F Vertices:input Conn:output /CAPPED:input /SURFACE_AREA:output",	$
	"IDLANROIGROUP(IDL_CONTAINER)::CONTAINSPOINTS 	(SYSTEM/built-in/IDLANROIGROUP)	F X:input [Y:input] [Z:input]",	$
	"IDLANROIGROUP(IDL_CONTAINER)::GETPROPERTY 	(SYSTEM/built-in/IDLANROIGROUP)	P " + IDLANROIGROUP_GETPROPERTY,	$
	"IDLANROIGROUP(IDL_CONTAINER)::INIT 		(SYSTEM/built-in/IDLANROIGROUP)	F",	$
	"IDLANROIGROUP(IDL_CONTAINER)::ROTATE 		(SYSTEM/built-in/IDLANROIGROUP)	P Axis:input Angle:input /CENTER:input",	$
	"IDLANROIGROUP(IDL_CONTAINER)::SCALE 		(SYSTEM/built-in/IDLANROIGROUP)	P Sx:input [Sy:input] [Sz:input]",	$ 
	"IDLANROIGROUP(IDL_CONTAINER)::TRANSLATE	(SYSTEM/built-in/IDLANROIGROUP)	P Tx:input [Ty:input] [Tz:input]",	$


	; IDLFFLANGCAT
	; ------------
	"IDLFFLANGCAT::APPENDCATALOG			(SYSTEM/lib/idlfflangcat__define.pro)	F /APP_NAME:input /FILENAME:input /APP_PATH:input",	$
	"IDLFFLANGCAT::CLEANUP				(SYSTEM/lib/idlfflangcat__define.pro)	P",							$
	"IDLFFLANGCAT::GETPROPERTY			(SYSTEM/lib/idlfflangcat__define.pro)	P " + IDLFFLANGCAT_GETPROPERTY,				$
	"IDLFFLANGCAT::INIT				(SYSTEM/lib/idlfflangcat__define.pro)	F /CONTINUE_ON_ERROR " + IDLFFLANGCAT_INIT,		$
	"IDLFFLANGCAT::QUERY				(SYSTEM/lib/idlfflangcat__define.pro)	F Key:input /DEFAULT_STRING:input",			$
	"IDLFFLANGCAT::SETPROPERTY			(SYSTEM/lib/idlfflangcat__define.pro)	P " + IDLFFLANGCAT_SETPROPERTY,				$


	; IDLITCOMPONENT
	; --------------
	"IDLITCOMPONENT::CLEANUP			(SYSTEM/built-in/IDLITCOMPONENT)	P",	$
	"IDLITCOMPONENT::EDITUSERDEFPROPERTY		(SYSTEM/built-in/IDLITCOMPONENT)	F iTool:input PropertyIdentifier:input",	$
	"IDLITCOMPONENT::GETFULLIDENTIFIER		(SYSTEM/built-in/IDLITCOMPONENT)	F [Objref:input]",	$
	"IDLITCOMPONENT::GETPROPERTY			(SYSTEM/built-in/IDLITCOMPONENT)	P " + IDLITCOMPONENT_GETPROPERTY,	$
	"IDLITCOMPONENT::GETPROPERTYATTRIBUTE		(SYSTEM/built-in/IDLITCOMPONENT)	P PropertyIdentifier:input /TYPE:output",	$
	"IDLITCOMPONENT::GETPROPERTYBYIDENTIFIER	(SYSTEM/built-in/IDLITCOMPONENT)	F PropertyIdentifier:input Value:output",	$
	"IDLITCOMPONENT::INIT				(SYSTEM/built-in/IDLITCOMPONENT)	F " + IDLITCOMPONENT_INIT,	$
	"IDLITCOMPONENT::NOTIFYBRIDGE			(SYSTEM/built-in/IDLITCOMPONENT)	P IdMessage:input Value:input",	$
	"IDLITCOMPONENT::QUERYPROPERTY			(SYSTEM/built-in/IDLITCOMPONENT)	F [PropertyIdentifier:input]",	$
	"IDLITCOMPONENT::REGISTERPROPERTY		(SYSTEM/built-in/IDLITCOMPONENT)	P PropertyIdentifier:input [Type:input] /BOOLEAN /COLOR /DESCRIPTION:input /ENUMLIST:input /FLOAT /HIDE /INTEGER /LINESTYLE /NAME:input /SENSITIVE /STRING /SYMBOL /THICKNESS /UNDEFINED /USERDEF:input /VALID_RANGE:input",	$
	"IDLITCOMPONENT::RESTORE			(SYSTEM/built-in/IDLITCOMPONENT)	P",	$
	"IDLITCOMPONENT::SETPROPERTY			(SYSTEM/built-in/IDLITCOMPONENT)	P " + IDLITCOMPONENT_SETPROPERTY,	$
	"IDLITCOMPONENT::SETPROPERTYATTRIBUTE		(SYSTEM/built-in/IDLITCOMPONENT)	P PropertyIdentifier:input /BOOLEAN /COLOR /DESCRIPTION:input /ENUMLIST:input /FLOAT /HIDE /INTEGER /LINESTYLE /NAME:input /SENSITIVE /STRING /SYMBOL /THICKNESS /UNDEFINED /USERDEF:input /VALID_RANGE:input",	$
	"IDLITCOMPONENT::SETPROPERTYBYIDENTIFIER	(SYSTEM/built-in/IDLITCOMPONENT)	P PropertyIdentifier:input Value:input",	$
	"IDLITCOMPONENT::UPDATECOMPONENTVERSION		(SYSTEM/built-in/IDLITCOMPONENT)	P",	$


	
	; IDLITCOMMAND
	; ------------
	"IDLITCOMMAND(IDLITCOMPONENT)::ADDITEM		(SYSTEM/lib/itools/framework/idlitcommand__define.pro)	F StrItem:input Item:input /OVERWRITE",		$
	"IDLITCOMMAND(IDLITCOMPONENT)::CLEANUP		(SYSTEM/lib/itools/framework/idlitcommand__define.pro)	P",						$
	"IDLITCOMMAND(IDLITCOMPONENT)::GETITEM		(SYSTEM/lib/itools/framework/idlitcommand__define.pro)	F StrItem:input Item:input",			$
	"IDLITCOMMAND(IDLITCOMPONENT)::GETPROPERTY	(SYSTEM/lib/itools/framework/idlitcommand__define.pro)	P " + IDLITCOMMAND_GETPROPERTY,			$
	"IDLITCOMMAND(IDLITCOMPONENT)::GETSIZE		(SYSTEM/lib/itools/framework/idlitcommand__define.pro)	F /KILOBYTES",					$
	"IDLITCOMMAND(IDLITCOMPONENT)::INIT		(SYSTEM/lib/itools/framework/idlitcommand__define.pro)	F " + IDLITCOMMAND_INIT,			$
	"IDLITCOMMAND(IDLITCOMPONENT)::SETPROPERTY	(SYSTEM/lib/itools/framework/idlitcommand__define.pro)	P " + IDLITCOMMAND_SETPROPERTY,			$



	; IDLITCOMMANDSET
	; ---------------
	"IDLITCOMMANDSET(IDL_CONTAINER/IDLITCOMMAND)::CLEANUP	(SYSTEM/lib/itools/framework/idlitcommandset__define.pro) 	P",				$
	"IDLITCOMMANDSET(IDL_CONTAINER/IDLITCOMMAND)::GETSIZE	(SYSTEM/lib/itools/framework/idlitcommandset__define.pro) 	F /KILOBYTES",			$
	"IDLITCOMMANDSET(IDL_CONTAINER/IDLITCOMMAND)::INIT	(SYSTEM/lib/itools/framework/idlitcommandset__define.pro) 	F",				$


	; IDLITCONTAINER
	; --------------
	"IDLITCONTAINER(IDL_CONTAINER/IDLITCOMPONENT)::ADD			(SYSTEM/lib/itools/framework/idlitcontainer__define.pro)	P Components:input /NO_NOTIFY",	$
	"IDLITCONTAINER(IDL_CONTAINER/IDLITCOMPONENT)::ADDBYIDENTIFIER		(SYSTEM/lib/itools/framework/idlitcontainer__define.pro)	P Identifier:input Item:input /FOLDER_CLASSNAME:input",	$
	"IDLITCONTAINER(IDL_CONTAINER/IDLITCOMPONENT)::CLEANUP			(SYSTEM/lib/itools/framework/idlitcontainer__define.pro)	P",	$
	"IDLITCONTAINER(IDL_CONTAINER/IDLITCOMPONENT)::FINDIDENTIFIERS		(SYSTEM/lib/itools/framework/idlitcontainer__define.pro)	F [Pattern:input] /COUNT:output /LEAF_NODES",	$
	"IDLITCONTAINER(IDL_CONTAINER/IDLITCOMPONENT)::GET			(SYSTEM/lib/itools/framework/idlitcontainer__define.pro)	F /ALL /COUNT:output /ISA:input /POSITION:input /SKIP_PRIVATE",	$
	"IDLITCONTAINER(IDL_CONTAINER/IDLITCOMPONENT)::GETBYIDENTIFIER		(SYSTEM/lib/itools/framework/idlitcontainer__define.pro)	F Identifier:input",	$
	"IDLITCONTAINER(IDL_CONTAINER/IDLITCOMPONENT)::INIT			(SYSTEM/lib/itools/framework/idlitcontainer__define.pro)	F",	$
	"IDLITCONTAINER(IDL_CONTAINER/IDLITCOMPONENT)::REMOVE			(SYSTEM/lib/itools/framework/idlitcontainer__define.pro)	P Components:input /NO_NOTIFY",	$
	"IDLITCONTAINER(IDL_CONTAINER/IDLITCOMPONENT)::REMOVEBYIDENTIFIER	(SYSTEM/lib/itools/framework/idlitcontainer__define.pro)	F Identifier:input",	$


	; IDLITDATA
	; ---------
	"IDLITDATA(IDLITCOMPONENT)::ADDDATAOBSERVER	(SYSTEM/lib/itools/framework/idlitdata__define.pro)	P",							$
	"IDLITDATA(IDLITCOMPONENT)::CLEANUP		(SYSTEM/lib/itools/framework/idlitdata__define.pro)	P",							$
	"IDLITDATA(IDLITCOMPONENT)::COPY 		(SYSTEM/lib/itools/framework/idlitdata__define.pro)	F",							$
	"IDLITDATA(IDLITCOMPONENT)::GETBYTYPE 		(SYSTEM/lib/itools/framework/idlitdata__define.pro)	F Type:input /COUNT:input",				$
	"IDLITDATA(IDLITCOMPONENT)::GETDATA 		(SYSTEM/lib/itools/framework/idlitdata__define.pro)	F Data:input [Identifier:input] /NAN:output /NO_COPY",	$
	"IDLITDATA(IDLITCOMPONENT)::GETPROPERTY		(SYSTEM/lib/itools/framework/idlitdata__define.pro)	P " + IDLITDATA_GETPROPERTY,				$
	"IDLITDATA(IDLITCOMPONENT)::GETSIZE		(SYSTEM/lib/itools/framework/idlitdata__define.pro)	F",							$
	"IDLITDATA(IDLITCOMPONENT)::INIT		(SYSTEM/lib/itools/framework/idlitdata__define.pro)	F [Data:input] " + IDLITDATA_INIT,			$
	"IDLITDATA(IDLITCOMPONENT)::NOTIFYDATACHANGE	(SYSTEM/lib/itools/framework/idlitdata__define.pro)	P",							$
	"IDLITDATA(IDLITCOMPONENT)::NOTIFYDATACOMPLETE	(SYSTEM/lib/itools/framework/idlitdata__define.pro)	P",							$
	"IDLITDATA(IDLITCOMPONENT)::REMOVEDATAOBSERVER	(SYSTEM/lib/itools/framework/idlitdata__define.pro)	P Observer:input",					$
	"IDLITDATA(IDLITCOMPONENT)::SETDATA		(SYSTEM/lib/itools/framework/idlitdata__define.pro)	F Data:input [Identifier:input] /NO_COPY /NULL",	$
	"IDLITDATA(IDLITCOMPONENT)::SETPROPERTY		(SYSTEM/lib/itools/framework/idlitdata__define.pro)	P " + IDLITDATA_SETPROPERTY,				$


	; IDLITDATACONTAINER
	; ------------------
	"IDLITDATACONTAINER(IDLITCONTAINER/IDLITDATA)::ADD		(SYSTEM/lib/itools/framework/idlitdatacontainer__define.pro)	P Data:input /NO_NOTIFY",			$
	"IDLITDATACONTAINER(IDLITCONTAINER/IDLITDATA)::CLEANUP		(SYSTEM/lib/itools/framework/idlitdatacontainer__define.pro)	P",						$
	"IDLITDATACONTAINER(IDLITCONTAINER/IDLITDATA)::GETDATA		(SYSTEM/lib/itools/framework/idlitdatacontainer__define.pro)	F Data:output [Identifier:input] /NO_COPY",	$
	"IDLITDATACONTAINER(IDLITCONTAINER/IDLITDATA)::GETIDENTIFIERS	(SYSTEM/lib/itools/framework/idlitdatacontainer__define.pro)	F [Pattern:input] /LEAF",			$
	"IDLITDATACONTAINER(IDLITCONTAINER/IDLITDATA)::GETPROPERTY	(SYSTEM/lib/itools/framework/idlitdatacontainer__define.pro)	P",						$
	"IDLITDATACONTAINER(IDLITCONTAINER/IDLITDATA)::INIT		(SYSTEM/lib/itools/framework/idlitdatacontainer__define.pro)	F [Data:input]",				$
	"IDLITDATACONTAINER(IDLITCONTAINER/IDLITDATA)::SETDATA		(SYSTEM/lib/itools/framework/idlitdatacontainer__define.pro)	F Data:input Identifier:input /NO_COPY /NULL",	$
	"IDLITDATACONTAINER(IDLITCONTAINER/IDLITDATA)::SETPROPERTY	(SYSTEM/lib/itools/framework/idlitdatacontainer__define.pro)	P",						$


	; IDLITIMESSAGING
	; ---------------
	"IDLITIMESSAGING::ADDONNOTIFYOBSERVER		(SYSTEM/lib/itools/framework/idlitimessaging__define.pro)	P IdObserver:input IdSubject:input",					$
	"IDLITIMESSAGING::DOONNOTIFY			(SYSTEM/lib/itools/framework/idlitimessaging__define.pro)	P IdOriginator:input IdMessage:input Value:input",			$
	"IDLITIMESSAGING::ERRORMESSAGE			(SYSTEM/lib/itools/framework/idlitimessaging__define.pro)	P StrMessage:input /SEVERITY:input /TITLE:input /USE_LAST_ERROR",	$
	"IDLITIMESSAGING::GETTOOL			(SYSTEM/lib/itools/framework/idlitimessaging__define.pro)	F",									$
	"IDLITIMESSAGING::PROBESTATUSMESSAGE		(SYSTEM/lib/itools/framework/idlitimessaging__define.pro)	P StrMessage:input",							$
	"IDLITIMESSAGING::PROGRESSBAR			(SYSTEM/lib/itools/framework/idlitimessaging__define.pro)	F StrMessage:input /CANCEL:input /PERCENT:input /SHUTDOWN",		$
	"IDLITIMESSAGING::PROMPTUSERTEXT		(SYSTEM/lib/itools/framework/idlitimessaging__define.pro)	F StrPrompt:input Answer:output /TITLE:input",				$
	"IDLITIMESSAGING::PROMPTUSERYESNO		(SYSTEM/lib/itools/framework/idlitimessaging__define.pro)	F StrPrompt:input Answer:output /TITLE:input",				$
	"IDLITIMESSAGING::REMOVEONNOTIFYOBSERVER	(SYSTEM/lib/itools/framework/idlitimessaging__define.pro)	P IdObserver:input IdSubject:input",					$
	"IDLITIMESSAGING::SIGNALERROR			(SYSTEM/lib/itools/framework/idlitimessaging__define.pro)	P StrMessage:input /CODE:input /SEVERITY:input",			$
	"IDLITIMESSAGING::STATUSMESSAGE			(SYSTEM/lib/itools/framework/idlitimessaging__define.pro)	P StrMessage:input /SEGMENT_IDENTIFIER:input",				$



	; IDLITOPERATION
	; --------------
	"IDLITOPERATION(IDLITCOMPONENT/IDLITIMESSAGING)::CLEANUP		(SYSTEM/lib/itools/framework/idlitoperation__define.pro)	P",									$
	"IDLITOPERATION(IDLITCOMPONENT/IDLITIMESSAGING)::DOACTION		(SYSTEM/lib/itools/framework/idlitoperation__define.pro)	F Tool:input",								$
	"IDLITOPERATION(IDLITCOMPONENT/IDLITIMESSAGING)::GETPROPERTY		(SYSTEM/lib/itools/framework/idlitoperation__define.pro)	P " + IDLITOPERATION_GETPROPERTY,					$
	"IDLITOPERATION(IDLITCOMPONENT/IDLITIMESSAGING)::INIT			(SYSTEM/lib/itools/framework/idlitoperation__define.pro)	F " + IDLITOPERATION_INIT,						$
	"IDLITOPERATION(IDLITCOMPONENT/IDLITIMESSAGING)::QUERYAVAILABILITY	(SYSTEM/lib/itools/framework/idlitoperation__define.pro)	F Tool:input SelTypes:input",						$
	"IDLITOPERATION(IDLITCOMPONENT/IDLITIMESSAGING)::RECORDFINALVALUES	(SYSTEM/lib/itools/framework/idlitoperation__define.pro)	F CommandSet:input Targets:input [IdProperty:input]",			$
	"IDLITOPERATION(IDLITCOMPONENT/IDLITIMESSAGING)::RECORDINITIALVALUES	(SYSTEM/lib/itools/framework/idlitoperation__define.pro)	F CommandSet:input Targets:input [IdProperty:input]",			$
	"IDLITOPERATION(IDLITCOMPONENT/IDLITIMESSAGING)::REDOOPERATION		(SYSTEM/lib/itools/framework/idlitoperation__define.pro)	F CommandSet:input",							$
	"IDLITOPERATION(IDLITCOMPONENT/IDLITIMESSAGING)::SETPROPERTY		(SYSTEM/lib/itools/framework/idlitoperation__define.pro)	P " + IDLITOPERATION_SETPROPERTY,					$
	"IDLITOPERATION(IDLITCOMPONENT/IDLITIMESSAGING)::UNDOOPERATION		(SYSTEM/lib/itools/framework/idlitoperation__define.pro)	F CommandSet:input",							$



	; IDLITDATAOPERATION
	; ------------------
	"IDLITDATAOPERATION(IDLITOPERATION)::CLEANUP		(SYSTEM/lib/itools/framework/idlitdataoperation__define.pro)	P",	$
	"IDLITDATAOPERATION(IDLITOPERATION)::DOEXECUTEUI	(SYSTEM/lib/itools/framework/idlitdataoperation__define.pro)	F",	$
	"IDLITDATAOPERATION(IDLITOPERATION)::EXECUTE		(SYSTEM/lib/itools/framework/idlitdataoperation__define.pro)	F Data:input",	$
	"IDLITDATAOPERATION(IDLITOPERATION)::GETPROPERTY	(SYSTEM/lib/itools/framework/idlitdataoperation__define.pro)	P " + IDLITDATAOPERATION_GETPROPERTY,	$
	"IDLITDATAOPERATION(IDLITOPERATION)::INIT		(SYSTEM/lib/itools/framework/idlitdataoperation__define.pro)	F " + IDLITDATAOPERATION_INIT,	$
	"IDLITDATAOPERATION(IDLITOPERATION)::SETPROPERTY	(SYSTEM/lib/itools/framework/idlitdataoperation__define.pro)	P " + IDLITDATAOPERATION_SETPROPERTY,	$
	"IDLITDATAOPERATION(IDLITOPERATION)::UNDOEXECUTE	(SYSTEM/lib/itools/framework/idlitdataoperation__define.pro)	F data:input", $


	; IDLITDIRECTWINDOW
	; -----------------
	"IDLITDIRECTWINDOW(IDLITCOMPONENT)::CLEANUP		(SYSTEM/built-in/IDLITDIRECTWINDOW)	P",	$
	"IDLITDIRECTWINDOW(IDLITCOMPONENT)::GETPROPERTY		(SYSTEM/built-in/IDLITDIRECTWINDOW)	P " + IDLITDIRECTWINDOW_GETPROPERTY,	$
	"IDLITDIRECTWINDOW(IDLITCOMPONENT)::INIT		(SYSTEM/built-in/IDLITDIRECTWINDOW)	F " + IDLITDIRECTWINDOW_INIT,	$
	"IDLITDIRECTWINDOW(IDLITCOMPONENT)::MAKECURRENT		(SYSTEM/built-in/IDLITDIRECTWINDOW)	P",	$
	"IDLITDIRECTWINDOW(IDLITCOMPONENT)::ONENTER		(SYSTEM/built-in/IDLITDIRECTWINDOW)	P",	$
	"IDLITDIRECTWINDOW(IDLITCOMPONENT)::ONEXIT		(SYSTEM/built-in/IDLITDIRECTWINDOW)	P",	$
	"IDLITDIRECTWINDOW(IDLITCOMPONENT)::ONEXPOSE		(SYSTEM/built-in/IDLITDIRECTWINDOW)	P X:input Y:input Width:input Height:input",	$
	"IDLITDIRECTWINDOW(IDLITCOMPONENT)::ONKEYBOARD		(SYSTEM/built-in/IDLITDIRECTWINDOW)	P IsASCII:input Character:input KeySymbol:input X:input Y:input Press:input Release:input Modifiers:input",	$
	"IDLITDIRECTWINDOW(IDLITCOMPONENT)::ONMOUSEDOWN		(SYSTEM/built-in/IDLITDIRECTWINDOW)	P X:input Y:input ButtonMask:input Modifiers:input NumClicks:input",	$
	"IDLITDIRECTWINDOW(IDLITCOMPONENT)::ONMOUSEMOTION	(SYSTEM/built-in/IDLITDIRECTWINDOW)	P X:input Y:input Modifiers:input",	$
	"IDLITDIRECTWINDOW(IDLITCOMPONENT)::ONMOUSEUP		(SYSTEM/built-in/IDLITDIRECTWINDOW)	P X:input Y:input ButtonMask:input",	$
	"IDLITDIRECTWINDOW(IDLITCOMPONENT)::ONRESIZE		(SYSTEM/built-in/IDLITDIRECTWINDOW)	P Width:input Height:input",	$
	"IDLITDIRECTWINDOW(IDLITCOMPONENT)::SETPROPERTY		(SYSTEM/built-in/IDLITDIRECTWINDOW)	P " + IDLITDIRECTWINDOW_SETPROPERTY,	$


	; IDLITMANIPULATOR
	; ----------------
	"IDLITMANIPULATOR(IDLITCOMPONENT/IDLITIMESSAGING)::CLEANUP			(SYSTEM/lib/itools/framework/idlitmanipulator__define.pro)	P",															$
	"IDLITMANIPULATOR(IDLITCOMPONENT/IDLITIMESSAGING)::COMMITUNDOVALUES		(SYSTEM/lib/itools/framework/idlitmanipulator__define.pro)	F /UNCOMMIT",														$
	"IDLITMANIPULATOR(IDLITCOMPONENT/IDLITIMESSAGING)::GETCURSORTYPE		(SYSTEM/lib/itools/framework/idlitmanipulator__define.pro)	F TypeIn:output KeyMods:output",											$
	"IDLITMANIPULATOR(IDLITCOMPONENT/IDLITIMESSAGING)::GETPROPERTY			(SYSTEM/lib/itools/framework/idlitmanipulator__define.pro)	P " + IDLITMANIPULATOR_GETPROPERTY,											$
	"IDLITMANIPULATOR(IDLITCOMPONENT/IDLITIMESSAGING)::INIT				(SYSTEM/lib/itools/framework/idlitmanipulator__define.pro)	F " + IDLITMANIPULATOR_INIT,												$
	"IDLITMANIPULATOR(IDLITCOMPONENT/IDLITIMESSAGING)::ONKEYBOARD			(SYSTEM/lib/itools/framework/idlitmanipulator__define.pro)	P Win:input IsASCII:input Character:input KeyValue:input X:input Y:input Press:input Release:input KeyMods:input",	$
	"IDLITMANIPULATOR(IDLITCOMPONENT/IDLITIMESSAGING)::ONLOSECURRENTMANIPULATOR	(SYSTEM/lib/itools/framework/idlitmanipulator__define.pro)	P",															$
	"IDLITMANIPULATOR(IDLITCOMPONENT/IDLITIMESSAGING)::ONMOUSEDOWN			(SYSTEM/lib/itools/framework/idlitmanipulator__define.pro)	P Win:input X:input Y:input IButton:input KeyMods:input NClicks:input",							$
	"IDLITMANIPULATOR(IDLITCOMPONENT/IDLITIMESSAGING)::ONMOUSEMOTION		(SYSTEM/lib/itools/framework/idlitmanipulator__define.pro)	P Win:input X:input Y:input KeyMods:input",										$
	"IDLITMANIPULATOR(IDLITCOMPONENT/IDLITIMESSAGING)::ONMOUSEUP			(SYSTEM/lib/itools/framework/idlitmanipulator__define.pro)	P Win:input X:input Y:input IButton:input",										$
	"IDLITMANIPULATOR(IDLITCOMPONENT/IDLITIMESSAGING)::RECORDUNDOVALUES		(SYSTEM/lib/itools/framework/idlitmanipulator__define.pro)	F",															$
	"IDLITMANIPULATOR(IDLITCOMPONENT/IDLITIMESSAGING)::REGISTERCURSOR		(SYSTEM/lib/itools/framework/idlitmanipulator__define.pro)	P ArrCursor:input Name:input /DEFAULT",											$
	"IDLITMANIPULATOR(IDLITCOMPONENT/IDLITIMESSAGING)::SETCURRENTMANIPULATOR	(SYSTEM/lib/itools/framework/idlitmanipulator__define.pro)	P [Item:input]",													$
	"IDLITMANIPULATOR(IDLITCOMPONENT/IDLITIMESSAGING)::SETPROPERTY			(SYSTEM/lib/itools/framework/idlitmanipulator__define.pro)	P " + IDLITMANIPULATOR_SETPROPERTY,											$


	; IDLITMANIPULATORCONTAINER
	; -------------------------
	"IDLITMANIPULATORCONTAINER(IDLITCONTAINER)::ADD				(SYSTEM/lib/itools/framework/idlitmanipulatorcontainer__define.pro)	P Manipulator:input",				$
	"IDLITMANIPULATORCONTAINER(IDLITCONTAINER)::GETCURRENT			(SYSTEM/lib/itools/framework/idlitmanipulatorcontainer__define.pro)	F",						$
	"IDLITMANIPULATORCONTAINER(IDLITCONTAINER)::GETCURRENTMANIPULATOR	(SYSTEM/lib/itools/framework/idlitmanipulatorcontainer__define.pro)	F /IDENTIFIER",					$
	"IDLITMANIPULATORCONTAINER(IDLITCONTAINER)::GETPROPERTY			(SYSTEM/lib/itools/framework/idlitmanipulatorcontainer__define.pro)	P " + IDLITMANIPULATORCONTAINER_GETPROPERTY,	$
	"IDLITMANIPULATORCONTAINER(IDLITCONTAINER)::INIT			(SYSTEM/lib/itools/framework/idlitmanipulatorcontainer__define.pro)	F " + IDLITMANIPULATORCONTAINER_INIT,		$
	"IDLITMANIPULATORCONTAINER(IDLITCONTAINER)::ONKEYBOARD			(SYSTEM/lib/itools/framework/idlitmanipulatorcontainer__define.pro)	P Win:input IsASCII:input Character:input Key:input Value:input X:input Y:input Press:input Release:input KeyMods:input",	$
	"IDLITMANIPULATORCONTAINER(IDLITCONTAINER)::ONMOUSEDOWN			(SYSTEM/lib/itools/framework/idlitmanipulatorcontainer__define.pro)	P Win:input X:input Y:input IButton:input KeyMods:input NClicks:input",	$
	"IDLITMANIPULATORCONTAINER(IDLITCONTAINER)::ONMOUSEMOTION		(SYSTEM/lib/itools/framework/idlitmanipulatorcontainer__define.pro)	P Win:input X:input Y:input KeyMods:input",	$
	"IDLITMANIPULATORCONTAINER(IDLITCONTAINER)::ONMOUSEUP			(SYSTEM/lib/itools/framework/idlitmanipulatorcontainer__define.pro)	P Win:input X:input Y:input IButton:input",	$
	"IDLITMANIPULATORCONTAINER(IDLITCONTAINER)::SETCURRENT			(SYSTEM/lib/itools/framework/idlitmanipulatorcontainer__define.pro)	P Manipulator:input",				$
	"IDLITMANIPULATORCONTAINER(IDLITCONTAINER)::SETCURRENTMANIPULATOR	(SYSTEM/lib/itools/framework/idlitmanipulatorcontainer__define.pro)	P Identifier:input",				$
	"IDLITMANIPULATORCONTAINER(IDLITCONTAINER)::SETPROPERTY			(SYSTEM/lib/itools/framework/idlitmanipulatorcontainer__define.pro)	P " + IDLITMANIPULATORCONTAINER_SETPROPERTY,	$


	; IDLITMANIPULATORMANAGER
	; -----------------------
	"IDLITMANIPULATORMANAGER(IDLITMANIPULATORCONTAINER)::ADD			(SYSTEM/lib/itools/framework/idlitmanipulatormanager__define.pro)	P Manipulator:input /DEFAULT",		$
	"IDLITMANIPULATORMANAGER(IDLITMANIPULATORCONTAINER)::ADDMANIPULATOROBSERVER	(SYSTEM/lib/itools/framework/idlitmanipulatormanager__define.pro)	P Observer:input",			$
	"IDLITMANIPULATORMANAGER(IDLITMANIPULATORCONTAINER)::GETDEFAULTMANIPULATOR	(SYSTEM/lib/itools/framework/idlitmanipulatormanager__define.pro)	F",					$
	"IDLITMANIPULATORMANAGER(IDLITMANIPULATORCONTAINER)::INIT			(SYSTEM/lib/itools/framework/idlitmanipulatormanager__define.pro)	F",					$
	"IDLITMANIPULATORMANAGER(IDLITMANIPULATORCONTAINER)::REMOVEMANIPULATOROBSERVER	(SYSTEM/lib/itools/framework/idlitmanipulatormanager__define.pro)	P Observer:input",			$


	; IDLGRMODEL
	; ----------
	"IDLGRMODEL(IDL_CONTAINER/IDLITCOMPONENT)::ADD		(SYSTEM/built-in/IDLGRMODEL) 				P Object:input /ALIAS /POSITION:input",			$
	"IDLGRMODEL(IDL_CONTAINER/IDLITCOMPONENT)::CLEANUP	(SYSTEM/built-in/IDLGRMODEL) 				P",							$
	"IDLGRMODEL(IDL_CONTAINER/IDLITCOMPONENT)::DRAW		(SYSTEM/built-in/IDLGRMODEL) 				P Destinatio:input Picture:input",			$
	"IDLGRMODEL(IDL_CONTAINER/IDLITCOMPONENT)::GETBYNAME	(SYSTEM/built-in/IDLGRMODEL) 				F Name:input",						$
	"IDLGRMODEL(IDL_CONTAINER/IDLITCOMPONENT)::GETCTM	(SYSTEM/built-in/IDLGRMODEL) 				F /DESTINATION:input /PATH:input /TOP:input",		$
	"IDLGRMODEL(IDL_CONTAINER/IDLITCOMPONENT)::GETPROPERTY	(SYSTEM/built-in/IDLGRMODEL) 				P " + IDLGRMODEL_GETPROPERTY,					$
	"IDLGRMODEL(IDL_CONTAINER/IDLITCOMPONENT)::INIT		(SYSTEM/built-in/IDLGRMODEL) 				F " + IDLGRMODEL_INIT,					$
	"IDLGRMODEL(IDL_CONTAINER/IDLITCOMPONENT)::RESET	(SYSTEM/built-in/IDLGRMODEL) 				P",							$
	"IDLGRMODEL(IDL_CONTAINER/IDLITCOMPONENT)::ROTATE	(SYSTEM/built-in/IDLGRMODEL) 				P Axis:input Angle:input /PREMULTIPLY",			$
	"IDLGRMODEL(IDL_CONTAINER/IDLITCOMPONENT)::SCALE	(SYSTEM/built-in/IDLGRMODEL) 				P Sx:input Sy:input Sz:input /PREMULTIPLY",		$
	"IDLGRMODEL(IDL_CONTAINER/IDLITCOMPONENT)::SETPROPERTY	(SYSTEM/built-in/IDLGRMODEL) 				P " + IDLGRMODEL_SETPROPERTY,					$
	"IDLGRMODEL(IDL_CONTAINER/IDLITCOMPONENT)::TRANSLATE	(SYSTEM/built-in/IDLGRMODEL) 				P Tx:input Ty:input Tz:input /PREMULTIPLY",		$



	; IDLITMANIPULATORVISUAL
	; ----------------------
	"IDLITMANIPULATORVISUAL(IDLGRMODEL/IDLITIMESSAGING)::CLEANUP		(SYSTEM/lib/itools/framework/idlitmanipulatorvisual__define.pro)	P",						$
	"IDLITMANIPULATORVISUAL(IDLGRMODEL/IDLITIMESSAGING)::GETPROPERTY	(SYSTEM/lib/itools/framework/idlitmanipulatorvisual__define.pro)	P " + IDLITMANIPULATORVISUAL_GETPROPERTY,	$
	"IDLITMANIPULATORVISUAL(IDLGRMODEL/IDLITIMESSAGING)::INIT		(SYSTEM/lib/itools/framework/idlitmanipulatorvisual__define.pro)	F " + IDLITMANIPULATORVISUAL_INIT,		$
	"IDLITMANIPULATORVISUAL(IDLGRMODEL/IDLITIMESSAGING)::SETPROPERTY	(SYSTEM/lib/itools/framework/idlitmanipulatorvisual__define.pro)	P " + IDLITMANIPULATORVISUAL_SETPROPERTY,	$


	; IDLITPARAMETER
	; --------------
	"IDLITPARAMETER::CLEANUP				(SYSTEM/lib/itools/framework/idlitparameter__define.pro)	P",							$
	"IDLITPARAMETER::GETPARAMETER				(SYSTEM/lib/itools/framework/idlitparameter__define.pro)	F Name:input /ALL /COUNT:output",			$
	"IDLITPARAMETER::GETPARAMETERATTRIBUTE			(SYSTEM/lib/itools/framework/idlitparameter__define.pro)	F ParamName:input /BY_VALUE:output /DESCRIPTION:output /INPUT:output /OPTARGET:output /OPTIONAL:output /OUTPUT:output /TYPES:output",	$
	"IDLITPARAMETER::GETPARAMETERSET			(SYSTEM/lib/itools/framework/idlitparameter__define.pro)	F /DEEP_COPY",				$
	"IDLITPARAMETER::INIT					(SYSTEM/lib/itools/framework/idlitparameter__define.pro)	F",					$
	"IDLITPARAMETER::ONDATACHANGEUPDATE			(SYSTEM/lib/itools/framework/idlitparameter__define.pro)	P Data:input ParameterName:input",	$
	"IDLITPARAMETER::ONDATADISCONNECT			(SYSTEM/lib/itools/framework/idlitparameter__define.pro)	P ParameterName:input",			$
	"IDLITPARAMETER::QUERYPARAMETER				(SYSTEM/lib/itools/framework/idlitparameter__define.pro)	F [ParamName:input] /COUNT:output",	$
	"IDLITPARAMETER::REGISTERPARAMETER			(SYSTEM/lib/itools/framework/idlitparameter__define.pro)	P Name:input /BY_VALUE /DESCRIPTION:input /INPUT /OPTARGET /OPTIONAL /OUTPUT /TYPES:input",	$
	"IDLITPARAMETER::SETDATA				(SYSTEM/lib/itools/framework/idlitparameter__define.pro)	F Data:input /BY_VALUE /NO_UPDATE /PARAMETER_NAME:input",	$
	"IDLITPARAMETER::SETPARAMETERATTRIBUTE			(SYSTEM/lib/itools/framework/idlitparameter__define.pro)	P ParamName:input /BY_VALUE:input /DESCRIPTION:input /INPUT:input /OPTARGET:input /OPTIONAL:input /OUTPUT:input /TYPES:input",	$
	"IDLITPARAMETER::SETPARAMETERSET			(SYSTEM/lib/itools/framework/idlitparameter__define.pro)	F ParamSet:input",	$


	; IDLITPARAMETERSET
	; -----------------
	"IDLITPARAMETERSET(IDLITDATACONTAINER)::ADD			(SYSTEM/lib/itools/framework/idlitparameterset__define.pro)	P Data:input /PARAMETER_NAME:input /PRESERVE_LOCATION",	$
	"IDLITPARAMETERSET(IDLITDATACONTAINER)::CLEANUP			(SYSTEM/lib/itools/framework/idlitparameterset__define.pro)	P",							$
	"IDLITPARAMETERSET(IDLITDATACONTAINER)::COPY			(SYSTEM/lib/itools/framework/idlitparameterset__define.pro)	F",							$
	"IDLITPARAMETERSET(IDLITDATACONTAINER)::GET			(SYSTEM/lib/itools/framework/idlitparameterset__define.pro)	F /ALL /COUNT:output /NAME:output /POSITION:input",	$
	"IDLITPARAMETERSET(IDLITDATACONTAINER)::GETBYNAME		(SYSTEM/lib/itools/framework/idlitparameterset__define.pro)	F Names:input /COUNT:output /NAME:output",		$
	"IDLITPARAMETERSET(IDLITDATACONTAINER)::GETPARAMETERNAME	(SYSTEM/lib/itools/framework/idlitparameterset__define.pro)	F Data:input Name:input",				$		
	"IDLITPARAMETERSET(IDLITDATACONTAINER)::INIT			(SYSTEM/lib/itools/framework/idlitparameterset__define.pro)	F",							$
	"IDLITPARAMETERSET(IDLITDATACONTAINER)::REMOVE			(SYSTEM/lib/itools/framework/idlitparameterset__define.pro)	P [Items:input] /ALL /POSITION:input",			$


	; IDLITREADER
	; -----------
	"IDLITREADER(IDLITCOMPONENT/IDLITIMESSAGING)::CLEANUP		(SYSTEM/lib/itools/framework/idlitreader__define.pro)				F",			$
	"IDLITREADER(IDLITCOMPONENT/IDLITIMESSAGING)::GETDATA		(SYSTEM/lib/itools/framework/idlitreader__define.pro)				F Data:input",		$
	"IDLITREADER(IDLITCOMPONENT/IDLITIMESSAGING)::GETFILEEXTENSIONS	(SYSTEM/lib/itools/framework/idlitreader__define.pro)				F /COUNT:output",	$
	"IDLITREADER(IDLITCOMPONENT/IDLITIMESSAGING)::GETFILENAME	(SYSTEM/lib/itools/framework/idlitreader__define.pro)				F",			$
	"IDLITREADER(IDLITCOMPONENT/IDLITIMESSAGING)::GETPROPERTY	(SYSTEM/lib/itools/framework/idlitreader__define.pro)				P",			$
	"IDLITREADER(IDLITCOMPONENT/IDLITIMESSAGING)::INIT		(SYSTEM/lib/itools/framework/idlitreader__define.pro)				F [Extensions:input]",	$
	"IDLITREADER(IDLITCOMPONENT/IDLITIMESSAGING)::ISA		(SYSTEM/lib/itools/framework/idlitreader__define.pro)				F Filename:input",	$
	"IDLITREADER(IDLITCOMPONENT/IDLITIMESSAGING)::SETFILENAME	(SYSTEM/lib/itools/framework/idlitreader__define.pro)				P Filename:input",	$
	"IDLITREADER(IDLITCOMPONENT/IDLITIMESSAGING)::SETPROPERTY	(SYSTEM/lib/itools/framework/idlitreader__define.pro)				P",			$


	; IDLITTOOL
	; ---------
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::ACTIVATEMANIPULATOR		(SYSTEM/lib/itools/framework/idlittool__define.pro)	P Identifier:input /DEFAULT",					$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::ADD				(SYSTEM/lib/itools/framework/idlittool__define.pro)	P Item:input",							$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::ADDSERVICE			(SYSTEM/lib/itools/framework/idlittool__define.pro)	P oService:input",						$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::CLEANUP			(SYSTEM/lib/itools/framework/idlittool__define.pro)	P",								$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::COMMITACTIONS		(SYSTEM/lib/itools/framework/idlittool__define.pro)	P",								$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::DISABLEUPDATES		(SYSTEM/lib/itools/framework/idlittool__define.pro)	P /PREVIOUSLY_DISABLED:output",					$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::DOACTION			(SYSTEM/lib/itools/framework/idlittool__define.pro)	F Identifier:input",						$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::DOSETPROPERTY		(SYSTEM/lib/itools/framework/idlittool__define.pro)	F TargetIdentifier:input PropertyIdentifier:input Value:input",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::DOUISERVICE			(SYSTEM/lib/itools/framework/idlittool__define.pro)	F ServiceIdentifier:input Requestor:input",			$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::ENABLEUPDATES		(SYSTEM/lib/itools/framework/idlittool__define.pro)	P",																		$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::FINDIDENTIFIERS		(SYSTEM/lib/itools/framework/idlittool__define.pro)	F [Pattern:input] /ANNOTATIONS /COUNT:output /DATA_MANAGER /FILE_READERS /FILE_WRITERS /LEAF_NODES /MANIPULATORS /OPERATIONS /VISUALIZATIONS",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::GETCURRENTMANIPULATOR	(SYSTEM/lib/itools/framework/idlittool__define.pro)	F",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::GETFILEREADER		(SYSTEM/lib/itools/framework/idlittool__define.pro)	F Identifier:input /ALL /COUNT:output",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::GETFILEWRITER		(SYSTEM/lib/itools/framework/idlittool__define.pro)	F Identifier:input /ALL /COUNT:output",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::GETMANIPULATORS		(SYSTEM/lib/itools/framework/idlittool__define.pro)	F /COUNT:output",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::GETOPERATIONS		(SYSTEM/lib/itools/framework/idlittool__define.pro)	F /COUNT:output /IDENTIFIER:input",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::GETPROPERTY			(SYSTEM/lib/itools/framework/idlittool__define.pro)	P " + IDLITTOOL_GETPROPERTY,		$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::GETSELECTEDITEMS		(SYSTEM/lib/itools/framework/idlittool__define.pro)	F /COUNT:output",			$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::GETSERVICE			(SYSTEM/lib/itools/framework/idlittool__define.pro)	F IdService:input",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::GETVISUALIZATION		(SYSTEM/lib/itools/framework/idlittool__define.pro)	F Identifier:input /ALL /COUNT:output",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::INIT			(SYSTEM/lib/itools/framework/idlittool__define.pro)	F " + IDLITTOOL_INIT,			$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::REFRESHCURRENTWINDOW	(SYSTEM/lib/itools/framework/idlittool__define.pro)	P",					$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::REGISTER			(SYSTEM/lib/itools/framework/idlittool__define.pro)	P Name:input ClassName:input /DEFAULT /DESCRIPTION:input /ICON:input /IDENTIFIER:input /PROXY:input",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::REGISTERCUSTOMIZATION	(SYSTEM/lib/itools/framework/idlittool__define.pro)	P Name:input ClassName:input",			$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::REGISTERFILEREADER		(SYSTEM/lib/itools/framework/idlittool__define.pro)	P Name:input ClassName:input /DEFAULT /DESCRIPTION:input /ICON:input /IDENTIFIER:input /PROXY:input",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::REGISTERFILEWRITER		(SYSTEM/lib/itools/framework/idlittool__define.pro)	P Name:input ClassName:input /DEFAULT /DESCRIPTION:input /ICON:input /IDENTIFIER:input /PROXY:input",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::REGISTERMANIPULATOR		(SYSTEM/lib/itools/framework/idlittool__define.pro)	P Name:input ClassName:input /DEFAULT /DESCRIPTION:input /ICON:input /IDENTIFIER:input",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::REGISTEROPERATION		(SYSTEM/lib/itools/framework/idlittool__define.pro)	P Name:input ClassName:input /ACCELERATOR:input /CHECKED /DESCRIPTION:input /DROPLIST_EDIT /DROPLIST_INDEX:input /DROPLIST_ITEMS:input /ICON:input /IDENTIFIER:input /PROXY:input /SEPARATOR",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::REGISTERSTATUSBARSEGMENT	(SYSTEM/lib/itools/framework/idlittool__define.pro)	P Name:input /IDENTIFIER:input /NORMALIZED_WIDTH:input",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::REGISTERVISUALIZATION	(SYSTEM/lib/itools/framework/idlittool__define.pro)	P Name:input ClassName:input /DEFAULT /DESCRIPTION:input /ICON:input /IDENTIFIER:input /PROXY:input",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::SETPROPERTY			(SYSTEM/lib/itools/framework/idlittool__define.pro)	P " + IDLITTOOL_SETPROPERTY,	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::UNREGISTER			(SYSTEM/lib/itools/framework/idlittool__define.pro)	P Identifier:input",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::UNREGISTERCUSTOMIZATION	(SYSTEM/lib/itools/framework/idlittool__define.pro)	P",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::UNREGISTERFILEREADER	(SYSTEM/lib/itools/framework/idlittool__define.pro)	P Identifier:input",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::UNREGISTERFILEWRITER	(SYSTEM/lib/itools/framework/idlittool__define.pro)	P Identifier:input",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::UNREGISTERMANIPULATOR	(SYSTEM/lib/itools/framework/idlittool__define.pro)	P Identifier:input",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::UNREGISTEROPERATION		(SYSTEM/lib/itools/framework/idlittool__define.pro)	P Identifier:input",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::UNREGISTERSTATUSBARSEGMENT	(SYSTEM/lib/itools/framework/idlittool__define.pro)	P Identifier:input",	$
	"IDLITTOOL(IDLITCONTAINER/IDLITIMESSAGING)::UNREGISTERVISUALIZATION	(SYSTEM/lib/itools/framework/idlittool__define.pro)	P Identifier:input",	$


	; IDLITUI
	; -------
	"IDLITUI(IDLITCONTAINER)::ADDONNOTIFYOBSERVER		(SYSTEM/lib/itools/ui_widgets/idlitui__define.pro)	P IdObserver:input IdSubject:input",			$
	"IDLITUI(IDLITCONTAINER)::CLEANUP			(SYSTEM/lib/itools/ui_widgets/idlitui__define.pro)	P",							$
	"IDLITUI(IDLITCONTAINER)::DOACTION			(SYSTEM/lib/itools/ui_widgets/idlitui__define.pro)	F Identifier:input",					$
	"IDLITUI(IDLITCONTAINER)::GETPROPERTY			(SYSTEM/lib/itools/ui_widgets/idlitui__define.pro)	P " + IDLITUI_GETPROPERTY,				$
	"IDLITUI(IDLITCONTAINER)::GETTOOL			(SYSTEM/lib/itools/ui_widgets/idlitui__define.pro)	F",							$
	"IDLITUI(IDLITCONTAINER)::GETWIDGETBYNAME		(SYSTEM/lib/itools/ui_widgets/idlitui__define.pro)	F Name:input",						$
	"IDLITUI(IDLITCONTAINER)::INIT				(SYSTEM/lib/itools/ui_widgets/idlitui__define.pro)	F oTool:input",						$
	"IDLITUI(IDLITCONTAINER)::REGISTERUISERVICE		(SYSTEM/lib/itools/ui_widgets/idlitui__define.pro)	F Name:input Callback:input",				$
	"IDLITUI(IDLITCONTAINER)::REGISTERWIDGET		(SYSTEM/lib/itools/ui_widgets/idlitui__define.pro)	F wID:input Name:input Callback:input /FLOATING",	$
	"IDLITUI(IDLITCONTAINER)::REMOVEONNOTIFYOBSERVER	(SYSTEM/lib/itools/ui_widgets/idlitui__define.pro)	P IdObserver:input IdSubject:input",			$
	"IDLITUI(IDLITCONTAINER)::SETPROPERTY			(SYSTEM/lib/itools/ui_widgets/idlitui__define.pro)	P " + IDLITUI_SETPROPERTY,				$
	"IDLITUI(IDLITCONTAINER)::UNREGISTERUISERVICE		(SYSTEM/lib/itools/ui_widgets/idlitui__define.pro)	P Name:input",						$
	"IDLITUI(IDLITCONTAINER)::UNREGISTERWIDGET		(SYSTEM/lib/itools/ui_widgets/idlitui__define.pro)	P Name:input",						$


	; IDLITVISUALIZATION
	; ------------------
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::ADD				(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P Objects:input /AGGREGATE /NO_UPDATE /POSITION:input",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::AGGREGATE			(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P Objects:input",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::BEGINMANIPULATION             	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P Manipulator:input",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::CLEANUP                       	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P",			$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::ENDMANIPULATION               	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P Manipulator:input",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::GET                           	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F /ALL /COUNT:output /ISA:input /POSITION:input /SKIP_PRIVATE",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::GETCENTERROTATION             	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F /NO_TRANSFORM /XRANGE:input /YRANGE:input /ZRANGE:input",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::GETCURRENTSELECTIONVISUAL     	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::GETDATASPACE                  	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F /UNNORMALIZED",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::GETDATASTRING                 	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F XYZLocation:input",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::GETDEFAULTSELECTIONVISUAL     	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::GETMANIPULATORTARGET          	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::GETPROPERTY                   	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P " + IDLITVISUALIZATION_GETPROPERTY,	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::GETREQUESTEDAXESSTYLE         	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::GETSELECTIONVISUAL            	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F Manipulator:input",		$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::GETTYPES                      	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F",			$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::GETXYZRANGE                   	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F XRange:output YRange:output ZRange:output /DATA /NO_TRANSFORM",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::INIT                          	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F " + IDLITVISUALIZATION_INIT,	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::IS3D                          	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::ISISOTROPIC                   	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::ISMANIPULATORTARGET           	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::ISSELECTED                    	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::MOVE                          	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P Source:input Destination:input",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::ON2DROTATE                    	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P Notifier:input IsRotated:input",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::ONAXESREQUESTCHANGE           	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P Notifier:input AxesRequest:input",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::ONAXESSTYLEREQUESTCHANGE      	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P Notifier:input StyleRequest:input",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::ONDATACHANGE                  	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P Notifier:input",			$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::ONDATACOMPLETE                	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P Notifier:input",			$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::ONDATARANGECHANGE             	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P Notifier:input XRange:input YRange:input Zrange:input",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::ONDIMENSIONCHANGE             	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P Notifier:input Is3D:input",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::ONWORLDDIMENSIONCHANGE        	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P Notifier:input Is3D:input",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::REMOVE                        	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P [Object:input] /NO_UPDATE",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::REQUESTSAXES                  	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F",				$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::RESTORE                       	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P",				$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::ROTATE                        	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P Axis:input Angle:input /CENTER_OF_ROTATION:input /PREMULTIPLY",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::SCALE                         	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P SX:input SY:input SZ:input /CENTER_OF_ROTATION:input /PREMULTIPLY",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::SELECT                        	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P [Mode:input] /ADDITIVE /SELECT /TOGGLE /UNSELECT /NO_NOTIFY",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::SET3D                         	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P [Is3D:input] /ALWAYS /AUTO_COMPUTE",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::SETAXESREQUEST                	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P [AxesRequest:input] /ALWAYS /AUTO_COMPUTE /NO_NOTIFY",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::SETAXESSTYLEREQUEST           	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P StyleRequest:input /NO_NOTIFY",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::SETCURRENTSELECTIONVISUAL     	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P Manipulator:input",			$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::SETDATA                       	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F Data:input",				$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::SETDEFAULTSELECTIONVISUAL     	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P SelectionVisual:input /POSITION:input",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::SETPARAMETERSET               	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	F ParameterSet:input",			$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::SETPROPERTY                   	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P " + IDLITVISUALIZATION_SETPROPERTY,	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::UPDATESELECTIONVISUAL         	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::VISTOWINDOW+1                  	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P InX:input InY:input InZ:input OutX:output OutY:output OutZ:output /NO_TRANSFORM",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::VISTOWINDOW+2                  	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P InX:input InY:input           OutX:output OutY:output             /NO_TRANSFORM",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::VISTOWINDOW+3                  	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P InVerts:input                 OutVerts:output                     /NO_TRANSFORM",	$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::WINDOWTOVIS+1                  	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P InX:input InY:input InZ:input OutX:output OutY:output OutZ:output",			$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::WINDOWTOVIS+2                  	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P InX:input InY:input           OutX:output OutY:output",			$
	"IDLITVISUALIZATION(IDLGRMODEL/IDLITIMESSAGING/IDLITPARAMETER)::WINDOWTOVIS+3                  	(SYSTEM/lib/itools/framework/idlitvisualization__define.pro)	P InVerts:input                 OutVerts:output",				$


	; IDLGRWINDOW
	; -----------
	"IDLGRWINDOW(IDLITCOMPONENT)::CLEANUP			(SYSTEM/built-in/IDLGRWINDOW) 				P",																										$
	"IDLGRWINDOW(IDLITCOMPONENT)::DRAW			(SYSTEM/built-in/IDLGRWINDOW) 				P [Picture:input] /CREATE_INSTANCE:input /DRAW_INSTANCE:input",																			$
	"IDLGRWINDOW(IDLITCOMPONENT)::ERASE			(SYSTEM/built-in/IDLGRWINDOW) 				P /COLOR:input",																								$
	"IDLGRWINDOW(IDLITCOMPONENT)::GETCONTIGUOUSPIXELS	(SYSTEM/built-in/IDLGRWINDOW) 				F",																										$
	"IDLGRWINDOW(IDLITCOMPONENT)::GETDEVICEINFO		(SYSTEM/built-in/IDLGRWINDOW) 				P /ALL:output /MAX_NUM_CLIP_PLANES:output /MAX_TEXTURE_DIMENSIONS:output /MAX_TILE_DIMENSIONS:output /MAX_VIEWPORT_DIMENSIONS:output /NAME:output /NUM_CPUS:output /VENDOR:output /VERSION:output",		$
	"IDLGRWINDOW(IDLITCOMPONENT)::GETDIMENSIONS		(SYSTEM/built-in/IDLGRWINDOW) 				F /MINIMUM_VIRTUAL_DIMENSIONS:output /ORIGINAL_VIRTUAL_DIMENSIONS:output /VIRTUAL_DIMENSIONS:output /VISIBLE_LOCATION:output",											$
	"IDLGRWINDOW(IDLITCOMPONENT)::GETFONTNAMES		(SYSTEM/built-in/IDLGRWINDOW) 				F FamilyName:input /IDL_FONTS:input /STYLES:input",																				$
	"IDLGRWINDOW(IDLITCOMPONENT)::GETPROPERTY		(SYSTEM/built-in/IDLGRWINDOW) 				P " + IDLGRWINDOW_GETPROPERTY,																								$
	"IDLGRWINDOW(IDLITCOMPONENT)::GETTEXTDIMENSIONS		(SYSTEM/built-in/IDLGRWINDOW) 				F TextObj:input /DESCENT:output /PATH:input",																					$
	"IDLGRWINDOW(IDLITCOMPONENT)::ICONIFY			(SYSTEM/built-in/IDLGRWINDOW) 				P IconFlag:input",																								$
	"IDLGRWINDOW(IDLITCOMPONENT)::INIT			(SYSTEM/built-in/IDLGRWINDOW) 				F " + IDLGRWINDOW_INIT,																								$
	"IDLGRWINDOW(IDLITCOMPONENT)::ONENTER			(SYSTEM/built-in/IDLGRWINDOW) 				P",																										$
	"IDLGRWINDOW(IDLITCOMPONENT)::ONEXIT			(SYSTEM/built-in/IDLGRWINDOW) 				P",																										$
	"IDLGRWINDOW(IDLITCOMPONENT)::ONEXPOSE			(SYSTEM/built-in/IDLGRWINDOW) 				P X:input Y:input Width:input Height:input",																					$
	"IDLGRWINDOW(IDLITCOMPONENT)::ONKEYBOARD		(SYSTEM/built-in/IDLGRWINDOW) 				P IsASCII:input Character:input KeySymbol:input X:input Y:input Press:input Release:input Modifiers:input",													$
	"IDLGRWINDOW(IDLITCOMPONENT)::ONMOUSEDOWN		(SYSTEM/built-in/IDLGRWINDOW) 				P X:input Y:input ButtonMask:input Modifiers:input NumClicks:input",																		$
	"IDLGRWINDOW(IDLITCOMPONENT)::ONMOUSEMOTION		(SYSTEM/built-in/IDLGRWINDOW) 				P X:input Y:input Modifiers:input",																						$
	"IDLGRWINDOW(IDLITCOMPONENT)::ONMOUSEUP			(SYSTEM/built-in/IDLGRWINDOW) 				P X:input Y:input ButtonMask:input",																						$
	"IDLGRWINDOW(IDLITCOMPONENT)::ONRESIZE			(SYSTEM/built-in/IDLGRWINDOW) 				P Width:input Height:input",																							$
	"IDLGRWINDOW(IDLITCOMPONENT)::PICKDATA			(SYSTEM/built-in/IDLGRWINDOW) 				F View:input Object:input Location:input XYZLocation:input /DIMENSIONS:input /PATH:input /PICK_STATUS:output",													$
	"IDLGRWINDOW(IDLITCOMPONENT)::QUERYREQUIREDTILES	(SYSTEM/built-in/IDLGRWINDOW) 				F View:input Image:input /COUNT:output /ALL_VISIBLE:input",																			$
	"IDLGRWINDOW(IDLITCOMPONENT)::READ			(SYSTEM/built-in/IDLGRWINDOW) 				F",																										$
	"IDLGRWINDOW(IDLITCOMPONENT)::SELECT			(SYSTEM/built-in/IDLGRWINDOW) 				F Picture:input XY:input /DIMENSIONS:input /ORDER /SUB_SELECTION:output /UNITS:input",																$
	"IDLGRWINDOW(IDLITCOMPONENT)::SETCURRENTCURSOR		(SYSTEM/built-in/IDLGRWINDOW) 				P [CursorName:input] /IMAGE:input /MASK:input /HOTSPOT:input /STANDARD:input",																	$
	"IDLGRWINDOW(IDLITCOMPONENT)::SETCURRENTZOOM		(SYSTEM/built-in/IDLGRWINDOW) 				P ZoomFactor:input /RESET",																							$
	"IDLGRWINDOW(IDLITCOMPONENT)::SETPROPERTY		(SYSTEM/built-in/IDLGRWINDOW) 				P " + IDLGRWINDOW_SETPROPERTY,																								$
	"IDLGRWINDOW(IDLITCOMPONENT)::SHOW			(SYSTEM/built-in/IDLGRWINDOW) 				P Position:input",																								$
	"IDLGRWINDOW(IDLITCOMPONENT)::ZOOMIN			(SYSTEM/built-in/IDLGRWINDOW) 				P",																										$
	"IDLGRWINDOW(IDLITCOMPONENT)::ZOOMOUT			(SYSTEM/built-in/IDLGRWINDOW) 				P",																										$



	; IDLITWINDOW
	; -----------
	"IDLITWINDOW(IDLGRWINDOW)::ADD					(SYSTEM/built-in/IDLITWINDOW)	P Objects:input /POSITION:input",	$
	"IDLITWINDOW(IDLGRWINDOW)::ADDWINDOWEVENTOBSERVER		(SYSTEM/built-in/IDLITWINDOW)	P Objects:input",	$
	"IDLITWINDOW(IDLGRWINDOW)::CLEANUP				(SYSTEM/built-in/IDLITWINDOW)	P",	$
	"IDLITWINDOW(IDLGRWINDOW)::CLEARSELECTIONS			(SYSTEM/built-in/IDLITWINDOW)	P",	$
	"IDLITWINDOW(IDLGRWINDOW)::DOHITTEST				(SYSTEM/built-in/IDLITWINDOW)	F X:input Y:input /DIMENSIONS:input /ORDER /SUB_HIT:output /UNITS:input",	$
	"IDLITWINDOW(IDLGRWINDOW)::GETEVENTMASK				(SYSTEM/built-in/IDLITWINDOW)	F /BUTTON_EVENTS:output /KEYBOARD_EVENTS:output /MOTION_EVENTS:output /TIMER_EVENTS:output /TRACKING_EVENTS:output",	$
	"IDLITWINDOW(IDLGRWINDOW)::GETPROPERTY				(SYSTEM/built-in/IDLITWINDOW)	P " + IDLITWINDOW_GETPROPERTY,	$
	"IDLITWINDOW(IDLGRWINDOW)::GETSELECTEDITEMS			(SYSTEM/built-in/IDLITWINDOW)	F /ALL /COUNT:output",	$
	"IDLITWINDOW(IDLGRWINDOW)::INIT					(SYSTEM/built-in/IDLITWINDOW)	F " + IDLITWINDOW_INIT,	$
	"IDLITWINDOW(IDLGRWINDOW)::ONENTER				(SYSTEM/built-in/IDLITWINDOW)	P",	$
	"IDLITWINDOW(IDLGRWINDOW)::ONEXIT				(SYSTEM/built-in/IDLITWINDOW)	P",	$
	"IDLITWINDOW(IDLGRWINDOW)::ONEXPOSE				(SYSTEM/built-in/IDLITWINDOW)	P X:input Y:input Width:input Height:input",	$
	"IDLITWINDOW(IDLGRWINDOW)::ONKEYBOARD				(SYSTEM/built-in/IDLITWINDOW)	P IsASCII:input Character:input KeySymbol:input X:input Y:input Press:input Release:input Modifiers:input",	$
	"IDLITWINDOW(IDLGRWINDOW)::ONMOUSEDOWN				(SYSTEM/built-in/IDLITWINDOW)	P X:input Y:input ButtonMask:input Modifiers:input NumClicks:input",	$
	"IDLITWINDOW(IDLGRWINDOW)::ONMOUSEMOTION			(SYSTEM/built-in/IDLITWINDOW)	P X:input Y:input Modifiers:input",	$
	"IDLITWINDOW(IDLGRWINDOW)::ONMOUSEUP				(SYSTEM/built-in/IDLITWINDOW)	P X:input Y:input ButtonMask:input",	$
	"IDLITWINDOW(IDLGRWINDOW)::ONRESIZE				(SYSTEM/built-in/IDLITWINDOW)	P Width:input Height:input",	$
	"IDLITWINDOW(IDLGRWINDOW)::ONSCROLL				(SYSTEM/built-in/IDLITWINDOW)	P X:input Y:input",	$
	"IDLITWINDOW(IDLGRWINDOW)::ONTIMER				(SYSTEM/built-in/IDLITWINDOW)	P",	$
	"IDLITWINDOW(IDLGRWINDOW)::REMOVE				(SYSTEM/built-in/IDLITWINDOW)	P [Object:input] /ALL /POSITION:input",	$
	"IDLITWINDOW(IDLGRWINDOW)::REMOVEWINDOWEVENTOBSERVER		(SYSTEM/built-in/IDLITWINDOW)	P Objects:input",	$
	"IDLITWINDOW(IDLGRWINDOW)::RESIZE				(SYSTEM/built-in/IDLITWINDOW)	P Objects:input",	$
	"IDLITWINDOW(IDLGRWINDOW)::SETCURRENTZOOM			(SYSTEM/built-in/IDLITWINDOW)	P ZoomFactor:input /RESET",	$
	"IDLITWINDOW(IDLGRWINDOW)::SETEVENTMASK				(SYSTEM/built-in/IDLITWINDOW)	P [EventMask:input] /BUTTON_EVENTS /KEYBOARD_EVENTS /MOTION_EVENTS /TIMER_EVENTS /TRACKING_EVENTS",	$
	"IDLITWINDOW(IDLGRWINDOW)::SETMANIPULATORMANAGER		(SYSTEM/built-in/IDLITWINDOW)	P Manager:input",	$
	"IDLITWINDOW(IDLGRWINDOW)::SETPROPERTY				(SYSTEM/built-in/IDLITWINDOW)	P " + IDLITWINDOW_SETPROPERTY,	$
	"IDLITWINDOW(IDLGRWINDOW)::SETTIMERINTERVAL			(SYSTEM/built-in/IDLITWINDOW)	P Interval:input",	$
	"IDLITWINDOW(IDLGRWINDOW)::ZOOMIN				(SYSTEM/built-in/IDLITWINDOW)	P",	$
	"IDLITWINDOW(IDLGRWINDOW)::ZOOMOUT				(SYSTEM/built-in/IDLITWINDOW)	P",	$


	; IDLITWRITER
	; -----------
	"IDLITWRITER(IDLITCOMPONENT/IDLITIMESSAGING)::CLEANUP			(SYSTEM/lib/itools/framework/idlitwriter__define.pro)	P",						$
	"IDLITWRITER(IDLITCOMPONENT/IDLITIMESSAGING)::GETFILEEXTENSIONS		(SYSTEM/lib/itools/framework/idlitwriter__define.pro)	F /COUNT:output",				$
	"IDLITWRITER(IDLITCOMPONENT/IDLITIMESSAGING)::GETFILENAME		(SYSTEM/lib/itools/framework/idlitwriter__define.pro)	F",						$
	"IDLITWRITER(IDLITCOMPONENT/IDLITIMESSAGING)::GETPROPERTY 		(SYSTEM/lib/itools/framework/idlitwriter__define.pro)	P " + IDLITWRITER_GETPROPERTY,			$
	"IDLITWRITER(IDLITCOMPONENT/IDLITIMESSAGING)::INIT	 		(SYSTEM/lib/itools/framework/idlitwriter__define.pro)	F [Extensions:input] " + IDLITWRITER_INIT,	$
	"IDLITWRITER(IDLITCOMPONENT/IDLITIMESSAGING)::ISA	 		(SYSTEM/lib/itools/framework/idlitwriter__define.pro)	F Filename:input",				$
	"IDLITWRITER(IDLITCOMPONENT/IDLITIMESSAGING)::SETDATA	 		(SYSTEM/lib/itools/framework/idlitwriter__define.pro)	F data:input",					$
	"IDLITWRITER(IDLITCOMPONENT/IDLITIMESSAGING)::SETFILENAME 		(SYSTEM/lib/itools/framework/idlitwriter__define.pro)	P Filename:input",				$
	"IDLITWRITER(IDLITCOMPONENT/IDLITIMESSAGING)::SETPROPERTY 		(SYSTEM/lib/itools/framework/idlitwriter__define.pro)	P " + IDLITWRITER_SETPROPERTY,			$


	; IDLGRAXIS
	; ---------
	"IDLGRAXIS(IDLITCOMPONENT)::CLEANUP 		(SYSTEM/built-in/IDLGRAXIS)				P",									$
	"IDLGRAXIS(IDLITCOMPONENT)::GETCTM 		(SYSTEM/built-in/IDLGRAXIS)				F /DESTINATION:input /PATH:input /TOP:input",				$
	"IDLGRAXIS(IDLITCOMPONENT)::GETPROPERTY		(SYSTEM/built-in/IDLGRAXIS)				P " + IDLGRAXIS_GETPROPERTY,						$
	"IDLGRAXIS(IDLITCOMPONENT)::INIT		(SYSTEM/built-in/IDLGRAXIS)				F [Direction:input] " + IDLGRAXIS_INIT,					$
	"IDLGRAXIS(IDLITCOMPONENT)::SETPROPERTY		(SYSTEM/built-in/IDLGRAXIS)				P " + IDLGRAXIS_SETPROPERTY,						$


	; IDLGRBUFFER
	; -----------
	"IDLGRBUFFER(IDLITCOMPONENT)::CLEANUP			(SYSTEM/built-in/IDLGRBUFFER)				P",									$
	"IDLGRBUFFER(IDLITCOMPONENT)::DRAW			(SYSTEM/built-in/IDLGRBUFFER)				P [Picture:input] /CREATE_INSTANCE:input /DRAW_INSTANCE:input",		$
	"IDLGRBUFFER(IDLITCOMPONENT)::ERASE			(SYSTEM/built-in/IDLGRBUFFER)				P /COLOR:input",							$
	"IDLGRBUFFER(IDLITCOMPONENT)::GETCONTIGUOUSPIXELS	(SYSTEM/built-in/IDLGRBUFFER)				F",									$
	"IDLGRBUFFER(IDLITCOMPONENT)::GETDEVICEINFO		(SYSTEM/built-in/IDLGRBUFFER)				P /ALL:output /MAX_NUM_CLIP_PLANES:output /MAX_TEXTURE_DIMENSIONS:output /MAX_TILE_DIMENSIONS:output /MAX_VIEWPORT_DIMENSIONS:output /NAME:output /NUM_CPUS:output /VENDOR:output /VERSION:output",	$
	"IDLGRBUFFER(IDLITCOMPONENT)::GETFONTNAMES		(SYSTEM/built-in/IDLGRBUFFER)				F FamilyName:input /IDL_FONTS:input /STYLES:input",	$
	"IDLGRBUFFER(IDLITCOMPONENT)::GETPROPERTY		(SYSTEM/built-in/IDLGRBUFFER)				P " + IDLGRBUFFER_GETPROPERTY,	$
	"IDLGRBUFFER(IDLITCOMPONENT)::GETTEXTDIMENSIONS		(SYSTEM/built-in/IDLGRBUFFER)				F TextObj:input /DESCENT:output /PATH:input",		$
	"IDLGRBUFFER(IDLITCOMPONENT)::INIT			(SYSTEM/built-in/IDLGRBUFFER)				F " + IDLGRBUFFER_INIT,					$
	"IDLGRBUFFER(IDLITCOMPONENT)::PICKDATA			(SYSTEM/built-in/IDLGRBUFFER)				F View:input Object:input Location:input XYZLocation:input /DIMENSIONS:input /PATH:input /PICK_STATUS:output",	$
	"IDLGRBUFFER(IDLITCOMPONENT)::QUERYREQUIREDTILES	(SYSTEM/built-in/IDLGRBUFFER)				F View:input Image:input /COUNT:output /ALL_VISIBLE:input",	$
	"IDLGRBUFFER(IDLITCOMPONENT)::READ			(SYSTEM/built-in/IDLGRBUFFER)				F",	$
	"IDLGRBUFFER(IDLITCOMPONENT)::SELECT			(SYSTEM/built-in/IDLGRBUFFER)				F Picture:input XY:input /DIMENSIONS:input /ORDER /SUB_SELECTION:output /UNITS:input",	$
	"IDLGRBUFFER(IDLITCOMPONENT)::SETPROPERTY		(SYSTEM/built-in/IDLGRBUFFER)				P " + IDLGRBUFFER_SETPROPERTY,			$


	; IDLGRCLIPBOARD
	; --------------
	"IDLGRCLIPBOARD(IDLITCOMPONENT)::CLEANUP		(SYSTEM/built-in/IDLGRCLIPBOARD)			P",							$
	"IDLGRCLIPBOARD(IDLITCOMPONENT)::DRAW			(SYSTEM/built-in/IDLGRCLIPBOARD)			P [Picture:input] /CMYK /FILENAME:input /POSTSCRIPT:input /VECT_SHADING:input /VECT_SORTING:input /VECT_TEXT_RENDER_METHOD:input /VECTOR:input",	$
	"IDLGRCLIPBOARD(IDLITCOMPONENT)::GETCONTIGUOUSPIXELS	(SYSTEM/built-in/IDLGRCLIPBOARD)			F",	$
	"IDLGRCLIPBOARD(IDLITCOMPONENT)::GETDEVICEINFO		(SYSTEM/built-in/IDLGRCLIPBOARD)			P /ALL:output /MAX_NUM_CLIP_PLANES:output /MAX_TEXTURE_DIMENSIONS:output /MAX_TILE_DIMENSIONS:output /MAX_VIEWPORT_DIMENSIONS:output /NAME:output /NUM_CPUS:output /VENDOR:output /VERSION:output",	$
	"IDLGRCLIPBOARD(IDLITCOMPONENT)::GETFONTNAMES		(SYSTEM/built-in/IDLGRCLIPBOARD)			F FamilyName:input /IDL_FONTS:input /STYLES:input",	$
	"IDLGRCLIPBOARD(IDLITCOMPONENT)::GETPROPERTY		(SYSTEM/built-in/IDLGRCLIPBOARD)			P " + IDLGRCLIPBOARD_GETPROPERTY,		$
	"IDLGRCLIPBOARD(IDLITCOMPONENT)::GETTEXTDIMENSIONS	(SYSTEM/built-in/IDLGRCLIPBOARD)			F TextObj:input /DESCENT:output /PATH:input",		$
	"IDLGRCLIPBOARD(IDLITCOMPONENT)::INIT			(SYSTEM/built-in/IDLGRCLIPBOARD)			F " + IDLGRCLIPBOARD_INIT,				$
	"IDLGRCLIPBOARD(IDLITCOMPONENT)::QUERYREQUIREDTILES	(SYSTEM/built-in/IDLGRCLIPBOARD)			F View:input Image:input /COUNT:output /ALL_VISIBLE:input",		$
	"IDLGRCLIPBOARD(IDLITCOMPONENT)::SETPROPERTY		(SYSTEM/built-in/IDLGRCLIPBOARD)			P " + IDLGRCLIPBOARD_SETPROPERTY,		$


	; IDLGRCOLORBAR
	; -------------
	"IDLGRCOLORBAR(IDLGRMODEL/IDLITCOMPONENT)::CLEANUP		(SYSTEM/lib/idlgrcolorbar__define.pro)		P",									$
	"IDLGRCOLORBAR(IDLGRMODEL/IDLITCOMPONENT)::COMPUTEDIMENSIONS	(SYSTEM/lib/idlgrcolorbar__define.pro)		F DestinationObji:input /PATH:input",					$
	"IDLGRCOLORBAR(IDLGRMODEL/IDLITCOMPONENT)::GETPROPERTY 		(SYSTEM/lib/idlgrcolorbar__define.pro)		P " + IDLGRCOLORBAR_GETPROPERTY,					$
	"IDLGRCOLORBAR(IDLGRMODEL/IDLITCOMPONENT)::INIT 		(SYSTEM/lib/idlgrcolorbar__define.pro)		F [aRed:input] [aGreen:input] [aBlue:input] " + IDLGRCOLORBAR_INIT,	$
	"IDLGRCOLORBAR(IDLGRMODEL/IDLITCOMPONENT)::SETPROPERTY 		(SYSTEM/lib/idlgrcolorbar__define.pro)		P " + IDLGRCOLORBAR_SETPROPERTY,					$


	; IDLGRCONTOUR
	; ------------
	"IDLGRCONTOUR(IDLITCOMPONENT)::ADJUSTLABELOFFSETS 		(SYSTEM/built-in/IDLGRCONTOUR)			P LevelIndex:input LabelOffsets:input",										$
	"IDLGRCONTOUR(IDLITCOMPONENT)::CLEANUP		 		(SYSTEM/built-in/IDLGRCONTOUR)			P",														$
	"IDLGRCONTOUR(IDLITCOMPONENT)::GETCTM		 		(SYSTEM/built-in/IDLGRCONTOUR)			F /DESTINATION:input /PATH:input /TOP:input",									$
	"IDLGRCONTOUR(IDLITCOMPONENT)::GETLABELINFO	 		(SYSTEM/built-in/IDLGRCONTOUR)			P Destination:input LevelIndex:input /LABEL_OFFSETS:output /LABEL_POLYLINES:output /LABEL_OBJECTS:output",	$
	"IDLGRCONTOUR(IDLITCOMPONENT)::GETPROPERTY	 		(SYSTEM/built-in/IDLGRCONTOUR)			P " + IDLGRCONTOUR_GETPROPERTY,	$
	"IDLGRCONTOUR(IDLITCOMPONENT)::INIT	 			(SYSTEM/built-in/IDLGRCONTOUR)			F [Values:input] " + IDLGRCONTOUR_INIT,			$ 
	"IDLGRCONTOUR(IDLITCOMPONENT)::SETPROPERTY 			(SYSTEM/built-in/IDLGRCONTOUR)			P " + IDLGRCONTOUR_SETPROPERTY,			$


	; IDLGRFONT
	; ---------
	"IDLGRFONT::CLEANUP 						(SYSTEM/built-in/IDLGRFONT)			P",						$
	"IDLGRFONT::GETPROPERTY 					(SYSTEM/built-in/IDLGRFONT)			P " + IDLGRFONT_GETPROPERTY,			$
	"IDLGRFONT::INIT	 					(SYSTEM/built-in/IDLGRFONT)			F [Fontname:input] " + IDLGRFONT_INIT,		$
	"IDLGRFONT::SETPROPERTY	 					(SYSTEM/built-in/IDLGRFONT)			P " + IDLGRFONT_SETPROPERTY,			$


	; IDLGRIMAGE
	; ----------
	"IDLGRIMAGE(IDLITCOMPONENT)::CLEANUP			(SYSTEM/built-in/IDLGRIMAGE) 		P",	$
	"IDLGRIMAGE(IDLITCOMPONENT)::DELETETILEDATA		(SYSTEM/built-in/IDLGRIMAGE) 		P TileInfo:input /ALL",	$
	"IDLGRIMAGE(IDLITCOMPONENT)::GETCTM			(SYSTEM/built-in/IDLGRIMAGE) 		F /DESTINATION:input /PATH:input /TOP:input",	$
	"IDLGRIMAGE(IDLITCOMPONENT)::GETPROPERTY 		(SYSTEM/built-in/IDLGRIMAGE) 		P " + IDLGRIMAGE_GETPROPERTY,	$
	"IDLGRIMAGE(IDLITCOMPONENT)::INIT	 		(SYSTEM/built-in/IDLGRIMAGE) 		F [ImageData:input] /NO_COPY " + IDLGRIMAGE_INIT,	$
	"IDLGRIMAGE(IDLITCOMPONENT)::SETPROPERTY		(SYSTEM/built-in/IDLGRIMAGE) 		P " + IDLGRIMAGE_SETPROPERTY,	$
	"IDLGRIMAGE(IDLITCOMPONENT)::SETTILEDATA		(SYSTEM/built-in/IDLGRIMAGE) 		P TileInfo:input TileData:input /NO_FREE:input",	$


	; IDLGRLEGEND
	; -----------
	"IDLGRLEGEND(IDLGRMODEL/IDLITCOMPONENT)::CLEANUP		(SYSTEM/lib/idlgrlegend__define.pro) 		P",							$
	"IDLGRLEGEND(IDLGRMODEL/IDLITCOMPONENT)::COMPUTEDIMENSIONS	(SYSTEM/lib/idlgrlegend__define.pro) 		F DestinationObject:input /PATH:input",			$
	"IDLGRLEGEND(IDLGRMODEL/IDLITCOMPONENT)::GETPROPERTY		(SYSTEM/lib/idlgrlegend__define.pro) 		P " + IDLGRLEGEND_GETPROPERTY,				$
	"IDLGRLEGEND(IDLGRMODEL/IDLITCOMPONENT)::INIT			(SYSTEM/lib/idlgrlegend__define.pro) 		F [aItemNames:input] " + IDLGRLEGEND_INIT,		$
	"IDLGRLEGEND(IDLGRMODEL/IDLITCOMPONENT)::SETPROPERTY		(SYSTEM/lib/idlgrlegend__define.pro) 		P " + IDLGRLEGEND_SETPROPERTY,				$


	; IDLGRLIGHT
	; ----------
	"IDLGRLIGHT(IDLITCOMPONENT)::CLEANUP		(SYSTEM/built-in/IDLGRLIGHT) 		P",									$
	"IDLGRLIGHT(IDLITCOMPONENT)::GETCTM		(SYSTEM/built-in/IDLGRLIGHT) 		F /DESTINATION:input /PATH:input /TOP:input",				$
	"IDLGRLIGHT(IDLITCOMPONENT)::GETPROPERTY	(SYSTEM/built-in/IDLGRLIGHT) 		P " + IDLGRLIGHT_GETPROPERTY,						$
	"IDLGRLIGHT(IDLITCOMPONENT)::INIT		(SYSTEM/built-in/IDLGRLIGHT) 		F " + IDLGRLIGHT_INIT,							$
	"IDLGRLIGHT(IDLITCOMPONENT)::SETPROPERTY	(SYSTEM/built-in/IDLGRLIGHT) 		P " + IDLGRLIGHT_SETPROPERTY,						$


	; IDLGRPALETTE
	; ------------
	"IDLGRPALETTE::CLEANUP					(SYSTEM/built-in/IDLGRPALETTE) 				P",									$
	"IDLGRPALETTE::GETRGB					(SYSTEM/built-in/IDLGRPALETTE) 				F Index:input",								$
	"IDLGRPALETTE::GETPROPERTY				(SYSTEM/built-in/IDLGRPALETTE) 				P " + IDLGRPALETTE_GETPROPERTY,							$
	"IDLGRPALETTE::INIT					(SYSTEM/built-in/IDLGRPALETTE) 				F [aRed:input] [aGree:input] [aBlue:input] " + IDLGRPALETTE_INIT,	$
	"IDLGRPALETTE::LOADCT					(SYSTEM/built-in/IDLGRPALETTE) 				P TableNum:input /FILE:input",						$
	"IDLGRPALETTE::NEARESTCOLOR				(SYSTEM/built-in/IDLGRPALETTE) 				F Red:input Green:input Blue:input",					$
	"IDLGRPALETTE::SETRGB					(SYSTEM/built-in/IDLGRPALETTE) 				P Index:input Red:input Green:input Blue:input",			$
	"IDLGRPALETTE::SETPROPERTY				(SYSTEM/built-in/IDLGRPALETTE) 				P " + IDLGRPALETTE_SETPROPERTY,							$


	; IDLGRPATTERN
	; ------------
	"IDLGRPATTERN::CLEANUP				(SYSTEM/built-in/IDLGRPATTERN) 				P",										$
	"IDLGRPATTERN::GETPROPERTY			(SYSTEM/built-in/IDLGRPATTERN) 				P " + IDLGRPATTERN_GETPROPERTY,							$
	"IDLGRPATTERN::INIT				(SYSTEM/built-in/IDLGRPATTERN) 				F [Style:input] " + IDLGRPATTERN_INIT,						$
	"IDLGRPATTERN::SETPROPERTY			(SYSTEM/built-in/IDLGRPATTERN) 				P " + IDLGRPATTERN_SETPROPERTY,							$


	; IDLGRPLOT
	; ---------
	"IDLGRPLOT(IDLITCOMPONENT)::CLEANUP			(SYSTEM/built-in/IDLGRPLOT) 			P",										$
	"IDLGRPLOT(IDLITCOMPONENT)::GETCTM			(SYSTEM/built-in/IDLGRPLOT) 			F /DESTINATION:input /PATH:input /TOP:input",					$
	"IDLGRPLOT(IDLITCOMPONENT)::GETPROPERTY			(SYSTEM/built-in/IDLGRPLOT) 			P " + IDLGRPLOT_GETPROPERTY,							$
	"IDLGRPLOT(IDLITCOMPONENT)::INIT			(SYSTEM/built-in/IDLGRPLOT) 			F [X:input] [Y:input] " + IDLGRPLOT_INIT,					$
	"IDLGRPLOT(IDLITCOMPONENT)::SETPROPERTY			(SYSTEM/built-in/IDLGRPLOT) 			P " + IDLGRPLOT_SETPROPERTY,							$


	; IDLGRPOLYGON
	; ------------
	"IDLGRPOLYGON(IDLITCOMPONENT)::CLEANUP			(SYSTEM/built-in/IDLGRPOLYGON) 			P",										$
	"IDLGRPOLYGON(IDLITCOMPONENT)::GETCTM			(SYSTEM/built-in/IDLGRPOLYGON) 			F /DESTINATION:input /PATH:input /TOP:input",					$
	"IDLGRPOLYGON(IDLITCOMPONENT)::GETPROPERTY		(SYSTEM/built-in/IDLGRPOLYGON) 			P " + IDLGRPOLYGON_GETPROPERTY,							$
	"IDLGRPOLYGON(IDLITCOMPONENT)::INIT			(SYSTEM/built-in/IDLGRPOLYGON) 			F [X:input] [Y:input] [Z:input] " + IDLGRPOLYGON_INIT,				$
	"IDLGRPOLYGON(IDLITCOMPONENT)::SETPROPERTY		(SYSTEM/built-in/IDLGRPOLYGON) 			P " + IDLGRPOLYGON_SETPROPERTY,							$


	; IDLGRPOLYLINE
	; -------------
	"IDLGRPOLYLINE(IDLITCOMPONENT)::CLEANUP			(SYSTEM/built-in/IDLGRPOLYLINE) 		P",										$
	"IDLGRPOLYLINE(IDLITCOMPONENT)::GETCTM			(SYSTEM/built-in/IDLGRPOLYLINE) 		F /DESTINATION:input /PATH:input /TOP:input",					$
	"IDLGRPOLYLINE(IDLITCOMPONENT)::GETPROPERTY		(SYSTEM/built-in/IDLGRPOLYLINE) 		P " + IDLGRPOLYLINE_GETPROPERTY,						$
	"IDLGRPOLYLINE(IDLITCOMPONENT)::INIT			(SYSTEM/built-in/IDLGRPOLYLINE) 		F [X:input] [Y:input] [Z:input] " + IDLGRPOLYLINE_INIT,				$
	"IDLGRPOLYLINE(IDLITCOMPONENT)::SETPROPERTY		(SYSTEM/built-in/IDLGRPOLYLINE) 		P " + IDLGRPOLYLINE_SETPROPERTY,						$


	; IDLGRPRINTER
	; ------------
	"IDLGRPRINTER::CLEANUP					(SYSTEM/built-in/IDLGRPRINTER) 				P",											$
	"IDLGRPRINTER::DRAW					(SYSTEM/built-in/IDLGRPRINTER) 				P [Picture:input] /VECT_SORTING:input /VECT_TEXT_RENDER_METHOD:input /VECTOR:input",	$
	"IDLGRPRINTER::GETCONTIGUOUSPIXELS 			(SYSTEM/built-in/IDLGRPRINTER) 				F",											$
	"IDLGRPRINTER::GETFONTNAMES 				(SYSTEM/built-in/IDLGRPRINTER)				F FamilyName:input /IDL_FONTS:input /STYLES:input",					$
	"IDLGRPRINTER::GETPROPERTY  				(SYSTEM/built-in/IDLGRPRINTER)				P "  + IDLGRPRINTER_GETPROPERTY,								$
	"IDLGRPRINTER::GETTEXTDIMENSIONS  			(SYSTEM/built-in/IDLGRPRINTER)				F TextObj:input /DESCENT:output /PATH:input",						$
	"IDLGRPRINTER::INIT   					(SYSTEM/built-in/IDLGRPRINTER)				F "  + IDLGRPRINTER_INIT,								$
	"IDLGRPRINTER::NEWDOCUMENT  				(SYSTEM/built-in/IDLGRPRINTER)				P",											$
	"IDLGRPRINTER::NEWPAGE   				(SYSTEM/built-in/IDLGRPRINTER)				P",											$
	"IDLGRPRINTER::QUERYREQUIREDTILES   			(SYSTEM/built-in/IDLGRPRINTER)				F View:input Image:input /COUNT:output /ALL_VISIBLE:input",				$
	"IDLGRPRINTER::SETPROPERTY				(SYSTEM/built-in/IDLGRPRINTER) 				P " + IDLGRPRINTER_SETPROPERTY,									$

	; IDLGRROI
	; --------
	"IDLGRROI(IDLANROI/IDLITCOMPONENT)::CLEANUP		(SYSTEM/built-in/IDLGRROI) 	P",	$
	"IDLGRROI(IDLANROI/IDLITCOMPONENT)::GETPROPERTY		(SYSTEM/built-in/IDLGRROI) 	P " + IDLGRROI_GETPROPERTY,	$
	"IDLGRROI(IDLANROI/IDLITCOMPONENT)::INIT		(SYSTEM/built-in/IDLGRROI) 	F X:input [Y:input] [Z:input] " + IDLGRROI_INIT,	$
	"IDLGRROI(IDLANROI/IDLITCOMPONENT)::PICKVERTEX		(SYSTEM/built-in/IDLGRROI) 	F Dest:input View:input Point:input /PATH:input",	$
	"IDLGRROI(IDLANROI/IDLITCOMPONENT)::SETPROPERTY		(SYSTEM/built-in/IDLGRROI) 	P " + IDLGRROI_SETPROPERTY,	$


	; IDLGRROIGROUP
	; -------------
	"IDLGRROIGROUP(IDLANROIGROUP/IDLITCOMPONENT)::ADD		(SYSTEM/built-in/IDLGRROIGROUP) 	P ROI:input",	$
	"IDLGRROIGROUP(IDLANROIGROUP/IDLITCOMPONENT)::CLEANUP		(SYSTEM/built-in/IDLGRROIGROUP) 	P",	$
	"IDLGRROIGROUP(IDLANROIGROUP/IDLITCOMPONENT)::GETPROPERTY 	(SYSTEM/built-in/IDLGRROIGROUP) 	P " + IDLGRROIGROUP_GETPROPERTY,	$
	"IDLGRROIGROUP(IDLANROIGROUP/IDLITCOMPONENT)::INIT 		(SYSTEM/built-in/IDLGRROIGROUP) 	F " + IDLGRROIGROUP_INIT,	$
	"IDLGRROIGROUP(IDLANROIGROUP/IDLITCOMPONENT)::PICKREGION	(SYSTEM/built-in/IDLGRROIGROUP) 	F Dest:input View:input Point:input /PATH:input",	$
	"IDLGRROIGROUP(IDLANROIGROUP/IDLITCOMPONENT)::SETPROPERTY	(SYSTEM/built-in/IDLGRROIGROUP) 	P " + IDLGRROIGROUP_SETPROPERTY,	$


	; IDLGRSCENE
	; ----------
	"IDLGRSCENE(IDL_CONTAINER/IDLITCOMPONENT)::ADD		(SYSTEM/built-in/IDLGRSCENE) 		P View:input /POSITION:input",	$
	"IDLGRSCENE(IDL_CONTAINER/IDLITCOMPONENT)::CLEANUP	(SYSTEM/built-in/IDLGRSCENE) 		P",	$
	"IDLGRSCENE(IDL_CONTAINER/IDLITCOMPONENT)::GETBYNAME	(SYSTEM/built-in/IDLGRSCENE) 		F Name:input",	$
	"IDLGRSCENE(IDL_CONTAINER/IDLITCOMPONENT)::GETPROPERTY	(SYSTEM/built-in/IDLGRSCENE) 		P " + IDLGRSCENE_GETPROPERTY,	$
	"IDLGRSCENE(IDL_CONTAINER/IDLITCOMPONENT)::INIT		(SYSTEM/built-in/IDLGRSCENE) 		F " + IDLGRSCENE_INIT,	$
	"IDLGRSCENE(IDL_CONTAINER/IDLITCOMPONENT)::SETPROPERTY 	(SYSTEM/built-in/IDLGRSCENE) 		P " + IDLGRSCENE_SETPROPERTY,	$


	; IDLGRSURFACE
	; ------------
	"IDLGRSURFACE(IDLITCOMPONENT)::CLEANUP		(SYSTEM/built-in/IDLGRSURFACE) 		P",	$
	"IDLGRSURFACE(IDLITCOMPONENT)::GETCTM		(SYSTEM/built-in/IDLGRSURFACE) 		F /DESTINATION:input /PATH:input /TOP:input",	$
	"IDLGRSURFACE(IDLITCOMPONENT)::GETPROPERTY	(SYSTEM/built-in/IDLGRSURFACE) 		P " + IDLGRSURFACE_GETPROPERTY,	$
	"IDLGRSURFACE(IDLITCOMPONENT)::INIT		(SYSTEM/built-in/IDLGRSURFACE) 		F Z:input [X:input] [Y:input] " + IDLGRSURFACE_INIT,	$
	"IDLGRSURFACE(IDLITCOMPONENT)::SETPROPERTY	(SYSTEM/built-in/IDLGRSURFACE) 		P " + IDLGRSURFACE_SETPROPERTY,	$


	; IDLGRSYMBOL
	; -----------
	"IDLGRSYMBOL::CLEANUP				(SYSTEM/built-in/IDLGRSYMBOL) 		P",	$
	"IDLGRSYMBOL::GETPROPERTY			(SYSTEM/built-in/IDLGRSYMBOL) 		P " + IDLGRSYMBOL_GETPROPERTY,	$
	"IDLGRSYMBOL::INIT				(SYSTEM/built-in/IDLGRSYMBOL) 		F " + IDLGRSYMBOL_INIT,	$
	"IDLGRSYMBOL::SETPROPERTY			(SYSTEM/built-in/IDLGRSYMBOL) 		P " + IDLGRSYMBOL_SETPROPERTY,	$


	; IDLGRTESSELLATOR
	; ----------------
	"IDLGRTESSELLATOR::ADDPOLYGON					(SYSTEM/built-in/IDLGRTESSELLATOR) 			P X:input [Y:input] [Z:input] /AUXDATA:input /INTERIOR /POLYGON:input",		$
	"IDLGRTESSELLATOR::CLEANUP					(SYSTEM/built-in/IDLGRTESSELLATOR) 			P",										$
	"IDLGRTESSELLATOR::INIT						(SYSTEM/built-in/IDLGRTESSELLATOR) 			F",										$
	"IDLGRTESSELLATOR::RESET					(SYSTEM/built-in/IDLGRTESSELLATOR) 			P",										$
	"IDLGRTESSELLATOR::TESSELLATE					(SYSTEM/built-in/IDLGRTESSELLATOR) 			F Vertices:output Poly:output /AUXDATA:output /QUIET",				$


	; IDLGRTEXT
	; ---------
	"IDLGRTEXT(IDLITCOMPONENT)::CLEANUP				(SYSTEM/built-in/IDLGRTEXT) 		P",	$
	"IDLGRTEXT(IDLITCOMPONENT)::GETCTM				(SYSTEM/built-in/IDLGRTEXT) 		F /DESTINATION:input /PATH:input /TOP:input",	$
	"IDLGRTEXT(IDLITCOMPONENT)::GETPROPERTY				(SYSTEM/built-in/IDLGRTEXT) 		P " + IDLGRTEXT_GETPROPERTY,	$
	"IDLGRTEXT(IDLITCOMPONENT)::INIT				(SYSTEM/built-in/IDLGRTEXT) 		F " + IDLGRTEXT_INIT,	$
	"IDLGRTEXT(IDLITCOMPONENT)::SETPROPERTY				(SYSTEM/built-in/IDLGRTEXT) 		P " + IDLGRTEXT_SETPROPERTY,	$


	; IDLGRVIEW
	; ---------
	"IDLGRVIEW(IDL_CONTAINER/IDLITCOMPONENT)::ADD			(SYSTEM/built-in/IDLGRVIEW) 				P Model:input /POSITION:input",											$
	"IDLGRVIEW(IDL_CONTAINER/IDLITCOMPONENT)::CLEANUP		(SYSTEM/built-in/IDLGRVIEW) 				P",											$
	"IDLGRVIEW(IDL_CONTAINER/IDLITCOMPONENT)::GETBYNAME		(SYSTEM/built-in/IDLGRVIEW) 				F Name:input",											$
	"IDLGRVIEW(IDL_CONTAINER/IDLITCOMPONENT)::GETPROPERTY		(SYSTEM/built-in/IDLGRVIEW) 				P " + IDLGRVIEW_GETPROPERTY,											$
	"IDLGRVIEW(IDL_CONTAINER/IDLITCOMPONENT)::INIT			(SYSTEM/built-in/IDLGRVIEW) 				F " + IDLGRVIEW_INIT,											$
	"IDLGRVIEW(IDL_CONTAINER/IDLITCOMPONENT)::SETPROPERTY		(SYSTEM/built-in/IDLGRVIEW) 				P " + IDLGRVIEW_SETPROPERTY,											$


	; IDLGRVIEWGROUP
	; --------------
	"IDLGRVIEWGROUP(IDL_CONTAINER/IDLITCOMPONENT)::ADD		(SYSTEM/built-in/IDLGRVIEWGROUP) 	P Model:input /POSITION:input",	$
	"IDLGRVIEWGROUP(IDL_CONTAINER/IDLITCOMPONENT)::CLEANUP		(SYSTEM/built-in/IDLGRVIEWGROUP) 	P",	$
	"IDLGRVIEWGROUP(IDL_CONTAINER/IDLITCOMPONENT)::GETBYNAME	(SYSTEM/built-in/IDLGRVIEWGROUP) 	F Name:input",	$
	"IDLGRVIEWGROUP(IDL_CONTAINER/IDLITCOMPONENT)::GETPROPERTY	(SYSTEM/built-in/IDLGRVIEWGROUP) 	P " + IDLGRVIEWGROUP_GETPROPERTY,	$
	"IDLGRVIEWGROUP(IDL_CONTAINER/IDLITCOMPONENT)::INIT 		(SYSTEM/built-in/IDLGRVIEWGROUP) 	F " + IDLGRVIEWGROUP_INIT,	$
	"IDLGRVIEWGROUP(IDL_CONTAINER/IDLITCOMPONENT)::SETPROPERTY	(SYSTEM/built-in/IDLGRVIEWGROUP) 	P " + IDLGRVIEWGROUP_SETPROPERTY,	$


	; IDLGRVOLUME
	; -----------
	"IDLGRVOLUME(IDLITCOMPONENT)::CLEANUP				(SYSTEM/built-in/IDLGRVOLUME) 				P",											$
	"IDLGRVOLUME(IDLITCOMPONENT)::COMPUTEBOUNDS			(SYSTEM/built-in/IDLGRVOLUME) 				P /OPACITY:input /RESET /VOLUMES:input",						$
	"IDLGRVOLUME(IDLITCOMPONENT)::GETCTM				(SYSTEM/built-in/IDLGRVOLUME) 				F /DESTINATION:input /PATH:input /TOP:input",						$
	"IDLGRVOLUME(IDLITCOMPONENT)::GETPROPERTY			(SYSTEM/built-in/IDLGRVOLUME) 				P " + IDLGRVOLUME_GETPROPERTY,								$
	"IDLGRVOLUME(IDLITCOMPONENT)::INIT				(SYSTEM/built-in/IDLGRVOLUME) 				F [vol0:input] [vol1:input]  [vol2:input] [vol3:input] /NO_COPY " + IDLGRVOLUME_INIT,	$
	"IDLGRVOLUME(IDLITCOMPONENT)::PICKVOXEL				(SYSTEM/built-in/IDLGRVOLUME) 				F Win:input View:input Point:input /PATH:input",											$
	"IDLGRVOLUME(IDLITCOMPONENT)::SETPROPERTY			(SYSTEM/built-in/IDLGRVOLUME) 				P " + IDLGRVOLUME_SETPROPERTY,								$


	; IDLGRVRML
	; ---------
	"IDLGRVRML(IDLITCOMPONENT)::CLEANUP			(SYSTEM/built-in/IDLGRVRML) 				P",																				$
	"IDLGRVRML(IDLITCOMPONENT)::DRAW			(SYSTEM/built-in/IDLGRVRML) 				P [Picture:input]",																				$
	"IDLGRVRML(IDLITCOMPONENT)::GETDEVICEINFO		(SYSTEM/built-in/IDLGRVRML) 				P /ALL:output /MAX_NUM_CLIP_PLANES:output /MAX_TEXTURE_DIMENSIONS:output /MAX_VIEWPORT_DIMENSIONS:output /NAME:output /NUM_CPUS:output /VENDOR:output /VERSION:output",		$
	"IDLGRVRML(IDLITCOMPONENT)::GETFONTNAMES		(SYSTEM/built-in/IDLGRVRML) 				F FamilyName:input /IDL_FONTS:input /STYLES:input",																						$
	"IDLGRVRML(IDLITCOMPONENT)::GETPROPERTY			(SYSTEM/built-in/IDLGRVRML) 				P " + IDLGRVRML_GETPROPERTY,																						$
	"IDLGRVRML(IDLITCOMPONENT)::GETTEXTDIMENSIONS		(SYSTEM/built-in/IDLGRVRML) 				F TextObj:input /DESCENT:output /PATH:input",																						$
	"IDLGRVRML(IDLITCOMPONENT)::INIT			(SYSTEM/built-in/IDLGRVRML) 				F " + IDLGRVRML_INIT,																						$
	"IDLGRVRML(IDLITCOMPONENT)::SETPROPERTY			(SYSTEM/built-in/IDLGRVRML) 				P " + IDLGRVRML_SETPROPERTY,																						$


	; IDL_SAVEFILE
	; ------------
	"IDL_SAVEFILE::CLEANUP					(SYSTEM/built-in/IDL_SAVEFILE) 		P",	$
	"IDL_SAVEFILE::CONTENTS					(SYSTEM/built-in/IDL_SAVEFILE) 		F",	$
	"IDL_SAVEFILE::INIT					(SYSTEM/built-in/IDL_SAVEFILE) 		F [Filename:input] /FILENAME:input /RELAXED_STRUCTURE_ASSIGNMENT",	$
	"IDL_SAVEFILE::NAMES					(SYSTEM/built-in/IDL_SAVEFILE) 		F /COUNT:output /COMMON_BLOCK /COMMON_VARIABLE:input /FUNCTION /OBJECT_HEAPVAR /POINTER_HEAPVAR /PROCEDURE /STRUCTURE_DEFINITION /SYSTEM_VARIABLE",	$
	"IDL_SAVEFILE::RESTORE					(SYSTEM/built-in/IDL_SAVEFILE) 		P SaveItem:input /COMMON /FUNCTION /NEW_HEAPVAR:output /OBJECT_HEAPVAR /POINTER_HEAPVAR /PROCEDURE /RESTORED_OBJECTS:output /STRUCTURE_DEFINITION /VERBOSE",	$
	"IDL_SAVEFILE::SIZE					(SYSTEM/built-in/IDL_SAVEFILE) 		F SaveItem:input /L64 /DIMENSIONS /FILE_LUN /FILE_OFFSET /N_DIMENSIONS /N_ELEMENTS /SNAME /STRUCTURE /TNAME /TYPE",	$


	; IDLCOMIDISPATCH
	; ---------------
	"IDLCOMIDISPATCH::GETPROPERTY				(SYSTEM/built-in/IDLCOMIDISPATCH) 		P",	$
	"IDLCOMIDISPATCH::INIT					(SYSTEM/built-in/IDLCOMIDISPATCH) 		F name:input",	$
	"IDLCOMIDISPATCH::SETPROPERTY				(SYSTEM/built-in/IDLCOMIDISPATCH) 		P",	$


	; IDLJAVAOBJECT
	; -------------
	"IDLJAVAOBJECT::GETPROPERTY				(SYSTEM/built-in/IDLJAVAOBJECT) 		P",	$
	"IDLJAVAOBJECT::INIT					(SYSTEM/built-in/IDLJAVAOBJECT) 		F javaclassname:input [Args:inputs]",	$
	"IDLJAVAOBJECT::SETPROPERTY				(SYSTEM/built-in/IDLJAVAOBJECT) 		P",	$


	; IDLSYSMONITORINFO
	; -----------------
	"IDLSYSMONITORINFO::CLEANUP				(SYSTEM/built-in/IDLSYSMONITORINFO) 		P",	$
	"IDLSYSMONITORINFO::GETMONITORNAMES			(SYSTEM/built-in/IDLSYSMONITORINFO) 		F",	$
	"IDLSYSMONITORINFO::GETNUMBEROFMONITORS			(SYSTEM/built-in/IDLSYSMONITORINFO) 		F",	$
	"IDLSYSMONITORINFO::GETPRIMARYMONITORINDEX		(SYSTEM/built-in/IDLSYSMONITORINFO) 		F",	$
	"IDLSYSMONITORINFO::GETPROPERTY				(SYSTEM/built-in/IDLSYSMONITORINFO) 		P " + IDLSYSMONITORINFO_GETPROPERTY,	$
	"IDLSYSMONITORINFO::GETRECTANGLES			(SYSTEM/built-in/IDLSYSMONITORINFO) 		F /EXCLUDE_TASKBAR",	$
	"IDLSYSMONITORINFO::GETRESOLUTIONS			(SYSTEM/built-in/IDLSYSMONITORINFO) 		F",	$
	"IDLSYSMONITORINFO::INIT				(SYSTEM/built-in/IDLSYSMONITORINFO) 		F " + IDLSYSMONITORINFO_INIT,	$
	"IDLSYSMONITORINFO::ISEXTENDEDDESKTOP			(SYSTEM/built-in/IDLSYSMONITORINFO) 		F",	$
	"IDLSYSMONITORINFO::SETPROPERTY				(SYSTEM/built-in/IDLSYSMONITORINFO) 		P " + IDLSYSMONITORINFO_GETPROPERTY,	$


	; TRACKBALL
	; ---------
	"TRACKBALL::INIT					(SYSTEM/lib/trackball__define.pro) 		F Center:input Radius:input " + TRACKBALL_INIT,	$
	"TRACKBALL::RESET					(SYSTEM/lib/trackball__define.pro) 		P Center:input Radius:input /AXIS:input /CONSTRAIN /MOUSE:input",	$
	"TRACKBALL::UPDATE					(SYSTEM/lib/trackball__define.pro) 		F sEvent:input /MOUSE:input /TRANSFORM:output /TRANSLATE",	$


	; IDLNETURL (IDL6.4)
	; ---------
	"IDLNETURL::CLEANUP					(SYSTEM/built-in/IDLNETURL) 				P",									$
	"IDLNETURL::CLOSECONNECTIONS				(SYSTEM/built-in/IDLNETURL) 				P",									$
	"IDLNETURL::DELETE					(SYSTEM/built-in/IDLNETURL) 				P /URL:input",								$
	"IDLNETURL::FTPCOMMAND					(SYSTEM/built-in/IDLNETURL) 				F Command:input /FTP_EXPLICIT_SSL /URL:input",				$
	"IDLNETURL::GET						(SYSTEM/built-in/IDLNETURL) 				F /BUFFER /FILENAME:input /FTP_EXPLICIT_SSL /STRING_ARRAY /URL:input",	$
	"IDLNETURL::GETFTPDIRLIST				(SYSTEM/built-in/IDLNETURL) 				F /FTP_EXPLICIT_SSL /URL:input /SHORT",					$
	"IDLNETURL::GETPROPERTY					(SYSTEM/built-in/IDLNETURL) 				F " + IDLNETURL_GETPROPERTY,						$
	"IDLNETURL::INIT					(SYSTEM/built-in/IDLNETURL) 				F " + IDLNETURL_INIT,							$
	"IDLNETURL::PUT						(SYSTEM/built-in/IDLNETURL) 				F data:input /BUFFER:input /FTP_EXPLICIT_SSL /POST /URL:input",		$
	"IDLNETURL::SETPROPERTY					(SYSTEM/built-in/IDLNETURL) 				P " + IDLNETURL_SETPROPERTY,						$


	; idl_qhull.dlm
	; -------------
	"GRID_INPUT+1						(SYSTEM/idl_qhull.dlm) 					P X:input   Y:input     F:input X1:input   Y1:input F1:input                  /DUPLICATES:input /EPSILON:input /EXCLUDE:input",			$
	"GRID_INPUT+2						(SYSTEM/idl_qhull.dlm) 					P Lon:input Lat:input   F:input Xyz:output F1:input          /SPHERE /DEGREES /DUPLICATES:input /EPSILON:input /EXCLUDE:input",	$
	"GRID_INPUT+3						(SYSTEM/idl_qhull.dlm) 					P R:input   Theta:input F:input X1:input   Y1:input F1:input /POLAR /DEGREES  /DUPLICATES:input /EPSILON:input /EXCLUDE:input",	$
	"GRID_TPS						(SYSTEM/idl_qhull.dlm)					F Xp:input Yp:input Values:input /COEFFICIENTS:output /NGRID:input /START:input /DELTA:input",			$
	"GRIDDATA+1						(SYSTEM/idl_qhull.dlm) 					F X:input                 F:input         /METHOD:input /INVERSE_DISTANCE /ANISOTROPY:input /DEGREES /DELTA:input /DIMENSION:input /TRIANGLES:input /EMPTY_SECTORS:input /MAX_PER_SECTOR:input /MIN_POINTS:input /SEARCH_ELLIPSE:input /FAULT_POLYGONS:input /FAULT_XY:input /GRID /XOUT:input /YOUT:input /MISSING:input /POWER:input /SMOOTHING:input /START:input /KRIGING /VARIOGRAM /LINEAR /MIN_CURVATURE /SHEPARDS /NEIGHBORHOOD:input /NATURAL_NEIGHBOR /NEAREST_NEIGHBOR /POLYNOMIAL_REGRESSION /QUINTIC /RADIAL_BASIS_FUNCTION /FUNCTION_TYPE:input",	$
	"GRIDDATA+2						(SYSTEM/idl_qhull.dlm) 					F X:input Y:input         F:input         /METHOD:input /INVERSE_DISTANCE /ANISOTROPY:input /DEGREES /DELTA:input /DIMENSION:input /TRIANGLES:input /EMPTY_SECTORS:input /MAX_PER_SECTOR:input /MIN_POINTS:input /SEARCH_ELLIPSE:input /FAULT_POLYGONS:input /FAULT_XY:input /GRID /XOUT:input /YOUT:input /MISSING:input /POWER:input /SMOOTHING:input /START:input /KRIGING /VARIOGRAM /LINEAR /MIN_CURVATURE /SHEPARDS /NEIGHBORHOOD:input /NATURAL_NEIGHBOR /NEAREST_NEIGHBOR /POLYNOMIAL_REGRESSION /QUINTIC /RADIAL_BASIS_FUNCTION /FUNCTION_TYPE:input",	$
	"GRIDDATA+3						(SYSTEM/idl_qhull.dlm) 					F X:input Y:input Z:input F:input /SPHERE /METHOD:input /INVERSE_DISTANCE /ANISOTROPY:input /DEGREES /DELTA:input /DIMENSION:input /TRIANGLES:input /EMPTY_SECTORS:input /MAX_PER_SECTOR:input /MIN_POINTS:input /SEARCH_ELLIPSE:input /FAULT_POLYGONS:input /FAULT_XY:input /GRID /XOUT:input /YOUT:input /MISSING:input /POWER:input /SMOOTHING:input /START:input /KRIGING /VARIOGRAM /LINEAR /MIN_CURVATURE /SHEPARDS /NEIGHBORHOOD:input /NATURAL_NEIGHBOR /NEAREST_NEIGHBOR /POLYNOMIAL_REGRESSION /QUINTIC /RADIAL_BASIS_FUNCTION /FUNCTION_TYPE:input",	$
	"GRIDDATA+4						(SYSTEM/idl_qhull.dlm) 					F Lon:input Lat:input     F:input /SPHERE /METHOD:input /INVERSE_DISTANCE /ANISOTROPY:input /DEGREES /DELTA:input /DIMENSION:input /TRIANGLES:input /EMPTY_SECTORS:input /MAX_PER_SECTOR:input /MIN_POINTS:input /SEARCH_ELLIPSE:input /FAULT_POLYGONS:input /FAULT_XY:input /GRID /XOUT:input /YOUT:input /MISSING:input /POWER:input /SMOOTHING:input /START:input /KRIGING /VARIOGRAM /LINEAR /MIN_CURVATURE /SHEPARDS /NEIGHBORHOOD:input /NATURAL_NEIGHBOR /NEAREST_NEIGHBOR /POLYNOMIAL_REGRESSION /QUINTIC /RADIAL_BASIS_FUNCTION /FUNCTION_TYPE:input",	$
	"QGRID3+1						(SYSTEM/idl_qhull.dlm)					F XYZ:input F:input Tetrahedra:input               /DELTA:input /DIMENSION:input /MISSING:input /START:input",	$
	"QGRID3+2						(SYSTEM/idl_qhull.dlm)					F X:input Y:input Z:input F:input Tetrahedra:input /DELTA:input /DIMENSION:input /MISSING:input /START:input",	$
	"QHULL+1						(SYSTEM/idl_qhull.dlm) 					P V0:input                                                       Tr:output /BOUNDS:output /CONNECTIVITY:output /DELAUNAY /SPHERE:output /VDIAGRAM:input /VNORMALS:input /VVERTICES:input",	$
	"QHULL+2						(SYSTEM/idl_qhull.dlm) 					P V0:input V1:input                                              Tr:output /BOUNDS:output /CONNECTIVITY:output /DELAUNAY /SPHERE:output /VDIAGRAM:input /VNORMALS:input /VVERTICES:input",	$
	"QHULL+3						(SYSTEM/idl_qhull.dlm) 					P V0:input V1:input V2:input                                     Tr:output /BOUNDS:output /CONNECTIVITY:output /DELAUNAY /SPHERE:output /VDIAGRAM:input /VNORMALS:input /VVERTICES:input",	$
	"QHULL+4						(SYSTEM/idl_qhull.dlm) 					P V0:input V1:input V2:input V3:input                            Tr:output /BOUNDS:output /CONNECTIVITY:output /DELAUNAY /SPHERE:output /VDIAGRAM:input /VNORMALS:input /VVERTICES:input",	$
	"QHULL+5						(SYSTEM/idl_qhull.dlm) 					P V0:input V1:input V2:input V3:input V4:input                   Tr:output /BOUNDS:output /CONNECTIVITY:output /DELAUNAY /SPHERE:output /VDIAGRAM:input /VNORMALS:input /VVERTICES:input",	$
	"QHULL+6						(SYSTEM/idl_qhull.dlm) 					P V0:input V1:input V2:input V3:input V4:input V5:input          Tr:output /BOUNDS:output /CONNECTIVITY:output /DELAUNAY /SPHERE:output /VDIAGRAM:input /VNORMALS:input /VVERTICES:input",	$
	"QHULL+7						(SYSTEM/idl_qhull.dlm) 					P V0:input V1:input V2:input V3:input V4:input V5:input V6:input Tr:output /BOUNDS:output /CONNECTIVITY:output /DELAUNAY /SPHERE:output /VDIAGRAM:input /VNORMALS:input /VVERTICES:input",	$


	; idl_jpeg.dlm
	; ------------
	"QUERY_JPEG						(SYSTEM/idl_jpeg.dlm) 					F Filename:input [output] /IMAGE_INDEX:input",	$
	"READ_JPEG+1						(SYSTEM/idl_jpeg.dlm) 					P                Image:output [Colortable:output] /BUFFER:output /COLORS:input /DITHER:input /GRAYSCALE /ORDER /TRUE:input /UNIT:input /TWO_PASS_QUANTIZE",	$
	"READ_JPEG+2						(SYSTEM/idl_jpeg.dlm) 					P Filename:input Image:output [Colortable:output] /BUFFER:output /COLORS:input /DITHER:input /GRAYSCALE /ORDER /TRUE:input /UNIT:input /TWO_PASS_QUANTIZE",	$
	"WRITE_JPEG+1						(SYSTEM/idl_jpeg.dlm) 					P                Image:input /ORDER /PROGRESSIVE /QUALITY:input /TRUE:input /UNIT:input",	$
	"WRITE_JPEG+2						(SYSTEM/idl_jpeg.dlm) 					P Filename:input Image:input /ORDER /PROGRESSIVE /QUALITY:input /TRUE:input /UNIT:input",	$


	; idl_png.dlm
	; ------------
	"QUERY_PNG						(SYSTEM/idl_png.dlm) 					F Filename:input [Info:output] /IMAGE_INDEX:input",	$
	"READ_PNG						(SYSTEM/idl_png.dlm) 					F Filename:input [R:output] [G:output] [B:output] /ORDER /VERBOSE /TRANSPARENT:output",			$
	"WRITE_PNG						(SYSTEM/idl_png.dlm)					P Filename:input Image:input [R:input] [G:input] [B:input] /ORDER /VERBOSE /TRANSPARENT:input",	$


	; idl_tiff.dlm
	; ------------
	"QUERY_TIFF						(SYSTEM/idl_tiff.dlm) 					F Filename:input [Info:output] /GEOTIFF:output /IMAGE_INDEX:input",	$
	"READ_TIFF						(SYSTEM/idl_tiff.dlm)					F Filename:input [R:output] [G:output] [B:output] /CHANNELS:input /DOT_RANGE:output /GEOTIFF:output /ICC_PROFILE:output /IMAGE_INDEX:input /INTERLEAVE:input /ORIENTATION:output /PHOTOSHOP:output /PLANARCONFIG:output /SUB_RECT:input /VERBOSE /ORDER:input",			$
	"WRITE_TIFF						(SYSTEM/idl_tiff.dlm)					P Filename:input [Image:input] [extra:input] /APPEND /BITS_PER_SAMPLE:input /RED:input /GREEN:input /BLUE:input /CMYK /COMPRESSION:input /DESCRIPTION:input /DOCUMENT_NAME:input /DOT_RANGE:input /GEOTIFF:input /LONG /SHORT /FLOAT /ICC_PROFILE:input /ORIENTATION:input /PHOTOSHOP:input /PLANARCONFIG:input /UNITS:input /VERBOSE /XPOSITION:input /XRESOL:input /YPOSITION:input /YRESOL:input",	$
	"DECODE_PACKBITS					(SYSTEM/idl_tiff.dlm)					P p1:input p2:input /POINTER:input /BUFFER:input /OFFSET:input /COUNT:input",	$


	; idl_lapack.dlm
	; --------------
	"BLAS_AXPY						(SYSTEM/idl_lapack.dlm) 				P Y:input A:input X:input [D1:input] [Loc1:input]  [D2:input] [Range:input]",			$
	"LA_CHOLDC						(SYSTEM/idl_lapack.dlm) 				P Array:input /DOUBLE /STATUS:output /UPPER",			$
	"LA_CHOLMPROVE						(SYSTEM/idl_lapack.dlm)					F Array:input Achol:input B:input X:input /BACKWARD_ERROR:output /DOUBLE /FORWARD_ERROR:output /UPPER",			$
	"LA_CHOLSOL						(SYSTEM/idl_lapack.dlm) 				F A:input B:input /DOUBLE /UPPER",			$
	"LA_EIGENPROBLEM					(SYSTEM/idl_lapack.dlm)					F A:input [B:input] /ALPHA:output /BALANCE:input /BETA:output /DOUBLE /EIGENVECTORS:output /LEFT_EIGENVECTORS:output /NORM_BALANCE:output /PERMUTE_RESULT:output /SCALE_RESULT:output /RCOND_VALUE:output /RCOND_VECTOR:output /STATUS:output",			$
	"LA_EIGENQL						(SYSTEM/idl_lapack.dlm)					F A:input [B:input] /DOUBLE /EIGENVECTORS:output /FAILED:output /GENERALIZED:input /METHOD:input /RANGE:input /SEARCH_RANGE:input /STATUS:output /TOLERANCE:input",			$
	"LA_EIGENVEC						(SYSTEM/idl_lapack.dlm) 				F T:input QZ:input /BALANCE:input /DOUBLE /EIGENINDEX:output /LEFT_EIGENVECTORS:output /PERMUTE_RESULT:input /SCALE_RESULT:input /RCOND_VALUE:output /RCOND_VECTOR:output /SELECT:input",			$
	"LA_ELMHES						(SYSTEM/idl_lapack.dlm)					F Array:input [Q:output] /BALANCE:input /DOUBLE /NORM_BALANCE:output /PERMUTE_RESULT:output /SCALE_RESULT:output",			$
	"LA_GM_LINEAR_MODEL					(SYSTEM/idl_lapack.dlm) 				F A:input B:input D:input Y:output /DOUBLE",			$
	"LA_HQR							(SYSTEM/idl_lapack.dlm) 				F H:input [Q:input] /DOUBLE /PERMUTE_RESULT:input /STATUS:output",			$
	"LA_INVERT						(SYSTEM/idl_lapack.dlm) 				F A:input /DOUBLE /STATUS:output",			$
	"LA_LEAST_SQUARE_EQUALITY				(SYSTEM/idl_lapack.dlm) 				F A:input B:input C:input D:input /DOUBLE /RESIDUAL:output",			$
	"LA_LEAST_SQUARES					(SYSTEM/idl_lapack.dlm)					F A:input B:input /DOUBLE /METHOD:input /RANK:output /RCONDITION:input /RESIDUAL:output /STATUS:output",			$	
	"LA_LUDC						(SYSTEM/idl_lapack.dlm) 				P Array:input Index:output /DOUBLE /STATUS:output",			$
	"LA_LUMPROVE						(SYSTEM/idl_lapack.dlm) 				F Array:input Aludc:input Index:input B:input X:input /BACKWARD_ERROR:output /DOUBLE /FORWARD_ERROR:output",			$
	"LA_LUSOL						(SYSTEM/idl_lapack.dlm) 				F A:input Index:input B:input /DOUBLE",			$
	"LA_SVD							(SYSTEM/idl_lapack.dlm) 				P Array:input W:output U:output V:output /DOUBLE /DIVIDE_CONQUER /STATUS:output",			$
	"LA_TRIDC						(SYSTEM/idl_lapack.dlm) 				P AL:input A:input AU:input U2:output Index:output /DOUBLE /STATUS:output",			$
	"LA_TRIMPROVE						(SYSTEM/idl_lapack.dlm) 				F AL:input A:input AU:input DAL:input DA:input DAU:input DU2:input Index:input B:input X:input /BACKWARD_ERROR:output /DOUBLE /FORWARD_ERROR:output",			$
	"LA_TRIQL						(SYSTEM/idl_lapack.dlm)					P D:input E:input [A:output] /DOUBLE /STATUS:output",			$
	"LA_TRIRED						(SYSTEM/idl_lapack.dlm)					P Array:input D:output E:output /DOUBLE /UPPER",			$
	"LA_TRISOL						(SYSTEM/idl_lapack.dlm)					F AL:input A:input AU:input U2:input Index:input B:input /DOUBLE",			$


	; idl_netcdf.dlm
	; --------------
	; IDL_NCDF 3.5.0
	"NCDF_ATTCOPY+1						(SYSTEM/idl_netcdf.dlm)					F Incdf:input             Name:input                           /IN_GLOBAL  /OUT_GLOBAL",	$
	"NCDF_ATTCOPY+2						(SYSTEM/idl_netcdf.dlm) 				F Incdf:input             Name:input Outcdf:input Outvar:input /IN_GLOBAL",			$
	"NCDF_ATTCOPY+3						(SYSTEM/idl_netcdf.dlm) 				F Incdf:input Invar:input Name:input Outcdf:input                          /OUT_GLOBAL",	$
	"NCDF_ATTCOPY+4						(SYSTEM/idl_netcdf.dlm) 				F Incdf:input Invar:input Name:input Outcdf:input Outvar:input",				$
	"NCDF_ATTDEL+1						(SYSTEM/idl_netcdf.dlm)					P Cdfid:input             Name:input /GLOBAL",			$
	"NCDF_ATTDEL+2						(SYSTEM/idl_netcdf.dlm)					P Cdfid:input Varid:input Name:input",			$
	"NCDF_ATTGET+1						(SYSTEM/idl_netcdf.dlm) 				P Cdfid:input             Name:input value:output /GLOBAL",		$
	"NCDF_ATTGET+2						(SYSTEM/idl_netcdf.dlm) 				P Cdfid:input Varid:input Name:input Value:output",			$	
	"NCDF_ATTINQ+1						(SYSTEM/idl_netcdf.dlm) 				F Cdfid:input             Name:input /GLOBAL",			$
	"NCDF_ATTINQ+2						(SYSTEM/idl_netcdf.dlm)					F Cdfid:input Varid:input Name:input",				$
	"NCDF_ATTNAME+1						(SYSTEM/idl_netcdf.dlm) 				F Cdfid:input             Attnum:input /GLOBAL",			$
	"NCDF_ATTNAME+2						(SYSTEM/idl_netcdf.dlm) 				F Cdfid:input Varid:input Attnum:input",				$
	"NCDF_ATTPUT+1						(SYSTEM/idl_netcdf.dlm) 				P Cdfid:input             Name:input value:input /GLOBAL /LENGTH:input /BYTE /CHAR /DOUBLE /FLOAT /LONG /SHORT",			$
	"NCDF_ATTPUT+2						(SYSTEM/idl_netcdf.dlm) 				P Cdfid:input Varid:input Name:input value:input         /LENGTH:input /BYTE /CHAR /DOUBLE /FLOAT /LONG /SHORT",			$
	"NCDF_ATTRENAME+1					(SYSTEM/idl_netcdf.dlm) 				P Cdfid:input             Oldname:input Newname:input /GLOBAL",			$
	"NCDF_ATTRENAME+2					(SYSTEM/idl_netcdf.dlm) 				P Cdfid:input Varid:input Oldname:input Newname:input",			$
	"NCDF_CLOSE						(SYSTEM/idl_netcdf.dlm) 				P Cdfid:input",		$
	"NCDF_CONTROL						(SYSTEM/idl_netcdf.dlm) 				P Cdfid:input /ABORT /ENDEF /FILL /NOFILL /NOVERBOSE /VERBOSE /OLDFILL:output /REDEF /SYNC",	$
	"NCDF_CREATE						(SYSTEM/idl_netcdf.dlm)					F Filename:input /CLOBBER /NOCLOBBER",	$
	"NCDF_DIMDEF+1						(SYSTEM/idl_netcdf.dlm) 				F Cdfid:input DimName:input            /UNLIMITED",	$
	"NCDF_DIMDEF+2						(SYSTEM/idl_netcdf.dlm) 				F Cdfid:input DimName:input Size:input",	$
	"NCDF_DIMID						(SYSTEM/idl_netcdf.dlm) 				F Cdfid:input DimName:input",			$
	"NCDF_DIMINQ						(SYSTEM/idl_netcdf.dlm) 				P Cdfid:input Dimid:input Name:output Size:output",			$
	"NCDF_DIMRENAME						(SYSTEM/idl_netcdf.dlm) 				P Cdfid:input Dimid:input NewName:input",			$
	"NCDF_INQUIRE						(SYSTEM/idl_netcdf.dlm) 				F Cdfid:input",		$
	"NCDF_OPEN						(SYSTEM/idl_netcdf.dlm) 				F Filename:input /NOWRITE /WRITE",	$
	"NCDF_VARDEF						(SYSTEM/idl_netcdf.dlm) 				F Cdfid:input Name:input [Dim:input] /BYTE /CHAR /DOUBLE /FLOAT /LONG /SHORT",	$
	"NCDF_VARGET						(SYSTEM/idl_netcdf.dlm) 				P Cdfid:input Varid:input Value:output /COUNT:input /OFFSET:input /STRIDE:input",	$
	"NCDF_VARGET1						(SYSTEM/idl_netcdf.dlm) 				P Cdfid:input Varid:input Value:output /OFFSET:input",			$
	"NCDF_VARID						(SYSTEM/idl_netcdf.dlm) 				F Cdfid:input Name:input",		$
	"NCDF_VARINQ						(SYSTEM/idl_netcdf.dlm) 				F Cdfid:input Varid:input",		$
	"NCDF_VARPUT						(SYSTEM/idl_netcdf.dlm) 				P Cdfid:input Varid:input Value:input /COUNT:input /OFFSET:input /STRIDE:input",	$
	"NCDF_VARRENAME						(SYSTEM/idl_netcdf.dlm) 				P Cdfid:input Varid:input Name:input",			$


	; idl_cdf.dlm
	; -----------
	; IDL_CDF 3.5.0.1
	"CDF_ATTCREATE						(SYSTEM/idl_cdf.dlm) 					F Id:input Attribute_Name:input /GLOBAL_SCOPE /VARIABLE_SCOPE",			$
	"CDF_ATTEXISTS						(SYSTEM/idl_cdf.dlm) 					F Id:input Attribute:input [EntryNum:input] /ZVARIABLE",			$
	"CDF_ATTNUM						(SYSTEM/idl_cdf.dlm) 					F Id:input Attribute_Name:input",			$
	"CDF_CREATE						(SYSTEM/idl_cdf.dlm) 					F Filename:input [Dimensions:input] /CLOBBER /MULTI_FILE /SINGLE_FILE /COL_MAJOR /ROW_MAJOR /ALPHAOSF1_ENCODING /ALPHAVMSD_ENCODING /ALPHAVMSG_ENCODING /DECSTATION_ENCODING /HOST_ENCODING /HP_ENCODING /IBMPC_ENCODING /IBMRS_ENCODING /MAC_ENCODING /NETWORK_ENCODING /NEXT_ENCODING /SGI_ENCODING /SUN_ENCODING /ALPHAOSF1_DECODING /ALPHAVMSD_DECODING /ALPHAVMSG_DECODING /DECSTATION_DECODING /HOST_DECODING /HP_DECODING /IBMPC_DECODING /IBMRS_DECODING /MAC_DECODING /NETWORK_DECODING /NEXT_DECODING /SGI_DECODING /SUN_DECODING", $
	"CDF_ENCODE_EPOCH					(SYSTEM/idl_cdf.dlm) 					F Epoch:input [p2:???] /EPOCH:input",			$
	"CDF_ENCODE_EPOCH16					(SYSTEM/idl_cdf.dlm) 					F Epoch16:input [p2:???] /EPOCH:input",			$
	"CDF_ENCODE_TT2000					(SYSTEM/idl_cdf.dlm) 					F Epoch:input [p2:???] /EPOCH:input",			$
	"CDF_EPOCH_COMPARE					(SYSTEM/idl_cdf.dlm) 					F epoch:input baseepoch:input [endepoch:input]",			$
	"CDF_EPOCH_DIFF						(SYSTEM/idl_cdf.dlm) 					F epoch1:input epoch2:input /MILLI_SECONDS /MICRO_SECONDS",			$
	"CDF_EPOCH_TOJULDAYS					(SYSTEM/idl_cdf.dlm) 					F epoch:input /STRING",			$
	"CDF_ERROR						(SYSTEM/idl_cdf.dlm) 					F Status:input",			$
	"CDF_INQUIRE						(SYSTEM/idl_cdf.dlm) 					F Id:input",		$
	"CDF_LEAPSECONDS_INFO					(SYSTEM/idl_cdf.dlm)					F",		$
	"CDF_OPEN						(SYSTEM/idl_cdf.dlm) 					F Filename:input /READONLY",		$
	"CDF_PARSE_EPOCH					(SYSTEM/idl_cdf.dlm) 					F Epoch_String:input",			$
	"CDF_PARSE_EPOCH16					(SYSTEM/idl_cdf.dlm) 					F Epoch_String:input",			$
	"CDF_PARSE_TT2000					(SYSTEM/idl_cdf.dlm) 					F Epoch_String:input",		$
	"CDF_VARCREATE						(SYSTEM/idl_cdf.dlm) 					F Id:input Name:input [DimVary:input] /CDF_BYTE /CDF_CHAR /CDF_UCHAR /CDF_INT1 /CDF_UINT1 /CDF_INT8 /CDF_INT2 /CDF_UINT2 /CDF_TIME_TT2000 /CDF_INT4 /CDF_UINT4 /CDF_FLOAT /CDF_REAL4 /CDF_DOUBLE /CDF_REAL8 /CDF_EPOCH /CDF_LONG_EPOCH /ALLOCATERECS /DIMENSIONS /NUMELEM /REC_NOVARY /REC_VARY /ZVARIABLE", $
	"CDF_VARINQ						(SYSTEM/idl_cdf.dlm) 					F Id:input Variable:input /ZVARIABLE",			$
	"CDF_VARNUM						(SYSTEM/idl_cdf.dlm) 					F Id:input VarName:input [IsZVar:input]",			$
	"CDF_ATTDELETE						(SYSTEM/idl_cdf.dlm) 					P Id:input Attribute:input [EntryNum:input] /ZVARIABLE",			$
	"CDF_ATTGET						(SYSTEM/idl_cdf.dlm) 					P Id:input Attribute:input EntryNum:input Value:output /CDF_TYPE:output /ZVARIABLE",			$
	"CDF_ATTGET_ENTRY					(SYSTEM/idl_cdf.dlm) 					P Id:input Attribute:input EntryNum:input AttributeEntryType:input [Value:output] [Status:output] /CDF_TYPE:output /ATTRIBUTE_NAME:input /ZVARIABLE", $
	"CDF_ATTINQ						(SYSTEM/idl_cdf.dlm) 					P Id:input Attribute:input Name:output Scope:output MaxEntry:output [MaxZEntry:output]", $
	"CDF_ATTPUT						(SYSTEM/idl_cdf.dlm) 					P Id:input Attribute:input EntryNum:input Value:input /CDF_EPOCH:input /ZVARIABLE", $
	"CDF_ATTRENAME						(SYSTEM/idl_cdf.dlm) 					P Id:input OldAttr:input NewName:input",			$
	"CDF_CLOSE						(SYSTEM/idl_cdf.dlm) 					P Id:input",			$
	"CDF_COMPRESSION					(SYSTEM/idl_cdf.dlm) 					P Id:input /GET_COMPRESSION:output /GET_GZIP_LEVEL:output /GET_VAR_COMPRESSION:output /GET_VAR_GZIP_LEVEL:output /SET_COMPRESSION:input /SET_GZIP_LEVEL:input /SET_VAR_COMPRESSION:input /SET_VAR_GZIP_LEVEL:input /VARIABLE:input /ZVARIABLE", $
	"CDF_CONTROL						(SYSTEM/idl_cdf.dlm) 					P Id:input /ATTRIBUTE:input /GET_ATTR_INFO:output /GET_CACHESIZE:output /GET_COPYRIGHT:output /GET_FILENAME:output /GET_FORMAT:output /GET_NEGTOPOSFP0_MODE:output /GET_NUMATTRS:output /GET_READONLY_MODE:output /GET_RVAR_CACHESIZE:output /GET_VAR_INFO:output /GET_ZMODE:output /GET_ZVAR_CACHESIZE:output /SET_CACHESIZE:input /SET_EXTENDRECS:input /SET_INITIALRECS:input /SET_NEGTOPOSFP0_MODE:input /SET_PADVALUE:input /SET_READONLY_MODE:input /SET_RVAR_CACHESIZE:input /SET_RVARS_CACHESIZE:input /SET_ZMODE:input /SET_ZVAR_CACHESIZE:input /SET_ZVARS_CACHESIZE:input /VARIABLE:input /ZVARIABLE", $
	"CDF_DELETE						(SYSTEM/idl_cdf.dlm) 					P Id:input",			$
	"CDF_DOC						(SYSTEM/idl_cdf.dlm) 					P Id:input Version:output Release:output Copyright:output /INCREMENT:output", $
	"CDF_EPOCH+1						(SYSTEM/idl_cdf.dlm) 					P Epoch:input  Year:output [Month:output] [Day:output] [Hour:output] [Minute:output] [Second:output] [Milli:output] [???:output] [???:output] [???:output] /BREAKDOWN_EPOCH:input /TOINTEGER[not_found_in_v6.3_documentation_but_OK]:input",			$
	"CDF_EPOCH+2						(SYSTEM/idl_cdf.dlm) 					P Epoch:output Year:input  [Month:input]  [Day:input]  [Hour:input]  [Minute:input]  [Second:input]  [Milli:input]  [???:input]  [???:input]  [???:input]  /COMPUTE_EPOCH:input ",			$
	"CDF_EPOCH16+1						(SYSTEM/idl_cdf.dlm)					P Epoch:input  Year:output [Month:output] [Day:output] [Hour:output] [Minute:output] [Second:output] [Milli:output] [Micro:output] [Nano:output] [Pico:output] /BREAKDOWN_EPOCH:input /TOINTEGER[not_found_in_v6.3_documentation_but_OK]:input",			$
	"CDF_EPOCH16+2						(SYSTEM/idl_cdf.dlm) 					P Epoch:output Year:input  [Month:input]  [Day:input]  [Hour:input]  [Minute:input]  [Second:input]  [Milli:input]  [Micro:input]  [Nano:input]  [Pico:input]  /COMPUTE_EPOCH:input ",			$
	"CDF_LIB_INFO						(SYSTEM/idl_cdf.dlm) 					P /COPYRIGHT:output /INCREMENT:output /RELEASE:output /SUBINCREMENT:output /VERSION:output", $
	"CDF_SET_CDF27_BACKWARD_COMPATIBLE			(SYSTEM/idl_cdf.dlm) 					P /YES /NO", $
	"CDF_SET_MD5CHECKSUM					(SYSTEM/idl_cdf.dlm) 					P Id:input /REMOVE", $
	"CDF_SET_VALIDATE					(SYSTEM/idl_cdf.dlm) 					P /YES /NO",			$
	"CDF_TT2000+1						(SYSTEM/idl_cdf.dlm) 					P Epoch:input  Year:output [Month:output] [Day:output] [Hour:output] [Minute:output] [Second:output] [Milli:output] [Micro:output] [Nano:output] /BREAKDOWN_EPOCH:input /TOINTEGER:input",			$
	"CDF_TT2000+2						(SYSTEM/idl_cdf.dlm) 					P Epoch:output Year:input  [Month:input]  [Day:input]  [Hour:input]  [Minute:input]  [Second:input]  [Milli:input]  [Micro:input]  [Nano:input]  /COMPUTE_EPOCH:input",			$
	"CDF_VARDELETE						(SYSTEM/idl_cdf.dlm) 					P Id:input Variable:input /ZVARIABLE", $
	"CDF_VARGET						(SYSTEM/idl_cdf.dlm) 					P Id:input Variable:input Value:output /COUNT:input /INTERVAL:input /OFFSET:input /REC_COUNT:input /REC_INTERVAL:input /REC_START:input /STRING /TO_COLUMN_MAJOR /ZVARIABLE", $
	"CDF_VARGET1						(SYSTEM/idl_cdf.dlm) 					P Id:input Variable:input Value:output /OFFSET:input /REC_START:input /STRING /ZVARIABLE", $
	"CDF_VARPUT						(SYSTEM/idl_cdf.dlm) 					P Id:input Variable:input Value:input /COUNT:input /INTERVAL:input /OFFSET:input /REC_INTERVAL:input /REC_START:input /ZVARIABLE", $
	"CDF_VARRENAME						(SYSTEM/idl_cdf.dlm) 					P Id:input OldVariable:input NewName:input /ZVARIABLE", $


	; idl_geopack.dlm
	; ---------------
	; GEOPACK v9.2
	; voir "http://ampere.jhuapl.edu/code/idl_geopack.html"
	; voir "GEOPACK.pdf"
	"GEOPACK_RECALC+1					(SYSTEM/idl_geopack.dlm)				P year:input doy:input   hour:input min:input  sec:input	               /TILT:output",			$
	"GEOPACK_RECALC+2					(SYSTEM/idl_geopack.dlm) 				P year:input month:input day:input  hour:input min:input sec:input /DATE:input /TILT:output",			$
	"GEOPACK_RECALC_08+1					(SYSTEM/idl_geopack.dlm) 				P year:input doy:input   hour:input min:input  sec:input	               /TILT:output /VGSE:input",			$
	"GEOPACK_RECALC_08+2					(SYSTEM/idl_geopack.dlm)				P year:input month:input day:input  hour:input min:input sec:input /DATE:input /TILT:output /VGSE:input",			$
	"GEOPACK_IGRF_GEO					(SYSTEM/idl_geopack.dlm) 				P r:input theta:input phi:input br:output btheta:output bphi:output /DEGREE:input /EPOCH:input",				$
	"GEOPACK_IGRF_GEO_08					(SYSTEM/idl_geopack.dlm) 				P r:input theta:input phi:input br:output btheta:output bphi:output /DEGREE:input /EPOCH:input",				$
	"GEOPACK_DIP						(SYSTEM/idl_geopack.dlm) 				P x:input y:input z:input bx:output by:output bz:output /TILT:input /EPOCH:input",				$
	"GEOPACK_DIP_08						(SYSTEM/idl_geopack.dlm) 				P x:input y:input z:input bx:output by:output bz:output /TILT:input /EPOCH:input",				$
	"GEOPACK_IGRF_GSM					(SYSTEM/idl_geopack.dlm) 				P x:input y:input z:input bx:output by:output bz:output /EPOCH:input",						$
	"GEOPACK_IGRF_GSW_08					(SYSTEM/idl_geopack.dlm) 				P x:input y:input z:input bx:output by:output bz:output /EPOCH:input",						$
	"GEOPACK_SPHCAR+1					(SYSTEM/idl_geopack.dlm) 				P r:input theta:input phi:input x:output y:output     z:output    /TO_RECT:input   /DEGREE:input",	$
	"GEOPACK_SPHCAR+2					(SYSTEM/idl_geopack.dlm) 				P x:input y:input     z:input   r:output theta:output phi:output /TO_SPHERE:input /DEGREE:input",	$
	"GEOPACK_SPHCAR_08+1					(SYSTEM/idl_geopack.dlm) 				P r:input theta:input phi:input x:output y:output     z:output   /TO_RECT:input   /DEGREE:input",	$
	"GEOPACK_SPHCAR_08+2					(SYSTEM/idl_geopack.dlm) 				P r:input y:input     z:input   r:output theta:output phi:output /TO_SPHERE:input /DEGREE:input",	$
	"GEOPACK_BSPCAR						(SYSTEM/idl_geopack.dlm) 				P theta:input phi:input br:input btheta:input bphi:input bx:output by:output bz:output /DEGREE:input",				$
	"GEOPACK_BSPCAR_08					(SYSTEM/idl_geopack.dlm) 				P theta:input phi:input br:input btheta:input bphi:input bx:output by:output bz:output /DEGREE:input",				$
	"GEOPACK_BCARSP						(SYSTEM/idl_geopack.dlm) 				P x:input y:input z:input bx:input by:input bz:input br:output btheta:output bphi:output",					$
	"GEOPACK_BCARSP_08					(SYSTEM/idl_geopack.dlm) 				P x:input y:input z:input bx:input by:input bz:input br:output btheta:output bphi:output",					$
	"GEOPACK_CONV_COORD					(SYSTEM/idl_geopack.dlm) 				P s1:input s2:input s3:input d1:output d2:output d3:output /FROM_GEO:input /FROM_MAG:input /FROM_GEI:input /FROM_SM:input /FROM_GSM:input /FROM_GSE:input /TO_GEO:input /TO_MAG:input /TO_GEI:input /TO_SM:input /TO_GSM:input /TO_GSE:input /EPOCH:input",					$
	"GEOPACK_TRACE						(SYSTEM/idl_geopack.dlm) 				P xi:input yi:input zi:input dir:input par:input xf:output yf:output zf:output /R0:input /RLIM:input /FLINE:output /TILT:input /IGRF:input /T89:input /T96:input /T01:input /TS04:input /STORM:input /NOBOUNDARY:input /IOPGEN:input /IOPT:input /IOPB:input /IOPR:input /REFINE:input /EQUATOR:input /IONOSPHERE:input /EPOCH:input",	$
	"GEOPACK_TRACE_08					(SYSTEM/idl_geopack.dlm) 				P xi:input yi:input zi:input dir:input par:input xf:output yf:output zf:output /R0:input /RLIM:input /FLINE:output /TILT:input /IGRF:input /T89:input /T96:input /T01:input /TS04:input /STORM:input /NOBOUNDARY:input /IOPGEN:input /IOPT:input /IOPB:input /IOPR:input /REFINE:input /EQUATOR:input /IONOSPHERE:input /EPOCH:input /DSMAX:input /ERR:input",	$
	"GEOPACK_T96_MGNP					(SYSTEM/idl_geopack.dlm) 				P xn_pd:input vel:input x_gsm:input y_gsm:input z_gsm:input x_mgnp:output y_mgnp:output z_mgnp:output dist:output id:output",								$
	"GEOPACK_T96_MGNP_08					(SYSTEM/idl_geopack.dlm) 				P xn_pd:input vel:input x_gsm:input y_gsm:input z_gsm:input x_mgnp:output y_mgnp:output z_mgnp:output dist:output id:output",								$
	"GEOPACK_SHUETAL_MGNP					(SYSTEM/idl_geopack.dlm) 				P xn_pd:input vel:input bzimf:input x_gsm:input y_gsm:input z_gsm:input x_mgnp:output y_mgnp:output z_mgnp:output dist:output id:output",							$
	"GEOPACK_SHUETAL_MGNP_08				(SYSTEM/idl_geopack.dlm) 				P xn_pd:input vel:input bzimf:input x_gsm:input y_gsm:input z_gsm:input x_mgnp:output y_mgnp:output z_mgnp:output dist:output id:output",							$
	"GEOPACK_T89						(SYSTEM/idl_geopack.dlm) 				P iopt:input x:input y:input z:input bx:output by:output bz:output /TILT:input /EPOCH:input",							$
	"GEOPACK_T96						(SYSTEM/idl_geopack.dlm) 				P parmod:input x:input y:input z:input bx:output by:output bz:output /TILT:input /EPOCH:input",							$
	"GEOPACK_T01						(SYSTEM/idl_geopack.dlm) 				P parmod:input x:input y:input z:input bx:output by:output bz:output /TILT:input /STORM:input /EPOCH:input",						$
	"GEOPACK_TS04						(SYSTEM/idl_geopack.dlm) 				P parmod:input x:input y:input z:input bx:output by:output bz:output /TILT:input /IOPGEN:input /IOPT:input /IOPB:input /IOPR:input /EPOCH:input",	$
	"GEOPACK_GETG						(SYSTEM/idl_geopack.dlm) 				P vsw:input by:input bz:input g:output /STORM:input",												$
	"GEOPACK_GETW						(SYSTEM/idl_geopack.dlm) 				P nsw:input vsw:input bz:input w:output",														$
	"GEOPACK_EPOCH+1					(SYSTEM/idl_geopack.dlm) 				P epoch:input  year:output [month:output] [day:output] [hour:output] [min:output] [sec:output] [msec:output] /BREAKDOWN_EPOCH:input",		$
	"GEOPACK_EPOCH+2					(SYSTEM/idl_geopack.dlm) 				P epoch:output year:input  [month:input]  [day:input]  [hour:input]  [min:input]  [sec:input]  [msec:input]  /COMPUTE_EPOCH:input",		$
	"GEOPACK_T96_MGNP					(SYSTEM/idl_geopack.dlm) 				P xn_pd:input vel:input x_gsm:input y_gsm:input z_gsm:input x_mgnp:output y_mgnp:output z_mgnp:output dist:output id:output",				$


	; icy.dlm
	; -------
	; SPICELIB
	; voir "http://naif.jpl.nasa.gov/pub/naif/toolkit_docs/IDL/icy/index.html"
	; voir routine get_cspice_prototypes
	"CSPICE_APPNDD                         	  		(SYSTEM/icy.dlm)					P item:input CELL:output", $
	"CSPICE_APPNDI                           		(SYSTEM/icy.dlm)					P item:input CELL:output", $
	"CSPICE_AXISAR                           		(SYSTEM/icy.dlm)					P axis:input angle:input R:output", $
	"CSPICE_B1900                            		(SYSTEM/icy.dlm)					F", $
	"CSPICE_B1950                            		(SYSTEM/icy.dlm)					F", $
	"CSPICE_BADKPV                           		(SYSTEM/icy.dlm)					P caller:input name:input comp:input size:input divby:input type:input", $
	"CSPICE_BODC2N                           		(SYSTEM/icy.dlm)					P code:input NAME:output FOUND:output", $
	"CSPICE_BODC2S                           		(SYSTEM/icy.dlm)					P code:input NAME:output", $
	"CSPICE_BODDEF                           		(SYSTEM/icy.dlm)					P name:input code:input", $
	"CSPICE_BODFND                           		(SYSTEM/icy.dlm)					F body:input item:input", $
	"CSPICE_BODN2C                           		(SYSTEM/icy.dlm)					P name:input CODE:output FOUND:output", $
	"CSPICE_BODS2C                           		(SYSTEM/icy.dlm)					P name:input CODE:output FOUND:output", $
	"CSPICE_BODVAR                           		(SYSTEM/icy.dlm)					P body:input item:input VALUES:output", $
	"CSPICE_BODVCD                           		(SYSTEM/icy.dlm)					P bodyid:input item:input maxn:input VALUES:output", $
	"CSPICE_BODVRD                           		(SYSTEM/icy.dlm)					P bodynm:input item:input maxn:input VALUES:output", $
	"CSPICE_BRCKTD                           		(SYSTEM/icy.dlm)					F number:input end1:input end2:input", $
	"CSPICE_BRCKTI                           		(SYSTEM/icy.dlm)					F number:input end1:input end2:input", $
	"CSPICE_CARD                             		(SYSTEM/icy.dlm)					F cell:input", $
	"CSPICE_CELLD                            		(SYSTEM/icy.dlm)					F size:input", $
	"CSPICE_CELLI                            		(SYSTEM/icy.dlm)					F size:input", $
	"CSPICE_CGV2EL                           		(SYSTEM/icy.dlm)					P center:input vec1:input vec2:input ELLIPSE:output", $
	"CSPICE_CIDFRM                           		(SYSTEM/icy.dlm)					P cent:input FRCODE:output FRNAME:output FOUND:output", $
	"CSPICE_CKCLS                            		(SYSTEM/icy.dlm)					P handle:input", $
	"CSPICE_CKCOV                            		(SYSTEM/icy.dlm)					P ck:input needav:input level:input tol:input timsys:input idcode:input COVER:output", $
	"CSPICE_CKGP                             		(SYSTEM/icy.dlm)					P inst:input sclkdp:input tol:input ref:input CMAT:output CLKOUT:output FOUND:output", $
	"CSPICE_CKGPAV                           		(SYSTEM/icy.dlm)					P inst:input sclkdp:input tol:input ref:input CMAT:output AV:output CLKOUT:output FOUND:output", $
	"CSPICE_CKLPF                            		(SYSTEM/icy.dlm)					P fname:input HANDLE:output", $
	"CSPICE_CKOBJ                            		(SYSTEM/icy.dlm)					P ck:input IDS:output", $
	"CSPICE_CKOPN                            		(SYSTEM/icy.dlm)					P name:input ifname:input ncomch:input HANDLE:output", $
	"CSPICE_CKUPF                            		(SYSTEM/icy.dlm)					P handle:input", $
	"CSPICE_CKW01                            		(SYSTEM/icy.dlm)					P handle:input begtime:input endtime:input inst:input ref:input avflag:input segid:input sclkdp:input quats:input avvs:input", $
	"CSPICE_CKW02                            		(SYSTEM/icy.dlm)					P handle:input begtim:input endtim:input inst:input ref:input segid:input start:input stop:input quats:input avvs:input rates:input", $
	"CSPICE_CKW03                            		(SYSTEM/icy.dlm)					P handle:input begtim:input endtim:input inst:input ref:input avflag:input segid:input sclkdp:input quats:input avvs:input starts:input", $
	"CSPICE_CLIGHT                           		(SYSTEM/icy.dlm)					F", $
	"CSPICE_CLPOO                            		(SYSTEM/icy.dlm)					P", $
	"CSPICE_CMPRSS                           		(SYSTEM/icy.dlm)					P delim:input n:input input:input OUTPUT:output", $
	"CSPICE_CNMFRM                           		(SYSTEM/icy.dlm)					P cname:input FRCODE:output FRNAME:output FOUND:output", $
	"CSPICE_CONICS                           		(SYSTEM/icy.dlm)					P elts:input et:input STATE:output", $
	"CSPICE_CONVRT                           		(SYSTEM/icy.dlm)					P x:input in:input out:input Y:output", $
	"CSPICE_CYLLAT                           		(SYSTEM/icy.dlm)					P r:input lonc:input z:input RADIUS:output LON:output LAT:output", $
	"CSPICE_CYLREC                           		(SYSTEM/icy.dlm)					P r:input lonc:input z:input RECTAN:output", $
	"CSPICE_CYLSPH                           		(SYSTEM/icy.dlm)					P r:input lonc:input z:input RADIUS:output COLAT:output LON:output", $
	"CSPICE_DAFAC                            		(SYSTEM/icy.dlm)					P handle:input length:input buffer:input", $
	"CSPICE_DAFBBS                           		(SYSTEM/icy.dlm)					P handle:input", $
	"CSPICE_DAFBFS                           		(SYSTEM/icy.dlm)					P handle:input", $
	"CSPICE_DAFCLS                           		(SYSTEM/icy.dlm)					P handle:input", $
	"CSPICE_DAFCS                            		(SYSTEM/icy.dlm)					P handle:input", $
	"CSPICE_DAFDC                            		(SYSTEM/icy.dlm)					P handle:input", $
	"CSPICE_DAFEC                            		(SYSTEM/icy.dlm)					P handle:input bufsiz:input lenout:input N:output BUFFER:output DONE:output", $
	"CSPICE_DAFFNA                           		(SYSTEM/icy.dlm)					P FOUND:output", $
	"CSPICE_DAFFPA                           		(SYSTEM/icy.dlm)					P FOUND:output", $
	"CSPICE_DAFGDA                           		(SYSTEM/icy.dlm)					P handle:input begin:input end:input DATA:output", $
	"CSPICE_DAFGN                            		(SYSTEM/icy.dlm)					P NAME:output", $
	"CSPICE_DAFGS                            		(SYSTEM/icy.dlm)					P nd:input ni:input DC:output IC:output", $
	"CSPICE_DAFOPR                           		(SYSTEM/icy.dlm)					P fname:input HANDLE:output", $
	"CSPICE_DAFOPW                           		(SYSTEM/icy.dlm)					P fname:input HANDLE:output", $
	"CSPICE_DAFRS                            		(SYSTEM/icy.dlm)					P nd:input ni:input dc:input ic:input", $
	"CSPICE_DELTET                           		(SYSTEM/icy.dlm)					P epoch:input eptype:input DELTA:output", $
	"CSPICE_DET                              		(SYSTEM/icy.dlm)					F m1:input", $
	"CSPICE_DIAGS2                           		(SYSTEM/icy.dlm)					P symmat:input DIAG:output ROTATE:output", $
	"CSPICE_DIFF                             		(SYSTEM/icy.dlm)					P a:input b:input C:output", $
	"CSPICE_DP2HX                            		(SYSTEM/icy.dlm)					P number:input STRING:output", $
	"CSPICE_DPMAX                            		(SYSTEM/icy.dlm)					F", $
	"CSPICE_DPMIN                            		(SYSTEM/icy.dlm)					F", $
	"CSPICE_DPR                              		(SYSTEM/icy.dlm)					F", $
	"CSPICE_DTPOOL                           		(SYSTEM/icy.dlm)					P name:input FOUND:output N:output TYPE:output", $
	"CSPICE_DUCRSS                           		(SYSTEM/icy.dlm)					P s1:input s2:input SOUT:output", $
	"CSPICE_DVCRSS                           		(SYSTEM/icy.dlm)					P s1:input s2:input SOUT:output", $
	"CSPICE_DVDOT                            		(SYSTEM/icy.dlm)					F s1:input s2:input", $
	"CSPICE_DVHAT                            		(SYSTEM/icy.dlm)					P s1:input SOUT:output", $
	"CSPICE_DVNORM                           		(SYSTEM/icy.dlm)					F state:input", $
	"CSPICE_DVPOOL                           		(SYSTEM/icy.dlm)					P name:input", $
	"CSPICE_DVSEP                            		(SYSTEM/icy.dlm)					F s1:input s2:input", $
	"CSPICE_EDLIMB                           		(SYSTEM/icy.dlm)					P a:input b:input c:input viewpt:input LIMB:output", $
	"CSPICE_EKACEC                           		(SYSTEM/icy.dlm)					P handle:input segno:input recno:input column:input nvals:input cvals_len:input cvals:input isnull:input", $
	"CSPICE_EKACED                           		(SYSTEM/icy.dlm)					P handle:input segno:input recno:input column:input nvals:input dvals:input isnull:input", $
	"CSPICE_EKACEI                           		(SYSTEM/icy.dlm)					P handle:input segno:input recno:input column:input nvals:input ivals:input isnull:input", $
	"CSPICE_EKACLC                           		(SYSTEM/icy.dlm)					P handle:input segno:input column:input vallen:input cvals:input entszs:input nlflgs:input rcptrs:input WKINDX:output", $
	"CSPICE_EKACLD                           		(SYSTEM/icy.dlm)					P handle:input segno:input column:input dvals:input entszs:input nlflgs:input rcptrs:input WKINDX:output", $
	"CSPICE_EKACLI                           		(SYSTEM/icy.dlm)					P handle:input segno:input column:input ivals:input entszs:input nlflgs:input rcptrs:input WKINDX:output", $
	"CSPICE_EKAPPR                           		(SYSTEM/icy.dlm)					P handle:input segno:input RECNO:output", $
	"CSPICE_EKBSEG                           		(SYSTEM/icy.dlm)					P handle:input tabnam:input ncols:input cnames:input decls:input SEGNO:output", $
	"CSPICE_EKCCNT                           		(SYSTEM/icy.dlm)					P table:input CCOUNT:output", $
	"CSPICE_EKCII                            		(SYSTEM/icy.dlm)					P table:input cindex:input COLUMN:output ATTDSC:output", $
	"CSPICE_EKCLS                            		(SYSTEM/icy.dlm)					P handle:input", $
	"CSPICE_EKDELR                           		(SYSTEM/icy.dlm)					P handle:input segno:input recno:input", $
	"CSPICE_EKFFLD                           		(SYSTEM/icy.dlm)					P handle:input segno:input rcptrs:input", $
	"CSPICE_EKFIND                           		(SYSTEM/icy.dlm)					P query:input NMROWS:output ERROR:output ERRMSG:output", $
	"CSPICE_EKGC                             		(SYSTEM/icy.dlm)					P selidx:input row:input elment:input lenout:input CDATA:output NULL:output FOUND:output", $
	"CSPICE_EKGD                             		(SYSTEM/icy.dlm)					P selidx:input row:input elment:input DDATA:output NULL:output FOUND:output", $
	"CSPICE_EKGI                             		(SYSTEM/icy.dlm)					P selidx:input row:input elment:input IDATA:output NULL:output FOUND:output", $
	"CSPICE_EKIFLD                           		(SYSTEM/icy.dlm)					P handle:input tabnam:input ncols:input nrows:input cnames:input decls:input SEGNO:output RCPTRS:output", $
	"CSPICE_EKINSR                           		(SYSTEM/icy.dlm)					P handle:input segno:input recno:input", $
	"CSPICE_EKLEF                            		(SYSTEM/icy.dlm)					P fname:input HANDLE:output", $
	"CSPICE_EKNELT                           		(SYSTEM/icy.dlm)					F selidx:input row:input", $
	"CSPICE_EKNSEG                           		(SYSTEM/icy.dlm)					F handle:input", $
	"CSPICE_EKNTAB                           		(SYSTEM/icy.dlm)					P N:output", $
	"CSPICE_EKOPN                            		(SYSTEM/icy.dlm)					P fname:input ifname:input ncomch:input HANDLE:output", $
	"CSPICE_EKOPR                            		(SYSTEM/icy.dlm)					P fname:input HANDLE:output", $
	"CSPICE_EKOPS                            		(SYSTEM/icy.dlm)					P HANDLE:output", $
	"CSPICE_EKOPW                            		(SYSTEM/icy.dlm)					P fname:input HANDLE:output", $
	"CSPICE_EKPSEL                           		(SYSTEM/icy.dlm)					P query:input N:output XBEGS:output XENDS:output XTYPES:output XCLASS:output TABS:output COLS:output ERROR:output ERRMSG:output", $
	"CSPICE_EKRCEC                           		(SYSTEM/icy.dlm)					P handle:input segno:input recno:input column:input nelts:input cvals_len:input CVALS:output ISNULL:output", $
	"CSPICE_EKRCED                           		(SYSTEM/icy.dlm)					P handle:input segno:input recno:input column:input nelts:input DVALS:output ISNULL:output", $
	"CSPICE_EKRCEI                           		(SYSTEM/icy.dlm)					P handle:input segno:input recno:input column:input nelts:input IVALS:output ISNULL:output", $
	"CSPICE_EKSSUM                           		(SYSTEM/icy.dlm)					P handle:input segno:input NROWS:output NCOLS:output TABNAM:output CNAMES:output CCLASS:output DTYPE:output SIZES:output STRLEN:output INDEXD:output NULLOK:output", $
	"CSPICE_EKTNAM                           		(SYSTEM/icy.dlm)					P n:input TABLE:output", $
	"CSPICE_EKUCEC                           		(SYSTEM/icy.dlm)					P handle:input segno:input recno:input column:input nvals:input cvals_len:input cvals:input isnull:input", $
	"CSPICE_EKUCED                           		(SYSTEM/icy.dlm)					P handle:input segno:input recno:input column:input nvals:input dvals:input isnull:input", $
	"CSPICE_EKUCEI                           		(SYSTEM/icy.dlm)					P handle:input segno:input recno:input column:input nvals:input ivals:input isnull:input", $
	"CSPICE_EKUEF                            		(SYSTEM/icy.dlm)					P handle:input", $
	"CSPICE_EL2CGV                           		(SYSTEM/icy.dlm)					P ellipse:input CENTER:output SMAJOR:output SMINOR:output", $
	"CSPICE_EQSTR                            		(SYSTEM/icy.dlm)					F a:input b:input", $
	"CSPICE_ET2LST                           		(SYSTEM/icy.dlm)					P et:input body:input lon:input type:input HR:output MN:output SC:output `TIME`:output `AMPM`:output", $
	"CSPICE_ET2UTC                           		(SYSTEM/icy.dlm)					P et:input format:input prec:input `UTCSTR`:output", $
	"CSPICE_ETCAL                            		(SYSTEM/icy.dlm)					P et:input `STRING`:output", $
	"CSPICE_EUL2M                            		(SYSTEM/icy.dlm)					P angle3:input angle2:input angle1:input axis3:input axis2:input axis1:input R:output", $
	"CSPICE_EUL2XF                           		(SYSTEM/icy.dlm)					P eulang:input axisa:input axisb:input axisc:input XFORM:output", $
	"CSPICE_EXISTS                           		(SYSTEM/icy.dlm)					F name:input", $
	"CSPICE_EXPOOL                           		(SYSTEM/icy.dlm)					P name:input FOUND:output", $
	"CSPICE_FRAME                            		(SYSTEM/icy.dlm)					P X:output Y:output Z:output", $
	"CSPICE_FRINFO                           		(SYSTEM/icy.dlm)					P frcode:input CENT:output CLSS:output CLSSID:output FOUND:output", $
	"CSPICE_FRMNAM                           		(SYSTEM/icy.dlm)					P frcode:input FRNAME:output", $
	"CSPICE_FURNSH                           		(SYSTEM/icy.dlm)					P file:input", $
	"CSPICE_GCPOOL                           		(SYSTEM/icy.dlm)					P name:input start:input room:input length:input CVALS:output FOUND:output", $
	"CSPICE_GDPOOL                           		(SYSTEM/icy.dlm)					P name:input start:input room:input VALUES:output FOUND:output", $
	"CSPICE_GEOREC                           		(SYSTEM/icy.dlm)					P lon:input lat:input alt:input re:input f:input RECTAN:output", $
	"CSPICE_GETELM                           		(SYSTEM/icy.dlm)					P frstyr:input lines:input EPOCH:output ELEMS:output", $
	"CSPICE_GETFAT                           		(SYSTEM/icy.dlm)					P file:input ARCH:output TYPE:output", $
	"CSPICE_GETFOV                           		(SYSTEM/icy.dlm)					P instid:input room:input SHAPE:output FRAME:output BSIGHT:output BOUNDS:output", $
	"CSPICE_GFDIST                           		(SYSTEM/icy.dlm)					P target:input abcorr:input obsrvr:input relate:input refval:input adjust:input step:input nintvls:input cnfine:input RESULT:output", $
	"CSPICE_GFOCLT                           		(SYSTEM/icy.dlm)					P occtyp:input front:input fshape:input fframe:input back:input bshape:input bframe:input abcorr:input obsrvr:input step:input cnfine:input RESULT:output", $
	"CSPICE_GFPOSC                           		(SYSTEM/icy.dlm)					P target:input frame:input abcorr:input obsrvr:input crdsys:input coord:input relate:input refval:input adjust:input step:input nintvls:input cnfine:input RESULT:output", $
	"CSPICE_GFRFOV                           		(SYSTEM/icy.dlm)					P inst:input raydir:input rframe:input abcorr:input obsrvr:input step:input cnfine:input RESULT:output", $
	"CSPICE_GFRR                             		(SYSTEM/icy.dlm)					P target:input abcorr:input obsrvr:input relate:input refval:input adjust:input step:input nintvls:input cnfine:input RESULT:output", $
	"CSPICE_GFSEP                            		(SYSTEM/icy.dlm)					P targ1:input shape1:input frame1:input targ2:input shape2:input frame2:input abcorr:input obsrvr:input relate:input refval:input adjust:input step:input nintvls:input cnfine:input RESULT:output", $
	"CSPICE_GFSNTC                           		(SYSTEM/icy.dlm)					P target:input fixref:input method:input abcorr:input obsrvr:input dref:input dvec:input crdsys:input coord:input relate:input refval:input adjust:input step:input nintvls:input cnfine:input RESULT:output", $
	"CSPICE_GFSUBC                           		(SYSTEM/icy.dlm)					P target:input fixref:input method:input abcorr:input obsrvr:input crdsys:input coord:input relate:input refval:input adjust:input step:input nintvls:input cnfine:input RESULT:output", $
	"CSPICE_GFTFOV                           		(SYSTEM/icy.dlm)					P inst:input target:input tshape:input tframe:input abcorr:input obsrvr:input step:input cnfine:input RESULT:output", $
	"CSPICE_GIPOOL                           		(SYSTEM/icy.dlm)					P name:input start:input room:input IVALS:output FOUND:output", $
	"CSPICE_GNPOOL                           		(SYSTEM/icy.dlm)					P name:input start:input room:input length:input KVARS:output FOUND:output", $
	"CSPICE_HALFPI                           		(SYSTEM/icy.dlm)					F", $
	"CSPICE_HX2DP                            		(SYSTEM/icy.dlm)					P string:input NUMBER:output ERROR:output ERRMSG:output", $
	"CSPICE_IDENT                            		(SYSTEM/icy.dlm)					P MATRIX:output", $
	"CSPICE_ILLUM                            		(SYSTEM/icy.dlm)					P target:input et:input abcorr:input obsrvr:input spoint:input PHASE:output SOLAR:output EMISSN:output", $
	"CSPICE_ILUMIN                           		(SYSTEM/icy.dlm)					P method:input target:input et:input fixref:input abcorr:input obsrvr:input spoint:input TRGEPC:output SRFVEC:output PHASE:output SOLAR:output EMISSN:output", $
	"CSPICE_INEDPL                           		(SYSTEM/icy.dlm)					P a:input b:input c:input plane:input ELLIPSE:output FOUND:output", $
	"CSPICE_INELPL                           		(SYSTEM/icy.dlm)					P ellips:input plane:input NXPTS:output XPT1:output XPT2:output", $
	"CSPICE_INRYPL                           		(SYSTEM/icy.dlm)					P vertex:input dir:input plane:input NXPTS:output XPT:output", $
	"CSPICE_INSRTD                           		(SYSTEM/icy.dlm)					P item:input SET:output", $
	"CSPICE_INSRTI                           		(SYSTEM/icy.dlm)					P item:input SET:output", $
	"CSPICE_INTER                            		(SYSTEM/icy.dlm)					P a:input b:input C:output", $
	"CSPICE_INTMAX                           		(SYSTEM/icy.dlm)					F", $
	"CSPICE_INTMIN                           		(SYSTEM/icy.dlm)					F", $
	"CSPICE_INVERT                           		(SYSTEM/icy.dlm)					P m1:input M2:output", $
	"CSPICE_ISROT                            		(SYSTEM/icy.dlm)					F m:input ntol:input dtol:input", $
	"CSPICE_ISWHSP                           		(SYSTEM/icy.dlm)					F STRING:output", $
	"CSPICE_J1900                            		(SYSTEM/icy.dlm)					F", $
	"CSPICE_J1950                            		(SYSTEM/icy.dlm)					F", $
	"CSPICE_J2000                            		(SYSTEM/icy.dlm)					F", $
	"CSPICE_J2100                            		(SYSTEM/icy.dlm)					F", $
	"CSPICE_JYEAR                            		(SYSTEM/icy.dlm)					F", $
	"CSPICE_KCLEA                            		(SYSTEM/icy.dlm)					P", $
	"CSPICE_KDATA                            		(SYSTEM/icy.dlm)					P which:input kind:input FILE:output FILTYP:output SOURCE:output HANDLE:output FOUND:output", $
	"CSPICE_KINFO                            		(SYSTEM/icy.dlm)					P file:input FILTYP:output SOURCE:output HANDLE:output FOUND:output", $
	"CSPICE_KTOTAL                           		(SYSTEM/icy.dlm)					P kind:input COUNT:output", $
	"CSPICE_LASTNB                           		(SYSTEM/icy.dlm)					F STRING:output", $
	"CSPICE_LATCYL                           		(SYSTEM/icy.dlm)					P radius:input lon:input lat:input R:output LONC:output Z:output", $
	"CSPICE_LATREC                           		(SYSTEM/icy.dlm)					P radius:input longitude:input latitude:input RECTAN:output", $
	"CSPICE_LATSPH                           		(SYSTEM/icy.dlm)					P radius:input lon:input lat:input RHO:output COLAT:output LONS:output", $
	"CSPICE_LCASE                            		(SYSTEM/icy.dlm)					P in:input OUT:output", $
	"CSPICE_LDPOOL                           		(SYSTEM/icy.dlm)					P filename:input", $
	"CSPICE_LMPOOL                           		(SYSTEM/icy.dlm)					P length:input cvals:input", $
	"CSPICE_LPARSE                           		(SYSTEM/icy.dlm)					P list:input delim:input n_max:input ITEMS:output", $
	"CSPICE_LSPCN                            		(SYSTEM/icy.dlm)					F body:input et:input abcorr:input", $
	"CSPICE_LTIME                            		(SYSTEM/icy.dlm)					P etobs:input obs:input dir:input targ:input ETTARG:output ELAPSD:output", $
	"CSPICE_M2EUL                            		(SYSTEM/icy.dlm)					P r:input axis3:input axis2:input axis1:input ANGLE3:output ANGLE2:output ANGLE1:output", $
	"CSPICE_M2Q                              		(SYSTEM/icy.dlm)					P r:input Q:output", $
	"CSPICE_MATCHI                           		(SYSTEM/icy.dlm)					F string:input templ:input wstr:input wchr:input", $
	"CSPICE_MATCHW                           		(SYSTEM/icy.dlm)					F string:input templ:input wstr:input wchr:input", $
	"CSPICE_MEQU                             		(SYSTEM/icy.dlm)					P m1:input MOUT:output", $
	"CSPICE_MTXM                             		(SYSTEM/icy.dlm)					P m1:input m2:input MOUT:output", $
	"CSPICE_MTXV                             		(SYSTEM/icy.dlm)					P m1:input vin:input VOUT:output", $
	"CSPICE_MXM                              		(SYSTEM/icy.dlm)					P m1:input m2:input MOUT:output", $
	"CSPICE_MXMT                             		(SYSTEM/icy.dlm)					P m1:input m2:input MOUT:output", $
	"CSPICE_MXV                              		(SYSTEM/icy.dlm)					P m1:input vin:input VOUT:output", $
	"CSPICE_NAMFRM                           		(SYSTEM/icy.dlm)					P frname:input FRCODE:output", $
	"CSPICE_NEARPT                           		(SYSTEM/icy.dlm)					P positn:input a:input b:input c:input NPOINT:output ALT:output", $
	"CSPICE_NPEDLN                           		(SYSTEM/icy.dlm)					P a:input b:input c:input linept:input linedr:input PNEAR:output DIST:output", $
	"CSPICE_NPELPT                           		(SYSTEM/icy.dlm)					P point:input ellips:input PNEAR:output DIST:output", $
	"CSPICE_NPLNPT                           		(SYSTEM/icy.dlm)					P linpt:input lindir:input point:input PNEAR:output DIST:output", $
	"CSPICE_NVC2PL                           		(SYSTEM/icy.dlm)					P normal:input constant:input PLANE:output", $
	"CSPICE_NVP2PL                           		(SYSTEM/icy.dlm)					P normal:input point:input PLANE:output", $
	"CSPICE_OSCELT                           		(SYSTEM/icy.dlm)					P state:input et:input mu:input ELTS:output", $
	"CSPICE_PCKLOF                           		(SYSTEM/icy.dlm)					P fname:input HANDLE:output", $
	"CSPICE_PCKUOF                           		(SYSTEM/icy.dlm)					P handle:input", $
	"CSPICE_PCPOOL                           		(SYSTEM/icy.dlm)					P name:input length:input cvals:input", $
	"CSPICE_PDPOOL                           		(SYSTEM/icy.dlm)					P name:input dvals:input", $
	"CSPICE_PGRREC                           		(SYSTEM/icy.dlm)					P body:input lon:input lat:input alt:input re:input f:input RECTAN:output", $
	"CSPICE_PI                               		(SYSTEM/icy.dlm)					F", $
	"CSPICE_PIPOOL                           		(SYSTEM/icy.dlm)					P name:input ivals:input", $
	"CSPICE_PJELPL                           		(SYSTEM/icy.dlm)					P elin:input plane:input ELOUT:output", $
	"CSPICE_PL2NVC                           		(SYSTEM/icy.dlm)					P plane:input NORMAL:output CONSTANT:output", $
	"CSPICE_PL2NVP                           		(SYSTEM/icy.dlm)					P plane:input NORMAL:output POINT:output", $
	"CSPICE_PL2PSV                           		(SYSTEM/icy.dlm)					P plane:input POINT:output SPAN1:output SPAN2:output", $
	"CSPICE_PROP2B                           		(SYSTEM/icy.dlm)					P gm:input pvinit:input dt:input PVPROP:output", $
	"CSPICE_PRSDP                            		(SYSTEM/icy.dlm)					P string:input DPVAL:output", $
	"CSPICE_PRSINT                           		(SYSTEM/icy.dlm)					P string:input INTVAL:output", $
	"CSPICE_PSV2PL                           		(SYSTEM/icy.dlm)					P point:input span1:input span2:input PLANE:output", $
	"CSPICE_PXFORM                           		(SYSTEM/icy.dlm)					P from:input to:input et:input ROTATE:output", $
	"CSPICE_Q2M                              		(SYSTEM/icy.dlm)					P q:input R:output", $
	"CSPICE_QDQ2AV                           		(SYSTEM/icy.dlm)					P q:input dq:input AV:output", $
	"CSPICE_QXQ                              		(SYSTEM/icy.dlm)					P q1:input q2:input QOUT:output", $
	"CSPICE_RADREC                           		(SYSTEM/icy.dlm)					P range:input ra:input dec:input RECTAN:output", $
	"CSPICE_RAV2XF                           		(SYSTEM/icy.dlm)					P rot:input av:input XFORM:output", $
	"CSPICE_RAXISA                           		(SYSTEM/icy.dlm)					P matrix:input AXIS:output ANGLE:output", $
	"CSPICE_RECCYL                           		(SYSTEM/icy.dlm)					P rectan:input R:output LON:output Z:output", $
	"CSPICE_RECGEO                           		(SYSTEM/icy.dlm)					P rectan:input re:input f:input LON:output LAT:output ALT:output", $
	"CSPICE_RECLAT                           		(SYSTEM/icy.dlm)					P rectan:input RADIUS:output LONGITUDE:output LATITUDE:output", $
	"CSPICE_RECPGR                           		(SYSTEM/icy.dlm)					P body:input rectan:input re:input f:input LON:output LAT:output ALT:output", $
	"CSPICE_RECRAD                           		(SYSTEM/icy.dlm)					P rectan:input RADIUS:output RA:output DEC:output", $
	"CSPICE_RECSPH                           		(SYSTEM/icy.dlm)					P rectan:input R:output COLAT:output LON:output", $
	"CSPICE_REMOVD                           		(SYSTEM/icy.dlm)					P item:input SET:output", $
	"CSPICE_REMOVI                           		(SYSTEM/icy.dlm)					P item:input SET:output", $
	"CSPICE_ROTATE                           		(SYSTEM/icy.dlm)					P angle:input iaxis:input MOUT:output", $
	"CSPICE_ROTMAT                           		(SYSTEM/icy.dlm)					P m1:input angle:input iaxis:input MOUT:output", $
	"CSPICE_ROTVEC                           		(SYSTEM/icy.dlm)					P v1:input angle:input iaxis:input VOUT:output", $
	"CSPICE_RPD                              		(SYSTEM/icy.dlm)					F", $
	"CSPICE_RQUAD                            		(SYSTEM/icy.dlm)					P a:input b:input c:input ROOT1:output ROOT2:output", $
	"CSPICE_SAELGV                           		(SYSTEM/icy.dlm)					P vec1:input vec2:input SMAJOR:output SMINOR:output", $
	"CSPICE_SCARD                            		(SYSTEM/icy.dlm)					P card:input CELL:output", $
	"CSPICE_SCDECD                           		(SYSTEM/icy.dlm)					P sc:input sclkdp:input `SCLKCH`:output", $
	"CSPICE_SCE2C                            		(SYSTEM/icy.dlm)					P sc:input et:input SCLKDP:output", $
	"CSPICE_SCE2S                            		(SYSTEM/icy.dlm)					P sc:input et:input SCLKCH:output", $
	"CSPICE_SCE2T                            		(SYSTEM/icy.dlm)					P sc:input et:input SCLKDP:output", $
	"CSPICE_SCENCD                           		(SYSTEM/icy.dlm)					P sc:input `sclkch`:input SCLKDP:output", $
	"CSPICE_SCFMT                            		(SYSTEM/icy.dlm)					P sc:input ticks:input CLKSTR:output", $
	"CSPICE_SCPART                           		(SYSTEM/icy.dlm)					P sc:input PSTART:output PSTOP:output", $
	"CSPICE_SCS2E                            		(SYSTEM/icy.dlm)					P sc:input `sclkch`:input ET:output", $
	"CSPICE_SCT2E                            		(SYSTEM/icy.dlm)					P sc:input sclkdp:input ET:output", $
	"CSPICE_SCTIKS                           		(SYSTEM/icy.dlm)					P sc:input clkstr:input TICKS:output", $
	"CSPICE_SDIFF                            		(SYSTEM/icy.dlm)					P a:input b:input C:output", $
	"CSPICE_SET                              		(SYSTEM/icy.dlm)					F a:input op:input b):input", $
	"CSPICE_SINCPT                           		(SYSTEM/icy.dlm)					P method`,`target:input et:input fixref:input abcorr:input obsrvr:input dref:input dvec:input SPOINT:output TRGEPC:output SRFVEC:output FOUND:output", $
	"CSPICE_SIZE                             		(SYSTEM/icy.dlm)					F cell:input", $
	"CSPICE_SPD                              		(SYSTEM/icy.dlm)					F", $
	"CSPICE_SPHCYL                           		(SYSTEM/icy.dlm)					P radius:input colat:input slon:input R:output LON:output Z:output", $
	"CSPICE_SPHLAT                           		(SYSTEM/icy.dlm)					P r:input colat:input lons:input RADIUS:output LON:output LAT:output", $
	"CSPICE_SPHREC                           		(SYSTEM/icy.dlm)					P r:input colat:input lon:input RECTAN:output", $
	"CSPICE_SPK14A                           		(SYSTEM/icy.dlm)					P handle:input ncsets:input coeffs:input epochs:input", $
	"CSPICE_SPK14B                           		(SYSTEM/icy.dlm)					P handle:input segid:input body:input center:input frame:input first:input last:input chbdeg:input", $
	"CSPICE_SPK14E                           		(SYSTEM/icy.dlm)					P handle:input", $
	"CSPICE_SPKAPO                           		(SYSTEM/icy.dlm)					P targ:input et:input ref:input sobs:input abcorr:input PTARG:output LTIME:output", $
	"CSPICE_SPKAPP                           		(SYSTEM/icy.dlm)					P targ:input et:input ref:input sobs:input abcorr:input STARG:output LTIME:output", $
	"CSPICE_SPKCLS                           		(SYSTEM/icy.dlm)					P handle:input", $
	"CSPICE_SPKCOV                           		(SYSTEM/icy.dlm)					P spk:input idcode:input COVER:output", $
	"CSPICE_SPKEZ                            		(SYSTEM/icy.dlm)					P targ:input et:input ref:input abcorr:input obs:input STATE:output LTIME:output", $
	"CSPICE_SPKEZP                           		(SYSTEM/icy.dlm)					P targ:input et:input ref:input abcorr:input obs:input PTARG:output LTIME:output", $
	"CSPICE_SPKEZR                           		(SYSTEM/icy.dlm)					P targ:input et:input ref:input abcorr:input obs:input STARG:output LTIME:output", $
	"CSPICE_SPKGEO                           		(SYSTEM/icy.dlm)					P targ:input et:input ref:input obs:input STATE:output LTIME:output", $
	"CSPICE_SPKGPS                           		(SYSTEM/icy.dlm)					P targ:input et:input ref:input obs:input POS:output LTIME:output", $
	"CSPICE_SPKLEF                           		(SYSTEM/icy.dlm)					P filename:input HANDLE:output", $
	"CSPICE_SPKOBJ                           		(SYSTEM/icy.dlm)					P spk:input IDS:output", $
	"CSPICE_SPKOPA                           		(SYSTEM/icy.dlm)					P file:input HANDLE:output", $
	"CSPICE_SPKOPN                           		(SYSTEM/icy.dlm)					P name:input ifname:input ncomch:input HANDLE:output", $
	"CSPICE_SPKPOS                           		(SYSTEM/icy.dlm)					P targ:input et:input ref:input abcorr:input obs:input PTARG:output LTIME:output", $
	"CSPICE_SPKSSB                           		(SYSTEM/icy.dlm)					P targ:input et:input ref:input STARG:output", $
	"CSPICE_SPKUEF                           		(SYSTEM/icy.dlm)					P handle:input", $
	"CSPICE_SPKW02                           		(SYSTEM/icy.dlm)					P handle:input body:input center:input frame:input first:input last:input segid:input intlen:input n:input polydg:input cdata:input btime:input", $
	"CSPICE_SPKW03                           		(SYSTEM/icy.dlm)					P handle:input body:input center:input frame:input first:input last:input segid:input intlen:input n:input polydg:input cdata:input btime:input", $
	"CSPICE_SPKW05                           		(SYSTEM/icy.dlm)					P handle:input body:input center:input frame:input first:input last:input segid:input gm:input n:input states:input epochs:input", $
	"CSPICE_SPKW08                           		(SYSTEM/icy.dlm)					P handle:input body:input center:input frame:input first:input last:input segid:input degree:input n:input states:input epoch1:input step:input", $
	"CSPICE_SPKW09                           		(SYSTEM/icy.dlm)					P handle:input body:input center:input frame:input first:input last:input segid:input degree:input n:input states:input epochs:input", $
	"CSPICE_SPKW10                           		(SYSTEM/icy.dlm)					P handle:input body:input center:input frame:input first:input last:input segid:input consts:input n:input elems:input epochs:input", $
	"CSPICE_SPKW12                           		(SYSTEM/icy.dlm)					P handle:input body:input center:input frame:input first:input last:input segid:input degree:input n:input states:input epoch0:input step:input", $
	"CSPICE_SPKW13                           		(SYSTEM/icy.dlm)					P handle:input body:input center:input frame:input first:input last:input segid:input degree:input n:input states:input epochs:input", $
	"CSPICE_SRFREC                           		(SYSTEM/icy.dlm)					P body:input longitude:input latitude:input RECTAN:output", $
	"CSPICE_SRFXPT                           		(SYSTEM/icy.dlm)					P method:input target:input et:input abcorr:input obsrvr:input dref:input dvec:input SPOINT:output DIST:output TRGEPC:output OBSPOS:output FOUND:output", $
	"CSPICE_SSIZE                            		(SYSTEM/icy.dlm)					P size:input CELL:output", $
	"CSPICE_STELAB                           		(SYSTEM/icy.dlm)					P pobj:input vobs:input APPOBJ:output", $
	"CSPICE_STPOOL                           		(SYSTEM/icy.dlm)					P item:input nth:input contin:input STRING:output SIZE:output FOUND:output", $
	"CSPICE_STR2ET                           		(SYSTEM/icy.dlm)					P str:input ET:output", $
	"CSPICE_SUBPNT                           		(SYSTEM/icy.dlm)					P method:input target:input et:input fixref:input abcorr:input obsrvr:input SPOINT:output TRGEPC:output SRFVEC:output", $
	"CSPICE_SUBPT                            		(SYSTEM/icy.dlm)					P method:input target:input et:input abcorr:input obsrvr:input SPOINT:output ALT:output", $
	"CSPICE_SUBSLR                           		(SYSTEM/icy.dlm)					P method:input target:input et:input fixref:input abcorr:input obsrvr:input SPOINT:output TRGEPC:output SRFVEC:output", $
	"CSPICE_SUBSOL                           		(SYSTEM/icy.dlm)					P method:input target:input et:input abcorr:input obsrvr:input SPOINT:output", $
	"CSPICE_SUMAD                            		(SYSTEM/icy.dlm)					F array:input n:input", $
	"CSPICE_SUMAI                            		(SYSTEM/icy.dlm)					F array:input n:input", $
	"CSPICE_SURFNM                           		(SYSTEM/icy.dlm)					P a:input b:input c:input point:input NORMAL:output", $
	"CSPICE_SURFPT                           		(SYSTEM/icy.dlm)					P positn:input u:input a:input b:input c:input POINT:output FOUND:output", $
	"CSPICE_SXFORM                           		(SYSTEM/icy.dlm)					P from:input to:input et:input XFORM:output", $
	"CSPICE_SZPOOL                           		(SYSTEM/icy.dlm)					P name:input N:output FOUND:output", $
	"CSPICE_TIMDEF                           		(SYSTEM/icy.dlm)					P action:input item:input 		(SYSTEM/VALUE):output", $
	"CSPICE_TIMOUT                           		(SYSTEM/icy.dlm)					P et:input pictur:input lenout:input `OUTPUT`:output", $
	"CSPICE_TIPBOD                           		(SYSTEM/icy.dlm)					P ref:input body:input et:input TIPM:output", $
	"CSPICE_TISBOD                           		(SYSTEM/icy.dlm)					P ref:input body:input et:input TSIPM:output", $
	"CSPICE_TKVRSN                           		(SYSTEM/icy.dlm)					F item:input", $
	"CSPICE_TPARSE                           		(SYSTEM/icy.dlm)					P STRING:output SP2000:output ERRMSG:output", $
	"CSPICE_TPICTR                           		(SYSTEM/icy.dlm)					P sample:input lenout:input PICTUR:output OK:output ERROR:output", $
	"CSPICE_TRACE                            		(SYSTEM/icy.dlm)					F matrix:input", $
	"CSPICE_TSETYR                           		(SYSTEM/icy.dlm)					P year:input", $
	"CSPICE_TWOPI                            		(SYSTEM/icy.dlm)					F", $
	"CSPICE_TWOVEC                           		(SYSTEM/icy.dlm)					P axdef:input indexa:input plndef:input indexp:input MOUT:output", $
	"CSPICE_TYEAR                            		(SYSTEM/icy.dlm)					F", $
	"CSPICE_UCASE                            		(SYSTEM/icy.dlm)					P in:input OUT:output", $
	"CSPICE_UCRSS                            		(SYSTEM/icy.dlm)					P v1:input v2:input VOUT:output", $
	"CSPICE_UNION                            		(SYSTEM/icy.dlm)					P a:input b:input C:output", $
	"CSPICE_UNITIM                           		(SYSTEM/icy.dlm)					F epoch:input insys:input outsys:input", $
	"CSPICE_UNLOAD                           		(SYSTEM/icy.dlm)					P file:input", $
	"CSPICE_UNORM                            		(SYSTEM/icy.dlm)					P v1:input VOUT:output VMAG:output", $
	"CSPICE_UNORMG                           		(SYSTEM/icy.dlm)					P v1:input VOUT:output VMAG:output", $
	"CSPICE_UTC2ET                           		(SYSTEM/icy.dlm)					P utcstr:input ET:output", $
	"CSPICE_VADD                             		(SYSTEM/icy.dlm)					P v1:input v2:input VOUT:output", $
	"CSPICE_VADDG                            		(SYSTEM/icy.dlm)					P v1:input v2:input VOUT:output", $
	"CSPICE_VALID                            		(SYSTEM/icy.dlm)					P size:input n:input SET:output", $
	"CSPICE_VCRSS                            		(SYSTEM/icy.dlm)					P v1:input v2:input VOUT:output", $
	"CSPICE_VDIST                            		(SYSTEM/icy.dlm)					F v1:input v2:input", $
	"CSPICE_VDISTG                           		(SYSTEM/icy.dlm)					F v1:input v2:input", $
	"CSPICE_VDOT                             		(SYSTEM/icy.dlm)					F v1:input v2:input", $
	"CSPICE_VDOTG                            		(SYSTEM/icy.dlm)					F v1:input v2:input", $
	"CSPICE_VEQU                             		(SYSTEM/icy.dlm)					P vin:input VOUT:output", $
	"CSPICE_VEQUG                            		(SYSTEM/icy.dlm)					P vin:input VOUT:output", $
	"CSPICE_VHAT                             		(SYSTEM/icy.dlm)					P v1:input VOUT:output", $
	"CSPICE_VHATG                            		(SYSTEM/icy.dlm)					P v1:input VOUT:output", $
	"CSPICE_VLCOM                            		(SYSTEM/icy.dlm)					P a:input v1:input b:input v2:input SUM:output", $
	"CSPICE_VLCOM3                           		(SYSTEM/icy.dlm)					P a:input v1:input b:input v2:input c:input v3:input SUM:output", $
	"CSPICE_VLCOMG                           		(SYSTEM/icy.dlm)					P a:input v1:input b:input v2:input SUM:output", $
	"CSPICE_VMINUG                           		(SYSTEM/icy.dlm)					P vin:input VOUT:output", $
	"CSPICE_VMINUS                           		(SYSTEM/icy.dlm)					P v1:input VOUT:output", $
	"CSPICE_VNORM                            		(SYSTEM/icy.dlm)					F v1:input", $
	"CSPICE_VNORMG                           		(SYSTEM/icy.dlm)					F v1:input", $
	"CSPICE_VPACK                            		(SYSTEM/icy.dlm)					P x:input y:input z:input V:output", $
	"CSPICE_VPERP                            		(SYSTEM/icy.dlm)					P a:input b:input P:output", $
	"CSPICE_VPRJP                            		(SYSTEM/icy.dlm)					P vin:input plane:input VOUT:output", $
	"CSPICE_VPRJPI                           		(SYSTEM/icy.dlm)					P vin:input projpl:input invpl:input VOUT:output FOUND:output", $
	"CSPICE_VPROJ                            		(SYSTEM/icy.dlm)					P a:input b:input P:output", $
	"CSPICE_VREL                             		(SYSTEM/icy.dlm)					F v1:input v2:input", $
	"CSPICE_VRELG                            		(SYSTEM/icy.dlm)					F v1:input v2:input", $
	"CSPICE_VROTV                            		(SYSTEM/icy.dlm)					P v:input axis:input theta:input R:output", $
	"CSPICE_VSCL                             		(SYSTEM/icy.dlm)					P s:input v1:input VOUT:output", $
	"CSPICE_VSCLG                            		(SYSTEM/icy.dlm)					P s:input v1:input VOUT:output", $
	"CSPICE_VSEP                             		(SYSTEM/icy.dlm)					F v1:input v2:input", $
	"CSPICE_VSEPG                            		(SYSTEM/icy.dlm)					F v1:input v2:input", $
	"CSPICE_VSUB                             		(SYSTEM/icy.dlm)					P v1:input v2:input VOUT:output", $
	"CSPICE_VSUBG                            		(SYSTEM/icy.dlm)					P v1:input v2:input VOUT:output", $
	"CSPICE_VTMV                             		(SYSTEM/icy.dlm)					F v1:input matrix:input v2:input", $
	"CSPICE_VUPACK                           		(SYSTEM/icy.dlm)					P v:input X:output Y:output Z:output", $
	"CSPICE_VZERO                            		(SYSTEM/icy.dlm)					F v:input", $
	"CSPICE_VZEROG                           		(SYSTEM/icy.dlm)					F v:input", $
	"CSPICE_WNCARD                           		(SYSTEM/icy.dlm)					F window:input", $
	"CSPICE_WNCOMD                           		(SYSTEM/icy.dlm)					P left:input right:input window:input RESULT:output", $
	"CSPICE_WNCOND                           		(SYSTEM/icy.dlm)					P left:input right:input WINDOW:output", $
	"CSPICE_WNDIFD                           		(SYSTEM/icy.dlm)					P a:input b:input C:output", $
	"CSPICE_WNELMD                           		(SYSTEM/icy.dlm)					F point:input window):input", $
	"CSPICE_WNEXPD                           		(SYSTEM/icy.dlm)					P left:input right:input WINDOW:output", $
	"CSPICE_WNEXTD                           		(SYSTEM/icy.dlm)					P side:input WINDOW:output", $
	"CSPICE_WNFETD                           		(SYSTEM/icy.dlm)					P window:input n:input LEFT:output RIGHT:output", $
	"CSPICE_WNFILD                           		(SYSTEM/icy.dlm)					P small:input WINDOW:output", $
	"CSPICE_WNFLTD                           		(SYSTEM/icy.dlm)					P small:input WINDOW:output", $
	"CSPICE_WNINCD                           		(SYSTEM/icy.dlm)					F left:input right:input window):input", $
	"CSPICE_WNINSD                           		(SYSTEM/icy.dlm)					P left:input right:input WINDOW:output", $
	"CSPICE_WNINTD                           		(SYSTEM/icy.dlm)					P a:input b:input C:output", $
	"CSPICE_WNRELD                          		(SYSTEM/icy.dlm)					F a:input op:input b):input", $
	"CSPICE_WNSUMD                           		(SYSTEM/icy.dlm)					P window:input MEAS:output AVG:output STDDEV:output SHORTEST:output LONGEST:output", $
	"CSPICE_WNUNID                           		(SYSTEM/icy.dlm)					P a:input b:input C:output", $
	"CSPICE_WNVALD                           		(SYSTEM/icy.dlm)					P size:input n:input WINDOW:output", $
	"CSPICE_XF2EUL                           		(SYSTEM/icy.dlm)					P xform:input axisa:input axisb:input axisc:input EULANG:output UNIQUE:output", $
	"CSPICE_XF2RAV                           		(SYSTEM/icy.dlm)					P xform:input ROT:output AV:output", $
	"CSPICE_XPOSE                            		(SYSTEM/icy.dlm)					P m1:input MOUT:output", $
	"CSPICE_XPOSE6                           		(SYSTEM/icy.dlm)					P m1:input MOUT:output", $


	; idl_aacgm.dlm
	; -------------
	; AACGM v5.1
	; voir "http://ampere.jhuapl.edu/code/idl_aacgm.html"
	; voir "AACGM.pdf"
	"AACGM_HELP						(SYSTEM/idl_aacgm.dlm)				 	P",	$
	"AACGM_SET_PATH						(SYSTEM/idl_aacgm.dlm)	 				P path:input /QUIET:input",	$
	"AACGM_LOAD_COEF					(SYSTEM/idl_aacgm.dlm) 					P year:input /QUIET:input",	$
	"AACGM_CONV_COORD					(SYSTEM/idl_aacgm.dlm) 					P glat_or_mlat:input glong_or_mlong:input hgt:input mlat_or_glat:output mlon_or_glon:output err:output /TO_AACGM:input /TO_GEO:input /ORDER:input",	$
	"AACGM_MLT						(SYSTEM/idl_aacgm.dlm) 					F epoch:input mlong:input /MSLONG:input",	$
	"AACGM_MLONG						(SYSTEM/idl_aacgm.dlm) 					F epoch:input mlt:input",	$
	"AACGM_CONV_VEC						(SYSTEM/idl_aacgm.dlm) 					F glat:input glon:input hgt:input gvth:input gvph:input mlat:output mlong:output mvth1:output mvph1:output mvth2:output mvph2:output err:output /TO_AACGM:input",	$


	; lint.dlm
	; -------
	"LINTC_SAUTER_ESPACES_TABULATIONS			(SYSTEM/lint.dlm) 					F ligneIDL:input k:input",			$
	"LINTC_GET_NAME_IDL					(SYSTEM/lint.dlm) 					F IDLline:input k:input l:output",		$
	"LINTC_GET_NAME_C					(SYSTEM/lint.dlm) 					F IDLline:input k:input l:output",		$
	"LINTC_GET_CONSTANT_C					(SYSTEM/lint.dlm) 					F IDLline:input k:input l:output",		$
	"LINTC_SUPPRIMER_COMMENTAIRES_IDL			(SYSTEM/lint.dlm) 					P ligneIDL:input",				$
	"LINTC_GET_HTML						(SYSTEM/lint.dlm) 					F ligneIDL:input",					$
	"LINTC_GET_CORRECT_LINE					(SYSTEM/lint.dlm) 					F ligneIDL:input",					$
	"LINTC_INT_TO_STR					(SYSTEM/lint.dlm) 					F v:input",					$
	"LINTC_CODE_TO_HTML					(SYSTEM/lint.dlm) 					P is_IDL:input is_C:input html_dir:input target:input nom_routine_html:input function_pro:input module:input name:input object:input previous:input next:input code:input noligne1:input noligne2:input premiere_ligne:input derniere_ligne:input nb_prototypes:input prototype_name:input prototype_type:input doc:input nb_calledbys:input calledby_module:input calledby_function_pro:input calledby_name:input calledby_nb:input nb_calls:input call_module:input call_function_pro:input call_name:input call_nb:input nb_vars:input vars_type:input vars_name:input nb_labels:input labels_name:input nb_commons:input commons_common_name:input commons_var_name:input nb_msgs:input msg_noline:input msg_txt1:input msg_txt2:input msg_class:input nb_clas:input cla_noline:input cla_nochar:input cla_type:input cla_word:input cla_extra:input cla_link:input",	$
	"LINTC_CODE_TO_C					(SYSTEM/lint.dlm) 					P is_IDL:input is_C:input html_dir:input target:input nom_routine_c:input function_pro:input module:input name:input object:input previous:input next:input code:input noligne1:input noligne2:input premiere_ligne:input derniere_ligne:input nb_prototypes:input prototype_name:input prototype_type:input doc:input nb_vars:input vars_type:input vars_name:input nb_labels:input labels_name:input nb_commons:input commons_common_name:input commons_var_name:input nb_cccs:input ccc_noline:input ccc_nochar:input ccc_type:input ccc_word:input ccc_extra:input ccc_link:input",	$


	; idl_xml.dlm
	; -----------
	"IDLFFXMLDOMNODE::APPENDCHILD				(SYSTEM/idl_xml.dlm)			F NewChild:input",			$
	"IDLFFXMLDOMNODE::CLEANUP				(SYSTEM/idl_xml.dlm)			P",					$
	"IDLFFXMLDOMNODE::CLONENODE				(SYSTEM/idl_xml.dlm)			F /DEEP",				$
	"IDLFFXMLDOMNODE::GETATTRIBUTES				(SYSTEM/idl_xml.dlm)			F",					$
	"IDLFFXMLDOMNODE::GETCHILDNODES				(SYSTEM/idl_xml.dlm)			F",					$
	"IDLFFXMLDOMNODE::GETFIRSTCHILD				(SYSTEM/idl_xml.dlm)			F",					$
	"IDLFFXMLDOMNODE::GETLASTCHILD				(SYSTEM/idl_xml.dlm)			F",					$
	"IDLFFXMLDOMNODE::GETNEXTSIBLING			(SYSTEM/idl_xml.dlm)			F",					$
	"IDLFFXMLDOMNODE::GETNODENAME				(SYSTEM/idl_xml.dlm)			F",					$
	"IDLFFXMLDOMNODE::GETNODETYPE				(SYSTEM/idl_xml.dlm)			F",					$
	"IDLFFXMLDOMNODE::GETNODEVALUE				(SYSTEM/idl_xml.dlm)			F",					$
	"IDLFFXMLDOMNODE::GETOWNERDOCUMENT			(SYSTEM/idl_xml.dlm)			F",					$
	"IDLFFXMLDOMNODE::GETPARENTNODE				(SYSTEM/idl_xml.dlm)			F",					$
	"IDLFFXMLDOMNODE::GETPREVIOUSSIBLING			(SYSTEM/idl_xml.dlm)			F",					$
	"IDLFFXMLDOMNODE::HASCHILDNODES				(SYSTEM/idl_xml.dlm)			F",					$
	"IDLFFXMLDOMNODE::INIT					(SYSTEM/idl_xml.dlm)			F",					$
	"IDLFFXMLDOMNODE::INSERTBEFORE				(SYSTEM/idl_xml.dlm)			F NewChild:input [RefChild:input]",	$
	"IDLFFXMLDOMNODE::REMOVECHILD				(SYSTEM/idl_xml.dlm)			F OldChild:input",			$
	"IDLFFXMLDOMNODE::REPLACECHILD				(SYSTEM/idl_xml.dlm)			F NewChild:input OldChild:input",	$
	"IDLFFXMLDOMNODE::SETNODEVALUE				(SYSTEM/idl_xml.dlm)			P NodeValue:input",			$

	"IDLFFXMLDOMATTR(IDLFFXMLDOMNODE)::CLEANUP		(SYSTEM/idl_xml.dlm)			P",		$
	"IDLFFXMLDOMATTR(IDLFFXMLDOMNODE)::GETNAME		(SYSTEM/idl_xml.dlm)			F",		$
	"IDLFFXMLDOMATTR(IDLFFXMLDOMNODE)::GETSPECIFIED		(SYSTEM/idl_xml.dlm)			F",		$
	"IDLFFXMLDOMATTR(IDLFFXMLDOMNODE)::GETVALUE		(SYSTEM/idl_xml.dlm)			F",		$
	"IDLFFXMLDOMATTR(IDLFFXMLDOMNODE)::INIT			(SYSTEM/idl_xml.dlm)			F",		$
	"IDLFFXMLDOMATTR(IDLFFXMLDOMNODE)::SETVALUE		(SYSTEM/idl_xml.dlm)			P Value:input",	$

	"IDLFFXMLDOMCDATASECTION(IDLFFXMLDOMNODE)::CLEANUP	(SYSTEM/idl_xml.dlm)			P",	$
	"IDLFFXMLDOMCDATASECTION(IDLFFXMLDOMNODE)::INIT		(SYSTEM/idl_xml.dlm)			F",	$

	"IDLFFXMLDOMCHARACTERDATA(IDLFFXMLDOMNODE)::APPENDDATA		(SYSTEM/idl_xml.dlm)		P String:input",				$
	"IDLFFXMLDOMCHARACTERDATA(IDLFFXMLDOMNODE)::CLEANUP		(SYSTEM/idl_xml.dlm)		P",						$
	"IDLFFXMLDOMCHARACTERDATA(IDLFFXMLDOMNODE)::DELETEDATA		(SYSTEM/idl_xml.dlm)		P Offset:input Count:input",			$
	"IDLFFXMLDOMCHARACTERDATA(IDLFFXMLDOMNODE)::GETDATA		(SYSTEM/idl_xml.dlm)		F",						$
	"IDLFFXMLDOMCHARACTERDATA(IDLFFXMLDOMNODE)::GETLENGTH		(SYSTEM/idl_xml.dlm)		F",						$
	"IDLFFXMLDOMCHARACTERDATA(IDLFFXMLDOMNODE)::INIT		(SYSTEM/idl_xml.dlm)		F",						$
	"IDLFFXMLDOMCHARACTERDATA(IDLFFXMLDOMNODE)::INSERTDATA		(SYSTEM/idl_xml.dlm)		P Offset:input String:input",			$
	"IDLFFXMLDOMCHARACTERDATA(IDLFFXMLDOMNODE)::REPLACEDATA		(SYSTEM/idl_xml.dlm)		P Offset:input Count:input String:input",	$
	"IDLFFXMLDOMCHARACTERDATA(IDLFFXMLDOMNODE)::SETDATA		(SYSTEM/idl_xml.dlm)		P String:input",				$
	"IDLFFXMLDOMCHARACTERDATA(IDLFFXMLDOMNODE)::SUBSTRINGDATA	(SYSTEM/idl_xml.dlm)		F Offset:input Count:input",			$

	"IDLFFXMLDOMCOMMENT(IDLFFXMLDOMNODE/IDLFFXMLDOMCHARACTERDATA)::CLEANUP	(SYSTEM/idl_xml.dlm)	P",	$
	"IDLFFXMLDOMCOMMENT(IDLFFXMLDOMNODE/IDLFFXMLDOMCHARACTERDATA)::INIT	(SYSTEM/idl_xml.dlm)	F",	$

	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::CLEANUP				(SYSTEM/idl_xml.dlm)	P",			$
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::CREATEATTRIBUTE			(SYSTEM/idl_xml.dlm)	F Name:input",		$
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::CREATECDATASECTION		(SYSTEM/idl_xml.dlm)	F String:input",	$
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::CREATECOMMENT			(SYSTEM/idl_xml.dlm)	F String:input",	$
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::CREATEDOCUMENTFRAGMENT		(SYSTEM/idl_xml.dlm)	F",			$
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::CREATEELEMENT			(SYSTEM/idl_xml.dlm)	F TagName:input",	$
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::CREATEENTITYREFERENCE		(SYSTEM/idl_xml.dlm)	F Name:input",		$
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::CREATENODEITERATOR		(SYSTEM/idl_xml.dlm)	F RootNode:input /FILTER_NAME:input /FILTER_USERDATA:input /WHAT_TO_SHOW:input",	$
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::CREATEPROCESSINGINSTRUCTION	(SYSTEM/idl_xml.dlm)	F Target:input Data:input",	$
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::CREATETEXTNODE			(SYSTEM/idl_xml.dlm)	F String:input",	$
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::CREATETREEWALKER			(SYSTEM/idl_xml.dlm)	F RootNode:input /FILTER_NAME:input /FILTER_USERDATA:input /WHAT_TO_SHOW:input",	$
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::GETDOCTYPE			(SYSTEM/idl_xml.dlm)	F",	$
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::GETDOCUMENTELEMENT		(SYSTEM/idl_xml.dlm)	F",	$
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::GETELEMENTSBYTAGNAME		(SYSTEM/idl_xml.dlm)	F TagName:input",	$
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::GETIMPLEMENTATION		(SYSTEM/idl_xml.dlm)	F",	$ ; pas dans la doc
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::GETPROPERTY			(SYSTEM/idl_xml.dlm)	P " + IDLFFXMLDOMDOCUMENT_GETPROPERTY,	$
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::INIT				(SYSTEM/idl_xml.dlm)	F /EXCLUDE_IGNORABLE_WHITESPACE /EXPAND_ENTITY_REFERENCES /FILENAME:input /MSG_ERROR:input /MSG_FATAL:input /MSG_WARNING:input /QUIET /SCHEMA_CHECKING:input /VALIDATION_MODE:input",	$
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::LOAD				(SYSTEM/idl_xml.dlm)	P /EXCLUDE_IGNORABLE_WHITESPACE /EXPAND_ENTITY_REFERENCES /FILENAME:input /MSG_ERROR:input /MSG_FATAL:input /MSG_WARNING:input /QUIET /SCHEMA_CHECKING:input /VALIDATION_MODE:input",	$
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::SAVE				(SYSTEM/idl_xml.dlm)	P /ENCODING:input /EXPAND_ENTITY_REFERENCES /FILENAME:input /PRETTY_PRINT",	$
	"IDLFFXMLDOMDOCUMENT(IDLFFXMLDOMNODE)::SETPROPERTY			(SYSTEM/idl_xml.dlm)	P " + IDLFFXMLDOMDOCUMENT_SETPROPERTY,	$

	"IDLFFXMLDOMDOCUMENTFRAGMENT(IDLFFXMLDOMNODE)::CLEANUP			(SYSTEM/idl_xml.dlm)	P",	$
	"IDLFFXMLDOMDOCUMENTFRAGMENT(IDLFFXMLDOMNODE)::INIT			(SYSTEM/idl_xml.dlm)	F",	$

	"IDLFFXMLDOMDOCUMENTTYPE(IDLFFXMLDOMNODE)::CLEANUP			(SYSTEM/idl_xml.dlm)	P",	$
	"IDLFFXMLDOMDOCUMENTTYPE(IDLFFXMLDOMNODE)::GETENTITIES			(SYSTEM/idl_xml.dlm)	F",	$
	"IDLFFXMLDOMDOCUMENTTYPE(IDLFFXMLDOMNODE)::GETNAME			(SYSTEM/idl_xml.dlm)	F",	$
	"IDLFFXMLDOMDOCUMENTTYPE(IDLFFXMLDOMNODE)::GETNOTATIONS			(SYSTEM/idl_xml.dlm)	F",	$
	"IDLFFXMLDOMDOCUMENTTYPE(IDLFFXMLDOMNODE)::INIT				(SYSTEM/idl_xml.dlm)	F",	$

	"IDLFFXMLDOMELEMENT(IDLFFXMLDOMNODE)::CLEANUP				(SYSTEM/idl_xml.dlm)	P",				$
	"IDLFFXMLDOMELEMENT(IDLFFXMLDOMNODE)::GETATTRIBUTE			(SYSTEM/idl_xml.dlm)	F Name:input",			$
	"IDLFFXMLDOMELEMENT(IDLFFXMLDOMNODE)::GETATTRIBUTENODE			(SYSTEM/idl_xml.dlm)	F Name:input",			$
	"IDLFFXMLDOMELEMENT(IDLFFXMLDOMNODE)::GETELEMENTSBYTAGNAME		(SYSTEM/idl_xml.dlm)	F TagName:input",		$
	"IDLFFXMLDOMELEMENT(IDLFFXMLDOMNODE)::GETTAGNAME			(SYSTEM/idl_xml.dlm)	F",				$
	"IDLFFXMLDOMELEMENT(IDLFFXMLDOMNODE)::INIT				(SYSTEM/idl_xml.dlm)	F",				$
	"IDLFFXMLDOMELEMENT(IDLFFXMLDOMNODE)::REMOVEATTRIBUTE			(SYSTEM/idl_xml.dlm)	P Name:input",			$
	"IDLFFXMLDOMELEMENT(IDLFFXMLDOMNODE)::REMOVEATTRIBUTENODE		(SYSTEM/idl_xml.dlm)	F OldAttr:input",		$
	"IDLFFXMLDOMELEMENT(IDLFFXMLDOMNODE)::SETATTRIBUTE			(SYSTEM/idl_xml.dlm)	P Name:input Value:input",	$
	"IDLFFXMLDOMELEMENT(IDLFFXMLDOMNODE)::SETATTRIBUTENODE			(SYSTEM/idl_xml.dlm)	F NewAttr:input",		$

	"IDLFFXMLDOMENTITY(IDLFFXMLDOMNODE)::CLEANUP				(SYSTEM/idl_xml.dlm)	P",	$
	"IDLFFXMLDOMENTITY(IDLFFXMLDOMNODE)::GETNOTATIONNAME			(SYSTEM/idl_xml.dlm)	F",	$
	"IDLFFXMLDOMENTITY(IDLFFXMLDOMNODE)::GETPUBLICID			(SYSTEM/idl_xml.dlm)	F",	$
	"IDLFFXMLDOMENTITY(IDLFFXMLDOMNODE)::GETSYSTEMID			(SYSTEM/idl_xml.dlm)	F",	$
	"IDLFFXMLDOMENTITY(IDLFFXMLDOMNODE)::INIT				(SYSTEM/idl_xml.dlm)	F",	$

	"IDLFFXMLDOMENTITYREFERENCE(IDLFFXMLDOMNODE)::CLEANUP			(SYSTEM/idl_xml.dlm)	P",	$
	"IDLFFXMLDOMENTITYREFERENCE(IDLFFXMLDOMNODE)::INIT			(SYSTEM/idl_xml.dlm)	F",	$

	"IDLFFXMLDOMNAMEDNODEMAP(IDLFFXMLDOMNODE)::CLEANUP			(SYSTEM/idl_xml.dlm)	P",		$
	"IDLFFXMLDOMNAMEDNODEMAP(IDLFFXMLDOMNODE)::GETLENGTH			(SYSTEM/idl_xml.dlm)	F",		$
	"IDLFFXMLDOMNAMEDNODEMAP(IDLFFXMLDOMNODE)::GETNAMEDITEM			(SYSTEM/idl_xml.dlm)	F Name:input",	$
	"IDLFFXMLDOMNAMEDNODEMAP(IDLFFXMLDOMNODE)::INIT				(SYSTEM/idl_xml.dlm)	F",		$
	"IDLFFXMLDOMNAMEDNODEMAP(IDLFFXMLDOMNODE)::ITEM				(SYSTEM/idl_xml.dlm)	F Index:input",	$
	"IDLFFXMLDOMNAMEDNODEMAP(IDLFFXMLDOMNODE)::REMOVENAMEDITEM		(SYSTEM/idl_xml.dlm)	F Name:input",	$
	"IDLFFXMLDOMNAMEDNODEMAP(IDLFFXMLDOMNODE)::SETNAMEDITEM			(SYSTEM/idl_xml.dlm)	F Node:input",	$

	"IDLFFXMLDOMNODEITERATOR::CLEANUP					(SYSTEM/idl_xml.dlm)	P",	$
	"IDLFFXMLDOMNODEITERATOR::INIT						(SYSTEM/idl_xml.dlm)	F",	$
	"IDLFFXMLDOMNODEITERATOR::NEXTNODE					(SYSTEM/idl_xml.dlm)	F",	$
	"IDLFFXMLDOMNODEITERATOR::PREVIOUSNODE					(SYSTEM/idl_xml.dlm)	F",	$

	"IDLFFXMLDOMNODELIST::CLEANUP						(SYSTEM/idl_xml.dlm)	P	",	$
	"IDLFFXMLDOMNODELIST::GETLENGTH						(SYSTEM/idl_xml.dlm)	F",		$
	"IDLFFXMLDOMNODELIST::INIT						(SYSTEM/idl_xml.dlm)	F	",	$
	"IDLFFXMLDOMNODELIST::ITEM						(SYSTEM/idl_xml.dlm)	F index:input",	$

	"IDLFFXMLDOMNOTATION(IDLFFXMLDOMNODE)::CLEANUP				(SYSTEM/idl_xml.dlm)	P",	$
	"IDLFFXMLDOMNOTATION(IDLFFXMLDOMNODE)::GETPUBLICID			(SYSTEM/idl_xml.dlm)	F",	$
	"IDLFFXMLDOMNOTATION(IDLFFXMLDOMNODE)::GETSYSTEMID			(SYSTEM/idl_xml.dlm)	F",	$
	"IDLFFXMLDOMNOTATION(IDLFFXMLDOMNODE)::INIT				(SYSTEM/idl_xml.dlm)	F",	$

	"IDLFFXMLDOMPROCESSINGINSTRUCTION(IDLFFXMLDOMNODE)::CLEANUP		(SYSTEM/idl_xml.dlm)	P",			$
	"IDLFFXMLDOMPROCESSINGINSTRUCTION(IDLFFXMLDOMNODE)::GETDATA		(SYSTEM/idl_xml.dlm)	F",			$
	"IDLFFXMLDOMPROCESSINGINSTRUCTION(IDLFFXMLDOMNODE)::GETTARGET		(SYSTEM/idl_xml.dlm)	F",			$
	"IDLFFXMLDOMPROCESSINGINSTRUCTION(IDLFFXMLDOMNODE)::INIT		(SYSTEM/idl_xml.dlm)	F",			$
	"IDLFFXMLDOMPROCESSINGINSTRUCTION(IDLFFXMLDOMNODE)::SETDATA		(SYSTEM/idl_xml.dlm)	P Content:input",	$

	"IDLFFXMLDOMTEXT(IDLFFXMLDOMNODE/IDLFFXMLDOMCHARACTERDATA)::CLEANUP			(SYSTEM/idl_xml.dlm)	P",	$
	"IDLFFXMLDOMTEXT(IDLFFXMLDOMNODE/IDLFFXMLDOMCHARACTERDATA)::INIT			(SYSTEM/idl_xml.dlm)	F",	$
	"IDLFFXMLDOMTEXT(IDLFFXMLDOMNODE/IDLFFXMLDOMCHARACTERDATA)::ISIGNORABLEWHITESPACE	(SYSTEM/idl_xml.dlm)	F",	$
	"IDLFFXMLDOMTEXT(IDLFFXMLDOMNODE/IDLFFXMLDOMCHARACTERDATA)::SPLITTEXT			(SYSTEM/idl_xml.dlm)	F Offset:input",	$

	"IDLFFXMLDOMTREEWALKER::CLEANUP						(SYSTEM/idl_xml.dlm)		P",			$
	"IDLFFXMLDOMTREEWALKER::FIRSTCHILD					(SYSTEM/idl_xml.dlm)		F",			$
	"IDLFFXMLDOMTREEWALKER::GETCURRENTNODE					(SYSTEM/idl_xml.dlm)		F",			$
	"IDLFFXMLDOMTREEWALKER::INIT						(SYSTEM/idl_xml.dlm)		F",			$
	"IDLFFXMLDOMTREEWALKER::SETCURRENTNODE					(SYSTEM/idl_xml.dlm)		P CurrentNode:input",	$
	"IDLFFXMLDOMTREEWALKER::LASTCHILD					(SYSTEM/idl_xml.dlm)		F",			$
	"IDLFFXMLDOMTREEWALKER::NEXTNODE					(SYSTEM/idl_xml.dlm)		F",			$
	"IDLFFXMLDOMTREEWALKER::NEXTSIBLING					(SYSTEM/idl_xml.dlm)		F",			$
	"IDLFFXMLDOMTREEWALKER::PARENTNODE					(SYSTEM/idl_xml.dlm)		F",			$
	"IDLFFXMLDOMTREEWALKER::PREVIOUSNODE					(SYSTEM/idl_xml.dlm)		F",			$
	"IDLFFXMLDOMTREEWALKER::PREVIOUSSIBLING					(SYSTEM/idl_xml.dlm)		F",			$

	"IDLFFXMLSAX::ATTRIBUTEDECL						(SYSTEM/idl_xml.dlm)		P eName:input aName:input Type:input Mode:input Value:input",		$
	"IDLFFXMLSAX::CHARACTERS						(SYSTEM/idl_xml.dlm)		P Chars:input",								$	
	"IDLFFXMLSAX::CLEANUP							(SYSTEM/idl_xml.dlm)		P",									$
	"IDLFFXMLSAX::COMMENT							(SYSTEM/idl_xml.dlm)		P Comment:input",							$
	"IDLFFXMLSAX::ELEMENTDECL						(SYSTEM/idl_xml.dlm)		P Name:input Model:input",						$
	"IDLFFXMLSAX::ENDCDATA							(SYSTEM/idl_xml.dlm)		P",									$
	"IDLFFXMLSAX::ENDDOCUMENT						(SYSTEM/idl_xml.dlm)		P",									$
	"IDLFFXMLSAX::ENDDTD							(SYSTEM/idl_xml.dlm)		P",									$
	"IDLFFXMLSAX::ENDELEMENT						(SYSTEM/idl_xml.dlm)		P URI:input Local:input qName:input",					$
	"IDLFFXMLSAX::ENDENTITY							(SYSTEM/idl_xml.dlm)		P Name:input",								$
	"IDLFFXMLSAX::ENDPREFIXMAPPING						(SYSTEM/idl_xml.dlm)		P Prefix:input",							$
	"IDLFFXMLSAX::ERROR							(SYSTEM/idl_xml.dlm)		P SystemID:input LineNumber:input ColumnNumber:input Message:input",	$
	"IDLFFXMLSAX::EXTERNALENTITYDECL					(SYSTEM/idl_xml.dlm)		P Name:input PublicID:input SystemID:input",				$
	"IDLFFXMLSAX::FATALERROR						(SYSTEM/idl_xml.dlm)		P SystemID:input LineNumber:input ColumnNumber:input Message:input",	$
	"IDLFFXMLSAX::GETPROPERTY						(SYSTEM/idl_xml.dlm)		P " + IDLFFXMLSAX_GETPROPERTY,						$
	"IDLFFXMLSAX::IGNORABLEWHITESPACE					(SYSTEM/idl_xml.dlm)		P Chars:input",								$
	"IDLFFXMLSAX::INIT							(SYSTEM/idl_xml.dlm)		F " + IDLFFXMLSAX_INIT,							$
	"IDLFFXMLSAX::INTERNALENTITYDECL					(SYSTEM/idl_xml.dlm)		P Name:input Value:input",						$
	"IDLFFXMLSAX::NOTATIONDECL						(SYSTEM/idl_xml.dlm)		P Name:input PublicID:input SystemID:input",				$
	"IDLFFXMLSAX::PARSEFILE							(SYSTEM/idl_xml.dlm)		P Filename:input",							$
	"IDLFFXMLSAX::PROCESSINGINSTRUCTION					(SYSTEM/idl_xml.dlm)		P Target:input Data:input",						$
	"IDLFFXMLSAX::SETDOCUMENTLOCATOR					(SYSTEM/idl_xml.dlm)		P p1:??? p2:??? p3:??? p4:???",						$ ; nodoc
	"IDLFFXMLSAX::SETPROPERTY						(SYSTEM/idl_xml.dlm)		P " + IDLFFXMLSAX_SETPROPERTY,						$
	"IDLFFXMLSAX::SKIPPEDENTITY						(SYSTEM/idl_xml.dlm)		P Name:input",								$
	"IDLFFXMLSAX::STARTCDATA						(SYSTEM/idl_xml.dlm)		P",									$
	"IDLFFXMLSAX::STARTDOCUMENT						(SYSTEM/idl_xml.dlm)		P",									$
	"IDLFFXMLSAX::STARTDTD							(SYSTEM/idl_xml.dlm)		P Name:input PublicID:input SystemID:input",				$
	"IDLFFXMLSAX::STARTELEMENT						(SYSTEM/idl_xml.dlm)		P URI:input Local:input qName:input [attName:input] [attValue:input]",	$
	"IDLFFXMLSAX::STARTENTITY						(SYSTEM/idl_xml.dlm)		P Name:input",								$
	"IDLFFXMLSAX::STARTPREFIXMAPPING					(SYSTEM/idl_xml.dlm)		P Prefix:input URI:input",						$
	"IDLFFXMLSAX::STOPPARSING						(SYSTEM/idl_xml.dlm)		P",									$
	"IDLFFXMLSAX::UNPARSEDENTITYDECL					(SYSTEM/idl_xml.dlm)		P Name:input PublicID:input SystemID:input Notation:input",		$
	"IDLFFXMLSAX::WARNING							(SYSTEM/idl_xml.dlm)		P SystemID:input LineNumber:input ColumnNumber:input Message:input",	$


	; idl_gif.dlm
	; -----------
	; pas de doc
	"DECODE_GIF						(SYSTEM/idl_gif.dlm)				P unit:input image:input",	$
	"ENCODE_GIF						(SYSTEM/idl_gif.dlm)				P unit:input image:input",	$


	; idl_mpeg.dlm
	; ------------
	"IDLGRMPEG(IDLITCOMPONENT)::CLEANUP			(SYSTEM/idl_mpeg.dlm)				P",				$
	"IDLGRMPEG(IDLITCOMPONENT)::GETPROPERTY			(SYSTEM/idl_mpeg.dlm)				P " + IDLGRMPEG_GETPROPERTY,	$
	"IDLGRMPEG(IDLITCOMPONENT)::INIT			(SYSTEM/idl_mpeg.dlm)				F",				$
	"IDLGRMPEG(IDLITCOMPONENT)::PUT				(SYSTEM/idl_mpeg.dlm)				P Image:input [Frame:input]",	$
	"IDLGRMPEG(IDLITCOMPONENT)::SAVE			(SYSTEM/idl_mpeg.dlm)				P /FILENAME:input",		$
	"IDLGRMPEG(IDLITCOMPONENT)::SETPROPERTY			(SYSTEM/idl_mpeg.dlm)				P " + IDLGRMPEG_SETPROPERTY,	$


	; idl_dicom.dlm
	; -------------
	"IDLFFDICOM::CLEANUP					(SYSTEM/idl_dicom.dlm)				P",	$
	"IDLFFDICOM::DUMPELEMENTS				(SYSTEM/idl_dicom.dlm)				P [Filename:input]",	$
	"IDLFFDICOM::GETCHILDREN				(SYSTEM/idl_dicom.dlm)				F Reference:output",	$
	"IDLFFDICOM::GETDESCRIPTION				(SYSTEM/idl_dicom.dlm)				F [Group:input] [Element:input] /REFERENCE:input",	$
	"IDLFFDICOM::GETELEMENT					(SYSTEM/idl_dicom.dlm)				F [Group:input] [Element:input] /REFERENCE:input",	$
	"IDLFFDICOM::GETGROUP					(SYSTEM/idl_dicom.dlm)				F [Group:input] [Element:input] /REFERENCE:input",	$
	"IDLFFDICOM::GETLENGTH					(SYSTEM/idl_dicom.dlm)				F [Group:input] [Element:input] /REFERENCE:input",	$
	"IDLFFDICOM::GETPARENT					(SYSTEM/idl_dicom.dlm)				F ReferenceList:input",	$
	"IDLFFDICOM::GETPREAMBLE				(SYSTEM/idl_dicom.dlm)				F",	$
	"IDLFFDICOM::GETREFERENCE				(SYSTEM/idl_dicom.dlm)				F [Group:input] [Element:input] /DESCRIPTION:input /VR:input",	$
	"IDLFFDICOM::GETVALUE					(SYSTEM/idl_dicom.dlm)				F [Group:input] [Element:input] /REFERENCE:input /NO_COPY",	$
	"IDLFFDICOM::GETVR					(SYSTEM/idl_dicom.dlm)				F [Group:input] [Element:input] /REFERENCE:input",	$
	"IDLFFDICOM::INIT					(SYSTEM/idl_dicom.dlm)				F [Filename:input] " + IDLFFDICOM_INIT,	$
	"IDLFFDICOM::READ					(SYSTEM/idl_dicom.dlm)				F Filename:input /ENDIAN:input",	$
	"IDLFFDICOM::RESET					(SYSTEM/idl_dicom.dlm)				P",	$


	; idl_dicomex.dlm
	; ---------------
	"IDLFFDICOMEX::ADDGROUP					(SYSTEM/idl_dicomex.dlm)		F DicomTag:input /PARENTSEQID:input",	$
	"IDLFFDICOMEX::ADDPRIVATEGROUP				(SYSTEM/idl_dicomex.dlm)		F PrivateCode:input Group:input Element:input /PARENTSEQID:input",	$
	"IDLFFDICOMEX::ADDPRIVATESEQUENCE			(SYSTEM/idl_dicomex.dlm)		F PrivateCode:input Group:input Element:input /PARENTSEQID:input",	$
	"IDLFFDICOMEX::ADDSEQUENCE				(SYSTEM/idl_dicomex.dlm)		F DicomTag:input /PARENTSEQID:input",	$
	"IDLFFDICOMEX::CHANGETRANSFERSYNTAX			(SYSTEM/idl_dicomex.dlm)		P NewSyntaxUID:input /LOSSY",	$
	"IDLFFDICOMEX::CLEANUP					(SYSTEM/idl_dicomex.dlm)		P",	$
	"IDLFFDICOMEX::COMMIT					(SYSTEM/idl_dicomex.dlm)		P",	$
	"IDLFFDICOMEX::COPYTAGS					(SYSTEM/idl_dicomex.dlm)		P DestinationObject:input Start_Tag:input Stop_Tag:input",	$
	"IDLFFDICOMEX::ENUMERATETAGS				(SYSTEM/idl_dicomex.dlm)		F /START_TAG:input /STOP_TAG:input /COUNT:output /FILENAME:input /QUIET",	$
	"IDLFFDICOMEX::GETDESCRIPTION				(SYSTEM/idl_dicomex.dlm)		F DicomTag:input",	$
	"IDLFFDICOMEX::GETPIXELDATA				(SYSTEM/idl_dicomex.dlm)		F /FRAME:input /ORDER /COUNT:output",	$
	"IDLFFDICOMEX::GETPRIVATEVALUE				(SYSTEM/idl_dicomex.dlm)		F PrivateCode:input Group:input Element:input /SEQID:input /COUNT:output",	$
	"IDLFFDICOMEX::GETPRIVATEVALUECOUNT			(SYSTEM/idl_dicomex.dlm)		F PrivateCode:input Group:input Element:input /SEQID:input",	$
	"IDLFFDICOMEX::GETPRIVATEVALUELENGTH			(SYSTEM/idl_dicomex.dlm)		F PrivateCode:input Group:input Element:input /SEQID:input /VALUEINDEX:input",	$
	"IDLFFDICOMEX::GETPRIVATEVR				(SYSTEM/idl_dicomex.dlm)		F PrivateCode:input Group:input Element:input /SEQID:input",	$
	"IDLFFDICOMEX::GETPROPERTY				(SYSTEM/idl_dicomex.dlm)		P " + IDLFFDICOMEX_GETPROPERTY,	$
	"IDLFFDICOMEX::GETVALUE					(SYSTEM/idl_dicomex.dlm)		F DicomTag:input /SEQID:input /COUNT:output",	$
	"IDLFFDICOMEX::GETVALUECOUNT				(SYSTEM/idl_dicomex.dlm)		F DicomTag:input /SEQID:input",	$
	"IDLFFDICOMEX::GETVALUELENGTH				(SYSTEM/idl_dicomex.dlm)		F DicomTag:input /SEQID:input /VALUEINDEX:input",	$
	"IDLFFDICOMEX::GETVR					(SYSTEM/idl_dicomex.dlm)		F DicomTag:input /SEQID:input",	$
	"IDLFFDICOMEX::INIT					(SYSTEM/idl_dicomex.dlm)		F Filename:input /CLONE:input /CREATE /SOP_CLASS:input /NON_CONFORMING " + IDLFFDICOMEX_INIT,	$
	"IDLFFDICOMEX::QUERYPRIVATEVALUE			(SYSTEM/idl_dicomex.dlm)		F PrivateCode:input Group:input Element:input /SEQID:input",	$
	"IDLFFDICOMEX::QUERYVALUE				(SYSTEM/idl_dicomex.dlm)		F DicomTag:input /SEQID:input",	$
	"IDLFFDICOMEX::SETPIXELDATA				(SYSTEM/idl_dicomex.dlm)		P PixelData:input /FRAME:input /ORDER /BITS_ALLOCATED:input /COLUMNS:input /NUMBER_OF_FRAMES:input /PHOTOMETRIC_INTERPRETATION:input /PIXEL_REPRESENTATION:input /PLANAR_CONFIGURATION:input /ROWS:input /SAMPLES_PER_PIXEL:input",	$
	"IDLFFDICOMEX::SETPRIVATEVALUE				(SYSTEM/idl_dicomex.dlm)		P PrivateCode:input Group:input Element:input VR:input [Value:input] /SEQID:input /CLEAR /REMOVE /BLOCKREMOVE",	$
	"IDLFFDICOMEX::SETPROPERTY				(SYSTEM/idl_dicomex.dlm)		P " + IDLFFDICOMEX_SETPROPERTY,	$
	"IDLFFDICOMEX::SETVALUE					(SYSTEM/idl_dicomex.dlm)		P DicomTag:input [VR:input] [Value:input] /SEQID:input /CLEAR /REMOVE",	$

	"IDLFFDICOMEXCFG::CLEANUP				(SYSTEM/idl_dicomex.dlm)		P",	$
	"IDLFFDICOMEXCFG::COMMIT				(SYSTEM/idl_dicomex.dlm)		P",	$
	"IDLFFDICOMEXCFG::ECHO					(SYSTEM/idl_dicomex.dlm)		F ApplicationEntityName:input /COUNT:output",	$
	"IDLFFDICOMEXCFG::GETAPPLICATIONENTITIES		(SYSTEM/idl_dicomex.dlm)		F /COUNT:output /SERVICE_TYPE:input",	$
	"IDLFFDICOMEXCFG::GETAPPLICATIONENTITY			(SYSTEM/idl_dicomex.dlm)		F ApplicatonEntityName:input",	$
	"IDLFFDICOMEXCFG::GETSERVICELISTS			(SYSTEM/idl_dicomex.dlm)		F /COUNT:output",	$
	"IDLFFDICOMEXCFG::GETSERVICETYPES			(SYSTEM/idl_dicomex.dlm)		F /COUNT:output",	$
	"IDLFFDICOMEXCFG::GETVALUE				(SYSTEM/idl_dicomex.dlm)		F ConfigurationParameterName:input",	$
	"IDLFFDICOMEXCFG::INIT					(SYSTEM/idl_dicomex.dlm)		F /SYSTEM",	$
	"IDLFFDICOMEXCFG::ISDIRTY				(SYSTEM/idl_dicomex.dlm)		F",	$
	"IDLFFDICOMEXCFG::REMOVEAPPLICATIONENTITY		(SYSTEM/idl_dicomex.dlm)		P ApplicationEntityName:input",	$
	"IDLFFDICOMEXCFG::SETAPPLICATIONENTITY			(SYSTEM/idl_dicomex.dlm)		P ApplicationEntityName:input AET:input Hostname:input Port:input ServiceListName:input ServiceType:input",	$
	"IDLFFDICOMEXCFG::SETVALUE				(SYSTEM/idl_dicomex.dlm)		P ConfigurationParameterName:input Value:input",	$
	"IDLFFDICOMEXCFG::STORAGESCPSERVICE			(SYSTEM/idl_dicomex.dlm)		F Command:input",	$
	"IDLFFDICOMEXCFG::UPDATECONFIGURATIONFILE		(SYSTEM/idl_dicomex.dlm)		P",	$ ; nodoc

	"IDLFFDICOMEXISLICENSED					(SYSTEM/idl_dicomex.dlm)		F",	$ ; nodoc

	"IDLFFDICOMEXQUERY::CLEANUP				(SYSTEM/idl_dicomex.dlm)		P",	$
	"IDLFFDICOMEXQUERY::CLEARPROPERTIES			(SYSTEM/idl_dicomex.dlm)		P",	$
	"IDLFFDICOMEXQUERY::GETPROPERTY				(SYSTEM/idl_dicomex.dlm)		P " + IDLFFDICOMEXQUERY_GETPROPERTY,	$
	"IDLFFDICOMEXQUERY::INIT				(SYSTEM/idl_dicomex.dlm)		F",	$
	"IDLFFDICOMEXQUERY::QUERY				(SYSTEM/idl_dicomex.dlm)		F /COUNT:output",	$
	"IDLFFDICOMEXQUERY::QUERYMODELSSUPPORTED		(SYSTEM/idl_dicomex.dlm)		F /COUNT:output",	$
	"IDLFFDICOMEXQUERY::RETRIEVE				(SYSTEM/idl_dicomex.dlm)		F /COUNT:output /PATIENT_ID:input /STUDY_INSTANCE_UID:input /SERIES_INSTANCE_UID:input /SOP_INSTANCE_UID:input",	$
	"IDLFFDICOMEXQUERY::SETPROPERTY				(SYSTEM/idl_dicomex.dlm)		P " + IDLFFDICOMEXQUERY_SETPROPERTY,	$

	"IDLFFDICOMEXSTORSCU::CLEANUP				(SYSTEM/idl_dicomex.dlm)		P",	$
	"IDLFFDICOMEXSTORSCU::CLEARPROPERTIES			(SYSTEM/idl_dicomex.dlm)		P",	$
	"IDLFFDICOMEXSTORSCU::GETPROPERTY			(SYSTEM/idl_dicomex.dlm)		P " + IDLFFDICOMEXSTORSCU_GETPROPERTY,	$
	"IDLFFDICOMEXSTORSCU::INIT				(SYSTEM/idl_dicomex.dlm)		F",	$
	"IDLFFDICOMEXSTORSCU::SEND				(SYSTEM/idl_dicomex.dlm)		F Files:input",	$
	"IDLFFDICOMEXSTORSCU::SETPROPERTY			(SYSTEM/idl_dicomex.dlm)		P " + IDLFFDICOMEXSTORSCU_SETPROPERTY,	$


	; idl_dxf.dlm
	; -----------
	"IDLFFDXF::CLEANUP					(SYSTEM/idl_dxf.dlm)			P",								$
	"IDLFFDXF::GETCONTENTS					(SYSTEM/idl_dxf.dlm)			F [Filter:input] /BLOCK:input /COUNT:output /LAYER:input",	$
	"IDLFFDXF::GETENTITY					(SYSTEM/idl_dxf.dlm)			F Type:input /BLOCK:input /INDEX:input /LAYER:input",		$
	"IDLFFDXF::GETPALETTE					(SYSTEM/idl_dxf.dlm)			P Red:output Green:output Blue:output",				$
	"IDLFFDXF::INIT						(SYSTEM/idl_dxf.dlm)			F [Filename:input]",						$
	"IDLFFDXF::PUTENTITY					(SYSTEM/idl_dxf.dlm)			P Data:input",							$
	"IDLFFDXF::READ						(SYSTEM/idl_dxf.dlm)			F Filename:input",						$
	"IDLFFDXF::REMOVEENTITY					(SYSTEM/idl_dxf.dlm)			P Type:input /INDEX:input",					$
	"IDLFFDXF::RESET					(SYSTEM/idl_dxf.dlm)			P",								$
	"IDLFFDXF::SETPALETTE					(SYSTEM/idl_dxf.dlm)			P Red:input Green:input Blue:input",				$
	"IDLFFDXF::WRITE					(SYSTEM/idl_dxf.dlm)			F Filename:input",						$
	"ISADXF							(SYSTEM/idl_dxf.dlm)			F p1:input",							$ ; nodoc


	; idl_envi.dlm (nodoc)
	; ------------
	; pas de doc
	"ENVI_AUTOCORRELATE					(SYSTEM/idl_envi.dlm)			P p1:??? p2:??? p3:??? p4:??? p5:??? p6:??? p7:??? p8:??? p9:??? p10:??? p11:??? p12:??? p13:??? p14:??? p15:??? p16:??? p17:???",	$
	"ENVI_CLASS_MAJORITY					(SYSTEM/idl_envi.dlm)			P P1:??? p2:??? p3:??? p4:??? p5:??? p6:??? p7:??? p8:??? p9:??? p10:??? p11:??? p12:??? p13:???",					$
	"ENVI_ND_FILL_IMAGE_24BIT				(SYSTEM/idl_envi.dlm)			P p1:??? p2:??? p3:??? p4:??? p5:??? p6:??? p7:??? p8:??? p9:??? p10:???",								$
	"ENVI_ND_FILL_IMAGE_8BIT				(SYSTEM/idl_envi.dlm)			P p1:??? p2:??? p3:??? p4:??? p5:??? p6:??? p7:???",											$
	"ENVI_RESIZE_WITH_AGGREGATE				(SYSTEM/idl_envi.dlm)			P p1:??? p2:??? p3:??? p4:??? p5:??? p6:??? p7:??? p8:??? p9:???",									$
	"ENVI_TOPO_FEATURE					(SYSTEM/idl_envi.dlm)			P p1:??? p2:??? p3:??? p4:??? p5:??? p6:???",												$
	"ENVI_TOPO_MEASURE					(SYSTEM/idl_envi.dlm)			P p1:??? p2:??? p3:??? p4:??? p5:??? p6:??? p7:??? p8:??? p9:??? p10:??? p11:??? p12:??? p13:??? p14:??? p15:??? p16:??? p17:???",	$


	; idl_hdf5.dlm
	; ------------
	"H5A_CREATE						(SYSTEM/idl_hdf5.dlm)			F Loc_id:input Name:input Datatype_id:input Dataspace_id:input",	$
	"H5A_GET_NAME						(SYSTEM/idl_hdf5.dlm)			F Attribute_id:input",	$
	"H5A_GET_NUM_ATTRS					(SYSTEM/idl_hdf5.dlm)			F Loc_id:input",	$
	"H5A_GET_SPACE						(SYSTEM/idl_hdf5.dlm)			F Attribute_id:input",	$
	"H5A_GET_TYPE						(SYSTEM/idl_hdf5.dlm)			F Attribute_id:input",	$
	"H5A_OPEN_IDX						(SYSTEM/idl_hdf5.dlm)			F Loc_id:input Index:input",	$
	"H5A_OPEN_NAME						(SYSTEM/idl_hdf5.dlm)			F Loc_id:input Name:input",	$
	"H5A_READ						(SYSTEM/idl_hdf5.dlm)			F Attribute_id:input [Datatype_id:input]",	$
	"H5A_WRITE						(SYSTEM/idl_hdf5.dlm)			P Attribute_id:input Data:input",	$
	"H5D_CLOSE						(SYSTEM/idl_hdf5.dlm)			P Dataset_id:input",	$
	"H5D_CREATE						(SYSTEM/idl_hdf5.dlm)			F Loc_id:input Name:input Datatype_id:input Dataspace_id:input /CHUNK_DIMENSIONS:input /GZIP:input /SHUFFLE",	$
	"H5D_EXTEND						(SYSTEM/idl_hdf5.dlm)			P Dataset_id:input Size:input",	$
	"H5D_GET_SPACE						(SYSTEM/idl_hdf5.dlm)			F Dataset_id:input",	$
	"H5D_GET_STORAGE_SIZE					(SYSTEM/idl_hdf5.dlm)			F Dataset_id:input",	$
	"H5D_GET_TYPE						(SYSTEM/idl_hdf5.dlm)			F Dataset_id:input",	$
	"H5D_OPEN						(SYSTEM/idl_hdf5.dlm)			F Loc_id:input Name:input",	$
	"H5D_READ						(SYSTEM/idl_hdf5.dlm)			F Dataset_id:input [Datatype_id:input] /FILE_SPACE:input /MEMORY_SPACE:input",	$
	"H5D_WRITE						(SYSTEM/idl_hdf5.dlm)			P Dataset_id:input Data:input /MEMORY_SPACE_ID:input /FILE_SPACE_ID:input",	$
	"H5F_CLOSE						(SYSTEM/idl_hdf5.dlm)			P File_id:input",	$
	"H5F_CREATE						(SYSTEM/idl_hdf5.dlm)			F Filename:input",	$
	"H5F_IS_HDF5						(SYSTEM/idl_hdf5.dlm)			F Filename:input",	$
	"H5F_OPEN						(SYSTEM/idl_hdf5.dlm)			F Filename:input /WRITE",	$
	"H5G_CLOSE						(SYSTEM/idl_hdf5.dlm)			P Group_id:input",	$
	"H5G_CREATE						(SYSTEM/idl_hdf5.dlm)			F Loc_id:input Name:input",	$
	"H5G_GET_COMMENT					(SYSTEM/idl_hdf5.dlm)			F Loc_id:input Name:input",	$
	"H5G_GET_LINKVAL					(SYSTEM/idl_hdf5.dlm)			F Loc_id:input Name:input",	$
	"H5G_GET_MEMBER_NAME					(SYSTEM/idl_hdf5.dlm)			F Loc_id:input Name:input Index:input",	$
	"H5G_GET_NMEMBERS					(SYSTEM/idl_hdf5.dlm)			F Loc_id:input Name:input",	$
	"H5G_GET_NUM_OBJS					(SYSTEM/idl_hdf5.dlm)			F Loc_id:input",	$
	"H5G_GET_OBJ_NAME_BY_IDX				(SYSTEM/idl_hdf5.dlm)			F Loc_id:input Index:input",	$
	"H5G_GET_OBJINFO					(SYSTEM/idl_hdf5.dlm)			F Loc_id:input Name:input /FOLLOW_LINK",	$
	"H5G_LINK						(SYSTEM/idl_hdf5.dlm)			P Loc_id:input Current_Name:input New_Name:input /SOFTLINK /NEW_LOC_ID:input",	$
	"H5G_MOVE						(SYSTEM/idl_hdf5.dlm)			P Loc_id:input Src_Name:input Dst_Name:input /NEW_LOC_ID:input",	$
	"H5G_OPEN						(SYSTEM/idl_hdf5.dlm)			F Loc_id:input Name:input",	$
	"H5G_SET_COMMENT					(SYSTEM/idl_hdf5.dlm)			P Loc_id:input Name:input Comment:input",	$
	"H5G_UNLINK						(SYSTEM/idl_hdf5.dlm)			P Loc_id:input Name:input",	$
	"H5I_GET_FILE_ID					(SYSTEM/idl_hdf5.dlm)			F Loc_id:input",	$
	"H5I_GET_TYPE						(SYSTEM/idl_hdf5.dlm)			F Obj_id:input",	$
	"H5R_CREATE						(SYSTEM/idl_hdf5.dlm)			F Loc_id:input Name:input /DATASPACE_ID:input",	$
	"H5R_DEREFERENCE					(SYSTEM/idl_hdf5.dlm)			F Loc_id:input Reference:input",	$
	"H5R_GET_OBJECT_TYPE					(SYSTEM/idl_hdf5.dlm)			F Loc_id:input Reference:input",	$
	"H5R_GET_REGION						(SYSTEM/idl_hdf5.dlm)			F Dataset_id:input Reference:input",	$
	"H5S_CLOSE						(SYSTEM/idl_hdf5.dlm)			P Dataspace_id:input",	$
	"H5S_COPY						(SYSTEM/idl_hdf5.dlm)			F Dataspace_id:input",	$
	"H5S_CREATE_SCALAR					(SYSTEM/idl_hdf5.dlm)			F",	$
	"H5S_CREATE_SIMPLE					(SYSTEM/idl_hdf5.dlm)			F Dimensions:input /MAX_DIMENSIONS:input",	$
	"H5S_GET_SELECT_BOUNDS					(SYSTEM/idl_hdf5.dlm)			F Dataspace_id:input",	$
	"H5S_GET_SELECT_ELEM_NPOINTS				(SYSTEM/idl_hdf5.dlm)			F Dataspace_id:input",	$
	"H5S_GET_SELECT_ELEM_POINTLIST				(SYSTEM/idl_hdf5.dlm)			F Dataspace_id:input /START:input /NUMBER:input",	$
	"H5S_GET_SELECT_HYPER_BLOCKLIST				(SYSTEM/idl_hdf5.dlm)			F Dataspace_id:input /START:input /NUMBER:input",	$
	"H5S_GET_SELECT_HYPER_NBLOCKS				(SYSTEM/idl_hdf5.dlm)			F Dataspace_id:input",	$
	"H5S_GET_SELECT_NPOINTS					(SYSTEM/idl_hdf5.dlm)			F Dataspace_id:input",	$
	"H5S_GET_SIMPLE_EXTENT_DIMS				(SYSTEM/idl_hdf5.dlm)			F Dataspace_id:input /MAX_DIMENSIONS:output",	$
	"H5S_GET_SIMPLE_EXTENT_NDIMS				(SYSTEM/idl_hdf5.dlm)			F Dataspace_id:input",	$
	"H5S_GET_SIMPLE_EXTENT_NPOINTS				(SYSTEM/idl_hdf5.dlm)			F Dataspace_id:input",	$
	"H5S_GET_SIMPLE_EXTENT_TYPE				(SYSTEM/idl_hdf5.dlm)			F Dataspace_id:input",	$
	"H5S_IS_SIMPLE						(SYSTEM/idl_hdf5.dlm)			F Dataspace_id:input",	$
	"H5S_OFFSET_SIMPLE					(SYSTEM/idl_hdf5.dlm)			P Dataspace_id:input Offset:input",	$
	"H5S_SELECT_ALL						(SYSTEM/idl_hdf5.dlm)			P Dataspace_id:input",	$
	"H5S_SELECT_ELEMENTS					(SYSTEM/idl_hdf5.dlm)			P Dataspace_id:input Coordinates:input /RESET",	$
	"H5S_SELECT_HYPERSLAB					(SYSTEM/idl_hdf5.dlm)			P Dataspace_id:input Start:input Count:input /BLOCK:input /RESET /STRIDE:input",	$
	"H5S_SELECT_NONE					(SYSTEM/idl_hdf5.dlm)			P Dataspace_id:input",	$
	"H5S_SELECT_VALID					(SYSTEM/idl_hdf5.dlm)			F Dataspace_id:input",	$
	"H5S_SET_EXTENT_NONE					(SYSTEM/idl_hdf5.dlm)			P Dataspace_id:input",	$
	"H5S_SET_EXTENT_SIMPLE					(SYSTEM/idl_hdf5.dlm)			P Dataspace_id:input Dimensions:input /MAX_DIMENSIONS:input",	$
	"H5T_ARRAY_CREATE					(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input Dimensions:input",	$
	"H5T_CLOSE						(SYSTEM/idl_hdf5.dlm)			P Datatype_id:input",	$
	"H5T_COMMIT						(SYSTEM/idl_hdf5.dlm)			P Loc_id:input Name:input Datatype_id^:input",	$
	"H5T_COMMITTED						(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_COMPOUND_CREATE					(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input Name:input",	$
	"H5T_COPY						(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_ENUM_CREATE					(SYSTEM/idl_hdf5.dlm)			F",	$
	"H5T_ENUM_INSERT					(SYSTEM/idl_hdf5.dlm)			P Datatype_id:input Name:input Value:input",	$
	"H5T_ENUM_NAMEOF					(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input Value:input",	$
	"H5T_ENUM_VALUEOF					(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input Name:input",	$
	"H5T_EQUAL						(SYSTEM/idl_hdf5.dlm)			F Datatype_id1:input Datatype_id2:input",	$
	"H5T_GET_ARRAY_DIMS					(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input /PERMUTATIONS:output",	$
	"H5T_GET_ARRAY_NDIMS					(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_GET_CLASS						(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_GET_CSET						(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_GET_EBIAS						(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_GET_FIELDS						(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_GET_INPAD						(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_GET_MEMBER_CLASS					(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input Member:input",	$
	"H5T_GET_MEMBER_INDEX					(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input Field_name:input",	$
	"H5T_GET_MEMBER_NAME					(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input Member:input",	$
	"H5T_GET_MEMBER_OFFSET					(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input Member:input",	$
	"H5T_GET_MEMBER_TYPE					(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input Member:input",	$
	"H5T_GET_MEMBER_VALUE					(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input Member:input",	$
	"H5T_GET_NMEMBERS					(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_GET_NORM						(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_GET_OFFSET						(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_GET_ORDER						(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_GET_PAD						(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_GET_PRECISION					(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_GET_SIGN						(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_GET_SIZE						(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_GET_STRPAD						(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_GET_SUPER						(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_GET_TAG						(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_IDL_CREATE						(SYSTEM/idl_hdf5.dlm)			F Data:input /MEMBER_NAMES:input /OPAQUE",	$
	"H5T_IDLTYPE						(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input /ARRAY_DIMENSIONS:output /STRUCTURE:output",	$
	"H5T_INSERT						(SYSTEM/idl_hdf5.dlm)			P Datatype_id:input Name:input Field_id:input",	$
	"H5T_MEMTYPE						(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5T_OPEN						(SYSTEM/idl_hdf5.dlm)			F Loc_id:input Name:input",	$
	"H5T_REFERENCE_CREATE					(SYSTEM/idl_hdf5.dlm)			F /REGION",	$
	"H5T_SET_TAG						(SYSTEM/idl_hdf5.dlm)			P Datatype_id:input Tag:input",	$
	"H5T_VLEN_CREATE					(SYSTEM/idl_hdf5.dlm)			F Datatype_id:input",	$
	"H5_GET_LIBVERSION					(SYSTEM/idl_hdf5.dlm)			F",	$
	"H5A_CLOSE						(SYSTEM/idl_hdf5.dlm)			P Attribute_id:input",	$
	"H5A_DELETE						(SYSTEM/idl_hdf5.dlm)			P Loc_id:input Name:input",	$
	"H5_CLOSE						(SYSTEM/idl_hdf5.dlm)			P",	$
	"H5_OPEN						(SYSTEM/idl_hdf5.dlm)			P",	$


	; idl_idlbridge.dlm
	; -----------------
	"IDL_IDLBRIDGE::ABORT					(SYSTEM/idl_idlbridge.dlm)				P",					$
	"IDL_IDLBRIDGE::CLEANUP					(SYSTEM/idl_idlbridge.dlm)				P",					$
	"IDL_IDLBRIDGE::EXECUTE					(SYSTEM/idl_idlbridge.dlm)				P IDLStmt:input /NOWAIT",		$
	"IDL_IDLBRIDGE::GETPROPERTY				(SYSTEM/idl_idlbridge.dlm)				P " + IDL_IDLBRIDGE_GETPROPERTY,	$
	"IDL_IDLBRIDGE::GETVAR					(SYSTEM/idl_idlbridge.dlm)				F VarName:input",			$
	"IDL_IDLBRIDGE::INIT					(SYSTEM/idl_idlbridge.dlm)				F " + IDL_IDLBRIDGE_INIT,		$
	"IDL_IDLBRIDGE::ONCALLBACK				(SYSTEM/idl_idlbridge.dlm)				P Status:output Error:output",		$
	"IDL_IDLBRIDGE::SETVAR					(SYSTEM/idl_idlbridge.dlm)				P Name:input Value:input",		$
	"IDL_IDLBRIDGE::STATUS					(SYSTEM/idl_idlbridge.dlm)				F /ERROR:output",			$
	"IDL_IDLBRIDGE::SETPROPERTY				(SYSTEM/idl_idlbridge.dlm)				P " + IDL_IDLBRIDGE_SETPROPERTY,	$


	; idl_jpeg2000.dlm
	; ----------------
	"IDLFFJPEG2000::CLEANUP					(SYSTEM/idl_jpeg2000.dlm)				P",																						$
	"IDLFFJPEG2000::GETDATA					(SYSTEM/idl_jpeg2000.dlm)				F /COMPONENT:input /DISCARD_LEVELS:input /MAX_LAYERS:input /N_COMPONENTS:input /ORDER:input /REGION:input /RGB /TILE_INDEX:input",						$
	"IDLFFJPEG2000::GETPROPERTY				(SYSTEM/idl_jpeg2000.dlm)				P " + IDLFFJPEG2000_GETPROPERTY,																		$
	"IDLFFJPEG2000::GETTILEPROPERTY				(SYSTEM/idl_jpeg2000.dlm)				P [TileIndex:input] [TileComponent:input] /N_LAYERS:output /N_LEVELS:output /PROGRESSION:output /REVERSIBLE:output /TILE_DIMENSIONS:output /TILE_OFFSET:output /YCC:output",	$
	"IDLFFJPEG2000::GETUUID					(SYSTEM/idl_jpeg2000.dlm)				F UUID:input /LENGTH:output",																			$
	"IDLFFJPEG2000::INIT					(SYSTEM/idl_jpeg2000.dlm)				F Filename:input /PERSISTENT " + IDLFFJPEG2000_INIT,																$
	"IDLFFJPEG2000::SETDATA					(SYSTEM/idl_jpeg2000.dlm)				P P1:input [Pn:inputs] /COMPONENT:input /ORDER /TILE_INDEX:input",																$
	"IDLFFJPEG2000::SETPROPERTY				(SYSTEM/idl_jpeg2000.dlm)				P " + IDLFFJPEG2000_SETPROPERTY,																		$
	"IDLFFJPEG2000::SETUUID					(SYSTEM/idl_jpeg2000.dlm)				P uuid:input Data:input",																			$


	; idl_livetools.dlm
	; -----------------
	;nodoc

	"GET_FWIDENT						(SYSTEM/idl_livetools.dlm)				F p1:???",		$ ; nodoc
	"ROLLOVER_FWIDENT					(SYSTEM/idl_livetools.dlm)				F p1:???",		$ ; nodoc
	"FWIDENT_ACQUIRE					(SYSTEM/idl_livetools.dlm)				P p1:???",		$ ; nodoc
	"FWIDENT_GC						(SYSTEM/idl_livetools.dlm)				P [p1:???]",		$ ; nodoc
	"FWIDENT_RELEASE					(SYSTEM/idl_livetools.dlm)				P p1:???",		$ ; nodoc
	"IDLFWSAVEABLERESTOREARRAY				(SYSTEM/idl_livetools.dlm)				P p1:???",		$ ; nodoc

	"IDLDSMAP::GETDATA					(SYSTEM/idl_livetools.dlm)				F p1:???",		$ ; nodoc
	"IDLDSMAP::GETKEYS					(SYSTEM/idl_livetools.dlm)				F [p1:???]",		$ ; nodoc
	"IDLDSMAP::GETSIZE					(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLDSMAP::INIT						(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLDSMAP::KEYEXISTS					(SYSTEM/idl_livetools.dlm)				F p1:???",		$ ; nodoc
	"IDLDSMAP::CLEANUP					(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLDSMAP::INSERT					(SYSTEM/idl_livetools.dlm)				P p1:??? p2:???",	$ ; nodoc
	"IDLDSMAP::REMOVE					(SYSTEM/idl_livetools.dlm)				P p1:???",		$ ; nodoc

	"IDLFWBEHAVIOR::INIT					(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWBEHAVIOR::ISREGISTERED				(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWBEHAVIOR::MESSAGESTRING				(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWBEHAVIOR::CLEANUP					(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWBEHAVIOR::EXECUTE					(SYSTEM/idl_livetools.dlm)				P [p1:???]",		$ ; nodoc
	"IDLFWBEHAVIOR::REGISTER				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWBEHAVIOR::RESTORE					(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWBEHAVIOR::SETMESSAGESTRING			(SYSTEM/idl_livetools.dlm)				P p1:???",		$ ; nodoc
	"IDLFWBEHAVIOR::UNREGISTER				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc

	"IDLFWDELAYARGBEHAV::INIT				(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWDELAYARGBEHAV::CLEANUP				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWDELAYARGBEHAV::DELAYEXECUTE			(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWDELAYARGBEHAV::EXECUTE				(SYSTEM/idl_livetools.dlm)				P p1:???",		$ ; nodoc

	"IDLFWDELAYBEHAV::INIT					(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWDELAYBEHAV::CLEANUP				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWDELAYBEHAV::DELAYEXECUTE				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWDELAYBEHAV::EXECUTE				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWDELAYBEHAV::RESTORE				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWDELAYBEHAV::SETMETHOD				(SYSTEM/idl_livetools.dlm)				P p1:???",		$ ; nodoc

	"IDLFWFUNCBEHAV::FUNC					(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWFUNCBEHAV::INIT					(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWFUNCBEHAV::CLEANUP				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWFUNCBEHAV::EXECUTE				(SYSTEM/idl_livetools.dlm)				P [p1:???]",		$ ; nodoc
	"IDLFWFUNCBEHAV::RESTORE				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWFUNCBEHAV::SETFUNC				(SYSTEM/idl_livetools.dlm)				P p1:???",		$ ; nodoc

	"IDLFWHASAHANDLER::HANDLER				(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWHASAHANDLER::INIT					(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWHASAHANDLER::CLEANUP				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWHASAHANDLER::RESTORE				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWHASAHANDLER::SETHANDLER				(SYSTEM/idl_livetools.dlm)				P p1:???",		$ ; nodoc

	"IDLFWMESSAGE::INIT					(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWMESSAGE::MESSAGESTRING				(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWMESSAGE::CLEANUP					(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWMESSAGE::RESTORE					(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWMESSAGE::SEND					(SYSTEM/idl_livetools.dlm)				P [p1:???]",		$ ; nodoc
	"IDLFWMESSAGE::SETMESSAGESTRING				(SYSTEM/idl_livetools.dlm)				P p1:???",		$ ; nodoc

	"IDLFWMESSAGEHANDLER::BEHAVIORS				(SYSTEM/idl_livetools.dlm)				F p1:???",		$ ; nodoc
	"IDLFWMESSAGEHANDLER::INIT				(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWMESSAGEHANDLER::ISSCOPED				(SYSTEM/idl_livetools.dlm)				F p1:???",		$ ; nodoc
	"IDLFWMESSAGEHANDLER::SCOPEDMESSAGES			(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWMESSAGEHANDLER::ADDBEHAVIOR			(SYSTEM/idl_livetools.dlm)				P p1:??? [p2:???]",	$ ; nodoc
	"IDLFWMESSAGEHANDLER::CLEANUP				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWMESSAGEHANDLER::REMOVEBEHAVIOR			(SYSTEM/idl_livetools.dlm)				P p1:??? [p2:???]",	$ ; nodoc
	"IDLFWMESSAGEHANDLER::RESTORE				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWMESSAGEHANDLER::SCOPEMESSAGE			(SYSTEM/idl_livetools.dlm)				P p1:???",		$ ; nodoc
	"IDLFWMESSAGEHANDLER::SENDMESSAGE			(SYSTEM/idl_livetools.dlm)				P p1:??? [p2:???]",	$ ; nodoc
	"IDLFWMESSAGEHANDLER::UNSCOPEMESSAGE			(SYSTEM/idl_livetools.dlm)				P p1:???",		$ ; nodoc

	"IDLFWOBJBEHAV::INIT					(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWOBJBEHAV::METHOD					(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWOBJBEHAV::OBJECT					(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWOBJBEHAV::CLEANUP					(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWOBJBEHAV::EXECUTE					(SYSTEM/idl_livetools.dlm)				P [p1:???]",		$ ; nodoc
	"IDLFWOBJBEHAV::RESTORE					(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWOBJBEHAV::SETMETHOD				(SYSTEM/idl_livetools.dlm)				P p1:???",		$ ; nodoc
	"IDLFWOBJBEHAV::SETOBJECT				(SYSTEM/idl_livetools.dlm)				P p1:???",		$ ; nodoc

	"IDLFWPROCBEHAV::INIT					(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWPROCBEHAV::PROC					(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWPROCBEHAV::CLEANUP				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWPROCBEHAV::EXECUTE				(SYSTEM/idl_livetools.dlm)				P [p1:???]",		$ ; nodoc
	"IDLFWPROCBEHAV::RESTORE				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWPROCBEHAV::SETPROC				(SYSTEM/idl_livetools.dlm)				P p1:???",		$ ; nodoc

	"IDLFWQUERY::INIT					(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWQUERY::RESULT					(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWQUERY::SENDQUERY					(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWQUERY::CLEANUP					(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWQUERY::RESTORE					(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWQUERY::SETRESULT					(SYSTEM/idl_livetools.dlm)				P p1:???",		$ ; nodoc

	"IDLFWQUERYBEHAV::INIT					(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWQUERYBEHAV::RESPONSE				(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWQUERYBEHAV::CLEANUP				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWQUERYBEHAV::EXECUTE				(SYSTEM/idl_livetools.dlm)				P p1:???",		$ ; nodoc
	"IDLFWQUERYBEHAV::RESTORE				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWQUERYBEHAV::SETRESPONSE				(SYSTEM/idl_livetools.dlm)				P [p1:???]",		$ ; nodoc

	"IDLFWSAVEABLE::INIT					(SYSTEM/idl_livetools.dlm)				F",			$ ; nodoc
	"IDLFWSAVEABLE::CLEANUP					(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWSAVEABLE::DORESTORE				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWSAVEABLE::RESETRESTORED				(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc
	"IDLFWSAVEABLE::RESTORE					(SYSTEM/idl_livetools.dlm)				P",			$ ; nodoc



	; idl_mjpeg2000.dlm
	; -----------------
	"IDLFFMJPEG2000::CLEANUP				(SYSTEM/idl_mjpeg2000.dlm)				P",																						$
	"IDLFFMJPEG2000::COMMIT					(SYSTEM/idl_mjpeg2000.dlm)				F Wait:input",																					$
	"IDLFFMJPEG2000::GETDATA				(SYSTEM/idl_mjpeg2000.dlm)				F FrameNumber:input /COMPONENT:input /DISCARD_LEVELS:input /MAX_LAYERS:input /N_COMPONENTS:input /ORDER /REGION:input /RGB /TILE_INDEX:input",					$
	"IDLFFMJPEG2000::GETPROPERTY				(SYSTEM/idl_mjpeg2000.dlm)				P " + IDLFFMJPEG2000_GETPROPERTY,																		$
	"IDLFFMJPEG2000::GETSEQUENTIALDATA			(SYSTEM/idl_mjpeg2000.dlm)				F Data:output /FRAME_NUMBER:output /FRAME_PERIOD:input /STEP:input",														$
	"IDLFFMJPEG2000::INIT					(SYSTEM/idl_mjpeg2000.dlm)				F Filename:input /PERSISTENT " + IDLFFMJPEG2000_INIT,																$
	"IDLFFMJPEG2000::RELEASESEQUENTIALDATA			(SYSTEM/idl_mjpeg2000.dlm)				P Frame_Index:input",																				$
	"IDLFFMJPEG2000::SETDATA				(SYSTEM/idl_mjpeg2000.dlm)				F A1:input [An:inputs] /COMPONENT:input /FRAME_PERIOD:input /ORDER /TILE_INDEX:input",													$
	"IDLFFMJPEG2000::STARTSEQUENTIALREADING			(SYSTEM/idl_mjpeg2000.dlm)				F /COMPONENT:input /DISCARD_LEVELS:input /MAX_LAYERS:input /N_COMPONENTS:input /ORDER /REGION:input /RGB /START_FRAME_NUMBER:input /STOP_FRAME_NUMBER:input /TILE_INDEX:input",	$
	"IDLFFMJPEG2000::STOPSEQUENTIALREADING			(SYSTEM/idl_mjpeg2000.dlm)				F",																						$
	"IDLFFMJPEG2000::SETPROPERTY				(SYSTEM/idl_mjpeg2000.dlm)				P " + IDLFFMJPEG2000_SETPROPERTY,	$


	; idl_mrsid.dlm
	; -------------
	"IDLFFMRSID::CLEANUP					(SYSTEM/idl_mrsid.dlm)					P",																					$
	"IDLFFMRSID::GETDIMSATLEVEL				(SYSTEM/idl_mrsid.dlm)					F Level:input",																				$
	"IDLFFMRSID::GETIMAGEDATA				(SYSTEM/idl_mrsid.dlm)					F /LEVEL:input /SUB_RECT:input",																	$
	"IDLFFMRSID::GETPROPERTY				(SYSTEM/idl_mrsid.dlm)					P /CHANNELS:output /DIMENSIONS:output /LEVELS:output /PIXEL_TYPE:output /TYPE:output /GEO_VALID:output /GEO_PROJTYPE:output /GEO_ORIGIN:output /GEO_RESOLUTION:output",	$
	"IDLFFMRSID::INIT					(SYSTEM/idl_mrsid.dlm)					F Filename:input " + IDLFFMRSID_INIT,																	$


	; idl_sem.dlm
	; -----------
	"IDL_SEMAPHORE::CLEANUP					(SYSTEM/idl_sem.dlm)					P",					$ ; nodoc
	"IDL_SEMAPHORE::GETPROPERTY				(SYSTEM/idl_sem.dlm)					P",					$ ; nodoc
	"IDL_SEMAPHORE::INIT					(SYSTEM/idl_sem.dlm)					F p1:???",				$ ; nodoc
	"IDL_SEMAPHORE::LOCK					(SYSTEM/idl_sem.dlm)					F",					$ ; nodoc
	"IDL_SEMAPHORE::RELEASE					(SYSTEM/idl_sem.dlm)					P",					$ ; nodoc
	"SEM_CREATE						(SYSTEM/idl_sem.dlm)					F strName:input /DESTROY_SEMAPHORE",	$
	"SEM_DELETE						(SYSTEM/idl_sem.dlm)					P strName:input",			$
	"SEM_LOCK						(SYSTEM/idl_sem.dlm)					F strName:input",			$
	"SEM_RELEASE						(SYSTEM/idl_sem.dlm)					P strName:input",			$


	; idl_shape.dlm
	; -------------
	"IDLFFSHAPE::ADDATTRIBUTE				(SYSTEM/idl_shape.dlm)					P Name:input Type:input Width:input /PRECISION:input",	$
	"IDLFFSHAPE::CLEANUP					(SYSTEM/idl_shape.dlm)					P",							$
	"IDLFFSHAPE::CLOSE					(SYSTEM/idl_shape.dlm)					P",							$
	"IDLFFSHAPE::DESTROYENTITY				(SYSTEM/idl_shape.dlm)					P Entity:input",					$
	"IDLFFSHAPE::GETATTRIBUTES				(SYSTEM/idl_shape.dlm)					F [Index:input] /ALL /ATTRIBUTE_STUCTURE",		$
	"IDLFFSHAPE::GETENTITY					(SYSTEM/idl_shape.dlm)					F [Index:input] /ALL /ATTRIBUTES",			$
	"IDLFFSHAPE::GETPROPERTY				(SYSTEM/idl_shape.dlm)					P " + IDLFFSHAPE_GETPROPERTY,				$
	"IDLFFSHAPE::INIT					(SYSTEM/idl_shape.dlm)					F [Filename:input] " + IDLFFSHAPE_INIT,			$ 
	"IDLFFSHAPE::OPEN					(SYSTEM/idl_shape.dlm)					F [Filename:input] /DBF_ONLY /ENTITY_TYPE:input /UPDATE",	$
	"IDLFFSHAPE::PUTENTITY					(SYSTEM/idl_shape.dlm)					P Data:input",						$
	"IDLFFSHAPE::SETATTRIBUTES+1				(SYSTEM/idl_shape.dlm)					P Index:input Attribute_Num:input Value:input",		$
	"IDLFFSHAPE::SETATTRIBUTES+2				(SYSTEM/idl_shape.dlm)					P Index:input Attributes:input",			$


	; idl_wavelet.dlm
	; ---------------
	"WV_DWT							(SYSTEM/idl_wavelet.dlm)				F Array:input Scaling:input Wavelet:input Ioff:input Joff:input /DOUBLE /INVERSE /N_LEVELS:input",	$
	"WV_PWT							(SYSTEM/idl_wavelet.dlm)				F A:input Scaling:input Wavelet:input Ioff:input Joff:input /DOUBLE /INVERSE",				$


	; idl_dataminer.dlm
	; -----------------
	"DB_EXISTS						(SYSTEM/idl_dataminer.dlm)				F",	$
	"DIALOG_DBCONNECT					(SYSTEM/idl_dataminer.dlm)				F DBobj:input /DATASOURCE:input /USER_ID:input /PASSWORD:input /DIALOG_PARENT:input",	$

	"IDLDBDATABASE::CONNECT					(SYSTEM/idl_dataminer.dlm)				P /CONNECTION:input /DATASOURCE:input /USER_ID:input /PASSWORD:input",	$
	"IDLDBDATABASE::CLEANUP					(SYSTEM/idl_dataminer.dlm)				P",									$ 
	"IDLDBDATABASE::EXECUTESQL				(SYSTEM/idl_dataminer.dlm)				P strSQL:input",							$
	"IDLDBDATABASE::GETDATASOURCES				(SYSTEM/idl_dataminer.dlm)				F",									$
	"IDLDBDATABASE::GETPROPERTY				(SYSTEM/idl_dataminer.dlm)				P " + IDLDBDATABASE_GETPROPERTY,					$
	"IDLDBDATABASE::GETTABLES				(SYSTEM/idl_dataminer.dlm)				F",									$
	"IDLDBDATABASE::INIT					(SYSTEM/idl_dataminer.dlm)				F " + IDLDBDATABASE_INIT,						$
	"IDLDBDATABASE::SETPROPERTY				(SYSTEM/idl_dataminer.dlm)				P " + IDLDBDATABASE_SETPROPERTY,					$

	"IDLDBRECORDSET::ADDRECORD				(SYSTEM/idl_dataminer.dlm)				P [fieldn:inputs] /SET_AUTOINCREMENT:input",			$
	"IDLDBRECORDSET::CLEANUP				(SYSTEM/idl_dataminer.dlm)				P",								$
	"IDLDBRECORDSET::CURRENTRECORD				(SYSTEM/idl_dataminer.dlm)				F",								$
	"IDLDBRECORDSET::DELETERECORD				(SYSTEM/idl_dataminer.dlm)				P",								$
	"IDLDBRECORDSET::GETFIELD				(SYSTEM/idl_dataminer.dlm)				F iFieldNumber:input /IS_NULL:output /NULL_VALUE:output",	$
	"IDLDBRECORDSET::GETPROPERTY				(SYSTEM/idl_dataminer.dlm)				P " + IDLDBRECORDSET_GETPROPERTY,				$
	"IDLDBRECORDSET::GETRECORD				(SYSTEM/idl_dataminer.dlm)				F",								$
	"IDLDBRECORDSET::INIT					(SYSTEM/idl_dataminer.dlm)				F p1:??? " + IDLDBRECORDSET_INIT,				$ ; pb doc (0 argument) ou dlm (1 argument)
	"IDLDBRECORDSET::MOVECURSOR				(SYSTEM/idl_dataminer.dlm)				F /ABSOLUTE:input /FIRST /LAST /NEXT /PRIOR /RELATIVE:input",	$
	"IDLDBRECORDSET::NFIELDS				(SYSTEM/idl_dataminer.dlm)				F",								$
	"IDLDBRECORDSET::SETFIELD				(SYSTEM/idl_dataminer.dlm)				P iFieldNumber:input [Value:input] /NULL",						$


	; idl_hdf.dlm
	; -----------
	"DFAN_LABLIST						(SYSTEM/idl_hdf.dlm)					F p1:??? p2:??? p3:??? p4:???",	$ ; nodoc
	"DFAN_LASTREF						(SYSTEM/idl_hdf.dlm)					F",				$ ; nodoc
	"DFP_LASTREF						(SYSTEM/idl_hdf.dlm)					F",				$ ; nodoc
	"DFP_NPALS						(SYSTEM/idl_hdf.dlm)					F p1:???",			$ ; nodoc
	"DF24_ADDIMAGE						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"DF24_GETIMAGE						(SYSTEM/idl_hdf.dlm)					P p1:??? P2:???",		$ ; nodoc
	"DF24_READREF						(SYSTEM/idl_hdf.dlm)					P p1:??? P2:???",		$ ; nodoc
	"DF24_RESTART						(SYSTEM/idl_hdf.dlm)					P",				$ ; nodoc
	"DFR8_ADDIMAGE						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:??? [p3:???]",	$ ; nodoc
	"DFR8_GETIMAGE						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:??? [p3:???]",	$ ; nodoc
	"DFR8_LASTREF						(SYSTEM/idl_hdf.dlm)					F",				$ ; nodoc
	"DFR8_NIMAGES						(SYSTEM/idl_hdf.dlm)					F p1:???",			$ ; nodoc
	"DFR8_PUTIMAGE						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:??? [p3:???]",	$ ; nodoc
	"DFR8_READREF						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"DFR8_RESTART						(SYSTEM/idl_hdf.dlm)					P",				$ ; nodoc
	"DFR8_SETPALETTE					(SYSTEM/idl_hdf.dlm)					P p1:???",			$ ; nodoc
	"HDF_VATTACH						(SYSTEM/idl_hdf.dlm)					F p1:??? P2:???",		$ ; nodoc
	"HDF_VGETID						(SYSTEM/idl_hdf.dlm)					F p1:??? p2:???",		$ ; nodoc
	"HDF_VGETNEXT						(SYSTEM/idl_hdf.dlm)					F p1:??? p2:???",		$ ; nodoc
	"HDF_VINQTAGREF						(SYSTEM/idl_hdf.dlm)					F P1:??? P2:??? p3:???",	$ ; nodoc
	"HDF_VISVG						(SYSTEM/idl_hdf.dlm)					F P1:??? P2:???",		$ ; nodoc
	"HDF_VISVS						(SYSTEM/idl_hdf.dlm)					F p1:??? p2:???",		$ ; nodoc
	"HDF_VLONE						(SYSTEM/idl_hdf.dlm)					F P1:???",			$ ; nodoc
	"HDF_VNTAGREFS						(SYSTEM/idl_hdf.dlm)					F p1:???",			$ ; nodoc
	"HDF_VSATTACH						(SYSTEM/idl_hdf.dlm)					F p1:??? p2:???",		$ ; nodoc
	"HDF_VSFEXIST						(SYSTEM/idl_hdf.dlm)					F p1:??? p2:???",		$ ; nodoc
	"HDF_VSFIND						(SYSTEM/idl_hdf.dlm)					F p1:??? p2:???",		$ ; nodoc
	"HDF_VSGETID						(SYSTEM/idl_hdf.dlm)					F p1:??? p2:???",		$ ; nodoc
	"HDF_VSLONE						(SYSTEM/idl_hdf.dlm)					F P1:???",			$ ; nodoc
	"HDF_VSREAD						(SYSTEM/idl_hdf.dlm)					F p1:??? p2:???",		$ ; nodoc
	"DFAN_ADDFDS						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"DFAN_ADDFID						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"DFAN_GETDESC						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:??? p3:??? p4:???",	$ ; nodoc
	"DFAN_GETFDS						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"DFAN_GETFID						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"DFAN_GETLABEL						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:??? p3:??? p4:???",	$ ; nodoc
	"DFAN_PUTDESC						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:??? p3:??? p4:???",	$ ; nodoc
	"DFAN_PUTLABEL						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:??? p3:??? p4:???",	$ ; nodoc
	"DFP_ADDPAL						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"DFP_GETPAL						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"DFP_PUTPAL						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"DFP_READREF						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"DFP_RESTART						(SYSTEM/idl_hdf.dlm)					P",				$ ; nodoc
	"DFP_WRITEREF						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"DFSD_ADDDATA						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"DFSD_DIMGET						(SYSTEM/idl_hdf.dlm)					P p1:input /LABEL:output",			$ ; nodoc
	"DFSD_DIMSET						(SYSTEM/idl_hdf.dlm)					P p1:???",			$ ; nodoc
	"DFSD_ENDSLICE						(SYSTEM/idl_hdf.dlm)					P",				$ ; nodoc
	"DFSD_GETDATA						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"DFSD_GETINFO						(SYSTEM/idl_hdf.dlm)					P [filename:input] /TYPE:output /DIMS:output /LABEL:output /UNIT:output /NSDS:output",			$ ; nodoc
	"DFSD_GETSLICE						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"DFSD_PUTSLICE						(SYSTEM/idl_hdf.dlm)					P p1:???",			$ ; nodoc
	"DFSD_READREF						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"DFSD_SETINFO						(SYSTEM/idl_hdf.dlm)					P /RESTART",				$ ; nodoc
	"DFSD_STARTSLICE					(SYSTEM/idl_hdf.dlm)					P p1:???",			$ ; nodoc
	"HDF_DFSD_ADDDATA					(SYSTEM/idl_hdf.dlm)					P p1:??? P2:???",		$ ; nodoc
	"HDF_DFSD_DIMGET					(SYSTEM/idl_hdf.dlm)					P p1:???",			$ ; nodoc
	"HDF_DFSD_DIMSET					(SYSTEM/idl_hdf.dlm)					P p1:???",			$ ; nodoc
	"HDF_DFSD_ENDSLICE					(SYSTEM/idl_hdf.dlm)					P",				$ ; nodoc
	"HDF_DFSD_GETDATA					(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"HDF_DFSD_GETINFO					(SYSTEM/idl_hdf.dlm)					P [p1:???]",			$ ; nodoc
	"HDF_DFSD_GETSLICE					(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"HDF_DFSD_PUTSLICE					(SYSTEM/idl_hdf.dlm)					P p1:???",			$ ; nodoc
	"HDF_DFSD_READREF					(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"HDF_DFSD_SETINFO					(SYSTEM/idl_hdf.dlm)					P",				$ ; nodoc
	"HDF_DFSD_STARTSLICE					(SYSTEM/idl_hdf.dlm)					P p1:???",			$ ; nodoc
	"HDF_VADDTAGREF						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:??? p3:???",	$ ; nodoc
	"HDF_VDETACH						(SYSTEM/idl_hdf.dlm)					P p1:???",			$ ; nodoc
	"HDF_VFGET						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"HDF_VGET						(SYSTEM/idl_hdf.dlm)					P p1:???",			$ ; nodoc
	"HDF_VGETTAGREF						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:??? p3:??? p4:???",	$ ; nodoc
	"HDF_VGETTAGREFS					(SYSTEM/idl_hdf.dlm)					P p1:??? p2:??? p3:???",	$ ; nodoc
	"HDF_VINSERT						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"HDF_VSDETACH						(SYSTEM/idl_hdf.dlm)					P p1:???",			$ ; nodoc
	"HDF_VSETCLASS						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"HDF_VSETNAME						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"HDF_VSFDEFINE						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"HDF_VSGET						(SYSTEM/idl_hdf.dlm)					P p1:???",			$ ; nodoc
	"HDF_VSSEEK						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",		$ ; nodoc
	"HDF_VSSET						(SYSTEM/idl_hdf.dlm)					P p1:???",			$ ; nodoc
	"HDF_VSWRITE						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:??? p3:???",	$ ; nodoc
	"EOS_GD_DEFTIMEPERIOD					(SYSTEM/idl_hdf.dlm)					F p1:??? p2:??? p3:??? p4:???",	$ ; nodoc

	"EOS_EH_CONVANG						(SYSTEM/idl_hdf.dlm)					F InAngle:input code:input",	$
	"EOS_EH_GETVERSION					(SYSTEM/idl_hdf.dlm)					F fid:input version:output",	$
	"EOS_EH_IDINFO						(SYSTEM/idl_hdf.dlm)					F fid:input HDFfid:output sdInterfaceID:output",	$
	"EOS_GD_ATTACH						(SYSTEM/idl_hdf.dlm)					F fid:input gridname:input",	$
	"EOS_GD_ATTRINFO					(SYSTEM/idl_hdf.dlm)					F gridID:input attrname:input numbertype:output count:output",	$
	"EOS_GD_BLKSOMOFFSET					(SYSTEM/idl_hdf.dlm)					F gridID:input offset:input code:input",	$
	"EOS_GD_CLOSE						(SYSTEM/idl_hdf.dlm)					F fid:input",	$
	"EOS_GD_COMPINFO					(SYSTEM/idl_hdf.dlm)					F gridID:input fieldname:input compcode:output compparm:output",	$
	"EOS_GD_CREATE						(SYSTEM/idl_hdf.dlm)					F fid:input gridname:input xdimsize:input ydimsize:input upleftpt:input lowrightpt:input",	$
	"EOS_GD_DEFBOXREGION					(SYSTEM/idl_hdf.dlm)					F gridID:input cornerlon:input cornerlat:input",	$
	"EOS_GD_DEFCOMP						(SYSTEM/idl_hdf.dlm)					F gridID:input compcode:input [compparm:input]",	$
	"EOS_GD_DEFDIM						(SYSTEM/idl_hdf.dlm)					F gridID:input dimname:input dim:input",	$
	"EOS_GD_DEFFIELD					(SYSTEM/idl_hdf.dlm)					F gridID:input fieldname:input dimlist:input numbertype:input /MERGE",	$
	"EOS_GD_DEFORIGIN					(SYSTEM/idl_hdf.dlm)					F gridID:input origincode:input",	$
	"EOS_GD_DEFPIXREG					(SYSTEM/idl_hdf.dlm)					F gridID:input pixreg:input",	$
	"EOS_GD_DEFPROJ						(SYSTEM/idl_hdf.dlm)					F gridID:input projcode:input zonecode:input spherecode:input projparm:input",	$
	"EOS_GD_DEFTILE						(SYSTEM/idl_hdf.dlm)					F gridID:input tilecode:input [tilerank:input] [tiledims:input]",	$
	"EOS_GD_DEFVRTREGION					(SYSTEM/idl_hdf.dlm)					F gridID:input regionID:input vertObj:input range:input",	$
	"EOS_GD_DETACH						(SYSTEM/idl_hdf.dlm)					F gridID:input",	$
	"EOS_GD_DIMINFO						(SYSTEM/idl_hdf.dlm)					F gridID:input dimname:input",	$
	"EOS_GD_DUPREGION					(SYSTEM/idl_hdf.dlm)					F regionID:input",	$
	"EOS_GD_EXTRACTREGION					(SYSTEM/idl_hdf.dlm)					F gridID:input regionID:input fieldname:input buffer:output",	$
	"EOS_GD_FIELDINFO					(SYSTEM/idl_hdf.dlm)					F gridID:input fieldname:input rank:output dims:output numbertype:output dimlist:output",	$
	"EOS_GD_GETFILLVALUE					(SYSTEM/idl_hdf.dlm)					F gridID:input fieldname:input fillvalue:output",	$
	"EOS_GD_GETPIXELS					(SYSTEM/idl_hdf.dlm)					F gridID:input nLonLat:input lonVal:input latVal:input pixRow:output pixCol:output",	$
	"EOS_GD_GETPIXVALUES					(SYSTEM/idl_hdf.dlm)					F gridID:input nPixels:input pixCol:input pixRow:input fieldname:input buffer:output",	$
	"EOS_GD_GRIDINFO					(SYSTEM/idl_hdf.dlm)					F gridID:input xdimsize:output ydimsize:output upleft:output lowright:output",	$
	"EOS_GD_INQATTRS					(SYSTEM/idl_hdf.dlm)					F gridID:input attrlist:output /LENGTH:output",	$
	"EOS_GD_INQDIMS						(SYSTEM/idl_hdf.dlm)					F gridID:input dimname:output dims:output",	$
	"EOS_GD_INQFIELDS					(SYSTEM/idl_hdf.dlm)					F gridID:input fieldlist:output rank:output numbertype:output",	$
	"EOS_GD_INQGRID						(SYSTEM/idl_hdf.dlm)					F filename:input gridlist:output /LENGTH:output",	$
	"EOS_GD_INTERPOLATE					(SYSTEM/idl_hdf.dlm)					F gridID:input Interp:input lonVal:input latVal:input fieldname:input interpVal:output",	$
	"EOS_GD_NENTRIES					(SYSTEM/idl_hdf.dlm)					F gridID:input entrycode:input /LENGTH:output",	$
	"EOS_GD_OPEN						(SYSTEM/idl_hdf.dlm)					F filename:input /CREATE /RDWR /READ",	$
	"EOS_GD_ORIGININFO					(SYSTEM/idl_hdf.dlm)					F gridID:input origincode:output",	$
	"EOS_GD_PIXREGINFO					(SYSTEM/idl_hdf.dlm)					F gridID:input pixregcode:output",	$
	"EOS_GD_PROJINFO					(SYSTEM/idl_hdf.dlm)					F gridID:input projcode:output zonecode:output spherecode:output projparm:output",	$
	"EOS_GD_READATTR					(SYSTEM/idl_hdf.dlm)					F gridID:input attrname:input datbuf:output",	$
	"EOS_GD_READFIELD					(SYSTEM/idl_hdf.dlm)					F gridID:input fieldname:input buffer:output /EDGE:input /START:input /STRIDE:input",	$
	"EOS_GD_READTILE					(SYSTEM/idl_hdf.dlm)					F gridID:input fieldname:input tilecoords:input buffer:output",	$
	"EOS_GD_REGIONINFO					(SYSTEM/idl_hdf.dlm)					F gridID:input regionID:input fieldname:input ntype:output rank:output dims:output size:output upleftpt:output lowrightpt:output",	$
	"EOS_GD_SETFILLVALUE					(SYSTEM/idl_hdf.dlm)					F gridID:input fieldname:input fillvalue:input",	$
	"EOS_GD_SETTILECACHE					(SYSTEM/idl_hdf.dlm)					F gridID:input fieldname:input maxcache:input cachecode:input",	$ ; pb doc (4 arguments) ou dlm (3 arguments)
	"EOS_GD_TILEINFO					(SYSTEM/idl_hdf.dlm)					F gridID:input fieldname:input tilecode:output tilerank:output tiledims:output",	$
	"EOS_GD_WRITEATTR					(SYSTEM/idl_hdf.dlm)					F gridID:input attrname:input datbuf:input /COUNT:input /HDF_TYPE:input",	$
	"EOS_GD_WRITEFIELD					(SYSTEM/idl_hdf.dlm)					F gridID:input fieldname:input data:input /EDGE:input /START:input /STRIDE:input",	$
	"EOS_GD_WRITEFIELDMETA					(SYSTEM/idl_hdf.dlm)					F gridID:input fieldname:input dimlist:input numbertype:input",	$
	"EOS_GD_WRITETILE					(SYSTEM/idl_hdf.dlm)					F gridID:input fieldname:input tilecoords:input data:input",	$
	"EOS_PT_ATTACH						(SYSTEM/idl_hdf.dlm)					F fid:input pointname:input",	$
	"EOS_PT_ATTRINFO					(SYSTEM/idl_hdf.dlm)					F pointID:input attrname:input numbertype:output count:output",	$
	"EOS_PT_BCKLINKINFO					(SYSTEM/idl_hdf.dlm)					F pointID:input level:input linkfield:output",	$
	"EOS_PT_CLOSE						(SYSTEM/idl_hdf.dlm)					F fid:input",	$
	"EOS_PT_CREATE						(SYSTEM/idl_hdf.dlm)					F fid:input pointname:input",	$
	"EOS_PT_DEFBOXREGION					(SYSTEM/idl_hdf.dlm)					F pointID:input cornerlon:input cornerlat:input",	$
	"EOS_PT_DEFLEVEL					(SYSTEM/idl_hdf.dlm)					F pointID:input levelname:input fieldlist:input fieldtype:input fieldorder:input",	$
	"EOS_PT_DEFLINKAGE					(SYSTEM/idl_hdf.dlm)					F pointID:input parent:input child:input linkfield:input",	$
	"EOS_PT_DEFTIMEPERIOD					(SYSTEM/idl_hdf.dlm)					F pointID:input starttime:input stoptime:input",	$
	"EOS_PT_DEFVRTREGION					(SYSTEM/idl_hdf.dlm)					F pointID:input regionID:input vertObj:input range:input",	$
	"EOS_PT_DETACH						(SYSTEM/idl_hdf.dlm)					F pointID:input",	$
	"EOS_PT_EXTRACTPERIOD					(SYSTEM/idl_hdf.dlm)					F pointID:input periodID:input level:input fieldlist:input buffer:output",	$
	"EOS_PT_EXTRACTREGION					(SYSTEM/idl_hdf.dlm)					F pointID:input regionID:input level:input fieldlist:input buffer:output",	$
	"EOS_PT_FWDLINKINFO					(SYSTEM/idl_hdf.dlm)					F pointID:input level:input linkfield:output",	$
	"EOS_PT_GETLEVELNAME					(SYSTEM/idl_hdf.dlm)					F pointID:input level:input levelname:output /LENGTH:output",	$
	"EOS_PT_GETRECNUMS					(SYSTEM/idl_hdf.dlm)					F pointID:input inlevel:input outlevel:input inNrec:input inRecs:input outNrec:output outRecs:output",	$
	"EOS_PT_INQATTRS					(SYSTEM/idl_hdf.dlm)					F pointID:input attrlist:output /LENGTH:output",	$
	"EOS_PT_INQPOINT					(SYSTEM/idl_hdf.dlm)					F filename:input pointlist:output /LENGTH:output",	$
	"EOS_PT_LEVELINDX					(SYSTEM/idl_hdf.dlm)					F pointID:input levelname:input",	$
	"EOS_PT_LEVELINFO					(SYSTEM/idl_hdf.dlm)					F pointID:input level:input fieldlist:output fldtype:output fldorder:output",	$
	"EOS_PT_NFIELDS						(SYSTEM/idl_hdf.dlm)					F pointID:input level:input /LENGTH:input",	$
	"EOS_PT_NLEVELS						(SYSTEM/idl_hdf.dlm)					F pointID:input",	$
	"EOS_PT_NRECS						(SYSTEM/idl_hdf.dlm)					F pointID:input level:input",	$
	"EOS_PT_OPEN						(SYSTEM/idl_hdf.dlm)					F fieldname:input /CREATE /RDWR /READ",	$
	"EOS_PT_PERIODINFO					(SYSTEM/idl_hdf.dlm)					F pointID:input periodID:input level:input fieldlist:input size:output",	$
	"EOS_PT_PERIODRECS					(SYSTEM/idl_hdf.dlm)					F pointID:input periodID:input level:input nrec:output recs:output",	$
	"EOS_PT_READATTR					(SYSTEM/idl_hdf.dlm)					F pointID:input attrname:input datbuf:output",	$
	"EOS_PT_READLEVEL					(SYSTEM/idl_hdf.dlm)					F pointID:input level:input fieldlist:input nrec:input recs:input buffer:output",	$
	"EOS_PT_REGIONINFO					(SYSTEM/idl_hdf.dlm)					F pointID:input regionID:input level:input fieldlist:input size:output",	$
	"EOS_PT_REGIONRECS					(SYSTEM/idl_hdf.dlm)					F pointID:input regionID:input level:input nrec:output recs:output",	$
	"EOS_PT_SIZEOF						(SYSTEM/idl_hdf.dlm)					F pointID:input fieldlist:input fldlevel:output",	$
	"EOS_PT_UPDATELEVEL					(SYSTEM/idl_hdf.dlm)					F pointID:input level:input field:input list:input nrec:input recs:input data:input",	$ ; pb doc(7 arguments) ou dlm(6 arguments)
	"EOS_PT_WRITEATTR					(SYSTEM/idl_hdf.dlm)					F pointID:input attrname:input datbuf:input /COUNT:input /HDF_TYPE:input",	$
	"EOS_PT_WRITELEVEL					(SYSTEM/idl_hdf.dlm)					F pointID:input level:input nrec:input data:input",	$
	"EOS_SW_ATTACH						(SYSTEM/idl_hdf.dlm)					F fid:input swathname:input",	$
	"EOS_SW_ATTRINFO					(SYSTEM/idl_hdf.dlm)					F swathID:input attrname:input numbertype:output count:output",	$
	"EOS_SW_CLOSE						(SYSTEM/idl_hdf.dlm)					F fid:input",	$
	"EOS_SW_COMPINFO					(SYSTEM/idl_hdf.dlm)					F swathID:input fieldname:input compcode:output compparm:output",	$
	"EOS_SW_CREATE						(SYSTEM/idl_hdf.dlm)					F fid:input swathname:input",	$
	"EOS_SW_DEFBOXREGION					(SYSTEM/idl_hdf.dlm)					F swathID:input cornerlon:input cornerlat:input mode:input",	$
	"EOS_SW_DEFCOMP						(SYSTEM/idl_hdf.dlm)					F swathID:input compcode:input [compparm:input]",	$
	"EOS_SW_DEFDATAFIELD					(SYSTEM/idl_hdf.dlm)					F swathID:input fieldname:input dimlist:input numbertype:input /MERGE",	$
	"EOS_SW_DEFDIM						(SYSTEM/idl_hdf.dlm)					F swathID:input fieldname:input dim:input",	$
	"EOS_SW_DEFDIMMAP					(SYSTEM/idl_hdf.dlm)					F swathID:input geodim:input datadim:input offset:input increment:input",	$
	"EOS_SW_DEFGEOFIELD					(SYSTEM/idl_hdf.dlm)					F swathID:input fieldname:input dimlist:input numbertype:input /MERGE",	$
	"EOS_SW_DEFIDXMAP					(SYSTEM/idl_hdf.dlm)					F swathID:input geodim:input datadim:input index:input",	$
	"EOS_SW_DEFTIMEPERIOD					(SYSTEM/idl_hdf.dlm)					F swathID:input starttime:input stoptime:input [mode:input]",	$
	"EOS_SW_DEFVRTREGION					(SYSTEM/idl_hdf.dlm)					F swathID:input regionID:input vertObj:input range:input",	$
	"EOS_SW_DETACH						(SYSTEM/idl_hdf.dlm)					F swathID:input",	$
	"EOS_SW_DIMINFO						(SYSTEM/idl_hdf.dlm)					F swathID:input dimname:input",	$
	"EOS_SW_DUPREGION					(SYSTEM/idl_hdf.dlm)					F regionID:input",	$
	"EOS_SW_EXTRACTPERIOD					(SYSTEM/idl_hdf.dlm)					F swathID:input periodID:input fieldname:input external_mode:input buffer:output",	$
	"EOS_SW_EXTRACTREGION					(SYSTEM/idl_hdf.dlm)					F swathID:input regionID:input fieldname:input external_mode:input buffer:output",	$
	"EOS_SW_FIELDINFO					(SYSTEM/idl_hdf.dlm)					F swathID:input fieldname:input rank:output dims:output numbertype:output dimlist:output",	$
	"EOS_SW_GETFILLVALUE					(SYSTEM/idl_hdf.dlm)					F swathID:input fieldname:input fillvalue:output",	$
	"EOS_SW_IDXMAPINFO					(SYSTEM/idl_hdf.dlm)					F swathID:input geodim:input datadim:input index:output",	$
	"EOS_SW_INQATTRS					(SYSTEM/idl_hdf.dlm)					F swathID:input attrlist:input /LENGTH:output",	$
	"EOS_SW_INQDATAFIELDS					(SYSTEM/idl_hdf.dlm)					F swathID:input fieldlist:output rank:output numbertype:output",	$
	"EOS_SW_INQDIMS						(SYSTEM/idl_hdf.dlm)					F swathID:input dimname:output dim:output",	$
	"EOS_SW_INQGEOFIELDS					(SYSTEM/idl_hdf.dlm)					F swathID:input fieldlist:output rank:output numbertype:output",	$
	"EOS_SW_INQIDXMAPS					(SYSTEM/idl_hdf.dlm)					F swathID:input idxmap:output idxsizes:output",	$
	"EOS_SW_INQMAPS						(SYSTEM/idl_hdf.dlm)					F swathID:input dimmap:output offset:output increment:output",	$
	"EOS_SW_INQSWATH					(SYSTEM/idl_hdf.dlm)					F filename:input swathlist:input /LENGTH:input",	$
	"EOS_SW_MAPINFO						(SYSTEM/idl_hdf.dlm)					F swathID:input geodim:input datadim:input offset:output increment:output",	$
	"EOS_SW_NENTRIES					(SYSTEM/idl_hdf.dlm)					F swathID:input entrycode:input /LENGTH:output",	$
	"EOS_SW_OPEN						(SYSTEM/idl_hdf.dlm)					F filename:input /CREATE /RDWR /READ",	$
	"EOS_SW_PERIODINFO					(SYSTEM/idl_hdf.dlm)					F swathID:input periodID:input fieldname:input ntype:output rank:output dims:output size:output",	$
	"EOS_SW_READATTR					(SYSTEM/idl_hdf.dlm)					F swathID:input attrname:input datbuf:output",	$
	"EOS_SW_READFIELD					(SYSTEM/idl_hdf.dlm)					F swathID:input fieldname:input buffer:output /EDGE:input /START:input /STRIDE:input",	$
	"EOS_SW_REGIONINFO					(SYSTEM/idl_hdf.dlm)					F swathID:input regionID:input fieldname:input ntype:output rank:output dims:output size:output",	$
	"EOS_SW_SETFILLVALUE					(SYSTEM/idl_hdf.dlm)					F swathID:input fieldname:input fillvalue:input",	$
	"EOS_SW_WRITEATTR					(SYSTEM/idl_hdf.dlm)					F swathID:input attrname:input datbuf:input /COUNT:input /HDF_TYPE:input",	$
	"EOS_SW_WRITEDATAMETA					(SYSTEM/idl_hdf.dlm)					F swathID:input fieldname:input dimlist:input numbertype:input",	$
	"EOS_SW_WRITEFIELD					(SYSTEM/idl_hdf.dlm)					F swathID:input fieldname:input data:input /EDGE:input /START:input /STRIDE:input",	$
	"EOS_SW_WRITEGEOMETA					(SYSTEM/idl_hdf.dlm)					F swathID:input fieldname:input dimlist:input numbertype:input",	$

	"HDF_AN_ANNLEN						(SYSTEM/idl_hdf.dlm)					F Annotation_id:input",	$
	"HDF_AN_ANNLIST						(SYSTEM/idl_hdf.dlm)					F Annotation_id:input Annotation_type:input Object_tag:input Object_ref:input Annotation_list:output",	$
	"HDF_AN_ATYPE2TAG					(SYSTEM/idl_hdf.dlm)					F Annotation_type:input",	$
	"HDF_AN_CREATE						(SYSTEM/idl_hdf.dlm)					F Annotation_id:input Object_tag:input Object_ref:input Annotation_type:input",	$
	"HDF_AN_CREATEF						(SYSTEM/idl_hdf.dlm)					F Annotation_id:input Annotation_type:input",	$
	"HDF_AN_END						(SYSTEM/idl_hdf.dlm)					P Annotation_id:input",	$
	"HDF_AN_ENDACCESS					(SYSTEM/idl_hdf.dlm)					P Annotation_id:input",	$
	"HDF_AN_FILEINFO					(SYSTEM/idl_hdf.dlm)					F Annotation_id:input n_file_labels:output n_file_descs:output n_data_labels:output n_data_descs:output",	$
	"HDF_AN_GET_TAGREF					(SYSTEM/idl_hdf.dlm)					F Annotation_id:input index:input Annotation_type:input Annotation_tag:output Annotation_ref:output",	$
	"HDF_AN_ID2TAGREF					(SYSTEM/idl_hdf.dlm)					F Annotation_id:input Annotation_tag:output Annotation_ref:output",	$
	"HDF_AN_NUMANN						(SYSTEM/idl_hdf.dlm)					F Annotation_id:input Annotation_type:input Object_tag:input Object_ref:input",	$
	"HDF_AN_READANN						(SYSTEM/idl_hdf.dlm)					F Annotation_id:input annotation:output /LENGTH:input",	$
	"HDF_AN_SELECT						(SYSTEM/idl_hdf.dlm)					F Annotation_id:input index:input Annotation_type:input",	$
	"HDF_AN_START						(SYSTEM/idl_hdf.dlm)					F file_id:input",	$
	"HDF_AN_TAG2ATYPE					(SYSTEM/idl_hdf.dlm)					F Annotation_tag:input",	$
	"HDF_AN_TAGREF2ID					(SYSTEM/idl_hdf.dlm)					F Annotation_id:input Annotation_tag:input Annotation_ref:input",	$
	"HDF_AN_WRITEANN					(SYSTEM/idl_hdf.dlm)					F Annotation_id:input annotation:input /LENGTH:input",	$


	"HDF_DF24_ADDIMAGE					(SYSTEM/idl_hdf.dlm)					P Filename:input Image:input /FORCE_BASELINE /JPEG /RLE /QUALITY:input",	$
	"HDF_DF24_GETIMAGE					(SYSTEM/idl_hdf.dlm)					P Filename:input Image:output /LINE /PIXEL /PLANE",	$
	"HDF_DF24_GETINFO					(SYSTEM/idl_hdf.dlm)					P Filename:input Width:output Height:output Interlace:output",	$
	"HDF_DF24_LASTREF					(SYSTEM/idl_hdf.dlm)					F",			$
	"HDF_DF24_NIMAGES					(SYSTEM/idl_hdf.dlm)					F Filename:input",	$
	"HDF_DF24_READREF					(SYSTEM/idl_hdf.dlm)					P Filename:input Reference_number:input",	$
	"HDF_DF24_RESTART					(SYSTEM/idl_hdf.dlm)					P",	$

	"HDF_DFAN_ADDFDS					(SYSTEM/idl_hdf.dlm)					P Filename:input Description:input",	$
	"HDF_DFAN_ADDFID					(SYSTEM/idl_hdf.dlm)					P Filename:input Label:input",	$
	"HDF_DFAN_GETDESC					(SYSTEM/idl_hdf.dlm)					P Filename:input Tag:input Ref:input Description:output /STRING",	$
	"HDF_DFAN_GETFDS					(SYSTEM/idl_hdf.dlm)					P Filename:input Description:input /FIRST /STRING",	$
	"HDF_DFAN_GETFID					(SYSTEM/idl_hdf.dlm)					P Filename:input Label:input /FIRST",	$
	"HDF_DFAN_GETLABEL					(SYSTEM/idl_hdf.dlm)					P Filename:input Tag:input Ref:input Label:output",	$ 
	"HDF_DFAN_LABLIST					(SYSTEM/idl_hdf.dlm)					F Filename:input Tag:input Reflist:input Labellist:input /LISTSIZE:input /MAXLABEL:input /STARTPOS:input /STRING",	$
	"HDF_DFAN_LASTREF					(SYSTEM/idl_hdf.dlm)					F",	$
	"HDF_DFAN_PUTDESC					(SYSTEM/idl_hdf.dlm)					P Filename:input Tag:input Ref:input Description:input",	$
	"HDF_DFAN_PUTLABEL					(SYSTEM/idl_hdf.dlm)					P Filename:input Tag:input Ref:input Label:input",	$

	"HDF_DFP_ADDPAL						(SYSTEM/idl_hdf.dlm)					P Filename:input Palette:input",	$
	"HDF_DFP_GETPAL						(SYSTEM/idl_hdf.dlm)					P Filename:input Palette:output",	$
	"HDF_DFP_LASTREF					(SYSTEM/idl_hdf.dlm)					F",	$
	"HDF_DFP_NPALS						(SYSTEM/idl_hdf.dlm)					F Filename:input",	$
	"HDF_DFP_PUTPAL						(SYSTEM/idl_hdf.dlm)					P Filename:input Palette:input /DELETE /OVERWRITE",	$
	"HDF_DFP_READREF					(SYSTEM/idl_hdf.dlm)					P Filename:input Reference_number:input",	$
	"HDF_DFP_RESTART					(SYSTEM/idl_hdf.dlm)					P",	$
	"HDF_DFP_WRITEREF					(SYSTEM/idl_hdf.dlm)					P Filename:input Reference_number:input",	$

	"HDF_DFR8_ADDIMAGE					(SYSTEM/idl_hdf.dlm)					P Filename:input Image:input /FORCE_BASELINE /JPEG /RLE /IMCOMP /PALETTE:input /QUALITY:input",	$
	"HDF_DFR8_GETIMAGE					(SYSTEM/idl_hdf.dlm)					P Filename:input Image:output [Palette:output]",	$
	"HDF_DFR8_GETINFO					(SYSTEM/idl_hdf.dlm)					P Filename:input Width:output Height:output Has_Palette:output",	$
	"HDF_DFR8_LASTREF					(SYSTEM/idl_hdf.dlm)					F",	$
	"HDF_DFR8_NIMAGES					(SYSTEM/idl_hdf.dlm)					F Filename:input",	$
	"HDF_DFR8_PUTIMAGE					(SYSTEM/idl_hdf.dlm)					P Filename:input Image:input /FORCE_BASELINE /IMCOMP /PALETTE:input /JPEG /RLE /QUALITY:input",	$
	"HDF_DFR8_READREF					(SYSTEM/idl_hdf.dlm)					P Filename:input Reference_number:input",	$
	"HDF_DFR8_RESTART					(SYSTEM/idl_hdf.dlm)					P",	$
	"HDF_DFR8_SETPALETTE					(SYSTEM/idl_hdf.dlm)					P Palette:input",	$

	"HDF_DUPDD						(SYSTEM/idl_hdf.dlm)					P FileHandle:input NewTag:input NewRef:input OldTag:input OldRef:input",	$

	"HDF_GR_ATTRINFO					(SYSTEM/idl_hdf.dlm)					F obj_id:input attr_index:input name:output data_type:output count:output",	$
	"HDF_GR_CREATE						(SYSTEM/idl_hdf.dlm)					F gr_id:input name:input ncomp:input data_type:input interlace_mode:input dim_sizes:input",	$
	"HDF_GR_END						(SYSTEM/idl_hdf.dlm)					P gr_id:input",	$
	"HDF_GR_ENDACCESS					(SYSTEM/idl_hdf.dlm)					P ri_id:input",	$
	"HDF_GR_FILEINFO					(SYSTEM/idl_hdf.dlm)					F gr_id:input n_images:output n_file_attrs:output",	$
	"HDF_GR_FINDATTR					(SYSTEM/idl_hdf.dlm)					F obj_id:input attr_name:input",	$
	"HDF_GR_GETATTR						(SYSTEM/idl_hdf.dlm)					F obj_id:input attr_index:input values:input",	$
	"HDF_GR_GETCHUNKINFO					(SYSTEM/idl_hdf.dlm)					F ri_id:input dim_length:output flag:output",	$
	"HDF_GR_GETIMINFO					(SYSTEM/idl_hdf.dlm)					F ri_id:input gr_name:output ncomp:output data_type:output interlace_mode:output dim_sizes:output num_attrs:output",	$
	"HDF_GR_GETLUTID					(SYSTEM/idl_hdf.dlm)					F ri_id:input pal_index:input",	$
	"HDF_GR_GETLUTINFO					(SYSTEM/idl_hdf.dlm)					F pal_id:input ncomp:output data_type:output interlace_mode:output num_entries:output",	$
	"HDF_GR_IDTOREF						(SYSTEM/idl_hdf.dlm)					F ri_id:input",	$
	"HDF_GR_LUTTOREF					(SYSTEM/idl_hdf.dlm)					F pal_id:input",	$
	"HDF_GR_NAMETOINDEX					(SYSTEM/idl_hdf.dlm)					F gr_id:input gr_name:input",	$
	"HDF_GR_READIMAGE					(SYSTEM/idl_hdf.dlm)					F ri_id:input data:output /EDGE:input /INTERLACE /START /STRIDE:input",	$
	"HDF_GR_READLUT						(SYSTEM/idl_hdf.dlm)					F pal_id:input pal_data:output /INTERLACE",	$
	"HDF_GR_REFTOINDEX					(SYSTEM/idl_hdf.dlm)					F gr_id:input gr_ref:input",	$
	"HDF_GR_SELECT						(SYSTEM/idl_hdf.dlm)					F gr_id:input index:input",	$
	"HDF_GR_SETATTR						(SYSTEM/idl_hdf.dlm)					F obj_id:input attr_name:input data_type:input count:input values:input",	$
	"HDF_GR_SETCHUNK					(SYSTEM/idl_hdf.dlm)					F ri_id:input dim_length:input comp_type:input comp_prm:input",	$
	"HDF_GR_SETCHUNKCACHE					(SYSTEM/idl_hdf.dlm)					F ri_id:input maxcache:input flags:input",	$
	"HDF_GR_SETCOMPRESS					(SYSTEM/idl_hdf.dlm)					F ri_id:input comp_type:input comp_prm:input",	$
	"HDF_GR_SETEXTERNALFILE					(SYSTEM/idl_hdf.dlm)					F ri_id:input filename:input offset:input",	$
	"HDF_GR_START						(SYSTEM/idl_hdf.dlm)					F file_id:input",	$
	"HDF_GR_WRITEIMAGE					(SYSTEM/idl_hdf.dlm)					F ri_id:input data:input /EDGE:input /INTERLACE:input /START:input /STRIDE:input",	$
	"HDF_GR_WRITELUT					(SYSTEM/idl_hdf.dlm)					F pal_id:input pal_data:input",	$

	"HDF_HDF2IDLTYPE					(SYSTEM/idl_hdf.dlm)					F hdftypecode:input",	$
	"HDF_IDL2HDFTYPE					(SYSTEM/idl_hdf.dlm)					F idltypecode:input",	$

	"HDF_ISHDF						(SYSTEM/idl_hdf.dlm)					F Filename:input",	$
	"HDF_LIB_INFO						(SYSTEM/idl_hdf.dlm)					P [FileHandle:input] /MAJOR:output /MINOR:output /RELEASE:output /VERSION:output",	$

	"HDF_NEWREF						(SYSTEM/idl_hdf.dlm)					F FileHandle:input",	$
	"HDF_NUMBER						(SYSTEM/idl_hdf.dlm)					F FileHandle:input /TAG:input",	$
	"HDF_OPEN						(SYSTEM/idl_hdf.dlm)					F Filename:input /ALL /CREATE /NUM_DD:input /RDWR /READ /WRITE",	$
	"HDF_PACKDATA						(SYSTEM/idl_hdf.dlm)					F data1:input [data2:input]  [data3:input] [data4:input] [data5:input] [data6:input] [data7:input] [data8:input] /HDF_ORDER:input /HDF_TYPE:input /NREC:input",	$

	"HDF_SD_ADDDATA						(SYSTEM/idl_hdf.dlm)					P SDdataset_id:input Data:input /COUNT:input /NOREVERSE /START:input /STRIDE:input ",	$
	"HDF_SD_ATTRFIND					(SYSTEM/idl_hdf.dlm)					F SD_id:input Name:input [p3:???]",	$
	"HDF_SD_ATTRINFO					(SYSTEM/idl_hdf.dlm)					P SD_id:input Attr_Index:input /COUNT:output /DATA:output /HDF_TYPE:output /NAME:output /TYPE:output",	$
	"HDF_SD_ATTRSET						(SYSTEM/idl_hdf.dlm)					P SD_id:input Attr_Name:input Values:input [Count:input] /BYTE /DFNT_CHAR /DFNT_FLOAT32 /DFNT_FLOAT64 /DFNT_INT8 /DFNT_INT16 /DFNT_INT32 /DFNT_UINT8 /DFNT_UINT16 /DFNT_UINT32 /DOUBLE /FLOAT /INT /LONG /SHORT /STRING",	$
	"HDF_SD_CREATE						(SYSTEM/idl_hdf.dlm)					F SDinterface_id:input Name:input Dims:input /BYTE /DFNT_CHAR8 /DFNT_FLOAT32 /DFNT_FLOAT64 /DFNT_INT8 /DFNT_INT16 /DFNT_INT32 /DFNT_UINT8 /DFNT_UINT16 /DFNT_UINT32 /DOUBLE /FLOAT /HDF_TYPE:input /INT /LONG /SHORT /STRING",	$
	"HDF_SD_DIMGET						(SYSTEM/idl_hdf.dlm)					P Dim_ID:input /COUNT /COMPATIBILITY:output /FORMAT /LABEL /NAME /NATTR /SCALE /TYPE /UNIT",	$
	"HDF_SD_DIMGETID					(SYSTEM/idl_hdf.dlm)					F SDdataset_id:input Dimension_Number:input",	$
	"HDF_SD_DIMSET						(SYSTEM/idl_hdf.dlm)					P Dim_ID:input /BW_INCOMP /FORMAT:input /LABEL:input /NAME:input /SCALE:input /UNIT:input",	$
	"HDF_SD_END						(SYSTEM/idl_hdf.dlm)					P SDinterface_id:input",	$
	"HDF_SD_ENDACCESS					(SYSTEM/idl_hdf.dlm)					P SDinterface_id:input",	$
	"HDF_SD_FILEINFO					(SYSTEM/idl_hdf.dlm)					P SDinterface_id:input Datasets:output Attributes:output",	$
	"HDF_SD_GETDATA						(SYSTEM/idl_hdf.dlm)					P SDdataset_id:input Data:output /COUNT:input /NOREVERSE /START:input /STRIDE:input",	$
	"HDF_SD_GETINFO						(SYSTEM/idl_hdf.dlm)					P SDdataset_id:input /CALDATA:output /COORDSYS:output /DIMS:output /FILL:output /FORMAT:output /HDF_TYPE:output /LABEL:output /NAME:output /NATTS:output /NDIMS:output /NOREVERSE /RANGE:output /TYPE:output /UNIT:output",	$
	"HDF_SD_IDTOREF						(SYSTEM/idl_hdf.dlm)					F SDdataset_id:input",	$
	"HDF_SD_ISCOORDVAR					(SYSTEM/idl_hdf.dlm)					F SDdataset_id:input",	$
	"HDF_SD_NAMETOINDEX					(SYSTEM/idl_hdf.dlm)					F SDinterface_id:input SDS_Name:input",	$
	"HDF_SD_REFTOINDEX					(SYSTEM/idl_hdf.dlm)					F SDinterface_id:input Reference_number:input",	$
	"HDF_SD_SELECT						(SYSTEM/idl_hdf.dlm)					F SDinterface_id:input Number:input",	$
	"HDF_SD_SETCOMPRESS					(SYSTEM/idl_hdf.dlm)					P SDdataset_id:input comptype:input /EFFORT:input",	$
	"HDF_SD_SETEXTFILE					(SYSTEM/idl_hdf.dlm)					P SDdataset_id:input Filename:input /OFFSET:input",	$
	"HDF_SD_SETINFO						(SYSTEM/idl_hdf.dlm)					P SDdataset_id:input /CALDATA:input /COORDSYS:input /FILL:input /FORMAT:input /LABEL:input /RANGE:input /UNIT:input",	$
	"HDF_SD_START						(SYSTEM/idl_hdf.dlm)					F Filename:input /READ /RDWR /CREATE",	$

	"HDF_UNPACKDATA						(SYSTEM/idl_hdf.dlm)					P packeddata:input data1:output [data2:output] [data3:output] [data4:output] [data5:output] [data6:output] [data7:output] [data8:output] /HDF_ORDER:input /HDF_TYPE:input /NREC:input",	$

	"HDF_VD_ATTACH						(SYSTEM/idl_hdf.dlm)					F FileHandle:input VData_id:input /READ /WRITE",	$
	"HDF_VD_ATTRFIND					(SYSTEM/idl_hdf.dlm)					F VData:input FieldID:input Name:input",	$
	"HDF_VD_ATTRINFO					(SYSTEM/idl_hdf.dlm)					P VData:input FieldID:input AttrID:input /COUNT:output /DATA:output /HDF_TYPE:output /NAME:output /TYPE:output",	$
	"HDF_VD_ATTRSET						(SYSTEM/idl_hdf.dlm)					P VData:input FieldID:input Attr_Name:input Values:input [Count:input] /BYTE /DFNT_CHAR8 /DFNT_FLOAT32 /DFNT_FLOAT64 /DFNT_INT8 /DFNT_INT16 /DFNT_INT32 /DFNT_UCHAR8 /DFNT_UINT8 /DFNT_UINT16 /DFNT_UINT32 /DOUBLE /FLOAT /INT /LONG /SHORT /STRING /UINT /ULONG",	$
	"HDF_VD_DETACH						(SYSTEM/idl_hdf.dlm)					P VData:input",	$
	"HDF_VD_DEFINE						(SYSTEM/idl_hdf.dlm)					P p1:??? p2:???",	$
	"HDF_VD_FDEFINE						(SYSTEM/idl_hdf.dlm)					P VData:input Fieldname:input /BYTE /DOUBLE /FLOAT /INT /LONG /ORDER:input /UINT /ULONG",	$
	"HDF_VD_FEXIST						(SYSTEM/idl_hdf.dlm)					F VData:input Fieldnames:input",	$
	"HDF_VD_FIND						(SYSTEM/idl_hdf.dlm)					F FileHandle:input Name:input",	$
	"HDF_VD_GET						(SYSTEM/idl_hdf.dlm)					P VData:input /CLASS:output /COUNT:output /FIELDS:output /INTERLACE:output /NAME:output /NFIELDS:output /REF:output /SIZE:output /TAG:output",	$
	"HDF_VD_GETID						(SYSTEM/idl_hdf.dlm)					F FileHandle:input VData_id:input",	$
	"HDF_VD_GETINFO						(SYSTEM/idl_hdf.dlm)					P VData:input Index:input /NAME:output /ORDER:output /SIZE:output /TYPE:output",	$
	"HDF_VD_GETNEXT						(SYSTEM/idl_hdf.dlm)					F VGroup:input Id:input",	$
	"HDF_VD_INSERT						(SYSTEM/idl_hdf.dlm)					P VGroup:input VData:input /POSITION:output",	$
	"HDF_VD_ISATTR						(SYSTEM/idl_hdf.dlm)					F VData:input",	$
	"HDF_VD_ISVD						(SYSTEM/idl_hdf.dlm)					F VGroup:input Id:input",	$
	"HDF_VD_ISVG						(SYSTEM/idl_hdf.dlm)					F VGroup:input Id:input",	$
	"HDF_VD_LONE						(SYSTEM/idl_hdf.dlm)					F FileHandle:input /MAXSIZE:input",	$
	"HDF_VD_NATTRS						(SYSTEM/idl_hdf.dlm)					F VData:input [FieldID:input]",	$
	"HDF_VD_READ						(SYSTEM/idl_hdf.dlm)					F VData:input Data:output /FIELDS:input /FULL_INTERLACE /NO_INTERLACE /NRECORDS:input",	$
	"HDF_VD_SEEK						(SYSTEM/idl_hdf.dlm)					P VData:input Record:input",	$
	"HDF_VD_SETINFO						(SYSTEM/idl_hdf.dlm)					P VData:input /CLASS:input /FULL_INTERLACE /NO_INTERLACE /NAME:input",	$
	"HDF_VD_WRITE						(SYSTEM/idl_hdf.dlm)					P VData:input Fields:input Data:input /FULL_INTERLACE /NO_INTERLACE /NRECORDS:input",	$

	"HDF_VG_ADDTR						(SYSTEM/idl_hdf.dlm)					P VGroup:input Tag:input Ref:input",	$
	"HDF_VG_ATTACH						(SYSTEM/idl_hdf.dlm)					F FileHandle:input VGroup_id:input /READ /WRITE",	$
	"HDF_VG_DETACH						(SYSTEM/idl_hdf.dlm)					P VGroup:input",	$
	"HDF_VG_GETID						(SYSTEM/idl_hdf.dlm)					F FileHandle:input VGroup_id:input",	$
	"HDF_VG_GETINFO						(SYSTEM/idl_hdf.dlm)					P VGroup:input /CLASS:output /NAME:output /NENTRIES:output /REF:output /TAG:output",	$
	"HDF_VG_GETNEXT						(SYSTEM/idl_hdf.dlm)					F VGroup:input Id:input",	$
	"HDF_VG_GETTR						(SYSTEM/idl_hdf.dlm)					P VGroup:input Index:input Tags:output [Refs:output]",	$
	"HDF_VG_GETTRS						(SYSTEM/idl_hdf.dlm)					P VGroup:input Tags:output Refs:output [p4:???] /MAXSIZE:input",	$
	"HDF_VG_INQTR						(SYSTEM/idl_hdf.dlm)					F VGroup:input Tag:input Ref:input",	$
	"HDF_VG_INSERT						(SYSTEM/idl_hdf.dlm)					P VGroup:input VData:input /POSITION:output",	$
	"HDF_VG_ISVD						(SYSTEM/idl_hdf.dlm)					F VGroup:input Id:input",	$
	"HDF_VG_ISVG						(SYSTEM/idl_hdf.dlm)					F VGroup:input Id:input",	$
	"HDF_VG_LONE						(SYSTEM/idl_hdf.dlm)					F FileHandle:input /MAXSIZE:input",	$
	"HDF_VG_NUMBER						(SYSTEM/idl_hdf.dlm)					F VGroup:input",	$
	"HDF_VG_SETINFO						(SYSTEM/idl_hdf.dlm)					P VGroup:input /CLASS:input /NAME:input",	$

	"HDF_CLOSE						(SYSTEM/idl_hdf.dlm)					P FileHandle:input",	$
	"HDF_DELDD						(SYSTEM/idl_hdf.dlm)					P FileHandle:input Tag:input Ref:input",	$



	; ROUTINES DE BERKELEY
	; --------------------
	; nodoc
	"TIME_TO_STR						(SYSTEM/BERKELEY) 					F time:input",	$
	"STR_TO_TIME						(SYSTEM/BERKELEY) 					F str:input"	$

	]

	nbdecls = 0L
	nb_graphics_keywords = N_ELEMENTS(graphics_keywords[0,*])

	last_name_sans_plus = ''
	
	FOR i=0L, N_ELEMENTS(list_all)-1 DO BEGIN

		tmp = STRSPLIT (list_all[i], /EXTRACT)
		tmpname = STRSPLIT (tmp[0], '::', /EXTRACT)
		inherits = ''
		IF N_ELEMENTS(tmpname) EQ 2 THEN BEGIN
			; inhrits ?
			pos1 = STRPOS (tmpname[0], '(')
			pos2 = STRPOS (tmpname[0], ')')
			IF pos1 NE -1 && pos2 NE -1 THEN BEGIN
				object = STRLOWCASE(STRMID (tmpname[0], 0, pos1))
				inherits = STRMID (tmpname[0], pos1+1, pos2-pos1-1)
				remplacer, inherits, '/' , ' '
				tab_inherits = STRSPLIT(inherits, /EXTRACT)
				FOR j=0L,N_ELEMENTS(tab_inherits)-1 DO BEGIN
					ind = WHERE (STRUPCASE(decls[0:nbdecls-1].object) EQ STRUPCASE(tab_inherits[j]))
					IF ind[0] EQ -1 THEN BEGIN
						my_print, 'ERROR IN SYSTEM DEFINITION CLASSE INHERITS ' + tab_inherits[j] + ' NOT DEFINED IN ' + list_all[i]
						EXIT
					END
				END
				
			END ELSE BEGIN
				object = STRLOWCASE(tmpname[0])
			END
			name   = STRLOWCASE(tmpname[1])
		END ELSE BEGIN
			object = ''
			name   = STRLOWCASE(tmpname[0])
		END

		; vrif sur name
		FOR j=0L,STRLEN(name)-1 DO BEGIN
			c = STRMID(name, j, 1)
			IF (c GE 'a' && c LE 'z') || (c GE '0' && c LE '9') || (c EQ '_') || (c EQ '+') THEN BEGIN
			END ELSE BEGIN
				my_print, 'ERROR IN SYSTEM DEFINITION INVALID NAME IN ' + list_all[i]
				EXIT
			END
		END

		; vrif sur object
		FOR j=0L,STRLEN(object)-1 DO BEGIN
			c = STRMID(object, j, 1)
			IF (c GE 'a' && c LE 'z') || (c GE '0' && c LE '9') || (c EQ '_') THEN BEGIN
			END ELSE BEGIN
				my_print, 'ERROR IN SYSTEM DEFINITION INVALID OBJECT IN ' + list_all[i]
				EXIT
			END
		END

		pos_plus = STRPOS(name, '+')
		name_sans_plus = pos_plus EQ -1 ? name : STRMID(name, 0, pos_plus)

		; rajouter les graphics_keywords
		IF object EQ '' THEN BEGIN
			FOR j=0L,nb_graphics_keywords-1 DO BEGIN
				tmp = STRSPLIT(graphics_keywords[1,j], /EXTRACT)
				IF (WHERE(tmp EQ STRUPCASE(name_sans_plus))) NE -1 THEN BEGIN ; il n'y a pas de '#' dans graphics_keywords[1,j]
					list_all[i] += ' ' + graphics_keywords[0,j]
					;PRINT, name + ' ' + graphics_keywords[0,j]
				END
			END
		END
	
		tmp = STRSPLIT (list_all[i], /EXTRACT)


		IF tmp[2] EQ 'F' THEN BEGIN
			function_pro = 'FUNCTION'
		END ELSE IF tmp[2] EQ 'P' THEN BEGIN
			function_pro = 'PRO'
		END ELSE BEGIN
			my_print, 'ERROR IN SYSTEM DEFINITION OF FUNC/PRO P OR F NOT FOUND IN "' + tmp[2] + '"' + name + ' (' + list_all[i] + ')'
			EXIT
		END

		params = ''
		keywords = ''

		module = STRMID(tmp[1], 1, STRLEN(tmp[1])-2)

		keywords_maintenant = 0
		FOR j=3L,N_ELEMENTS(tmp)-1 DO BEGIN
			IF STRMID(tmp[j], 0, 1) EQ '/' THEN BEGIN
				keywords_maintenant = 1
				IF STRPOS(tmp[j], ':') EQ -1 THEN BEGIN
					tmp1 = [ STRMID(tmp[j], 1) , 'input' ]
				END ELSE BEGIN
					tmp1 = STRSPLIT(STRMID(tmp[j], 1), ":", /EXTRACT, /PRESERVE_NULL)
				END
				IF N_ELEMENTS(tmp1) GT 2 THEN BEGIN
					my_print, 'ERROR IN SYSTEM DEFINITION OF ' + tmp[j] + ' PARAMETER (' + list_all[i] + ')'
					EXIT
				END
				mots = tmp1[0]
				pos1 = STRPOS(mots[0], '{')
				pos2 = STRPOS(mots[0], '}')
				IF pos1 NE -1 AND pos2 NE -1 AND pos1 EQ 0 THEN BEGIN
					mots = STRMID(mots[0], pos1+1, pos2-pos1-1)
					mots = STRSPLIT (mots, '|', /EXTRACT)
					mots += STRMID(tmp1[0], pos2+1)
				END
				IF N_ELEMENTS(tmp1) EQ 1 THEN BEGIN
					my_print, 'ERROR IN SYSTEM DEFINITION OF ' + tmp1[0] + ' KEYWORD (' + list_all[i] + ')'
					EXIT
				END ELSE IF tmp1[1] EQ 'input' || tmp1[1] EQ 'output' || tmp1[1] EQ '???' THEN BEGIN
					FOR k=0L,N_ELEMENTS(mots)-1 DO BEGIN
						IF STRPOS (keywords, mots[k]+'='+mots[k]+':'+tmp1[1]) NE -1 THEN BEGIN
							my_print, 'ERROR IN SYSTEM DEFINITION OF ' + mots[k] + ' DUPLICATED KEYWORD (' + list_all[i] + ')'
							EXIT
						END
						keywords += mots[k]+'='+mots[k]+':'+tmp1[1]+' '
						IF ~lint_check_mot (mots[k]) THEN BEGIN
							my_print, 'ERROR IN SYSTEM DEFINITION OF ' + mots[k] + ' KEYWORD (' + list_all[i] + ')'
							EXIT
						END
					END
				END ELSE BEGIN
					my_print, 'ERROR IN SYSTEM DEFINITION OF ' + tmp1[0] + ' KEYWORD (' + list_all[i] + ')'
					EXIT
				END
			END ELSE BEGIN
				IF keywords_maintenant THEN BEGIN
					my_print, 'ERROR IN SYSTEM DEFINITION OF ' + tmp[j] + ' PARAMETER (' + list_all[i] + ')'
					EXIT
				END
				is_optional = STRMID(tmp[j], 0, 1) EQ '[' AND STRMID(tmp[j], STRLEN(tmp[j])-1, 1) EQ ']'
				IF is_optional THEN tmp[j] = STRMID(tmp[j], 1, STRLEN(tmp[j])-2)
				tmp1 = STRSPLIT(tmp[j], ":", /EXTRACT, /PRESERVE_NULL)
				IF N_ELEMENTS(tmp1) GT 2 THEN BEGIN
					my_print, 'ERROR IN SYSTEM DEFINITION OF ' + tmp[j] + ' PARAMETER (' + list_all[i] + ')'
					EXIT
				END
				var_name = N_ELEMENTS(tmp1) EQ 1 ? '???'   : tmp1[0]
				var_type = N_ELEMENTS(tmp1) EQ 1 ? tmp1[0] : tmp1[1]
				IF is_optional THEN var_type = '[' + var_type + ']'
				IF var_type EQ 'input' || var_type EQ '[input]' || var_type EQ 'output' || var_type EQ '[output]' THEN BEGIN
					params += var_name + ':' + var_type + ' '
				END ELSE IF var_type EQ '???' THEN BEGIN
					params += var_name+':??? '
				END ELSE IF var_type EQ '[???]' THEN BEGIN
					params += var_name + ':[???] '
				END ELSE IF var_type EQ 'input#LABEL' || var_type EQ 'input#CONSTANT' || var_type EQ 'input#CONSTANT_STRING' || var_type EQ 'input#UNDEFINED' || var_type EQ 'input#CONSTANT_STRING#CONSTANT' THEN BEGIN
					params += var_name + ':' + var_type + ' '
				END ELSE IF var_type EQ '[input#CONSTANT_STRING]' THEN BEGIN
					params += var_name + ':' + '[input]#CONSTANT_STRING' + ' '
				END ELSE IF var_type EQ '[input#UNDEFINED]'THEN BEGIN
					params += var_name + ':' + '[input]#UNDEFINED' + ' '
				END ELSE IF var_type EQ 'inputs' THEN BEGIN
					FOR k=0L,999 DO params += var_name + ':' + 'input '
				END ELSE IF var_type EQ '[inputs]' THEN BEGIN
					FOR k=0L,999 DO params += var_name + ':' + '[input] '
				END ELSE IF var_type EQ 'outputs' THEN BEGIN
					FOR k=0L,999 DO params += var_name + ':' + 'output '
				END ELSE IF var_type EQ '[outputs]' THEN BEGIN
					FOR k=0L,999 DO params += var_name + ':' + '[output] '
				END ELSE BEGIN
					my_print, 'ERROR IN SYSTEM DEFINITION OF ' + tmp[j] + ' PARAMETER (' + list_all[i] + ')'
					EXIT
				END
			END
		END


		IF pos_plus NE -1 AND name_sans_plus NE last_name_sans_plus THEN BEGIN
			; crer une entre avec name sans '+' avec prototype et dfinition vide
			decls[nbdecls].is_system	= 1
			decls[nbdecls].function_pro	= function_pro
			decls[nbdecls].object		= object
			decls[nbdecls].inherits		= inherits
			decls[nbdecls].name		= name_sans_plus
			;PRINT, decls[nbdecls].name
			decls[nbdecls].prototype	= ''
			decls[nbdecls].module		= module
			decls[nbdecls].definition	= ''
			decls[nbdecls].first_plus	= nbdecls+1
			no_plus = nbdecls
			lint_ajouter_hash, decls, nbdecls, hash
			nbdecls++
		END

		decls[nbdecls].is_system	= 1
		decls[nbdecls].function_pro	= function_pro
		decls[nbdecls].object		= object
		decls[nbdecls].inherits		= inherits
		decls[nbdecls].name		= name
		decls[nbdecls].prototype	= params + ' ' + keywords
		decls[nbdecls].module		= module
		decls[nbdecls].definition	= STRCOMPRESS(list_all[i])
		lint_ajouter_hash, decls, nbdecls, hash

		IF pos_plus NE -1 THEN BEGIN
			; rajouter la dfintion dans la routine avec name sans '+'

			IF decls[no_plus].definition NE '' THEN decls[no_plus].definition += STRING(10b) + STRING(10b)
			decls[no_plus].definition += decls[nbdecls].definition
			decls[no_plus].last_plus = nbdecls
		END

		nbdecls++

		last_name_sans_plus = name_sans_plus

	END

	; Vrifier les FUN/PRO de graphics_keywords
	FOR i=0L,nb_graphics_keywords-1 DO BEGIN
		names = STRSPLIT (graphics_keywords[1,i], /EXTRACT)
		FOR j=0L,N_ELEMENTS(names)-1 DO BEGIN
			IF (WHERE (decls.is_system AND STRUPCASE(decls.name) EQ STRUPCASE(names[j])))[0] EQ -1 THEN BEGIN
				my_print, 'ERROR IN GRAPHICS_KEYWORDS DEFINITION OF ' + graphics_keywords[0,i] + ' ' +graphics_keywords[1,i]
				EXIT
			END
		END
	END

END

		
;-------------------------------------------------------------------------------
PRO lint_pass1,		$
;-------------------------------------------------------------------------------
	liste,		$	; LINT_PROTOTYPE input
	decls,		$	; LINT_PROTOTYPE input
	hash,		$	; LINT_PROTOTYPE input
	repertoire		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Cre dans repertoire le fichier "all.html"
;-------------------------------------------------------------------------------

	nom_all_html  = repertoire + '/all.html'

	my_print, ''
	my_print, '------'
	my_print, 'pass#1'
	my_print, '------'
	my_print, ''

	premier = (WHERE (decls.module EQ ''))[0] - 1 ; le dernier lment non vide

	OPENW, fdall, nom_all_html, /GET_LUN
	PRINTF, fdall, '<html><body><pre>'

	nb_liste = N_ELEMENTS(liste)
	FOR i=0L,nb_liste-1 DO BEGIN
		lint_decl, liste, i, decls, premier, hash, fdall, repertoire
	END

	; Il y a peut-tre des fichiers qui ont t rajouts  liste
	WHILE i LT N_ELEMENTS(liste) DO BEGIN
		lint_decl, liste, i, decls, premier, hash, fdall, repertoire
		; et il peut y en avoir encore d'autres ici ...
		i++
	END

	FOR i=0L,N_ELEMENTS(decls)-1 DO BEGIN
		IF decls[i].function_pro EQ 'FUNCTIONC' || decls[i].function_pro EQ 'MACROC' || decls[i].function_pro EQ 'TYPEC' THEN BEGIN
			tmp = STRSPLIT (decls[i].code, STRING(10b), /PRESERVE_NULL, /EXTRACT)
			IF N_ELEMENTS(tmp) GT decls[i].nblignes THEN BEGIN
				decls[i].code = STRJOIN (tmp[0:decls[i].nblignes-1], STRING(10b))
			END
		END
	END

	PRINTF, fdall, '</pre></body></html>'
	FREE_LUN, fdall

END

;-------------------------------------------------------------------------------
PRO lint_finaliser_decls,	$
;-------------------------------------------------------------------------------
	decls,			$	; LINT_PROTOTYPE input
	hash				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Analyse le prototype de toutes les FUNCTION/PRO de decls.
;-------------------------------------------------------------------------------

	; Supprimer les lments superflus de decls
	decls = decls[WHERE (decls.module NE "")]

	FOR i=0L,N_ELEMENTS(decls)-1 DO BEGIN

		code = lint_analyser_prototype (decls[i].prototype, nb_params_min, nb_params_max, nb_keywords, params, params_type, params_extra,  keywords, keywords_type, keywords_ambigus)
		IF code NE '' THEN BEGIN
			my_print, 'ERROR '+decls[i].module+'('+decls[i].name+') ' + code + ' ['+decls[i].prototype+']' + ' ['+decls[i].prototype+']'
			EXIT
		END

		; Y a t-il que des '???' dans params_type ?
		IF decls[i].is_system THEN BEGIN
			params_type_all_unknow = 0
		END ELSE BEGIN
			params_type_all_unknow = 1
			tmp = STRSPLIT (params_type, /EXTRACT)
			FOR j=0L,N_ELEMENTS(tmp)-1 DO BEGIN
				IF STRPOS(tmp[j], '???') EQ -1 THEN BEGIN
					params_type_all_unknow = 0
					BREAK
				END
			END
		END

		decls[i].nb_params_min	= params_type_all_unknow ? 0 : nb_params_min ; impossible  savoir s'il n'y a que des ???
		decls[i].nb_params_max	= nb_params_max
		decls[i].nb_keywords	= nb_keywords
		decls[i].keywords	= keywords
		decls[i].keywords_type	= keywords_type
		decls[i].params		= params
		decls[i].params_type	= params_type
		decls[i].params_extra   = params_extra

	END

	; Resoudre inherits en y mettant toutes les classes possibles
	PRINT, 'DEBUT inherits_full'
	FOR i=0L,N_ELEMENTS(decls)-1 DO BEGIN


		IF i GT 0 THEN BEGIN
			; peut-on utiliser les valeurs calcules  la ligne i-1 ?
			ok = 0
			IF decls[i].inherits EQ decls[i-1].inherits THEN BEGIN
				IF decls[i].is_c THEN BEGIN
					ok = decls[i].module EQ decls[i-1].module 
				END ELSE BEGIN
					ok = decls[i].object EQ decls[i-1].object
				END
			END
			IF ok THEN BEGIN
				;PRINT, 'ok ' + decls[i].module + '*' + decls[i].name
				decls[i].inherits_full = decls[i-1].inherits_full
				CONTINUE
			END
		END


		IF decls[i].is_c THEN BEGIN
			inherits_full = decls[i].module
		END ELSE BEGIN
			inherits_full = decls[i].object
		END

		IF decls[i].inherits NE '' THEN BEGIN

			tmp = STRSPLIT (decls[i].inherits, /EXTRACT)
			;PRINT, decls[i].module + '*' + decls[i].name + ': ' + decls[i].inherits
			FOR j=0L,N_ELEMENTS(tmp)-1 DO BEGIN
				; depth first, left to right
				tmp[j] = lint_get_inherits_recursif (decls, hash, '', tmp[j], decls[i].is_c)
			END

			; supprimer les doublons
			IF ~decls[i].is_c THEN tmp = STRUPCASE (tmp)
			tmp = STRSPLIT (STRJOIN(tmp, ''), /EXTRACT)
			tmp = tmp[UNIQ (tmp, SORT(tmp))]

			inherits_full += ' ' + STRJOIN (tmp, ' ')


		END
		decls[i].inherits_full = inherits_full

	END
	PRINT, 'FIN inherits_full'

END

;-------------------------------------------------------------------------------
PRO lint_afficher_infos_appels,	$
;-------------------------------------------------------------------------------
	decls				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche des infops sur les FUNCTION/PRO et KEYWORD jamais utiliss (que pour target 'cl').
;-------------------------------------------------------------------------------

	COMMON COMMON_LINT, common_lint_infos

	target = common_lint_infos.target


	my_print, ''
	my_print, 'FUNCTION/PRO NEVER USED'
	my_print, '-----------------------'
	FOR i=0L, N_ELEMENTS(decls)-1 DO BEGIN

		IF decls[i].function_pro EQ 'GLOBALC' THEN CONTINUE
		IF decls[i].is_extern THEN CONTINUE
		IF decls[i].is_system THEN CONTINUE
		IF decls[i].is_cl_other THEN CONTINUE
		IF decls[i].nb_use NE 0 THEN CONTINUE
		IF STRMID(decls[i].module, STRLEN(decls[i].module)-2, 2) EQ '.h' THEN CONTINUE ; pas pour le ".h" sinon trop de messages
		IF decls[i].object NE '' && decls[i].name EQ 'init' THEN CONTINUE
		IF decls[i].object NE '' && decls[i].name EQ 'cleanup' THEN CONTINUE
		IF decls[i].object NE '' && decls[i].name EQ 'define' THEN CONTINUE

		msg = decls[i].module + '('+LINTC_INT_TO_STR(decls[i].noligne1) + ')'
		IF target EQ 'cl' THEN my_print, STRING(msg, FORMAT='(A-55)') + STRING(decls[i].function_pro, FORMAT='(A-10)') + ' "' + (decls[i].object EQ '' ? '' : (decls[i].object + '::')) + decls[i].name + '"'

	END

	my_print, ''
	my_print, 'KEYWORD NEVER USED'
	my_print, '------------------'
	FOR i=0L, N_ELEMENTS(decls)-1 DO BEGIN

		IF decls[i].is_system THEN CONTINUE
		IF decls[i].is_cl_other THEN CONTINUE
		IF decls[i].nb_use EQ 0 THEN CONTINUE

		prototype = STRSPLIT(STRUPCASE(decls[i].prototype), ' ', /EXTRACT)
		tmp = STRSPLIT(decls[i].keywords_used, /EXTRACT)
		FOR k=0L,N_ELEMENTS(prototype)-1 DO BEGIN
			IF ~lint_is_keyword(prototype[k], keyword, type_keyword) THEN CONTINUE
			IF keyword EQ '_EXTRA' THEN CONTINUE
			IF keyword EQ '_REF_EXTRA' THEN CONTINUE
			IF (WHERE(tmp EQ keyword))[0] NE -1 THEN CONTINUE
			msg = decls[i].module + '(' + LINTC_INT_TO_STR(decls[i].noligne1) + ')'
			IF target EQ 'cl' THEN my_print, STRING(msg, FORMAT='(A-55)') + STRING(keyword, FORMAT='(A-20)') + ' IN ' + STRING(decls[i].function_pro, FORMAT='(A-8)') + ' "'+ (decls[i].object EQ '' ? '' : (decls[i].object + '::')) + decls[i].name + '"'
		END

	END

END

;-------------------------------------------------------------------------------
PRO lint_afficher_nblignes,	$
;-------------------------------------------------------------------------------
	texte,			$	; LINT_PROTOTYPE input
	nb				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche texte sur 17 caractres et nb sur 6 caractres.
;-------------------------------------------------------------------------------

	my_print, STRING(texte+':', FORMAT='(A-17)') + ' ' + STRING(nb, FORMAT='(I6)')

END

;-------------------------------------------------------------------------------
PRO lint_afficher_infos_declarations,	$
;-------------------------------------------------------------------------------
	decls					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche des infos sur le nombre de routines et le nombre de lignes.
;-------------------------------------------------------------------------------

	COMMON COMMON_LINT, common_lint_infos

	my_print, ''
	my_print, 'NUMBER OF ROUTINES'
	my_print, '------------------'



	lint_unused = WHERE (decls.is_cl_other EQ 0 AND decls.is_system NE 1 AND decls.object NE '' AND (decls.function_pro EQ 'PRO' OR decls.function_pro EQ 'FUNCTION') AND (decls.nb_params_max+decls.nb_keywords NE decls.nb_prototypes), nb_prototypes_pb)
	lint_unused = WHERE (decls.is_cl_other EQ 0 AND decls.is_system NE 1 AND decls.object NE '' AND (decls.function_pro EQ 'PRO' OR decls.function_pro EQ 'FUNCTION') AND (decls.nb_params_max+decls.nb_keywords EQ decls.nb_prototypes), nb_prototypes_ok)
	my_print, ''
	my_print, STRING(nb_prototypes_ok, FORMAT='(I4)')      +       ' ROUTINES OBJECT LINT_PROTOTYPES OK'
	my_print, STRING(nb_prototypes_pb, FORMAT='(I4)')      +       ' ROUTINES OBJECT LINT_PROTOTYPES PB'
	lint_unused = WHERE (decls.object NE '' AND decls.is_system NE 1 AND (decls.function_pro EQ 'FUNCTION' OR decls.function_pro EQ 'PRO'), nb_routines_object)
	my_print, STRING(nb_routines_object, FORMAT='(I4)')	+	' ROUTINES OBJECT'

	lint_unused = WHERE (decls.is_cl_other EQ 0 AND decls.is_system NE 1 AND decls.object EQ '' AND (decls.function_pro EQ 'PRO' OR decls.function_pro EQ 'FUNCTION') AND (decls.nb_params_max+decls.nb_keywords NE decls.nb_prototypes), nb_prototypes_pb)
	lint_unused = WHERE (decls.is_cl_other EQ 0 AND decls.is_system NE 1 AND decls.object EQ '' AND (decls.function_pro EQ 'PRO' OR decls.function_pro EQ 'FUNCTION') AND (decls.nb_params_max+decls.nb_keywords EQ decls.nb_prototypes), nb_prototypes_ok)
	my_print, ''
	my_print, STRING(nb_prototypes_ok, FORMAT='(I4)')      +       ' ROUTINES NON OBJECT LINT_PROTOTYPES OK'
	my_print, STRING(nb_prototypes_pb, FORMAT='(I4)')      +       ' ROUTINES NON OBJECT LINT_PROTOTYPES PB'
	lint_unused = WHERE (decls.object EQ '' AND decls.is_system NE 1 AND (decls.function_pro EQ 'FUNCTION' OR decls.function_pro EQ 'PRO'), nb_routines_non_object)
	my_print, STRING(nb_routines_non_object, FORMAT='(I4)')	+	' ROUTINES NON OBJECT'

	lint_unused = WHERE (decls.is_system NE 1 AND decls.lint_variables NE '', nb_routines_avec_lint_variables)
	my_print, ''
	my_print, STRING(nb_routines_avec_lint_variables, FORMAT='(I4)')      +       ' ROUTINES WITH LINT_VARIABLES'

	;ind = WHERE (decls.nblignes_doc LE 1)
	;IF ind[0] NE -1 THEN BEGIN
	;	FOR i=0L,N_ELEMENTS(ind)-1 DO BEGIN
	;		my_print, '*** PAS DE DOC ***' + decls[ind[i]].module+'('+LINTC_INT_TO_STR(decls[ind[i]].noligne1)+') '+decls[ind[i]].function_pro+' '+decls[ind[i]].nom
	;	END
	;END

	my_print, ''
	my_print, 'TOTAL NUMBER OF LINES'
	my_print, '---------------------'
	
	IF common_lint_infos.total_nblignes_IDL_interne_code NE 0 THEN BEGIN
		lint_afficher_nblignes, 'IDL_interne_all', 	common_lint_infos.total_nblignes_IDL_interne_all
		lint_afficher_nblignes, 'IDL_interne_code',	common_lint_infos.total_nblignes_IDL_interne_code
		my_print, ''
	END

	IF common_lint_infos.total_nblignes_IDL_externe_code NE 0 THEN BEGIN
		lint_afficher_nblignes, 'IDL_externe_all', 	common_lint_infos.total_nblignes_IDL_externe_all
		lint_afficher_nblignes, 'IDL_externe_code',	common_lint_infos.total_nblignes_IDL_externe_code
		my_print, ''
	END

	IF common_lint_infos.total_nblignes_IDL_other_code NE 0 THEN BEGIN
		lint_afficher_nblignes, 'IDL_other_all', 	common_lint_infos.total_nblignes_IDL_other_all
		lint_afficher_nblignes, 'IDL_other_code',	common_lint_infos.total_nblignes_IDL_other_code
		my_print, ''
	END

	lint_afficher_nblignes, 'IDL_all', 	common_lint_infos.total_nblignes_IDL_all
	lint_afficher_nblignes, 'IDL_code', 	common_lint_infos.total_nblignes_IDL_code
	my_print, ''

	lint_afficher_nblignes, 'C_all', 	common_lint_infos.total_nblignes_C_all
	lint_afficher_nblignes, 'C_code', 	common_lint_infos.total_nblignes_C_code


END

;-------------------------------------------------------------------------------
PRO lint_check_commons,	$
;-------------------------------------------------------------------------------
	decls			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Dtecte les dfinitions d'un mme COMMON avec des variables diffrentes
;-------------------------------------------------------------------------------
; LINT_VARIABLES commons

	COMMON COMMON_LINT, common_lint_infos

	target = common_lint_infos.target

	nbdecls = N_ELEMENTS(decls)
	FOR i=0L, nbdecls-1 DO BEGIN

		IF decls[i].commons EQ '' THEN CONTINUE

		tmp1 = STRSPLIT (decls[i].commons, !SEP1, /EXTRACT)
		FOR j=0L, N_ELEMENTS(tmp1)-1 DO BEGIN
			tmp2 = STRSPLIT (tmp1[j], !SEP2, /EXTRACT)
			vars = N_ELEMENTS(tmp2) EQ 2 ? "" : tmp2[2:*]
			tmp = STRSPLIT (vars, /EXTRACT)
			nbvars = tmp[0] EQ '' ? 0L : N_ELEMENTS(tmp)
			elt = { noi: i, noj: j, module: decls[i].module, function_pro: decls[i].name, name: tmp2[0], noligne: tmp2[1], nbvars: nbvars, vars: vars }

			IF N_ELEMENTS(commons) NE 0 THEN BEGIN
			
				; Existe t-il un common avec le mme nom dja dclar ?
				no = (WHERE (commons.name EQ elt.name))[0]
				IF no NE -1 THEN BEGIN
					; oui
					IF commons[no].vars NE elt.vars THEN BEGIN
						; mais avec des variables diffrentes
						IF target EQ 'cl' THEN my_print, '*** DIFFERENT COMMON DEFINITION *** '+commons[no].module+'('+commons[no].noligne+'):'+' COMMON '+commons[no].name+' '+commons[no].vars
						IF target EQ 'cl' THEN my_print, '*** DIFFERENT COMMON DEFINITION *** '+elt.module        +'('+elt.noligne        +'):'+' COMMON '+elt.name  +'  '+elt.vars
					END
				END
			END
			commons = N_ELEMENTS(commons) EQ 0 ? [elt] : [commons,elt]
		END
	
	END

	IF N_ELEMENTS(commons) NE 0 THEN BEGIN
		ind1 = WHERE (commons.vars EQ '')
		IF ind1[0] NE -1 THEN BEGIN
			; il faut faire qq chose pour ces commons: y mettre des noms de variables mais lesquelles ?
			FOR i=0L, N_ELEMENTS(ind1)-1 DO BEGIN
				PRINT
				PRINT, commons[ind1[i]].module + ' ' + commons[ind1[i]].function_pro + "("+commons[ind1[i]].noligne + ') COMMON "' + commons[ind1[i]].name + ' ' + commons[ind1[i]].vars + '"'
				ind2 = WHERE (STRUPCASE(commons.name) EQ STRUPCASE(commons[ind1[i]].name) AND commons.nbvars NE 0, nb)
				IF nb NE 0 THEN BEGIN
					nbvars_max = MAX(commons[ind2].nbvars)
					ind2 = ind2[WHERE (commons[ind2].nbvars EQ nbvars_max)]
					PRINT, '  REPLACED BY '+ commons[ind2[0]].module + ' ' + commons[ind2[0]].function_pro + "(" + commons[ind2[0]].noligne + ') COMMON "' + commons[ind2[0]].name + ' ' + commons[ind2[0]].vars + '"'
					noi = commons[ind1[i]].noi
					noj = commons[ind1[i]].noj
					tmp1 = STRSPLIT (decls[noi].commons, !SEP1, /EXTRACT)
					tmp2 = STRSPLIT (tmp1[noj], !SEP2, /EXTRACT)
					tmp1[noj] = tmp2[0] + !SEP2 + tmp2[1] + !SEP2 + commons[ind2[0]].vars
					decls[noi].commons = STRJOIN (tmp1, !SEP1)
				END
			END
		END
	END

END

;-------------------------------------------------------------------------------
PRO lint_ecrire_resultats_listing,	$
;-------------------------------------------------------------------------------
	decls,				$	; LINT_PROTOTYPE input
	repertoire				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Cre dans repertoire le fichier "lint.txt"
;-------------------------------------------------------------------------------

	fichier_lint_txt = repertoire + '/lint.txt'

	OPENW, fd, fichier_lint_txt, /GET_LUN

	nbchars_module = MAX(STRLEN(decls.module)) + 7	; 7 pour les numro de ligne (xxxxx)
	format_module = '(A-'+LINTC_INT_TO_STR(nbchars_module)+')'

	nbchars_name = MAX(STRLEN(decls.name))
	format_name = '(A-'+LINTC_INT_TO_STR(nbchars_name)+')'

	PRINTF, fd,	STRING('MODULE(LINE)',			FORMAT=format_module) 	+ '  ' + $
			;STRING('FUNC/PRO',			FORMAT='(A-10)')	+ '  ' + $
			STRING('NAME',				FORMAT=format_name) 	+ '  ' + $
			STRING('PMIN',				FORMAT='(A4)')		+ ' '  + $
			STRING('PMAX',				FORMAT='(A4)')		+ ' '  + $
			STRING('KEYW',				FORMAT='(A4)')		+ ' '  + $
			STRING('LINES',				FORMAT='(A5)')		+ ' '  + $
			STRING('DOC',				FORMAT='(A4)')		+ ' '  + $
			STRING('USE',				FORMAT='(A4)')
	PRINTF, fd

	FOR i=0L,N_ELEMENTS(decls)-1 DO BEGIN

		IF decls[i].nb_use EQ 0 THEN BEGIN
			IF decls[i].object NE '' && decls[i].name EQ 'define' THEN BEGIN
			END ELSE IF decls[i].object NE '' && decls[i].name EQ 'init' THEN BEGIN
			END ELSE IF decls[i].object NE '' && decls[i].name EQ 'cleanup' THEN BEGIN
			END ELSE BEGIN
				CONTINUE
			END
		END

		msg = decls[i].module + '('+LINTC_INT_TO_STR(decls[i].noligne1) + ')'
		name = decls[i].is_system ? STRUPCASE(decls[i].name) : decls[i].name

		PRINTF, fd,	STRING(msg,			FORMAT=format_module) 	+ '  ' + $
				;STRING(decls[i].function_pro,	FORMAT='(A-10)')	+ '  ' + $
				STRING(name,			FORMAT=format_name) 	+ '  ' + $
				STRING(decls[i].nb_params_min,	FORMAT='(I4)')		+ ' '  + $
				STRING(decls[i].nb_params_max,	FORMAT='(I4)')		+ ' '  + $
				STRING(decls[i].nb_keywords,	FORMAT='(I4)')		+ ' '  + $
				STRING(decls[i].nblignes,	FORMAT='(I5)')		+ ' '  + $
				STRING(decls[i].nbchars_doc,	FORMAT='(I4)')		+ ' '  + $
				STRING(decls[i].nb_use,		FORMAT='(I4)')

	END

	FREE_LUN, fd

	my_print, ''
	my_print, fichier_lint_txt + ' has been created'

END


;-------------------------------------------------------------------------------
PRO lint_printf,	$
;-------------------------------------------------------------------------------
	fds,		$	; LINT_PROTOTYPE input
	ligne			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ecrit une mme ligne dans plusieurs fichiers.
;-------------------------------------------------------------------------------

	FOR i=0L,N_ELEMENTS(fds)-1 DO PRINTF, fds[i],   ligne

END

;-------------------------------------------------------------------------------
;FUNCTION lint_utilise_uniquement_des_routines_systemes,	$
;-------------------------------------------------------------------------------
;	decls,						$	; LINT_PROTOTYPE input
;	no							; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne 1 si decls[no] ne contient que des appels  des routines systemes
;-------------------------------------------------------------------------------
;
;	tmp1 = STRSPLIT (decls[no].call, /EXTRACT)
;	RETURN, (WHERE (decls[tmp1].is_module NE 1))[0] EQ -1
;
;END

;-------------------------------------------------------------------------------
FUNCTION lint_utilise_uniquement_des_routines_compilees,	$
;-------------------------------------------------------------------------------
	decls,							$	; LINT_PROTOTYPE input
	no								; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne 1 si decls[no] ne contient que des appels  des routines dont le numro est infrieur ou gal  no
;-------------------------------------------------------------------------------

	tmp1 = STRSPLIT (decls[no].call, /EXTRACT)
	aie = WHERE (tmp1 GT no)
	IF aie[0] NE -1 THEN BEGIN
		FOR i=0L,N_ELEMENTS(aie)-1 DO my_print, 'COMPILATION ORDER PROBLEM '+decls[no].name+'('+decls[no].module+') call ' + decls[tmp1[aie[i]]].name
	END
	RETURN, aie[0] EQ -1

END

;-------------------------------------------------------------------------------
FUNCTION lint_utilise_uniquement_des_routines_compilees_dans_ordre,	$
;-------------------------------------------------------------------------------
	decls,								$	; LINT_PROTOTYPE input
	no									; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne 1 si decls[no] ne contient pas d'appel  des routines de son propre module dont le numro est infrieur ou gal  no
;-------------------------------------------------------------------------------

	tmp1 = STRSPLIT (decls[no].call, /EXTRACT)
	aie = WHERE (decls[tmp1].module EQ decls[no].module AND tmp1 GT no)
	IF aie[0] NE -1 THEN BEGIN
		FOR i=0L,N_ELEMENTS(aie)-1 DO my_print, 'COMPILATION ORDER PROBLEM '+decls[no].name+'('+decls[no].module+') call ' + decls[tmp1[aie[i]]].name
	END
	RETURN, aie[0] EQ -1

END

;-------------------------------------------------------------------------------
FUNCTION lint_is_interne,	$
;-------------------------------------------------------------------------------
	decls,			$	; LINT_PROTOTYPE input
	no				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne 1 si decls[no] n'est appell que dans son propre module, 2 s'il n'est jamais appel, 0 sinon.
;-------------------------------------------------------------------------------

	IF decls[no].object NE '' && decls[no].name EQ 'cleanup' THEN RETURN, 0
	IF decls[no].object NE '' && decls[no].name EQ 'init'    THEN RETURN, 0
	IF decls[no].object NE '' && decls[no].name EQ 'define'  THEN RETURN, 0

	tmp1 = STRSPLIT(decls[no].calledby, /EXTRACT)
	IF tmp1[0] EQ '' THEN RETURN, 2
	FOR i=0L,N_ELEMENTS(tmp1)-1 DO BEGIN
		IF decls[tmp1[i]].module NE decls[no].module THEN RETURN, 0
	END

	RETURN, 1

END

;-------------------------------------------------------------------------------
PRO lint_remplacer_fichier,	$
;-------------------------------------------------------------------------------
	fichier1,		$	; LINT_PROTOTYPE input
	fichier2,		$	; LINT_PROTOTYPE input
	infos				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Recopie fichier1 dans fichier2 en modifiant les lignes avec "$NBxx" en utilisant infos.no et infos.couleur
;-------------------------------------------------------------------------------

	nb_messages = N_ELEMENTS(infos)

	OPENR, fd1, fichier1, /GET_LUN
	OPENW, fd2, fichier2, /GET_LUN

	motifs = REPLICATE ('', nb_messages)
	FOR j=0L,nb_messages-1 DO BEGIN
		motifs[j] = '<td>$NB'+int_str_0(j, 2)+'</td>'
	END

	s = ''
	WHILE ~EOF(fd1) DO BEGIN
		READF, fd1, s
		IF STRPOS(s, '$NB') NE -1 THEN BEGIN
			FOR j=0L,nb_messages-1 DO BEGIN
				IF STRPOS(s, motifs[j]) NE -1 THEN BEGIN
					; il n'y a qu'un message par ligne
					IF infos[j].no-1 EQ 0 THEN BEGIN
						s = '' ; pour supprimer la ligne
					END ELSE BEGIN
						remplacer, s, motifs[j], '<td class='+infos[j].class+'>' + LINTC_INT_TO_STR(infos[j].no-1) + '</td>'
					END
					BREAK
				END
			END
		END
		PRINTF, fd2, s
	END

	FREE_LUN, fd1
	FREE_LUN, fd2

END

;-------------------------------------------------------------------------------
PRO lint_ecrire_resultats_html, 	$
;-------------------------------------------------------------------------------
	decls,				$	; LINT_PROTOTYPE input
	repertoire				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Cre dans repertoire "index.html", "modules.html" et un fichier html par FUNCTION/PRO
;-------------------------------------------------------------------------------
; LINT_VARIABLES fd_module

	COMMON COMMON_LINT, common_lint_infos

	html_dir = common_lint_infos.html_dir
	target   = common_lint_infos.target

	my_print, ''
	my_print, '---------------------'
	my_print, 'ecrire_resultats_html'
	my_print, '---------------------'
	my_print, ''

	; Le dernier module dont on doit vrifier l'ordre de compilation est pro/libxml.pro
	tmp1 = WHERE (decls.module EQ 'pro/libxml.pro')
	liste_verifier_all_ordre_compilation = tmp1[0] EQ -1 ? -1 : LINDGEN(1+tmp1[N_ELEMENTS(tmp1)-1])

	; Le dernier module dont on doit vrifier qu'il n'utilise pas des routines de lui mme non compiles est 'pro/clweb.pro'
	tmp1 = WHERE (decls.module EQ 'pro/clweb.pro')
	liste_verifier_mini_ordre_compilation = tmp1[0] EQ -1 ? -1 : LINDGEN(1+tmp1[N_ELEMENTS(tmp1)-1])

	nom_index_html_tmp					= repertoire + '/index.html.tmp'

	infos = [																													$
		{ fd:0L, nom:'index_syntax_error.html',						msg:'SYNTAX ERROR',						table:'BEGIN',	no:1L, nb:0L, texte:'', class:"LINT_ERROR"		},	$
		{ fd:0L, nom:'index_ambiguous_keyword.html',					msg:'AMBIGUOUS KEYWORD',					table:'',	no:1L, nb:0L, texte:'', class:"LINT_ERROR"		},	$
		{ fd:0L, nom:'index_too_few_arguments.html',					msg:'TOO FEW ARGUMENTS', 					table:'',	no:1L, nb:0L, texte:'', class:"LINT_ERROR"		},	$
		{ fd:0L, nom:'index_too_many_arguments.html',					msg:'TOO MANY ARGUMENTS', 					table:'',	no:1L, nb:0L, texte:'', class:"LINT_ERROR"		},	$
		{ fd:0L, nom:'index__bad_argument.html',					msg:'BAD ARGUMENT', 						table:'',	no:1L, nb:0L, texte:'', class:"LINT_ERROR"		},	$
		{ fd:0L, nom:'index_bad_keyword.html',						msg:'BAD KEYWORD', 						table:'',	no:1L, nb:0L, texte:'', class:"LINT_ERROR"		},	$
		{ fd:0L, nom:'index_named_variable_expected.html',				msg:'NAMED VARIABLE EXPECTED', 					table:'',	no:1L, nb:0L, texte:'', class:"LINT_ERROR"		},	$
		{ fd:0L, nom:'index_constant_expected.html',					msg:'CONSTANT EXPECTED',					table:'',	no:1L, nb:0L, texte:'', class:"LINT_ERROR"		},	$
		{ fd:0L, nom:'index_label_expected.html',					msg:'LABEL EXPECTED',						table:'',	no:1L, nb:0L, texte:'', class:"LINT_ERROR"		},	$
		{ fd:0L, nom:'index_undefined_include.html',					msg:'UNDEFINED INCLUDE', 					table:'',	no:1L, nb:0L, texte:'', class:"LINT_ERROR"		},	$
		{ fd:0L, nom:'index_undefined_label.html',					msg:'UNDEFINED LABEL', 						table:'',	no:1L, nb:0L, texte:'', class:"LINT_ERROR"		},	$
		{ fd:0L, nom:'index_undefined_method.html',					msg:'UNDEFINED METHOD', 					table:'',	no:1L, nb:0L, texte:'', class:"LINT_ERROR"		},	$
		{ fd:0L, nom:'index_undefined_pro.html',					msg:'UNDEFINED PRO',						table:'',	no:1L, nb:0L, texte:'', class:"LINT_ERROR"		},	$
		{ fd:0L, nom:'index_undefined_function_or_variable.html',			msg:'UNDEFINED FUNCTION OR VARIABLE',				table:'',	no:1L, nb:0L, texte:'', class:"LINT_ERROR"		},	$
		{ fd:0L, nom:'index_undefined_variable.html',					msg:'UNDEFINED VARIABLE', 					table:'',	no:1L, nb:0L, texte:'', class:"LINT_ERROR"		},	$
		{ fd:0L, nom:'index_variable_used_but_not_defined.html',			msg:'VARIABLE USED BUT NOT DEFINED',				table:'',	no:1L, nb:0L, texte:'', class:"LINT_ERROR"		},	$
		{ fd:0L, nom:'index_variable_defined_after.html',				msg:'VARIABLE DEFINED AFTER', 					table:'END',	no:1L, nb:0L, texte:'', class:"LINT_ERROR_WARNING"	},	$

		{ fd:0L, nom:'index_redefined.html',						msg:'REDEFINED',						table:'BEGIN',	no:1L, nb:0L, texte:'', class:"LINT_WARNING"		},	$
		{ fd:0L, nom:'index_incorrect_missing_semi_colon_after_dollar.html',		msg:'INCORRECT LINE MISSING SEMI-COLON AFTER DOLLAR',		table:'',	no:1L, nb:0L, texte:'', class:"LINT_WARNING"		},	$
		{ fd:0L, nom:'index_incorrect_line_unterminated_simple_quote.html',		msg:'INCORRECT LINE UNTERMINATED SIMPLE-QUOTE', 		table:'',	no:1L, nb:0L, texte:'', class:"LINT_WARNING"		},	$
		{ fd:0L, nom:'index_incorrect_line_unterminated_double_quote.html',		msg:'INCORRECT LINE UNTERMINATED DOUBLE-QUOTE', 		table:'',	no:1L, nb:0L, texte:'', class:"LINT_WARNING"		},	$
		{ fd:0L, nom:'index_instruction_execute_found.html',				msg:'INSTRUCTION EXECUTE FOUND',				table:'',	no:1L, nb:0L, texte:'', class:"LINT_WARNING"		},	$
		{ fd:0L, nom:'index_instruction_restore_found.html',				msg:'INSTRUCTION RESTORE FOUND',				table:'',	no:1L, nb:0L, texte:'', class:"LINT_WARNING"		},	$
		{ fd:0L, nom:'index_instruction_stop_found.html',				msg:'INSTRUCTION STOP FOUND',					table:'',	no:1L, nb:0L, texte:'', class:"LINT_WARNING"		},	$
		{ fd:0L, nom:'index_instruction_debug1_found.html',				msg:'INSTRUCTION DEBUG=1 FOUND',				table:'',	no:1L, nb:0L, texte:'', class:"LINT_WARNING"		},	$

		{ fd:0L, nom:'index_unused_label.html',						msg:'UNUSED LABEL',						table:'',	no:1L, nb:0L, texte:'', class:"LINT_WARNING"		},	$
		{ fd:0L, nom:'index_unused_param.html',						msg:'UNUSED PARAM',						table:'',	no:1L, nb:0L, texte:'', class:"LINT_WARNING"		},	$
		{ fd:0L, nom:'index_unused_keyword.html',					msg:'UNUSED KEYWORD',						table:'',	no:1L, nb:0L, texte:'', class:"LINT_WARNING"		},	$
		{ fd:0L, nom:'index_unused_common.html',					msg:'UNUSED COMMON',						table:'',	no:1L, nb:0L, texte:'', class:"LINT_WARNING"		},	$

		{ fd:0L, nom:'index_variable_set_but_not_used.html',				msg:'VARIABLE SET BUT NOT USED',				table:'',	no:1L, nb:0L, texte:'', class:"LINT_WARNING"		},	$
		{ fd:0L, nom:'index_variable_created_but_not_used.html',			msg:'VARIABLE CREATED BUT NOT USED',				table:'',	no:1L, nb:0L, texte:'', class:"LINT_WARNING"		},	$


		{ fd:0L, nom:'index_case_sensitive_label.html',					msg:'CASE SENSITIVE LABEL',					table:'',	no:1L, nb:0L, texte:'', class:"LINT_WARNING"		},	$
		{ fd:0L, nom:'index_case_sensitive_variable.html',				msg:'CASE SENSITIVE VARIABLE',					table:'',	no:1L, nb:0L, texte:'', class:"LINT_WARNING"		},	$
		{ fd:0L, nom:'index_case_sensitive_instance.html',				msg:'CASE SENSITIVE INSTANCE',					table:'END',	no:1L, nb:0L, texte:'', class:"LINT_WARNING"		}]

	nbmax_messages = N_ELEMENTS(infos)
	nom_modules_html 				= repertoire + '/modules.html'
	nom_system_html 				= repertoire + '/SYSTEM.html'

	OPENW,  fd_index, 				nom_index_html_tmp, 			/GET_LUN
	FOR j=0L,nbmax_messages-1 DO BEGIN
		; je ne peux pas utiliser /GET_LUN car j'ai plus de 28 fichiers (/GET_LUN retourne un fd entre 100 et 128, MAX=128)
		; mais les fd entre 1 et 99 sont disponibles
		OPENW, j+1, repertoire + '/' + infos[j].nom
		infos[j].fd = j+1
	END
	OPENW,  fd_modules, 				nom_modules_html, 			/GET_LUN
	OPENW,  fd_system, 				nom_system_html, 			/GET_LUN

	lint_printf, [fd_index,fd_system,infos.fd,fd_modules], '<!DOCTYPE HTML>'
	lint_printf, [fd_index,fd_system,infos.fd,fd_modules], '<html>'
	lint_printf, [fd_index,fd_system,infos.fd,fd_modules], '<head>'
	lint_printf, [fd_index,fd_system,infos.fd,fd_modules], '<meta http-equiv="Content-Type" content="text/html;charset=iso-8859-1">'
	lint_printf, [fd_index,fd_system,infos.fd,fd_modules], '<link href="'+html_dir+'/lint.css" rel="stylesheet" media="all" type="text/css">'	; feuille de style dans le <head>
	lint_printf, [fd_index,fd_system,infos.fd,fd_modules], '</head>'

	lint_printf, [fd_index,fd_system,infos.fd,fd_modules], '<body>'

	lint_printf, [fd_index,fd_system,fd_modules], '<table width="100%" border="0">'
	lint_printf, [fd_index,fd_system,fd_modules], '<tr>'
	lint_printf, [fd_index,fd_system,fd_modules], '<td width="25%" align="left"></td>'
	lint_printf, [fd_index,fd_system,fd_modules], '<td width="50%" align="center">'
	lint_printf, [fd_index,fd_system,fd_modules], '<a href="'+html_dir+'/'+target+'/lint.txt" target="_blank">lint.txt</a>'
	lint_printf, [fd_index,fd_system,fd_modules], '&nbsp;<a href="'+html_dir+'/'+target+'/lint.msg" target="_blank">lint.msg</a>'
	lint_printf, [fd_index,fd_system,fd_modules], '&nbsp;<a href="'+html_dir+'/'+target+'/SYSTEM.html" target="_blank">SYSTEM</a>'
	lint_printf, [fd_index,fd_system,fd_modules], '&nbsp;<a href="'+html_dir+'/'+target+'/index.html">Index</a>'
	lint_printf, [fd_index,fd_system,fd_modules], '&nbsp;<a href="'+html_dir+'/'+target+'/modules.html">Modules</a></td>'
	lint_printf, [fd_index,fd_system,fd_modules], '<td width="25%" align="right"></td>'
	lint_printf, [fd_index,fd_system,fd_modules], '</tr>'
	lint_printf, [fd_index,fd_system,fd_modules], '</table>'

	FOR j=0L,nbmax_messages-1 DO BEGIN
		IF infos[j].table EQ 'BEGIN' THEN lint_printf, [fd_index], '<table border="1" style="border-collapse: collapse;">'
		lint_printf, [fd_index], '<tr><td><a href="'+html_dir+'/'+target+'/'+infos[j].nom+'" target="_blank">'+infos[j].msg+'</a></td><td>$NB'+int_str_0(j, 2)+'</td></tr>'
		IF infos[j].table EQ 'END' THEN lint_printf, [fd_index], '</table><br>'
	END


	lint_printf, [fd_index,infos.fd], '<br>'

	VERT = '#00AA00'
	; Infos sur le nombre de routines
	lint_printf, [fd_index], '<table border="1" style="border-collapse: collapse;">'

	lint_unused = WHERE (decls.object NE '' AND decls.is_system NE 1 AND (decls.function_pro EQ 'FUNCTION' OR decls.function_pro EQ 'PRO'), nb_routines_object)
	lint_unused = WHERE (decls.is_cl_other EQ 0 AND decls.is_system NE 1 AND decls.object NE '' AND (decls.function_pro EQ 'PRO' OR decls.function_pro EQ 'FUNCTION') AND (decls.nb_params_max+decls.nb_keywords NE decls.nb_prototypes), nb_prototypes_pb)
	lint_unused = WHERE (decls.is_cl_other EQ 0 AND decls.is_system NE 1 AND decls.object NE '' AND (decls.function_pro EQ 'PRO' OR decls.function_pro EQ 'FUNCTION') AND (decls.nb_params_max+decls.nb_keywords EQ decls.nb_prototypes), nb_prototypes_ok)
	IF nb_routines_object NE 0 THEN BEGIN
		lint_printf, [fd_index], '<tr>'
		lint_printf, [fd_index], '<td>ROUTINES OBJECT <FONT COLOR='+VERT+'>(LINT_PROTOTYPES OK,LINT_PROTOTYPES PB)</FONT></td>'
		lint_printf, [fd_index], '<td>' + LINTC_INT_TO_STR(nb_routines_object) + ' <FONT COLOR='+VERT+'>(' + LINTC_INT_TO_STR(nb_prototypes_ok) + ',' + LINTC_INT_TO_STR(nb_prototypes_pb) + ')</FONT></td>'
		lint_printf, [fd_index], '<td>routines</td>'
		lint_printf, [fd_index], '</tr>'
	END

	lint_unused = WHERE (decls.object EQ '' AND decls.is_system NE 1 AND (decls.function_pro EQ 'FUNCTION' OR decls.function_pro EQ 'PRO'), nb_routines_non_object)
	lint_unused = WHERE (decls.is_cl_other EQ 0 AND decls.is_system NE 1 AND decls.object EQ '' AND (decls.function_pro EQ 'PRO' OR decls.function_pro EQ 'FUNCTION') AND (decls.nb_params_max+decls.nb_keywords NE decls.nb_prototypes), nb_prototypes_pb)
	lint_unused = WHERE (decls.is_cl_other EQ 0 AND decls.is_system NE 1 AND decls.object EQ '' AND (decls.function_pro EQ 'PRO' OR decls.function_pro EQ 'FUNCTION') AND (decls.nb_params_max+decls.nb_keywords EQ decls.nb_prototypes), nb_prototypes_ok)
	IF nb_routines_non_object NE 0 THEN BEGIN
		lint_printf, [fd_index], '<tr>'
		lint_printf, [fd_index], '<td>ROUTINES NON OBJECT <FONT COLOR='+VERT+'>(LINT_PROTOTYPES OK,LINT_PROTOTYPES PB)</FONT></td>'
		lint_printf, [fd_index], '<td>' + LINTC_INT_TO_STR(nb_routines_non_object) + ' <FONT COLOR='+VERT+'>(' + LINTC_INT_TO_STR(nb_prototypes_ok) + ',' + LINTC_INT_TO_STR(nb_prototypes_pb) + ')</FONT></td>'
		lint_printf, [fd_index], '<td>routines</td>'
		lint_printf, [fd_index], '</tr>'
	END

	lint_unused = WHERE (decls.is_system NE 1 AND decls.lint_variables NE '', nb_routines_avec_lint_variables)
	IF nb_routines_avec_lint_variables NE 0 THEN BEGIN
		lint_printf, [fd_index], '<tr>'
		lint_printf, [fd_index], '<td>ROUTINES WITH LINT_VARIABLES</td>'
		lint_printf, [fd_index], '<td>' + LINTC_INT_TO_STR(nb_routines_avec_lint_variables)  + '</td>'
		lint_printf, [fd_index], '<td>routines</td>'
		lint_printf, [fd_index], '</tr>'
	END
	lint_printf, [fd_index], '</table>'

	lint_printf, [fd_index], '<br>'

	; Infos sur le nombre de lignes
	lint_printf, [fd_index], '<table border="1" style="border-collapse: collapse;">'
	total_nblignes_IDL_interne_all = common_lint_infos.total_nblignes_IDL_interne_all
	total_nblignes_IDL_interne_code = common_lint_infos.total_nblignes_IDL_interne_code
	IF total_nblignes_IDL_interne_code NE 0 THEN BEGIN
		lint_printf, [fd_index], '<tr>'
		lint_printf, [fd_index], '<td>IDL internal <FONT COLOR='+VERT+'>(code only)</FONT></td>'
		lint_printf, [fd_index], '<td>' + LINTC_INT_TO_STR(total_nblignes_IDL_interne_all) + ' <FONT COLOR='+VERT+'>(' + LINTC_INT_TO_STR(total_nblignes_IDL_interne_code) + ')</FONT></td>'
		lint_printf, [fd_index], '<td>lines</td>'
		lint_printf, [fd_index], '</tr>'
	END

	total_nblignes_IDL_externe_all = common_lint_infos.total_nblignes_IDL_externe_all
	total_nblignes_IDL_externe_code = common_lint_infos.total_nblignes_IDL_externe_code
	IF total_nblignes_IDL_externe_code NE 0 THEN BEGIN
		lint_printf, [fd_index], '<tr>'
		lint_printf, [fd_index], '<td>IDL external <FONT COLOR='+VERT+'>(code only)</FONT></td>'
		lint_printf, [fd_index], '<td>' + LINTC_INT_TO_STR(total_nblignes_IDL_externe_all) + ' <FONT COLOR='+VERT+'>(' + LINTC_INT_TO_STR(total_nblignes_IDL_externe_code) + ')</FONT></td>'
		lint_printf, [fd_index], '<td>lines</td>'
		lint_printf, [fd_index], '</tr>'
	END

	total_nblignes_IDL_other_all = common_lint_infos.total_nblignes_IDL_other_all
	total_nblignes_IDL_other_code = common_lint_infos.total_nblignes_IDL_other_code
	IF total_nblignes_IDL_other_code NE 0 THEN BEGIN
		lint_printf, [fd_index], '<tr>'
		lint_printf, [fd_index], '<td>IDL other <FONT COLOR='+VERT+'>(code only)</FONT></td>'
		lint_printf, [fd_index], '<td>' + LINTC_INT_TO_STR(total_nblignes_IDL_other_all)  + ' <FONT COLOR='+VERT+'>(' + LINTC_INT_TO_STR(total_nblignes_IDL_other_code) + ')</FONT></td>'
		lint_printf, [fd_index], '<td>lines</td>'
		lint_printf, [fd_index], '</tr>'
	END

	total_nblignes_IDL_all  = common_lint_infos.total_nblignes_IDL_all
	total_nblignes_IDL_code = common_lint_infos.total_nblignes_IDL_code
	IF total_nblignes_IDL_all NE 0 THEN BEGIN
		lint_printf, [fd_index], '<tr>'
		lint_printf, [fd_index], '<td>IDL <FONT COLOR='+VERT+'>(code only)</FONT></td>'
		lint_printf, [fd_index], '<td>' + LINTC_INT_TO_STR(total_nblignes_IDL_all)  + ' <FONT COLOR='+VERT+'>(' + LINTC_INT_TO_STR(total_nblignes_IDL_code) + ')</FONT></td>'
		lint_printf, [fd_index], '<td>lines</td>'
		lint_printf, [fd_index], '</tr>'
	END

	total_nblignes_C_all  = common_lint_infos.total_nblignes_C_all
	total_nblignes_C_code = common_lint_infos.total_nblignes_C_code
	IF total_nblignes_C_all NE 0 THEN BEGIN
		lint_printf, [fd_index], '<tr>'
		lint_printf, [fd_index], '<td>C <FONT COLOR='+VERT+'>(code only)</FONT></td>'
		lint_printf, [fd_index], '<td>' + LINTC_INT_TO_STR(total_nblignes_C_all)  + ' <FONT COLOR='+VERT+'>(' + LINTC_INT_TO_STR(total_nblignes_C_code) + ')</FONT></td>'
		lint_printf, [fd_index], '<td>lines</td>'
		lint_printf, [fd_index], '</tr>'
	END
	lint_printf, [fd_index], '</table>'

	lint_printf, [fd_index], '<br>'

	lint_printf, [infos.fd,fd_modules,fd_system,fd_index], '<table width="100%" border="1" style="border-collapse: collapse;">'
	lint_printf, [infos.fd,fd_system,fd_index], '<tr>'
	lint_printf, [infos.fd,fd_system,fd_index], '<th>Nb</th>'
	lint_printf, [infos.fd,fd_system,fd_index], '<th>FUNC/PRO/INCLUDE Name</th>'
	lint_printf, [infos.fd,fd_system,fd_index], '<th>Module</th>'
	lint_printf, [infos.fd,fd_system,fd_index], '<th>Lines</th>'
	lint_printf, [infos.fd,fd_system,fd_index], '<th>Doc</th>'
	lint_printf, [infos.fd,fd_system,fd_index], '</tr>'

	numero = 1L
	module = ''
	FOR i=0L,N_ELEMENTS(decls)-1 DO BEGIN

		; pour ne pas mettre du tout les routines 'SYSTEM'
		;IF decls[i].module EQ 'SYSTEM' THEN CONTINUE

		; pour mettre seulement les routines SYSTEM qui sont utilises
		;IF decls[i].module EQ 'SYSTEM' THEN BEGIN
		;	IF decls[i].nb_use EQ 0 THEN CONTINUE
		;END

		;IF decls[i].nb_use EQ 0 THEN BEGIN
		;	IF decls[i].object NE '' AND decls[i].name EQ 'define' THEN BEGIN
		;	END ELSE IF decls[i].object NE '' AND decls[i].name EQ 'init' THEN BEGIN
		;	END ELSE IF decls[i].object NE '' AND decls[i].name EQ 'cleanup' THEN BEGIN
		;	END ELSE BEGIN
		;		CONTINUE
		;	END
		;END

		FILE_MKDIR, repertoire + '/' + decls[i].module

		IF decls[i].module NE module THEN BEGIN

			IF module NE '' THEN BEGIN
				PRINTF,   fd_module, '</table>'
				PRINTF,   fd_module, '</body>'
				PRINTF,   fd_module, '</html>'
				FREE_LUN, fd_module
			END
			nom_module_html = repertoire + '/' + decls[i].module + '.html'
			OPENW,  fd_module, nom_module_html, /GET_LUN

			fd = decls[i].is_system ? [fd_system,fd_module] : [fd_index,fd_module] ; ne pas mettre les routines SYSTEM dans index.html

			PRINTF, fd_module, '<!DOCTYPE HTML>'
			PRINTF, fd_module, '<html>'
			PRINTF, fd_module, '<head>'
			PRINTF, fd_module, '<meta http-equiv="Content-Type" content="text/html;charset=iso-8859-1">'
			PRINTF, fd_module, '<link href="'+html_dir+'/lint.css" rel="stylesheet" media="all" type="text/css">'	; feuille de style dans le <head>
			PRINTF, fd_module, '</head>'
			PRINTF, fd_module, '<body>'

			PRINTF, fd_module, '<table width="100%" border="0">'
			; Lien Previous
			; -------------
			PRINTF, fd_module, '<td width="25%" align="left">'
			tmp1 = WHERE (decls[0:i].module NE decls[i].module AND decls[0:i].is_system NE 1)
			IF tmp1[0] NE -1 THEN PRINTF, fd_module, 'Previous <a href="'+html_dir+'/'+target+'/'+decls[tmp1[N_ELEMENTS(tmp1)-1]].function_pro+'_'+decls[tmp1[N_ELEMENTS(tmp1)-1]].module+'.html">'+decls[tmp1[N_ELEMENTS(tmp1)-1]].module+'</a>'
			PRINTF, fd_module, '</td>'

			PRINTF, fd_module, '<td width="50%" align="center"><a href="'+html_dir+'/'+target+'/index.html">Index</a>&nbsp;<a href="'+html_dir+'/'+target+'/modules.html">Modules</a></td></td>'

			; Lien Next
			; ---------
			PRINTF, fd_module, '<td width="25%" align="right">'
			tmp1 = WHERE (decls[i:*].module NE decls[i].module AND decls[i:*].is_system NE 1)
			IF tmp1[0] NE -1 THEN PRINTF, fd_module, 'Next <a href="'+html_dir+'/'+target+'/'+decls[i+tmp1[0]].function_pro+'_'+decls[i+tmp1[0]].module+'.html">'+decls[i+tmp1[0]].module+'</a>'
			PRINTF, fd_module, '</td>'

			PRINTF, fd_module, '</table>'


			lint_printf, [fd_module],  '<table width="100%" border="1" style="border-collapse: collapse;">'
			IF module NE '' THEN lint_printf, fd, '<tr><td colspan=6 bgcolor="#00aa00"></td></tr>'
			lint_printf, [fd_modules],         '<tr><td><a href="'+html_dir+'/'+target+'/'+decls[i].module+'.html" target="_blank">'+decls[i].module+'</a></td></tr>'
			lint_printf, [fd_module], '<th>Nb</th>'
			lint_printf, [fd_module], '<th>FUNC/PRO/INCLUDE Name</th>'
			lint_printf, [fd_module], '<th>Module</th>'
			lint_printf, [fd_module], '<th>Lines</th>'
			lint_printf, [fd_module], '<th>Doc</th>'
			lint_printf, [fd_module], '</tr>'
			numero = 1L
		END

		top1 = nbsec()

		; Transformer la chaine decls[i].msg en:
		; 	msg_noline[]
		;	msg_txt1[]
		;	msg_txt2[]
		;	msg_class[]
		; Et mettre  jour infos.nb
		msg = STRSPLIT(decls[i].msg, !SEP1, /EXTRACT)
		msg_noline = REPLICATE (0L, N_ELEMENTS(msg)) ; LONG pour LINTC_INT_TO_STR
		msg_txt1   = REPLICATE ('', N_ELEMENTS(msg))
		msg_txt2   = REPLICATE ('', N_ELEMENTS(msg))
		msg_class  = REPLICATE ('', N_ELEMENTS(msg))
		infos.nb = 0
		FOR j=0L,N_ELEMENTS(msg)-1 DO BEGIN
			IF msg[j] EQ '' THEN CONTINUE
			tmp = STRSPLIT (msg[j], !SEP2, /EXTRACT, /PRESERVE_NULL) ; il peut y avoir des champs vides
			ind = (WHERE (infos.msg EQ tmp[2]))[0]
			msg_noline[j] = tmp[0]
			msg_txt1[j]   = tmp[2]
			msg_txt2[j]   = tmp[3]
			msg_class[j]  = infos[ind].class
			infos[ind].nb++
		END
		nb_msgs = msg[0] EQ '' ? 0L : N_ELEMENTS(msg_noline)

		; If faut absolument trier les messages par numros de ligne pour que LINTC_CODE_TO_HTML fonctionne correctement
		trie = SORT(msg_noline)
		msg_noline = msg_noline[trie]
		msg_txt1   = msg_txt1[trie]
		msg_txt2   = msg_txt2[trie]
		msg_class  = msg_class[trie]

		; Transformer la chaine decls[i].cla en:
		; 	cla_noline[]
		;	cla_nochar[]
		;	cla_type[]
		;	cla_word[]
		;	cla_extra[]
		;	cla_link[]
		nb_clas = decls[i].nbclas
		cla_noline = (*decls[i].cla).noline
		cla_nochar = (*decls[i].cla).nochar
		cla_type   = (*decls[i].cla).type
		cla_word   = (*decls[i].cla).word
		cla_extra  = (*decls[i].cla).extra
		cla_link   = (*decls[i].cla).link

		; If faut absolument trier les cla par numros de ligne puis numro de colonne pour que LINTC_CODE_TO_HTML fonctionne correctement
		trie = SORT(cla_noline*(1+MAX(cla_nochar)) + cla_nochar)
		cla_noline = cla_noline[trie]
		cla_nochar = cla_nochar[trie]
		cla_type   = cla_type[trie]
		cla_word   = cla_word[trie]
		cla_extra  = cla_extra[trie]
		cla_link   = cla_link[trie]

		; Transformer la chaine decls[i].ccc en:
		; 	ccc_noline[]
		;	ccc_nochar[]
		;	ccc_type[]
		;	ccc_word[]
		;	ccc_extra[]
		;	ccc_link[]
;		ccc = STRSPLIT(decls[i].c, !SEP1, /EXTRACT)
;		ccc_noline = REPLICATE (0L, N_ELEMENTS(ccc))
;		ccc_nochar = REPLICATE (0L, N_ELEMENTS(ccc))
;		ccc_type   = REPLICATE ('', N_ELEMENTS(ccc))
;		ccc_word   = REPLICATE ('', N_ELEMENTS(ccc))
;		ccc_extra  = REPLICATE ('', N_ELEMENTS(ccc))
;		ccc_link   = REPLICATE ('', N_ELEMENTS(ccc))
;		FOR j=0L,N_ELEMENTS(ccc)-1 DO BEGIN
;			IF ccc[j] EQ '' THEN CONTINUE
;			tmp2 = STRSPLIT(ccc[j], !SEP2, /EXTRACT, /PRESERVE_NULL)
;			ccc_noline[j] = tmp2[0]
;			ccc_nochar[j]  = tmp2[1]
;			ccc_type[j]    = tmp2[2]
;			ccc_word[j]    = tmp2[3]
;			IF N_ELEMENTS(tmp2) GE 5 THEN ccc_extra[j]  = tmp2[4]
;			IF N_ELEMENTS(tmp2) GE 6 THEN ccc_link[j]   = tmp2[5]
;		END
;		nb_cccs = ccc_noline[0] EQ -1 ? 0L : N_ELEMENTS(ccc_noline)

		previous = i GT 0 && decls[i-1].module EQ decls[i].module ? decls[i-1].function_pro+'_'+decls[i-1].name : ''
		next = i LT N_ELEMENTS(decls)-1 && decls[i+1].module EQ decls[i].module ? decls[i+1].function_pro+'_'+decls[i+1].name : ''
		name = decls[i].name
		module = decls[i].module
		function_pro = decls[i].function_pro
		object = decls[i].object

		; Transformer la chaine decls[i].prototype en:
		; 	- tableau string prototype_type
		;	- tableau string prototype_name
		;	- int nb_prototypes
		prototype = STRSPLIT(decls[i].prototype, /EXTRACT)
		nb_prototypes = prototype[0] EQ '' ? 0L : N_ELEMENTS(prototype)
		prototype_type = REPLICATE ('', MAX([1,nb_prototypes]))
		prototype_name = REPLICATE ('', MAX([1,nb_prototypes]))
		FOR j=0L,nb_prototypes-1 DO BEGIN
			tmp = STRSPLIT (prototype[j], ':', /EXTRACT)
			prototype_name[j] = tmp[0]
			prototype_type[j] = tmp[1]
		END

		; Transformer la chaine decls[i].calledby en:
		;	- tableau string calledby_nb
		;	- tableau string calledby_module
		;	- tableau string calledby_function_pro
		;	- tableau string calledby_name
		;	- int nb_calledbys
		calledby = STRSPLIT(decls[i].calledby, /EXTRACT)
		nb = calledby[0] EQ '' ? 0L : N_ELEMENTS(calledby)
		calledby_nb           = REPLICATE (0L, MAX([1,nb]))
		calledby_module       = REPLICATE ('', MAX([1,nb]))
		calledby_function_pro = REPLICATE ('', MAX([1,nb]))
		calledby_name         = REPLICATE ('', MAX([1,nb]))
		nb_calledbys = 0L
		FOR j=0L,nb-1 DO BEGIN
			; dja vu ?
			ind = (WHERE (calledby_module EQ decls[calledby[j]].module AND calledby_name EQ decls[calledby[j]].name))[0]
			IF ind NE -1 THEN BEGIN
				calledby_nb[ind]++
			END ELSE BEGIN
				calledby_nb[nb_calledbys]           = 1
				calledby_module[nb_calledbys]       = decls[calledby[j]].module
				calledby_function_pro[nb_calledbys] = decls[calledby[j]].function_pro
				calledby_name[nb_calledbys]         = decls[calledby[j]].name
				nb_calledbys++
			END
		END

		; Transformer la chaine decls[i].call en:
		;	- tableau string call_nb
		;	- tableau string call_module
		;	- tableau string call_function_pro
		;	- tableau string call_name
		;	- int nb_calls
		call = STRSPLIT(decls[i].call, /EXTRACT)
		nb = call[0] EQ '' ? 0L : N_ELEMENTS(call)
		call_nb           = REPLICATE (0L, MAX([1,nb]))
		call_module       = REPLICATE ('', MAX([1,nb]))
		call_function_pro = REPLICATE ('', MAX([1,nb]))
		call_name         = REPLICATE ('', MAX([1,nb]))
		nb_calls = 0L
		FOR j=0L,nb-1 DO BEGIN
			IF call[j] EQ '' THEN CONTINUE
			IF decls[call[j]].is_system THEN CONTINUE ; ne pas compter les appels aux fonctions systmes
			; dja vu ?
			ind = (WHERE (call_module EQ decls[call[j]].module AND call_name EQ decls[call[j]].name))[0]
			IF ind NE -1 THEN BEGIN
				call_nb[ind]++
			END ELSE BEGIN
				call_nb[nb_calls]           = 1
				call_module[nb_calls]       = decls[call[j]].module
				call_function_pro[nb_calls] = decls[call[j]].function_pro
				call_name[nb_calls]         = decls[call[j]].name
				nb_calls++
			END
		END

		; Transformer decls[i].vars_common, decls[i].vars_para, decls[i].vars_local_for et decls[i].vars_local en:
		; 	- tableau string vars_type
		; 	- tableau string vars_name
		;	- int nb_vars
		vars_commons   = STRSPLIT(decls[i].vars_common,    /EXTRACT)
		vars_para      = STRSPLIT(decls[i].vars_para,      /EXTRACT)
		vars_local_for = STRSPLIT(decls[i].vars_local_for, /EXTRACT)
		vars_local     = STRSPLIT(decls[i].vars_local,     /EXTRACT)
		nbvars_commons   = decls[i].vars_common    EQ '' ? 0L : N_ELEMENTS(vars_commons)
		nbvars_para      = decls[i].vars_para      EQ '' ? 0L : N_ELEMENTS(vars_para)
		nbvars_local_for = decls[i].vars_local_for EQ '' ? 0L : N_ELEMENTS(vars_local_for)
		nbvars_local     = decls[i].vars_local     EQ '' ? 0L : N_ELEMENTS(vars_local)
		nb_vars = nbvars_commons + nbvars_para + nbvars_local_for + nbvars_local
		vars_type = REPLICATE ('', MAX([1,nb_vars]))
		vars_name = REPLICATE ('', MAX([1,nb_vars]))
		nb = 0L
		FOR j=0L,nbvars_commons-1 DO BEGIN
			vars_type[nb] = 'VAR_COMMON'
			vars_name[nb] = vars_commons[j]
			nb++
		END
		FOR j=0L,nbvars_para-1 DO BEGIN
			vars_type[nb] = 'VAR_PARA'
			vars_name[nb] = vars_para[j]
			nb++
		END
		FOR j=0L,nbvars_local_for-1 DO BEGIN
			vars_type[nb] = 'VAR_FOR'
			vars_name[nb] = vars_local_for[j]
			nb++
		END
		FOR j=0L,nbvars_local-1 DO BEGIN
			vars_type[nb] = 'VAR'
			vars_name[nb] = vars_local[j]
			nb++
		END

		; Transformer decls[i].labels_found en:
		;	- tableau string labels_name
		;	- int nb_labels
		labels_found = STRSPLIT(decls[i]. labels_found, /EXTRACT)
		nb_labels = labels_found[0] EQ '' ? 0L : N_ELEMENTS(labels_found)
		labels_name = REPLICATE ('' , MAX([1,nb_labels]))
		labels_name[*] = labels_found

		; Transformer decls[i].commons en:
		;	- tableau string commons_common_name
		;	- tableau string commons_var_name
		;	- int nb_commons
		commons = STRSPLIT(decls[i].commons, !SEP1, /EXTRACT)
		nb_commons = commons[0] EQ '' ? 0L : N_ELEMENTS(commons)
		commons_common_name = REPLICATE ('', MAX([1,nb_commons]))
		commons_var_name    = REPLICATE ('', MAX([1,nb_commons]))
		FOR j=0L,nb_commons-1 DO BEGIN
			tmp = STRSPLIT(commons[j], !SEP2, /EXTRACT) ; de la forme common_name+!SEP2+no_ligne+!SEP2+var1 var2 ... varn
			commons_common_name[j] = (STRSPLIT(tmp[0], ':', /EXTRACT))[0]
			IF N_ELEMENTS(tmp) GE 3 THEN commons_var_name[j] = tmp[2:*] ; peut tre vide
		END

		doc = lint_doc_to_html(decls[i].doc, /txt)

		is_IDL = ~decls[i].is_c
		is_C   = decls[i].is_c

		premiere_ligne = decls[i].noligne2+1+decls[i].nblignes_doc
		IF ~is_IDL THEN premiere_ligne = decls[i].noligne1
		derniere_ligne =  decls[i].noligne1+decls[i].nblignes-1

		top2 = nbsec()
		IF decls[i].is_system EQ 1 THEN common_lint_infos.duree_before_SYSTEM += top2 - top1
		IF decls[i].is_system NE 1 THEN common_lint_infos.duree_before_USER   += top2 - top1

		nom_routine_html = repertoire + '/' + decls[i].module + '/' + function_pro + '_' + decls[i].name + '.html'

		top1 = nbsec()
		LINTC_CODE_TO_HTML, is_IDL, is_C, html_dir, target, nom_routine_html, function_pro, module, name, object, previous, next,		$
			decls[i].code, decls[i].noligne1, decls[i].noligne2, premiere_ligne, derniere_ligne,						$
			nb_prototypes, prototype_name, prototype_type,											$
			doc,																$
			nb_calledbys, calledby_module, calledby_function_pro, calledby_name, calledby_nb,						$
			nb_calls, call_module, call_function_pro, call_name, call_nb, 									$
			nb_vars, vars_type, vars_name, 													$
			nb_labels, labels_name,														$
			nb_commons, commons_common_name, commons_var_name,										$
			nb_msgs, msg_noline, msg_txt1, msg_txt2, msg_class,										$
			nb_clas, cla_noline, cla_nochar, cla_type, cla_word, cla_extra, cla_link
		top2 = nbsec()
		common_lint_infos.duree_lintc_code_to_html += top2-top1

;		nom_routine_c = repertoire + '/' + decls[i].module + '/' + decls[i].name + '.c'
;		top1 = nbsec()
;		LINTC_CODE_TO_C, is_IDL, is_INCLUDE, html_dir, target, nom_routine_c, function_pro, module, name, object, previous, next,		$
;			decls[i].code, decls[i].noligne1, decls[i].noligne2, premiere_ligne, derniere_ligne,					$
;			nb_prototypes, prototype_name, prototype_type,											$
;			doc,																$
;			nb_vars, vars_type, vars_name, 													$
;			nb_labels, labels_name,														$
;			nb_commons, commons_common_name, commons_var_name,										$
;			nb_cccs, ccc_noline, ccc_nochar, ccc_type, ccc_word, ccc_extra, ccc_link
;		top2 = nbsec()
;		common_lint_infos.duree_lintc_code_to_html += top2-top1

		top1 = nbsec()

		texte = ''
		is_interne = lint_is_interne(decls, i)
		IF is_interne EQ 1 THEN BEGIN
			texte += '&nbsp;<b>INTERNAL</b>'
		END ELSE IF is_interne EQ 2 THEN BEGIN
			texte += '&nbsp;<b>NEVER_USED</b>'
		END

		FOR j=0L,nbmax_messages-1 DO BEGIN
			IF infos[j].nb NE 0 THEN BEGIN
				tmp = '<br><b>'+infos[j].msg+' ('+LINTC_INT_TO_STR(infos[j].nb)+')</b>'
				texte += tmp
				infos[j].texte = tmp
			END
		END

		fds = fd
		FOR j=0L,nbmax_messages-1 DO BEGIN
			IF infos[j].nb NE 0 THEN fds = [ fds, infos[j].fd ]
		END


		lint_printf, fds, '<tr>'

		lint_printf, fds, '<td>'
		lint_printf, fd, LINTC_INT_TO_STR(numero)
		FOR j=0L,nbmax_messages-1 DO BEGIN
			IF infos[j].nb NE 0 THEN lint_printf, infos[j].fd, LINTC_INT_TO_STR(infos[j].no)
		END
		lint_printf, fds, '</td>'

		lint_printf, fd, is_interne ? '<td class="INTERNAL">' : '<td>'
		FOR j=0L,nbmax_messages-1 DO BEGIN
			IF infos[j].nb NE 0 THEN lint_printf, infos[j].fd, '<td>'
		END

		IF decls[i].object EQ '' THEN BEGIN
			name = ''
		END ELSE BEGIN
			name = decls[i].object
			IF decls[i].inherits NE '' THEN BEGIN
				name += '(INHERITS '+ decls[i].inherits + ')'
			END
			name += '::'
		END
		name += decls[i].name
		lint_printf, fds, decls[i].function_pro+'&nbsp;<a href="'+html_dir+'/'+target+'/' + decls[i].module+'/'+decls[i].function_pro+'_'+decls[i].name+'.html" target="_blank">'+name+'</a>'
		tmp1 = lint_doc_to_html(decls[i].doc, /first, /rouge)
		lint_printf, fd, tmp1 + texte
		FOR j=0L,nbmax_messages-1 DO BEGIN
			IF infos[j].nb NE 0 THEN lint_printf, infos[j].fd, tmp1 + infos[j].texte
		END
		lint_printf, fds, '</td>'

		IF ~decls[i].is_cl_other THEN BEGIN
			IF (WHERE (liste_verifier_all_ordre_compilation EQ i))[0] NE -1 THEN BEGIN
				lint_unused = lint_utilise_uniquement_des_routines_compilees(decls, i)
			END
			IF (WHERE (liste_verifier_mini_ordre_compilation EQ i))[0] NE -1 THEN BEGIN
				lint_unused = lint_utilise_uniquement_des_routines_compilees_dans_ordre(decls, i)
			END
		END
		lint_printf, fds, '<td>'
		lint_printf, fds, '<a href="'+html_dir+'/'+target+'/'+decls[i].module+'.html" target="_blank">'+ decls[i].module + '</a>'
		lint_printf, fds, '</td>'

		lint_printf, fds, '<td>'
		lint_printf, fds, LINTC_INT_TO_STR(decls[i].nblignes)
		lint_printf, fds, '</td>'

		tmp1 = lint_doc_to_html(decls[i].doc, /first)
		IF decls[i].is_cl_other || decls[i].is_c || decls[i].is_system THEN BEGIN
			lint_printf, fds, '<td>'
			lint_printf, fds, tmp1
		END ELSE BEGIN
			IF target NE 'cl' THEN BEGIN
				tmp2 = ''
			END ELSE IF STRCOMPRESS(tmp1, /REMOVE_ALL) EQ '' THEN BEGIN
				tmp2 = ' class="LINT_WARNING"'
			END ELSE IF STRMID(tmp1, 0, 1) EQ '-' THEN BEGIN
				tmp2 = ' class="LINT_WARNING"'
			END ELSE IF STRLEN(tmp1) LT 20 THEN BEGIN
				tmp2 = ' class="LINT_WARNING"'
			END ELSE BEGIN
				tmp2 = ''
			END
			lint_printf, fds, '<td' + tmp2 + '>'
			lint_printf, fds, tmp1
		END
		lint_printf, fds, '</td>'

		lint_printf, fds, '</tr>'

		module = decls[i].module
		numero++
		FOR j=0L,nbmax_messages-1 DO BEGIN
			IF infos[j].nb NE 0 THEN infos[j].no++
		END

		top2 = nbsec()
		common_lint_infos.duree_after += top2 - top1

	END

	lint_printf, [fd_module,fd_index,infos.fd,fd_modules], '</table>'
	lint_printf, [fd_module,fd_index,infos.fd,fd_modules], '</body>'
	lint_printf, [fd_module,fd_index,infos.fd,fd_modules], '</html>'
	FREE_LUN, fd_module
	FREE_LUN, fd_index
	FREE_LUN, fd_modules
	FREE_LUN, fd_system
	FOR i=0L,nbmax_messages -1 DO CLOSE, infos[i].fd

	top1 = nbsec()
	lint_remplacer_fichier, nom_index_html_tmp, STRMID(nom_index_html_tmp, 0, STRLEN(nom_index_html_tmp)-4), infos
	lint_unused = detruire (nom_index_html_tmp)
	top2 = nbsec()
	PRINT, 'lint_remplacer_fichier in ' + val_to_str_2decimales(top2-top1)+' sec'

END


;-------------------------------------------------------------------------------
PRO lint,		$
;-------------------------------------------------------------------------------
	argv,		$	; LINT_PROTOTYPE input
	noexit=noexit		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Analyse les fichiers codes en IDL ou C donnes en argument et cre des fichiers html
;
; Limitations:
; ------------
; - Maxi !MAX_ROUTINES routines (y compris les routines systmes)
; - Maxi !MAX_ARGS arguments par routine IDL
;-------------------------------------------------------------------------------

	COMMON COMMON_LINT, common_lint_infos

	; Pour GDL
	DEFSYSV, '!GDL', exist=exist
	IF exist EQ 0 THEN DEFSYSV, '!GDL', { RELEASE:'', BUILD_DATE:'' }

	; Pour FDL
	DEFSYSV, '!FL', exist=exist
	IF exist EQ 0 THEN DEFSYSV, '!FL', { RELEASE:'' }

	IF 0 THEN get_cspice_prototypes, '/home/penou/spicelib' ; pour faire croire  lint que la routine est appell

	HTML_ROOT = '/var/www/html'
	HTML_DIR  = '/manu/lint'
	;HTML_DIR  = '/lint'

	PROFILE = 1 ; pour crer fichier 'lint.profiler'

	DEFSYSV, '!DEBUG', 			0						; 1 pour afficher des messages de debug
	DEFSYSV, '!MAX_ROUTINES',		40000						; nombre maxi de routines (IDL + C)
	DEFSYSV, '!MAX_ARGS',			1000						; nombre maxi d'arguments par routine
	DEFSYSV, '!SEP1', 			STRING(1b)					; sparateur
	DEFSYSV, '!SEP2', 			STRING(2b)					; sparateur
	DEFSYSV, '!SYSTEM_INCLUDE_DIR', 	['/usr/include','/usr/lib/bcc/include','CLUSTER/SOFT/LIB/inc']	; rpertoires ou se trouvent les include system
	DEFSYSV, '!LINT_SYSTEM_FUNCTIONC',	0						; 1 pour mettre un lien html vers les FUNCTIONC system
	DEFSYSV, '!LINT_SYSTEM_MACROC',		0						; 1 pour mettre un lien html vers les MACROC system
	DEFSYSV, '!LINT_SYSTEM_TYPEC',		0						; 1 pour mettre un lien html vers les TYPEC system

	top_debut = nbsec()

	IF N_ELEMENTS(argv)      EQ 0 THEN argv   = ''
	IF N_ELEMENTS(noexit)    EQ 0 THEN noexit = 0

	tmp = STRSPLIT (argv, /EXTRACT)
	target = tmp[0] EQ '' ? 'cl' : tmp[0]
	filenames = N_ELEMENTS(tmp) GE 2 ? tmp[1:*] : ''

	; suppresion de "./' en dbut de filenames
	FOR i=0L,N_ELEMENTS(filenames)-1 DO BEGIN
		IF STRMID(filenames[i], 0, 2) EQ './' THEN filenames[i] = STRMID(filenames[i], 2)
	END

	result = FILE_INFO (HTML_ROOT + HTML_DIR + '/' + target)
	IF result.directory THEN BEGIN
		; supprimer tous les fichiers
		FILE_DELETE,  HTML_ROOT + HTML_DIR + '/' + target, /RECURSIVE
	END

	mkdir_p, HTML_ROOT + HTML_DIR + '/' + target

	OPENW, fd_log, HTML_ROOT + HTML_DIR + '/' + target + '/lint.msg', /GET_LUN, WIDTH=1e6
	PRINTF, fd_log, '<html>'
	PRINTF, fd_log, '<pre>'

	common_lint_infos = {	target:					target,		$
				html_dir:				HTML_DIR,	$
				fd_log:					fd_log,		$
				duree_bigline:				0.,		$
				duree_before_SYSTEM:			0.,		$
				duree_before_USER:			0.,		$
				duree_after:				0.,		$
				duree_lintc_code_to_html:		0.,		$
				total_nblignes_IDL_interne_all:		0L,		$
				total_nblignes_IDL_interne_code:	0L,		$
				total_nblignes_IDL_externe_all:		0L,		$
				total_nblignes_IDL_externe_code:	0L,		$
				total_nblignes_IDL_other_all:		0L,		$
				total_nblignes_IDL_other_code:		0L,		$
				total_nblignes_IDL_all:			0L,		$
				total_nblignes_IDL_code:		0L,		$
				total_nblignes_C_all:			0L,		$
				total_nblignes_C_code:			0L		$
	}

	IF PROFILE THEN PROFILER

	; 'hash' de decls
	;table pour acclrer la recherche d'une routine IDL dans decls.name (ex: ind = WHERE (decls.name EQ 'toto'))
	hash = { name: PTRARR(256), object: PTRARR(256), module: PTRARR(256) }

	; Obtenir la liste des modules  analyser
	top1 = nbsec()
	liste = lint_get_list(filenames)
	top2 = nbsec()
	duree_get_list = top2-top1

	; FORMAT pour les messages d'erreur: nombre de caractres max dans liste.filename + 10
	DEFSYSV, '!FORMAT', '(A-' + val_to_str(10+MAX(STRLEN(liste.filename))) + ')'

	; Ajouter les routines systeme
	top1 = nbsec()
	lint_add_system_routines, decls, hash
	top2 = nbsec()
	duree_add_system_routines = top2-top1

	; Chercher les dclaration de FUNCTION/PRO
	top1 = nbsec()
	lint_pass1, liste, decls, hash, HTML_ROOT + HTML_DIR + '/' + target
	top2 = nbsec()
	duree_pass1 = top2-top1

	; finaliser_decls
	top1 = nbsec()
	lint_finaliser_decls, decls, hash
	top2 = nbsec()
	duree_finaliser_decls = top2-top1

	; check_dlm
	IF 0 THEN check_dlm, decls ; pour faire croir  lint que la routine est appell

	; check_help
	IF 0 THEN check_help, decls ; pour faire croire  lint que la routine est appell

	; Vrifier les dclarations de COMMON
	top1 = nbsec()
	lint_check_commons, decls
	top2 = nbsec()
	duree_check_commons = top2-top1

	; Analyser le code
	top1 = nbsec()
	lint_pass2, liste, decls, hash
	top2 = nbsec()
	duree_pass2 = top2-top1

	; Compter le nombre de lignes
	top1 = nbsec()
	lint_get_numbers_of_lines, liste
	top2 = nbsec()
	duree_get_numbers_of_lines = top2-top1

	; Afficher des infos sur les FUNCTION/PRO (FUNCTION/PRO et KEYWORD NEVER USED)
	top1 = nbsec()
	lint_afficher_infos_appels, decls
	top2 = nbsec()
	duree_afficher_infos_appels = top2-top1

	; Afficher des infos sur les FUNCTION/PRO (nombre de FUNCTION/PRO)
	top1 = nbsec()
	lint_afficher_infos_declarations, decls
	top2 = nbsec()
	duree_afficher_infos_declarations = top2-top1

	; Ecrire les rsultats
	top1 = nbsec()
	lint_ecrire_resultats_listing, decls, HTML_ROOT + HTML_DIR + '/' + target
	top2 = nbsec()
	duree_ecrire_resultats_listing = top2-top1

	; Ecrire les rsultats en html
	top1 = nbsec()
	lint_ecrire_resultats_html, decls, HTML_ROOT + HTML_DIR + '/' + target
	top2 = nbsec()
	duree_ecrire_resultats_html = top2-top1

	top_fin = nbsec()


	IF PROFILE THEN ecrire_profiler, 0, HTML_ROOT + HTML_DIR + '/' + target + '/lint.profiler'

	my_print, 'lint_add_system_routines         in ' + STRING(duree_add_system_routines,			FORMAT='(F7.2)')	+ ' sec'
	my_print, 'lint_get_list                    in ' + STRING(duree_get_list,				FORMAT='(F7.2)')	+ ' sec'
	my_print, 'lint_pass1                       in ' + STRING(duree_pass1,					FORMAT='(F7.2)')	+ ' sec'
	my_print, 'lint_finaliser_decls             in ' + STRING(duree_finaliser_decls,			FORMAT='(F7.2)')	+ ' sec'
	my_print, 'lint_check_commons               in ' + STRING(duree_check_commons,				FORMAT='(F7.2)')	+ ' sec'
	my_print, 'lint_pass2                       in ' + STRING(duree_pass2,					FORMAT='(F7.2)')	+ ' sec'
	my_print, 'lint_get_numbers_of_lines        in ' + STRING(duree_get_numbers_of_lines,			FORMAT='(F7.2)')	+ ' sec'
	my_print, 'lint_afficher_infos_appels       in ' + STRING(duree_afficher_infos_appels,			FORMAT='(F7.2)')	+ ' sec'
	my_print, 'lint_afficher_infos_declarations in ' + STRING(duree_afficher_infos_declarations,		FORMAT='(F7.2)')	+ ' sec'
	my_print, 'lint_ecrire_resultats_listing    in ' + STRING(duree_ecrire_resultats_listing,		FORMAT='(F7.2)')	+ ' sec'
	my_print, 'lint_ecrire_resultats_html       in ' + STRING(duree_ecrire_resultats_html,			FORMAT='(F7.2)')	+ ' sec'
	my_print, ''
	my_print, 'bigligne                         in ' + STRING(common_lint_infos.duree_bigline,		FORMAT='(F7.2)')	+ ' sec'
	my_print, 'before_SYSTEM                    in ' + STRING(common_lint_infos.duree_before_SYSTEM,	FORMAT='(F7.2)')	+ ' sec'
	my_print, 'before_USER                      in ' + STRING(common_lint_infos.duree_before_USER,		FORMAT='(F7.2)')	+ ' sec'
	my_print, 'after                            in ' + STRING(common_lint_infos.duree_after,		FORMAT='(F7.2)')	+ ' sec'
	my_print, ''
	my_print, 'LINTC_CODE_TO_HTML               in ' + STRING(common_lint_infos.duree_lintc_code_to_html,	FORMAT='(F7.2)')	+ ' sec'
	my_print, 'done                             in ' + STRING(top_fin-top_debut,				FORMAT='(F7.2)')	+ ' sec'

	PRINTF, fd_log, '</pre>'
	PRINTF, fd_log, '</html>'

	FREE_LUN, fd_log

	IF noexit EQ 0 THEN EXIT

END
