;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: line__define.pro,v $, v $Revision: 1.8 $
;
;	Date	: $Date: 2014/03/13 11:25:49 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
FUNCTION line::check
;-------------------------------------------------------------------------------
; Retourne un message d'erreur s'il y un problème avec les valeurs 'gauche', 'droite', 'hait', 'bas'.
;-------------------------------------------------------------------------------


	RETURN, self -> obj::check_gauche_droite_bas_haut()

END

;-------------------------------------------------------------------------------
PRO line::compute
;-------------------------------------------------------------------------------
; Effectue les opérations nécessaire pour visualiser l'objet.
;-------------------------------------------------------------------------------

	fenetre = self.fenetre
	general = self.general

	hash = self -> gethash()
	hash_general = general -> gethash()

	ntrace = getq (general, hash_general.ntrace)
	IF ntrace GE 1 THEN BEGIN
		msg = self -> name()
		str = STRING(msg, FORMAT='(A)')
		cl_msg, general, str_bas=" "
		cl_msg, general, str_bas=str
	END

	xsize = getq (general,hash_general.xsize)
	ysize = getq (general,hash_general.ysize)
	dx = getq (self,hash.droite) - getq (self,hash.gauche)
	dy = getq (self,hash.haut) - getq (self,hash.bas)

	nbx = xsize*dx
	nby = ysize*dy

	angle     = getq(self,hash.angle)
	linestyle = getq(self,hash.linestyle)
	thick     = getq(self,hash.thick)
	coulr     = getq(self,hash.coulr)
	coulv     = getq(self,hash.coulv)
	coulb     = getq(self,hash.coulb)

	list_linestyle = ['Solid','Dotted','Dashed','Dash Dot','Dash Dot Dot Dot','Long Dashes']
	style = (WHERE (list_linestyle EQ linestyle))[0]

	; De quelles couleurs a t-on besoin ?
	rvb = { var_pal, r:coulr, v:coulv, b:coulb } & coul   = 0

	cube = getq(self,hash.palette_cube) 
	IF cube NE 'No' AND cube NE 'True color' THEN BEGIN
		; On va quantifier les couleurs avec COLOR_QUAN et cube
		r = rvb.r & v = rvb.v & b = rvb.b
		image = INDGEN(N_ELEMENTS(rvb))
		nbcube = (STRSPLIT(cube, /EXTRACT))[0]^(1./3)
		trans = COLOR_QUAN (r[image],v[image], b[image],r,v,b,cube=nbcube)
		rvb = REPLICATE ({ var_pal, r:0, v:0, b:0 }, N_ELEMENTS(r))
		rvb.r = r & rvb.v = v & rvb.b = b
	END ELSE BEGIN
		trans = INDGEN(N_ELEMENTS(rvb))
	END

	fenetre -> fsetproperty,rvb,/rvb

	pt_haut_x = nbx/2 + nbx/2*COS(angle*!pi/180.)
	pt_haut_y = nby/2 + nby/2*SIN(angle*!pi/180.)

	pt_bas_x = nbx/2 - nbx/2*COS(angle*!pi/180.)
	pt_bas_y = nby/2 - nby/2*SIN(angle*!pi/180.)

	fenetre -> ajouter_courbe, 	$
		[pt_bas_x, pt_haut_x] , $	; tabx
		[pt_bas_y, pt_haut_y] , $	; taby
		trans[coul], 		$  	; couleur
		0, 			$	; psym1
		0, 			$	; psym2
		1., 			$	; symsize
		style,			$	; linestyle
		thick, 			$	; thick
		0., 			$	; xmin
		nbx, 			$	; xmax
		0,  			$	; xlog
		0., 			$	; ymin
		nby, 			$	; ymax
		0,  			$	; ylog
		0., 			$	; x1
		1., 			$	; x2
		0., 			$	; y1
		1., 			$	; y2
		nocourbe			; nocourbe

END

;-------------------------------------------------------------------------------
FUNCTION line::init,	$
;-------------------------------------------------------------------------------
	no,		$	; LINT_PROTOTYPE input
	container,	$	; LINT_PROTOTYPE input
	order,		$	; LINT_PROTOTYPE input
	general			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Constructeur de la classe "line".
;-------------------------------------------------------------------------------

	param = [ $
		{ var_obj, 'Data:Angle (deg)',	'angle', 	2, PTR_NEW(['FL','2','12']), 											'check_always_ok',	PTR_NEW(),	PTR_NEW(90.0)		},	$
		{ var_obj, 'Linestyle',		'linestyle',	2, PTR_NEW(['DR','2','LABEL_LEFT','Solid','Dotted','Dashed','Dash Dot','Dash Dot Dot Dot','Long Dashes']),	'check_always_ok',	PTR_NEW(),	PTR_NEW('Dashed')	},	$
		{ var_obj, 'Thick', 		'thick', 	2, PTR_NEW(['FL','2','12']), 											'check_sup',		PTR_NEW(0),	PTR_NEW(1.)		},	$
		{ var_obj, 'Color R', 		'coulr', 	2, PTR_NEW(['SL','0','150','0','255']), 									'check_always_ok',	PTR_NEW(),	PTR_NEW(0)		},	$
		{ var_obj, 'G', 		'coulv', 	2, PTR_NEW(['SL','0','150','0','255']), 									'check_always_ok',	PTR_NEW(),	PTR_NEW(0)		},	$
		{ var_obj, 'B', 		'coulb', 	2, PTR_NEW(['SL','2','150','0','255']), 									'check_always_ok',	PTR_NEW(),	PTR_NEW(0)		} 	$
	]

	code = self -> obj::init (no, container, order, param, general=general,$
		/saisissable, graphique=1,palette=3,/shortpalette,/nonbcolors)

	set, self, 'nbmincolors', 1
	set, self, 'nbmaxcolors', 1
	set, self, 'noparam', 2

	RETURN, code

END


;-------------------------------------------------------------------------------
PRO line__define
;-------------------------------------------------------------------------------
; La classe "linee" hérite de "obj".
;-------------------------------------------------------------------------------

	lint_unused = { line, 		$

		INHERITS obj 		$

	}

END
