;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: libxml.pro,v $, v $Revision: 1.30 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
FUNCTION chercher_noeud_xml,	$
;-------------------------------------------------------------------------------
	dataxml,	$	; LINT_PROTOTYPE input
	noeud,		$	; LINT_PROTOTYPE input
	no=no			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((-)) Retourne la nime partie de dataxml entre <noeud> et </noeud> (pour xml_to_noeud_variable_valeur).
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(no) EQ 0 THEN no = 0

	ind1 = WHERE (dataxml.noeud EQ noeud)
	ind2 = WHERE (dataxml.noeud EQ '/'+noeud)

	IF ind1[0] EQ -1 OR ind2[0] EQ -1 THEN RETURN, [-1,-1]

	IF no GE N_ELEMENTS(ind1) THEN RETURN, -1

	debut = ind1[no]
	fin = ind2[no]

	nb = fin-debut

	RETURN, debut+LINDGEN(nb)

END

;-------------------------------------------------------------------------------
FUNCTION chercher_noeuds_xml,	$
;-------------------------------------------------------------------------------
	dataxml,	$	; LINT_PROTOTYPE input
	noeuds,		$	; LINT_PROTOTYPE input
	no=no			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((-)) Retourne la nime partie de dataxml contenant une slection de noeuds (pour xml_to_noeud_variable_valeur).
;-------------------------------------------------------------------------------

	nb = N_ELEMENTS(noeuds)

	tmpxml = dataxml
	FOR i=0L,nb-1 DO BEGIN
		tmp = chercher_noeud_xml (tmpxml,noeuds[i],no=no)
		IF tmp[0] EQ -1 THEN RETURN, { noeud: "" }
		tmpxml = tmpxml[tmp]
	END

	RETURN, tmpxml

END
	

;-------------------------------------------------------------------------------
FUNCTION xml_to_noeud_variable_valeur,	$
;-------------------------------------------------------------------------------
	nom,		$	; LINT_PROTOTYPE input
	dataxml,	$	; LINT_PROTOTYPE output
	nexit=nexit		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((1:ok 0:pb)) Lit un fichier XML en C et retourne un tableau de structure avec les donnes avec { noeud, variable, valeur }
;
; nexit=nexit: pour sortir ds que l'on trouve le noeud nexit (ex: "TABLEDATA" pour les XML)
;
; Lit nom et cre dataxml
; Retourne 1 si OK, 0 si PB
;-------------------------------------------------------------------------------

	ON_IOERROR, erreur

	IF N_ELEMENTS(nexit) EQ 0 THEN nexit = ""

	; 0.03 sec
	OPENR, fd, nom, /GET_LUN, compress=STRMID(nom,STRLEN(nom)-3,3) EQ '.gz'
	stat = FSTAT(fd)
	size = stat.size

	IF size NE 0 THEN BEGIN
		data = REPLICATE(0b,size)
		READU,fd,data
	END
	FREE_LUN, fd
	IF size EQ 0 THEN RETURN, 0

	data = [data,0b]

	; 0.00001 sec
	s 			= { noeud: '', variable: '', valeur: '' }

	; 0.33 sec
	IF is_fdl() THEN BEGIN
		nb = CALL_EXTERNAL (libname('libxml'), 'WC_L_AUTO_GLUE', data, /AUTO_GLUE)
	END ELSE BEGIN
		nb = CALL_EXTERNAL (libname('libxml'), 'WC_L',           data)
	END
	IF nb EQ 0 THEN RETURN, 0

	; 0.18 sec
	dataxml 		= REPLICATE (s,nb)

	; 0.03 sec
	; Le tableau data a t modifi par 'wc_l' donc il faut le re-crer
	OPENR, fd, nom, /GET_LUN, compress=STRMID(nom,STRLEN(nom)-3,3) EQ '.gz'
	stat = FSTAT(fd)
	size = stat.size
	data = REPLICATE(0b,size)
	READU,fd,data
	FREE_LUN, fd
	data = [data,0b]

	; 0.75 sec
	IF is_fdl() THEN BEGIN
		NAMES = TAG_NAMES(dataxml)
		FOR i=0L,N_ELEMENTS(NAMES)-1 DO BEGIN
			IF is_string(dataxml[0].(i)) THEN BEGIN
				dataxml.(i) = STRING(REPLICATE(BYTE('A'),1024)) ; rserver 1024 bytes pour les STRING
			END
		END
		lint_unused = CALL_EXTERNAL (libname('libxml'), 'LIRE_AUTO_GLUE', data, dataxml, nexit, 1L, /AUTO_GLUE)
		FOR i=0L,N_ELEMENTS(NAMES)-1 DO BEGIN
			IF is_string(dataxml[0].(i)) THEN BEGIN
				pos = STRPOS (dataxml.(i), STRING(255b))
				dataxml.(i) = STRMID (dataxml.(i), 0, pos) ; garder ce qu'il y a avant le caractre spcial 255
			END
		END
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('libxml'), 'LIRE',           data, dataxml, nexit, 0L)
	END

	IF nexit NE '' THEN BEGIN
		ind = WHERE (dataxml.noeud NE '',nb)
		IF nb EQ 0 THEN RETURN, 0
		dataxml = dataxml[ind]
	END

	RETURN, 1

;	; Estimation du nombre max de tags: 0.08 sec
;	ind = WHERE (data EQ 60 OR data EQ 61, nbmax) ; 60 pour '<' et 61 pour '='
;	nbmax *= 2
;
;	; 0.24 sec
;	noeud 		= REPLICATE ('',nbmax)
;	variable	= REPLICATE ('',nbmax)
;	valeur 		= REPLICATE ('',nbmax)
;
;	; 0.76 sec
;	nb = 0L
;	dataxml = 0L
;	lint_unused = CALL_EXTERNAL (libname('libxml'),'LIRE', data, noeud, variable, valeur, dataxml, nb)
;
;	; 0.06 sec
;	ind = WHERE (noeud NE '',nb)
;	IF nb EQ 0 THEN RETURN, 0
;
;	; 0.2 sec
;	dataxml 		= REPLICATE (s,nb)
;
;	; 0.67 sec
;	dataxml.noeud 		= noeud[ind]
;
;	; 0.24 sec
;	dataxml.variable	= variable[ind]
;
;	; 0.37 sec
;	dataxml.valeur 		= valeur[ind]
;
;	;xml = OBJ_NEW('IDLffXMLDOMDocument')
;	;xml->Load, FILENAME=nom, SCHEMA_CHECKING=0
;
;	RETURN, 1

erreur:
	RETURN, 0

END

;-------------------------------------------------------------------------------
FUNCTION ligne_to_noeud_variable_valeur,	$
;-------------------------------------------------------------------------------
	ligne,		$	; LINT_PROTOTYPE input
	dataxml			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; ((1:ok 0:pb)) A partir d'une ligne retourne un tableau de structure avec les donnes avec { noeud, variable, valeur }
;-------------------------------------------------------------------------------

	s = { noeud: '', variable: '', valeur: '' }
	IF is_fdl() THEN BEGIN
		nb = CALL_EXTERNAL (libname('libxml'), 'WC_L_AUTO_GLUE', [BYTE(ligne),0b], /AUTO_GLUE)
	END ELSE BEGIN
		nb = CALL_EXTERNAL (libname('libxml'), 'WC_L',           [BYTE(ligne),0b])
	END
	dataxml = REPLICATE (s,nb)
	; ex: GET_ARBRES_CL
	IF is_fdl() THEN BEGIN
		NAMES = TAG_NAMES(dataxml)
		FOR i=0L,N_ELEMENTS(NAMES)-1 DO BEGIN
			IF is_string(dataxml[0].(i)) THEN BEGIN
				dataxml.(i) = STRING(REPLICATE(BYTE('A'),1024)) ; rserver 1024 bytes pour les STRING
			END
		END
		lint_unused = CALL_EXTERNAL (libname('libxml'), 'LIRE_AUTO_GLUE', [BYTE(ligne),0b], dataxml, '', 1L, /AUTO_GLUE)
		FOR i=0L,N_ELEMENTS(NAMES)-1 DO BEGIN
			IF is_string(dataxml[0].(i)) THEN BEGIN
				pos = STRPOS (dataxml.(i), STRING(255b))
				dataxml.(i) = STRMID (dataxml.(i), 0, pos) ; garder ce qu'il y a avant le caractre spcial 255
			END
		END
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('libxml'), 'LIRE',           [BYTE(ligne),0b], dataxml, '', 0L)
	END

	IF dataxml[0].noeud NE '' THEN BEGIN
		dataxml = dataxml[WHERE (dataxml.noeud NE '')]
		RETURN, 1
	END ELSE BEGIN
		RETURN, 0
	END

END

;-------------------------------------------------------------------------------
PRO xml_affecter_valeur,	$
;-------------------------------------------------------------------------------
	TAGS,	$	; LINT_PROTOTYPE input
	VALS,	$	; LINT_PROTOTYPE input
	NBVALS,	$	; LINT_PROTOTYPE input
	valeur		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((-)) Rajoute une valeur  VALS et incrment NBVALS (pour xml_to_vals).
;
; Entres:
;	TAGS: tableau de TAG
;
; Sorties
;	VALS
;	NBVALS
;-------------------------------------------------------------------------------

	IF STRCOMPRESS(valeur,/remove_all) EQ '' THEN RETURN ; inutile de n'affecter que des blancs

	no = 0
	FOR i=0L,N_ELEMENTS(TAGS)-1 DO BEGIN
		IF STRMID(TAGS[i],0,5) EQ '<?xml' THEN CONTINUE
		VALS[NBVALS].(no) = TAGS[i]
		no++
	END

	VALS[NBVALS].V = valeur
	NBVALS++

	IF NBVALS EQ N_ELEMENTS(VALS) THEN BEGIN
		; augmenter la dimension de VALS
		NEWVALS = REPLICATE (VALS[0], 2*N_ELEMENTS(VALS))
		NEWVALS[0:NBVALS-1] = VALS
		VALS = NEWVALS
	END
END


;-------------------------------------------------------------------------------
FUNCTION xml_to_vals,	$
;-------------------------------------------------------------------------------
	nom,	$	; LINT_PROTOTYPE input
	VALS		; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; ((1:ok 0:pb)) Lit un fichier XML et retourne un tableau de structure avec {T1,T2,T3,T4,T5,T6,T7,T8,T9,V}
;
; Lit nom et cre VALS
;
; Retourne:
;	1 si OK
;	0 si PB
;
; Limitations:
;	- 9 niveaux de tag maxi
;-------------------------------------------------------------------------------

	ON_IOERROR, erreur

	fd = -1
	TAGS = ''
	VALS = REPLICATE({ T1:'', T2:'', T3:'', T4:'', T5:'', T6:'', T7:'', T8:'', T9:'', V:'' },10000) ; 10000 pour commencer, sera augment automatiquement si ncessaire
	NBVALS = 0L
	ligne = ''

	OPENR,fd,nom,/GET_LUN,compress=STRMID(nom,STRLEN(nom)-3,3) EQ '.gz'
	WHILE ~EOF(fd) DO BEGIN
		READF, fd, ligne
		no = 0L
		len = STRLEN(ligne)
		WHILE no LT len DO BEGIN
			no1 = STRPOS(ligne,"<",no)
			IF no1 EQ -1 THEN BEGIN
				; ligne sans "<"
				xml_affecter_valeur, TAGS, VALS, NBVALS, ligne
				BREAK
			END

			no2 = STRPOS(ligne,">",no1)
			IF no2 EQ -1 THEN BEGIN
				; ligne sans ">"
				xml_affecter_valeur, TAGS, VALS, NBVALS, ligne
				BREAK
			END

			IF STRMID(ligne,no1+1,1) EQ '/' THEN BEGIN

				; On a trouve "</" en position no1
				xml_affecter_valeur, TAGS, VALS, NBVALS, STRMID(ligne,no,no1-no)

				; On supprime le dernier element de TAGS
				TAGS = TAGS[0:N_ELEMENTS(TAGS)-2]

			END ELSE BEGIN

				; TAG: ce qui est entre "<" et ">"
				TAG = STRMID(ligne,no1,no2-no1+1)

				; TAGS: tableau de TAG
				TAGS = TAGS[0] EQ '' ? TAG : [TAGS,TAG]

			END
			no = no2 + 1
		END
	END
	FREE_LUN, fd

	IF NBVALS EQ 0 THEN RETURN, 0
	VALS = VALS[0:NBVALS-1]
	RETURN, 1

erreur:
	IF fd NE -1 THEN FREE_LUN, fd
	RETURN, 0

END


;-------------------------------------------------------------------------------
FUNCTION xml_to_timetable,	$
;-------------------------------------------------------------------------------
	nom,				$	; LINT_PROTOTYPE input
	votable_description,		$	; LINT_PROTOTYPE output
	votable_resource_description,	$	; LINT_PROTOTYPE output
	tab_time_t1,			$	; LINT_PROTOTYPE output
	tab_time_t2				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; ((1:ok 0:pb)) Lit une timetable dans un fichier XML.
;
; Entres:
;	nom: fichier xml  lire
;
; Sorties:
;	votable_description:		tableau de chaines de carcatres
;	votable_resource_description:	tableau de chaine de caractres
;	tab_time_t1:			tableau de chaine de caractres
;	tab_time_t2:			tableau de chaine de caractres
;
;
; Retourne:
;	1 si OK
;	0 si PB
;-------------------------------------------------------------------------------

	votable_description		= ''
	votable_resource_description	= ''
	tab_time_t1			= ''
	tab_time_t2			= ''

	; ---------------------------------------------------------
	; Nouvelle mthode qui utilise xml_to_noeud_variable_valeur
	; ---------------------------------------------------------

	code = xml_to_noeud_variable_valeur (nom, dataxml)
	IF code EQ 0 THEN RETURN, code

	ind = WHERE (dataxml.noeud EQ 'TD',nbTD)
	IF ind[0] NE -1 THEN BEGIN
		; Je fais l'hypothse que le temps dbut est le premier champ, que le temps fin est le second champ
		tab_time_t1 = dataxml[ind[0+2*LINDGEN(nbTD/2)]].valeur
		tab_time_t2 = dataxml[ind[1+2*LINDGEN(nbTD/2)]].valeur
	END
	tmpxml = chercher_noeuds_xml (dataxml,['VOTABLE','DESCRIPTION'])
	IF tmpxml[0].noeud NE "" THEN BEGIN
		votable_description = tmpxml[0].valeur
		PRINT,'*** votable_description *** ',votable_description
	END     

	tmpxml = chercher_noeuds_xml (dataxml,['VOTABLE','RESOURCE','DESCRIPTION'])
	IF tmpxml[0].noeud NE "" THEN BEGIN
		votable_resource_description = tmpxml[0].valeur
		PRINT,'*** votable_resource_description *** ',votable_resource_description
	END

	RETURN, code


;	----------------------------------------
;	Ancienne mthode qui utilise xml_to_vals
;	----------------------------------------
;
;	code = xml_to_vals(nom, VALS)
;	IF code EQ 0 THEN RETURN, code
;
;	ind = WHERE (STRMID(VALS.t1,0,8) EQ '<VOTABLE' AND VALS.t2 EQ '<DESCRIPTION>')
;	IF ind[0] NE -1 THEN votable_description = VALS[ind].V
;
;	ind = WHERE (STRMID(VALS.t1,0,8) EQ '<VOTABLE' AND VALS.t2 EQ '<RESOURCE>' AND VALS.t3 EQ '<DESCRIPTION>')
;	IF ind[0] NE -1 THEN votable_resource_description = VALS[ind].V
;
;	; Combien y a t-il de champs dans la table ?
;	ind = WHERE (STRMID(VALS.t1,0,8) EQ '<VOTABLE' AND VALS.t2 EQ '<RESOURCE>' AND VALS.t3 EQ '<TABLE>' AND STRMID(VALS.t4,0,6) EQ '<FIELD', nbchamps)
;	IF nbchamps LT 2 THEN RETURN, 0
;
;	ind = WHERE (STRMID(VALS.t1,0,8) EQ '<VOTABLE' AND VALS.t2 EQ '<RESOURCE>' AND VALS.t3 EQ '<TABLE>' AND VALS.t4 EQ '<DATA>' AND VALS.t5 EQ '<TABLEDATA>' AND VALS.t6 EQ '<TR>' AND VALS.t7 EQ '<TD>')
;	IF ind[0] NE -1 THEN BEGIN
;		; Je fais l'hypothse que le temps dbut est le premier champ, que le temps fin est le second champ
;		tab_time_t1 = VALS[ind[0+nbchamps*LINDGEN(N_ELEMENTS(ind)/nbchamps)]].V
;		tab_time_t2 = VALS[ind[1+nbchamps*LINDGEN(N_ELEMENTS(ind)/nbchamps)]].V
;	END
;
;	RETURN, code

END


;-------------------------------------------------------------------------------
FUNCTION time_table_to_xml,	$
;-------------------------------------------------------------------------------
	nom,				$	; LINT_PROTOTYPE input
	votable_description,		$	; LINT_PROTOTYPE input
	votable_resource_description,	$	; LINT_PROTOTYPE input
	tab_time_t1,			$	; LINT_PROTOTYPE input
	tab_time_t2				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((1:ok 0:pb)) Ecrit une timetable dans un fichier XML.
;
; Entres:
;	nom:				nom du fichier xml  crer
;	votable_description:		tableau de chaines de carcatres
;	votable_resource_description:	tableau de chaine de caractres
;	tab_time_t1:			tableau de chaine de caractres
;	tab_time_t2:			tableau de chaine de caractres
;	
; Retourne:
;	1 si OK
;	0 si PB
;-------------------------------------------------------------------------------

	ON_IOERROR, erreur

	fd = -1
	OPENW,fd,nom,/GET_LUN

	; Ancienne version (Elena)
	;PRINTF, fd, '<?xml version="1.0" encoding="UTF-8"?>'
	;PRINTF, fd, '<VOTABLE version="1.1" xmlns="http://www.ivoa.net/xml/VOTable/v1.1" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.ivoa.net/xml/VOTable/v1.1 C:\DOCUME~1\MICHEL~1\MESDOC~1\VOTable1-1.xsd">'

	; Nouvelle version (Alain Barthe): le parser XML d'IDL trouve une erreur
	;PRINTF, fd, '<?xml version="1.0"?>'
	;PRINTF, fd, '<VOTABLE version="1.1" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="http://www.ivoa.net/xml/VOTable/v1.1">'

	; Nouvelle version
	PRINTF, fd, '<?xml version="1.0" encoding="UTF-8"?>'
	PRINTF, fd, '<VOTABLE version="1.1" xmlns="http://www.ivoa.net/xml/VOTable/v1.1" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">'

	PRINTF, fd, '<DESCRIPTION>'
	FOR i=0L,N_ELEMENTS(votable_description)-1 DO BEGIN
		PRINTF, fd, votable_description[i]
	END
	PRINTF, fd, '</DESCRIPTION>'

	PRINTF, fd, '<RESOURCE>'
	PRINTF, fd, '<DESCRIPTION>'
	FOR i=0L,N_ELEMENTS(votable_resource_description)-1 DO BEGIN
		PRINTF, fd, votable_resource_description[i]
	END
	PRINTF, fd, '</DESCRIPTION>'

	PRINTF, fd, '<TABLE>'
	PRINTF, fd, '<FIELD datatype="char" name="Start Time" ID="TimeIntervalStart" ucd="time.start">'
	PRINTF, fd, '<DESCRIPTION>time tag for beginning of interval</DESCRIPTION>'
	PRINTF, fd, '</FIELD>'
	PRINTF, fd, '<FIELD datatype="char" name="Stop Time" ID="TimeIntervalStop" ucd="time.stop">'
	PRINTF, fd, '<DESCRIPTION>time tag for end of interval</DESCRIPTION>'
	PRINTF, fd, '</FIELD>'

	PRINTF, fd, '<DATA>'
	PRINTF, fd, '<TABLEDATA>'
	FOR i=0L,N_ELEMENTS(tab_time_t1)-1 DO BEGIN
		PRINTF, fd, '<TR>'
		PRINTF, fd, '<TD>'+tab_time_t1[i]+'</TD>'
		PRINTF, fd, '<TD>'+tab_time_t2[i]+'</TD>'
		PRINTF, fd, '</TR>'
	END
	PRINTF, fd, '</TABLEDATA>'
	PRINTF, fd, '</DATA>'
	PRINTF, fd, '</TABLE>'
	PRINTF, fd, '</RESOURCE>'
	PRINTF, fd, '</VOTABLE>'

	FREE_LUN, fd
	RETURN, 1

erreur:
	IF fd NE -1 THEN FREE_LUN, fd
	RETURN, 0

END

;-------------------------------------------------------------------------------
FUNCTION read_votable_get_symbols,	$
;-------------------------------------------------------------------------------
	FILENAME,			$	; LINT_PROTOTYPE input
	SYMBOLS,			$	; LINT_PROTOTYPE output
	FORMAT,				$	; LINT_PROTOTYPE output
	NBRECORDS,			$	; LINT_PROTOTYPE output
	NBLINES0,			$	; LINT_PROTOTYPE output
	DESCRIPTION,			$	; LINT_PROTOTYPE [output]
	nonb=nonb				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((1:ok 0:pb)) Lit un fichier XML et retourne les symboles trouvs.
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(nonb)             EQ 0 THEN nonb          = 0

	nexit = nonb ? '/TR' : ''

	code = xml_to_noeud_variable_valeur (FILENAME,dataxml,nexit=nexit)
	IF ~code THEN RETURN, 0

        symbol0 = {     $
                name:           '',     $
                exception:      0,      $

                value_type:     '',     $
                var_type:       '',     $
                property:       '',     $
                sizes:          '',     $
                data:           '',     $
                delta_plus:     '',     $
                delta_minus:    '',     $
                fillval:        '',     $
                units:          '',     $
                fieldnam:       '',     $
                si_conversion:  '',     $
                depend_0:       '',     $
                depend_1:       '',     $
                depend_2:       '',     $
                depend_3:       '',     $
                depend_4:       '',     $
                labl_ptr_1:     '',     $
                labl_ptr_2:     ''      $
        }
        SYMBOLS = [ symbol0 ]

	ind = WHERE (dataxml.noeud EQ 'DESCRIPTION')
	DESCRIPTION = ind[0] EQ -1 ? '' : htmlspecialchars_decode(dataxml[ind[0]].valeur)

	TAGS = [ 'PARAM', 'FIELD' ]

	FOR itag=0L, N_ELEMENTS(TAGS)-1 DO BEGIN
		fin   = WHERE(dataxml.noeud EQ '/'+TAGS[itag], nbchamps)
		FOR i=0L,nbchamps-1 DO BEGIN

			; dterminer debut
			debut = fin[i]
			FOR j=fin[i]-1,0,-1 DO BEGIN
				IF dataxml[j].noeud EQ 'DESCRIPTION' OR dataxml[j].noeud EQ '/DESCRIPTION' THEN BEGIN
				END ELSE IF dataxml[j].noeud EQ 'VALUES' OR dataxml[j].noeud EQ '/VALUES' THEN BEGIN
				END ELSE IF dataxml[j].noeud EQ TAGS[itag] THEN BEGIN
					debut = j
				END ELSE BEGIN
					BREAK
				END
			END

			symbol = symbol0
			data = dataxml[debut:fin[i]]

			; name
			tmp = (WHERE (data.variable EQ 'name'))[0]
			IF tmp NE -1 THEN BEGIN
				symbol.name = htmlspecialchars_decode(data[tmp].valeur)
			END

			; units
			tmp = (WHERE (data.variable EQ 'unit'))[0]
			IF tmp NE -1 THEN BEGIN
				symbol.units = htmlspecialchars_decode(data[tmp].valeur)
			END

			; value_type
			value_type = 'FLOAT'
			tmp = (WHERE (data.variable EQ 'datatype'))[0]
			IF tmp NE -1 THEN BEGIN
				IF data[tmp].valeur EQ 'char' THEN BEGIN
					value_type = 'CHAR'
				END
			END
			tmp = (WHERE (data.variable EQ 'ucd'))[0]
			IF tmp NE -1 THEN BEGIN
				IF STRMID(data[tmp].valeur,0,4) EQ 'time' THEN BEGIN
					value_type = 'ISO_TIME'
				END
			END
			symbol.value_type = value_type

			; fieldnam
			tmp = (WHERE (data.noeud EQ 'DESCRIPTION'))[0]
			IF tmp NE -1 THEN BEGIN
				symbol.fieldnam = htmlspecialchars_decode(data[tmp].valeur)
			END

			; fillval
			tmp = (WHERE (data.noeud EQ 'VALUES'))[0]
			IF tmp NE -1 THEN BEGIN
				symbol.fillval = htmlspecialchars_decode(data[tmp].valeur)
			END

			; sizes
			tmp = (WHERE (data.variable EQ 'arraysize'))[0]
			sizes = '1'
			IF tmp NE -1 THEN BEGIN
				IF data[tmp].valeur NE '*' THEN BEGIN
					sizes = htmlspecialchars_decode(data[tmp].valeur)
					remplacer, sizes, 'x', ','
				END
			END
			symbol.sizes = sizes

			IF TAGS[itag] EQ 'PARAM' THEN BEGIN

				; data
				tmp = (WHERE (data.variable EQ 'value'))[0]
				IF tmp NE -1 THEN BEGIN
					symbol.data = STRJOIN(STRSPLIT(htmlspecialchars_decode(data[tmp].valeur),/EXTRACT),',')
				END

			END ELSE IF TAGS[itag] EQ 'FIELD' THEN BEGIN

				; labl_ptr_1
				tmp = (WHERE (SYMBOLS.name EQ 'components_'+symbol.name))[0]
				IF tmp NE -1 THEN BEGIN
					IF symbol.sizes NE '1' THEN BEGIN ; car par exemple ref="UTC" pour epoch
						symbol.labl_ptr_1 = SYMBOLS[tmp].data
					END
				END ELSE BEGIN
					; depend_1
					tmp = (WHERE (data.variable EQ 'ref'))[0]
					IF tmp NE -1 THEN BEGIN
						IF symbol.sizes NE '1' THEN BEGIN ; car par exemple ref="UTC" pour epoch
							symbol.depend_1 = htmlspecialchars_decode(data[tmp].valeur)
						END
					END
				END

				; depend_0
				IF SYMBOLS[0].value_type EQ 'ISO_TIME' AND i NE 0 THEN symbol.DEPEND_0 = SYMBOLS[0].name

				; depend_[1234]
				IF symbol.sizes NE '1' AND symbol.labl_ptr_1 EQ '' THEN BEGIN
					DIMS = LONG(string_to_data(symbol.sizes))
					NBDIMS = N_ELEMENTS(DIMS)
					FOR j=1L,NBDIMS DO BEGIN
						IF symbol.name EQ 'energy_table' THEN CONTINUE
						IF symbol.name EQ 'delta_plus_energy_table' THEN CONTINUE
						IF symbol.name EQ 'delta_minus_energy_table' THEN CONTINUE
						IF j EQ 1 AND symbol.DEPEND_1 EQ '' THEN symbol.DEPEND_1 = 'DEPEND_1_'+symbol.name
						IF j EQ 2 THEN symbol.DEPEND_2 = 'DEPEND_2_'+symbol.name
						IF j EQ 3 THEN symbol.DEPEND_3 = 'DEPEND_3_'+symbol.name
						IF j EQ 4 THEN symbol.DEPEND_4 = 'DEPEND_4_'+symbol.name
					END
				END

			END

			IF symbol[0].name NE '' THEN BEGIN ; arrive avec certains fichiers retourns par AMDA
				SYMBOLS = SYMBOLS[0].name EQ '' ? [symbol] : [SYMBOLS,symbol]
			END

		END

	END

	IF nonb EQ 0 THEN BEGIN
		lint_unused = WHERE (dataxml.noeud EQ 'TR', NBRECORDS)
	END


	; premire ligne de donnes: entre le premier <TR> et le premier </TR>  pour en dduire le format du temps
	debut = (WHERE(dataxml.noeud EQ 'TR'))[0]
	fin   = (WHERE(dataxml.noeud EQ '/TR'))[0]
	IF fin EQ -1 THEN fin = N_ELEMENTS(dataxml)-1

	; quel est le premier champ en 'ISO_TIME' (ne pas compter les champs avec DATA) ?
	no_premier_ISO_TIME = (WHERE (SYMBOLS.VALUE_TYPE EQ 'ISO_TIME'))[0]

	; patch temporaire pour les fichiers SINP qui n'ont pas de ucd dans le champ 'time'
	;IF no_premier_ISO_TIME EQ -1 THEN BEGIN
	;	no_premier_ISO_TIME = (WHERE (SYMBOLS.name EQ 'time'))[0]
	;	SYMBOLS[no_premier_ISO_TIME].value_type = 'ISO_TIME'
	;END

	
	; nombre de champs avec DATA non vides
	lint_unused = WHERE(SYMBOLS.DATA NE '', nb_champs_data)

	IF no_premier_ISO_TIME NE -1 AND debut NE -1 THEN BEGIN
		no_premier_ISO_TIME -= nb_champs_data
		
		; quel est la valeur du premier champ 'ISO_TIME'
		tmp = (WHERE(dataxml[debut:fin].noeud EQ 'TD'))[no_premier_ISO_TIME]
		valeur_premier_champ_ISO_TIME = dataxml[debut+tmp].valeur
		FORMAT = get_date_format (valeur_premier_champ_ISO_TIME)

	END ELSE BEGIN

		; il faut renvoyer une valeur
		; 'TTTT-MM-DDTHH:MM:SS.MSCZ'
		FORMAT = 3

	END
	
	NBLINES0 = 0L

	corriger_symbols, symbol0, SYMBOLS, modif

	IF SYMBOLS[0].name EQ '' THEN RETURN, 0

	; Patch pour IMPEX pour garder les paramtres de la simulation dans le champ FIELDNAM de chaque paramtre
	IF DESCRIPTION NE '' THEN BEGIN
		; Supprimer les STRING(10b) en dbut et en fin
		IF STRMID(DESCRIPTION,0,1) EQ STRING(10b) THEN DESCRIPTION = STRMID(DESCRIPTION,1)
		IF STRMID(DESCRIPTION,STRLEN(DESCRIPTION)-1,1) EQ STRING(10b) THEN DESCRIPTION = STRMID(DESCRIPTION,0,STRLEN(DESCRIPTION)-2)
		remplacer, DESCRIPTION, STRING(10b), '!C'
		FOR i=0L,N_ELEMENTS(SYMBOLS)-1 DO BEGIN
			SYMBOLS[i].FIELDNAM = SYMBOLS[i].FIELDNAM EQ '' ? DESCRIPTION : (DESCRIPTION + '!C!C' + SYMBOLS[i].FIELDNAM)
		END
	END

	RETURN, 1

END

;-------------------------------------------------------------------------------
FUNCTION read_votable_get_data,	$
;-------------------------------------------------------------------------------
	FILENAME,					$	; LINT_PROTOTYPE input
	FORMAT,						$	; LINT_PROTOTYPE input
	NBRECORDS,					$	; LINT_PROTOTYPE input
	NBLINES0,					$	; LINT_PROTOTYPE input
	STRUCT,						$	; LINT_PROTOTYPE input
	INFO,						$	; LINT_PROTOTYPE input
	DATA,						$	; LINT_PROTOTYPE output
	rec_start=rec_start,				$	; LINT_PROTOTYPE input
	rec_count=rec_count,				$	; LINT_PROTOTYPE input
	modify_float_fillval=modify_float_fillval,	$	; LINT_PROTOTYPE input
	nomalloc=nomalloc,				$	; LINT_PROTOTYPE input
	quiet=quiet						; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((1:ok 0:pb)) Lit les donnes d'un fichier XML dja analys et retourne un tableau de structure avec les donnes.
;-------------------------------------------------------------------------------

        IF N_ELEMENTS(rec_start)                EQ 0 THEN rec_start             = 0L
        IF N_ELEMENTS(rec_count)                EQ 0 THEN rec_count             = NBRECORDS-rec_start
        IF N_ELEMENTS(modify_float_fillval)     EQ 0 THEN modify_float_fillval  = 0
        IF N_ELEMENTS(nomalloc)                 EQ 0 THEN nomalloc              = 0
        IF N_ELEMENTS(quiet)                    EQ 0 THEN quiet                 = 0

	IF rec_count EQ 0 THEN RETURN, 0
	IF ~nomalloc THEN DATA = REPLICATE (STRUCT,rec_count)
	code = read_ascii_get_data (FILENAME, FORMAT, NBRECORDS, NBLINES0, STRUCT, INFO, DATA, $
					rec_start=rec_start, rec_count=rec_count, /modify_float_fillval, /nomalloc, quiet=quiet, /votable)
	RETURN, code

END


;-------------------------------------------------------------------------------
FUNCTION read_votable,			$
;-------------------------------------------------------------------------------
        FILENAME,			$	; LINT_PROTOTYPE input
        DATA,				$	; LINT_PROTOTYPE output
        VARNAMES,			$	; LINT_PROTOTYPE [output]
        NAMES,				$	; LINT_PROTOTYPE [output]
	DESCRIPTION,			$	; LINT_PROTOTYPE [output]
        quiet=quiet,			$	; LINT_PROTOTYPE input
        selection_date=selection_date,	$	; LINT_PROTOTYPE input
        selection_data=selection_data,	$	; LINT_PROTOTYPE input
        selection_type=selection_type		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((1:ok 0:pb)) Lit le fichier VOTABLE donn en argument et retourne les donnes dans un tableau de structure.
;
; Input:
; -----
; - FILENAME:                   filename to read
;
; Keywords:
; ---------
; - /quiet:                     no messages
;
; Output:
; -------
; - ATT:                        array of structure { v1:'', v2:'', v3:'', v4:''} with all attributes found in header
; - NOVARY:                     structure with variables containing a non empty DATA field
; - VARNAMES:                   names of variables with empty DATA field
; - NAMES:                      names of fields in the structure
; - DATA:                       array of STRUCT with data read in FILENAME
;                               'ISO_TIME' and 'ISO_TIME_RANGE' variables are stored as number of millsecondes since 01/01/1958 00:00:00.000 in a double
;                               use date_to_tu to convert these fields to year, month, day, hour, minute, seconde
;
; Return code:
; ------------
;       1 = OK
;       0 = PB
;                               'ERROR: INCORRECT FORMAT IN ' + FILENAME
;-------------------------------------------------------------------------------

        IF N_ELEMENTS(quiet)		EQ 0 THEN quiet = 0
        IF N_ELEMENTS(selection_date)	EQ 0 THEN selection_date = 'Automatic'
        IF N_ELEMENTS(selection_data)	EQ 0 THEN selection_data = 'Automatic'
        IF N_ELEMENTS(selection_type)	EQ 0 THEN selection_type = 'count3d'

	code = read_votable_get_symbols (FILENAME, SYMBOLS, FORMAT, NBRECORDS, NBLINES0, DESCRIPTION)
        IF ~code THEN RETURN, 0


        code = read_ascii_analyse_symbols (SYMBOLS, VARNAMES, REALVARNAMES, TYPES, SIZES, FILLVALS, UNITS, NAME_TIME, NAME_THETA, UNIT_THETA, NAME_PHI, UNIT_PHI, NAME_ENERGY, UNIT_ENERGY)
        IF ~code THEN RETURN, 0

        code = read_ascii_get_structure (VARNAMES, REALVARNAMES, TYPES, SIZES, FILLVALS, NAMES, STRUCT, INFO, quiet=quiet)
        IF ~code THEN RETURN, 0

        IF ~quiet THEN BEGIN
        	nbalire = NBRECORDS
	        taille = get_structure_length (STRUCT)
                msg = basename(FILENAME)+' Reading ' + val_to_str(nbalire)+' lines ('+val_to_str_2decimales(DOUBLE(nbalire)*taille/1e6)+' Mbytes)'
                PRINT, msg
        END

        code = read_votable_get_data (FILENAME, FORMAT, NBRECORDS, NBLINES0, STRUCT, INFO, DATA, /modify_float_fillval, quiet=quiet)
        RETURN, code

END

;-------------------------------------------------------------------------------
;FUNCTION resize_votable,		$
;-------------------------------------------------------------------------------
;        filename1,			$	; LINT_PROTOTYPE input
;        filename2,			$	; LINT_PROTOTYPE input
;        yyyy,				$	; LINT_PROTOTYPE input
;        mm,				$	; LINT_PROTOTYPE input
;        dd					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Lit le fichier votable filename1 et cr le fichier votable filename2 avec uniquement les donnes pour le jour (yyyy,mm,dd).
;-------------------------------------------------------------------------------
;
; todo ?
;
;END
