;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: libplot.pro,v $, v $Revision: 1.1 $
;
;	Date	: $Date: 2021/07/01 12:57:40 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
FUNCTION libplot_convert_coord,	$
;-------------------------------------------------------------------------------
	x,			$	; LINT_PROTOTYPE input
	y,			$	; LINT_PROTOTYPE input
	norm=norm,		$	; LINT_PROTOTYPE input
	data=data,		$	; LINT_PROTOTYPE input
	dev=dev,		$	; LINT_PROTOTYPE input
	to_norm=to_norm,	$	; LINT_PROTOTYPE input
	to_dev=to_dev			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de CONVERT_COORD
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_convert_coord'

	IF N_ELEMENTS(norm) EQ 0 THEN norm = 0
	IF N_ELEMENTS(data) EQ 0 THEN data = 0
	IF N_ELEMENTS(dev) EQ 0 THEN dev = 0
	IF N_ELEMENTS(to_dev) EQ 0 THEN to_dev = 0
	IF N_ELEMENTS(to_norm) EQ 0 THEN to_norm = 0

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		x_in = DOUBLE(REFORM(x))
		y_in = DOUBLE(REFORM(y))

		IF norm EQ 1 AND to_dev EQ 1 THEN BEGIN
			; /norm	=> /to_dev

			x_norm = x_in
			y_norm = y_in

			x_dev = x_norm * !CL.D_X_VSIZE
			y_dev = y_norm * !CL.D_Y_VSIZE

			x_out = x_dev
			y_out = y_dev

		END ELSE IF data EQ 1 AND to_dev EQ 1 THEN BEGIN
			; /data	=> /to_dev

			x_data = x_in
			y_data = y_in

			x_norm = !CL.X_S[0] + !CL.X_S[1]*x_data
			y_norm = !CL.Y_S[0] + !CL.Y_S[1]*y_data

			x_dev = x_norm * !CL.D_X_VSIZE
			y_dev = y_norm * !CL.D_Y_VSIZE

			x_out = x_dev
			y_out = y_dev

		END ELSE IF dev EQ 1 AND to_norm EQ 1 THEN BEGIN
			; /dev	=> /to_norm

			x_dev = x_in
			y_dev = y_in

			x_norm = x_dev / !CL.D_X_VSIZE
			y_norm = y_dev / !CL.D_Y_VSIZE

			x_out = x_norm
			y_out = y_norm

		END ELSE IF data EQ 1 AND to_norm EQ 1 THEN BEGIN
			; /data	=> /to_norm

			x_data = x_in
			y_data = y_in

			x_norm = !CL.X_S[0] + !CL.X_S[1]*x_data
			y_norm = !CL.Y_S[0] + !CL.Y_S[1]*y_data

			x_out = x_norm
			y_out = y_norm
		END

		out = REPLICATE (0d, 3, N_ELEMENTS(x))
		out[0,*] = x_out
		out[1,*] = y_out

		RETURN, out

	END ELSE BEGIN

		; /data	=> /to_dev
		; /dev	=> /to_norm
		; /data	=> /to_norm

		RETURN, CONVERT_COORD (x, y, norm=norm, data=data, dev=dev, to_dev=to_dev, to_norm=to_norm)

	END

END

;-------------------------------------------------------------------------------
PRO libplot_real_set_plot
;-------------------------------------------------------------------------------
; Ouvre le device plplot si nécessaire.
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_real_set_plot'

	IF !CL.D_NAME_DONE EQ !CL.D_NAME THEN RETURN

	device = !CL.D_NAME

	IF device EQ 'PS' THEN BEGIN
		IF !CL.D_ORIENTATION EQ 'landscape' THEN BEGIN
			;x_vsize = LONG(!CL.D_Y_VSIZE / 35.4)	; ok landscape si "psttfc"
			;y_vsize = LONG(!CL.D_X_VSIZE / 35.4)	; ok landscape si "psttfc"
			x_vsize = LONG(!CL.D_X_VSIZE / 35.2)	; ok landscape si "pscairo"
			y_vsize = LONG(!CL.D_Y_VSIZE / 35.2)	; ok landscape si "pscairo"
		END
		IF !CL.D_ORIENTATION EQ 'portrait' THEN BEGIN
			x_vsize = LONG(!CL.D_Y_VSIZE / 32.6)	; ok portrait
			y_vsize = LONG(!CL.D_X_VSIZE / 32.6)	; ok portrait
		END
	END ELSE BEGIN
		x_vsize = !CL.D_X_VSIZE
		y_vsize = !CL.D_Y_VSIZE
	END

	filename = !CL.D_filename
	IF is_fdl() THEN BEGIN
		lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'SET_PLOT_AUTO_GLUE',	$
				pchar(device), pchar(filename), x_vsize, y_vsize, /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'SET_PLOT',			$
				device, filename, x_vsize, y_vsize)
	END

	!CL.D_NAME_DONE = !CL.D_NAME

	IF PTR_VALID(!CL.D_COLORS_R) THEN BEGIN
		r = *!CL.D_COLORS_R
		v = *!CL.D_COLORS_V
		b = *!CL.D_COLORS_B
		libplot_tvlct, r, v, b
	END

END

;-------------------------------------------------------------------------------
PRO libplot_set_plot,		$
;-------------------------------------------------------------------------------
	dev,			$		; LINT_PROTOTYPE input
	copy=copy				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de SET_PLOT.
;-------------------------------------------------------------------------------

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		!CL.D_NAME = dev
		IF !CL.D_NAME_DONE EQ !CL.D_NAME THEN RETURN
		!CL.D_NAME_DONE = ''

	END ELSE BEGIN

		;PRINT, '**libplot_set_plot dev=', dev
		SET_PLOT, dev, copy=copy

	END

END

;-------------------------------------------------------------------------------
PRO libplot_end
;-------------------------------------------------------------------------------
; Equivalent de DEVICE, /close
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_end'

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		libplot_real_set_plot
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'END_AUTO_GLUE', /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'END')
		END

	END

END

;-------------------------------------------------------------------------------
PRO libplot_erase,	$
;-------------------------------------------------------------------------------
	couleur					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de ERASE.
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_erase'

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		libplot_real_set_plot
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'ERASE_AUTO_GLUE', /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'ERASE')
		END

	END ELSE  BEGIN

		ERASE, couleur

	END

END

;-------------------------------------------------------------------------------
PRO libplot_plot,			$
;-------------------------------------------------------------------------------
	x,				$	; LINT_PROTOTYPE input
	y,				$	; LINT_PROTOTYPE input
	charsize=charsize,		$	; LINT_PROTOTYPE input
	charthick=charthick,		$	; LINT_PROTOTYPE input
	xthick=xthick,			$	; LINT_PROTOTYPE input
	xminor=xminor,			$	; LINT_PROTOTYPE input
	xticklen=xticklen,		$	; LINT_PROTOTYPE input
	xtickv=xtickv,			$	; LINT_PROTOTYPE input
	xticks=xticks,			$	; LINT_PROTOTYPE input
	xtickname=xtickname,		$	; LINT_PROTOTYPE input
	xtickformat=xtickformat,	$	; LINT_PROTOTYPE input
	ythick=ythick,			$	; LINT_PROTOTYPE input
	yminor=yminor,			$	; LINT_PROTOTYPE input
	yticklen=yticklen,		$	; LINT_PROTOTYPE input
	ytickv=ytickv,			$	; LINT_PROTOTYPE input
	yticks=yticks,			$	; LINT_PROTOTYPE input
	ytickname=ytickname,		$	; LINT_PROTOTYPE input
	ytickformat=ytickformat,	$	; LINT_PROTOTYPE input
	position=position,		$	; LINT_PROTOTYPE input
	linestyle=linestyle,		$	; LINT_PROTOTYPE input
	noerase=noerase,		$	; LINT_PROTOTYPE input
	psym=psym,			$	; LINT_PROTOTYPE input
	symsize=symsize,		$	; LINT_PROTOTYPE input
	thick=thick,			$	; LINT_PROTOTYPE input
	xlog=xlog,			$	; LINT_PROTOTYPE input
	ylog=ylog,			$	; LINT_PROTOTYPE input
	xrange=xrange,			$	; LINT_PROTOTYPE input
	yrange=yrange,			$	; LINT_PROTOTYPE input
	xstyle=xstyle,			$	; LINT_PROTOTYPE input
	ystyle=ystyle,			$	; LINT_PROTOTYPE input
	device=device,			$	; LINT_PROTOTYPE input
	normal=normal,			$	; LINT_PROTOTYPE input
	nodata=nodata,			$	; LINT_PROTOTYPE input
	color=color				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de PLOT.
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_plot'

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		libplot_real_set_plot

		; TODO:
		;	xthick ? ythick ?
		;	xminor ? yminor ?
		;	xticks ? yticks ?
		;	xtickformat ? ytickformat ?

		;	noerase ? je n'efface pas l'écran donc je fais comme si /noerase

		;	xtickv ? ytickv ?
		;	xtickname ? ytickname ?

		; si position n'est pas donné on utilise [0, 0, 1, 1]

		IF N_ELEMENTS(charsize) EQ 0 THEN charsize = 1
		IF N_ELEMENTS(position) EQ 0 THEN position = [0, 0, 1, 1]
		IF N_ELEMENTS(nodata) EQ 0 THEN nodata = 0
		IF N_ELEMENTS(xstyle) EQ 0 THEN xstyle = 0
		IF N_ELEMENTS(ystyle) EQ 0 THEN ystyle = 0
		IF N_ELEMENTS(xrange) EQ 0 THEN xrange = [ MIN(x), MAX(x) ]
		IF N_ELEMENTS(yrange) EQ 0 THEN yrange = [ MIN(y), MAX(y) ]
		IF N_ELEMENTS(linestyle) EQ 0 THEN linestyle = 0
		IF N_ELEMENTS(color) EQ 0 THEN color = 0
		IF N_ELEMENTS(normal) EQ 0 THEN normal = 0
		IF N_ELEMENTS(device) EQ 0 THEN device = 0
		IF N_ELEMENTS(xlog) EQ 0 THEN xlog = 0
		IF N_ELEMENTS(ylog) EQ 0 THEN ylog = 0
		IF N_ELEMENTS(xticklen) EQ 0 THEN xticklen = 1
		IF N_ELEMENTS(yticklen) EQ 0 THEN yticklen = 1
		IF N_ELEMENTS(psym) EQ 0 THEN psym = 0
		IF N_ELEMENTS(symsize) EQ 0 THEN symsize = 0
		IF N_ELEMENTS(thick) EQ 0 THEN thick = 1
		IF N_ELEMENTS(charthick) EQ 0 THEN charthick = 1

		x1 = DOUBLE(position[0])
		y1 = DOUBLE(position[1])
		x2 = DOUBLE(position[2])
		y2 = DOUBLE(position[3])

		xmin = DOUBLE(xrange[0])
		xmax = DOUBLE(xrange[1])
		ymin = DOUBLE(yrange[0])
		ymax = DOUBLE(yrange[1])

		x_in = DOUBLE(x)
		y_in = DOUBLE(y)

		IF xlog EQ 1 THEN BEGIN
			x_in = ALOG10(x_in)
			xmin = ALOG10(xmin)
			xmax = ALOG10(xmax)
		END

		IF ylog EQ 1 THEN BEGIN
			y_in = ALOG10(y_in)
			ymin = ALOG10(ymin)
			ymax = ALOG10(ymax)
		END

		; ne pas afficher de valeurs sur l'axe X si xtickname vaut '' à tous les indices et si N_ELEMENTS(xtickname) >= 2
		xvalues = 1L
		IF N_ELEMENTS(xtickname) NE 0 && N_ELEMENTS(xtickname) GE 2 THEN BEGIN
			ind = WHERE (xtickname NE '')
			IF ind[0] NE -1 THEN xvalues = 0L
			
		END

		; ne pas afficher de valeurs sur l'axe Y si ytickname vaut '' à tous les indices et si N_ELEMENTS(ytickname) >= 2
		yvalues = 1L
		IF N_ELEMENTS(ytickname) NE 0 && N_ELEMENTS(ytickname) GE 2 THEN BEGIN
			ind = WHERE (ytickname NE '')
			IF ind[0] NE -1 THEN yvalues = 0L
			
		END

		; n'afficher que certaines valeurs de l'axe Y si ytickv contient des valeurs et que ytickname[0) vaut ''
		IF N_ELEMENTS(ytickv) GE 2 && N_ELEMENTS(ytickname) GE 1 && ytickname[0] EQ '' THEN BEGIN
			ytickv1 = DOUBLE(ytickv)
			nbytickv1 = N_ELEMENTS(ytickv1)
		END ELSE BEGIN
			ytickv1 = 0d
			nbytickv1 = 0L
		END

		IF psym EQ 8 THEN BEGIN
			xsym = *(!CL.SYM_X)
			ysym = *(!CL.SYM_Y)
			nbsym = N_ELEMENTS(xsym)
		END ELSE BEGIN
			xsym = 0
			ysym = 0
			nbsym = 0L
		END
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'PLOT_AUTO_GLUE',			$
						LONG(xlog), LONG(ylog),						$
						x_in, y_in, N_ELEMENTS(x_in),					$
						xmin, xmax, ymin, ymax,					 	$
						x1, x2, y1, y2, LONG(xstyle), LONG(ystyle), LONG(color),	$
						LONG(linestyle), LONG(nodata),					$
						DOUBLE(xticklen), DOUBLE(yticklen),				$
						DOUBLE(charsize), LONG(psym), DOUBLE(symsize),			$
						DOUBLE(xsym), DOUBLE(ysym), nbsym,				$
						DOUBLE(thick), DOUBLE(charthick), xvalues, yvalues,		$
						ytickv1, nbytickv1,						$
						/AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'PLOT',				$
						LONG(xlog), LONG(ylog),						$
						x_in, y_in, N_ELEMENTS(x_in),					$
						xmin, xmax, ymin, ymax,						$
						x1, x2, y1, y2, LONG(xstyle), LONG(ystyle), LONG(color),	$
						LONG(linestyle), LONG(nodata),					$
						DOUBLE(xticklen), DOUBLE(yticklen),				$
						DOUBLE(charsize), LONG(psym), DOUBLE(symsize),			$
						DOUBLE(xsym), DOUBLE(ysym), nbsym,				$
						DOUBLE(thick), DOUBLE(charthick), xvalues, yvalues,		$
						ytickv1, nbytickv1)
		END

		IF device EQ 0 THEN BEGIN
			!CL.P_POSITION = position
			!CL.X_CRANGE = xrange
			!CL.Y_CRANGE = yrange
			!CL.X_STYLE = xstyle
			!CL.Y_STYLE = ystyle
			!CL.X_TYPE = xlog
			!CL.Y_TYPE = ylog
			!CL.X_S = [ x1-xmin*(x2-x1)/(xmax-xmin), (x2-x1)/(xmax-xmin) ]
			!CL.Y_S = [ y1-ymin*(y2-y1)/(ymax-ymin), (y2-y1)/(ymax-ymin) ]
		END

	END ELSE BEGIN

		PLOT,					$
			x,				$
			y,				$
			charsize=charsize,		$
			charthick=charthick,		$
			xthick=xthick,			$
			xminor=xminor,			$
			xticklen=xticklen,		$
			xtickv=xtickv,			$
			xticks=xticks,			$
			xtickname=xtickname,		$
			xtickformat=xtickformat,	$
			ythick=ythick,			$
			yminor=yminor,			$
			yticklen=yticklen,		$
			ytickv=ytickv,			$
			yticks=yticks,			$
			ytickname=ytickname,		$
			ytickformat=ytickformat,	$
			position=position,		$
			linestyle=linestyle,		$
			noerase=noerase,		$
			psym=psym,			$
			symsize=symsize,		$
			thick=thick,			$
			xlog=xlog,			$
			ylog=ylog,			$
			xrange=xrange,			$
			yrange=yrange,			$
			xstyle=xstyle,			$
			ystyle=ystyle,			$
			device=device,			$
			normal=normal,			$
			nodata=nodata,			$
			color=color

	END

END

;-------------------------------------------------------------------------------
PRO libplot_plots,		$
;-------------------------------------------------------------------------------
	X,			$	; LINT_PROTOTYPE input
	Y,			$	; LINT_PROTOTYPE input
	linestyle=linestyle,	$	; LINT_PROTOTYPE input
	psym=psym,		$	; LINT_PROTOTYPE input
	symsize=symsize,	$	; LINT_PROTOTYPE input
	thick=thick,		$	; LINT_PROTOTYPE input
	device=device,		$	; LINT_PROTOTYPE input
	normal=normal,		$	; LINT_PROTOTYPE input
	color=color			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de PLOTS.
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_plots'

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		libplot_real_set_plot

		IF N_ELEMENTS(device) EQ 0 THEN device = 0
		IF N_ELEMENTS(normal) EQ 0 THEN normal = 0

		IF device THEN BEGIN

			position = [0, 0, 1, 1]
			xrange = [0, !CL.D_X_VSIZE]
			yrange = [0, !CL.D_Y_VSIZE]

		END ELSE IF normal THEN BEGIN

			position = [0, 0, 1, 1]
			xrange = [0, 1]
			yrange = [0, 1]

		END ELSE BEGIN

			position = !CL.P_position
			xrange = !CL.X_crange
			yrange = !CL.Y_crange
			xlog = !CL.X_type
			ylog = !CL.Y_type

		END

		xticklen = 0
		yticklen = 0
		xstyle = 5
		ystyle = 5

		libplot_plot, 	X,							$
				Y,							$
				linestyle=linestyle,					$
				psym=psym,						$
				symsize=symsize,					$
				thick=thick,						$
				device=device,						$
				normal=normal,						$
				color=color,						$
				xticklen=xticklen, yticklen=yticklen,			$
				xstyle=xstyle, ystyle=ystyle,				$
				xlog=xlog, ylog=ylog,					$
				position=position, xrange=xrange, yrange=yrange, /noerase

	END ELSE BEGIN

		PLOTS,				$
			X,			$
			Y,			$
			linestyle=linestyle,	$
			psym=psym,		$
			symsize=symsize,	$
			thick=thick,		$
			device=device,		$
			normal=normal,		$
			color=color

	END

END

;-------------------------------------------------------------------------------
PRO libplot_oplot,		$
;-------------------------------------------------------------------------------
	X,			$	; LINT_PROTOTYPE input
	Y,			$	; LINT_PROTOTYPE input
	linestyle=linestyle,	$	; LINT_PROTOTYPE input
	thick=thick,		$	; LINT_PROTOTYPE input
	color=color			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de OPLOT.
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_oplot'

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		libplot_real_set_plot

		libplot_plots, X, Y, linestyle=linestyle, thick=thick, color=color

	END ELSE BEGIN

		OPLOT,				$
			X,			$
			Y,			$
			linestyle=linestyle,	$
			thick=thick,		$
			color=color

	END

END

;-------------------------------------------------------------------------------
PRO libplot_xyouts,			$
;-------------------------------------------------------------------------------
	X,				$	; LINT_PROTOTYPE input
	Y,				$	; LINT_PROTOTYPE input
	str,				$	; LINT_PROTOTYPE input
	orientation=orientation,	$	; LINT_PROTOTYPE input
	alignment=alignment,		$	; LINT_PROTOTYPE input
	normal=normal,			$	; LINT_PROTOTYPE input
	color=color,			$	; LINT_PROTOTYPE input
	charsize=charsize,		$	; LINT_PROTOTYPE input
	width=width,			$	; LINT_PROTOTYPE input
	charthick=charthick			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de XYOUTS.
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_xyouts'

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		libplot_real_set_plot

		; TODO:
		;	- passer str en utf-8 sinon "PA (°)" s'affiche "PA ( )"

		IF N_ELEMENTS(orientation) EQ 0 THEN orientation = 0
		IF N_ELEMENTS(alignment) EQ 0 THEN alignment = 0
		IF N_ELEMENTS(normal) EQ 0 THEN normal = 0		; ne marche que si /normal
		IF N_ELEMENTS(color) EQ 0 THEN color = 0
		IF N_ELEMENTS(charsize) EQ 0 THEN charsize = 1
		IF N_ELEMENTS(width) EQ 0 THEN width = 0		; TODO
		IF N_ELEMENTS(charthick) EQ 0 THEN charthick = 0

		charsize1 = charsize
		IF charsize1 EQ 0 THEN charsize1 = 1 ; pour faire comme IDL


		IF color GT 256 THEN BEGIN
			; bug timeaxis couleur en RGB ?
			color = 0
		END

		IF X LT 0 OR X GT 1 OR Y LT 0 OR Y GT 1 THEN BEGIN
			;HELP, X, Y, str
		END ELSE IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'XYOUTS_AUTO_GLUE',			$
					DOUBLE(X), DOUBLE(Y), pchar(str), DOUBLE(alignment), DOUBLE(charsize1),	$
					DOUBLE(orientation), LONG(color), DOUBLE(charthick), /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'XYOUTS',				$
					DOUBLE(X), DOUBLE(Y), pchar(str), DOUBLE(alignment), DOUBLE(charsize1),	$
					DOUBLE(orientation), LONG(color), DOUBLE(charthick))
		END

	END ELSE BEGIN

		XYOUTS,					$
			X,				$
			Y,				$
			str,				$
			orientation=orientation,	$
			alignment=alignment,		$
			normal=normal,			$
			color=color,			$
			charsize=charsize,		$
			width=width,			$
			charthick=charthick

	END

END

;-------------------------------------------------------------------------------
PRO libplot_tvlct,			$
;-------------------------------------------------------------------------------
	r,				$	; LINT_PROTOTYPE input
	v,				$	; LINT_PROTOTYPE input
	b					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de TVLCT.
;-------------------------------------------------------------------------------

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		IF !CL.D_NAME_DONE EQ !CL.D_NAME THEN BEGIN

			nb = N_ELEMENTS(r)
			IF is_fdl() THEN BEGIN
				lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'TVLCT_AUTO_GLUE',	$
						LONG(r), LONG(v), LONG(b), nb, /AUTO_GLUE)
			END ELSE BEGIN
				lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'TVLCT',		$
						LONG(r), LONG(v), LONG(b), nb)
			END
			!CL.D_N_COLORS = 256
		END

		PTR_FREE, !CL.D_COLORS_R
		PTR_FREE, !CL.D_COLORS_V
		PTR_FREE, !CL.D_COLORS_B
		!CL.D_COLORS_R = PTR_NEW (r)
		!CL.D_COLORS_V = PTR_NEW (v)
		!CL.D_COLORS_B = PTR_NEW (b)

	END ELSE BEGIN

		TVLCT, r, v, b

	END

END

;-------------------------------------------------------------------------------
PRO libplot_tv,		$
;-------------------------------------------------------------------------------
	image,		$	; LINT_PROTOTYPE input
	x1,		$	; LINT_PROTOTYPE input
	y1,		$	; LINT_PROTOTYPE input
	x2=x2,		$	; LINT_PROTOTYPE input
	y2=y2,		$	; LINT_PROTOTYPE input
	normal=normal,	$	; LINT_PROTOTYPE input
	device=device,	$	; LINT_PROTOTYPE input
	xsize=xsize,	$	; LINT_PROTOTYPE input
	ysize=ysize,	$	; LINT_PROTOTYPE input
	true=true		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de TV.
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_tv'

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		libplot_real_set_plot

		IF N_ELEMENTS(device) EQ 0 THEN device = 0
		IF N_ELEMENTS(normal) EQ 0 THEN normal = 0
		IF N_ELEMENTS(true) EQ 0 THEN true = 0

		nbx = N_ELEMENTS(true ? image[0,*,0] : image[*,0])
		nby = N_ELEMENTS(true ? image[0,0,*] : image[0,*])

		IF device THEN BEGIN

			; on passe de dev en norm
			tmp1 = libplot_convert_coord (DOUBLE(x1), DOUBLE(y1), /dev, /to_norm)
			tmp2 = libplot_convert_coord (DOUBLE(nbx), DOUBLE(nby), /dev, /to_norm)

			my_x1 = tmp1[0]
			my_y1 = tmp1[1]
			my_x2 = my_x1 + tmp2[0]
			my_y2 = my_y1 + tmp2[1]

			IF tmp2[0] LT 0.01 THEN BEGIN
				RETURN ; sinon ca plante
			END
			IF tmp2[1] LT 0.01 THEN BEGIN
				RETURN ; sinon ca plante
			END

		END ELSE IF normal THEN BEGIN

			; les valeurs sont entre 0 et 1
			my_x1 = DOUBLE(x1)
			my_y1 = DOUBLE(y1)
			IF N_ELEMENTS(x2) NE 0 THEN BEGIN
				my_x2 = DOUBLE(x2)
				my_y2 = DOUBLE(y2)
			END ELSE BEGIN
				my_x2 = my_x1 + DOUBLE(xsize)
				my_y2 = my_y1 + DOUBLE(ysize)
			END

		END ELSE BEGIN

			RETURN ; non géré

		END

		!CL.P_POSITION = [my_x1, my_y1, my_x2, my_y2] ; utile ?

		IF true THEN RETURN ; non géré

		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'TV_AUTO_GLUE',		$
					my_x1, my_x2, my_y1, my_y2, BYTE(image), nbx, nby, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'TV',			$
					my_x1, my_x2, my_y1, my_y2, BYTE(image), nbx, nby)
		END

	END ELSE BEGIN

		TV, image, x1, y1, normal=normal, device=device, xsize=xsize, ysize=ysize, true=true

	END

END

;-------------------------------------------------------------------------------
PRO libplot_axis,	$
;-------------------------------------------------------------------------------
	v,				$	; LINT_PROTOTYPE input
	xaxis=xaxis,			$	; LINT_PROTOTYPE input
	yaxis=yaxis,			$	; LINT_PROTOTYPE input
	xlog=xlog,			$	; LINT_PROTOTYPE input
	ylog=ylog,			$	; LINT_PROTOTYPE input
	xticklen=xticklen,		$	; LINT_PROTOTYPE input
	yticklen=yticklen,		$	; LINT_PROTOTYPE input
	xtickv=xtickv,			$	; LINT_PROTOTYPE input
	ytickv=ytickv,			$	; LINT_PROTOTYPE input
	xticks=xticks,			$	; LINT_PROTOTYPE input
	yticks=yticks,			$	; LINT_PROTOTYPE input
	xminor=xminor,			$	; LINT_PROTOTYPE input
	yminor=yminor,			$	; LINT_PROTOTYPE input
	xtickname=xtickname,		$	; LINT_PROTOTYPE input
	ytickname=ytickname,		$	; LINT_PROTOTYPE input
	color=color,			$	; LINT_PROTOTYPE input
	charsize=charsize,		$	; LINT_PROTOTYPE input
	xthick=xthick,			$	; LINT_PROTOTYPE input
	ythick=ythick,			$	; LINT_PROTOTYPE input
	xtickformat=xtickformat,	$	; LINT_PROTOTYPE input
	ytickformat=ytickformat,	$	; LINT_PROTOTYPE input
	charthick=charthick,		$	; LINT_PROTOTYPE input
	ystyle=ystyle				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de AXIS.
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_axis'

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		libplot_real_set_plot

		IF N_ELEMENTS(yaxis) EQ 0 THEN axis = xaxis	; xaxis vaut 0 ou 1
		IF N_ELEMENTS(xaxis) EQ 0 THEN axis = 2+yaxis	; yaxis vaut 0 ou 1
		IF N_ELEMENTS(xlog) EQ 0 THEN xlog = 0
		IF N_ELEMENTS(ylog) EQ 0 THEN ylog = 0
		IF N_ELEMENTS(xticklen) EQ 0 THEN xticklen = 0
		IF N_ELEMENTS(yticklen) EQ 0 THEN yticklen = 0
		IF N_ELEMENTS(charsize) EQ 0 THEN charsize = 1
		IF N_ELEMENTS(charthick) EQ 0 THEN charthick = 1

		; TODO:
		;	xtickv ? ytickv ?
		;	xticks ? yticks ?
		;	xminor ? yminor ?
		;	xtickname ? ytickname ?
		;	si color n'est pas donné ?
		;	xtick ? ytick ?
		;	xtickformat ? ytickformat ?
		;	ystyle ?

		position = !CL.P_position
		x1 = DOUBLE(position[0])
		y1 = DOUBLE(position[1])
		x2 = DOUBLE(position[2])
		y2 = DOUBLE(position[3])

		xmin = !CL.X_CRANGE[0]
		xmax = !CL.X_CRANGE[1]
		ymin = !CL.Y_CRANGE[0]
		ymax = !CL.Y_CRANGE[1]

		IF xlog EQ 1 THEN BEGIN
			xmin = ALOG10(xmin)
			xmax = ALOG10(xmax)
		END

		IF ylog EQ 1 THEN BEGIN
			ymin = ALOG10(ymin)
			ymax = ALOG10(ymax)
		END

		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'AXIS_AUTO_GLUE',			$
						LONG(axis), LONG(xlog), LONG(ylog),				$
						DOUBLE(xmin), DOUBLE(xmax), DOUBLE(ymin), DOUBLE(ymax), 	$
						x1, x2, y1, y2, LONG(color),					$
						DOUBLE(xticklen), DOUBLE(yticklen),				$
						DOUBLE(charsize), DOUBLE(charthick),				$ 
						/AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'AXIS',				$
						LONG(axis), LONG(xlog), LONG(ylog),				$
						DOUBLE(xmin), DOUBLE(xmax), DOUBLE(ymin), DOUBLE(ymax),		$
						x1, x2, y1, y2, LONG(color),					$
						DOUBLE(xticklen), DOUBLE(yticklen),				$
						DOUBLE(charsize), DOUBLE(charthick))
		END

	END ELSE BEGIN

		; si yaxis est donné (0 ou 1): l'axe Y se fera en position x=v
		; si xaxis est donné (0 ou 1): l'axe X se fera en position Y=v
		AXIS, 					$
			v,				$
			xaxis=xaxis,			$
			yaxis=yaxis,			$
			xlog=xlog,			$
			ylog=ylog,			$
			xticklen=xticklen,		$
			yticklen=yticklen,		$
			xtickv=xtickv,			$
			ytickv=ytickv,			$
			xticks=xticks,			$
			yticks=yticks,			$
			xminor=xminor,			$
			yminor=yminor,			$
			xtickname=xtickname,		$
			ytickname=ytickname,		$
			color=color,			$
			charsize=charsize,		$
			xthick=xthick,			$
			ythick=ythick,			$
			xtickformat=xtickformat,	$
			ytickformat=ytickformat,	$
			charthick=charthick,		$
			ystyle=ystyle

	END

END

;-------------------------------------------------------------------------------
PRO libplot_polyfill,	$
;-------------------------------------------------------------------------------
	x,		$	; LINT_PROTOTYPE input
	y,		$	; LINT_PROTOTYPE input
	normal=normal,	$	; LINT_PROTOTYPE input
	color=color		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de POLYFILL.
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_polyfill'

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		libplot_real_set_plot

		nb = N_ELEMENTS(x)
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'POLYFILL_AUTO_GLUE',	$
					DOUBLE(x), DOUBLE(y), nb, LONG(color), /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'POLYFILL',			$
					DOUBLE(x), DOUBLE(y), nb, LONG(color))
		END

	END ELSE BEGIN

		POLYFILL, x, y, normal=normal, color=color

	END

END

;-------------------------------------------------------------------------------
PRO libplot_usersym,	$
;-------------------------------------------------------------------------------
	x,		$	; LINT_PROTOTYPE input
	y,		$	; LINT_PROTOTYPE input
	fill=fill		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de USERSYM.
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_usersym'

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		libplot_real_set_plot

		IF PTR_VALID(!CL.SYM_X) THEN PTR_FREE, !CL.SYM_X
		IF PTR_VALID(!CL.SYM_Y) THEN PTR_FREE, !CL.SYM_Y

		!CL.SYM_X = PTR_NEW (x)
		!CL.SYM_Y = PTR_NEW (y)

	END ELSE BEGIN

		USERSYM, x, y, fill=fill

	END

END

;-------------------------------------------------------------------------------
PRO libplot_contour,			$
;-------------------------------------------------------------------------------
	image,				$	; LINT_PROTOTYPE input
	position=position,		$	; LINT_PROTOTYPE input
	noerase=noerase,		$	; LINT_PROTOTYPE input
	normal=normal,			$	; LINT_PROTOTYPE input
	c_colors=c_colors,		$	; LINT_PROTOTYPE input
	levels=levels,			$	; LINT_PROTOTYPE input
	xstyle=xstyle,			$	; LINT_PROTOTYPE input
	ystyle=ystyle,			$	; LINT_PROTOTYPE input
	fill=fill,			$	; LINT_PROTOTYPE input
	overplot=overplot,		$	; LINT_PROTOTYPE input
	background=background,		$	; LINT_PROTOTYPE input
	closed=closed,			$	; LINT_PROTOTYPE input
	c_linestyle=c_linestyle			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de CONTOUR.
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_contour'

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		libplot_real_set_plot

		IF N_ELEMENTS(position) EQ 0 THEN position = !CL.P_position

		x1 = DOUBLE(position[0])
		y1 = DOUBLE(position[1])
		x2 = DOUBLE(position[2])
		y2 = DOUBLE(position[3])

		nbx = N_ELEMENTS(image[*,0])
		nby = N_ELEMENTS(image[0,*])
		nb = N_ELEMENTS(levels)

		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'CONTOUR_AUTO_GLUE',	$
					x1, x2, y1, y2, DOUBLE(image), nbx, nby, DOUBLE(levels), LONG(c_colors), nb, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'CONTOUR',		$
					x1, x2, y1, y2, DOUBLE(image), nbx, nby, DOUBLE(levels), LONG(c_colors), nb)
		END

		!CL.P_position = position

	END ELSE BEGIN

		IF is_fdl() THEN BEGIN

			; n'accepte pas /closed
			; n'accepte pas /c_linestyle

			CONTOUR,					$
					image,				$
					position=position,		$
					noerase=noerase,		$
					normal=normal,			$
					c_colors=c_colors,		$
					levels=levels,			$
					xstyle=xstyle,			$
					ystyle=ystyle,			$
					fill=fill,			$
					overplot=overplot,		$
					background=background

		END ELSE BEGIN

			CONTOUR,					$
					image,				$
					position=position,		$
					noerase=noerase,		$
					normal=normal,			$
					c_colors=c_colors,		$
					levels=levels,			$
					xstyle=xstyle,			$
					ystyle=ystyle,			$
					fill=fill,			$
					overplot=overplot,		$
					background=background,		$
					closed=closed,			$
					c_linestyle=c_linestyle	

		END

	END

END

;-------------------------------------------------------------------------------
PRO libplot_set_shading,		$
;-------------------------------------------------------------------------------
	gouraud=gouraud			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de SET_SHADING.
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_set_shading'

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		libplot_real_set_plot

	END ELSE BEGIN

		IF is_fdl() THEN BEGIN
			; ne marche pas sous FDL
		END ELSE BEGIN
			SET_SHADING, gouraud=gouraud
		END

	END

END

;-------------------------------------------------------------------------------
PRO libplot_shade_surf,		$
;-------------------------------------------------------------------------------
	image,			$	; LINT_PROTOTYPE input
	position=position,	$	; LINT_PROTOTYPE input
	noerase=noerase,	$	; LINT_PROTOTYPE input
	normal=normal,		$	; LINT_PROTOTYPE input
	ax=ax,			$	; LINT_PROTOTYPE input
	az=az,			$	; LINT_PROTOTYPE input
	xstyle=xstyle,		$	; LINT_PROTOTYPE input
	ystyle=ystyle,		$	; LINT_PROTOTYPE input
	zstyle=zstyle,		$	; LINT_PROTOTYPE input
	min_value=min_value,	$	; LINT_PROTOTYPE input
	max_value=max_value,	$	; LINT_PROTOTYPE input
	shades=shades			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de SHADE_SURF.
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_shade_surf'

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		libplot_real_set_plot

		x1 = DOUBLE(position[0])
		y1 = DOUBLE(position[1])
		x2 = DOUBLE(position[2])
		y2 = DOUBLE(position[3])

		nbx = N_ELEMENTS(image[*,0])
		nby = N_ELEMENTS(image[0,*])

		image1 = DOUBLE(image)
		ind = WHERE (image EQ !VALUES.F_INFINITY)
		IF ind[0] NE -1 THEN image1[ind] = 0

		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'SHADE_SURF_AUTO_GLUE',	$
					x1, x2, y1, y2, image1, nbx, nby, DOUBLE(min_value), DOUBLE(max_value), /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'SHADE_SURF',		$
					x1, x2, y1, y2, image1, nbx, nby, DOUBLE(min_value), DOUBLE(max_value))
		END

	END ELSE BEGIN

		IF is_fdl() THEN BEGIN
			; ne marche pas sous FDL
		END ELSE BEGIN
			SHADE_SURF,				$
					image,			$
					position=position,	$
					noerase=noerase,	$
					normal=normal,		$
					ax=ax,			$
					az=az,			$
					xstyle=xstyle,		$
					ystyle=ystyle,		$
					zstyle=zstyle,		$
					min_value=min_value,	$
					max_value=max_value,	$
					shades=shades
		END

	END

END

;-------------------------------------------------------------------------------
PRO libplot_device_x,				$
;-------------------------------------------------------------------------------
	decomposed=decomposed,			$	; LINT_PROTOTYPE input
	bypass_translation=bypass_translation,	$	; LINT_PROTOTYPE input
	true_color=true_color,			$	; LINT_PROTOTYPE input
	pseudo=pseudo,				$	; LINT_PROTOTYPE input
	font=font,				$	; LINT_PROTOTYPE input
	get_fontnames=get_fontnames,		$	; LINT_PROTOTYPE output
	get_screen_size=get_screen_size,	$	; LINT_PROTOTYPE output
	cursor_standard=cursor_standard			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de DEVICE pour x.
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_device_x'

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		libplot_real_set_plot

	END ELSE BEGIN

		IF is_gdl() THEN BEGIN

			DEVICE,							$
					decomposed=decomposed,			$
					get_screen_size=get_screen_size,	$
					cursor_standard=cursor_standard	

		END ELSE IF is_fdl() THEN BEGIN

			DEVICE,							$
					decomposed=decomposed,			$
					get_screen_size=get_screen_size,	$
					cursor_standard=cursor_standard	

		END ELSE IF is_windows() THEN BEGIN

			DEVICE,							$
					decomposed=decomposed,			$
					bypass_translation=bypass_translation,	$
					font=font,				$
					get_fontnames=get_fontnames,		$
					get_screen_size=get_screen_size,	$
					cursor_standard=cursor_standard	

		END ELSE BEGIN

			DEVICE,							$
					decomposed=decomposed,			$
					bypass_translation=bypass_translation,	$
					true_color=true_color,			$
					pseudo=pseudo,				$
					font=font,				$
					get_fontnames=get_fontnames,		$
					get_screen_size=get_screen_size,	$
					cursor_standard=cursor_standard	

		END

	END

END

;-------------------------------------------------------------------------------
PRO libplot_device_ps,				$
;-------------------------------------------------------------------------------
	close_file=close_file,			$	; LINT_PROTOTYPE input
	xsize=xsize,				$	; LINT_PROTOTYPE input
	ysize=ysize,				$	; LINT_PROTOTYPE input
	xoffset=xoffset,			$	; LINT_PROTOTYPE input
	yoffset=yoffset,			$	; LINT_PROTOTYPE input
	filename=filename,			$	; LINT_PROTOTYPE input
	encapsulated=encapsulated,		$	; LINT_PROTOTYPE input
	color=color,				$	; LINT_PROTOTYPE input
	landscape=landscape,			$	; LINT_PROTOTYPE input
	portrait=portrait,			$	; LINT_PROTOTYPE input
	bits=bits					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de DEVICE pour ps.
;-------------------------------------------------------------------------------

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		IF N_ELEMENTS(close_file) EQ 0 THEN close_file = 0

		IF N_ELEMENTS(bits) NE 0 THEN libplot_real_set_plot
		IF N_ELEMENTS(filename) NE 0 THEN !CL.D_filename = filename
		IF N_ELEMENTS(portrait) NE 0 THEN !CL.D_ORIENTATION = 'portrait'
		IF N_ELEMENTS(landscape) NE 0 THEN !CL.D_ORIENTATION = 'landscape'
		IF N_ELEMENTS(xsize) NE 0 THEN !CL.D_X_VSIZE = xsize * 1000
		IF N_ELEMENTS(ysize) NE 0 THEN !CL.D_Y_VSIZE = ysize * 1000

		IF close_file THEN libplot_end

	END ELSE BEGIN

		IF KEYWORD_SET(close_file) 	THEN BEGIN
			;PRINT, '**libplot_device_ps close_file=',close_file
		END
		IF KEYWORD_SET(xsize) 		THEN BEGIN
			;PRINT, '**libplot_device_ps xsize=',xsize
		END
		IF KEYWORD_SET(ysize) 		THEN BEGIN
			;PRINT, '**libplot_device_ps ysize=',ysize
		END
		IF KEYWORD_SET(xoffset)		THEN BEGIN
			;PRINT, '**libplot_device_ps xoffset=',xoffset
		END
		IF KEYWORD_SET(yoffset)		THEN BEGIN
			;PRINT, '**libplot_device_ps yoffset=',yoffset
		END
		IF KEYWORD_SET(filename)	THEN BEGIN
			;PRINT, '**libplot_device_ps filename=',filename
		END
		IF KEYWORD_SET(encapsulated)	THEN BEGIN
			;PRINT, '**libplot_device_ps encapsulated=',encapsulated
		END
		IF KEYWORD_SET(color)		THEN BEGIN
			;PRINT, '**libplot_device_ps color=',color
		END
		IF KEYWORD_SET(landscape)	THEN BEGIN
			;PRINT, '**libplot_device_ps landscape=',landscape
		END
		IF KEYWORD_SET(portrait)	THEN BEGIN
			;PRINT, '**libplot_device_ps portrait=',portrait
		END
		IF KEYWORD_SET(bits)		THEN BEGIN
			;PRINT, '**libplot_device_ps bits=',bits
		END

		DEVICE,							$
				close_file=close_file,			$
				xsize=xsize,				$
				ysize=ysize,				$
				xoffset=xoffset,			$
				yoffset=yoffset,			$
				filename=filename,			$
				encapsulated=encapsulated,		$
				color=color,				$
				landscape=landscape,			$
				portrait=portrait,			$
				bits=bits

	END

END

;-------------------------------------------------------------------------------
PRO libplot_device_printer,			$
;-------------------------------------------------------------------------------
	true_color=true_color,			$	; LINT_PROTOTYPE input
	close_document=close_document,		$	; LINT_PROTOTYPE input
	xsize=xsize,				$	; LINT_PROTOTYPE input
	ysize=ysize,				$	; LINT_PROTOTYPE input
	xoffset=xoffset,			$	; LINT_PROTOTYPE input
	yoffset=yoffset					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de DEVICE pour printer.
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_device_printer'

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		libplot_real_set_plot

	END ELSE BEGIN

		DEVICE,							$
				true_color=true_color,			$
				close_document=close_document,		$
				xsize=xsize,				$
				ysize=ysize,				$
				xoffset=xoffset,			$
				yoffset=yoffset

	END

END

;-------------------------------------------------------------------------------
PRO libplot_device_png,				$
;-------------------------------------------------------------------------------
	close_file=close_file,			$	; LINT_PROTOTYPE input
	filename=filename,			$	; LINT_PROTOTYPE input
	landscape=landscape,			$	; LINT_PROTOTYPE input
	portrait=portrait,			$	; LINT_PROTOTYPE input
	bits=bits					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de DEVICE pour png.
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_device_png'

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		IF N_ELEMENTS(close_file) EQ 0 THEN close_file = 0

		IF N_ELEMENTS(bits) NE 0 THEN libplot_real_set_plot
		IF N_ELEMENTS(filename) NE 0 THEN !CL.D_filename = filename
		IF N_ELEMENTS(portrait) NE 0 THEN !CL.D_ORIENTATION = 'portrait'
		IF N_ELEMENTS(landscape) NE 0 THEN !CL.D_ORIENTATION = 'landscape'

		IF close_file THEN libplot_end

	END

END

;-------------------------------------------------------------------------------
PRO libplot_get_cursor,	$
;-------------------------------------------------------------------------------
	keysym,		$	; LINT_PROTOTYPE output
	button			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Uniquement pour plplot.
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_get_cursor'

	keysym = 0L
	button = 0L

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		libplot_real_set_plot

		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'GET_CURSOR_AUTO_GLUE',	$
					keysym, button, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'GET_CURSOR',		$
					keysym, button)
		END
	END

END

;-------------------------------------------------------------------------------
PRO libplot_set_output,			$
;-------------------------------------------------------------------------------
	nom				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Donne le nom du fichier que plplot doit créer (ou "" s'il ne doit pas le créér).
;-------------------------------------------------------------------------------
	;PRINT, '**libplot_set_output'

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'SET_OUTPUT_AUTO_GLUE', pchar(nom), /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('my_plplot'), 'SET_OUTPUT',           nom)
		END

	END

END
