;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: libnetcdf.pro,v $, v $Revision: 1.4 $
;
;	Date	: $Date: 2017/09/29 13:59:00 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
PRO lire_struct_netcdf,	$
;-------------------------------------------------------------------------------
	filename,	$	; LINT_PROTOTYPE input
	data,		$	; LINT_PROTOTYPE input
	nom1,		$	; LINT_PROTOTYPE input
	nom2,		$	; LINT_PROTOTYPE input
	REC_START,	$	; LINT_PROTOTYPE input
	REC_COUNT		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((-)) Lit certaines variables d'un fichier CDF et crit les valeurs dans certains champs d'un tableau de structure.
;
; Entres:
;
;	filename:	fichier CDF
;	nom1:		tableau de string avec les noms des champs de la structure  lire
;	nom2:		tableau de string avec les noms des variables CDF correspondantes
;	REC_START:	commencer  lire dans le CDF  l'enregistrement REC_START
;	REC_COUNT:	lire REC_COUNT enregistrements dans le fichier cdf
;
; Entrs/Sorties:
;
;	data:		tableau de structure existante en entre, renseigne en sortie
;-------------------------------------------------------------------------------

	top1 = nbsec()

	;DEBUG = 0

	;nblignes = 0L
	;nblignesonly = 0L
	lint_unused = get_structure_infos (data[0], taille_enreg, nbchamps, nom_champ, type_champ, offset_champ, taille_champ, nb_champ)

	ouvrir_fermer = 0L ; pour ne pas ouvrir et fermer le fichier  chaque variable

	IF ~ouvrir_fermer THEN fd = NCDF_OPEN (filename)
	FOR i=0L,N_ELEMENTS(nom1)-1 DO BEGIN
		nochamp = WHERE (STRUPCASE(TAG_NAMES(data)) EQ STRUPCASE(nom1[i]))

		; Rcuprer l'id de la variable nom2[i]
		varid = NCDF_VARID (fd, nom2[i])

		; Rcuprer des infos sur la variable nom2[i]
		vinq = NCDF_VARINQ (fd, varid)
		datatype = vinq.datatype
		dim = vinq.dim
		ndims = vinq.ndims

		; pour les types 'CHAR', le premier indice est le nombre de caractres
		; le dernier indice est le nombre de records au sens CDF
		OFFSET = REPLICATE (0L, ndims)
		COUNT  = REPLICATE (0L, ndims)

		FOR j=0L,ndims-1 DO BEGIN
			NCDF_DIMINQ, fd, dim[j], a,b
			IF j EQ ndims-1 THEN BEGIN
				OFFSET[j] = REC_START
				COUNT[j]  = REC_COUNT
                        END ELSE BEGIN
				OFFSET[j] = 0
				COUNT[j]  = b
			END
                END

		NCDF_VARGET, fd, nom2[i], var, OFFSET=OFFSET, COUNT=COUNT

		IF datatype EQ 'CHAR' THEN BEGIN
			var = STRING(var)

			IF nom2[i] EQ 'Time' THEN BEGIN
				;                                 0123456789012345
				; rustine codage temps AMDA: ex: '2013067000001148'
				;	annee	= 2013
				;	doy	= 067 (1er janvier=0)
				;	heure	= 00
				;	minute 	= 00
				;	seconde = 01.148
				annee	= LONG(STRMID(var,0,4))
				doy	= LONG(STRMID(var,4,3)) + 1
				heure	= LONG(STRMID(var,7,2))
				minute	= LONG(STRMID(var,9,2))
				seconde	= LONG(STRMID(var,11)) / 1000d
				year_doy_to_month_day, annee, doy, mois, jour
				var = tu_to_date (annee, mois, jour, heure, minute, seconde)

			END ELSE IF nom2[i] EQ 'epoch' THEN BEGIN

				var = str_to_date (var, format=7, /C)
			END
			
		END

		IF N_ELEMENTS(var) NE N_ELEMENTS(data) * N_ELEMENTS(data[0].(nochamp)) THEN BEGIN
			; Arrive par exemple lorsque l'on lit plusieurs composantes d'un vecteur qui sont dans une seule variable NCDF
			FOR j=0L,N_ELEMENTS(var[*,0])-1 DO BEGIN
				data.(nochamp+j) = REFORM(var[j,*])
			END
		END ELSE BEGIN
			data.(nochamp) = var
		END

	END

	IF ~ouvrir_fermer THEN NCDF_CLOSE,fd

	top2 = nbsec()
	PRINT, 'lire_struct_netcdf en ' + val_to_str_2decimales(top2-top1)

END

;-------------------------------------------------------------------------------
FUNCTION read_netcdf_get_symbols,	$
;-------------------------------------------------------------------------------
	FILENAME,			$	; LINT_PROTOTYPE input
	ATT,				$	; LINT_PROTOTYPE output
	NOVARY,				$	; LINT_PROTOTYPE output
	SYMBOLS,			$	; LINT_PROTOTYPE output
	FORMAT,				$	; LINT_PROTOTYPE output
	NBRECORDS,			$	; LINT_PROTOTYPE output
	NBLINES0,			$	; LINT_PROTOTYPE output
	noatt=noatt,			$	; LINT_PROTOTYPE input
	nonb=nonb,			$	; LINT_PROTOTYPE input
	selection_date=selection_date,	$	; LINT_PROTOTYPE input
	remove_ext=remove_ext,		$	; LINT_PROTOTYPE input
	nosymbols=nosymbols,		$	; LINT_PROTOTYPE input
	quiet=quiet				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((1:ok 0:pb)) Lit un fichier NCDF et retourne les symboles trouvs.
;
; Input:
; ------
; - FILENAME:			filename to read
;
; Keywords:
; ---------
; - /noatt:			don't compute ATT and NOVARY
; - /nonb:			don't compute NBRECORDS
; - /selection_date:		
; - /remove_ext:		"CAA" or "THEMIS" to remove extension in variables names
; - /nosymbols:			don't compute symbols
; - /quiet: 			no messages
;
; Output:
; -------
; - ATT:			(undefined if /noatt) array of structure { v1:'', v2:'', v3:'', v4:''} with all attributes found in header
; - NOVARY:			(undefined if /noatt) structure with variables containing a non empty DATA field
; - SYMBOLS:			structure with variables inforation found in header
; - FORMAT:			format number for Date/Time found in first line of data (5 for CEF-2)
; - NBRECORDS:			number of records found in data
; - NBLINES0:			number of lines found in header
;
; Return code:
; ------------
;	1 = OK
;	0 = PB
;-------------------------------------------------------------------------------

	;DEBUG = 0

	top1 = nbsec()

	ON_IOERROR, error

	IF N_ELEMENTS(quiet) 		EQ 0 THEN quiet = 0
	IF N_ELEMENTS(noatt) 		EQ 0 THEN noatt = 0
	IF N_ELEMENTS(nosymbols) 	EQ 0 THEN nosymbols = 0
	IF N_ELEMENTS(remove_ext)	EQ 0 THEN remove_ext = 'No'
	IF N_ELEMENTS(nonb) 		EQ 0 THEN nonb = 0

	FORMAT		= 0L
	NBLINES0	= 0L
	NBRECORDS	= 0L

	IF ~quiet THEN BEGIN
		PRINT,''
		FOR i=0L,STRLEN(FILENAME)-1 DO PRINT, '-',FORMAT='(A,$)' & PRINT, ''
		PRINT, FILENAME
		FOR i=0L,STRLEN(FILENAME)-1 DO PRINT, '-',FORMAT='(A,$)' & PRINT, ''
	END

	IF noatt THEN BEGIN
		ATT = 0
		lint_unused = TEMPORARY(ATT) ; destroy ATT
	END ELSE BEGIN
		ATT = { v1:'', v2:'', v3:'', v4:'' }
	END
	NOVARY = 0
	lint_unused = TEMPORARY(NOVARY) ; destroy NOVARY
	symbol0 = { 			$
		name:		'', 	$
		exception:	0,  	$
		nblignes:	0L,  	$
		value_type:	'', 	$
		var_type:	'', 	$
		property:	'', 	$
		sizes:		'', 	$
		data:		'', 	$
		delta_plus:	'', 	$
		delta_minus:	'', 	$
		fillval:	'', 	$
		units:		'', 	$
		fieldnam:	'', 	$
		si_conversion:	'', 	$
		depend_0:	'', 	$
		depend_1:	'', 	$
		depend_2:	'', 	$
		depend_3:	'', 	$
		depend_4:	'', 	$
		labl_ptr_1:	''  	$

	}
	SYMBOLS = [ symbol0 ]

	fd = -1 ; car sinon, si CDF_OPEN plante, fd ne sera pas defini
	fd = NCDF_OPEN (FILENAME)
	inq = NCDF_INQUIRE (fd)

	nbvar = inq.nvars
	SYMBOLS = REPLICATE (symbol0, nbvar)

	; une premire passe pour dterminer le nombre de lignes dans la variable contenant le temps
	NBRECORDS = 0L
	FOR i=0L,nbvar-1 DO BEGIN
		novar = i
		vinq = NCDF_VARINQ (fd,i)
		; Patch pour forcer le champ Time  'ISO_TIME'
		IF vinq.name EQ 'Time' OR vinq.name EQ 'epoch' THEN BEGIN
			dim = REVERSE(vinq.dim)
			FOR j=0L,vinq.ndims-1 DO BEGIN
				IF vinq.datatype EQ 'CHAR' AND j EQ vinq.ndims-1 THEN CONTINUE ; sauter le dernier indice pour les types 'CHAR'
				NCDF_DIMINQ, fd, dim[j], a,b
				NBRECORDS = b
				BREAK
			END
		END
	END
	

	FOR i=0L,nbvar-1 DO BEGIN

		novar = i
		vinq = NCDF_VARINQ (fd,i)
		SYMBOLS[novar].name = vinq.name

		CASE vinq.datatype OF
			; on peut avoir BYTE CHAR INT LONG FLOAT DOUBLE
			'CDF_EPOCH':	SYMBOLS[novar].value_type = 'ISO_TIME'
			'CDF_EPOCH16':	SYMBOLS[novar].value_type = 'ISO_TIME'
			'CHAR':		SYMBOLS[novar].value_type = 'CHAR'
			'DOUBLE':	SYMBOLS[novar].value_type = 'FLOAT' ; sinon ca dconne pour les spectros
			ELSE:		SYMBOLS[novar].value_type = 'FLOAT'
		END

		; Patch pour forcer le champ Time  'ISO_TIME'
		IF vinq.name EQ 'Time' OR vinq.name EQ 'epoch' THEN BEGIN
			SYMBOLS[novar].value_type = 'ISO_TIME'
		END

		; exemple sur un fichier d'AMDA
		;
		; ncdump donne:
		; ------------
		;
		;dimensions:
		;	Time = UNLIMITED ; // (18089 currently)
		;	TimeLength = 17 ;
		;	Data = 3 ;
		;	Flux = 32 ;
		;variables:
		;	char Time(Time, TimeLength) ;
		;	double DeltaT(Time) ;
		;	double Density(Time) ;
		;		Density:Units = "cm^-3" ;
		;	double Velocity(Time, Data) ;
		;		Velocity:Units = "km/s" ;
		;		Velocity:Frame = "GSE" ;
		;	double Temperature(Time, Data) ;
		;		Temperature:Units = "eV" ;
		;	double Flux(Time, Flux) ;
		;		Flux:Units = "eV/(cm^2-s-sr-eV)" ;
		;	float Energy(Time, Flux) ;
		;		Energy:Units = "eV" ;
		;	char StartTime(TimeLength) ;
		;	char StopTime(TimeLength) ;
		;
		; IDL donne:
		; ---------
		;
		; NAME		DATATYPE	NDIMS	DIM
		;
		; 'Time'	'CHAR'		2	1 0	=> CHAR		Time[TimeLength:17,Time:18089]		=> STRING	Time[Time:18089]		DEPEND_0:Time
		; 'DeltaT'	'DOUBLE'	1	0	=> DOUBLE	DeltaT[Time:18089]			=> DOUBLE	DeltaT[Time:18089]		DEPEND_0:Time
		; 'Density'	'DOUBLE'	1	0	=> DOUBLE	Density[Time:18089]			=> DOUBLE	Density[Time:18089]		DEPEND_0:Time
		; 'Velocity'	'DOUBLE'	2	2 0	=> DOUBLE	Velocity[Data:3,Time:18089]		=> DOUBLE	Velocity[Data:3,Time:18089]	DEPEND_0:Time
		; 'Temperature'	'DOUBLE'	2	2 0	=> DOUBLE	Temperature[Data:3,Time:18089]		=> DOUBLE	Temperature[Data:3,Time:18089]	DEPEND_0:Time
		; 'Flux'	'DOUBLE'	2	3 0	=> DOUBLE	Flux[Flux:32,Time:18089]		=> DOUBLE	Flux[Flux:32,Time:18089]	DEPEND_0:Time
		; 'Energy'	'FLOAT'		2	3 0	=> FLOAT	Energy[Flux:32,Time:18089]		=> FLOAT	Energy[Flux:32,Time:18089]	DEPEND_0:Time
		; 'StartTime'	'CHAR'		1	1	=> CHAR		StartTime[TimeLength:17]		=> STRING	StartTime			DATA
		; 'StopTime'	'CHAR'		1	1	=> CHAR		StopTime[TimeLength:17]			=> STRING	StopTime			DATA
		;
		; et pour les dimensions:
		; 0 'Time'		18089
		; 1 'TimeLength'	17
		; 2 'Data'		3
		; 3 'Flux'		32

		dim = REVERSE(vinq.dim)
		SIZES = ''
		nblignes = 0L

		FOR j=0L,vinq.ndims-1 DO BEGIN
			IF vinq.datatype EQ 'CHAR' AND j EQ vinq.ndims-1 THEN CONTINUE ; sauter le dernier indice pour les types 'CHAR'
			NCDF_DIMINQ, fd, dim[j], a,b
			IF j EQ 0 THEN BEGIN
				IF b EQ NBRECORDS THEN BEGIN
					SYMBOLS[novar].DEPEND_0 = a
					nblignes = b
				END ELSE BEGIN
					; c'est une variable NOVARY dont la valeur doit tre mise dans 'DATA'
					SIZES += (SIZES EQ '' ? '' : ',') + val_to_str(b)
				END
			END ELSE IF j EQ 1 THEN BEGIN
				SYMBOLS[novar].DEPEND_1 = 'DEPEND_1_'+a
				SIZES += (SIZES EQ '' ? '' : ',') + val_to_str(b)
			END ELSE IF j EQ 2 THEN BEGIN
				SYMBOLS[novar].DEPEND_2 = 'DEPEND_2_'+a
				SIZES += (SIZES EQ '' ? '' : ',') + val_to_str(b)
			END ELSE IF j EQ 3 THEN BEGIN
				SYMBOLS[novar].DEPEND_3 = 'DEPEND_3_'+a
				SIZES += (SIZES EQ '' ? '' : ',') + val_to_str(b)
			END ELSE IF j EQ 4 THEN BEGIN
				SYMBOLS[novar].DEPEND_4 = 'DEPEND_4_'+a
				SIZES += (SIZES EQ '' ? '' : ',') + val_to_str(b)
			END
		END
		IF SIZES EQ '' THEN SIZES = '1'
		SYMBOLS[novar].SIZES = SIZES
		SYMBOLS[novar].nblignes = nblignes

		IF nblignes EQ 0 THEN BEGIN
			; NOVARY
			NCDF_VARGET, fd, vinq.name, var

			IF vinq.datatype EQ 'CHAR' THEN BEGIN
				sVALEUR = STRING(var)
			END ELSE BEGIN
				sVALEUR = STRING(DOUBLE(var))
			END
			var = 0 ; pour librer la mmoire


			SIZES = LONG(val_to_str(N_ELEMENTS(sVALEUR)))
			sVALEUR = REFORM(sVALEUR,SIZES)
			sVALEUR = supprimer_caractere(sVALEUR,',')
			DATA = STRJOIN(sVALEUR,',')
			SYMBOLS[novar].SIZES = val_to_str(N_ELEMENTS(sVALEUR))
			SYMBOLS[novar].data = DATA
		END

		; Attributs
		NCDF_VARGET, fd, vinq.name, var
		FOR j=0L,vinq.natts-1 DO BEGIN
			attname = NCDF_ATTNAME (fd, NCDF_VARID(fd,vinq.name), j)
			NCDF_ATTGET, fd,  NCDF_VARID(fd,vinq.name), attname, valeur
			;PRINT,'ATT ('+vinq.name+'): '+attname + ' = '+STRING(valeur)
			CASE STRUPCASE(attname) OF
				'PROPERTY':		SYMBOLS[novar].property		= STRING(valeur)
				'FILLVAL':		SYMBOLS[novar].fillval		= STRING(valeur)
				'DELTA_PLUS':		SYMBOLS[novar].delta_plus	= STRING(valeur)
				'DELTA_MINUS':		SYMBOLS[novar].delta_minus	= STRING(valeur)
				'UNITS':		SYMBOLS[novar].units		= STRING(valeur)
				'FIELDNAM':		SYMBOLS[novar].fieldnam		= STRING(valeur)
				'SI_CONVERSION':	SYMBOLS[novar].si_conversion	= STRING(valeur)
				'DEPEND_0':		SYMBOLS[novar].depend_0		= STRING(valeur)
				'DEPEND_1':		SYMBOLS[novar].depend_1		= STRING(valeur)
				'DEPEND_2':		SYMBOLS[novar].depend_2		= STRING(valeur)
				'DEPEND_3':		SYMBOLS[novar].depend_3		= STRING(valeur)
				'DEPEND_4':		SYMBOLS[novar].depend_4		= STRING(valeur)
				'LABL_PTR_1':		BEGIN
								SYMBOLS[novar].labl_ptr_1	= STRING(valeur)
								SYMBOLS[novar].depend_1		= ''
								SYMBOLS[novar].depend_2		= ''
								SYMBOLS[novar].depend_3		= ''
								SYMBOLS[novar].depend_4		= ''
							END
				ELSE:
			END
		END


	END

	NBRECORDS = -1L
	ind1 = WHERE (SYMBOLS.VALUE_TYPE EQ 'ISO_TIME' AND SYMBOLS.DATA EQ '')
	IF ind1[0] EQ -1 THEN BEGIN
		PRINT,'*** WARNING *** NO ISO_TIME VARIABLE'
		RETURN, 0
	END
	selection = selection_date
	IF selection EQ 'Automatic' THEN selection = REFORM(SYMBOLS[ind1[0]].name)
	selection = selection[0] ; pour supprimer la dimension inutile Array[1] qui pose problme  chaine_contient
	selection = remove_extension(remove_ext,selection)
	IF NBRECORDS EQ -1 THEN BEGIN
		IF ind1[0] NE -1 THEN BEGIN
			FOR i=0L, N_ELEMENTS(ind1)-1 DO BEGIN
				IF SYMBOLS[ind1[i]].name EQ selection THEN BEGIN
					NBRECORDS = SYMBOLS[ind1[i]].nblignes
					BREAK
				END
			END
		END
	END


	corriger_symbols, symbol0, SYMBOLS, modif

	IF fd NE -1 THEN NCDF_CLOSE,fd
	top2 = nbsec()
	PRINT,FILENAME+' read_netcdf_get_symbols ***** ' + val_to_str(top2-top1)+' *****'
	RETURN, 1

error:

	PRINT,FILENAME+' read_netcdf_nget_symbols_error ***** '
	IF fd NE -1 THEN NCDF_CLOSE,fd
	RETURN, 0

END

;-------------------------------------------------------------------------------
FUNCTION read_netcdf_get_data,	$
;-------------------------------------------------------------------------------
	filename,					$	; LINT_PROTOTYPE input
	FORMAT,						$	; LINT_PROTOTYPE output
	NBRECORDS,					$	; LINT_PROTOTYPE output
	NBLINES0,					$	; LINT_PROTOTYPE output
	STRUCT,						$	; LINT_PROTOTYPE output
	INFO,						$	; LINT_PROTOTYPE output
	DATA,						$	; LINT_PROTOTYPE output
	rec_start=rec_start,				$	; LINT_PROTOTYPE input
	rec_count=rec_count,				$	; LINT_PROTOTYPE input
	modify_float_fillval=modify_float_fillval,	$	; LINT_PROTOTYPE input
	nomalloc=nomalloc,				$	; LINT_PROTOTYPE input
	quiet=quiet						; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((1:ok 0:pb)) Lit les donnes d'un fichier CDF dja analys et retourne un tableau de structure avec les donnes.
;
; Input:
; -----
; - filename:			filename to read
; - FORMAT:			number of format for Date/Time
; - NBRECORDS:			nbrecords
; - NBLINES0:			number of lines in header
; - STRUCT:			output from read_ascii_get_structure()
; - INFO:			output from read_ascii_get_structure()
;
; Keywords:
; ---------
; - rec_start:			start read at record rec_start (0=first)
; - rec_count:			number of records to read
; - /modify_float_fillval:	to modify FLOAT fillval by -1e31
; - /nomalloc:			if DATA has already been allocated
; - /quiet: 			no messages
;
; Output:
; -------
; - DATA:			array of STRUCT with data read in filename
;				'ISO_TIME' and 'ISO_TIME_RANGE' variables are stored as number of millsecondes since 01/01/1958 00:00:00.000 in a double
;				use date_to_tu to convert these fields to year, month, day, hour, minute, seconde
;
;
; Return code:
; ------------
;	1 = OK
;	0 = PB
;				'ERROR: INCORRECT FORMAT IN ' + filename
;-------------------------------------------------------------------------------

	lint_unused = FORMAT ; pour ne pas avoir de message de LINT
	lint_unused = NBLINES0 ; pour ne pas avoir de message de LINT

	IF N_ELEMENTS(rec_start) 		EQ 0 THEN rec_start 		= 0L
	IF N_ELEMENTS(rec_count) 		EQ 0 THEN rec_count 		= NBRECORDS-rec_start
	IF N_ELEMENTS(modify_float_fillval)	EQ 0 THEN modify_float_fillval	= 0
	IF N_ELEMENTS(nomalloc) 		EQ 0 THEN nomalloc 		= 0
	IF N_ELEMENTS(quiet) 			EQ 0 THEN quiet 		= 0

	IF rec_count LE 0 THEN RETURN, 0

	IF ~nomalloc THEN DATA = REPLICATE (STRUCT,rec_count)

	top1 = nbsec()
	TAGNAMES = TAG_NAMES(DATA)
	inf = [['','','']]

	; on peut sortir sur N_ELEMENTS(INFO.NAME) si TAGNAMES contient des champs GSM rajouts a la structure (ex: FGM cluster)

	; ex:	TAGNAMES			INFO.NAME
	;
	;	date				epoch
	;	duration			duration
	;	energy_table_1			energy_table
	; 	energy_table_2			energy_table
	;	...
	;	energy_256			energy_table
	;	delta_plus_energy_table_1	delta_plus_energy_table
	;	delta_plus_energy_table_2	delta_plus_energy_table
	;	...
	;	delta_plus_energy_table_256	delta_plus_energy_table
	;
	;	il faut mettre dans inf:
	;	=> date				epoch
	;	=> energy_table_1		energy_table
	;	=> delta_plus_energy_table_1	delta_plus_energy_table

	; ex:	TAGNAMES
	;	date				epoch
	;	duration			duration
	;	energy_table			energy_table
	;					energy_table
	;					...
	;					energy_table
	;	delta_plus_energy_table		delta_plus_energy_table
	;					delta_plus_energy_table
	;	...
	;					delta_plus_energy_table
	;
	;	il faut mettre dans inf:
	;	=> date				epoch
	;	=> energy_table			energy_table
	;	=> delta_plus_energy_table	delta_plus_energy_table
	

	i1 = 0L	; / TAGNAMES
	i2 = 0L	; / INFO.NAME

	nb1 = N_ELEMENTS(TAGNAMES)
	nb2 = N_ELEMENTS(INFO.NAME)
	WHILE 1 DO BEGIN
		val = [TAGNAMES[i1], INFO.NAME[i2], '']
		IF inf[0,0] EQ '' THEN BEGIN
			inf = [val]
		END ELSE IF val[1] NE inf[1,N_ELEMENTS(inf[0,*])-1] THEN BEGIN
			inf = [[inf],[val]]
		END
		i2 += N_ELEMENTS(DATA[0].(i1))
		IF i2 GE nb2 THEN BREAK
		i1++
		IF i1 GE nb1 THEN BREAK
	END
	lire_struct_netcdf, filename, DATA, inf[0,*], inf[1,*], rec_start, rec_count

	top2 = nbsec()

	; rustine pour Themis avec codage spcial du temps
	ind_epoch = WHERE (STRMID(INFO.name,5,6,/REVERSE_OFFSET) EQ '_epoch', nbepoch)
	FOR j=0L,nbepoch-1 DO BEGIN
		i = ind_epoch[j]
		ind = WHERE (INFO.name EQ STRMID(INFO.name[i],0,STRLEN(INFO.name[i])-6)+'_time')
		IF ind[0] NE -1 THEN BEGIN
			; var_epoch (INFO.name[i]) et var_time (INFO.name[ind[i]]) existe
			PRINT,'Compute ' + val_to_str(N_ELEMENTS(DATA)) + ' ' + INFO.name[i]
			DATA.(i) = DATA.(ind[0])*1000D + tu_to_date(1970,1,1,0,0,0)
			
		END
	END
	ind_epoch16 = WHERE (STRMID(INFO.name,5,6,/REVERSE_OFFSET) EQ '_epoch16', nbepoch16)
	FOR j=0L,nbepoch16-1 DO BEGIN
		i = ind_epoch16[j]
		ind = WHERE (INFO.name EQ STRMID(INFO.name[i],0,STRLEN(INFO.name[i])-8)+'_time')
		IF ind[0] NE -1 THEN BEGIN
			; var_epoch (INFO.name[i]) et var_time (INFO.name[ind[i]]) existe
			PRINT,'Compute ' + val_to_str(N_ELEMENTS(DATA)) + ' ' + INFO.name[i]
			DATA.(i) = DATA.(ind[0])*1000D + tu_to_date(1970,1,1,0,0,0)
			
		END
	END

	IF ~quiet THEN PRINT,'reading ' + filename + ' in '+ val_to_str_2decimales(top2-top1)+' sec'

	RETURN, 1

END 

;-------------------------------------------------------------------------------
;FUNCTION lire_netcdf, nom, phase, infocdf, noms, fillval, nblignes, data=data, $
;	REC_COUNT=REC_COUNT,REC_START=REC_START, cdfdata=cdfdata
;-------------------------------------------------------------------------------
; Si phase=1, on demande juste a connaitre les noms des champs et le nombre de lignes
; Si phase=2, on demande a lire reellement les donnes dans data
; Si phase=3, on demande juste a connaitre nblignes
; Si phase=4, on demande juste a connaitre le champ date
;
; Si N_ELEMENTS(cdfdata) NE 0 alors cdfdata contiendra:
; - le champ ATT
; - le champ NOVARY
; - le champ VARY
;
; infocdf: 1 pour afficher des informations sur les attributs et variables du fichier CDF
;
;	ON_IOERROR, lire_netcdf_erreur
; 
; 	COMMON COMMON_LIRE_NCDF, attvar
; 
; 	top1 = nbsec()
; 	noms  = ''
; 	id = -1 ; car sinon, si NCDF_OPEN plante, id ne sera pas defini
; 	id = NCDF_OPEN (nom)
; 	inq = NCDF_INQUIRE (id)
; 	nblignes = 0L
; 
; 	IF infocdf THEN BEGIN
; 		PRINT
; 		PRINT,nom
; 	END
; 
; 	infocdf=1
; 	IF (phase EQ 1 AND infocdf) THEN BEGIN
; 		attvar = '' ; attributs VARIABLE_SCOPE
; 		FOR i=0L,inq.ngatts-1 DO BEGIN 				; Boucle sur tous les attributs
; 			name = NCDF_ATTNAME (id, /global, i)
; 			NCDF_ATTGET,id, /global, name, att
; 			PRINT,'ATT (GLOBAL): '+name + ' = '+STRING(att)
; 		END
; 	END
; 
; 	IF phase EQ 1 THEN BEGIN
; 		REC_START=0
; 		REC_COUNT=1
; 	END
; 
; 	nbvar = inq.nvars
; 
; 	premier_Time=0	; positionne a 1 la premiere fois que l'on rencontre une variable commencant par 'Time'
; 
; 	FOR i=0L,nbvar-1 DO BEGIN
; 		res1 = NCDF_VARINQ (id,i)
; 
; 		IF phase EQ 3 OR phase EQ 4 THEN BEGIN ; On ne s'interesse qu' la variable 'Time'
; 
; 			IF res1.datatype EQ 'CDF_EPOCH' THEN BEGIN ; Datation
; 				IF phase EQ 3 THEN BEGIN
; 					CDF_CONTROL, id, variable=res1.name,zvariable=isz,get_var_info=vinfo
; 					nblignes = vinfo.maxrec+1
; 				END ELSE IF phase EQ 4 THEN BEGIN
; 					;PRINT,"Lecture!"
; 					lire_var_cdf, id,res1.name,data,err,type
; 					nblignes = N_ELEMENTS(data)
; 					CDF_EPOCH, decalage, 1958, 1, 1, 0, 0, 0, /compute_epoch
; 					data -= decalage
; 				END
; 				NCDF_CLOSE,id
; 				IF infocdf THEN PRINT,nom+' Phase ' + val_to_str(phase)+' done in '+val_to_str_2decimales(nbsec()-top1)+' sec'
; 				RETURN, 1
; 			END
; 
; 		END ELSE IF phase EQ 1 OR phase EQ 2 THEN BEGIN
; 
; 			IF infocdf THEN top3=nbsec()
; 			NCDF_VARGET, id, res1.name, var
; 			REC_COUNT = N_ELEMENTS(var[*,0]) 
; 			IF infocdf THEN PRINT,'Phase '+val_to_str(phase)+' read '+val_to_str(REC_COUNT)+' lines of ' + res1.name+' in '+val_to_str_2decimales(nbsec()-top3)+' sec'
; 
; 			IF (phase EQ 1 AND infocdf) THEN BEGIN
; 				attvar = '' ; attributs VARIABLE_SCOPE
; 				FOR j=0L,res1.natts-1 DO BEGIN 				; Boucle sur tous les attributs
; 					name = NCDF_ATTNAME (id, NCDF_VARID(id,res1.name), j)
; 					NCDF_ATTGET,id,  NCDF_VARID(id,res1.name), name, att
; 					PRINT,'ATT ('+res1.name+'): '+name + ' = '+STRING(att)
; 				END
; 			END
; 
; 			IF premier_Time EQ 0 AND chaine_contient(STRUPCASE(res1.name),'TIME') THEN BEGIN ; Datation
; 				nblignes = N_ELEMENTS(var) 
; 				premier_Time = 1
; 			END
; 
; 			getnbxy_cdf, var,nbX,nbY
; 			IF phase EQ 2 AND infocdf THEN BEGIN
; 				HELP,var
; 				PRINT,'   '+res1.name+'[',val_to_str(nbX)+','+val_to_str(nbY)+']'
; 			END
;
; 			IF nbY EQ 1 THEN BEGIN
; 
; 				nom_court = STRUPCASE(STRMID(res1.name,0,5)) EQ 'TIME' ? 'date' : res1.name
; 				noms = noms[0] EQ '' ? [nom_court] : [noms, nom_court]
; 				IF phase EQ 2 THEN BEGIN
; 					IF nom_court EQ 'date' THEN BEGIN ; Codage de epoch en nb msec depuis 1/1/1958
; 						CDF_EPOCH, decalage, 2005, 1, 1, 0, 0, 0, /compute_epoch
; 						var = decalage + (var-1) * 86400*1000d
; 						CDF_EPOCH, decalage, 1958, 1, 1, 0, 0, 0, /compute_epoch
; 						var -= decalage
; 					END
; 					k = N_ELEMENTS(noms)-1
; 					code = transferer_cdf (data, k, var)
; 					IF code NE 1 THEN BEGIN
; 						PRINT, 'WARNING: Not exactly ' + val_to_str(N_ELEMENTS(data)) + ' values in ' + res1.name
; 					END
; 					fillval = k EQ 0 ? [-1E31] : [fillval, -1E31]
; 				END
; 
; 			END ELSE BEGIN
; 
; 				var = REFORM (var, nbX, nbY)
; 
; 				nom_long = res1.name+'_'+val_to_str(1+LINDGEN(nbY))
; 				noms = noms[0] EQ '' ? [nom_long] : [noms, nom_long]
; 				FOR j=1L,nbY DO BEGIN
; 					IF phase EQ 2 THEN BEGIN
; 						k = N_ELEMENTS(noms)-1
; 						code = transferer_cdf (data, k, var[*,j-1])
; 						IF code NE 1 THEN BEGIN
; 							PRINT, 'WARNING: Not exactly ' + val_to_str(N_ELEMENTS(data)) + ' values in ' +  nom_long
; 						END
; 						fillval = k EQ 0 ? [-1E31] : [fillval, -1E31]
; 					END
; 				END
; 			END
; 		END
; 	END
; 
; 	NCDF_CLOSE,id
; 	IF infocdf THEN PRINT,nom + ' Phase ' + val_to_str(phase)+'  done in '+val_to_str_2decimales(nbsec()-top1)+' sec'
; 
; 	IF nblignes EQ 0 THEN RETURN,0
; 
; 	RETURN, 1
; 
; lire_netcdf_erreur:
; 	IF id NE -1 THEN NCDF_CLOSE,id
; 	nblignes = 0
; 	RETURN, 0
; 
; END


;-------------------------------------------------------------------------------
FUNCTION read_netcdf,			$
;-------------------------------------------------------------------------------
        FILENAME,			$	; LINT_PROTOTYPE input
        DATA,				$	; LINT_PROTOTYPE output
        ATT,				$	; LINT_PROTOTYPE [output]
        NOVARY,				$	; LINT_PROTOTYPE [output]
        VARNAMES,			$	; LINT_PROTOTYPE [output]
        NAMES,				$	; LINT_PROTOTYPE [output]
        quiet=quiet,			$	; LINT_PROTOTYPE input
        noatt=noatt,			$	; LINT_PROTOTYPE input
        nonb=nonb,			$	; LINT_PROTOTYPE input
        remove_ext=remove_ext,		$	; LINT_PROTOTYPE input
        selection_date=selection_date,	$	; LINT_PROTOTYPE input
        selection_data=selection_data,	$	; LINT_PROTOTYPE input
        selection_type=selection_type		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((1:ok 0:pb)) Lit le fichier CEF donn en argument et retourne les donnes dans un tableau de structure.
;
; Input:
; -----
; - FILENAME:                   filename to read
;
; Keywords:
; ---------
; - /quiet:                     no messages
;
; Output:
; -------
; - ATT:                        array of structure { v1:'', v2:'', v3:'', v4:''} with all attributes found in header
; - NOVARY:                     structure with variables containing a non empty DATA field
; - VARNAMES:                   names of variables with empty DATA field
; - NAMES:                      names of fields in the structure
; - DATA:                       array of STRUCT with data read in FILENAME
;                               'ISO_TIME' and 'ISO_TIME_RANGE' variables are stored as number of millsecondes since 01/01/1958 00:00:00.000 in a double
;                               use date_to_tu to convert these fields to year, month, day, hour, minute, seconde
;
; Return code:
; ------------
;       1 = OK
;       0 = PB
;                               'ERROR: INCORRECT FORMAT IN ' + FILENAME
;-------------------------------------------------------------------------------

        IF N_ELEMENTS(quiet)		EQ 0 THEN quiet = 0
        IF N_ELEMENTS(selection_date)	EQ 0 THEN selection_date = 'Automatic'
        IF N_ELEMENTS(selection_data)	EQ 0 THEN selection_data = 'Automatic'
        IF N_ELEMENTS(selection_type)	EQ 0 THEN selection_type = 'count3d'

	code = read_netcdf_get_symbols (FILENAME, ATT, NOVARY, SYMBOLS, format, NBRECORDS, nblignes0, $
					selection_date=selection_date, $
					quiet=quiet, noatt=noatt, nonb=nonb, remove_ext=remove_ext)

        IF ~code THEN RETURN, 0

        code = read_ascii_analyse_symbols (SYMBOLS, VARNAMES, REALVARNAMES, TYPES, SIZES, FILLVALS, UNITS, NAME_TIME, NAME_THETA, UNIT_THETA, NAME_PHI, UNIT_PHI, NAME_ENERGY, UNIT_ENERGY)
        IF ~code THEN RETURN, 0

        code = read_ascii_get_structure (VARNAMES, REALVARNAMES, TYPES, SIZES, FILLVALS, NAMES, STRUCT, INFO, quiet=quiet)
        IF ~code THEN RETURN, 0

        nbalire = NBRECORDS
        taille = get_structure_length (STRUCT)
        IF ~quiet THEN BEGIN
                msg = basename(FILENAME)+' Reading ' + val_to_str(nbalire)+' lines ('+val_to_str_2decimales(DOUBLE(nbalire)*taille/1e6)+' Mbytes)'
                PRINT, msg
        END

        code = read_netcdf_get_data (FILENAME, format, NBRECORDS, nblignes0, STRUCT, INFO, DATA, /modify_float_fillval, quiet=quiet)
        RETURN, code

END
