;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: libidl.pro,v $, v $Revision: 1.90 $
;
;	Date	: $Date: 2021/06/26 20:27:02 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
;
; Ce module doit pouvoir se compiler tout seul.
; Il ne doit pas y avoir d'appel  des routines non dfinies ici.
;
; Les routines doivent tre dclares avant de pouvoir tre utilises:
; si A utilise B alors dclarer d'abord B puis A.
;
; Ne pas utiliser d'objets.
;
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
FUNCTION libplot_get,		$
;-------------------------------------------------------------------------------
	x_crange=x_crange,	$	; LINT_PROTOTYPE input
	y_crange=y_crange,	$	; LINT_PROTOTYPE input
	x_type=x_type,		$	; LINT_PROTOTYPE input
	y_type=y_type,		$	; LINT_PROTOTYPE input
	d_x_size=d_x_size,	$	; LINT_PROTOTYPE input
	d_y_size=d_y_size,	$	; LINT_PROTOTYPE input
	d_x_vsize=d_x_vsize,	$	; LINT_PROTOTYPE input
	d_y_vsize=d_y_vsize,	$	; LINT_PROTOTYPE input
	d_y_ch_size=d_y_ch_size,$	; LINT_PROTOTYPE input
	d_n_colors=d_n_colors,	$	; LINT_PROTOTYPE input
	d_name=d_name			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne les valeurs correspondantes de la structure !D.
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(x_crange) EQ 0 THEN x_crange = 0
	IF N_ELEMENTS(y_crange) EQ 0 THEN y_crange = 0
	IF N_ELEMENTS(x_type) EQ 0 THEN x_type = 0
	IF N_ELEMENTS(y_type) EQ 0 THEN y_type = 0
	IF N_ELEMENTS(d_x_size) EQ 0 THEN d_x_size = 0
	IF N_ELEMENTS(d_y_size) EQ 0 THEN d_y_size = 0
	IF N_ELEMENTS(d_x_vsize) EQ 0 THEN d_x_vsize = 0
	IF N_ELEMENTS(d_y_vsize) EQ 0 THEN d_y_vsize = 0
	IF N_ELEMENTS(d_y_ch_size) EQ 0 THEN d_y_ch_size = 0
	IF N_ELEMENTS(d_n_colors) EQ 0 THEN d_n_colors = 0
	IF N_ELEMENTS(d_name) EQ 0 THEN d_name = 0

	IF !CL.libplot EQ 'plplot' THEN BEGIN

		IF x_crange THEN RETURN, !CL.X_CRANGE
		IF y_crange THEN RETURN, !CL.Y_CRANGE
		IF x_type THEN RETURN, !CL.X_TYPE
		IF y_type THEN RETURN, !CL.Y_TYPE
		IF d_x_size THEN RETURN, !CL.D_X_VSIZE
		IF d_y_size THEN RETURN, !CL.D_Y_VSIZE
		IF d_x_vsize THEN RETURN, !CL.D_X_VSIZE
		IF d_y_vsize THEN RETURN, !CL.D_Y_VSIZE
		IF d_y_ch_size THEN RETURN, !CL.D_NAME EQ 'PS' ? 352. : 9.
		IF d_n_colors THEN RETURN, !CL.D_N_COLORS
		IF d_name THEN RETURN, !CL.D_NAME

	END ELSE BEGIN

		IF x_crange THEN RETURN, !X.CRANGE
		IF y_crange THEN RETURN, !Y.CRANGE
		IF x_type THEN RETURN, !X.TYPE
		IF y_type THEN RETURN, !Y.TYPE
		IF d_x_size THEN RETURN, !D.X_SIZE
		IF d_y_size THEN RETURN, !D.Y_SIZE
		IF d_x_vsize THEN RETURN, !D.X_VSIZE
		IF d_y_vsize THEN RETURN, !D.Y_VSIZE
		IF d_y_ch_size THEN RETURN, !D.Y_CH_SIZE
		IF d_n_colors THEN RETURN, !D.N_COLORS
		IF d_name THEN RETURN, !D.NAME


	END

END

;-------------------------------------------------------------------------------
FUNCTION is_windows,	$
;-------------------------------------------------------------------------------
	is32=is32	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((-)) Retourne 1 si le systme d'exploitation est Windows (32 bits si /is32), 0 sinon.
;-------------------------------------------------------------------------------

	RETURN, (!VERSION.OS EQ 'Win32' OR !VERSION.OS EQ 'Windows') && (KEYWORD_SET(is32) ? !VERSION.ARCH EQ 'x86' : 1)

END

;-------------------------------------------------------------------------------
FUNCTION is_mac
;-------------------------------------------------------------------------------
; ((-)) Retourne 1 si le systme d'exploitation est Mac, 0 sinon.
;-------------------------------------------------------------------------------

	RETURN, !VERSION.OS EQ 'darwin'

END

;-------------------------------------------------------------------------------
FUNCTION is_gdl,		$
;-------------------------------------------------------------------------------
	RELEASE=RELEASE,	$	; LINT_PROTOTYPE input
	BUILD_DATE=BUILD_DATE		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((-)) Retourne 1/RELEASE/BUILD_DATE si on utilise GDL, 0/''/'' sinon
;-------------------------------------------------------------------------------

	RETURN, KEYWORD_SET(RELEASE) ? !GDL.RELEASE : (KEYWORD_SET(BUILD_DATE) ? !GDL.BUILD_DATE : !GDL.RELEASE NE '')

END

;-------------------------------------------------------------------------------
FUNCTION is_fdl,	$
;-------------------------------------------------------------------------------
	RELEASE=RELEASE	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((-)) Retourne 1/RELEASE si on utilise FL, 0/'' sinon
;-------------------------------------------------------------------------------

	RETURN, KEYWORD_SET(RELEASE) ? !FL.RELEASE : !FL.RELEASE NE ''

END

;-------------------------------------------------------------------------------
FUNCTION get_structure_length,	$
;-------------------------------------------------------------------------------
	enreg			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((-)) Renvoie la taille d'une structure (alignement compris)
;-------------------------------------------------------------------------------

	IF is_gdl() THEN BEGIN ; ok

		; sinon "Erreur de segmentation  (core dumped)"

		; GDL n'aligne pas les stuctures de la mme facon qu'IDL
		; IDL fait comme le langage C, pas GDL

		IF N_ELEMENTS(enreg) EQ 0 THEN RETURN, 0L

		myalign = !VERSION.memory_bits / 8
		totalsize = 0L
		nbchamps = N_TAGS (enreg[0])

		FOR nochamp=0L,nbchamps-1 DO BEGIN
			tmp = SIZE (enreg[0].(nochamp))
			typecode = tmp[0]+1
			type = tmp[typecode]
	                CASE type OF
				 1:	sizeof =  1	; Byte
				 2:	sizeof =  2	; Integer
				 3:	sizeof =  4	; Longword integer
				 4:	sizeof =  4	; Floating point
				 5:	sizeof =  8	; Double-precision floating
				 7:	sizeof = 16	; String
				12:	sizeof =  2	; Unsigned integer
				13:	sizeof =  4	; Unsigned Longword integer
				14:	sizeof =  8	; 64-bit integer
				15:	sizeof =  8	; Unsigned 64-bit integer
				ELSE:	RETURN, 0	; Lecture en C impossible
			END

			align = sizeof LT myalign ? sizeof : myalign
			IF totalsize MOD align NE 0 THEN BEGIN
	                	totalsize += align - (totalsize MOD align)
			END

			totalsize += sizeof * tmp[typecode+1]
		END

		IF totalsize MOD myalign NE 0 THEN BEGIN
			totalsize += myalign - (totalsize MOD myalign)
		END

		RETURN, totalsize

	END ELSE BEGIN

		RETURN, N_TAGS(enreg, /length)

	END

END

;-------------------------------------------------------------------------------
FUNCTION get_structure_offsets,	$
;-------------------------------------------------------------------------------
	enreg			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((-)) Renvoie un tableau contenant les offsets des champs d'une structure (alignement compris) ou 0 si c'est impossible
;-------------------------------------------------------------------------------

	myalign = !VERSION.memory_bits / 8
	totalsize = 0L
	nbchamps = N_TAGS (enreg[0])

	offset = REPLICATE (0L, nbchamps)

	FOR nochamp=0L,nbchamps-1 DO BEGIN

		tmp = SIZE (enreg[0].(nochamp))
		typecode = tmp[0]+1
		type = tmp[typecode]
                CASE type OF
			 1:	sizeof =  1	; Byte
			 2:	sizeof =  2	; Integer
			 3:	sizeof =  4	; Longword integer
			 4:	sizeof =  4	; Floating point
			 5:	sizeof =  8	; Double-precision floating
			 7:	sizeof = is_fdl() ? 32 : 16	; String
			12:	sizeof =  2	; Unsigned integer
			13:	sizeof =  4	; Unsigned Longword integer
			14:	sizeof =  8	; 64-bit integer
			15:	sizeof =  8	; Unsigned 64-bit integer
			ELSE:	RETURN, 0
		END

		align = sizeof LT myalign ? sizeof : myalign
		IF (totalsize MOD align) NE 0 THEN BEGIN
                	totalsize += align - (totalsize MOD align)
		END

		offset[nochamp] = totalsize

		totalsize += sizeof * tmp[typecode+1]
	END

	RETURN, offset

END

;-------------------------------------------------------------------------------
FUNCTION libname,	$
;-------------------------------------------------------------------------------
	name	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((-)) Rajoute l'extension ".dll" ou ".so" suivant le systme d'exploitation.
;-------------------------------------------------------------------------------

	filename = name + (is_windows(/is32) ? '_32.dll' : (is_windows() ? '.dll' : '.so'))

	IF is_mac() THEN BEGIN

		; LD_LIBRARY_PATH ne peut plus tre utilis sur macOS High Sierra
		; L'OS supprime le contenu quand on y met '/DATA/CLUSTER/SOFT/CLL3/lib'
		; Solution: rajouter le chemin complet de filename

		RETURN, GETENV('CL_ROOT') + '/lib/' + filename

	END ELSE IF is_fdl() THEN BEGIN

		; sinon erreur 
		; % Error: CALL_EXTERNAL: 
		; shared library: /home/penou/DATA/CLUSTER/SOFT/CLL3/libascii.so: cannot open shared object file: No such file or directory

		RETURN, GETENV('CL_ROOT') + '/lib/' + filename

	END ELSE BEGIN

		RETURN, filename

	END

END

;-------------------------------------------------------------------------------
FUNCTION nbsec
;-------------------------------------------------------------------------------
; ((-)) Retourne dans un double le temps machine en seconde (le temps 0 dpend du systme d'exploitation). Sert  faire des mesures de dures.
;-------------------------------------------------------------------------------

	IF is_fdl() THEN BEGIN
		RETURN, CALL_EXTERNAL (libname ('libascii'), 'NBSEC', /D_VALUE, /AUTO_GLUE)
	END ELSE BEGIN
		RETURN, CALL_EXTERNAL (libname ('libascii'), 'NBSEC', /D_VALUE)
	END

END

;-------------------------------------------------------------------------------
FUNCTION pchar,	$
;-------------------------------------------------------------------------------
	s		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((-)) Retourne un tableau de BYTE de 1024 BYTES contenant la chaine s.
;-------------------------------------------------------------------------------

	nb = N_ELEMENTS(s)
	tabs = REPLICATE (0b, 1024, nb)
	FOR i=0L,nb-1 DO BEGIN
		tabs[0:STRLEN(s[i])-1,i] = BYTE(s[i])
	END
	RETURN, tabs

END

;-------------------------------------------------------------------------------
FUNCTION int_str_0,	$
;-------------------------------------------------------------------------------
	var,		$	; LINT_PROTOTYPE input
	dim			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Retourne une chaine de caractres reprsentant un entier sur dim caractres, complte par des zros  gauche.
;
;   Entres:
;   --------
;    - var: entier que l'on veut crire sous forme de chaine de caractres
;    - dim: nombre de caracteres voulu dans la chaine
;
;   Retourne:
;   --------
;    Chaine de caractre contenant l'entier var sur dim caractres, cadre  droite et complte par des 0  gauche.
;-------------------------------------------------------------------------------

	s = STRCOMPRESS (STRING (var), /REMOVE_ALL)
	l = STRLEN (s)
	FOR i=l,dim-1 DO s = '0'+s
	RETURN, s

END


;-------------------------------------------------------------------------------
FUNCTION my_strsplit,	$
;-------------------------------------------------------------------------------
	s,		$	; LINT_PROTOTYPE input
	sep,		$	; LINT_PROTOTYPE input
	TRIM=TRIM,	$	; LINT_PROTOTYPE input
	ESC=ESC			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Appelle STRSPLIT avec /EXTRACT et /PRESERVE_NULL, en supprimant les blancs au dbut et  la fin si /TRIM. Retourne un scalaire plutot qu'un tableau  une dimension.
;-------------------------------------------------------------------------------

	snew = STRSPLIT(s, sep, /EXTRACT, ESCAPE=ESC, /PRESERVE_NULL)
	IF KEYWORD_SET(TRIM) THEN snew =  STRTRIM(snew, 2) ; supprimer les blancs avant et aprs
	IF N_ELEMENTS(snew) EQ 1 THEN snew = snew[0] ; passage en scalaire

	RETURN, snew

END


;-------------------------------------------------------------------------------
FUNCTION chaine_la_plus_courte,	$
;-------------------------------------------------------------------------------
	s1,	$	; LINT_PROTOTYPE input
	s2		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Retourne la chaine de caractre non vide la plus courte parmi les deux fournies en arguments.
;-------------------------------------------------------------------------------

	IF STRLEN(s1) EQ 0 THEN RETURN, s2
	IF STRLEN(s2) EQ 0 THEN RETURN, s1
	RETURN, STRLEN(s1) LT STRLEN(s2) ? s1 : s2
END

;-------------------------------------------------------------------------------
FUNCTION supprimer_caractere,	$
;-------------------------------------------------------------------------------
	s,	$	; LINT_PROTOTYPE input
	c		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Remplace par des blancs toutes les occurences d'un caractre dans une chaine de caractre.
;-------------------------------------------------------------------------------

	tabpos = STRPOS(s, c)
	ind = WHERE (tabpos NE -1)
	IF ind[0] EQ -1 THEN RETURN, s

	s1 = s
	FOR j=0L,N_ELEMENTS(ind)-1 DO BEGIN
		i = ind[j]
		WHILE 1 DO BEGIN
			pos = STRPOS(s1[i], c)
			IF pos EQ -1 THEN BREAK
			tmp = s1[i]
			STRPUT, tmp, ' ', pos
			s1[i] = tmp
		END
	END

	RETURN, s1

END


;-------------------------------------------------------------------------------
FUNCTION chiffre_to_str,	$
;-------------------------------------------------------------------------------
	x,		$	; LINT_PROTOTYPE input
	format=format,	$	; LINT_PROTOTYPE input
	opt=opt			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Retourne une chaine de caractres reprsentant un chiffre, avec format si demand, en supprimant les 0 inutiles si demand.
;
; Permet d'ecrire l'entier x dans une chaine de caracteres ne contenant pas de blanc.
;-------------------------------------------------------------------------------

	str = STRCOMPRESS(STRING (x, format=format), /REMOVE_ALL)

	IF KEYWORD_SET(opt) THEN BEGIN
		; certains 0 peuvent-ils tre enlevs ? ex: "1.20000" -> "1.2"
		IF STRPOS (str, '.') NE -1 THEN BEGIN
			; on a un '.'

			; exposant ?
			exposant = ''
			pos = STRPOS (str, 'e')
			IF pos EQ -1 THEN pos = STRPOS (str, 'E')
			IF pos NE -1 THEN BEGIN
				exposant = STRMID (str, pos)
				str = STRMID (str, 0, pos)
			END

			; => suppression des '0' de la fin
			first = STRLEN(str) - 1
			WHILE STRMID(str, first, 1) EQ '0' DO first--
			str = STRMID(str, 0, first+1)
			; suppression du '.' si c'est le dernier caractre ex: "2." -> "2"
			IF STRMID(str, STRLEN(str)-1, 1) EQ '.' THEN str = STRMID(str, 0, STRLEN(str)-1)

			str += exposant
		END
	END

	RETURN, str

END


;-------------------------------------------------------------------------------
FUNCTION val_to_str,	$
;-------------------------------------------------------------------------------
	x,		$	; LINT_PROTOTYPE input
	format=format,	$	; LINT_PROTOTYPE input
	opt=opt			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Retourne une chaine de caractres reprsentant une valeur (scalaire ou tableau), avec format si demand, en supprimant les 0 inutiles si demand.
;-------------------------------------------------------------------------------

	info = SIZE (x)
	IF info[N_ELEMENTS(info)-2] EQ 7 THEN RETURN, x ; string

	nb = N_ELEMENTS(x)
	IF nb EQ 1 THEN RETURN, chiffre_to_str (x, format=format, opt=opt)

	ret = REPLICATE ('', nb)
	FOR i=0L,nb-1 DO ret[i] = chiffre_to_str(x[i], format=format, opt=opt)
	RETURN, ret

END


;-------------------------------------------------------------------------------
FUNCTION val_to_str_1decimale,	$
;-------------------------------------------------------------------------------
	x	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Retourne une chaine de caractre reprsentant une valeur, avec une dcimale. Accepte les tableaux.
;-------------------------------------------------------------------------------

	nb = N_ELEMENTS(x)
	IF nb NE 1 THEN tabs = REPLICATE('', nb)
	FOR i=0L,nb-1 DO BEGIN
		IF ABS(x[i]) GE 1000000 THEN BEGIN
			; sinon trop de perte en prcision
			s = val_to_str(x[i])
		END ELSE BEGIN
			s = val_to_str(DOUBLE(LONG(x[i]*10.0+(x[i] GE 0 ? 0.5 : -0.5)))/10.0, /opt)
			IF STRPOS(s, '.') EQ -1 THEN s += '.'
			IF STRLEN(s) GE 1 THEN IF STRMID(s, STRLEN(s)-1, 1) EQ '.' THEN s += '0'
		END
		IF nb EQ 1 THEN RETURN, s
		tabs[i] = s
	END

	RETURN, tabs

END

;-------------------------------------------------------------------------------
FUNCTION val_to_str_2decimales,	$
;-------------------------------------------------------------------------------
	x	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Retourne une chaine de caractre reprsentant une valeur, avec deux dcimales. Accepte les tableaux.
;-------------------------------------------------------------------------------

	nb = N_ELEMENTS(x)
	IF nb NE 1 THEN tabs = REPLICATE('', nb)
	FOR i=0L,nb-1 DO BEGIN
		IF ABS(x[i]) GE 1000000 THEN BEGIN
			; sinon trop de perte en prcision
			s = val_to_str(x[i])
		END ELSE BEGIN
			s = val_to_str(DOUBLE(LONG(x[i]*100.0+(x[i] GE 0 ? 0.5 : -0.5)))/100.0, /opt)
			IF STRPOS(s, '.') EQ -1 THEN s += '.'
			IF STRLEN(s) GE 1 THEN IF STRMID(s, STRLEN(s)-1, 1) EQ '.' THEN s += '0'
			IF STRLEN(s) GE 2 THEN IF STRMID(s, STRLEN(s)-2, 1) EQ '.' THEN s += '0'
		END
		IF nb EQ 1 THEN RETURN, s
		tabs[i] = s
	END

	RETURN, tabs

END

;-------------------------------------------------------------------------------
FUNCTION chaine_contient,	$
;-------------------------------------------------------------------------------
	chaine,	$	; LINT_PROTOTYPE input
	souschaine	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((1:oui 0:non)) Retourne 1 si chaine contient souschaine, 0 sinon.
;-------------------------------------------------------------------------------

	RETURN, STRPOS(chaine, souschaine) NE -1

END

;-------------------------------------------------------------------------------
PRO remplacer,	$
;-------------------------------------------------------------------------------
	chaine,		$	; LINT_PROTOTYPE input
	motif1,		$	; LINT_PROTOTYPE input
	motif2,		$	; LINT_PROTOTYPE input
	DEBUT=DEBUT		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Remplace dans une chaine de caractres (ou un tableau de chaines) les occurences d'une sous chaine par une autre. Accepte les tableaux.
;
; Cherche dans chaine toutes les occurences de motif1 et les remplace pas motif2
;
; Entres:
; --------
;  - chaine:      (RW) chaine  analyser
;  - motif1:      (RO) motif  chercher
;  - motif2:      (RO) motif de substitution
;  - DEBUT=DEBUT: (RO) 1 pour ne remplacer que la premire occurence
;                      0 pour remplacer toutes les occurences
;
; Sorties:
; --------
;  - chaine: chaine modifie
;-------------------------------------------------------------------------------

	IF motif1 EQ '' THEN RETURN

	l1 = STRLEN(motif1)
	l2 = STRLEN(motif2)

	FOR i=0L, N_ELEMENTS(chaine)-1 DO BEGIN

		pos = 0L
		WHILE 1 DO BEGIN

			ou = STRPOS (chaine[i], motif1, pos)
			IF ou EQ -1 THEN BREAK

			chaine[i] = (ou EQ 0 ? '' : STRMID(chaine[i], 0, ou)) + motif2 + STRMID(chaine[i], ou+l1)
			pos = ou + l2
			IF KEYWORD_SET(DEBUT) THEN BREAK

		END

	END

END

;-------------------------------------------------------------------------------
FUNCTION htmlspecialchars_encode,               $
;-------------------------------------------------------------------------------
        valeur                  ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) Remplace les "&", """, "'", "<" et ">" en '&amp;', '&quot;', '&#039;', '&lt;' et '&gt;'.
;-------------------------------------------------------------------------------

	tmp = valeur

	remplacer, tmp, '&', '&amp;'
	remplacer, tmp, '"', '&quot;'
	remplacer, tmp, "'", '&#039;'
	remplacer, tmp, "<", '&lt;'
	remplacer, tmp, ">", '&gt;'

	RETURN, tmp

END

;-------------------------------------------------------------------------------
FUNCTION htmlspecialchars_decode,       $
;-------------------------------------------------------------------------------
        ligne1,                 $       ; LINT_PROTOTYPE input
        tooltip=tooltip                 ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) Remplace les '&gt;', '&lt;', '&#039;', '&quot;' et '&amp;' par '>', '<', "'", '"' et '&'.
;-------------------------------------------------------------------------------

	ligne2 = ligne1

	remplacer, ligne2, '&gt;', '>'
	remplacer, ligne2, '&lt;', '<'
	remplacer, ligne2, '&#039;', "'"
	remplacer, ligne2, '&quot;', '"'
	remplacer, ligne2, '&amp;', '&'

	IF KEYWORD_SET(tooltip) THEN BEGIN

		; Supprimer les tags <> car:
		; - ils ne sont pas interprts dans les Tooltips Title en HTML
		; - ils ne ne servent  rien dans les Tooltips IDL

		; => fvrier 2014: je laisse tomber ce traitement

	END

	RETURN, ligne2

END

;-------------------------------------------------------------------------------
FUNCTION int_str_,	$
;-------------------------------------------------------------------------------
	var,		$	; LINT_PROTOTYPE input
	dim			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Retourne une chaine de caractres reprsentant un entier sur dim caractres, complte par des blancs  gauche.
;
;   Entres:
;   --------
;    - var: entier que l'on veut crire sous forme de chaine de caractres
;    - dim: nombre de caracteres voulu dans la chaine
;
;   Retourne:
;   --------
;    Chaine de caractre contenant l'entier var sur dim caractres, cadre  droite et complte par des blancs  gauche.
;-------------------------------------------------------------------------------

	s = STRING (LONG(var))
	s1 = STRMID (s, STRLEN(s)-dim, dim)
	s2 = STRCOMPRESS (s1, /Remove_all)
	FOR i=0L,STRLEN(s1)-STRLEN(s2)-1 DO STRPUT, s1, ' ', i

	RETURN, s1

END

;-------------------------------------------------------------------------------
FUNCTION chaine_contient_debut,	$
;-------------------------------------------------------------------------------
	chaine,			$	; LINT_PROTOTYPE input
	souschaine			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((1:oui 0:non)) Retourne 1 si une chaine de caractres commence par une sous chaine de caractres particulire, 0 sinon.
;-------------------------------------------------------------------------------

	RETURN, STRMID(chaine, 0, STRLEN(souschaine)) EQ souschaine

END

;-------------------------------------------------------------------------------
FUNCTION chaine_contient_fin,	$
;-------------------------------------------------------------------------------
	chaine,			$	; LINT_PROTOTYPE input
	souschaine			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((1:oui 0:non)) Retourne 1 si une chaine de caractres se termine par une sous chaine de caractres particulire, 0 sinon.
;-------------------------------------------------------------------------------

	RETURN, STRMID(chaine, STRLEN(chaine)-STRLEN(souschaine), STRLEN(souschaine)) EQ souschaine

END

;-------------------------------------------------------------------------------
FUNCTION proteger_escape,	$
;-------------------------------------------------------------------------------
	s,			$	; LINT_PROTOTYPE input
	x				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Retourne une copie de s en insrant STRING(2b) devant chaque caractre x. Accepte les tableaux.
;-------------------------------------------------------------------------------

	s1 = s
	remplacer, s1, x, STRING(2b)+x

	RETURN, s1

END

;-------------------------------------------------------------------------------
FUNCTION chercher_commencepar_terminepar,	$
;-------------------------------------------------------------------------------
	noms,					$	; LINT_PROTOTYPE input
	debut,					$	; LINT_PROTOTYPE input
	fin						; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-1:null sinon:numro)) Retourne -1 ou le numro tel que noms[no] commence par debut et se termine par fin, fin ne devant pas tre prcd d'un chiffre.
;
; Ne fait pas la diffrence entre minsucule et majuscule.
;-------------------------------------------------------------------------------

	ind = WHERE (STRMID(STRUPCASE(noms), 0, STRLEN(debut)) EQ debut) ; debut trouv au dbut de noms ?
	IF ind[0] EQ -1 THEN RETURN, -1

	; Une ou plusieurs chaines commencent par debut.
	; Sortir ds qu'on en trouve une qui se termine par fin, non prcde 0..9

	FOR i=0L, N_ELEMENTS(ind)-1 DO BEGIN

		nom = noms[ind[i]]

		; se termine par fin ?
		IF STRMID(STRUPCASE(nom), STRLEN(nom)-STRLEN(fin)) NE fin THEN CONTINUE

		; caractre juste avant fin non compris dans 0..9 ?
		c1 = STRMID(STRUPCASE(nom), STRLEN(nom)-STRLEN(fin)-1, 1)
		IF c1 GE '0' AND c1 LE '9' THEN CONTINUE

		RETURN, ind[i]

	END

	RETURN, -1

END

;-------------------------------------------------------------------------------
FUNCTION string_to_data,	$
;-------------------------------------------------------------------------------
	x		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Dcoupe une chaine de caractres suivant le sparateur ','.
;-------------------------------------------------------------------------------

	RETURN, my_strsplit (x, ',') ; ne retourne pas toujours un tableau, contrairement  STRSPLIT

END

;-------------------------------------------------------------------------------
FUNCTION corriger_nomchamp,	$
;-------------------------------------------------------------------------------
	nom	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Retourne une copie d'une chaine de caractres, en modifiant si ncessaire certains caractres, pour qu'elle soit utilisable en tant que nom de champ de structure. Cod en C.
;-------------------------------------------------------------------------------

	IF is_fdl() THEN BEGIN
		nomcorrect = pchar('')
		lint_unused = CALL_EXTERNAL (libname('libascii'), 'CORRIGER_NOMCHAMP_AUTO_GLUE', nom, nomcorrect, /AUTO_GLUE)
		nomcorrect = STRING(nomcorrect)
	END ELSE BEGIN
		nomcorrect = ''
		lint_unused = CALL_EXTERNAL (libname('libascii'), 'CORRIGER_NOMCHAMP',           nom, nomcorrect)
	END

	RETURN, nomcorrect

END


;-------------------------------------------------------------------------------
FUNCTION my_strcompress,	$
;-------------------------------------------------------------------------------
	s	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Supprime les blancs en double et le blanc de dbut et de fin.
;
; Utiliser pour ne pas afficher de blanc au dbut d'un titre.
;-------------------------------------------------------------------------------

	RETURN, STRTRIM(STRCOMPRESS(s), 2)	; 2=dbut et fin

END

;-------------------------------------------------------------------------------
FUNCTION supprimer_quote_debut_fin,	$
;-------------------------------------------------------------------------------
	s	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Retourne une copie de la chaine en supprimant les " trouvs au dbut et  la fin.
;-------------------------------------------------------------------------------

	RETURN, STRMID(s, 0, 1) EQ '"' AND STRMID(s, STRLEN(s)-1, 1) EQ '"' ?  STRMID(s, 1, STRLEN(s)-2) : s

END

;-------------------------------------------------------------------------------
PRO ajouter_tabstring,	$
;-------------------------------------------------------------------------------
	tab,		$	; LINT_PROTOTYPE input
	val			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Rajoute une chaine de caractres  un tableau de chaine de caractres.
;
; Ajoute la chaine val au tableau de strings tab
;-------------------------------------------------------------------------------

	tab = tab[0] EQ '' ? val : [tab, val]

END

;-------------------------------------------------------------------------------
FUNCTION data_to_cef,	$
;-------------------------------------------------------------------------------
	x	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Retourne une chaine de caractres avec toutes les valeurs du tableau x crites avec 2 dcimales, spares par ','.
;-------------------------------------------------------------------------------

	nb = N_ELEMENTS(x)
	s = ''
	FOR i=0L,nb-1 DO s += val_to_str_2decimales(x[i]) + (i NE nb-1 ? ', ' : '')
	RETURN, s

END

;-------------------------------------------------------------------------------
FUNCTION modif_thunderbird,	$
;-------------------------------------------------------------------------------
	s	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Retourne une copie de s en remplacant "http://" par "http//".
; 
; Si un mail contient des liens avec "http://", thundebird passe beaucoup de temps  les analyser
; En transformant "http://" par "http//" il n'y a plus de problmes
;-------------------------------------------------------------------------------

	RETURN, STRMID(s, 0, 7) EQ 'http://' ? STRMID(s, 0, 4) + STRMID(s, 5) : s

END

;-------------------------------------------------------------------------------
FUNCTION supprimer_tags,	$
;-------------------------------------------------------------------------------
	s1	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Retourne une copie d'une chaine en supprimant tout les tags qui se trouvent entre '<' et '>'.
;
; Utilis dans themispro/file_http_copy pour rcuprer la date et la taille des liens
;
; si s1 vaut "</a></td><td align="right">19-Jun-2009 11:54  </td><td align="right">718K</td></tr>" alors
; 
; => la fonction retourne "19-Jun-2009 11:54  718K"
;-------------------------------------------------------------------------------

	s2 = ''
	len = STRLEN(s1)
	inside = 0
	last_car = ''
	FOR i=0L,len-1 DO BEGIN
		car = STRMID(s1, i, 1)
		IF ~inside THEN inside = car EQ '<'
		IF inside THEN BEGIN
			IF car EQ '>' THEN inside = 0
		END ELSE BEGIN
			IF last_car EQ '>' THEN s2 += ' ' ; un blanc pour que les champs ne soient pas colls les uns aux autres
			s2 += car
		END
		last_car = car
	END

	RETURN, s2

END


;-------------------------------------------------------------------------------
FUNCTION get_tag,	$
;-------------------------------------------------------------------------------
	s,		$	; LINT_PROTOTYPE input
	tag			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Retourne ce qui se trouve dans un STRING entre <tag> et </tag>, ou "" si le tag n'existe pas
;-------------------------------------------------------------------------------

	MOTIF1 = '<' + tag + '>'
	MOTIF2 = '</' + tag + '>'

	pos1 = STRPOS(s, MOTIF1)
	pos2 = STRPOS(s, MOTIF2)
	IF pos1 NE -1 AND pos2 NE -1 THEN BEGIN
		RETURN, STRMID(STRMID(s, 0, pos2), pos1+STRLEN(MOTIF1))
	END ELSE BEGIN
		RETURN, ''
	END

END


;-------------------------------------------------------------------------------
FUNCTION afficher_http,	$
;-------------------------------------------------------------------------------
	nom	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Si nom est de la forme "http://site/.../.../nom" alors retourne "(http://site) nom".
;
; Sinon retourne nom
;-------------------------------------------------------------------------------

	IF STRMID(nom, 0, 7) EQ 'http://' THEN BEGIN
		tmp = STRSPLIT(nom, '/', /EXTRACT)
		RETURN, '(http://' + tmp[1] + ') ' + tmp[N_ELEMENTS(tmp)-1]
	END ELSE BEGIN
		RETURN, nom
	END

END

;-------------------------------------------------------------------------------
FUNCTION enlever_slash_fin,	$
;-------------------------------------------------------------------------------
	nom	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Retourne un copie d'un nom de fichier aprs suppression des '/' et '\' trouv  la fin.
;-------------------------------------------------------------------------------

	len = STRLEN(nom)
	IF len GE 1 THEN BEGIN
		IF STRMID(nom, len-1, 1) EQ '/' OR STRMID(nom, len-1, 1) EQ '\' THEN BEGIN
			RETURN, enlever_slash_fin(STRMID(nom, 0, len-1))
		END
	END

	RETURN, nom

END

;-------------------------------------------------------------------------------
FUNCTION rajouter_slash_fin,	$
;-------------------------------------------------------------------------------
	rep	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (STRING) ((-)) Retourne une copie d'un nom de fichier aprs rajout si ncessaire de '/'  la fin.
;-------------------------------------------------------------------------------

	RETURN, STRMID(rep, STRLEN(rep)-1, 1) NE '/' ?  rep+'/' : rep

END

;-------------------------------------------------------------------------------
FUNCTION is_string,	$
;-------------------------------------------------------------------------------
	x	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((1:oui 0:non)) Retourne 1 si l'argument est une chaine de caractres, 0 sinon.
;-------------------------------------------------------------------------------

	info = SIZE (x)
	RETURN, info[N_ELEMENTS(info)-2] EQ 7

END


;-------------------------------------------------------------------------------
FUNCTION is_number,	$
;-------------------------------------------------------------------------------
	x	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((1:oui 0:non)) Retourne 1 si l'argument est un chiffre entier, 0 sinon.
;
; Ne marche pas trs bien mais ca me suffit.
;-------------------------------------------------------------------------------

	ON_IOERROR, error

	IF is_string(x) THEN BEGIN
		IF x EQ '' THEN RETURN, 0
	END

	y = LONG (x)

	RETURN, y EQ x


error:

	RETURN, 0

END

;-------------------------------------------------------------------------------
FUNCTION my_obj_valid,	$
;-------------------------------------------------------------------------------
	x	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((1:oui 0:non)) Retourne 1 si l'argument est un objet valide, 0 sinon.
;-------------------------------------------------------------------------------

	CATCH, error

	IF error NE 0 THEN BEGIN
		RETURN, 0
	END

	; plante sous fdl si x vaut -1
	RETURN, OBJ_VALID(x)

END


;-------------------------------------------------------------------------------
FUNCTION is_byte,	$
;-------------------------------------------------------------------------------
	x	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((1:oui 0:non)) Retourne 1 si l'argument est de type BYTE, 0 sinon.
;-------------------------------------------------------------------------------

	info = SIZE (x)
	RETURN, info[N_ELEMENTS(info)-2] EQ 1

END


;-------------------------------------------------------------------------------
FUNCTION is_int,	$
;-------------------------------------------------------------------------------
	x	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((1:oui 0:non)) Retourne 1 si l'argument est de type INT, 0 sinon.
;-------------------------------------------------------------------------------

	info = SIZE (x)
	RETURN, info[N_ELEMENTS(info)-2] EQ 2 OR info[N_ELEMENTS(info)-2] EQ 12

END


;-------------------------------------------------------------------------------
FUNCTION is_long,	$
;-------------------------------------------------------------------------------
	x	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((1:oui 0:non)) Retourne 1 si l'argument est de type LONG, 0 sinon.
;-------------------------------------------------------------------------------

	info = SIZE (x)
	RETURN, info[N_ELEMENTS(info)-2] EQ 3 OR info[N_ELEMENTS(info)-2] EQ 13

END


;-------------------------------------------------------------------------------
FUNCTION is_float,	$
;-------------------------------------------------------------------------------
	x	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((1:oui 0:non)) Retourne 1 si l'argument est de type FLOAT, 0 sinon.
;-------------------------------------------------------------------------------

	info = SIZE (x)
	RETURN, info[N_ELEMENTS(info)-2] EQ 4

END

;-------------------------------------------------------------------------------
FUNCTION is_double,	$
;-------------------------------------------------------------------------------
	x	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((1:oui 0:non)) Retourne 1 si l'argument est de type DOUBLE, 0 sinon.
;-------------------------------------------------------------------------------

	info = SIZE (x)
	RETURN, info[N_ELEMENTS(info)-2] EQ 5

END


;-------------------------------------------------------------------------------
FUNCTION is_structure,	$
;-------------------------------------------------------------------------------
	x			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((1:oui 0:non)) Retourne 1 si l'argument est une structure, 0 sinon.
;-------------------------------------------------------------------------------

	info = SIZE (x)
	RETURN, info[N_ELEMENTS(info)-2] EQ 8

END

;-------------------------------------------------------------------------------
PRO ajouter_champ,	$
;-------------------------------------------------------------------------------
	s,		$	; LINT_PROTOTYPE input
	val,		$	; LINT_PROTOTYPE input
	nom,		$	; LINT_PROTOTYPE output
	enreg,		$	; LINT_PROTOTYPE output
	taille,		$	; LINT_PROTOTYPE output
	first=first		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((-)) Ajoute un champ  une structure et retourne la structure, les noms et les tailles des champs.
;-------------------------------------------------------------------------------

	champ = corriger_nomchamp (s)

	IF KEYWORD_SET(first) THEN BEGIN
		nom = [champ]
		taille = 0L
		enreg = CREATE_STRUCT (champ, val)
	END ELSE BEGIN
		; Le champ que l'on veut rajouter  la structure existe t-il dja ?
		; Si oui, on rajoute '_' au champ autant de fois que ncessaire.
		REPEAT BEGIN
			ind = WHERE (STRUPCASE(nom) EQ STRUPCASE(champ))
			IF ind[0] NE -1 THEN champ += '_'
		END UNTIL ind[0] EQ -1
		nom = [nom,champ]
		enreg = CREATE_STRUCT (enreg, champ, val)
	END
	info = SIZE(val)
	CASE info[N_ELEMENTS(info)-2] OF
		 1:	nb =  1	; Byte
		 2:	nb =  2	; Integer
		 3:	nb =  4	; Longword integer
		 4:	nb =  4	; Floating point
		 5:	nb =  8	; Double-precision floating
		 7:	nb = 16	; String comment estimer la taille d'un string ?
		12:	nb =  2	; Unsigned integer
		13:	nb =  4	; Unsigned Longword integer
		14:	nb =  8	; 64-bit integer
		15:	nb =  8	; Unsigned 64-bit integer
	END
	taille += nb * info[N_ELEMENTS(info)-1]

	;IF s NE champ THEN PRINT,'WARNING: renaming field '+s+' to '+champ+' !'

END

;-------------------------------------------------------------------------------
PRO ajouter_champs,	$
;-------------------------------------------------------------------------------
	s,		$	; LINT_PROTOTYPE input
	val,		$	; LINT_PROTOTYPE input
	nom,		$	; LINT_PROTOTYPE output
	enreg,		$	; LINT_PROTOTYPE output
	taille,		$	; LINT_PROTOTYPE output
	first=first		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((-)) Ajoute plusieurs champs  une structure et retourne la structure, les noms et les tailles des champs.
;-------------------------------------------------------------------------------

	nbchamps = N_ELEMENTS(s)
	first_small = 1
	first_enreg = KEYWORD_SET(first) ? 1 : 0
	FOR i=0L,nbchamps-1 DO BEGIN
		ajouter_champ, s[i], val, nom1, small, taille1, first=first_small
		IF (i+1) MOD 100 EQ 0 THEN BEGIN
			enreg  = first_enreg ? CREATE_STRUCT (small) : CREATE_STRUCT (enreg, small)
			nom    = first_enreg ? nom1 : [ nom , nom1 ]
			taille = first_enreg ? taille1 : (taille+taille1)
			first_small = 1
			first_enreg = 0
		END ELSE BEGIN
			first_small = 0
		END
	END
	IF first_small EQ 0 THEN BEGIN
		enreg  = first_enreg ? CREATE_STRUCT (small) : CREATE_STRUCT (enreg, small)
		nom    = first_enreg ? nom1 : [ nom , nom1 ]
		taille = first_enreg ? taille1 : (taille+taille1)
	END

END

;-------------------------------------------------------------------------------
FUNCTION codage_elt_structure,	$
;-------------------------------------------------------------------------------
	elt		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) Retourne une valeur de l'lment dont le codage binaire ne contiendra que des valeurs non nulles
;-------------------------------------------------------------------------------

	IF is_double(elt) THEN BEGIN
		RETURN, 1.79d308
	END ELSE IF is_float(elt) THEN BEGIN
		RETURN, 3.4e38
	END ELSE IF is_long(elt) THEN BEGIN
		RETURN, 1L + 256L + 256L*256L + 256L*256L*256L
	END ELSE IF is_int(elt) THEN BEGIN
		RETURN, 1L + 256L
	END ELSE IF is_byte(elt) THEN BEGIN
		RETURN, 1L
	END

END

;-------------------------------------------------------------------------------
FUNCTION tableaux_nonidem,	$
;-------------------------------------------------------------------------------
	t1,			$	; LINT_PROTOTYPE input
	t2				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((1:nonidem 0:idem)) Retourne 1 si deux tableaux sont diffrents, 0 sinon.
;-------------------------------------------------------------------------------

	dim_t1 = N_ELEMENTS(t1)
	dim_t2 = N_ELEMENTS(t2)
	changement = dim_t1 NE dim_t2
	IF ~changement THEN BEGIN
		lint_unused = WHERE(t1 NE t2, changement)
		changement = changement NE 0
	END

	RETURN, changement

END

;-------------------------------------------------------------------------------
FUNCTION tableaux_idem,	$
;-------------------------------------------------------------------------------
	t1,			$	; LINT_PROTOTYPE input
	t2				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((1:idem 0:nonidem)) Retourne 1 si deux tableaux sont identiques, 0 sinon.
;-------------------------------------------------------------------------------

	RETURN, 1 - tableaux_nonidem (t1, t2)

END

;-------------------------------------------------------------------------------
FUNCTION get_structure_infos,	$
;-------------------------------------------------------------------------------
	enreg,		$	; LINT_PROTOTYPE input
	taille_enreg,	$	; LINT_PROTOTYPE output
	nbchamps,	$	; LINT_PROTOTYPE output
	nom_champ,	$	; LINT_PROTOTYPE output
	type_champ,	$	; LINT_PROTOTYPE output
	offset_champ,	$	; LINT_PROTOTYPE output
	taille_champ,	$	; LINT_PROTOTYPE output
	nb_champ		; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (TYPE) ((1:ok 0:pb)) Retourne des informations sur une structure, permettant une utilisation de cette structure en langage C.
;
; Entres: 
; -------
; - enreg: structure IDL
;
; Sorties:
; -------
; - taille_enreg:	(LONG) nombre d'octets qu'occupe la structure en mmoire
; - nbchamps:		(LONG) nombre de champs dans la structure
; - nom_champ:		(STRING) tableau de noms des champs contenus dans la structure
; - type_champ:		(LONG) tableau de code donnant le type des champs contenus dans la structure:
;				 1:	Byte
;				 2:	Integer
;				 3:	Longword integer
;				 4:	Floating point
;				 5:	Double-precision floating
;				 7:	String
;				12:	Unsigned integer
;				13:	Unsigned Longword integer
;				14:	64-bit integer
;				15:	Unsigned 64-bit integer
; - offset_champ	(LONG) tableau de position du 1er octet de chaque champ dans la structure
; - taille_champ	(LONG) tableau du nombre d'octets occup par chaque champ dans la structure
; - nb_champ		(LONG) tableau du nombre d'lments de chaque champ dans la structure
;
; Retourne:
; --------
;  1:			si la structure ne contient pas de champ de type inconnu et peut donc tre lue en C
;  0:			si la structure contient au moins un champ de type inconnu et ne peut donc pas tre lue en C
;-------------------------------------------------------------------------------

	DEBUG = 0
	IF DEBUG THEN top1 = nbsec()

	taille_enreg 	= get_structure_length (enreg)
	IF taille_enreg EQ 0 THEN RETURN, 0
	offset_enreg	= get_structure_offsets (enreg)
	nbchamps 	= N_TAGS (enreg)
	nom_champ 	= TAG_NAMES (enreg)
	type_champ 	= REPLICATE (0L, nbchamps)
	offset_champ	= REPLICATE (0L, nbchamps)
	taille_champ	= REPLICATE (0L, nbchamps)
	nb_champ 	= REPLICATE (0L, nbchamps)

	FOR nochamp=0L,nbchamps-1 DO BEGIN

		tmp = SIZE (enreg.(nochamp))
		; tmp contient le nombre de dimension puis la taille de chaque dimension puis le code type puis le nombre d'lments

		typecode = tmp[0]+1
		type = tmp[typecode]
		CASE type OF
			 1:	taille_champ[nochamp] =  1	; Byte
			 2:	taille_champ[nochamp] =  2	; Integer
			 3:	taille_champ[nochamp] =  4	; Longword integer
			 4:	taille_champ[nochamp] =  4	; Floating point
			 5:	taille_champ[nochamp] =  8	; Double-precision floating
			 7:	taille_champ[nochamp] = is_fdl() ? 32 : 16	; String
			12:	taille_champ[nochamp] =  2	; Unsigned integer
			13:	taille_champ[nochamp] =  4	; Unsigned Longword integer
			14:	taille_champ[nochamp] =  8	; 64-bit integer
			15:	taille_champ[nochamp] =  8	; Unsigned 64-bit integer
			ELSE:	RETURN, 0			; Lecture en C impossible
		END
		type_champ[nochamp] = tmp[typecode]
		nb_champ[nochamp] = tmp[typecode+1]

		tmp = enreg

;		IF type EQ 7 THEN BEGIN
;
;			; String
;			x = "n'importe qu'elle chaine de caractre..."
;			; Codage du champ  x
;			tmp.(nochamp)[0] = x
;			offset_champ[nochamp] = CALL_EXTERNAL (libname('util'), 'GET_STRUCTURE_DEBUT_STRING', tmp, taille_enreg, x)
;
;		END ELSE BEGIN
;
;			; Codage de tous les octets  0
;			lint_unused = CALL_EXTERNAL (libname('util'), 'PUT_STRUCTURE', tmp, taille_enreg, 0L)
;
;			; Codage du champ
;			tmp.(nochamp)[0] = codage_elt_structure (tmp.(nochamp)[0])
;
;			; Recherche
;			offset_champ[nochamp] = CALL_EXTERNAL (libname('util'), 'GET_STRUCTURE_DEBUT', tmp, taille_enreg)
;
;			; Restauration des valeurs initiales sinon IDL n'aime pas que l'on laisse  1 tous les octets d'un string
;			lint_unused = CALL_EXTERNAL (libname('util'), 'PUT_STRUCTURE', tmp, taille_enreg, -1L)
;		END

	END

;	IF ~tableaux_idem(offset_champ,offset_enreg) THEN stop

	offset_champ = offset_enreg

	IF DEBUG THEN top2 = nbsec()
	IF DEBUG THEN PRINT, 'get_structure_infos en '+val_to_str(top2-top1)+' sec'

	RETURN, 1

END


;-------------------------------------------------------------------------------
FUNCTION check_dims,	$
;-------------------------------------------------------------------------------
	msg,		$	; LINT_PROTOTYPE input
	tableau,	$	; LINT_PROTOTYPE input
	dims			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((-)) ((1:idem 0:nonidem)) Retourne 1 si le tableau a les dimensions dims, 0 sinon.
;-------------------------------------------------------------------------------

	PRINT, msg

	IF tableaux_idem (tableau, dims) THEN RETURN, 1

	; Supprimer les dimensions  1  la fin de dims
	WHILE 1 DO BEGIN
		nbdims = SIZE(dims, /DIMENSIONS)
		IF nbdims EQ 3 && dims[2] EQ 1 THEN  BEGIN
			dims = dims[0:1]
		END ELSE IF nbdims EQ 2 && dims[1] EQ 1 THEN BEGIN
			dims = dims[0]
		END ELSE BEGIN
			BREAK
		END
	END

	RETURN, tableaux_idem (tableau, dims)

END

;-------------------------------------------------------------------------------
FUNCTION get_structure_offset,	$
;-------------------------------------------------------------------------------
	enreg,			$	; LINT_PROTOTYPE input
	nom=nom,		$	; LINT_PROTOTYPE input
	numero=numero				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; ((-)) Renvoie l'offset d'un champ de structure (d'aprs son nom ou son numro)
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(nom) NE 0 THEN BEGIN
		names = TAG_NAMES(enreg)
		numero = (WHERE (names EQ STRUPCASE(nom)))[0]
	END

	IF get_structure_infos (enreg[0], taille_enreg, nbchamps, nom_champ, type_champ, offset_champ, taille_champ, nb_champ) EQ 0 THEN RETURN, 0

	RETURN, offset_champ[numero]

END

;-------------------------------------------------------------------------------
FUNCTION get_typeval,	$
;-------------------------------------------------------------------------------
	typeascii			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((-)) Retourne une constante IDL du type C spcifi en argument.
;-------------------------------------------------------------------------------

	CASE typeascii OF
		'unsigned char':	RETURN, 0b
		'short':		RETURN, 0
		'int':			RETURN, 0L
		'float':		RETURN, 0.
		'double':		RETURN, 0d
		'unsigned short':	RETURN, 0U
		'unsigned int':		RETURN, 0UL
		'long long int':	RETURN, 0LL
		'string':		RETURN, ''
	END

END

;-------------------------------------------------------------------------------
FUNCTION type_to_val,	$
;-------------------------------------------------------------------------------
	type	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((-)) Retourne une valeur du type IDL fourni en argument.
;-------------------------------------------------------------------------------

	CASE type OF
		 1:	val = BYTE(0)		; Byte
		 2:	val = FIX(0)		; Integer
		 3:	val = LONG(0)		; Longword integer
		 4:	val = FLOAT(0)		; Floating point
		 5:	val = DOUBLE(0)		; Double-precision floating
		 7:	val = ''		; String
		12:	val = UINT(0)		; Unsigned integer
		13:	val = ULONG(0)		; Unsigned Longword integer
		14:	val = LONG64(0)		; 64-bit Integer
		15:	val = ULONG64(0)	; Unsigned 64-bit Integer
	END

	RETURN, val

END

;-------------------------------------------------------------------------------
FUNCTION compress_struct,	$
;-------------------------------------------------------------------------------
	struct	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((-)) Retourne une chaine de caractres contenant la dfinition d'une structure.
;
; Entres: 
; -------
;  - struct: structure  compresser
;
; Retourne une chaine de caractre reprsentant cette structure sous forme compresse
; avec pour chaque champ le nom, les dimensions et la valeur 
;
; Utile pour les structures contenant les coups non compresss de IMA
;-------------------------------------------------------------------------------

	noms = TAG_NAMES(struct)
	nb = N_ELEMENTS(noms)
	info = ''
	FOR i=0L,nb-1 DO BEGIN
		IF i NE 0 THEN info += ' '
		info += noms[i]
		tmp = SIZE(struct.(i))
		nbdims = tmp[0]
		info += ' '+val_to_str(nbdims)
		FOR j=0L,nbdims DO info += ' '+val_to_str(tmp[j+1])
	END

	RETURN, info

END

;-------------------------------------------------------------------------------
FUNCTION valnbdimsdims_to_tab,	$
;-------------------------------------------------------------------------------
	val,	$	; LINT_PROTOTYPE input
	nbdims,	$	; LINT_PROTOTYPE input
	dims		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((-)) Retourne un tableau rempli de val, dont les dimensions sont donnes dans le tableau dims.
;-------------------------------------------------------------------------------

	IF nbdims EQ 0 THEN RETURN, val
	IF nbdims EQ 1 THEN RETURN, REPLICATE (val, dims[0])
	IF nbdims EQ 2 THEN RETURN, REPLICATE (val, dims[0], dims[1])
	IF nbdims EQ 3 THEN RETURN, REPLICATE (val, dims[0], dims[1], dims[2])
	IF nbdims EQ 4 THEN RETURN, REPLICATE (val, dims[0], dims[1], dims[2], dims[3])
	IF nbdims EQ 5 THEN RETURN, REPLICATE (val, dims[0], dims[1], dims[2], dims[3], dims[4])
	IF nbdims EQ 6 THEN RETURN, REPLICATE (val, dims[0], dims[1], dims[2], dims[3], dims[4], dims[5])
	IF nbdims EQ 7 THEN RETURN, REPLICATE (val, dims[0], dims[1], dims[2], dims[3], dims[4], dims[5], dims[6])
	IF nbdims EQ 8 THEN RETURN, REPLICATE (val, dims[0], dims[1], dims[2], dims[3], dims[4], dims[5], dims[6], dims[7])

END


;-------------------------------------------------------------------------------
FUNCTION uncompress_struct,	$
;-------------------------------------------------------------------------------
	info	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((-)) Retourne la structure correspondant  une dfinition donn sous forme de chaine de caractres.
;
; Entres:
; -------
;  - info: representation sous forme compresse de la structure
;
; Retourne la structure.
;
; Utile pour les structures contenant les coups non compresss de IMA
;-------------------------------------------------------------------------------

	dims = REPLICATE(0L, 8)

	tmp = STRSPLIT(info, /EXTRACT)
	nb = N_ELEMENTS(tmp)

	i = 0L
	first = 1
	REPEAT BEGIN
		nom = tmp[i]
		i++
		nbdims = tmp[i]
		i++
		FOR j=0L,nbdims-1 DO BEGIN
			dims[j] = tmp[i]
			i++
		END
		type = LONG(tmp[i])
		val = type_to_val(type)
		tab_val = valnbdimsdims_to_tab (val, nbdims, dims)

		IF first THEN BEGIN
			struct = CREATE_STRUCT (nom, tab_val)
			first = 0
		END ELSE BEGIN
			struct = CREATE_STRUCT (struct, nom, tab_val)
		END
		
		i++
	END UNTIL i EQ nb

	RETURN, struct

END

;-------------------------------------------------------------------------------
FUNCTION structures_idem,	$
;-------------------------------------------------------------------------------
	s1,	$	; LINT_PROTOTYPE input
	s2		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (TYPE) ((1:idem 0:nonidem)) Retourne 1 si deux structures sont identiques, 0 sinon. Accepte les tableaux de structures.
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(s1) NE N_ELEMENTS(s2) THEN RETURN, 0

	NAMES1 = TAG_NAMES(s1)
	NAMES2 = TAG_NAMES(s2)
	IF N_ELEMENTS(NAMES1) NE N_ELEMENTS(NAMES2) THEN RETURN, 0

	FOR i=0L,N_ELEMENTS(NAMES1)-1 DO BEGIN
		IF NAMES1[i] NE NAMES2[i] THEN RETURN, 0
	END

	code = 1
	FOR i=0L,N_ELEMENTS(s1)-1 DO BEGIN

		FOR j=0L,N_ELEMENTS(NAMES1)-1 DO BEGIN

			IF N_ELEMENTS(s1[i].(j)) GT 1 THEN BEGIN
				IF tableaux_idem(s1[i].(j), s2[i].(j)) EQ 0 THEN BEGIN
					code = 0
				END
			END ELSE IF s1[i].(j) NE s2[i].(j) THEN BEGIN
				PRINT, 's1[' + val_to_str(i) + '].' + NAMES1[j] + ' = ' + val_to_str(s1[i].(j))
				PRINT, 's2[' + val_to_str(i) + '].' + NAMES1[j] + ' = ' + val_to_str(s2[i].(j))
				code = 0
			END

		END
	END

	RETURN, code

END

;-------------------------------------------------------------------------------
PRO creer_structure_quick,	$
;-------------------------------------------------------------------------------
	noms,			$	; LINT_PROTOTYPE input
	types,			$	; LINT_PROTOTYPE input
	nom,			$	; LINT_PROTOTYPE output
	enreg,			$	; LINT_PROTOTYPE output
	taille				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (TYPE) ((-)) Cr une structure  partir de noms et types et retourne la structure, les noms et les tailles des champs.
;-------------------------------------------------------------------------------

	; Quand on rajoute les champs ENERGY_TABLE_1, ENERGY_TABLE_2, ... ca devient de plus en plus lent, surout avec gdl
	; L'ide est de crer une structure small avec tous les champs ENERGY_TABLE_* puis de faire enreg = CREATE_STRUCT (enreg, small)

	debut = 0L
	nb = N_ELEMENTS(noms)
	FOR i=0L, nb-1 DO BEGIN
		IF i NE nb-1 && types[i+1] EQ types[i] THEN BEGIN
		END ELSE BEGIN
			IF debut EQ i THEN BEGIN
				ajouter_champ,  noms[i],       get_typeval(types[i]), nom, enreg, taille, FIRST=debut EQ 0
			END ELSE BEGIN
				ajouter_champs, noms[debut:i], get_typeval(types[i]), nom, enreg, taille, FIRST=debut EQ 0
			END
			debut = i+1
		END
	END

END


;-------------------------------------------------------------------------------
FUNCTION moyen,	$
;-------------------------------------------------------------------------------
	tab,		$	; LINT_PROTOTYPE input
	FILLVAL=FILLVAL		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MATH) ((-)) Retourne la valeur moyenne des lments d'un tableau.
;
; MEAN fait la mme chose, mais fait des calculs inutiles, donc je prfre garder cette fonction qui doit tre plus rapide.
;-------------------------------------------------------------------------------

	IF KEYWORD_SET(FILLVAL) THEN BEGIN
		ind = WHERE (tab EQ FILLVAL)
		IF ind[0] NE -1 THEN RETURN, FILLVAL
	END

	RETURN, TOTAL(tab)/N_ELEMENTS(tab)

END

;-------------------------------------------------------------------------------
FUNCTION module_v1,	$
;-------------------------------------------------------------------------------
	V1			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MATH) ((-)) Retourne le module d'un vecteur.
;-------------------------------------------------------------------------------

	RETURN, SQRT(V1[0]*V1[0] + V1[1]*V1[1] + V1[2]*V1[2])

END


;-------------------------------------------------------------------------------
FUNCTION module,	$
;-------------------------------------------------------------------------------
	X,		$	; LINT_PROTOTYPE input
	Y,		$	; LINT_PROTOTYPE input
	Z			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MATH) ((-)) Retourne le module d'un vecteur  partir de ces 3 composantes.
;-------------------------------------------------------------------------------

	RETURN, SQRT(X*X + Y*Y + Z*Z)

END


;-------------------------------------------------------------------------------
FUNCTION v1_vectoriel_v2,	$
;-------------------------------------------------------------------------------
	V1,			$	; LINT_PROTOTYPE input
	V2				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MATH) ((-)) Retourne le produit vectoriel de 2 vecteurs.
;-------------------------------------------------------------------------------

	RETURN, [V1[1]*V2[2]-V1[2]*V2[1], V1[2]*V2[0]-V1[0]*V2[2], V1[0]*V2[1]-V1[1]*V2[0]]

END


;-------------------------------------------------------------------------------
FUNCTION produit_scalaire_v1_v2,	$
;-------------------------------------------------------------------------------
	V1,				$	; LINT_PROTOTYPE input
	V2					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MATH) ((-)) Retourne le produit scalaire de 2 vecteurs.
;-------------------------------------------------------------------------------

	RETURN, V1[0]*V2[0] + V1[1]*V2[1] + V1[2]*V2[2]

END

;-------------------------------------------------------------------------------
FUNCTION my_ludcmp,	$
;-------------------------------------------------------------------------------
	A,		$	; LINT_PROTOTYPE input
	N,		$	; LINT_PROTOTYPE input
	INDX,		$	; LINT_PROTOTYPE output
	D			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (MATH) ((1:ok 0:pb)) Retourne la "LU dcomposition" d'une matrice en utilisant une copie en IDL de la routine FORTRAN ludcmp() de Numerical recipies.
;
; Retourne 1 si OK, 0 si PB.
; 
; Entres:
; -------
;  - A: (RW) matrice[1..N,1..N]
;  - N: (RO) dimension de la matrice
;
; Sorties:
; -------
;  - A:    matrice[1..N,1..N] modifie
;  - INDX: vecteur[1..N] output vector that records the row permutation effected by the partial pivoting
;  - D:    1 ou -1 indicateur si le nombre de lignes perumutes est pair ou impair
;-------------------------------------------------------------------------------

; Codage en IDL de la routine FORTRAN de Numerical Recipies disponible sur Internet

	INDX = REPLICATE (0L, N+1)

	TINY = 1.0E-20
	VV = REPLICATE (0d, N+1)

	D = 1d
	FOR I=1L,N DO BEGIN ;12
		AAMAX = 0d
		FOR J=1L,N DO BEGIN ; 11
			IF ABS(A[I,J]) GT AAMAX THEN AAMAX = ABS(A[I,J])
		END ; 11
		IF AAMAX EQ 0 THEN RETURN, 0
		VV[I] = 1d/AAMAX
	END ; 12

	FOR J=1L,N DO BEGIN ; 19
		FOR I=1L,J-1 DO BEGIN ; 14
			SUM = A[I,J]
			FOR K=1L,I-1 DO BEGIN ; 13
				SUM -= A[I,K]*A[K,J]
			END ; 13
			A[I,J] = SUM
		END ; 14
		AAMAX = 0d
		FOR I=J,N DO BEGIN ; 16
			SUM = A[I,J]
			FOR K=1L,J-1 DO BEGIN ; 15
				SUM -= A[I,K]*A[K,J]
			END ; 15
			A[I,J] = SUM
			DUM = VV[I]*ABS(SUM)
			IF DUM GE AAMAX THEN BEGIN
				IMAX = I
				AAMAX = DUM
			END
		END ; 16
		IF J NE IMAX THEN BEGIN
			FOR K=1L,N DO BEGIN ; 17
				DUM = A[IMAX,K]
				A[IMAX,K] = A[J,K]
				A[J,K] = DUM
			END ; 17
			D = -D
			VV[IMAX] = VV[J]
		END
		INDX[J] = IMAX
		IF A[J,J] EQ 0 THEN A[J,J] = TINY
		IF J NE N THEN BEGIN
			DUM = 1d/A[J,J]
			FOR I=J+1,N DO BEGIN ; 18
				A[I,J] *= DUM
			END ; 18
		END
	END ; 19

	RETURN, 1
END


;-------------------------------------------------------------------------------
FUNCTION ludcmp_v1_v2,	$
;-------------------------------------------------------------------------------
	U,		$	; LINT_PROTOTYPE input
	V,		$	; LINT_PROTOTYPE input
	Aorg,		$	; LINT_PROTOTYPE output
	A,		$	; LINT_PROTOTYPE output
	INDX			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (MATH) ((1:ok 0:pb)) Retourne la "LU dcomposition" de la matrice (U/normU,V/normV,(U/normU)^(V/normV)).
;
; Retourne 1 si OK, 0 si PB.
;
; Entres:
; -------
;  - U: vecteur avec 3 composantes
;  - V: vecteur avec 3 composantes
;
; Sorties:
; -------
;  - Aorg: matrice[4,4] avec Aorg[1:3,1]=U/module(U), Aorg[1:3,2]=V/module(V), Aorg[1:3,3]=(U/module(U))^(V/module(V))
;  - A:    matrice Aorg aprs appel  my_ludcmp
;  - INDX: vecteur INDX aprs appel  my_ludcmp
;-------------------------------------------------------------------------------

	modU = module_v1(U)			; module de U
	modV = module_v1(V)			; module de V
	UV   = produit_scalaire_v1_v2(U, V)	; produit scalaire U.V

	IF modU EQ 0 OR modV EQ 0 OR UV EQ modU*modV THEN RETURN, 0

	TA = [ [U/modU], [V/modV], [v1_vectoriel_v2(U/modU, V/modV)] ]

	A = REPLICATE (0d, 4, 4)
	A[1:3,1:3] = TA	; passage [0..2,0..2] vers [1..3,1..3] pour my_ludcmp
	
	Aorg = A
	code = my_ludcmp (A, 3, INDX, D)

	; exemple avec une fonction de distribution CODIF H+ (Vperp1,Vpar), B  1 sec, le 30/09/2002 09:57:27

	; en entre U vaut
	;IDL> print,u
     	;-113.771      1.87281     -379.948

	; en entre V vaut:
	;IDL> print,v
     	;-20.9494      9.63101      6.32051

	; Aorg vaut:
	;IDL> print,Aorg
       	;0.0000000       0.0000000       0.0000000       0.0000000
       	;0.0000000     -0.28685084    0.0047219233     -0.95796359
       	;0.0000000     -0.87625778      0.40284038      0.26437068
       	;0.0000000      0.38715473      0.91525799     -0.11141748

	; A vaut:
	;IDL> print,A  
       	;0.0000000       0.0000000       0.0000000       0.0000000
       	;0.0000000     -0.95796359      0.29943815   -0.0049291260
       	;0.0000000      0.26437068     -0.95542044     -0.42300067
       	;0.0000000     -0.11141748      0.42051737       1.0925879

	RETURN, code

END

;-------------------------------------------------------------------------------
PRO moyenner_vecteur,	$
;-------------------------------------------------------------------------------
	tabtdeb,	$	; LINT_PROTOTYPE input
	tabtfin,	$	; LINT_PROTOTYPE input
	date,		$	; LINT_PROTOTYPE input
	x1,		$	; LINT_PROTOTYPE input
	y1,		$	; LINT_PROTOTYPE input
	z1,		$	; LINT_PROTOTYPE input
	x2,		$	; LINT_PROTOTYPE output
	y2,		$	; LINT_PROTOTYPE output
	z2,		$	; LINT_PROTOTYPE output
	FILLVAL,	$	; LINT_PROTOTYPE input
	NBPTS=NBPTS		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MATH) ((-)) Moyenne chaque point i des tableaux de vecteurs (date=date, x=x1, y=y1, z=z1) entre tabtdeb[i] et tabtfin[i]. Cod en C.
;
; Entres:
; -------
;  - tabtdeb: (DOUBLE) tableau de temps dbut
;  - tabtfin: (DOUBLE) tableau de temps fin
;  - date:    (DOUBLE) datation des tableaux x1, y1, z1
;  - x1:      (FLOAT)  tableau de premire   composante du vecteur  moyenner
;  - y1:      (FLOAT)  tableau de seconde    composante du vecteur  moyenner
;  - z1:      (FLOAT)  tableau de troisime  composante du vecteur  moyenner
;  - FILLVAL: (FLOAT)  valeur fillaire pouvant exister dans x1, y1 et z1
;
; Sorties:
; -------
;  - x2: (FLOAT) composante x1 moyenne (mme dimension que tabtdeb et tabfin)
;  - y2: (FLOAT) composante y1 moyenne (mme dimension que tabtdeb et tabfin)
;  - z2: (FLOAT) composante z1 moyenne (mme dimension que tabtdeb et tabfin)
;  - NBPTS: (INT) nombre de points utiliss pour faire les moyennes (mme dimension que tabtdeb et tabfin)
;-------------------------------------------------------------------------------

	nb = N_ELEMENTS(tabtdeb)

	NBPTS = REPLICATE (0L, nb)

	x2 = REPLICATE (FILLVAL, nb)
	y2 = x2
	z2 = x2

	; Modif du 09/03/2010: les donnes champ B d'ASPERA4 contiennent des FILLVAL => tenir compte des FILLVAL
	ind = WHERE (x1 NE FILLVAL AND y1 NE FILLVAL AND z1 NE FILLVAL)
	IF ind[0] NE -1 THEN BEGIN
		x1ok = x1[ind]
		y1ok = y1[ind]
		z1ok = z1[ind]
		dateok = date[ind]
		nb1 = N_ELEMENTS(dateok)
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'MOYENNER_VECTEUR_AUTO_GLUE', nb, tabtdeb, tabtfin, nb1, dateok, x1ok, y1ok, z1ok, x2, y2, z2, NBPTS, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'MOYENNER_VECTEUR', nb, tabtdeb, tabtfin, nb1, dateok, x1ok, y1ok, z1ok, x2, y2, z2, NBPTS)
		END
	END

END

;-------------------------------------------------------------------------------
FUNCTION interpoler_tab,	$
;-------------------------------------------------------------------------------
	t2,			$	; LINT_PROTOTYPE input
	t1,			$	; LINT_PROTOTYPE input
	x1,			$	; LINT_PROTOTYPE input
	FILLVAL,		$	; LINT_PROTOTYPE input
	DTMAX=DTMAX,		$	; LINT_PROTOTYPE input
	EXTRAPOLER=EXTRAPOLER		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MATH) ((-)) Retourne une copie d'un tableau de FLOAT ou DOUBLE interpol suivant une tableau de temps. Cod en C.
;
; Entres:
; -------
;  - t2:                   (RO) (DOUBLE) tableau de temps de rfrence t2 (en ms)
;  - t1:                   (RO) (DOUBLE) tableau de temps t1 (en ms)
;  - x1:                   (RO) (FLOAT ou DOUBLE) tableau de composante x1 en FLOAT
;  - FILLVAL:              (RO) (n'importe quel type) valeur fillaire pouvant tre utilise dans x1
;  - DTMAX=DTMAX           (RO) (n'importe quel type) pour ne pas interpoler/extrapoler au dela de DTMAX ms
;  - EXTRAPOLER=EXTRAPOLER (RO) (n'importe quel type) pour extrapoler
;
; Retourne:
; --------
;  - (FLOAT ou DOUBLE) tableau x1 interpol aux temps de rfrence
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(DTMAX)      EQ 0 THEN DTMAX      = 1e34
	IF N_ELEMENTS(EXTRAPOLER) EQ 0 THEN EXTRAPOLER = 1 ; on extrapole par dfaut

	nb2 = N_ELEMENTS(t2)

	IF is_double(x1) THEN BEGIN
		; DOUBLE
		x2 = REPLICATE (DOUBLE(FILLVAL), nb2)
	END ELSE BEGIN
		; FLOAT prsum
		x2 = REPLICATE (FLOAT(FILLVAL), nb2)
	END

	; Modif du 19/05/2019: les donnes PSP spc contiennent des FILLVAL => tenir compte des FILLVAL
	ind = WHERE (x1 NE FILLVAL)
	IF ind[0] NE -1 THEN BEGIN
		x1ok = x1[ind]
		t1ok = t1[ind]
		nb1ok = N_ELEMENTS(t1ok)

		IF is_double(x1) THEN BEGIN
			; DOUBLE
			IF is_fdl() THEN BEGIN
				lint_unused = CALL_EXTERNAL (libname('get_data3d'), 'INTERPOLER_TAB_DOUBLE_AUTO_GLUE',	$
					nb2, t2, nb1ok, t1ok, x1ok, x2, DOUBLE(FILLVAL), DOUBLE(DTMAX), LONG(EXTRAPOLER), /AUTO_GLUE)
			END ELSE BEGIN
				lint_unused = CALL_EXTERNAL (libname('get_data3d'), 'INTERPOLER_TAB_DOUBLE',	$
					nb2, t2, nb1ok, t1ok, x1ok, x2, DOUBLE(FILLVAL), DOUBLE(DTMAX), LONG(EXTRAPOLER))
			END
		END ELSE BEGIN
			; FLOAT prsum
			IF is_fdl() THEN BEGIN
				lint_unused = CALL_EXTERNAL (libname('get_data3d'), 'INTERPOLER_TAB_FLOAT_AUTO_GLUE',	$
					nb2, t2, nb1ok, t1ok, x1ok, x2, FLOAT(FILLVAL),  DOUBLE(DTMAX), LONG(EXTRAPOLER), /AUTO_GLUE)
			END ELSE BEGIN
				lint_unused = CALL_EXTERNAL (libname('get_data3d'), 'INTERPOLER_TAB_FLOAT',	$
					nb2, t2, nb1ok, t1ok, x1ok, x2, FLOAT(FILLVAL),  DOUBLE(DTMAX), LONG(EXTRAPOLER))
			END
		END

		IF nb2 EQ 1 THEN x2 = x2[0]
	END

	RETURN, x2

END

;-------------------------------------------------------------------------------
PRO xyz_to_module,	$
;-------------------------------------------------------------------------------
	Z1,		$	; LINT_PROTOTYPE input
	Z2,		$	; LINT_PROTOTYPE input
	sx,		$	; LINT_PROTOTYPE input
	sy,		$	; LINT_PROTOTYPE input
	sz,		$	; LINT_PROTOTYPE input
	smodule			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MATH) ((-)) Calcule le champ smodule (module) de Z2  partir des champs sx (composante X), sy (composante Y) et sz (composante Z) de Z1.
;-------------------------------------------------------------------------------

	NAMES1 = TAG_NAMES(Z1)
	ix = (WHERE (NAMES1 EQ STRUPCASE(sx)))[0]
	iy = (WHERE (NAMES1 EQ STRUPCASE(sy)))[0]
	iz = (WHERE (NAMES1 EQ STRUPCASE(sz)))[0]

	NAMES2 = TAG_NAMES(Z2)
	imodule = (WHERE (NAMES2 EQ STRUPCASE(smodule)))[0]

	; Mehode C (0.017 sec) plus rapide qu'en IDL (0.396 sec)
	; je n'utilise pas FILLVAL, mais dans le code C il y a des test avec "x>-1e30 && y>-1e30 && z>=-1e30"
	; et ca enlve des points Nan trouvs dans le champs magntique THEMIS

	lint_unused = get_structure_infos (Z1[0], taille1, nbchamps, nom_champ, type_champ, offset1, taille_champ, nb_champ)
	lint_unused = get_structure_infos (Z2[0], taille2, nbchamps, nom_champ, type_champ, offset2, taille_champ, nb_champ)
	IF is_fdl() THEN BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'MODULE_XYZ_AUTO_GLUE',					$
						Z1, N_ELEMENTS(Z1), taille1, offset1[ix], offset1[iy], offset1[iz], 	$
						Z2, N_ELEMENTS(Z2), taille2, offset2[imodule], /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'MODULE_XYZ', 						$
						Z1, N_ELEMENTS(Z1), taille1, offset1[ix], offset1[iy], offset1[iz], 	$
						Z2, N_ELEMENTS(Z2), taille2, offset2[imodule])
	END

END

;-------------------------------------------------------------------------------
PRO moyenner_tab,	$
;-------------------------------------------------------------------------------
	type,		$	; LINT_PROTOTYPE input
	moyenne,	$	; LINT_PROTOTYPE input
	t,		$	; LINT_PROTOTYPE input
	y			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MATH) ((-)) Moyenne un tableau de valeurs toutes les N secondes ou tous les N points.
;
; Entres:
; -------
;  - type:      (RO) type de moyenne:
;			1: 	moyenne linaire tous les N points en rduisant le nombre de points
;			6: 	moyenne linaire tous les N points (histogramme) en gardant le mme nombre de points
;			2: 	moyenne glissante toutes les N secondes, en utilisant pour chaque points les voisins situs  +- N/2 secondes
;					t reste inchang
;			5: 	difference avec la moyenne glissante toutes les N secondes
;					t reste inchang
;			3: 	prendre le maximum
;					il ne restera que le ou les points corrrespondant au maximum en y
;			4: 	prendre le minimum
;					il ne restera que le ou les points corrrespondant au minimum en y
;			sinon:	pas de moyenne
;  - moyenne:   (RO) nombre de points ou de secondes 
;  - t:         (RW) (DOUBLE) tableau de date en msec
;  - y:         (RW) (peu importe le type)  tableau de valeurs correspondantes
;
; Sorties:
; --------
;  - t: tableau de date en msec aprs moyenne (DOUBLE)
;  - y: tableau de valeurs      aprs moyenne (DOUBLE si typemoyenne vaut 2 ou 5)
;-------------------------------------------------------------------------------

	IF type EQ 0 THEN RETURN

	nbelem = N_ELEMENTS(t)
	IF type EQ 1 OR type EQ 6 THEN BEGIN

		IF (nbelem LT moyenne) OR (moyenne LE 0) THEN RETURN ; calcul impossible

		ind = LINDGEN(nbelem/moyenne)*moyenne; indices des premiers points de chaque intervalle

		; t1: moyenne en t
		t1 = REPLICATE (t[0]*0, N_ELEMENTS(ind))
		FOR i=0L,moyenne-1 DO t1 += t[ind+i]
		t1 /= moyenne

		; y1: moyenne en y
		y1 = REPLICATE (y[0]*0, N_ELEMENTS(ind))
		FOR i=0L,moyenne-1 DO y1 += y[ind+i]
		y1 /= moyenne

		IF type EQ 6 THEN BEGIN
			FOR i=0L, moyenne-1 DO y[ind+i] = y1
		END ELSE BEGIN
			t = t1
			y = y1
		END

	END ELSE IF type EQ 3 THEN BEGIN ; maximum

		maxi = MAX (y)
		ind = WHERE (y EQ maxi)
		t = t[ind]
		y = y[ind]

	END ELSE IF type EQ 4 THEN BEGIN ; minimum

		mini = MIN (y)
		ind = WHERE (y EQ mini)
		t = t[ind]
		y = y[ind]

	END ELSE IF type EQ 2 OR type EQ 5 THEN BEGIN ; moyenne glissante (2) ou diffrence avec la moyenne glissante (5)

		dt = moyenne * 1000. ; passage en msec
		nb_t   = N_ELEMENTS(t)

		y1 = DOUBLE(y)
		tdeb = t - dt/2.
		tfin = t + dt/2.
		ideb = REPLICATE (0L, nb_t)
		ifin = REPLICATE (nb_t-1, nb_t)

		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'MOYENNE_GLISSANTE_AUTO_GLUE', nb_t, t, tdeb, tfin, ideb, ifin, DOUBLE(y), y1, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'MOYENNE_GLISSANTE', nb_t, t, tdeb, tfin, ideb, ifin, DOUBLE(y), y1)
		END

		y = type EQ 2 ? y1 : y - y1

	END 

END


;-------------------------------------------------------------------------------
PRO trou_de_donnees,	$
;-------------------------------------------------------------------------------
	tab_date,	$	; LINT_PROTOTYPE input
	dttrou,		$	; LINT_PROTOTYPE input
	tab_deb,	$	; LINT_PROTOTYPE output
	tab_fin			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (MATH) ((-)) Dcoupe un tableau de points en tableau d'indices sans trous de donnes.
;
; Entres:
; -------
;  - tab_date: tableau de date en secondes (LONG ou DOUBLE)
;
;  - dttrou:   nombre de ms definissant un trou de donnes (LONG ou DOUBLE)
;
; Sorties:
; -------
;  - tab_deb et tab_fin: tableaux (LONG) de mmes dimension. Pour tout i, tab_date [tab_deb[i] : tab_fin[i]] contient un
;   bloc de donnes dont les lments ne sont pas spars de plus de dttrou secondes.
;-------------------------------------------------------------------------------

	nbelem = N_ELEMENTS (tab_date)
	IF nbelem EQ 1 THEN  BEGIN
		tab_deb = 0L
		tab_fin = 0L
		RETURN
	END

	tabok = REPLICATE (0b, nbelem-1)

	; tab_date contient-il des valeurs de type C double ou int ?
	info = SIZE(tab_date[0])
	type_int = info[1] EQ 3 ? 1L : 0L

	IF type_int THEN BEGIN
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'TROU_DE_DONNEES_INT_AUTO_GLUE',    tab_date, tabok, nbelem, dttrou, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'TROU_DE_DONNEES_INT',              tab_date, tabok, nbelem, dttrou)
		END
	END ELSE BEGIN
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'TROU_DE_DONNEES_DOUBLE_AUTO_GLUE', tab_date, tabok, nbelem, dttrou, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'TROU_DE_DONNEES_DOUBLE',           tab_date, tabok, nbelem, dttrou)
		END
	END
	ou = WHERE (tabok EQ 1, nbou)

	IF nbou EQ 0 THEN BEGIN
		tab_deb = 0L
		tab_fin = nbelem-1
		RETURN
	END

	tab_deb = [0L,1+ou]
	tab_fin = [ou,nbelem-1]

END

;-------------------------------------------------------------------------------
PRO spectro_additiony,	$
;-------------------------------------------------------------------------------
	additionY,	$	; LINT_PROTOTYPE input
	nbx,		$	; LINT_PROTOTYPE input
	nby,		$	; LINT_PROTOTYPE input
	Ymin,		$	; LINT_PROTOTYPE input
	Ymax,		$	; LINT_PROTOTYPE input
	Ymoy,		$	; LINT_PROTOTYPE input
	Z			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MATH) ((-)) Augmente la statistique en Y d'un spectro Z[nbx,nby] en sommant les valeurs en Y par paquets de additionY.
;-------------------------------------------------------------------------------

	nby1 = nby / additionY
	IF nby1 * additionY NE nby THEN nby1++

	tabdeb = REPLICATE (0, nby1)
	tabnb  = REPLICATE (0, nby1)
	FOR y=0L,nby1-1 DO BEGIN
		debut = y*additionY
		fin = MIN([(y+1)*additionY,nby])-1
		tabdeb[y] = debut
		tabnb [y] = fin - debut + 1
	END

	Z1 = REPLICATE (Z[0,0]*0, nbx, nby1) ; Z1 contient des lments de mme type que Z

	; Version lente car elle boucle sur les X
	;FOR x=0L,nbx-1 DO BEGIN
	;	FOR y=0L,nby1-1 DO BEGIN
	;		Z1[x,y] = TOTAL (Z[x, tabdeb[y] + LINDGEN(tabnb[y])])
	;	END
	;END

	; Version 100 fois plus rapide car elle ne boucle pas sur les X
	FOR y=0L,nby1-1 DO BEGIN
		FOR j=0L,tabnb[y]-1 DO BEGIN
			Z1[*,y] += Z[*,tabdeb[y]+j]
		END
	END

	Z = Z1

	Ymin = Ymin [*, tabdeb]
	Ymax = Ymax [*, tabdeb + tabnb-1]
	Ymoy = (Ymin+Ymax)/2.

END

;-------------------------------------------------------------------------------
FUNCTION my_triangulate,	$
;-------------------------------------------------------------------------------
	X,			$	; LINT_PROTOTYPE input
	Y,			$	; LINT_PROTOTYPE input
	TOLERANCE,		$	; LINT_PROTOTYPE input
	TRIANGLES			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (MATH) ((-)) Appelle TRIANGULATE et retourne 0 si OK et une valeur diffrente de 0 en cas de problme.
;-------------------------------------------------------------------------------

	CATCH, error

	IF error NE 0 THEN BEGIN
		; ex: "% TRIANGULATE: Points are co-linear, no solution."
		PRINT, !ERROR_STATE.msg + ' (TOLERANCE=' + val_to_str(TOLERANCE) + ')'
		RETURN, error
	END

	IF is_gdl() THEN BEGIN
		; car le TRIANGULATE de gdl est bugg

		nbp = N_ELEMENTS(X)
		nbt = 3 * nbp ; on prvoit 3 fois de triangles que de points
		TRIANGLES = REPLICATE (0L, 3, nbt)
		CL_ROOT = GETENV('CL_ROOT')
		lint_unused = CALL_EXTERNAL (libname('util'), 'MY_TRIANGULATE', DOUBLE(X), DOUBLE(Y), nbp, TRIANGLES, nbt, CL_ROOT)
		TRIANGLES = TRIANGLES[*,LINDGEN(nbt)]

	END ELSE IF is_fdl() THEN BEGIN
		TRIANGULATE, X, Y, TRIANGLES
	END ELSE BEGIN
		TRIANGULATE, X, Y, TRIANGLES, TOLERANCE=TOLERANCE
	END

	RETURN, 0

END

;-------------------------------------------------------------------------------
FUNCTION calc_dyad,	$
;-------------------------------------------------------------------------------
	V1,		$	; LINT_PROTOTYPE input
	V2			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MATH) ((-)) Utilis dans le calcul du rayon de courbure
;-------------------------------------------------------------------------------

	V = REPLICATE (0., 3, 3)

	FOR i=0L,2 DO BEGIN
		FOR j=0L,2 DO BEGIN
			V[i,j] = V1[i] * V2[j]
		END
	END

	RETURN, V

END


;-------------------------------------------------------------------------------
FUNCTION my_determ,	$
;-------------------------------------------------------------------------------
	A			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MATH) Remplace determ qui ne marche pas avec FDL.
;-------------------------------------------------------------------------------

	n = N_ELEMENTS(A[0,*])

	A1 = DOUBLE(A)
	index = REPLICATE (0d, n)
	sign = 0d
	IF is_fdl() THEN BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'MY_LUDCMP_AUTO_GLUE', A1, n, index, sign, /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'MY_LUDCMP',           A1, n, index, sign)
	END

	det = 1
	FOR k=0L,n-1 DO det *= A1[k,k]

	RETURN, sign * det

END

;-------------------------------------------------------------------------------
FUNCTION my_cramer,	$
;-------------------------------------------------------------------------------
	A,		$	; LINT_PROTOTYPE input
	B			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MATH) Remplace cramer qui ne marche pas avec FDL.
;-------------------------------------------------------------------------------

	n = N_ELEMENTS(A[0,*])

	DetermA = my_determ (A)
	xout = REPLICATE (0d, n)

	FOR k=0L,n-1 DO BEGIN
		tmp = A[k,*]
		A[k,*] = B
		xout[k] = my_determ (A) / DetermA
		A[k,*] = tmp
	END

	RETURN, xout

END

;-------------------------------------------------------------------------------
FUNCTION check_tu,	$
;-------------------------------------------------------------------------------
	annee,		$	; LINT_PROTOTYPE input
	mois,		$	; LINT_PROTOTYPE input
	jour,		$	; LINT_PROTOTYPE input
	heure,		$	; LINT_PROTOTYPE input
	minute,		$	; LINT_PROTOTYPE input
	seconde			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((1:ok 0:pb)) Retourne 1 si les valeurs annee, mois, jour, heure, minute et seconde sont correctes, 0 sinon.
;
; Ne marche pas bien car accepte les jours jusqu' 31, quelque soit l'anne et le mois.
;-------------------------------------------------------------------------------

	ok = 0
	IF jour GE 1 AND jour LE 31 THEN BEGIN
		IF mois GE 1 AND mois LE 12 THEN BEGIN
			IF annee GE 1000 AND annee LE 9999 THEN BEGIN
				IF heure GE 0 AND heure LE 24 THEN BEGIN ; on accepte 24h
					IF minute GE 0 AND minute LE 59 THEN BEGIN
						IF seconde GE 0 AND seconde LE 59.999 THEN ok = 1
					END
				END
			END
		END
	END

	RETURN, ok

END


;-------------------------------------------------------------------------------
FUNCTION check_doy,	$
;-------------------------------------------------------------------------------
	annee,		$	; LINT_PROTOTYPE input
	doy,		$	; LINT_PROTOTYPE input
	heure,		$	; LINT_PROTOTYPE input
	minute,		$	; LINT_PROTOTYPE input
	seconde			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((1:ok 0:pb)) Retourne 1 si les valeurs annee, doy, heure, minute et seconde sont correctes, 0 sinon.
;
; Ne marche pas bien car accepte les doy jusqu' 366, quelque soit l'anne.
;-------------------------------------------------------------------------------

	ok = 0
	IF doy GE 1 AND doy LE 366 THEN BEGIN
		IF annee GE 1000 AND annee LE 9999 THEN BEGIN
			IF heure GE 0 AND heure LE 24 THEN BEGIN ; on accepte 24h
				IF minute GE 0 AND minute LE 59 THEN BEGIN
					IF seconde GE 0 AND seconde LE 59.999 THEN ok = 1
				END
			END
		END
	END

	RETURN, ok

END


;-------------------------------------------------------------------------------
FUNCTION date_to_nbjours,	$
;-------------------------------------------------------------------------------
	date	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retourne le nombre de jours correspondant  une date. Accepte les tableaux.
;-------------------------------------------------------------------------------

	nbjours = LONG(date / 86400000d)
	ind1 = WHERE (date LT 0)
	IF ind1[0] NE -1 THEN BEGIN
		; enlever un jour aux dates ngatives (avant 1/1/1958) qui ne correspondent pas pile au dbut d'un jour
		tmp2 = date[ind1] - nbjours[ind1]*86400000d
		ind2 = WHERE (tmp2 NE 0)
		IF ind2[0] NE -1 THEN nbjours[ind1[ind2]]--
	END

	RETURN, nbjours

END


;-------------------------------------------------------------------------------
FUNCTION date_to_nanodate,	$
;-------------------------------------------------------------------------------
	date	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retourne la nanodate correspondant  date.
;-------------------------------------------------------------------------------

	nbjours = date_to_nbjours(date)

	nbmilli = date - nbjours*86400000d
	nbmicro = ULONG64 (nbmilli * 1000L + 0.5)

	nanodate = nbjours * 86400000000000LL + nbmicro * 1000LL

	RETURN, nanodate

END


;-------------------------------------------------------------------------------
PRO date_to_tu,		$
;-------------------------------------------------------------------------------
	date,		$	; LINT_PROTOTYPE input
	ann,		$	; LINT_PROTOTYPE output
	moi,		$	; LINT_PROTOTYPE output
	jou,		$	; LINT_PROTOTYPE output
	heu,		$	; LINT_PROTOTYPE output
	min,		$	; LINT_PROTOTYPE output
	sec,		$	; LINT_PROTOTYPE output
	exact=exact		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retourne annee, mois, jour, heure, minute et seconde correspondant  une date. Accepte les tableaux.
; /exact pour ne pas arrondir  la milliseconde entire
;-------------------------------------------------------------------------------

	nbjours = date_to_nbjours(date)

	CALDAT, 2436205 + nbjours, moi, jou, ann ; 2436205 = JULDAY (1, 1, 1958)

	IF KEYWORD_SET(exact) THEN BEGIN

		sec = (date - nbjours*86400000d) / 1000d
		heu = LONG(sec / 3600d)
		sec -= heu*3600d
		min = LONG(sec / 60d)
		sec -= min*60d

	END ELSE BEGIN

		tmp    = LONG(date - nbjours*86400000d)

		heu = tmp / 3600000L
		tmp -= heu*3600000L

		min = tmp / 60000L
		tmp -= min*60000L

		sec = tmp / 1000d

	END

END


;-------------------------------------------------------------------------------
PRO nanodate_to_tu,		$
;-------------------------------------------------------------------------------
	nanodate,	$	; LINT_PROTOTYPE input
	annee,		$	; LINT_PROTOTYPE output
	mois,		$	; LINT_PROTOTYPE output
	jour,		$	; LINT_PROTOTYPE output
	heure,		$	; LINT_PROTOTYPE output
	minute,		$	; LINT_PROTOTYPE output
	seconde,	$	; LINT_PROTOTYPE output
	milli,		$	; LINT_PROTOTYPE output
	micro,		$	; LINT_PROTOTYPE output
	nano			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retourne annee, mois, jour, heure, minute, seconde, milli, micro, nano correspondant  une nanodate. Accepte les tableaux.
;-------------------------------------------------------------------------------

	nbjours = nanodate / 86400000000000LL

	CALDAT, 2436205 + LONG(nbjours), mois, jour, annee ; 2436205 = JULDAY (1, 1, 1958)

	tmp = nanodate - nbjours*86400000000000LL
	heure 	 = tmp   / 3600000000000LL
	tmp	-= heure * 3600000000000LL
	minute	 = tmp    / 60000000000LL
	tmp	-= minute * 60000000000LL
	seconde	 = tmp /     1000000000LL
	tmp	-= seconde * 1000000000LL
	milli	 = tmp   / 1000000LL
	tmp	-= milli * 1000000LL
	micro	 = tmp   / 1000LL
	tmp	-= micro * 1000LL
	nano	 = tmp

END

;-------------------------------------------------------------------------------
FUNCTION tu_to_date,	$
;-------------------------------------------------------------------------------
	ann,		$	; LINT_PROTOTYPE input
	moi,		$	; LINT_PROTOTYPE input
	jou,		$	; LINT_PROTOTYPE input
	heu,		$	; LINT_PROTOTYPE input
	min,		$	; LINT_PROTOTYPE input
	sec,		$	; LINT_PROTOTYPE input
	exact=exact		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retourne la date correspondant  annee, mois, jour, heure, minute et seconde. Accepte les tableaux.
; /exact pour ne pas arrondir  la milliseconde entire.
;-------------------------------------------------------------------------------

	IF KEYWORD_SET(exact) THEN BEGIN
		RETURN, (JULDAY (moi, jou, ann) - 2436205)*86400000d + heu*3600000d + min*60000d + sec*1000d
	END ELSE BEGIN
		nbjours = JULDAY (moi, jou, ann) - 2436205 ; 2436205 = JULDAY (1, 1, 1958)
		nbmilli	= heu*3600000d + min*60000d + LONG(sec*1000d + 0.5d) ; pb arrondi
		date    = nbjours*86400000d + nbmilli
		RETURN, date
	END

END


;-------------------------------------------------------------------------------
FUNCTION nanodate_to_date,	$
;-------------------------------------------------------------------------------
	nanodate	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retourne la date correspondant  nanodate.
;-------------------------------------------------------------------------------

	nanodate_to_tu, nanodate, annee, mois, jour, heure, minute, seconde, milli, micro, nano

	date = tu_to_date (annee, mois, jour, heure, minute, seconde + milli*1d-3 + micro*1d-6, /exact)

	RETURN, date

END

;-------------------------------------------------------------------------------
FUNCTION get_correction_date,	$
;-------------------------------------------------------------------------------
	date			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retourne le nombre de nanoseconde qu'il faut ajouter  date pour retomber sur la valeur de date_to_nanodate(date).
;-------------------------------------------------------------------------------

	nanodate = date_to_nanodate (date)

	date_to_tu, date, annee1, mois1, jour1, heure1, minute1, seconde1, /exact
	nanodate1 = (JULDAY (mois1, jour1, annee1) - 2436205) * 86400000000000LL
	nanodate1 += LONG64(heure1) *				 3600000000000LL
	nanodate1 += LONG64(minute1) *				   60000000000LL
	nanodate1 += LONG64(seconde1 *				    1000000000LL + 0.5)

	correction = nanodate - nanodate1

	RETURN, correction

END



;-------------------------------------------------------------------------------
FUNCTION tt2000_to_date,	$
;-------------------------------------------------------------------------------
	tt2000			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retourne la date correspondant  tt2000 de type CDF_TIME_TT2000. Accepte les tableaux.
; Les leapsecondes sont intgrs dans la librairie CDFLIB.
;-------------------------------------------------------------------------------

	nb = N_ELEMENTS(tt2000)
	date = REPLICATE (0d, nb)
	IF is_fdl() THEN BEGIN
		lint_unused = CALL_EXTERNAL (libname('filecdf'), 'TT2000_TO_DATE_AUTO_GLUE', tt2000, nb, date, /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('filecdf'), 'TT2000_TO_DATE', tt2000, nb, date)
	END
	RETURN, date

END

;-------------------------------------------------------------------------------
FUNCTION epoch16_to_date,	$
;-------------------------------------------------------------------------------
	epoch16			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retourne la date correspondant  epoch16 de type EPOCH16. Accepte les tableaux.
;-------------------------------------------------------------------------------

	nb = N_ELEMENTS(epoch16)
	date = REPLICATE (0d, nb)
	IF is_fdl() THEN BEGIN
		lint_unused = CALL_EXTERNAL (libname('filecdf'), 'EPOCH16_TO_DATE_AUTO_GLUE', epoch16, nb, date, /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('filecdf'), 'EPOCH16_TO_DATE', epoch16, nb, date)
	END
	RETURN, date

END

;-------------------------------------------------------------------------------
PRO year_doy_to_month_day,	$
;-------------------------------------------------------------------------------
	year,			$	; LINT_PROTOTYPE input
	doy,			$	; LINT_PROTOTYPE input
	month,			$	; LINT_PROTOTYPE output
	day				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retourne le mois et l'anne correspondant  une anne et  un doy (1=1er janv). Accepte les tableaux.
;-------------------------------------------------------------------------------

	date_to_tu, tu_to_date (year, 1, 1, 0, 0, 0) + (doy-1)*86400000d, year, month, day, hour, minute, second

END


;-------------------------------------------------------------------------------
FUNCTION year_month_day_to_doy,	$
;-------------------------------------------------------------------------------
	year,			$	; LINT_PROTOTYPE input
	month,			$	; LINT_PROTOTYPE input
	day				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retourne le doy (1=1er janv) correspondant  une anne, mois et jour. Accepte les tableaux.
;-------------------------------------------------------------------------------

	RETURN, JULDAY (month, day, year) - JULDAY (1, 1, year) + 1

END

;-------------------------------------------------------------------------------
FUNCTION mois_to_str, 	$
;-------------------------------------------------------------------------------
	i	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retourne les 3 premires lettre (an anglais) du nom d'un mois. Accepte les tableaux.
;-------------------------------------------------------------------------------

	tab = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec']

	RETURN, tab[i-1]

END

;-------------------------------------------------------------------------------
FUNCTION tu_to_str,	$
;-------------------------------------------------------------------------------
	ann,		$	; LINT_PROTOTYPE input
	moi,		$	; LINT_PROTOTYPE input
	jou,		$	; LINT_PROTOTYPE input
	heu,		$	; LINT_PROTOTYPE input
	min,		$	; LINT_PROTOTYPE input
	sec,		$	; LINT_PROTOTYPE input
	format=format,	$	; LINT_PROTOTYPE input
	exact=exact		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retoune une chaine reprsentant une date, dans un format donn. N'accepte pas les tableaux.
;
; format=0: "20/Dec/2012 01:02:03.400"
; format=1: "20 12 2012 01 02 03.400"
; format=2: "20/12/2012 01:02:03.400"
; format=3: "2012-12-20T01:02:03.400Z"
; format=4: "2012 12 20 01 02 03.400"
; format=5: "2012-12-20T01:02:03Z"
; format=6: "01:02"
; format=7: "2012-12-20T01:02:03.400"
; format=8: "2012-12-20T01:02:03.400000"
; format=9: "2012-12-20T01:02:03.400000Z"
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(format) EQ 0 THEN format = 0
	IF N_ELEMENTS(exact) EQ 0 THEN exact = 0

	val = exact ? 1000L*1000L : 1000L
	nb  = exact ? 6 : 3

	IF format EQ 1 THEN BEGIN
		str =     int_str_0(jou, 2) + ' ' 				$
			+ int_str_0(moi, 2) + ' ' 				$
			+ int_str_0(ann, 4) + ' ' 				$
			+ int_str_0(heu, 2) + ' ' 				$
			+ int_str_0(min, 2) + ' ' 				$
			+ int_str_0(LONG(sec), 2) + '.' 			$
			+ int_str_0(LONG(val*sec+0.5)-val*LONG(sec), nb) ; pb arrondi
	END ELSE IF format EQ 0 THEN BEGIN
		str =     int_str_0(jou, 2) + '/' 				$
			+ mois_to_str(moi)  + '/' 				$
			+ int_str_0(ann, 4) + ' ' 				$
			+ int_str_0(heu, 2) + ':' 				$
			+ int_str_0(min, 2) + ':' 				$
			+ int_str_0(LONG(sec), 2) + '.' 			$
			+ int_str_0(LONG(val*sec+0.5)-val*LONG(sec), nb) ; pb arrondi
	END ELSE IF format EQ 2 THEN BEGIN
		str =     int_str_0(jou, 2) + '/' 				$
			+ int_str_0(moi, 2) + '/' 				$
			+ int_str_0(ann, 4) + ' ' 				$
			+ int_str_0(heu, 2) + ':' 				$
			+ int_str_0(min, 2) + ':' 				$
			+ int_str_0(LONG(sec), 2) + '.' 			$
			+ int_str_0(LONG(val*sec+0.5)-val*LONG(sec), nb) ; pb arrondi
	END ELSE IF format EQ 3 THEN BEGIN
		str =     int_str_0(ann, 4) + '-' 				$
			+ int_str_0(moi, 2) + '-' 				$
			+ int_str_0(jou, 2) + 'T' 				$
			+ int_str_0(heu, 2) + ':' 				$
			+ int_str_0(min, 2) + ':' 				$
			+ int_str_0(LONG(sec), 2) + '.' 			$
			+ int_str_0(LONG(val*sec+0.5)-val*LONG(sec), nb)+'Z' ; pb arrondi
	END ELSE IF format EQ 4 THEN BEGIN
		str =     int_str_0(ann, 4) + ' ' 				$
			+ int_str_0(moi, 2) + ' ' 				$
			+ int_str_0(jou, 2) + ' ' 				$
			+ int_str_0(heu, 2) + ' ' 				$
			+ int_str_0(min, 2) + ' ' 				$
			+ int_str_0(LONG(sec), 2) + '.' 			$
			+ int_str_0(LONG(val*sec+0.5)-val*LONG(sec), 3) ; pb arrondi
	END ELSE IF format EQ 5 THEN BEGIN
		str =     int_str_0(ann, 4) + '-' 				$
			+ int_str_0(moi, 2) + '-' 				$
			+ int_str_0(jou, 2) + 'T' 				$
			+ int_str_0(heu, 2) + ':' 				$
			+ int_str_0(min, 2) + ':' 				$
			+ int_str_0(LONG(sec), 2) + 'Z'
	END ELSE IF format EQ 6 THEN BEGIN
		str =  int_str_0(heu, 2) + ':' + int_str_0(min, 2)
	END ELSE IF format EQ 7 THEN BEGIN
		str =     int_str_0(ann, 4) + '-' 				$
			+ int_str_0(moi, 2) + '-' 				$
			+ int_str_0(jou, 2) + 'T' 				$
			+ int_str_0(heu, 2) + ':' 				$
			+ int_str_0(min, 2) + ':' 				$
			+ int_str_0(LONG(sec), 2) + '.' 			$
			+ int_str_0(LONG(val*sec+0.5)-val*LONG(sec), 3) ; pb arrondi
	END ELSE IF format EQ 8 THEN BEGIN
		str =     int_str_0(ann, 4) + '-' 				$
			+ int_str_0(moi, 2) + '-' 				$
			+ int_str_0(jou, 2) + 'T' 				$
			+ int_str_0(heu, 2) + ':' 				$
			+ int_str_0(min, 2) + ':' 				$
			+ int_str_0(LONG(sec), 2) + '.' 			$
			+ int_str_0(LONG(1000L*1000L*sec+0.5)-1000L*1000L*LONG(sec), 6) ; pb arrondi
	END ELSE IF format EQ 9 THEN BEGIN
		str =     int_str_0(ann, 4) + '-' 				$
			+ int_str_0(moi, 2) + '-' 				$
			+ int_str_0(jou, 2) + 'T' 				$
			+ int_str_0(heu, 2) + ':' 				$
			+ int_str_0(min, 2) + ':' 				$
			+ int_str_0(LONG(sec), 2) + '.' 			$
			+ int_str_0(LONG(1000L*1000L*sec+0.5)-1000L*1000L*LONG(sec), 6) + 'Z'; pb arrondi
	END

	RETURN, str

END

;-------------------------------------------------------------------------------
FUNCTION get_date
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retourne la date actuelle en ms depuis 1/1/1958.
;-------------------------------------------------------------------------------

	; fraction de jours  rajouter pour passer de UTC  LOCAL_TIME
	decalage = SYSTIME(/JULIAN) - SYSTIME(/JULIAN, /UTC)

	RETURN, SYSTIME(1)*1000d + (JULDAY (1, 1, 1970) - JULDAY (1, 1, 1958))*86400*1000d + decalage * 86400000d

END

;-------------------------------------------------------------------------------
FUNCTION date_to_str,	$
;-------------------------------------------------------------------------------
	date,		$	; LINT_PROTOTYPE input
	format=format,	$	; LINT_PROTOTYPE input
	C=C,		$	; LINT_PROTOTYPE input
	exact=exact		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) (('': !VALUES.D_INFINITY)) Retourne un tableau de chaine reprsentant un tableau de date dans un format donn (cod en C si /C pour format 1 et 5). Accepte les tableaux.
;
; format=0 (format par dfaut) sans /C: "20/Dec/2012 01:02:03.400"	cod en IDL. 	Accepte les tableaux.
; format=1                     sans /C: "20 12 2012 01 02 03.400" 	cod en IDL. 	Accepte les tableaux.
; format=2                     sans /C: "20/12/2012 01:02:03.400"	cod en IDL. 	Accepte les tableaux.
; format=3                     sans /C: "2012-12-20T01:02:03.400Z"	cod en IDL. 	Accepte les tableaux.
; format=4                     sans /C: "2012 12 20 01 02 03.400"	cod en IDL. 	Accepte les tableaux.
; format=5                     sans /C: "2012-12-20T01:02:03Z"		cod en IDL. 	Accepte les tableaux.
; format=6                     sans /C: "01:02"				cod en IDL. 	Accepte les tableaux.
; format=7                     sans /C: "2012-12-20T01:02:03.400"	cod en IDL. 	Accepte les tableaux.
; format=8                     sans /C: "2012-12-20T01:02:03.400000"	cod en IDL. 	Accepte les tableaux.
; format=9                     sans /C: "2012-12-20T01:02:03.400000Z"	cod en IDL. 	Accepte les tableaux.
;
; format=1                     avec /C: "20 12 2012 01 02 03.400"	cod en C. 	Accepte les tableaux.
; format=3                     avec /C: "2012-12-20T01:02:03.400Z"	cod en C.	Accepte les tableaux.
; format=5                     avec /C: "2012-12-20T01:02:03Z"		cod en C.	Accepte les tableaux.
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(format) EQ 0 THEN format = 0
	IF N_ELEMENTS(exact) EQ 0 THEN exact = 0

	nbdate = N_ELEMENTS(date)
	tabstr = REPLICATE('', nbdate)

	IF KEYWORD_SET(C) AND format EQ 1 THEN BEGIN
		IF is_fdl() THEN BEGIN
			; ex: PRINT, date_to_str([get_date(),get_date()], FORMAT=1, /C)
			tabstr = pchar(tabstr)
			lint_unused = CALL_EXTERNAL (libname('libascii'), 'DATE_TO_STR1_AUTO_GLUE', nbdate, date, tabstr, /AUTO_GLUE)
			tabstr = STRING(tabstr)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('libascii'), 'DATE_TO_STR1',           nbdate, date, tabstr)
		END
	END ELSE IF KEYWORD_SET(C) AND format EQ 3 THEN BEGIN
		IF is_fdl() THEN BEGIN
			; ex: PRINT, date_to_str([get_date(),get_date()], FORMAT=3, /C)
			tabstr = pchar(tabstr)
			lint_unused = CALL_EXTERNAL (libname('libascii'), 'DATE_TO_STR3_AUTO_GLUE', nbdate, date, tabstr, /AUTO_GLUE)
			tabstr = STRING(tabstr)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('libascii'), 'DATE_TO_STR3',           nbdate, date, tabstr)
		END
	END ELSE IF KEYWORD_SET(C) AND format EQ 5 THEN BEGIN
		IF is_fdl() THEN BEGIN
			; ex: PRINT, date_to_str([get_date(),get_date()], FORMAT=5, /C)
			tabstr = pchar(tabstr)
			lint_unused = CALL_EXTERNAL (libname('libascii'), 'DATE_TO_STR5_AUTO_GLUE', nbdate, date, tabstr, /AUTO_GLUE)
			tabstr = STRING(tabstr)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('libascii'), 'DATE_TO_STR5',           nbdate, date, tabstr)
		END
	END ELSE BEGIN
		FOR i=0L,nbdate-1 DO BEGIN
			IF date[i] NE !VALUES.D_INFINITY THEN BEGIN
				date_to_tu, date[i], ann, moi, jou, heu, min, sec, exact=format EQ 8 OR format EQ 9 OR exact
				tabstr[i] = tu_to_str (ann, moi, jou, heu, min, sec, format=format, exact=exact)
			END
		END
	END

	RETURN, nbdate EQ 1 ? tabstr[0] : tabstr

END

;-------------------------------------------------------------------------------
FUNCTION nbjours_to_date,	$
;-------------------------------------------------------------------------------
	 nbjours	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retourne une date correspondant  un nombre de jours. Accepte les tableaux.
;-------------------------------------------------------------------------------

	RETURN, nbjours*86400000d

END

;-------------------------------------------------------------------------------
FUNCTION date_to_nanoinday,	$
;-------------------------------------------------------------------------------
	date,	$	; LINT_PROTOTYPE input
	t1,	$	; LINT_PROTOTYPE input
	exact=exact	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retourne le nombre de nano secondes entre date et le dbut du jour de date t1.
;-------------------------------------------------------------------------------

	IF KEYWORD_SET(exact) THEN BEGIN
		RETURN, LONG64(1000d * 1000d * (date - 86400d * 1000d * date_to_nbjours(t1)))
	END ELSE BEGIN
		RETURN, LONG64(1000d * (date - 86400d * 1000d * date_to_nbjours(t1)) + 0.5) * 1000LL
	END

END

;-------------------------------------------------------------------------------
FUNCTION str_to_date,	$
;-------------------------------------------------------------------------------
	str,		$	; LINT_PROTOTYPE input
	format=format,	$	; LINT_PROTOTYPE input
	C=C			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((!VALUES.D_INFINITY:pb)) Retourne une date contenue dans une chaine de caractres dans un format donn (cod en C si /C pour format 1 et 7).
;
; format=1 (format par dfaut) sans /C: '20 12 2012 01 02 03.400'	cod en IDL.	N'accepte pas les tableaux.
;                                       '20 12 2012 01 02 03'
;                                       '20 12 2012 01 02'
;                                       '20 12 2012 01'
;                                       '20 12 2012'
; format=3                     sans /C: '2012-12-20T01:02:03.400Z'	cod en IDL.	N'accepte pas les tableaux.
; format=5                     sans /C: '2012-12-20T01:02:03Z'		cod en IDL.	N'accepte pas les tableaux.
;
; format=1 (format par dfaut) avec /C: '20 12 2012 01 02 03.400' 	cod en C.	Accepte les tableaux.
; format=7                     avec /C: '2012-12-20T01:02:03.400' 	cod en C.	Accepte les tableaux.
;-------------------------------------------------------------------------------

	ON_IOERROR, erreur

	IF N_ELEMENTS(format) EQ 0 THEN format = 1

	IF KEYWORD_SET(C) AND format EQ 1 THEN BEGIN
		; ex: projets/mms/mms_TemplateFGM.cl
		nbdate = N_ELEMENTS(str)
		tabdate = nbdate EQ 1 ? 0d : REPLICATE (0d, nbdate)
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('libascii'), 'STR1_TO_DATE_AUTO_GLUE', nbdate, pchar(str), !VALUES.D_INFINITY, tabdate, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('libascii'), 'STR1_TO_DATE',           nbdate, str,        !VALUES.D_INFINITY, tabdate)
		END
		RETURN, tabdate
	END

	IF KEYWORD_SET(C) AND format EQ 7 THEN BEGIN
		; ex: date = str_to_date('2012-12-20T01:02:03.400',FORMAT=7,/C)
		nbdate = N_ELEMENTS(str)
		tabdate = nbdate EQ 1 ? 0d : REPLICATE (0d, nbdate)
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('libascii'), 'STRCCSDS_TO_DATE_AUTO_GLUE', nbdate, pchar(str), !VALUES.D_INFINITY, tabdate, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('libascii'), 'STRCCSDS_TO_DATE',           nbdate, str,        !VALUES.D_INFINITY, tabdate)
		END
		RETURN, tabdate
	END

	jou = 0
	moi = 0
	ann = 0
	heu = 0
	min = 0
	sec = 0d

	exact = 0

	IF format EQ 3 THEN BEGIN
		len = STRLEN(str)
		IF len LT 23 THEN GOTO, erreur
		ann = LONG(  STRMID (str,  0, 4))
		moi = LONG(  STRMID (str,  5, 2))
		jou = LONG(  STRMID (str,  8, 2))
		heu = LONG(  STRMID (str, 11, 2))
		min = LONG(  STRMID (str, 14, 2))
		sec = DOUBLE(STRMID (str, 17, 6))
	END ELSE IF format EQ 5 THEN BEGIN
		len = STRLEN(str)
		IF len LT 19 THEN GOTO, erreur
		ann = LONG(  STRMID (str,  0, 4))
		moi = LONG(  STRMID (str,  5, 2))
		jou = LONG(  STRMID (str,  8, 2))
		heu = LONG(  STRMID (str, 11, 2))
		min = LONG(  STRMID (str, 14, 2))
		sec = DOUBLE(STRMID (str, 17, 2))
	END ELSE BEGIN
		tmp = STRSPLIT (str, /EXTRACT)
		nb = N_ELEMENTS(tmp)
		IF nb LT 3 THEN GOTO, erreur
		READS, tmp[0], jou
		READS, tmp[1], moi
		READS, tmp[2], ann
		IF nb GE 4 THEN READS, tmp[3], heu
		IF nb GE 5 THEN READS, tmp[4], min
		IF nb GE 6 THEN BEGIN
			READS, tmp[5], sec
			IF STRLEN(tmp[5]) GE 5 && STRMID(tmp[5], STRLEN(tmp[5])-5, 1) EQ '.' THEN BEGIN
				; ".xxxx"
				exact = 1
			END ELSE IF STRLEN(tmp[5]) GE 6 && STRMID(tmp[5], STRLEN(tmp[5])-6, 1) EQ '.' THEN BEGIN
				; ".xxxxx"
				exact = 1
			END ELSE IF STRLEN(tmp[5]) GE 7 && STRMID(tmp[5], STRLEN(tmp[5])-7, 1) EQ '.' THEN BEGIN
				; ".xxxxxx"
				exact = 1
			END
		END
	END

	IF ~check_tu (ann, moi, jou, heu, min, sec) THEN RETURN, !VALUES.D_INFINITY
	date = tu_to_date (ann, moi, jou, heu, min, sec, exact=exact)
	RETURN, date

erreur:

	RETURN, !VALUES.D_INFINITY

END

;-------------------------------------------------------------------------------
FUNCTION ccsds_to_date,	$
;-------------------------------------------------------------------------------
	str	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) (!VALUES.D_INFINITY:pb) Retourne la date contenue dans une chaine au format CCSDS.
;
; Accepte "YYYY-MM-DDThh:mm:ss.mscZ"
; Accepte "YYYY-MM-DDThh:mm:ss.msc"
; Accepte "YYYY-MM-DDThh:mm:ss"
; Accepte "YYYY-DDDThh:mm:ss.mscZ"
; Accepte "YYYY-DDDThh:mm:ss.msc"
; Accepte "YYYY-DDDThh:mm:ss"
;-------------------------------------------------------------------------------

	ON_IOERROR, erreur

	;                   0123456789012345678901234567
	; ASCII TIME CODE A YYYY-MM-DDThh:mm:ss[.msc][Z]

	;                   0123456789012345678901234567
	; ASCII TIME CODE B YYYY-DDDThh:mm:ss[.msc][Z]


	IF STRMID(str, 4, 1) EQ '-' AND STRMID(str, 7, 1) EQ '-' AND STRMID(str, 10, 1) EQ 'T' AND STRMID(str, 13, 1) EQ ':' AND STRMID(str, 16, 1) EQ ':' THEN BEGIN ; CODE A

		len = STRLEN(str)
		IF len LT 19 THEN GOTO, erreur
		ann = LONG(  STRMID (str,  0, 4))
		moi = LONG(  STRMID (str,  5, 2))
		jou = LONG(  STRMID (str,  8, 2))
		heu = LONG(  STRMID (str, 11, 2))
		min = LONG(  STRMID (str, 14, 2))
		sec = DOUBLE(STRMID (str, 17, 6))
		IF ~check_tu (ann, moi, jou, heu, min, sec) THEN RETURN, !VALUES.D_INFINITY
		date = tu_to_date (ann, moi, jou, heu, min, sec)

	END ELSE IF STRMID(str, 4, 1) EQ '-' AND STRMID(str, 8, 1) EQ 'T' AND STRMID(str, 11, 1) EQ ':' AND STRMID(str, 14, 1) EQ ':' THEN BEGIN ; CODE B

		len = STRLEN(str)
		IF len LT 17 THEN GOTO, erreur
		ann = LONG(  STRMID (str,  0, 4))
		doy = LONG(  STRMID (str,  5, 3))
		heu = LONG(  STRMID (str,  9, 2))
		min = LONG(  STRMID (str, 12, 2))
		sec = DOUBLE(STRMID (str, 15, 6))
		IF ~check_tu (ann, 1, 1, heu, min, sec) THEN RETURN, !VALUES.D_INFINITY
		IF doy LT 1 OR doy GT 366 THEN RETURN, !VALUES.D_INFINITY
		date = tu_to_date (ann, 1, 1, heu, min, sec) + 86400000d*(doy-1)

	END ELSE BEGIN

		date = !VALUES.D_INFINITY

	END
	RETURN, date

erreur:

	RETURN, !VALUES.D_INFINITY

END


;-------------------------------------------------------------------------------
PRO init_carrington_rotation
;-------------------------------------------------------------------------------
; (DATE) ((-)) Lit le fichier "resource/rotn_nos.html" et stocke les informations lues dans la variable carrington_rotation_infos du common COMMON_CARRINGTON_ROTATION.
;-------------------------------------------------------------------------------

	COMMON COMMON_CARRINGTON_ROTATION, carrington_rotation_infos

	ON_IOERROR, erreur

	RESOURCE_PATH = GETENV ('CL_ROOT')+'/resource/'
	nom = RESOURCE_PATH + 'rotn_nos.html'

	fd = -1
	carrington_rotation_infos = REPLICATE ({ no:0L, start_time:0d, end_time:0d }, 10000)

	OPENR, fd, nom, /GET_LUN

	ligne = ''
	numero = 1L
	WHILE ~EOF(fd) DO BEGIN

		READF, fd, ligne
		;PRINT, ligne

		; Chercher ligne genre "1053          1932     6   2.6216     1932.41973      2426861.12156"
		tmp = STRSPLIT (ligne, /EXTRACT)
		IF N_ELEMENTS(tmp) EQ 6 THEN BEGIN
			IF tmp[0] GE 0 THEN BEGIN
				numero = LONG(tmp[0])
				annee = LONG(tmp[1])
				; On ne garde que les valeurs > 1/1/1996 (pour aller plus vite)
				IF annee LT 1996 THEN CONTINUE
				mois = LONG(tmp[2])
				jour = DOUBLE(tmp[3])
				carrington_rotation_infos[numero].no = numero
				carrington_rotation_infos[numero].start_time = tu_to_date (annee, mois, LONG(jour), 0, 0, 0) + 1000d*86400*(jour-LONG(jour))
				IF numero GE 1 THEN BEGIN
					carrington_rotation_infos[numero-1].end_time = carrington_rotation_infos[numero].start_time
				END
			END
		END
	END

	FREE_LUN, fd

	; 29/02/2016: il manque l'information pour la rotation 2173
	; Alexis me dit d'utiliser 27.2753j par rotation

	DUREE = 27.2753d * 86400 * 1000d
	carrington_rotation_infos[2172].end_time = carrington_rotation_infos[2172].start_time + DUREE
	FOR no=2173L, 2300 DO BEGIN
		carrington_rotation_infos[no].start_time = carrington_rotation_infos[no-1].end_time
		carrington_rotation_infos[no].end_time = carrington_rotation_infos[no].start_time + DUREE
		carrington_rotation_infos[no].no = no
	END

	; On ne garde que les valeurs > 1/1/1996 (pour ne pas avoir une liste trop longue)
	limit = tu_to_date(1996, 1, 1, 0, 0, 0)
	ind = WHERE (carrington_rotation_infos.start_time GE limit)
	IF ind[0] EQ -1 THEN ind[0] = 0
	carrington_rotation_infos  = carrington_rotation_infos[ind]

	RETURN

erreur:
	IF fd NE -1 THEN FREE_LUN, fd
	carrington_rotation_infos  = carrington_rotation_infos[0]
	carrington_rotation_infos.start_time = tu_to_date(2000, 1, 1, 0, 0, 0)
	carrington_rotation_infos.end_time   = tu_to_date(2000, 2, 1, 0, 0, 0)

END

;-------------------------------------------------------------------------------
FUNCTION get_carrington_rotation_infos
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retourne le tableau de structure carrington_rotation_infos du common COMMON_CARRINGTON_ROTATION (structure avec les temps des diffrents carrington number).
;-------------------------------------------------------------------------------

	COMMON COMMON_CARRINGTON_ROTATION, carrington_rotation_infos

	RETURN, carrington_rotation_infos

END

;-------------------------------------------------------------------------------
FUNCTION get_carrington_rotation_best,	$
;-------------------------------------------------------------------------------
	t	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retourne la structure carrington contenant le temps t.
;-------------------------------------------------------------------------------

	COMMON COMMON_CARRINGTON_ROTATION, carrington_rotation_infos

	no = (WHERE (carrington_rotation_infos.start_time LE t AND carrington_rotation_infos.end_time GT t))[0]

	; On prend le premier intervalle si aucun ne convient
	RETURN, carrington_rotation_infos[no EQ -1 ? 0 : no]

END

;-------------------------------------------------------------------------------
FUNCTION get_carrington_rotation_number,	$
;-------------------------------------------------------------------------------
	t1,	$	; LINT_PROTOTYPE input
	t2		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((-1:null sinon:numro)) Retourne -1 si l'intervalle t1 t2 n'est pas exactement un intervalle carrington rotation, sinon retourne le numro de l'intervalle.
;-------------------------------------------------------------------------------

	COMMON COMMON_CARRINGTON_ROTATION, carrington_rotation_infos

	no = (WHERE (carrington_rotation_infos.start_time EQ t1 AND carrington_rotation_infos.end_time EQ t2))[0]

	RETURN, no EQ -1 ? -1 : carrington_rotation_infos[no].no

END

;-------------------------------------------------------------------------------
FUNCTION is_month_t1_t2,	$
;-------------------------------------------------------------------------------
	t1,	$	; LINT_PROTOTYPE input
	t2		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((1:oui 0:non)) Retourne 1 si l'intervalle entre t1 et t2 est exactement un mois, 0 sinon.
;-------------------------------------------------------------------------------

	date_to_tu, t1, annee, mois, jour, heure, minute, seconde
	IF mois EQ 12 THEN BEGIN
		mois = 1
		annee++
	END ELSE BEGIN
		mois++
	END
	RETURN, tu_to_date(annee, mois, jour, heure, minute, seconde) EQ t2

END

;-------------------------------------------------------------------------------
FUNCTION is_year_t1_t2,	$
;-------------------------------------------------------------------------------
	t1,	$	; LINT_PROTOTYPE input
	t2		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((1:oui 0:non)) Retourne 1 si l'intervalle entre t1 et t2 est exactement une anne, 0 sinon.
;-------------------------------------------------------------------------------

	date_to_tu, t1, annee, mois, jour, heure, minute, seconde
	RETURN, tu_to_date(annee+1, mois, jour, heure, minute, seconde) EQ t2

END

;-------------------------------------------------------------------------------
FUNCTION duree_to_str,	$
;-------------------------------------------------------------------------------
	duree	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((-)) Transforme une dure en ms en chaine de carcatres avec la dure en jour, heure, minute, seconde.
;-------------------------------------------------------------------------------

	nbjours = date_to_nbjours(duree)
	date_to_tu, duree, ann, moi, jou, heu, min, sec

	str = ''
	IF nbjours NE 0 THEN str += (str EQ '' ? '' : ', ') + val_to_str(nbjours, /opt)  + ' day'    + (nbjours LT 2 ? '' : 's')
	IF heu     NE 0 THEN str += (str EQ '' ? '' : ', ') + val_to_str(heu,     /opt)  + ' hour'   + (heu     LT 2 ? '' : 's')
	IF min     NE 0 THEN str += (str EQ '' ? '' : ', ') + val_to_str(min,     /opt)  + ' minute' + (min     LT 2 ? '' : 's')
	                     str += (str EQ '' ? '' : ', ') + val_to_str_2decimales(sec) + ' second' + (sec     LT 2 ? '' : 's')

	RETURN, str

END

;-------------------------------------------------------------------------------
FUNCTION get_date_format,	$
;-------------------------------------------------------------------------------
	ligne			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (DATE) ((-)) Retourne le numro du format (1,3,4,5,6,7,8,10) contenu dans une chaine, ou -1.
;-------------------------------------------------------------------------------

	s = STRSPLIT (ligne, /EXTRACT)
	nbs = N_ELEMENTS(s)

	IF STRLEN(s[0]) GE 24 THEN BEGIN ; format no3 'YYYY-MM-DDTHH:MM:SS.MSCZ'
		IF	STRMID(s[0],  4, 1) EQ '-' AND $
			STRMID(s[0],  7, 1) EQ '-' AND $
			STRMID(s[0], 10, 1) EQ 'T' AND $
			STRMID(s[0], 13, 1) EQ ':' AND $
			STRMID(s[0], 16, 1) EQ ':' AND $
			STRMID(s[0], 19, 1) EQ '.' AND $
			STRMID(s[0], 23, 1) EQ 'Z' THEN BEGIN
				RETURN, 3L
		END
	END

	IF STRLEN(s[0]) GE 23 THEN BEGIN ; format no7 'YYYY-MM-DDTHH:MM:SS.MSC'
		IF	STRMID(s[0],  4, 1) EQ '-' AND $
			STRMID(s[0],  7, 1) EQ '-' AND $
			STRMID(s[0], 10, 1) EQ 'T' AND $
			STRMID(s[0], 13, 1) EQ ':' AND $
			STRMID(s[0], 16, 1) EQ ':' AND $
			STRMID(s[0], 19, 1) EQ '.' THEN BEGIN
				RETURN, 7L
		END
	END

	IF nbs GE 2 THEN BEGIN
		IF STRLEN(s[0]) EQ 10 AND STRLEN(s[1]) GE 12 THEN BEGIN ; format no10 'YYYY-MM-DD HH:MM:SS.MSC'
			IF	STRMID(s[0],  4, 1) EQ '-' AND $
				STRMID(s[0],  7, 1) EQ '-' AND $
				STRMID(s[1],  2, 1) EQ ':' AND $
				STRMID(s[1],  5, 1) EQ ':' AND $
				STRMID(s[1],  8, 1) EQ '.' THEN BEGIN
					RETURN, 10L
			END
		END
	END

	IF STRLEN(s[0]) GE 20 THEN BEGIN ; format no5 'YYYY-MM-DDTHH:MM:SSZ'
		IF	STRMID(s[0],  4, 1) EQ '-' AND $
			STRMID(s[0],  7, 1) EQ '-' AND $
			STRMID(s[0], 10, 1) EQ 'T' AND $
			STRMID(s[0], 13, 1) EQ ':' AND $
			STRMID(s[0], 16, 1) EQ ':' AND $
			STRMID(s[0], 19, 1) EQ 'Z' THEN BEGIN
				RETURN, 5L
		END
	END

	IF STRLEN(s[0]) GE 19 THEN BEGIN ; format no7 'YYYY-MM-DDTHH:MM:SS'
		IF	STRMID(s[0],  4, 1) EQ '-' AND $
			STRMID(s[0],  7, 1) EQ '-' AND $
			STRMID(s[0], 10, 1) EQ 'T' AND $
			STRMID(s[0], 13, 1) EQ ':' AND $
			STRMID(s[0], 16, 1) EQ ':' THEN BEGIN
				RETURN, 7L
		END
	END

	IF nbs GE 6 THEN BEGIN

		IF is_number(s[0]) AND is_number(s[1]) AND is_number(s[2]) AND is_number(s[3]) AND is_number(s[4]) AND is_number(s[5]) THEN BEGIN
			IF check_tu (s[0], s[1], s[2], s[3], s[4], s[5]) THEN BEGIN ; format no4 'YYYY MM DD HH MM SS[.MSC]'
				RETURN, 4L
			END ELSE IF check_tu (s[2], s[1], s[0], s[3], s[4], s[5]) THEN BEGIN ; format no1 'DD MM YYYY HH MM SS[.MSC]'
				RETURN, 1L
			END

		END

	END

	IF nbs GE 5 THEN BEGIN

		IF is_number(s[0]) AND is_number(s[1]) AND is_number(s[2]) AND is_number(s[3]) AND is_number(s[4]) THEN BEGIN
			IF check_doy (s[0], s[1], s[2], s[3], s[4]) THEN BEGIN ; format no8 'YYYY DOY DD HH MM SS[.MSC]
				year = s[0]
				doy = s[1]
				year_doy_to_month_day, year, doy, month, day
				IF check_tu (year, month, day, s[2], s[3], s[4]) THEN BEGIN ; format no8 'YYYY DOY DD HH MM SS[.MSC]'
					RETURN, 8L
				END
			END
		END
	END

	IF is_number(s[0]) THEN BEGIN

		RETURN, 6L

	END

	RETURN, -1

END


;-------------------------------------------------------------------------------
FUNCTION dernier_element,	$
;-------------------------------------------------------------------------------
	x			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (VAR) ((-)) Retourne le dernier lment d'un tableau.
;-------------------------------------------------------------------------------

	RETURN, x[N_ELEMENTS(x)-1]

END

;-------------------------------------------------------------------------------
FUNCTION allocfree,	$
;-------------------------------------------------------------------------------
	p,		$	; LINT_PROTOTYPE input
	x,		$	; LINT_PROTOTYPE input
	NO_COPY=NO_COPY		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (VAR) ((-)) Met une valeur dans un pointeur, en dtruisant l'ancienne allocation.
;
; Met x dans le pointeur p, en dsallouant l'ancien contenu de p.
; Avec /NO_COPY, la valeur de x est dtruite.
;-------------------------------------------------------------------------------

	PTR_FREE, p
	RETURN, PTR_NEW(x, NO_COPY=NO_COPY)

END

;-------------------------------------------------------------------------------
FUNCTION n_elements_p,	$
;-------------------------------------------------------------------------------
	p			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (VAR) ((-)) Retourne le nombre d'lments du contenu d'un pointeur.
;-------------------------------------------------------------------------------

	RETURN, PTR_VALID(p) ? N_ELEMENTS(*p) : 0L

END

;-------------------------------------------------------------------------------
FUNCTION tableau_contient,	$
;-------------------------------------------------------------------------------
	tableau,	$	; LINT_PROTOTYPE input
	valeur			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (VAR) ((1:oui 0:non)) Retourne 1 si un tableau contient une valeur donne, 0 sinon.
;-------------------------------------------------------------------------------

	RETURN, (WHERE (tableau EQ valeur))[0] NE -1

END

;-------------------------------------------------------------------------------
FUNCTION supprimer_val,	$
;-------------------------------------------------------------------------------
	tab,		$	; LINT_PROTOTYPE input
	val			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (VAR) ((-)) Retourne une copie d'un tableau apres suppression des lments contenant une valeur donn.
;
; Entres: 
; -------
;	tab: tableau pouvant contenir certaines fois la valeur val
;	val: valeur  supprimer dans tab
;
; Retourne:
; --------
;  une copie de tab aprs avoir supprim les valeurs val s'il y en a
;-------------------------------------------------------------------------------

	RETURN, tab[WHERE (tab NE val)]

END

;-------------------------------------------------------------------------------
PRO joindre_structure,	$
;-------------------------------------------------------------------------------
	struct_src1,	$	; LINT_PROTOTYPE input
	struct_src2,	$	; LINT_PROTOTYPE input
	no1,		$	; LINT_PROTOTYPE input
	no2,		$	; LINT_PROTOTYPE input
	struct_dst		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (VAR) ((-)) Copie struct_src1[no1:no2] et struct_src2[no1:no2] dans struct_dst[0:no2-no1].
;
; no1 et no2 doivent etre des LONG IDL.
;-------------------------------------------------------------------------------

	IF get_structure_infos (struct_src1[0], lsrc1, nbchamps1, nom_champ1, type_champ1, offset_champ1, taille_champ1, nb_champ1) EQ 0 THEN RETURN
	IF get_structure_infos (struct_src2[0], lsrc2, nbchamps2, nom_champ2, type_champ2, offset_champ2, taille_champ2, nb_champ2) EQ 0 THEN RETURN
	IF get_structure_infos (struct_dst[0],  ldst, nbchamps3, nom_champ3, type_champ3, offset_champ3, taille_champ3, nb_champ3) EQ 0 THEN RETURN

	lsrc1_util = offset_champ1[nbchamps1-1] + taille_champ1[nbchamps1-1] ; nombre d'octets sans le padding  la fin
	lsrc2_util = offset_champ2[nbchamps2-1] + taille_champ2[nbchamps2-1] ; nombre d'octets sans le padding  la fin

	; A partir de quel octet struct_src2 va t-elle tre copie dans struct_dst ?
	N1 =  N_TAGS(struct_src1)
	offset = offset_champ3[N1]

	IF is_fdl() THEN BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'JOINDRE_STRUCTURES_AUTO_GLUE', no1, no2, lsrc1, lsrc1_util, lsrc2, lsrc2_util, ldst, offset, struct_src1, struct_src2, struct_dst, /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'JOINDRE_STRUCTURES', no1, no2, lsrc1, lsrc1_util, lsrc2, lsrc2_util, ldst, offset, struct_src1, struct_src2, struct_dst)
	END

END

;-------------------------------------------------------------------------------
FUNCTION joindre_intervalle,	$
;-------------------------------------------------------------------------------
	intervalle1,		$	; LINT_PROTOTYPE input
	intervalle2,		$	; LINT_PROTOTYPE input
	constraint_match		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (VAR) ((-)) Retourne la jonction de 2 intervalles, avec un ET ou un OU.
;
; Entres: 
; -------
;	intervalle1:      premier intervalle sous la forme [tdeb1, tfin1, tdeb2, tfin2, ...]
;	intervalle2:      second  intervalle   "                                      "
;	constraint_match: "all" si on veut faire un ET LOGIQUE des 2 intervalles
;			  "any"  "                " OU  "                    "
;
; Retourne:
; --------
;  l'intervalle sous la forme [tdeb1, tfin1, tdeb2, tfin2, ...] correspondant  la jonction des 2 intervalles
;-------------------------------------------------------------------------------

	DEBUG = 0

	intervalle = [ intervalle1, intervalle2 ]
	ind = UNIQ (intervalle, SORT(intervalle))
	intervalle3 = intervalle[ind]
	resultat = REPLICATE (0L, N_ELEMENTS(intervalle3))
	IF is_fdl() THEN BEGIN
		; non test
		lint_unused = CALL_EXTERNAL (libname('util'), 'JOINDRE_INTERVALLE_AUTO_GLUE',			$
						N_ELEMENTS(intervalle1), intervalle1,				$
						N_ELEMENTS(intervalle2), intervalle2,				$
						N_ELEMENTS(intervalle3), intervalle3, resultat, /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'JOINDRE_INTERVALLE',				$
						N_ELEMENTS(intervalle1), intervalle1,				$
						N_ELEMENTS(intervalle2), intervalle2,				$
						N_ELEMENTS(intervalle3), intervalle3, resultat)
	END

	IF DEBUG THEN BEGIN
		FOR i=0L, N_ELEMENTS(intervalle1)/2-1 DO PRINT, date_to_str(intervalle1[2*i])+' (1) '+date_to_str(intervalle1[2*i+1])
		FOR i=0L, N_ELEMENTS(intervalle2)/2-1 DO PRINT, date_to_str(intervalle2[2*i])+' (2) '+date_to_str(intervalle2[2*i+1])
		FOR i=0L, N_ELEMENTS(intervalle3)-2   DO PRINT, date_to_str(intervalle3[i])  +' (*) '+date_to_str(intervalle3[i+1])+'  ' + val_to_str(resultat[i])
	END

	indok = constraint_match EQ 'all' ? WHERE (resultat EQ 3, nbok) : WHERE (resultat NE 0, nbok)
	IF nbok EQ 0 THEN BEGIN
		intervalle = -1L
	END ELSE BEGIN
		intervalle = REPLICATE (0d, 2*nbok)
		FOR i=0L,nbok-1 DO BEGIN
			intervalle[2*i]   = intervalle3[indok[i]]
			intervalle[2*i+1] = intervalle3[indok[i]+1]
		END

		; Rduction possible du nombre d'intervalles ?
		; ex: [t1,t2] puis [t2,t3] => [-1e31,-1e31] puis [t1,t3]
		FOR i=0L,nbok-2 DO BEGIN
			IF intervalle[2*i+1] EQ intervalle[2*i+2] THEN BEGIN
				intervalle[2*i+2] = intervalle[2*i]
				intervalle[2*i]   = -1e31
				intervalle[2*i+1] = -1e31
			END
		END
		intervalle = supprimer_val (intervalle, -1e31)
	END

	RETURN, intervalle

END

;-------------------------------------------------------------------------------
FUNCTION check_always_ok,	$
;-------------------------------------------------------------------------------
	para,	$	; LINT_PROTOTYPE input
	val		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (VAR) ((-)) Une des fonctions de vrification de la valeur d'une variable dans formulaire
;-------------------------------------------------------------------------------

	lint_unused = para
	lint_unused = val

	RETURN, ''

END


;-------------------------------------------------------------------------------
FUNCTION check_strdate,	$
;-------------------------------------------------------------------------------
	para,	$	; LINT_PROTOTYPE input
	str		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (VAR) ((-)) Une des fonctions de vrification de la valeur d'une variable dans formulaire
;-------------------------------------------------------------------------------

	lint_unused = para

	ret = str_to_date (str)
	IF FINITE(ret) THEN BEGIN
		RETURN, ''
	END ELSE BEGIN
		RETURN, ': must be in format DD MM YYYY HH MM SS.MSC or DD MM YYYY HH MM or DD MM YYYY HH or DD MM YYYY (1000<=YYYY<=9999)'
	END

END


;-------------------------------------------------------------------------------
FUNCTION check_sup,	$
;-------------------------------------------------------------------------------
	para,	$	; LINT_PROTOTYPE input
	val		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (VAR) ((-)) Une des fonctions de vrification de la valeur d'une variable dans formulaire
;-------------------------------------------------------------------------------

	a = (*para)[0]   
	IF val GT a THEN BEGIN
		RETURN, ''
	END ELSE BEGIN
		RETURN, ': must be > ' + val_to_str(a)
	END

END


;-------------------------------------------------------------------------------
FUNCTION check_sup_inf,	$
;-------------------------------------------------------------------------------
	para,	$	; LINT_PROTOTYPE input
	val		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (VAR) ((-)) Une des fonctions de vrification de la valeur d'une variable dans formulaire
;-------------------------------------------------------------------------------

	a = (*para)[0]
	b = (*para)[1]

	IF (val GT a) AND (val LT b) THEN BEGIN
		RETURN, ''
	END ELSE BEGIN
		RETURN, ': must be >= ' + val_to_str(a) + ' and <= ' + val_to_str(b)
	END

END


;-------------------------------------------------------------------------------
FUNCTION check_supegal,	$
;-------------------------------------------------------------------------------
	para,	$	; LINT_PROTOTYPE input
	val		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (VAR) ((-)) Une des fonctions de vrification de la valeur d'une variable dans formulaire
;-------------------------------------------------------------------------------

	a = (*para)[0]   
	IF val GE a THEN BEGIN
		RETURN, ''
	END ELSE BEGIN
		RETURN, ': must be >= ' + val_to_str(a)
	END

END


;-------------------------------------------------------------------------------
FUNCTION check_supegal_infegal,	$
;-------------------------------------------------------------------------------
	para,	$	; LINT_PROTOTYPE input
	val		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (VAR) ((-)) Une des fonctions de vrification de la valeur d'une variable dans formulaire
;-------------------------------------------------------------------------------

	a = (*para)[0]
	b = (*para)[1]

	IF (val GE a) AND (val LE b) THEN BEGIN
		RETURN, ''
	END ELSE BEGIN
		RETURN, ': must be >= ' + val_to_str(a) + ' and <= ' + val_to_str(b)
	END

END

;-------------------------------------------------------------------------------
FUNCTION dicho_date_sup_inf,	$
;-------------------------------------------------------------------------------
	sup_inf,		$	; LINT_PROTOTYPE input
	tab,			$	; LINT_PROTOTYPE input
	nb_ms				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MEM) ((-)) Recherche par dichotomie une valeur dans un tableau.
;
;   Entrees:
;   -------
;
;    nb_sec: valeur du champ date de l'enregistrement que l'on recherche
;
;    sup_inf:
;        1 si l'on recherche la valeur suprieure
;        2 si l'on recherche la valeur infrieure
;
;   Entrees-Sorties:
;   ----------------
;    tab: enregistrement lu
;
;   Retourne:
;   --------
;    index: numro de l'enregistrement trouv (1 pour le premier)
;
;
;        La fonction recherche par dichotomie, dans le tableau tab
;   l'lment le plus petit suprieur ou egal a nb_ms (si sup_inf=1) ou
;   le plus grand infrieur ou egal a nb_sec (si sup_inf=2).
;-------------------------------------------------------------------------------

	ideb = 0L
	ifin = N_ELEMENTS(tab)-1

	; Patch /DATA/PSP/DATA/sweap/spc/L3/2020/01/spp_swp_spc_l3i_20200128_v02.cdf
	; 1er enregistrement: 28/Jan/2020 23:59:56.686
	; 2nd enregistrement: 27/Jan/2020 23:59:56.689
	IF N_ELEMENTS(tab) GE 2 && (tab[0] GT tab[1]) THEN tab[0] = tu_to_date (1958, 0, 0, 0, 0, 0)

	; Lecture du premier enregistrement:  on arrete si nb_ms < var
	IF nb_ms LT tab[ideb] THEN RETURN, ideb

	; Lecture du dernier enregistrement: on arrete si nb_ms > var
	IF nb_ms GT tab[ifin] THEN RETURN, ifin

	d = ideb
	f = ifin

	WHILE d+1 NE f DO BEGIN

		index = (d+f)/2

		; Lecture de l'enregistrement de numero 'index'
		var = tab[index]

		IF nb_ms EQ var THEN BEGIN
			IF sup_inf EQ 1 AND index NE ideb THEN BEGIN
				RETURN, index-1
			END ELSE IF sup_inf EQ 2 AND index NE ifin THEN BEGIN
				RETURN, index+1
			END ELSE BEGIN
				RETURN, index
			END
		END ELSE IF nb_ms LT var THEN BEGIN
			f = index 
		END ELSE BEGIN
			d = index
		END

	END

	index = sup_inf EQ 1 ? d : f
	RETURN, index

END

;-------------------------------------------------------------------------------
FUNCTION dicho_data_sup_inf,	$
;-------------------------------------------------------------------------------
	sup_inf,		$	; LINT_PROTOTYPE input
	data,			$	; LINT_PROTOTYPE input
	nb_ms				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MEM) ((-)) Recherche par dichotomie une valeur dans un tableau d'enregistrements contenant le champ date
;
;   Entrees:
;   -------
;
;    nb_sec: valeur du champ date de l'enregistrement que l'on recherche
;
;    sup_inf:
;        1 si l'on recherche la valeur suprieure
;        2 si l'on recherche la valeur infrieure
;
;   Entrees-Sorties:
;   ----------------
;    tab: enregistrement lu
;
;   Retourne:
;   --------
;    index: numro de l'enregistrement trouv (1 pour le premier)
;
;        La fonction recherche par dichotomie, dans le tableau data
;   l'lment dont le champ date est le plus petit suprieur ou egal a
;   nb_ms (si sup_inf=1) ou le plus grand infrieur ou egal a nb_sec (si sup_inf=2).
;-------------------------------------------------------------------------------

	ideb = 0L
	ifin = N_ELEMENTS(data)-1

	; Lecture du premier enregistrement:  on arrete si nb_ms < var
	IF nb_ms LT data[ideb].date THEN RETURN, ideb

	; Lecture du dernier enregistrement: on arrete si nb_ms > var
	IF nb_ms GT data[ifin].date THEN RETURN, ifin

	d = ideb
	f = ifin

	WHILE d+1 NE f DO BEGIN

		index = (d+f)/2

		; Lecture de l'enregistrement de numero 'index'
		var = data[index].date

		IF nb_ms EQ var THEN BEGIN
			IF sup_inf EQ 1 AND index NE ideb THEN BEGIN
				RETURN, index-1
			END ELSE IF sup_inf EQ 2 AND index NE ifin THEN BEGIN
				RETURN, index+1
			END ELSE BEGIN
				RETURN, index
			END
		END ELSE IF nb_ms LT var THEN BEGIN
			f = index 
		END ELSE BEGIN
			d = index
		END

	END

	index = sup_inf EQ 1 ? d : f
	RETURN, index

END


;-------------------------------------------------------------------------------
FUNCTION rech_monotone,	$
;-------------------------------------------------------------------------------
	tab			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MEM) ((-)) Retourne un tableau donnant les intervalles o les valeurs sont monotones.
;
;   Entres:
;   -------
;    tab: tableau de valeurs de Lambda0
;
;   Retourne:
;   --------
;    Tableau donnant les intervalles ou Lambda0 est monotone sous la forme
;    (deb1,fin1,deb2,fin2,...,debn,finn).
;-------------------------------------------------------------------------------

	nb = N_ELEMENTS(tab)
	IF nb LE 2 THEN  BEGIN
		tab1 = [0,nb-1]
		RETURN, tab1
	END

	var = tab[1] GE tab[0]
	tab1 = [0]

	FOR i=1L,nb-2 DO BEGIN
		var1 = tab[i+1] GE tab[i]
		IF var1 NE var THEN tab1 = [tab1,i,i]
		var = var1
	END

	tab1 = [tab1,i]

	RETURN, tab1

END

;-------------------------------------------------------------------------------
PRO remplir,	$
;-------------------------------------------------------------------------------
	tab,	$	; LINT_PROTOTYPE input
	ind,	$	; LINT_PROTOTYPE input
	val		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MEM) ((-)) Met tab dans tab[ind].
;-------------------------------------------------------------------------------

	IF ind[0] NE -1 THEN tab[ind] = val

END

;-------------------------------------------------------------------------------
FUNCTION remplir_tableau,	$
;-------------------------------------------------------------------------------
	tab1,			$	; LINT_PROTOTYPE input
	tab2,			$	; LINT_PROTOTYPE input
	val1,			$	; LINT_PROTOTYPE input
	val2				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MEM) ((-)) Mettre dans le tableau tab1 les valeurs dcrites dans val1[i] aux endroits ou le tableau tab2 vaut val2[i].
;
; Entres: 
; -------
;  - tab1: (RW) tableau de valeurs
;  - tab2: (RO) tableau de valeurs de mme dimension que tab1
;  - val2: (RO) nb valeurs  chercher dans tab2
;  - val1: (RO) nb valeurs  mettre   dans tab1
;
; mettre tab1  val1[0] aux endroits ou tab2 vaut val2[0]
; mettre tab1  val1[1] aux endroits ou tab2 vaut val2[1]
; ...
;-------------------------------------------------------------------------------

	nb = N_ELEMENTS(val2)
	FOR i=0L,nb-1 DO BEGIN
		ind = WHERE (tab2 EQ val2[i])
		IF ind[0] NE -1 THEN tab1[ind] = val1[i]
	END

	RETURN, tab1

END

;-------------------------------------------------------------------------------
PRO modifier_ordre_data,	$
;-------------------------------------------------------------------------------
	data,	$	; LINT_PROTOTYPE input
	nocas		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MEM) ((-)) Modifie l'ordre de certaines dimensions de data (angles ou nergies).
;
; Entres:
;
;	data: 		donnes (tableau de structure contenant le champ 'DATA')
;	nocas:		
;			1:	passer de l'ordre angles_energies  energies_angles (STEREO)
;			2:	inverser l'ordre des nergies
;
; Entrs/Sorties:
;
;	data:		tableau de structure existante en entre, modife en sortie
;-------------------------------------------------------------------------------

	lint_unused = get_structure_infos (data[0], taille_enreg, nbchamps, nom_champ, type_champ, offset_champ, taille_champ, nb_champ)

	nochamp = WHERE (STRUPCASE(TAG_NAMES(data)) EQ 'DATA')
	nb = N_ELEMENTS(data)
	nbenergies = N_ELEMENTS(data[0].data[*,0,0])
	nbangles   = N_ELEMENTS(data[0].data[0,*,0])
	nbmasses   = N_ELEMENTS(data[0].data[0,0,*])

	IF is_fdl() THEN BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'MODIFIER_ORDRE_DATA_AUTO_GLUE', data, $
					taille_enreg, offset_champ[nochamp], taille_champ[nochamp], nb, nbangles, nbenergies, nbmasses, LONG(nocas), /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'MODIFIER_ORDRE_DATA', data, $
					taille_enreg, offset_champ[nochamp], taille_champ[nochamp], nb, nbangles, nbenergies, nbmasses, LONG(nocas))
	END

END

;-------------------------------------------------------------------------------
FUNCTION ajouter_tab,	$
;-------------------------------------------------------------------------------
	p,		$	; LINT_PROTOTYPE input
	x 			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MEM) ((-)) Rajoute une valeur au contenu d'un pointeur (qui doit point sur un tableau). Lent car le rajout se fait par concatnation.
;
; Ajoute x au tableau point par *p
;-------------------------------------------------------------------------------

	IF PTR_VALID(p) THEN BEGIN
		tab = [*p,x]
		PTR_FREE, p
	END ELSE BEGIN
		tab = x
	END

	RETURN, PTR_NEW (tab, /NO_COPY)

END


;-------------------------------------------------------------------------------
PRO ajouter_tab1,	$
;-------------------------------------------------------------------------------
	p,		$	; LINT_PROTOTYPE input
	x,		$	; LINT_PROTOTYPE input
	nb			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MEM) ((-)) Rajoute une valeur au contenu d'un pointeur (qui doit point sur un tableau). Rapide car la routine fait des allocations par paquets de 1000.
;-------------------------------------------------------------------------------

	IF ~ PTR_VALID(p) THEN BEGIN
		p = PTR_NEW(REPLICATE (x, 1000), /NO_COPY)
	END ELSE IF nb EQ N_ELEMENTS(*p) THEN BEGIN
		tab = [*p,REPLICATE (x, 1000)]
		PTR_FREE, p
		p = PTR_NEW (tab, /NO_COPY)
	END ELSE BEGIN
		(*p)[nb]=x
	END
	nb++

END


;-------------------------------------------------------------------------------
PRO supprimer_tab,	$
;-------------------------------------------------------------------------------
	p,		$	; LINT_PROTOTYPE input
	i 			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MEM) ((-)) Supprime un lment au contenu d'un pointeur.
;
; Supprime l'lment numro i dans le tableau *p
;-------------------------------------------------------------------------------

	IF ~ PTR_VALID(p) THEN RETURN

	nb = N_ELEMENTS(*p)
	IF nb EQ 1 THEN BEGIN ; on supprime l'unique element
		PTR_FREE, p
		p = PTR_NEW()
	END ELSE BEGIN
		IF i EQ 0 THEN BEGIN ; on supprime le premier element
			tmp = (*p)[1:nb-1]
			PTR_FREE, p
			p = PTR_NEW(tmp, /NO_COPY)
		END ELSE IF i EQ nb-1 THEN BEGIN ; on supprime le dernier element
			tmp = (*p)[0:nb-2]
			PTR_FREE, p
			p = PTR_NEW(tmp, /NO_COPY)
		END ELSE BEGIN ; on supprime un element quelconque
			avt = (*p)[0:i-1]
			apr = (*p)[i+1:nb-1]
			PTR_FREE, p
			p = PTR_NEW([avt,apr], /NO_COPY)
		END
	END

END

;-------------------------------------------------------------------------------
PRO infos_add,	$
;-------------------------------------------------------------------------------
	infos,	$	; LINT_PROTOTYPE input
	i,	$	; LINT_PROTOTYPE input
	nom,	$	; LINT_PROTOTYPE input
	val		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MEM) ((-)) Ajoute { nom, val }  *infos[i].
;-------------------------------------------------------------------------------

	infos[i] = ajouter_tab (infos[i], { nom: nom, val: val })

END

;-------------------------------------------------------------------------------
PRO permuter,	$
;-------------------------------------------------------------------------------
	x,	$	; LINT_PROTOTYPE input
	y		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MEM) ((-)) Permute x et y, de n'importe quel type.
;-------------------------------------------------------------------------------

	tmp = x
	x = y
	y = tmp

END

;-------------------------------------------------------------------------------
FUNCTION reduction,	$
;-------------------------------------------------------------------------------
	data,		$	; LINT_PROTOTYPE input
	indok			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MEM) ((-)) Retourne (*data)[ind] et libre le pointeur data.
;-------------------------------------------------------------------------------

	tmp = (*data)[indok]
	PTR_FREE, data
	RETURN, tmp

END

;-------------------------------------------------------------------------------
FUNCTION selection,	$
;-------------------------------------------------------------------------------
	tab_date,	$	; LINT_PROTOTYPE input
	tab_time_t1,	$	; LINT_PROTOTYPE input
	tab_time_t2,	$	; LINT_PROTOTYPE input
	INVERSE=INVERSE		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (MEM) ((-1:null sinon:liste)) Retourne les points de tab_date qui font parti d'au moins un des intervalles [tab_time_t1,tab_time_t2].
;
; Utilis lorsque lorsqu'il y a des contraintes sur des panneaux et que les donnes sont lues avec constraint_read_methode == 'all data'
;-------------------------------------------------------------------------------

	ind = LINDGEN (N_ELEMENTS(tab_date))
	IF tab_time_t1[0] EQ '' THEN RETURN, KEYWORD_SET(INVERSE) ? -1 : ind

	tab_date1 = str_to_date (tab_time_t1, format=1, /C)
	tab_date2 = str_to_date (tab_time_t2, format=1, /C)
	tab_ok = REPLICATE (0b, N_ELEMENTS(tab_date))
	IF is_fdl() THEN BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'SELECTION_AUTO_GLUE', N_ELEMENTS(tab_date), tab_date, N_ELEMENTS(tab_date1), tab_date1, tab_date2, tab_ok, /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'SELECTION', N_ELEMENTS(tab_date), tab_date, N_ELEMENTS(tab_date1), tab_date1, tab_date2, tab_ok)
	END
	indok = WHERE (tab_ok EQ 1)

	IF KEYWORD_SET(INVERSE) THEN BEGIN
		tmp = REPLICATE (0, N_ELEMENTS(tab_date))
		IF indok[0] NE -1 THEN tmp[indok] = 1
		indok = WHERE (tmp EQ 0)
	END

	RETURN, indok

END

;-------------------------------------------------------------------------------
FUNCTION cte_masseelectron
;-------------------------------------------------------------------------------
; (PHYSIC) ((-)) Retourne la masse d'un lectron (en kg).
;-------------------------------------------------------------------------------

	RETURN, 9.10956e-31 ; Masse d'un electron (en kg)

END


;-------------------------------------------------------------------------------
FUNCTION cte_masseproton
;-------------------------------------------------------------------------------
; (PHYSIC) ((-)) Retourne la masse d'un proton (en kg).
;-------------------------------------------------------------------------------

	RETURN, 1.67252e-27 ; Masse d'un proton (en kg)

END


;-------------------------------------------------------------------------------
FUNCTION cte_electronvolt
;-------------------------------------------------------------------------------
; (PHYSIC) ((-)) Retourne la valeur d'un eV (en joule).
;-------------------------------------------------------------------------------

	RETURN, 1.602176e-19   ; 1eV = ELECTRONVOLT Joule Rob Wilson

END


;-------------------------------------------------------------------------------
FUNCTION cte_rt_m
;-------------------------------------------------------------------------------
; (PHYSIC) ((-)) Retourne la valeur d'un rayon terrestere (en m).
;-------------------------------------------------------------------------------

	RETURN,  6378000. ; 1Rt = RT metres

END


;-------------------------------------------------------------------------------
FUNCTION cte_rm_km,	$
;-------------------------------------------------------------------------------
	maven=maven	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (PHYSIC) ((-)) Retourne la valeur d'un rayon martien (en km).
;-------------------------------------------------------------------------------

	IF KEYWORD_SET(maven) THEN RETURN, 3389.1 ; RAYON DE MARS en Kilometres utilis pour MAVEN

	RETURN, 3397.2 ; RAYON DE MARS EN Kilometres

END


;-------------------------------------------------------------------------------
FUNCTION cte_rv_km
;-------------------------------------------------------------------------------
; (PHYSIC) ((-)) Retourne la valeur d'un rayon vnusien (en km).
;-------------------------------------------------------------------------------

	RETURN, 6051.8 ; RAYON DE VENUS EN Kilometres

END

;-------------------------------------------------------------------------------
FUNCTION cte_rj_km
;-------------------------------------------------------------------------------
; (PHYSIC) ((-)) Retourne la valeur du rayon de Jupiter (en km).
;-------------------------------------------------------------------------------

	RETURN,  71492.0

END

;-------------------------------------------------------------------------------
FUNCTION energy_to_vitesse,	$
;-------------------------------------------------------------------------------
	E,			$	; LINT_PROTOTYPE input
	Q,			$	; LINT_PROTOTYPE input
	ELECTRONVOLT,		$	; LINT_PROTOTYPE input
	MASSE,			$	; LINT_PROTOTYPE input
	Rt=Rt				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (PHYSIC) ((-)) Retourne la vitesse (en km/sec ou Rt/sec) correspondant  une nergie donne (en eV).
;
; E: energy en electronvolt
; Retourne la vitesse en km/sec ou en Rt/sec si Rt=1
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(Rt) EQ 0 THEN Rt = 0

	vitesse = SQRT(2*E*Q*ELECTRONVOLT/MASSE)/1e3
	IF Rt NE 0 THEN vitesse /= 6378.

	RETURN, vitesse

END

;-------------------------------------------------------------------------------
PRO km_to_rt,	$
;-------------------------------------------------------------------------------
	FILLVAL,	$	; LINT_PROTOTYPE input
	Z1,		$	; LINT_PROTOTYPE input
	Z2,		$	; LINT_PROTOTYPE input
	sKm,		$	; LINT_PROTOTYPE input
	sRt			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (PHYSIC) ((-)) Calcule le champ sRt (rayon terrestres) de Z2  partir du chap sKm (kilomtres) de Z1.
;-------------------------------------------------------------------------------

	RAYON_TERRE_KM = cte_rt_m() / 1000.0

	iKm = (WHERE (TAG_NAMES(Z1) EQ STRUPCASE(sKm)))[0]
	iRt = (WHERE (TAG_NAMES(Z2) EQ STRUPCASE(sRt)))[0]

	tmp = Z1.(iKm)
	Z2.(iRt) = FILLVAL
	ind = WHERE (tmp NE FILLVAL)
	IF ind[0] NE -1 THEN Z2[ind].(iRt) = tmp[ind] / RAYON_TERRE_KM

END


;-------------------------------------------------------------------------------
PRO km_to_rm,	$
;-------------------------------------------------------------------------------
	FILLVAL,	$	; LINT_PROTOTYPE input
	Z1,		$	; LINT_PROTOTYPE input
	Z2,		$	; LINT_PROTOTYPE input
	sKm,		$	; LINT_PROTOTYPE input
	sRm			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (PHYSIC) ((-)) Calule le champ sRm (rayon martiens) de Z2  partir du chap sKm (kilomtres) de Z1.
;-------------------------------------------------------------------------------

	RAYON_MARS_KM = cte_rm_km()

	iKm = (WHERE (TAG_NAMES(Z1) EQ STRUPCASE(sKm)))[0]
	iRm = (WHERE (TAG_NAMES(Z2) EQ STRUPCASE(sRm)))[0]

	Z2.(iRm) = FILLVAL
	ind = WHERE (Z1.(iKm) NE FILLVAL)
	IF ind[0] NE -1 THEN Z2[ind].(iRm) = Z1[ind].(iKm) / RAYON_MARS_KM

END


;-------------------------------------------------------------------------------
PRO b_to_pmnpa,	$
;-------------------------------------------------------------------------------
	FILLVAL,	$	; LINT_PROTOTYPE input
	Z1,		$	; LINT_PROTOTYPE input
	Z2,		$	; LINT_PROTOTYPE input
	sx,		$	; LINT_PROTOTYPE input
	sy,		$	; LINT_PROTOTYPE input
	sz,		$	; LINT_PROTOTYPE input
	spmnpa			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (PHYSIC) ((-)) Calcule le champ spmnpa (pression magntique) de Z2  partir des champs sx (Bx), sy (Bx) et sz (Bz) de Z1.
;-------------------------------------------------------------------------------

	NAMES1 = TAG_NAMES(Z1)
	ix = WHERE (NAMES1 EQ STRUPCASE(sx))
	ix = ix[0]
	iy = WHERE (NAMES1 EQ STRUPCASE(sy))
	iy = iy[0]
	iz = WHERE (NAMES1 EQ STRUPCASE(sz))
	iz = iz[0]

	NAMES2 = TAG_NAMES(Z2)
	ipmnpa = WHERE (NAMES2 EQ STRUPCASE(spmnpa))
	ipmnpa = ipmnpa[0]

	Z2.(ipmnpa) = FILLVAL
	ind = WHERE (Z1.(ix) NE FILLVAL AND Z1.(iy) NE FILLVAL AND Z1.(iz) NE FILLVAL)
	IF ind[0] NE -1 THEN BEGIN
		Z2[ind].(ipmnpa) = ((Z1[ind].(ix)*1E-9)^2 + (Z1[ind].(iy)*1E-9)^2 + (Z1[ind].(iz)*1E-9)^2) / (2*(4*!PI*1E-7)) * 1E9
	END

END


;-------------------------------------------------------------------------------
PRO rep1_to_rep2_rocotlib,	$
;-------------------------------------------------------------------------------
	FILLVAL,		$	; LINT_PROTOTYPE input
	Z1,			$	; LINT_PROTOTYPE input
	Z2,			$	; LINT_PROTOTYPE input
	date,			$	; LINT_PROTOTYPE input
	sx1,			$	; LINT_PROTOTYPE input
	sy1,			$	; LINT_PROTOTYPE input
	sz1,			$	; LINT_PROTOTYPE input
	sx2,			$	; LINT_PROTOTYPE input
	sy2,			$	; LINT_PROTOTYPE input
	sz2,			$	; LINT_PROTOTYPE input
	transformation			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (PHYSIC) ((-)) Passe de gei en gse ou de gse en gsm, en utilisant la rocotlib code en C.
;
; Calcule les champs sx2, sy2 et sz2 de Z2  partir de date et des champs sx1, sy1 et sz1 de Z1
;-------------------------------------------------------------------------------

	; transformation peut valoir 'gei_to_gse' ou 'gse_to_gsm'
	IF transformation EQ 'gei_to_gse' THEN BEGIN
		repere = 1L
	END ELSE IF transformation EQ 'gse_to_gsm' THEN BEGIN
		repere = 2L
	END ELSE BEGIN
		RETURN
	END

	NAMES1 = TAG_NAMES(Z1)
	nbvecteurs = N_ELEMENTS(sx1)
	NAMES2 = TAG_NAMES(Z2)
	nb = N_ELEMENTS(date)

	tabx1 = REPLICATE (0., nb, nbvecteurs)
	taby1 = REPLICATE (0., nb, nbvecteurs)
	tabz1 = REPLICATE (0., nb, nbvecteurs)
	FOR i=0L,nbvecteurs-1 DO BEGIN
		tabx1[*,i] = Z1.((WHERE (NAMES1 EQ STRUPCASE(sx1[i])))[0])
		taby1[*,i] = Z1.((WHERE (NAMES1 EQ STRUPCASE(sy1[i])))[0])
		tabz1[*,i] = Z1.((WHERE (NAMES1 EQ STRUPCASE(sz1[i])))[0])
	END
	tabx2 = REPLICATE (FILLVAL, nb, nbvecteurs)
	taby2 = REPLICATE (FILLVAL, nb, nbvecteurs)
	tabz2 = REPLICATE (FILLVAL, nb, nbvecteurs)

	date_to_tu, date, ann, moi, jou, heu, min, sec
	IF is_fdl() THEN BEGIN
		lint_unused = CALL_EXTERNAL (libname('rocotlibc'), 'REP1_TO_REP2_AUTO_GLUE', 			$
					repere, FLOAT(FILLVAL), nb, ann, moi, jou, heu, min, LONG(sec), 	$
					nbvecteurs, tabx1, taby1, tabz1, tabx2, taby2, tabz2, /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('rocotlibc'), 'REP1_TO_REP2', 				$
					repere, FLOAT(FILLVAL), nb, ann, moi, jou, heu, min, LONG(sec), 	$
					nbvecteurs, tabx1, taby1, tabz1, tabx2, taby2, tabz2)
	END

	FOR i=0L,nbvecteurs-1 DO BEGIN
		Z2.((WHERE (NAMES2 EQ STRUPCASE(sx2[i])))[0]) = tabx2[*,i]
		Z2.((WHERE (NAMES2 EQ STRUPCASE(sy2[i])))[0]) = taby2[*,i]
		Z2.((WHERE (NAMES2 EQ STRUPCASE(sz2[i])))[0]) = tabz2[*,i]
	END

END


;-------------------------------------------------------------------------------
PRO gse_to_gsm,	$
;-------------------------------------------------------------------------------
	FILLVAL,	$	; LINT_PROTOTYPE input
	Z1,		$	; LINT_PROTOTYPE input
	Z2,		$	; LINT_PROTOTYPE input
	date,		$	; LINT_PROTOTYPE input
	sxgse,		$	; LINT_PROTOTYPE input
	sygse,		$	; LINT_PROTOTYPE input
	szgse,		$	; LINT_PROTOTYPE input
	sxgsm,		$	; LINT_PROTOTYPE input
	sygsm,		$	; LINT_PROTOTYPE input
	szgsm			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (PHYSIC) ((-)) Passe de gse en gsm, en utilisant la maglib code en C. Ne marche pas avant 2000.
;
; Calcule les champs sxgsm, sygsm et szgsm de Z2  partir de date et des champs sxgse, sygse et szgse de Z1
;
;	La structure Z1 doit contenir les champs sxgse, sygse, szgse
;	La structure Z2 doit contenir les champs sxgsm, sygsm, szgsm
;-------------------------------------------------------------------------------

	IF date[0] LT 1325376000000 THEN BEGIN ; 1er janvier 2000
		rep1_to_rep2_rocotlib, FILLVAL, Z1, Z2, date, sxgse, sygse, szgse, sxgsm, sygsm, szgsm, 'gse_to_gsm'
		RETURN
	END

	NAMES1 = TAG_NAMES(Z1)
	nbvecteurs = N_ELEMENTS(sxgse)
	NAMES2 = TAG_NAMES(Z2)
	nb = N_ELEMENTS(date)

	tabxgse = REPLICATE (0., nb, nbvecteurs)
	tabygse = REPLICATE (0., nb, nbvecteurs)
	tabzgse = REPLICATE (0., nb, nbvecteurs)
	FOR i=0L,nbvecteurs-1 DO BEGIN
		tabxgse[*,i] = Z1.((WHERE (NAMES1 EQ STRUPCASE(sxgse[i])))[0])
		tabygse[*,i] = Z1.((WHERE (NAMES1 EQ STRUPCASE(sygse[i])))[0])
		tabzgse[*,i] = Z1.((WHERE (NAMES1 EQ STRUPCASE(szgse[i])))[0])
	END
	tabxgsm = REPLICATE (FILLVAL, nb, nbvecteurs)
	tabygsm = REPLICATE (FILLVAL, nb, nbvecteurs)
	tabzgsm = REPLICATE (FILLVAL, nb, nbvecteurs)

	date_to_tu, date, ann, moi, jou, heu, min, sec
	IF is_fdl() THEN BEGIN
		lint_unused = CALL_EXTERNAL (libname('maglibc'), 'GSE_TO_GSM_AUTO_GLUE', 			$
					FLOAT(FILLVAL), nb, ann, moi, jou, heu, min, LONG(sec), 		$
					nbvecteurs, tabxgse, tabygse, tabzgse, tabxgsm, tabygsm, tabzgsm, /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('maglibc'), 'GSE_TO_GSM', 					$
					FLOAT(FILLVAL), nb, ann, moi, jou, heu, min, LONG(sec), 		$
					nbvecteurs, tabxgse, tabygse, tabzgse, tabxgsm, tabygsm, tabzgsm)
	END

	FOR i=0L,nbvecteurs-1 DO BEGIN
		Z2.((WHERE (NAMES2 EQ STRUPCASE(sxgsm[i])))[0]) = tabxgsm[*,i]
		Z2.((WHERE (NAMES2 EQ STRUPCASE(sygsm[i])))[0]) = tabygsm[*,i]
		Z2.((WHERE (NAMES2 EQ STRUPCASE(szgsm[i])))[0]) = tabzgsm[*,i]
	END

END


;-------------------------------------------------------------------------------
PRO rep1_to_rep2,	$
;-------------------------------------------------------------------------------
	Mdate,		$	; LINT_PROTOTYPE input
	M00,		$	; LINT_PROTOTYPE input
	M01,		$	; LINT_PROTOTYPE input
	M02,		$	; LINT_PROTOTYPE input
	M10,		$	; LINT_PROTOTYPE input
	M11,		$	; LINT_PROTOTYPE input
	M12,		$	; LINT_PROTOTYPE input
	M20,		$	; LINT_PROTOTYPE input
	M21,		$	; LINT_PROTOTYPE input
	M22,		$	; LINT_PROTOTYPE input
	FILLVAL,	$	; LINT_PROTOTYPE input
	date,		$	; LINT_PROTOTYPE input
	Z,		$	; LINT_PROTOTYPE input
	xpgse,		$	; LINT_PROTOTYPE input
	ypgse,		$	; LINT_PROTOTYPE input
	zpgse,		$	; LINT_PROTOTYPE input
	xgse,		$	; LINT_PROTOTYPE input
	ygse,		$	; LINT_PROTOTYPE input
	zgse,		$	; LINT_PROTOTYPE input
	DTMAX=DTMAX		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (PHYSIC) ((-)) Calcule les champs xgse, ygse et zgse de Z  partir de des champs xpgse, ypgse et zpgse de Z.
;
; Utilise les coefficients de matrice M00 .. M22
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(DTMAX) EQ 0 THEN DTMAX = 86400*1000d

	NAMES = TAG_NAMES(Z)

	i_xpgse = (WHERE (NAMES EQ STRUPCASE(xpgse)))[0]
	i_ypgse = (WHERE (NAMES EQ STRUPCASE(ypgse)))[0]
	i_zpgse = (WHERE (NAMES EQ STRUPCASE(zpgse)))[0]
	i_xgse  = (WHERE (NAMES EQ STRUPCASE(xgse)))[0]
	i_ygse  = (WHERE (NAMES EQ STRUPCASE(ygse)))[0]
	i_zgse  = (WHERE (NAMES EQ STRUPCASE(zgse)))[0]

	nb = N_ELEMENTS(Z)
	x1 = Z.(i_xpgse)
	y1 = Z.(i_ypgse)
	z1 = Z.(i_zpgse)
	x2 = REPLICATE (FILLVAL, nb)
	y2 = x2
	z2 = x2

	nbrepgse = N_ELEMENTS(Mdate)
	IF is_fdl() THEN BEGIN
		; ex: solar_gdl.cl
		lint_unused = CALL_EXTERNAL (libname('util'), 'GET_REP1_TO_REP2_AUTO_GLUE', 	$
						nb, date, x1, y1, z1, x2, y2, z2, 		$
						nbrepgse, Mdate, 				$
						M00, M01, M02, 					$
						M10, M11, M12, 					$
						M20, M21, M22, 					$
						FILLVAL, DTMAX, /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'GET_REP1_TO_REP2', 		$
						nb, date, x1, y1, z1, x2, y2, z2, 		$
						nbrepgse, Mdate, 				$
						M00, M01, M02, 					$
						M10, M11, M12, 					$
						M20, M21, M22, 					$
						FILLVAL, DTMAX)
	END

	Z.(i_xgse) = x2
	Z.(i_ygse) = y2
	Z.(i_zgse) = z2

END


;-------------------------------------------------------------------------------
FUNCTION get_facteur_multiplicatif_unit1_vers_unit2,	$
;-------------------------------------------------------------------------------
	unit1,						$	; LINT_PROTOTYPE input
	unit2							; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (PHYSIC) ((-)) Retourne le facteur multiplicatif  appliquer pour passer de l'unit unit1 vers l'unit unit2.
;-------------------------------------------------------------------------------

; valeurs possibles pour unit1 et unit2: 'm', 'km', 'rt', 're', 'rm', 'rv'
; ces valeurs peuvent tre passes en majuscules ou minuscules

	; facteur  appliquer pour passer de unit1 en 'm'
	CASE STRLOWCASE (unit1) OF
		'm':		facteur = 1
		'km':		facteur = 1000
		'rt':		facteur = cte_rt_m()
		're':		facteur = cte_rt_m()
		'rm':		facteur = cte_rm_km()*1000.0
		'rv':		facteur = cte_rv_km()*1000.0
	END

	; facteur  appliquer pour passer de 'm' en unit2
	CASE STRLOWCASE (unit2) OF
		'm':		facteur *= 1
		'km':		facteur /= 1000
		'rt':		facteur /= cte_rt_m()
		're':		facteur /= cte_rt_m()
		'rm':		facteur /= cte_rm_km()*1000.0
		'rv':		facteur /= cte_rv_km()*1000.0
	END

	RETURN, facteur

END


;-------------------------------------------------------------------------------
FUNCTION dirname,	$
;-------------------------------------------------------------------------------
	nom	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((-)) Retourne le rpertoire d'un nom de fichier.
;
; Je ne peux pas utiliser FILE_DIRNAME sous Windows car pour 'd:/tmp/DATA/toto'
; FILE_DIRNAME retourne 'd:\tmp\DATA' alors que dirname retourne 'd:/tmp/DATA'
;
; Lorsque je veux transformer 'd:/tmp/DATA/toto' en 'http://server/toto' FILE_DIRNAME pose des problmes.
;-------------------------------------------------------------------------------

	len = STRLEN(nom)
	FOR i=len-2,0,-1 DO BEGIN
		IF STRMID(nom, i, 1) EQ '/' OR STRMID(nom, i, 1) EQ '\' THEN RETURN, STRMID(nom, 0, i)
	END

	RETURN, nom

END


;-------------------------------------------------------------------------------
FUNCTION basename,	$
;-------------------------------------------------------------------------------
	nom	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((-)) Retourne le nom d'un fichier sans le rpertoire (fonctionne aussi avec un tableau de noms de fichiers).
;
; Comme je ne veux pas utiliser FILE_DIRNAME, je n'utilise pas non plus FILE_BASENAME
;-------------------------------------------------------------------------------

	nb = N_ELEMENTS(nom)
	ret = nom

	FOR j=0L,nb-1 DO BEGIN
		len = STRLEN(nom[j])
		FOR i=len-1,0,-1 DO BEGIN
			IF STRMID(nom[j], i, 1) EQ '/' OR STRMID(nom[j], i, 1) EQ '\' THEN BEGIN
				ret[j] = STRMID(nom[j], i+1, len-i)
				BREAK
			END
		END
	END

	RETURN, nb EQ 1 ? ret[0] : ret

END


;-------------------------------------------------------------------------------
PRO modifier_droits,	$
;-------------------------------------------------------------------------------
	nom,			$	; LINT_PROTOTYPE input
	o_read=o_read,		$	; LINT_PROTOTYPE input
	o_write=o_write,	$	; LINT_PROTOTYPE input
	o_execute=o_execute		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((-)) Positionne les droits en "o+" du fichier ou rpertoire nom.
;-------------------------------------------------------------------------------
	ON_IOERROR, error

	IF nom EQ '' THEN RETURN

	;PRINT,'file_chmod('+nom+')'
	IF N_ELEMENTS(o_read) NE 0 THEN BEGIN
		IF is_gdl() OR is_fdl() THEN BEGIN
			cmd = 'chmod o+r ' + nom
			SPAWN, cmd
		END ELSE BEGIN
			FILE_CHMOD, nom, o_read=o_read
		END
	END
	IF N_ELEMENTS(o_write) NE 0 THEN BEGIN
		IF is_gdl() OR is_fdl() THEN BEGIN
			cmd = 'chmod o+w ' + nom
			SPAWN, cmd
		END ELSE BEGIN
			FILE_CHMOD, nom, o_write=o_write
		END
	END
	IF N_ELEMENTS(o_execute) NE 0 THEN BEGIN
		IF is_gdl() OR is_fdl() THEN BEGIN
			cmd = 'chmod o+x ' + nom
			SPAWN, cmd
		END ELSE BEGIN
			FILE_CHMOD, nom, o_execute=o_execute
		END
	END

error:

END


;-------------------------------------------------------------------------------
PRO mkdir_p,			$
;-------------------------------------------------------------------------------
	nom,			$	; LINT_PROTOTYPE input
	o_read=o_read,		$	; LINT_PROTOTYPE input
	o_write=o_write,	$	; LINT_PROTOTYPE input
	o_execute=o_execute,	$	; LINT_PROTOTYPE input
	err=err				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (FILE) ((-)) Cre recursivement le repertoire nom.
;-------------------------------------------------------------------------------

	ON_IOERROR, error

	err = 0

	IF nom EQ '' THEN RETURN
	IF ~is_windows() && FILE_TEST (enlever_slash_fin(nom), /DANGLING_SYMLINK) THEN BEGIN
		; lien symbolique qui pointe sur un fichier qui n'existe pas
		; Arrive si on veut crer un rpertoire dans "/DATAP" qui pointe sur un rpertoire qui n'existe pas
		err = 1
		RETURN
	END


	IF ~FILE_TEST (enlever_slash_fin(nom), /DIRECTORY) THEN BEGIN

		mkdir_p, dirname (nom), o_read=o_read, o_write=o_write, o_execute=o_execute, err=err
		IF err THEN RETURN
		FILE_MKDIR, nom
		;PRINT,"file_mkdir("+nom+")"
		IF N_ELEMENTS(o_read) NE 0 THEN modifier_droits, nom, o_read=o_read
		IF N_ELEMENTS(o_write) NE 0 THEN modifier_droits, nom, o_write=o_write
		IF N_ELEMENTS(o_execute) NE 0 THEN modifier_droits, nom, o_execute=o_execute
	END

	RETURN

error:
	err = 1

END


;-------------------------------------------------------------------------------
FUNCTION ecrire_master,	$
;-------------------------------------------------------------------------------
	filename,	$	; LINT_PROTOTYPE input
	SYMBOLS			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((1:toujours)) Cre un fichier master, au format CEF,  partir d'un tableau de structures dfinissant les variables.
;-------------------------------------------------------------------------------

	mkdir_p, dirname(filename)

	OPENW, fd, filename, /GET_LUN, /COMPRESS

	NAMES = TAG_NAMES (SYMBOLS[0])
	FOR i=0L,N_ELEMENTS(SYMBOLS)-1 DO BEGIN

		PRINTF, fd, "START_VARIABLE       = " + SYMBOLS[i].name
		FOR j=0L,N_ELEMENTS(NAMES)-1 DO BEGIN
			IF NAMES[j] EQ 'NAME' THEN CONTINUE
			IF NAMES[j] EQ 'EXCEPTION' THEN CONTINUE
			IF NAMES[j] EQ 'NBLIGNES' THEN CONTINUE
			IF SYMBOLS[i].(j) EQ '' THEN CONTINUE
			s = '  '+NAMES[j]
			FOR k=STRLEN(s),20 DO s += ' '
			s += "= " + SYMBOLS[i].(j)
			PRINTF, fd, s
		END
		PRINTF, fd, "END_VARIABLE         = " + SYMBOLS[i].name
		PRINTF, fd

	END

	FREE_LUN, fd

	RETURN, 1

END

;-------------------------------------------------------------------------------
FUNCTION fichier_existe,	$
;-------------------------------------------------------------------------------
	nom	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((1:oui 0:non)) Retourne 1 si le fichier existe, 0 sinon (cod en C).
;-------------------------------------------------------------------------------

	IF is_fdl() THEN BEGIN
		code = CALL_EXTERNAL (libname('libascii'), 'FICHIER_EXISTE_AUTO_GLUE', nom, /AUTO_GLUE)
	END ELSE BEGIN
		code = CALL_EXTERNAL (libname('libascii'), 'FICHIER_EXISTE',           nom)
	END

	RETURN, code

END

;-------------------------------------------------------------------------------
FUNCTION my_findfile,	$
;-------------------------------------------------------------------------------
	filtre,	$	; LINT_PROTOTYPE input
	C=C		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((-)) Retourne une liste de fichiers correspondant  filtre (cod en C si le mot clf C est utilis).
;
; Si filtre contient un rpertoire:
;  - retourne une liste avec noms de rpertoires sans /C
;  - retourne une liste sans noms de rpertoires avec /C
;
; Les rpertoires '.' et '..' sont supprims
;
; la liste est trie
;-------------------------------------------------------------------------------

	IF KEYWORD_SET(C) THEN BEGIN

		; utilis dans get_http_file

		; NEW: codage en C de FINDFILE
		; Attention: retourne une liste de fichiers mais sans les rpertoires dedans!
		IF is_fdl() THEN BEGIN
			nb = 1L
			tabliste = REPLICATE (0b, 1024, nb)
			nb = CALL_EXTERNAL (libname('file'), 'FINDFILE_AUTO_GLUE', filtre, 1L, tabliste, nb, /AUTO_GLUE)	; retourne le nombre de fichiers trouvs
			liste = STRING(tabliste)
		END ELSE BEGIN
			liste = ''
			nb = CALL_EXTERNAL (libname('file'), 'FINDFILE', filtre, 1L, liste)	; retourne le nombre de fichiers trouvs
		END
		IF is_fdl() THEN BEGIN
			IF nb NE 0 THEN tabliste = REPLICATE (0b, 1024, nb)
			lint_unused = CALL_EXTERNAL (libname('file'), 'FINDFILE_AUTO_GLUE', filtre, 2L, tabliste, nb, /AUTO_GLUE)
			liste = STRING(tabliste)
		END ELSE BEGIN
			IF nb NE 0 THEN liste = REPLICATE ('', nb)
			lint_unused = CALL_EXTERNAL (libname('file'), 'FINDFILE', filtre, 2L, liste)
		END
		RETURN, liste
	END


	liste = FILE_SEARCH (filtre)
	liste = liste [SORT (liste)]

	; Sous Win: 
	;	- les fichiers finissant par '\' sont des repertoires
	;	- il peut donner dans liste les repertoires '.' et '..'


	IF is_windows() THEN BEGIN
		IF liste[0] EQ '' THEN RETURN, liste
		nb = N_ELEMENTS(liste)
		ok = REPLICATE (1, nb)
		FOR i=0L, nb-1 DO BEGIN
			IF STRMID (liste[i], STRLEN(liste[i])-1, 1) EQ '\' THEN BEGIN ; fini par '\'
				liste[i] = STRMID (liste[i], 0, STRLEN(liste[i])-1) ; suppression du '\'
				IF basename(liste[i]) EQ '.' OR basename(liste[i]) EQ '..' THEN ok[i] = 0
			END
		END
		ind = WHERE (ok EQ 1)
		RETURN, ind[0] EQ -1 ? '' : liste[ind]
	END

	RETURN, liste

END

;-------------------------------------------------------------------------------
PRO corriger_dirname,	$
;-------------------------------------------------------------------------------
	nom		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((-)) Corrige, uniquement sous Windows, un nom s'il contient des mots interdits (ex: CON) en rajoutant des '_'.
;-------------------------------------------------------------------------------

	; Ne corriger que sous Windows
	IF ~is_windows() THEN RETURN

	; Sous Windows certains noms de fichiers ou rpertoires sont interdits:
	;
	;	- CON
	;	- PRN
	;	- AUX (arrive avec les donnes EQUATOR-S)
	;	- NUL
	;	- COM0, COM1, COM2, ... COM9
	;	- LPT0, LPT1, LPT2, ... LPT9
	;
	; Solution: rajouter "_" a ces rpertoires si ncessaire

	MOTS = [	$
		'CON',	$
		'PRN',	$
		'AUX',	$
		'NUL',	$
		'COM0',	$
		'COM1',	$
		'COM2',	$
		'COM3',	$
		'COM4',	$
		'COM5',	$
		'COM6',	$
		'COM7',	$
		'COM8',	$
		'COM9',	$
		'LPT0',	$
		'LPT1',	$
		'LPT2',	$
		'LPT3',	$
		'LPT4',	$
		'LPT5',	$
		'LPT6',	$
		'LPT7',	$
		'LPT8',	$
		'LPT9'	$
	]

	FOR i=0L,N_ELEMENTS(MOTS)-1 DO BEGIN

		debut = 0
		WHILE 1 DO BEGIN

			pos = STRPOS(STRUPCASE(nom), MOTS[i], debut)
			pos = pos[0]
			IF pos[0] EQ -1 THEN BREAK

			; caractre avant
			cavant = pos EQ 0 ? '/' : STRMID(nom, pos-1, 1)

			IF cavant EQ '/' OR cavant EQ '\' THEN BEGIN
			END ELSE BEGIN
				debut++
				CONTINUE
			END

			; caractre aprs
			capres = pos+STRLEN(MOTS[i]) EQ STRLEN(nom) ? '/' : STRMID(nom, pos+STRLEN(MOTS[i]), 1)
			IF capres EQ '/' OR capres EQ '\' THEN BEGIN
			END ELSE BEGIN
				debut++
				CONTINUE
			END

			; Il faut rajouter '_'
			nom = STRMID(nom, 0, pos+STRLEN(MOTS[i])) + '_' + STRMID(nom, pos+STRLEN(MOTS[i]))

		END
		
	END


END


;-------------------------------------------------------------------------------
FUNCTION filelength,	$
;-------------------------------------------------------------------------------
	fd	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((-)) Retourne la taille d'un fichier dja ouvert en IDL.
;
;   Entrees:
;   ========
;    fd: file descriptor du fichier
;
;   Retour:
;   =======
;    Taille du fichier en octets
;
;
;        Cette fonction permet de connaitre la taille d'un fichier deja ouvert.
;-------------------------------------------------------------------------------

	status = FSTAT (fd)
	RETURN, status.SIZE

END


;-------------------------------------------------------------------------------
PRO ouvrir_ecriture,	$
;-------------------------------------------------------------------------------
	nom,		$	; LINT_PROTOTYPE input
	fd			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (FILE) ((-)) Ouvre un fichier en criture et retourne le fd correspondant.
;-------------------------------------------------------------------------------

	OPENW, fd, nom, /GET_LUN

END

;-------------------------------------------------------------------------------
PRO ouvrir_lecture,	$
;-------------------------------------------------------------------------------
	nom,			$	; LINT_PROTOTYPE input
	compress=compress,	$	; LINT_PROTOTYPE input
	fd				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (FILE) ((-)) Ouvre un fichier en lecture avec /SWAP_IF_LITTLE_ENDIAN et retourne le fd correspondant.
;
;   Entrees:
;   ========
;    nom: nom du fichier a ouvrir (fichier binaire)
;
;   Sorties:
;   ========
;    fd: file descriptor du fichier
;
;
;        Cette procedure ouvre un fichier en mode lecture binaire et retourne
;   son file descriptor (le fichier doit pouvoir etre ouvert).
;-------------------------------------------------------------------------------

	;PRINT,'ouvrir_lecture '+nom

	IF STRMID(nom, STRLEN(nom)-4) EQ '.x86' OR STRMID(nom, STRLEN(nom)-7) EQ '.x86.gz' OR STRMID(nom, STRLEN(nom)-4) EQ '.v86' OR STRMID(nom, STRLEN(nom)-4) EQ '.n86' THEN BEGIN
		SWAP_IF_BIG_ENDIAN    = 1
		SWAP_IF_LITTLE_ENDIAN = 0
	END ELSE BEGIN
		SWAP_IF_LITTLE_ENDIAN = 1
		SWAP_IF_BIG_ENDIAN    = 0
	END
	OPENR, fd, nom, /GET_LUN, SWAP_IF_LITTLE_ENDIAN=SWAP_IF_LITTLE_ENDIAN, SWAP_IF_BIG_ENDIAN=SWAP_IF_BIG_ENDIAN, compress=compress

END


;-------------------------------------------------------------------------------
FUNCTION detruire,	$
;-------------------------------------------------------------------------------
	nom	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((0:ok 1:pb)) Detruit un fichier (cod en C). Retourne 0 si OK, -1 si PB.
;-------------------------------------------------------------------------------

	IF is_fdl() THEN BEGIN
		code = CALL_EXTERNAL (libname('file'), 'DETRUIRE_AUTO_GLUE', nom, /AUTO_GLUE)
	END ELSE BEGIN
		code = CALL_EXTERNAL (libname('file'), 'DETRUIRE',           nom)
	END
	RETURN, code

END

;-------------------------------------------------------------------------------
PRO positionner,	$
;-------------------------------------------------------------------------------
	fd,	$	; LINT_PROTOTYPE input
	offset,	$	; LINT_PROTOTYPE input
	taille,	$	; LINT_PROTOTYPE input
	no		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((-)) Se positionne dans un fichier  un numro d'enregistrement donn.
;
;   Entrees:
;   ========
;    fd: file descriptor du fichier
;
;    offset: nombre d'octets entre le debut du fichier et le 1er enregistrement
;            ou -1 si les enregistrements sont de longueur variable
;
;    taille: taille des enregistrements s'ils sont de longueur fixe
;
;    no: numero de l'enregistrement sur lequel on veut se positionner (0 pour le
;   1er)
;
;
;        Cette procedure permet de se positionner directement sur un
;   enregistrement d'un fichier binaire constitues d'enregistrements de longueur
;   fixe ou variable. Ce fichier peu eventuellement contenir une entete.
;-------------------------------------------------------------------------------

	POINT_LUN, fd, LONG64(offset)+LONG64(no)*LONG64(taille)

END

;-------------------------------------------------------------------------------
FUNCTION lire_position_v86,	$
;-------------------------------------------------------------------------------
	fd	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) Retourne une position lue sur 5 octets.
;-------------------------------------------------------------------------------

	tab = REPLICATE (0b, 5) ; position sur 5 octets
	READU, fd, tab
	position =	tab[0]*256LL*256LL*256LL*256LL 	+ $
			tab[1]*256LL*256LL*256LL 	+ $
			tab[2]*256LL*256LL 		+ $
			tab[3]*256LL 			+ $
			tab[4]

	RETURN, position
END

;-------------------------------------------------------------------------------
FUNCTION dicho_file_sup_inf,	$
;-------------------------------------------------------------------------------
	is_v86,			$	; LINT_PROTOTYPE input
	sup_inf,		$	; LINT_PROTOTYPE input
	fd,			$	; LINT_PROTOTYPE input
	offset,			$	; LINT_PROTOTYPE input
	taille,			$	; LINT_PROTOTYPE input
	var,			$	; LINT_PROTOTYPE input
	nb,			$	; LINT_PROTOTYPE input
	nb_ms				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((-)) Fait une recherche dichotomique dans un ficher.
;
;   Entrees:
;   ========
;    is_v86:
;	1 si l'extension du fichier est '.v86'
;	0 si l'extension du fichier n'est pas '.v86'
;
;    sup_inf:
;        1 si l'on desire rechercher la valeur superieure
;        2 si l'on desire rechercher la valeur inferieure
;
;    fd: file descriptor du fichier binaire
;
;    offset: nombre d'octets entre le debut du fichier et le 1er enregistrement
;
;    taille : taille des enregistrements en octets
;
;    var: variable de type enregistrement
;
;    nb: nombre d'enregistrement dans le fichier
;
;    nb_sec: valeur du champ date de l'enregistrement que l'on recherche
;
;
;   Retour:
;   =======
;    numero de l'enregistrement ou -1
;
;
;        Cette fonction est specifique aux fichiers binaires avec entete
;   constitues d'enregistrements de longueur fixe contenant chacun un champ date
;   (nombre de millisecondes par rapport au 1er janvier 1958).
;
;        La fonction recherche par dichotomie, dans le fichier de file
;   descriptor fd l'enregistrement dont le champ date est le plus petit
;   superieur ou egal a nb_ms (si sup_inf=1) ou le plus grand inferieur ou egal
;   a nb_sec (si sup_inf=2). Si cet enregistrement existe, elle fournie son
;   numero dans index et retourne 1, sinon elle retourne 0.
;-------------------------------------------------------------------------------

	ideb = 0L
	ifin = nb-1

	; Lecture du premier enregistrement: on arrete si nb_sec < var.date
	positionner, fd, offset, taille, ideb
	IF is_v86 THEN POINT_LUN, fd, lire_position_v86 (fd)
	READU, fd, var
	IF nb_ms LT var.date THEN RETURN, ideb

	; Lecture du dernier enregistrement: on arrete si nb_sec > var.date
	positionner, fd, offset, taille, ifin
	IF is_v86 THEN POINT_LUN, fd, lire_position_v86 (fd)
	READU, fd, var
	IF nb_ms GT var.date THEN RETURN, ifin

	d = ideb
	f = ifin

	WHILE d+1 NE f DO BEGIN

		index = (d+f)/2

		; Lecture de l'enregistrement de numero 'index'
		positionner, fd, offset, taille, index
		IF is_v86 THEN POINT_LUN, fd, lire_position_v86 (fd)
		READU, fd, var

		IF nb_ms EQ var.date THEN BEGIN

			IF sup_inf EQ 1 AND index NE ideb THEN BEGIN

				RETURN, index-1

			END ELSE IF sup_inf EQ 2 AND index NE ifin THEN BEGIN

				RETURN, index+1

			END ELSE BEGIN

				RETURN, index

			END

		END ELSE IF nb_ms LT var.date THEN BEGIN

			f = index

		END ELSE BEGIN

			d = index

		END

	END

	index = sup_inf EQ 1 ? d : f

	; Lecture de l'enregistrement de numero 'index'
	positionner, fd, offset, taille, index
	IF is_v86 THEN POINT_LUN, fd, lire_position_v86 (fd)
	READU, fd, var

	RETURN, index

END

;-------------------------------------------------------------------------------
FUNCTION renommer,	$
;-------------------------------------------------------------------------------
	nom1,	$	; LINT_PROTOTYPE input
	nom2		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((0:ok -1:pb)) Renomme le fichier nom1 en nom2 (cod en C). Retourne 0 si OK, -1 sinon.
;-------------------------------------------------------------------------------

	IF is_fdl() THEN BEGIN
		code = CALL_EXTERNAL (libname('file'), 'RENOMMER_AUTO_GLUE', nom1, nom2, /AUTO_GLUE)
	END ELSE BEGIN
		code = CALL_EXTERNAL (libname('file'), 'RENOMMER',           nom1, nom2)
	END
	RETURN, code

END


;-------------------------------------------------------------------------------
FUNCTION copier,	$
;-------------------------------------------------------------------------------
	nom1,	$	; LINT_PROTOTYPE input
	nom2		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((0:ok 1:pb)) Copie le fichier nom1 en nom2 (cod en C). Retourne 0 si OK, 1 si PB.
;-------------------------------------------------------------------------------

	IF is_fdl() THEN BEGIN
		code = CALL_EXTERNAL (libname('file'), 'COPIER_AUTO_GLUE', nom1, nom2, /AUTO_GLUE)
	END ELSE BEGIN
		code = CALL_EXTERNAL (libname('file'), 'COPIER', nom1, nom2)
	END
	RETURN, code

END

;-------------------------------------------------------------------------------
FUNCTION detruire_repertoire,	$
;-------------------------------------------------------------------------------
	nom	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((0:ok -1:pb)) Detruit un rpertoire (cod en C). Retourne 0 si OK, -1 si PB.
;-------------------------------------------------------------------------------

	IF is_fdl() THEN BEGIN
		code = CALL_EXTERNAL (libname('file'), 'DETRUIRE_REPERTOIRE_AUTO_GLUE', nom, /AUTO_GLUE)
	END ELSE BEGIN
		code = CALL_EXTERNAL (libname('file'), 'DETRUIRE_REPERTOIRE', nom)
	END
	RETURN, code

END

;-------------------------------------------------------------------------------
FUNCTION chercher_fichier,	$
;-------------------------------------------------------------------------------
	nom	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) (('':introuvable)) Cherche un fichier dans les rpertoires CL_ROOT/resource, '.' et !path.
;
;   Entrees:
;   ========
;    nom: nom du fichier a chercher
;
;   Retour:
;   =======
;    Chaine de caractere contenant le chemin complet du fichier ou '' s'il est
;   introuvable
;
;
;        Cette fonction permet de rechercher le chemin complet d'un fichier.
;   Elle cherche le fichier d'abord dans le repertoire courant, puis dans tous
;   les chemins contenus dans la variable !PATH (variable d'environnement
;   WAVE_PATH sous UNIX).
;-------------------------------------------------------------------------------

	ou = GETENV('CL_ROOT')+'/resource:.:'+!path

	max = STRLEN(ou)-1
	debut = 0
	REPEAT BEGIN
		fin = STRPOS (ou, ':', debut)
		IF fin EQ -1 THEN fin = max
		name = STRMID (ou, debut, fin-debut)+'/'+nom
		IF fichier_existe (name) THEN RETURN, name
		debut = fin+1
	END UNTIL debut GE max

	RETURN, ''

END


;-------------------------------------------------------------------------------
FUNCTION fichiers_idem,	$
;-------------------------------------------------------------------------------
	filename1,	$	; LINT_PROTOTYPE input
	filename2		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((1:idem 0:nonidem)) Retourne 1 si deux fichiers sont identiques, 0 sinon (cod en C).
;-------------------------------------------------------------------------------

	IF is_fdl() THEN BEGIN
		code = CALL_EXTERNAL (libname('file'), 'COMPARE_FICHIER_AUTO_GLUE', filename1, filename2, /AUTO_GLUE)
	END ELSE BEGIN
		code = CALL_EXTERNAL (libname('file'), 'COMPARE_FICHIER', filename1, filename2)
	END

	RETURN, 1 - code

END


;-------------------------------------------------------------------------------
FUNCTION my_du,	$
;-------------------------------------------------------------------------------
	filtre	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((-)) Retourne la somme de la taille des fichiers correspondant  filtre.
;-------------------------------------------------------------------------------

	taille = 0.

	noms = my_findfile (filtre)

	IF noms[0] EQ '' THEN RETURN, taille

	FOR i=0L, N_ELEMENTS(noms)-1 DO BEGIN

		nom = noms[i]

		IF FILE_TEST (nom, /DIRECTORY) THEN BEGIN

			taille += my_du (nom+'/*')
		
		END ELSE BEGIN

			OPENR, fd, nom, /GET_LUN
			info = FSTAT(fd)
			taille += info.size
			FREE_LUN, fd

		END

	END

	RETURN, taille

END

;-------------------------------------------------------------------------------
FUNCTION decompresser,	$
;-------------------------------------------------------------------------------
	nomgz,	$	; LINT_PROTOTYPE input
	nom		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((0:ok <0:pb)) Dcompresse le fichier nomgz dans le fichier nom (cod en C). Retourne 0 si OK, <0 si PB.
;-------------------------------------------------------------------------------

	IF is_fdl() THEN BEGIN
		code = CALL_EXTERNAL (libname('file'), 'DECOMPRESSER_AUTO_GLUE', nomgz, nom, /AUTO_GLUE)
	END ELSE BEGIN
		code = CALL_EXTERNAL (libname('file'), 'DECOMPRESSER', nomgz, nom)
	END
	RETURN, code

END


;-------------------------------------------------------------------------------
FUNCTION get_filelengthc,	$
;-------------------------------------------------------------------------------
	nom,	$	; LINT_PROTOTYPE input
	taille		; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (FILE) ((0:ok -1:pb)) Retourne dans taille le nombre d'octets du fichier nom, ou la taille du fichier dcompress si ".gz" (cod en C).
;
; Si le fichier est en ".gz" retourne dans taille le nombre d'octets du fichier dcompress, en utilisant les 5 derniers octets
; du fichier ".gz".
; Retourne 0 si OK, -1 si PB
;-------------------------------------------------------------------------------

	taille = LONG64(0)
	IF is_fdl() THEN BEGIN
		code = CALL_EXTERNAL (libname('file'), 'FILELENGTHC_AUTO_GLUE', nom, taille, /AUTO_GLUE)
	END ELSE BEGIN
		code = CALL_EXTERNAL (libname('file'), 'FILELENGTHC',           nom, taille)
	END
	RETURN, code

	; ou utiliser la fonction d'IDL qui fait la mme chose
	;tmp = FILE_INFO(nom)
	;taille = tmp.size
	;RETURN, tmp.exists

END

;-------------------------------------------------------------------------------
FUNCTION tester_ecriture,	$
;-------------------------------------------------------------------------------
	nom_fichier	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((1:ok 0:pb)) Retourne 1 si le fichier donn en paramtre peut tre cr.
;-------------------------------------------------------------------------------

	ON_IOERROR, erreur

	mkdir_p, dirname(nom_fichier)
	OPENW, fd, nom_fichier, /GET_LUN
	FREE_LUN, fd
	lint_unused = detruire (nom_fichier)

	RETURN, 1

erreur:
	RETURN, 0

END

;-------------------------------------------------------------------------------
FUNCTION iscdfgz,	$
;-------------------------------------------------------------------------------
	filename	;	LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((1:oui 0:non)) Retourne 1 si le nom de fichier se termine par '.cdf.gz', en majuscule ou minuscule, 0 sinon.
;-------------------------------------------------------------------------------

	RETURN, STRLOWCASE(STRMID(filename, STRLEN(filename)-7, 7)) EQ '.cdf.gz'

END

;-------------------------------------------------------------------------------
FUNCTION iscdf,	$
;-------------------------------------------------------------------------------
	filename	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((1:oui 0:non)) Retourne 1 si le nom de fichier se termine par '.cdf', en majuscule ou minuscule, 0 sinon.
;-------------------------------------------------------------------------------

	RETURN, STRLOWCASE(STRMID(filename, STRLEN(filename)-4, 4)) EQ '.cdf'

END

;-------------------------------------------------------------------------------
FUNCTION iscefgz,	$
;-------------------------------------------------------------------------------
	filename	;	LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((1:oui 0:non)) Retourne 1 si le nom de fichier se termine par '.cef.gz', en majuscule ou minuscule, 0 sinon.
;-------------------------------------------------------------------------------

	RETURN, STRLOWCASE(STRMID(filename, STRLEN(filename)-7, 7)) EQ '.cef.gz'

END

;-------------------------------------------------------------------------------
FUNCTION iscef,	$
;-------------------------------------------------------------------------------
	filename	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((1:oui 0:non)) Retourne 1 si le nom de fichier se termine par '.cef', en majuscule ou minuscule, 0 sinon.
;-------------------------------------------------------------------------------

	RETURN, STRLOWCASE(STRMID(filename, STRLEN(filename)-4, 4)) EQ '.cef'

END

;-------------------------------------------------------------------------------
FUNCTION isxml,	$
;-------------------------------------------------------------------------------
	filename	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((1:oui 0:non)) Retourne 1 si le nom de fichier se termine par '.xml', en majuscule ou minuscule, 0 sinon.
;-------------------------------------------------------------------------------

	RETURN, STRLOWCASE(STRMID(filename, STRLEN(filename)-4, 4)) EQ '.xml'

END

;-------------------------------------------------------------------------------
FUNCTION isnetcdfgz,	$
;-------------------------------------------------------------------------------
	filename	;	LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((1:oui 0:non)) Retourne 1 si le nom de fichier se termine par '.nc.gz', en majuscule ou minuscule, 0 sinon.
;-------------------------------------------------------------------------------

	RETURN, STRLOWCASE(STRMID(filename, STRLEN(filename)-6, 6)) EQ '.nc.gz'

END

;-------------------------------------------------------------------------------
FUNCTION isnetcdf,	$
;-------------------------------------------------------------------------------
	filename	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((1:oui 0:non)) Retourne 1 si le nom de fichier se termine par '.ncf', en majuscule ou minuscule, 0 sinon.
;-------------------------------------------------------------------------------

	RETURN, STRLOWCASE(STRMID(filename, STRLEN(filename)-3, 3)) EQ '.nc'

END

;-------------------------------------------------------------------------------
PRO rajout_extension,	$
;-------------------------------------------------------------------------------
	nom,		$	; LINT_PROTOTYPE input
	extension		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((-)) Rajoute l'extension au nom de fichier si elle n'y est pas (ne fait rien si le fichier a l'extension '.gz').
;-------------------------------------------------------------------------------

	len_nom = STRLEN(nom)
	IF len_nom GE 4 THEN BEGIN
		IF STRMID(nom, len_nom-3, 3) EQ '.gz' THEN RETURN
	END
	len_extension = STRLEN(extension)

	rajout = len_nom LE len_extension ? 1 : 0
	IF ~rajout THEN rajout = STRMID(nom, len_nom-len_extension, len_extension) NE extension
	IF rajout THEN nom += extension

END

;-------------------------------------------------------------------------------
PRO modif_extension,	$
;-------------------------------------------------------------------------------
	nom,		$	; LINT_PROTOTYPE input
	ext1,		$	; LINT_PROTOTYPE input
	ext2			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((-)) Modifie l'extension d'un fichier ext1 en ext2.
;-------------------------------------------------------------------------------

	len_nom = STRLEN(nom)
	len_ext1 = STRLEN(ext1)

	IF len_nom LE len_ext1 THEN RETURN
	rajout = STRMID(nom, len_nom-len_ext1, len_ext1) EQ ext1
	IF rajout THEN nom = STRMID(nom, 0, len_nom-len_ext1)+ext2

END

;-------------------------------------------------------------------------------
FUNCTION get_extension,	$
;-------------------------------------------------------------------------------
	nom			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((-)) Retourne l'extension d'un fichier
;-------------------------------------------------------------------------------

	pos = STRPOS (nom, '.', /REVERSE_SEARCH)
	RETURN, pos EQ -1 ? '' : STRMID(nom, pos+1)

END

;-------------------------------------------------------------------------------
FUNCTION my_file_info,	$
;-------------------------------------------------------------------------------
	nom	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) ((que des 0:pb sinon:ok)) Retourne une structure avec des infos sur le fichier nom: NAME, EXITS, MTIME et SIZE (cod en C).
;-------------------------------------------------------------------------------

	exists 		= BYTE(0)
	mtime		= LONG64(0)
	size 		= LONG64(0)
	IF is_fdl() THEN BEGIN
		lint_unused = CALL_EXTERNAL (libname('file'), 'MY_FILE_INFO_AUTO_GLUE', nom, exists, mtime, size, /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('file'), 'MY_FILE_INFO',           nom, exists, mtime, size)
	END
	lcl1 = { NAME: nom, EXISTS: exists, MTIME: mtime, SIZE: size }
	RETURN, lcl1

	; ou utiliser la fonction d'IDL qui fait la mme chose
	;RETURN, FILE_INFO(nom)

END

;-------------------------------------------------------------------------------
FUNCTION get_date_fichier,	$
;-------------------------------------------------------------------------------
	nom	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) Retourne la date de la dernire modification d'un fichier.
;-------------------------------------------------------------------------------

	lcl = my_file_info(nom)
	date_fichier  = lcl.mtime*1000d + tu_to_date(1970, 1, 1, 0, 0, 0)

	RETURN, date_fichier

END


;-------------------------------------------------------------------------------
FUNCTION get_md5sum,	$
;-------------------------------------------------------------------------------
	nom	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (FILE) Retourne la md5 checksum d'un fichier.
;-------------------------------------------------------------------------------

	cmd = 'md5sum ' + nom
	SPAWN, cmd, res
	tmp = STRSPLIT (res, /EXTRACT)
	RETURN, tmp[0]

END


;-------------------------------------------------------------------------------
PRO wc_l,		$
;-------------------------------------------------------------------------------
	filename,	$	; LINT_PROTOTYPE input
	nblines0,	$	; LINT_PROTOTYPE input
	usecomma,	$	; LINT_PROTOTYPE input
	usechar,	$	; LINT_PROTOTYPE input
	nbrecords,	$	; LINT_PROTOTYPE output
	nbspecial,	$	; LINT_PROTOTYPE output
	nbcomma			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (FILE) Retourne le nombre de lignes d'un fichier.
;-------------------------------------------------------------------------------

	nbrecords = 0L
	nbspecial = REPLICATE (0L, 256)
	nbcomma = 0L
	IF is_fdl() THEN BEGIN
		lint_unused = CALL_EXTERNAL (libname('libascii'), 'WC_L_AUTO_GLUE', filename, nblines0, usecomma, usechar, nbrecords, nbspecial, nbcomma, /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('libascii'), 'WC_L',           filename, nblines0, usecomma, usechar, nbrecords, nbspecial, nbcomma)
	END

END


;-------------------------------------------------------------------------------
PRO tv_new,		$
;-------------------------------------------------------------------------------
	image,		$	; LINT_PROTOTYPE input
	x1,		$	; LINT_PROTOTYPE input
	y1,		$	; LINT_PROTOTYPE input
	x2=x2,		$	; LINT_PROTOTYPE input
	y2=y2,		$	; LINT_PROTOTYPE input
	normal=normal,	$	; LINT_PROTOTYPE input
	device=device,	$	; LINT_PROTOTYPE input
	xsize=xsize,	$	; LINT_PROTOTYPE input
	ysize=ysize, 	$	; LINT_PROTOTYPE input
	true=true		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (IMAGE) ((-)) Affiche une image 1D ou 3D.
;
; Fait un TV de l'image (se dbrouille pour afficher une image en 3 dimensions si /true)
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(true) EQ 0 THEN true = 0

	IF true NE 0 THEN BEGIN
		nb3 = N_ELEMENTS(image[0,0,*])
		IF nb3 EQ 1 THEN BEGIN ; la 3eme dimension a disparue!
			nb1 = N_ELEMENTS(image[*,0,0])
			nb2 = N_ELEMENTS(image[0,*,0])
			image = REFORM (image, nb1, nb2, nb3)
		END
	END
	libplot_tv, image, x1, y1, x2=x2, y2=y2, normal=normal, device=device, xsize=xsize, ysize=ysize, true=true

END

;-------------------------------------------------------------------------------
FUNCTION imagetrue_to_image,	$
;-------------------------------------------------------------------------------
	imagetrue,		$	; LINT_PROTOTYPE input
	r,			$	; LINT_PROTOTYPE input
	v,			$	; LINT_PROTOTYPE input
	b,			$	; LINT_PROTOTYPE input
	image				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (IMAGE) ((-)) Transforme une image true-color en une image non true-color.
;-------------------------------------------------------------------------------

	nbx = N_ELEMENTS(imagetrue[0,*,0])
	nby = N_ELEMENTS(imagetrue[0,0,*])
	nbcouleurs = N_ELEMENTS(r)
	image = REPLICATE (0b, nbx, nby)

	IF is_fdl() THEN BEGIN
		; non test
		code = CALL_EXTERNAL (libname('util'), 'IMAGETRUE_TO_IMAGE_AUTO_GLUE', nbx, nby, imagetrue, nbcouleurs, r, v, b, image, /AUTO_GLUE)
	END ELSE BEGIN
		code = CALL_EXTERNAL (libname('util'), 'IMAGETRUE_TO_IMAGE',           nbx, nby, imagetrue, nbcouleurs, r, v, b, image)
	END

	RETURN, code

END


;-------------------------------------------------------------------------------
FUNCTION tvrd_new,	$
;-------------------------------------------------------------------------------
	x,		$	; LINT_PROTOTYPE input
	y,		$	; LINT_PROTOTYPE input
	nbx,		$	; LINT_PROTOTYPE input
	nby,		$	; LINT_PROTOTYPE input
	r,		$	; LINT_PROTOTYPE input
	v,		$	; LINT_PROTOTYPE input
	b,		$	; LINT_PROTOTYPE input
	optiontrue,	$	; LINT_PROTOTYPE input
	true=true		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (IMAGE) ((-)) Retourne un capture d'cran sous forme d'image.
;-------------------------------------------------------------------------------

	image = TVRD (x, y, nbx, nby, true=true)

	IF ~is_windows() OR (optiontrue OR ~true) THEN BEGIN
	
		RETURN, image
	
	END ELSE BEGIN
	
		lint_unused = imagetrue_to_image (image, r, v, b, image1)
		RETURN, image1
		
	END

END

;-------------------------------------------------------------------------------
PRO ps2png,	$
;-------------------------------------------------------------------------------
	type,		$	; LINT_PROTOTYPE input
	VALD,		$	; LINT_PROTOTYPE input
	INPUT_PS,	$	; LINT_PROTOTYPE input
	OUTPUT_PNG		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (IMAGE) ((-)) Cre un fichier PNG d'une taille donne  partir d'un fichier PS, en utilisant le script PS2PNG.
;-------------------------------------------------------------------------------

	BIN = GETENV('CL_ROOT')+'/bin/'
	cmd = BIN + "PS2PNG " + type +" " + VALD + " " + INPUT_PS + " " + OUTPUT_PNG
	taille_PS = 0L
	lint_unused = get_filelengthc (INPUT_PS, taille_PS)
	PRINT, 'PS2PNG ' + INPUT_PS + ' (' + val_to_str_2decimales(taille_PS / 1e6) + ' Mbytes) ...'
	top1 = nbsec()
	IF is_fdl() THEN BEGIN
		; car le SPAWN ne cre pas de fichier PNG sous clweb ...
		lint_unused = CALL_EXTERNAL (libname('util'), 'MY_SPAWN_AUTO_GLUE', cmd, /AUTO_GLUE)
	END ELSE BEGIN
		SPAWN, cmd
	END
	top2 = nbsec()
	taille_PS = 0L
	lint_unused = get_filelengthc (INPUT_PS, taille_PS)
	taille_PNG = 0L
	lint_unused = get_filelengthc (OUTPUT_PNG, taille_PNG)
	PRINT, basename(INPUT_PS) +' ('+val_to_str(taille_PS/1024)+ ' k) -> '+basename(OUTPUT_PNG)+' ('+val_to_str(taille_PNG/1024)+' k) in '+val_to_str_2decimales(top2-top1)+' sec'

END

;-------------------------------------------------------------------------------
PRO ps2pdf,	$
;-------------------------------------------------------------------------------
	VALD,		$	; LINT_PROTOTYPE input
	INPUT_PS,	$	; LINT_PROTOTYPE input
	OUTPUT_PDF		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (IMAGE) ((-)) Cre un fichier PDF d'une taille donne  partir d'un fichier PS, en utilisant le script PS2PDF.
;-------------------------------------------------------------------------------

	BIN = GETENV('CL_ROOT')+'/bin/'
	cmd = BIN + "PS2PDF pdfwrite " + VALD + " /prepress " + INPUT_PS + " " + OUTPUT_PDF

	top1 = nbsec()
	IF is_fdl() THEN BEGIN
		; car le SPAWN ne cre pas de fichier PDF sous clweb ...
		lint_unused = CALL_EXTERNAL (libname('util'), 'MY_SPAWN_AUTO_GLUE', cmd, /AUTO_GLUE)
	END ELSE BEGIN
		SPAWN, cmd
	END
	top2 = nbsec()
	taille_PS = 0L
	lint_unused = get_filelengthc (INPUT_PS, taille_PS)
	taille_PDF = 0L
	lint_unused = get_filelengthc (OUTPUT_PDF, taille_PDF)
	PRINT, basename(INPUT_PS) +' ('+val_to_str(taille_PS/1024)+ ' k) -> '+basename(OUTPUT_PDF)+' ('+val_to_str(taille_PDF/1024)+' k) in '+val_to_str_2decimales(top2-top1)+' sec'

END

;-------------------------------------------------------------------------------
FUNCTION rvb2no,	$
;-------------------------------------------------------------------------------
	r,		$	; LINT_PROTOTYPE input
	v,		$	; LINT_PROTOTYPE input
	b			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (IMAGE) ((-)) Retourne le code couleur sur 24 bits correspondant  un triplet 8 bits (r,v,b).
;-------------------------------------------------------------------------------

	RETURN, 256L*256L*b + 256L*v + r
END

;-------------------------------------------------------------------------------
PRO data_to_image_end,	$
;-------------------------------------------------------------------------------
	image,		$	; LINT_PROTOTYPE input	FLOAT
	nb			; LINT_PROTOTYPE input	LONG
;-------------------------------------------------------------------------------
; (IMAGE) ((-)) Utilis pour terminer data_to_image.
;-------------------------------------------------------------------------------

	ind = WHERE (nb GE 2)
	IF ind[0] NE -1 THEN image[ind] /= nb[ind]

END

;-------------------------------------------------------------------------------
FUNCTION data_to_image, $	
;-------------------------------------------------------------------------------
	Xmin_data,	$	; LINT_PROTOTYPE input	DOUBLE
	xmin_next,	$	; LINT_PROTOTYPE input	DOUBLE
	Xmoy_data,	$	; LINT_PROTOTYPE input	DOUBLE
	Xmax_data,	$	; LINT_PROTOTYPE input	DOUBLE
	dttrou,		$	; LINT_PROTOTYPE input	DOUBLE
	Ymin_data,	$	; LINT_PROTOTYPE input	FLOAT
	Ymoy_data,	$	; LINT_PROTOTYPE input	FLOAT
	Ymax_data,	$	; LINT_PROTOTYPE input	FLOAT
	indY,		$	; LINT_PROTOTYPE input	LONG
	Zdata,		$ 	; LINT_PROTOTYPE input	FLOAT
	xmin,		$	; LINT_PROTOTYPE input	DOUBLE
	xmax,		$	; LINT_PROTOTYPE input	DOUBLE
	nbx,		$	; LINT_PROTOTYPE input	LONG
	ymin,		$	; LINT_PROTOTYPE input	FLOAT
	ymax,		$	; LINT_PROTOTYPE input	FLOAT
	nby,		$	; LINT_PROTOTYPE input	LONG
	interp,		$	; LINT_PROTOTYPE input	LONG
	moyenner,	$	; LINT_PROTOTYPE input	LONG
	normaliser,	$	; LINT_PROTOTYPE input	LONG
	premier,	$	; LINT_PROTOTYPE input	INT
	image,		$	; LINT_PROTOTYPE output	FLOAT
	nb,		$	; LINT_PROTOTYPE output	LONG
	utilise,	$	; LINT_PROTOTYPE output	LONG
	produitdata,	$	; LINT_PROTOTYPE input	INT
	produitimage		; LINT_PROTOTYPE output	FLOAT
;-------------------------------------------------------------------------------
; (IMAGE) ((1:ok -1:pb)) Retourne une image couleur  partir de tableaux X[nbx], Y[nby] et Z[nbx,nby].
;-------------------------------------------------------------------------------

	infini = !VALUES.F_INFINITY
	nbx1 = N_ELEMENTS(Xmin_data) ; nb en X
	nby1 = N_ELEMENTS(Zdata)/nbx1 ; nb en Y
	nbt1 = N_ELEMENTS(Ymin_data)/nby1 ; nb de tables
	IF nby1 EQ 1 THEN BEGIN
		Ymin_data = REFORM (Ymin_data, nbt1, nby1)
		Ymoy_data = REFORM (Ymoy_data, nbt1, nby1)
		Ymax_data = REFORM (Ymax_data, nbt1, nby1)
		Zdata     = REFORM (Zdata, nbx1, nby1)
	END

	info = SIZE(xmin_next)
	ok = info[0] EQ 0            ; scalaire
	IF ok THEN ok = info[1] EQ 5 ; double
	IF ~ok THEN BEGIN
		PRINT, '% data_to_image: argument xmin_next incorrect'
		RETURN, -1
	END

	info = SIZE(dttrou)
	ok = info[0] EQ 0            ; scalaire
	IF ok THEN ok = info[1] EQ 5 ; double
	IF ~ok THEN BEGIN
		PRINT, '% data_to_image: argument dttrou incorrect'
		RETURN, -1
	END

	info = SIZE(xmin)
	ok = info[0] EQ 0            ; scalaire
	IF ok THEN ok = info[1] EQ 5 ; double
	IF ~ok THEN BEGIN
		PRINT, '% data_to_image: argument xmin incorrect'
		RETURN, -1
	END

	info = SIZE(xmax)
	ok = info[0] EQ 0            ; scalaire
	IF ok THEN ok = info[1] EQ 5 ; double
	IF ~ok THEN BEGIN
		PRINT, '% data_to_image: argument xmax incorrect'
		RETURN, -1
	END

	info = SIZE(ymin)
	ok = info[0] EQ 0            ; scalaire
	IF ok THEN ok = info[1] EQ 4 ; float
	IF ~ok THEN BEGIN
		PRINT, '% data_to_image: argument ymin incorrect'
		RETURN, -1
	END

	info = SIZE(ymax)
	ok = info[0] EQ 0            ; scalaire
	IF ok THEN ok = info[1] EQ 4 ; float
	IF ~ok THEN BEGIN
		PRINT, '% data_to_image: argument ymax incorrect'
		RETURN, -1
	END

	info = SIZE(nbx)
	ok = info[0] EQ 0            ; scalaire
	IF ok THEN ok = info[1] EQ 3 ; longint
	IF ~ok THEN BEGIN
		PRINT, '% data_to_image: argument nbx incorrect'
		RETURN, -1
	END

	info = SIZE(nby)
	ok = info[0] EQ 0            ; scalaire
	IF ok THEN ok = info[1] EQ 3 ; longint
	IF ~ok THEN BEGIN
		PRINT, '% data_to_image: argument nby incorrect'
		RETURN, -1
	END

	info = SIZE(moyenner)
	ok = info[0] EQ 0            ; scalaire
	IF ok THEN ok = info[1] EQ 3 ; longint
	IF ~ok THEN BEGIN
		PRINT, '% data_to_image: argument moyenner incorrect'
		RETURN, -1
	END

	info = SIZE(Xmin_data)
	ok = info[0] EQ 1            ; tableau  une dimension
	IF ok THEN ok = info[2] EQ 5 ; double
	IF ~ok THEN BEGIN
		PRINT, '% data_to_image: argument Xmin_data incorrect'
		RETURN, -1
	END

	info = SIZE(Xmoy_data)
	ok = info[0] EQ 1            ; tableau  une dimension
	IF ok THEN ok = info[2] EQ 5 ; double
	IF ~ok THEN BEGIN
		PRINT, '% data_to_image: argument Xmoy_data incorrect'
		RETURN, -1
	END

	info = SIZE(Xmax_data)
	ok = info[0] EQ 1            ; tableau  une dimension
	IF ok THEN ok = info[2] EQ 5 ; double
	IF ~ok THEN BEGIN
		PRINT, '% data_to_image: argument Xmax_data incorrect'
		RETURN, -1
	END

	info = SIZE(Ymin_data)
	ok = info[0] EQ 2            ; tableau  deux dimensions
	IF ok THEN ok = info[3] EQ 4 ; float
	IF ~ok THEN BEGIN
		PRINT, '% data_to_image: argument Ymin_data incorrect'
		RETURN, -1
	END

	info = SIZE(Ymoy_data)
	ok = info[0] EQ 2            ; tableau  deux dimensions
	IF ok THEN ok = info[3] EQ 4 ; float
	IF ~ok THEN BEGIN
		PRINT, '% data_to_image: argument Ymoy_data incorrect'
		RETURN, -1
	END

	info = SIZE(Ymax_data)
	ok = info[0] EQ 2            ; tableau  deux dimensions
	IF ok THEN ok = info[3] EQ 4 ; float
	IF ~ok THEN BEGIN
		PRINT, '% data_to_image: argument Ymax_data incorrect'
		RETURN, -1
	END

	info = SIZE(indY)
	ok = info[0] EQ 1            ; tableau  une dimension
	IF ok THEN ok = info[2] EQ 3 ; longint
	IF ~ok THEN BEGIN
		PRINT, '% data_to_image: argument indY incorrect'
		RETURN, -1
	END

	info = SIZE(Zdata)
	ok = info[0] EQ 2              ; tableau  deux dimensions
	IF ok THEN ok = info[3] EQ 4  ; float
	IF ~ok THEN BEGIN
		PRINT, '% data_to_image: argument Zdata incorrect'
		RETURN, -1
	END

	IF nbx LE 0 THEN BEGIN
		PRINT, '% data_to_image: nbx doit etre > 0'
		RETURN, -1
	END

	IF xmax LE xmin THEN BEGIN
		PRINT, '% data_to_image: xmax doit etre > xmin'
		RETURN, -1
	END

	dx = (xmax-xmin)/nbx
	nbx_xdata = N_ELEMENTS(Xmin_data)

	IF nby LE 0 THEN BEGIN
		PRINT, '% data_to_image: nby doit etre > 0'
		RETURN, -1
	END

	IF ymax LE ymin THEN BEGIN
		PRINT, '% data_to_image: ymax doit etre > ymin'
		RETURN, -1
	END

	info = SIZE(produitdata)
	ok = info[0] EQ 1            ; tableau  une dimension
	IF ok THEN ok = info[2] EQ 2 ; short
	IF ~ok THEN BEGIN
		PRINT, '% data_to_image: argument produitdata incorrect'
		RETURN, -1
	END

	dy = (ymax-ymin)/nby
	nbx_ydata = N_ELEMENTS(Ymin_data[*,0])
	nby_ydata = N_ELEMENTS(Ymin_data[0,*])

	IF normaliser GT 0 THEN BEGIN
		top1 = nbsec()
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'NORMALIZE_AUTO_GLUE',	$
					normaliser, nbx_xdata, nbx_ydata, nby_ydata, Zdata, infini, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'NORMALIZE',		$
					normaliser, nbx_xdata, nbx_ydata, nby_ydata, Zdata, infini)
		END
		top2 = nbsec()
		IF top2-top1 GT 10 THEN PRINT, 'normalize in ' + val_to_str(top2-top1) + ' sec'
	END

	IF premier THEN BEGIN
		image        = REPLICATE (infini, nbx, nby)
		produitimage = REPLICATE (infini, nbx)
		nb           = REPLICATE (0L, nbx, nby)
		utilise      = REPLICATE (0L, nbx)
	END

	IF interp EQ 2 THEN BEGIN

		modif = Xmax_data[nbx_xdata-1]+dttrou GE xmin_next
		IF modif THEN BEGIN
			tmp = Xmax_data[nbx_xdata-1]
			Xmax_data[nbx_xdata-1] = xmin_next
		END
		top1 = nbsec()
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('interpoler2dxy'), 'INTERPOLER2DXY_AUTO_GLUE',		$
					      Xmin_data, Xmoy_data, Xmax_data, nbx_xdata, dttrou, 			$
					      Ymin_data, Ymoy_data, Ymax_data, nbx_ydata, nby_ydata, indY, Zdata, 	$
					      xmin, dx, nbx, ymin, dy, nby, image, nb, utilise, infini, 		$
					      produitdata, produitimage, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('interpoler2dxy'), 'INTERPOLER2DXY',			$
					      Xmin_data, Xmoy_data, Xmax_data, nbx_xdata, dttrou, 			$
					      Ymin_data, Ymoy_data, Ymax_data, nbx_ydata, nby_ydata, indY, Zdata, 	$
					      xmin, dx, nbx, ymin, dy, nby, image, nb, utilise, infini, 		$
					      produitdata, produitimage)
		END
		IF modif THEN Xmax_data[nbx_xdata-1] = tmp
		top2 = nbsec()
		IF top2-top1 GT 10 THEN PRINT, 'interpoler2dxy in ' + val_to_str_2decimales(top2-top1) + ' sec'

	END ELSE BEGIN

		tmp1 = SORT (Xmin_data)-LINDGEN(nbx1)
		tmp2 = WHERE (tmp1 NE 0)
		croissant = tmp2[0] EQ -1
		x1_data = FLOOR (([Xmin_data,xmin_next]-xmin)/dx)
		x2_data = CEIL ((Xmax_data-xmin)/dx)
		x3_data = CEIL ((Xmax_data+dttrou-xmin)/dx)
		xf_data = REPLICATE (1L, nbx_xdata) ; FLAG plage de temps visible

		y1_data = REPLICATE (-1L, nbx_ydata, nby_ydata)
		ind = WHERE(Ymin_data NE infini)
		IF ind[0] NE -1 THEN y1_data[ind] = ROUND ((Ymin_data[ind]-ymin)/dy)

		y2_data = REPLICATE (-1L, nbx_ydata, nby_ydata)
		ind = WHERE(Ymax_data NE infini)
		IF ind[0] NE -1 THEN y2_data[ind] = ROUND ((Ymax_data[ind]-ymin)/dy)

		yf_data = REPLICATE (1L, nbx_ydata, nby_ydata) ; FLAG plage d'energie visible

		; Trou de donnes: ajustement ventuel de x2_data
		; -----------------------------------------------
		IF nbx_xdata GT 1 THEN BEGIN
			ind = WHERE ((x3_data[0:nbx_xdata-1] GE x1_data[1:nbx_xdata]) AND (x1_data[0:nbx_xdata-1] LT x1_data[1:nbx_xdata]-1))
			IF ind[0] NE -1 THEN x2_data[ind] = x1_data[1+ind] - 1
		END

		; Plages de temps totalement hors limite
		; --------------------------------------
		ind = WHERE ((x2_data LT 0) OR (x1_data GT nbx-1))
		IF ind[0] NE -1 THEN xf_data[ind] = 0

		; Plages de temps partiellement visibles
		; --------------------------------------
		ind = WHERE ((x1_data LT 0) AND xf_data)
		IF ind[0] NE -1 THEN x1_data[ind] = 0
		ind = WHERE ((x2_data GT nbx-1) AND xf_data)
		IF ind[0] NE -1 THEN x2_data[ind] = nbx-1

		IF nbx_xdata GT 1 AND croissant THEN BEGIN
			; Chevauchement des plages de temps: ajustement ventuel de x2_data
			; -----------------------------------------------------------------
			;
			; | x1 |    | x2 |    |    |    | ->   | x1 | x2 |    |    |    |    |
			; |    |    | x1 |    |    | x2 | ->   |    |    | x1 |    |    | x2 |
			;
			ind = WHERE ((x2_data[0:nbx_xdata-1] GE x1_data[1:nbx_xdata]) AND (x2_data[0:nbx_xdata-1] NE x1_data[0:nbx_xdata-1]))
			IF ind[0] NE -1 THEN x2_data[ind]--
		END

		IF interp EQ 1 THEN BEGIN
			top1 = nbsec()
			IF is_fdl() THEN BEGIN
				lint_unused = CALL_EXTERNAL (libname('interpoler2dy'), 'INTERPOLER2DY_AUTO_GLUE',	$
						      x1_data, x2_data, xf_data, nbx_xdata,				$
						      Ymin_data, Ymoy_data, Ymax_data, nbx_ydata, nby_ydata, indY,	$
						      Zdata, image, nb, utilise, nbx, nby, ymin, dy, moyenner, infini,	$
						      produitdata, produitimage, /AUTO_GLUE)
			END ELSE BEGIN
				lint_unused = CALL_EXTERNAL (libname('interpoler2dy'), 'INTERPOLER2DY',			$
						      x1_data, x2_data, xf_data, nbx_xdata,				$
						      Ymin_data, Ymoy_data, Ymax_data, nbx_ydata, nby_ydata, indY,	$
						      Zdata, image, nb, utilise, nbx, nby, ymin, dy, moyenner, infini,	$
						      produitdata, produitimage)
			END
			top2 = nbsec()
			IF top2-top1 GT 10 THEN PRINT, 'interpoler2dy in ' + val_to_str_2decimales(top2-top1) + ' sec'
		END ELSE IF interp EQ 0 THEN BEGIN
			top1 = nbsec()
			IF is_fdl() THEN BEGIN
				lint_unused = CALL_EXTERNAL (libname('noninterpoler2d'), 'NONINTERPOLER2D_AUTO_GLUE',	$
						      x1_data, x2_data, xf_data, nbx_xdata,			$
						      y1_data, y2_data, yf_data, nbx_ydata, nby_ydata, indY,	$
						      Zdata, image, nb, utilise, nbx, nby, moyenner, infini,	$
						      produitdata, produitimage, /AUTO_GLUE)
			END ELSE BEGIN
				lint_unused = CALL_EXTERNAL (libname('noninterpoler2d'), 'NONINTERPOLER2D',	$
						      x1_data, x2_data, xf_data, nbx_xdata,			$
						      y1_data, y2_data, yf_data, nbx_ydata, nby_ydata, indY,	$
						      Zdata, image, nb, utilise, nbx, nby, moyenner, infini,	$
						      produitdata, produitimage)
			END
			top2 = nbsec()
			IF top2-top1 GT 10 THEN PRINT, 'noninterpoler2d in ' + val_to_str_2decimales(top2-top1) + ' sec'
		END
	END

	RETURN, 1

END

;-------------------------------------------------------------------------------
PRO get_minmax,	$
;-------------------------------------------------------------------------------
	tab,	$	; LINT_PROTOTYPE input
	min,	$	; LINT_PROTOTYPE output
	max,	$	; LINT_PROTOTYPE output
	nb=nb,	$	; LINT_PROTOTYPE input
	diff=diff	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (IMAGE) ((-)) Retourne le min et le max des valeurs a utiliser en Z pour utiliser au mieux la palette de couleurs.
;
; Entrees: 
; --------
;  tab: tableau a tester
;  nb: pour etendre les valeurs de min et max de maniere a ce qu'en utilisant
;      une palette avec des couleurs allant de 0 a nb-1, min corresponde a la
;      couleur 1 et max a la couleur nb-2
;  diff: pour n'avoir jamais min egal a max
;
; Sorties:
; --------
;    min: valeur min de tab
;    max: valeur max de tab
;-------------------------------------------------------------------------------

	indok = WHERE (tab NE !VALUES.F_INFINITY)
	IF indok[0] NE -1 THEN BEGIN
		min = MIN (tab[indok], MAX=max)
	END ELSE BEGIN
		IF N_ELEMENTS(diff) EQ 0 THEN BEGIN
			min = !VALUES.F_INFINITY
			max = !VALUES.F_INFINITY
		END ELSE BEGIN
			min = 1.
			max = 2.
		END
	END

	IF N_ELEMENTS(nb) NE 0 THEN BEGIN
		min1 = min-1.5*(max-min)/(nb-3)
		max1 = max+1.5*(max-min)/(nb-3)
		min = min1
		max = max1
	END

	IF N_ELEMENTS(diff) NE 0 THEN BEGIN
		IF min EQ max THEN BEGIN
			min -= 0.1*ABS(min)+1
			max += 0.1*ABS(min)+1
		END
	END

END

;-------------------------------------------------------------------------------
FUNCTION charger_palette,	$
;-------------------------------------------------------------------------------
	numero,		$	; LINT_PROTOTYPE input
	nbcolors,	$	; LINT_PROTOTYPE input
	inverser,	$	; LINT_PROTOTYPE input
	rvb_first,	$	; LINT_PROTOTYPE input
	rvb_last,	$	; LINT_PROTOTYPE input
	rvb			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (IMAGE) ((1:ok 0:pb)) Charge la palette de couleur (-1) de 'TABGRGB.tbl' ou une des palette de 'colors1.tbl'.
;
;   Entrees:
;   ========
;    numero:
;        0:      palette des courbes (9 couleurs  + BLANC + NOIR)
;        1 ou 2: palette des spectrogrammes (11 couleurs + BLANC + NOIR)
;        3..40:  chargement d'une des 38 palettes d'IDL (62 couleurs + BLANC +
;   NOIR)
;
;   nbcolors
;   inverser
;   rvb_first: r vaut -1 pour rvb automatique
;   rvb_last: r vaut -1 pour rvb automatique
;
;   Sorties:
;   ========
;   rvb
;    !P.COLOR est mis a jour avec l'indice correspondant au noir. L'indice 0
;   correspond au blanc, l'indice !P.COLOR correspond au noir.
;
;
;        Cette procedure permet de charger une palette de couleurs. Elle attend
;   un parametre compris entre 0 et 40. Si ce parametre vaut 0, 1, 2 ou 36
;   (palette interessante d'IDL), les couleurs sont codees directement dans la
;   procedure. Sinon, les couleurs sont recuperees dans un fichier de nom
;   "colors1.tbl" qui doit etre accessible soit dans le repertoire courant, soit
;   au travers du chemin donne par la variable !PATH. Ce fichier est le fichier
;   des couleurs d'IDL (38 palettes).
;-------------------------------------------------------------------------------

	IF numero LT -1 OR numero GT 41 THEN RETURN, 0

	IF numero EQ -1 THEN BEGIN

		filename = 'TABGRGB.tbl'
		; Lecture de la palette de couleurs dans le fichier filename
		filename1 = chercher_fichier (filename)
		IF filename1 EQ '' THEN BEGIN
			PRINT, 'Unable to find '+filename
			RETURN, 0
		END
		OPENR, fd, filename1, /GET_LUN ; contient 64 lignes de 3 colonnes: r, v, b
		rvb = REPLICATE(0b, 3, 64)
		READF, fd, rvb
		FREE_LUN, fd  

		p = (LINDGEN(nbcolors) * 63) / (nbcolors-1)
		rvb = TRANSPOSE (rvb[*,p])

	END ELSE BEGIN

		filename = 'colors1.tbl'
		; Lecture de la palette de couleurs dans le fichier filename
		filename1 = chercher_fichier (filename)
		IF filename1 EQ '' THEN BEGIN
			PRINT, 'Unable to find '+filename
			RETURN, 0
		END

		OPENR, lun, filename1, /block, /get_lun
		ntables = 0b
		READU, lun, ntables
		names = BYTARR(32, ntables)
		POINT_LUN, lun, ntables * 768L + 1	;Read table names
		READU, lun, names
		names = STRTRIM(names, 2)
		aa = ASSOC(lun, BYTARR(256), 1)	;Read 256 long ints
		r = aa[numero*3]
		v = aa[numero*3+1]
		b = aa[numero*3+2]

		FREE_LUN, lun

		p = (LINDGEN(nbcolors) * 255) / (nbcolors-1)
		rvb = [[r[p]],[v[p]],[b[p]]]

	END

	IF rvb_first.r EQ -1 THEN BEGIN
		rvb_first.r = rvb[0,0]
		rvb_first.v = rvb[0,1]
		rvb_first.b = rvb[0,2]
	END ELSE BEGIN
		rvb[0,0] = rvb_first.r
		rvb[0,1] = rvb_first.v
		rvb[0,2] = rvb_first.b
	END

	IF rvb_last.r EQ -1 THEN BEGIN
		rvb_last.r = rvb[nbcolors-1,0]
		rvb_last.v = rvb[nbcolors-1,1]
		rvb_last.b = rvb[nbcolors-1,2]
	END ELSE BEGIN
		rvb[nbcolors-1,0] = rvb_last.r
		rvb[nbcolors-1,1] = rvb_last.v
		rvb[nbcolors-1,2] = rvb_last.b
	END

	IF inverser THEN rvb = REVERSE (rvb) ; Inversion de la palette ?

	rvb1 = REPLICATE ({ var_pal, r:0, v:0, b:0 }, nbcolors)
	rvb1.r = rvb[*,0]
	rvb1.v = rvb[*,1]
	rvb1.b = rvb[*,2]
	rvb = rvb1

	RETURN, 1

END

;-------------------------------------------------------------------------------
FUNCTION get_nbx1_nby1,	$
;-------------------------------------------------------------------------------
	constraint,	$	; LINT_PROTOTYPE input
	nbx,		$	; LINT_PROTOTYPE input
	nby,		$	; LINT_PROTOTYPE input
	xsize,		$	; LINT_PROTOTYPE input
	ysize,		$	; LINT_PROTOTYPE input
	nbx1,		$	; LINT_PROTOTYPE output
	nby1			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (IMAGE) ((0:ok -1:pb)) Retourne les dimensions qu'il faudra donner  une image (en fonction de constraint None, Proportion, Original size).
;-------------------------------------------------------------------------------

	IF constraint EQ 'None' THEN BEGIN
		nbx1 = xsize
		nby1 = ysize
	END ELSE IF constraint EQ 'Proportion' THEN BEGIN
		ratio = FLOAT(nbx)/FLOAT(nby)
		ratio1 = FLOAT(xsize)/FLOAT(ysize)
		IF ratio1 GT ratio THEN BEGIN
			nby1 = ysize
			nbx1 = ROUND(ratio*nby1)
		END ELSE BEGIN
			nbx1 = xsize
			nby1 = ROUND(nbx1/ratio)
		END
	END ELSE IF constraint EQ 'Original size' THEN BEGIN
		IF xsize LT nbx OR ysize LT nby THEN RETURN, -1
		nbx1 = nbx
		nby1 = nby
	END

	RETURN, 0

END


;-------------------------------------------------------------------------------
PRO ecrire_orbito,	$
;-------------------------------------------------------------------------------
	tab_data,	$	; LINT_PROTOTYPE input
	t1,		$	; LINT_PROTOTYPE input
	t2,		$	; LINT_PROTOTYPE input
	x0,		$	; LINT_PROTOTYPE input
	x1,		$	; LINT_PROTOTYPE input
	x2,		$	; LINT_PROTOTYPE input
	y1,		$	; LINT_PROTOTYPE input
	y2,		$	; LINT_PROTOTYPE input
	orb_txt,	$	; LINT_PROTOTYPE input
	tailleorb,	$	; LINT_PROTOTYPE input
	fontorb,	$	; LINT_PROTOTYPE input
	epaisorb,	$	; LINT_PROTOTYPE input
	presence,	$	; LINT_PROTOTYPE input
	nocouleur		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (PLOT) ((-)) Ecrit les donnes d'orbite en bas du trac.
;
;   Entrees:
;   ========
;    tab_enreg_orb: tableau d'enregistrements orbitographie
;
;    Orbmax: nombre de valeurs (moins une) a afficher
;
;    dt: nombre de secondes sur la vue
;
;    tmin: temps de debut (Date & Time) de la vue
;
;    Orb_t0: temps de reference (Date & Time) des donnes orbitographie
;
;    larg: largeur de la vue (en coordonnes normalisees)
;
;    x1: abscisse correspondant a tmin (en coordonnes normalises)
;
;    x2: abscisse correspondant a tmin + dt (en coordonnes normalises)
;
;    x0: abscisse la plus faible de la fenetre (coordonnes normalises)
;
;    y0: ordonnee la plus faible de la fenetre (coordonnes normalises)
;
;    L3: pourcentage de la vue attribuee a l'orbitographie en Y normalise
;
;    Orb_txt: 4 chaines de caracteres
;
;    tailleorb: taille des chaines et des valeurs numeriques
;
;    fontorb: fonte des chaines et des valeurs numeriques
;
;    epaisorb: epaisseur des chaines et des valeurs numeriques
;
;
;        Cette procedure permet d'afficher les donnes d'orbitographie en bas de
;   la vue. Les donnes  crire sont slectionnes par dichotomie.
;-------------------------------------------------------------------------------

	nbpresent = 0
	ind = REPLICATE(0, N_ELEMENTS(presence))
	FOR i=0L,N_ELEMENTS(presence)-1 DO BEGIN
		IF presence[i] THEN BEGIN
			ind[i] = nbpresent
			nbpresent++
		END
	END

	IF tailleorb EQ 0 THEN RETURN

	x = (x0+x1)/2
	FOR n = 0L, N_ELEMENTS(orb_txt)-1 DO BEGIN
		IF presence[n] THEN BEGIN
			libplot_xyouts, x, y1 + (y2-y1)*(nbpresent-ind[n])/(1+nbpresent), orb_txt[n], /normal,		$
				charsize=tailleorb, charthick=epaisorb, alignment=0.5, color=nocouleur
		END
	END

	IF N_ELEMENTS(tab_data[0,*])-1 NE N_ELEMENTS(orb_txt) THEN RETURN

	; Affichage des valeurs
	; ---------------------

	; Passage en fonte Orbitographie
	libplot_xyouts, 0, 0, fontorb, /normal
	FOR i=0L,N_ELEMENTS(tab_data[*,0])-1 DO BEGIN
		IF tab_data[i,0] LT 1.0e30 THEN BEGIN
			x = x1 + (x2-x1)*(tab_data[i,0]-t1)/(t2-t1)
			FOR n = 0L, N_ELEMENTS(orb_txt)-1 DO BEGIN
				IF presence[n] THEN BEGIN
					IF orb_txt[n] NE '' THEN BEGIN
						val = tab_data[i,1+n]
						libplot_xyouts, x, y1+(y2-y1)*(nbpresent-ind[n])/(1+nbpresent),				$
							val GT -1E31 ? STRCOMPRESS(STRING (val, format='(F20.2)'), /remove_all) : '-' ,	$
							/normal, charsize=tailleorb, charthick=epaisorb, alignment=0.5,			$
							color=nocouleur
					END
				END
			END
		END
	END

END

;------------------------------------------------------------------------------
PRO show_dir,	$
;------------------------------------------------------------------------------
	dir,			$	; LINT_PROTOTYPE input
	x0,			$	; LINT_PROTOTYPE input
	y0,			$	; LINT_PROTOTYPE input
	taillex,		$	; LINT_PROTOTYPE input
	nocouleur,		$	; LINT_PROTOTYPE input
	noncentre=noncentre		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (PLOT) ((-)) Dessine une direction de vise.
;
; dir=0 Sun
;     1 Dusk
;     2 Tail
;     3 Dawn
;     4 All
;
; noncentre=1 pour ne pas centrer le symbole en (x0,y0)
;-------------------------------------------------------------------------------

	; Il faut definir une region pour qu'un cercle reste un cercle

	IF dir EQ 4 THEN BEGIN
		show_dir, 0, x0, y0, taillex/2, nocouleur, /noncentre
		show_dir, 1, x0, y0, taillex/2, nocouleur, /noncentre
		show_dir, 2, x0, y0, taillex/2, nocouleur, /noncentre
		show_dir, 3, x0, y0, taillex/2, nocouleur, /noncentre
	END ELSE BEGIN
		ATAN2 = 63.43494882292200998108

		tailley = taillex * libplot_get(/D_X_SIZE) / libplot_get(/D_Y_SIZE)

		x1 = x0 - taillex/2
		x2 = x0 + taillex/2
		y1 = y0 - tailley/2
		y2 = y0 + tailley/2

		IF N_ELEMENTS(noncentre) EQ 0 THEN BEGIN
			x = [x0,x2,x0,x1] & x = x[dir]
			y = [y1,y0,y2,y0] & y = y[dir]
			theta1 = INDGEN(4)*!pi/2 + ATAN2*!pi/180
			theta2 = theta1 + !pi-2*ATAN2*!pi/180
			theta1 = theta1[dir]
			theta2 = theta2[dir]
		END ELSE BEGIN
			theta1 = !pi/4 + INDGEN(4)*!pi/2 & theta1 = theta1[dir]
			theta2 = theta1  + !pi/2 
			x = x0
			y = y0
		END

		lx = taillex/(2*COS(ATAN2*!pi/180))
		ly = tailley/SIN(ATAN2*!pi/180)

		xa = x + lx*COS(theta1)
		ya = y + ly*SIN(theta1)
		xb = x + lx*COS(theta2)
		yb = y + ly*SIN(theta2)

		tabx = [xa,x,xb]
		taby = [ya,y,yb]
		libplot_plots, tabx, taby, /normal, color=nocouleur

		nb = 20
		tabx = x + 0.75*taillex*COS(theta1+INDGEN(nb)*(theta2-theta1)/(nb-1))  
		taby = y + 0.75*tailley*SIN(theta1+INDGEN(nb)*(theta2-theta1)/(nb-1))  
		libplot_plots, tabx, taby, /normal, color=nocouleur
	END

END


;-------------------------------------------------------------------------------
PRO show_palette,	$
;-------------------------------------------------------------------------------
	x1,		$	; LINT_PROTOTYPE input
	x2,		$	; LINT_PROTOTYPE input
	y1,		$	; LINT_PROTOTYPE input
	y2,		$	; LINT_PROTOTYPE input
	xval,		$	; LINT_PROTOTYPE input
	yval,		$	; LINT_PROTOTYPE input
	tailleld,	$	; LINT_PROTOTYPE input
	epaisld,	$	; LINT_PROTOTYPE input
	nbld,		$	; LINT_PROTOTYPE input
	format,		$	; LINT_PROTOTYPE input
	minz,		$	; LINT_PROTOTYPE input
	maxz,		$	; LINT_PROTOTYPE input
	ldtxt,		$	; LINT_PROTOTYPE input
	xtexte,		$	; LINT_PROTOTYPE input
	ytexte,		$	; LINT_PROTOTYPE input
	couleurs,	$	; LINT_PROTOTYPE input
	couleur			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (PLOT) ((-)) Affiche la palette de couleurs associ  un spectrogramme.
;
;   Entrees:
;   ========
;    x1, x2, y1, y2: definition, en coordonnes normalises, du rectangle
;   utilise pour afficher la palette de couleurs
;
;    minz et maxz: valeurs minimum et maximum utilises sur la palette de
;   couleurs
;
;    autres parametres: voir la procedure spe
;
;
;        Cette procedure affiche la palette de couleurs a droite du
;   spectrogramme. La palette contient !P.COLOR-1 couleurs, un titre et des
;   valeurs numeriques (a gauche de la palette).
;-------------------------------------------------------------------------------

	dy = y2-y1

	; Affichage du texte de la legende des axes Y
	IF ldtxt NE '' THEN BEGIN
		; debut du texte en xtexte => le texte sort parfois de la page
		libplot_xyouts, xtexte, ytexte, /normal, ldtxt, alignment=0, charsize=tailleld, charthick=epaisld, color=couleur

		; texte centre sur (x1+x2)*0.5 => le texte est un peu trop  gauche
		;libplot_xyouts, (x1+x2)*0.5, ytexte, /normal, ldtxt, alignment=0.5, charsize=tailleld, charthick=epaisld, color=couleur

		; texte centre sur xval
		;libplot_xyouts, xval, ytexte, /normal, ldtxt, alignment=0.5, charsize=tailleld, charthick=epaisld, color=couleur
	END

	; Combien de couleurs faut-il afficher ?
	max = N_ELEMENTS(couleurs)

	; format contient le format ou "Normalized "+format, le format pouvant etre vide
	; /PRESERVE_NULL est indispensable
	tmp = STRSPLIT(format, /EXTRACT, /PRESERVE_NULL)

	IF N_ELEMENTS(tmp) EQ 2 THEN BEGIN
		libplot_xyouts, xtexte, y1-2*(ytexte-y2), tmp[0], /normal, charsize=tailleld, charthick=epaisld, alignment=0, color=couleur, orientation=0
		format2 = tmp[1]
	END ELSE BEGIN
		format2 = tmp[0]
	END

	; --- On affiche 'nbld' valeurs numeriques dans le format 'format'
	deltaz = (maxz-minz)/max
	FOR i=0L,nbld-1 DO BEGIN
		val = minz+deltaz*i/(nbld-1)*max
		ok = 1
		;IF ok THEN str = format2 EQ '' ? val_to_str_1decimale(val) : STRCOMPRESS(STRING(val, FORMAT=format2), /REMOVE_ALL)
		IF ok THEN str = format2 EQ '' ? val_to_str_1decimale(val) : STRING(val, FORMAT=format2)
		libplot_xyouts, xval, yval + 1.5*dy/max + (dy-3*dy/max)*i/(nbld-1), str,		$
			/normal, charsize=tailleld, charthick=epaisld, alignment=0, color=couleur
	END

	; On affiche toutes les couleurs
	xinf = x1
	xsup = x2
	FOR i=0L,max-1 DO BEGIN
		yinf = y1 + dy*i/max
		ysup = y1 + dy*(i+1)/max
		libplot_polyfill, [xinf,xinf,xsup,xsup,xinf], [yinf,ysup,ysup,yinf,yinf], Color=couleurs[i], /normal
	END

	; On affiche le cadre contenant les couleurs
	libplot_plots, [x1,x1,x2,x2,x1], [y1,y2,y2,y1,y1], /normal, color=couleur

END

;-------------------------------------------------------------------------------
FUNCTION get_tickname,	$
;-------------------------------------------------------------------------------
	tickname	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (PLOT) ((-)) Retourne une copie de tickname en supprimant les "'" de dbut et fin et en changeant '*' par ' '.
;-------------------------------------------------------------------------------

	FOR i=0L,N_ELEMENTS(tickname)-1 DO BEGIN

		; Supprimer le "'" de dbut
		IF STRMID(tickname[i], 0, 1) EQ "'" THEN tickname[i] = STRMID(tickname[i], 1, STRLEN(tickname[i])-1)

		; Supprimer le "'" de fin
		IF STRMID(tickname[i], STRLEN(tickname[i])-1, 1) EQ "'" THEN tickname[i] = STRMID(tickname[i], 0, STRLEN(tickname[i])-1)

		; Changer les '*' de tickname par ' '
		IF tickname[i] EQ '*' THEN tickname[i] = ' '

	END

	RETURN, tickname

END

;-------------------------------------------------------------------------------
FUNCTION get_tickformat,	$
;-------------------------------------------------------------------------------
	format_type,	$	; LINT_PROTOTYPE input
	format_w,	$	; LINT_PROTOTYPE input
	format_q		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (PLOT) ((-)) Calcule et retourne tickformat.
;-------------------------------------------------------------------------------

	IF format_type EQ 'Automatic' THEN BEGIN
		tickformat = ''
	END ELSE BEGIN
		tickformat = '(' + format_type + chiffre_to_str(format_w) + '.' + chiffre_to_str(format_q) + ')'
	END

	RETURN, tickformat

END

;-------------------------------------------------------------------------------
PRO corriger_min_max,	$
;-------------------------------------------------------------------------------
	ymin,		$	; LINT_PROTOTYPE input
	ymax,		$	; LINT_PROTOTYPE input
	ylog			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (PLOT) ((-)) Corrige ymin et ymax pour que l'on puisse faire un trac en Y entre ymin et ymax, en log si log==1.
;-------------------------------------------------------------------------------

	ymin = FLOAT(ymin) & ymax = FLOAT(ymax) ; si les donnes sont entieres!
	IF ymin EQ !VALUES.F_INFINITY THEN BEGIN
		ymin = 1.0E19
		ymax = 1.0E21 ; car 1.0E34 et 1.0E35 semblent causer des Floating underflow
	END
	IF ylog THEN BEGIN
		IF ymax EQ 0 THEN ymax = 0.01
		IF ymin EQ 0 THEN ymin = ymax GT 0.01 ?  0.01 : ymax/2.
		IF ymin EQ ymax THEN ymax = ymin+1
		; On etend les echelles (changement de dcade)
		ymin1 = 10^DOUBLE(FLOOR(ALOG10(ymin)))	; DOUBLE pour MAVEN_NGIMS
		ymax1 = 10^DOUBLE(CEIL(ALOG10(ymax)))	; DOUBLE pour MAVEN_NGIMS
		ymin = ymin1 EQ ymin ? 10^DOUBLE(FLOOR(ALOG10(ymin))-1) : ymin1
		ymax = ymax1 EQ ymax ? 10^DOUBLE(CEIL(ALOG10(ymax))+1)  : ymax1
		IF ymin EQ ymax THEN BEGIN
			; arrive par exemple si au dpart ymin=ymax=1e31
			ymin *= 0.1
			ymax *= 10
		END
	END ELSE IF ymin EQ ymax THEN BEGIN

		; Ancienne version qui ne va pas pour TARANIS
		;IF ymin EQ 0 THEN BEGIN
		;	ymin -= 0.1*ABS(ymin)+1
		;	ymax += 0.1*ABS(ymin)+1
		;END ELSE BEGIN
		;	ymin -= 0.1*ABS(ymin)
		;	ymax += 0.1*ABS(ymin)
		;END

		; Nouvelle version pour numro d'orbite de TARANIS
		ymin -= 0.1 ; pour numro d'orbite de TARANIS
		ymax += 0.1 ; pour numro d'orbite de TARANIS

		; 19/06/2018: Si ymin==ymax=-1e30, on se retrouve avec ymin et ymax identiques
		pas = 0.1
		WHILE ymin EQ ymax DO BEGIN
			pas *= 10
			ymin -= pas
			ymax += pas
		END

	END ELSE BEGIN
		; On etend les echelles de 10 %

		; Sur MAVEN_NGIMS:
		; YMIN            FLOAT     =       0.00000
		; YMAX            FLOAT     =   3.28837e+38
		; Ca met ymax  Inf
		; On passe en DOUBLE

		ymin = DOUBLE(ymin)
		ymax = DOUBLE(ymax)
		dy = ymax-ymin
		ymin -= dy/10
		ymax += dy/10
	END

END

;-------------------------------------------------------------------------------
FUNCTION ouvrir_device,	$
;-------------------------------------------------------------------------------
	name,		$	; LINT_PROTOTYPE input
	orientation,	$	; LINT_PROTOTYPE input
	encapsule,	$	; LINT_PROTOTYPE input
	mg,		$	; LINT_PROTOTYPE input
	md,		$	; LINT_PROTOTYPE input
	mh,		$	; LINT_PROTOTYPE input
	mb,		$	; LINT_PROTOTYPE input
	rap,		$	; LINT_PROTOTYPE input
	long,		$	; LINT_PROTOTYPE input
	larg,		$	; LINT_PROTOTYPE input
	coul,		$	; LINT_PROTOTYPE input
	true			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (SYS) ((1:ok -1:pb)) Ouvre un DEVICE IDL.
;
;   Entres:
;   -------
;    name: nom du fichier ou de la fenetre a ouvrir
;
;    ps:
;        1 pour une sortie fichier graphique
;        sinon sortie ecran
;
;    land:
;        0 pour une sortie portrait
;        1 pour une sortie landscape
;
;    nopalette: numero de la palette de couleurs a charger
;
;    liste_fd: file descriptor du fichier contenant les noms des fichiers
;   graphiques crees
;
;        Cette procedure est a appeler une seule fois pour chaque type de trace.
;   Elle initialise le driver de sortie et charge la palette de couleurs voulue.
;-------------------------------------------------------------------------------

	ON_IOERROR, erreur

	IF rap LT 1 THEN BEGIN ; les marges sont forcement automatiquement calculees
		IF orientation EQ 'Landscape' THEN BEGIN
			mdg = (long-mg-md)*(1-rap)/2.
			mg1 = mg + mdg
			md1 = md + mdg
			mhb = (larg-mh-mb)*(1-rap)/2.
			mh1 = mh + mhb
			mb1 = mb + mhb
		END ELSE BEGIN
			mdg = (larg-mg-md)*(1-rap)/2.
			mg1 = mg + mdg
			md1 = md + mdg
			mhb = (long-mh-mb)*(1-rap)/2.
			mh1 = mh + mhb
			mb1 = mb + mhb
		END
	END ELSE BEGIN
		mg1 = mg
		md1 = md
		mh1 = mh
		mb1 = mb
	END

	IF libplot_get(/D_NAME) EQ 'PRINTER' THEN BEGIN

		IF true THEN libplot_device_printer, /true_color
		; Le device Printer prevoit deja une marge d'approximativement 0.55 cm a gauche et en bas
		IF orientation EQ 'Landscape' THEN BEGIN
			libplot_device_printer, xsize=long-mg1-md1, ysize=larg-mh1-mb1, xoffset=mg1-0.55, yoffset=mb1-0.55
		END ELSE BEGIN
			libplot_device_printer, xsize=larg-mg1-md1, ysize=long-mh1-mb1, xoffset=mg1-0.55, yoffset=mb1-0.55
		END

	END ELSE IF libplot_get(/D_NAME) EQ 'PS' THEN BEGIN

		libplot_device_ps, filename=name, encapsulated=encapsule, /color
		IF orientation EQ 'Landscape' THEN BEGIN
			libplot_device_ps, /landscape, xsize=long-mg1-md1, ysize=larg-mh1-mb1, xoffset=mh1, yoffset=long-mg1
		END ELSE BEGIN
			libplot_device_ps, /portrait, xsize=larg-mg1-md1, ysize=long-mh1-mb1, xoffset=mg1, yoffset=mb1
		END
		libplot_device_ps, bits=8

	END ELSE IF libplot_get(/D_NAME) EQ 'PNG' THEN BEGIN

		libplot_device_png, filename=name
		IF orientation EQ 'Landscape' THEN BEGIN
			libplot_device_png, /landscape
		END ELSE BEGIN
			libplot_device_png, /portrait
		END
		libplot_device_png, bits=8

	END ELSE BEGIN

		libplot_erase, coul

	END

	RETURN, 1

erreur:
	RETURN, -1

END

;-------------------------------------------------------------------------------
PRO imprimer,	$
;-------------------------------------------------------------------------------
	nom,	$	; LINT_PROTOTYPE input
	cmdprint	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (SYS) ((-)) Imprime un fichier en utilisant la commande Unix fournie en paramtre.
;
;   Entres:
;   -------
;    file: nom du fichier a imprimer
;
;    cmdprint: commande Unix pour imprimer (ex: 'lp -d pro')
;
;
;        Cette procedure imprime le fichier nom sur en utilisant la commande cmdprint.
;-------------------------------------------------------------------------------

	commande = cmdprint + ' ' + nom

	PRINT, 'Printing file '+nom+' ('+commande+')'
	SPAWN, commande

	commande = '\rm '+nom
	PRINT, 'Removing file '+nom+' ('+commande+')'
	SPAWN, commande

END

;-------------------------------------------------------------------------------
PRO curseur,	$
;-------------------------------------------------------------------------------
	x 		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (SYS) ((-)) Change l'apparence du curseur.
;-------------------------------------------------------------------------------

	libplot_device_x, cursor_standard=x

END

;-------------------------------------------------------------------------------
PRO ecrire_profiler,	$
;-------------------------------------------------------------------------------
	nbsec_mini,	$	; LINT_PROTOTYPE input
	nomfichier		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (SYS) ((-)) Ecrit les rsultats du profiler dans un fichier, en supprimant les routines avec un temps d'excution trop court.
;
; Ecrit les rsultats du profiler dans nomfichier, en ne gardant que les routines qui ont utiliss au moins nbsec_mini secondes
;-------------------------------------------------------------------------------

	PROFILER, /REPORT, OUTPUT=var
	nom = ''
	temps = ''
	count = ''
	i = 0
	WHILE i LT N_ELEMENTS(var)-1 DO BEGIN
		xxx = STRSPLIT(var[i], /EXTRACT)
		IF N_ELEMENTS(xxx) EQ 1 THEN BEGIN
			name = STRTRIM(xxx[0], 2)
			i++
			pos = STRPOS(var[i], ')')
			yyy = STRSPLIT(STRMID(var[i], 1+pos), /EXTRACT)
			info = [name,yyy[0],yyy[1]]
		END ELSE BEGIN
			pos = STRPOS(var[i], '(')
			name = STRTRIM(STRMID(var[i], 0, pos), 2)
			pos = STRPOS(var[i], ')')
			yyy = STRSPLIT(STRMID(var[i], 1+pos), /EXTRACT)
			info = [name,yyy[0],yyy[1]]
		END
		nom   = nom[0]   EQ '' ? info[0] : [nom,  info[0]]
		count = count[0] EQ '' ? info[1] : [count,info[1]]
		temps = temps[0] EQ '' ? info[2] : [temps,info[2]]
		i++
	END

	ind = REVERSE(SORT(FLOAT(temps)))
	nom = nom[ind]
	temps = temps[ind]
	count = count[ind]
	somme = 0.
	FOR i=0L,N_ELEMENTS(nom)-1 DO BEGIN
		somme += temps[i]
	END

	OPENW, fd, nomfichier, /GET_LUN
	FOR i=0L,N_ELEMENTS(nom)-1 DO BEGIN
		IF temps[i] GE nbsec_mini THEN BEGIN
			PRINTF, fd, nom[i], count[i], temps[i], temps[i]*100./somme, ' %', format='(A40,1X,I10,1X,A10,1X,F6.2,A2)'
		END
	END
	PRINTF, fd
	PRINTF, fd, 'TOTAL', 0, somme, format='(A40,1X,I10,1X,A10)'
	FREE_LUN, fd

END

;-------------------------------------------------------------------------------
FUNCTION get_adresseip
;-------------------------------------------------------------------------------
; (SYS) ((-)) Retourne une chaine de caractre avec l'adresse ip.
;-------------------------------------------------------------------------------

	adresseip = '                                              ' ; assez de caracteres pour y mettre l'adresse IP
	IF is_fdl() THEN BEGIN
		adresseip = pchar(adresseip)
		lint_unused = CALL_EXTERNAL (libname('util'), 'GET_ADRESSEIP_AUTO_GLUE', adresseip, /AUTO_GLUE)
		adresseip = STRING(adresseip)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'GET_ADRESSEIP', adresseip)
	END
	adresseip = STRCOMPRESS (adresseip, /REMOVE_ALL)
	IF adresseip EQ '' THEN adresseip = '127.0.0.1' ; arrive sur Windows car get_adresseip() ne fonctionne pas

	RETURN, adresseip

END


;-------------------------------------------------------------------------------
FUNCTION get_uid
;-------------------------------------------------------------------------------
; (SYS) ((-)) Retourne une chaine de caractre avec le nom de l'utilisateur.
;-------------------------------------------------------------------------------

	IF is_windows() THEN BEGIN
		uid = STRLOWCASE (GETENV ('USERNAME'))
	END ELSE BEGIN
		uid = GETENV ('LOGNAME')
	END
	IF uid EQ '' THEN uid = 'unknownuser' ; on ne sait jamais au CNES
	RETURN, uid

END

;-------------------------------------------------------------------------------
PRO my_spawn,	$
;-------------------------------------------------------------------------------
	cmd		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (SYS) ((-)) Excute une commande en utilisant SPAWN.
;
; Excute la commande cmd avec SPAWN
;-------------------------------------------------------------------------------

	IF is_windows() THEN BEGIN

		SPAWN, cmd, /HIDE

	END ELSE BEGIN

		SPAWN, cmd

	END

END

;-------------------------------------------------------------------------------
FUNCTION get_memory_used
;-------------------------------------------------------------------------------
; (SYS) ((-)) Retourne une chaine de caractres avec la mmoire utilise.
;-------------------------------------------------------------------------------

	HELP, /memory, output=str
	ligne = STRSPLIT (str[0], /EXTRACT)
	IF is_fdl() THEN BEGIN
		memory_used = FLOAT(STRMID(ligne[2], 0, STRLEN(ligne[2])-1))
	END ELSE BEGIN
		memory_used = FLOAT(STRMID(ligne[3], 0, STRLEN(ligne[3])-1))
	END

	RETURN, memory_used

END


;-------------------------------------------------------------------------------
PRO my_setenv,	$
;-------------------------------------------------------------------------------
	cmd		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (SYS) ((-)) Positionne une variable d'environnement
;-------------------------------------------------------------------------------

	SETENV, cmd
	IF is_windows() THEN BEGIN
		; pour que la variable cr soit vue en C avec getenv() sous Windows avec gcc
		; sinon la variable est vue par GETENV de IDL mais par par getenv() en C ...
		lint_unused = CALL_EXTERNAL(libname('util'), 'MY_PUTENV', cmd)
	END

END

;-------------------------------------------------------------------------------
FUNCTION tables_to_str,		$
;-------------------------------------------------------------------------------
	table, 	$	; LINT_PROTOTYPE input
	nom		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (ENERGY) ((-)) Retourne un tableau de chaines de caractres avec le nom de la table d'nergie puis les valeurs des nergies.
;
; Retourne une chaine avec nom suivi de la valeur table
;-------------------------------------------------------------------------------

	table = REFORM(table)
	nb = N_ELEMENTS(table)
	
	; (I5) pour CDAWeb POLAR P0_H7_PWI avec 31744 frquences
	RETURN, nom + '  ' + STRING(1+LINDGEN(nb), FORMAT='(I5)') + '  ' + STRING(table, FORMAT='(F10.1)') + ' eV'

END

;-------------------------------------------------------------------------------
PRO supprimer_chevauchements_et_trous,	$
;-------------------------------------------------------------------------------
	E					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (ENERGY) ((-)) Supprime les chevauchement et les trous dans les tables d'nergies. Une bande d'nergie est ignore si Emin=Emax.
;-------------------------------------------------------------------------------
; LINT_VARIABLES decroissant

	IF is_gdl() THEN BEGIN
		; ex: /home/penou/DATA/CLUSTER/SOFT/CLL3/resource/cluster_phi_theta_he1_multi.cl.gz
		; idl = 16.927719 micro sec
		; gdl = 42.915344 micro sec
		nbenergies = N_ELEMENTS(E[*,0,0])
		nbtables = N_ELEMENTS(E[0,0,*])
		tmp = TRANSPOSE(REFORM(E[nbenergies-LINDGEN(nbenergies)-1,1,*]))
	END ELSE BEGIN
		; ex: /home/penou/DATA/CLUSTER/SOFT/CLL3/resource/cluster_phi_theta_he1_multi.cl.gz
		; idl = 32.901764 micro sec
		; gdl = 5856.0371 micro sec
		tmp = TRANSPOSE(REVERSE(REFORM(E[*,1,*])))
		nbtables = N_ELEMENTS(tmp[*,0])
		nbenergies = N_ELEMENTS(tmp[0,*])
	END

	IF nbenergies EQ 1 THEN RETURN	; c'est le cas pour NPI/ASPERA3 par ex

	FOR itable=0L,nbtables-1 DO BEGIN

		tablesEmin = E[*,0,itable]
		tablesEmoy = E[*,1,itable]
		tablesEmax = E[*,2,itable]

		;PRINT,[transpose(tablesemin),transpose(tablesemoy),transpose(tablesemax)]

		FOR i=0L,nbenergies-2 DO BEGIN
			IF tablesEmin[i] EQ tablesEmax[i] THEN CONTINUE

			; correction du 02 juillet 2009:
			; - pb (dtect par Alain) visible sous caa.cesr.fr et aspera: le P6 grand G le 31/01/2001 14h-15H SC1 n'a pas les spectres direction solaires coups  2kev!
			; - pas de pb sous cisnew, stereo et sur les pc WINXP
			; Solution: ne pas essayer de joindre 2 bandes d'energies si la bande d'nergie suivante est bloque (cad Emax==Emin)
			IF tablesEmin[i+1] EQ tablesEmax[i+1] THEN CONTINUE

			; correction septembre 2012: dterminer dcroissant une seule fois
			IF N_ELEMENTS(decroissant) EQ 0 THEN decroissant = tablesEmin[i] GT tablesEmin[i+1]
			IF decroissant THEN BEGIN
				v1 = tablesEmin[i]
				v2 = tablesEmax[i+1]
			END ELSE BEGIN
				v1 = tablesEmax[i]
				v2 = tablesEmin[i+1]
			END
			IF v1 NE v2 THEN BEGIN ; chevauchement ou trou
				IF tablesEmoy[i] GT 0 AND tablesEmoy[i+1] GT 0 THEN BEGIN
					moyenne = 10.0^(0.5*(ALOG10(tablesEmoy[i])+ALOG10(tablesEmoy[i+1])))
				END ELSE BEGIN
					moyenne = 0.5*(tablesEmoy[i]+tablesEmoy[i+1])
				END
				IF decroissant THEN BEGIN
					tablesEmin[i]   = moyenne
					tablesEmax[i+1] = moyenne
				END ELSE BEGIN
					tablesEmax[i]   = moyenne
					tablesEmin[i+1] = moyenne
				END
			END
		END

		;PRINT,[transpose(tablesemin),transpose(tablesemoy),transpose(tablesemax)]

		E[*,0,itable] = tablesEmin
		E[*,1,itable] = tablesEmoy
		E[*,2,itable] = tablesEmax

	END

END

;-------------------------------------------------------------------------------
PRO corriger_table,	$
;-------------------------------------------------------------------------------
	ENERGIES,	$	; LINT_PROTOTYPE input
	i,		$	; LINT_PROTOTYPE input
	T,		$	; LINT_PROTOTYPE input
	LINEAR=LINEAR		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (ENERGY) ((-)) Corrige la table numro i de table d'nergie T et calcule les nergies min et max correspondantes (en log par dfaut)
;-------------------------------------------------------------------------------

	IF KEYWORD_SET(LINEAR) THEN BEGIN

		; ECHELLE LINEAIRE
		; ----------------
		; On ne connait que les nergies centrales: tmp avec N lments
		tmp = T
		N = N_ELEMENTS(tmp)
		IF N LT 2 THEN RETURN
		; nergies au milieu de ces nergies centrales
		milieu = (tmp[LINDGEN(N-1)] + tmp[1+LINDGEN(N-1)]) / 2.0
		TMIN = [ milieu, tmp[N-1] + (tmp[N-1]-milieu[N-2]) ]
		TMAX = [ tmp[0] - (milieu[0]-tmp[0]) , milieu]

		ind = LINDGEN(N)

	END ELSE BEGIN

		; ECHELLE LOGARITHMIQUE
		; ---------------------
		; On ne connait que les nergies centrales: T avec N lments

		; Sur EESA-REDUCED, la table de 32 energies peut ne contenir que 16 valeurs puis 16 NaN, dans les modes  16 nergies
		; Les NaN ont t convertis plus haut en 0
		ind = WHERE (T NE 0)
		IF ind[0] EQ -1 THEN RETURN
		N = N_ELEMENTS(ind)
		IF N LT 2 THEN RETURN

		T = T[ind]

		; dtect par fdl: T ne contient que des NaN
		; ex: resource/wind_HIRES.cl.gz
		ind1 = WHERE (FINITE(T) EQ 0)
		IF ind1[0] NE -1 THEN T[ind1] = 1

		; Septembre 2012: suppression des messages "% Program caused arithmetic error: Floating illegal operand"
		ind1 = WHERE (T LE 0)
		IF ind1[0] NE -1 THEN T[ind1] = 1

		; La premire plage d'nergie a pour nergie centrale T[0] et va de amin  amax
		; amin = 10.0^( (ALOG10(T[0])+ALOG10(T[1]))/2.0)
		; T[0] est la moyenne log de amin et amax donc T[0] = 10^( (ALOG10(amin)+ALOG10(amax))/2.0)
		; Donc ALOG10(T[0]) = (ALOG10(amin)+ALOG10(amax))/2.0
		; Donc amax = 10.0 ^(2*ALOG10(T[0])-ALOG10(amin))
		amin = 10.0 ^ ( (ALOG10(T[0])+ALOG10(T[1]))/2.0)
		amax = 10.0 ^ (2*ALOG10(T[0])-ALOG10(amin))

		; La dernire plage d'nergie a pour nergie centrale T[N-1] et va de zmin a zmax
		; zmax = 10.0 ^( (ALOG10(T[N-2]) + ALOG10(T[N-1]))/2.0)
		; T[N-1] est la moyenne log de zmin et zmax donc T[N-1] = 10.0 ^( (ALOG10(zmin)+alog1(zmax))/2.0)
		; Donc ALOG10(T[N-1]) = (ALOG10(zmin) + ALOG10(zmax)) / 2.0
		; Donc zmin = 10.0 ^ (2*ALOG10(T[N-1]) - ALOG10(zmax))
		zmax = 10.0 ^ ( (ALOG10(T[N-2]) + ALOG10(T[N-1]))/2.0)
		zmin = 10.0 ^ (2*ALOG10(T[N-1]) - ALOG10(zmax))

		TMIN = [ 10.0 ^ ((ALOG10(T[0:N-2])+ALOG10(T[1:N-1]))/2.0), zmin]
		TMAX = [ amax, 10.0 ^ ((ALOG10(T[0:N-2])+ALOG10(T[1:N-1]))/2.0)]

	END

	FOR j=0L,N_ELEMENTS(T)-2 DO BEGIN
		; ex: /home/penou/DATA/CLUSTER/SOFT/CLL3/projets/psp/exp_psp_spa.cl
		; T contient des Nan  certain endroits mais pas partout
		IF FINITE(T[j]) AND FINITE(T[j+1]) THEN BEGIN
			IF T[j] GT T[j+1] THEN BEGIN
				; tables dcroissantes
				ENERGIES[ind,0,i] = TMIN
				ENERGIES[ind,2,i] = TMAX
			END ELSE BEGIN
				ENERGIES[ind,2,i] = TMIN
				ENERGIES[ind,0,i] = TMAX
			END
			BREAK
		END
	END

	; Ncessaire si T contient des NaN
	; ex: resource/wind_HIRES.cl.gz
	ENERGIES[ind,1,i] = T

END


;-------------------------------------------------------------------------------
PRO trouver_chgt_table,	$
;-------------------------------------------------------------------------------
	data,		$	; LINT_PROTOTYPE input
	motif,		$	; LINT_PROTOTYPE input
	ENERGIES,	$	; LINT_PROTOTYPE output
	indY,		$	; LINT_PROTOTYPE output
	LINEAR=LINEAR		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (ENERGY) ((-)) Retourne les tables d'nergies et les numros de tables  utiliser dans chaque enregistrement (pour les fichiers dont les enregistrements contiennent la table).
;
; motif: 'ENERGY' ou 'MASS'
; Pour les fichiers avec tables d'nergies donne dans chaque enregistrement: retourne indY et ENERGIES.
;-------------------------------------------------------------------------------
; LINT_VARIABLES min1 max1

	IF N_ELEMENTS(LINEAR) EQ 0 THEN LINEAR = 0

	nblignes = N_ELEMENTS(data)

	nom = STRUPCASE(TAG_NAMES(data))

	lint_unused = get_structure_infos (data[0], taille1, nbchamps, nom_champ, type_champ, offset1, taille_champ, nb_champ)

	no = (WHERE (STRMID(nom, 0, STRLEN(motif)+7) EQ motif+'_TABLE_', nb))[0]
	IF no NE -1 THEN BEGIN
		; ex: "C1_CP_CIS-HIA_LS_1D_PEF_20011219_V01.cef.gz" du CAA
		; ENERGY_TABLE_1, ENERGY_TABLE_2, ...
		nbenergies = nb
		has_ENERGY_TABLE = 1
	END ELSE BEGIN
		no = (WHERE (STRMID(nom, 0, STRLEN(motif)+6) EQ motif+'_TABLE'))[0]
		IF no NE -1 THEN BEGIN
			; aucun exemple trouv!
			; tableau ENERGY_TABLE[energies,spins]
			;tmp = (data.(no))[*,0]
			;nbenergies = N_ELEMENTS(tmp)

			; rajout pour mvn_sta_D4_P4E ou la table ne contient qu'une seule nergie
			nbenergies = 1L
		
			; pour ROSINA
			nbenergies = N_ELEMENTS(data[0].(no))

			has_ENERGY_TABLE = 1
		END ELSE BEGIN
			; arrive lorsque l'on veut rcuprer les masses dans un fichier sans masses
			nbenergies = 0L
			has_ENERGY_TABLE = 0
			RETURN
		END
	END
	has_DELTA_ENERGY_TABLE 		= (WHERE (STRMID(nom, 0, STRLEN(motif)+12) EQ 'DELTA_'+motif+'_TABLE'))[0] NE -1
	has_DELTA_PLUS_ENERGY_TABLE	= (WHERE (STRMID(nom, 0, STRLEN(motif)+17) EQ 'DELTA_PLUS_'+motif+'_TABLE'))[0] NE -1
	has_DELTA_MINUS_ENERGY_TABLE	= (WHERE (STRMID(nom, 0, STRLEN(motif)+18) EQ 'DELTA_MINUS_'+motif+'_TABLE'))[0] NE -1

	numeros = REPLICATE (-1L, nbenergies)

	; Recherche des changements de table  l'aide d'une fonction heuristique, qui ne doit pas contenir de -1e31
	heuristique = REPLICATE (0d, nblignes)
	IF has_ENERGY_TABLE THEN BEGIN

		no = (WHERE (nom EQ motif+'_TABLE'))[0]
		IF no NE -1 THEN BEGIN
			; aucun exemple trouv
			; tableau ENERGY_TABLE[energies,spins]
			ENERGY_TABLE = FLOAT((data.(no)))

			; rajout pour mvn_sta_D4_P4E ou la table ne contient qu'une seule nergie
			ENERGY_TABLE = REFORM (ENERGY_TABLE, nbenergies, nblignes)
		END ELSE BEGIN
			; ex: "C1_CP_CIS-HIA_LS_1D_PEF_20020204_V01.cef.gz" du CAA
			ENERGY_TABLE = REPLICATE (0., nbenergies, nblignes)

			; 20200129: ne chercher que le premier numro (les autres suivent)
			no = chercher_commencepar_terminepar (nom, motif+'_TABLE', '1')
			IF no[0] NE -1 THEN numeros = no[0] + LINDGEN(nbenergies)

			; 20141020: codage en C (4 fois plus rapide)
			IF is_fdl() THEN BEGIN
				lint_unused = CALL_EXTERNAL (libname('util'), 'GET_ENERGY_TABLE_AUTO_GLUE', nbenergies, nblignes, taille1, offset1, ENERGY_TABLE, numeros, data, /AUTO_GLUE)
			END ELSE BEGIN
				lint_unused = CALL_EXTERNAL (libname('util'), 'GET_ENERGY_TABLE', nbenergies, nblignes, taille1, offset1, ENERGY_TABLE, numeros, data)
			END
		END
	
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'GET_HEURISTIQUE_AUTO_GLUE', nbenergies, nblignes, ENERGY_TABLE, heuristique, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'GET_HEURISTIQUE', nbenergies, nblignes, ENERGY_TABLE, heuristique)
		END
	END

	IF has_DELTA_ENERGY_TABLE THEN BEGIN

		no = (WHERE (nom EQ 'DELTA_'+motif+'_TABLE'))[0]
		IF no NE -1 THEN BEGIN
			; aucun exemple trouv
			; tableau DELTA_ENERGY_TABLE[energies,spin]
			DELTA_ENERGY_TABLE = FLOAT((data.(no)))
		END ELSE BEGIN
			; projets/mms/mms_1234-DistFunc.cl
			DELTA_ENERGY_TABLE = REPLICATE (0., nbenergies, nblignes)

			; 20200129: ne chercher que le premier numro (les autres suivent)
			no = chercher_commencepar_terminepar (nom, 'DELTA_'+motif+'_TABLE', '1')
			IF no[0] NE -1 THEN numeros = no[0] + LINDGEN(nbenergies)

			; 20141020: codage en C (4 fois plus rapide)
			IF is_fdl() THEN BEGIN
				lint_unused = CALL_EXTERNAL (libname('util'), 'GET_ENERGY_TABLE_AUTO_GLUE', nbenergies, nblignes, taille1, offset1, DELTA_ENERGY_TABLE, numeros, data, /AUTO_GLUE)
			END ELSE BEGIN
				lint_unused = CALL_EXTERNAL (libname('util'), 'GET_ENERGY_TABLE', nbenergies, nblignes, taille1, offset1, DELTA_ENERGY_TABLE, numeros, data)
			END
		END

	END

	IF has_DELTA_PLUS_ENERGY_TABLE THEN BEGIN

		no = (WHERE (nom EQ 'DELTA_PLUS_'+motif+'_TABLE'))[0]
		IF no NE -1 THEN BEGIN
			; aucun exemple trouv
			; tableau DELTA_PLUS_ENERGY_TABLE[energies,spin]
			DELTA_PLUS_ENERGY_TABLE = FLOAT((data.(no)))
		END ELSE BEGIN
			; ex: "C1_CP_CIS-HIA_LS_1D_PEF_20020204_V01.cef.gz" du CAA
			DELTA_PLUS_ENERGY_TABLE = REPLICATE (0., nbenergies, nblignes)

			; 20200129: ne chercher que le premier numro (les autres suivent)
			no = chercher_commencepar_terminepar (nom, 'DELTA_PLUS_'+motif+'_TABLE', '1')
			IF no[0] NE -1 THEN numeros = no[0] + LINDGEN(nbenergies)

			; 20141020: codage en C (4 fois plus rapide)
			IF is_fdl() THEN BEGIN
				; ex: projets/taranis/taranis_idee_event_BGK_SPECTRO.cl
				lint_unused = CALL_EXTERNAL (libname('util'), 'GET_ENERGY_TABLE_AUTO_GLUE', nbenergies, nblignes, taille1, offset1, DELTA_PLUS_ENERGY_TABLE, numeros, data, /AUTO_GLUE)
			END ELSE BEGIN
				lint_unused = CALL_EXTERNAL (libname('util'), 'GET_ENERGY_TABLE', nbenergies, nblignes, taille1, offset1, DELTA_PLUS_ENERGY_TABLE, numeros, data)
			END
		END

	END

	IF has_DELTA_MINUS_ENERGY_TABLE THEN BEGIN

		no = (WHERE (nom EQ 'DELTA_MINUS_'+motif+'_TABLE'))[0]
		IF no NE -1 THEN BEGIN
			; aucun exemple trouv
			; tableau DELTA_MINUS_ENERGY_TABLE[]
			DELTA_MINUS_ENERGY_TABLE = FLOAT((data.(no)))
		END ELSE BEGIN
			; ex: "C1_CP_CIS-HIA_LS_1D_PEF_20020204_V01.cef.gz" du CAA
			DELTA_MINUS_ENERGY_TABLE = REPLICATE (0., nbenergies, nblignes)

			; 20200129: ne chercher que le premier numro (les autres suivent)
			no = chercher_commencepar_terminepar (nom, 'DELTA_MINUS_'+motif+'_TABLE', '1')
			IF no[0] NE -1 THEN numeros = no[0] + LINDGEN(nbenergies)

			; 20141020: codage en C (4 fois plus rapide)
			IF is_fdl() THEN BEGIN
				; ex: projets/taranis/taranis_idee_event_BGK_SPECTRO.cl
				lint_unused = CALL_EXTERNAL (libname('util'), 'GET_ENERGY_TABLE_AUTO_GLUE', nbenergies, nblignes, taille1, offset1, DELTA_MINUS_ENERGY_TABLE, numeros, data, /AUTO_GLUE)
			END ELSE BEGIN
				lint_unused = CALL_EXTERNAL (libname('util'), 'GET_ENERGY_TABLE', nbenergies, nblignes, taille1, offset1, DELTA_MINUS_ENERGY_TABLE, numeros, data)
			END
		END

	END

	heuristique_uniq = heuristique[UNIQ (heuristique, SORT(heuristique))]
	nbtables = N_ELEMENTS(heuristique_uniq)
	indtable = REPLICATE (0L, nbtables)

	IF is_fdl() THEN BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'GET_INDTABLE_AUTO_GLUE', nbtables, nblignes, heuristique, heuristique_uniq, indtable, /AUTO_GLUE)
	END ELSE BEGIN	
		lint_unused = CALL_EXTERNAL (libname('util'), 'GET_INDTABLE', nbtables, nblignes, heuristique, heuristique_uniq, indtable)
	END

	; VERIF
	DEBUG = 0
	IF DEBUG EQ 1 THEN BEGIN
		top1 = nbsec()
		nbpb = 0
		FOR i=0L,N_ELEMENTS(heuristique_uniq)-1 DO BEGIN
			tmp = WHERE (heuristique EQ heuristique_uniq[i])
			FOR j=1L,N_ELEMENTS(tmp)-1 DO BEGIN
				diff = ENERGY_TABLE[*,tmp[j]] - ENERGY_TABLE[*,tmp[0]]
				aie = WHERE (diff NE 0)
				IF aie[0] NE -1 THEN BEGIN
					min_diff = MIN (ENERGY_TABLE[*,tmp[j]] - ENERGY_TABLE[*,tmp[0]])
					max_diff = MAX (ENERGY_TABLE[*,tmp[j]] - ENERGY_TABLE[*,tmp[0]])
					PRINT, min_diff, max_diff
					min1 = N_ELEMENTS(min1) EQ 0 ? min_diff : MIN([min1,min_diff])
					max1 = N_ELEMENTS(max1) EQ 0 ? max_diff : MAX([max1,max_diff])
					nbpb++
				END
			END
		END
		top2 = nbsec()
		IF nbpb NE 0 THEN BEGIN
			HELP, nbpb, heuristique
			PRINT, 'check heuristique ' + motif , min1, max1
			EXIT
		END
		PRINT, 'check heuristique ' + motif + ' en ' + val_to_str_2decimales(top2-top1) + ' sec'
	END

	ind = WHERE (indtable NE -1, nbtables) ;  cause des fichiers CDF WIND avec des coups valant Nan

	IF nbtables EQ 0 THEN BEGIN
		has_ENERGY_TABLE = 0
		nbtables = 1
		indtable = [0L]
	END

	ENERGIES = REPLICATE (0., nbenergies, 3, nbtables)
		
	IF ~has_ENERGY_TABLE THEN BEGIN ; pas de champ ENERGY_TABLE

		FOR i=0L, nbtables-1 DO BEGIN
			ENERGIES[*, 0, i] = FINDGEN(nbenergies)+1.0	; MIN
			ENERGIES[*, 1, i] = FINDGEN(nbenergies)+1.5	; MOY
			ENERGIES[*, 2, i] = FINDGEN(nbenergies)+2.0	; MAX
		END

	END ELSE BEGIN

		FOR i=0L, nbtables-1 DO BEGIN
			ENERGIES[*, 0, i] = ENERGY_TABLE[*,indtable[i]]	; MIN
			ENERGIES[*, 1, i] = ENERGY_TABLE[*,indtable[i]]	; MOY=MIN
			ENERGIES[*, 2, i] = ENERGY_TABLE[*,indtable[i]]	; MAX=MIN
		END

		IF ~has_DELTA_ENERGY_TABLE AND ~has_DELTA_PLUS_ENERGY_TABLE AND ~has_DELTA_MINUS_ENERGY_TABLE THEN BEGIN

			PRINT, '*** CORRECTION OF '+val_to_str(nbtables)+' ' + motif + ' TABLE ***'
			FOR i=0L, nbtables-1 DO BEGIN

				T = ENERGY_TABLE[*,indtable[i]]
				corriger_table, ENERGIES, i, T, LINEAR=LINEAR

			END

		END ELSE IF has_DELTA_ENERGY_TABLE THEN BEGIN

			;FOR i=0L,nbtables-1 DO BEGIN
			;	ENERGIES [*, 2, i] = ENERGY_TABLE[*,indtable[i]]				; MAX=ENERGY_TABLE
			;	ENERGIES [*, 0, i] = ENERGIES [*, 2, i] - DELTA_ENERGY_TABLE[*,indtable[i]]	; MIN=ENERGY_TABLE - DELTA_ENERGY_TABLE
			;END
			;ENERGIES [*, 1, *] = 0.5 * (ENERGIES [*, 0, *] + ENERGIES [*, 2, *])

			; Modif du 26/09/2016 pour MMS:
			; - MIN = ENERGY_TABLE - DELTA_ENERGY_TABLE
			; - MOY = ENERGY_TABLE
			; - MAX = ENERGY_TABLE + DELTA_ENERGY_TABLE
			FOR i=0L,nbtables-1 DO BEGIN
				ENERGIES [*, 0, i] = ENERGY_TABLE[*,indtable[i]] - DELTA_ENERGY_TABLE[*,indtable[i]]	; MIN=ENERGY_TABLE - DELTA_ENERGY_TABLE
				ENERGIES [*, 1, i] = ENERGY_TABLE[*,indtable[i]]					; MOY=ENERGY_TABLE
				ENERGIES [*, 2, i] = ENERGY_TABLE[*,indtable[i]] + DELTA_ENERGY_TABLE[*,indtable[i]]	; MAX=ENERGY_TABLE + DELTA_ENERGY_TABLE
			END

		END ELSE BEGIN
			IF has_DELTA_PLUS_ENERGY_TABLE THEN BEGIN
				FOR i=0L,nbtables-1 DO BEGIN
					ENERGIES [*, 2, i] = ENERGIES [*, 1, i] + DELTA_PLUS_ENERGY_TABLE[*,indtable[i]]	; MAX=MOY + DELTA_PLUS_ENERGY_TABLE
				END
			END
			IF has_DELTA_MINUS_ENERGY_TABLE THEN BEGIN
				FOR i=0L,nbtables-1 DO BEGIN
					ENERGIES [*, 0, i] = ENERGIES [*, 1, i] - DELTA_MINUS_ENERGY_TABLE[*,indtable[i]]	; MIN=MOY-DELTA_MINUS_ENERGY_TABLE
				END
			END
		END
	END

	; Correction des tables contenant des nergies ngatives ou nulles
	IF LINEAR EQ 0 THEN BEGIN
		FOR i=0L,nbtables-1 DO BEGIN
			ind = WHERE (ENERGIES[*,0,i] LE 0 OR ENERGIES[*,1,i] LE 0 OR ENERGIES[*,2,i] LE 0)
			IF ind[0] NE -1 THEN BEGIN
				ENERGIES[ind,1,i] = 1e-30
				ENERGIES[ind,0,i] = 1e-30
				ENERGIES[ind,2,i] = 1e-30
			END
		END
	END

	indY = REPLICATE (-1L, nblignes)

	; Codage en IDL
	;FOR i=0L,nbtables-1 DO BEGIN
	;	ind = WHERE (heuristique EQ heuristique[indtable[i]])
	;	IF ind[0] NE -1 THEN BEGIN
	;		indY[ind] = i
	;	END
	;END

	; Codage en C
	IF is_fdl() THEN BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'GET_INDY_AUTO_GLUE', nbtables, nblignes, heuristique, indtable, indY, /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'GET_INDY', nbtables, nblignes, heuristique, indtable, indY)
	END

END

;-------------------------------------------------------------------------------
PRO trouver_chgt_table_energies,	$
;-------------------------------------------------------------------------------
	data,		$	; LINT_PROTOTYPE input
	ENERGIES,	$	; LINT_PROTOTYPE output
	indY			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (ENERGY) ((-)) Retourne les tables d'nergies et les numros de tables  utiliser dans chaque enregistrement (pour les fichiers dont les enregistrements contiennent la table).
;
; Pour les fichiers avec tables d'nergies donne dans chaque enregistrement: retourne indY et ENERGIES.
;-------------------------------------------------------------------------------

	top1 = nbsec()
	trouver_chgt_table, data, 'ENERGY', ENERGIES, indY
	top2 = nbsec()
	PRINT, 'trouver_chgt_table_energies (' + val_to_str(N_ELEMENTS(ENERGIES[0,0,*])) + ' tables) ', top2-top1
END

;-------------------------------------------------------------------------------
PRO trouver_chgt_table_masses,	$
;-------------------------------------------------------------------------------
	data,		$	; LINT_PROTOTYPE input
	MASSES,		$	; LINT_PROTOTYPE output
	indM			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (ENERGY) ((-)) Retourne les tables de masses et les numros de tables  utiliser dans chaque enregistrement (pour les fichiers dont les enregistrements contiennent la table).
;
; Pour les fichiers avec tables de masses donne dans chaque enregistrement: retourne indM et MASSES.
;-------------------------------------------------------------------------------

	top1 = nbsec()
	trouver_chgt_table, data, 'MASS', MASSES, indM, /LINEAR
	top2 = nbsec()
	PRINT, 'trouver_chgt_table_masses ', top2-top1
END

;-------------------------------------------------------------------------------
PRO trouver_chgt_table_phis,	$
;-------------------------------------------------------------------------------
	data,		$	; LINT_PROTOTYPE input
	PHI,		$	; LINT_PROTOTYPE output
	indP			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (ENERGY) ((-)) Retourne les tables de phis et les numros de tables  utiliser dans chaque enregistrement (pour les fichiers dont les enregistrements contiennent la table).
;
; Pour les fichiers avec tables de phis donne dans chaque enregistrement: retourne indP et PHI.
;-------------------------------------------------------------------------------

	top1 = nbsec()
	trouver_chgt_table, data, 'PHI', PHI, indP, /LINEAR
	top2 = nbsec()
	PRINT, 'trouver_chgt_table_phis ', top2-top1
END

;-------------------------------------------------------------------------------
PRO modifier_emin_emax_bloquee,	$
;-------------------------------------------------------------------------------
	table,	$	; LINT_PROTOTYPE input
	notable		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (ENERGY) ((-)) Rechercher dans table[1,*,notable] les nergies qui sont bloques a une valeur constante et positionne les min et les max correspodants  la valeur centrale.
;
; Entree/sortie: table[3, nbenergies, nbtables]
;
; Rechercher dans table[1,*,notable] (classes par ordre dcroissant) les energies qui sont bloquees a une valeur constante.
; Pour ces energies la, positionner table[0,ind,notable] et table[2,ind,notable] a table[1,ind,notable]
;-------------------------------------------------------------------------------

	nbenergies = N_ELEMENTS(table[0,*,0])
	ind = WHERE (table[1,*,notable] EQ table[1, nbenergies-1,notable])
	IF ind[0] NE -1 THEN BEGIN
		table[0,ind,notable] = table[1,ind,notable]
		table[2,ind,notable] = table[1,ind,notable]
	END

END

;-------------------------------------------------------------------------------
FUNCTION remove_extension_caa,	$
;-------------------------------------------------------------------------------
	chaine	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (ASCII_CEF_CDF) ((-)) Retourne une copie d'une chaine de caractres en tronquant tout ce qui se trouve aprs '__'.
;-------------------------------------------------------------------------------

	motif1 = '__'

	chaine1 = chaine

	; Exceptions pour les fichiers cdf Cluster du CDAWeb. Pour FGM, on a :
	; --------------------------------------------------------------------
	;
	;	- time_tags__C3_CP_FGM_SPIN
	;	- half_interval__C3_CP_FGM_SPIN
	;	- B_vec_xyz_gse__C3_CP_FGM_SPIN B_mag__C3_CP_FGM_SPIN
	;	- sc_pos_xyz_gse__C3_CP_FGM_SPIN
	;	- range__C3_CP_FGM_SPIN
	;	- tm__C3_CP_FGM_SPIN
	;	- B_vec_xyz_gse__C3_CP_FGM_SPIN_REPRESENTATION_1
	;	- B_vec_xyz_gse__C3_CP_FGM_SPIN_LABEL_1
	;	- sc_pos_xyz_gse__C3_CP_FGM_SPIN_REPRESENTATION_1
	;	- sc_pos_xyz_gse__C3_CP_FGM_SPIN_LABEL_1
	;
	; Si on supprime tout ce qui est aprs "__", on va avoir plusieurs fois "B_vec_xyz_gse"!
	; => il faut supprimer "__C3_CP_FGM_SPIN"
	;
	; Solution: rajouter "_REPRESENTATION_1" ou "_LABEL_1" aprs suppression de tout ce qui est aprs "__"

	exceptions = ["_REPRESENTATION_1","_LABEL_1"]


	FOR i=0L, N_ELEMENTS(chaine1)-1 DO BEGIN

		ou = STRPOS (chaine1[i], motif1)
		IF ou NE -1 THEN BEGIN
			chaine1[i] = ou EQ 0 ? '' : STRMID(chaine1[i], 0, ou)
			FOR j=0L,N_ELEMENTS(exceptions)-1 DO BEGIN
				exception = exceptions[j]
				IF STRMID(chaine[i], STRLEN(chaine[i])-STRLEN(exception), STRLEN(exception)) EQ exception THEN BEGIN
					chaine1[i] += exception
				END
			END
		END
	END

	RETURN, chaine1

END

;-------------------------------------------------------------------------------
FUNCTION remove_extension_themis,	$
;-------------------------------------------------------------------------------
	chaine	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (ASCII_CEF_CDF) ((-)) Retourne une copie d'une chaine de caractres en supprimant les 4 premires lettres si elles sont 'th[abcdeg]_'.
;-------------------------------------------------------------------------------

	tmp = STRMID(chaine, 0, 4)
	chaine1 = chaine
	ind = WHERE (tmp EQ 'tha_' OR tmp EQ 'thb_' OR tmp EQ 'thc_' OR tmp EQ 'thd_' OR tmp EQ 'the_' OR tmp EQ 'thg_', nb)
	IF ind[0] NE -1 THEN BEGIN
		FOR i=0L,nb-1 DO BEGIN
			chaine1[ind[i]] =  STRMID (chaine1[ind[i]], 4, STRLEN(chaine1[ind[i]])-4)
		END
	END
	RETURN, chaine1

END


;-------------------------------------------------------------------------------
FUNCTION remove_extension,	$
;-------------------------------------------------------------------------------
	remove_ext,	$	; LINT_PROTOTYPE input
	string			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (ASCII_CEF_CDF) ((-)) Retourne une copie d'une chaine de caractres en supprimant l'extension CAA ou THEMIS.
;-------------------------------------------------------------------------------

	CASE remove_ext OF
		'CAA':		RETURN, remove_extension_caa (string)
		'THEMIS':	RETURN, remove_extension_themis (string)
		ELSE:		RETURN, string
	END

END


;-------------------------------------------------------------------------------
PRO corriger_symbols,	$
;-------------------------------------------------------------------------------
	symbol0,	$	; LINT_PROTOTYPE input
	SYMBOLS,	$	; LINT_PROTOTYPE input
	modif			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (ASCII_CEF_CDF) ((-)) Corrige les symboles issus de fichiers CEF ou CDF (DEPEND_0 incorrect, vecteurs ou matrices 1D avec plus de 200 composantes).
;-------------------------------------------------------------------------------

	; Correction des DEPEND_0 vides
	; Correction des DEPEND_0 si les variables correspondantes n'existent pas (arrive sur POLAR dataset="TIMAS_HE")
	FOR i=0L,N_ELEMENTS(SYMBOLS)-1 DO BEGIN
		ind = WHERE (SYMBOLS.VALUE_TYPE EQ 'ISO_TIME')
		IF ind[0] NE -1 THEN BEGIN
			nom_premier_ISO_TIME = SYMBOLS[ind[0]].NAME
			IF SYMBOLS[i].DEPEND_0 NE '' THEN BEGIN
				ind = WHERE (SYMBOLS.NAME EQ SYMBOLS[i].DEPEND_0)
				IF ind[0] EQ -1 THEN BEGIN
					PRINT, '*** WARNING *** '+'"'+SYMBOLS[i].NAME+'"'+' has an incorrect DEPEND_0 ('+'"'+SYMBOLS[i].DEPEND_0+'"'+' replaced by ' + '"'+nom_premier_ISO_TIME+'"'+')'
					SYMBOLS[i].DEPEND_0 = nom_premier_ISO_TIME
				END
			END
			IF SYMBOLS[i].DEPEND_0 EQ '' THEN BEGIN
				;PRINT,'*** WARNING *** '+SYMBOLS[i].NAME+' has an empty DEPEND_0 (replaced by ' + nom_premier_ISO_TIME+')'
				SYMBOLS[i].DEPEND_0 = nom_premier_ISO_TIME
			END
		END
	END

	; Transformer en matrice 2D les vecteurs ou les matrices 1D qui ont trop de composantes
	; arrive par exemple sur "cdaweb.gsfc.nasa.gov/istp_public/data/polar/pwi/pwi_h7/1996/po_h7_pwi_1996032615_v02.cdf"
	; arrive par exemple sur "cdaweb.gsfc.nasa.gov/istp_public/data/timed/guvi/l1cdisk/2001/10/timed_L1Cdisk_guvi_20011018061025_v01.cdf"
	; 07/06/2013: je met la limite de 200  1025 afin de pouvoir tracer les spectros DEMETER_ICE en 1024 frequences
	ind = WHERE (LONG(SYMBOLS.SIZES) GE 1025 AND SYMBOLS.DEPEND_2 EQ '' AND SYMBOLS.DEPEND_3 EQ '' AND SYMBOLS.DEPEND_4 EQ '')
	is_1d = REPLICATE (0, N_ELEMENTS(SYMBOLS))
	IF ind[0] NE -1 THEN BEGIN
		SYMBOLS[ind].SIZES = '1,'+SYMBOLS[ind].SIZES
		SYMBOLS[ind].DEPEND_2 = SYMBOLS[ind].DEPEND_1
		SYMBOLS[ind].DEPEND_1 = ''
		is_1d[ind] = 1
	END

	modif = 0
	; Rajout de DEPEND_[1234] si ncessaire
	FOR i=0L,N_ELEMENTS(SYMBOLS)-1 DO BEGIN
		IF SYMBOLS[i].DATA NE '' THEN CONTINUE
		;IF SYMBOLS[i].SIZES EQ '1' THEN CONTINUE
		IF SYMBOLS[i].SIZES EQ '' THEN CONTINUE
		DIMS = LONG(string_to_data(SYMBOLS[i].sizes))
		NBDIMS = N_ELEMENTS(DIMS)
		IF NBDIMS EQ 1 AND SYMBOLS[i].DEPEND_1 EQ '' THEN CONTINUE	; vecteur
		IF NBDIMS GE 1 AND (SYMBOLS[i].DEPEND_1 EQ '' OR (WHERE(SYMBOLS.NAME EQ SYMBOLS[i].DEPEND_1))[0] EQ -1) THEN BEGIN
			modif = 1
			DEPEND_1 = [ symbol0 ]
			DEPEND_1.NAME = 'DEPEND_1_'+SYMBOLS[i].NAME
			DEPEND_1.VALUE_TYPE = 'FLOAT'
			DEPEND_1.SIZES = val_to_str(DIMS[0])
			DEPEND_1.DATA = '0.5'
			FOR j=1L,DEPEND_1.SIZES-1 DO DEPEND_1.DATA += ','+val_to_str(j+0.5)
			DEPEND_1.DELTA_PLUS = '0.5'
			DEPEND_1.DELTA_MINUS = '0.5'
			IF ~is_1d[i] THEN PRINT, '*** WARNING *** '+'"'+SYMBOLS[i].NAME+'"'+' has an incorrect DEPEND_1 ("'+SYMBOLS[i].DEPEND_1+'" replaced by ' + '"'+DEPEND_1.NAME+'"'+')'
			SYMBOLS[i].DEPEND_1 = DEPEND_1.NAME
			SYMBOLS = [ SYMBOLS , DEPEND_1 ]
		END
		IF NBDIMS GE 2 AND (SYMBOLS[i].DEPEND_2 EQ '' OR (WHERE(SYMBOLS.NAME EQ SYMBOLS[i].DEPEND_2))[0] EQ -1) THEN BEGIN
			modif = 1
			DEPEND_2 = [ symbol0 ]
			DEPEND_2.NAME = 'DEPEND_2_'+SYMBOLS[i].NAME
			DEPEND_2.VALUE_TYPE = 'FLOAT'
			DEPEND_2.SIZES = val_to_str(DIMS[1])
			DEPEND_2.DATA = '0.5'
			FOR j=1L,DEPEND_2.SIZES-1 DO DEPEND_2.DATA += ','+val_to_str(j+0.5)
			DEPEND_2.DELTA_PLUS = '0.5'
			DEPEND_2.DELTA_MINUS = '0.5'
			PRINT, '*** WARNING *** '+'"'+SYMBOLS[i].NAME+'"'+' has an incorrect DEPEND_2 ("'+SYMBOLS[i].DEPEND_2+'" replaced by ' + '"'+DEPEND_2.NAME+'"'+')'
			SYMBOLS[i].DEPEND_2 = DEPEND_2.NAME
			SYMBOLS = [ SYMBOLS , DEPEND_2 ]
		END
		IF NBDIMS GE 3 AND (SYMBOLS[i].DEPEND_3 EQ '' OR (WHERE(SYMBOLS.NAME EQ SYMBOLS[i].DEPEND_3))[0] EQ -1) THEN BEGIN
			modif = 1
			DEPEND_3 = [ symbol0 ]
			DEPEND_3.NAME = 'DEPEND_3_'+SYMBOLS[i].NAME
			DEPEND_3.VALUE_TYPE = 'FLOAT'
			DEPEND_3.SIZES = val_to_str(DIMS[2])
			DEPEND_3.DATA = '0.5'
			FOR j=1L,DEPEND_3.SIZES-1 DO DEPEND_3.DATA += ','+val_to_str(j+0.5)
			DEPEND_3.DELTA_PLUS = '0.5'
			DEPEND_3.DELTA_MINUS = '0.5'
			PRINT, '*** WARNING *** '+'"'+SYMBOLS[i].NAME+'"'+' has an incorrect DEPEND_3 ("'+SYMBOLS[i].DEPEND_3+'" replaced by ' + '"'+DEPEND_3.NAME+'"'+')'
			SYMBOLS[i].DEPEND_3 = DEPEND_3.NAME
			SYMBOLS = [ SYMBOLS , DEPEND_3 ]
		END
		IF NBDIMS GE 4 AND (SYMBOLS[i].DEPEND_4 EQ '' OR (WHERE(SYMBOLS.NAME EQ SYMBOLS[i].DEPEND_4))[0] EQ -1) THEN BEGIN
			modif = 1
			DEPEND_4 = [ symbol0 ]
			DEPEND_4.NAME = 'DEPEND_4_'+SYMBOLS[i].NAME
			DEPEND_4.VALUE_TYPE = 'FLOAT'
			DEPEND_4.SIZES = val_to_str(DIMS[3])
			DEPEND_4.DATA = '0.5'
			FOR j=1L,DEPEND_4.SIZES-1 DO DEPEND_4.DATA += ','+val_to_str(j+0.5)
			DEPEND_4.DELTA_PLUS = '0.5'
			DEPEND_4.DELTA_MINUS = '0.5'
			PRINT, '*** WARNING *** '+'"'+SYMBOLS[i].NAME+'"'+' has an incorrect DEPEND_4 ("'+SYMBOLS[i].DEPEND_4+'" replaced by ' + '"'+DEPEND_4.NAME+'"'+')'
			SYMBOLS[i].DEPEND_4 = DEPEND_4.NAME
			SYMBOLS = [ SYMBOLS , DEPEND_4 ]
		END
	END

END

;-------------------------------------------------------------------------------
FUNCTION dt_to_delta,	$
;-------------------------------------------------------------------------------
	tabdata,	$	; LINT_PROTOTYPE input
	DT,		$	; LINT_PROTOTYPE input
	no1,		$	; LINT_PROTOTYPE input
	no2,		$	; LINT_PROTOTYPE input
	PLUS=PLUS,	$	; LINT_PROTOTYPE input
	MINUS=MINUS		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (ASCII_CEF_CDF) ((-)) Retourne la valeur de DELTA_PLUS ou DELTA_MINUS en seconde.
;
; Si DT.DELTA_xxx est une constante, renvoyer un tableau contenant cette valeur (attention  l'unit)
; Si DT.DELTA_xxx est une variable,  renvoyer la valeur de cette variable
;-------------------------------------------------------------------------------

	IF KEYWORD_SET(PLUS) THEN BEGIN
		DATA		=	DT.DELTA_PLUS.DATA
		UNITS		=	DT.DELTA_PLUS.DATA
		;SI_CONVERSION	=	DT.DELTA_PLUS.SI_CONVERSION
	END ELSE IF KEYWORD_SET(MINUS) THEN BEGIN
		DATA		=	DT.DELTA_MINUS.DATA
		UNITS		=	DT.DELTA_MINUS.DATA
		;SI_CONVERSION	=	DT.DELTA_MINUS.SI_CONVERSION
	END

	; Constante ou variable ?
	NAMES = TAG_NAMES(tabdata)
	ind = WHERE (NAMES EQ STRUPCASE(corriger_nomchamp(DATA)))
	IF ind[0] EQ -1 THEN BEGIN	; constante
		IF is_number(DATA) THEN BEGIN
			valeur = REPLICATE (FLOAT(DATA), no2-no1+1)
		END ELSE BEGIN
			; ex: projets/bepi/bepi_data_id_7.cl ou DATA vaut "duration"
			valeur = REPLICATE (0., no2-no1+1)
		END
	END ELSE BEGIN			; variable
		valeur = tabdata[no1:no2].(ind[0])
	END

	; Utilisation de UNITS
	CASE UNITS OF
		'"ms"': 	valeur *= 0.001
		ELSE:
	END

	; Gestion des -1e31 (arrive sur C4_CP_PEA_3DRH_DEFlux__20010214_000000_20010215_000000_V090617.cdf)
	ind = WHERE (valeur LT -1e30)
	IF ind[0] NE -1 THEN valeur[ind] = 0

	RETURN, valeur

END

;-------------------------------------------------------------------------------
FUNCTION get_min_max_symbols,	$
;-------------------------------------------------------------------------------
	symbols,	$	; LINT_PROTOTYPE input
	no,		$	; LINT_PROTOTYPE input
	size			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (ASCII_CEF_CDF) ((-)) Retourne, pour une variable donne (THETA, PHI, ENERGIES), les valeurs [ [DATA-DELTA_MINUS], [DATA] , [DATA+DELTA_PLUS] ].
;-------------------------------------------------------------------------------

	IF symbols[no].DATA EQ '' THEN BEGIN

		; arrive pour les tables d'nergies lorsqu'elles sont fournies dans les donnes
		; INDISPENSABLE: sinon cl ne re-calculera pas les tables d'nergies

		DATA = REPLICATE (-1E31, size)
		RETURN, [ [DATA], [DATA] , [DATA] ]

	END ELSE BEGIN

		tmp = string_to_data(symbols[no].DATA)
		IF N_ELEMENTS(tmp) NE size THEN BEGIN

			; la variable n'a pas la bonne dimension: on corrige ca
			DATA = FINDGEN(size)+1
			DELTA_PLUS = 1
			DELTA_MINUS = 0
			
		END ELSE BEGIN

			; les champs peuvent etre des strings ne contenant pas des valeurs numriques
			; plutt que de les convertir en 0, il faut renvoyer 0, 1, 2, ...

			isnumber = 1
			FOR i=0L,N_ELEMENTS(tmp)-1 DO BEGIN
				IF ~is_number(tmp[i]) THEN BEGIN
					isnumber = 0
					BREAK
				END
			END
			IF ~isnumber THEN BEGIN
				DATA = FINDGEN(N_ELEMENTS(tmp))
			END ELSE BEGIN
				DATA = FLOAT (string_to_data(symbols[no].DATA))
			END

			DELTA_PLUS	= FLOAT (string_to_data(symbols[no].DELTA_PLUS))

			DELTA_MINUS	= FLOAT (string_to_data(symbols[no].DELTA_MINUS))

		END

		RETURN, [ [DATA-DELTA_MINUS], [DATA] , [DATA+DELTA_PLUS] ]

	END

END


;-------------------------------------------------------------------------------
FUNCTION read_ascii_analyse_symbols_for_cl,	$
;-------------------------------------------------------------------------------
	SYMBOLS,				$	; LINT_PROTOTYPE input
	VARNAMES,				$	; LINT_PROTOTYPE output
	REALVARNAMES,				$	; LINT_PROTOTYPE output
	TYPES,					$	; LINT_PROTOTYPE output
	SIZES,					$	; LINT_PROTOTYPE output
	FILLVALS,				$	; LINT_PROTOTYPE output
	UNITS,					$	; LINT_PROTOTYPE output
	FIELDNAMS,				$	; LINT_PROTOTYPE output
	NAME_TIME,				$	; LINT_PROTOTYPE output
	NAME_THETA,				$	; LINT_PROTOTYPE output
	UNIT_THETA,				$	; LINT_PROTOTYPE output
	NAME_PHI,				$	; LINT_PROTOTYPE output
	UNIT_PHI,				$	; LINT_PROTOTYPE output
	NAME_ENERGY,				$	; LINT_PROTOTYPE output
	UNIT_ENERGY,				$	; LINT_PROTOTYPE output
	NAME_MASS,				$	; LINT_PROTOTYPE output
	UNIT_MASS,				$	; LINT_PROTOTYPE output
	ENERGIES,				$	; LINT_PROTOTYPE output
	THETA,					$	; LINT_PROTOTYPE output
	PHI,					$	; LINT_PROTOTYPE output
	MASS,					$	; LINT_PROTOTYPE output
	DT,					$	; LINT_PROTOTYPE output
	PROPERTY,				$	; LINT_PROTOTYPE output
	UNIT123D,				$	; LINT_PROTOTYPE output
	NAME123D,				$	; LINT_PROTOTYPE output
	remove_ext=remove_ext,			$	; LINT_PROTOTYPE input
	selection_date=selection_date,		$	; LINT_PROTOTYPE input
	selection_data=selection_data,		$	; LINT_PROTOTYPE input
	selection_type=selection_type			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (ASCII_CEF_CDF) ((1:ok 0:pb)) Analyse la table de symboles lue dans un fichier cef ou cdf et retourne les tables utiles pour cl.
;
; Input:
; ------
; - SYMBOLS:
;
; Output:
; -------
; - VARNAMES:
; - REALVARNAMES:
; - TYPES:
; - SIZES:
; - FILLVALS:
; - UNITS:
; - FIELDNAMS:
; - NAME_TIME:
; - NAME_MASS:
; - UNIT_MASS:
; - NAME_THETA:
; - UNIT_THETA:
; - NAME_PHI:
; - UNIT_PHI:
; - NAME_ENERGY:
; - UNIT_ENERGY:
; - ENERGIES:
; - THETA:
; - PHI:
; - PROPERTY:
; - UNIT123D:
; - NAME123D:
;
;
; - /selection_date
; - /selection_data
; - /selection_type
; - /remove_ext:		"CAA" or "THEMIS" to remove extension in variables names
;
; Return code:
; ------------
;	1 = OK
;	0 = PB
;				"ERROR: NO VARIABLE ISO_TIME OR ISO_TIME_RANGE FOUND"
;				"ERROR: VARIABLE " + cherche + " DOESN'T EXIST"
;				"ERROR: VARIABLE " + symbols[no].DEPEND_1 + " DOESN'T EXIST"
;				"ERROR: VARIABLE " + symbols[no].DEPEND_2 + " DOESN'T EXIST"
;				"ERROR: VARIABLE " + symbols[no].DEPEND_3 + " DOESN'T EXIST"
;				"ERROR: VARIABLE " + symbols[no].DEPEND_4 + " DOESN'T EXIST"
;				'ERROR: NO VARIABLES TO READ'
;-------------------------------------------------------------------------------

	;COMMON duree2,duree
	;IF N_ELEMENTS(duree) EQ 0 THEN duree=0.0
	;topduree = nbsec()

	IF N_ELEMENTS(selection_date) EQ 0 THEN selection_date = 'Automatic'
	IF N_ELEMENTS(selection_data) EQ 0 THEN selection_data = ['Automatic']
	IF N_ELEMENTS(selection_type) EQ 0 THEN selection_type = 'count3d'
	IF N_ELEMENTS(remove_ext)     EQ 0 THEN remove_ext = 'No'

	; sauvegarde de SYMBOLS.name pour REALVARNAMES
	SYMBOLS_NAME = SYMBOLS.name

	SYMBOLS.name            = remove_extension(remove_ext, SYMBOLS.name)
	SYMBOLS.data            = remove_extension(remove_ext, SYMBOLS.data)
	SYMBOLS.delta_plus      = remove_extension(remove_ext, SYMBOLS.delta_plus)
	SYMBOLS.delta_minus     = remove_extension(remove_ext, SYMBOLS.delta_minus)
	SYMBOLS.depend_0        = remove_extension(remove_ext, SYMBOLS.depend_0)
	SYMBOLS.depend_1        = remove_extension(remove_ext, SYMBOLS.depend_1)
	SYMBOLS.depend_2        = remove_extension(remove_ext, SYMBOLS.depend_2)
	SYMBOLS.depend_3        = remove_extension(remove_ext, SYMBOLS.depend_3)
	SYMBOLS.depend_4        = remove_extension(remove_ext, SYMBOLS.depend_4)
	SYMBOLS.labl_ptr_1      = remove_extension(remove_ext, SYMBOLS.labl_ptr_1)

	ENERGIES        = [[1.0],[1e3],[1e6]]
	THETA           = [[0.0],[90.0],[180.0]]
	PHI             = [[0.0],[180.0],[360.0]]
	info_DT         = { DATA:'0', UNITS:'', SI_CONVERSION:'' }
	IF N_ELEMENTS(DT) EQ 0 THEN DT  = { DELTA_PLUS: info_DT, DELTA_MINUS: info_DT }
	PROPERTY        = ''
	UNIT123D        = ''
	NAME123D        = ''

	; Analyse de SYMBOLS
	; -------------------

	VARNAMES	= ''
	REALVARNAMES	= ''
	TYPES		= ''
	SIZES		= ''
	FILLVALS	= ''
	UNITS		= ''
	FIELDNAMS	= ''
	NAME_TIME	= ''
	NAME_MASS	= ''
	UNIT_MASS	= ''
	NAME_THETA	= ''
	UNIT_THETA	= ''
	NAME_PHI	= ''
	UNIT_PHI	= ''
	NAME_ENERGY	= ''
	UNIT_ENERGY	= ''

	NAMES = TAG_NAMES(SYMBOLS)

	; Remplacer VALUE_TYPE='INT' par VALUE_TYPE='FLOAT' ; sinon pb avec les fillval des int, pb dans les coups en int
	ind = WHERE (STRUPCASE(SYMBOLS.VALUE_TYPE) EQ 'INT')
	IF ind[0] NE -1 THEN SYMBOLS[ind].VALUE_TYPE = 'FLOAT'


	; Variable Epoch
	ind1 = WHERE (SYMBOLS.data EQ '' AND SYMBOLS.VALUE_TYPE EQ 'ISO_TIME', nb1)
	ind2 = WHERE (SYMBOLS.data EQ '' AND SYMBOLS.VALUE_TYPE EQ 'ISO_TIME_RANGE', nb2)

	no1 = -1
	no2 = -1
	IF ind1[0] NE -1 THEN BEGIN
		no1 = WHERE (SYMBOLS[ind1].name EQ selection_date)
		IF no1[0] NE -1 THEN no1 = no1[0]
	END
	IF ind2[0] NE -1 THEN BEGIN
		no2 = WHERE (SYMBOLS[ind2].name EQ selection_date)
		IF no2[0] NE -1 THEN no2 = no2[0]
	END

	IF no1 EQ -1 AND no2 EQ -1 THEN BEGIN
		IF ind1[0] EQ -1 THEN BEGIN
			IF ind2[0] EQ -1 THEN BEGIN
				PRINT, "ERROR: NO VARIABLE ISO_TIME OR ISO_TIME_RANGE FOUND"
				RETURN, 0
			END ELSE BEGIN
				no2 = 0
			END
		END ELSE BEGIN
			no1 = 0
		END
	END

	IF no1 NE -1 THEN nodate = ind1[no1]
	IF no2 NE -1 THEN nodate = ind2[no2]

	liste = ['DELTA_PLUS', 'DELTA_MINUS']
	; Variables avec champ DATA: rsolution des champs de liste
	ind_data = WHERE (SYMBOLS.data NE '')
	IF ind_data[0] NE -1 THEN BEGIN
		FOR i=0L,N_ELEMENTS(ind_data)-1 DO BEGIN
			FOR j=0L,N_ELEMENTS(liste)-1 DO BEGIN
				no = (WHERE (NAMES EQ liste[j]))[0]; existe toujours car les champs DELTA_PLUS et DELTA_MINUS existent
				ind = WHERE (SYMBOLS.name EQ SYMBOLS[ind_data[i]].(no))
				IF ind[0] NE -1 THEN BEGIN
					IF N_ELEMENTS(ind) GT 1 THEN BEGIN
						PRINT, 'WARNING: VARIABLE '+SYMBOLS[ind_data[i]].(no) + ' IS DEFINED MORE THAN ONE TIME'
					END
					SYMBOLS[ind_data[i]].(no) = SYMBOLS[ind[0]].data
				END
			END
		END
	END

	IF nodate NE -1 THEN BEGIN

		; DT.DELTA_PLUS de nodate
		ind = WHERE (SYMBOLS.name EQ SYMBOLS[nodate].DELTA_PLUS)
		IF ind[0] EQ -1 THEN BEGIN ; le champ DELTA_PLUS n'est pas une variable
			DT.DELTA_PLUS.DATA		=	SYMBOLS[nodate].DELTA_PLUS
			DT.DELTA_PLUS.UNITS		=	SYMBOLS[nodate].UNITS
			DT.DELTA_PLUS.SI_CONVERSION	=	SYMBOLS[nodate].SI_CONVERSION
		END ELSE BEGIN
			IF N_ELEMENTS(ind) GT 1 THEN BEGIN
				PRINT, 'WARNING: VARIABLE '+SYMBOLS[nodate].DELTA_PLUS + ' IS DEFINED MORE THAN ONE TIME'
			END
			DT.DELTA_PLUS.DATA		=	SYMBOLS[ind[0]].DATA EQ '' ? SYMBOLS[ind[0]].NAME : SYMBOLS[ind[0]].DATA
			DT.DELTA_PLUS.UNITS		=	SYMBOLS[ind[0]].UNITS
			DT.DELTA_PLUS.SI_CONVERSION	=	SYMBOLS[ind[0]].SI_CONVERSION
		END
		ind = WHERE (SYMBOLS.NAME EQ 'DT' AND SYMBOLS.EXCEPTION EQ 1)
		IF ind[0] NE -1 THEN BEGIN
			DT.DELTA_PLUS.DATA		=	SYMBOLS[ind[0]].DATA
		END


		; DT.DELTA_MINUS de nodate
		ind = WHERE (SYMBOLS.name EQ SYMBOLS[nodate].DELTA_MINUS)
		IF ind[0] EQ -1 THEN BEGIN ; le champ DELTA_MINUS n'est pas une variable
			DT.DELTA_MINUS.DATA		=	SYMBOLS[nodate].DELTA_MINUS
			DT.DELTA_MINUS.UNITS		=	SYMBOLS[nodate].UNITS
			DT.DELTA_MINUS.SI_CONVERSION	=	SYMBOLS[nodate].SI_CONVERSION
		END ELSE BEGIN
			IF N_ELEMENTS(ind) GT 1 THEN BEGIN
				PRINT, 'ERROR: VARIABLE '+SYMBOLS[nodate].DELTA_MINUS + ' IS DEFINED MORE THAN ONE TIME'
			END
			DT.DELTA_MINUS.DATA		=	SYMBOLS[ind[0]].DATA EQ '' ? SYMBOLS[ind[0]].NAME : SYMBOLS[ind[0]].DATA
			DT.DELTA_MINUS.UNITS		=	SYMBOLS[ind[0]].UNITS
			DT.DELTA_MINUS.SI_CONVERSION	=	SYMBOLS[ind[0]].SI_CONVERSION
		END
	END


	; Variables 1D avec DEPEND_0, DEPEND_1                               et SIZES=x
	; Variables 2D avec DEPEND_0, DEPEND_1, DEPEND_2                     et SIZES=x,y
	; Variables 3D avec DEPEND_0, DEPEND_1, DEPEND_2, DEPEND_3           et SIZES=x,y,z
	; Variables 4D avec DEPEND_0, DEPEND_1, DEPEND_2, DEPEND_3, DEPEND_4 et SIZES=x,y,z,t
	NBDIMS = REPLICATE (1L, N_ELEMENTS(SYMBOLS))
	FOR i=0L,N_ELEMENTS(SYMBOLS)-1 DO NBDIMS[i] = N_ELEMENTS(LONG(string_to_data(SYMBOLS[i].sizes)))
	DATA = SYMBOLS.DATA
	DEPEND_0 = SYMBOLS.DEPEND_0
	DEPEND_1 = SYMBOLS.DEPEND_1
	DEPEND_2 = SYMBOLS.DEPEND_2
	DEPEND_3 = SYMBOLS.DEPEND_3
	DEPEND_4 = SYMBOLS.DEPEND_4
	ind1d = WHERE (DATA EQ '' AND DEPEND_0 NE '' AND DEPEND_1 NE '' AND DEPEND_2 EQ '' AND DEPEND_3 EQ '' AND DEPEND_4 EQ '' AND NBDIMS EQ 1 AND SYMBOLS.sizes NE '1', nb1d)
	ind2d = WHERE (DATA EQ '' AND DEPEND_0 NE '' AND DEPEND_1 NE '' AND DEPEND_2 NE '' AND DEPEND_3 EQ '' AND DEPEND_4 EQ '' AND NBDIMS EQ 2, nb2d)
	ind3d = WHERE (DATA EQ '' AND DEPEND_0 NE '' AND DEPEND_1 NE '' AND DEPEND_2 NE '' AND DEPEND_3 NE '' AND DEPEND_4 EQ '' AND NBDIMS EQ 3, nb3d)
	ind4d = WHERE (DATA EQ '' AND DEPEND_0 NE '' AND DEPEND_1 NE '' AND DEPEND_2 NE '' AND DEPEND_3 NE '' AND DEPEND_4 NE '' AND NBDIMS EQ 4, nb4d)
	no = -1


	IF selection_data[0] NE 'Automatic' AND selection_data[0] NE '' THEN BEGIN

		; remplir no et (d1,d2,d3,d4)

		cherche = selection_type EQ 'count3d' ? selection_data[0] : selection_data

		; PATCH POLAR
		; Pour http://cdaweb.gsfc.nasa.gov/istp_public/data/polar/uvi/uvi_level1/$YEAR/po_level1_uvi_$YYYYMMDD_v??.cdf
		; La variable 'INT_IMAGE  ' a t transforme dans l'arbre CDAWeb en 'INT_IMAGE' et sera introuvable
		ind = WHERE (SYMBOLS.name EQ cherche)
		IF ind[0] EQ -1 THEN BEGIN
			ind = WHERE (STRCOMPRESS(SYMBOLS.name, /REMOVE_ALL) EQ STRCOMPRESS(cherche, /REMOVE_ALL))
			IF ind[0] NE -1 THEN BEGIN
				cherche = SYMBOLS[ind[0]].name
				IF selection_type EQ 'count3d' THEN BEGIN
					selection_data[0] = cherche
				END ELSE BEGIN
					selection_data = cherche
				END
			END
		END

		FOR i=0L,N_ELEMENTS(cherche)-1 DO BEGIN
			IF ind1d[0] NE -1 THEN BEGIN
				no1 = WHERE (SYMBOLS[ind1d].name EQ cherche[i]) ; ok pour CDF themis
				IF no1[0] NE -1 THEN BEGIN
					no = no[0] EQ -1 ? [ind1d[no1]] : [no,ind1d[no1]]
					d1 = 1
					d2 = 0
					d3 = 0
					d4 = 0
				END
			END
			IF ind2d[0] NE -1 THEN BEGIN
				no2 = WHERE (SYMBOLS[ind2d].name EQ cherche[i])
				IF no2[0] NE -1 THEN BEGIN
					no = no[0] EQ -1 ? [ind2d[no2]] : [no,ind2d[no2]]
					d1 = 0
					d2 = 1
					d3 = 0
					d4 = 0
				END
			END
			IF ind3d[0] NE -1 THEN BEGIN
				no3 = WHERE (SYMBOLS[ind3d].name EQ cherche[i])
				IF no3[0] NE -1 THEN BEGIN
					no = no[0] EQ -1 ? [ind3d[no3]] : [no,ind3d[no3]]
					d1 = 0
					d2 = 0
					d3 = 1
					d4 = 0
				END
			END
			IF ind4d[0] NE -1 THEN BEGIN
				no4 = WHERE (SYMBOLS[ind4d].name EQ cherche[i])
				IF no4[0] NE -1 THEN BEGIN
					no = no[0] EQ -1 ? [ind4d[no4]] : [no,ind4d[no4]]
					d1 = 0
					d2 = 0
					d3 = 0
					d4 = 1
				END
			END

			IF no[0] EQ -1 THEN BEGIN
				PRINT, "ERROR: VARIABLE " + '"' + cherche + '"' + " DOESN'T EXIST"
				RETURN, 0
			END
		END

	END

	IF no[0] EQ -1 AND selection_type EQ 'count3d' THEN BEGIN
		; En mode automatique, on choisi le premier spectro trouv parmi 1d, 2d, 3d, 4d
		tmp = [ind1d[0],ind2d[0],ind3d[0],ind4d[0]]
		ind = WHERE(tmp EQ -1) & IF ind[0] NE -1 THEN tmp[ind] = 1000000000
		premier_spectro = MIN(tmp)
		IF ind1d[0] EQ premier_spectro THEN BEGIN
			no = ind1d[0]
			d1 = 1
			d2 = 0
			d3 = 0
			d4 = 0
		END ELSE IF ind2d[0] EQ premier_spectro THEN BEGIN
			no = ind2d[0]
			d1 = 0
			d2 = 1
			d3 = 0
			d4 = 0
		END ELSE IF ind3d[0] EQ premier_spectro THEN BEGIN
			no = ind3d[0]
			d1 = 0
			d2 = 0
			d3 = 1
			d4 = 0
		END ELSE IF ind4d[0] EQ premier_spectro THEN BEGIN
			no = ind4d[0]
			d1 = 0
			d2 = 0
			d3 = 0
			d4 = 1
		END
	END
	nodata = no


	noENERGY = -1 ; contiendra le numro du champ definissant les tables d'nergies
	noTHETA = -1 ; idem pour les tables de thetas
	noPHI = -1 ; idem pour les tables de phis
	IF nodata[0] NE -1 AND selection_type EQ 'count3d' THEN BEGIN
		no = nodata[0]

		PROPERTY = SYMBOLS[no].PROPERTY
		UNIT123D = SYMBOLS[no].UNITS
		NAME123D = SYMBOLS[no].FIELDNAM
		IF PROPERTY EQ '' THEN PROPERTY = SYMBOLS[no].UNITS  ; on prend UNITS si PROPERTY est vide (arrive SUR SWEA_DIST)
		SIZES = LONG(string_to_data(SYMBOLS[no].sizes))
		IF d1 OR d2 OR d3 OR d4 THEN BEGIN
			no_DEPEND_1 = WHERE (SYMBOLS.name EQ SYMBOLS[no].DEPEND_1, nb_DEPEND_1)
			IF nb_DEPEND_1 EQ 0 THEN BEGIN
				PRINT, "ERROR: VARIABLE " + '"' + SYMBOLS[no].DEPEND_1 + '"' + " DOESN'T EXIST"
				RETURN, 0
			END
			IF nb_DEPEND_1 GT 1 THEN BEGIN
				PRINT, "WARNING: VARIABLE " + '"' + SYMBOLS[no].DEPEND_1 + '"' + " IS DEFINED MORE THAN ONE TIME"
			END
		END
		IF d2 OR d3 OR d4 THEN BEGIN
			no_DEPEND_2 = WHERE (SYMBOLS.name EQ SYMBOLS[no].DEPEND_2, nb_DEPEND_2)
			IF nb_DEPEND_2 EQ 0 THEN BEGIN
				PRINT, "ERROR: VARIABLE " + '"' + SYMBOLS[no].DEPEND_2 + '"' + " DOESN'T EXIST"
				RETURN, 0
			END
			IF nb_DEPEND_2 GT 1 THEN BEGIN
				PRINT, "WARNING: VARIABLE " + '"' + SYMBOLS[no].DEPEND_2 + '"' + " IS DEFINED MORE THAN ONE TIME"
			END
		END
		IF d3 OR d4 THEN BEGIN
			no_DEPEND_3 = WHERE (SYMBOLS.name EQ SYMBOLS[no].DEPEND_3, nb_DEPEND_3)
			IF nb_DEPEND_3 EQ 0 THEN BEGIN
				PRINT, "ERROR: VARIABLE " + '"' + SYMBOLS[no].DEPEND_3 + '"' + " DOESN'T EXIST"
				RETURN, 0
			END
			IF nb_DEPEND_3 GT 1 THEN BEGIN
				PRINT, "WARNING: VARIABLE " + '"' + SYMBOLS[no].DEPEND_3 + '"' + " IS DEFINED MORE THAN ONE TIME"
			END
		END
		IF d4 THEN BEGIN
			no_DEPEND_4 = WHERE (SYMBOLS.name EQ SYMBOLS[no].DEPEND_4, nb_DEPEND_4)
			IF nb_DEPEND_4 EQ 0 THEN BEGIN
				PRINT, "ERROR: VARIABLE " + '"' + SYMBOLS[no].DEPEND_4 + '"' + " DOESN'T EXIST"
				RETURN, 0
			END
			IF nb_DEPEND_4 GT 1 THEN BEGIN
				PRINT, "WARNING: VARIABLE " + '"' + SYMBOLS[no].DEPEND_4 + '"' + " IS DEFINED MORE THAN ONE TIME"
			END
		END
		IF d1 THEN BEGIN
			; 1 Theta, 1 Phi, Energie=DEPEND_1
			THETA = [[0.0],[90.0],[180.0]]
			PHI = [[0.0],[180.0],[360.0]] 
			ENERGIES = get_min_max_symbols (SYMBOLS, no_DEPEND_1[0], SIZES[0])
			noENERGY = no_DEPEND_1[0]
		END
		IF d2 THEN BEGIN

			; Theta=DEPEND_1, 1 Phi, Energie=DEPEND_2
			THETA = get_min_max_symbols (SYMBOLS, no_DEPEND_1[0], SIZES[0])
			noTHETA = no_DEPEND_1[0]

			PHI = [[0.0],[180.0],[360.0]] 

			ENERGIES = get_min_max_symbols (SYMBOLS, no_DEPEND_2[0], SIZES[1])
			noENERGY = no_DEPEND_2[0]
		END
		IF d3 THEN BEGIN
			; Soit Theta=DEPEND_1, Phi=DEPEND_2
			; Soit Theta=DEPEND_2, Phi=DEPEND_1

			; Je ne traite bien que les phi qui dpendent du temps, pas les theta
			; Il faut choisir maintenant

			; Donc THETA=DEPEND_1, PHI=DEPEND_2, ENERGIES=DEPEND_3
			THETA = get_min_max_symbols (SYMBOLS, no_DEPEND_1[0], SIZES[0])
			noTHETA = no_DEPEND_1[0]

			;PHI = get_min_max_symbols (SYMBOLS, no_DEPEND_2[0], SIZES[1])
			; Patch pour MAVEN_SWIA
			PHI = get_min_max_symbols (SYMBOLS, no_DEPEND_2[0], LONG(PRODUCT(LONG(string_to_data(SYMBOLS[no_DEPEND_2[0]].sizes)))))
			noPHI = no_DEPEND_2[0]
			
			ENERGIES = get_min_max_symbols (SYMBOLS, no_DEPEND_3[0], SIZES[2])
			noENERGY = no_DEPEND_3[0]
		END
		IF d4 THEN BEGIN

			; Donc MASS=DEPEND_1, THETA=DEPEND_2, PHI=DEPEND_3, ENERGIES=DEPEND_4
			MASS = get_min_max_symbols (SYMBOLS, no_DEPEND_1[0], SIZES[0])
			IF MASS[0] NE -1E31 THEN BEGIN
				; ne pas corriger si MASS est dans les enregistrements
				corriger_table, MASS, 0, MASS[*,1]
			END
			;noMASS = no_DEPEND_1[0]

			THETA = get_min_max_symbols (SYMBOLS, no_DEPEND_2[0], SIZES[1])
			noTHETA = no_DEPEND_2[0]

			PHI = get_min_max_symbols (SYMBOLS, no_DEPEND_3[0], SIZES[2])
			noPHI = no_DEPEND_3[0]
			
			ENERGIES = get_min_max_symbols (SYMBOLS, no_DEPEND_4[0], SIZES[3])
			noENERGY = no_DEPEND_4[0]
		END
	END

	no_ENERGY_TABLE = -1 ; contiendra le numro du champ  renommer en 'ENERGY_TABLE'
	no_DELTA_PLUS_ENERGY_TABLE = -1 ; contiendra le numro du champ  renommer en 'DELTA_PLUS_ENERGY_TABLE'
	no_DELTA_MINUS_ENERGY_TABLE = -1 ; contiendra le numro du champ  renommer en 'DELTA_MINUS_ENERGY_TABLE'
	IF noENERGY NE -1 THEN BEGIN
		IF SYMBOLS[noENERGY].data NE '' AND SYMBOLS[noENERGY].delta_plus EQ '' AND SYMBOLS[noENERGY].delta_minus EQ '' THEN BEGIN
			; ni delta_plus ni delta_minus: calcul automatique des MIN et MAX de la table en nergies
			corriger_table, ENERGIES, 0, ENERGIES[*,1]
		END
		IF SYMBOLS[noENERGY].DATA EQ '' AND selection_type EQ 'count3d' THEN BEGIN ; ne pas renommer en mode 'timeseries' ...
			; Les nergies sont dans un champ de donnes. Il faut renommer ce champ en "ENERGY_TABLE"
			no_ENERGY_TABLE = noENERGY
			; chercher si une variable porte le nom de la valeur de l'attribut DELTA_PLUS
			ind = WHERE (STRUPCASE(SYMBOLS.name) EQ STRUPCASE(SYMBOLS[noENERGY].DELTA_PLUS))
			IF ind[0] NE -1 THEN no_DELTA_PLUS_ENERGY_TABLE = ind[0]
			; chercher si une variable porte le nom de la valeur de l'attribut DELTA_MINUS
			ind = WHERE (STRUPCASE(SYMBOLS.name) EQ STRUPCASE(SYMBOLS[noENERGY].DELTA_MINUS))
			IF ind[0] NE -1 THEN no_DELTA_MINUS_ENERGY_TABLE = ind[0]
		END
	END

	IF noTHETA NE -1 THEN BEGIN
		IF SYMBOLS[noTHETA].data NE '' AND SYMBOLS[noTHETA].delta_plus EQ '' AND SYMBOLS[noTHETA].delta_minus EQ '' THEN BEGIN
			; ni delta_plus ni delta_minus: calcul automatique des MIN et MAX de la table en thetas
			corriger_table, THETA, 0, THETA[*,1], /LINEAR
		END
	END

	IF noPHI NE -1 THEN BEGIN
		IF SYMBOLS[noPHI].data NE '' AND SYMBOLS[noPHI].delta_plus EQ '' AND SYMBOLS[noPHI].delta_minus EQ '' THEN BEGIN
			; ni delta_plus ni delta_minus: calcul automatique des MIN et MAX de la table en phis
			corriger_table, PHI, 0, PHI[*,1], /LINEAR
		END
	END


	; Variables sans champ DATA: on les mets dans VARNAMES:
	; - en les dupliquant SIZES fois si DEPEND_1, DEPEND_2 et DEPEND_3 sont vides
	; - en ne les dupliquant pas si DEPEND_1, DEPEND_2 ou DEPEND_3 ne sont pas vides

	FOR no=0L, N_ELEMENTS(SYMBOLS)-1 DO BEGIN		
		IF SYMBOLS[no].data NE '' THEN CONTINUE
		IF no EQ nodate THEN BEGIN
			name = 'date'
			type = 'date'
		END ELSE IF selection_type EQ 'count3d' AND no EQ nodata[0] THEN BEGIN
			name = 'data'
			type = 'data'
		END ELSE BEGIN
			name = SYMBOLS[no].name
			IF no EQ no_ENERGY_TABLE THEN name = 'ENERGY_TABLE'
			IF no EQ no_DELTA_PLUS_ENERGY_TABLE THEN name = 'DELTA_PLUS_ENERGY_TABLE'
			IF no EQ no_DELTA_MINUS_ENERGY_TABLE THEN name = 'DELTA_MINUS_ENERGY_TABLE'
			type = SYMBOLS[no].value_type
		END
		size = string_to_data(SYMBOLS[no].SIZES)
		fillval1 = SYMBOLS[no].fillval
		units1 = SYMBOLS[no].units
		fieldnam1 = SYMBOLS[no].fieldnam
		NBDIMS = LONG(PRODUCT(LONG(size)))

		is_123d = SYMBOLS[no].DEPEND_1 NE '' OR SYMBOLS[no].DEPEND_2 NE '' OR SYMBOLS[no].DEPEND_3 NE '' OR SYMBOLS[no].DEPEND_4 NE ''

		; Patch STEREO-PLASTIC: on a DEPEND_1!='' et DEPEND_2!='' mais SIZES=1
		IF N_ELEMENTS(size) EQ 1 THEN BEGIN
			IF size[0] EQ 1 THEN is_123d = 0
		END
		; Dans les CDF GEOTAIL, les tables d'nergies dfinissent DEPEND_0 et DEPEND_1 ... alors qu'il faut dupliquer ces variables ...
		IF no EQ no_ENERGY_TABLE THEN is_123d = 0
		IF no EQ no_DELTA_PLUS_ENERGY_TABLE THEN is_123d = 0
		IF no EQ no_DELTA_MINUS_ENERGY_TABLE THEN is_123d = 0


		ind = WHERE (nodata EQ no)
		is_data = 0
		is_datax = 0
		is_duplique = 0
		IF (selection_type EQ 'count3d') AND is_123d AND (no EQ nodata[0]) THEN is_data = 1	; no == nodata[0]
		IF (selection_type EQ 'count3d') AND is_123d AND (no NE nodata[0]) THEN is_datax = 1	; no != nodata[0]
		IF (selection_type EQ 'timeseries') AND is_123d AND (ind[0] EQ -1) THEN is_datax = 1	; no n'appartient pas  nodata
		IF (selection_type EQ 'timeseries') AND is_123d AND (ind[0] NE -1) THEN is_duplique = 1	; no appartient  nodata
		IF (~is_123d) AND (NBDIMS NE 1) AND (N_ELEMENTS(size) EQ 1) THEN is_duplique = 1	; vecteur uniquement
		IF is_duplique THEN BEGIN
			IF STRUPCASE(SYMBOLS[no].value_type) EQ 'ISO_TIME_RANGE' THEN BEGIN
				tmp_VARNAMES = REPLICATE('', 2*NBDIMS)	; 2*NBDIMS nouveaux noms de champs  rajouter
			END ELSE BEGIN
				tmp_VARNAMES = REPLICATE('', NBDIMS)	; NBDIMS nouveaux noms de champs  rajouter
			END
			i = 0L
			IF N_ELEMENTS(size) EQ 1 THEN BEGIN
				ind = WHERE (SYMBOLS.NAME EQ SYMBOLS[no].LABL_PTR_1)
				IF ind[0] NE -1 AND no NE no_ENERGY_TABLE AND no NE no_DELTA_PLUS_ENERGY_TABLE AND no NE no_DELTA_MINUS_ENERGY_TABLE THEN BEGIN
					tmp = STRSPLIT(SYMBOLS[ind[0]].DATA, ',', /EXTRACT)
					; supprimer les '(' et ')'
					FOR i1=0L,N_ELEMENTS(tmp)-1 DO BEGIN
						tmp1 = ''
						FOR i2=0L,STRLEN(tmp[i1])-1 DO BEGIN
							c = STRMID(tmp[i1], i2, 1)
							IF c EQ '(' OR c EQ ')' THEN BEGIN
							END ELSE BEGIN
								tmp1 += c
							END
						END
						; supprimer les espaces a la fin
						WHILE (STRMID(tmp1, STRLEN(tmp1)-1, 1) EQ ' ') DO tmp1 = STRMID(tmp1, 0, STRLEN(tmp1)-1)
						; supprimer les espaces au debut
						WHILE (STRMID(tmp1, 0, 1) EQ ' ') DO tmp1 = STRMID(tmp1, 1, STRLEN(tmp1)-1)
						tmp[i1] = tmp1
					END
				END ELSE BEGIN
					tmp = STRSPLIT(SYMBOLS[no].LABL_PTR_1, ',', /EXTRACT)
					FOR i1=0L,N_ELEMENTS(tmp)-1 DO BEGIN
						tmp[i1] = STRTRIM (tmp[i1], 2)
					END
				END
				IF N_ELEMENTS(tmp) NE size[0] THEN tmp = '' ; arrive avec "Sweep_Azimuth" fichier CAA PEACE
				FOR i1=0L,size[0]-1 DO BEGIN
					IF STRUPCASE(SYMBOLS[no].value_type) EQ 'ISO_TIME_RANGE' THEN BEGIN
						tmp_VARNAMES[2*i+0] = name + '_'     + val_to_str(i1+1)
						tmp_VARNAMES[2*i+1] = name + '_end_' + val_to_str(i1+1)
					END ELSE BEGIN
						tmp_VARNAMES[i] = name + '_' + (tmp[0] EQ '' ? val_to_str(i1+1) : tmp[i])
						IF i1 NE 0 THEN BEGIN
							; Patch EQUATOR-S
							ind = WHERE (tmp_VARNAMES[0:i-1] EQ tmp_VARNAMES[i])
							IF ind[0] NE -1 THEN tmp_VARNAMES[i] = name + '_' + val_to_str(i1+1)
						END
					END
					i++
				END
			END ELSE IF N_ELEMENTS(size) EQ 2 THEN BEGIN
				FOR i1=0L,size[0]-1 DO BEGIN
					FOR i2=0L,size[1]-1 DO BEGIN
						IF STRUPCASE(SYMBOLS[no].value_type) EQ 'ISO_TIME_RANGE' THEN BEGIN
							tmp_VARNAMES[2*i+0] = name + '_'     + val_to_str(i1+1) + '_' + val_to_str(i2+1)
							tmp_VARNAMES[2*i+1] = name + '_end_' + val_to_str(i1+1) + '_' + val_to_str(i2+1)
						END ELSE BEGIN
							tmp_VARNAMES[i] = name + '_' + val_to_str(i1+1) + '_' + val_to_str(i2+1)
						END
						i++
					END
				END
			END ELSE IF N_ELEMENTS(size) EQ 3 THEN BEGIN
				FOR i1=0L,size[0]-1 DO BEGIN
					FOR i2=0L,size[1]-1 DO BEGIN
						FOR i3=0L,size[2]-1 DO BEGIN
							IF STRUPCASE(SYMBOLS[no].value_type) EQ 'ISO_TIME_RANGE' THEN BEGIN
								tmp_VARNAMES[2*i+0] = name+'_'    +val_to_str(i1+1)+'_'+val_to_str(i2+1)+'_'+val_to_str(i3+1)
								tmp_VARNAMES[2*i+1] = name+'_end_'+val_to_str(i1+1)+'_'+val_to_str(i2+1)+'_'+val_to_str(i3+1)
							END ELSE BEGIN
								tmp_VARNAMES[i] = name+'_'+val_to_str(i1+1)+'_'+val_to_str(i2+1)+'_'+val_to_str(i3+1)
							END
							i++
						END
					END
				END
			END
			IF STRUPCASE(SYMBOLS[no].value_type) EQ 'ISO_TIME_RANGE' THEN BEGIN
				tmp_SIZES = REPLICATE ('1', 2*NBDIMS)
				tmp_TYPES = REPLICATE ('ISO_TIME', 2*NBDIMS)
				tmp_FILLVALS = REPLICATE (fillval1 EQ '' ? '-1e31' : fillval1, 2*NBDIMS)
				tmp_UNITS = REPLICATE (units1, 2*NBDIMS)
				tmp_FIELDNAMS = REPLICATE (fieldnam1, 2*NBDIMS)
			END ELSE BEGIN
				tmp_SIZES = REPLICATE ('1', NBDIMS)
				tmp_TYPES = REPLICATE (SYMBOLS[no].value_type, NBDIMS)
				tmp_FILLVALS = REPLICATE (fillval1 EQ '' ? '-1e31' : fillval1, NBDIMS)
				tmp_UNITS = REPLICATE (units1, NBDIMS)
				tmp_FIELDNAMS = REPLICATE (fieldnam1, NBDIMS)
			END
		END ELSE BEGIN
			IF STRUPCASE(SYMBOLS[no].value_type) EQ 'ISO_TIME_RANGE' THEN BEGIN
				tmp_VARNAMES = [ name, name+'_end_' ]
				tmp_SIZES = REPLICATE ('1', 2)
				tmp_TYPES = REPLICATE ('ISO_TIME', 2)
				tmp_FILLVALS = REPLICATE (fillval1 EQ '' ? '-1e31' : fillval1, 2)
				tmp_UNITS = REPLICATE (units1, 2)
				tmp_FIELDNAMS = REPLICATE (fieldnam1, 2)
			END ELSE BEGIN
				tmp_VARNAMES = is_datax ? 'datax' : (is_data ? 'data' : name)
				tmp_SIZES = SYMBOLS[no].SIZES
				tmp_TYPES = SYMBOLS[no].value_type
				tmp_FILLVALS = fillval1 EQ '' ? '-1e31' : fillval1
				tmp_UNITS = units1
				tmp_FIELDNAMS = fieldnam1
			END
		END
		IF type EQ 'date' OR type EQ 'data' THEN BEGIN
			tmp_VARNAMES[0] = type
			tmp_TYPES[0] = type
		END
		tmp_REALVARNAMES = tmp_VARNAMES
		tmp_REALVARNAMES[*] = SYMBOLS_NAME[no]
		tmp_NAME_TIME = tmp_VARNAMES
		tmp_NAME_TIME[*] = SYMBOLS[no].DEPEND_0
		tmp_NAME_MASS = REPLICATE ('', N_ELEMENTS(tmp_VARNAMES))
		tmp_UNIT_MASS = REPLICATE ('', N_ELEMENTS(tmp_VARNAMES))
		tmp_NAME_THETA = REPLICATE ('', N_ELEMENTS(tmp_VARNAMES))
		tmp_UNIT_THETA = REPLICATE ('', N_ELEMENTS(tmp_VARNAMES))
		tmp_NAME_PHI = REPLICATE ('', N_ELEMENTS(tmp_VARNAMES))
		tmp_UNIT_PHI = REPLICATE ('', N_ELEMENTS(tmp_VARNAMES))
		tmp_NAME_ENERGY = REPLICATE ('', N_ELEMENTS(tmp_VARNAMES))
		tmp_UNIT_ENERGY = REPLICATE ('', N_ELEMENTS(tmp_VARNAMES))

		; variable 1D
		tmp = WHERE (ind1d EQ no)
		IF tmp[0] NE -1 THEN BEGIN
			tmp_NAME_ENERGY[*] = SYMBOLS[no].DEPEND_1	; ENERGY
			tmp_UNIT_ENERGY[*] = 'ENERGY'			; ENERGY
			tmp = WHERE(SYMBOLS.name EQ SYMBOLS[no].DEPEND_1) & IF tmp[0] NE -1 THEN tmp_UNIT_ENERGY[*] = SYMBOLS[tmp[0]].UNITS
		END

		; variable 2D
		tmp = WHERE (ind2d EQ no)
		IF tmp[0] NE -1 THEN BEGIN
			tmp_NAME_THETA[*] = SYMBOLS[no].DEPEND_1	; THETA
			tmp_UNIT_THETA[*] = 'THETA'			; THETA
			tmp = WHERE(SYMBOLS.name EQ SYMBOLS[no].DEPEND_1) & IF tmp[0] NE -1 THEN tmp_UNIT_THETA[*] = SYMBOLS[tmp[0]].UNITS

			tmp_NAME_ENERGY[*] = SYMBOLS[no].DEPEND_2	; ENERGY
			tmp_UNIT_ENERGY[*] = 'ENERGY'			; ENERGY
			tmp = WHERE(SYMBOLS.name EQ SYMBOLS[no].DEPEND_2) & IF tmp[0] NE -1 THEN tmp_UNIT_ENERGY[*] = SYMBOLS[tmp[0]].UNITS
		END

		; variable 3D
		tmp = WHERE (ind3d EQ no)
		IF tmp[0] NE -1 THEN BEGIN
			tmp_NAME_THETA[*] = SYMBOLS[no].DEPEND_1	; THETA
			tmp_UNIT_THETA[*] = 'THETA'			; THETA
			tmp = WHERE(SYMBOLS.name EQ SYMBOLS[no].DEPEND_1) & IF tmp[0] NE -1 THEN tmp_UNIT_THETA[*] = SYMBOLS[tmp[0]].UNITS

			tmp_NAME_PHI[*] = SYMBOLS[no].DEPEND_2		; PHI
			tmp_UNIT_PHI[*] = 'PHI'				; PHI
			tmp = WHERE(SYMBOLS.name EQ SYMBOLS[no].DEPEND_2) & IF tmp[0] NE -1 THEN tmp_UNIT_PHI[*] = SYMBOLS[tmp[0]].UNITS

			tmp_NAME_ENERGY[*] = SYMBOLS[no].DEPEND_3	; ENERGY
			tmp_UNIT_ENERGY[*] = 'ENERGY'			; ENERGY
			tmp = WHERE(SYMBOLS.name EQ SYMBOLS[no].DEPEND_3) & IF tmp[0] NE -1 THEN tmp_UNIT_ENERGY[*] = SYMBOLS[tmp[0]].UNITS
		END

		; variable 4D
		tmp = WHERE (ind4d EQ no)
		IF tmp[0] NE -1 THEN BEGIN
			tmp_NAME_MASS[*] = SYMBOLS[no].DEPEND_1		; MASS
			tmp_UNIT_MASS[*] = 'MASS'			; MASS
			tmp = WHERE(SYMBOLS.name EQ SYMBOLS[no].DEPEND_1) & IF tmp[0] NE -1 THEN tmp_UNIT_MASS[*] = SYMBOLS[tmp[0]].UNITS

			tmp_NAME_THETA[*] = SYMBOLS[no].DEPEND_2	; THETA
			tmp_UNIT_THETA[*] = 'THETA'			; THETA
			tmp = WHERE(SYMBOLS.name EQ SYMBOLS[no].DEPEND_2) & IF tmp[0] NE -1 THEN tmp_UNIT_THETA[*] = SYMBOLS[tmp[0]].UNITS

			tmp_NAME_PHI[*] = SYMBOLS[no].DEPEND_3		; PHI
			tmp_UNIT_PHI[*] = 'PHI'				; PHI
			tmp = WHERE(SYMBOLS.name EQ SYMBOLS[no].DEPEND_3) & IF tmp[0] NE -1 THEN tmp_UNIT_PHI[*] = SYMBOLS[tmp[0]].UNITS

			tmp_NAME_ENERGY[*] = SYMBOLS[no].DEPEND_4	; ENERGY
			tmp_UNIT_ENERGY[*] = 'ENERGY'			; ENERGY
			tmp = WHERE(SYMBOLS.name EQ SYMBOLS[no].DEPEND_4) & IF tmp[0] NE -1 THEN tmp_UNIT_ENERGY[*] = SYMBOLS[tmp[0]].UNITS
		END

		IF VARNAMES[0] EQ '' THEN BEGIN
			VARNAMES	= [tmp_VARNAMES]
			REALVARNAMES	= [tmp_REALVARNAMES]
			TYPES		= [tmp_TYPES]
			SIZES		= [tmp_SIZES]
			FILLVALS	= [tmp_FILLVALS]
			UNITS		= [tmp_UNITS]
			FIELDNAMS	= [tmp_FIELDNAMS]
			NAME_TIME	= [tmp_NAME_TIME]
			NAME_MASS	= [tmp_NAME_MASS]
			UNIT_MASS	= [tmp_UNIT_MASS]
			NAME_THETA	= [tmp_NAME_THETA]
			UNIT_THETA	= [tmp_UNIT_THETA]
			NAME_PHI	= [tmp_NAME_PHI]
			UNIT_PHI	= [tmp_UNIT_PHI]
			NAME_ENERGY	= [tmp_NAME_ENERGY]
			UNIT_ENERGY	= [tmp_UNIT_ENERGY]
		END ELSE BEGIN
			VARNAMES	= [VARNAMES,tmp_VARNAMES]
			REALVARNAMES	= [REALVARNAMES,tmp_REALVARNAMES]
			TYPES		= [TYPES,tmp_TYPES]
			SIZES		= [SIZES,tmp_SIZES]
			FILLVALS	= [FILLVALS,tmp_FILLVALS]
			UNITS		= [UNITS,tmp_UNITS]
			FIELDNAMS	= [FIELDNAMS,tmp_FIELDNAMS]
			NAME_TIME	= [NAME_TIME,tmp_NAME_TIME]
			NAME_MASS	= [NAME_MASS,tmp_NAME_MASS]
			UNIT_MASS	= [UNIT_MASS,tmp_UNIT_MASS]
			NAME_THETA	= [NAME_THETA,tmp_NAME_THETA]
			UNIT_THETA	= [UNIT_THETA,tmp_UNIT_THETA]
			NAME_PHI	= [NAME_PHI,tmp_NAME_PHI]
			UNIT_PHI	= [UNIT_PHI,tmp_UNIT_PHI]
			NAME_ENERGY	= [NAME_ENERGY,tmp_NAME_ENERGY]
			UNIT_ENERGY	= [UNIT_ENERGY,tmp_UNIT_ENERGY]
		END
	END

	ind1 = WHERE (SYMBOLS.NAME EQ 'EMIN' AND SYMBOLS.EXCEPTION EQ 1)
	ind2 = WHERE (SYMBOLS.NAME EQ 'EMOY' AND SYMBOLS.EXCEPTION EQ 1)
	ind3 = WHERE (SYMBOLS.NAME EQ 'EMAX' AND SYMBOLS.EXCEPTION EQ 1)
	IF ind1[0] NE -1 AND ind2[0] NE -1 AND ind3[0] NE -1 THEN BEGIN
		EMIN = FLOAT(string_to_data(SYMBOLS[ind1[0]].DATA))
		EMOY = FLOAT(string_to_data(SYMBOLS[ind2[0]].DATA))
		EMAX = FLOAT(string_to_data(SYMBOLS[ind3[0]].DATA))
	END

	ind1 = WHERE (SYMBOLS.NAME EQ 'TMIN' AND SYMBOLS.EXCEPTION EQ 1)
	ind2 = WHERE (SYMBOLS.NAME EQ 'TMOY' AND SYMBOLS.EXCEPTION EQ 1)
	ind3 = WHERE (SYMBOLS.NAME EQ 'TMAX' AND SYMBOLS.EXCEPTION EQ 1)
	IF ind1[0] NE -1 AND ind2[0] NE -1 AND ind3[0] NE -1 THEN BEGIN
		TMIN = FLOAT(string_to_data(SYMBOLS[ind1[0]].DATA))
		TMOY = FLOAT(string_to_data(SYMBOLS[ind2[0]].DATA))
		TMAX = FLOAT(string_to_data(SYMBOLS[ind3[0]].DATA))
	END

	ind1 = WHERE (SYMBOLS.NAME EQ 'PMIN' AND SYMBOLS.EXCEPTION EQ 1)
	ind2 = WHERE (SYMBOLS.NAME EQ 'PMOY' AND SYMBOLS.EXCEPTION EQ 1)
	ind3 = WHERE (SYMBOLS.NAME EQ 'PMAX' AND SYMBOLS.EXCEPTION EQ 1)
	IF ind1[0] NE -1 AND ind2[0] NE -1 AND ind3[0] NE -1 THEN BEGIN
		PMIN = FLOAT(string_to_data(SYMBOLS[ind1[0]].DATA))
		PMOY = FLOAT(string_to_data(SYMBOLS[ind2[0]].DATA))
		PMAX = FLOAT(string_to_data(SYMBOLS[ind3[0]].DATA))
	END

	ind1 = WHERE (SYMBOLS.NAME EQ 'AMIN' AND SYMBOLS.EXCEPTION EQ 1)
	ind2 = WHERE (SYMBOLS.NAME EQ 'AMOY' AND SYMBOLS.EXCEPTION EQ 1)
	ind3 = WHERE (SYMBOLS.NAME EQ 'AMAX' AND SYMBOLS.EXCEPTION EQ 1)
	IF ind1[0] NE -1 AND ind2[0] NE -1 AND ind3[0] NE -1 THEN BEGIN
		AMIN = FLOAT(string_to_data(SYMBOLS[ind1[0]].DATA))
		AMOY = FLOAT(string_to_data(SYMBOLS[ind2[0]].DATA))
		AMAX = FLOAT(string_to_data(SYMBOLS[ind3[0]].DATA))
	END

	; LINT: je n'utilise pas MMIN, MMOY et MMAX
	;ind1 = WHERE (SYMBOLS.NAME EQ 'MMIN' AND SYMBOLS.EXCEPTION EQ 1)
	;ind2 = WHERE (SYMBOLS.NAME EQ 'MMOY' AND SYMBOLS.EXCEPTION EQ 1)
	;ind3 = WHERE (SYMBOLS.NAME EQ 'MMAX' AND SYMBOLS.EXCEPTION EQ 1)
	;IF ind1[0] NE -1 AND ind2[0] NE -1 AND ind3[0] NE -1 THEN BEGIN
	;	MMIN = FLOAT(string_to_data(SYMBOLS[ind1[0]].DATA))
	;	MMOY = FLOAT(string_to_data(SYMBOLS[ind2[0]].DATA))
	;	MMAX = FLOAT(string_to_data(SYMBOLS[ind3[0]].DATA))
	;END

	IF (N_ELEMENTS(EMIN) NE 0) AND (N_ELEMENTS(TMIN) NE 0) AND (N_ELEMENTS(PMIN) NE 0) AND (N_ELEMENTS(AMIN) EQ 0) THEN BEGIN

		; fichier ascii (time,energy,theta,phi) sera vu comme (time,energy,theta,phi) par cl
		ENERGIES = [[EMIN],[EMOY],[EMAX]]
		THETA = [[TMIN],[TMOY],[TMAX]]
		PHI = [[PMIN],[PMOY],[PMAX]]

	END ELSE IF (N_ELEMENTS(EMIN) NE 0) AND (N_ELEMENTS(TMIN) EQ 0) AND (N_ELEMENTS(PMIN) EQ 0) AND (N_ELEMENTS(AMIN) NE 0) THEN BEGIN

		; fichier ascii (time,energy,pitchangle) sera vu comme (time,energy,theta) par cl
		ENERGIES = [[EMIN],[EMOY],[EMAX]]
		THETA = [[AMIN],[AMOY],[AMAX]]

	END ELSE IF (N_ELEMENTS(EMIN) EQ 0) AND (N_ELEMENTS(TMIN) EQ 0) AND (N_ELEMENTS(PMIN) EQ 0) AND (N_ELEMENTS(AMIN) NE 0) THEN BEGIN

		; fichier ascii (time,pitchangle) sera vu comme (time,energy) par cl
		ENERGIES = [[AMIN],[AMOY],[AMAX]]

	END ELSE IF (N_ELEMENTS(EMIN) NE 0) AND (N_ELEMENTS(TMIN) EQ 0) AND (N_ELEMENTS(PMIN) EQ 0) AND (N_ELEMENTS(AMIN) EQ 0) THEN BEGIN

		; fichier ascii (time,energy) sera vu comme (time,energy) par cl
		ENERGIES = [[EMIN],[EMOY],[EMAX]]

	END ELSE IF (N_ELEMENTS(EMIN) EQ 0) AND (N_ELEMENTS(TMIN) NE 0) AND (N_ELEMENTS(PMIN) EQ 0) AND (N_ELEMENTS(AMIN) EQ 0) THEN BEGIN

		; fichier ascii (time,theta) sera vu comme (time,energy) par cl
		ENERGIES = [[TMIN],[TMOY],[TMAX]]

	END ELSE IF (N_ELEMENTS(EMIN) EQ 0) AND (N_ELEMENTS(TMIN) EQ 0) AND (N_ELEMENTS(PMIN) NE 0) AND (N_ELEMENTS(AMIN) EQ 0) THEN BEGIN

		; fichier ascii (time,phi) sera vu comme (time,energy) par cl
		ENERGIES = [[PMIN],[PMOY],[PMAX]]


	END


	;duree = duree+nbsec()-topduree
	;PRINT,'duree2 = ' + val_to_str_2decimales(duree)+' sec'

	IF VARNAMES[0] EQ '' THEN BEGIN
		PRINT, 'ERROR: NO VARIABLES TO READ'
		RETURN, 0
	END

	RETURN, 1

END


;-------------------------------------------------------------------------------
PRO correct_epoch_for_cl,	$
;-------------------------------------------------------------------------------
	DATA,	$	; LINT_PROTOTYPE input
	DT		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (ASCII_CEF_CDF) ((-)) Positionne le champ date des donnes spectro au temps dbut des donnes.
;-------------------------------------------------------------------------------

	IF is_structure(DATA) THEN BEGIN
		ind = WHERE (TAG_NAMES(DATA) EQ 'DATA')
		is3d = ind[0] NE -1
		nbdata = N_ELEMENTS(DATA)
		IF is3d THEN BEGIN
			; Positionnement du temps des donnes 3D au dbut
			DATA.date -= 1000d * dt_to_delta (DATA, DT, 0, nbdata-1, /MINUS)
		END ELSE BEGIN
			; Positionnement du temps des donnes non 3D au milieu
			; Je pense que ca ne sert  rien et ca consomme pas mal de temps CPU
			; data.date = data.date + 500d * (dt_to_delta (data, DT, 0, nbdata-1, /PLUS) - dt_to_delta (data, DT, 0, nbdata-1, /MINUS))
		END
	END

END

;-------------------------------------------------------------------------------
FUNCTION my_clip,	$
;-------------------------------------------------------------------------------
	tabx,	$		; LINT_PROTOTYPE input
	taby,	$		; LINT_PROTOTYPE input
	xmin,	$		; LINT_PROTOTYPE input
	xmax,	$		; LINT_PROTOTYPE input
	ymin,	$		; LINT_PROTOTYPE input
	ymax,	$		; LINT_PROTOTYPE input
	clipx,	$		; LINT_PROTOTYPE output
	clipy			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Dcoupe tabx et taby dans le rectangle (xmin,xmax,ymin,ymax) et retourne clipx et clipy (1 si ok, 0 sinon)
;-------------------------------------------------------------------------------

	typex = SIZE(tabx, /TYPE)
	typey = SIZE(taby, /TYPE)
	nb = N_ELEMENTS(tabx)
	nbclip = 0L
	clipx = REPLICATE (tabx[0], nb*2)
	clipy = REPLICATE (taby[0], nb*2)

	IF typex EQ 14 AND typey EQ 4 THEN BEGIN
		; ex: resource/dsp_CSSAR1.cl.gz
		; tabx=LONG64 et taby=FLOAT
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'CLIPPING_LONG64_FLOAT_AUTO_GLUE',	$
						tabx, taby, nb,							$
						LONG64(xmin), LONG64(xmax), FLOAT(ymin), FLOAT(ymax),		$
						clipx, clipy, nbclip, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'CLIPPING_LONG64_FLOAT',			$
						tabx, taby, nb,							$
						LONG64(xmin), LONG64(xmax), FLOAT(ymin), FLOAT(ymax),		$
						clipx, clipy, nbclip)
		END
	END ELSE IF typex EQ 4 AND typey EQ 4 THEN BEGIN
		; ex: projets/taranis/taranis_bug.cl
		; tabx=FLOAT et taby=FLOAT
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'CLIPPING_FLOAT_FLOAT_AUTO_GLUE',		$
						tabx, taby, nb, 						$
						FLOAT(xmin), FLOAT(xmax), FLOAT(ymin), FLOAT(ymax),		$
						clipx, clipy, nbclip, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'CLIPPING_FLOAT_FLOAT',			$
						tabx, taby, nb, 						$
						FLOAT(xmin), FLOAT(xmax), FLOAT(ymin), FLOAT(ymax),		$
						clipx, clipy, nbclip)
		END
	END ELSE IF typex EQ 5 AND typey EQ 4 THEN BEGIN
		; ex: projets/taranis/taranis_idee_spectre_A.cl
		; tabx=DOUBLE et taby=FLOAT
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'CLIPPING_DOUBLE_FLOAT_AUTO_GLUE',	$
						tabx, taby, nb, 						$
						DOUBLE(xmin), DOUBLE(xmax), FLOAT(ymin), FLOAT(ymax),		$
						clipx, clipy, nbclip, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'CLIPPING_DOUBLE_FLOAT',			$
						tabx, taby, nb, 						$
						DOUBLE(xmin), DOUBLE(xmax), FLOAT(ymin), FLOAT(ymax),		$
						clipx, clipy, nbclip)
		END
	END ELSE IF typex EQ 5 AND typey EQ 5 THEN BEGIN
		; ex: projets/mms/mms_1234-DistFunc.cl
		; tabx=DOUBLE et taby=DOUBLE
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'CLIPPING_DOUBLE_DOUBLE_AUTO_GLUE',	$
						tabx, taby, nb, 						$
						DOUBLE(xmin), DOUBLE(xmax), DOUBLE(ymin), DOUBLE(ymax),		$
						clipx, clipy, nbclip, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'CLIPPING_DOUBLE_DOUBLE',			$
						tabx, taby, nb, 						$
						DOUBLE(xmin), DOUBLE(xmax), DOUBLE(ymin), DOUBLE(ymax),		$
						clipx, clipy, nbclip)
		END
	END ELSE BEGIN
		; ex: aucun exmple
		; que faire ?
		clipx = tabx
		clipy = taby
		nbclip = nb
	END

	IF nbclip NE 0 THEN BEGIN
		clipx = clipx[0:nbclip-1]
		clipy = clipy[0:nbclip-1]
		RETURN, 1
	END

	RETURN, 0
END

;-------------------------------------------------------------------------------
FUNCTION my_map_image_hammer_aitoff,	$
;-------------------------------------------------------------------------------
	image		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de MAP_IMAGE pour fdl.
;-------------------------------------------------------------------------------

	nbxnew = 567L
	nbynew = 283L
	image_new = REPLICATE (!VALUES.F_INFINITY, nbxnew, nbynew)
	IF is_fdl() THEN BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'HAMMER_AITOFF_MAP_IMAGE_AUTO_GLUE',	$
				image, image_new, nbxnew, nbynew, !VALUES.F_INFINITY, /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'HAMMER_AITOFF_MAP_IMAGE',	$
				image, image_new, nbxnew, nbynew, !VALUES.F_INFINITY)
	END
	RETURN, image_new

END

;-------------------------------------------------------------------------------
PRO my_map_grid,		$
;-------------------------------------------------------------------------------
	lons=lons,		$	; LINT_PROTOTYPE input
	lats=lats,		$	; LINT_PROTOTYPE input
	color=color,		$	; LINT_PROTOTYPE input
	position=position		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de MAP_GRID pour fdl.
;-------------------------------------------------------------------------------

	nbxnew = 567L
	nbynew = 283L

	FOR ilong=0L,N_ELEMENTS(lons)-1 DO BEGIN
		longitude = FLOAT(lons[ilong])
		lignex = REPLICATE (!VALUES.F_INFINITY, 1000)
		ligney = REPLICATE (!VALUES.F_INFINITY, 1000)
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'HAMMER_AITOFF_MAP_GRID_LONS_AUTO_GLUE',			$
							longitude LE 180 ? longitude-0.01 : longitude+0.01, lignex, ligney, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'HAMMER_AITOFF_MAP_GRID_LONS',				$
							longitude LE 180 ? longitude-0.01 : longitude+0.01, lignex, ligney)
		END
		ind = WHERE (lignex NE !VALUES.F_INFINITY, nb)
		lignex = lignex[ind]
		ligney = ligney[ind]
		IF nb GT 2 THEN BEGIN
			tmp1x = lignex[0]
			tmp1y = ligney[0]
			tmp2x = lignex[nb-1]
			tmp2y = ligney[nb-1]
			FOR i=0L,nb-1 DO BEGIN
				IF i MOD 10 EQ 0 THEN CONTINUE
				lignex[i] = !VALUES.F_INFINITY
				ligney[i] = !VALUES.F_INFINITY
			END
			lignex[0] = tmp1x
			ligney[0] = tmp1y
			lignex[nb-1] = tmp2x
			ligney[nb-1] = tmp2y
			ind = WHERE (lignex NE !VALUES.F_INFINITY)
			lignex = lignex[ind]
			ligney = ligney[ind]
		END
		libplot_plot, lignex, ligney,									$
			xrange=[0,nbxnew], yrange=[0,nbynew],							$
			position=position, /NOERASE, xstyle=5, ystyle=5, color=color, linestyle=is_gdl() ? 2 : 1
	END

	FOR ilat=0L,N_ELEMENTS(lats)-1 DO BEGIN
		latitude = FLOAT(lats[ilat])
		lignex = REPLICATE (!VALUES.F_INFINITY, 1000)
		ligney = REPLICATE (!VALUES.F_INFINITY, 1000)
		IF is_fdl() THEN BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'HAMMER_AITOFF_MAP_GRID_LATS_AUTO_GLUE',		$
					latitude LT 0 ? latitude+0.01+90 : latitude-0.01+90, lignex, ligney, /AUTO_GLUE)
		END ELSE BEGIN
			lint_unused = CALL_EXTERNAL (libname('util'), 'HAMMER_AITOFF_MAP_GRID_LATS',			$
					latitude LT 0 ? latitude+0.01+90 : latitude-0.01+90, lignex, ligney)
		END
		ind = WHERE (lignex NE !VALUES.F_INFINITY, nb)
		lignex = lignex[ind]
		ligney = ligney[ind]
		IF nb GT 2 THEN BEGIN
			tmp1x = lignex[0]
			tmp1y = ligney[0]
			tmp2x = lignex[nb-1]
			tmp2y = ligney[nb-1]
			FOR i=0L,nb-1 DO BEGIN
				IF i MOD 10 EQ 0 THEN CONTINUE
				lignex[i] = !VALUES.F_INFINITY
				ligney[i] = !VALUES.F_INFINITY
			END
			lignex[0] = tmp1x
			ligney[0] = tmp1y
			lignex[nb-1] = tmp2x
			ligney[nb-1] = tmp2y
			ind = WHERE (lignex NE !VALUES.F_INFINITY)
			lignex = lignex[ind]
			ligney = ligney[ind]
		END
		libplot_plot, lignex, ligney,									$
			xrange=[0,nbxnew], yrange=[0,nbynew],							$
			position=position, /NOERASE, xstyle=5, ystyle=5, color=color, linestyle=is_gdl() ? 2 : 1
	END

END

;-------------------------------------------------------------------------------
PRO my_map_plot,		$
;-------------------------------------------------------------------------------
	longitude,		$	; LINT_PROTOTYPE input
	latitude,		$	; LINT_PROTOTYPE input
	psym=psym,		$	; LINT_PROTOTYPE input
	symsize=symsize,	$	; LINT_PROTOTYPE input
	thick=thick,		$	; LINT_PROTOTYPE input
	color=color,		$	; LINT_PROTOTYPE input
	position=position		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de PLOT avec MAP pour fdl.
;-------------------------------------------------------------------------------

	nbxnew = 567L
	nbynew = 283L

	x = 0.
	y = 0.
	IF is_fdl() THEN BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'HAMMER_AITOFF_CONVERT_AUTO_GLUE',	$
				longitude, latitude, x, y, /AUTO_GLUE)
	END ELSE BEGIN
		lint_unused = CALL_EXTERNAL (libname('util'), 'HAMMER_AITOFF_CONVERT',			$
				longitude, latitude, x, y)
	END

	libplot_plot, [x], [y],						$
		xrange=[0,nbxnew], yrange=[0,nbynew],			$
		position=position, /NOERASE, xstyle=5, ystyle=5,	$
		psym=psym, symsize=symsize, thick=thick, color=color

END


;-------------------------------------------------------------------------------
FUNCTION my_map_continents_getindex,	$
;-------------------------------------------------------------------------------
	indx,				$	; LINT_PROTOTYPE input
	error					; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Equivalent de MAP_CONTINENTS_GETINDEX pour fdl.
;-------------------------------------------------------------------------------

	OPENR, lun, indx, /xdr, /get_lun, error=error
	IF error NE 0 THEN RETURN, 0
	segments = 0L
	READU, lun, segments
	dx_map = REPLICATE ( { fptr:0L, npts:0L, latmax:0., latmin:0., lonmax:0., lonmin:0. }, segments)
	READU, lun, dx_map
	FREE_LUN, lun
	FREE_LUN, lun
	RETURN, dx_map

END


;-------------------------------------------------------------------------------
PRO my_map_continents_do_segments,	$
;-------------------------------------------------------------------------------
	fnames,				$	; LINT_PROTOTYPE input
	p0lat,				$	; LINT_PROTOTYPE input
	p0long,				$	; LINT_PROTOTYPE input
	xmin,				$	; LINT_PROTOTYPE input
	xmax,				$	; LINT_PROTOTYPE input
	ymin,				$	; LINT_PROTOTYPE input
	ymax,				$	; LINT_PROTOTYPE input
	hires,				$	; LINT_PROTOTYPE input
	thick,				$	; LINT_PROTOTYPE input
	color,				$	; LINT_PROTOTYPE input
	position				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de MAP_CONTINENTS_DO_SEGMENT pour fdl.
;-------------------------------------------------------------------------------

	lun = -1
	sub = (['low', 'high'])[hires]
	fndx = GETENV('CL_ROOT') + '/resource/maps/' + sub + '/' + fnames[hires]+'.ndx'
	dat =  GETENV('CL_ROOT') + '/resource/maps/' + sub + '/' + fnames[hires]+'.dat'
	ndx = my_map_continents_getindex(fndx, error)		;OPEN it
	IF error EQ 0 THEN OPENR, lun, dat, /xdr, /stream, /get, error=error
	IF lun LT 0 THEN OPENR, lun, dat, /xdr, /stream, /get, error=error
	IF error NE 0 THEN MESSAGE, 'Map file:'+fnames[hires]+' not found'

	count = N_ELEMENTS(ndx)

	IF count GT 0 THEN BEGIN

		libplot_plot, [1,2], [1,2], XRANGE=[xmin,xmax], YRANGE=[ymin,ymax], position=position, XSTYLE=5, YSTYLE=5, /NOERASE, /NODATA

		FOR i=0L, count-1 DO BEGIN

			POINT_LUN, lun, ndx[i].fptr

			IF ndx[i].npts LT 2 THEN CONTINUE

			xy = FLTARR (2, ndx[i].NPTS, /NOZERO)
			READU, lun, xy
			xy = REVERSE(xy)

			tabx = REFORM (xy[0,*])
			taby = REFORM (xy[1,*])
			IF p0long EQ 180 THEN BEGIN
				ind = WHERE (tabx LT 0)
				IF ind[0] NE -1 THEN tabx[ind] += 360
			END
			IF p0lat EQ p0lat THEN BEGIN
				; pour ne pas avoir de message LINT UNUSED PARAM "p0lat"
			END

			nb = N_ELEMENTS(tabx)
			diff = tabx[1:nb-1] - tabx[0:nb-2]
			ind = WHERE (diff GT 300 OR diff LT -300)
			IF ind[0] EQ -1 THEN BEGIN
				IF !CL.libplot EQ '' && (is_gdl() OR is_fdl()) THEN BEGIN
					code = my_clip (tabx, taby, xmin, xmax, ymin, ymax, clipx, clipy)
					IF code EQ 1 THEN libplot_plots, clipx, clipy, color=color, thick=thick
				END ELSE BEGIN
					libplot_plots, tabx, taby, color=color, thick=thick
				END
			END ELSE BEGIN
				debut = 0L
				FOR j=0L,N_ELEMENTS(ind)-1 DO BEGIN
					fin = ind[j]
					IF !CL.libplot EQ '' && (is_gdl() OR is_fdl()) THEN BEGIN
						code = my_clip (tabx[debut:fin], taby[debut:fin], xmin, xmax, ymin, ymax, clipx, clipy)
						IF code EQ 1 THEN libplot_plots, clipx, clipy, color=color, thick=thick
					END ELSE BEGIN
						libplot_plots, tabx[debut:fin], taby[debut:fin], color=color, thick=thick
					END
					debut = fin+1
				END
				IF !CL.libplot EQ '' && (is_gdl() OR is_fdl()) THEN BEGIN
					code = my_clip (tabx[debut:*], taby[debut:*], xmin, xmax, ymin, ymax, clipx, clipy)
					IF code EQ 1 THEN libplot_plots, clipx, clipy, color=color, thick=thick
				END ELSE BEGIN
					libplot_plots, tabx[debut:*], taby[debut:*], color=color, thick=thick
				END
			END
		END
	END

	FREE_LUN, lun

END


;-------------------------------------------------------------------------------
PRO my_map_continents,		$
;-------------------------------------------------------------------------------
	p0lat,			$	; LINT_PROTOTYPE input
	p0long,			$	; LINT_PROTOTYPE input
	xmin,			$	; LINT_PROTOTYPE input
	xmax,			$	; LINT_PROTOTYPE input
	ymin,			$	; LINT_PROTOTYPE input
	ymax,			$	; LINT_PROTOTYPE input
	hires,			$	; LINT_PROTOTYPE input
	mlinethick,		$	; LINT_PROTOTYPE input
	color,	 		$	; LINT_PROTOTYPE input
	position			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Equivalent de MAP_CONTINENTS pour fdl.
;-------------------------------------------------------------------------------

	my_map_continents_do_segments, ['plow', 'phigh'], p0lat, p0long, xmin, xmax, ymin, ymax, hires, mlinethick, color, position

END
