;-------------------------------------------------------------------------------
FUNCTION decompresse_log, p
;-------------------------------------------------------------------------------
	IF p LT 32 THEN BEGIN
		valeur = p
	END ELSE IF p LT 224 THEN BEGIN
		m1 = p AND '0F'XUL
		e1 = ISHFT ( p AND 'F0'XUL, -4)
		valeur = ISHFT ( 16+m1, e1-1)
	END ELSE BEGIN
		m2 = p AND '07'XUL
		e2 = ISHFT ( p AND 'F8'XUL, -3)
		valeur = ISHFT (8+m2, e2-14)
	END
	RETURN, valeur
END

;-------------------------------------------------------------------------------
PRO lire, annee, mois, jour
;-------------------------------------------------------------------------------
	nbdico = 256L
	dico = REPLICATE (0L,nbdico)
	FOR i=0L,nbdico-1 DO dico[i] = decompresse_log (i)

	COMMON COMMON_CL, general
	p = get (general, 'p')

	; On va lire de date1  date2
	date1 = val_to_str(jour)+' '+val_to_str(mois)+' '+val_to_str(annee)
	date2 = date1 + ' 23 59 59.999'

	; Fichier 32 nergies
	produit_32e = p[ 4,36,1] ; 4=32e, 36=electron interball, 1=nosat
	code_32e = produit_32e->get_data(str_to_date(date1),str_to_date(date2),/exact1,/exact2,data_32e)
	coups_32e = code_32e EQ 1 ? dico[data_32e.data] : -1
	HELP,date1, data_32e, coups_32e, /str

	; Fichier 16 nergies
	produit_16e = p[ 5,36,1] ; 5=16e, 36=electron interball, 1=nosat
	code_16e = produit_16e->get_data(str_to_date(date1),str_to_date(date2),/exact1,/exact2,data_16e)
	coups_16e = code_16e EQ 1 ? dico[data_16e.data] : -1
	HELP,date1, data_16e, coups_16e, /str
STOP

END


;-------------------------------------------------------------------------------
PRO interball_coco
;------------------------------------------------------------------------------
	FOR tmp=str_to_date('20 1 1996'),str_to_date('20 1 1996'), 86400*1000d DO BEGIN
		date_to_tu, tmp, annee, mois, jour, heure, minute, seconde
		lire, annee, mois, jour
	END

END

