;
;	Fichier	: $RCSfile: image__define.pro,v $, v $Revision: 1.29 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO image::setproperty,	$
;-------------------------------------------------------------------------------
	nom,			$	; LINT_PROTOTYPE input
	val,			$	; LINT_PROTOTYPE input
	passaveold=passaveold		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Positionne la variable nom à la valeur val.
;-------------------------------------------------------------------------------

	self -> obj::setproperty, nom, val, passaveold=passaveold

	IF nom EQ 'palette_cube' THEN BEGIN

		no = self -> obj::getproperty ('palette_nbcolors', /no)
		decompose_no, no, no_reel, cfils, cpere, cinvisible
		cfils = val NE 'No'
		no = recompose_no (no_reel, cfils, cpere, cinvisible)
		self -> obj::setproperty, 'palette_nbcolors', no, /no

	END ELSE IF nom EQ 'filename' THEN BEGIN

		time_t1		= str_to_date(get(self,'time_t1'))
		tmp		= date_to_str(time_t1, format=3)
		YYYYMMDD	= STRMID(tmp,0,4)+STRMID(tmp,5,2)+STRMID(tmp,8,2)
		YEAR		= STRMID(YYYYMMDD,0,4)
		MONTH		= STRMID(YYYYMMDD,4,2)
		DAY		= STRMID(YYYYMMDD,6,2)
		DOY		= int_str_0(year_month_day_to_doy(YEAR,MONTH,DAY),3)
		HOUR		= STRMID(tmp,11,2)
		MINUTE		= STRMID(tmp,14,2)
		SECOND		= STRMID(tmp,17,2)
		NOSAT		= LONG(get(self,'nosat'))
		
		filename 	= ''
		http 		= get (self.general, 'use_local_or_nfs') EQ 'LOCAL_AND_HTTP'
		nfs 		= get (self.general, 'use_local_or_nfs') EQ 'LOCAL_AND_NFS'
		IF val NE '' THEN BEGIN
			code = chercher_dernier_fichier (self.general, http, nfs, '', '', val, $
								NOSAT, YYYYMMDD, YEAR, MONTH, DAY, DOY, HOUR, MINUTE, SECOND, filename)
		END

		code = ouvrir_lecture_ok (filename,fd) ; INDISPENSABLE sinon probleme constate sous Windows s'il y a trop d'images 'UNKNOW'

		IF STRPOS(filename,"*") NE -1 THEN BEGIN
			self -> obj::setproperty,'format','UNKNOW'
		END ELSE IF STRPOS(filename,"?") NE -1 THEN BEGIN
			self -> obj::setproperty,'format','UNKNOW'
		END ELSE IF fichier_existe(filename) EQ 0 THEN BEGIN
			self -> obj::setproperty,'format','UNKNOW'
		END ELSE IF QUERY_JPEG (filename,info) THEN BEGIN
			self -> obj::setproperty,'format','JPEG'
			self -> obj::setproperty,'nbx',info.dimensions[0]
			self -> obj::setproperty,'nby',info.dimensions[1]
		END ELSE IF QUERY_PNG (filename,info) THEN BEGIN
			self -> obj::setproperty,'format','PNG'
			self -> obj::setproperty,'nbx',info.dimensions[0]
			self -> obj::setproperty,'nby',info.dimensions[1]
		END ELSE IF QUERY_BMP (filename,info) THEN BEGIN
			self -> obj::setproperty,'format','BMP'
			self -> obj::setproperty,'nbx',info.dimensions[0]
			self -> obj::setproperty,'nby',info.dimensions[1]
		END ELSE IF QUERY_TIFF (filename,info) THEN BEGIN
			self -> obj::setproperty,'format','TIFF'
			self -> obj::setproperty,'nbx',info.dimensions[0]
			self -> obj::setproperty,'nby',info.dimensions[1]
		END ELSE IF QUERY_GIF (filename,info) THEN BEGIN
			self -> obj::setproperty,'format','GIF'
			self -> obj::setproperty,'nbx',info.dimensions[0]
			self -> obj::setproperty,'nby',info.dimensions[1]
		END ELSE BEGIN
			self -> obj::setproperty,'format','UNKNOW'
		END

		IF code THEN FREE_LUN, fd ; INDISPENSABLE

	END

	IF nom EQ 'palette_cube' OR nom EQ 'filename' THEN BEGIN

		format = get (self,'format')
		CASE format OF
			'JPEG': nbmincolors = 8
			'BMP':	nbmincolors = 2
			'PNG':	nbmincolors = 2
			'TIFF': nbmincolors = 2
			'GIF':	nbmincolors = 2
			ELSE :	nbmincolors = 0
		END
		self -> obj::setproperty, 'nbmincolors', nbmincolors
		nbmaxcolors =  get(self,'nbmaxcolors')
		info = get(self,'palette_nbcolors', /info)
		info[3] = nbmincolors
		info[4] = nbmaxcolors
		self -> obj::setproperty, 'palette_nbcolors', info, /info

	END

END

;-------------------------------------------------------------------------------
FUNCTION image::check
;-------------------------------------------------------------------------------
; Retourne un message s'il y a une erreur lors de la saisie.
;-------------------------------------------------------------------------------

	RETURN, self -> obj::check()

END

;-------------------------------------------------------------------------------
PRO image::compute
;-------------------------------------------------------------------------------
; Traitement effectué pour afficher un objet de type 'image'.
;-------------------------------------------------------------------------------

	fenetre = self.fenetre
	general = self.general

	hash = self -> gethash()
	hash_general = general -> gethash()

	ntrace = getq (general, hash_general.ntrace)
	IF ntrace GE 1 THEN BEGIN
		msg = self -> name()
		str = STRING(msg, FORMAT='(A)')
		cl_msg, general, str_bas=" "
		cl_msg, general, str_bas=str
	END

	filename      = getq(self,hash.filename)
	nbcolors      = getq(self,hash.palette_nbcolors)
	cube          = getq(self,hash.palette_cube)
	rotation      = getq(self,hash.rotation)
	constraint    = getq(self,hash.constraint)
	constraintw   = getq(self,hash.constraintw)
	format        = getq(self,hash.format)
	nbx           = getq(self,hash.nbx)
	nby           = getq(self,hash.nby)

	xsize         = getq(general,hash_general.xsize)
	ysize         = getq(general,hash_general.ysize)

	x1            = getq(self,hash.x1)
	x2            = getq(self,hash.x2)
	y1            = getq(self,hash.y1)
	y2            = getq(self,hash.y2)
	interp        = getq(self,hash.interp)


	time_t1		= str_to_date(getq(self,hash.time_t1))
	tmp		= date_to_str(time_t1, format=3)
	YYYYMMDD	= STRMID(tmp,0,4)+STRMID(tmp,5,2)+STRMID(tmp,8,2)
	YEAR		= STRMID(YYYYMMDD,0,4)
	MONTH		= STRMID(YYYYMMDD,4,2)
	DAY		= STRMID(YYYYMMDD,6,2)
	DOY		= int_str_0(year_month_day_to_doy(YEAR,MONTH,DAY),3)
	HOUR		= STRMID(tmp,11,2)
	MINUTE		= STRMID(tmp,14,2)
	SECOND		= STRMID(tmp,17,2)
	NOSAT		= LONG(getq(self,hash.nosat))
	http 		= get (general, 'use_local_or_nfs') EQ 'LOCAL_AND_HTTP'
	nfs 		= get (general, 'use_local_or_nfs') EQ 'LOCAL_AND_NFS'
	IF filename NE '' THEN BEGIN
		code = chercher_dernier_fichier (self.general, http, nfs, '', '', filename, $
				NOSAT, YYYYMMDD, YEAR, MONTH, DAY, DOY, HOUR, MINUTE, SECOND, filename1)
		filename = filename1
	END

	cl_msg, general, str_bas=filename+' ...'

	ok = fichier_existe (filename)

	IF ~ok THEN BEGIN ; impossible d'ouvrir le fichier
		IF filename NE '' THEN fenetre -> ajouter_image, -2, 0, 1, 0, 1
		RETURN
	END

	CASE format OF
		'JPEG':		ok = 1
		'BMP':		ok = 1
		'PNG':		ok = 1
		'TIFF':		ok = 1
		'GIF':		ok = 1
		'UNKNOW':	ok = 0
	END

	IF ~ok THEN BEGIN ; format incorrect
		fenetre -> ajouter_image, -3, 0, 1, 0, 1
		RETURN
	END

	IF rotation EQ '90' OR rotation EQ '270' THEN BEGIN
		;tmp = nbx & nbx = nby & nby = tmp
	END

	true = 0

	IF format EQ 'JPEG' THEN BEGIN

		IF cube EQ 'True color' THEN BEGIN
			READ_JPEG, filename, image, /TRUE
			true = 1
		END ELSE IF cube EQ 'No' THEN BEGIN 
			READ_JPEG, filename, image, rvb, colors=nbcolors, /two_pass_quantize
			r = rvb[*,0] & v = rvb[*,1] & b = rvb[*,2]
		END ELSE BEGIN
			; Couleurs approximees
			READ_JPEG, filename, image, /TRUE
			cl_msg, general, str_bas='COLOR_QUAN ...'
			nbcube = (STRSPLIT(cube, /EXTRACT))[0]^(1./3)
			image = COLOR_QUAN (image,1, r,v,b, cube=nbcube)
		END

	END ELSE BEGIN

		IF format EQ 'BMP' THEN BEGIN 
			image = READ_BMP (filename, r, v, b)
		END ELSE IF format EQ 'PNG' THEN BEGIN 
			image = READ_PNG (filename, r, v, b)
		END ELSE IF format EQ 'TIFF' THEN BEGIN 
			image = READ_TIFF (filename, r, v, b)
		END ELSE IF format EQ 'GIF' THEN BEGIN 
			READ_GIF, filename, image, r, v, b
			IF is_gdl() THEN BEGIN
				; ex: /home/penou/DATA/CLUSTER/SOFT/CLL3/resource/superdarn_anim_gif.cl.gz
				; ex: /home/penou/DATA/CLUSTER/SOFT/CLL3/resource/superdarn_gif.cl.gz
				; sinon l'image est inversée
				image = REVERSE (image, 2)
			END
		END
		info = SIZE(image)
		true = info[0] EQ 3
		IF cube NE 'True color' THEN BEGIN
			;cl_msg, general, str_bas='COLOR_QUAN ...'
			IF cube EQ 'No' THEN BEGIN ; entre 2 et 256 couleurs
				IF true THEN BEGIN ; image true color
					IF is_gdl() THEN BEGIN
						couleurs = image[0,*,*] + 256L*image[1,*,*] + 256L*256L*image[2,*,*]
						couleurs = REFORM (couleurs)
						ind_uniq = UNIQ (couleurs, SORT(couleurs))
						couleurs_uniq = couleurs[ind_uniq]
						image = REPLICATE (0b, nbx, nby)
						r = REPLICATE (0b, nbcolors)
						v = REPLICATE (0b, nbcolors)
						b = REPLICATE (0b, nbcolors)
						FOR i=0L,N_ELEMENTS(ind_uniq)-1 DO BEGIN
							IF i EQ nbcolors THEN BREAK ; sinon ca va planter
							ind = WHERE (couleurs EQ couleurs_uniq[i])
							image[ind] = i
							r[i] = couleurs_uniq[i] AND 255
							v[i] = couleurs_uniq[i]/(256L) AND 255
							b[i] = couleurs_uniq[i]/(256L*256L) AND 255
						END
					END ELSE BEGIN
						image = COLOR_QUAN (REFORM(image[0,*,*],nbx,nby),REFORM(image[1,*,*],nbx,nby),REFORM(image[2,*,*],nbx,nby), r,v,b, colors=nbcolors) 
					END
				END ELSE BEGIN
					IF is_gdl() THEN BEGIN
						IF N_ELEMENTS(r) GE nbcolors THEN BEGIN
							; sinon ca va planter
							r = r[LINDGEN(nbcolors)]
							v = v[LINDGEN(nbcolors)]
							b = b[LINDGEN(nbcolors)]
						END
						r_old = r
						v_old = v
						b_old = b
						r = REPLICATE (0b, nbcolors)
						v = REPLICATE (0b, nbcolors)
						b = REPLICATE (0b, nbcolors)
						r[LINDGEN(N_ELEMENTS(r_old))] = r_old
						v[LINDGEN(N_ELEMENTS(r_old))] = v_old
						b[LINDGEN(N_ELEMENTS(r_old))] = b_old
					END ELSE BEGIN
						image = COLOR_QUAN (r[image],v[image],b[image], r,v,b, colors=nbcolors) 
					END
				END
				true = 0
			END ELSE BEGIN
				nbcube = (STRSPLIT(cube, /EXTRACT))[0]^(1./3)
				IF true THEN BEGIN ; image true color
					image = COLOR_QUAN (REFORM(image[0,*,*],nbx,nby),REFORM(image[1,*,*],nbx,nby),REFORM(image[2,*,*],nbx,nby), r,v,b, cube=nbcube) 
				END ELSE BEGIN
					image = COLOR_QUAN (r[image],v[image],b[image], r,v,b, cube=nbcube)
				END
				true = 0
			END
			; Correction bug dans COLOR_QUAN:
			; certaines valeurs de r,v,b sont aléatoires et plusieurs instances de cl ne donneront pas les mêmes résultats
			; Mais on dirait que les png restent les mêmes
			;max_image = MAX(image)
			;IF max_image LT nbcolors-1 THEN BEGIN
			;	r[max_image+1:*] = 0
			;	v[max_image+1:*] = 0
			;	b[max_image+1:*] = 0
			;END
		END
	END

	ind = ['0','90','180','270'] & rot = (WHERE (ind EQ rotation))[0]
	IF rot NE 0 THEN BEGIN
		IF ~true THEN BEGIN
			image = ROTATE (image, rot)
		END ELSE BEGIN
			nbx = N_ELEMENTS(image[0,*,0])
			nby = N_ELEMENTS(image[0,0,*])
			image1 = rot EQ 1 OR rot EQ 3 ? REPLICATE(0b,3,nby,nbx) : image
			FOR i=0L,2 DO image1[i,*,*] = ROTATE(REFORM(image[i,*,*],nbx,nby),rot)
			image = image1
		END
	END

	IF ~true THEN BEGIN
		rvb = REPLICATE ({ var_pal, r:0, v:0, b:0 },N_ELEMENTS(r))
		rvb.r = r & rvb.v = v & rvb.b = b
		fenetre -> fsetproperty,rvb,/rvb
	END

	IF constraintw NE 'No' AND (libplot_get(/D_NAME) EQ 'X' OR libplot_get(/D_NAME) EQ 'WIN') THEN BEGIN
		gauche = get(self,'gauche')
		droite = get(self,'droite')
		bas    = get(self,'bas')
		haut   = get(self,'haut')
		xsize  = libplot_get(/D_X_VSIZE) * (droite-gauche)
		ysize  = libplot_get(/D_Y_VSIZE) * (haut-bas)
		IF ~true THEN BEGIN
			nbx = N_ELEMENTS(image[*,0])
			nby = N_ELEMENTS(image[0,*])
		END ELSE IF true THEN BEGIN
			nbx = N_ELEMENTS(image[0,*,0])
			nby = N_ELEMENTS(image[0,0,*])
		END
		code = get_nbx1_nby1 (constraint,nbx,nby,xsize,ysize,nbx1,nby1)
		IF code EQ 0 THEN BEGIN
			dx = FLOAT(nbx1)/FLOAT(libplot_get(/D_X_VSIZE))
			dy = FLOAT(nby1)/FLOAT(libplot_get(/D_Y_VSIZE))
			IF droite-gauche GE dx AND haut-bas GE dy THEN BEGIN
				gauche1	= gauche
				droite1	= droite
				bas1	= bas
				haut1	= haut
				IF constraintw EQ 'Bottom left' THEN BEGIN
					droite1 = gauche + dx
					haut1 = bas + dy
				END ELSE IF constraintw EQ 'Bottom right' THEN BEGIN
					gauche1 = droite - dx
					haut1 = bas + dy
				END ELSE IF constraintw EQ 'Top left' THEN BEGIN
					droite1 = gauche + dx
					bas1 = haut - dy
				END ELSE IF constraintw EQ 'Top right' THEN BEGIN
					gauche1 = droite - dx
					bas1 = haut - dy
				END ELSE IF constraintw EQ 'Center' THEN BEGIN
					gauche1 = (gauche+droite)/2 - dx/2
					droite1 = (gauche+droite)/2 + dx/2
					bas1 = (bas+haut)/2 - dy/2
					haut1 = (bas+haut)/2 + dy/2
				END
				set, self, 'gauche', gauche1, /passaveold
				set, self, 'droite', droite1, /passaveold
				set, self, 'bas', bas1, /passaveold
				set, self, 'haut', haut1, /passaveold
			END
		END
	END


	IF x1 EQ -1 THEN x1 = 0
	IF x2 EQ -1 THEN x2 = N_ELEMENTS(true ? image[0,*,0] : image[*,0])-1
	IF y1 EQ -1 THEN y1 = 0
	IF y2 EQ -1 THEN y2 = N_ELEMENTS(true ? image[0,0,*] : image[0,*])-1

	IF true THEN BEGIN
		image = image[*,x1:x2,y1:y2]
	END ELSE BEGIN
		image = image[x1:x2,y1:y2]
	END

	fenetre -> ajouter_image, image, 0, 1, 0, 1, TRUE=true, CONSTRAINT=constraint, INTERP=interp

END

;-------------------------------------------------------------------------------
PRO image::voirandremove_lastimage, $
;-------------------------------------------------------------------------------
	novoir=novoir	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche l'image puis la supprime en mémoire.
;-------------------------------------------------------------------------------

	fenetre = self.fenetre
	fenetre -> voirandremove_lastimage, novoir=novoir

END

;-------------------------------------------------------------------------------
FUNCTION image::init,	$
;-------------------------------------------------------------------------------
	no,		$	; LINT_PROTOTYPE input
	container,	$	; LINT_PROTOTYPE input
	order,		$	; LINT_PROTOTYPE input
	general			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Constructeur de ma classe "image".
;-------------------------------------------------------------------------------

	nosat_list = get_nosat_list()
	nosat_list = val_to_str(INDGEN(N_ELEMENTS(nosat_list))+1)

	param = [ $
		{ var_obj, '', 				'format', 	0, PTR_NEW(), 												'', 			PTR_NEW(), PTR_NEW ('')				},	$
		{ var_obj, '', 				'nbx', 		0, PTR_NEW(), 												'', 			PTR_NEW(), PTR_NEW (0)				},	$
		{ var_obj, '', 				'nby', 		0, PTR_NEW(), 												'', 			PTR_NEW(), PTR_NEW (0)				},	$
		{ var_obj, 'Time:Start', 		'time_t1', 	2, PTR_NEW(['TE','0','23']), 										'check_strdate', 	PTR_NEW(), PTR_NEW ('29 06 1999 14 30 00.000')	},	$
		{ var_obj, '  End', 			'time_t2', 	2, PTR_NEW(['TE','2','23']), 										'check_strdate', 	PTR_NEW(), PTR_NEW ('29 06 1999 15 30 00.000')	},	$
		{ var_obj, 'Data: Spacecraft',		'nosat',	3, PTR_NEW(['DR','2','LABEL_LEFT',nosat_list]),								'check_always_ok',	PTR_NEW(), PTR_NEW ('1')			},	$
		{ var_obj, 'Filename', 			'filename', 	3, PTR_NEW(['CH','2','60']), 										'check_always_ok', 	PTR_NEW(), PTR_NEW ()				},	$
		{ var_obj, 'Constraint', 		'constraint', 	3, PTR_NEW(['DR','0','LABEL_LEFT','None','Proportion','Original size']),				'check_always_ok', 	PTR_NEW(), PTR_NEW ('Original size')		},	$
		{ var_obj, 'Constraint window',		'constraintw',	3, PTR_NEW(['DR','2','LABEL_LEFT','Bottom left','Bottom right','Top left','Top right','Center','No']),	'check_always_ok', 	PTR_NEW(), PTR_NEW ('No')			},	$
		{ var_obj, 'Rotation (deg)', 		'rotation', 	3, PTR_NEW(['DR','2','LABEL_LEFT','0','90','180','270']), 						'check_always_ok', 	PTR_NEW(), PTR_NEW ('0')			},	$
		{ var_obj, '            Y2', 		'y2', 		3, PTR_NEW(['IN','2','4']), 										'check_always_ok', 	PTR_NEW(), PTR_NEW (-1)				},	$
		{ var_obj, 'X1', 			'x1', 		3, PTR_NEW(['IN','0','4']), 										'check_always_ok', 	PTR_NEW(), PTR_NEW (-1)				},	$
		{ var_obj, '               X2', 	'x2', 		3, PTR_NEW(['IN','0','4']), 										'check_always_ok', 	PTR_NEW(), PTR_NEW (-1)				},	$
		{ var_obj, '       Interpolation',	'interp', 	3, PTR_NEW(['DR','2','LABEL_LEFT','None','congrid']), 							'check_always_ok', 	PTR_NEW(), PTR_NEW ('congrid')			},	$
		{ var_obj, '            Y1', 		'y1', 		3, PTR_NEW(['IN','2','4']), 										'check_always_ok', 	PTR_NEW(), PTR_NEW (-1)				}	$
	]

	code = self -> obj::init (no, container, order, param, general=general,$
			/saisissable,graphique=1,palette=4,/shortpalette)

	set, self, 'nbmaxcolors', 256
	set, self, 'palette_cube', 'No'
	set, self, 'filename','image1.jpg'
	set, self, 'noparam', 2

	RETURN, code

END

;-------------------------------------------------------------------------------
PRO image__define
;-------------------------------------------------------------------------------
; La classe "image" hérite de obj.
;-------------------------------------------------------------------------------

	lint_unused = { image, 	$

		INHERITS obj 	$

	}

END
