;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: global__define.pro,v $, v $Revision: 1.17 $
;
;	Date	: $Date: 2014/03/12 17:08:35 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
FUNCTION global::vglobal
;-------------------------------------------------------------------------------
; Retourne la liste des variables globales, ou 'null' s'il n'y en a pas.
;-------------------------------------------------------------------------------

	vglobal = get (self, 'choice')
	FOR i=0L,N_ELEMENTS(vglobal)-1 DO BEGIN
		tmp = STRSPLIT (vglobal[i], /EXTRACT)
		vglobal[i] = tmp[N_ELEMENTS(tmp)-1] ; dernier lment
	END

	RETURN, vglobal

END

;-------------------------------------------------------------------------------
PRO global::setproperty,	$
;-------------------------------------------------------------------------------
	nom,			$	; LINT_PROTOTYPE input
	val,			$	; LINT_PROTOTYPE input
	passaveold=passaveold		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affecte une valeur  une variable.
;------------------------------------------------------------------------------- 

	IF nom EQ 'choice' THEN BEGIN

		liste = (get (self,'choice', /info))[4:*]
		FOR i=0L,N_ELEMENTS(liste)-1 DO BEGIN
			tmp = STRSPLIT(liste[i],/EXTRACT)
			liste[i] = tmp[N_ELEMENTS(tmp)-1] ; dernier lment
		END

		lastval = REPLICATE ('',N_ELEMENTS(val))
		FOR i=0L,N_ELEMENTS(val)-1 DO BEGIN
			tmp = STRSPLIT(val[i],/EXTRACT)
			lastval[i] = tmp[N_ELEMENTS(tmp)-1] ; dernier lment
		END

		FOR i=0L,N_ELEMENTS(liste)-1 DO BEGIN
			no = self -> obj::getproperty (liste[i], /no)
			decompose_no, no, no_reel, cfils, cpere, cinvisible
			ind = WHERE(lastval EQ liste[i])
			cfils = ind[0] EQ -1 ; on containt les variables non slectionnes
			no = recompose_no (no_reel, cfils, cpere, cinvisible)
			self -> obj::setproperty, liste[i], no, /no
		END

	END

	self -> obj::setproperty, nom, val, passaveold=passaveold

END


;-------------------------------------------------------------------------------
FUNCTION global::check
;-------------------------------------------------------------------------------
; Vrification des variables.
;------------------------------------------------------------------------------- 

	ret = self -> obj::check_t1_t2('time_t1','time_t2')
	IF ret NE '' THEN RETURN, ret

	RETURN, ''

END

;-------------------------------------------------------------------------------
FUNCTION global::init,	$
;-------------------------------------------------------------------------------
	general=general	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Constructeur de la classe "global".
;------------------------------------------------------------------------------- 

	IF N_ELEMENTS(general) NE 0 THEN self.general = general

	nomin = 1

	param = [ $

		{ var_obj, '', 				'nbmincolors', 		0, 		PTR_NEW(), 												'', 				PTR_NEW(), 	PTR_NEW (4)			}, 	$
		{ var_obj, '', 				'nbmaxcolors', 		0, 		PTR_NEW(), 												'', 				PTR_NEW(), 	PTR_NEW (0)			}, 	$
		{ var_obj, 'Data: Left Winsize',	'yleft_winsize',	3+nomin,	PTR_NEW(['FL','0','12']),										'check_supegal_infegal',	PTR_NEW([0,1]),	PTR_NEW (0.2)			}, 	$
		{ var_obj, 'Right Winsize',		'legend_winsize',	3+nomin,	PTR_NEW(['FL','0','12']),										'check_supegal_infegal',	PTR_NEW([0,1]),	PTR_NEW (0.2)			}, 	$
		{ var_obj, 'Data:Spacecraft',		'nosat',		3+nomin,	PTR_NEW(['DR','2','LABEL_LEFT','1','2','3','4','5']),							'check_always_ok',		PTR_NEW(),	PTR_NEW ('1')			}, 	$
		{ var_obj, 'Cjf', 			'cjf', 			3+nomin, 	PTR_NEW(['DR','2','LABEL_LEFT','count','count/spin','count/s','c/s','flux','fdist','JE']),		'check_always_ok', 		PTR_NEW(), 	PTR_NEW ('c/s')			}, 	$
		{ var_obj, 'Interpolation', 		'interp', 		3+nomin, 	PTR_NEW(['DR','0','LABEL_LEFT','None','Y','XY']), 							'check_always_ok', 		PTR_NEW(), 	PTR_NEW ('None')		}, 	$
		{ var_obj, 'Average', 			'moyenner', 		3+nomin, 	PTR_NEW(['DR','2','LABEL_LEFT','No','Yes']), 								'check_always_ok', 		PTR_NEW(), 	PTR_NEW ('No')			}, 	$
		{ var_obj, 'Ion', 			'ion', 			3+nomin, 	PTR_NEW(['DR','0','LABEL_LEFT','H+','He++','He+','O+','He++O+']), 					'check_always_ok', 		PTR_NEW(), 	PTR_NEW ('H+')			}, 	$
		{ var_obj, 'Only one value per spin', 	'spin_average', 	3+nomin, 	PTR_NEW(['DR','2','LABEL_LEFT','Yes','No']), 								'check_always_ok', 		PTR_NEW(), 	PTR_NEW ('Yes')			}, 	$
		{ var_obj, 'Constraint', 		'constraint', 		3+nomin, 	PTR_NEW(['DR','0','LABEL_LEFT','None','Proportion','Original size']), 					'check_always_ok', 		PTR_NEW(), 	PTR_NEW ('Original size')	}, 	$
		{ var_obj, 'Constraint window', 	'constraintw', 		3+nomin, 	PTR_NEW(['DR','2','LABEL_LEFT','Bottom left','Bottom right','Top left','Top right','Center','No']),	'check_always_ok', 		PTR_NEW(), 	PTR_NEW ('No')			}, 	$
		{ var_obj, 'Rotation (deg)', 		'rotation', 		3+nomin, 	PTR_NEW(['DR','2','LABEL_LEFT','0','90','180','270']), 							'check_always_ok', 		PTR_NEW(), 	PTR_NEW ('0')			}	]

	code = self -> obj::init (1, -1, -1, param,								$
				/saisissable, 									$
				time=nomin, x=1+nomin, left=2+nomin, right=4+nomin, legend_courbe=5+nomin, 	$
				spectro_right=6+nomin, palette=7+nomin,						$
				titre=9+nomin,									$
				orbito=10+nomin,orbtxt=['!3XGSE','!3YGSE','!3ZGSE','!3DIST'])

	self -> obj::setproperty, 'nbmincolors', 2
	set, self, 'nbmaxcolors', 256
	nbmaxcolors =  get(self,'nbmaxcolors')
	info = get(self,'palette_nbcolors', /info)
	info[3] = 2
	info[4] = nbmaxcolors
	self -> obj::setproperty, 'palette_nbcolors', info, /info

	ind = WHERE ((*self.param).no GE nomin AND (*self.param).no LE 10+nomin)
	IF ind[0] NE -1 THEN BEGIN 
		nom = (*self.param)[ind].nom
		texte = (*self.param)[ind].texte
		titre = nom
		FOR i=0L,N_ELEMENTS(texte)-1 DO BEGIN
			tmp = STRSPLIT(texte[i], ':', /EXTRACT)
			IF N_ELEMENTS(tmp) NE 1 THEN BEGIN
				titre[i] = tmp[0]
				texte[i] = tmp[1]
			END ELSE BEGIN
				titre[i] = titre[i-1]
			END
		END
		val = STRING(STRCOMPRESS(titre),FORMAT='(A20)') + 	$
		      STRING(STRCOMPRESS(texte),FORMAT='(A30)') + 	$
		      STRING(STRCOMPRESS(nom),FORMAT='(A30)')
		param = { var_obj, 'Choice: Choice', 'choice', 11+nomin, PTR_NEW([['L2','2','15','LABEL_LEFT'],val]), 'check_always_ok', PTR_NEW(), PTR_NEW('[null]') }
		self -> obj::add, param
	END

	set, self, 'choice', ''
	self -> obj::setproperty,'choice',['null']

	set, self, 'noparam', 1

	RETURN, code

END

;-------------------------------------------------------------------------------
PRO global__define
;-------------------------------------------------------------------------------
; La classe "global" hrite de "obj".
;------------------------------------------------------------------------------- 

	lint_unused = { global, 	$

		INHERITS obj 		$

	}

END
