;-------------------------------------------------------------------------------
FUNCTION get_pitch90_swea,	$
;-------------------------------------------------------------------------------
	year,			$	; LINT_PROTOTYPE input
	month,			$	; LINT_PROTOTYPE input
	day,			$	; LINT_PROTOTYPE input
	sat,			$	; LINT_PROTOTYPE input
	cjf,			$	; LINT_PROTOTYPE input
	spacecraft_potential,	$	; LINT_PROTOTYPE input
	bulk_speed,		$	; LINT_PROTOTYPE input
	res				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Exemple d'appel de get_data3d pour obtenir les donnes time_pitchangle de STEREO-SWEA
;-------------------------------------------------------------------------------
;	Input:
;	-----
;		year:		
;		month:	1..12
;		day:	1..31
;		sat:	'A' or 'B'
;		cjf:	
;			0 for 'count'			don't use efficencies
;			1 for 'count/spin'		don't use efficiencies
;			2 for 'count/s'			don't uses efficencies
;			3 for 'c/s'			use efficencies
;			4 for 'flux'			use efficencies and geometrical factor
;			5 for 'fdist'			use efficencies and geometrical factor
;			6 for 'JE'			use efficencies and geometrical factor
;		spacecraft_potential:			-1e31 or value
;		bulk_speed:				-1e31 or [Vx,Vy,Vz]
;		
;
;	Output:
;	------
;		array of structure res with the following fields:
;			- no: record number (first is 0)
;			- a: anode (0..15)
;			- d: deflection (0..5)
;			- e: energy (0..15)
;			- alphamin: pitch angle mini in deg
;			- alphamoy: pitch angle central in deg
;			- alphamax: pitch angle maxi in deg
;			- cjf: count, count/spin, count/s, c/s, flux, fdist or JE
;			- rawcount: raw count
;
;	Return code:
;	-----------
;		0	OK
;		-1	No data
;-------------------------------------------------------------------------------
	COMMON COMMON_CL, general

	p 		= get (general, 'p')

	produit		= p[1,4,sat EQ 'A' ? 1 : 2] ; dist
	date1		= val_to_str(day)+' '+val_to_str(month)+' '+val_to_str(year)
	date2 		= date1 + ' 23 59 59.999'
	eminreel	= -1L
	emaxreel	= -1L
	theta		= ['All']
	phi		= ['All']
	emin		= 0.0
	emax		= 1.0e6
	imasse		= 0

	lint_unused = produit -> get_data3d(type='time_pitchangle',theta,phi,[emin,emax],imasse, 							$
					str_to_date(date1), str_to_date(date2), /exact1, /exact2, cjf, /spin_average, 					$
					999, '', '', compress='All', 											$
					Xmin_data,xmin_next,Xmoy_data,Xmax_data,									$
					Ymin_data,Ymoy_data,Ymax_data,indY,Zdata,produit1,Bresolution='MAG',eminreel=eminreel,emaxreel=emaxreel,	$
					pad_thetaB=0, nbalphas=18, 											$
					spacecraft_potential=spacecraft_potential, 									$
					bulk_speed=bulk_speed, 												$
					pitch_use_val=90, 												$
					pitch_use_no=pitch_use_no, 											$
					pitch_use_cellule=pitch_use_cellule, 										$
					pitch_use_spectre=pitch_use_spectre, 										$
					pitch_use_energy=pitch_use_energy, 										$
					pitch_use_alphamin=pitch_use_alphamin, 										$
					pitch_use_alphamoy=pitch_use_alphamoy, 										$
					pitch_use_alphamax=pitch_use_alphamax, 										$
					pitch_use_cjf=pitch_use_cjf,											$
					pitch_use_rawcount=pitch_use_rawcount)

	IF N_ELEMENTS(pitch_use_cellule) EQ 0 THEN RETURN, -1	; pas de donnes

	ind = WHERE (pitch_use_cellule NE 255, nb)

	IF nb EQ 0 THEN RETURN, -1	; pas de cellules  90 deg

	s = { no: 0L, a: 0b, d:0b, e: 0b, alphamin: 0.0, alphamoy:0.0, alphamax: 0.0, cjf: 0.0, rawcount: 0.0 }
	res = REPLICATE (s, nb)

	res.no		= pitch_use_no[ind]
	res.a		= pitch_use_cellule[ind]
	res.d		= pitch_use_spectre[ind]
	res.e		= pitch_use_energy[ind]
	res.alphamin	= pitch_use_alphamin[ind]
	res.alphamoy	= pitch_use_alphamoy[ind]
	res.alphamax	= pitch_use_alphamax[ind]
	res.cjf		= pitch_use_cjf[ind]
	res.rawcount	= pitch_use_rawcount[ind]

	RETURN, 0

END
