;-------------------------------------------------------------------------------
FUNCTION get_moments_swea,	$
;-------------------------------------------------------------------------------
	sat,			$	; LINT_PROTOTYPE input
	spacecraft_potential,	$	; LINT_PROTOTYPE input
	moments_rawcount,	$	; LINT_PROTOTYPE input
	moments_date,		$	; LINT_PROTOTYPE input
	res				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Exemple d'appel de get_data3d pour calculer les moments de STEREO-SWEA
;-------------------------------------------------------------------------------
;	Input:
;	-----
;		sat: 'A' or 'B'
;		moments_rawcount: FLOAT array[16 energies, 80 angles, nb record]
;		moments_date: DOUBLE array[nb record]
;		
;
;	Output:
;	------
;		res: array of structure with the following fields:
;			- N_cm3: density
;			- ...
;
;	Return code:
;	-----------
;		0	OK
;		-1	PB
;-------------------------------------------------------------------------------

	COMMON COMMON_CL, general

	p		= get (general, 'p')
	produit		= p[9,nomcis_string_to_val('STEREO_SWEA'),sat EQ 'A' ? 1 : 2] ; DIST

	date1		= moments_date[0]
	date2		= moments_date[N_ELEMENTS(moments_date)-1]

	theta_		=	['All']
	phi_		=	['All']
	emin_		=	0.0
	emax_		=	1.0e6
	imasse		=	0
	cjf		=	0
	valE_		=	0.0
	Bresolution	=	'MAG'

	code = produit -> get_data3d(type='moments',theta_,phi_,'',imasse, 			$
				date1, date2, /exact1, /exact2, cjf,spin_average=0L,		$
				999, '', '', compress='All',					$
				energymin=emin_,energymax=emax_,valE=valE_,			$
				Bresolution=Bresolution,					$
				Xmin_data,xmin_next,Xmoy_data,Xmax_data,			$
				Ymin_data,Ymoy_data,Ymax_data,indY,res,produits1,		$
				spacecraft_potential=spacecraft_potential,			$
				moments_rawcount=moments_rawcount, moments_date=moments_date)

	RETURN, code

END
