;-------------------------------------------------------------------------------
PRO ecrire,	$
;-------------------------------------------------------------------------------
	tabs, 	$	; LINT_PROTOTYPE input
	fichier		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ecrit les donnes de tabs dans le fichier XML fichier.
;-------------------------------------------------------------------------------

	OPENW, fd, fichier, /GET_LUN

	PRINTF, fd, '<?xml version="1.0" encoding="UTF-8"?>'
	PRINTF, fd, '<conf>'

	FOR i=0L,N_ELEMENTS(tabs)-1 DO BEGIN
		IF tabs[i] NE '' THEN PRINTF, fd, tabs[i]
	END

	PRINTF, fd, '</conf>'

	FREE_LUN, fd

END


;-------------------------------------------------------------------------------
PRO get_cldataset_starttime_endtime
;-------------------------------------------------------------------------------
; Cre le fichier '/home/penou/DATA/CLUSTER/SOFT/CLL3/resource/xml/cldataset_starttime_endtime.xml'
;-------------------------------------------------------------------------------

	COMMON COMMON_CL, general

	nom_xml = '/home/penou/DATA/CLUSTER/SOFT/CLL3/resource/xml/cldataset_starttime_endtime.xml'

	tabs = REPLICATE ('',10000)
	no = 0L

	p = get(general,'p')

	nbproduits = N_ELEMENTS(p[*,0,0])
	nbcis = N_ELEMENTS(p[0,*,0])

	FOR nocis=0L,nbcis-1 DO BEGIN
		nomcis = nocis_val_to_string(nocis)
		IF nomcis EQ 'PLUGIN_CAA' THEN CONTINUE
		IF nomcis EQ 'PLUGIN_CSA' THEN CONTINUE
		create_products, nocis_val_to_string(nocis)
		p = get(general,'p')
		exp_obj = get (general, objname(nocis=nocis))
		IF OBJ_VALID(exp_obj) EQ 0 THEN CONTINUE
		nbsatreel = exp_obj -> exp_all_033_get_nbsat()
		FOR nosat=1L,nbsatreel DO BEGIN
			FOR noproduit=0L,nbproduits-1 DO BEGIN
				produit = p[noproduit,nocis,nosat]
				IF OBJ_VALID(produit) EQ 0 THEN CONTINUE
				starttime_endtime = produit -> get_starttime_endtime()
				nom = nomcis+'_P'+val_to_str(noproduit)+'_SC'+val_to_str(nosat)
				s = '<'+nom+'>'+starttime_endtime + '</'+nom+'>'
				tabs[no++] = s
				PRINT, date_to_str(get_date()) + ' ' + s
				ecrire, tabs, nom_xml+'.tmp'
			END
		END
	END

	lint_unused = renommer (nom_xml+'.tmp', nom_xml)

END
