;-------------------------------------------------------------------------------
PRO ecrire_arbre_cl,	$
;-------------------------------------------------------------------------------
	arbre,	$	; LINT_PROTOTYPE input
	nom		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ecrit les donnes de l'arbre dans le fichier nom dans le rpertoire /DATA/CLUSTER/SOFT/CLL3/resource
;-------------------------------------------------------------------------------

	RESOURCE_PATH = '/home/penou/DATA/CLUSTER/SOFT/CLL3/resource/tree/'

	OPENW, fd, RESOURCE_PATH + nom + '.txt.gztmp', /COMPRESS, /GET_LUN
	nb = N_ELEMENTS(arbre)
	FOR i=0L,nb-1 DO BEGIN
		IF arbre[i] NE '' THEN BEGIN
			s = arbre[i]
			remplacer, s, '	', '' ; supprimer les tabulations qui posent problmes en JSON pour CLWEB
			PRINTF, fd, s
		END
	END

	FREE_LUN, fd

	lint_unused = copier (RESOURCE_PATH + nom + '.txt.gztmp', RESOURCE_PATH + nom + '.txt.gz')
	lint_unused = detruire (RESOURCE_PATH + nom + '.txt.gztmp')

END

;-------------------------------------------------------------------------------
FUNCTION mots_communs,	$
;-------------------------------------------------------------------------------
	liste			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne la liste de mots appartenant  tous les lments de liste.
;-------------------------------------------------------------------------------
; LINT_VARIABLES s

	nb = N_ELEMENTS(liste)
	FOR i=0L,nb-1 DO BEGIN
		IF N_ELEMENTS(s) EQ 0 THEN BEGIN
			s = STRSPLIT(liste[i],/EXTRACT)
		END ELSE BEGIN
			tmp = STRSPLIT(liste[i],/EXTRACT)
			ok = REPLICATE(0,N_ELEMENTS(s))
			FOR j=0L,MIN([N_ELEMENTS(s),N_ELEMENTS(tmp)])-1 DO BEGIN
				; le mot numro j de s est-il le mot numro j de liste[i] ?
				mot_s = s[j]
				mot_liste = tmp[j]
				ok[j] = mot_liste EQ mot_s
			END
			FOR j=0L,N_ELEMENTS(s)-1 DO BEGIN
				IF ok[j] EQ 0 THEN s[j] = ''
			END
			
		END
	
	END

	ind = WHERE(s NE '')
	IF ind[0] NE -1 THEN s = s[ind]
	RETURN, STRJOIN(s,' ')

END

;-------------------------------------------------------------------------------
PRO ajouter_dataset,		$
;-------------------------------------------------------------------------------
	arbre,				$	; LINT_PROTOTYPE input
	s,				$	; LINT_PROTOTYPE input
	nomcis,				$	; LINT_PROTOTYPE input
	noproduit, 			$	; LINT_PROTOTYPE input
	nomsat,				$	; LINT_PROTOTYPE input
	tab,				$	; LINT_PROTOTYPE input
	id,				$	; LINT_PROTOTYPE input
	exp,				$	; LINT_PROTOTYPE input
	moments=moments,		$	; LINT_PROTOTYPE input
	spectro=spectro,		$	; LINT_PROTOTYPE input
	gradpressmom=gradpressmom,	$	; LINT_PROTOTYPE input
	lawohm=lawohm,			$	; LINT_PROTOTYPE input
	notime=notime,			$	; LINT_PROTOTYPE input
	nolibelles=nolibelles			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ajoute dans arbre un dataset correspondant a nomcis,produit,nosat.
;-------------------------------------------------------------------------------

	COMMON COMMON_CL, general

	p = get(general,'p') ; p[noproduit,nocis,nosat]

	nosat = STRMID(nomsat,2)

	IF nomcis_string_to_val(nomcis) EQ -1 THEN BEGIN
		PRINT, 'ERREUR avec '+nomcis
		EXIT
	END

	produit = p[noproduit[0],nomcis_string_to_val(nomcis),nosat]

	IF KEYWORD_SET(gradpressmom) THEN BEGIN
		vars = produit -> pgetproperty(/gradpressmom_nom)
		unites = produit -> pgetproperty(/gradpressmom_unite)
		libelles = produit -> pgetproperty(/gradpressmom_libelle)
		libelles = vars + ': ' + libelles
	END ELSE IF KEYWORD_SET(lawohm) THEN BEGIN
		vars = produit -> pgetproperty(/lawohm_nom)
		unites = produit -> pgetproperty(/lawohm_unite)
		libelles = produit -> pgetproperty(/lawohm_libelle)
		libelles = vars + ': ' + libelles
	END ELSE IF KEYWORD_SET(moments) THEN BEGIN
		vars = produit -> pgetproperty(/moments_nom)
		unites = produit -> pgetproperty(/moments_unite)
		libelles = produit -> pgetproperty(/moments_libelle)
	END ELSE IF KEYWORD_SET(spectro) THEN BEGIN
		vars = ['1d_data']
		size = val_to_str(produit -> pgetproperty(/nbenergies))
	END ELSE BEGIN
		vars = produit -> pgetproperty(/nom)
		unites = produit -> pgetproperty(/unite)
		libelles = KEYWORD_SET(nolibelles) ? vars : produit -> pgetproperty(/libelle)
	END

	nb = N_ELEMENTS(tab)

	IF KEYWORD_SET(notime) THEN BEGIN
		arbre = [ arbre, s]
	END ELSE BEGIN
		arbre = [ arbre, s + ' ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat) ]
	END

	FOR i=0L,nb-1 DO BEGIN

		; tab[i] contient "visibility var comp option"

		tmp = STRSPLIT(tab[i],/EXTRACT)
		IF tmp[2] EQ '#' THEN BEGIN
			components = ''
		END ELSE BEGIN
			components = ' components="'+tmp[2]+'"'
		END

		IF KEYWORD_SET(spectro) THEN BEGIN
			action = STRJOIN(tmp[3:*],' ')
			pos = STRPOS(action,'cjf=')
			cjf = (STRSPLIT(STRMID(action,pos+4), /EXTRACT))[0]
			cjf = cjf_string_to_val(cjf)
			unites = produit -> pgetproperty(/unit123d,cjf=cjf)
			libelles = produit -> pgetproperty(/property,cjf=cjf)
			; PATH DEMETER_ICE
			IF exp EQ 'demeter_ice' THEN BEGIN
				unites = 'uV^2/m^2/Hz'
				libelles = 'Power array'
			END
			; PATH DEMETER_IMSC
			IF exp EQ 'demeter_imsc' THEN BEGIN
				unites = 'nT^2/Hz'
				libelles = 'Power array'
			END
		END
		champs = STRSPLIT(tmp[1],',',/EXTRACT)
		nochamps = REPLICATE(-1,N_ELEMENTS(champs))
		nochamps_communs = REPLICATE(-1,N_ELEMENTS(champs))
		FOR j=0L,N_ELEMENTS(champs)-1 DO BEGIN
			IF KEYWORD_SET(spectro) THEN BEGIN
				nochamps[j] = val_to_str(cjf)
			END ELSE BEGIN
				IF STRMID(champs[j],0,1) EQ '*' THEN BEGIN
					champ = STRMID(champs[j],1)
				END ELSE BEGIN
					champ = champs[j]
				END
				nochamps[j] = (WHERE (vars EQ champ))[0]
			END
			IF nochamps[j] EQ -1 THEN BEGIN
				PRINT, champ+' introuvable dans ' + STRJOIN(vars,',')
				EXIT
			END
			IF STRMID(champs[j],0,1) NE '*' THEN nochamps_communs[j] = nochamps[j]
		END
		nochamps_communs = nochamps_communs[WHERE(nochamps_communs NE -1)]
		action = nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',')+' SC'+val_to_str(nosat)+' {var} ' + STRJOIN(tmp[3:*],' ')
		arbre1 = '<parameter '+components+' id="'+id+'" units="'+mots_communs(unites[nochamps_communs])+ '" desc="'+mots_communs(unites[nochamps_communs])+'" exp="'+exp+'" novar="'+STRJOIN(val_to_str(nochamps),',')+'" var="'+STRJOIN(vars[nochamps],',')+ '" visibility="'+tmp[0]+'"'
		IF KEYWORD_SET(spectro) THEN BEGIN
			arbre1 += ' display_type="spectrogram" size="'+size+'"'
		END
		arbre1 += '>0 ' + (tmp[3] EQ 'orbito' ? 'orbit panel ' : '')+mots_communs(libelles[nochamps_communs]) + '#' + action
		arbre = [arbre,arbre1]

	END

	arbre = [ arbre, '</dataset>']

END

;-------------------------------------------------------------------------------
PRO ecrire_tree,		$
;-------------------------------------------------------------------------------
	fd_tree,		$	; LINT_PROTOTYPE input
	fd_tree_interne,	$	; LINT_PROTOTYPE input
	quoi,			$	; LINT_PROTOTYPE input
	info				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ecrit une ligne dans "clweb_tree.xml" et "clweb_tree_internal.xml".
;-------------------------------------------------------------------------------

	COMMON COMMON_ID, list_id

	IF N_ELEMENTS(list_id) EQ 0 THEN BEGIN
		list_id = REPLICATE ('',10000)
	END

	CASE quoi OF
		'mission':	BEGIN
					PRINTF, fd_tree,         '    <mission name="'+htmlspecialchars_encode(info.name)+'" xml:id="'+htmlspecialchars_encode(info.id)+'" desc="'+htmlspecialchars_encode(info.desc)+'" target="'+htmlspecialchars_encode(info.target)+'" targets="'+htmlspecialchars_encode(info.targets)+'">'
					PRINTF, fd_tree_interne, '    <mission name="'+htmlspecialchars_encode(info.name)+'" xml:id="'+htmlspecialchars_encode(info.id)+'" desc="'+htmlspecialchars_encode(info.desc)+'" target="'+htmlspecialchars_encode(info.target)+'" targets="'+htmlspecialchars_encode(info.targets)+'">'
				END
		'/mission':	BEGIN
					PRINTF, fd_tree,         '    </mission>'
					PRINTF, fd_tree_interne, '    </mission>'
				END
		'observatory':	BEGIN
					PRINTF, fd_tree,         '    <observatory name="'+htmlspecialchars_encode(info.name)+'" xml:id="'+htmlspecialchars_encode(info.id)+'" desc="'+htmlspecialchars_encode(info.desc)+'">'
					PRINTF, fd_tree_interne, '    <observatory name="'+htmlspecialchars_encode(info.name)+'" xml:id="'+htmlspecialchars_encode(info.id)+'" desc="'+htmlspecialchars_encode(info.desc)+'">'
				END
		'/observatory':	BEGIN
					PRINTF, fd_tree,         '    </observatory>'
					PRINTF, fd_tree_interne, '    </observatory>'
				END
		'instrument':	BEGIN
					PRINTF, fd_tree,         '      <instrument name="'+htmlspecialchars_encode(info.name)+'" xml:id="'+htmlspecialchars_encode(info.id)+'" desc="'+htmlspecialchars_encode(info.desc)+'">'
					PRINTF, fd_tree_interne, '      <instrument name="'+htmlspecialchars_encode(info.name)+'" xml:id="'+htmlspecialchars_encode(info.id)+'" desc="'+htmlspecialchars_encode(info.desc)+'">'
				END
		'/instrument':	BEGIN
					PRINTF, fd_tree,         '      </instrument>'
					PRINTF, fd_tree_interne, '      </instrument>'
				END
		'dataset':	BEGIN
					PRINTF, fd_tree,         '        <dataset name="'+htmlspecialchars_encode(info.name)+'" xml:id="'+htmlspecialchars_encode(info.id)+'" dataStart="'+htmlspecialchars_encode(info.datastart)+'" dataStop="'+htmlspecialchars_encode(info.datastop)+'">'
					PRINTF, fd_tree_interne, '        <dataset name="'+htmlspecialchars_encode(info.name)+'" xml:id="'+htmlspecialchars_encode(info.id)+'" dataStart="'+htmlspecialchars_encode(info.datastart)+'" dataStop="'+htmlspecialchars_encode(info.datastop)+'">'
				END
		'/dataset':	BEGIN
					PRINTF, fd_tree,         '        </dataset>'
					PRINTF, fd_tree_interne, '        </dataset>'
				END
		'parameter1':	BEGIN
					no = (WHERE(list_id EQ info.id))[0]
					IF no EQ -1 THEN BEGIN
						tmp1 = '          <parameter name="'+htmlspecialchars_encode(info.name)+'" units="'+htmlspecialchars_encode(info.units)+'" xml:id="'+htmlspecialchars_encode(info.id)+'" var="'+htmlspecialchars_encode(info.var)+'" desc="'+htmlspecialchars_encode(info.desc)+'"'
						IF info.display_type NE '' THEN BEGIN
							tmp1 += ' size="'+info.size+'" display_type="'+info.display_type+'"'
						END
						tmp2 = tmp1 + ' exp="'+htmlspecialchars_encode(info.exp)+'" action="'+htmlspecialchars_encode(info.action)+'"'
						tmp1 += '/>'
						tmp2 += '/>'
						PRINTF, fd_tree,         tmp1
						PRINTF, fd_tree_interne, tmp2
						no = (WHERE(list_id EQ ''))[0]
						list_id[no] = info.id
					END
				END
		'parameter':	BEGIN
					no = (WHERE(list_id EQ info.id))[0]
					IF no EQ -1 THEN BEGIN
						PRINTF, fd_tree,         '          <parameter name="'+htmlspecialchars_encode(info.name)+'" units="'+htmlspecialchars_encode(info.units)+'" xml:id="'+htmlspecialchars_encode(info.id)+'" var="'+htmlspecialchars_encode(info.var)+'" desc="'+htmlspecialchars_encode(info.desc)+'">'
						PRINTF, fd_tree_interne, '          <parameter name="'+htmlspecialchars_encode(info.name)+'" units="'+htmlspecialchars_encode(info.units)+'" xml:id="'+htmlspecialchars_encode(info.id)+'" var="'+htmlspecialchars_encode(info.var)+'" desc="'+htmlspecialchars_encode(info.desc)+'" exp="'+htmlspecialchars_encode(info.exp)+'" action="'+htmlspecialchars_encode(info.action)+'">'
						no = (WHERE(list_id EQ ''))[0]
						list_id[no] = info.id
					END
				END
		'/parameter':	BEGIN
					PRINTF, fd_tree,         '          </parameter>'
					PRINTF, fd_tree_interne, '          </parameter>'
				END
		'component':	BEGIN
					no = (WHERE(list_id EQ info.id))[0]
					IF no EQ -1 THEN BEGIN
						PRINTF, fd_tree,         '            <component name="'+htmlspecialchars_encode(info.name)+'" xml:id="'+htmlspecialchars_encode(info.id)+'" var="'+htmlspecialchars_encode(info.var)+'"/>'
						PRINTF, fd_tree_interne, '            <component name="'+htmlspecialchars_encode(info.name)+'" xml:id="'+htmlspecialchars_encode(info.id)+'" var="'+htmlspecialchars_encode(info.var)+'" action="'+htmlspecialchars_encode(info.action)+'"/>'
						no = (WHERE(list_id EQ ''))[0]
						list_id[no] = info.id
					END
				END
	END
END


;-------------------------------------------------------------------------------
PRO ecrire_index,	$
;-------------------------------------------------------------------------------
	arbre,		$	; LINT_PROTOTYPE input
	fd			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ecrit l'arbre dans le fichier index.
;-------------------------------------------------------------------------------

	nb = 0L
	lignes = REPLICATE ('',2,10000)
	; indice 0: texte
	; indice 1: starttime stoptime

	; ne garder que les branches en sautant les feuilles
	FOR i=0L,N_ELEMENTS(arbre)-1 DO BEGIN
		ligne = STRSPLIT(arbre[i], /EXTRACT)
		IF ligne[0] EQ 0 THEN CONTINUE
		pos1 = STRPOS (arbre[i], '{')
		pos2 = STRPOS (arbre[i], '}')
		IF pos1 EQ -1 AND pos2 EQ -1 THEN BEGIN
			lignes[0,nb] = arbre[i]
		END ELSE BEGIN
			lignes[0,nb] = STRMID (arbre[i],0,pos1-1)
			lignes[1,nb] = STRMID (arbre[i],pos1+1,pos2-pos1-1)
		END
		nb++
	END

	PRINTF, fd, '<TR>'

	PRINTF, fd, '<TD>'
	tmp = STRSPLIT (lignes[0,0], /EXTRACT)
	s = '<b>'
	FOR j=0L,2*(tmp[0]-2)-1 DO s += '&nbsp;'
	s += STRJOIN(tmp[1:*], ' ') + '</b><br>'
	PRINTF, fd, s
	FOR i=1L,nb-1 DO BEGIN
		tmp = STRSPLIT (lignes[0,i], /EXTRACT)
		FOR j=0L,2*(tmp[0]-2)-1 DO PRINTF, fd, '&nbsp;'
		PRINTF, fd, '- '+STRJOIN(tmp[1:*], ' ')+'<br>'
	END
	PRINTF, fd, '</TD>'

	PRINTF, fd, '<TD>'
	PRINTF, fd, '<br>'
	FOR i=1L,nb-1 DO BEGIN
		PRINTF, fd, lignes[1,i] + '<br>'
	END
	PRINTF, fd, '</TD>'

	PRINTF, fd, '</TR>'

END

;-------------------------------------------------------------------------------
PRO ecrire_clweb_tree,		$
;-------------------------------------------------------------------------------
	arbre,			$	; LINT_PROTOTYPE input
	fd_tree,		$	; LINT_PROTOTYPE input
	fd_tree_interne			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ecrit ce qu'il faut dans clweb_tree et retourne l'arbre utile pour cl
;-------------------------------------------------------------------------------

	; supprimer les infos concernants TREE
	nb = N_ELEMENTS(arbre)
	arbre1 = REPLICATE ('', nb)
	no = 0L
	FOR i=0L,nb-1 DO BEGIN
		IF STRMID(arbre[i],0,1) NE '<' THEN BEGIN
			; anciennes dclarations ...
			arbre1[no++] = STRTRIM(arbre[i],2)
		END ELSE BEGIN
			pos2 = STRPOS(arbre[i],'>')
			avant = STRMID(arbre[i],0,pos2+1)
			apres = STRMID(arbre[i],pos2+1)

			info = { name:'', components:'', desc:'', id:'', dataStart:'', dataStop:'', units:'', novar:'', var:'', exp:'', action:'', visibility:'cl,ws', target:'', targets:'', display_type:'', size:'' }
			lint_unused = ligne_to_noeud_variable_valeur (avant, dataxml)
			noeud = dataxml[0].noeud

			FOR j=0L,N_ELEMENTS(dataxml)-1 DO BEGIN
				CASE dataxml[j].variable OF
					'name':		info.name 		= dataxml[j].valeur
					'components':	info.components		= dataxml[j].valeur
					'desc':		info.desc		= dataxml[j].valeur
					'id':		info.id   		= dataxml[j].valeur
					'units':	info.units		= dataxml[j].valeur
					'novar':	info.novar		= dataxml[j].valeur
					'var':		info.var		= dataxml[j].valeur
					'exp':		info.exp		= dataxml[j].valeur
					'visibility':	info.visibility		= dataxml[j].valeur
					'target':	info.target		= dataxml[j].valeur
					'targets':	info.targets		= dataxml[j].valeur
					'display_type':	info.display_type	= dataxml[j].valeur
					'size':		info.size		= dataxml[j].valeur
					'':		j = j ; ne rien faire
					ELSE:		BEGIN
								PRINT,'ERREUR avec ' + dataxml[j].variable + ' dans ('+arbre[i]+')'
								EXIT
							END
					
				END
			END
			IF noeud EQ 'dataset' THEN BEGIN
				IF apres NE '' THEN BEGIN
					info.name = STRMID(apres,2)
					pos = STRPOS (info.name,' {')
					IF pos NE -1 THEN info.name = STRMID(info.name,0,pos)
				END
			END
			IF info.id EQ '' THEN info.id = info.name


			tmp = STRSPLIT(info.visibility,',',/EXTRACT)
			is_ws = (WHERE(tmp EQ 'ws'))[0] NE -1
			is_cl = (WHERE(tmp EQ 'cl'))[0] NE -1


			IF is_cl THEN BEGIN
					
				IF apres NE '' THEN BEGIN
					IF info.components NE '' THEN BEGIN
						w = STRSPLIT (apres, '#', /EXTRACT)
						w = STRTRIM (w,2)
						action = w[1]
						remplacer, action, '{var}', info.var
						texte = w[0]
						arbre1[no++] = texte + ' [' + info.components + ']#' + action
					END ELSE BEGIN
						w = STRSPLIT (apres, '#', /EXTRACT)
						IF N_ELEMENTS(w) EQ 2 THEN BEGIN
							action = w[1]
							remplacer, action, '{var}', info.var
							texte = w[0]
							arbre1[no++] = texte + '#' + action
						END ELSE BEGIN
							arbre1[no++] = STRTRIM(apres,2) ; supprimer blanc dbut et fin
						END
					END
				END

			END

			IF fd_tree LE -1 THEN CONTINUE ; pour VEX


			IF is_ws THEN BEGIN

				CASE noeud OF
					'mission':	BEGIN
								ecrire_tree, fd_tree, fd_tree_interne, noeud, info
							END
					'observatory':	BEGIN
								ecrire_tree, fd_tree, fd_tree_interne, noeud, info
							END
					'instrument':	BEGIN
								ecrire_tree, fd_tree, fd_tree_interne, noeud, info
							END
					'dataset':	BEGIN
								; ex: apres = "4 orbit {05-07-2004 ... 14-03-2011}"

								; on veut le format comme AMDA: YYYY/MM/DD
								info.dataStart = STRMID(apres,STRLEN(apres)-20,4)+'/'+STRMID(apres,STRLEN(apres)-23,2)+'/'+STRMID(apres,STRLEN(apres)-26,2)
								info.dataStop  = STRMID(apres,STRLEN(apres)-5,4)+'/'+STRMID(apres,STRLEN(apres)-8,2)+'/'+STRMID(apres,STRLEN(apres)-11,2)
								ecrire_tree, fd_tree, fd_tree_interne, noeud, info
							END
					'parameter':	BEGIN
								w = STRSPLIT (apres, '#', /EXTRACT)
								x = STRSPLIT (w[0], /EXTRACT)
								action = STRTRIM(w[1],1)
								name = STRJOIN(x[1:*],' ')
								id = info.id
								; il peut y avoir des components
								IF info.components NE '' THEN BEGIN
									components = STRSPLIT(info.components,',',/EXTRACT)
									vars = STRSPLIT(info.var,',',/EXTRACT)
									nbcomponents = N_ELEMENTS(components)
									info.action = action
									info.name = name
									info.id = id + '(' + info.novar + ')'
									tmp = action
									remplacer, tmp, '{var}', info.var
									info.action = tmp
									info.var = STRJOIN(vars,'.') ; patch variables spares par des points
									ecrire_tree, fd_tree, fd_tree_interne, 'parameter', info
									novar = STRSPLIT (info.novar,',',/EXTRACT)
									FOR j=0L,nbcomponents-1 DO BEGIN
										;'<component name="bx"  var="Bx_sc_nT" id="IT_FM3I_MAG(0)">-1 xxx#										INTERBALL-FM3I P0 SC1 Bx_sc_nT header',		$
										info.name = components[j]
										info.var = vars[j]
										info.id = id + '(' + val_to_str(novar[j]) + ')'
										tmp = action
										remplacer, tmp, '{var}', vars[j]
										info.action = tmp
										ecrire_tree, fd_tree, fd_tree_interne, 'component', info
									END
									ecrire_tree, fd_tree, fd_tree_interne, '/parameter', 0
								END ELSE BEGIN
									tmp = action
									remplacer, tmp, '{var}', info.var
									info.action = tmp
									info.name = name
									info.id = id + (info.novar EQ '' ? '' : ('(' + info.novar + ')'))
									ecrire_tree, fd_tree, fd_tree_interne, 'parameter1', info
								END
							END
					'/dataset':	BEGIN
								ecrire_tree, fd_tree, fd_tree_interne, noeud, 0
							END
					'/instrument':	BEGIN
								ecrire_tree, fd_tree, fd_tree_interne, noeud, 0
							END
					'/mission':	BEGIN
								ecrire_tree, fd_tree, fd_tree_interne, noeud, 0
							END
					'/observatory':	BEGIN
								ecrire_tree, fd_tree, fd_tree_interne, noeud, 0
							END
					'/parameter':	BEGIN
								ecrire_tree, fd_tree, fd_tree_interne, noeud, 0
							END
				END

			END

		END

	END

	arbre = arbre1

END

;-------------------------------------------------------------------------------
;FUNCTION get_change2_starttime_endtime,	$
;-------------------------------------------------------------------------------
;	sat,			$	; LINT_PROTOTYPE input
;	exp,			$	; LINT_PROTOTYPE input
;	masque,			$	; LINT_PROTOTYPE input
;	chemin,			$	; LINT_PROTOTYPE input
;	start_annee,		$	; LINT_PROTOTYPE input
;	start_mois,		$	; LINT_PROTOTYPE input
;	start_jour			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne une structure avec le premier et le dernier jour de donnes trouvs dans le chemin.
;-------------------------------------------------------------------------------
;
;	cmd = 'find ' + chemin + ' -type f | sort'
;	SPAWN, cmd, res
;
;	res1 = basename(res[0])
;	res2 = basename(res[N_ELEMENTS(res)-1])
;
;	filename	= masque
;	DD1		= STRMID(res1,start_jour, 2)
;	MM1		= STRMID(res1,start_mois, 2)
;	YYYY1		= STRMID(res1,start_annee,4)
;	DD2		= STRMID(res2,start_jour, 2)
;	MM2		= STRMID(res2,start_mois, 2)
;	YYYY2		= STRMID(res2,start_annee,4)
;
;	txt		= '{' + DD1+'-'+MM1+'-'+YYYY1+' ... '+DD2+'-'+MM2+'-'+YYYY2 + '}'
;
;	; F30.0 pour ne pas perdre de prcision lors du passage en STRING
;	datemin		= val_to_str(LONG64(tu_to_date(YYYY1,MM1,DD1,0,0,0)), FORMAT='(F30.0)')
;	datemax		= val_to_str(LONG64(tu_to_date(YYYY2,MM2,DD2,0,0,0)), FORMAT='(F30.0)')
;
;	para = 'nosat=1 nom_sat='+sat+' nom_experiment='+exp+' time_t1='+DD1+STRING(2b)+MM1+STRING(2b)+YYYY1+' time_t2='+DD1+STRING(2b)+MM1+STRING(2b)+YYYY1+' 24 filename='+filename+' datemin='+datemin+' datemax='+datemax
;
;	RETURN, {	txt:		txt,		$
;			para:		para		}
;
;END

;-------------------------------------------------------------------------------
;FUNCTION get_arbre_change2_cef
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL du satellite Chang'E-2
;-------------------------------------------------------------------------------
;
;	; Ces donnes ne sont pas dans une exprience connue par cl.
;	; Il faut chercher ici les dates dbut et fin pour:
;	; - ORBITA
;	; - SWIDA
;	; - ORBITB
;	; - SWIDB
;
;	info = REPLICATE ({ txt:'', para:'' },4)
;
;	ORBITA = 0
;	ORBITB = 1
;	SWIDA  = 2
;	SWIDB  = 3
;
;	info[ORBITA] = get_change2_starttime_endtime ('CE2', 'SWIDA', '/DATA/CHANGE2/A/ORBIT/$YEAR/$MONTH/ORBITA_$YYYYMMDD_V01.cef.gz', '/DATA/CHANGE2/A/ORBIT', 7, 11, 13)	; ex: ORBITA_20101023_V01.cef.gz
;	info[ORBITB] = get_change2_starttime_endtime ('CE2', 'SWIDB', '/DATA/CHANGE2/B/ORBIT/$YEAR/$MONTH/ORBITB_$YYYYMMDD_V01.cef.gz', '/DATA/CHANGE2/B/ORBIT', 7, 11, 13)	; ex: ORBITB_20101004_V01.cef.gz
;	info[SWIDA]  = get_change2_starttime_endtime ('CE2', 'SWIDA', '/DATA/CHANGE2/A/SWID/$YEAR/$MONTH/SWIDA_$YYYYMMDD_V01.cef.gz',   '/DATA/CHANGE2/A/SWID',  6, 10, 12) 	; ex: SWIDA_20101010_V01.cef.gz
;	info[SWIDB]  = get_change2_starttime_endtime ('CE2', 'SWIDB', '/DATA/CHANGE2/B/SWID/$YEAR/$MONTH/SWIDB_$YYYYMMDD_V01.cef.gz',   '/DATA/CHANGE2/B/SWID',  6, 10, 12)	; ex: SWIDB_20101010_V01.cef.gz
;
;	arbre = ['2 '+"CHANG'E-2",																				$
;		 '3 ephemeris',																					$
;		 '4 orbit and attitude',																			$
;
;		 '5 ORBITA ' + info[ORBITA].txt,																		$
;			'0 Orbit panel 1mn resolution info with X,Y,Z in GSE#ASCII P-1 SC1 Xgse_m,Ygse_m,Zgse_m orbito ' +                                            info[ORBITA].para,	$
;			'0 Xgse_m,Ygse_m,Zgse_m#ASCII P-1 SC1 Xgse_m,Ygse_m,Zgse_m header ' +                                                                         info[ORBITA].para,	$
;
;		 '5 ORBITB ' + info[ORBITB].txt,																		$
;			'0 Orbit panel 1mn resolution info with X,Y,Z in GSE#ASCII P-1 SC1 Xgse_m,Ygse_m,Zgse_m orbito ' +                                            info[ORBITB].para,	$
;			'0 Xgse_m,Ygse_m,Zgse_m#ASCII P-1 SC1 Xgse_m,Ygse_m,Zgse_m header ' +                                                                         info[ORBITB].para,	$
;
;	 	 '3 SWIDA ' + info[SWIDA].txt,																			$
;	 	 '4 Particle spectrogram',																			$
;			'0 Time Energy Count #ASCII P-1 SC1 count count3d type=time_energy cjf=count z_showdir=No z_theta=No z_phi=No z_energy=No ' +                 info[SWIDA].para,		$
;		 '4 Particle plot',																				$
;			'0 Time count#ASCII P-1 SC1 count count2d type=time_cjf cjf=count yleft_typetitle=Wording legend_theta=No legend_phi=No legend_mass=No ' + info[SWIDA].para,	$
;
;		 '3 SWIDB ' + info[SWIDB].txt,																			$
;		 '4 Particle spectrogram',																			$
;			'0 Time Energy Count#ASCII P-1 SC1 count count3d type=time_energy cjf=count z_showdir=No z_theta=No z_phi=No z_energy=No ' +                  info[SWIDB].para,		$
;		 '4 Particle plot',																				$
;			'0 Time count#ASCII P-1 SC1 count count2d type=time_cjf cjf=count yleft_typetitle=Wording legend_theta=No legend_phi=No legend_mass=No ' + info[SWIDB].para	$
;	]
;
;	RETURN, arbre
;
;END


;-------------------------------------------------------------------------------
FUNCTION get_arbre_change2
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL du satellite Chang'E-2
;-------------------------------------------------------------------------------
;
; CHANGE2 n'est pas dans spase !
;

	create_products, 'CHANGE2'

	target  = "Earth" ; E. Penou
	targets = "Earth" ; E. Penou

	arbre = [																$
		'<mission name="CHANGE2" id="CHANGE2" target="'+target+'" targets="'+targets+'">2 CHANGE2',					$
		'<instrument name="ephemeris" id="CHANGE2:ephemeris">3 ephemeris'								]

	; ephemeris A
	tab = [	'cl	Xgse_m,Ygse_m,Zgse_m           x,y,z  orbito',										$
		'cl,ws	Xgse_m,Ygse_m,Zgse_m           x,y,z  header'										]
	ajouter_dataset, arbre, '<dataset id="CHANGE2:EPHEMERIS:ORBIT_A">4 orbit from A', 'CHANGE2', 0, 'SC1', tab, 'CHANGE2_EPHEMERIS_ORBIT_A', 'change2'

	; ephemeris B
	tab = [	'cl	Xgse_m,Ygse_m,Zgse_m           x,y,z  orbito',										$
		'cl,ws	Xgse_m,Ygse_m,Zgse_m           x,y,z  header'										]
	ajouter_dataset, arbre, '<dataset id="CHANGE2:EPHEMERIS:ORBIT_B">4 orbit from B', 'CHANGE2', 1, 'SC1', tab, 'CHANGE2_EPHEMERIS_ORBIT_B', 'change2'

	arbre = [ arbre,	$
		 '3 SWIDA ' + get_cldataset_starttime_endtime('CHANGE2',2,'SC1'),														$
		 '4 Particle spectrogram',																			$
			'0 Time Energy Count #CHANGE2 P2 SC1 count count3d type=time_energy cjf=count z_showdir=No z_theta=No z_phi=No z_energy=No',						$
		 '4 Particle plot',																				$
			'0 Time count#CHANGE2 P2 SC1 count count2d type=time_cjf cjf=count yleft_typetitle=Wording legend_theta=No legend_phi=No legend_mass=No',				$

		 '3 SWIDB ' + get_cldataset_starttime_endtime('CHANGE2',3,'SC1'),														$
		 '4 Particle spectrogram',																			$
			'0 Time Energy Count#CHANGE2 P3 SC1 count count3d type=time_energy cjf=count z_showdir=No z_theta=No z_phi=No z_energy=No',						$
		 '4 Particle plot',																				$
			'0 Time count#CHANGE2 P3 SC1 count count2d type=time_cjf cjf=count yleft_typetitle=Wording legend_theta=No legend_phi=No legend_mass=No'				$
	]

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'</mission>' 																$
	]

	RETURN, arbre

END


;-------------------------------------------------------------------------------
FUNCTION get_arbre_cluster,	$
;-------------------------------------------------------------------------------
	no		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL d'un satellite CLUSTER.
;-------------------------------------------------------------------------------
;
; Trouv dans spase://SMWG/Observatory/Cluster-Rumba
;
; <ObservatoryRegion>Heliosphere.NearEarth</ObservatoryRegion>
; <ObservatoryRegion>Earth.Magnetosheath</ObservatoryRegion>
; <ObservatoryRegion>Earth.Magnetosphere.Main</ObservatoryRegion>
; <ObservatoryRegion>Earth.Magnetosphere.Polar</ObservatoryRegion>
;

	create_products, 'CLUSTER'

	target  =                                           "Earth.Magnetosphere.Main"					; V. genot
	targets = "Heliosphere.NearEarth Earth.Magnetosheath Earth.Magnetosphere.Main Earth.Magnetosphere.Polar"	; Space

	codif = no EQ 1 OR no EQ 3 OR no EQ 4	; donnes CODIF uniquement pour SC1, SC3 et SC4
	hia   = no EQ 1 OR no EQ 3		; donnes HIA   uniquement pour SC1 et SC3

	SC = 'SC'+val_to_str(no)
	NAME1 = 'CLUSTER'+val_to_str(no)
	NAME2 = 'CLUSTER'+val_to_str(no)
	NAME3 = 'C'+val_to_str(no)

	arbre = [															$
		'<mission name="'+NAME2+'" id="'+NAME2+'" target="'+target+'" targets="'+targets+'">3 '+NAME1,				$
		'<instrument name="ephemeris" id="'+NAME2+':ephemeris">4 ephemeris'							]

	; orbit
	tab = [	'cl	Xgse,Ygse,Zgse,Dist		x,y,z,Dist 	orbito',							$
		'cl,ws	Xgse,Ygse,Zgse			x,y,z  		header',							$
		'cl,ws	Dist				#		header'								]
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':EPHEMERIS:ORBIT">5 orbit 1mn resolution', 'CIS-OTH', 1, SC, tab, NAME3+'_EPHEMERIS_ORBIT', 'cluster_oth'

	; orbit detailed
	tab = [	'cl	XGSE,YGSE,ZGSE,R		x,y,z,R 	orbito',							$
		'cl,ws	XGR,YGR,ZGR			x,y,z  		header',							$
		'cl,ws	XGSE,YGSE,ZGSE			x,y,z  		header',							$
		'cl,ws	XGSM,YGSM,ZGSM			x,y,z  		header',							$
		'cl,ws	R				#  		header',							$
		'cl,ws	DPP				#  		header',							$
		'cl,ws	DMP				#  		header',							$
		'cl,ws	DBS				#  		header',							$
		'cl,ws	DZNSH				#  		header',							$
		'cl,ws	DZPSN				#  		header',							$
		'cl,ws	DZPSS				#  		header',							$
		'cl,ws	DSH				#  		header',							$
		'cl,ws	VXGR,VYGR,VZGR,*VGR		Vx,Vy,Vz,|V| 	header',							$
		'cl,ws	BXGSM,BYGSM,BZGSM,*BGSM		Bx,By,Bz,|B| 	header',							$
		'cl,ws	L				#  		header',							$
		'cl,ws	ILAT				#  		header',							$
		'cl,ws	MLTS				#  		header',							$
		'cl,ws	LATGRS				#  		header',							$
		'cl,ws	LONGRS				#  		header',							$
		'cl,ws	MLTC				#  		header',							$
		'cl,ws	LATGRC				#  		header',							$
		'cl,ws	LONGRC				#  		header',							$
		'cl,ws	LATGMC				#  		header',							$
		'cl,ws	LONGMC				#		header'								]
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':EPHEMERIS:ORBIT_DETAILED">5 orbit detailed 1mn resolution', 'CIS-OTH', 7, SC, tab, NAME3+'_EPHEMERIS_ORBIT_DETAILED', 'cluster_oth'

	arbre = [ arbre, 														$
		'5 attitude 30mn resolution ' + get_cldataset_starttime_endtime('CIS-OTH',0,SC),					$
			'0 matrix SR2->GSE#CIS-OTH P0 '+SC+' M00,M01,M02,M10,M11,M12,M20,M21,M22 header'				$
	]

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'<instrument name="FGM" id="'+NAME2+':FGM">4 FGM'											]

	; FGM
	tab = [	'cl,ws	Bx_gse_nT,By_gse_nT,Bz_gse_nT,*B_nT	Bx,By,Bz,|B|  	header',								$
		'cl,ws	Bx_gsm_nT,By_gsm_nT,Bz_gsm_nT,*B_nT	Bx,By,Bz,|B|  	header',								$
		'cl,ws	Half_interval				#		header',								$
		'cl,ws	Status1					#		header',								$
		'cl,ws	Status2					#		header',								$
		'cl,ws	Status3					#		header',								$
		'cl,ws	Status4					#		header',								$
		'cl,ws	B_nsigma_t				#		header',								$
		'cl,ws	B_nsigma_b				#		header'									]
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':FGM:4SEC">5 4sec resolution', 'CIS-OTH', 5, SC, tab, NAME3+'_FGM_4SEC', 'cluster_oth'

	arbre = [ arbre, '</instrument>' ]

	IF codif THEN BEGIN

		arbre = [ arbre, 															$
			'<instrument name="CODIF" id="'+NAME2+':CODIF">4 CODIF'										]

		arbre = [ arbre, '5 On board moments ' ]
	
		; On board moments H+
		tab = [	'cl,ws	NH1_CODIF_cm3							# 	 	header yleft_log=Log',				$
			'cl,ws	Vx_CODIF_GSE_km_sec,Vy_CODIF_GSE_km_sec,Vz_CODIF_GSE_km_sec	Vx,Vy,Vz  	header',					$
			'cl,ws	Vx_CODIF_GSM_km_sec,Vy_CODIF_GSM_km_sec,Vz_CODIF_GSM_km_sec	Vx,Vy,Vz	header',					$
			'cl,ws	Tpar_CODIF_MK							#		header',					$
			'cl,ws	Tperp_CODIF_MK							#		header'						]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':CODIF:MOMENTS_H1">6 On board moments H+', 'CIS-OTH', 2, SC, tab, NAME3+'_CODIF_MOMENTS_H1', 'cluster_oth'

		; On board moments He++
		tab = [	'cl,ws	NHe2_CODIF_cm3							# 	 	header yleft_log=Log'				]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':CODIF:MOMENTS_HE2">6 On board moments He++', 'CIS-OTH', 2, SC, tab, NAME3+'_CODIF_MOMENTS_HE2', 'cluster_oth'

		; On board moments He+
		tab = [	'cl,ws	NHe1_CODIF_cm3							# 	 	header yleft_log=Log'				]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':CODIF:MOMENTS_HE1">6 On board moments He+', 'CIS-OTH', 2, SC, tab, NAME3+'_CODIF_MOMENTS_HE1', 'cluster_oth'

		; On board moments O+
		tab = [	'cl,ws	NO1_CODIF_cm3							# 	 	header yleft_log=Log'				]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':CODIF:MOMENTS_O1">6 On board moments O+', 'CIS-OTH', 2, SC, tab, NAME3+'_CODIF_MOMENTS_O1', 'cluster_oth'

		info_bulle_VB = get_cldataset_starttime_endtime('CIS-CODIF',[50,51],SC)
		info_bulle_CODIF = get_cldataset_starttime_endtime('CIS-CODIF',[12,13,14,15,16,17,18,19,20,21,22,23,29,46,47,48,49],SC)

		arbre = [ arbre, $
			'5 On board moments VB ' + info_bulle_VB,													$
			'6 H+',													$
				'0 VB Vpar GSE Vx,Vy,Vz,V#  		CIS-CODIF P50,P51 '+SC+' Vxpar_h1_gse_km_sec,Vypar_h1_gse_km_sec,Vzpar_h1_gse_km_sec,Vpar_h1_gse_km_sec 		vb ',	$
				'0 VB Vpar GSM Vx,Vy,Vz,V#  		CIS-CODIF P50,P51 '+SC+' Vxpar_h1_gsm_km_sec,Vypar_h1_gsm_km_sec,Vzpar_h1_gsm_km_sec,Vpar_h1_gse_km_sec 		vb ',	$
				'0 VB Vper GSE Vx,Vy,Vz,V#  		CIS-CODIF P50,P51 '+SC+' Vxper_h1_gse_km_sec,Vyper_h1_gse_km_sec,Vzper_h1_gse_km_sec,Vper_h1_gse_km_sec			vb ',	$
				'0 VB Vper GSM Vx,Vy,Vz,V#  		CIS-CODIF P50,P51 '+SC+' Vxper_h1_gsm_km_sec,Vyper_h1_gsm_km_sec,Vzper_h1_gsm_km_sec,Vper_h1_gse_km_sec			vb ',	$
				'0 VB V^B GSE Elx,Ely,Elz,El#		CIS-CODIF P50,P51 '+SC+' Elx_h1_gse_mV_m,Ely_h1_gse_mV_m,Elz_h1_gse_mV_m,El_h1_gse_mV_m					vb',	$
				'0 VB V^B GSM Elx,Ely,Elz,El#		CIS-CODIF P50,P51 '+SC+' Elx_h1_gsm_mV_m,Ely_h1_gsm_mV_m,Elz_h1_gsm_mV_m,El_h1_gse_mV_m					vb',	$
				'0 VB 1/3 of Pressure Tensor trace Pp#	CIS-CODIF P50,P51 '+SC+' Pp_h1_nPa											vb',	$
				'0 VB Beta#				CIS-CODIF P50,P51 '+SC+' Beta_h1											vb',	$
				'0 VB Pp + Pm#				CIS-CODIF P50,P51 '+SC+' TBD_h1_nPa											vb',	$
				'0 VB Alfven velocity GSE Vx,Vy,Vz,V#	CIS-CODIF P50,P51 '+SC+' Vxalfven_h1_gse_km_sec,Vyalfven_h1_gse_km_sec,Vzalfven_h1_gse_km_sec,Valfven_h1_km_sec		vb',	$
				'0 VB Alfven velocity GSM Vx,Vy,Vz,V#	CIS-CODIF P50,P51 '+SC+' Vxalfven_h1_gsm_km_sec,Vyalfven_h1_gsm_km_sec,Vzalfven_h1_gsm_km_sec,Valfven_h1_km_sec		vb',	$
			'6 He++',													$
				'0 VB Vpar GSE Vx,Vy,Vz,V#  		CIS-CODIF P50,P51 '+SC+' Vxpar_he2_gse_km_sec,Vypar_he2_gse_km_sec,Vzpar_he2_gse_km_sec,Vpar_he2_gse_km_sec 		vb ',	$
				'0 VB Vpar GSM Vx,Vy,Vz,V#  		CIS-CODIF P50,P51 '+SC+' Vxpar_he2_gsm_km_sec,Vypar_he2_gsm_km_sec,Vzpar_he2_gsm_km_sec,Vpar_he2_gse_km_sec 		vb ',	$
				'0 VB Vper GSE Vx,Vy,Vz,V#  		CIS-CODIF P50,P51 '+SC+' Vxper_he2_gse_km_sec,Vyper_he2_gse_km_sec,Vzper_he2_gse_km_sec,Vper_he2_gse_km_sec		vb ',	$
				'0 VB Vper GSM Vx,Vy,Vz,V#  		CIS-CODIF P50,P51 '+SC+' Vxper_he2_gsm_km_sec,Vyper_he2_gsm_km_sec,Vzper_he2_gsm_km_sec,Vper_he2_gse_km_sec		vb ',	$
				'0 VB V^B GSE Elx,Ely,Elz,El#		CIS-CODIF P50,P51 '+SC+' Elx_he2_gse_mV_m,Ely_he2_gse_mV_m,Elz_he2_gse_mV_m,El_he2_gse_mV_m				vb',	$
				'0 VB V^B GSM Elx,Ely,Elz,El#		CIS-CODIF P50,P51 '+SC+' Elx_he2_gsm_mV_m,Ely_he2_gsm_mV_m,Elz_he2_gsm_mV_m,El_he2_gse_mV_m				vb',	$
				'0 VB 1/3 of Pressure Tensor trace Pp#	CIS-CODIF P50,P51 '+SC+' Pp_he2_nPa											vb',	$
				'0 VB Beta#				CIS-CODIF P50,P51 '+SC+' Beta_he2											vb',	$
				'0 VB Pp + Pm#				CIS-CODIF P50,P51 '+SC+' TBD_he2_nPa											vb',	$
				'0 VB Alfven velocity GSE Vx,Vy,Vz,V#	CIS-CODIF P50,P51 '+SC+' Vxalfven_he2_gse_km_sec,Vyalfven_he2_gse_km_sec,Vzalfven_he2_gse_km_sec,Valfven_he2_km_sec	vb',	$
				'0 VB Alfven velocity GSM Vx,Vy,Vz,V#	CIS-CODIF P50,P51 '+SC+' Vxalfven_he2_gsm_km_sec,Vyalfven_he2_gsm_km_sec,Vzalfven_he2_gsm_km_sec,Valfven_he2_km_sec	vb',	$
			'6 He+',													$
				'0 VB Vpar GSE Vx,Vy,Vz,V#  		CIS-CODIF P50,P51 '+SC+' Vxpar_he1_gse_km_sec,Vypar_he1_gse_km_sec,Vzpar_he1_gse_km_sec,Vpar_he1_gse_km_sec 		vb ',	$
				'0 VB Vpar GSM Vx,Vy,Vz,V#  		CIS-CODIF P50,P51 '+SC+' Vxpar_he1_gsm_km_sec,Vypar_he1_gsm_km_sec,Vzpar_he1_gsm_km_sec,Vpar_he1_gse_km_sec 		vb ',	$
				'0 VB Vper GSE Vx,Vy,Vz,V#  		CIS-CODIF P50,P51 '+SC+' Vxper_he1_gse_km_sec,Vyper_he1_gse_km_sec,Vzper_he1_gse_km_sec,Vper_he1_gse_km_sec		vb ',	$
				'0 VB Vper GSM Vx,Vy,Vz,V#  		CIS-CODIF P50,P51 '+SC+' Vxper_he1_gsm_km_sec,Vyper_he1_gsm_km_sec,Vzper_he1_gsm_km_sec,Vper_he1_gse_km_sec		vb ',	$
				'0 VB V^B GSE Elx,Ely,Elz,El#		CIS-CODIF P50,P51 '+SC+' Elx_he1_gse_mV_m,Ely_he1_gse_mV_m,Elz_he1_gse_mV_m,El_he1_gse_mV_m				vb',	$
				'0 VB V^B GSM Elx,Ely,Elz,El#		CIS-CODIF P50,P51 '+SC+' Elx_he1_gsm_mV_m,Ely_he1_gsm_mV_m,Elz_he1_gsm_mV_m,El_he1_gse_mV_m				vb',	$
				'0 VB 1/3 of Pressure Tensor trace Pp#	CIS-CODIF P50,P51 '+SC+' Pp_he1_nPa											vb',	$
				'0 VB Beta#				CIS-CODIF P50,P51 '+SC+' Beta_he1											vb',	$
				'0 VB Pp + Pm#				CIS-CODIF P50,P51 '+SC+' TBD_he1_nPa											vb',	$
				'0 VB Alfven velocity GSE Vx,Vy,Vz,V#	CIS-CODIF P50,P51 '+SC+' Vxalfven_he1_gse_km_sec,Vyalfven_he1_gse_km_sec,Vzalfven_he1_gse_km_sec,Valfven_he1_km_sec	vb',	$
				'0 VB Alfven velocity GSM Vx,Vy,Vz,V#	CIS-CODIF P50,P51 '+SC+' Vxalfven_he1_gsm_km_sec,Vyalfven_he1_gsm_km_sec,Vzalfven_he1_gsm_km_sec,Valfven_he1_km_sec	vb',	$
			'6 O+',													$
				'0 VB Vpar GSE Vx,Vy,Vz,V#  		CIS-CODIF P50,P51 '+SC+' Vxpar_o1_gse_km_sec,Vypar_o1_gse_km_sec,Vzpar_o1_gse_km_sec,Vpar_o1_gse_km_sec 		vb ',	$
				'0 VB Vpar GSM Vx,Vy,Vz,V#  		CIS-CODIF P50,P51 '+SC+' Vxpar_o1_gsm_km_sec,Vypar_o1_gsm_km_sec,Vzpar_o1_gsm_km_sec,Vpar_o1_gse_km_sec 		vb ',	$
				'0 VB Vper GSE Vx,Vy,Vz,V#  		CIS-CODIF P50,P51 '+SC+' Vxper_o1_gse_km_sec,Vyper_o1_gse_km_sec,Vzper_o1_gse_km_sec,Vper_o1_gse_km_sec			vb ',	$
				'0 VB Vper GSM Vx,Vy,Vz,V#  		CIS-CODIF P50,P51 '+SC+' Vxper_o1_gsm_km_sec,Vyper_o1_gsm_km_sec,Vzper_o1_gsm_km_sec,Vper_o1_gse_km_sec			vb ',	$
				'0 VB V^B GSE Elx,Ely,Elz,El#		CIS-CODIF P50,P51 '+SC+' Elx_o1_gse_mV_m,Ely_o1_gse_mV_m,Elz_o1_gse_mV_m,El_o1_gse_mV_m					vb',	$
				'0 VB V^B GSM Elx,Ely,Elz,El#		CIS-CODIF P50,P51 '+SC+' Elx_o1_gsm_mV_m,Ely_o1_gsm_mV_m,Elz_o1_gsm_mV_m,El_o1_gse_mV_m					vb',	$
				'0 VB 1/3 of Pressure Tensor trace Pp#	CIS-CODIF P50,P51 '+SC+' Pp_o1_nPa											vb',	$
				'0 VB Beta#				CIS-CODIF P50,P51 '+SC+' Beta_o1											vb',	$
				'0 VB Pp + Pm#				CIS-CODIF P50,P51 '+SC+' TBD_o1_nPa											vb',	$
				'0 VB Alfven velocity GSE Vx,Vy,Vz,V#	CIS-CODIF P50,P51 '+SC+' Vxalfven_o1_gse_km_sec,Vyalfven_o1_gse_km_sec,Vzalfven_o1_gse_km_sec,Valfven_o1_km_sec		vb',	$
				'0 VB Alfven velocity GSM Vx,Vy,Vz,V#	CIS-CODIF P50,P51 '+SC+' Vxalfven_o1_gsm_km_sec,Vyalfven_o1_gsm_km_sec,Vzalfven_o1_gsm_km_sec,Valfven_o1_km_sec		vb'	]

			; moments CDF: mmes donnes que dans les fichiers binaires
			;'6 CDF file',														$
			;	'0 Density H+#CIS-OTH P4 '+SC+' NH1_CODIF_cm3 header yleft_log=Log',							$
			;	'0 Density O+#CIS-OTH P4 '+SC+' NO1_CODIF_cm3 header yleft_log=Log',							$
			;	'0 Density He+#CIS-OTH P4 '+SC+' NHe1_CODIF_cm3 header yleft_log=Log',						$
			;	'0 Density He++#CIS-OTH P4 '+SC+' NHe2_CODIF_cm3 header yleft_log=Log',						$
			;	'0 Velocity Vx,Vy,Vz GSE H+#CIS-OTH P4 '+SC+' Vx_H1_CODIF_GSE_km_sec,Vy_H1_CODIF_GSE_km_sec,Vz_H1_CODIF_GSE_km_sec header',	$
			;	'0 Tpar Tper H+#CIS-OTH P4 '+SC+' TparH1_CODIF_MK,TperH1_CODIF_MK header',						$

		arbre = [ arbre, '5 3D moments from 35 to 26000eV' ]

		action = 'count2d type=moments ion_nochamp=H+ emin_=35 emax_=26000 legend_theta=No legend_phi=No'
		tab = [	'cl,ws	N_cm3												#  			' + action + ' yleft_log=Log',	$
			'cl,ws	Vx_gse_km_sec,Vy_gse_km_sec,Vz_gse_km_sec,*V_km_sec						Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vx_gsm_km_sec,Vy_gsm_km_sec,Vz_gsm_km_sec,*V_km_sec						Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Ppar_eV_cm3											#			' + action,			$
			'cl,ws	Pper1_eV_cm3											#			' + action,			$
			'cl,ws	Pper2_eV_cm3											#			' + action,			$
			'cl,ws	Qx_gse_erg_sec_cm2,Qy_gse_erg_sec_cm2,Qz_gse_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Qx_gsm_erg_sec_cm2,Qy_gsm_erg_sec_cm2,Qz_gsm_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,*Qpar_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,*Qper_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Pxx_eV_cm3_gse,Pxy_eV_cm3_gse,Pxz_eV_cm3_gse,Pyy_eV_cm3_gse,Pyz_eV_cm3_gse,Pzz_eV_cm3_gse	Pxx,Pxy,Pxz,Pyy,Pyz,Pzz	' + action,			$
			'cl,ws	Pxx_eV_cm3_b,Pxy_eV_cm3_b,Pxz_eV_cm3_b,Pyy_eV_cm3_b,Pyz_eV_cm3_b,Pzz_eV_cm3_b			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz	' + action,			$
			'cl,ws	Ti_eV												#			' + action,			$
			'cl,ws	Ex_gse,Ey_gse,Ez_gse										Ex,Ey,Ez		' + action,			$
			'cl,ws	Ex_gsm,Ey_gsm,Ez_gsm										Ex,Ey,Ez		' + action,			$
			'cl,ws	Vxpar_gse_km_sec,Vypar_gse_km_sec,Vzpar_gse_km_sec,*Vpar_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxpar_gsm_km_sec,Vypar_gsm_km_sec,Vzpar_gsm_km_sec,*Vpar_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxper_gse_km_sec,Vyper_gse_km_sec,Vzper_gse_km_sec,*Vper_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxper_gsm_km_sec,Vyper_gsm_km_sec,Vzper_gsm_km_sec,*Vper_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Elx_gse_mV_m,Ely_gse_mV_m,Elz_gse_mV_m,*El_gse_mV_m						Elx,Ely,Elz,|El|	' + action,			$
			'cl,ws	Elx_gsm_mV_m,Ely_gsm_mV_m,Elz_gsm_mV_m,*El_gse_mV_m						Elx,Ely,Elz,|El|	' + action,			$
			'cl,ws	Pp_nPa												#			' + action,			$
			'cl,ws	Pm_nPa												#			' + action,			$
			'cl,ws	Beta												#			' + action,			$
			'cl,ws	Vxalfven_gse_km_sec,Vyalfven_gse_km_sec,Vzalfven_gse_km_sec,*Valfven_km_sec			Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxalfven_gsm_km_sec,Vyalfven_gsm_km_sec,Vzalfven_gsm_km_sec,*Valfven_km_sec			Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	An												#			' + action,			$
			'cl,ws	Ng												#			' + action,			$
			'cl,ws	Bx_gse_nT,By_gse_nT,Bz_gse_nT									Bx,By,Bz		' + action,			$
			'cl,ws	Bx_gsm_nT,By_gsm_nT,Bz_gsm_nT									Bx,By,Bz		' + action			]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':CODIF:3DMOMENTS_H1">6 3D moments from 35 to 26000eV H+',   'CIS-CODIF', [12,13,14,29], SC, tab, NAME3+'_CODIF_3DMOMENTS_H1',  'cluster_codif cluster_oth', /moments

		action = 'count2d type=moments ion_nochamp=He++ emin_=35 emax_=26000 legend_theta=No legend_phi=No'
		tab = [	'cl,ws	N_cm3												#  			' + action + ' yleft_log=Log',	$
			'cl,ws	Vx_gse_km_sec,Vy_gse_km_sec,Vz_gse_km_sec,*V_km_sec						Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vx_gsm_km_sec,Vy_gsm_km_sec,Vz_gsm_km_sec,*V_km_sec						Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Ppar_eV_cm3											#			' + action,			$
			'cl,ws	Pper1_eV_cm3											#			' + action,			$
			'cl,ws	Pper2_eV_cm3											#			' + action,			$
			'cl,ws	Qx_gse_erg_sec_cm2,Qy_gse_erg_sec_cm2,Qz_gse_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Qx_gsm_erg_sec_cm2,Qy_gsm_erg_sec_cm2,Qz_gsm_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,*Qpar_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,*Qper_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Pxx_eV_cm3_gse,Pxy_eV_cm3_gse,Pxz_eV_cm3_gse,Pyy_eV_cm3_gse,Pyz_eV_cm3_gse,Pzz_eV_cm3_gse	Pxx,Pxy,Pxz,Pyy,Pyz,Pzz	' + action,			$
			'cl,ws	Pxx_eV_cm3_b,Pxy_eV_cm3_b,Pxz_eV_cm3_b,Pyy_eV_cm3_b,Pyz_eV_cm3_b,Pzz_eV_cm3_b			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz	' + action,			$
			'cl,ws	Ti_eV												#			' + action,			$
			'cl,ws	Ex_gse,Ey_gse,Ez_gse										Ex,Ey,Ez		' + action,			$
			'cl,ws	Ex_gsm,Ey_gsm,Ez_gsm										Ex,Ey,Ez		' + action,			$
			'cl,ws	Vxpar_gse_km_sec,Vypar_gse_km_sec,Vzpar_gse_km_sec,*Vpar_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxpar_gsm_km_sec,Vypar_gsm_km_sec,Vzpar_gsm_km_sec,*Vpar_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxper_gse_km_sec,Vyper_gse_km_sec,Vzper_gse_km_sec,*Vper_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxper_gsm_km_sec,Vyper_gsm_km_sec,Vzper_gsm_km_sec,*Vper_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Elx_gse_mV_m,Ely_gse_mV_m,Elz_gse_mV_m,*El_gse_mV_m						Elx,Ely,Elz,|El|	' + action,			$
			'cl,ws	Elx_gsm_mV_m,Ely_gsm_mV_m,Elz_gsm_mV_m,*El_gse_mV_m						Elx,Ely,Elz,|El|	' + action,			$
			'cl,ws	Pp_nPa												#			' + action,			$
			'cl,ws	Pm_nPa												#			' + action,			$
			'cl,ws	Beta												#			' + action,			$
			'cl,ws	Vxalfven_gse_km_sec,Vyalfven_gse_km_sec,Vzalfven_gse_km_sec,*Valfven_km_sec			Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxalfven_gsm_km_sec,Vyalfven_gsm_km_sec,Vzalfven_gsm_km_sec,*Valfven_km_sec			Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	An												#			' + action,			$
			'cl,ws	Ng												#			' + action,			$
			'cl,ws	Bx_gse_nT,By_gse_nT,Bz_gse_nT									Bx,By,Bz		' + action,			$
			'cl,ws	Bx_gsm_nT,By_gsm_nT,Bz_gsm_nT									Bx,By,Bz		' + action			]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':CODIF:3DMOMENTS_HE2">6 3D moments from 35 to 26000eV He++', 'CIS-CODIF', [15,16,29],    SC, tab, NAME3+'_CODIF_3DMOMENTS_HE2', 'cluster_codif cluster_oth', /moments

		action = 'count2d type=moments ion_nochamp=He+ emin_=35 emax_=26000 legend_theta=No legend_phi=No'
		tab = [	'cl,ws	N_cm3												#  			' + action + ' yleft_log=Log',	$
			'cl,ws	Vx_gse_km_sec,Vy_gse_km_sec,Vz_gse_km_sec,*V_km_sec						Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vx_gsm_km_sec,Vy_gsm_km_sec,Vz_gsm_km_sec,*V_km_sec						Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Ppar_eV_cm3											#			' + action,			$
			'cl,ws	Pper1_eV_cm3											#			' + action,			$
			'cl,ws	Pper2_eV_cm3											#			' + action,			$
			'cl,ws	Qx_gse_erg_sec_cm2,Qy_gse_erg_sec_cm2,Qz_gse_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Qx_gsm_erg_sec_cm2,Qy_gsm_erg_sec_cm2,Qz_gsm_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,*Qpar_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,*Qper_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Pxx_eV_cm3_gse,Pxy_eV_cm3_gse,Pxz_eV_cm3_gse,Pyy_eV_cm3_gse,Pyz_eV_cm3_gse,Pzz_eV_cm3_gse	Pxx,Pxy,Pxz,Pyy,Pyz,Pzz	' + action,			$
			'cl,ws	Pxx_eV_cm3_b,Pxy_eV_cm3_b,Pxz_eV_cm3_b,Pyy_eV_cm3_b,Pyz_eV_cm3_b,Pzz_eV_cm3_b			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz	' + action,			$
			'cl,ws	Ti_eV												#			' + action,			$
			'cl,ws	Ex_gse,Ey_gse,Ez_gse										Ex,Ey,Ez		' + action,			$
			'cl,ws	Ex_gsm,Ey_gsm,Ez_gsm										Ex,Ey,Ez		' + action,			$
			'cl,ws	Vxpar_gse_km_sec,Vypar_gse_km_sec,Vzpar_gse_km_sec,*Vpar_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxpar_gsm_km_sec,Vypar_gsm_km_sec,Vzpar_gsm_km_sec,*Vpar_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxper_gse_km_sec,Vyper_gse_km_sec,Vzper_gse_km_sec,*Vper_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxper_gsm_km_sec,Vyper_gsm_km_sec,Vzper_gsm_km_sec,*Vper_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Elx_gse_mV_m,Ely_gse_mV_m,Elz_gse_mV_m,*El_gse_mV_m						Elx,Ely,Elz,|El|	' + action,			$
			'cl,ws	Elx_gsm_mV_m,Ely_gsm_mV_m,Elz_gsm_mV_m,*El_gse_mV_m						Elx,Ely,Elz,|El|	' + action,			$
			'cl,ws	Pp_nPa												#			' + action,			$
			'cl,ws	Pm_nPa												#			' + action,			$
			'cl,ws	Beta												#			' + action,			$
			'cl,ws	Vxalfven_gse_km_sec,Vyalfven_gse_km_sec,Vzalfven_gse_km_sec,*Valfven_km_sec			Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxalfven_gsm_km_sec,Vyalfven_gsm_km_sec,Vzalfven_gsm_km_sec,*Valfven_km_sec			Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	An												#			' + action,			$
			'cl,ws	Ng												#			' + action,			$
			'cl,ws	Bx_gse_nT,By_gse_nT,Bz_gse_nT									Bx,By,Bz		' + action,			$
			'cl,ws	Bx_gsm_nT,By_gsm_nT,Bz_gsm_nT									Bx,By,Bz		' + action			]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':CODIF:3DMOMENTS_HE1">6 3D moments from 35 to 26000eV He+',  'CIS-CODIF', [17,18,29,46,48], SC, tab, NAME3+'_CODIF_3DMOMENTS_HE1', 'cluster_codif cluster_oth', /moments

		action = 'count2d type=moments ion_nochamp=O+ emin_=35 emax_=26000 legend_theta=No legend_phi=No'
		tab = [	'cl,ws	N_cm3												#  			' + action + ' yleft_log=Log',	$
			'cl,ws	Vx_gse_km_sec,Vy_gse_km_sec,Vz_gse_km_sec,*V_km_sec						Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vx_gsm_km_sec,Vy_gsm_km_sec,Vz_gsm_km_sec,*V_km_sec						Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Ppar_eV_cm3											#			' + action,			$
			'cl,ws	Pper1_eV_cm3											#			' + action,			$
			'cl,ws	Pper2_eV_cm3											#			' + action,			$
			'cl,ws	Qx_gse_erg_sec_cm2,Qy_gse_erg_sec_cm2,Qz_gse_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Qx_gsm_erg_sec_cm2,Qy_gsm_erg_sec_cm2,Qz_gsm_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,*Qpar_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,*Qper_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Pxx_eV_cm3_gse,Pxy_eV_cm3_gse,Pxz_eV_cm3_gse,Pyy_eV_cm3_gse,Pyz_eV_cm3_gse,Pzz_eV_cm3_gse	Pxx,Pxy,Pxz,Pyy,Pyz,Pzz	' + action,			$
			'cl,ws	Pxx_eV_cm3_b,Pxy_eV_cm3_b,Pxz_eV_cm3_b,Pyy_eV_cm3_b,Pyz_eV_cm3_b,Pzz_eV_cm3_b			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz	' + action,			$
			'cl,ws	Ti_eV												#			' + action,			$
			'cl,ws	Ex_gse,Ey_gse,Ez_gse										Ex,Ey,Ez		' + action,			$
			'cl,ws	Ex_gsm,Ey_gsm,Ez_gsm										Ex,Ey,Ez		' + action,			$
			'cl,ws	Vxpar_gse_km_sec,Vypar_gse_km_sec,Vzpar_gse_km_sec,*Vpar_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxpar_gsm_km_sec,Vypar_gsm_km_sec,Vzpar_gsm_km_sec,*Vpar_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxper_gse_km_sec,Vyper_gse_km_sec,Vzper_gse_km_sec,*Vper_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxper_gsm_km_sec,Vyper_gsm_km_sec,Vzper_gsm_km_sec,*Vper_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Elx_gse_mV_m,Ely_gse_mV_m,Elz_gse_mV_m,*El_gse_mV_m						Elx,Ely,Elz,|El|	' + action,			$
			'cl,ws	Elx_gsm_mV_m,Ely_gsm_mV_m,Elz_gsm_mV_m,*El_gse_mV_m						Elx,Ely,Elz,|El|	' + action,			$
			'cl,ws	Pp_nPa												#			' + action,			$
			'cl,ws	Pm_nPa												#			' + action,			$
			'cl,ws	Beta												#			' + action,			$
			'cl,ws	Vxalfven_gse_km_sec,Vyalfven_gse_km_sec,Vzalfven_gse_km_sec,*Valfven_km_sec			Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxalfven_gsm_km_sec,Vyalfven_gsm_km_sec,Vzalfven_gsm_km_sec,*Valfven_km_sec			Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	An												#			' + action,			$
			'cl,ws	Ng												#			' + action,			$
			'cl,ws	Bx_gse_nT,By_gse_nT,Bz_gse_nT									Bx,By,Bz		' + action,			$
			'cl,ws	Bx_gsm_nT,By_gsm_nT,Bz_gsm_nT									Bx,By,Bz		' + action			]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':CODIF:3DMOMENTS_O1">6 3D moments from 35 to 26000eV O+',   'CIS-CODIF', [17,18,29,47,49], SC, tab, NAME3+'_CODIF_3DMOMENTS_O1',  'cluster_codif cluster_oth', /moments

		; Spectro H+ pour webservice (que les 3D)
		info1 = [							$
			{ noproduit:12,	nomproduit:'H1_P12_3D_88A_16E' 	},	$
			{ noproduit:13,	nomproduit:'H1_P13_3D_88A_31E' 	},	$
			{ noproduit:14,	nomproduit:'H1_P14_3D_24A_31E' 	},	$
			{ noproduit:29,	nomproduit:'H1_RPA_3D_88A_16E' 	}	]

		FOR i=0L,N_ELEMENTS(info1)-1 DO BEGIN
			tab = [	'ws	1d_data 		# count3d type=time_energy ion_nochamp=H+ cjf=c/s  yleft_auto=Manual yleft_min=35 yleft_max=26000 z_showdir=No z_theta=No z_phi=No',	$
				'ws	1d_data 		# count3d type=time_energy ion_nochamp=H+ cjf=flux yleft_auto=Manual yleft_min=35 yleft_max=26000 z_showdir=No z_theta=No z_phi=No',	$
				'ws	1d_data 		# count3d type=time_energy ion_nochamp=H+ cjf=JE   yleft_auto=Manual yleft_min=35 yleft_max=26000 z_showdir=No z_theta=No z_phi=No']
			ajouter_dataset, arbre, '<dataset id="'+NAME2+':CODIF:'+info1[i].nomproduit+'_SPECTRO_TIME_ENERGY" visibility="ws">5 '+info1[i].nomproduit+' Spectrogram H+ Time Energy', 'CIS-CODIF', info1[i].noproduit, SC, tab, NAME3+'_CODIF_'+info1[i].nomproduit+'_SPECTRO_TIME_ENERGY', 'cluster_codif', /spectro
		END

		; Spectro He++ pour webservice (que les 3D)
		info1 = [							$
			{ noproduit:15,	nomproduit:'HE2_P15_3D_88A_16E'	},	$
			{ noproduit:16,	nomproduit:'HE2_P16_3D_88A_31E'	},	$
			{ noproduit:29,	nomproduit:'HE2_RPA_3D_88A_16E'	}	]

		FOR i=0L,N_ELEMENTS(info1)-1 DO BEGIN
			tab = [	'ws	1d_data 		# count3d type=time_energy ion_nochamp=He++ cjf=c/s  yleft_auto=Manual yleft_min=35 yleft_max=26000 z_showdir=No z_theta=No z_phi=No',	$
				'ws	1d_data 		# count3d type=time_energy ion_nochamp=He++ cjf=flux yleft_auto=Manual yleft_min=35 yleft_max=26000 z_showdir=No z_theta=No z_phi=No',	$
				'ws	1d_data 		# count3d type=time_energy ion_nochamp=He++ cjf=JE   yleft_auto=Manual yleft_min=35 yleft_max=26000 z_showdir=No z_theta=No z_phi=No']
			ajouter_dataset, arbre, '<dataset id="'+NAME2+':CODIF:'+info1[i].nomproduit+'_SPECTRO_TIME_ENERGY" visibility="ws">5 '+info1[i].nomproduit+' Spectrogram He++ Time Energy', 'CIS-CODIF', info1[i].noproduit, SC, tab, NAME3+'_CODIF_'+info1[i].nomproduit+'_SPECTRO_TIME_ENERGY', 'cluster_codif', /spectro
		END

		; Spectro He+ pour webservice (que les 3D)
		info1 = [							$
			{ noproduit:17,	nomproduit:'HE1_P17_3D_88A_16E'	},	$
			{ noproduit:18,	nomproduit:'HE1_P18_3D_88A_31E'	},	$
			{ noproduit:29,	nomproduit:'HE1_RPA_3D_88A_16E'	},	$
			{ noproduit:46,	nomproduit:'HE1_P46_3D_88A_16E'	},	$
			{ noproduit:48,	nomproduit:'HE1_P48_3D_88A_31E'	}	]

		FOR i=0L,N_ELEMENTS(info1)-1 DO BEGIN
			tab = [	'ws	1d_data 		# count3d type=time_energy ion_nochamp=He+ cjf=c/s  yleft_auto=Manual yleft_min=35 yleft_max=26000 z_showdir=No z_theta=No z_phi=No',	$
				'ws	1d_data 		# count3d type=time_energy ion_nochamp=He+ cjf=flux yleft_auto=Manual yleft_min=35 yleft_max=26000 z_showdir=No z_theta=No z_phi=No',	$
				'ws	1d_data 		# count3d type=time_energy ion_nochamp=He+ cjf=JE   yleft_auto=Manual yleft_min=35 yleft_max=26000 z_showdir=No z_theta=No z_phi=No']
			ajouter_dataset, arbre, '<dataset id="'+NAME2+':CODIF:'+info1[i].nomproduit+'_SPECTRO_TIME_ENERGY" visibility="ws">5 '+info1[i].nomproduit+' Spectrogram He+ Time Energy', 'CIS-CODIF', info1[i].noproduit, SC, tab, NAME3+'_CODIF_'+info1[i].nomproduit+'_SPECTRO_TIME_ENERGY', 'cluster_codif', /spectro
		END

		; Spectro O+ pour webservice (que les 3D)
		info1 = [							$
			{ noproduit:17,	nomproduit:'O1_P17_3D_88A_16E' 	},	$
			{ noproduit:18,	nomproduit:'O1_P18_3D_88A_31E' 	},	$
			{ noproduit:29,	nomproduit:'O1_RPA_3D_88A_16E' 	},	$
			{ noproduit:47,	nomproduit:'O1_P47_3D_88A_16E' 	},	$
			{ noproduit:49,	nomproduit:'O1_P49_3D_88A_31E' 	}	]

		FOR i=0L,N_ELEMENTS(info1)-1 DO BEGIN
			tab = [	'ws	1d_data 		# count3d type=time_energy ion_nochamp=O+ cjf=c/s  yleft_auto=Manual yleft_min=35 yleft_max=26000 z_showdir=No z_theta=No z_phi=No',	$
				'ws	1d_data 		# count3d type=time_energy ion_nochamp=O+ cjf=flux yleft_auto=Manual yleft_min=35 yleft_max=26000 z_showdir=No z_theta=No z_phi=No',	$
				'ws	1d_data 		# count3d type=time_energy ion_nochamp=O+ cjf=JE   yleft_auto=Manual yleft_min=35 yleft_max=26000 z_showdir=No z_theta=No z_phi=No'	]
			ajouter_dataset, arbre, '<dataset id="'+NAME2+':CODIF:'+info1[i].nomproduit+'_SPECTRO_TIME_ENERGY" visibility="ws">5 '+info1[i].nomproduit+' Spectrogram O+ Time Energy', 'CIS-CODIF', info1[i].noproduit, SC, tab, NAME3+'_CODIF_'+info1[i].nomproduit+'_SPECTRO_TIME_ENERGY', 'cluster_codif', /spectro
		END

		arbre = [ arbre,	$
			'5 Particle spectrogram ' + info_bulle_CODIF,													$
			'6 H+',													$
				'0 Time Energy JE#          	CIS-CODIF P12,P13,P14,P19,P20,P21,P22,P23,P29 '+SC+' JE count3d type=time_energy cjf=JE yleft_auto=Manual yleft_min=35 yleft_max=26000 z_showdir=No z_theta=No z_phi=No',		$
				'0 Time Theta JE#           	CIS-CODIF P12,P13,P14,P19,P20,P21,P22,P23,P29 '+SC+' JE count3d type=time_theta cjf=JE emin_nochamp=35 emax_nochamp=26000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',		$
				'0 Time Phi JE#             	CIS-CODIF P12,P13,P14,P19,P20,P21,P22,P23,P29 '+SC+' JE count3d type=time_phi cjf=JE emin_nochamp=35 emax_nochamp=26000 yleft_auto=Manual yleft_min=-180 yleft_max=180 z_showdir=No z_theta=No z_phi=No',		$
				'0 Time Pitchangle JE#     	CIS-CODIF P12,P13,P14,P29                 '+SC+' JE count3d type=time_pitchangle cjf=JE emin_nochamp=35 emax_nochamp=26000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
				'0 Energy Pitchangle JE#	CIS-CODIF P12,P13,P14,P29                 '+SC+' JE count3d type=energy_pitchangle cjf=JE z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',									$
				'0 Phi Theta JE#            	CIS-CODIF P12,P13,P14,P29                 '+SC+' JE count3d type=phi_theta cjf=JE emin_nochamp=35 emax_nochamp=26000 yleft_auto=Automatic x_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
				'0 Distribution Function JE#	CIS-CODIF P12,P13,P14,P29                 '+SC+' JE count3d type=Distribution'+STRING(2b)+'Function log0use=Yes cjf=JE interp_nochamp=TRIGRID yleft_auto=Automatic x_auto=Automatic z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',	$
			'6 He++',													$
				'0 Time Energy JE#          	CIS-CODIF P15,P16,P19,P20,P21,P23,P29 '+SC+' JE count3d ion_nochamp=He++ type=time_energy cjf=JE yleft_auto=Manual yleft_min=35 yleft_max=26000 z_showdir=No z_theta=No z_phi=No',		$
				'0 Time Theta JE#           	CIS-CODIF P15,P16,P19,P20,P21,P23,P29 '+SC+' JE count3d ion_nochamp=He++ type=time_theta cjf=JE emin_nochamp=35 emax_nochamp=26000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',		$
				'0 Time Phi JE#             	CIS-CODIF P15,P16,P19,P20,P21,P23,P29 '+SC+' JE count3d ion_nochamp=He++ type=time_phi cjf=JE emin_nochamp=35 emax_nochamp=26000 yleft_auto=Manual yleft_min=-180 yleft_max=180 z_showdir=No z_theta=No z_phi=No',		$
				'0 Time Pitchangle JE#      	CIS-CODIF P15,P16,P29                 '+SC+' JE count3d ion_nochamp=He++ type=time_pitchangle cjf=JE emin_nochamp=35 emax_nochamp=26000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
				'0 Energy Pitchangle JE#	CIS-CODIF P15,P16,P29                 '+SC+' JE count3d ion_nochamp=He++ type=energy_pitchangle cjf=JE z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',									$
				'0 Phi Theta JE#            	CIS-CODIF P15,P16,P29                 '+SC+' JE count3d ion_nochamp=He++ type=phi_theta cjf=JE emin_nochamp=35 emax_nochamp=26000 yleft_auto=Automatic x_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
				'0 Distribution Function JE#	CIS-CODIF P15,P16,P29                 '+SC+' JE count3d ion_nochamp=He++ type=Distribution'+STRING(2b)+'Function log0use=Yes cjf=JE interp_nochamp=TRIGRID yleft_auto=Automatic x_auto=Automatic z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',	$
			'6 He+',													$
				'0 Time Energy JE#          	CIS-CODIF P17,P18,P19,P20,P23,P29,P46,P48 '+SC+' JE count3d ion_nochamp=He+ type=time_energy cjf=JE yleft_auto=Manual yleft_min=35 yleft_max=26000 z_showdir=No z_theta=No z_phi=No',		$
				'0 Time Theta JE#           	CIS-CODIF P17,P18,P19,P20,P23,P29,P46,P48 '+SC+' JE count3d ion_nochamp=He+ type=time_theta cjf=JE emin_nochamp=35 emax_nochamp=26000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',		$
				'0 Time Phi JE#             	CIS-CODIF P17,P18,P19,P20,P23,P29,P46,P48 '+SC+' JE count3d ion_nochamp=He+ type=time_phi cjf=JE emin_nochamp=35 emax_nochamp=26000 yleft_auto=Manual yleft_min=-180 yleft_max=180 z_showdir=No z_theta=No z_phi=No',		$
				'0 Time Pitchangle JE#      	CIS-CODIF P17,P18,P29,P46,P48             '+SC+' JE count3d ion_nochamp=He+ type=time_pitchangle cjf=JE emin_nochamp=35 emax_nochamp=26000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
				'0 Energy Pitchangle JE#	CIS-CODIF P17,P18,P29,P46,P48             '+SC+' JE count3d ion_nochamp=He+ type=energy_pitchangle cjf=JE z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',									$
				'0 Phi Theta JE#            	CIS-CODIF P17,P18,P29,P46,P48             '+SC+' JE count3d ion_nochamp=He+ type=phi_theta cjf=JE emin_nochamp=35 emax_nochamp=26000 yleft_auto=Automatic x_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
				'0 Distribution Function JE#	CIS-CODIF P17,P18,P29,P46,P48             '+SC+' JE count3d ion_nochamp=He+ type=Distribution'+STRING(2b)+'Function log0use=Yes cjf=JE interp_nochamp=TRIGRID yleft_auto=Automatic x_auto=Automatic z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',	$
			'6 O+',													$
				'0 Time Energy JE#         	CIS-CODIF P17,P18,P19,P20,P23,P29,P47,P49 '+SC+' JE count3d ion_nochamp=O+ type=time_energy cjf=JE yleft_auto=Manual yleft_min=35 yleft_max=26000 z_showdir=No z_theta=No z_phi=No',		$
				'0 Time Theta JE#           	CIS-CODIF P17,P18,P19,P20,P23,P29,P47,P49 '+SC+' JE count3d ion_nochamp=O+ type=time_theta cjf=JE emin_nochamp=35 emax_nochamp=26000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',		$
				'0 Time Phi JE#             	CIS-CODIF P17,P18,P19,P20,P23,P29,P47,P49 '+SC+' JE count3d ion_nochamp=O+ type=time_phi cjf=JE emin_nochamp=35 emax_nochamp=26000 yleft_auto=Manual yleft_min=-180 yleft_max=180 z_showdir=No z_theta=No z_phi=No',		$
				'0 Time Pitchangle JE#      	CIS-CODIF P17,P18,P29,P47,P49             '+SC+' JE count3d ion_nochamp=O+ type=time_pitchangle cjf=JE emin_nochamp=35 emax_nochamp=26000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
				'0 Energy Pitchangle JE#	CIS-CODIF P17,P18,P29,P46,P48             '+SC+' JE count3d ion_nochamp=O+ type=energy_pitchangle cjf=JE z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',									$
				'0 Phi Theta JE#            	CIS-CODIF P17,P18,P29,P47,P49             '+SC+' JE count3d ion_nochamp=O+ type=phi_theta cjf=JE emin_nochamp=35 emax_nochamp=26000 yleft_auto=Automatic x_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
				'0 Distribution Function JE#	CIS-CODIF P17,P18,P29,P47,P49             '+SC+' JE count3d ion_nochamp=O+ type=Distribution'+STRING(2b)+'Function log0use=Yes cjf=JE interp_nochamp=TRIGRID yleft_auto=Automatic x_auto=Automatic z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',	$
			'5 Particle plot ' + info_bulle_CODIF,													$
			'6 H+',													$
				'0 Time JE#  			CIS-CODIF P12,P13,P14,P19,P20,P21,P22,P23,P29 '+SC+' JE  count2d type=time_cjf   cjf=JE emin_nochamp=35 emax_nochamp=26000 legend_theta=No legend_phi=No',	$
				'0 Energy JE#			CIS-CODIF P12,P13,P14,P29                     '+SC+' JE  count2d type=energy_cjf cjf=JE emin_nochamp=35 emax_nochamp=26000 legend_theta=No legend_phi=No',	$
				'0 Pitchangle c/s#		CIS-CODIF P12,P13,P14,P29                     '+SC+' c/s count2d type=pitch_cjf cjf=c/s legend_theta=No legend_phi=No',	$
			'6 He++',													$
				'0 Time JE# 			CIS-CODIF P15,P16,P19,P20,P21,P23,P29 '+SC+' JE  count2d ion_nochamp=He++ type=time_cjf   cjf=JE emin_nochamp=35 emax_nochamp=26000 legend_theta=No legend_phi=No',	$
				'0 Energy JE#			CIS-CODIF P15,P16,P29                 '+SC+' JE  count2d ion_nochamp=He++ type=energy_cjf cjf=JE emin_nochamp=35 emax_nochamp=26000 legend_theta=No legend_phi=No',	$
				'0 Pitchangle c/s#		CIS-CODIF P15,P16,P29                 '+SC+' c/s count2d ion_nochamp=He++ type=pitch_cjf cjf=c/s legend_theta=No legend_phi=No',	$
			'6 He+',													$
				'0 Time JE#  			CIS-CODIF P17,P18,P19,P20,P23,P29,P46,P48 '+SC+' JE  count2d ion_nochamp=He+ type=time_cjf   cjf=JE emin_nochamp=35 emax_nochamp=26000 legend_theta=No legend_phi=No',	$
				'0 Energy JE#			CIS-CODIF P17,P18,P29,P46,P48             '+SC+' JE  count2d ion_nochamp=He+ type=energy_cjf cjf=JE emin_nochamp=35 emax_nochamp=26000 legend_theta=No legend_phi=No',	$
				'0 Pitchangle c/s#		CIS-CODIF P17,P18,P29,P46,P48             '+SC+' c/s count2d ion_nochamp=He+ type=pitch_cjf cjf=c/s legend_theta=No legend_phi=No',	$
			'6 O+',													$
				'0 Time JE# 			CIS-CODIF P17,P18,P19,P20,P23,P29,P47,P49 '+SC+' JE  count2d ion_nochamp=O+ type=time_cjf   cjf=JE emin_nochamp=35 emax_nochamp=26000 legend_theta=No legend_phi=No',	$
				'0 Energy JE#			CIS-CODIF P17,P18,P29,P47,P49             '+SC+' JE  count2d ion_nochamp=O+ type=energy_cjf cjf=JE emin_nochamp=35 emax_nochamp=26000 legend_theta=No legend_phi=No',	$
				'0 Pitchangle c/s#		CIS-CODIF P17,P18,P29,P47,P49             '+SC+' c/s count2d ion_nochamp=O+ type=pitch_cjf cjf=c/s legend_theta=No legend_phi=No'	$
		]

		arbre = [ arbre, '</instrument>' ]

	END

	IF hia THEN BEGIN

		arbre = [ arbre, 															$
			'<instrument name="HIA" id="'+NAME2+':HIA">4 HIA'										]

		; On board moments
		tab = [	'cl,ws	NH1_HIA_cm3							# 	 	header yleft_log=Log',				$
			'cl,ws	NHe2_HIA_cm3							# 	 	header yleft_log=Log',				$
			'cl,ws	VxH1_HIA_GSE_km_sec,VyH1_HIA_GSE_km_sec,VzH1_HIA_GSE_km_sec	Vx,Vy,Vz  	header',					$
			'cl,ws	VxH1_HIA_GSM_km_sec,VyH1_HIA_GSM_km_sec,VzH1_HIA_GSM_km_sec	Vx,Vy,Vz  	header',					$
			'cl,ws	VxHe2_HIA_GSE_km_sec,VyHe2_HIA_GSE_km_sec,VzHe2_HIA_GSE_km_sec	Vx,Vy,Vz  	header',					$
			'cl,ws	VxHe2_HIA_GSM_km_sec,VyHe2_HIA_GSM_km_sec,VzHe2_HIA_GSM_km_sec	Vx,Vy,Vz  	header',					$
			'cl,ws	Tpar_HIA_MK							#		header',					$
			'cl,ws	Tperp_HIA_MK							#		header',					$
			'cl,ws	Pc_HIA_nPa							#		header'						]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':HIA:MOMENTS">5 On board moments', 'CIS-OTH', 2, SC, tab, NAME3+'_HIA_MOMENTS', 'cluster_oth'

		info_bulle_VB = get_cldataset_starttime_endtime('CIS-HIA',[50,51],SC)
		info_bulle_HIA_high = get_cldataset_starttime_endtime('CIS-HIA',[6,7,9,10,11,15,17,18,21,23,30,32],SC)
		info_bulle_HIA_low = get_cldataset_starttime_endtime('CIS-HIA',[8,13,14,22,24,31],SC)
		arbre = [ arbre, $
			'5 On board moments VB ' + info_bulle_VB,													$
				'0 VB Vpar GSE Vx,Vy,Vz,V#  		CIS-HIA P50,P51 '+SC+' Vxpar_ions_gse_km_sec,Vypar_ions_gse_km_sec,Vzpar_ions_gse_km_sec,Vpar_ions_gse_km_sec 		vb ',	$
				'0 VB Vpar GSM Vx,Vy,Vz,V#  		CIS-HIA P50,P51 '+SC+' Vxpar_ions_gsm_km_sec,Vypar_ions_gsm_km_sec,Vzpar_ions_gsm_km_sec,Vpar_ions_gse_km_sec 		vb ',	$
				'0 VB Vper GSE Vx,Vy,Vz,V#  		CIS-HIA P50,P51 '+SC+' Vxper_ions_gse_km_sec,Vyper_ions_gse_km_sec,Vzper_ions_gse_km_sec,Vper_ions_gse_km_sec		vb ',	$
				'0 VB Vper GSM Vx,Vy,Vz,V#  		CIS-HIA P50,P51 '+SC+' Vxper_ions_gsm_km_sec,Vyper_ions_gsm_km_sec,Vzper_ions_gsm_km_sec,Vper_ions_gse_km_sec		vb ',	$
				'0 VB V^B GSE Elx,Ely,Elz,El#		CIS-HIA P50,P51 '+SC+' Elx_ions_gse_mV_m,Ely_ions_gse_mV_m,Elz_ions_gse_mV_m,El_ions_gse_mV_m				vb',	$
				'0 VB V^B GSM Elx,Ely,Elz,El#		CIS-HIA P50,P51 '+SC+' Elx_ions_gsm_mV_m,Ely_ions_gsm_mV_m,Elz_ions_gsm_mV_m,El_ions_gse_mV_m				vb',	$
				'0 VB 1/3 of Pressure Tensor trace Pp#	CIS-HIA P50,P51 '+SC+' Pp_ions_nPa											vb',	$
				'0 VB Beta#				CIS-HIA P50,P51 '+SC+' Beta_ions											vb',	$
				'0 VB Pp + Pm#				CIS-HIA P50,P51 '+SC+' TBD_ions_nPa											vb',	$
				'0 VB Alfven velocity GSE Vx,Vy,Vz,V#	CIS-HIA P50,P51 '+SC+' Vxalfven_ions_gse_km_sec,Vyalfven_h1_gse_km_sec,Vzalfven_h1_gse_km_sec,Valfven_h1_km_sec		vb'	]

		arbre = [ arbre, '5 3D moments' ]

		action = 'count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No'
		tab = [	'cl,ws	N_cm3												#  			' + action + ' yleft_log=Log',	$
			'cl,ws	Vx_gse_km_sec,Vy_gse_km_sec,Vz_gse_km_sec,*V_km_sec						Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vx_gsm_km_sec,Vy_gsm_km_sec,Vz_gsm_km_sec,*V_km_sec						Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Ppar_eV_cm3											#			' + action,			$
			'cl,ws	Pper1_eV_cm3											#			' + action,			$
			'cl,ws	Pper2_eV_cm3											#			' + action,			$
			'cl,ws	Qx_gse_erg_sec_cm2,Qy_gse_erg_sec_cm2,Qz_gse_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Qx_gsm_erg_sec_cm2,Qy_gsm_erg_sec_cm2,Qz_gsm_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,*Qpar_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,*Qper_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Pxx_eV_cm3_gse,Pxy_eV_cm3_gse,Pxz_eV_cm3_gse,Pyy_eV_cm3_gse,Pyz_eV_cm3_gse,Pzz_eV_cm3_gse	Pxx,Pxy,Pxz,Pyy,Pyz,Pzz	' + action,			$
			'cl,ws	Pxx_eV_cm3_b,Pxy_eV_cm3_b,Pxz_eV_cm3_b,Pyy_eV_cm3_b,Pyz_eV_cm3_b,Pzz_eV_cm3_b			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz	' + action,			$
			'cl,ws	Ti_eV												#			' + action,			$
			'cl,ws	Ex_gse,Ey_gse,Ez_gse										Ex,Ey,Ez		' + action,			$
			'cl,ws	Ex_gsm,Ey_gsm,Ez_gsm										Ex,Ey,Ez		' + action,			$
			'cl,ws	Vxpar_gse_km_sec,Vypar_gse_km_sec,Vzpar_gse_km_sec,*Vpar_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxpar_gsm_km_sec,Vypar_gsm_km_sec,Vzpar_gsm_km_sec,*Vpar_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxper_gse_km_sec,Vyper_gse_km_sec,Vzper_gse_km_sec,*Vper_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxper_gsm_km_sec,Vyper_gsm_km_sec,Vzper_gsm_km_sec,*Vper_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Elx_gse_mV_m,Ely_gse_mV_m,Elz_gse_mV_m,*El_gse_mV_m						Elx,Ely,Elz,|El|	' + action,			$
			'cl,ws	Elx_gsm_mV_m,Ely_gsm_mV_m,Elz_gsm_mV_m,*El_gse_mV_m						Elx,Ely,Elz,|El|	' + action,			$
			'cl,ws	Pp_nPa												#			' + action,			$
			'cl,ws	Pm_nPa												#			' + action,			$
			'cl,ws	Beta												#			' + action,			$
			'cl,ws	Vxalfven_gse_km_sec,Vyalfven_gse_km_sec,Vzalfven_gse_km_sec,*Valfven_km_sec			Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxalfven_gsm_km_sec,Vyalfven_gsm_km_sec,Vzalfven_gsm_km_sec,*Valfven_km_sec			Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	An												#			' + action,			$
			'cl,ws	Ng												#			' + action,			$
			'cl,ws	Bx_gse_nT,By_gse_nT,Bz_gse_nT									Bx,By,Bz		' + action,			$
			'cl,ws	Bx_gsm_nT,By_gsm_nT,Bz_gsm_nT									Bx,By,Bz		' + action			]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':HIA:3DMOMENTS_HIGHG_H1">6 3D moments high G H+', 'CIS-HIA', [6,7,15,17,21,23,30,32], SC, tab, NAME3+'_HIA_3DMOMENTS_HIGHG_H1',  'cluster_hia cluster_oth', /moments

		action = 'count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No'
		tab = [	'cl,ws	N_cm3												#  			' + action + ' yleft_log=Log',	$
			'cl,ws	Vx_gse_km_sec,Vy_gse_km_sec,Vz_gse_km_sec,*V_km_sec						Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vx_gsm_km_sec,Vy_gsm_km_sec,Vz_gsm_km_sec,*V_km_sec						Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Ppar_eV_cm3											#			' + action,			$
			'cl,ws	Pper1_eV_cm3											#			' + action,			$
			'cl,ws	Pper2_eV_cm3											#			' + action,			$
			'cl,ws	Qx_gse_erg_sec_cm2,Qy_gse_erg_sec_cm2,Qz_gse_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Qx_gsm_erg_sec_cm2,Qy_gsm_erg_sec_cm2,Qz_gsm_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,*Qpar_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,*Qper_erg_sec_cm2				Qx,Qy,Qz,|Q|		' + action,			$
			'cl,ws	Pxx_eV_cm3_gse,Pxy_eV_cm3_gse,Pxz_eV_cm3_gse,Pyy_eV_cm3_gse,Pyz_eV_cm3_gse,Pzz_eV_cm3_gse	Pxx,Pxy,Pxz,Pyy,Pyz,Pzz	' + action,			$
			'cl,ws	Pxx_eV_cm3_b,Pxy_eV_cm3_b,Pxz_eV_cm3_b,Pyy_eV_cm3_b,Pyz_eV_cm3_b,Pzz_eV_cm3_b			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz	' + action,			$
			'cl,ws	Ti_eV												#			' + action,			$
			'cl,ws	Ex_gse,Ey_gse,Ez_gse										Ex,Ey,Ez		' + action,			$
			'cl,ws	Ex_gsm,Ey_gsm,Ez_gsm										Ex,Ey,Ez		' + action,			$
			'cl,ws	Vxpar_gse_km_sec,Vypar_gse_km_sec,Vzpar_gse_km_sec,*Vpar_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxpar_gsm_km_sec,Vypar_gsm_km_sec,Vzpar_gsm_km_sec,*Vpar_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxper_gse_km_sec,Vyper_gse_km_sec,Vzper_gse_km_sec,*Vper_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxper_gsm_km_sec,Vyper_gsm_km_sec,Vzper_gsm_km_sec,*Vper_gse_km_sec				Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Elx_gse_mV_m,Ely_gse_mV_m,Elz_gse_mV_m,*El_gse_mV_m						Elx,Ely,Elz,|El|	' + action,			$
			'cl,ws	Elx_gsm_mV_m,Ely_gsm_mV_m,Elz_gsm_mV_m,*El_gse_mV_m						Elx,Ely,Elz,|El|	' + action,			$
			'cl,ws	Pp_nPa												#			' + action,			$
			'cl,ws	Pm_nPa												#			' + action,			$
			'cl,ws	Beta												#			' + action,			$
			'cl,ws	Vxalfven_gse_km_sec,Vyalfven_gse_km_sec,Vzalfven_gse_km_sec,*Valfven_km_sec			Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	Vxalfven_gsm_km_sec,Vyalfven_gsm_km_sec,Vzalfven_gsm_km_sec,*Valfven_km_sec			Vx,Vy,Vz,|V|		' + action,			$
			'cl,ws	An												#			' + action,			$
			'cl,ws	Ng												#			' + action,			$
			'cl,ws	Bx_gse_nT,By_gse_nT,Bz_gse_nT									Bx,By,Bz		' + action,			$
			'cl,ws	Bx_gsm_nT,By_gsm_nT,Bz_gsm_nT									Bx,By,Bz		' + action			]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':HIA:3DMOMENTS_LOWG_H1">6 3D moments low g H+', 'CIS-HIA', [8,22,24,31], SC, tab, NAME3+'_HIA_3DMOMENTS_LOWG_H1',  'cluster_hia cluster_oth', /moments

		; Spectro pour webservice
		info1 = [								$
			{ noproduit:6,	nomproduit:'HIGHG_P06_3D_088A_31E' 	},	$
			{ noproduit:7,	nomproduit:'HIGHG_P07_3D_042A_31E' 	},	$
			{ noproduit:9,	nomproduit:'HIGHG_P09_1D_001A_62E' 	},	$
			{ noproduit:10,	nomproduit:'HIGHG_P10_2D_016A_31E' 	},	$
			{ noproduit:11,	nomproduit:'HIGHG_P11_2D_016A_31E' 	},	$
			{ noproduit:15,	nomproduit:'HIGHG_P15_3D_088A_16E' 	},	$
			{ noproduit:17,	nomproduit:'HIGHG_P17_3D_088A_62E' 	},	$
			{ noproduit:18,	nomproduit:'HIGHG_P18_1D_001A_31E' 	},	$
			{ noproduit:21,	nomproduit:'HIGHG_P21_3D_128A_31E' 	},	$
			{ noproduit:23,	nomproduit:'HIGHG_P23_3D_128A_31E' 	},	$
			{ noproduit:32,	nomproduit:'HIGHG_P32_3D_088A_31E' 	},	$
			{ noproduit:8,	nomproduit:'LOWG_P08_3D_064A_31E' 	},	$
			{ noproduit:13,	nomproduit:'LOWG_P13_2D_008A_31E' 	},	$
			{ noproduit:14,	nomproduit:'LOWG_P14_2D_008A_31E' 	},	$
			{ noproduit:22,	nomproduit:'LOWG_P22_3D_128A_31E' 	},	$
			{ noproduit:24,	nomproduit:'LOWG_P24_3D_064A_31E' 	}	]

		FOR i=0L,N_ELEMENTS(info1)-1 DO BEGIN
			tab = [	'ws	1d_data 		# count3d type=time_energy cjf=c/s  yleft_auto=Manual yleft_min=10 yleft_max=40000 z_showdir=No z_theta=No z_phi=No',	$
				'ws	1d_data 		# count3d type=time_energy cjf=flux yleft_auto=Manual yleft_min=10 yleft_max=40000 z_showdir=No z_theta=No z_phi=No',	$
				'ws	1d_data 		# count3d type=time_energy cjf=JE   yleft_auto=Manual yleft_min=10 yleft_max=40000 z_showdir=No z_theta=No z_phi=No'	]
			ajouter_dataset, arbre, '<dataset id="'+NAME2+':HIA:'+info1[i].nomproduit+'_SPECTRO_TIME_ENERGY" visibility="ws">5 '+info1[i].nomproduit+' Spectrogram Time Energy', 'CIS-HIA', info1[i].noproduit, 'SC1', tab, NAME3+'_HIA_'+info1[i].nomproduit+'_SPECTRO_TIME_ENERGY', 'cluster_hia', /spectro
		END

		arbre = [ arbre,	$
			'5 Particle spectrogram',													$
			'6 high G H+ ' + info_bulle_HIA_high,													$
				'0 Time Energy JE#          CIS-HIA P6,P7,P9,P10,P11,P15,P17,P18,P21,P23,P30,P32,P40 '+SC+' JE count3d type=time_energy cjf=JE yleft_auto=Manual yleft_min=10 yleft_max=40000 z_showdir=No z_theta=No z_phi=No',		$
				'0 Time Theta JE#           CIS-HIA P6,P7,P9,P10,P11,P15,P17,P18,P21,P23,P30,P32     '+SC+' JE count3d type=time_theta cjf=JE emin_nochamp=10 emax_nochamp=40000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',		$
				'0 Time Phi JE#             CIS-HIA P6,P7,P9,P10,P11,P15,P17,P18,P21,P23,P30,P32     '+SC+' JE count3d type=time_phi cjf=JE emin_nochamp=10 emax_nochamp=40000 yleft_auto=Manual yleft_min=-180 yleft_max=180 z_showdir=No z_theta=No z_phi=No',		$
				'0 Time Pitchangle JE#      CIS-HIA P6,P7,P15,P17,P21,P23,P30,P32                    '+SC+' JE count3d type=time_pitchangle cjf=JE emin_nochamp=10 emax_nochamp=40000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
				'0 Energy Pitchangle JE#    CIS-HIA P6,P7,P15,P17,P21,P23,P30,P32                    '+SC+' JE count3d type=energy_pitchangle cjf=JE z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',									$
				'0 Phi Theta JE#            CIS-HIA P6,P7,P15,P17,P21,P23,P30,P32                    '+SC+' JE count3d type=phi_theta cjf=JE emin_nochamp=10 emax_nochamp=40000 yleft_auto=Automatic x_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
				'0 Distribution Function JE#CIS-HIA P6,P7,P15,P17,P21,P23,P30,P32                    '+SC+' JE count3d type=Distribution'+STRING(2b)+'Function log0use=Yes cjf=JE interp_nochamp=TRIGRID yleft_auto=Automatic x_auto=Automatic z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',	$
			'6 low g H+ ' + info_bulle_HIA_low,													$
				'0 Time Energy JE#          CIS-HIA P8,P13,P14,P22,P24,P31,P41 '+SC+' JE count3d type=time_energy cjf=JE yleft_auto=Manual yleft_min=10 yleft_max=40000 z_showdir=No z_theta=No z_phi=No',		$
				'0 Time Theta JE#           CIS-HIA P8,P13,P14,P22,P24,P31     '+SC+' JE count3d type=time_theta cjf=JE emin_nochamp=10 emax_nochamp=40000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',		$
				'0 Time Phi JE#             CIS-HIA P8,P13,P14,P22,P24,P31     '+SC+' JE count3d type=time_phi cjf=JE emin_nochamp=10 emax_nochamp=40000 yleft_auto=Manual yleft_min=-180 yleft_max=180 z_showdir=No z_theta=No z_phi=No',		$
				'0 Time Pitchangle JE#      CIS-HIA P8,P22,P24,P31             '+SC+' JE count3d type=time_pitchangle cjf=JE emin_nochamp=10 emax_nochamp=40000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
				'0 Energy Pitchangle JE#    CIS-HIA P8,P22,P24,P31             '+SC+' JE count3d type=energy_pitchangle cjf=JE z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',									$
				'0 Phi Theta JE#            CIS-HIA P8,P22,P24,P31             '+SC+' JE count3d type=phi_theta cjf=JE emin_nochamp=10 emax_nochamp=40000 yleft_auto=Automatic x_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
				'0 Distribution Function JE#CIS-HIA P8,P22,P24,P31             '+SC+' JE count3d type=Distribution'+STRING(2b)+'Function log0use=Yes cjf=JE interp_nochamp=TRIGRID yleft_auto=Automatic x_auto=Automatic z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',	$
			'5 Particle plot',													$
			'6 high G H+ ' + info_bulle_HIA_high,													$
				'0 Time JE# 			CIS-HIA P6,P7,P9,P10,P11,P15,P17,P18,P21,P23,P30,P32,P40 '+SC+' JE  count2d type=time_cjf   cjf=JE emin_nochamp=10 emax_nochamp=40000 legend_theta=No legend_phi=No',	$
				'0 Energy JE#			CIS-HIA P6,P7,P15,P17,P21,P23,P30,P32,P40                '+SC+' JE  count2d type=energy_cjf cjf=JE emin_nochamp=10 emax_nochamp=40000 legend_theta=No legend_phi=No',	$
				'0 Pitchangle c/s#		CIS-HIA P6,P7,P15,P17,P21,P23,P30,P32                    '+SC+' c/s count2d type=pitch_cjf  cjf=c/s legend_theta=No legend_phi=No',	$
			'6 low g H+ ' + info_bulle_HIA_low,													$
				'0 Time JE#			CIS-HIA P8,P13,P14,P22,P24,P31,P41 '+SC+' JE  count2d type=time_cjf   cjf=JE emin_nochamp=10 emax_nochamp=40000 legend_theta=No legend_phi=No',	$
				'0 Energy JE#			CIS-HIA P8,P22,P24,P31,P41         '+SC+' JE  count2d type=energy_cjf cjf=JE emin_nochamp=10 emax_nochamp=40000 legend_theta=No legend_phi=No',	$
				'0 Pitchangle c/s#		CIS-HIA P8,P22,P24,P31             '+SC+' c/s count2d type=pitch_cjf  cjf=c/s legend_theta=No legend_phi=No'	$

		]

		arbre = [ arbre, '</instrument>' ]

	END

		; moments CDF: mmes donnes que dans les fichiers binaires
		;'5 CDF file',														$
		;	'0 Density H+#CIS-OTH P4 '+SC+' NH1_HIA_cm3 header yleft_log=Log',							$
		;	'0 Velocity GSE H+#CIS-OTH P4 '+SC+' Vx_H1_HIA_GSE_km_sec,Vy_H1_HIA_GSE_km_sec,Vz_H1_HIA_GSE_km_sec header',	$
		;	'0 Tpar Tper H+#CIS-OTH P4 '+SC+' TparH1_HIA_MK,TperH1_HIA_MK header',						$

		; Ne pas mettre EFW car je n'ai que quelques jours de donnes
		;'3 EFW',														$
		;	'0 E_dusk#CIS-OTH P6 '+SC+' E_dusk header'										$

	arbre = [ arbre, $
		'4 PEACE',													$
		'5 Particle spectrogram',													$
		'6 HEEA electron ' + get_cldataset_starttime_endtime('CLUSTER-PEACE',0,SC) + ' (Aug/Sep/Oct only)',													$
			'0 Time Energy JE#          CLUSTER-PEACE P0 '+SC+' JE count3d cjf=JE type=time_energy yleft_auto=Manual yleft_min=10 yleft_max=40000 z_showdir=No z_theta=No z_phi=No',		$
			'0 Time Theta JE#           CLUSTER-PEACE P0 '+SC+' JE count3d cjf=JE type=time_theta emin_nochamp=10 emax_nochamp=40000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',		$
			'0 Time Phi JE#             CLUSTER-PEACE P0 '+SC+' JE count3d cjf=JE type=time_phi emin_nochamp=10 emax_nochamp=40000 yleft_auto=Manual yleft_min=-180 yleft_max=180 z_showdir=No z_theta=No z_phi=No',		$
			'0 Time Pitchangle JE#      CLUSTER-PEACE P0 '+SC+' JE count3d cjf=JE type=time_pitchangle emin_nochamp=10 emax_nochamp=40000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
			'0 Energy Pitchangle JE#    CLUSTER-PEACE P0 '+SC+' JE count3d type=energy_pitchangle cjf=JE z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',									$
			'0 Phi Theta JE#            CLUSTER-PEACE P0 '+SC+' JE count3d cjf=JE type=phi_theta emin_nochamp=10 emax_nochamp=40000 yleft_auto=Automatic x_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
			'0 Distribution Function JE#CLUSTER-PEACE P0 '+SC+' JE count3d cjf=JE type=Distribution'+STRING(2b)+'Function log0use=No interp_nochamp=None yleft_auto=No yleft_min=-100000 yleft_max=100000 x_auto=No x_min=-100000 x_max=100000 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',	$
		'6 LEEA electron ' + get_cldataset_starttime_endtime('CLUSTER-PEACE',1,SC) + ' (Aug/Sep/Oct only)',													$
			'0 Time Energy JE#          CLUSTER-PEACE P1 '+SC+' JE count3d type=time_energy cjf=JE yleft_auto=Manual yleft_min=1 yleft_max=1000 z_showdir=No z_theta=No z_phi=No',		$
			'0 Time Theta JE#           CLUSTER-PEACE P1 '+SC+' JE count3d cjf=JE type=time_theta emin_nochamp=1 emax_nochamp=1000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',		$
			'0 Time Phi JE#             CLUSTER-PEACE P1 '+SC+' JE count3d cjf=JE type=time_phi emin_nochamp=1 emax_nochamp=1000 yleft_auto=Manual yleft_min=-180 yleft_max=180 z_showdir=No z_theta=No z_phi=No',		$
			'0 Time Pitchangle JE#      CLUSTER-PEACE P1 '+SC+' JE count3d cjf=JE type=time_pitchangle emin_nochamp=1 emax_nochamp=1000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
			'0 Energy Pitchangle JE#    CLUSTER-PEACE P1 '+SC+' JE count3d type=energy_pitchangle cjf=JE z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',									$
			'0 Phi Theta JE#            CLUSTER-PEACE P1 '+SC+' JE count3d cjf=JE type=phi_theta emin_nochamp=1 emax_nochamp=1000 yleft_auto=Automatic x_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
			'0 Distribution Function JE#CLUSTER-PEACE P1 '+SC+' JE count3d cjf=JE type=Distribution'+STRING(2b)+'Function log0use=No interp_nochamp=None yleft_auto=No yleft_min=-30000 yleft_max=30000 x_auto=No x_min=-30000 x_max=30000 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',	$
		'5 Particle plot',													$
		'6 HHEA electron ' + get_cldataset_starttime_endtime('CLUSTER-PEACE',0,SC) + ' (Aug/Sep/Oct only)',													$
			'0 Time JE#			CLUSTER-PEACE P0 '+SC+' JE  count2d cjf=JE type=time_cjf   emin_nochamp=10 emax_nochamp=40000 legend_theta=No legend_phi=No',	$
			'0 Energy JE#			CLUSTER-PEACE P0 '+SC+' JE  count2d cjf=JE type=energy_cjf x_auto=No x_min=10 x_max=40000 legend_theta=No legend_phi=No',	$
			'0 Pitchangle c/s#		CLUSTER-PEACE P0 '+SC+' c/s count2d type=pitch_cjf  cjf=c/s legend_theta=No legend_phi=No',	$
		'6 LEEA electron ' + get_cldataset_starttime_endtime('CLUSTER-PEACE',1,SC) + ' (Aug/Sep/Oct only)',													$
			'0 Time JE#			CLUSTER-PEACE P1 '+SC+' JE  count2d cjf=JE type=time_cjf   emin_nochamp=1 emax_nochamp=1000 legend_theta=No legend_phi=No',	$
			'0 Energy JE#			CLUSTER-PEACE P1 '+SC+' JE  count2d cjf=JE type=energy_cjf x_auto=No x_min=1 x_max=1000 legend_theta=No legend_phi=No',	$
			'0 Pitchangle c/s#		CLUSTER-PEACE P1 '+SC+' c/s count2d type=pitch_cjf  cjf=c/s legend_theta=No legend_phi=No'	$
	]

	arbre = [ arbre, 											$
		'4 Current ' + get_cldataset_starttime_endtime('CIS-OTH',5,SC),											$
			'0 Jx,Jy,Jz,J GSE#CIS-OTH P5 '+SC+' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 current'	$
	]

	IF codif THEN BEGIN
		arbre = [ arbre,							$
			'4 OH ' + get_cldataset_starttime_endtime('CIS-OTH',5,SC),								$
				'0 BetaTOT,Blobe#CIS-OTH P5 '+SC+' BetaTOT,Blobe oh'	$
		]
	END

	arbre = [ arbre, 												$
		'4 Housekeeping ' + get_cldataset_starttime_endtime('CIS-OTH',8,SC),											$
			'0 CODIF Post Acc HV status     (ECCHACCS)#	CIS-OTH P8 '+SC+' ECCHACCS header yleft_typetitle=Wording',	$
			'0 CODIF Analyser HV status     (ECCHANLS)#	CIS-OTH P8 '+SC+' ECCHANLS header yleft_typetitle=Wording',	$
			'0 CODIF MCP HV status          (ECCHMCPS)#	CIS-OTH P8 '+SC+' ECCHMCPS header yleft_typetitle=Wording',	$
			'0 CODIF Cover status           (ECCACVRS)#	CIS-OTH P8 '+SC+' ECCACVRS header yleft_typetitle=Wording',	$
			'0 HIA Power status             (ECL2PWRS)#	CIS-OTH P8 '+SC+' ECL2PWRS header yleft_typetitle=Wording',	$
			'0 HIA Amplifier test status    (ECHATSTS)#	CIS-OTH P8 '+SC+' ECHATSTS header yleft_typetitle=Wording',	$
			'0 HIA Analyser HV status       (ECHHANLS)#	CIS-OTH P8 '+SC+' ECHHANLS header yleft_typetitle=Wording',	$
			'0 HIA MCP HC status            (ECHHMCPS)#	CIS-OTH P8 '+SC+' ECHHMCPS header yleft_typetitle=Wording',	$
			'0 CODIF -5 V monitor           (ECCAVN5)#	CIS-OTH P8 '+SC+' ECCAVN5  header yleft_typetitle=Wording',	$
			'0 CODIF +5 V monitor           (ECCAVP5)#	CIS-OTH P8 '+SC+' ECCAVP5  header yleft_typetitle=Wording',	$
			'0 CODIF +12 V monitor          (ECCAVP12)#	CIS-OTH P8 '+SC+' ECCAVP12 header yleft_typetitle=Wording',	$
			'0 Scratch Mem. volt.           (ECCAVSCR)#	CIS-OTH P8 '+SC+' ECCAVSCR header yleft_typetitle=Wording',	$
			'0 CODIF Acc. HV current        (ECCHIACC)#	CIS-OTH P8 '+SC+' ECCHIACC header yleft_typetitle=Wording',	$
			'0 CODIF Step HV on 28V primary (ECCHIANL)#	CIS-OTH P8 '+SC+' ECCHIANL header yleft_typetitle=Wording',	$
			'0 CODIF Step HV diode current  (ECCHID)#	CIS-OTH P8 '+SC+' ECCHID   header yleft_typetitle=Wording',	$
			'0 CODIF MCP HV current         (ECCHIMCP)#	CIS-OTH P8 '+SC+' ECCHIMCP header yleft_typetitle=Wording',	$
			'0 CODIF Acc. HV                (ECCHVACC)#	CIS-OTH P8 '+SC+' ECCHVACC header yleft_typetitle=Wording',	$
			'0 CODIF maximum Step HV value  (ECCHVANL)#	CIS-OTH P8 '+SC+' ECCHVANL header yleft_typetitle=Wording',	$
			'0 CODIF MCP HV monitor         (ECCHVMCP)#	CIS-OTH P8 '+SC+' ECCHVMCP header yleft_typetitle=Wording',	$
			'0 RPA -100 V deflector voltage (ECCRN100)#	CIS-OTH P8 '+SC+' ECCRN100 header yleft_typetitle=Wording',	$
			'0 RPA -153 V deflector voltage (ECCRN153)#	CIS-OTH P8 '+SC+' ECCRN153 header yleft_typetitle=Wording',	$
			'0 RPA -247 V deflector voltage (ECCRN247)#	CIS-OTH P8 '+SC+' ECCRN247 header yleft_typetitle=Wording',	$
			'0 RPA +200 V deflector voltage (ECCRP220)#	CIS-OTH P8 '+SC+' ECCRP220 header yleft_typetitle=Wording',	$
			'0 RPA out voltage              (ECCRVOUT)#	CIS-OTH P8 '+SC+' ECCRVOUT header yleft_typetitle=Wording',	$
			'0 CIS1 analog temperature      (ECCTANL)#	CIS-OTH P8 '+SC+' ECCTANL  header yleft_typetitle=Wording',	$
			'0 CODIF electronic temperature (ECCTELEC)#	CIS-OTH P8 '+SC+' ECCTELEC header yleft_typetitle=Wording',	$
			'0 HIA Discri level 1           (ECHADIS1)#	CIS-OTH P8 '+SC+' ECHADIS1 header yleft_typetitle=Wording',	$
			'0 HIA Discri level 2           (ECHADIS2)#	CIS-OTH P8 '+SC+' ECHADIS2 header yleft_typetitle=Wording',	$
			'0 HIA Step HV on 28V primary   (ECHHIANL)#	CIS-OTH P8 '+SC+' ECHHIANL header yleft_typetitle=Wording',	$
			'0 HIA Step HV diode current    (ECHHID)#	CIS-OTH P8 '+SC+' ECHHID   header yleft_typetitle=Wording',	$
			'0 HIA MCP HV on 28V primary    (ECHHIMCP)#	CIS-OTH P8 '+SC+' ECHHIMCP header yleft_typetitle=Wording',	$
			'0 HIA Maximum step HV          (ECHHVANL)#	CIS-OTH P8 '+SC+' ECHHVANL header yleft_typetitle=Wording',	$
			'0 HIA MCP high voltage control (ECHHVMI)#	CIS-OTH P8 '+SC+' ECHHVMI  header yleft_typetitle=Wording',	$
			'0 HIA MCP high voltage actual  (ECHHVMO)#	CIS-OTH P8 '+SC+' ECHHVMO  header yleft_typetitle=Wording',	$
			'0 CIS2 electronic temperature  (ECHTELEC)#	CIS-OTH P8 '+SC+' ECHTELEC header yleft_typetitle=Wording',	$
			'0 Total CIS1 Current           (ECL1ITOT)#	CIS-OTH P8 '+SC+' ECL1ITOT header yleft_typetitle=Wording',	$
			'0 CIS1 -5 V                    (ECL1VN5)#	CIS-OTH P8 '+SC+' ECL1VN5  header yleft_typetitle=Wording',	$
			'0 CIS1 +5 V                    (ECL1VP5)#	CIS-OTH P8 '+SC+' ECL1VP5  header yleft_typetitle=Wording',	$
			'0 CIS1 -12 V                   (ECL1VN12)#	CIS-OTH P8 '+SC+' ECL1VN12 header yleft_typetitle=Wording',	$
			'0 CIS1 +12 V                   (ECL1VP12)#	CIS-OTH P8 '+SC+' ECL1VP12 header yleft_typetitle=Wording',	$
			'0 Total CIS2 Current           (ECL2ITOT)#	CIS-OTH P8 '+SC+' ECL2ITOT header yleft_typetitle=Wording',	$
			'0 CIS2 +5 V monitor            (ECL2VP5)#	CIS-OTH P8 '+SC+' ECL2VP5  header yleft_typetitle=Wording',	$
			'0 CIS2 -12 V monitor           (ECL2VN12)#	CIS-OTH P8 '+SC+' ECL2VN12 header yleft_typetitle=Wording',	$
			'0 CIS2 +12 V monitor           (ECL2VP12)#	CIS-OTH P8 '+SC+' ECL2VP12 header yleft_typetitle=Wording'	$
	]

	arbre = [ arbre, '</mission>' ]

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_ace
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL de ACE.
;-------------------------------------------------------------------------------
;
; Trouv dans spase://SMWG/Observatory/ACE
;
; <ObservatoryRegion>Heliosphere.NearEarth</ObservatoryRegion>
; <ObservatoryRegion>Heliosphere.Inner</ObservatoryRegion>
;

	create_products, 'ACE'

	target  = "Heliosphere.NearEarth"			; E. Penou
	targets = "Heliosphere.NearEarth Heliosphere.Inner"	; spase

	arbre = [																	$
		'<mission name="ACE" id="ACE" target="'+target+'" targets="'+targets+'">2 ACE',								$
		'<instrument name="ephemeris" id="ACE:ephemeris">3 ephemeris'										]

	; ephemeris H0_SWE
	tab = [	'cl	X_gse_km,Y_gse_km,Z_gse_km           x,y,z  orbito',										$
		'cl,ws	X_gse_km,Y_gse_km,Z_gse_km           x,y,z  header',										$
		'cl,ws	X_gsm_km,Y_gsm_km,Z_gsm_km           x,y,z  header'										]
	ajouter_dataset, arbre, '<dataset id="ACE:EPHEMERIS:ORBIT_H0_SWE">4 orbit from H0_SWE', 'ACE', 5, 'SC1', tab, 'AC_EPHEMERIS_ORBIT_H0_SWE', 'ace'

	; ephemeris 1H_LOC
	tab = [	'cl	X_GSE_Rt,Y_GSE_Rt,Z_GSE_Rt           x,y,z  orbito',										$
		'cl,ws	X_GSE_Rt,Y_GSE_Rt,Z_GSE_Rt           x,y,z  header'										]
	ajouter_dataset, arbre, '<dataset id="ACE:EPHEMERIS:ORBIT_1H_LOC">4 orbit from 1H_LOC', 'ACE', 14, 'SC1', tab, 'AC_EPHEMERIS_ORBIT_1H_LOC', 'ace'

	; ephemeris H0_MFI
	tab = [	'cl	SC_Xpos_GSE,SC_Ypos_GSE,SC_Zpos_GSE           x,y,z  orbito',									$
		'cl,ws	SC_Xpos_GSE,SC_Ypos_GSE,SC_Zpos_GSE           x,y,z  header',									$
		'cl,ws	SC_Xpos_GSM,SC_Ypos_GSM,SC_Zpos_GSM           x,y,z  header'									]
	ajouter_dataset, arbre, '<dataset id="ACE:EPHEMERIS:ORBIT_H0_MFI">4 orbit from H0_MFI', 'ACE', 16, 'SC1', tab, 'AC_EPHEMERIS_ORBIT_H0_MFI', 'ace'

	arbre = [ arbre,									$
		'3 EPAM',									$
		'4 5mn resolution (K0) ' + get_cldataset_starttime_endtime('ACE',1,'SC1'),	$
			'0 Proton Flux 0.48-0.97 Mev#  ACE P1 SC1 H_lo header',			$
			'0 Ion Flux 47-65 keV#		ACE P1 SC1 Ion_very_lo header',										$
			'0 Ion Flux 112-187 keV#	ACE P1 SC1 Ion_lo header',											$
			'0 Ion Flux 310-580 keV#	ACE P1 SC1 Ion_mid header',											$
			'0 Ion Flux 1060-1910 keV#	ACE P1 SC1 Ion_hi header',											$
			'0 Electron Flux 38-53 keV#	ACE P1 SC1 Electron_lo header',											$
			'0 Electron Flux 175-315 keV#	ACE P1 SC1 Electron_hi header',											$
		'4 5mn resolution (L2) ' + get_cldataset_starttime_endtime('ACE',8,'SC1'),																$
			'0 Differential electron flux 38-53 keV#	ACE P8 SC1 Differential_electron_flux_038_053_keV_p_cm2_s_ster_Mev header',			$
			'0 Differential electron flux 175-315 keV#	ACE P8 SC1 Differential_electron_flux_175_315_keV_p_cm2_s_ster_Mev header',			$
			'0 Differential proton flux 47-68 keV#		ACE P8 SC1 Differential_proton_flux_0047_0068_keV_p_cm2_s_ster_Mev header',			$
			'0 Differential proton flux 115-195 keV#	ACE P8 SC1 Differential_proton_flux_0115_0195_keV_p_cm2_s_ster_Mev header',			$
			'0 Differential proton flux 310-580 keV#	ACE P8 SC1 Differential_proton_flux_0310_0580_keV_p_cm2_s_ster_Mev header',			$
			'0 Differential proton flux 761-1220 keV#	ACE P8 SC1 Differential_proton_flux_0761_1220_keV_p_cm2_s_ster_Mev header',			$
			'0 Differential proton flux 1060-1900 keV#	ACE P8 SC1 Differential_proton_flux_1060_1900_keV_p_cm2_s_ster_Mev header',			$
			'0 Anisotropy index#				ACE P8 SC1 Anisotropy_index header',								$
		'4 1hour resolution (L2) ' + get_cldataset_starttime_endtime('ACE',9,'SC1'),																$
			'0 Differential electron flux 38-53 keV#	ACE P9 SC1 Differential_electron_flux_038_053_keV_p_cm2_s_ster_Mev header',			$
			'0 Differential electron flux 175-315 keV#	ACE P9 SC1 Differential_electron_flux_175_315_keV_p_cm2_s_ster_Mev header',			$
			'0 Differential proton flux 47-68 keV#		ACE P9 SC1 Differential_proton_flux_0047_0068_keV_p_cm2_s_ster_Mev header',			$
			'0 Differential proton flux 115-195 keV#	ACE P9 SC1 Differential_proton_flux_0115_0195_keV_p_cm2_s_ster_Mev header',			$
			'0 Differential proton flux 310-580 keV#	ACE P9 SC1 Differential_proton_flux_0310_0580_keV_p_cm2_s_ster_Mev header',			$
			'0 Differential proton flux 761-1220 keV#	ACE P9 SC1 Differential_proton_flux_0761_1220_keV_p_cm2_s_ster_Mev header',			$
			'0 Differential proton flux 1060-1900 keV#	ACE P9 SC1 Differential_proton_flux_1060_1900_keV_p_cm2_s_ster_Mev header',			$
			'0 Anisotropy index#				ACE P9 SC1 Anisotropy_index header',								$

		'3 MAG',											$
		'4 1sec resolution (H3 CDF) ' + get_cldataset_starttime_endtime('ACE',17,'SC1'),									$
			'0 Bx,By,Bz in RTN#	ACE P17 SC1 Bx_rtn_nT,By_rtn_nT,Bz_rtn_nT header',		$
			'0 Bx,By,Bz in GSE#	ACE P17 SC1 Bx_gse_nT,By_gse_nT,Bz_gse_nT header',		$
			'0 Bx,By,Bz in GSM#	ACE P17 SC1 Bx_gsm_nT,By_gsm_nT,Bz_gsm_nT header',		$
		'4 16sec resolution (H0 CDF) ' + get_cldataset_starttime_endtime('ACE',16,'SC1'),									$
			'0 Bx,By,Bz in GSE#	ACE P16 SC1 Bx_gse_nT,By_gse_nT,Bz_gse_nT header',		$
			'0 Bx,By,Bz in GSM#	ACE P16 SC1 Bx_gsm_nT,By_gsm_nT,Bz_gsm_nT header',		$
		'4 16sec resolution (K1 CDF) ' + get_cldataset_starttime_endtime('ACE',2,'SC1'),									$
			'0 Bx,By,Bz,B in GSE#	ACE P2 SC1 Bx_gse_nT,By_gse_nT,Bz_gse_nT,B_nT header',		$
			'0 Bx,By,Bz,B in GSM#	ACE P2 SC1 Bx_gsm_nT,By_gsm_nT,Bz_gsm_nT,B_nT header',		$
		'4 1mn resolution (L2) ' + get_cldataset_starttime_endtime('ACE',12,'SC1'),									$
			'0 Bx,By,Bz,B in GSM#	ACE P12 SC1 Bx_GSM_nT,By_GSM_nT,Bz_GSM_nT,B_GSM_nT header',	$
		'4 1h resolution (L2) ' + get_cldataset_starttime_endtime('ACE',13,'SC1'),										$
			'0 Bx,By,Bz,B in GSM#	ACE P13 SC1 Bx_GSM_nT,By_GSM_nT,Bz_GSM_nT,B_GSM_nT header',	$

		'3 SIS',													$
		'4 5mn resolution (L2) ' + get_cldataset_starttime_endtime('ACE',6,'SC1'),											$
			'0 Integral Proton Flux > 10 MeV #	ACE P6 SC1 IPF_sup10Mev_p_cs2_sec_ster header',			$
			'0 Integral Proton Flux > 30 MeV #	ACE P6 SC1 IPF_sup30Mev_p_cs2_sec_ster header',			$
		'4 1hour resolution (L2) ' + get_cldataset_starttime_endtime('ACE',7,'SC1'),											$
			'0 Integral Proton Flux > 10 MeV #	ACE P7 SC1 IPF_sup10Mev_p_cs2_sec_ster header',			$
			'0 Integral Proton Flux > 30 MeV #	ACE P7 SC1 IPF_sup30Mev_p_cs2_sec_ster header',			$
		'4 1hour resolution (K0 CDF) ' + get_cldataset_starttime_endtime('ACE',3,'SC1'),											$
			'0 Proton Flux (E>10 MeV)#		ACE P3 SC1 H_lo header',							$
			'0 Proton Flux (E>30 MeV)#		ACE P3 SC1 H_hi header',							$
			'0 CNO Flux (7-10 MeV/n)# 		ACE P3 SC1 CNO_lo header',							$
			'0 CNO Flux (10-15 MeV/n)#		ACE P3 SC1 CNO_hi header',							$
			'0 Z>=10 flux (9-21 MeV/n)#		ACE P3 SC1 Z_ge_10 header',							$

		'3 SWEPAM',															$
		'4 1mn resolution (L2) ' + get_cldataset_starttime_endtime('ACE',10,'SC1'),													$
			'0 Proton density#				ACE P10 SC1 Proton_density_p_cc header',				$
			'0 Bulk speed#					ACE P10 SC1 Bulk_speed_km_sec header',					$
			'0 Ion temperature#				ACE P10 SC1 Ion_Temperature_K header',					$
		'4 64sec resolution (H0 CDF) ' + get_cldataset_starttime_endtime('ACE',5,'SC1'),													$
			'0 Proton No. density#				ACE P5 SC1 Np_cm3 header',						$
			'0 Solar Wind Proton Speed#			ACE P5 SC1 Vp_km_sec header',						$
			'0 Proton Temperature#				ACE P5 SC1 Tp_K header',						$
			'0 alpha/proton ratio#				ACE P5 SC1 alpha_ratio header',						$
			'0 Solar Wind X Velocity GSE Vx,Vy,Vz#		ACE P5 SC1 Vx_gse_km_sec,Vy_gse_km_sec,Vz_gse_km_sec header',		$
			'0 Pressure N*M*V*V#				ACE P5 SC1 P_nPa header',						$
		'4 5mn resolution (K0 CDF) ' + get_cldataset_starttime_endtime('ACE',4,'SC1'),													$
			'0 Proton No. density#     			ACE P4 SC1 Np_cm3 header',						$
			'0 Solar Wind Proton Speed#			ACE P4 SC1 Vp_km_sec header',						$
			'0 He Ratio - He++/H+#     			ACE P4 SC1 He_ratio header',						$
			'0 Proton Temperature#     			ACE P4 SC1 Tp_K header',						$
			'0 Pressure N*M*V*V#      			ACE P4 SC1 P_nPa header',						$
		'4 1h resolution (L2) ' + get_cldataset_starttime_endtime('ACE',11,'SC1'),														$
			'0 Proton density#				ACE P11 SC1 Proton_density_p_cc header',				$
			'0 Bulk speed#					ACE P11 SC1 Bulk_speed_km_sec header',					$
			'0 Ion temperature#				ACE P11 SC1 Ion_Temperature_K header',					$

		'4 Particle spectrogram ' + get_cldataset_starttime_endtime('ACE',15,'SC1'),																					$
			'0 Time Pitchangle fdist at 272eV#	ACE P15 SC1 fdist count3d type=time_theta cjf=fdist yleft_auto=Manual yleft_min=0 yleft_max=180 z_zformat_w=5 z_showdir=No z_theta=No z_phi=No',	$
		'4 Particle plot ' + get_cldataset_starttime_endtime('ACE',15,'SC1'),																						$
			'0 Time fdist at 272eV#			ACE P15 SC1 fdist count2d type=time_cjf cjf=fdist legend_theta=No legend_phi=No'							$
	]

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'</mission>' 																$
	]

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_bepi_mmo
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL de BEPI-COLOMBO MMO.
;-------------------------------------------------------------------------------
;
	COMMON COMMON_CL, general

	create_products, 'BEPI'
	create_products, 'MPO'

	p = get(general,'p') ; p[noproduit,nocis,nosat]

	target  = "Heliosphere.NearEarth"			; E. Penou
	targets = "Heliosphere.NearEarth Heliosphere.Inner"	; spase

	arbre = [																	$
		'<mission name="MMO" id="MMO" target="'+target+'" targets="'+targets+'">3 MMO'								]

	nomsat = 'SC1'
	nosat = STRMID(nomsat,2)

	; ---------
	; ephemeris
	; ---------

	arbre = [ arbre, '4 ephemeris']
	nomcis = 'BEPI-EPHEMERIS'

	noproduit = 0
	tab = [	'cl	xvso,yvso,zvso						x,y,z 	orbito',	$
		'cl	xvso,yvso,zvso						x,y,z	header'		]
	ajouter_dataset, arbre, '<dataset id="BEPI:EPHEMERIS:ORBIT">5 orbit', nomcis, noproduit, nomsat, tab, 'BEPI_EPHEMERIS_ORBIT', 'bepi_ephemeris'

	; ---
	; ENA
	; ---

	nom1 = 'ENA'
	nomcis = 'BEPI-' + nom1
	arbre = [ arbre,															$
		'<instrument name="'+nom1+'" id="MMO:'+nom1+'">4 '+nom1										]

		; cnt
		; ---
		noproduit = [0]
		arbre = [ arbre, '5 cnt ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Particle spectrogram" et "Particle plot"
		unite = 'count'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																															$
			'6 Particle spectrogram',																																													$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy spin_average=Yes cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No ',																								$
			'6 Particle plot',																																														$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf spin_average=Yes cjf='+unite+' legend_theta=No legend_phi=No',																											$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																						$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic'																						$
		]

	; --
	; HK
	; --

	nom1 = 'HK'
	nomcis = 'BEPI-' + nom1
	arbre = [ arbre,															$
		'<instrument name="'+nom1+'" id="MMO:'+nom1+'">4 '+nom1										]

		; HK
		; ---
		noproduit = 0
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':HK">5 HK', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_HK', 'bepi'

	; ---
	; MAG
	; ---

	nom1 = 'MAG'
	nomcis = 'BEPI-' + nom1
	arbre = [ arbre,															$
		'<instrument name="'+nom1+'" id="MMO:'+nom1+'">4 '+nom1										]

		; MGFIMS
		; ------
		noproduit = 0
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':MGFIMS">5 MGFIMS', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_MGFIMS', 'bepi'

		; MGFOMS
		; ------
		noproduit = 1
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':MGFOMS">5 MGFOMS', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_MGFOMS', 'bepi'

	FOR nomea=1L,2 DO BEGIN

		nom1 = 'MEA' + val_to_str(nomea)

		nomcis = 'BEPI-' + nom1

		arbre = [ arbre,															$
			'<instrument name="'+nom1+'" id="MMO:'+nom1+'">4 '+nom1										]

		; HSK
		; ---
		noproduit = 0
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':HSK">5 HSK', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_HSK', 'bepi'

		; SYS-HSK
		; -------
		noproduit = 12
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':SYS-HSK">5 SYS-HSK', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_SYS-HSK', 'bepi'

		; VML
		; ---
		noproduit = [1]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':VML">5 VML', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_VML', 'bepi'

		; VMM
		; ---
		noproduit = [2]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':VMM">5 VMM', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_VMM', 'bepi'

		; OMN 16E
		; -------
		noproduit = [3]
		arbre = [ arbre, '5 OMN 16E ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':OMN16E">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_OMN16E', 'bepi', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'count'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																															$
			'6 Particle spectrogram',																																													$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy spin_average=Yes cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No ',																								$
			'6 Particle plot',																																														$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf spin_average=Yes cjf='+unite+' legend_theta=No legend_phi=No',																											$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																						$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic'																						$
		]

		; 2D MOMENTS
		tab = [	'cl	N_cm3												#  				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Scpot_V												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No'	$
		]
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':OMN16E2DMOMENTS">6 2D moments', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_OMN16E2DMOMENTS', 'bepi', /moments, /notime

		; OMN 32E
		; -------
		noproduit = [4]
		arbre = [ arbre, '5 OMN 32E ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':OMN32E">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_OMN32E', 'bepi', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'count'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																															$
			'6 Particle spectrogram',																																													$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy spin_average=Yes cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No ',																								$
			'6 Particle plot',																																														$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf spin_average=Yes cjf='+unite+' legend_theta=No legend_phi=No',																											$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																						$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic'																						$
		]

		; 2D MOMENTS
		tab = [	'cl	N_cm3												#  				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Scpot_V												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No'	$
		]
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':OMN32E2DMOMENTS">6 2D moments', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_OMN32E2DMOMENTS', 'bepi', /moments, /notime

		; OMN 64E
		; -------
		noproduit = [5]
		arbre = [ arbre, '5 OMN 64E ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':OMN64E">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_OMN64E', 'bepi', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'count'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																															$
			'6 Particle spectrogram',																																													$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy spin_average=Yes cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No ',																								$
			'6 Particle plot',																																														$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf spin_average=Yes cjf='+unite+' legend_theta=No legend_phi=No',																											$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																						$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic'																						$
		]

		; 2D MOMENTS
		tab = [	'cl	N_cm3												#  				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Scpot_V												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No'	$
		]
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':OMN64E2DMOMENTS">6 3D moments', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_OMN64E2DMOMENTS', 'bepi', /moments, /notime

		; 3DL
		; ---
		noproduit = [6]
		arbre = [ arbre, '5 3DL ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':3DL">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_3DL', 'bepi', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'count'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																																	$
			'6 Particle spectrogram',																																															$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy                        Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																						$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta                         Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																						$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi                           Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																			$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta                          Bresolution=fgm_brst_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',															$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_brst_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-100000 x_max=100000 yleft_auto=Manual yleft_min=-100000 yleft_max=100000 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=500',	$
			'6 Particle plot',																																																$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf                           Bresolution=fgm_brst_l2 cjf='+unite+' legend_theta=No legend_phi=No',																									$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf                         Bresolution=fgm_brst_l2 cjf='+unite+' x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																					$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf                         Bresolution=fgm_brst_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic'																		$
		]

		; 3D MOMENTS
		tab = [	'cl	N_cm3												#  				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec								Vx,Vy,Vz,|V| 			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3								Ppar,Pper1,Pper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV									Tpar,Tper1,Tper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV									Tpar,Tper1,Tper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2					Qx,Qy,Qz,|Q|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2				Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2				Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3				Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Ei_eV_cm3											#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Ti_eV												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Ex,Ey,Ez											Ex,Ey,Ez			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Vxpar_mmo_km_sec,Vypar_mmo_km_sec,Vzpar_mmo_km_sec,*Vpar_mmo_km_sec				Vx,Vy,Vz,|V|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Vxper_mmo_km_sec,Vyper_mmo_km_sec,Vzper_mmo_km_sec,*Vper_mmo_km_sec				Vx,Vy,Vz,|V|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Elx_mmo_mV_m,Ely_mmo_mV_m,Elz_mmo_mV_m,El_mmo_mV_m						Elx,Ely,Elz,|El|		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Pp_nPa												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Pm_nPa												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Beta												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Vxalfven_mmo_km_sec,Vyalfven_mmo_km_sec,Vzalfven_mmo_km_sec,*Valfven_km_sec			Vx,Vy,Vz,[V|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	An												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Ng												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Bx_nT,By_nT,Bz_nT										Bx,By,Bz			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Scpot_V												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No'	$
		]
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':3DMOMENTS">6 3D moments', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_3DMOMENTS', 'bepi', /moments, /notime

		; 3DM
		; ---
		noproduit = [7]
		arbre = [ arbre, '5 3DM ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':3DM">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_3DM', 'bepi', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'count'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																																	$
			'6 Particle spectrogram',																																															$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy                        Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																						$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta                         Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																						$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi                           Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																			$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta                          Bresolution=fgm_brst_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',															$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_brst_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-100000 x_max=100000 yleft_auto=Manual yleft_min=-100000 yleft_max=100000 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=500',	$
			'6 Particle plot',																																																$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf                           Bresolution=fgm_brst_l2 cjf='+unite+' legend_theta=No legend_phi=No',																									$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf                         Bresolution=fgm_brst_l2 cjf='+unite+' x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																					$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf                         Bresolution=fgm_brst_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic'																		$
		]

		; 3D MOMENTS
		tab = [	'cl	N_cm3												#  				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec								Vx,Vy,Vz,|V| 			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3								Ppar,Pper1,Pper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV									Tpar,Tper1,Tper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV									Tpar,Tper1,Tper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2					Qx,Qy,Qz,|Q|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2				Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2				Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3				Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Ei_eV_cm3											#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Ti_eV												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Ex,Ey,Ez											Ex,Ey,Ez			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Vxpar_mmo_km_sec,Vypar_mmo_km_sec,Vzpar_mmo_km_sec,*Vpar_mmo_km_sec				Vx,Vy,Vz,|V|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Vxper_mmo_km_sec,Vyper_mmo_km_sec,Vzper_mmo_km_sec,*Vper_mmo_km_sec				Vx,Vy,Vz,|V|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Elx_mmo_mV_m,Ely_mmo_mV_m,Elz_mmo_mV_m,El_mmo_mV_m						Elx,Ely,Elz,|El|		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Pp_nPa												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Pm_nPa												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Beta												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Vxalfven_mmo_km_sec,Vyalfven_mmo_km_sec,Vzalfven_mmo_km_sec,*Valfven_km_sec			Vx,Vy,Vz,[V|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	An												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Ng												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Bx_nT,By_nT,Bz_nT										Bx,By,Bz			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Scpot_V												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No'	$
		]
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':3DMOMENTS">6 3D moments', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_3DMOMENTS', 'bepi', /moments, /notime

		; 3DH
		; ---
		noproduit = [8]
		arbre = [ arbre, '5 3DH ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':3DH">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_3DH', 'bepi', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'count'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																																	$
			'6 Particle spectrogram',																																															$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy                        Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																						$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta                         Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																						$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi                           Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																			$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta                          Bresolution=fgm_brst_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',															$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_brst_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-100000 x_max=100000 yleft_auto=Manual yleft_min=-100000 yleft_max=100000 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=500',	$
			'6 Particle plot',																																																$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf                           Bresolution=fgm_brst_l2 cjf='+unite+' legend_theta=No legend_phi=No',																									$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf                         Bresolution=fgm_brst_l2 cjf='+unite+' x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																					$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf                         Bresolution=fgm_brst_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic'																		$
		]

		; 3D MOMENTS
		tab = [	'cl	N_cm3												#  				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec								Vx,Vy,Vz,|V| 			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3								Ppar,Pper1,Pper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV									Tpar,Tper1,Tper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV									Tpar,Tper1,Tper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2					Qx,Qy,Qz,|Q|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2				Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2				Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3				Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Ei_eV_cm3											#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Ti_eV												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Ex,Ey,Ez											Ex,Ey,Ez			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Vxpar_mmo_km_sec,Vypar_mmo_km_sec,Vzpar_mmo_km_sec,*Vpar_mmo_km_sec				Vx,Vy,Vz,|V|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Vxper_mmo_km_sec,Vyper_mmo_km_sec,Vzper_mmo_km_sec,*Vper_mmo_km_sec				Vx,Vy,Vz,|V|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Elx_mmo_mV_m,Ely_mmo_mV_m,Elz_mmo_mV_m,El_mmo_mV_m						Elx,Ely,Elz,|El|		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Pp_nPa												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Pm_nPa												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Beta												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Vxalfven_mmo_km_sec,Vyalfven_mmo_km_sec,Vzalfven_mmo_km_sec,*Valfven_km_sec			Vx,Vy,Vz,[V|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	An												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Ng												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Bx_nT,By_nT,Bz_nT										Bx,By,Bz			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',	$
			'cl	Scpot_V												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No'	$
		]
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':3DMOMENTS">6 3D moments', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_3DMOMENTS', 'bepi', /moments, /notime

		; PAP
		; ---
			noproduit = [9,10,11]
			arbre = [ arbre, '5 PAP ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

			; "Timeseries"
			vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
			ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':3D">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_3D', 'bepi', /notime

			; "Particle spectrogram" et "Particle plot"
			unite = 'count'
			nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
			arbre = [ arbre, 																																																	$
				'6 Particle spectrogram',																																															$
					'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																									$
					'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																									$
					;'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																					$
					;'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   Bresolution=fgm_brst_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',																	$
					;'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_brst_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-100000 x_max=100000 yleft_auto=Manual yleft_min=-100000 yleft_max=100000 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=500',	$
				'6 Particle plot',																																																$
					'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_brst_l2 cjf='+unite+' legend_theta=No legend_phi=No',																												$
					'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+'                            x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																					$
					'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic'																					$
			]

		arbre = [ arbre, 															$
			'</instrument>'															]

	END


	; ---
	; MIA
	; ---

	nom1 = 'MIA'
	nomcis = 'BEPI-' + nom1
	arbre = [ arbre,															$
		'<instrument name="'+nom1+'" id="MMO:'+nom1+'">4 '+nom1										]

		; count
		; -----
		noproduit = [0]
		arbre = [ arbre, '5 count ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Particle spectrogram" et "Particle plot"
		unite = 'count'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																															$
			'6 Particle spectrogram',																																													$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy spin_average=Yes cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No ',																								$
			'6 Particle plot',																																														$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf spin_average=Yes cjf='+unite+' legend_theta=No legend_phi=No',																											$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																						$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic'																						$
		]

		; VML
		; ---
		noproduit = [1]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MMO:'+nom1+':VML">5 VML', nomcis, noproduit, nomsat, tab, 'MMO_'+nom1+'_VML', 'bepi'


	; ---
	; MSA
	; ---

	nom1 = 'MSA'
	nomcis = 'BEPI-' + nom1
	arbre = [ arbre,															$
		'<instrument name="'+nom1+'" id="MMO:'+nom1+'">4 '+nom1										]

		; protons
		; -------
		noproduit = [0]
		arbre = [ arbre, '5 protons ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Particle spectrogram" et "Particle plot"
		unite = 'count'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																															$
			'6 Particle spectrogram',																																													$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy spin_average=Yes cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No ',																								$
			'6 Particle plot',																																														$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf spin_average=Yes cjf='+unite+' legend_theta=No legend_phi=No',																											$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																						$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic'																						$
		]

		; alpha
		; -----
		noproduit = [1]
		arbre = [ arbre, '5 alpha ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Particle spectrogram" et "Particle plot"
		unite = 'count'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																															$
			'6 Particle spectrogram',																																													$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy spin_average=Yes cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No ',																								$
			'6 Particle plot',																																														$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf spin_average=Yes cjf='+unite+' legend_theta=No legend_phi=No',																											$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																						$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic'																						$
		]

		; heavies
		; -------
		noproduit = [2]
		arbre = [ arbre, '5 heavies ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Particle spectrogram" et "Particle plot"
		unite = 'count'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																															$
			'6 Particle spectrogram',																																													$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy spin_average=Yes cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No ',																								$
			'6 Particle plot',																																														$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf spin_average=Yes cjf='+unite+' legend_theta=No legend_phi=No',																											$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																						$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic'																						$
		]

		; total
		; ------
		noproduit = [3]
		arbre = [ arbre, '5 total ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Particle spectrogram" et "Particle plot"
		unite = 'count'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																															$
			'6 Particle spectrogram',																																													$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy spin_average=Yes cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No ',																								$
			'6 Particle plot',																																														$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf spin_average=Yes cjf='+unite+' legend_theta=No legend_phi=No',																											$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																						$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic'																						$
		]



	arbre = [ arbre, 																$
		'</mission>' 																]

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_bepi_mpo
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL de BEPI-COLOMBO MPO.
;-------------------------------------------------------------------------------
;
	COMMON COMMON_CL, general

	create_products, 'MPO'

	p = get(general,'p') ; p[noproduit,nocis,nosat]

	target  = "Heliosphere.NearEarth"			; E. Penou
	targets = "Heliosphere.NearEarth Heliosphere.Inner"	; spase

	arbre = [																	$
		'<mission name="MPO" id="MPO" target="'+target+'" targets="'+targets+'">3 MPO'								]

	nomsat = 'SC1'
	nosat = STRMID(nomsat,2)
	nom1 = 'MAG'

	nomcis = 'MPO-' + nom1

	arbre = [ arbre,															$
		'<instrument name="'+nom1+'" id="MPO:'+nom1+'">4 '+nom1										]

	; OB J2000
	; --------
	noproduit = 0
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
	ajouter_dataset, arbre, '<dataset id="MPO:'+nom1+':OBJ2000">5 OB J2000', nomcis, noproduit, nomsat, tab, 'MPO_'+nom1+'_OBJ2000', 'bepi'

	; IB J2000
	; --------
	noproduit = 1
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
	ajouter_dataset, arbre, '<dataset id="MPO:'+nom1+':IBJ2000">5 IB J2000', nomcis, noproduit, nomsat, tab, 'MPO_'+nom1+'_IBJ2000', 'bepi'

	; OB VSO
	; ------
	noproduit = 2
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
	ajouter_dataset, arbre, '<dataset id="MPO:'+nom1+':OBVSO">5 OB VSO', nomcis, noproduit, nomsat, tab, 'MPO_'+nom1+'_OBVSO', 'bepi'

	; IB VSO
	; ------
	noproduit = 3
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
	ajouter_dataset, arbre, '<dataset id="MPO:'+nom1+':IBVSO">5 IB VSO', nomcis, noproduit, nomsat, tab, 'MPO_'+nom1+'_IBVSO', 'bepi'

	arbre = [ arbre, 															$
		'</instrument>'															]

	arbre = [ arbre, 																$
		'</mission>' 																]

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_geotail
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL de GEOTAIL.
;-------------------------------------------------------------------------------
;
; Trouv dans spase://SMWG/Observatory/Geotail
;
; <ObservatoryRegion>Earth.Magnetosphere</ObservatoryRegion>
; <ObservatoryRegion>Heliosphere.NearEarth</ObservatoryRegion>
;

	create_products, 'GEOTAIL'

	target  = "Earth.Magnetosphere"				; V. genot
	targets = "Earth.Magnetosphere Heliosphere.NearEarth"	; spase

	arbre = [																	$
		'<mission name="GEOTAIL" id="GEOTAIL" target="'+target+'" targets="'+targets+'">2 GEOTAIL',						$
		'<instrument name="ephemeris" id="GEOTAIL:ephemeris">3 ephemeris'									]

	; ephemeris MGF
	tab = [	'cl	X_gse_Km,Y_gse_Km,Z_gse_Km           x,y,z  orbito',										$
		'cl,ws	X_gse_Km,Y_gse_Km,Z_gse_Km           x,y,z  header'										]
	ajouter_dataset, arbre, '<dataset id="GEOTAIL:EPHEMERIS:ORBIT_MGF">4 orbit from MGF', 'GEOTAIL', 0, 'SC1', tab, 'GE_EPHEMERIS_ORBIT_MGF', 'geotail'

	; ephemeris LEP
	tab = [	'cl	X_gse_km,Y_gse_km,Z_gse_km           x,y,z  orbito',										$
		'cl,ws	X_gse_km,Y_gse_km,Z_gse_km           x,y,z  header'										]
	ajouter_dataset, arbre, '<dataset id="GEOTAIL:EPHEMERIS:ORBIT_LEP">4 orbit from LEP', 'GEOTAIL', 3, 'SC1', tab, 'GE_EPHEMERIS_ORBIT_LEP', 'geotail'

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'<instrument name="MGF" id="GEOTAIL:MGF">3 MGF'												]

	; MGF
	tab = [	'cl,ws	Bx_gse_nT,By_gse_nT,Bz_gse_nT,*B_nT	Bx,By,Bz,|B|		header',							$
		'cl,ws	Bx_rms_nT,By_rms_nT,Bz_rms_nT,*B_nT	Bx,By,Bz,|B|		header'								]
	ajouter_dataset, arbre, '<dataset id="GEOTAIL:MGF:K0">4 GE_K0_MGF', 'GEOTAIL', 0, 'SC1', tab, 'GE_MGF_K0', 'geotail'

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'<instrument name="CPI" id="GEOTAIL:CPI">3 CPI'												]

	; CPI
	tab = [	'cl,ws	N_SWA_cm3						#		header',						$
		'cl,ws	E_SWA_eV						#		header',						$
		'cl,ws	Vx_gse_SWA_km_sec,Vy_gse_SWA_km_sec,Vz_gse_SWA_km_sec	Vx,Vy,Vz	header',						$
		'cl,ws	N_Ion_HPA_cm3						#		header',						$
		'cl,ws	E_Ion_HPA_eV						#		header',						$
		'cl,ws	Vx_gse_HPA_km_sec,Vy_gse_HPA_km_sec			Vx,Vy		header',						$
		'cl,ws	E_Electron_HPA_eV					#		header',						$
		'cl,ws	P_plasma_HPA_Pa						#		header'							]
	ajouter_dataset, arbre, '<dataset id="GEOTAIL:CPI:K0">4 GE_K0_CPI', 'GEOTAIL', 1, 'SC1', tab, 'GE_CPI_K0', 'geotail'

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'<instrument name="EPI" id="GEOTAIL:EPI">3 EPI'												]

	; EPI
	tab = [	'cl,ws	Electron_Integral_Intensity_1_cm2_s_sr			#		header',						$
		'cl,ws	Electron_energy_ev					#		header'							]
	ajouter_dataset, arbre, '<dataset id="GEOTAIL:EPI:K0">4 GE_K0_EPI', 'GEOTAIL', 2, 'SC1', tab, 'GE_EPI_K0', 'geotail'

	; Spectro EPI uniquement pour webservice
	action = 'count3d type=time_energy cjf=flux  yleft_auto=Manual yleft_min=50 yleft_max=2000 z_showdir=No z_theta=No z_phi=No'
	nom1 = 'K0_SPECTRO_TIME_ENERGY'
	nom2 = 'GE_K0_EPI Spectrogram Time Energy'
	nom3 = 'GE_EPI_K0_SPECTRO_TIME_ENERGY'
	visibility = "ws"
	tab = [	visibility +' 1d_data 		# ' + action ]
	ajouter_dataset, arbre, '<dataset id="GEOTAIL:EPI:'+nom1+'" visibility="'+visibility+'">4 '+nom2, 'GEOTAIL', 2, 'SC1', tab, nom3, 'geotail', /spectro

	; Spectro + Plot EPI uniquement pour cl
	arbre = [ arbre, 																$
		'4 Particle spectrogram '+ get_cldataset_starttime_endtime('GEOTAIL',[2],'SC1'),							$
			'0 Time Energy flux# GEOTAIL P2 SC1 flux ' + action,										$
		'4 Particle plot '+ get_cldataset_starttime_endtime('GEOTAIL',[2],'SC1'),								$
			'0 Time flux#   GEOTAIL P2 SC1 flux count2d type=time_cjf cjf=flux legend_theta=No legend_phi=No',				$
			'0 Energy flux# GEOTAIL P2 SC1 flux count2d type=energy_cjf cjf=flux legend_theta=No legend_phi=No'				]

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'<instrument name="LEP" id="GEOTAIL:LEP">3 LEP'												]

	; LEP
	tab = [	'cl,ws	Solar_Wind_Velocity_V_km_sec			#		header'								]
	ajouter_dataset, arbre, '<dataset id="GEOTAIL:LEP:K0">4 GE_K0_LEP', 'GEOTAIL', 3, 'SC1', tab, 'GE_LEP_K0', 'geotail'

	; Spectro LEP uniquement pour webservice
	action = 'count3d type=time_energy cjf=count  z_showdir=No z_theta=No z_phi=No'
	nom1 = 'K0_SPECTRO_TIME_ENERGY'
	nom2 = 'GE_K0_LEP spectrogram Time Energy'
	nom3 = 'GE_LEP_K0_SPECTRO_TIME_ENERGY'
	visibility = "ws"
	tab = [	visibility +' 1d_data 		# ' + action ]
	ajouter_dataset, arbre, '<dataset id="GEOTAIL:LEP:'+nom1+'" visibility="'+visibility+'">4 '+nom2, 'GEOTAIL', 3, 'SC1', tab, nom3, 'geotail', /spectro

	; Spectro + Plot LEP uniquement pour cl

	arbre = [ arbre, 																$
		'4 Particle spectrogram '+ get_cldataset_starttime_endtime('GEOTAIL',[3],'SC1'),							$
		'0 Time Energy count# GEOTAIL P3 SC1 count ' + action,											$
		'0 Time Theta count#  GEOTAIL P3 SC1 count count3d count3d type=time_theta cjf=count  z_showdir=No z_theta=No z_phi=No',		$
		'4 Particle plot '+ get_cldataset_starttime_endtime('GEOTAIL',[3],'SC1'),								$
		'0 Time count#   GEOTAIL P3 SC1 flux count2d type=time_cjf cjf=count legend_theta=No legend_phi=No',					$
		'0 Energy count# GEOTAIL P3 SC1 flux count2d type=energy_cjf cjf=count legend_theta=No legend_phi=No'					]


	arbre = [ arbre, 																$
		'</instrument>', 															$
		'</mission>' 																$
	]

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_goes,	$
;-------------------------------------------------------------------------------
	no	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL d'un satellite GOES.
;-------------------------------------------------------------------------------

	SC = 'SC'+val_to_str(no-7)

	arbre = [ '3 GOES' + val_to_str(no) ]

	IF no EQ 17 THEN BEGIN
		arbre = [ arbre, 												$
		'4 XRAY',													$
		'5 1mn resolution ' + get_cldataset_starttime_endtime('GOES',0,SC),												$
			'0 Solar X-ray Flux 0.05- 0.4 nanometer# GOES P0 '+SC+' Flux_0_05_0_40nm_Watt_m2 header yleft_log=Log',	$
			'0 Solar X-ray Flux 0.1 - 0.8 nanometer# GOES P0 '+SC+' Flux_0_10_0_80nm_Watt_m2 header yleft_log=Log'	$
		]
		RETURN, arbre
	END

	IF no NE 9 AND no NE 13 THEN BEGIN
		arbre = [ arbre, 												$
		'4 XRAY',													$
		'5 1mn resolution ' + get_cldataset_starttime_endtime('GOES',0,SC),												$
			'0 Solar X-ray Flux 0.05- 0.4 nanometer# GOES P0 '+SC+' Flux_0_05_0_40nm_Watt_m2 header yleft_log=Log',		$
			'0 Solar X-ray Flux 0.1 - 0.8 nanometer# GOES P0 '+SC+' Flux_0_10_0_80nm_Watt_m2 header yleft_log=Log',		$
		'5 5mn resolution ' + get_cldataset_starttime_endtime('GOES',1,SC),												$
			'0 Solar X-ray Flux 0.05- 0.4 nanometer# GOES P1 '+SC+' Flux_0_05_0_40nm_Watt_m2 header yleft_log=Log',		$
			'0 Solar X-ray Flux 0.1 - 0.8 nanometer# GOES P1 '+SC+' Flux_0_10_0_80nm_Watt_m2 header yleft_log=Log'		$
		]
	END

	IF no GE 10 THEN BEGIN

		arbre = [ arbre, $
		'4 GEOMAG 1min resolution ' + get_cldataset_starttime_endtime('GOES',2,SC),																		$
			'0 '+"Geomagnetic component perpendicular to the satellite orbital plane or parallel to the Earth's spin axis"+'#	GOES P2 '+SC+' Hp_nT header',		$
			'0 '+"Geomagnetic component perpendicular to Hp and directed earthwards"+'#						GOES P2 '+SC+' He_nT header',		$
			'0 '+"Geomagnetic component perpendicular to both Hp and He, directed eastwards"+'#					GOES P2 '+SC+' Hn_nT header',		$
			'0 '+"Geomagnetic Total Field"+'#											GOES P2 '+SC+' H_nT header'		$

		]
	END

	arbre = [ arbre, 											$
		'4 PARTICLE 5min resolution ' + get_cldataset_starttime_endtime('GOES',3,SC),										$
			'0 Particles at >1 Mev#		GOES P3 '+SC+' Particles_sup_001_Mev_cm2_s_sr header yleft_log=Log',		$
			'0 Particles at >5 Mev#		GOES P3 '+SC+' Particles_sup_005_Mev_cm2_s_sr header yleft_log=Log',		$
			'0 Particles at >10 Mev#	GOES P3 '+SC+' Particles_sup_010_Mev_cm2_s_sr header yleft_log=Log',		$
			'0 Particles at >30 Mev#	GOES P3 '+SC+' Particles_sup_030_Mev_cm2_s_sr header yleft_log=Log',		$
			'0 Particles at >50 Mev#	GOES P3 '+SC+' Particles_sup_050_Mev_cm2_s_sr header yleft_log=Log',		$
			'0 Particles at >100 Mev#	GOES P3 '+SC+' Particles_sup_100_Mev_cm2_s_sr header yleft_log=Log',		$
			'0 Electrons at >0.8 Mev#	GOES P3 '+SC+' Electrons_sup_0_6_Mev_cm2_s_sr header yleft_log=Log',		$
			'0 Electrons at >2.0 Mev#	GOES P3 '+SC+' Electrons_sup_2_0_Mev_cm2_s_sr header yleft_log=Log',		$
			'0 Electrons at >4.0 Mev#	GOES P3 '+SC+' Electrons_sup_4_0_Mev_cm2_s_sr header yleft_log=Log'		$
	]

	IF no GE 10 THEN BEGIN
		arbre = [ arbre, 													$
		'4 PCHAN 5min resolution ' + get_cldataset_starttime_endtime('GOES',4,SC),												$
			'0 Protons from 0.7 - 4 MeV#	GOES P4 '+SC+' Protons_from_0_8_____4_MeV_units___cm2_s_sr_MeV header yleft_log=Log',		$
			'0 Protons from 4 - 9 MeV#	GOES P4 '+SC+' Protons_from___4_____9_MeV_units___cm2_s_sr_MeV header yleft_log=Log',		$
			'0 Protons from 9 - 15 MeV#	GOES P4 '+SC+' Protons_from___9____15_MeV_units___cm2_s_sr_MeV header yleft_log=Log',		$
			'0 Protons from 15 - 40 MeV#	GOES P4 '+SC+' Protons_from__15____40_MeV_units___cm2_s_sr_MeV header yleft_log=Log',		$
			'0 Protons from 38 - 82 MeV#	GOES P4 '+SC+' Protons_from__40____80_MeV_units___cm2_s_sr_MeV header yleft_log=Log',		$
			'0 Protons from 84 - 200 MeV#	GOES P4 '+SC+' Protons_from__80___165_MeV_units___cm2_s_sr_MeV header yleft_log=Log',		$
			'0 Protons from 110 - 900 MeV#	GOES P4 '+SC+' Protons_from_165___500_MeV_units___cm2_s_sr_MeV header yleft_log=Log',		$
			'0 Protons from 350 - 420 MeV#	GOES P4 '+SC+' Protons_from_350___420_MeV_units___cm2_s_sr_MeV header yleft_log=Log',		$
			'0 Protons from 420 - 510 MeV#	GOES P4 '+SC+' Protons_from_420___510_MeV_units___cm2_s_sr_MeV header yleft_log=Log',		$
			'0 Protons from 510 - 700 MeV#	GOES P4 '+SC+' Protons_from_510___700_MeV_units___cm2_s_sr_MeV header yleft_log=Log',		$
			'0 Protons from >700 MeV#	GOES P4 '+SC+' Protons_from_______700_MeV_units___cm2_s_sr header yleft_log=Log'		$
		]
	END


	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_imp8
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL d'IMP8.
;-------------------------------------------------------------------------------
;
; Trouv dans spase://SMWG/Observatory/IMP8
;
; <ObservatoryRegion>Heliosphere.NearEarth</ObservatoryRegion>
; <ObservatoryRegion>Earth.Magnetosheath</ObservatoryRegion>
; <ObservatoryRegion>Earth.Magnetosphere.Magnetotail</ObservatoryRegion>
;

	create_products, 'IMP8'

	target  = "Heliosphere.NearEarth"							; E. Penou
	targets = "Heliosphere.NearEarth Earth.Magnetosheath Earth.Magnetosphere.Magnetotail"	; spase

	arbre = [																	$
		'<mission name="IMP8" id="IMP8" target="'+target+'" targets="'+targets+'">2 IMP8',							$
		'<instrument name="ephemeris" id="IMP8:ephemeris">3 ephemeris'										]

	; ephemeris
	tab = [	'cl	X_gsm_Rt,Y_gsm_Rt,Z_gsm_Rt           x,y,z  orbito',										$
		'cl,ws	X_gsm_Rt,Y_gsm_Rt,Z_gsm_Rt           x,y,z  header',										$
		'cl,ws	dZ                                   #      header'										]
	ajouter_dataset, arbre, '<dataset id="IMP8:EPHEMERIS:ORBIT">4 orbit', 'IMP8', 1, 'SC1', tab, 'IMP8_EPHEMERIS_ORBIT', 'imp8'

	arbre = [ arbre,		$
		'3 MAG ' + get_cldataset_starttime_endtime('IMP8',1,'SC1'),							$
			'0 Bx,By,Bz,B in GSM#IMP8 P0 SC1 Bx_gsm_nT,By_gsm_nT,Bz_gsm_nT,B_nT header'				$
	]

	arbre = [ arbre, 													$
		'</instrument>', 												$
		'</mission>' 													$
	]

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_isee
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL d'ISEE.
;-------------------------------------------------------------------------------

	arbre = [			$
		'2 ISEE',		$

		'3 ephemeris',																$
		'4 orbit',																$
		'5 orbit from MAG ' + get_cldataset_starttime_endtime('ISEE',1,'SC1'),																				$
			'0 Orbit panel info MAG with XGSM,YGSM,ZGSM,dZ#			ISEE P1 SC1 X_gsm_Rt,Y_gsm_Rt,Z_gsm_Rt,dZ orbito',	$
		'5 orbit from MAGE ' + get_cldataset_starttime_endtime('ISEE',3,'SC1'),																				$
			'0 Orbit panel info MAGE with XGSM,YGSM,ZGSM,dZ#		ISEE P3 SC1 X_gsm_Rt,Y_gsm_Rt,Z_gsm_Rt,dZ orbito',	$
		'5 orbit from ISEE1 ' + get_cldataset_starttime_endtime('ISEE',5,'SC1'),																				$
			'0 Orbit panel info particle ISEE1 with XGSR,YGSE,ZGSE,dZ#	ISEE P5 SC1 X_gse_Rt,Y_gse_Rt,Z_gse_Rt,dZ orbito',	$
		'5 orbit from ISEE2 ' + get_cldataset_starttime_endtime('ISEE',7,'SC1'),																				$
			'0 Orbit panel info particle ISEE2 with XGSR,YGSE,ZGSE,dZ#	ISEE P7 SC1 X_gse_Rt,Y_gse_Rt,Z_gse_Rt,dZ orbito',	$

		'3 MAG ' + get_cldataset_starttime_endtime('ISEE',0,'SC1'),															$
			'0 Bx,By,Bz,B in GSM#ISEE P0 SC1 Bx_gsm_nT,By_gsm_nT,Bz_gsm_nT,B_nT header',						$

		'3 MAGE ' + get_cldataset_starttime_endtime('ISEE',2,'SC1'),															$
			'0 Bx,By,Bz,B in GSE#	ISEE P2 SC1 Bx_gse_nT,By_gse_nT,Bz_gse_nT,B_nT header',						$
			'0 ExGSE,EyGSE,V2S#	ISEE P2 SC1 Ex_gse_mV_m,Ey_gse_mV_m,V2S header',						$

		'3 Particle ISEE1 ' + get_cldataset_starttime_endtime('ISEE',4,'SC1'),														$
			'0 flux OT12#		ISEE P4 SC1 OT12   header',									$
			'0 flux OT60#		ISEE P4 SC1 OT60   header',									$
			'0 flux FT8#		ISEE P4 SC1 FT8    header',									$
			'0 flux FT60#		ISEE P4 SC1 FT60   header',									$
			'0 flux electron 2 keV#	ISEE P4 SC1 E2     header',										$
			'0 flux electron 6 keV#	ISEE P4 SC1 E6     header',										$
			'0 flux proton 2 keV#	ISEE P4 SC1 P2     header',										$
			'0 flux proton 6 keV#	ISEE P4 SC1 P6     header',										$
			'0 flux OT200#		ISEE P4 SC1 OT200  header',									$
			'0 flux COIN#		ISEE P4 SC1 COIN   header',									$
			'0 flux SC_ANG#		ISEE P4 SC1 SC_ANG header',									$

		'3 Particle ISEE2 ' + get_cldataset_starttime_endtime('ISEE',6,'SC1'),														$
			'0 flux OT12#		ISEE P6 SC1 OT12   header',									$
			'0 flux OT60#		ISEE P6 SC1 OT60   header',									$
			'0 flux FT8#		ISEE P6 SC1 FT8    header',									$
			'0 flux FT60#		ISEE P6 SC1 FT60   header',									$
			'0 flux electron 2 keV#	ISEE P6 SC1 E2     header',										$
			'0 flux electron 6 keV#	ISEE P6 SC1 E6     header',										$
			'0 flux proton 2 keV#	ISEE P6 SC1 P2     header',										$
			'0 flux proton 6 keV#	ISEE P6 SC1 P6     header',										$
			'0 flux OT200#		ISEE P6 SC1 OT200  header',									$
			'0 flux COIN#		ISEE P6 SC1 COIN   header',									$
			'0 flux SC_ANG#		ISEE P6 SC1 SC_ANG header'									$
	]

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_jason3
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL JASON3.
;-------------------------------------------------------------------------------
;
; Pas trouv dans spase ?

	COMMON COMMON_CL, general

	create_products, 'JASON3'

	p = get(general,'p') ; p[noproduit,nocis,nosat]
	nomsat = 'SC1'
	nosat = STRMID(nomsat,2)


	arbre = [ '2 JASON3' ]

	; ---------
	; ephemeris
	; ---------

	arbre = [ arbre, '3 ephemeris']
	nomcis = 'JASON3-EPHEMERIS'

	; orbit ONERA
	noproduit = 0
	tab = [	'cl	XGEO,YGEO,ZGEO						x,y,z 	orbito',	$
		'cl	XGEO,YGEO,ZGEO						x,y,z	header',	$
		'cl	Quality							#	header',	$
		'cl	B_Calc							#	header',	$
		'cl	B_Eq							#	header',	$
		'cl	L							#	header',	$
		'cl	L_star							#	header',	$
		'cl	I							#	header',	$
		'cl	MLT							#	header',	$
		'cl	D							#	header',	$
		'cl	INVLAT							#	header',	$
		'cl	RLAT							#	header',	$
		'cl	RLONG							#	header'		]
	ajouter_dataset, arbre, '<dataset id="JASON3:EPHEMERIS:ORBIT_AMBRE_ONERA">4 orbit ONERA', nomcis, noproduit, nomsat, tab, 'JASON3_EPHEMERIS_ORBIT_ONERA', 'jason3_ephemeris'

	; orbit IRAP
	noproduit = 1
	tab = [	'cl	XGSE,YGSE,ZGSE						x,y,z 	orbito',	$
		'cl	ALT							# 	header',	$
		'cl	XGSE							#	header',	$
		'cl	YGSE							#	header',	$
		'cl	ZGSE							#	header',	$
		'cl	XGSM							#	header',	$
		'cl	YGSM							#	header',	$
		'cl	ZGSM							#	header',	$
		'cl	BXGSM							#	header',	$
		'cl	BYGSM							#	header',	$
		'cl	BZGSM							#	header',	$
		'cl	B							#	header',	$
		'cl	L							#	header',	$
		'cl	INVLAT							#	header',	$
		'cl	MLT							#	header',	$
		'cl	MLTcjg							#	header',	$
		'cl	IHSL							#	header'		]
	ajouter_dataset, arbre, '<dataset id="JASON3:EPHEMERIS:ORBIT_AMBRE_IRAP">4 orbit IRAP', nomcis, noproduit, nomsat, tab, 'JASON3_EPHEMERIS_ORBIT_IRAP', 'jason3_ephemeris'

	; -----
	; AMBRE
	; -----

	arbre = [ arbre, '3 AMBRE']
	nomcis = 'JASON3-AMBRE'

		; --
		; HK
		; --
		arbre = [ arbre, '4 HK ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

			; "Timeseries"
			noproduit = 0
			vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
			ajouter_dataset, arbre, '<dataset id="JASON3:AMBRE:HK">5 Timeseries', nomcis, noproduit, nomsat, tab, 'JASON3_AMBRE_HK', 'jason3_ambre', /notime

		; -----
		; PITCH
		; -----
		arbre = [ arbre, '4 PITCH ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

			; "Timeseries"
			noproduit = 11
			vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
			ajouter_dataset, arbre, '<dataset id="JASON3:AMBRE:PITCH">5 Timeseries', nomcis, noproduit, nomsat, tab, 'JASON3_AMBRE_PITCH', 'jason3_ambre', /notime

		; ----------------
		; ELECTRONS + IONS
		; ----------------

		tab1 = [     1,      2,      3,      4,      5,      6,      7,      8,          9,        10]
		tab2 = ['ELE1', 'ELE2', 'ELE3', 'ELE4', 'ION1', 'ION2', 'ION3', 'ION4', 'ELEC1234', 'ION1234']

		FOR i=0L,N_ELEMENTS(tab1)-1 DO BEGIN

			noproduit = tab1[i]
			arbre = [ arbre, '4 ' + tab2[i] + ' ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

				; "Timeseries"
				vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
				tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
				ajouter_dataset, arbre, '<dataset id="JASON3:AMBRE:' + tab2[i] + '">5 Timeseries', nomcis, noproduit, nomsat, tab, 'JASON3_AMBRE_' + tab2[i], 'jason3_ambre', /notime

				; "Particle spectrogram" et "Particle plot"
				unite = 'count'
				nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
				arbre = [ arbre, 																																												$
					'5 Particle spectrogram',																																										$
						'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
					'5 Particle plot',																																											$
						'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
						'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																$
						'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic'																	$
				]

		END

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_juno
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL JUNO.
;-------------------------------------------------------------------------------
;
; Pas trouv dans spase ?

	COMMON COMMON_CL, general

	create_products, 'JUNO'

	p = get(general,'p') ; p[noproduit,nocis,nosat]
	nomsat = 'SC1'
	nosat = STRMID(nomsat,2)


	arbre = [ '2 JUNO' ]

	; ---------
	; ephemeris
	; ---------

	arbre = [ arbre, '3 ephemeris']
	nomcis = 'JUNO-EPHEMERIS'

	; orbit
	noproduit = 0
	tab = [	'cl	XJ2000,YJ2000,ZJ2000,R						x,y,z,r 	orbito',		$
		'cl	XJ2000,YJ2000,ZJ2000						x,y,z		header',		$
		'cl	VXJ2000,VYJ2000,VZJ2000						Vx,Vy,Vz	header',		$
		'cl	AVXJ2000,AVYJ2000,AVZJ2000					AVx,AVy,AVz	header',		$
		'cl	R								#		header',		$
		'cl	LAT								#		header',		$
		'cl	MLT								#		header',		$
		'cl	LONG								#		header',		$
		'cl	MLAT								#		header',		$
		'cl	IO_PHASE							#		header']
	ajouter_dataset, arbre, '<dataset id="JUNO:EPHEMERIS:ORBIT">4 orbit', nomcis, noproduit, nomsat, tab, 'JUNO_EPHEMERIS_ORBIT', 'juno_ephemeris'

	; attitude
	noproduit = [1]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="JUNO:EPHEMERIS:ATTITUDE">4 attitude', nomcis, noproduit, nomsat, tab, 'JUNO_EPHEMERIS_ATTITUDE', 'juno_ephemeris'

	; ---
	; MAG
	; ----

	arbre = [ arbre, '3 MAG']
	nomcis = 'JUNO-MAG'

	; JADEE
	noproduit = [0]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="JUNO:MAG:JADEE">4 JADEE', nomcis, noproduit, nomsat, tab, 'JUNO_MAG_JADEE', 'juno_mag'

	; PC
	noproduit = [1]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="JUNO:MAG:PC">4 PC (Planetocentric)', nomcis, noproduit, nomsat, tab, 'JUNO_MAG_PC', 'juno_mag'

	; PC1S
	noproduit = [2]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="JUNO:MAG:PC1S">4 PC (Planetocentric) res 1s', nomcis, noproduit, nomsat, tab, 'JUNO_MAG_PC1S', 'juno_mag'

	; PC60S
	noproduit = [3]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="JUNO:MAG:PC60S">4 PC (Planetocentric) res 60s', nomcis, noproduit, nomsat, tab, 'JUNO_MAG_PC60S', 'juno_mag'

	; PL
	noproduit = [4]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="JUNO:MAG:PL">4 PL (Payload)', nomcis, noproduit, nomsat, tab, 'JUNO_MAG_PL', 'juno_mag'

	; PL1S
	noproduit = [5]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="JUNO:MAG:PL1S">4 PL (Payload) res 1s', nomcis, noproduit, nomsat, tab, 'JUNO_MAG_PL1S', 'juno_mag'

	; SS
	noproduit = [6]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="JUNO:MAG:SS">4 SS (Sun-State)', nomcis, noproduit, nomsat, tab, 'JUNO_MAG_SS', 'juno_mag'

	; SS1S
	noproduit = [7]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="JUNO:MAG:SS1S">4 SS (Sun-State) res 1s', nomcis, noproduit, nomsat, tab, 'JUNO_MAG_SS1S', 'juno_mag'

	; SS60S
	noproduit = [8]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="JUNO:MAG:SS60S">4 SS (Sun-State) res 60s', nomcis, noproduit, nomsat, tab, 'JUNO_MAG_SS60S', 'juno_mag'


	patch = 'z_zauto=Automatic'+STRING(2b)+'with'+STRING(2b)+'limited'+STRING(2b)+'Zmin z_zmin=1'
	patch = 'z_zauto=Automatic'

	; ----
	; JADEE
	; ----

	arbre = [ arbre, '3 JADEE']
	nomcis = 'JUNO-JADEE'

	; 2D HRS et LRS
	noproduit = [1,2,3,4]
	arbre = [ arbre, '4 2D HRS and LRS ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="JUNO:JADEE:2D_HRS_LRS">5 Timeseries', nomcis, noproduit, nomsat, tab, 'JUNO_JADEE_2D_HRS_LRS', 'juno_jadee', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																																$
			'5 Particle spectrogram',																																														$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy spin_average=No cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No '+patch,																								$
				'0 Time Theta (Theta=Anode) '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta    cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No '+patch,																										$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=MAG cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Automatic spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100 '+patch,									$
				'0 Energy Pitchangle '+unite+'#	        '+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle cjf='+unite+' pad_nbalphas=16 z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic '+patch,																						$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-150000.0 x_max=150000 yleft_auto=Manual yleft_min=-150000.0 yleft_max=150000.0 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=1000 '+patch,	$
			'5 Particle plot',																																															$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf spin_average=No cjf='+unite+' legend_theta=No legend_phi=No '+patch,																											$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=100 x_max=100000 '+patch,																				$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=100 x_max=100000 '+patch,																				$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=MAG cjf='+unite+' x_dx=100.0 pad_nbalphas=16 bulk_speed_auto=Automatic legend_theta=No legend_phi=No '+patch																					$
		]

	; 3D HRS et LRS
	noproduit = [6,7,8,9]
	arbre = [ arbre, '4 3D HRS and LRS ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="JUNO:JADEE:3D_HRS_LRS">5 Timeseries', nomcis, noproduit, nomsat, tab, 'JUNO_JADEE_3D_HRS_LRS', 'juno_jadee', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																																$
			'5 Particle spectrogram',																																														$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy spin_average=No cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No '+patch,																								$
				'0 Time Phi (Phi=Anode) '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No '+patch,																							$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=MAG cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Automatic spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100 '+patch,									$
				'0 Energy Pitchangle '+unite+'#	        '+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle cjf='+unite+' pad_nbalphas=16 z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic '+patch,																							$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No '+patch,																			$
				'0 Phi Theta AITOF '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta representation=(latitude,longitude)'+STRING(2b)+'map'+STRING(2b)+'AITOFF cjf='+unite+' emin_nochamp=I0#I63 emax_nochamp=I0#I63  yleft_auto=Automatic x_auto=Automatic z_showdir=No z_theta=No z_phi=No '+patch,										$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-150000.0 x_max=150000 yleft_auto=Manual yleft_min=-150000.0 yleft_max=150000.0 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=1000 '+patch,	$
			'5 Particle plot',																																															$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf spin_average=No cjf='+unite+' legend_theta=No legend_phi=No '+patch,																											$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=100 x_max=100000 '+patch,																				$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=100 x_max=100000 '+patch,																				$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=MAG cjf='+unite+' x_dx=100.0 pad_nbalphas=16 bulk_speed_auto=Automatic legend_theta=No legend_phi=No '+patch																					$
		]

		; 3D MOMENTS
		tab = [	'cl	N_cm3												#  				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec								Vx,Vy,Vz,|V| 			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Vx_j2000_km_sec,Vy_j2000_km_sec,Vz_j2000_km_sec,*V_km_sec					Vx,Vy,Vz,|V| 			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3								Ppar,Pper1,Pper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV									Tpar,Tper1,Tper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV									Tpar,Tper1,Tper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2					Qx,Qy,Qz,|Q|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Qx_j2000_erg_sec_cm2,Qy_j2000_erg_sec_cm2,Qz_j2000_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2				Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2				Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3				Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Ei_eV_cm3											#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Ti_eV												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Ex,Ey,Ez											Ex,Ey,Ez			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Ex_j2000,Ey_j2000,Ez_j2000									Ex,Ey,Ez			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Vxpar_jadee_km_sec,Vypar_jadee_km_sec,Vzpar_jadee_km_sec,*Vpar_jadee_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Vxper_jadee_km_sec,Vyper_jadee_km_sec,Vzper_jadee_km_sec,*Vper_jadee_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Elx_jadee_mV_m,Ely_jadee_mV_m,Elz_jadee_mV_m,El_jadee_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Pp_nPa												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Pm_nPa												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Beta												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Vxalfven_jadee_km_sec,Vyalfven_jadee_km_sec,Vzalfven_jadee_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	An												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Ng												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Bx_nT,By_nT,Bz_nT										Bx,By,Bz			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Bx_j2000_nT,By_j2000_nT,Bz_j2000_nT								Bx,By,Bz			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
			'cl	Scpot_V												#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No'				$
		]
		ajouter_dataset, arbre, '<dataset id="JUNO:JADEE:3D_HRS_LRS_3DMOMENTS">5 3D moments', nomcis, noproduit, nomsat, tab, 'JUNO_JADEE_3D_HRS_LRS_3DMOMENTS', 'juno_jadee', /moments, /notime

	; -----
	; JADEI
	; -----

	arbre = [ arbre, '3 JADEI']
	nomcis = 'JUNO-JADEI'

	tab1 = ['0',	'1',	'2',	'3',		'4',		'5',		'6','	7',	'A']
	tab2 = ['',	'',	'',	' (Protons)',	' (Lights)',	' (Heavies)',	'',	'',	'']

	FOR i=0L,N_ELEMENTS(tab1)-1 DO BEGIN

		; HRS_SP? et LRS_SP?
		noproduit = [i,9+i]
		v = tab1[i]
		m = tab2[i]
		arbre = [ arbre, '4 HRS and LRS SP' + v + m + ' ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

			; "Timeseries"
			vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
			ajouter_dataset, arbre, '<dataset id="JUNO:JADEI:HRS_LRS_SP' + v + '">5 Timeseries', nomcis, noproduit, nomsat, tab, 'JUNO_JADEI_HRS_LRS_SP' + v, 'juno_jadei', /notime

			; "Particle spectrogram" et "Particle plot"
			unite = 'flux'
			nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
			arbre = [ arbre, 																																												$
				'5 Particle spectrogram',																																										$
					'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy spin_average=No cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No '+patch,																				$
					'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  spin_average=No cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No '+patch,																				$
					'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No '+patch,																			$
					'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=MAG cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Automatic spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100 '+patch,					$
					'0 Energy Pitchangle '+unite+'#	        '+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle cjf='+unite+' pad_nbalphas=16 z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic '+patch,																			$
					'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No '+patch,															$
					'0 Phi Theta AITOF '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta representation=(latitude,longitude)'+STRING(2b)+'map'+STRING(2b)+'AITOFF cjf='+unite+' emin_nochamp=I0#I63 emax_nochamp=I0#I63  yleft_auto=Automatic x_auto=Automatic z_showdir=No z_theta=No z_phi=No '+patch,						$
					'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-3000.0 x_max=3000 yleft_auto=Manual yleft_min=-3000.0 yleft_max=3000.0 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No '+patch,	$
				'5 Particle plot',																																											$
					'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf spin_average=No cjf='+unite+' legend_theta=No legend_phi=No '+patch,																							$
					'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=100 x_max=100000 '+patch,																$
					'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=100 x_max=100000 '+patch,																$
					'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=MAG cjf='+unite+' x_dx=100.0 pad_nbalphas=16 bulk_speed_auto=Automatic legend_theta=No legend_phi=No '+patch																	$
			]

			; 3D MOMENTS
			tab = [	'cl	N_cm3											#  				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vx_j2000_km_sec,Vy_j2000_km_sec,Vz_j2000_km_sec,*V_km_sec				Vx,Vy,Vz,|V| 			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vx_jss_km_sec,Vy_jss_km_sec,Vz_jss_km_sec,*V_km_sec					Vx,Vy,Vz,|V| 			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vr_rtn_km_sec,Vt_rtn_km_sec,Vn_rtn_km_sec,*V_km_sec					Vr,Vt,Vn,|V| 			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qx_j2000_erg_sec_cm2,Qy_j2000_erg_sec_cm2,Qz_j2000_erg_sec_cm2,*Q_erg_sec_cm2		Qx,Qy,Qz,|Q|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qx_jss_erg_sec_cm2,Qy_jss_erg_sec_cm2,Qz_jss_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qr_rtn_erg_sec_cm2,Qt_rtn_erg_sec_cm2,Qn_rtn_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ei_eV_cm3										#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ti_eV											#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ex_j2000,Ey_j2000,Ez_j2000								Ex,Ey,Ez			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ex_jss,Ey_jss,Ez_jss									Ex,Ey,Ez			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Er_rtn,Et_rtn,En_rtn									Ex,Ey,Ez			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vxpar_jadei_km_sec,Vypar_jadei_km_sec,Vzpar_jadei_km_sec,*Vpar_jadei_km_sec		Vx,Vy,Vz,|V|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vxper_jadei_km_sec,Vyper_jadei_km_sec,Vzper_jadei_km_sec,*Vper_jadei_km_sec		Vx,Vy,Vz,|V|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Elx_jadei_mV_m,Ely_jadei_mV_m,Elz_jadei_mV_m,El_jadei_mV_m				Elx,Ely,Elz,|El|		count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Pp_nPa											#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Pm_nPa											#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Beta											#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vxalfven_jadei_km_sec,Vyalfven_jadei_km_sec,Vzalfven_jadei_km_sec,*Valfven_km_sec	Vx,Vy,Vz,[V|			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	An											#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ng											#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Bx_j2000_nT,By_j2000_nT,Bz_j2000_nT							Bx,By,Bz			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Bx_jss_nT,By_jss_nT,Bz_jss_nT								Bx,By,Bz			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Br_rtn_nT,Bt_rtn_nT,Bn_rtn_nT								Bx,By,Bz			count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Scpot_V											#				count2d Bresolution=MAG type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No'				$
			]
			ajouter_dataset, arbre, '<dataset id="JUNO:JADEI:HRS_LRS_SP' + v + '_3DMOMENTS">5 3D moments', nomcis, noproduit, nomsat, tab, 'JUNO_JADEI_HRS_LRS_SP' + v + '_3DMOMENTS', 'juno_jadei', /moments, /notime

	END

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_lightning
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL de LIGHTNING
;-------------------------------------------------------------------------------

	arbre = [													$
		'2 LIGHTNING',												$
		'3 WWLL ' + get_cldataset_starttime_endtime('LIGHTNING',0,'SC1'),					$
		'4 Timeseries',												$
		'0 RLONG versus RLAT#LIGHTNING P0 SC1 RLAT header Xaxis=RLONG x_auto=Manual x_min=-180 x_max=180 yleft_auto=Manual yleft_min=-90 yleft_max=90 showsymbol_nochamp=Only'+STRING(2b)+'symbol',				$
 	 	'4 Spectrogram',																									$
		'0 RLONG-RLAT#       LIGHTNING P0 SC1 count count3d type=RLONG_RLAT cjf=count yleft_log=Linear yleft_auto=Manual yleft_min=-90 yleft_max=90 x_auto=Manual x_min=-180 x_max=180 z_showdir=No z_theta=No z_phi=No'	$
	]

	RETURN, arbre

END

;-------------------------------------------------------------------------------
PRO spectro_maven_static_e,	$
;-------------------------------------------------------------------------------
	arbre,			$	; LINT_PROTOTYPE input
	p,			$	; LINT_PROTOTYPE input
	nomcis,			$	; LINT_PROTOTYPE input
	nomsat,			$	; LINT_PROTOTYPE input
	nosat,			$	; LINT_PROTOTYPE input
	nomproduit,		$	; LINT_PROTOTYPE input
	noproduit,		$	; LINT_PROTOTYPE input
	emin,			$	; LINT_PROTOTYPE input
	emax				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Rajoute une branche pour un spectro E de MAVEN STATIC
;-------------------------------------------------------------------------------

	arbre = [ arbre, '5 ' + nomproduit + ' ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MAVEN:STATIC:'+nomproduit+'">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MVN_STATIC_'+nomproduit, 'maven_static', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'count'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'6 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min='+val_to_str(emin)+' yleft_max='+val_to_str(emax),																$
			'6 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',																	$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000'																	$
		]

END

;-------------------------------------------------------------------------------
PRO spectro_maven_static_m,	$
;-------------------------------------------------------------------------------
	arbre,			$	; LINT_PROTOTYPE input
	p,			$	; LINT_PROTOTYPE input
	nomcis,			$	; LINT_PROTOTYPE input
	nomsat,			$	; LINT_PROTOTYPE input
	nosat,			$	; LINT_PROTOTYPE input
	nomproduit,		$	; LINT_PROTOTYPE input
	noproduit			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Rajoute une branche pour un spectro M de MAVEN STATIC
;-------------------------------------------------------------------------------

	arbre = [ arbre, '5 ' + nomproduit + ' ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MAVEN:STATIC:'+nomproduit+'">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MVN_STATIC_'+nomproduit, 'maven_static', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'count'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'6 Particle spectrogram',																																										$
				'0 Time Mass '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1 yleft_max=100',																					$
			'6 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Mass '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',																	$
				'0 Mass '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000'																	$
		]

END

;-------------------------------------------------------------------------------
PRO spectro_maven_static_d,	$
;-------------------------------------------------------------------------------
	arbre,			$	; LINT_PROTOTYPE input
	p,			$	; LINT_PROTOTYPE input
	nomcis,			$	; LINT_PROTOTYPE input
	nomsat,			$	; LINT_PROTOTYPE input
	nosat,			$	; LINT_PROTOTYPE input
	nomproduit,		$	; LINT_PROTOTYPE input
	noproduit,		$	; LINT_PROTOTYPE input
	min,			$	; LINT_PROTOTYPE input
	max				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Rajoute une branche pour un spectro D de MAVEN STATIC
;-------------------------------------------------------------------------------

	arbre = [ arbre, '5 ' + nomproduit + ' ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MAVEN:STATIC:'+nomproduit+'">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MVN_STATIC_'+nomproduit, 'maven_static', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'count'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																															$
			'6 Particle spectrogram',																													$
				'0 Time Deflection '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_log=Linear yleft_auto=Manual yleft_min='+val_to_str(min)+' yleft_max='+val_to_str(max),	$
			'6 Particle plot',																														$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',													$
				'0 Deflection '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',				$
				'0 Delection '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000'				$
		]

END

;-------------------------------------------------------------------------------
PRO spectro_maven_static_a,	$
;-------------------------------------------------------------------------------
	arbre,			$	; LINT_PROTOTYPE input
	p,			$	; LINT_PROTOTYPE input
	nomcis,			$	; LINT_PROTOTYPE input
	nomsat,			$	; LINT_PROTOTYPE input
	nosat,			$	; LINT_PROTOTYPE input
	nomproduit,		$	; LINT_PROTOTYPE input
	noproduit,		$	; LINT_PROTOTYPE input
	min,			$	; LINT_PROTOTYPE input
	max				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Rajoute une branche pour un spectro D de MAVEN STATIC
;-------------------------------------------------------------------------------

	arbre = [ arbre, '5 ' + nomproduit + ' ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MAVEN:STATIC:'+nomproduit+'">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MVN_STATIC_'+nomproduit, 'maven_static', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'count'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																$
			'6 Particle spectrogram',																														$
				'0 Time Anode '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_log=Linear yleft_auto=Manual yleft_min='+val_to_str(min)+' yleft_max='+val_to_str(max),		$
			'6 Particle plot',																															$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',														$
				'0 Anode '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',					$
				'0 Anode '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000'					$
		]

END

;-------------------------------------------------------------------------------
PRO spectro_maven_static_all,	$
;-------------------------------------------------------------------------------
	arbre,			$	; LINT_PROTOTYPE input
	p,			$	; LINT_PROTOTYPE input
	nomcis,			$	; LINT_PROTOTYPE input
	nomsat,			$	; LINT_PROTOTYPE input
	nosat,			$	; LINT_PROTOTYPE input
	nomproduit,		$	; LINT_PROTOTYPE input
	noproduit,		$	; LINT_PROTOTYPE input
	e=e,			$	; LINT_PROTOTYPE input
	m=m,			$	; LINT_PROTOTYPE input
	a=a,			$	; LINT_PROTOTYPE input
	d=d,			$	; LINT_PROTOTYPE input
	nbe=nbe,		$	; LINT_PROTOTYPE input
	nbm=nbm,		$	; LINT_PROTOTYPE input
	nom=nom				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Rajoute une branche pour un spectro D de MAVEN STATIC
;-------------------------------------------------------------------------------

	arbre = [ arbre, '5 ' + nomproduit + ' ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

	; "Timeseries"
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
	ajouter_dataset, arbre, '<dataset id="MAVEN:STATIC:'+nomproduit+'">6 Timeseries', nomcis, noproduit[0], nomsat, tab, 'MVN_STATIC_'+nomproduit, 'maven_static', /notime

	; "Particle spectrogram" et "Particle plot"
	unites = ['c/s','flux','JE','fdist']
	IF KEYWORD_SET(e) OR KEYWORD_SET(d) OR KEYWORD_SET(a) OR KEYWORD_SET(m) THEN BEGIN
		arbre = [ arbre, 																														$
			'6 Particle spectrogram' ]
		IF KEYWORD_SET(e) THEN BEGIN
			FOR i=0L,N_ELEMENTS(unites)-1 DO BEGIN
				IF noproduit[i] EQ -1 THEN CONTINUE
				unite = unites[i]
				nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit[i]),',')+' '+nomsat
				arbre = [ arbre, $
					'0 Time Energy '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' ion_nochamp='+STRJOIN(val_to_str(1+LINDGEN(nbm)),',')+' z_showdir=No z_theta=No z_phi=No yleft_log=Log yleft_auto=Manual yleft_min='+val_to_str(e[0])+' yleft_max='+val_to_str(e[1]) ]
			END
		END
		IF KEYWORD_SET(d) THEN BEGIN
			FOR i=0L,N_ELEMENTS(unites)-1 DO BEGIN
				IF noproduit[i] EQ -1 THEN CONTINUE
				unite = unites[i]
				nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit[i]),',')+' '+nomsat
				arbre = [ arbre, $
					'0 Time Deflection '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi cjf='+unite+' ion_nochamp='+STRJOIN(val_to_str(1+LINDGEN(nbm)),',')+' z_showdir=No z_theta=No z_phi=No yleft_log=Linear yleft_auto=Manual yleft_min='+val_to_str(d[0])+' yleft_max='+val_to_str(d[1]) ]
			END
		END
		IF KEYWORD_SET(a) THEN BEGIN
			FOR i=0L,N_ELEMENTS(unites)-1 DO BEGIN
				IF noproduit[i] EQ -1 THEN CONTINUE
				unite = unites[i]
				nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit[i]),',')+' '+nomsat
				arbre = [ arbre, $
					'0 Time Anode '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta cjf='+unite+' ion_nochamp='+STRJOIN(val_to_str(1+LINDGEN(nbm)),',')+' z_showdir=No z_theta=No z_phi=No yleft_log=Linear yleft_auto=Manual yleft_min='+val_to_str(a[0])+' yleft_max='+val_to_str(a[1]) ]
			END
		END
		IF KEYWORD_SET(m) THEN BEGIN
			FOR i=0L,N_ELEMENTS(unites)-1 DO BEGIN
				IF noproduit[i] EQ -1 THEN CONTINUE
				unite = unites[i]
				nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit[i]),',')+' '+nomsat
				arbre = [ arbre, $
					'0 Time Mass '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_mass cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_log=Log yleft_auto=Manual yleft_min='+val_to_str(m[0])+' yleft_max='+val_to_str(m[1])]
			END
		END
		IF KEYWORD_SET(m) AND KEYWORD_SET(e)THEN BEGIN
			FOR i=0L,N_ELEMENTS(unites)-1 DO BEGIN
				IF noproduit[i] EQ -1 THEN CONTINUE
				unite = unites[i]
				nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit[i]),',')+' '+nomsat
				arbre = [ arbre, $
					'0 Mass Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=mass_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Manual x_min='+val_to_str(m[0])+' x_max='+val_to_str(m[1])+' yleft_log=Log yleft_auto=Manual yleft_min='+val_to_str(e[0])+' yleft_max='+val_to_str(e[1]) ]
			END
		END
		IF KEYWORD_SET(a) AND KEYWORD_SET(d)THEN BEGIN
			FOR i=0L,N_ELEMENTS(unites)-1 DO BEGIN
				IF noproduit[i] EQ -1 THEN CONTINUE
				unite = unites[i]
				nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit[i]),',')+' '+nomsat
				arbre = [ arbre, $
					'0 Phi Theta AITOF '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta representation=(latitude,longitude)'+STRING(2b)+'map'+STRING(2b)+'AITOFF cjf='+unite+' ion_nochamp='+STRJOIN(val_to_str(1+LINDGEN(nbm)),',') + ' emin_nochamp=I'+val_to_str(nbe-1)+'#I0 emax_nochamp=I'+val_to_str(nbe-1)+'#I0  yleft_auto=Manual yleft_min='+val_to_str(a[0])+' yleft_max='+val_to_str(a[1])+' x_auto=Manual x_min='+val_to_str(d[0])+' x_max='+val_to_str(d[1])+'  z_showdir=No z_theta=No z_phi=No'	]
			END
		END
		IF KEYWORD_SET(e) AND KEYWORD_SET(a) AND KEYWORD_SET(d)THEN BEGIN
			FOR i=0L,N_ELEMENTS(unites)-1 DO BEGIN
				IF noproduit[i] EQ -1 THEN CONTINUE
				unite = unites[i]
				IF unite NE 'fdist' THEN CONTINUE
				nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit[i]),',')+' '+nomsat
				arbre = [ arbre, $
					'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=MAG3 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Manual yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',	$
					'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic'														]
			END
		END
		IF KEYWORD_SET(a) AND KEYWORD_SET(d)THEN BEGIN
			FOR i=0L,N_ELEMENTS(unites)-1 DO BEGIN
				IF noproduit[i] EQ -1 THEN CONTINUE
				unite = unites[i]
				nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit[i]),',')+' '+nomsat
				arbre = [ arbre, $
					'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function log0use=No cjf='+unite+' ion_nochamp='+STRJOIN(val_to_str(1+LINDGEN(nbm)),',') +' width_nochamp=100 interp_nochamp=None x_auto=Manual x_min=-3000.0 x_max=3000 yleft_auto=Manual yleft_min=-3000.0 yleft_max=3000.0 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No'														]
			END
		END
	END

	IF KEYWORD_SET(e) OR KEYWORD_SET(m) THEN BEGIN
		arbre = [ arbre, $
			'6 Particle plot' ]
		IF KEYWORD_SET(e) THEN BEGIN
			FOR i=0L,N_ELEMENTS(unites)-1 DO BEGIN
				IF noproduit[i] EQ -1 THEN CONTINUE
				unite = unites[i]
				nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit[i]),',')+' '+nomsat
				arbre = [ arbre, $
					'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																	$
					'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' ion_nochamp='+STRJOIN(val_to_str(1+LINDGEN(nbm)),',')+'                                        legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',	$
					'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' ion_nochamp='+STRJOIN(val_to_str(1+LINDGEN(nbm)),',')+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000'	]
			END
		END
		IF KEYWORD_SET(m) THEN BEGIN
			FOR i=0L,N_ELEMENTS(unites)-1 DO BEGIN
				IF noproduit[i] EQ -1 THEN CONTINUE
				unite = unites[i]
				nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit[i]),',')+' '+nomsat
				arbre = [ arbre, $
					'0 Mass '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=mass_cjf cjf='+unite+' ion_nochamp='+STRJOIN(val_to_str(1+LINDGEN(nbm)),',')+'                                      legend_theta=No legend_phi=No x_auto=Manual x_min=0.1 x_max=120',	$
					'0 Mass '+unite+' T1-T2#	'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=mass_cjf cjf='+unite+' ion_nochamp='+STRJOIN(val_to_str(1+LINDGEN(nbm)),',')+' spinaccu=0 time_onespin=No x_dx=50.0 legend_theta=No legend_phi=No x_auto=Manual x_min=0.1 x_max=120'	]
			END
		END
	END
	IF KEYWORD_SET(e) AND KEYWORD_SET(d) AND KEYWORD_SET(a) AND KEYWORD_SET(m) THEN BEGIN
		tab = [	'cl	N_cm3											#  				count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',					$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Vx_mso_km_sec,Vy_mso_km_sec,Vz_mso_km_sec,*V_km_sec					Vx,Vy,Vz,|V| 			count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Qx_mso_erg_sec_cm2,Qy_mso_erg_sec_cm2,Qz_mso_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|			count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Ei_eV_cm3										#				count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Ti_eV											#				count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Ex_mso,Ey_mso,Ez_mso									Ex,Ey,Ez			count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Vxpar_static_km_sec,Vypar_static_km_sec,Vzpar_static_km_sec,*Vpar_static_km_sec		Vx,Vy,Vz,|V|			count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Vxper_static_km_sec,Vyper_static_km_sec,Vzper_static_km_sec,*Vper_static_km_sec		Vx,Vy,Vz,|V|			count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Elx_static_mV_m,Ely_static_mV_m,Elz_static_mV_m,El_static_mV_m				Elx,Ely,Elz,|El|		count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Pp_nPa											#				count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Pm_nPa											#				count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Beta											#				count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Vxalfven_static_km_sec,Vyalfven_static_km_sec,Vzalfven_static_km_sec,*Valfven_km_sec	Vx,Vy,Vz,[V|			count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	An											#				count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Ng											#				count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No',				$
			'cl	Bx_mso_nT,By_mso_nT,Bz_mso_nT								Bx,By,Bz			count2d Bresolution=MAG3 type=moments ion_nochamp=1 emin_=1 emax_=1000000 legend_theta=No legend_phi=No'				$
		]
		ind = (WHERE (unites EQ 'JE'))[0]; produit 'JE' pour calculer les moments 3D
		ajouter_dataset, arbre, '<dataset id="MAVEN:STATIC:'+nom+'3DMOMENTS">6 3D moments', nomcis, noproduit[ind], nomsat, tab, 'MVN_STATIC_'+nom+'3DMOMENTS', 'maven_static', /moments
	END

END

;-------------------------------------------------------------------------------
PRO spectro_maven_swia_e,	$
;-------------------------------------------------------------------------------
	arbre,			$	; LINT_PROTOTYPE input
	p,			$	; LINT_PROTOTYPE input
	nomcis,			$	; LINT_PROTOTYPE input
	nomsat,			$	; LINT_PROTOTYPE input
	nosat,			$	; LINT_PROTOTYPE input
	nomproduit,		$	; LINT_PROTOTYPE input
	noproduit,		$	; LINT_PROTOTYPE input
	emin,			$	; LINT_PROTOTYPE input
	emax				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Rajoute une branche pour un spectro E de MAVEN SWIA
;-------------------------------------------------------------------------------

	arbre = [ arbre, '5 ' + nomproduit + ' ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MAVEN:SWIA:'+nomproduit+'">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MVN_SWIA_'+nomproduit, 'maven_swia', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'count'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'6 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min='+val_to_str(emin)+' yleft_max='+val_to_str(emax),																$
			'6 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',																	$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000'																	$
		]

END

;-------------------------------------------------------------------------------
PRO spectro_maven_swia_all,	$
;-------------------------------------------------------------------------------
	arbre,			$	; LINT_PROTOTYPE input
	p,			$	; LINT_PROTOTYPE input
	nomcis,			$	; LINT_PROTOTYPE input
	nomsat,			$	; LINT_PROTOTYPE input
	nosat,			$	; LINT_PROTOTYPE input
	nomproduit,		$	; LINT_PROTOTYPE input
	noproduit,		$	; LINT_PROTOTYPE input
	e=e,			$	; LINT_PROTOTYPE input
	a=a,			$	; LINT_PROTOTYPE input
	d=d,			$	; LINT_PROTOTYPE input
	nbe=nbe,		$	; LINT_PROTOTYPE input
	nom=nom				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Rajoute une branche pour un spectro D de MAVEN SWIA
;-------------------------------------------------------------------------------

	arbre = [ arbre, '5 ' + nomproduit + ' ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

	; "Timeseries"
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
	ajouter_dataset, arbre, '<dataset id="MAVEN:SWIA:'+nomproduit+'">6 Timeseries', nomcis, noproduit[0], nomsat, tab, 'MVN_SWIA_'+nomproduit, 'maven_swia', /notime

	; "Particle spectrogram" et "Particle plot"
	unites = ['c/s','flux','JE','fdist']
	IF KEYWORD_SET(e) OR KEYWORD_SET(d) OR KEYWORD_SET(a) THEN BEGIN
		arbre = [ arbre, 																														$
			'6 Particle spectrogram' ]
		IF KEYWORD_SET(e) THEN BEGIN
			FOR i=0L,N_ELEMENTS(unites)-1 DO BEGIN
				IF noproduit[i] EQ -1 THEN CONTINUE
				unite = unites[i]
				nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit[i]),',')+' '+nomsat
				arbre = [ arbre, $
					'0 Time Energy '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_log=Log yleft_auto=Manual yleft_min='+val_to_str(e[0])+' yleft_max='+val_to_str(e[1]) ]
			END
		END
		IF KEYWORD_SET(d) THEN BEGIN
			FOR i=0L,N_ELEMENTS(unites)-1 DO BEGIN
				IF noproduit[i] EQ -1 THEN CONTINUE
				unite = unites[i]
				nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit[i]),',')+' '+nomsat
				arbre = [ arbre, $
					'0 Time Deflection '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_log=Linear yleft_auto=Manual yleft_min='+val_to_str(d[0])+' yleft_max='+val_to_str(d[1]) ]
			END
		END
		IF KEYWORD_SET(a) THEN BEGIN
			FOR i=0L,N_ELEMENTS(unites)-1 DO BEGIN
				IF noproduit[i] EQ -1 THEN CONTINUE
				unite = unites[i]
				nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit[i]),',')+' '+nomsat
				arbre = [ arbre, $
					'0 Time Anode '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_log=Linear yleft_auto=Manual yleft_min='+val_to_str(a[0])+' yleft_max='+val_to_str(a[1]) ]
			END
		END
		IF KEYWORD_SET(a) AND KEYWORD_SET(d)THEN BEGIN
			FOR i=0L,N_ELEMENTS(unites)-1 DO BEGIN
				IF noproduit[i] EQ -1 THEN CONTINUE
				unite = unites[i]
				nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit[i]),',')+' '+nomsat
				arbre = [ arbre, $
					'0 Phi Theta AITOF '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta representation=(latitude,longitude)'+STRING(2b)+'map'+STRING(2b)+'AITOFF cjf='+unite+' emin_nochamp=I'+val_to_str(nbe-1)+'#I0 emax_nochamp=I'+val_to_str(nbe-1)+'#I0  yleft_auto=Manual yleft_min='+val_to_str(a[0])+' yleft_max='+val_to_str(a[1])+' x_auto=Manual x_min='+val_to_str(d[0])+' x_max='+val_to_str(d[1])+'  z_showdir=No z_theta=No z_phi=No'	]
			END
		END
		IF KEYWORD_SET(a) AND KEYWORD_SET(d)THEN BEGIN
			FOR i=0L,N_ELEMENTS(unites)-1 DO BEGIN
				IF noproduit[i] EQ -1 THEN CONTINUE
				unite = unites[i]
				IF unite EQ 'flux' OR unite EQ 'JE' OR unite EQ 'fdist' THEN BEGIN
					nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit[i]),',')+' '+nomsat
					arbre = [ arbre, $
						'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=MAG3 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Manual yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',	$
						'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic'														]
				END
			END
		END
		IF KEYWORD_SET(a) AND KEYWORD_SET(d)THEN BEGIN
			FOR i=0L,N_ELEMENTS(unites)-1 DO BEGIN
				IF noproduit[i] EQ -1 THEN CONTINUE
				unite = unites[i]
				nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit[i]),',')+' '+nomsat
				arbre = [ arbre, $
					'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-3000.0 x_max=3000.0 yleft_auto=Manual yleft_min=-3000.0 yleft_max=3000.0 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No'														]
			END
		END
	END

	IF KEYWORD_SET(e) THEN BEGIN
		arbre = [ arbre, $
			'6 Particle plot' ]
		IF KEYWORD_SET(e) THEN BEGIN
			FOR i=0L,N_ELEMENTS(unites)-1 DO BEGIN
				IF noproduit[i] EQ -1 THEN CONTINUE
				unite = unites[i]
				nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit[i]),',')+' '+nomsat
				arbre = [ arbre, $
					'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',										$
					'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',	$
					'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000'	]
			END
		END
	END

	IF KEYWORD_SET(e) AND KEYWORD_SET(d) AND KEYWORD_SET(a) THEN BEGIN
		tab = [	'cl	N_cm3											#  				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Vx_mso_km_sec,Vy_mso_km_sec,Vz_mso_km_sec,*V_km_sec					Vx,Vy,Vz,|V| 			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Qx_mso_erg_sec_cm2,Qy_mso_erg_sec_cm2,Qz_mso_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Ei_eV_cm3										#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Ti_eV											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Ex_mso,Ey_mso,Ez_mso									Ex,Ey,Ez			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Vxpar_swia_km_sec,Vypar_swia_km_sec,Vzpar_swia_km_sec,*Vpar_swia_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Vxper_swia_km_sec,Vyper_swia_km_sec,Vzper_swia_km_sec,*Vper_swia_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Elx_swia_mV_m,Ely_swia_mV_m,Elz_swia_mV_m,El_swia_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Pp_nPa											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Pm_nPa											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Beta											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Vxalfven_swia_km_sec,Vyalfven_swia_km_sec,Vzalfven_swia_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	An											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Ng											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Bx_mso_nT,By_mso_nT,Bz_mso_nT								Bx,By,Bz			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No'				$
		]
		ind = (WHERE (unites EQ 'JE'))[0]; produit 'JE' pour calculer les moments 3D
		ajouter_dataset, arbre, '<dataset id="MAVEN:SWIA:'+nom+'3DMOMENTS">6 3D moments', nomcis, noproduit[ind], nomsat, tab, 'MVN_SWIA_'+nom+'3DMOMENTS', 'maven_swia', /moments
	END

END


;-------------------------------------------------------------------------------
FUNCTION get_arbre_maven
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL MAVEN.
;-------------------------------------------------------------------------------
;
; Pas trouv dans spase

	COMMON COMMON_CL, general

	create_products, 'MAVEN'

	p = get(general,'p') ; p[noproduit,nocis,nosat]
	nomsat = 'SC1'
	nosat = STRMID(nomsat,2)


	arbre = [ '2 MAVEN' ]

	; ---------
	; ephemeris
	; ---------

	arbre = [ arbre, '3 ephemeris']
	nomcis = 'MAVEN-EPHEMERIS'
	; orbit
	noproduit = 0
	tab = [	'cl	X_Rm_MSO,Y_Rm_MSO,Z_Rm_MSO,Altitude_Rm		x,y,z,Alt 	orbito',							$
		'cl	X_Km_MSO,Y_Km_MSO,Z_Km_MSO			x,y,z		header',							$
		'cl	long_deg					# 		header',							$
		'cl	lat_deg						# 		header',							$
		'cl	Altitude_Km					#		header',							$
		'cl	X_Rm_MSO,Y_Rm_MSO,Z_Rm_MSO			x,y,z 		header',							$
		'cl	Altitude_Rm					# 		header',							$
		'cl	SZA_deg						# 		header',							$
		'cl	LT_h						# 		header',							$
		'cl	SH						# 		header'								]
	ajouter_dataset, arbre, '<dataset id="MAVEN:EPHEMERIS:ORBIT">4 orbit 1mn resolution', nomcis, noproduit, nomsat, tab, 'MVN_EPHEMERIS_ORBIT', 'maven_ephemeris'

	arbre = [ arbre, '4 attitude']

	; attitude MAVEN_SWEA -> MAVEN_MSO
	noproduit = [1]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="MAVEN:EPHEMERIS:ATTITUDE_SWEA_MSO">5 MAVEN_SWEA -> MAVEN_MSO 1sec resolution', nomcis, noproduit, nomsat, tab, 'MAVEN_EPHEMERIS_ATTITUDE_SWEA_MSO', 'maven_ephemeris'

	; attitude MAVEN_STATIC -> MAVEN_MSO
	noproduit = [2]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="MAVEN:EPHEMERIS:ATTITUDE_STATIC_MSO">5 MAVEN_STATIC -> MAVEN_MSO 1sec resolution', nomcis, noproduit, nomsat, tab, 'MAVEN_EPHEMERIS_ATTITUDE_STATIC_MSO', 'maven_ephemeris'

	; attitude MAVEN_SWIA -> MAVEN_MSO
	noproduit = [3]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="MAVEN:EPHEMERIS:ATTITUDE_SWIA_MSO">5 MAVEN_SWIA -> MAVEN_MSO 1sec resolution', nomcis, noproduit, nomsat, tab, 'MAVEN_EPHEMERIS_ATTITUDE_SWIA_MSO', 'maven_ephemeris'

	; ---
	; EUV
	; ---
	nomcis = 'MAVEN-EUV'
	arbre = [ arbre, 														$
		'<instrument name="EUV" id="MAVEN:EUV">3 EUV'									]

	; mvn_euv_l2_bands
	noproduit = [0]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="MAVEN:EUV:MVN_EUV_L2_BANDS">4 mvn_euv_l2_bands', nomcis, noproduit, nomsat, tab, 'MAVEN_EUV_L2_BANDS', 'maven_euv'

	arbre = [ arbre, '</instrument>' ]

	; --
	; KP
	; --
	nomcis = 'MAVEN-KP'
	arbre = [ arbre, 														$
		'<instrument name="KP" id="MAVEN:KP">3 KP'									]

	; mvn_kp_insitu
	noproduit = [0]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="MAVEN:KP:MVN_KP_INSITU">4 mvn_kp_insitu', nomcis, noproduit, nomsat, tab, 'MAVEN_KP_INSITU', 'maven_kp'

	; mvn_kp_insitu_helcats
	noproduit = [1]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="MAVEN:KP:MVN_KP_INSITU_HELCATS">4 mvn_kp_insitu_helcats res=1mn', nomcis, noproduit, nomsat, tab, 'MAVEN_KP_INSITU_HELCATS', 'maven_kp'

	arbre = [ arbre, '</instrument>' ]

	; ---
	; LPW
	; ---
	nomcis = 'MAVEN-LPW'
	arbre = [ arbre, 														$
		'<instrument name="LPW" id="MAVEN:LPW">3 LPW'									]

	; l2_mrgscpot
	noproduit = [0]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="MAVEN:LPW:L2_MRGSCPOT">4 l2_mrgscpot', nomcis, noproduit, nomsat, tab, 'MAVEN_LPW_L2_MRGSCPOT', 'maven_lpw'

	; l2_wn
	noproduit = [1]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="MAVEN:LPW:L2_WN">4 l2_wn', nomcis, noproduit, nomsat, tab, 'MAVEN_LPW_L2_WN', 'maven_lpw'

	; l2_lpnt
	noproduit = [2]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="MAVEN:LPW:L2_LPNT">4 l2_lpnt', nomcis, noproduit, nomsat, tab, 'MAVEN_LPW_L2_LPNT', 'maven_lpw'

	; l2_wspecact
	noproduit = [3]
	arbre = [ arbre, '4 l2_wspecact ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MAVEN:LPW:L2_WSPECACT">5 Timeseries', nomcis, noproduit, nomsat, tab, 'MVN_LPW_L2_WSPECACT', 'maven_lpw', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'Power'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'5 Particle spectrogram',																																										$
				'0 Time Frequency '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1 yleft_max=2e6',																				$
			'5 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Frequency '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                          legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=2e6',																	$
				'0 Frequency '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=100000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=2e6'																	$
		]

	; l2_wspecpas
	noproduit = [4]
	arbre = [ arbre, '4 l2_wspecpas ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MAVEN:LPW:L2_WSPECPAS">5 Timeseries', nomcis, noproduit, nomsat, tab, 'MVN_LPW_L2_WSPECPAS', 'maven_lpw', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'Wave_power'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'5 Particle spectrogram',																																										$
				'0 Time Frequency '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1 yleft_max=2e6',																				$
			'5 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Frequency '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                          legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=2e6',																	$
				'0 Frequency '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=100000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=2e6'																	$
		]

	arbre = [ arbre, '</instrument>' ]


	; ---
	; MAG
	; ---

	arbre = [ arbre, '3 MAG']
	nomcis = 'MAVEN-MAG'
	; MAG1
	noproduit = 0
	tab = [	'cl	Bx_SWEA_nT,By_SWEA_nT,Bz_SWEA_nT		Bx,By,Bz 	header',							$
		'cl	Bx_MSO_nT,By_MSO_nT,Bz_MSO_nT			Bx,By,Bz 	header',							$
		'cl	Br_nT,Bt_nT,Bp_nT				Br,Bt,Bp 	header',							$
		'cl	Bamp_SWEA_nT					#		header',							$
		'cl	Bthe_SWEA_deg					#		header',							$
		'cl	Bphi_SWEA_deg					# 		header'								]
	ajouter_dataset, arbre, '<dataset id="MAVEN:MAG:MAG1">4 MAG1', nomcis, noproduit, nomsat, tab, 'MVN_MAG_MAG1', 'maven_mag'

	; MAG2
	noproduit = 1
	tab = [	'cl	Bx_SWEA_nT,By_SWEA_nT,Bz_SWEA_nT		Bx,By,Bz 	header',							$
	        'cl	Bx_MSO_nT,By_MSO_nT,Bz_MSO_nT			Bx,By,Bz 	header',							$
		'cl	Br_nT,Bt_nT,Bp_nT				Br,Bt,Bp 	header',							$
		'cl	Bamp_SWEA_nT					#		header',							$
		'cl	Bthe_SWEA_deg					#		header',							$
		'cl	Bphi_SWEA_deg					# 		header'								]
	ajouter_dataset, arbre, '<dataset id="MAVEN:MAG:MAG2">4 MAG2', nomcis, noproduit, nomsat, tab, 'MVN_MAG_MAG2', 'maven_mag'

	; MAGPCFULL
	noproduit = 2
	tab = [	'cl	Bx_IAU_nT,By_IAU_nT,Bz_IAU_nT			Bx,By,Bz 	header',							$
		'cl	Br_nT,Bt_nT,Bp_nT				Br,Bt,Bp 	header',							$
		'cl	B_nT						# 		header',							$
		'cl	X_IAU_km,Y_IAU_km,Z_IAU_km			x,y,z		header'								]
	ajouter_dataset, arbre, '<dataset id="MAVEN:MAG:MAGPCFULL">4 MAGPCFULL', nomcis, noproduit, nomsat, tab, 'MVN_MAG_MAGPCFULL', 'maven_mag'

	; MAGSSFULL
	noproduit = 3
	tab = [	'cl	Bx_MSO_nT,By_MSO_nT,Bz_MSO_nT			Bx,By,Bz 	header',							$
		'cl	B_nT						# 		header',							$
		'cl	X_MSO_km,Y_MSO_km,Z_MSO_km			x,y,z		header'								]
	ajouter_dataset, arbre, '<dataset id="MAVEN:MAG:MAGSSFULL">4 MAGSSFULL', nomcis, noproduit, nomsat, tab, 'MVN_MAG_MAGSSFULL', 'maven_mag'

	; MAGPLFULL
	noproduit = 4
	tab = [	'cl	Bx_PL_nT,By_PL_nT,Bz_PL_nT			Bx,By,Bz 	header',							$
		'cl	B_nT						# 		header',							$
		'cl	X_PL_km,Y_PL_km,Z_PL_km				x,y,z		header'								]
	ajouter_dataset, arbre, '<dataset id="MAVEN:MAG:MAGPLFULL">4 MAGPLFULL', nomcis, noproduit, nomsat, tab, 'MVN_MAG_MAGPLFULL', 'maven_mag'

	; MAGPC1SEC
	noproduit = 5
	tab = [	'cl	Bx_IAU_nT,By_IAU_nT,Bz_IAU_nT			Bx,By,Bz 	header',							$
	        'cl	Br_nT,Bt_nT,Bp_nT				Br,Bt,Bp 	header',							$
		'cl	B_nT						# 		header',							$
		'cl	X_IAU_km,Y_IAU_km,Z_IAU_km			x,y,z		header'								]
	ajouter_dataset, arbre, '<dataset id="MAVEN:MAG:MAGPC1SEC">4 MAGPC1SEC', nomcis, noproduit, nomsat, tab, 'MVN_MAG_MAGPC1SEC', 'maven_mag'

	; MAGSS1SEC
	noproduit = 6
	tab = [	'cl	Bx_MSO_nT,By_MSO_nT,Bz_MSO_nT			Bx,By,Bz 	header',							$
		'cl	B_nT						# 		header',							$
		'cl	X_MSO_km,Y_MSO_km,Z_MSO_km			x,y,z		header'								]
	ajouter_dataset, arbre, '<dataset id="MAVEN:MAG:MAGSS1SEC">4 MAGSS1SEC', nomcis, noproduit, nomsat, tab, 'MVN_MAG_MAGSS1SEC', 'maven_mag'

	; MAGPL1SEC
	noproduit = 7
	tab = [	'cl	Bx_PL_nT,By_PL_nT,Bz_PL_nT			Bx,By,Bz 	header',							$
		'cl	B_nT						# 		header',							$
		'cl	X_PL_km,Y_PL_km,Z_PL_km				x,y,z		header'								]
	ajouter_dataset, arbre, '<dataset id="MAVEN:MAG:MAGPL1SEC">4 MAGPL1SEC', nomcis, noproduit, nomsat, tab, 'MVN_MAG_MAGPL1SEC', 'maven_mag'

	; MAG3
	noproduit = 8
	tab = [	'cl	B_calib						#		header',							$
		'cl	Bx_SWEA,By_SWEA,Bz_SWEA				Bx,By,Bz 	header',							$
		'cl	Bx_SWIA,By_SWIA,Bz_SWIA				Bx,By,Bz 	header',							$
		'cl	Bx_STATIC,By_STATIC,Bz_STATIC			Bx,By,Bz 	header',							$
		'cl	Bx_MSO,By_MSO,Bz_MSO				Bx,By,Bz 	header',							$
		'cl	Br,Bt,Bp					Br,Bt,Bp 	header',							$
		'cl	Bthe_MSO					#		header',							$
		'cl	Bphi_MSO					# 		header',							$
		'cl	B						#		header',							$
		'cl	Bavg						#		header'								]
	ajouter_dataset, arbre, '<dataset id="MAVEN:MAG:MAG3">4 MAG3', nomcis, noproduit, nomsat, tab, 'MVN_MAG_MAG3', 'maven_mag'

	; ------
	; MODELS
	; ------

	arbre = [ arbre, '3 MODELS']
	nomcis = 'MAVEN-MODELS'

	; CAIN
	noproduit = 0
	tab = [	'cl	Bx_Cain_MSO_nT,By_Cain_MSO_nT,Bz_Cain_MSO_nT			Bx,By,Bz 	header',							$
		'cl	Br_Cain_nT,Bt_Cain_nT,Bp_Cain_nT				Br,Bt,Bp 	header',							$
		'cl	B_Cain_nT							#		header',							$
		'cl	Bx_residual_MSO_nT,By_residual_MSO_nT,Bz_residual_MSO_nT	Bx,By,Bz 	header',							$
		'cl	B_residual_nT							#		header'								]
	ajouter_dataset, arbre, '<dataset id="MAVEN:MODELS:CAIN">4 CAIN for altitude lower than 3000 km', nomcis, noproduit, nomsat, tab, 'MVN_MODELS_CAIN', 'maven_models'

	; ARKANI
	noproduit = 1
	tab = [	'cl	Bx_Arkani_MSO_nT,By_Arkani_MSO_nT,Bz_Arkani_MSO_nT		Bx,By,Bz 	header',							$
		'cl	Br_Arkani_nT,Bt_Arkani_nT,Bp_Arkani_nT				Br,Bt,Bp 	header',							$
		'cl	B_Arkani_nT							#		header',							$
		'cl	Bx_residual_MSO_nT,By_residual_MSO_nT,Bz_residual_MSO_nT	Bx,By,Bz 	header',							$
		'cl	B_residual_nT							#		header'								]
	ajouter_dataset, arbre, '<dataset id="MAVEN:MODELS:ARKANI">4 ARKANI for altitude lower than 3000 km', nomcis, noproduit, nomsat, tab, 'MVN_MODELS_ARKANI', 'maven_models'

	; MORSCHHAUSER
	noproduit = 2
	tab = [	'cl	Bx_Morschhauser_MSO_nT,By_Morschhauser_MSO_nT,Bz_Morschhauser_MSO_nT	Bx,By,Bz 	header',						$
		'cl	Br_Morschhauser_nT,Bt_Morschhauser_nT,Bp_Morschhauser_nT		Br,Bt,Bp 	header',						$
		'cl	B_Morschhauser_nT							#		header',						$
		'cl	Bx_residual_MSO_nT,By_residual_MSO_nT,Bz_residual_MSO_nT		Bx,By,Bz 	header',						$
		'cl	B_residual_nT								#		header'							]
	ajouter_dataset, arbre, '<dataset id="MAVEN:MODELS:MORSCHHAUSER">4 MORSCHHAUSER for altitude lower than 3000 km', nomcis, noproduit, nomsat, tab, 'MVN_MODELS_MORSCHHAUSER', 'maven_models'

	arbre = [ arbre, $
		'4 CAIN Map at Mars surface ' + get_cldataset_starttime_endtime(nomcis,3,nomsat),																																																		$
		'0 |B| #	MAVEN_MODELS P3 SC1 count count3d type=RLONG_RLAT cjf=count yleft_log=Linear yleft_auto=Manual yleft_min=-90 yleft_max=90 x_auto=Manual x_min=0 x_max=360 moins180plus180=0&nbsp;360 RESOLUTION_RLONG_RLAT=0.5 CONTINENTS_RLONG_RLAT=No z_showdir=No z_theta=No z_phi=No z_energy=No z_title=Log(|B|)',																				$
		'0 Br  #	MAVEN_MODELS P6 SC1 count count3d type=RLONG_RLAT cjf=count yleft_log=Linear yleft_auto=Manual yleft_min=-90 yleft_max=90 x_auto=Manual x_min=0 x_max=360 moins180plus180=0&nbsp;360 RESOLUTION_RLONG_RLAT=0.5 CONTINENTS_RLONG_RLAT=No z_showdir=No z_theta=No z_phi=No z_energy=No z_title=Br z_zlog=Linear z_zauto=Manual z_zmin=-2000 z_zmax=2000 palette_firstcoul_r=0 palette_firstcoul_v=0 palette_firstcoul_b=139 palette_lastcoul_r=144 palette_lastcoul_v=0 palette_lastcoul_b=0',		$
		'4 ARKANI Map at Mars surface ' + get_cldataset_starttime_endtime(nomcis,4,nomsat),																																	$
		'0 |B| #	MAVEN_MODELS P4 SC1 count count3d type=RLONG_RLAT cjf=count yleft_log=Linear yleft_auto=Manual yleft_min=-90 yleft_max=90 x_auto=Manual x_min=0 x_max=360 moins180plus180=0&nbsp;360 RESOLUTION_RLONG_RLAT=0.5 CONTINENTS_RLONG_RLAT=No z_showdir=No z_theta=No z_phi=No z_energy=No z_title=Log(|B|)',			$
		'0 Br  #	MAVEN_MODELS P7 SC1 count count3d type=RLONG_RLAT cjf=count yleft_log=Linear yleft_auto=Manual yleft_min=-90 yleft_max=90 x_auto=Manual x_min=0 x_max=360 moins180plus180=0&nbsp;360 RESOLUTION_RLONG_RLAT=0.5 CONTINENTS_RLONG_RLAT=No z_showdir=No z_theta=No z_phi=No z_energy=No z_title=Br z_zlog=Linear z_zauto=Manual z_zmin=-2000 z_zmax=2000 palette_firstcoul_r=0 palette_firstcoul_v=0 palette_firstcoul_b=139 palette_lastcoul_r=144 palette_lastcoul_v=0 palette_lastcoul_b=0',		$
		'4 MORSCHHAUSER Map at Mars surface '+ get_cldataset_starttime_endtime(nomcis,5,nomsat),																																$
		'0 |B| #	MAVEN_MODELS P5 SC1 count count3d type=RLONG_RLAT cjf=count yleft_log=Linear yleft_auto=Manual yleft_min=-90 yleft_max=90 x_auto=Manual x_min=0 x_max=360 moins180plus180=0&nbsp;360 RESOLUTION_RLONG_RLAT=0.5 CONTINENTS_RLONG_RLAT=No z_showdir=No z_theta=No z_phi=No z_energy=No z_title=Log(|B|)',			$
		'0 Br  #	MAVEN_MODELS P8 SC1 count count3d type=RLONG_RLAT cjf=count yleft_log=Linear yleft_auto=Manual yleft_min=-90 yleft_max=90 x_auto=Manual x_min=0 x_max=360 moins180plus180=0&nbsp;360 RESOLUTION_RLONG_RLAT=0.5 CONTINENTS_RLONG_RLAT=No z_showdir=No z_theta=No z_phi=No z_energy=No z_title=Br z_zlog=Linear z_zauto=Manual z_zmin=-2000 z_zmax=2000 palette_firstcoul_r=0 palette_firstcoul_v=0 palette_firstcoul_b=139 palette_lastcoul_r=144 palette_lastcoul_v=0 palette_lastcoul_b=0'		$
	]

	; ---
	; NGI
	; ---
	nomcis = 'MAVEN-NGI'
	arbre = [ arbre, 													$
		'<instrument name="LPW" id="MAVEN:LPW">3 NGIMS'									]

	; mvn_ngi_l2_ion-abund
	noproduit = [0]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="MAVEN:NGI:L2_ION_ABUND">4 l2_ion-abund (Ion)', nomcis, noproduit, nomsat, tab, 'MAVEN_NGI_L2_ION_ABUND', 'maven_ngi'

	; mvn_ngi_l2_csn-abund
	noproduit = [1]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="MAVEN:NGI:L2_CSN_ABUND">4 l2_csn-abund (Neutral Ar, CO2, N2, He, CO)', nomcis, noproduit, nomsat, tab, 'MAVEN_NGI_L2_CSN_ABUND', 'maven_ngi'

	; mvn_ngi_l2_cso-abund
	noproduit = [2]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="MAVEN:NGI:L2_CSO_ABUND">4 l2_cso-abund (Neutral Ar, CO2, N2, He, CO, NO, O, O2)', nomcis, noproduit, nomsat, tab, 'MAVEN_NGI_L2_CSO_ABUND', 'maven_ngi'

	arbre = [ arbre, '</instrument>' ]

	; ---
	; SEP
	; ---
	nomcis = 'MAVEN-SEP'
	arbre = [ arbre, 													$
		'<instrument name="SEP" id="MAVEN:SEP">3 SEP'									]

	arbre = [ arbre, 									$
		'4 SEP1'									]

	; l2_s1-cal-svy-full_f_ion_flux
	noproduit = [0]
	arbre = [ arbre, '5 l2_s1-cal-svy-full f_ion_flux (Ion Flux in Forward look direction) ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MAVEN:SEP:L2_S1-CAL-SVY-FULL_F_ION_FLUX">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MVN_SEP_L2_S1-CAL-SVY-FULL_F_ION_FLUX', 'maven_sep', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'6 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1e4 yleft_max=1e7',																				$
			'6 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=6.5e6 legend_theta=No legend_phi=No x_auto=Manual x_min=1e4 x_max=1e7',																	$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=6.5e6 legend_theta=No legend_phi=No x_auto=Manual x_min=1e4 x_max=1e7'																	$
		]

	; l2_s1-cal-svy-full_f_elec_flux
	noproduit = [1]
	arbre = [ arbre, '5 l2_s1-cal-svy-full f_elec_flux (Electron Flux in Forward look direction) ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MAVEN:SEP:L2_S1-CAL-SVY-FULL_F_ELEC_FLUX">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MVN_SEP_L2_S1-CAL-SVY-FULL_F_ELEC_FLUX', 'maven_sep', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'6 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1e4 yleft_max=1e6',																				$
			'6 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=1.9e5 legend_theta=No legend_phi=No x_auto=Manual x_min=1e4 x_max=1e6',																	$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1.9e5 legend_theta=No legend_phi=No x_auto=Manual x_min=1e4 x_max=1e6'																	$
		]

	; l2_s1-cal-svy-full_r_ion_flux
	noproduit = [2]
	arbre = [ arbre, '5 l2_s1-cal-svy-full r_ion_flux (Ion Flux in Rear look direction) ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MAVEN:SEP:L2_S1-CAL-SVY-FULL_R_ION_FLUX">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MVN_SEP_L2_S1-CAL-SVY-FULL_R_ION_FLUX', 'maven_sep', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'6 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1e4 yleft_max=1e7',																				$
			'6 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=6.5e6 legend_theta=No legend_phi=No x_auto=Manual x_min=1e4 x_max=1e7',																	$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=6.5e6 legend_theta=No legend_phi=No x_auto=Manual x_min=1e4 x_max=1e7'																	$
		]

	; l2_s1-cal-svy-full_r_elec_flux
	noproduit = [3]
	arbre = [ arbre, '5 l2_s1-cal-svy-full r_elec_flux (Electron Flux in Rear look direction) ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MAVEN:SEP:L2_S1-CAL-SVY-FULL_R_ELEC_FLUX">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MVN_SEP_L2_S1-CAL-SVY-FULL_R_ELEC_FLUX', 'maven_sep', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'6 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1e4 yleft_max=1e6',																				$
			'6 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=1.9e5 legend_theta=No legend_phi=No x_auto=Manual x_min=1e4 x_max=1e6',																	$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1.9e5 legend_theta=No legend_phi=No x_auto=Manual x_min=1e4 x_max=1e6'																	$
		]

	arbre = [ arbre, 									$
		'4 SEP2'									]

	; l2_s2-cal-svy-full_f_ion_flux
	noproduit = [4]
	arbre = [ arbre, '5 l2_s2-cal-svy-full f_ion_flux (Ion Flux in Forward look direction) ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MAVEN:SEP:L2_S2-CAL-SVY-FULL_F_ION_FLUX">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MVN_SEP_L2_S2-CAL-SVY-FULL_F_ION_FLUX', 'maven_sep', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'6 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1e4 yleft_max=1e7',																				$
			'6 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=6.5e6 legend_theta=No legend_phi=No x_auto=Manual x_min=1e4 x_max=1e7',																	$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=6.5e6 legend_theta=No legend_phi=No x_auto=Manual x_min=1e4 x_max=1e7'																	$
		]

	; l2_s2-cal-svy-full_f_elec_flux
	noproduit = [5]
	arbre = [ arbre, '5 l2_s2-cal-svy-full f_elec_flux (Electron Flux in Forward look direction) ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MAVEN:SEP:L2_S2-CAL-SVY-FULL_F_ELEC_FLUX">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MVN_SEP_L2_S2-CAL-SVY-FULL_F_ELEC_FLUX', 'maven_sep', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'6 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1e4 yleft_max=1e6',																				$
			'6 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=1.9e5 legend_theta=No legend_phi=No x_auto=Manual x_min=1e4 x_max=1e6',																	$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1.9e5 legend_theta=No legend_phi=No x_auto=Manual x_min=1e4 x_max=1e6'																	$
		]

	; l2_s2-cal-svy-full_r_ion_flux
	noproduit = [6]
	arbre = [ arbre, '5 l2_s2-cal-svy-full r_ion_flux (Ion Flux in Rear look direction) ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MAVEN:SEP:L2_S2-CAL-SVY-FULL_R_ION_FLUX">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MVN_SEP_L2_S2-CAL-SVY-FULL_R_ION_FLUX', 'maven_sep', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'6 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1e4 yleft_max=1e7',																				$
			'6 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=6.5e6 legend_theta=No legend_phi=No x_auto=Manual x_min=1e4 x_max=1e7',																	$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=6.5e6 legend_theta=No legend_phi=No x_auto=Manual x_min=1e4 x_max=1e7'																	$
		]

	; l2_s2-cal-svy-full_r_elec_flux
	noproduit = [7]
	arbre = [ arbre, '5 l2_s2-cal-svy-full r_elec_flux (Electron Flux in Rear look direction) ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MAVEN:SEP:L2_S2-CAL-SVY-FULL_R_ELEC_FLUX">6 Timeseries', nomcis, noproduit, nomsat, tab, 'MVN_SEP_L2_S2-CAL-SVY-FULL_R_ELEC_FLUX', 'maven_sep', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'6 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1e4 yleft_max=1e6',																				$
			'6 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                            x_dx=1.9e5 legend_theta=No legend_phi=No x_auto=Manual x_min=1e4 x_max=1e6',																	$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1.9e5 legend_theta=No legend_phi=No x_auto=Manual x_min=1e4 x_max=1e6'																	$
		]

	arbre = [ arbre, '</instrument>' ]


	; ------
	; STATIC
	; ------

	arbre = [ arbre, '3 STATIC']
	nomcis = 'MAVEN-STATIC'

	no1 = 73
	no2 = 88
	no3 = 103

	arbre = [ arbre, '4 C0     64E x              2M          4 sec resolution, omnidirectional, useful for s/c potential']
	spectro_maven_static_e,   arbre, p, nomcis, nomsat, nosat, '64E (QL)',	 	0, 0.1, 100000
	spectro_maven_static_m,   arbre, p, nomcis, nomsat, nosat, '2M (QL)',	 	1
	spectro_maven_static_e,   arbre, p, nomcis, nomsat, nosat, '64E M0 (QL)',	2, 0.1, 100000
	spectro_maven_static_e,   arbre, p, nomcis, nomsat, nosat, '64E M1 (QL)',	3, 0.1, 100000
	spectro_maven_static_all, arbre, p, nomcis, nomsat, nosat, '64Ex2M', 		[4,no1++,no2++,no3++], e=[0.1,100000], m=[0.1,120], nbe=64, nbm=2

	arbre = [ arbre, '4 C2     32E x             32M']
	spectro_maven_static_e,   arbre, p, nomcis, nomsat, nosat, '32E (QL)',	 	5, 0.1, 100000
	spectro_maven_static_m,   arbre, p, nomcis, nomsat, nosat, '32M (QL)',	 	6
	spectro_maven_static_all, arbre, p, nomcis, nomsat, nosat, '32Ex32M', 		[7,no1++,no2++,no3++], e=[0.1,100000], m=[0.1,120], nbe=32, nbm=32

	arbre = [ arbre, '4 C4      4E x             64M']
	spectro_maven_static_e,   arbre, p, nomcis, nomsat, nosat, '4E (QL)', 	 	8, 0.1, 100000
	spectro_maven_static_m,   arbre, p, nomcis, nomsat, nosat, '64M (QL)',	 	9
	spectro_maven_static_all, arbre, p, nomcis, nomsat, nosat, '4Ex64M', 		[10,no1++,no2++,no3++], e=[0.1,100000], m=[0.1,120], nbe=4, nbm=64

	arbre = [ arbre, '4 C6     32E x             64M          4 sec resolution, omnidirectional, useful for composition']
	spectro_maven_static_e,   arbre, p, nomcis, nomsat, nosat, '32E (QL)', 		11, 0.1, 100000
	spectro_maven_static_m,   arbre, p, nomcis, nomsat, nosat, '64M (QL)', 		12
	spectro_maven_static_all, arbre, p, nomcis, nomsat, nosat, '32Ex64M', 		[13,no1++,no2++,no3++], e=[0.1,100000], m=[0.1,120], nbe=32, nbm=64

	arbre = [ arbre, '4 C8     32E x 16D                      4 sec resolution, useful for perpendicular temperature']
	spectro_maven_static_e,   arbre, p, nomcis, nomsat, nosat, '32E (QL)',		14, 0.1, 100000
	spectro_maven_static_d,   arbre, p, nomcis, nomsat, nosat, '16D (QL)',		15, -60.0, 60.0
	spectro_maven_static_all, arbre, p, nomcis, nomsat, nosat, '32Ex16D', 		[16,no1++,no2++,-1], e=[0.1,100000], d=[-60,60], nbe=32, nbm=1

	arbre = [ arbre, '4 CA     16E x  4D x 16A                4 sec resolution, useful for solid angle location']
	spectro_maven_static_e,   arbre, p, nomcis, nomsat, nosat, '16E (QL)',		17, 0.1, 100000
	spectro_maven_static_d,   arbre, p, nomcis, nomsat, nosat, '4D (QL)',		18, -60.0, 60.0
	spectro_maven_static_a,   arbre, p, nomcis, nomsat, nosat, '16A (QL)',		19, -180.0, 180.0
	spectro_maven_static_all, arbre, p, nomcis, nomsat, nosat, '16Ex4Dx16A',	[20,no1++,no2++,-1], e=[0.1,100000], d=[-60,60], a=[-180,180], nbe=16, nbm=1

	arbre = [ arbre, '4 CC     32E x  8D x       32M          Lower time resolution, 3D data product, Ram mode']
	spectro_maven_static_e,   arbre, p, nomcis, nomsat, nosat, '32E (QL)',		21, 0.1, 100000
	spectro_maven_static_d,   arbre, p, nomcis, nomsat, nosat, '8D (QL)',		22, -60.0, 60.0
	spectro_maven_static_m,   arbre, p, nomcis, nomsat, nosat, '32M (QL)',		23
	spectro_maven_static_all, arbre, p, nomcis, nomsat, nosat, '32Ex8Dx32M',	[24,no1++,no2++,no3++], e=[0.1,100000], d=[-60,60], m=[0.1,120], nbe=32, nbm=32

	arbre = [ arbre, '4 CD     32E x  8D x       32M          Lower time resolution, 3D data product, Ram mode (burst)']
	spectro_maven_static_e,   arbre, p, nomcis, nomsat, nosat, '32E (QL)',		25, 0.1, 100000
	spectro_maven_static_d,   arbre, p, nomcis, nomsat, nosat, '8D (QL)',		26, -60.0, 60.0
	spectro_maven_static_m,   arbre, p, nomcis, nomsat, nosat, '32M (QL)',		27
	spectro_maven_static_all, arbre, p, nomcis, nomsat, nosat, '32Ex8Dx32M',	[28,no1++,no2++,no3++], e=[0.1,100000], d=[-60,60], m=[0.1,120], nbe=32, nbm=32

	arbre = [ arbre, '4 CE     16E x  4D x 16A x 16M          Lower time resolution, 4D data product, Conic mode']
	spectro_maven_static_e,   arbre, p, nomcis, nomsat, nosat, '16E (QL)',		29, 0.1, 100000
	spectro_maven_static_d,   arbre, p, nomcis, nomsat, nosat, '4D (QL)',		30, -60.0, 60.0
	spectro_maven_static_a,   arbre, p, nomcis, nomsat, nosat, '16A (QL)',		31, -180.0, 180.0
	spectro_maven_static_m,   arbre, p, nomcis, nomsat, nosat, '16M (QL)',		32
	spectro_maven_static_all, arbre, p, nomcis, nomsat, nosat, '16Ex4Dx16Ax16M',	[33,no1++,no2++,no3++], e=[0.1,100000], d=[-60,60], a=[-180,180], m=[0.1,120], nbe=16, nbm=16, nom='CE'

	arbre = [ arbre, '4 CF     16E x  4D x 16A x 16M          Lower time resolution, 4D data product, Conic mode (burst)']
	spectro_maven_static_e,   arbre, p, nomcis, nomsat, nosat, '16E (QL)',		34, 0.1, 100000
	spectro_maven_static_d,   arbre, p, nomcis, nomsat, nosat, '4D (QL)',		35, -60.0, 60.0
	spectro_maven_static_a,   arbre, p, nomcis, nomsat, nosat, '16A (QL)',		36, -180.0, 180.0
	spectro_maven_static_m,   arbre, p, nomcis, nomsat, nosat, '16M (QL)',		37
	spectro_maven_static_all, arbre, p, nomcis, nomsat, nosat, '16Ex4Dx16Ax16M',	[38,no1++,no2++,no3++], e=[0.1,100000], d=[-60,60], a=[-180,180], m=[0.1,120], nbe=16, nbm=16, nom='CF'

	arbre = [ arbre, '4 D0     32E x  4D x 16A x  8M          Lower time resolution, 4D data product, Pickup, Eclipse, Protect modes']
	spectro_maven_static_e,   arbre, p, nomcis, nomsat, nosat, '32E (QL)',		39, 0.1, 100000
	spectro_maven_static_d,   arbre, p, nomcis, nomsat, nosat, '4D (QL)',		40, -60.0, 60.0
	spectro_maven_static_a,   arbre, p, nomcis, nomsat, nosat, '16A (QL)',		41, -180.0, 180.0
	spectro_maven_static_m,   arbre, p, nomcis, nomsat, nosat, '8M (QL)',		42
	spectro_maven_static_all, arbre, p, nomcis, nomsat, nosat, '32Ex4Dx16Ax8M',	[43,no1++,no2++,no3++], e=[0.1,100000], d=[-60,60], a=[-180,180], m=[0.1,120], nbe=32, nbm=8, nom='D0'

	arbre = [ arbre, '4 D1     32E x  4D x 16A x  8M          Lower time resolution, 4D data product, Pickup, Eclipse, Protect modes (burst)']
	spectro_maven_static_e,   arbre, p, nomcis, nomsat, nosat, '32E (QL)',		44, 0.1, 100000
	spectro_maven_static_d,   arbre, p, nomcis, nomsat, nosat, '4D (QL)',		45, -60.0, 60.0
	spectro_maven_static_a,   arbre, p, nomcis, nomsat, nosat, '16A (QL)',		46, -180.0, 180.0
	spectro_maven_static_m,   arbre, p, nomcis, nomsat, nosat, '8M (QL)',		47
	spectro_maven_static_all, arbre, p, nomcis, nomsat, nosat, '32Ex4Dx16Ax8M',	[48,no1++,no2++,no3++], e=[0.1,100000], d=[-60,60], a=[-180,180], m=[0.1,120], nbe=32, nbm=8, nom='D1'

	arbre = [ arbre, '4 D2     32E x       16A x  8M']
	spectro_maven_static_e,   arbre, p, nomcis, nomsat, nosat, '32E (QL)',		49, 0.1, 100000
	spectro_maven_static_a,   arbre, p, nomcis, nomsat, nosat, '16A (QL)',		50, -180.0, 180.0
	spectro_maven_static_m,   arbre, p, nomcis, nomsat, nosat, '8M (QL)',		51
	spectro_maven_static_all, arbre, p, nomcis, nomsat, nosat, '32Ex16Ax8M',	[52,no1++,no2++,no3++], e=[0.1,100000], a=[-180,180], m=[0.1,120], nbe=32, nbm=8

	arbre = [ arbre, '4 D3     ??E x       ??A x ??M          NO DATA']
	spectro_maven_static_e, arbre, p, nomcis, nomsat, nosat, '?E (QL)',			53, 1.0, 5000
	spectro_maven_static_m, arbre, p, nomcis, nomsat, nosat, '?M (QL)',			55

	arbre = [ arbre, '4 D4            4D x 16A x  2M']
	spectro_maven_static_d,   arbre, p, nomcis, nomsat, nosat, '4D (QL)',		57, -60.0, 60.0
	spectro_maven_static_a,   arbre, p, nomcis, nomsat, nosat, '16A (QL)',		58, -180.0, 180.0
	spectro_maven_static_m,   arbre, p, nomcis, nomsat, nosat, '2M (QL)',		59
	spectro_maven_static_all, arbre, p, nomcis, nomsat, nosat, '4Dx16Ax2M',		[60,no1++,no2++,no3++], d=[-60,60], a=[-180,180], m=[0.1,120], nbe=1, nbm=2

	arbre = [ arbre, '4 DA     64E                            Rate data packets, useful for dead time corrections']
	spectro_maven_static_e, arbre, p, nomcis, nomsat, nosat, '64E (QL)',			61, 0.1, 100000

	arbre = [ arbre, '4 DB     1024TOF                        Lower time resolution, All modes']
	spectro_maven_static_m, arbre, p, nomcis, nomsat, nosat, '1024M (QL)',		62

	arbre = [ arbre, '4 P4     ??E x ??D x ??A x ??M          NO DATA']
	spectro_maven_static_e, arbre, p, nomcis, nomsat, nosat, '?Ex (QL)',			63, 1.0, 5000
	spectro_maven_static_m, arbre, p, nomcis, nomsat, nosat, '?M (QL)',			66

	arbre = [ arbre, '4 P4_arc ??E x ??D x ??A x ??M          NO DATA']
	spectro_maven_static_e, arbre, p, nomcis, nomsat, nosat, '?E (QL)',			68, 1.0, 5000
	spectro_maven_static_m, arbre, p, nomcis, nomsat, nosat, '?M (QL)',			71


	; ----
	; SWEA
	; ----

	arbre = [ arbre, '3 SWEA']
	nomcis = 'MAVEN-SWEA'

	; SLOW_HSK
	noproduit = 14
	vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
	ajouter_dataset, arbre, '<dataset id="MAVEN:SWEA:SLOW_HSK">4 Housekeeping SLOW_HSK', nomcis, noproduit, nomsat, tab, 'MVN_SWEA_SLOW_HSK', 'maven_swea'

	; FAST_HSK
	noproduit = 15
	vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
	ajouter_dataset, arbre, '<dataset id="MAVEN:SWEA:FAST_HSK">4 Housekeeping FAST_HSK', nomcis, noproduit, nomsat, tab, 'MVN_SWEA_FAST_HSK', 'maven_swea'

	; 3D
	noproduit = [0,1,2,3,4,5]
	arbre = [ arbre, '4 3D ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MAVEN:SWEA:3D">5 Timeseries', nomcis, noproduit, nomsat, tab, 'MVN_SWEA_3D', 'maven_swea', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'JE'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'5 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1 yleft_max=10000',																	$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=MAG3 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Automatic spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',						$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																			$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=-90 x_max=90 z_showdir=No z_theta=No z_phi=No',															$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-30000.0 x_max=30000 yleft_auto=Manual yleft_min=-30000.0 yleft_max=30000.0 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',	$
			'5 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',													$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',													$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=MAG3 cjf='+unite+' x_dx=100.0 pad_nbalphas=16 bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																	$
		]

		; 3D MOMENTS
		tab = [	'cl	N_cm3											#  				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Vx_mso_km_sec,Vy_mso_km_sec,Vz_mso_km_sec,*V_km_sec					Vx,Vy,Vz,|V| 			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Qx_mso_erg_sec_cm2,Qy_mso_erg_sec_cm2,Qz_mso_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Ei_eV_cm3										#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Ti_eV											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Ex_mso,Ey_mso,Ez_mso									Ex,Ey,Ez			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Vxpar_swea_km_sec,Vypar_swea_km_sec,Vzpar_swea_km_sec,*Vpar_swea_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Vxper_swea_km_sec,Vyper_swea_km_sec,Vzper_swea_km_sec,*Vper_swea_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Elx_swea_mV_m,Ely_swea_mV_m,Elz_swea_mV_m,El_swea_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Pp_nPa											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Pm_nPa											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Beta											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Vxalfven_swea_km_sec,Vyalfven_swea_km_sec,Vzalfven_swea_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	An											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Ng											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Bx_mso_nT,By_mso_nT,Bz_mso_nT								Bx,By,Bz			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Scpot_V											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	quality_index_0										#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	quality_index_1										#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	quality_index_2										#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No'				$
		]
		ajouter_dataset, arbre, '<dataset id="MAVEN:SWEA:3D_3DMOMENTS">5 3D moments', nomcis, noproduit, nomsat, tab, 'MVN_SWEA_3D_3DMOMENTS', 'maven_swea', /moments, /notime


	; PAD
	noproduit = [6,7,8,9,10,11]
	arbre = [ arbre, '4 PAD ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat) ]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MAVEN:SWEA:PAD">5 Timeseries', nomcis, noproduit, nomsat, tab, 'MVN_SWEA_PAD', 'maven_swea'

		; "Particle spectrogram" et "Particle plot"
		unite = 'JE'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																								$
			'5 Particle spectrogram',																																						$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1 yleft_max=10000',																$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=MAG_PAD_SURVEY cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Automatic spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',	$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',															$
			'5 Particle plot',																																							$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																						$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',									$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',									$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=MAG3 cjf='+unite+' x_dx=100.0 pad_nbalphas=16 bulk_speed_auto=Automatic legend_theta=No legend_phi=No'													$
		]

	; ENGY
	noproduit = [12,13]
	arbre = [ arbre, '4 ENGY ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="MAVEN:SWEA:ENERGY">5 Timeseries', nomcis, noproduit, nomsat, tab, 'MVN_SWEA_ENERGY', 'maven_swea', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'JE'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'5 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1 yleft_max=10000',																				$
			'5 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',													$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000'													$
		]

		; 1D MOMENTS
		tab = [	'cl	N_cm3											#  				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	Scpot_V											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	quality_index_0										#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	quality_index_1										#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
			'cl	quality_index_2										#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No'				$
		]
		ajouter_dataset, arbre, '<dataset id="MAVEN:SWEA:ENGY_3DMOMENTS">5 1D moments', nomcis, noproduit, nomsat, tab, 'MVN_SWEA_ENGY_3DMOMENTS', 'maven_swea', /moments, /notime

	; SC_POT
	noproduit = 18
	vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
	tab = [	'cl	Sc_Pot_V									#  				header yleft_typetitle=Unit',				$
		'cl	Sc_Pot_Method									#				header yleft_auto=Manual yleft_min=-2 yleft_max=6 yleft_tickv=-1'+STRING(2b)+'0'+STRING(2b)+'1'+STRING(2b)+'2'+STRING(2b)+'3'+STRING(2b)+'4'+STRING(2b)+'5 yleft_tickname=invalid'+STRING(2b)+'manually_set'+STRING(2b)+'SWE/LPW'+STRING(2b)+'SWE+'+STRING(2b)+'SWE-'+STRING(2b)+'STA-'+STRING(2b)+'SWEPAD']
	ajouter_dataset, arbre, '<dataset id="MAVEN:SWEA:SC_POT">4 SC_POT', nomcis, noproduit, nomsat, tab, 'MVN_SWEA_SC_POT', 'maven_swea'

	; ----
	; SWIA
	; ----

	arbre = [ arbre, '3 SWIA']
	nomcis = 'MAVEN-SWIA'

	; SWICS
	noproduit = 0
	arbre = [ arbre, '4 SWICS (Coarse Survey 3d) ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
	spectro_maven_swia_e,   arbre, p, nomcis, nomsat, nosat, '48E (QL)', 	0, 10, 100000
	spectro_maven_swia_all, arbre, p, nomcis, nomsat, nosat, '48Ex4Dx16A',	[13,14,15,16], e=[10,100000], d=[-60,60], a=[0,360], nbe=48, nom='SWICS'


	; SWICA
	noproduit = 1
	arbre = [ arbre, '4 SWICA (Coarse Archive 3d) ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
	spectro_maven_swia_e,   arbre, p, nomcis, nomsat, nosat, '48E (QL)', 	1, 10, 100000
	spectro_maven_swia_all, arbre, p, nomcis, nomsat, nosat, '48Ex4Dx16A',	[17,18,19,20], e=[10,100000], d=[-60,60], a=[0,360], nbe=48, nom='SWICA'

	; SWIFS
	noproduit = 2
	arbre = [ arbre, '4 SWIFS (Fine Survey 3d) ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
	spectro_maven_swia_e,   arbre, p, nomcis, nomsat, nosat, '48E (QL)', 	2, 10, 100000
	spectro_maven_swia_all, arbre, p, nomcis, nomsat, nosat, '48Ex12Dx10A',	[21,22,23,24], e=[10,100000], d=[-60,60], a=[0,360], nbe=48, nom='SWIFS'

	; SWIFA
	noproduit = 3
	arbre = [ arbre, '4 SWIFA (Fine Archive 3d) ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
	spectro_maven_swia_e,   arbre, p, nomcis, nomsat, nosat, '48E (QL)', 	3, 10, 100000
	spectro_maven_swia_all, arbre, p, nomcis, nomsat, nosat, '48Ex12Dx10A',	[25,26,27,28], e=[10,100000], d=[-60,60], a=[0,360], nbe=48, nom='SWIFA'

	; SWIS
	noproduit = 4
	arbre = [ arbre, '4 SWIS (Onboard Energy Spectra) ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
	spectro_maven_swia_e,   arbre, p, nomcis, nomsat, nosat, '48E (QL)', 	4, 10, 100000
	spectro_maven_swia_all, arbre, p, nomcis, nomsat, nosat, '48E',		[29,30,31,32], e=[10,100000], nbe=48

	; DENSITY
	noproduit = 5
	tab = [	'cl	density	# 	header' ]
	ajouter_dataset, arbre, '<dataset id="MAVEN:SWIA:DENSITY">4 Density L1', nomcis, noproduit, nomsat, tab, 'MVN_SWIA_DENSITY', 'maven_swia'

	; VELOCITY
	noproduit = 6
	tab = [	'cl	Vx,Vy,Vz Vx,Vy,Vz header' ]
	ajouter_dataset, arbre, '<dataset id="MAVEN:SWIA:VELOCITY">4 Velocity L1', nomcis, noproduit, nomsat, tab, 'MVN_SWIA_VELOCITY', 'maven_swia'

	; PRESSURE
	noproduit = 7
	tab = [	'cl	Pxx,Pyy,Pzz,Pxy,Pxz,Pyz Pxx,Pyy,Pzz,Pxy,Pxz,Pyz header' ]
	ajouter_dataset, arbre, '<dataset id="MAVEN:SWIA:VELOCITY">4 Pressure L1', nomcis, noproduit, nomsat, tab, 'MVN_SWIA_PRESSURE', 'maven_swia'

	; TEMPERATURE
	noproduit = 8
	tab = [	'cl	Tx,Ty,Tz Tx,Ty,Tz header' ]
	ajouter_dataset, arbre, '<dataset id="MAVEN:SWIA:TEMPERATURE">4 Temperature L1', nomcis, noproduit, nomsat, tab, 'MVN_SWIA_TEMPERATURE', 'maven_swia'

	; HEATFLUX
	noproduit = 9
	tab = [	'cl	Qx,Qy,Qz Qx,Qy,Qz header' ]
	ajouter_dataset, arbre, '<dataset id="MAVEN:SWIA:HEATFLUX">4 Heatflux L1', nomcis, noproduit, nomsat, tab, 'MVN_SWIA_HEATFLUX', 'maven_swia'

	; QUALITY FLAG
	noproduit = 10
	tab = [	'cl	quality_flag	# 	header' ]
	ajouter_dataset, arbre, '<dataset id="MAVEN:SWIA:QUALITYFLAG">4 Quality flag L1', nomcis, noproduit, nomsat, tab, 'MVN_SWIA_QUALITYFLAG', 'maven_swia'

	; DECOM FLAG
	noproduit = 11
	tab = [	'cl	decom_flag	# 	header' ]
	ajouter_dataset, arbre, '<dataset id="MAVEN:SWIA:DECOMFLAG">4 Decom flag L1', nomcis, noproduit, nomsat, tab, 'MVN_SWIA_DECOMFLAG', 'maven_swia'

	; ONBOARDSVYMOM
	noproduit = 12
	tab = [	'cl	atten_state							#				header',	$
		'cl	telem_mode							#				header',	$
		'cl	quality_flag							#				header',	$
		'cl	decom_flag							#				header',	$
		'cl	N								#				header',	$
		'cl	Pxx_swia,Pyy_swia,Pzz_swia,Pxy_swia,Pxz_swia,Pyz_swia		Pxx,Pyy,Pzz,Pxy,Pxz,Pyz		header',	$
		'cl	Vx_swia,Vy_swia,Vz_swia						Vx,Vy,Vz			header',	$
		'cl	Vx_mso,Vy_mso,Vz_mso						Vx,Vy,Vz			header',	$
		'cl	Tx_swia,Ty_swia,Tz_swia						Tx,Ty,Tz			header',	$
		'cl	Tx_mso,Ty_mso,Tz_mso						Tx,Ty,Tz			header',	$
		'cl	cone_angle							#				header',	$
		'cl	clock_angle							#				header',	$
		'cl	Vx_swea,Vy_swea,Vz_swea						Vx,Vy,Vz			header',	$
		'cl	Pxx_mso,Pyy_mso,Pzz_mso,Pxy_mso,Pxz_mso,Pyz_mso			Pxx,Pyy,Pzz,Pxy,Pxz,Pyz		header'		]

	ajouter_dataset, arbre, '<dataset id="MAVEN:SWIA:ONBOARDSVYMOM">4 ONBOARDSVYMOM L2', nomcis, noproduit, nomsat, tab, 'MVN_SWIA_ONBOARDSVYMOM', 'maven_swia'

	; -----------------
	; MARS B CONNECTION
	; -----------------

	nomcis = 'MAVEN-EPHEMERIS'
	; MARS_B_CONNECTION
	noproduit = 4
	tab = [	'cl	X_Km_MSO,Y_Km_MSO,Z_Km_MSO			x,y,z		header',							$
		'cl	long_deg					# 		header',							$
		'cl	lat_deg						# 		header',							$
		'cl	Bx_MSO,By_MSO,Bz_MSO				Bx,By,Bz 	header',							$
		'cl	thBX						# 		header',							$
		'cl	thBn						# 		header',							$
		'cl	thVn						# 		header',							$
		'cl	Dist						# 		header',							$
		'cl	nShockX,nShockY,nShockZ				x,y,z 		header',							$
		'cl	AshockX,AshockY,AshockZ				x,y,z 		header',							$
		'cl	DF						# 		header'								]
	ajouter_dataset, arbre, '<dataset id="MAVEN:EPHEMERIS:MARS_B_CONNECTION">3 Mars B connection 1mn resolution', nomcis, noproduit, nomsat, tab, 'MVN_EPHEMERIS_MARS_B_CONNECTION', 'maven_ephemeris'

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_psp
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL Parker Solar Probe.
;-------------------------------------------------------------------------------

; Pas trouv dans spase

	COMMON COMMON_CL, general

	create_products, 'PSP'

	p = get(general,'p') ; p[noproduit,nocis,nosat]
	nomsat = 'SC1'
	nosat = STRMID(nomsat,2)


	arbre = [ '2 PSP' ]

	; ---------
	; ephemeris
	; ---------

	arbre = [ arbre, '3 EPHEMERIS']
	nomcis = 'PSP-EPHEMERIS'

	; orbit
	noproduit = 0
	tab = [	'cl	sc_xpos_HCI,sc_ypos_HCI,sc_zpos_HCI		x,y,z 		orbito',							$
		'cl	sc_xpos_HCI,sc_ypos_HCI,sc_zpos_HCI		x,y,z		header',							$
		'cl	sc_xvel_HCI,sc_yvel_HCI,sc_zvel_HCI		vx,vy,vz	header',							$
		'cl	carr_latitude					# 		header',							$
		'cl	carr_longitude					# 		header',							$
		'cl	distance_RS					# 		header',							$
		'cl	distance_AU					# 		header'								]
	ajouter_dataset, arbre, '<dataset id="PSP:EPHEMERIS:ORBIT">4 orbit', nomcis, noproduit, nomsat, tab, 'PSP_EPHEMERIS_ORBIT', 'psp_ephemeris'


	; --
	; KP
	; ---

	arbre = [ arbre, '3 KP']
	nomcis = 'PSP-KP'

	; L2_30sec
	noproduit = [0]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="PSP:KP:L2_30S">4 L2 30 sec resolution', nomcis, noproduit, nomsat, tab, 'PSP_KP_L2_30S', 'psp_kp'


	; ---
	; MAG
	; ----

	arbre = [ arbre, '3 MAG']
	nomcis = 'PSP-MAG'

	arbre = [ arbre, '4 OLD']

	; L2_1MIN
	noproduit = [0]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="PSP:MAG:L2_1MIN">5 L2 1 min resolution', nomcis, noproduit, nomsat, tab, 'PSP_MAG_L2_1MIN', 'psp_mag'

	;BERKELEY
	noproduit = [1]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="PSP:MAG:BERKELEY">5 BERKELEY 0.2 sec resolution', nomcis, noproduit, nomsat, tab, 'PSP_MAG_BERKELEY', 'psp_mag'

	arbre = [ arbre, '4 L2_draft']

	; L2_DRAFT
	noproduit = [2]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="PSP:MAG:L2_DRAFT">5 L2_DRAFT 15 ms resolution', nomcis, noproduit, nomsat, tab, 'PSP_MAG_L2_DRAFT', 'psp_mag'

	arbre = [ arbre, '4 L2']

	; L2
	noproduit = [3]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="PSP:MAG:L2">5 L2 250 ms resolution', nomcis, noproduit, nomsat, tab, 'PSP_MAG_L2', 'psp_mag'

	; ----------
	; FORMAGONLY
	; ----------

	arbre = [ arbre, '3 MAG (formagonly)']
	nomcis = 'PSP-FORMAGONLY'

	arbre = [ arbre, '4 L2']

	; L2_1MIN
	noproduit = [0]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="PSP:FORMAGONLY:L2_1MIN">5 L2 RTN 1 min resolution', nomcis, noproduit, nomsat, tab, 'PSP_FORMAGONLY_L2_1MIN', 'psp_mag'

;	; ---
;	; SPA
;	; ----
;
;	arbre = [ arbre, '3 SPA']
;	nomcis = 'PSP-SPA'
;
;	; 1D Electron SF1
;	noproduit = [0]
;	arbre = [ arbre, '4 1D Electron SF1 ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
;
;		; "Timeseries"
;		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
;		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
;		ajouter_dataset, arbre, '<dataset id="PSP:SPA:ENERGYSF1">5 Timeseries', nomcis, noproduit, nomsat, tab, 'PSP_SPA_ENERGYSF1', 'psp_spa', /notime
;
;		; "Particle spectrogram" et "Particle plot"
;		unite = 'JE'
;		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
;		arbre = [ arbre, 																																												$
;			'5 Particle spectrogram',																																										$
;				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1 yleft_max=10000',																				$
;			'5 Particle plot',																																											$
;				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
;				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',													$
;				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000'													$
;		]
;
;	; 1D Electron ST1
;	noproduit = [1]
;	arbre = [ arbre, '4 1D Electron ST1 ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
;
;		; "Timeseries"
;		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
;		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
;		ajouter_dataset, arbre, '<dataset id="PSP:SPA:ENERGYST1">5 Timeseries', nomcis, noproduit, nomsat, tab, 'PSP_SPA_ENERGYST1', 'psp_spa', /notime
;
;		; "Particle spectrogram" et "Particle plot"
;		unite = 'JE'
;		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
;		arbre = [ arbre, 																																												$
;			'5 Particle spectrogram',																																										$
;				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1 yleft_max=10000',																				$
;			'5 Particle plot',																																											$
;				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
;				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',													$
;				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000'													$
;		]
;
;
;	; 3D Electron SF0
;	noproduit = [2]
;	arbre = [ arbre, '4 3D Electron SF0 ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
;
;		; "Timeseries"
;		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
;		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
;		ajouter_dataset, arbre, '<dataset id="PSP:SPA:3DSF0">5 Timeseries', nomcis, noproduit, nomsat, tab, 'PSP_SPA_3DSF0', 'psp_spa', /notime
;
;		; "Particle spectrogram" et "Particle plot"
;		unite = 'JE'
;		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
;		arbre = [ arbre, 																																												$
;			'5 Particle spectrogram',																																										$
;				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1 yleft_max=10000',																	$
;				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
;				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
;				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=MAG3 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Automatic spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',						$
;				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																			$
;				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=-90 x_max=90 z_showdir=No z_theta=No z_phi=No',															$
;				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-30000.0 x_max=30000 yleft_auto=Manual yleft_min=-30000.0 yleft_max=30000.0 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',	$
;			'5 Particle plot',																																											$
;				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
;				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',													$
;				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',													$
;				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=MAG3 cjf='+unite+' x_dx=100.0 pad_nbalphas=16 bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																	$
;		]
;
;		; 3D MOMENTS
;		tab = [	'cl	N_cm3											#  				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ei_eV_cm3										#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ti_eV											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vxpar_spa_km_sec,Vypar_spa_km_sec,Vzpar_spa_km_sec,*Vpar_spa_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vxper_spa_km_sec,Vyper_spa_km_sec,Vzper_spa_km_sec,*Vper_spa_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Elx_spa_mV_m,Ely_spa_mV_m,Elz_spa_mV_m,El_spa_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Pp_nPa											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Pm_nPa											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Beta											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vxalfven_spa_km_sec,Vyalfven_spa_km_sec,Vzalfven_spa_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	An											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ng											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No'				$
;		]
;		ajouter_dataset, arbre, '<dataset id="PSP:SPA:3D_3DMOMENTSSF0">5 3D moments', nomcis, noproduit, nomsat, tab, 'PSP_SPA_3DMOMENTSSF0', 'psp_spa', /moments, /notime
;
;	; 3D Electron ST0
;	noproduit = [3]
;	arbre = [ arbre, '4 3D Electron ST0 ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
;
;		; "Timeseries"
;		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
;		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
;		ajouter_dataset, arbre, '<dataset id="PSP:SPA:3DST0">5 Timeseries', nomcis, noproduit, nomsat, tab, 'PSP_SPA_3DST0', 'psp_spa', /notime
;
;		; "Particle spectrogram" et "Particle plot"
;		unite = 'JE'
;		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
;		arbre = [ arbre, 																																												$
;			'5 Particle spectrogram',																																										$
;				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1 yleft_max=10000',																	$
;				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
;				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
;				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=MAG3 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Automatic spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',						$
;				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																			$
;				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=-90 x_max=90 z_showdir=No z_theta=No z_phi=No',															$
;				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-30000.0 x_max=30000 yleft_auto=Manual yleft_min=-30000.0 yleft_max=30000.0 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',	$
;			'5 Particle plot',																																											$
;				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
;				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',													$
;				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',													$
;				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=MAG3 cjf='+unite+' x_dx=100.0 pad_nbalphas=16 bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																	$
;		]
;
;		; 3D MOMENTS
;		tab = [	'cl	N_cm3											#  				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ei_eV_cm3										#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ti_eV											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vxpar_spa_km_sec,Vypar_spa_km_sec,Vzpar_spa_km_sec,*Vpar_spa_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vxper_spa_km_sec,Vyper_spa_km_sec,Vzper_spa_km_sec,*Vper_spa_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Elx_spa_mV_m,Ely_spa_mV_m,Elz_spa_mV_m,El_spa_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Pp_nPa											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Pm_nPa											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Beta											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vxalfven_spa_km_sec,Vyalfven_spa_km_sec,Vzalfven_spa_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	An											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ng											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No'				$
;		]
;		ajouter_dataset, arbre, '<dataset id="PSP:SPA:3D_3DMOMENTSST0">5 3D moments', nomcis, noproduit, nomsat, tab, 'PSP_SPA_3DMOMENTSST0', 'psp_spa', /moments, /notime
;
;	; 3D Ion SF00
;	noproduit = [4]
;	arbre = [ arbre, '4 3D Ion SF00 ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
;
;		; "Timeseries"
;		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
;		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
;		ajouter_dataset, arbre, '<dataset id="PSP:SPA:3DST00">5 Timeseries', nomcis, noproduit, nomsat, tab, 'PSP_SPA_3DST00', 'psp_spa', /notime
;
;		; "Particle spectrogram" et "Particle plot"
;		unite = 'JE'
;		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
;		arbre = [ arbre, 																																												$
;			'5 Particle spectrogram',																																										$
;				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1 yleft_max=10000',																	$
;				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
;				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
;				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=MAG3 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Automatic spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',						$
;				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																			$
;				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=-90 x_max=90 z_showdir=No z_theta=No z_phi=No',															$
;				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-30000.0 x_max=30000 yleft_auto=Manual yleft_min=-30000.0 yleft_max=30000.0 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',	$
;			'5 Particle plot',																																											$
;				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
;				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',													$
;				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',													$
;				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=MAG3 cjf='+unite+' x_dx=100.0 pad_nbalphas=16 bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																	$
;		]
;
;		; 3D MOMENTS
;		tab = [	'cl	N_cm3											#  				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ei_eV_cm3										#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ti_eV											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vxpar_spa_km_sec,Vypar_spa_km_sec,Vzpar_spa_km_sec,*Vpar_spa_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vxper_spa_km_sec,Vyper_spa_km_sec,Vzper_spa_km_sec,*Vper_spa_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Elx_spa_mV_m,Ely_spa_mV_m,Elz_spa_mV_m,El_spa_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Pp_nPa											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Pm_nPa											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Beta											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vxalfven_spa_km_sec,Vyalfven_spa_km_sec,Vzalfven_spa_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	An											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ng											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No'				$
;		]
;		ajouter_dataset, arbre, '<dataset id="PSP:SPA:3D_3DMOMENTSST00">5 3D moments', nomcis, noproduit, nomsat, tab, 'PSP_SPA_3DMOMENTSST00', 'psp_spa', /moments, /notime
;
;	; ---
;	; SPB
;	; ---
;
;	arbre = [ arbre, '3 SPB']
;	nomcis = 'PSP-SPB'
;
;	; 1D Electron SF1
;	noproduit = [0]
;	arbre = [ arbre, '4 1D Electron SF1 ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
;
;		; "Timeseries"
;		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
;		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
;		ajouter_dataset, arbre, '<dataset id="PSP:SPB:ENERGYSF1">5 Timeseries', nomcis, noproduit, nomsat, tab, 'PSP_SPB_ENERGYSF1', 'psp_spb', /notime
;
;		; "Particle spectrogram" et "Particle plot"
;		unite = 'JE'
;		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
;		arbre = [ arbre, 																																												$
;			'5 Particle spectrogram',																																										$
;				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1 yleft_max=10000',																				$
;			'5 Particle plot',																																											$
;				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
;				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',													$
;				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000'													$
;		]
;
;	; 1D Electron ST1
;	noproduit = [1]
;	arbre = [ arbre, '4 1D Electron ST1 ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
;
;		; "Timeseries"
;		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
;		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
;		ajouter_dataset, arbre, '<dataset id="PSP:SPB:ENERGYST1">5 Timeseries', nomcis, noproduit, nomsat, tab, 'PSP_SPB_ENERGYST1', 'psp_spb', /notime
;
;		; "Particle spectrogram" et "Particle plot"
;		unite = 'JE'
;		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
;		arbre = [ arbre, 																																												$
;			'5 Particle spectrogram',																																										$
;				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1 yleft_max=10000',																				$
;			'5 Particle plot',																																											$
;				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
;				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',													$
;				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000'													$
;		]
;
;
;	; 3D Electron SF0
;	noproduit = [2]
;	arbre = [ arbre, '4 3D Electron SF0 ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
;
;		; "Timeseries"
;		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
;		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
;		ajouter_dataset, arbre, '<dataset id="PSP:SPB:3DSF0">5 Timeseries', nomcis, noproduit, nomsat, tab, 'PSP_SPB_3DSF0', 'psp_spb', /notime
;
;		; "Particle spectrogram" et "Particle plot"
;		unite = 'JE'
;		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
;		arbre = [ arbre, 																																												$
;			'5 Particle spectrogram',																																										$
;				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1 yleft_max=10000',																	$
;				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
;				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
;				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=MAG3 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Automatic spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',						$
;				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																			$
;				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=-90 x_max=90 z_showdir=No z_theta=No z_phi=No',															$
;				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-30000.0 x_max=30000 yleft_auto=Manual yleft_min=-30000.0 yleft_max=30000.0 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',	$
;			'5 Particle plot',																																											$
;				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
;				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',													$
;				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',													$
;				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=MAG3 cjf='+unite+' x_dx=100.0 pad_nbalphas=16 bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																	$
;		]
;
;		; 3D MOMENTS
;		tab = [	'cl	N_cm3											#  				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ei_eV_cm3										#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ti_eV											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vxpar_spb_km_sec,Vypar_spb_km_sec,Vzpar_spb_km_sec,*Vpar_spb_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vxper_spb_km_sec,Vyper_spb_km_sec,Vzper_spb_km_sec,*Vper_spb_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Elx_spb_mV_m,Ely_spb_mV_m,Elz_spb_mV_m,El_spb_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Pp_nPa											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Pm_nPa											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Beta											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vxalfven_spb_km_sec,Vyalfven_spb_km_sec,Vzalfven_spb_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	An											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ng											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No'				$
;		]
;		ajouter_dataset, arbre, '<dataset id="PSP:SPB:3D_3DMOMENTSSF0">5 3D moments', nomcis, noproduit, nomsat, tab, 'PSP_SPB_3DMOMENTSSF0', 'psp_spb', /moments, /notime
;
;	; 3D Electron ST0
;	noproduit = [3]
;	arbre = [ arbre, '4 3D Electron ST0 ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]
;
;		; "Timeseries"
;		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
;		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
;		ajouter_dataset, arbre, '<dataset id="PSP:SPB:3DST0">5 Timeseries', nomcis, noproduit, nomsat, tab, 'PSP_SPB_3DST0', 'psp_spb', /notime
;
;		; "Particle spectrogram" et "Particle plot"
;		unite = 'JE'
;		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
;		arbre = [ arbre, 																																												$
;			'5 Particle spectrogram',																																										$
;				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=1 yleft_max=10000',																	$
;				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
;				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
;				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=MAG3 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Automatic spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',						$
;				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																			$
;				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=-90 x_max=90 z_showdir=No z_theta=No z_phi=No',															$
;				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-30000.0 x_max=30000 yleft_auto=Manual yleft_min=-30000.0 yleft_max=30000.0 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',	$
;			'5 Particle plot',																																											$
;				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
;				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',													$
;				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000',													$
;				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=MAG3 cjf='+unite+' x_dx=100.0 pad_nbalphas=16 bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																	$
;		]
;
;		; 3D MOMENTS
;		tab = [	'cl	N_cm3											#  				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ei_eV_cm3										#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ti_eV											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vxpar_spb_km_sec,Vypar_spb_km_sec,Vzpar_spb_km_sec,*Vpar_spb_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vxper_spb_km_sec,Vyper_spb_km_sec,Vzper_spb_km_sec,*Vper_spb_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Elx_spb_mV_m,Ely_spb_mV_m,Elz_spb_mV_m,El_spb_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Pp_nPa											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Pm_nPa											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Beta											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Vxalfven_spb_km_sec,Vyalfven_spb_km_sec,Vzalfven_spb_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	An											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Ng											#				count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No',				$
;			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=MAG3 type=moments ion_nochamp=H+ emin_=1 emax_=5000 legend_theta=No legend_phi=No'				$
;		]
;		ajouter_dataset, arbre, '<dataset id="PSP:SPB:3D_3DMOMENTSST0">5 3D moments', nomcis, noproduit, nomsat, tab, 'PSP_SPB_3DMOMENTSST0', 'psp_spb', /moments, /notime

	; ---
	; SPC
	; ---

	arbre = [ arbre, '3 SPC']
	nomcis = 'PSP-SPC'

	arbre = [ arbre, '4 L2']

	; HSK
	; ---
	noproduit = 0
	vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
	ajouter_dataset, arbre, '<dataset id="PSP:SPC:HSK">5 HSK', nomcis, noproduit, nomsat, tab, 'PSP_SPC_HSK', 'psp_spc'

	; L2_A_CURRENT
	; ------------
	noproduit = [2]
	arbre = [ arbre, '5 L2 A_CURRENT ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="PSP:SPC:L2_A_CURRENT">6 Timeseries', nomcis, noproduit, nomsat, tab, 'PSP_SPC_L2_A_CURRENT', 'psp_spc', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'current'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'6 Particle spectrogram',																																										$
				'0 Time Voltage '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No yleft_auto=Automatic',																				$
			'6 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Voltage '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Automatic',															$
				'0 Voltage '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Automatic'															$
		]

	; L2_B_CURRENT
	; ------------
	noproduit = [3]
	arbre = [ arbre, '5 L2 B_CURRENT ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="PSP:SPC:L2_B_CURRENT">6 Timeseries', nomcis, noproduit, nomsat, tab, 'PSP_SPC_L2_B_CURRENT', 'psp_spc', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'current'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'6 Particle spectrogram',																																										$
				'0 Time Voltage '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No yleft_auto=Automatic',																				$
			'6 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Voltage '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Automatic',															$
				'0 Voltage '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Automatic'															$
		]

	; L2_C_CURRENT
	; ------------
	noproduit = [4]
	arbre = [ arbre, '5 L2 C_CURRENT ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="PSP:SPC:L2_C_CURRENT">6 Timeseries', nomcis, noproduit, nomsat, tab, 'PSP_SPC_L2_C_CURRENT', 'psp_spc', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'current'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'6 Particle spectrogram',																																										$
				'0 Time Voltage '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No yleft_auto=Automatic',																				$
			'6 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Voltage '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Automatic',															$
				'0 Voltage '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Automatic'															$
		]

	; L2_D_CURRENT
	; ------------
	noproduit = [5]
	arbre = [ arbre, '5 L2 D_CURRENT ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="PSP:SPC:L2_D_CURRENT">6 Timeseries', nomcis, noproduit, nomsat, tab, 'PSP_SPC_L2_D_CURRENT', 'psp_spc', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'current'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'6 Particle spectrogram',																																										$
				'0 Time Voltage '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No yleft_auto=Automatic',																				$
			'6 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Voltage '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Automatic',															$
				'0 Voltage '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Automatic'															$
		]

	; L2_DIFF_CHARGE
	; --------------
	noproduit = [6]
	arbre = [ arbre, '5 L2 DIFF_CHARGE_FLUX_DENSITY ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="PSP:SPC:L2_DIFF_CHARGE">6 Timeseries', nomcis, noproduit, nomsat, tab, 'PSP_SPC_L2_DIFF_CHARGE', 'psp_spc', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'diff_charge_flux_density'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'6 Particle spectrogram',																																										$
				'0 Time Voltage '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No yleft_auto=Automatic',																				$
			'6 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Voltage '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Automatic',															$
				'0 Voltage '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Automatic'															$
		]

	arbre = [ arbre, '4 L3']

	; MOM
	; ---
	noproduit = 1
	vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="PSP:SPC:MOM">5 MOM', nomcis, noproduit, nomsat, tab, 'PSP_SPC_MOM', 'psp_spc'



	; ---
	; SPE
	; ---

	arbre = [ arbre, '3 SPE']
	nomcis = 'PSP-SPE'
	arbre = [ arbre, '4 OLD']

	; SPE_AF0_PA_SPEC_315EV
	; ---------------------
	noproduit = [0]
	unite = 'fdist'
	nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
	arbre = [ arbre, 																													$
		'5 SPE_AF0_PA_SPEC_315EV ' + get_cldataset_starttime_endtime('PSP-SPE',noproduit,nomsat),																			$
		'6 Particle spectrogram',																											$
		'0 Time Pitchangle fdist#		'+nomcis_nomproduit_nomsat+ ' ' + unite + ' count3d type=time_energy cjf='+unite+' yleft_log=Linear yleft_auto=Manual yleft_min=0 yleft_max=180 z_showdir=No z_theta=No z_phi=No'	]

	; SPE_AF0_PA_NORM_SPEC_315EV
	; --------------------------
	noproduit = [1]
	unite = 'fdist'
	nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
	arbre = [ arbre, 																													$
		'5 SPE_AF0_PA_NORM_SPEC_315EV ' + get_cldataset_starttime_endtime('PSP-SPE',noproduit,nomsat),																			$
		'6 Particle spectrogram',																											$
		'0 Time Pitchangle fdist#		'+nomcis_nomproduit_nomsat+ ' ' + unite + ' count3d type=time_energy cjf='+unite+' yleft_log=Linear yleft_auto=Manual yleft_min=0 yleft_max=180 z_showdir=No z_theta=No z_phi=No'	]

	; SPE_SF0_PA_SPEC_315EV
	; ---------------------
	noproduit = [2]
	unite = 'fdist'
	nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
	arbre = [ arbre, 																													$
		'5 SPE_SF0_PA_SPEC_315EV ' + get_cldataset_starttime_endtime('PSP-SPE',noproduit,nomsat),																			$
		'6 Particle spectrogram',																											$
		'0 Time Pitchangle fdist#		'+nomcis_nomproduit_nomsat+ ' ' + unite + ' count3d type=time_energy cjf='+unite+' yleft_log=Linear yleft_auto=Manual yleft_min=0 yleft_max=180 z_showdir=No z_theta=No z_phi=No'	]

	; SPE_SF0_PA_NORM_SPEC_315EV
	; --------------------------
	noproduit = [3]
	unite = 'fdist'
	nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
	arbre = [ arbre, 																													$
		'5 SPE_SF0_PA_NORM_SPEC_315EV ' + get_cldataset_starttime_endtime('PSP-SPE',noproduit,nomsat),																			$
		'6 Particle spectrogram',																											$
		'0 Time Pitchangle fdist#		'+nomcis_nomproduit_nomsat+ ' ' + unite + ' count3d type=time_energy cjf='+unite+' yleft_log=Linear yleft_auto=Manual yleft_min=0 yleft_max=180 z_showdir=No z_theta=No z_phi=No'	]

	; SPE_NEW_PA_315EV
	; ----------------
	noproduit = [4]
	unite = 'fdist'
	nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
	arbre = [ arbre, 																													$
		'5 SPE_NEW_PA_315EV ' + get_cldataset_starttime_endtime('PSP-SPE',noproduit,nomsat),																				$
		'6 Particle spectrogram',																											$
		'0 Time Pitchangle fdist#		'+nomcis_nomproduit_nomsat+ ' ' + unite + ' count3d type=time_energy cjf='+unite+' yleft_log=Linear yleft_auto=Manual yleft_min=0 yleft_max=180 z_showdir=No z_theta=No z_phi=No'	]

	; SPE_NEW_PA_315EV_NORM
	; ---------------------
	noproduit = [5]
	unite = 'fdist'
	nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
	arbre = [ arbre, 																													$
		'5 SPE_NEW_PA_315EV_NORM ' + get_cldataset_starttime_endtime('PSP-SPE',noproduit,nomsat),																			$
		'6 Particle spectrogram',																											$
		'0 Time Pitchangle fdist#		'+nomcis_nomproduit_nomsat+ ' ' + unite + ' count3d type=time_energy cjf='+unite+' yleft_log=Linear yleft_auto=Manual yleft_min=0 yleft_max=180 z_showdir=No z_theta=No z_phi=No'	]

	arbre = [ arbre, '4 L3']

	; SPE_SF0_L3_PAD
	; --------------
	noproduit = [6]
	unite = 'fdist'
	nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
	arbre = [ arbre, 																													$
		'5 SPE_SF0_L3_PAD ' + get_cldataset_starttime_endtime('PSP-SPE',noproduit,nomsat),																			$
		'6 Particle spectrogram',																											$
		'0 Time Pitchangle fdist#		'+nomcis_nomproduit_nomsat+ ' ' + unite + ' count3d type=time_theta cjf='+unite+' yleft_log=Linear yleft_auto=Manual yleft_min=0 yleft_max=180 z_showdir=No z_theta=No z_phi=No'	]

	; ---
	; SPI
	; ---

	arbre = [ arbre, '3 SPI']
	nomcis = 'PSP-SPI'
	arbre = [ arbre, '4 L3']

	afs  = [ 'AF00',  'AF01', 'SF00',   'SF01', 'SF0A'  ]
	ions = [ 'ion',  'ion',   'proton', 'ion',  'alpha' ]

	FOR i=0L,N_ELEMENTS(afs)-1 DO BEGIN

		arbre = [ arbre, '5 ' + afs[i] + ' (' + ions[i] + ')' ]
	

		; MOM
		; ---
		IF i EQ 2 THEN BEGIN
			; proton CL
			noproduit = 20
		END ELSE BEGIN
			noproduit = 4*i + 0
		END
		vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
		ajouter_dataset, arbre, '<dataset id="PSP:SPI:'+afs[i]+'MOM">6 MOM', nomcis, noproduit, nomsat, tab, 'PSP_SPI_'+afs[i]+'MOM', 'psp_spi'

		; SPECTRO_E
		; ---------
		noproduit = [4*i + 1]
		arbre = [ arbre, '6 SPECTRO_ENERGY ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

			; "Timeseries"
			vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
			ajouter_dataset, arbre, '<dataset id="PSP:SPI:'+afs[i]+'_SPECTRO_E">7 Timeseries', nomcis, noproduit, nomsat, tab, 'PSP_SPI_'+afs[i]+'_SPECTRO_E', 'psp_spi', /notime

			; "Particle spectrogram" et "Particle plot"
			unite = 'JE'
			nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
			arbre = [ arbre, 																																												$
				'7 Particle spectrogram',																																										$
					'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No yleft_auto=Automatic',																				$
				'7 Particle plot',																																											$
					'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
					'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Automatic',															$
					'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Automatic'															$
			]

		; SPECTRO_T
		; ---------
		noproduit = [4*i + 2]
		arbre = [ arbre, '6 SPECTRO_THETA ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

			; "Timeseries"
			;vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			;tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
			;ajouter_dataset, arbre, '<dataset id="PSP:SPI:AF00_SPECTRO_T">5 Timeseries', nomcis, noproduit, nomsat, tab, 'PSP_SPI_AF00_SPECTRO_T', 'psp_spi', /notime

			; "Particle spectrogram" et "Particle plot"
			unite = 'JE'
			nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
			arbre = [ arbre, 																																												$
				'7 Particle spectrogram',																																										$
					'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No yleft_auto=Automatic',																				$
				'7 Particle plot',																																											$
					'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
					'0 Theta '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Automatic',															$
					'0 Theta '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Automatic'															$
			]

		; SPECTRO_P
		; ---------
		noproduit = [4*i + 3]
		arbre = [ arbre, '6 SPECTRO_PHI ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

			; "Timeseries"
			;vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			;tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
			;ajouter_dataset, arbre, '<dataset id="PSP:SPI:AF00_SPECTRO_P">5 Timeseries', nomcis, noproduit, nomsat, tab, 'PSP_SPI_AF00_SPECTRO_P', 'psp_spi', /notime

			; "Particle spectrogram" et "Particle plot"
			unite = 'JE'
			nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
			arbre = [ arbre, 																																												$
				'7 Particle spectrogram',																																										$
					'0 Time Phi '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No yleft_auto=Automatic',																				$
				'7 Particle plot',																																											$
					'0 Time '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
					'0 Phi '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+'                            x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Automatic',															$
					'0 Phi '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf spacecraft_potential_auto=Manual cjf='+unite+' spinaccu=0 time_onespin=No x_dx=1000.0 legend_theta=No legend_phi=No x_auto=Automatic'															$
			]

	END

	RETURN, arbre

END


;-------------------------------------------------------------------------------
FUNCTION get_arbre_rosina
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL ROSINA.
;-------------------------------------------------------------------------------
;
; Pas trouv dans spase

	COMMON COMMON_CL, general

	create_products, 'ROSINA'

	p = get(general,'p') ; p[noproduit,nocis,nosat]
	nomsat = 'SC1'
	nosat = STRMID(nomsat,2)


	arbre = [ '2 ROSINA' ]

	; ----
	; RTOF
	; ----

	arbre = [ arbre, '3 RTOF']
	nomcis = 'ROSINA-RTOF'

	; L2HK
	noproduit = [0,5,10,15,20,25,30,35,40,45]
	vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
	tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
	ajouter_dataset, arbre, '<dataset id="ROSINA:RTOF:L2HK">4 L2 HK', nomcis, noproduit, nomsat, tab, 'ROSINA_RTOF_L2HK', 'rosina_rtof'

	; Spectro (time,channel)
	noproduit = [1,6,11,16,21,26,31,36,41,46]
	arbre = [ arbre, '4 L2 DATA ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		;vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		;tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Wording'
		;ajouter_dataset, arbre, '<dataset id="ROSINA:RTOF:DATAL3">5 Timeseries', nomcis, noproduit, nomsat, tab, 'ROSINA_RTOF_DATAL3', 'rosina_rtof', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'c/s'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'5 Particle spectrogram',																																										$
				'0 Time Channel '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No yleft_log=Log yleft_auto=Manual yleft_min=1 yleft_max=36000',																$
			'5 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Channel '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000'																						$
		]

	; L3HK
	noproduit = [2,7,12,17,22,27,32,37,42,47]
	tab = [	'cl	ROSINA_RTOF_SCI_UPDATE_MPS_FILE			# 	header',							$
		'cl	ROSINA_RTOF_SCI_GCU_C				# 	header',							$
		'cl	ROSINA_RTOF_SCI_GCU_C_UNC			# 	header',							$
		'cl	ROSINA_RTOF_SCI_GCU_T0				# 	header',							$
		'cl	ROSINA_RTOF_SCI_GCU_T0_UNC			# 	header',							$
		'cl	ROSINA_RTOF_SCI_SELF_C				# 	header',							$
		'cl	ROSINA_RTOF_SCI_SELF_C_UNC			# 	header',							$
		'cl	ROSINA_RTOF_SCI_SELF_T0				# 	header',							$
		'cl	ROSINA_RTOF_SCI_SELF_T0_UNC			# 	header',							$
		'cl	ROSINA_RTOF_SCI_MODE_NUMBER			# 	header',							$
		'cl	ROSINA_RTOF_SCI_SEQUENCE_NUMBER			# 	header',							$
		'cl	ROSINA_RTOF_SCI_OS_FIL_V			# 	header',							$
		'cl	ROSINA_RTOF_SCI_SS_FIL_V			# 	header',							$
		'cl	ROSINA_RTOF_SCI_OS_FIL_I			# 	header',							$
		'cl	ROSINA_RTOF_SCI_SS_FIL_I			# 	header',							$
		'cl	ROSINA_RTOF_SCI_GCU_TEMP_PIRAN_1		# 	header',							$
		'cl	ROSINA_RTOF_SCI_GCU_TEMP_PIRAN_2		# 	header',							$
		'cl	ROSINA_RTOF_SCI_GEX_TEMP			# 	header',							$
		'cl	ROSINA_RTOF_SCI_HM_PW				# 	header',							$
		'cl	ROSINA_RTOF_SCI_HM_DEL				# 	header',							$
		'cl	ROSINA_RTOF_SCI_MOT_POSITION			# 	header',							$
		'cl	ROSINA_RTOF_SCI_PSDC_TEMP_BP_OS			# 	header',							$
		'cl	ROSINA_RTOF_SCI_PSDC_TEMP_BP_SS			# 	header',							$
		'cl	ROSINA_RTOF_SCI_PSU_TEMP_MCP_OS			# 	header',							$
		'cl	ROSINA_RTOF_SCI_PSU_TEMP_HV1			# 	header',							$
		'cl	ROSINA_RTOF_SCI_PSU_TEMP_LVPS			# 	header',							$
		'cl	ROSINA_RTOF_SCI_TOTAL_NB_EVENTS			# 	header',							$
		'cl	ROSINA_RTOF_SCI_NB_EXTRACTIONS			# 	header',							$
		'cl	ROSINA_COPS_PRESSURE_NG				# 	header',							$
		'cl	ROSINA_COPS_PRESSURE_RG				# 	header',							$
		'cl	ROSINA_RTOF_SCI_SIGNAL_CAL_VALUE		# 	header',							$
		'cl	ROSINA_RTOF_SCI_SIGNAL_CAL_STDEV		# 	header',							$
		'cl	ROSINA_RTOF_SCI_BG_LEVEL			# 	header',							$
		'cl	ROSINA_RTOF_SCI_BG_STDEV			# 	header',							$
		'cl	ROSINA_RTOF_SCI_BG_STARTBIN			# 	header',							$
		'cl	ROSINA_RTOF_SCI_BG_STOPBIN			# 	header',							$
		'cl	ROSINA_RTOF_SCI_AVG_PPM_DEV			# 	header'								]
	ajouter_dataset, arbre, '<dataset id="ROSINA:RTOF:L3HK">4 L3 HK', nomcis, noproduit, nomsat, tab, 'ROSINA_RTOF_L3HK', 'rosina_rtof'

	; MASS_CAL
	noproduit = [8,13,18,23,28,38,43,48]
	tab = [	'cl	PEAK_CAL_H2			# 	header',							$
		'cl	PEAK_CAL_12C			# 	header',							$
		'cl	PEAK_CAL_H2O			# 	header',							$
		'cl	PEAK_CAL_CO2			# 	header',							$
		'cl	PEAK_CAL_C6H6			# 	header',							$
		'cl	PEAK_FOUND_H2			# 	header',							$
		'cl	PEAK_FOUND_12C			# 	header',							$
		'cl	PEAK_FOUND_H2O			# 	header',							$
		'cl	PEAK_FOUND_CO2			# 	header',							$
		'cl	PEAK_FOUND_C6H6			# 	header',							$
		'cl	PEAK_CENTER_BIN_H2		# 	header',							$
		'cl	PEAK_CENTER_BIN_12C		# 	header',							$
		'cl	PEAK_CENTER_BIN_H2O		# 	header',							$
		'cl	PEAK_CENTER_BIN_CO2		# 	header',							$
		'cl	PEAK_CENTER_BIN_C6H6		# 	header',							$
		'cl	PEAK_WIDTH_H2			# 	header',							$
		'cl	PEAK_WIDTH_12C			# 	header',							$
		'cl	PEAK_WIDTH_H2O			# 	header',							$
		'cl	PEAK_WIDTH_CO2			# 	header',							$
		'cl	PEAK_WIDTH_C6H6			# 	header',							$
		'cl	PEAK_HEIGHT_H2			# 	header',							$
		'cl	PEAK_HEIGHT_12C			# 	header',							$
		'cl	PEAK_HEIGHT_H2O			# 	header',							$
		'cl	PEAK_HEIGHT_CO2			# 	header',							$
		'cl	PEAK_HEIGHT_C6H6		# 	header',							$
		'cl	PPM_DEVIANCE_H2			# 	header',							$
		'cl	PPM_DEVIANCE_12C		# 	header',							$
		'cl	PPM_DEVIANCE_H2O		# 	header',							$
		'cl	PPM_DEVIANCE_CO2		# 	header',							$
		'cl	PPM_DEVIANCE_C6H6		# 	header'								]
	ajouter_dataset, arbre, '<dataset id="ROSINA:RTOF:L3MASSCAL">4 L3 MASS_CAL', nomcis, noproduit, nomsat, tab, 'ROSINA_RTOF_L3MASSCAL', 'rosina_rtof'

	; MASS_CAL_GCU
	noproduit = [3,33]
	tab = [	'cl	PEAK_CAL_H2			# 	header',							$
		'cl	PEAK_CAL_4He			# 	header',							$
		'cl	PEAK_CAL_12C			# 	header',							$
		'cl	PEAK_CAL_16O			# 	header',							$
		'cl	PEAK_CAL_CO			# 	header',							$
		'cl	PEAK_CAL_CO2			# 	header',							$
		'cl	PEAK_CAL_78Kr			# 	header',							$
		'cl	PEAK_CAL_80Kr			# 	header',							$
		'cl	PEAK_CAL_82Kr			# 	header',							$
		'cl	PEAK_CAL_83Kr			# 	header',							$
		'cl	PEAK_CAL_84Kr			# 	header',							$
		'cl	PEAK_CAL_86Kr			# 	header',							$

		'cl	PEAK_FOUND_H2			# 	header',							$
		'cl	PEAK_FOUND_4He			# 	header',							$
		'cl	PEAK_FOUND_12C			# 	header',							$
		'cl	PEAK_FOUND_16O			# 	header',							$
		'cl	PEAK_FOUND_CO			# 	header',							$
		'cl	PEAK_FOUND_CO2			# 	header',							$
		'cl	PEAK_FOUND_78Kr			# 	header',							$
		'cl	PEAK_FOUND_80Kr			# 	header',							$
		'cl	PEAK_FOUND_82Kr			# 	header',							$
		'cl	PEAK_FOUND_83Kr			# 	header',							$
		'cl	PEAK_FOUND_84Kr			# 	header',							$
		'cl	PEAK_FOUND_86Kr			# 	header',							$

		'cl	PEAK_CENTER_BIN_H2		# 	header',							$
		'cl	PEAK_CENTER_BIN_4He		# 	header',							$
		'cl	PEAK_CENTER_BIN_12C		# 	header',							$
		'cl	PEAK_CENTER_BIN_16O		# 	header',							$
		'cl	PEAK_CENTER_BIN_CO		# 	header',							$
		'cl	PEAK_CENTER_BIN_CO2		# 	header',							$
		'cl	PEAK_CENTER_BIN_78Kr		# 	header',							$
		'cl	PEAK_CENTER_BIN_80Kr		# 	header',							$
		'cl	PEAK_CENTER_BIN_82Kr		# 	header',							$
		'cl	PEAK_CENTER_BIN_83Kr		# 	header',							$
		'cl	PEAK_CENTER_BIN_84Kr		# 	header',							$
		'cl	PEAK_CENTER_BIN_86Kr		# 	header',							$

		'cl	PEAK_WIDTH_H2			# 	header',							$
		'cl	PEAK_WIDTH_4He			# 	header',							$
		'cl	PEAK_WIDTH_12C			# 	header',							$
		'cl	PEAK_WIDTH_16O			# 	header',							$
		'cl	PEAK_WIDTH_CO			# 	header',							$
		'cl	PEAK_WIDTH_CO2			# 	header',							$
		'cl	PEAK_WIDTH_78Kr			# 	header',							$
		'cl	PEAK_WIDTH_80Kr			# 	header',							$
		'cl	PEAK_WIDTH_82Kr			# 	header',							$
		'cl	PEAK_WIDTH_83Kr			# 	header',							$
		'cl	PEAK_WIDTH_84Kr			# 	header',							$
		'cl	PEAK_WIDTH_86Kr			# 	header',							$

		'cl	PEAK_HEIGHT_H2			# 	header',							$
		'cl	PEAK_HEIGHT_4He			# 	header',							$
		'cl	PEAK_HEIGHT_12C			# 	header',							$
		'cl	PEAK_HEIGHT_16O			# 	header',							$
		'cl	PEAK_HEIGHT_CO			# 	header',							$
		'cl	PEAK_HEIGHT_CO2			# 	header',							$
		'cl	PEAK_HEIGHT_78Kr		# 	header',							$
		'cl	PEAK_HEIGHT_80Kr		# 	header',							$
		'cl	PEAK_HEIGHT_82Kr		# 	header',							$
		'cl	PEAK_HEIGHT_83Kr		# 	header',							$
		'cl	PEAK_HEIGHT_84Kr		# 	header',							$
		'cl	PEAK_HEIGHT_86Kr		# 	header',							$

		'cl	PPM_DEVIANCE_H2			# 	header',							$
		'cl	PPM_DEVIANCE_4He		# 	header',							$
		'cl	PPM_DEVIANCE_12C		# 	header',							$
		'cl	PPM_DEVIANCE_16O		# 	header',							$
		'cl	PPM_DEVIANCE_CO			# 	header',							$
		'cl	PPM_DEVIANCE_CO2		# 	header',							$
		'cl	PPM_DEVIANCE_78Kr		# 	header',							$
		'cl	PPM_DEVIANCE_80Kr		# 	header',							$
		'cl	PPM_DEVIANCE_82Kr		# 	header',							$
		'cl	PPM_DEVIANCE_83Kr		# 	header',							$
		'cl	PPM_DEVIANCE_84Kr		# 	header',							$
		'cl	PPM_DEVIANCE_86Kr		# 	header'								]

	ajouter_dataset, arbre, '<dataset id="ROSINA:RTOF:L3MASSCALGCU">4 L3 MASS_CAL_GCU', nomcis, noproduit, nomsat, tab, 'ROSINA_RTOF_L3MASSCALGCU', 'rosina_rtof'

	; Spectro (time,amu)
	noproduit = [4,9,14,19,24,29,34,39,44,49]
	arbre = [ arbre, '4 L3 DATA ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

		; "Timeseries"
		;vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		;tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Wording'
		;ajouter_dataset, arbre, '<dataset id="ROSINA:RTOF:DATAL3">5 Timeseries', nomcis, noproduit, nomsat, tab, 'ROSINA_RTOF_DATAL3', 'rosina_rtof', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'c/s'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
		arbre = [ arbre, 																																												$
			'5 Particle spectrogram',																																										$
				'0 Time Mass '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No yleft_log=Linear yleft_auto=Manual yleft_min=1 yleft_max=140',																$
			'5 Particle plot',																																											$
				'0 Time '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Mass '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' legend_theta=No legend_phi=No x_auto=Manual x_min=1 x_max=10000'																						$
		]

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_indices
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL INDICES.
;-------------------------------------------------------------------------------

	arbre = [															$
		'2 INDEX',														$

		'3 AEAUALAO ' + get_cldataset_starttime_endtime('INDICES',4,'SC1'),							$
		'4 1mn resolution ',													$
			'0 AE#						INDICES P4 SC1 AE header',					$
			'0 AE daily mean value#				INDICES P4 SC1 AE_daily_mean_value header',			$
			'0 AL#						INDICES P4 SC1 AL header',					$
			'0 AL daily mean value#				INDICES P4 SC1 AL_daily_mean_value header',			$
			'0 AO#						INDICES P4 SC1 AO header',					$
			'0 AO daily mean value#				INDICES P4 SC1 AO_daily_mean_value header',			$
			'0 AU#						INDICES P4 SC1 AU header',					$
			'0 AU daily mean value#				INDICES P4 SC1 AU_daily_mean_value header',			$

		'3 DST ' + get_cldataset_starttime_endtime('INDICES',0,'SC1'),								$
		'4 1h resolution',													$
			'0 Geomagnetic field component#			INDICES P0 SC1 Geomagnetic_field_component header',		$
			'0 Tabular base#				INDICES P0 SC1 Tabular_base header',				$
			'0 DST value#					INDICES P0 SC1 DST_value header',				$
			'0 DST daily mean value#			INDICES P0 SC1 DST_daily_mean_value header',			$

		'3 KPAP ' + get_cldataset_starttime_endtime('INDICES',2,'SC1'),								$
		'4 3h resolution',													$
			'0 Bartels solar rotation number#		INDICES P2 SC1 Bartels_solar_rotation_number header',		$
			'0 Nb of day within Bartels 27day cycle#	INDICES P2 SC1 Nb_of_day_within_Bartels_27day_cycle header',	$
			'0 Kp#						INDICES P2 SC1 Kp header',					$
			'0 Daily Kp#					INDICES P2 SC1 Daily_Kp header',				$
			'0 Ap#						INDICES P2 SC1 Ap header',					$
			'0 Daily Ap#					INDICES P2 SC1 Daily_Ap header',				$
			'0 Cp#						INDICES P2 SC1 Cp header',					$
			'0 C9#						INDICES P2 SC1 C9 header',					$
			'0 International sunspot number#		INDICES P2 SC1 International_sunspot_number header',		$
			'0 Ottawa 10.7-cm solar radio flux#		INDICES P2 SC1 Ottawa_10.7_cm_solar_radio_flux header',		$
			'0 Flux qualifier#				INDICES P2 SC1 Flux_qualifier header',				$

		'3 PCN ' + get_cldataset_starttime_endtime('INDICES',3,'SC1'),									$
		'4 1mn resolution',													$
			'0 Northern Polar Cap#				INDICES P3 SC1 PCN header'					$
	]

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_wind
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL WIND.
;-------------------------------------------------------------------------------
;
; Trouv dans spase://SMWG/Observatory/Wind
;
; <ObservatoryRegion>Heliosphere.NearEarth</ObservatoryRegion>
; <ObservatoryRegion>Heliosphere.Inner</ObservatoryRegion>$
; <ObservatoryRegion>Earth.Magnetosheath</ObservatoryRegion>
; <ObservatoryRegion>Earth.Magnetosphere</ObservatoryRegion>
; <ObservatoryRegion>Earth.Magnetosphere.Magnetotail</ObservatoryRegion>
; <ObservatoryRegion>Earth.Magnetosphere.Main</ObservatoryRegion>
;

	create_products, 'WIND'

	target  = "Heliosphere.NearEarth"															; V. Genot
	targets = "Heliosphere.NearEarth Heliosphere.Inner Earth.Magnetosheath Earth.Magnetosphere Earth.Magnetosphere.Magnetotail Earth.Magnetosphere.Main"	; spase

	arbre = [																	$
		'<mission name="WIND" id="WIND" target="'+target+'" targets="'+targets+'">2 WIND',							$
		'<instrument name="ephemeris" id="WIND:ephemeris">3 ephemeris'										]

	; ephemeris K0_3DP
	tab = [	'cl	Xsc_GSE_Rt,Ysc_GSE_Rt,Zsc_GSE_Rt     x,y,z  orbito',										$
		'cl,ws	Xsc_GSE_km,Ysc_GSE_km,Zsc_GSE_km     x,y,z  header',										$
		'cl,ws	Xsc_GSE_Rt,Ysc_GSE_Rt,Zsc_GSE_Rt     x,y,z  header',										$
		'cl,ws	Dist_GSE_Rt                          #      header'										]
	ajouter_dataset, arbre, '<dataset id="WIND:EPHEMERIS:ORBIT_K0_3DP">4 orbit from K0_3DP', 'WIND', 0, 'SC1', tab, 'WI_EPHEMERIS_ORBIT_K0_3DP', 'wind'

	; ephemeris H0_MFI
	tab = [	'cl	X_GSE_Rt,Y_GSE_Rt,Z_GSE_Rt           x,y,z  orbito',										$
		'cl,ws	X_GSM_Rt,Y_GSM_Rt,Z_GSM_Rt           x,y,z  header',										$
		'cl,ws	X_GSE_Rt,Y_GSE_Rt,Z_GSE_Rt           x,y,z  header'										]
	ajouter_dataset, arbre, '<dataset id="WIND:EPHEMERIS:ORBIT_H0_MFI">4 orbit from H0_MFI 1min res', 'WIND', 6, 'SC1', tab, 'WI_EPHEMERIS_ORBIT_H0_MFI', 'wind'

	; ephemeris OR_PRE
	tab = [	'cl	X_GSE_km,Y_GSE_km,Z_GSE_km           x,y,z  orbito',										$
		'cl,ws	X_GCI_km,Y_GCI_km,Z_GCI_km           x,y,z  header',										$
		'cl,ws	X_GSE_km,Y_GSE_km,Z_GSE_km           x,y,z  header',										$
		'cl,ws	X_GSM_km,Y_GSM_km,Z_GSM_km           x,y,z  header',										$
		'cl,ws	X_HEC_km,Y_HEC_km,Z_HEC_km           x,y,z  header'										]
	ajouter_dataset, arbre, '<dataset id="WIND:EPHEMERIS:ORBIT_OR_PRE">4 orbit from OR_PRE', 'WIND', 7, 'SC1', tab, 'WI_EPHEMERIS_ORBIT_OR_PRE', 'wind'

	; ephemeris H1_SWE
	tab = [	'cl	Xgse_Rt,Ygse_Rt,Zgse_Rt           x,y,z  orbito',										$
		'cl,ws	Xgse_Rt,Ygse_Rt,Zgse_Rt           x,y,z  header'										]
	ajouter_dataset, arbre, '<dataset id="WIND:EPHEMERIS:ORBIT_H1_SWE">4 orbit from H1_SWE', 'WIND', 9, 'SC1', tab, 'WI_EPHEMERIS_ORBIT_H1_SWE', 'wind'

	; ephemeris K0_SWE
	tab = [	'cl	SC_pos_Xgse_km,SC_pos_Ygse_km,SC_pos_Zgse_km           x,y,z  orbito',								$
		'cl,ws	SC_pos_Xgse_km,SC_pos_Ygse_km,SC_pos_Zgse_km           x,y,z  header',								$
		'cl,ws	SC_pos_Xgsm_km,SC_pos_Ygsm_km,SC_pos_Zgsm_km           x,y,z  header',								$
		'cl,ws	SC_pos_R_km                                            #      header'								]
	ajouter_dataset, arbre, '<dataset id="WIND:EPHEMERIS:ORBIT_K0_SWE">4 orbit from K0_SWE', 'WIND', 19, 'SC1', tab, 'WI_EPHEMERIS_ORBIT_K0_SWE', 'wind'

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'<instrument name="MFI" id="WIND:MFI">3 MFI'												]

	; 1mn resolution (WI_H0_MFI)
	tab = [	'cl,ws	Nb_Points_in_average							#			header',			$
		'cl,ws	Bx_GSM_nT,By_GSM_nT,Bz_GSM_nT,*B_nT					Bx,By,Bz,|B|		header',			$
		'cl,ws	Bx_RMS_GSM_nT,By_RMS_GSM_nT,Bz_RMS_GSM_nT,*B_RMS_nT			Bx,By,Bz,|B|		header',			$
		'cl,ws	Bx_GSE_nT,By_GSE_nT,Bz_GSE_nT,*B_nT					Bx,By,Bz,|B|		header',			$
		'cl,ws	Bx_RMS_GSE_nT,By_RMS_GSE_nT,Bz_RMS_GSE_nT,*B_RMS_nT			Bx,By,Bz,|B|		header',			$
		'cl,ws	Rad__Dist__Rt								#			header',			$
		'cl,ws	X_Unit_spin_vector_GSM,Y_Unit_spin_vector_GSM,Z_Unit_spin_vector_GSM	x,y,z			header',			$
		'cl,ws	X_Unit_spin_vector_GSE,Y_Unit_spin_vector_GSE,Z_Unit_spin_vector_GSE	x,y,z			header',			$
		'cl,ws	Delta_Bx__Outer___Inner__nT						#			header',			$
		'cl,ws	Delta_By__Outer___Inner__nT						#			header',			$
		'cl,ws	Delta_Bz__Outer___Inner__nT						#			header',			$
		'cl,ws	Dipole_Tilt_Angle_deg							#			header',			$
		'cl,ws	Average_Range_Inner_Magnetometer					#			header',			$
		'cl,ws	Average_Range_Outer_Magnetometer					#			header',			$
		'cl,ws	S_C_operational_mode							#			header',			$
		'cl,ws	WIND_MFI_operational_mode						#			header'				]
	ajouter_dataset, arbre, '<dataset id="WIND:MFI:H0_1M">4 1mn resolution (WI_H0_MFI)', 'WIND', 6, 'SC1', tab, 'WI_MFI_H0_1M', 'wind'

	; 3sec resolution (WI_H0_MFI)
	tab = [	'cl,ws	NUM_PTS									#			header',			$
		'cl,ws	Bx_GSM_nT,By_GSM_nT,Bz_GSM_nT,*B_nT					Bx,By,Bz,|B|		header',			$
		'cl,ws	BxRMS_GSM_nT,ByRMS_GSM_nT,BzRMS_GSM_nT,*BRMS_nT				Bx,By,Bz,|B|		header',			$
		'cl,ws	Bx_GSE_nT,By_GSE_nT,Bz_GSE_nT,*B_nT					Bx,By,Bz,|B|		header',			$
		'cl,ws	BxRMS_GSE_nT,ByRMS_GSE_nT,BzRMS_GSE_nT,*BRMS_nT				Bx,By,Bz,|B|		header'				]
	ajouter_dataset, arbre, '<dataset id="WIND:MFI:H0_3S">4 3sec resolution (WI_H0_MFI)', 'WIND', 16, 'SC1', tab, 'WI_MFI_H0_3S', 'wind'

	; high resolution (WI_H2_MFI)
	tab = [	'cl,ws	Bx_GSM_nT,By_GSM_nT,Bz_GSM_nT,*B_nT					Bx,By,Bz,|B|		header',			$
		'cl,ws	Bx_GSE_nT,By_GSE_nT,Bz_GSE_nT,*B_nT					Bx,By,Bz,|B|		header'				]
	ajouter_dataset, arbre, '<dataset id="WIND:MFI:H2">4 high resolution (WI_H2_MFI)', 'WIND', 18, 'SC1', tab, 'WI_MFI_H2', 'wind'

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'<instrument name="3DP" id="WIND:3DP">3 3DP'												]

	; Key parameters 92sec resolution Moments (WI_K0_3DP)
	tab = [	'cl,ws	Ne_cm3					#		header',			$
		'cl,ws	Vex_km_s,Vey_km_s,Vez_km_s		Vx,Vy,Vz	header',			$
		'cl,ws	Te_eV					#		header',			$

		; jamais de donnes pour ce paramtre (sauf +1e31 du 2 au 14 nov 1994)
		;'cl,ws	elect_qdotb_heat_flux_along_b_eV_cm_2_s	#		header',			$

		'cl,ws	Ni_cm_3					#		header',			$
		'cl,ws	Vix_km_s,Viy_km_s,Viz_km_s		Vx,Vy,Vz	header',			$
		'cl,ws	Ti_eV					#		header'				]
	ajouter_dataset, arbre, '<dataset id="WIND:3DP:K0">4 Key parameters 92sec resolution Moments (WI_K0_3DP)', 'WIND', 0, 'SC1', tab, 'WI_3DP_K0', 'wind'

	action = 'count3d type=time_energy cjf=flux yleft_auto=Manual yleft_min=1e2 yleft_max=1e6 z_showdir=No z_theta=No z_phi=No'
	arbre = [ arbre,																									$
		'4 Key parameters 92sec resolution Particle spectrogram (WI_K0_3DP) ' + get_cldataset_starttime_endtime('WIND',0,'SC1'),											$
			'0 Time Energy Electron flux# 				WIND P11 SC1 flux ' + action,		$
			'0 Time Energy Ion flux# 				WIND P12 SC1 flux ' + action		]

	; Key parameters 92sec resolution Particle spectrogram (WI_K0_3DP) Time Energy Electron flux# uniquement pour webservice
	nom1 = 'K0_ELECTRON_SPECTRO_TIME_ENERGY'
	nom2 = 'Key parameters 92sec resolution Particle spectrogram (WI_K0_3DP) Time Energy Electron'
	nom3 = 'WI_3DP_K0_ELECTRON_SPECTRO_TIME_ENERGY'
	visibility = "ws"
	tab = [	visibility +' 1d_data 		# ' + action ]
	ajouter_dataset, arbre, '<dataset id="WIND:3DP:'+nom1+'" visibility="'+visibility+'">4 '+nom2, 'WIND', 11, 'SC1', tab, nom3, 'wind', /spectro

	; Key parameters 92sec resolution Particle spectrogram (WI_K0_3DP) Time Energy Ion flux# uniquement pour webservice
	nom1 = 'K0_ION_SPECTRO_TIME_ENERGY'
	nom2 = 'Key parameters 92sec resolution Particle spectrogram (WI_K0_3DP) Time Energy Ion'
	nom3 = 'WI_3DP_K0_ION_SPECTRO_TIME_ENERGY'
	visibility = "ws"
	tab = [	visibility +' 1d_data 		# ' + action ]
	ajouter_dataset, arbre, '<dataset id="WIND:3DP:'+nom1+'" visibility="'+visibility+'">4 '+nom2, 'WIND', 12, 'SC1', tab, nom3, 'wind', /spectro

	arbre = [ arbre,																						$
		'4 Key parameters 92sec resolution Particle plot (WI_K0_3DP) ' + get_cldataset_starttime_endtime('WIND',0,'SC1'),									$
			'0 Electron Flux  0.1 - 0.4 keV#			WIND P0 SC1 electron_flux__000_1_000_4_keV__1__cm_2_s_sr_keV_ header yleft_log=Log',					$
			'0 Electron Flux  0.4 - 1.8 keV#			WIND P0 SC1 electron_flux__000_4_001_8_keV__1__cm_2_s_sr_keV_ header yleft_log=Log',					$
			'0 Electron Flux  1.9 - 8.0 keV#			WIND P0 SC1 electron_flux__001_9_008_0_keV__1__cm_2_s_sr_keV_ header yleft_log=Log',					$
			'0 Electron Flux  9.0 - 30  keV#			WIND P0 SC1 electron_flux__009_0_030_0_keV__1__cm_2_s_sr_keV_ header yleft_log=Log',					$
			'0 Electron Flux   20 - 48  keV#			WIND P0 SC1 electron_flux__020_0_048_0_keV__1__cm_2_s_sr_keV_ header yleft_log=Log',					$
			'0 Electron Flux   43 - 138 keV#			WIND P0 SC1 electron_flux__043_0_138_0_keV__1__cm_2_s_sr_keV_ header yleft_log=Log',					$
			'0 Electron Flux  127 - 225 keV#			WIND P0 SC1 electron_flux__043_0_138_0_keV__1__cm_2_s_sr_keV_ header yleft_log=Log',					$
			'0 Ion Flux 0.07 - 0.21 keV#				WIND P0 SC1 ion_flux__000_07_000_21_keV__1__cm_2_s_sr_keV_ header yleft_log=Log',					$
			'0 Ion Flux 0.25 - 1.1  keV#				WIND P0 SC1 ion_flux__000_25_001_10_keV__1__cm_2_s_sr_keV_ header yleft_log=Log',					$
			'0 Ion Flux  1.3 - 7    keV#				WIND P0 SC1 ion_flux__001_30_007_00_keV__1__cm_2_s_sr_keV_ header yleft_log=Log',					$
			'0 Ion Flux    8 - 30   keV#				WIND P0 SC1 ion_flux__008_00_030_00_keV__1__cm_2_s_sr_keV_ header yleft_log=Log',					$
			'0 Ion Flux   20 - 58   keV#				WIND P0 SC1 ion_flux__020_00_058_00_keV__1__cm_2_s_sr_keV_ header yleft_log=Log',					$
			'0 Ion Flux   58 - 126  keV#				WIND P0 SC1 ion_flux__058_00_126_00_keV__1__cm_2_s_sr_keV_ header yleft_log=Log',					$
			'0 Ion Flux  115 - 400  keV#				WIND P0 SC1 ion_flux__115_00_400_00_keV__1__cm_2_s_sr_keV_ header yleft_log=Log',					$
			'0 Time Electron flux#					WIND P11 SC1 flux count2d type=time_cjf cjf=flux legend_theta=No legend_phi=No',					$
			'0 Time Ion flux#					WIND P12 SC1 flux count2d type=time_cjf cjf=flux legend_theta=No legend_phi=No',					$
			'0 Energy Electron flux#				WIND P11 SC1 flux count2d type=energy_cjf cjf=flux x_auto=No x_min=1e2 x_max=1e6 legend_theta=No legend_phi=No',	$
			'0 Energy Ion flux#					WIND P12 SC1 flux count2d type=energy_cjf cjf=flux x_auto=No x_min=1e1 x_max=1e6 legend_theta=No legend_phi=No'		]

	; Electron EESA Low ELSP Particle spectrogram (WI_ELSP_3DP) Time Energy flux# uniquement pour webservice
	nom1 = 'ELSP_SPECTRO_TIME_ENERGY'
	nom2 = 'Electron EESA Low Particle spectrogram (WI_ELSP_3DP) Time Energy'
	nom3 = 'WI_3DP_ELSP_SPECTRO_TIME_ENERGY'
	visibility = "ws"
	tab = [	visibility +' 1d_data 		# ' + action ]
	ajouter_dataset, arbre, '<dataset id="WIND:3DP:'+nom1+'" visibility="'+visibility+'">4 '+nom2, 'WIND', 14, 'SC1', tab, nom3, 'wind', /spectro

	arbre = [ arbre,																							$
		'4 Electron EESA Low Particle spectrogram (WI_ELSP_3DP) ' + get_cldataset_starttime_endtime('WIND',14,'SC1'),										$
			'0 Time Energy flux# 				WIND P14 SC1 flux count3d type=time_energy cjf=flux yleft_auto=Manual yleft_min=1 yleft_max=1e4 z_showdir=No z_theta=No z_phi=No',	$
		'4 Electron EESA Low Particle plot (WI_ELSP_3DP) ' + get_cldataset_starttime_endtime('WIND',14,'SC1'),											$
			'0 flux 1112.990 eV#				WIND P2 SC1 FLUX_1112_990 header yleft_log=Log',											$
			'0 flux  689.161 eV#				WIND P2 SC1 FLUX_0689_161 header yleft_log=Log',											$
			'0 flux  426.769 eV#				WIND P2 SC1 FLUX_0426_769 header yleft_log=Log',											$
			'0 flux  264.837 eV#				WIND P2 SC1 FLUX_0264_837 header yleft_log=Log',											$
			'0 flux  164.957 eV#				WIND P2 SC1 FLUX_0164_957 header yleft_log=Log',											$
			'0 flux  103.320 eV#				WIND P2 SC1 FLUX_0103_320 header yleft_log=Log',											$
			'0 flux   65.243 eV#				WIND P2 SC1 FLUX_0065_243 header yleft_log=Log',											$
			'0 flux   41.766 eV#				WIND P2 SC1 FLUX_0041_766 header yleft_log=Log',											$
			'0 flux   27.249 eV#				WIND P2 SC1 FLUX_0027_249 header yleft_log=Log',											$
			'0 flux   18.289 eV#				WIND P2 SC1 FLUX_0018_289 header yleft_log=Log',											$
			'0 flux   12.814 eV#				WIND P2 SC1 FLUX_0012_814 header yleft_log=Log',											$
			'0 flux    9.413 eV#				WIND P2 SC1 FLUX_0009_413 header yleft_log=Log',											$
			'0 flux    7.256 eV#				WIND P2 SC1 FLUX_0007_256 header yleft_log=Log',											$
			'0 flux    5.929 eV#				WIND P2 SC1 FLUX_0005_929 header yleft_log=Log',											$
			'0 flux    5.182 eV#				WIND P2 SC1 FLUX_0005_182 header yleft_log=Log',											$
			'0 Time flux#					WIND P14 SC1 flux count2d type=time_cjf cjf=flux legend_theta=No legend_phi=No',							$
			'0 Energy flux#					WIND P14 SC1 flux count2d type=energy_cjf cjf=flux x_auto=Manual x_min=1 x_max=1e4 legend_theta=No legend_phi=No'			]

	; Electron EESA Low Particle spectrogram (WI_ELPD_3DP) Time Energy flux# uniquement pour webservice
	nom1 = 'ELPD_SPECTRO_TIME_ENERGY'
	nom2 = 'Electron EESA Low Particle spectrogram (WI_ELPD_3DP) Time Energy'
	nom3 = 'WI_3DP_ELPD_SPECTRO_TIME_ENERGY'
	visibility = "ws"
	tab = [	visibility +' 1d_data 		# ' + action ]
	ajouter_dataset, arbre, '<dataset id="WIND:3DP:'+nom1+'" visibility="'+visibility+'">4 '+nom2, 'WIND', 20, 'SC1', tab, nom3, 'wind', /spectro

	arbre = [ arbre,																								$
		'4 Electron EESA Low Particle spectrogram (WI_ELPD_3DP) ' + get_cldataset_starttime_endtime('WIND',20,'SC1'),											$
			'0 Time Energy flux# 				WIND P20 SC1 flux count3d type=time_energy cjf=flux yleft_auto=Manual yleft_min=1 yleft_max=1e4 z_showdir=No z_theta=No z_phi=No',		$
			'0 Time Pitchangle flux# 			WIND P20 SC1 flux count3d type=time_theta cjf=flux yleft_auto=Manual yleft_min=0 yleft_max=180 z_showdir=No z_theta=No z_phi=No',		$
		'4 Electron EESA Low Particle plot (WI_ELPD_3DP) ' + get_cldataset_starttime_endtime('WIND',20,'SC1'),												$
			'0 Time flux#					WIND P20 SC1 flux count2d type=time_cjf cjf=flux yleft_typetitle=Wording legend_theta=No legend_phi=No',					$
			'0 Energy flux#					WIND P20 SC1 flux count2d type=energy_cjf cjf=flux x_auto=Manual x_min=1 x_max=10000 yleft_typetitle=Wording legend_theta=No legend_phi=No'	]

	; Electron EESA High Particle spectrogram (WI_EHSP_3DP) Time Energy flux# uniquement pour webservice
	nom1 = 'EHSP_SPECTRO_TIME_ENERGY'
	nom2 = 'Electron EESA High Particle spectrogram (WI_EHSP_3DP) Time Energy'
	nom3 = 'WI_3DP_EHSP_SPECTRO_TIME_ENERGY'
	visibility = "ws"
	tab = [	visibility +' 1d_data 		# ' + action ]
	ajouter_dataset, arbre, '<dataset id="WIND:3DP:'+nom1+'" visibility="'+visibility+'">4 '+nom2, 'WIND', 13, 'SC1', tab, nom3, 'wind', /spectro

	arbre = [ arbre,																								$
		'4 Electron EESA High Particle spectrogram (WI_EHSP_3DP) ' + get_cldataset_starttime_endtime('WIND',13,'SC1'),											$
			'0 Time Energy flux# 					WIND P13 SC1 flux count3d type=time_energy cjf=flux yleft_auto=Manual yleft_min=100 yleft_max=1e5 z_showdir=No z_theta=No z_phi=No',	$
		'4 Electron EESA High Particle plot (WI_EHSP_3DP) ' + get_cldataset_starttime_endtime('WIND',13,'SC1'),												$
			'0 flux 27662.700 eV#					WIND P1 SC1 FLUX_27662_700 header yleft_log=Log',											$
			'0 flux 18944.400 eV#					WIND P1 SC1 FLUX_18944_400 header yleft_log=Log',											$
			'0 flux 12965.800 eV#					WIND P1 SC1 FLUX_12965_800 header yleft_log=Log',											$
			'0 flux  8874.880 eV#					WIND P1 SC1 FLUX_08874_880 header yleft_log=Log',											$
			'0 flux  6076.480 eV#					WIND P1 SC1 FLUX_06076_480 header yleft_log=Log',											$
			'0 flux  4161.270 eV#					WIND P1 SC1 FLUX_04161_270 header yleft_log=Log',											$
			'0 flux  2849.210 eV#					WIND P1 SC1 FLUX_02849_210 header yleft_log=Log',											$
			'0 flux  1952.320 eV#					WIND P1 SC1 FLUX_01952_320 header yleft_log=Log',											$
			'0 flux  1339.370 eV#					WIND P1 SC1 FLUX_01339_370 header yleft_log=Log',											$
			'0 flux   920.296 eV#					WIND P1 SC1 FLUX_00920_296 header yleft_log=Log',											$
			'0 flux   634.385 eV#					WIND P1 SC1 FLUX_00634_385 header yleft_log=Log',											$
			'0 flux   432.730 eV#					WIND P1 SC1 FLUX_00432_730 header yleft_log=Log',											$
			'0 flux   292.064 eV#					WIND P1 SC1 FLUX_00292_064 header yleft_log=Log',											$
			'0 flux   200.056 eV#					WIND P1 SC1 FLUX_00200_056 header yleft_log=Log',											$
			'0 flux   136.845 eV#					WIND P1 SC1 FLUX_00136_845 header yleft_log=Log',											$
			'0 Time flux#						WIND P13 SC1 flux count2d type=time_cjf cjf=flux legend_theta=No legend_phi=No',							$
			'0 Energy flux#						WIND P13 SC1 flux count2d type=energy_cjf cjf=flux x_auto=Manual x_min=100 x_max=100000 legend_theta=No legend_phi=No'			]

	; Ion PESA Low On board Moments 3sec resolution (WI_PM_3DP)
	tab = [	'cl,ws	P_DENS							#				header',			$
		'cl,ws	P_VELSx,P_VELSy,P_VELSz					Vx,Vy,Vz			header',			$
		'cl,ws	P_TENS_1,P_TENS_2,P_TENS_3,P_TENS_4,P_TENS_5,P_TENS_6	Pxx,Pyy,Pzz,Pxy,Pxz,Pyz		header',			$
		'cl,ws	P_TEMP							#				header',			$
		'cl,ws	A_DENS							#				header',			$
		'cl,ws	A_VELSx,A_VELSy,A_VELSz					Vx,Vy,Vz			header',			$
		'cl,ws	A_TENS_1,A_TENS_2,A_TENS_3,A_TENS_4,A_TENS_5,A_TENS_6	Pxx,Pyy,Pzz,Pxy,Pxz,Pyz		header',			$
		'cl,ws	A_TEMP							#				header',			$
		'cl,ws	E_RANGE_1						#				header',			$
		'cl,ws	E_RANGE_2						#				header',			$
		'cl,ws	VC							#				header',			$
		'cl,ws	GAP							#				header',			$
		'cl,ws	VALID							#				header'				]
	ajouter_dataset, arbre, '<dataset id="WIND:3DP:PM">4 Ion PESA Low On board Moments 3sec resolution (WI_PM_3DP)', 'WIND', 4, 'SC1', tab, 'WI_3DP_PM', 'wind'

	; Ion PESA Low Moments (WI_PLSP_3DP)
	tab = [	'cl,ws	MOM_P_SC_CURRENT										#				header',			$
		'cl,ws	MOM_P_MAGF_1,MOM_P_MAGF_2,MOM_P_MAGF_3								Bx,By,Bz			header',			$
		'cl,ws	MOM_P_DENSITY											#				header',			$
		'cl,ws	MOM_P_AVGTEMP											#				header',			$
		'cl,ws	MOM_P_VTHERMAL											#				header',			$
		'cl,ws	MOM_P_VELOCITY_1,MOM_P_VELOCITY_2,MOM_P_VELOCITY_3						Vx,Vy,Vz			header',			$
		'cl,ws	MOM_P_FLUX_1,MOM_P_FLUX_2,MOM_P_FLUX_3								x,y,z				header',			$
		'cl,ws	MOM_P_PTENS_1,MOM_P_PTENS_2,MOM_P_PTENS_3,MOM_P_PTENS_4,MOM_P_PTENS_5,MOM_P_PTENS_6		Pxx,Pyy,Pzz,Pxy,Pxz,Pyz		header',			$
		'cl,ws	MOM_P_MFTENS_1,MOM_P_MFTENS_2,MOM_P_MFTENS_3,MOM_P_MFTENS_4,MOM_P_MFTENS_5,MOM_P_MFTENS_6	Pxx,Pyy,Pzz,Pxy,Pxz,Pyz		header',			$
		'cl,ws	MOM_P_T3_1,MOM_P_T3_2,MOM_P_T3_3								x,y,z				header',			$
		'cl,ws	MOM_P_SYMM_1,MOM_P_SYMM_2,MOM_P_SYMM_3								x,y,z				header',			$
		'cl,ws	MOM_P_SYMM_THETA										#				header',			$
		'cl,ws	MOM_P_SYMM_PHI											#				header',			$
		'cl,ws	MOM_P_SYMM_ANG											#				header',			$
		'cl,ws	MOM_P_ERANGE_1											#				header',			$
		'cl,ws	MOM_P_ERANGE_2											#				header',			$
		'cl,ws	MOM_P_MASS											#				header',			$
		'cl,ws	MOM_P_VALID											#				header',			$
		'cl,ws	MOM_P_VEL_MAG											#				header',			$
		'cl,ws	MOM_P_VEL_TH											#				header',			$
		'cl,ws	MOM_P_VEL_PHI											#				header',			$
		'cl,ws	MOM_A_SC_CURRENT										#				header',			$
		'cl,ws	MOM_A_MAGF_1,MOM_A_MAGF_2,MOM_A_MAGF_3								Bx,By,Bz			header',			$
		'cl,ws	MOM_A_DENSITY											#				header',			$
		'cl,ws	MOM_A_AVGTEMP											#				header',			$
		'cl,ws	MOM_A_VTHERMAL											#				header',			$
		'cl,ws	MOM_A_VELOCITY_1,MOM_A_VELOCITY_2,MOM_A_VELOCITY_3						Vx,Vy,Vz			header',			$
		'cl,ws	MOM_A_FLUX_1,MOM_A_FLUX_2,MOM_A_FLUX_3								x,y,z				header',			$
		'cl,ws	MOM_A_PTENS_1,MOM_A_PTENS_2,MOM_A_PTENS_3,MOM_A_PTENS_4,MOM_A_PTENS_5,MOM_A_PTENS_6		Pxx,Pyy,Pzz,Pxy,Pxz,Pyz		header',			$
		'cl,ws	MOM_A_MFTENS_1,MOM_A_MFTENS_2,MOM_A_MFTENS_3,MOM_A_MFTENS_4,MOM_A_MFTENS_5,MOM_A_MFTENS_6	Pxx,Pyy,Pzz,Pxy,Pxz,Pyz		header',			$
		'cl,ws	MOM_A_T3_1,MOM_A_T3_2,MOM_A_T3_3								#				header',			$
		'cl,ws	MOM_A_SYMM_1,MOM_A_SYMM_2,MOM_A_SYMM_3								#				header',			$
		'cl,ws	MOM_A_SYMM_THETA										#				header',			$
		'cl,ws	MOM_A_SYMM_PHI											#				header',			$
		'cl,ws	MOM_A_SYMM_ANG											#				header',			$
		'cl,ws	MOM_A_ERANGE_1											#				header',			$
		'cl,ws	MOM_A_ERANGE_2											#				header',			$
		'cl,ws	MOM_A_MASS											#				header',			$
		'cl,ws	MOM_A_VALID											#				header',			$
		'cl,ws	MOM_A_VEL_MAG											#				header',			$
		'cl,ws	MOM_A_VEL_TH											#				header',			$
		'cl,ws	MOM_A_VEL_PHI											#				header']
	ajouter_dataset, arbre, '<dataset id="WIND:3DP:PLSP">4 Ion PESA Low Moments (WI_PLSP_3DP)', 'WIND', 3, 'SC1', tab, 'WI_3DP_PLSP', 'wind'

	; Ion PESA Low Particle spectrogram (WI_PLSP_3DP) Time Energy flux# uniquement pour webservice
	nom1 = 'PLSP_SPECTRO_TIME_ENERGY'
	nom2 = 'Ion PESA Low Particle spectrogram (WI_PLSP_3DP) Time Energy'
	nom3 = 'WI_3DP_PLSP_SPECTRO_TIME_ENERGY'
	visibility = "ws"
	tab = [	visibility +' 1d_data 		# ' + action ]
	ajouter_dataset, arbre, '<dataset id="WIND:3DP:'+nom1+'" visibility="'+visibility+'">4 '+nom2, 'WIND', 15, 'SC1', tab, nom3, 'wind', /spectro

	arbre = [ arbre,																											$
		'4 Ion PESA Low Particle spectrogram (WI_PLSP_3DP) ' + get_cldataset_starttime_endtime('WIND',15,'SC1'),															$
			'0 Time Energy flux#                                                            WIND P15 SC1 flux count3d type=time_energy cjf=fdist yleft_auto=Manual yleft_min=1e2 yleft_max=1e4 z_showdir=No z_theta=No z_phi=No',	$
		'4 Ion PESA Low Particle plot (WI_PLSP_3DP) ' + get_cldataset_starttime_endtime('WIND',15,'SC1'),																$
			'0 Time flux#									WIND P15 SC1 flux count2d type=time_cjf cjf=flux legend_theta=No legend_phi=No',							$
			'0 Energy flux#									WIND P15 SC1 flux count2d type=energy_cjf cjf=flux x_auto=Manual x_min=1e2 x_max=1e4 legend_theta=No legend_phi=No'			]

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'<instrument name="EPACT" id="WIND:EPACT">3 EPACT'											]

	; Key Parameters (WI_K0_EPA)
	tab = [	'cl,ws	LEMT_He__flux_3_2_6_2_keV_n_____cm2_sr_sec_MeV_n_	#		header',			$
		'cl,ws	LEMT_O1__flux_3_2_6_2_keV_n_____cm2_sr_sec_MeV_n_	#		header',			$
		'cl,ws	LEMT_Fe__flux_3_2_6_2_keV_n_____cm2_sr_sec_MeV_n_	#		header',			$
		'cl,ws	APE_B_e__flux_1_10_MeV_n________cm2_sr_sec_MeV_n_	#		header',			$
		'cl,ws	APE_B_p__flux_19_28_MeV_n_______cm2_sr_sec_MeV_n_	#		header',			$
		'cl,ws	APE_B_p__flux_28_72_Mev_n_______cm2_sr_sec_MeV_n_	#		header',			$
		'cl,ws	APE_B_He_flux_19_28_MeV_n_______cm2_sr_sec_MeV_n_	#		header',			$
		'cl,ws	STEP_He__flux_80_160_keV_n______cm2_sr_sec_MeV_n_	#		header',			$
		'cl,ws	STEP_He__flux_320_640_keV_n_____cm2_sr_sec_MeV_n_	#		header',			$
		'cl,ws	STEP_CNO_flux_80_160_keV_n______cm2_sr_sec_MeV_n_	#		header',			$
		'cl,ws	STEP_CNO_flux_320_640_keV_n_____cm2_sr_sec_MeV_n_	#		header',			$
		'cl,ws	STEP_Fe__flux_80_160_keV_n______cm2_sr_sec_MeV_n_	#		header',			$
		'cl,ws	STEP_Fe__flux_640_1050_keV_n____cm2_sr_sec_MeV_n_	#		header',			$
		'cl,ws	Data_Quality_Flag					#		header',			$
		'cl,ws	Gap_Flag						#		header'				]
	ajouter_dataset, arbre, '<dataset id="WIND:EPA:K0">4 Key Parameters (WI_K0_EPA)', 'WIND', 5, 'SC1', tab, 'WI_EPA_K0', 'wind'

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'<instrument name="SMS" id="WIND:SMS">3 SMS'											]

	; Key Parameters (WI_K0_SMS)
	tab = [	'cl,ws	Valpha_km_sec		#		header',			$
		'cl,ws	C_O_ratio		#		header',			$
		'cl,ws	C_ioniztn_T_MK		#		header',			$
		'cl,ws	O_ioniztn_T_MK		#		header',			$
		'cl,ws	Delta_in_speed_km_s	#		header',			$
		'cl,ws	C_O_uncertainty		#		header',			$
		'cl,ws	Delta_C_ioniztn_T_MK	#		header',			$
		'cl,ws	Delta_O_ioniztn_T_MK	#		header',			$
		'cl,ws	Data_Quality_Flag_1	#		header',			$
		'cl,ws	Post_Gap_Flag		#		header'				]
	ajouter_dataset, arbre, '<dataset id="WIND:SMS:K0">4 Key Parameters (WI_K0_SMS)', 'WIND', 8, 'SC1', tab, 'WI_SMS_K0', 'wind'

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'<instrument name="SWE" id="WIND:SWE">3 SWE'												]

	; 100-sec Proton Anisotropy Analysis (WI_H1_SWE)
	tab = [	'cl,ws	Proton_V_nonlin_km_s									#		header',			$
		'cl,ws	Proton_VX_nonlin_km_s,Proton_VY_nonlin_km_s,Proton_VZ_nonlin_km_s			Vx,Vy,Vz	header',			$
		'cl,ws	Proton_sigmaVX_nonlin_km_s,Proton_sigmaVY_nonlin_km_s,Proton_sigmaVZ_nonlin_km_s	Vx,Vy,Vz	header',			$
		'cl,ws	Proton_sigmaW_nonlin_km_s								#		header',			$
		'cl,ws	Proton_Wperp_nonlin_km_s								#		header',			$
		'cl,ws	Proton_sigmaWperp_nonlin_km_s								#		header',			$
		'cl,ws	Proton_Wpar_nonlin_km_s									#		header',			$
		'cl,ws	Proton_sigmaWpar_nonlin_km_s								#		header',			$
		'cl,ws	EW_flowangle_deg									#		header',			$
		'cl,ws	SigmaEW_flowangle_km_s									#		header',			$
		'cl,ws	NS_flowangle_deg									#		header',			$
		'cl,ws	SigmaNS_flowangle_deg									#		header',			$
		'cl,ws	NS_flowangle_deg									#		header',			$
		'cl,ws	SigmaNS_flowangle_deg									#		header',			$
		'cl,ws	Proton_Np_nonlin_n_cc									#		header',			$
		'cl,ws	Proton_sigmaNp_nonlin_n_cc								#		header',			$
		'cl,ws	Alpha_V_nonlin_km_s									#		header',			$
		'cl,ws	Alpha_sigmaV_nonlin_km_s								#		header',			$
		'cl,ws	Alpha_VX_nonlin_km_s,Alpha_VY_nonlin_km_s,Alpha_VZ_nonlin_km_s				Vx,Vy,Vz	header',			$
		'cl,ws	Alpha_sigmaVX_nonlin_km_s,Alpha_sigmaVY_nonlin_km_s,Alpha_sigmaVZ_nonlin_km_s		Vx,Vy,Vz	header',			$
		'cl,ws	Alpha_W_nonlin_km_s									#		header',			$
		'cl,ws	Alpha_sigmaW_nonlin_km_s								#		header',			$
		'cl,ws	Alpha_Wperp_nonlin_km_s									#		header',			$
		'cl,ws	Alpha_sigmaWperp_nonlin_km_s								#		header',			$
		'cl,ws	Alpha_Wpar_nonlin_km_s									#		header',			$
		'cl,ws	Alpha_sigmaWpar_nonlin_km_s								#		header',			$
		'cl,ws	Alpha_Na_nonlin_n_cc									#		header',			$
		'cl,ws	Alpha_sigmaNa_nonlin_n_cc								#		header',			$
		'cl,ws	ChisQ_DOF_nonlin									#		header',			$
		'cl,ws	Peak_doy										#		header',			$
		'cl,ws	sigmaPeak_doy										#		header',			$
		'cl,ws	Proton_V_moment_km_s									#		header',			$
		'cl,ws	Proton_VX_moment_km_s,Proton_VY_moment_km_s,Proton_VZ_moment_km_s			Vx,Vy,Vz	header',			$
		'cl,ws	Proton_W_moment_km_s									#		header',			$
		'cl,ws	Proton_Wperp_moment_km_s								#		header',			$
		'cl,ws	Proton_Wpar_moment_km_s									#		header',			$
		'cl,ws	Proton_Np_moment_n_cc									#		header',			$
		'cl,ws	BX_GSE_nT,BY_GSE_nT,BZ_GSE_nT								Bx,By,Bz	header',			$
		'cl,ws	Ang_dev_deg										#		header',			$
		'cl,ws	dev_nT											#		header',			$
		'cl,ws	Xgse_Rt,Ygse_Rt,Zgse_Rt									x,y,z		header',			$
		'cl,ws	Ygsm_Rt,Zgsm_Rt										y,z		header'				]
	ajouter_dataset, arbre, '<dataset id="WIND:SWE:H1">4 100-sec Proton Anisotropy Analysis (WI_H1_SWE)', 'WIND', 9, 'SC1', tab, 'WI_SWE_H1', 'wind'

	; Moments 9sec resolution (WI_H5_SWE)
	tab = [	'cl,ws	Ne_cm3												#				header',			$
		'cl,ws	Necore_cm3											#				header',			$
		'cl,ws	Vxebulk_gse_km_sec,Vyebulk_gse_km_sec,Vzebulk_gse_km_sec					Vx,Vy,Vz			header',			$
		'cl,ws	Vxecorebulk_gse_km_sec,Vyecorebulk_gse_km_sec,Vzecorebulk_gse_km_sec				Vx,Vy,Vz			header',			$
		'cl,ws	Pexx_gse_erg_cc,Pexy_gse_erg_cc,Pexz_gse_erg_cc,Peyy_gse_erg_cc,Peyz_gse_erg_cc,Pezz_gse_erg_cc	Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		header',			$
		'cl,ws	Te_K												#				header',			$
		'cl,ws	Tecore_K											#				header',			$
		'cl,ws	We_eV												#				header',			$
		'cl,ws	Wecore_eV											#				header',			$
		'cl,ws	Tepal_K												#				header',			$
		'cl,ws	Teper_K												#				header',			$
		'cl,ws	Tecorepal_K											#				header',			$
		'cl,ws	Tecoreper_K											#				header',			$
		'cl,ws	Teani												#				header',			$
		'cl,ws	Tecoreani											#				header',			$
		'cl,ws	EGyrtrp												#				header'				]
	ajouter_dataset, arbre, '<dataset id="WIND:SWE:H5">4 Moments 9sec resolution (WI_H5_SWE)', 'WIND', 17, 'SC1', tab, 'WI_SWE_H5', 'wind'

	; Key Parameter (WI_K0_SWE)
	tab = [	'cl,ws	Delta_time					#		header',			$
		'cl,ws	GAP_FLAG					#		header',			$
		'cl,ws	MODE						#		header',			$
		'cl,ws	SC_pos_Xgse_km,SC_pos_Ygse_km,SC_pos_Zgse_km	x,y,z		header',			$
		'cl,ws	SC_pos_Xgsm_km,SC_pos_Ygsm_km,SC_pos_Zgsm_km	x,y,z		header',			$
		'cl,ws	SC_pos_R_km					#		header',			$
		'cl,ws	DQF						#		header',			$
		'cl,ws	QF_V						#		header',			$
		'cl,ws	QF_Vth						#		header',			$
		'cl,ws	QF_Np						#		header',			$
		'cl,ws	QF_a_p						#		header',			$
		'cl,ws	Vx_GSE_km_s,Vy_GSE_km_s,Vz_GSE_km_s		Vx,Vy,Vz	header',			$
		'cl,ws	Vx_GSM_km_s,Vy_GSM_km_s,Vz_GSM_km_s		Vx,Vy,Vz	header',			$
		'cl,ws	Vx_GSE_p,Vy_GSE_p,Vz_GSE_p			#		header',			$
		'cl,ws	THERMAL_SPD_km_s				#		header',			$
		'cl,ws	Np_cc						#		header'				]

		; jamais de donnes sauf 0 le 1er nov 1994
		;'cl,ws	Alpha_Percent					#		header'				]
	ajouter_dataset, arbre, '<dataset id="WIND:SWE:K0">4 Key Parameter (WI_K0_SWE)', 'WIND', 19, 'SC1', tab, 'WI_SWE_K0', 'wind'

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'<instrument name="WAVES" id="WIND:WAVES">3 WAVES'											]

	; Key Parameters (WI_H0_WAV)
	tab = [	'cl,ws	Ne__N_cm__3					#		header',			$
		'cl,ws	Ne_peak_dB					#		header',			$
		'cl,ws	Ne_Quality					#		header',			$
		'cl,ws	GAP_FLAG					#		header'				]
	ajouter_dataset, arbre, '<dataset id="WIND:WAVES:H0">4 Key Parameters (WI_H0_WAV)', 'WIND', 10, 'SC1', tab, 'WI_WAVES_H0', 'wind'

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'</mission>' 																$
	]

	RETURN, arbre

END


;-------------------------------------------------------------------------------
FUNCTION get_arbre_omni
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL OMNI.
;-------------------------------------------------------------------------------

	arbre = [			$
		'2 OMNI',		$

		'3 omni_coho1hr_magplasma ' + get_cldataset_starttime_endtime('OMNI',0,'SC1'),											$
			'0 HelioGraphic Inertial (HGI) latitude#	OMNI P0 SC1 heliographicLatitude_deg header',	$
			'0 HelioGraphic Inertial (HGI) longitude#	OMNI P0 SC1 heliographicLongitude_deg header',	$
			'0 B in RTN Bx,By,Bz,B#				OMNI P0 SC1 BR_nT,BT_nT,BN_nT,ABS_B_nT header',	$
			'0 Bulk Flow Speed#				OMNI P0 SC1 V_km_sec header',			$
			'0 Proton flow elevation angle / latitude (RTN)#OMNI P0 SC1 elevAngle_deg header',		$
			'0 Proton flow azimuth angle / longitude (RTN)#	OMNI P0 SC1 azimuthAngle_deg header',		$
			'0 Ion Density#					OMNI P0 SC1 N_cm3 header',			$
			'0 Temperature#					OMNI P0 SC1 T_degK header',			$

		'3 omni_hro_5min ' + get_cldataset_starttime_endtime('OMNI',1,'SC1'),																$
			'0 ID for IMF spacecraft [ACE=71 Geotail=60 IMP8=50 Wind=51]#		OMNI P1 SC1 IMF header',					$
			'0 ID for SW Plasma spacecraft [ACE=71 Geotail=60 IMP8=50 Wind=51]#	OMNI P1 SC1 PLS header',					$
			'0 Nb fine time scale IMF averages#					OMNI P1 SC1 IMF_PTS header',					$
			'0 Nb fine time scale plasma averages#					OMNI P1 SC1 PLS_PTS header',					$
			'0 Percent interpolated#						OMNI P1 SC1 percent_interp header',				$
			'0 Timeshift#								OMNI P1 SC1 Timeshift_sec header',				$
			'0 RMS Timeshift#							OMNI P1 SC1 RMS_Timeshift_sec header',				$
			'0 Time between observations#						OMNI P1 SC1 Time_btwn_obs_sec header',				$
			'0 Magnitude of avg. field vector#					OMNI P1 SC1 F_nT header',					$
			'0 Magnetic field GSE Bx,By,Bz#						OMNI P1 SC1 BX_GSE_nT,BY_GSE_nT,BZ_GSE_nT header',		$
			'0 Magnetic field GSM Bx,By,Bz#						OMNI P1 SC1 BX_GSM_nT,BY_GSM_nT,BZ_GSM_nT header',		$
			'0 RMS SD B scalar#							OMNI P1 SC1 RMS_SD_B_nT header',				$
			'0 RMS SD field vector#							OMNI P1 SC1 RMS_SD_fld_vec_nT header',				$
			'0 flow speed GSE#							OMNI P1 SC1 flow_speed_GSE_km_sec header',			$
			'0 Velocity GSE Vx,Vy,Vz#						OMNI P1 SC1 Vx_GSE_km_sec,Vy_GSE_km_sec,Vz_GSE_km_sec header',	$
			'0 Proton density#							OMNI P1 SC1 proton_density_cm3 header',				$
			'0 temperature#								OMNI P1 SC1 T_K header',					$
			'0 Flow pressure#							OMNI P1 SC1 Pressure_nPa header',				$
			'0 Electric Field#							OMNI P1 SC1 E_mV_m header',					$
			'0 Plasma beta#								OMNI P1 SC1 Beta header',					$
			'0 Alfen mach number#							OMNI P1 SC1 Mach_num header',					$
			'0 s/c GSE X,Y,Z#							OMNI P1 SC1 x_SC_GSE_Re,y_SC_GSE_Re,z_SC_GSE_Re header',	$
			'0 BSN GSE X,Y,Z#							OMNI P1 SC1 BSN_x_GSE_Re,BSN_y_GSE_Re,BSN_z_GSE_Re header',	$
			'0 AE-index (5-m) from WDC Kyoto#					OMNI P1 SC1 AE_INDEX_nT header',				$
			'0 AL-index (5-m) from WDC Kyoto#					OMNI P1 SC1 AL_INDEX_nT header',				$
			'0 AU-index (5-m) from WDC Kyoto#					OMNI P1 SC1 AU_INDEX_nT header',				$
			'0 SYM/D index from WDC Kyoto#						OMNI P1 SC1 SYM_D_nT header',					$
			'0 SYM/H index from WDC Kyoto#						OMNI P1 SC1 SYM_H_nT header',					$
			'0 ASY/D index from WDC Kyoto#						OMNI P1 SC1 ASY_D_nT header',					$
			'0 ASY/H index from WDC Kyoto#						OMNI P1 SC1 ASY_H_nT header',					$
			'0 PC(N) index from Danish Meteorological Institute#			OMNI P1 SC1 PC_N_INDEX header',					$
			'0 PROT Flux >10 MEV#							OMNI P1 SC1 PR_FLX_10Mev_SQcm_ster_s header',			$
			'0 PROT Flux >30 MEV#							OMNI P1 SC1 PR_FLX_30Mev_SQcm_ster_s header',			$
			'0 PROT Flux >60 MEV#							OMNI P1 SC1 PR_FLX_60Mev_SQcm_ster_s header',			$
			'0 IMF Cone angle GSE#							OMNI P1 SC1 IMF_cone_angle_GSE header',				$
			'0 IMF Clock angle GSE#							OMNI P1 SC1 IMF_clock_angle_GSE header',			$
			'0 IMF Clock angle GSM#							OMNI P1 SC1 IMF_clock_angle_GSM header',			$

		'3 omni_hro_1min ' + get_cldataset_starttime_endtime('OMNI',2,'SC1'),										$
			'0 ID for IMF spacecraft [ACE=71 Geotail=60 IMP8=50 Wind=51]#		OMNI P2 SC1 IMF header',					$
			'0 ID for SW Plasma spacecraft [ACE=71 Geotail=60 IMP8=50 Wind=51]#	OMNI P2 SC1 PLS header',					$
			'0 Nb fine time scale IMF averages#					OMNI P2 SC1 IMF_PTS header',					$
			'0 Nb fine time scale plasma averages#					OMNI P2 SC1 PLS_PTS header',					$
			'0 Percent interpolated#						OMNI P2 SC1 percent_interp header',				$
			'0 Timeshift#								OMNI P2 SC1 Timeshift_sec header',				$
			'0 RMS Timeshift#							OMNI P2 SC1 RMS_Timeshift_sec header',				$
			'0 RMS Phase front normal#						OMNI P2 SC1 RMS_phase_nT header',				$
			'0 Time between observations#						OMNI P2 SC1 Time_btwn_obs_sec header',				$
			'0 Magnitude of avg. field vector#					OMNI P2 SC1 F_nT header',					$
			'0 Magnetic field GSE Bx,By,Bz#						OMNI P2 SC1 BX_GSE_nT,BY_GSE_nT,BZ_GSE_nT header',		$
			'0 Magnetic field GSM Bx,By,Bz#						OMNI P2 SC1 BX_GSM_nT,BY_GSM_nT,BZ_GSM_nT header',		$
			'0 RMS SD B scalar#							OMNI P2 SC1 RMS_SD_B_nT header',				$
			'0 RMS SD field vector#							OMNI P2 SC1 RMS_SD_fld_vec_nT header',				$
			'0 flow speed GSE#							OMNI P2 SC1 flow_speed_GSE_km_sec header',			$
			'0 Velocity GSE Vx,Vy,Vz#						OMNI P2 SC1 Vx_GSE_km_sec,Vy_GSE_km_sec,Vz_GSE_km_sec header',	$
			'0 Proton density#							OMNI P2 SC1 proton_density_cm3 header',				$
			'0 temperature#								OMNI P2 SC1 T_K header',					$
			'0 Flow pressure#							OMNI P2 SC1 Pressure_nPa header',				$
			'0 Electric Field#							OMNI P2 SC1 E_mV_m header',					$
			'0 Plasma beta#								OMNI P2 SC1 Beta header',					$
			'0 Alfen mach number#							OMNI P2 SC1 Mach_num header',					$
			'0 s/c GSE X,Y,Z#							OMNI P2 SC1 x_SC_GSE_Re,y_SC_GSE_Re,z_SC_GSE_Re header',	$
			'0 BSN GSE X,Y,Z#							OMNI P2 SC1 BSN_x_GSE_Re,BSN_y_GSE_Re,BSN_z_GSE_Re header',	$
			'0 AE-index (5-m) from WDC Kyoto#					OMNI P2 SC1 AE_INDEX_nT header',				$
			'0 AL-index (5-m) from WDC Kyoto#					OMNI P2 SC1 AL_INDEX_nT header',				$
			'0 AU-index (5-m) from WDC Kyoto#					OMNI P2 SC1 AU_INDEX_nT header',				$
			'0 SYM/D index from WDC Kyoto#						OMNI P2 SC1 SYM_D_nT header',					$
			'0 SYM/H index from WDC Kyoto#						OMNI P2 SC1 SYM_H_nT header',					$
			'0 ASY/D index from WDC Kyoto#						OMNI P2 SC1 ASY_D_nT header',					$
			'0 ASY/H index from WDC Kyoto#						OMNI P2 SC1 ASY_H_nT header',					$
			'0 PC(N) index from Danish Meteorological Institute#			OMNI P2 SC1 PC_N_INDEX header',					$
			'0 IMF Cone angle GSE#							OMNI P1 SC1 IMF_cone_angle_GSE header',				$
			'0 IMF Clock angle GSE#							OMNI P1 SC1 IMF_clock_angle_GSE header',			$
			'0 IMF Clock angle GSM#							OMNI P1 SC1 IMF_clock_angle_GSM header'				$
	]

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_poesn17
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL POESN17.
;-------------------------------------------------------------------------------
;
; POES n'est pas dans spase !
;

	create_products, 'POESN17'

	target  = "Earth" ; E. Penou
	targets = "Earth" ; E. Penou

	arbre = [																	$
		'<mission name="POESN17" id="POESN17" target="'+target+'" targets="'+targets+'">2 POESN17',						$
		'<instrument name="ephemeris" id="POESN17:ephemeris">3 ephemeris'									]

	; ephemeris
	tab = [	'cl	L,MLT                                L,MLT  orbito',										$
		'cl,ws	satellite_altitude                   #      header',										$
		'cl,ws	orbit                                #      header',										$
		'cl,ws	RLAT                                 #      header',										$
		'cl,ws	RLONG                                #      header',										$
		'cl,ws	scalar_value_of_B_at_the_satellite   #      header',										$
		'cl,ws	TED_0_degree_pa_at_the_satellite     #      header',										$
		'cl,ws	TED_30_degree_pa_at_the_satellite    #      header',										$
		'cl,ws	MEPED_0_degree_pa_at_the_satellite   #      header',										$
		'cl,ws	MEPED_90_degree_pa_at_the_satellite  #      header',										$
		'cl,ws	scalar_value_of_B_at_the_fofl        #      header',										$
		'cl,ws	TED_0_degree_pa_at_the_fofl          #      header',										$
		'cl,ws	TED_30_degree_pa_at_the_fofl         #      header',										$
		'cl,ws	MEPED_0_pa_at_the_fofl               #      header',										$
		'cl,ws	MEPED_90_pa_at_the_fofl              #      header',										$
		'cl,ws	fofl_geographic_latitude             #      header',										$
		'cl,ws	fofl_geographic_longitude            #      header',										$
		'cl,ws	fofl_geomagnetic_latitude            #      header',										$
		'cl,ws	fofl_geomagnetic_longitude           #      header',										$
		'cl,ws	L                                    #      header',										$
		'cl,ws	corrected_magnetic_latitude          #      header',										$
		'cl,ws	LTI                                  #      header',										$
		'cl,ws	MLT                                  #  header'											]
	ajouter_dataset, arbre, '<dataset id="POESN17:EPHEMERIS:ORBIT">4 orbit', 'POESN17', 0, 'SC1', tab, 'POESN17_EPHEMERIS_ORBIT', 'poesn17'

	arbre = [ arbre, 													$
		'3 P[1..6]_90 0.03 - 15.00 Mev (6E) PROTON   PERPENDICULAR ' + get_cldataset_starttime_endtime('POESN17',1,'SC1'),	$
		'0 RLONG-RLAT count#		POESN17 P1 SC1 count count3d type=RLONG_RLAT cjf=count yleft_log=Linear yleft_auto=Manual yleft_min=-90 yleft_max=90 x_auto=Manual x_min=-180 x_max=180 z_showdir=No z_theta=No z_phi=No',	$
		'3 E[1..3]_90 0.03 - 2.50 Mev (3E) ELECTRON PERPENDICULAR ' + get_cldataset_starttime_endtime('POESN17',2,'SC1'),	$
		'0 RLONG-RLAT count#		POESN17 P2 SC1 count count3d type=RLONG_RLAT cjf=count yleft_log=Linear yleft_auto=Manual yleft_min=-90 yleft_max=90 x_auto=Manual x_min=-180 x_max=180 z_showdir=No z_theta=No z_phi=No',	$
		'3 P[1..6]_0 0.03 - 15.00 Mev (6E) PROTON FIELD ALIGNED ' + get_cldataset_starttime_endtime('POESN17',3,'SC1'),	$
		'0 RLONG-RLAT count#		POESN17 P3 SC1 count count3d type=RLONG_RLAT cjf=count yleft_log=Linear yleft_auto=Manual yleft_min=-90 yleft_max=90 x_auto=Manual x_min=-180 x_max=180 z_showdir=No z_theta=No z_phi=No',	$
		'3 E[1..3]_0 0.03 -  2.50 Mev (6E) ELECTRON FIELD ALIGNED ' + get_cldataset_starttime_endtime('POESN17',4,'SC1'),	$
		'0 RLONG-RLAT count#		POESN17 P4 SC1 count count3d type=RLONG_RLAT cjf=count yleft_log=Linear yleft_auto=Manual yleft_min=-90 yleft_max=90 x_auto=Manual x_min=-180 x_max=180 z_showdir=No z_theta=No z_phi=No',	$
		'3 P[6..3]_Omni_directional 16 - 141 Mev (4E) PROTON DOME ' + get_cldataset_starttime_endtime('POESN17',5,'SC1'),	$
		'0 RLONG-RLAT count#		POESN17 P5 SC1 count count3d type=RLONG_RLAT cjf=count yleft_log=Linear yleft_auto=Manual yleft_min=-90 yleft_max=90 x_auto=Manual x_min=-180 x_max=180 z_showdir=No z_theta=No z_phi=No',	$
		'3 P[1..5]_90_corrected 0.03 - 6.90 Mev (5E) PROTON PERPENDICULAR CORRECTED ' + get_cldataset_starttime_endtime('POESN17',6,'SC1'),	$
		'0 RLONG-RLAT count#		POESN17 P6 SC1 count count3d type=RLONG_RLAT cjf=count yleft_log=Linear yleft_auto=Manual yleft_min=-90 yleft_max=90 x_auto=Manual x_min=-180 x_max=180 z_showdir=No z_theta=No z_phi=No',	$
		'3 E[1..3]_90_corrected 0.03 - 2.50 Mev (3E) ELECTRON PERPENDICULAR CORRECTED ' + get_cldataset_starttime_endtime('POESN17',7,'SC1'),	$
		'0 RLONG-RLAT count#		POESN17 P7 SC1 count count3d type=RLONG_RLAT cjf=count yleft_log=Linear yleft_auto=Manual yleft_min=-90 yleft_max=90 x_auto=Manual x_min=-180 x_max=180 z_showdir=No z_theta=No z_phi=No',	$
		'3 P[1..5]_0_corrected 0.03 - 6.90 Mev (5E) PROTON FIELD ALIGNED CORRECTED ' + get_cldataset_starttime_endtime('POESN17',8,'SC1'),	$
		'0 RLONG-RLAT count#		POESN17 P8 SC1 count count3d type=RLONG_RLAT cjf=count yleft_log=Linear yleft_auto=Manual yleft_min=-90 yleft_max=90 x_auto=Manual x_min=-180 x_max=180 z_showdir=No z_theta=No z_phi=No',	$
		'3 E[1..3]_0_corrected 0.03 - 2.50 Mev (3E) ELECTRON FIELD ALIGNED CORRECTED ' + get_cldataset_starttime_endtime('POESN17',9,'SC1'),	$
		'0 RLONG-RLAT count#		POESN17 P9 SC1 count count3d type=RLONG_RLAT cjf=count yleft_log=Linear yleft_auto=Manual yleft_min=-90 yleft_max=90 x_auto=Manual x_min=-180 x_max=180 z_showdir=No z_theta=No z_phi=No',	$
		'3 MPED[0,90] 0 - 90 deg (2E) MPED ' + get_cldataset_starttime_endtime('POESN17',10,'SC1'),	$
		'0 RLONG-RLAT count#		POESN17 P10 SC1 count count3d type=RLONG_RLAT cjf=count yleft_log=Linear yleft_auto=Manual yleft_min=-90 yleft_max=90 x_auto=Manual x_min=-180 x_max=180 z_showdir=No z_theta=No z_phi=No'	$
	]

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'</mission>' 																$
	]

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_dsp
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL DOUBLE-STAR.
;-------------------------------------------------------------------------------
;
; Trouv dans spase://SMWG/Observatory/DoubleStar1
;
; <ObservatoryRegion>Earth.Magnetosphere.Main</ObservatoryRegion>
;

	create_products, 'DSP'

	target  = "Earth.Magnetosphere.Main"	; V. Genot
	targets = "Earth.Magnetosphere.Main"	; spase

	arbre = [																$
		'<mission name="DOUBLESTAR1" id="DOUBLESTAR1" target="'+target+'" targets="'+targets+'">2 DOUBLESTAR1',				$
		'<instrument name="ephemeris" id="DOUBLESTAR1:ephemeris">3 ephemeris'								]

	; orbit
	tab = [	'cl	XGSE,YGSE,ZGSE			x,y,z  		orbito',								$
		'cl,ws	XGR,YGR,ZGR			x,y,z  		header',								$
		'cl,ws	XGSE,YGSE,ZGSE			x,y,z  		header',								$
		'cl,ws	XGSM,YGSM,ZGSM			x,y,z		header',								$
		'cl,ws	R				#		header',								$
		'cl,ws	DPP				#		header',								$
		'cl,ws	DMP				#		header',								$
		'cl,ws	DBS				#		header',								$
		'cl,ws	DZNSH				#		header',								$
		'cl,ws	DZPSN				#		header',								$
		'cl,ws	DZPSS				#		header',								$
		'cl,ws	DSH				#		header',								$
		'cl,ws	VXGR,VYGR,VZGR,*VGR		Vx,Vy,Vz,|V|	header',								$
		'cl,ws	BXGSM,BYGSM,BZGSM,*BGSM		Bx,By,Bz,|B|	header',								$
		'cl,ws	L				#		header',								$
		'cl,ws	ILAT				#		header',								$
		'cl,ws	MLTS				#		header',								$
		'cl,ws	LATGRS				#		header',								$
		'cl,ws	LONGRS				#		header',								$
		'cl,ws	MLTC				#		header',								$
		'cl,ws	LATGRC				#		header',								$
		'cl,ws	LONGRC				#		header',								$
		'cl,ws	LATGMC				#		header',								$
		'cl,ws	LONGMC				#		header'									]
	ajouter_dataset, arbre, '<dataset id="DOUBLESTAR1:EPHEMERIS:ORBIT">4 orbit', 'DSP', 52, 'SC1', tab, 'DSP1_EPHEMERIS_ORBIT', 'dsp'

	arbre = [ arbre, 																$
		'4 attitude ' + get_cldataset_starttime_endtime('DSP',54,'SC1'),									$
			'0 matrix SR2->GSE low g#DSP P54 SC1 M00_log,M01_log,M02_log,M10_log,M11_log,M12_log,M20_log,M21_log,M22_log header',		$
			'0 matrix SR2->GSE high G#DSP P54 SC1 M00_hig,M01_hig,M02_hig,M10_hig,M11_hig,M12_hig,M20_hig,M21_hig,M22_hig header'		]

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'<instrument name="FGM" id="DOUBLESTAR1:FGM">3 FGM'											]

	; FGM
	tab = [	'cl,ws	Bx_gse_nT,By_gse_nT,Bz_gse_nT,*B_nT	Bx,By,Bz,|B|  	header',								$
		'cl,ws	Bx_gsm_nT,By_gsm_nT,Bz_gsm_nT,*B_nT	Bx,By,Bz,|B|  	header',								$
		'cl,ws	Half_interval				#		header',								$
		'cl,ws	Status1					#		header',								$
		'cl,ws	Status2					#		header',								$
		'cl,ws	Status3					#		header',								$
		'cl,ws	Status4					#		header',								$
		'cl,ws	B_nsigma_t				#		header',								$
		'cl,ws	B_nsigma_b				#		header'									]
	ajouter_dataset, arbre, '<dataset id="DOUBLESTAR1:FGM:4sec">4 4sec resolution', 'DSP-OTH', 0, 'SC1', tab, 'DSP1_FGM_4SEC', 'dsp_oth'

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'<instrument name="HIA" id="DOUBLESTAR1:HIA">3 HIA'											]

	tab = [	'cl,ws	NH1_HIA_cm3												#  		header yleft_log=Log',	$
		'cl,ws	Vx_H1_HIA_GSE_km_sec,Vy_H1_HIA_GSE_km_sec,Vz_H1_HIA_GSE_km_sec,*V_H1_HIA_km_sec				Vx,Vy,Vz,|V|  	header',		$
		'cl,ws	Vx_H1_HIA_GSM_km_sec,Vy_H1_HIA_GSM_km_sec,Vz_H1_HIA_GSM_km_sec,*V_H1_HIA_km_sec				Vx,Vy,Vz,|V|	header',		$
		'cl,ws	TparH1_HIA_MK												#		header',		$
		'cl,ws	TperH1_HIA_MK												#		header',		$
		'cl,ws	TH1_HIA_MK												#		header',		$
		'cl,ws	NH1_180A_HIA_cm3											#		header',		$
		'cl,ws	Vx_H1_180A_HIA_GSE_km_sec,Vy_H1_180A_HIA_GSE_km_sec,Vz_H1_180A_HIA_GSE_km_sec,*V_H1_180A_HIA_km_sec	Vx,Vy,Vz,|V|  	header',		$
		'cl,ws	Vx_H1_180A_HIA_GSM_km_sec,Vy_H1_180A_HIA_GSM_km_sec,Vz_H1_180A_HIA_GSM_km_sec,*V_H1_180A_HIA_km_sec	Vx,Vy,Vz,|V|  	header',		$
		'cl,ws	TparH1_180A_HIA_MK											#		header',		$
		'cl,ws	TperH1_180A_HIA_MK											#		header',		$
		'cl,ws	TH1_180A_HIA_MK												#		header',		$
		'cl,ws	NH1_180B_HIA_cm3											#		header',		$
		'cl,ws	Vx_H1_180B_HIA_GSE_km_sec,Vy_H1_180B_HIA_GSE_km_sec,Vz_H1_180B_HIA_GSE_km_sec,*V_H1_180B_HIA_km_sec	Vx,Vy,Vz,|V|  	header',		$
		'cl,ws	Vx_H1_180B_HIA_GSM_km_sec,Vy_H1_180B_HIA_GSM_km_sec,Vz_H1_180B_HIA_GSM_km_sec,*V_H1_180B_HIA_km_sec	Vx,Vy,Vz,|V|  	header',		$
		'cl,ws	TparH1_180B_HIA_MK											#		header',		$
		'cl,ws	TperH1_180B_HIA_MK											#		header',		$
		'cl,ws	TH1_180B_HIA_MK												#		header'			]
	ajouter_dataset, arbre, '<dataset id="DOUBLESTAR1:HIA:MOMENTS_HIGHG">4 On board moments high G', 'DSP', 50, 'SC1', tab, 'DSP1_HIA_MOMENTS_HIGHG', 'dsp'

	tab = [	'cl,ws	NH1_HIA_cm3												#  		header yleft_log=Log',	$
		'cl,ws	Vx_H1_HIA_GSE_km_sec,Vy_H1_HIA_GSE_km_sec,Vz_H1_HIA_GSE_km_sec,*V_H1_HIA_km_sec				Vx,Vy,Vz,|V|  	header',		$
		'cl,ws	Vx_H1_HIA_GSM_km_sec,Vy_H1_HIA_GSM_km_sec,Vz_H1_HIA_GSM_km_sec,*V_H1_HIA_km_sec				Vx,Vy,Vz,|V|	header',		$
		'cl,ws	TparH1_HIA_MK												#		header',		$
		'cl,ws	TperH1_HIA_MK												#		header',		$
		'cl,ws	TH1_HIA_MK												#		header',		$
		'cl,ws	NHe2_HIA_cm3												#  		header yleft_log=Log',	$
		'cl,ws	Vx_He2_HIA_GSE_km_sec,Vy_He2_HIA_GSE_km_sec,Vz_He2_HIA_GSE_km_sec,*V_He2_HIA_km_sec			Vx,Vy,Vz,|V|  	header',		$
		'cl,ws	Vx_He2_HIA_GSM_km_sec,Vy_He2_HIA_GSM_km_sec,Vz_He2_HIA_GSM_km_sec,*V_He2_HIA_km_sec			Vx,Vy,Vz,|V|	header',		$
		'cl,ws	TparHe2_HIA_MK												#		header',		$
		'cl,ws	TperHe2_HIA_MK												#		header',		$
		'cl,ws	THe2_HIA_MK												#		header'			]
	ajouter_dataset, arbre, '<dataset id="DOUBLESTAR1:HIA:MOMENTS_LOWG">4 On board moments low g', 'DSP', 51, 'SC1', tab, 'DSP1_HIA_MOMENTS_LOWG', 'dsp'

	tab = [	'cl,ws	N_cm3												#  			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No yleft_log=1',	$
		'cl,ws	Vx_gse_km_sec,Vy_gse_km_sec,Vz_gse_km_sec,*V_km_sec						Vx,Vy,Vz,|V|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Vx_gsm_km_sec,Vy_gsm_km_sec,Vz_gsm_km_sec,*V_km_sec						Vx,Vy,Vz,|V|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Ppar_eV_cm3											#			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Pper1_eV_cm3											#			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Pper2_eV_cm3											#			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Qx_gse_erg_sec_cm2,Qy_gse_erg_sec_cm2,Qz_gse_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Qx_gsm_erg_sec_cm2,Qy_gsm_erg_sec_cm2,Qz_gsm_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,*Qpar_erg_sec_cm2				Qx,Qy,Qz,|Q|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,*Qper_erg_sec_cm2				Qx,Qy,Qz,|Q|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Pxx_eV_cm3_gse,Pxy_eV_cm3_gse,Pxz_eV_cm3_gse,Pyy_eV_cm3_gse,Pyz_eV_cm3_gse,Pzz_eV_cm3_gse	Pxx,Pxy,Pxz,Pyy,Pyz,Pzz	count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Pxx_eV_cm3_b,Pxy_eV_cm3_b,Pxz_eV_cm3_b,Pyy_eV_cm3_b,Pyz_eV_cm3_b,Pzz_eV_cm3_b			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz	count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Ti_eV												#			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Ex_gse,Ey_gse,Ez_gse										Ex,Ey,Ez		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Ex_gsm,Ey_gsm,Ez_gsm										Ex,Ey,Ez		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Vxpar_gse_km_sec,Vypar_gse_km_sec,Vzpar_gse_km_sec,*Vpar_gse_km_sec				Vx,Vy,Vz,|V|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Vxpar_gsm_km_sec,Vypar_gsm_km_sec,Vzpar_gsm_km_sec,*Vpar_gse_km_sec				Vx,Vy,Vz,|V|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Vxper_gse_km_sec,Vyper_gse_km_sec,Vzper_gse_km_sec,*Vper_gse_km_sec				Vx,Vy,Vz,|V|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Vxper_gsm_km_sec,Vyper_gsm_km_sec,Vzper_gsm_km_sec,*Vper_gse_km_sec				Vx,Vy,Vz,|V|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Elx_gse_mV_m,Ely_gse_mV_m,Elz_gse_mV_m,*El_gse_mV_m						Elx,Ely,Elz,|El|	count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Elx_gsm_mV_m,Ely_gsm_mV_m,Elz_gsm_mV_m,*El_gse_mV_m						Elx,Ely,Elz,|El|	count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Pp_nPa												#			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Pm_nPa												#			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Beta												#			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Vxalfven_gse_km_sec,Vyalfven_gse_km_sec,Vzalfven_gse_km_sec,*Valfven_km_sec			Vx,Vy,Vz,|V|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Vxalfven_gsm_km_sec,Vyalfven_gsm_km_sec,Vzalfven_gsm_km_sec,*Valfven_km_sec			Vx,Vy,Vz,|V|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	An												#			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Ng												#			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Bx_gse_nT,By_gse_nT,Bz_gse_nT									Bx,By,Bz		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Bx_gsm_nT,By_gsm_nT,Bz_gsm_nT									Bx,By,Bz		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No'			]
	ajouter_dataset, arbre, '<dataset id="DOUBLESTAR1:HIA:3DMOMENTS_HIGHG_H1">4 3D moments high G H+', 'DSP', [6,7,15,17,21], 'SC1', tab, 'DSP1_HIA_3DMOMENTS_HIGHG_H1', 'dsp dsp_oth', /moments

	tab = [	'cl,ws	N_cm3												#  			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No yleft_log=1',	$
		'cl,ws	Vx_gse_km_sec,Vy_gse_km_sec,Vz_gse_km_sec,*V_km_sec						Vx,Vy,Vz,|V|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Vx_gsm_km_sec,Vy_gsm_km_sec,Vz_gsm_km_sec,*V_km_sec						Vx,Vy,Vz,|V|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Ppar_eV_cm3											#			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Pper1_eV_cm3											#			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Pper2_eV_cm3											#			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Qx_gse_erg_sec_cm2,Qy_gse_erg_sec_cm2,Qz_gse_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Qx_gsm_erg_sec_cm2,Qy_gsm_erg_sec_cm2,Qz_gsm_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,*Qpar_erg_sec_cm2				Qx,Qy,Qz,|Q|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,*Qper_erg_sec_cm2				Qx,Qy,Qz,|Q|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Pxx_eV_cm3_gse,Pxy_eV_cm3_gse,Pxz_eV_cm3_gse,Pyy_eV_cm3_gse,Pyz_eV_cm3_gse,Pzz_eV_cm3_gse	Pxx,Pxy,Pxz,Pyy,Pyz,Pzz	count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Pxx_eV_cm3_b,Pxy_eV_cm3_b,Pxz_eV_cm3_b,Pyy_eV_cm3_b,Pyz_eV_cm3_b,Pzz_eV_cm3_b			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz	count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Ti_eV												#			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Ex_gse,Ey_gse,Ez_gse										Ex,Ey,Ez		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Ex_gsm,Ey_gsm,Ez_gsm										Ex,Ey,Ez		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Vxpar_gse_km_sec,Vypar_gse_km_sec,Vzpar_gse_km_sec,*Vpar_gse_km_sec				Vx,Vy,Vz,|V|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Vxpar_gsm_km_sec,Vypar_gsm_km_sec,Vzpar_gsm_km_sec,*Vpar_gse_km_sec				Vx,Vy,Vz,|V|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Vxper_gse_km_sec,Vyper_gse_km_sec,Vzper_gse_km_sec,*Vper_gse_km_sec				Vx,Vy,Vz,|V|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Vxper_gsm_km_sec,Vyper_gsm_km_sec,Vzper_gsm_km_sec,*Vper_gse_km_sec				Vx,Vy,Vz,|V|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Elx_gse_mV_m,Ely_gse_mV_m,Elz_gse_mV_m,*El_gse_mV_m						Elx,Ely,Elz,|El|	count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Elx_gsm_mV_m,Ely_gsm_mV_m,Elz_gsm_mV_m,*El_gse_mV_m						Elx,Ely,Elz,|El|	count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Pp_nPa												#			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Pm_nPa												#			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Beta												#			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Vxalfven_gse_km_sec,Vyalfven_gse_km_sec,Vzalfven_gse_km_sec,*Valfven_km_sec			Vx,Vy,Vz,|V|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Vxalfven_gsm_km_sec,Vyalfven_gsm_km_sec,Vzalfven_gsm_km_sec,*Valfven_km_sec			Vx,Vy,Vz,|V|		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	An												#			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Ng												#			count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Bx_gse_nT,By_gse_nT,Bz_gse_nT									Bx,By,Bz		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No',		$
		'cl,ws	Bx_gsm_nT,By_gsm_nT,Bz_gsm_nT									Bx,By,Bz		count2d type=moments emin_=1 emax_=40000 legend_theta=No legend_phi=No'			]
	ajouter_dataset, arbre, '<dataset id="DOUBLESTAR1:HIA:3DMOMENTS_LOWG_H1">4 3D moments low g H+', 'DSP', [8,22], 'SC1', tab, 'DSP1_HIA_3DMOMENTS_LOWG_H1', 'dsp dsp_oth', /moments

	; Spectro pour webservice
	info1 = [								$
		{ noproduit:6,	nomproduit:'HIGHG_P06_3D_088A_31E' 	},	$
		{ noproduit:7,	nomproduit:'HIGHG_P07_3D_042A_31E' 	},	$
		{ noproduit:9,	nomproduit:'HIGHG_P09_1D_001A_62E' 	},	$
		{ noproduit:10,	nomproduit:'HIGHG_P10_2D_016A_31E' 	},	$
		{ noproduit:11,	nomproduit:'HIGHG_P11_2D_016A_31E' 	},	$
		{ noproduit:15,	nomproduit:'HIGHG_P15_3D_088A_16E' 	},	$
		{ noproduit:17,	nomproduit:'HIGHG_P17_3D_088A_62E' 	},	$
		{ noproduit:18,	nomproduit:'HIGHG_P18_1D_001A_31E' 	},	$
		{ noproduit:21,	nomproduit:'HIGHG_P21_3D_128A_31E' 	},	$
		{ noproduit:8,	nomproduit:'LOWG_P08_3D_064A_31E' 	},	$
		{ noproduit:13,	nomproduit:'LOWG_P13_2D_008A_31E' 	},	$
		{ noproduit:14,	nomproduit:'LOWG_P14_2D_008A_31E' 	},	$
		{ noproduit:22,	nomproduit:'LOWG_P22_3D_128A_31E' 	}	]

	FOR i=0L,N_ELEMENTS(info1)-1 DO BEGIN
		tab = [	'ws	1d_data 		# count3d type=time_energy cjf=c/s  yleft_auto=Manual yleft_min=10 yleft_max=40000 z_showdir=No z_theta=No z_phi=No',	$
			'ws	1d_data 		# count3d type=time_energy cjf=flux yleft_auto=Manual yleft_min=10 yleft_max=40000 z_showdir=No z_theta=No z_phi=No',	$
			'ws	1d_data 		# count3d type=time_energy cjf=JE   yleft_auto=Manual yleft_min=10 yleft_max=40000 z_showdir=No z_theta=No z_phi=No']
		ajouter_dataset, arbre, '<dataset id="DOUBLESTAR1:HIA:'+info1[i].nomproduit+'_SPECTRO_TIME_ENERGY" visibility="ws">5 '+info1[i].nomproduit+' Spectrogram Time Energy', 'DSP', info1[i].noproduit, 'SC1', tab, 'DSP1_HIA_'+info1[i].nomproduit+'_SPECTRO_TIME_ENERGY', 'dsp', /spectro
	END

	arbre = [ arbre, 															$
		'</instrument>', 														$
		'</mission>' 															$
	]

	info_bulle_HIA = get_cldataset_starttime_endtime('DSP',[[6,7,8,9,10,11,13,14,15,17,18,21,22]],'SC1')

	arbre = [ arbre, $
		'4 Particle spectrogram ' + info_bulle_HIA,													$
		'5 high G H+',													$
			'0 Time Energy JE#          	DSP P6,P7,P9,P10,P11,P15,P17,P18,P21 SC1 JE count3d type=time_energy cjf=JE yleft_auto=Manual yleft_min=10 yleft_max=40000 z_showdir=No z_theta=No z_phi=No',		$
			'0 Time Theta JE#           	DSP P6,P7,P9,P10,P11,P15,P17,P18,P21 SC1 JE count3d type=time_theta cjf=JE emin_nochamp=10 emax_nochamp=40000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',		$
			'0 Time Phi JE#             	DSP P6,P7,P9,P10,P11,P15,P17,P18,P21 SC1 JE count3d type=time_phi cjf=JE emin_nochamp=10 emax_nochamp=40000 yleft_auto=Manual yleft_min=-180 yleft_max=180 z_showdir=No z_theta=No z_phi=No',		$
			'0 Time Pitchangle JE#      	DSP P6,P7,P15,P17,P21                SC1 JE count3d type=time_pitchangle cjf=JE emin_nochamp=10 emax_nochamp=40000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
			'0 Energy Pitchangle JE#	DSP P6,P7,P15,P17,P21                SC1 JE count3d type=energy_pitchangle cjf=JE z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',									$
			'0 Phi Theta JE#            	DSP P6,P7,P15,P17,P21                SC1 JE count3d type=phi_theta cjf=JE emin_nochamp=10 emax_nochamp=40000 yleft_auto=Automatic x_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
			'0 Distribution Function JE#	DSP P6,P7,P15,P17,P21                SC1 JE count3d type=Distribution'+STRING(2b)+'Function log0use=Yes cjf=JE interp_nochamp=TRIGRID yleft_auto=Automatic x_auto=Automatic z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',	$
		'5 low g H+',													$
			'0 Time Energy JE#          	DSP P8,P13,P14,P22 SC1 JE count3d type=time_energy cjf=JE yleft_auto=Manual yleft_min=10 yleft_max=40000 z_showdir=No z_theta=No z_phi=No',		$
			'0 Time Theta JE#           	DSP P8,P13,P14,P22 SC1 JE count3d type=time_theta cjf=JE emin_nochamp=10 emax_nochamp=40000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',		$
			'0 Time Phi JE#             	DSP P8,P13,P14,P22 SC1 JE count3d type=time_phi cjf=JE emin_nochamp=10 emax_nochamp=40000 yleft_auto=Manual yleft_min=-180 yleft_max=180 z_showdir=No z_theta=No z_phi=No',		$
			'0 Time Pitchangle JE#      	DSP P8,P22         SC1 JE count3d type=time_pitchangle cjf=JE emin_nochamp=10 emax_nochamp=40000 yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
			'0 Energy Pitchangle JE#	DSP P8,P22         SC1 JE count3d type=energy_pitchangle cjf=JE z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',									$
			'0 Phi Theta JE#            	DSP P8,P22         SC1 JE count3d type=phi_theta cjf=JE emin_nochamp=10 emax_nochamp=40000 yleft_auto=Automatic x_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
			'0 Distribution Function JE#	DSP P8,P22         SC1 JE count3d type=Distribution'+STRING(2b)+'Function log0use=Yes cjf=JE interp_nochamp=TRIGRID yleft_auto=Automatic x_auto=Automatic z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',	$
		'4 Particle plot ' + info_bulle_HIA,													$
		'5 high G H+',													$
			'0 Time JE#			DSP P6,P7,P9,P10,P11,P15,P17,P18,P21 SC1 JE  count2d type=time_cjf   cjf=JE emin_nochamp=10 emax_nochamp=40000 legend_theta=No legend_phi=No',	$
			'0 Energy JE#			DSP P6,P7,P15,P17,P21                SC1 JE  count2d type=energy_cjf cjf=JE emin_nochamp=10 emax_nochamp=40000 legend_theta=No legend_phi=No',	$
			'0 Pitchangle c/s#		DSP P6,P7,P15,P17,P21                SC1 c/s count2d type=pitch_cjf  cjf=c/s legend_theta=No legend_phi=No',	$
		'5 low g H+',													$
			'0 Time JE#			DSP P8,P13,P14,P22 SC1 JE  count2d type=time_cjf   cjf=JE emin_nochamp=10 emax_nochamp=40000 legend_theta=No legend_phi=No',	$
			'0 Energy JE#			DSP P8,P22         SC1 JE  count2d type=energy_cjf cjf=JE emin_nochamp=10 emax_nochamp=40000 legend_theta=No legend_phi=No',	$
			'0 Pitchangle c/s#		DSP P8,P22         SC1 c/s count2d type=pitch_cjf  cjf=c/s legend_theta=No legend_phi=No'	$
	]

	arbre = [ arbre, 												$
		'3 Housekeeping ' + get_cldataset_starttime_endtime('DSP',53,'SC1'),											$
			'0 cds_time_pfield#    		DSP P53 SC1 cds_pfield header yleft_typetitle=Wording',		$
			'0 cds_time_day#    		DSP P53 SC1 cds_day    header yleft_typetitle=Wording',		$
			'0 cds_time_milli#    		DSP P53 SC1 cds_milli  header yleft_typetitle=Wording',		$

			'0 Frame counter#    		DSP P53 SC1 frame      header yleft_typetitle=Wording',		$
			'0 Telemtry rate#    		DSP P53 SC1 sc_mode    header yleft_typetitle=Wording',		$
			'0 DSP mode#    		DSP P53 SC1 cis_mode   header yleft_typetitle=Wording',		$
			'0 Analyser amplifier status# 	DSP P53 SC1 ht         header yleft_typetitle=Wording',		$
			'0 Analyser HV status# 		DSP P53 SC1 ha         header yleft_typetitle=Wording',		$
			'0 MCP HV status# 		DSP P53 SC1 hm         header yleft_typetitle=Wording',		$
			'0 Cover status# 		DSP P53 SC1 hc         header yleft_typetitle=Wording',		$

			'0 Total Current# 		DSP P53 SC1 ECL2ITOT   header yleft_typetitle=Wording',		$
			'0 Maximum step HV# 		DSP P53 SC1 ECHHVANL   header yleft_typetitle=Wording',		$
			'0 MCP high voltage actual# 	DSP P53 SC1 ECHHVMO    header yleft_typetitle=Wording',		$
			'0 MCP high voltage control# 	DSP P53 SC1 ECHHVMI    header yleft_typetitle=Wording',		$
			'0 +5 V monitor# 		DSP P53 SC1 ECL2VP5    header yleft_typetitle=Wording',		$
			'0 +12 V monitor# 		DSP P53 SC1 ECL2VP12   header yleft_typetitle=Wording',		$
			'0 -12 V monitor# 		DSP P53 SC1 ECL2VN12   header yleft_typetitle=Wording',		$
			'0 Step HV on 28V primary# 	DSP P53 SC1 ECHHIANL   header yleft_typetitle=Wording',		$
			'0 MCP HV on 28V primary# 	DSP P53 SC1 ECHHIMCP   header yleft_typetitle=Wording',		$
			'0 Electronic temperature# 	DSP P53 SC1 ECHTELEC   header yleft_typetitle=Wording',		$
			'0 Cover status in Volt# 	DSP P53 SC1 ECHACOVR   header yleft_typetitle=Wording',		$
			'0 Step HV diode current# 	DSP P53 SC1 ECHHID     header yleft_typetitle=Wording',		$
			'0 Discri level 1# 		DSP P53 SC1 ECHADIS1   header yleft_typetitle=Wording',		$
			'0 Discri level 2# 		DSP P53 SC1 ECHADIS2   header yleft_typetitle=Wording'		$

	]


	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_xmm
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL XMM.
;-------------------------------------------------------------------------------
;
; XMM n'est pas dans spase !
;

	create_products, 'XMM'

	target  = "Earth" ; E. Penou
	targets = "Earth" ; E. Penou

	arbre = [	$
		'<mission name="XMM" id="XMM" target="'+target+'" targets="'+targets+'">2 XMM',	$
		'<instrument name="ephemeris" id="XMM:ephemeris">3 ephemeris']

	tab = [	'cl	Xgeo_km,Ygeo_km,Zgeo_km	x,y,z		orbito',	$
		'cl,ws	Xgeo_km,Ygeo_km,Zgeo_km x,y,z		header',	$
		'cl,ws	Position_Quality 	#		header',	$
		'cl,ws	B_Calc_nT 		#		header',	$
		'cl,ws	B_eq_nT 		#		header',	$
		'cl,ws	L_RE 			#		header',	$
		'cl,ws	L_star_RE 		#		header',	$
		'cl,ws	I 			#		header',	$
		'cl,ws	MLT_h 			#		header',	$
		'cl,ws	Alpha_degrees 		#		header',	$
		'cl,ws	Alpha_Eq_degrees 	#		header'		]
	ajouter_dataset, arbre, '<dataset id="XMM:EPHEMERIS:ORBIT">4 orbit', 'XMM', 0, 'SC1', tab, 'XMM_EPHEMERIS_ORBIT', 'xmm'

	arbre = [ arbre, 													$
		'3 ERMD ' + get_cldataset_starttime_endtime('XMM',[0,1,2,3],'SC1'),																		$
		'4 Particle spectrogram',																$
		'5 Proton',																		$
			'0 Time Energy Omnidirectional Differential Flux#          XMM P1 SC1 flux count3d type=time_energy cjf=flux yleft_auto=Manual yleft_min=1 yleft_max=100 z_showdir=No z_theta=No z_phi=No',		$
		'5 Electron',																		$
			'0 Time Energy Omnidirectional Differential Flux#          XMM P2 SC1 flux count3d type=time_energy cjf=flux yleft_auto=Manual yleft_min=0.1 yleft_max=10 z_showdir=No z_theta=No z_phi=No',		$
			'0 Time Energy Omnidirectional Integral Flux#          	   XMM P3 SC1 flux count3d type=time_energy cjf=flux yleft_auto=Manual yleft_min=0.1 yleft_max=10 z_showdir=No z_theta=No z_phi=No',		$
		'4 Particle plot',																	$
		'5 Proton',																				$
			'0 Omnidirectional Differential Flux 01.82-02.03MeV#						XMM P0 SC1 FPDO_01_82MeV_02_03MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 02.03-02.30MeV#						XMM P0 SC1 FPDO_02_03MeV_02_30MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 02.25-03.45MeV#						XMM P0 SC1 FPDO_02_25MeV_03_45MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 10.50-13.11MeV#						XMM P0 SC1 FPDO_10_50MeV_13_11MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 15.72-19.09MeV#						XMM P0 SC1 FPDO_15_72MeV_19_09MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 18.95-25.05MeV#						XMM P0 SC1 FPDO_18_95MeV_25_05MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 25.23-28.78MeV#						XMM P0 SC1 FPDO_25_23MeV_28_78MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 28.70-33.10MeV#						XMM P0 SC1 FPDO_28_70MeV_33_10MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 33.00-40.01MeV#						XMM P0 SC1 FPDO_33_00MeV_40_01MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 33.50-40.50MeV#						XMM P0 SC1 FPDO_33_50MeV_40_50MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 39.94-49.27MeV#						XMM P0 SC1 FPDO_39_94MeV_49_27MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Quality 01.82-02.03MeV#									XMM P0 SC1 FPDO_Quality_01_82MeV_02_03MeV header',	$
			'0 Quality 02.03_02.30MeV#									XMM P0 SC1 FPDO_Quality_02_03MeV_02_30MeV header',	$
			'0 Quality 02.25-03.45MeV#									XMM P0 SC1 FPDO_Quality_02_25MeV_03_45MeV header',	$
			'0 Quality 10.50-13.11MeV#									XMM P0 SC1 FPDO_Quality_10_50MeV_13_11MeV header',	$
			'0 Quality 15.72-19.09MeV#									XMM P0 SC1 FPDO_Quality_15_72MeV_19_09MeV header',	$
			'0 Quality 18.95-25.05MeV#									XMM P0 SC1 FPDO_Quality_18_95MeV_25_05MeV header',	$
			'0 Quality 25.23-28.78MeV#									XMM P0 SC1 FPDO_Quality_25_23MeV_28_78MeV header',	$
			'0 Quality 28.70-33.10MeV#									XMM P0 SC1 FPDO_Quality_28_70MeV_33_10MeV header',	$
			'0 Quality 33.00-40.01MeV#									XMM P0 SC1 FPDO_Quality_33_00MeV_40_01MeV header',	$
			'0 Quality 33.50-40.50MeV#									XMM P0 SC1 FPDO_Quality_33_50MeV_40_50MeV header',	$
			'0 Quality 39.94-49.27MeV#									XMM P0 SC1 FPDO_Quality_39_94MeV_49_27MeV header',	$
			'0 Omnidirectional Integral Flux 4.5MeV#							XMM P0 SC1 FPIO_4_5MeV_cm_2_s_1_sr_1 header',		$
			'0 Quality 4.5MeV#										XMM P0 SC1 FPIO_Quality_4_5MeV header',			$
		'5 Electron',																				$
			'0 Omnidirectional Differential Flux 0.13-0.20MeV#						XMM P0 SC1 FEDO_0_13MeV_0_20MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 0.19-0.26MeV#						XMM P0 SC1 FEDO_0_19MeV_0_26MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 0.26-0.32MeV#						XMM P0 SC1 FEDO_0_26MeV_0_32MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 0.32-0.38MeV#						XMM P0 SC1 FEDO_0_32MeV_0_38MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 0.38-0.45MeV#						XMM P0 SC1 FEDO_0_38MeV_0_45MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 0.45-0.51MeV#						XMM P0 SC1 FEDO_0_45MeV_0_51MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 0.51-0.57MeV#						XMM P0 SC1 FEDO_0_51MeV_0_57MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 0.57-0.64MeV#						XMM P0 SC1 FEDO_0_57MeV_0_64MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 0.64-0.76MeV#						XMM P0 SC1 FEDO_0_64MeV_0_76MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 0.76-0.89MeV#						XMM P0 SC1 FEDO_0_76MeV_0_89MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 0.78-1.02MeV#						XMM P0 SC1 FEDO_0_78MeV_1_02MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 0.83-1.07MeV#						XMM P0 SC1 FEDO_0_83MeV_1_07MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 0.89-1.08MeV#						XMM P0 SC1 FEDO_0_89MeV_1_08MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 0.95-1.19MeV#						XMM P0 SC1 FEDO_0_95MeV_1_19MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 1.07-1.33MeV#						XMM P0 SC1 FEDO_1_07MeV_1_33MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 1.12-1.36MeV#						XMM P0 SC1 FEDO_1_12MeV_1_36MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 1.29-1.53MeV#						XMM P0 SC1 FEDO_1_29MeV_1_53MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 1.46-1.70MeV#						XMM P0 SC1 FEDO_1_46MeV_1_70MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Omnidirectional Differential Flux 1.63-1.87MeV#						XMM P0 SC1 FEDO_1_63MeV_1_87MeV_cm_2_s_1_sr_1_MeV_1 header',	$
			'0 Quality 0.13-0.20MeV#									XMM P0 SC1 FEDO_Quality_0_13MeV_0_20MeV header',	$
			'0 Quality 0.19-0.26MeV#									XMM P0 SC1 FEDO_Quality_0_19MeV_0_26MeV header',	$
			'0 Quality 0.26-0.32MeV#									XMM P0 SC1 FEDO_Quality_0_26MeV_0_32MeV header',	$
			'0 Quality 0.32-0.38MeV#									XMM P0 SC1 FEDO_Quality_0_32MeV_0_38MeV header',	$
			'0 Quality 0.38-0.45MeV#									XMM P0 SC1 FEDO_Quality_0_38MeV_0_45MeV header',	$
			'0 Quality 0.45-0.51MeV#									XMM P0 SC1 FEDO_Quality_0_45MeV_0_51MeV header',	$
			'0 Quality 0.51-0.57MeV#									XMM P0 SC1 FEDO_Quality_0_51MeV_0_57MeV header',	$
			'0 Quality 0.57-0.64MeV#									XMM P0 SC1 FEDO_Quality_0_57MeV_0_64MeV header',	$
			'0 Quality 0.64-0.76MeV#									XMM P0 SC1 FEDO_Quality_0_64MeV_0_76MeV header',	$
			'0 Quality 0.76-0.89MeV#									XMM P0 SC1 FEDO_Quality_0_76MeV_0_89MeV header',	$
			'0 Quality 0.78-1.02MeV#									XMM P0 SC1 FEDO_Quality_0_78MeV_1_02MeV header',	$
			'0 Quality 0.83-1.07MeV#									XMM P0 SC1 FEDO_Quality_0_83MeV_1_07MeV header',	$
			'0 Quality 0.89-1.08MeV#									XMM P0 SC1 FEDO_Quality_0_89MeV_1_08MeV header',	$
			'0 Quality 0.95-1.19MeV#									XMM P0 SC1 FEDO_Quality_0_95MeV_1_19MeV header',	$
			'0 Quality 1.07-1.33MeV#									XMM P0 SC1 FEDO_Quality_1_07MeV_1_33MeV header',	$
			'0 Quality 1.12-1.36MeV#									XMM P0 SC1 FEDO_Quality_1_12MeV_1_36MeV header',	$
			'0 Quality 1.29-1.53MeV#									XMM P0 SC1 FEDO_Quality_1_29MeV_1_53MeV header',	$
			'0 Quality 1.46-1.70MeV#									XMM P0 SC1 FEDO_Quality_1_46MeV_1_70MeV header',	$
			'0 Quality 1.63-1.87MeV#									XMM P0 SC1 FEDO_Quality_1_63MeV_1_87MeV header',	$
			'0 Omnidirectional Integral Flux 0.94MeV#							XMM P0 SC1 FEIO_0_94_MeV_cm_2_s_1_sr_1 header',		$
			'0 Omnidirectional Integral Flux 1.02MeV#							XMM P0 SC1 FEIO_1_02_MeV_cm_2_s_1_sr_1 header',		$
			'0 Omnidirectional Integral Flux 1.14MeV#							XMM P0 SC1 FEIO_1_14_MeV_cm_2_s_1_sr_1 header',		$
			'0 Omnidirectional Integral Flux 1.30MeV#							XMM P0 SC1 FEIO_1_30_MeV_cm_2_s_1_sr_1 header',		$
			'0 Omnidirectional Integral Flux 1.38MeV#							XMM P0 SC1 FEIO_1_38_MeV_cm_2_s_1_sr_1 header',		$
			'0 Omnidirectional Integral Flux 1.44MeV#							XMM P0 SC1 FEIO_1_44_MeV_cm_2_s_1_sr_1 header',		$
			'0 Omnidirectional Integral Flux 1.62MeV#							XMM P0 SC1 FEIO_1.62_MeV_cm_2_s_1_sr_1 header',		$
			'0 Omnidirectional Integral Flux 1.82MeV#							XMM P0 SC1 FEIO_1_82_MeV_cm_2_s_1_sr_1 header',		$
			'0 Omnidirectional Integral Flux 2.02MeV#							XMM P0 SC1 FEIO_2_02_MeV_cm_2_s_1_sr_1 header',		$
			'0 Omnidirectional Integral Flux 2.54MeV#							XMM P0 SC1 FEIO_2_54_MeV_cm_2_s_1_sr_1 header',		$
			'0 Quality 0.94MeV#										XMM P0 SC1 FEIO_Quality_0_94_MeV header',	$
			'0 Quality 1.02MeV#										XMM P0 SC1 FEIO_Quality_1_02_MeV header',	$
			'0 Quality 1.14MeV#										XMM P0 SC1 FEIO_Quality_1_14_MeV header',	$
			'0 Quality 1.30MeV#										XMM P0 SC1 FEIO_Quality_1_30_MeV header',	$
			'0 Quality 1.38MeV#										XMM P0 SC1 FEIO_Quality_1_38_MeV header',	$
			'0 Quality 1.44MeV#										XMM P0 SC1 FEIO_Quality_1_44_MeV header',	$
			'0 Quality 1.62MeV#										XMM P0 SC1 FEIO_Quality_1_62_MeV header',	$
			'0 Quality 1.82MeV#										XMM P0 SC1 FEIO_Quality_1_82_MeV header',	$
			'0 Quality 2.02MeV#										XMM P0 SC1 FEIO_Quality_2_02_MeV header',	$
			'0 Quality 2.54MeV#										XMM P0 SC1 FEIO_Quality_2_54_MeV header'	$
	]

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'</mission>' 																$
	]

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_sacc
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL SACC.
;-------------------------------------------------------------------------------
;
; SACC n'est pas dans spase !
;

	create_products, 'SACC'

	target  = "Earth" ; E. Penou
	targets = "Earth" ; E. Penou

	arbre = [	$
		'<mission name="SACC" id="SACC" target="'+target+'" targets="'+targets+'"">2 SACC',	$
		'<instrument name="ephemeris" id="SACC:ephemeris">3 ephemeris']

	tab = [	'cl	Xgeo_km,Ygeo_km,Zgeo_km	x,y,z		orbito',	$
		'cl,ws	Xgeo_km,Ygeo_km,Zgeo_km x,y,z		header',	$
		'cl,ws	Position_Quality 	#		header',	$
		'cl,ws	B_Calc_nT 		#		header',	$
		'cl,ws	B_eq_nT 		#		header',	$
		'cl,ws	L_RE 			#		header',	$
		'cl,ws	L_star_RE 		#		header',	$
		'cl,ws	I 			#		header',	$
		'cl,ws	MLT_h 			#		header',	$
		'cl,ws	Alpha_degrees 		#		header',	$
		'cl,ws	Alpha_Eq_degrees 	#		header'		]
	ajouter_dataset, arbre, '<dataset id="SACC:EPHEMERIS:ORBIT">4 orbit', 'SACC', 0, 'SC1', tab, 'SACC_EPHEMERIS_ORBIT', 'sacc'

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'<instrument name="ICARE" id="SACC:ICARE">3 ICARE'												]

	; Spectro ICARE PROTON uniquement pour webservice
	action_proton = 'count3d type=time_energy cjf=flux yleft_auto=Manual yleft_min=10 yleft_max=100 z_showdir=No z_theta=No z_phi=No'
	nom1 = 'PROTON_SPECTRO_TIME_ENERGY'
	nom2 = 'PROTON Spectrogram Time Energy'
	nom3 = 'SACC_ICARE_PROTON_SPECTRO_TIME_ENERGY'
	visibility = "ws"
	tab = [	visibility +' 1d_data 		# ' + action_proton ]
	ajouter_dataset, arbre, '<dataset id="SACC:ICARE:'+nom1+'" visibility="'+visibility+'">4 '+nom2, 'SACC', 1, 'SC1', tab, nom3, 'sacc', /spectro

	; Spectro ICARE ELECTRON uniquement pour webservice
	action_electron = 'count3d type=time_energy cjf=flux yleft_auto=Manual yleft_min=0.1 yleft_max=10 z_showdir=No z_theta=No z_phi=No'
	nom1 = 'ELECTRON_SPECTRO_TIME_ENERGY'
	nom2 = 'ELECTRON Spectrogram Time Energy'
	nom3 = 'SACC_ICARE_ELECTRON_SPECTRO_TIME_ENERGY'
	visibility = "ws"
	tab = [	visibility +' 1d_data 		# ' + action_electron ]
	ajouter_dataset, arbre, '<dataset id="SACC:ICARE:'+nom1+'" visibility="'+visibility+'">4 '+nom2, 'SACC', 2, 'SC1', tab, nom3, 'sacc', /spectro

	arbre = [ arbre, 																$
		'4 Proton Particle spectrogram ' + get_cldataset_starttime_endtime('SACC',[1],'SC1'),																										$
			'0 Time Energy Omnidirectional Differential Flux#          	SACC P1 SC1 flux ' + action_proton,		$
		'4 Electron Particle spectrogram ' + get_cldataset_starttime_endtime('SACC',[2],'SC1'),																										$
			'0 Time Energy Omnidirectional Differential Flux#          	SACC P2 SC1 flux ' + action_electron		$
	]

	tab = [	'cl,ws	FPDO_09_65MeV_11_35MeV_cm_2_s_1_sr_1_MeV_1	#		header',	$
		'cl,ws	FPDO_12_50MeV_18_50MeV_cm_2_s_1_sr_1_MeV_1	#		header',	$
		'cl,ws	FPDO_18_75MeV_27_25MeV_cm_2_s_1_sr_1_MeV_1 	#		header',	$
		'cl,ws	FPDO_27_00MeV_40_00MeV_cm_2_s_1_sr_1_MeV_1 	#		header',	$
		'cl,ws	FPDO_Quality_09_65MeV_11_35MeV 			#		header',	$
		'cl,ws	FPDO_Quality_12_50MeV_18_50MeV 			#		header',	$
		'cl,ws	FPDO_Quality_18_75MeV_27_25MeV 			#		header',	$
		'cl,ws	FPDO_Quality_27_00MeV_40_00MeV 			#		header'		]
	ajouter_dataset, arbre, '<dataset id="SACC:ICARE:PROTON">4 Proton Particle plot', 'SACC', 0, 'SC1', tab, 'SACC_ICARE_PROTON', 'sacc'

	tab = [	'cl,ws	FEDO_0_19MeV_0_25MeV_cm_2_s_1_sr_1_MeV_1	#		header',	$
		'cl,ws	FEDO_0_23MeV_0_29MeV_cm_2_s_1_sr_1_MeV_1	#		header',	$
		'cl,ws	FEDO_0_29MeV_0_35MeV_cm_2_s_1_sr_1_MeV_1 	#		header',	$
		'cl,ws	FEDO_0_33MeV_0_39MeV_cm_2_s_1_sr_1_MeV_1 	#		header',	$
		'cl,ws	FEDO_0_39MeV_0_45MeV_cm_2_s_1_sr_1_MeV_1 	#		header',	$
		'cl,ws	FEDO_0_45MeV_0_51MeV_cm_2_s_1_sr_1_MeV_1 	#		header',	$
		'cl,ws	FEDO_0_53MeV_0_59MeV_cm_2_s_1_sr_1_MeV_1 	#		header',	$
		'cl,ws	FEDO_0_59MeV_0_65MeV_cm_2_s_1_sr_1_MeV_1 	#		header',	$
		'cl,ws	FEDO_0_64MeV_0_76MeV_cm_2_s_1_sr_1_MeV_1 	#		header',	$
		'cl,ws	FEDO_0_76MeV_0_88MeV_cm_2_s_1_sr_1_MeV_1 	#		header',	$
		'cl,ws	FEDO_1_08MeV_1_36MeV_cm_2_s_1_sr_1_MeV_1 	#		header',	$
		'cl,ws	FEDO_1_24MeV_1_60MeV_cm_2_s_1_sr_1_MeV_1 	#		header',	$
		'cl,ws	FEDO_1_28MeV_1_72MeV_cm_2_s_1_sr_1_MeV_1 	#		header',	$
		'cl,ws	FEDO_1_72MeV_2_20MeV_cm_2_s_1_sr_1_MeV_1 	#		header',	$
		'cl,ws	FEDO_2_19MeV_2_67MeV_cm_2_s_1_sr_1_MeV_1 	#		header',	$
		'cl,ws	FEDO_2_67MeV_3_15MeV_cm_2_s_1_sr_1_MeV_1 	#		header',	$
		'cl,ws	FEDO_3_15MeV_3_63MeV_cm_2_s_1_sr_1_MeV_1 	#		header',	$
		'cl,ws	FEDO_3_63MeV_4_11MeV_cm_2_s_1_sr_1_MeV_1 	#		header',	$
		'cl,ws	FEDO_Quality_0_19MeV_0_25MeV 			#		header',	$
		'cl,ws	FEDO_Quality_0_23MeV_0_29MeV 			#		header',	$
		'cl,ws	FEDO_Quality_0_29MeV_0_35MeV 			#		header',	$
		'cl,ws	FEDO_Quality_0_33MeV_0_39MeV 			#		header',	$
		'cl,ws	FEDO_Quality_0_39MeV_0_45MeV 			#		header',	$
		'cl,ws	FEDO_Quality_0_45MeV_0_51MeV 			#		header',	$
		'cl,ws	FEDO_Quality_0_53MeV_0_59MeV 			#		header',	$
		'cl,ws	FEDO_Quality_0_59MeV_0_65MeV 			#		header',	$
		'cl,ws	FEDO_Quality_0_64MeV_0_76MeV 			#		header',	$
		'cl,ws	FEDO_Quality_0_76MeV_0_88MeV 			#		header',	$
		'cl,ws	FEDO_Quality_1_08MeV_1_36MeV 			#		header',	$
		'cl,ws	FEDO_Quality_1_24MeV_1_60MeV 			#		header',	$
		'cl,ws	FEDO_Quality_1_28MeV_1_72MeV 			#		header',	$
		'cl,ws	FEDO_Quality_1_72MeV_2_20MeV 			#		header',	$
		'cl,ws	FEDO_Quality_2_19MeV_2_67MeV 			#		header',	$
		'cl,ws	FEDO_Quality_2_67MeV_3_15MeV 			#		header',	$
		'cl,ws	FEDO_Quality_3_15MeV_3_63MeV 			#		header',	$
		'cl,ws	FEDO_Quality_3_63MeV_4_11MeV 			#		header',	$
		'cl,ws	FEIO_0_90MeV_cm_2_s_1_sr_1 			#		header',	$
		'cl,ws	FEIO_Quality_0_90MeV_cm_2_s_1_sr_1 		#		header'		]
	ajouter_dataset, arbre, '<dataset id="SACC:ICARE:ELECTRON">4 Electron Particle plot', 'SACC', 0, 'SC1', tab, 'SACC_ICARE_ELECTRON', 'sacc'

	tab = [	'cl,ws	FADO_39_0MeV_69_0MeV_cm_2_s_1_sr_1_MeV_1	#		header',	$
		'cl,ws	FADO_54_5MeV_75_5MeV_cm_2_s_1_sr_1_MeV_1	#		header',	$
		'cl,ws	FADO_Quality_39_0MeV_69_0MeV 			#		header',	$
		'cl,ws	FADO_Quality_54_5MeV_75_5MeV 			#		header',	$
		'cl,ws	FAIO_100MeV_cm_2_s_1_sr_1 			#		header',	$
		'cl,ws	FAIO_Quality_100MeV 				#		header'		]
	ajouter_dataset, arbre, '<dataset id="SACC:ICARE:ALPHA">4 Alpha Particle plot', 'SACC', 0, 'SC1', tab, 'SACC_ICARE_ALPHA', 'sacc'

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'</mission>' 																$
	]

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_mgs
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL MGS.
;-------------------------------------------------------------------------------
;
; Trouv dans spase://SMWG/Observatory/MGS
;
; <ObservatoryRegion>Heliosphere.Outer</ObservatoryRegion>
;

	target  = "Mars" ; E. Penou
	targets = "Mars" ; E. Penou

	arbre = [													$
		'<mission name="MGS" id="MGS" target="'+target+'" targets="'+targets+'">2 MGS',				$
		'<instrument name="ephemeris" id="MGS:ephemeris">3 ephemeris'						]

	; ephemeris
	tab = [	'cl	X_Rm_MSO,Y_Rm_MSO,Z_Rm_MSO,D_Rm    x,y,z,D  orbito',			$
		'cl,ws	X_Rm_MSO,Y_Rm_MSO,Z_Rm_MSO         x,y,z    header',			$
		'cl,ws	D_Rm                               #        header',			$
		'cl,ws	ALTITUDE_Rm                        #        header',			$
		'cl,ws	ALTITUDE_Km                        #        header',			$
		'cl,ws	LONG_deg                           #        header',			$
		'cl,ws	LAT_deg                            #        header',			$
		'cl,ws	SZA_deg				   # 	    header',			$
		'cl,ws	LT_h				   # 	    header',			$
		'cl,ws	SH				   # 	    header'			]
	ajouter_dataset, arbre, '<dataset id="MGS:EPHEMERIS:ORBIT">4 orbit', 'MGS', 6, 'SC1', tab, 'MGS_EPHEMERIS_ORBIT', 'mgs'


	arbre = [ arbre, 																	$
		'5 orbit from ORBPC ' + get_cldataset_starttime_endtime('MGS',2,'SC1'),										$
			'0 Orbit panel in body-fixed     coord. sys. with X,Y,Z,Dist (km)#	MGS P2 SC1 X_PC_km,Y_PC_km,Z_PC_km,Dist_PC_km orbito',		$
		'5 orbit from ORBSS ' + get_cldataset_starttime_endtime('MGS',3,'SC1'),										$
			'0 Orbit panel in body-Sun-State coord. sys. with X,Y,Z,Dist (km)# 	MGS P3 SC1 X_SS_km,Y_SS_km,Z_SS_km,Dist_SS_km orbito',		$
			'0 Orbit panel in body-Sun-State coord. sys. with X,Y,Z,Dist (Rm)# 	MGS P3 SC1 X_SS_Rm,Y_SS_Rm,Z_SS_Rm,Dist_SS_Rm orbito',		$
		'3 MAG',																	$
		'4 MAGPC (IAU_MARS) ' + get_cldataset_starttime_endtime('MGS',0,'SC1'),											$
			'0 Mag Field, body-fixed coord. sys.     Bx,By,Bz#			MGS P0 SC1 Bx_PC_nT,By_PC_nT,Bz_PC_nT header',			$
			'0 Mag Field magnitude                   |B|#                           MGS P0 SC1 B_nT header',					$
		'4 MAGSS (MSO) ' + get_cldataset_starttime_endtime('MGS',1,'SC1'),											$
			'0 Mag Field, body-Sun-State coord. sys. Bx,By,Bz#			MGS P1 SC1 Bx_SS_nT,By_SS_nT,Bz_SS_nT header',			$
			'0 Mag Field magnitude                   |B|#                           MGS P1 SC1 B_nT header',					$
		'4 MAGOFW (SENSOR) ' + get_cldataset_starttime_endtime('MGS',5,'SC1'),											$
			'0 Mag Field, Sensor coord. sys.       Bx,By,Bz#			MGS P5 SC1 Bx_OFW_nT,By_OFW_nT,Bz_OFW_nT header',		$
			'0 Mag Field magnitude                   |B|#                           MGS P5 SC1 B_nT header',					$
		'3 ER ' + get_cldataset_starttime_endtime('MGS',7,'SC1'),											$
		'4 Particle spectrogram',															$
			'0 Time Energy Flux#		MGS P7 SC1 flux count3d type=time_energy cjf=flux z_showdir=No z_theta=No z_phi=No',			$
			'0 RLONG-RLAT Flux#		MGS P7 SC1 flux count3d type=RLONG_RLAT cjf=flux yleft_log=Linear yleft_auto=Manual yleft_min=-90 yleft_max=90 x_auto=Manual x_min=0 x_max=360 moins180plus180=0&nbsp;360 z_showdir=No z_theta=No z_phi=No',		$
		'4 Particle plot',																$
			'0 Time flux#			MGS P7 SC1 flux count2d type=time_cjf cjf=flux legend_theta=No legend_phi=No',	$
			'0 Energy flux#			MGS P7 SC1 flux count2d type=energy_cjf cjf=flux legend_theta=No legend_phi=No'	$
	]

	; -----------------
	; MARS B CONNECTION
	; -----------------

	tab = [	'cl	X_Km_MSO,Y_Km_MSO,Z_Km_MSO			x,y,z		header',							$
		'cl	Bx_MSO,By_MSO,Bz_MSO				Bx,By,Bz 	header',							$
		'cl	thBX						# 		header',							$
		'cl	thBn						# 		header',							$
		'cl	thVn						# 		header',							$
		'cl	Dist						# 		header',							$
		'cl	nShockX,nShockY,nShockZ				x,y,z 		header',							$
		'cl	AshockX,AshockY,AshockZ				x,y,z 		header',							$
		'cl	DF						# 		header'								]
	ajouter_dataset, arbre, '<dataset id="MGS:EPHEMERIS:MARS_B_CONNECTION">3 Mars B connection 3sec resolution', 'MGS', 8, 'SC1', tab, 'MGS_EPHEMERIS_MARS_B_CONNECTION', 'mgs'

	arbre = [ arbre, 																$
		'</instrument>', 															$
		'</mission>' 																$
	]

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_mms,	$
;-------------------------------------------------------------------------------
	no		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL MMS.
;-------------------------------------------------------------------------------
;
; Trouv dans spase://SMWG/Observatory/MMS
;
; <ObservatoryRegion>Earth.Magnetosphere</ObservatoryRegion>

	COMMON COMMON_CL, general

	create_products, 'MMS'

	target  = "Earth.Magnetosphere"
	targets = "Earth.Magnetosphere"

	p = get(general,'p') ; p[noproduit,nocis,nosat]

	SC = 'SC'+val_to_str(no)
	NAME1 = 'MMS'+val_to_str(no)
	NAME2 = 'MMS'+val_to_str(no)
	NAME3 = 'MMS'+val_to_str(no)
	nosat = no

	arbre = ['<mission name="'+NAME2+'" id="'+NAME2+'" target="'+target+'" targets="'+targets+'">3 '+NAME1]

	; ---------
	; ephemeris
	; ---------

	arbre = [ arbre, '4 ephemeris']
	nomcis = 'MMS-MEC'

	tab_orbit = [	'cl	mec_rx_eci,mec_ry_eci,mec_rz_eci					X,Y,Z 		orbito',			$
			'cl	mec_rx_gsm,mec_ry_gsm,mec_rz_gsm					X,Y,Z 		orbito',			$
			'cl	mec_rx_geo,mec_ry_geo,mec_rz_geo					X,Y,Z 		orbito',			$
			'cl	mec_rx_sm,mec_ry_sm,mec_rz_sm						X,Y,Z 		orbito',			$
			'cl	mec_rx_gse,mec_ry_gse,mec_rz_gse					X,Y,Z 		orbito',			$
			'cl	mec_rx_gse2000,mec_ry_gse2000,mec_rz_gse2000				X,Y,Z 		orbito',			$
			'cl	XGSE,YGSE,ZGSE,*DIST							X,Y,Z,D		orbito',			$
			'cl	XGSM,YGSM,ZGSM,*DIST							X,Y,Z,D		orbito',			$
			'cl	mec_dipole_tilt								# 		header',			$
			'cl	mec_gmst								# 		header',			$
			'cl	mec_mlat								# 		header',			$
			'cl	mec_mlt									# 		header',			$
			'cl	mec_l_dipole								# 		header',			$
			'cl	mec_L_vec_RA								# 		header',			$
			'cl	mec_L_vec_DEC								# 		header',			$
			'cl	mec_Z_vec_RA								# 		header',			$
			'cl	mec_Z_vec_DEC								# 		header',			$
			'cl	mec_P_vec_RA								# 		header',			$
			'cl	mec_P_vec_DEC								# 		header',			$
			'cl	mec_L_phase								# 		header',			$
			'cl	mec_Z_phase								# 		header',			$
			'cl	mec_P_phase								# 		header',			$
			'cl	mec_kp									# 		header',			$
			'cl	mec_dst									# 		header',			$
			'cl	mec_earth_eclipse_flag							# 		header',			$
			'cl	mec_moon_eclipse_flag							# 		header',			$
			'cl	mec_rx_eci,mec_ry_eci,mec_rz_eci					X,Y,Z 		header',			$
			'cl	mec_vx_eci,mec_vy_eci,mec_vz_eci					Vx,Vy,Vz 	header',			$
			'cl	mec_rx_gsm,mec_ry_gsm,mec_rz_gsm					X,Y,Z 		header',			$
			'cl	mec_vx_gsm,mec_vy_gsm,mec_vz_gsm					Vx,Vy,Vz	header',			$
			'cl	mec_rx_geo,mec_ry_geo,mec_rz_geo					X,Y,Z 		header',			$
			'cl	mec_vx_geo,mec_vy_geo,mec_vz_geo					Vx,Vy,Vz	header',			$
			'cl	mec_rx_sm,mec_ry_sm,mec_rz_sm						X,Y,Z 		header',			$
			'cl	mec_vx_sm,mec_vy_sm,mec_vy_sm						Vx,Vy,Vz	header',			$
			'cl	mec_rx_gse,mec_ry_gse,mec_rz_gse					X,Y,Z 		header',			$
			'cl	mec_vx_gse,mec_vy_gse,mec_vz_gse					Vx,Vy,Vz	header',			$
			'cl	mec_rx_gse2000,mec_ry_gse2000,mec_rz_gse2000				X,Y,Z 		header',			$
			'cl	mec_vx_gse2000,mec_vy_gse2000,mec_vz_gse2000				Vx,Vy,Vz	header',			$
			'cl	mec_geod_lat								# 		header',			$
			'cl	mec_geod_lon								# 		header',			$
			'cl	mec_geod_height								# 		header',			$
			'cl	mec_rx_sun_de421_eci,mec_ry_sun_de421_eci,mec_rz_sun_de421_eci		X,Y,Z 		header',			$
			'cl	mec_rx_moon_de421_eci,mec_ry_moon_de421_eci,mec_rz_moon_de421_eci	X,Y,Z 		header',			$
			;'cl	mec_int_model								# 		header',			$
			;'cl	mec_ext_model								# 		header',			$
			'cl	mec_fieldline_type							# 		header',			$
			'cl	mec_bxsc_gsm,mec_bysc_gsm,mec_bzsc_gsm,mec_btsc_gsm			Bx,By,Bz,Bt 	header',			$
			'cl	mec_loss_cone_angle_s							# 		header',			$
			'cl	mec_loss_cone_angle_n							# 		header',			$
			'cl	mec_pfs_geod_lat							# 		header',			$
			'cl	mec_pfs_geod_lon							# 		header',			$
			'cl	mec_pfn_geod_lat							# 		header',			$
			'cl	mec_pfn_geod_lon							# 		header',			$
			'cl	mec_pxfs_gsm,mec_pyfs_gsm,mec_pzfs_gsm					X,Y,Z 		header',			$
			'cl	mec_bxfs_gsm,mec_byfs_gsm,mec_bzfs_gsm					Bx,By,Bz 	header',			$
			'cl	mec_pxfn_gsm,mec_pyfn_gsm,mec_pzfn_gsm					X,Y,Z 		header',			$
			'cl	mec_bxfn_gsm,mec_byfn_gsm,mec_bzfn_gsm					Bx,By,Bz 	header',			$
			'cl	mec_pxmin_gsm,mec_pymin_gsm,mec_pzmin_gsm				X,Y,Z 		header',			$
			'cl	mec_bxmin_gsm,mec_bymin_gsm,mec_bzmin_gsm				Bx,By,Bz 	header',			$
			'cl	XGSE,YGSE,ZGSE								X,Y,Z 		header',			$
			'cl	XGSM,YGSM,ZGSM								X,Y,Z 		header',			$
			'cl	DIST									# 		header'				]

	arbre = [ arbre, '5 orbit' ]
	arbre = [ arbre, '6 mec' ]

	arbre = [ arbre, '7 brst' ]
	arbre = [ arbre, '8 l2' ]

	; orbit epht89d
	noproduit = 3
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':EPHEMERIS:ORBITE_BRST_EPHT89D">9 epht89d res=30ms', nomcis, noproduit, SC, tab_orbit, NAME3+'_EPHEMERIS_ORBITE_BRST_EPHT89D', 'mms_mec'

	; orbit epht89q
	noproduit = 4
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':EPHEMERIS:ORBITE_BRST_EPHT89Q">9 epht89q res=30ms', nomcis, noproduit, SC, tab_orbit, NAME3+'_EPHEMERIS_ORBITE_BRST_EPHT89Q', 'mms_mec'

	; orbit ephts04d
	noproduit = 5
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':EPHEMERIS:ORBITE_BRST_EPHTS04D">9 ephts04d res=30ms', nomcis, noproduit, SC, tab_orbit, NAME3+'_EPHEMERIS_ORBITE_BRST_EPHTS04D', 'mms_mec'

	arbre = [ arbre, '7 srvy' ]
	arbre = [ arbre, '8 l2' ]

	; orbit epht89d
	noproduit = 0
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':EPHEMERIS:ORBITE_SRVY_EPHT89D">9 epht89d res=30s', nomcis, noproduit, SC, tab_orbit, NAME3+'_EPHEMERIS_ORBITE_SRVY_EPHT89D', 'mms_mec'

	; orbit epht89q
	noproduit = 1
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':EPHEMERIS:ORBITE_SRVY_EPHT89Q">9 epht89q res=30s', nomcis, noproduit, SC, tab_orbit, NAME3+'_EPHEMERIS_ORBITE_SRVY_EPHT89Q', 'mms_mec'

	; orbit ephts04d
	noproduit = 2
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':EPHEMERIS:ORBITE_SRVY_EPHTS04D">9 ephts04d res=30s', nomcis, noproduit, SC, tab_orbit, NAME3+'_EPHEMERIS_ORBITE_SRVY_EPHTS04D', 'mms_mec'

	arbre = [ arbre, '6 dfg' ]

	arbre = [ arbre, '7 brst' ]

	; orbit dfg brst l2pre
	noproduit = 17
	tab = [	'cl	pos_gse_x,pos_gse_y,pos_gse_z,pos_gse_r					X,Y,Z,R		orbito',		$
		'cl	pos_gsm_x,pos_gsm_y,pos_gsm_z,pos_gsm_r					X,Y,Z,R		orbito',		$
		'cl	XGSE,YGSE,ZGSE,*DIST							X,Y,Z,D		orbito',		$
		'cl	XGSM,YGSM,ZGSM,*DIST							X,Y,Z,D		orbito',		$
		'cl	pos_gse_x,pos_gse_y,pos_gse_z,pos_gse_r					X,Y,Z,R		header',		$
		'cl	pos_gsm_x,pos_gsm_y,pos_gsm_z,pos_gsm_r					X,Y,Z,R		header'			]
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':EPHEMERIS:ORBITE_DFG_BRST_L2PRE">8 l2pre res=30s', 'MMS-DFG', noproduit, SC, tab, NAME3+'_EPHEMERIS_ORBITE_DFG_BRST_L2PRE', 'mms_dfg'

	arbre = [ arbre, '7 srvy' ]

	; orbit dfg srvy l2pre
	noproduit = 15
	tab = [	'cl	pos_gse_x,pos_gse_y,pos_gse_z,pos_gse_r					X,Y,Z,R		orbito',		$
		'cl	pos_gsm_x,pos_gsm_y,pos_gsm_z,pos_gsm_r					X,Y,Z,R		orbito',		$
		'cl	XGSE,YGSE,ZGSE,*DIST							X,Y,Z,D		orbito',		$
		'cl	XGSM,YGSM,ZGSM,*DIST							X,Y,Z,D		orbito',		$
		'cl	pos_gse_x,pos_gse_y,pos_gse_z,pos_gse_r					X,Y,Z,R		header',		$
		'cl	pos_gsm_x,pos_gsm_y,pos_gsm_z,pos_gsm_r					X,Y,Z,R		header'			]
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':EPHEMERIS:ORBITE_DFG_SRVY_L2PRE">8 l2pre res=30s', 'MMS-DFG', noproduit, SC, tab, NAME3+'_EPHEMERIS_ORBITE_DFG_SRVY_L2PRE', 'mms_dfg'

	arbre = [ arbre, '6 fgm' ]

	arbre = [ arbre, '7 brst' ]

	; orbit fgm brst l2
	noproduit = 1
	tab = [	'cl	fgm_xgse_brst_l2,fgm_ygse_brst_l2,fgm_zgse_brst_l2,fgm_rgse_brst_l2	X,Y,Z,R		orbito',		$
		'cl	fgm_xgsm_brst_l2,fgm_ygsm_brst_l2,fgm_zgsm_brst_l2,fgm_rgsm_brst_l2	X,Y,Z,R		orbito',		$
		'cl	XGSE,YGSE,ZGSE,*DIST							X,Y,Z,D		orbito',		$
		'cl	XGSM,YGSM,ZGSM,*DIST							X,Y,Z,D		orbito',		$
		'cl	fgm_xgse_brst_l2,fgm_ygse_brst_l2,fgm_zgse_brst_l2,fgm_rgse_brst_l2	X,Y,Z,R		header',		$
		'cl	fgm_xgsm_brst_l2,fgm_ygsm_brst_l2,fgm_zgsm_brst_l2,fgm_rgsm_brst_l2	X,Y,Z,R		header'			]
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':EPHEMERIS:ORBITE_FGM_BRST_L2PRE">8 l2 res=30s', 'MMS-FGM', noproduit, SC, tab, NAME3+'_EPHEMERIS_ORBITE_FGM_BRST_L2', 'mms_fgm'

	arbre = [ arbre, '7 srvy' ]

	; orbit fgm srvy l2
	noproduit = 3
	tab = [	'cl	fgm_xgse_srvy_l2,fgm_ygse_srvy_l2,fgm_zgse_srvy_l2,fgm_rgse_srvy_l2	X,Y,Z,R		orbito',		$
		'cl	fgm_xgsm_srvy_l2,fgm_ygsm_srvy_l2,fgm_zgsm_srvy_l2,fgm_rgsm_srvy_l2	X,Y,Z,R		orbito',		$
		'cl	XGSE,YGSE,ZGSE,*DIST							X,Y,Z,D		orbito',		$
		'cl	XGSM,YGSM,ZGSM,*DIST							X,Y,Z,D		orbito',		$
		'cl	fgm_xgse_srvy_l2,fgm_ygse_srvy_l2,fgm_zgse_srvy_l2,fgm_rgse_srvy_l2	X,Y,Z,R		header',		$
		'cl	fgm_xgsm_srvy_l2,fgm_ygsm_srvy_l2,fgm_zgsm_srvy_l2,fgm_rgsm_srvy_l2	X,Y,Z,R		header'			]
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':EPHEMERIS:ORBITE_FGM_SRVY_L2PRE">8 l2 res=30s', 'MMS-FGM', noproduit, SC, tab, NAME3+'_EPHEMERIS_ORBITE_FGM_SRVY_L2', 'mms_fgm'


	arbre = [ arbre, '5 attitude' ]
	arbre = [ arbre, '6 mec' ]

	arbre = [ arbre, '7 brst' ]
	arbre = [ arbre, '8 l2' ]

	; attitude epht89d
	noproduit = 3
	tab = [	'cl	mec_quatx_eci_to_bcs,mec_quaty_eci_to_bcs,mec_quatz_eci_to_bcs,mec_quatw_eci_to_bcs			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_dbcs,mec_quaty_eci_to_dbcs,mec_quatz_eci_to_dbcs,mec_quatw_eci_to_dbcs			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_dmpa,mec_quaty_eci_to_dmpa,mec_quatz_eci_to_dmpa,mec_quatw_eci_to_dmpa			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_smpa,mec_quaty_eci_to_smpa,mec_quatz_eci_to_smpa,mec_quatw_eci_to_smpa			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_dsl,mec_quaty_eci_to_dsl,mec_quatz_eci_to_dsl,mec_quatw_eci_to_dsl			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_ssl,mec_quaty_eci_to_ssl,mec_quatz_eci_to_ssl,mec_quatw_eci_to_ssl			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_gsm,mec_quaty_eci_to_gsm,mec_quatz_eci_to_gsm,mec_quatw_eci_to_gsm			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_geo,mec_quaty_eci_to_geo,mec_quatz_eci_to_geo,mec_quatw_eci_to_geo			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_sm,mec_quaty_eci_to_sm,mec_quatz_eci_to_sm,mec_quatw_eci_to_sm				Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_gse,mec_quaty_eci_to_gse,mec_quatz_eci_to_gse,mec_quatw_eci_to_gse			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_gse2000,mec_quaty_eci_to_gse2000,mec_quatz_eci_to_gse2000,mec_quatw_eci_to_gse2000	Qx,Qy,Qz,Qw	header'			]
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':EPHEMERIS:ATTITUDE_BRST_L2_EPHT89D">9 epht89d res=30s', nomcis, noproduit, SC, tab, NAME3+'_EPHEMERIS_ATTITUDE_BRST_L2_EPHT89D', 'mms_mec'

	; attitude epht89q
	noproduit = 4
	tab = [	'cl	mec_quatx_eci_to_bcs,mec_quaty_eci_to_bcs,mec_quatz_eci_to_bcs,mec_quatw_eci_to_bcs			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_dbcs,mec_quaty_eci_to_dbcs,mec_quatz_eci_to_dbcs,mec_quatw_eci_to_dbcs			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_dmpa,mec_quaty_eci_to_dmpa,mec_quatz_eci_to_dmpa,mec_quatw_eci_to_dmpa			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_smpa,mec_quaty_eci_to_smpa,mec_quatz_eci_to_smpa,mec_quatw_eci_to_smpa			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_dsl,mec_quaty_eci_to_dsl,mec_quatz_eci_to_dsl,mec_quatw_eci_to_dsl			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_ssl,mec_quaty_eci_to_ssl,mec_quatz_eci_to_ssl,mec_quatw_eci_to_ssl			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_gsm,mec_quaty_eci_to_gsm,mec_quatz_eci_to_gsm,mec_quatw_eci_to_gsm			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_geo,mec_quaty_eci_to_geo,mec_quatz_eci_to_geo,mec_quatw_eci_to_geo			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_sm,mec_quaty_eci_to_sm,mec_quatz_eci_to_sm,mec_quatw_eci_to_sm				Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_gse,mec_quaty_eci_to_gse,mec_quatz_eci_to_gse,mec_quatw_eci_to_gse			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_gse2000,mec_quaty_eci_to_gse2000,mec_quatz_eci_to_gse2000,mec_quatw_eci_to_gse2000	Qx,Qy,Qz,Qw	header'			]
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':EPHEMERIS:ATTITUDE_BRST_L2_EPHT89Q">9 epht89q res=30s', nomcis, noproduit, SC, tab, NAME3+'_EPHEMERIS_ATTITUDE_BRST_L2_EPHT89Q', 'mms_mec'

	; attitude ephts04d
	noproduit = 5
	tab = [	'cl	mec_quatx_eci_to_bcs,mec_quaty_eci_to_bcs,mec_quatz_eci_to_bcs,mec_quatw_eci_to_bcs			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_dbcs,mec_quaty_eci_to_dbcs,mec_quatz_eci_to_dbcs,mec_quatw_eci_to_dbcs			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_dmpa,mec_quaty_eci_to_dmpa,mec_quatz_eci_to_dmpa,mec_quatw_eci_to_dmpa			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_smpa,mec_quaty_eci_to_smpa,mec_quatz_eci_to_smpa,mec_quatw_eci_to_smpa			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_dsl,mec_quaty_eci_to_dsl,mec_quatz_eci_to_dsl,mec_quatw_eci_to_dsl			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_ssl,mec_quaty_eci_to_ssl,mec_quatz_eci_to_ssl,mec_quatw_eci_to_ssl			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_gsm,mec_quaty_eci_to_gsm,mec_quatz_eci_to_gsm,mec_quatw_eci_to_gsm			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_geo,mec_quaty_eci_to_geo,mec_quatz_eci_to_geo,mec_quatw_eci_to_geo			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_sm,mec_quaty_eci_to_sm,mec_quatz_eci_to_sm,mec_quatw_eci_to_sm				Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_gse,mec_quaty_eci_to_gse,mec_quatz_eci_to_gse,mec_quatw_eci_to_gse			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_gse2000,mec_quaty_eci_to_gse2000,mec_quatz_eci_to_gse2000,mec_quatw_eci_to_gse2000	Qx,Qy,Qz,Qw	header'			]
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':EPHEMERIS:ATTITUDE_BRST_L2_EPHTS04D">9 ephts04d res=30s', nomcis, noproduit, SC, tab, NAME3+'_EPHEMERIS_ATTITUDE_BRST_L2_EPHTS04D', 'mms_mec'

	arbre = [ arbre, '7 srvy' ]
	arbre = [ arbre, '8 l2' ]

	; attitude epht89d
	noproduit = 0
	tab = [	'cl	mec_quatx_eci_to_bcs,mec_quaty_eci_to_bcs,mec_quatz_eci_to_bcs,mec_quatw_eci_to_bcs			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_dbcs,mec_quaty_eci_to_dbcs,mec_quatz_eci_to_dbcs,mec_quatw_eci_to_dbcs			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_dmpa,mec_quaty_eci_to_dmpa,mec_quatz_eci_to_dmpa,mec_quatw_eci_to_dmpa			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_smpa,mec_quaty_eci_to_smpa,mec_quatz_eci_to_smpa,mec_quatw_eci_to_smpa			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_dsl,mec_quaty_eci_to_dsl,mec_quatz_eci_to_dsl,mec_quatw_eci_to_dsl			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_ssl,mec_quaty_eci_to_ssl,mec_quatz_eci_to_ssl,mec_quatw_eci_to_ssl			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_gsm,mec_quaty_eci_to_gsm,mec_quatz_eci_to_gsm,mec_quatw_eci_to_gsm			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_geo,mec_quaty_eci_to_geo,mec_quatz_eci_to_geo,mec_quatw_eci_to_geo			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_sm,mec_quaty_eci_to_sm,mec_quatz_eci_to_sm,mec_quatw_eci_to_sm				Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_gse,mec_quaty_eci_to_gse,mec_quatz_eci_to_gse,mec_quatw_eci_to_gse			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_gse2000,mec_quaty_eci_to_gse2000,mec_quatz_eci_to_gse2000,mec_quatw_eci_to_gse2000	Qx,Qy,Qz,Qw	header'			]
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':EPHEMERIS:ATTITUDE_SRVY_L2_EPHT89D">9 epht89d res=30s', nomcis, noproduit, SC, tab, NAME3+'_EPHEMERIS_ATTITUDE_SRVY_L2_EPHT89D', 'mms_mec'

	; attitude epht89q
	noproduit = 1
	tab = [	'cl	mec_quatx_eci_to_bcs,mec_quaty_eci_to_bcs,mec_quatz_eci_to_bcs,mec_quatw_eci_to_bcs			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_dbcs,mec_quaty_eci_to_dbcs,mec_quatz_eci_to_dbcs,mec_quatw_eci_to_dbcs			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_dmpa,mec_quaty_eci_to_dmpa,mec_quatz_eci_to_dmpa,mec_quatw_eci_to_dmpa			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_smpa,mec_quaty_eci_to_smpa,mec_quatz_eci_to_smpa,mec_quatw_eci_to_smpa			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_dsl,mec_quaty_eci_to_dsl,mec_quatz_eci_to_dsl,mec_quatw_eci_to_dsl			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_ssl,mec_quaty_eci_to_ssl,mec_quatz_eci_to_ssl,mec_quatw_eci_to_ssl			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_gsm,mec_quaty_eci_to_gsm,mec_quatz_eci_to_gsm,mec_quatw_eci_to_gsm			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_geo,mec_quaty_eci_to_geo,mec_quatz_eci_to_geo,mec_quatw_eci_to_geo			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_sm,mec_quaty_eci_to_sm,mec_quatz_eci_to_sm,mec_quatw_eci_to_sm				Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_gse,mec_quaty_eci_to_gse,mec_quatz_eci_to_gse,mec_quatw_eci_to_gse			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_gse2000,mec_quaty_eci_to_gse2000,mec_quatz_eci_to_gse2000,mec_quatw_eci_to_gse2000	Qx,Qy,Qz,Qw	header'			]
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':EPHEMERIS:ATTITUDE_SRVY_L2_EPHT89Q">9 epht89q res=30s', nomcis, noproduit, SC, tab, NAME3+'_EPHEMERIS_ATTITUDE_SRVY_L2_EPHT89Q', 'mms_mec'

	; attitude ephts04d
	noproduit = 2
	tab = [	'cl	mec_quatx_eci_to_bcs,mec_quaty_eci_to_bcs,mec_quatz_eci_to_bcs,mec_quatw_eci_to_bcs			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_dbcs,mec_quaty_eci_to_dbcs,mec_quatz_eci_to_dbcs,mec_quatw_eci_to_dbcs			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_dmpa,mec_quaty_eci_to_dmpa,mec_quatz_eci_to_dmpa,mec_quatw_eci_to_dmpa			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_smpa,mec_quaty_eci_to_smpa,mec_quatz_eci_to_smpa,mec_quatw_eci_to_smpa			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_dsl,mec_quaty_eci_to_dsl,mec_quatz_eci_to_dsl,mec_quatw_eci_to_dsl			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_ssl,mec_quaty_eci_to_ssl,mec_quatz_eci_to_ssl,mec_quatw_eci_to_ssl			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_gsm,mec_quaty_eci_to_gsm,mec_quatz_eci_to_gsm,mec_quatw_eci_to_gsm			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_geo,mec_quaty_eci_to_geo,mec_quatz_eci_to_geo,mec_quatw_eci_to_geo			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_sm,mec_quaty_eci_to_sm,mec_quatz_eci_to_sm,mec_quatw_eci_to_sm				Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_gse,mec_quaty_eci_to_gse,mec_quatz_eci_to_gse,mec_quatw_eci_to_gse			Qx,Qy,Qz,Qw	header',		$
		'cl	mec_quatx_eci_to_gse2000,mec_quaty_eci_to_gse2000,mec_quatz_eci_to_gse2000,mec_quatw_eci_to_gse2000	Qx,Qy,Qz,Qw	header'			]
	ajouter_dataset, arbre, '<dataset id="'+NAME2+':EPHEMERIS:ATTITUDE_SRVY_L2_EPHTS04D">9 ephts04d res=30s', nomcis, noproduit, SC, tab, NAME3+'_EPHEMERIS_ATTITUDE_SRVY_L2_EPHTS04D', 'mms_mec'

	; -----
	; ASPOC
	; -----
	nomcis = 'MMS-ASPOC'
	arbre = [ arbre, 																$
		'<instrument name="ASPOC" id="'+NAME2+':ASPOC">4 ASPOC'											]
		arbre = [ arbre, '5 srvy' ]

		; l2
		noproduit = [0]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':ASPOC:SRVY_L2">6 L2', nomcis, noproduit, SC, tab, NAME3+'_ASPOC_SRVY', 'mms_aspoc'

		arbre = [ arbre, '</instrument>' ]


	; ---
	; DFG
	; ---
	nomcis = 'MMS-DFG'
	arbre = [ arbre, 																$
		'<instrument name="DFG" id="'+NAME2+':DFG">4 DFG'											]
		arbre = [ arbre, '5 brst' ]

		; BRSTQL
		noproduit = [5]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DFG:BRSTQL">6 ql res=configurable', nomcis, noproduit, SC, tab, NAME3+'_DFG_BRSTQL', 'mms_dfg'

		; BRSTL1B
		noproduit = [0]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DFG:BRSTL1B">6 l1b res=configurable', nomcis, noproduit, SC, tab, NAME3+'_DFG_BRSTL1B', 'mms_dfg'

		; BRSTL2PRE
		noproduit = [16]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DFG:BRSTL2PRE">6 l2pre res=configurable', nomcis, noproduit, SC, tab, NAME3+'_DFG_BRSTL2PRE', 'mms_dfg'

		arbre = [ arbre, '5 srvy' ]

		; SRVYQL
		noproduit = [9]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DFG:SRVYQL">6 ql res=configurable', nomcis, noproduit, SC, tab, NAME3+'_DFG_SRVYQL', 'mms_dfg'

		; SRVYL1B
		noproduit = [4]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DFG:SRVYL1B">6 l1b res=configurable', nomcis, noproduit, SC, tab, NAME3+'_DFG_SRVYL1B', 'mms_dfg'

		; SRVYL2PRE
		noproduit = [14]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DFG:SRVYL2PRE">6 l2pre res=configurable', nomcis, noproduit, SC, tab, NAME3+'_DFG_SRVYL2PRE', 'mms_dfg'

		arbre = [ arbre, '</instrument>' ]

	; ---
	; DSP
	; ---
	nomcis = 'MMS-DSP'
	arbre = [ arbre, 																$
		'<instrument name="DSP" id="'+NAME2+':DSP">4 DSP'											]
		arbre = [ arbre, '5 fast' ]
		arbre = [ arbre, '6 l2' ]

		arbre = [ arbre, '7 bpsd' ]

		; dsp_fast_l2_bpsd_scm1
		noproduit = [0]
		arbre = [ arbre, '8 scm1 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'power_spectral_density'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Manual yleft_min=10.0 yleft_max=10000.0 z_showdir=No z_theta=No z_phi=No',																			$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; dsp_fast_l2_bpsd_scm2
		noproduit = [1]
		arbre = [ arbre, '8 scm2 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'power_spectral_density'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Manual yleft_min=10.0 yleft_max=10000.0 z_showdir=No z_theta=No z_phi=No',																			$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; dsp_fast_l2_bpsd_scm3
		noproduit = [2]
		arbre = [ arbre, '8 scm3 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'power_spectral_density'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Manual yleft_min=10.0 yleft_max=10000.0 z_showdir=No z_theta=No z_phi=No',																			$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; dsp_fast_l2_bpsd_omni
		noproduit = [3]
		arbre = [ arbre, '8 omni ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'power_spectral_density'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Manual yleft_min=10.0 yleft_max=10000.0 z_showdir=No z_theta=No z_phi=No',																			$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		arbre = [ arbre, '7 epsd' ]

		; dsp_fast_l2_epsd_x
		noproduit = [4]
		arbre = [ arbre, '8 x ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'electric_spectral_density'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Manual yleft_min=1.0 yleft_max=1000000.0 z_showdir=No z_theta=No z_phi=No',																			$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; dsp_fast_l2_epsd_y
		noproduit = [5]
		arbre = [ arbre, '8 y ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'electric_spectral_density'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Manual yleft_min=1.0 yleft_max=1000000.0 z_showdir=No z_theta=No z_phi=No',																			$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; dsp_fast_l2_epsd_z
		noproduit = [6]
		arbre = [ arbre, '8 z ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'electric_spectral_density'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Manual yleft_min=1.0 yleft_max=1000000.0 z_showdir=No z_theta=No z_phi=No',																			$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; dsp_fast_l2_epsd_omni
		noproduit = [7]
		arbre = [ arbre, '8 omni ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'electric_spectral_density'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Manual yleft_min=1.0 yleft_max=1000000.0 z_showdir=No z_theta=No z_phi=No',																			$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		arbre = [ arbre, '7 swd' ]

		; dsp_fast_l2_swd_e12_counts
		noproduit = [8]
		arbre = [ arbre, '8 e12_counts ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'Counts'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Manual yleft_min=10.0 yleft_max=1000.0 z_showdir=No z_theta=No z_phi=No',																			$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		arbre = [ arbre, '5 slow' ]
		arbre = [ arbre, '6 l2' ]

		arbre = [ arbre, '7 bpsd' ]

		; dsp_slow_l2_bpsd_scm1
		noproduit = [9]
		arbre = [ arbre, '8 scm1 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'power_spectral_density'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Manual yleft_min=10.0 yleft_max=10000.0 z_showdir=No z_theta=No z_phi=No',																			$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; dsp_slow_l2_bpsd_scm2
		noproduit = [10]
		arbre = [ arbre, '8 scm2 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'power_spectral_density'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Manual yleft_min=10.0 yleft_max=10000.0 z_showdir=No z_theta=No z_phi=No',																			$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; dsp_slow_l2_bpsd_scm3
		noproduit = [11]
		arbre = [ arbre, '8 scm3 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'power_spectral_density'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Manual yleft_min=10.0 yleft_max=10000.0 z_showdir=No z_theta=No z_phi=No',																			$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; dsp_slow_l2_bpsd_omni
		noproduit = [12]
		arbre = [ arbre, '8 omni ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'power_spectral_density'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Manual yleft_min=10.0 yleft_max=10000.0 z_showdir=No z_theta=No z_phi=No',																			$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		arbre = [ arbre, '7 epsd' ]

		; dsp_slow_l2_epsd_x
		noproduit = [13]
		arbre = [ arbre, '8 x ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'electric_spectral_density'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Manual yleft_min=1.0 yleft_max=1000000.0 z_showdir=No z_theta=No z_phi=No',																			$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; dsp_slow_l2_epsd_y
		noproduit = [14]
		arbre = [ arbre, '8 y ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'electric_spectral_density'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Manual yleft_min=1.0 yleft_max=1000000.0 z_showdir=No z_theta=No z_phi=No',																			$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; dsp_slow_l2_epsd_z
		noproduit = [15]
		arbre = [ arbre, '8 z ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'electric_spectral_density'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Manual yleft_min=1.0 yleft_max=1000000.0 z_showdir=No z_theta=No z_phi=No',																			$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; dsp_slow_l2_epsd_omni
		noproduit = [16]
		arbre = [ arbre, '8 omni ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'electric_spectral_density'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Manual yleft_min=1.0 yleft_max=1000000.0 z_showdir=No z_theta=No z_phi=No',																			$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]


	; ---
	; EDI
	; ---
	nomcis = 'MMS-EDI'
	arbre = [ arbre, 																$
		'<instrument name="EDI" id="'+NAME2+':EDI">4 EDI'											]

		arbre = [ arbre, '5 brst' ]
		arbre = [ arbre, '6 l2' ]
		arbre = [ arbre, '7 amb' ]

		; amb timetag
		noproduit = [0]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:BRST_L2_AMB_TIMETAG">8 timetag', nomcis, noproduit, SC, tab, NAME3+'_EDI_BRST_L2_AMB_TIMETAG', 'mms_edi'

		; amb 0
		noproduit = [1]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:BRST_L2_AMB_0">8 0', nomcis, noproduit, SC, tab, NAME3+'_EDI_BRST_L2_AMB_0', 'mms_edi'

		; amb 180
		noproduit = [2]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:BRST_L2_AMB_180">8 180', nomcis, noproduit, SC, tab, NAME3+'_EDI_BRST_L2_AMB_180', 'mms_edi'

		arbre = [ arbre, '7 amb-pm2' ]

		; amb-pm2 timetag
		noproduit = [3]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:BRST_L2_AMB-PM2_TIMETAG">8 timetag', nomcis, noproduit, SC, tab, NAME3+'_EDI_BRST_L2_AMB-PM2_TIMETAG', 'mms_edi'

		; amb-pm2 pa0
		noproduit = [4]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:BRST_L2_AMB-PM2_0">8 0', nomcis, noproduit, SC, tab, NAME3+'_EDI_BRST_L2_AMB-PM2_0', 'mms_edi'

		; amb-pm2 pa180
		noproduit = [5]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:BRST_L2_AMB-PM2_180">8 180', nomcis, noproduit, SC, tab, NAME3+'_EDI_BRST_L2_AMB-PM2_180', 'mms_edi'

		arbre = [ arbre, '7 q0' ]

		; q0 timetag
		noproduit = [6]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:BRST_L2_Q0_TIMETAG">8 timetag', nomcis, noproduit, SC, tab, NAME3+'_EDI_BRST_L2_Q0_TIMETAG', 'mms_edi'

		; q0 gdu1
		noproduit = [7]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:BRST_L2_Q0_GDU1">8 gdu1', nomcis, noproduit, SC, tab, NAME3+'_EDI_BRST_L2_Q0_GDU1', 'mms_edi'

		; q0 gdu2
		noproduit = [8]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:BRST_L2_Q0_GDU2">8 gdu2', nomcis, noproduit, SC, tab, NAME3+'_EDI_BRST_L2_Q0_GDU2', 'mms_edi'

		; efield
		noproduit = [9]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:BRST_L2_EFIELD">7 efield', nomcis, noproduit, SC, tab, NAME3+'_EDI_BRST_L2_EFIELD', 'mms_edi'

		arbre = [ arbre, '5 srvy' ]
		arbre = [ arbre, '6 l2' ]
		arbre = [ arbre, '7 amb' ]

		; amb timetag
		noproduit = [10]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:SRVY_L2_AMB_TIMETAG">8 timetag', nomcis, noproduit, SC, tab, NAME3+'_EDI_SRVY_L2_AMB_TIMETAG', 'mms_edi'

		; amb 0
		noproduit = [11]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:SRVY_L2_AMB_0">8 0', nomcis, noproduit, SC, tab, NAME3+'_EDI_SRVY_L2_AMB_0', 'mms_edi'

		; amb 180
		noproduit = [12]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:SRVY_L2_AMB_180">8 180', nomcis, noproduit, SC, tab, NAME3+'_EDI_SRVY_L2_AMB_180', 'mms_edi'

		arbre = [ arbre, '7 amb-pm2' ]

		; amb-pm2 timetag
		noproduit = [13]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:SRVY_L2_AMB-PM2_TIMETAG">8 timetag', nomcis, noproduit, SC, tab, NAME3+'_EDI_SRVY_L2_AMB-PM2_TIMETAG', 'mms_edi'

		; amb-pm2 0
		noproduit = [14]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:SRVY_L2_AMB-PM2_0">8 0', nomcis, noproduit, SC, tab, NAME3+'_EDI_SRVY_L2_AMB-PM2_0', 'mms_edi'

		; amb-pm2 180
		noproduit = [15]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:SRVY_L2_AMB-PM2_180">8 180', nomcis, noproduit, SC, tab, NAME3+'_EDI_SRVY_L2_AMB-PM2_180', 'mms_edi'

		arbre = [ arbre, '7 q0' ]

		; q0 gdu1
		noproduit = [16]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:SRVY_L2_Q0_GDU1">8 gdu1', nomcis, noproduit, SC, tab, NAME3+'_EDI_SRVY_L2_Q0_GDU1', 'mms_edi'

		; q0 gdu2
		noproduit = [17]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:SRVY_L2_Q0_GDU2">8 gdu2', nomcis, noproduit, SC, tab, NAME3+'_EDI_SRVY_L2_Q0_GDU2', 'mms_edi'

		; efield
		noproduit = [18]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDI:SRVY_L2_EFIELD">7 efield', nomcis, noproduit, SC, tab, NAME3+'_EDI_SRVY_L2_EFIELD', 'mms_edi'

		arbre = [ arbre, '</instrument>' ]

	; ---
	; EDP
	; ---
	nomcis = 'MMS-EDP'
	arbre = [ arbre, 																$
		'<instrument name="EDP" id="'+NAME2+':EDP">4 EDP'											]

		arbre = [ arbre, '5 brst' ]
		arbre = [ arbre, '6 l2' ]

		; edp_brst_l2_scpot
		noproduit = [0]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDP:BRST_L2_SCPOT">7 scpot', nomcis, noproduit, SC, tab, NAME3+'_EDP_BRST_L2_SCPOT', 'mms_edp'

		; edp_brst_l2_hmfe
		noproduit = [2]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDP:BRST_L2_HMFE">7 hmfe', nomcis, noproduit, SC, tab, NAME3+'_EDP_BRST_L2_HMFE', 'mms_edp'

		; edp_brst_l2_dce
		noproduit = [3]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDP:BRST_L2_DCE">7 dce', nomcis, noproduit, SC, tab, NAME3+'_EDP_BRST_L2_DCE', 'mms_edp'

		arbre = [ arbre, '5 fast' ]
		arbre = [ arbre, '6 l2' ]

		; edp_fast_l2_scpot
		noproduit = [1]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDP:FAST_L2_SCPOT">7 scpot', nomcis, noproduit, SC, tab, NAME3+'_EDP_FAST_L2_SCPOT', 'mms_edp'

		; edp_fast_l2_dce
		noproduit = [5]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDP:FAST_L2_DCE">7 dce', nomcis, noproduit, SC, tab, NAME3+'_EDP_FAST_L2_DCE', 'mms_edp'

		arbre = [ arbre, '5 comm' ]
		arbre = [ arbre, '6 l2' ]

		; edp_comm_l2_scpot
		noproduit = [4]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDP:COMM_L2_SCPOT">7 scpot', nomcis, noproduit, SC, tab, NAME3+'_EDP_COMM_L2_SCPOT', 'mms_edp'

		arbre = [ arbre, '5 slow' ]
		arbre = [ arbre, '6 l2' ]

		; edp_slow_l2_scpot
		noproduit = [6]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDP:SLOW_L2_SCPOT">7 scpot', nomcis, noproduit, SC, tab, NAME3+'_EDP_SLOW_L2_SCPOT', 'mms_edp'

		; edp_slow_l2_dce
		noproduit = [7]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EDP:SLOW_L2_DCE">7 dce', nomcis, noproduit, SC, tab, NAME3+'_EDP_SLOW_L2_DCE', 'mms_edp'

		arbre = [ arbre, '5 srvy' ]
		arbre = [ arbre, '6 l2' ]

		; hfesp
		noproduit = [8]
		arbre = [ arbre, '7 hfesp ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]

		; "Particle spectrogram" et "Particle plot"
		unite = 'Efield_Spectral_Density'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'8 Particle spectrogram',																																										$
				'0 Time Frequency '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' z_showdir=No z_theta=No z_phi=No yleft_auto=Manual yleft_min=100.0 yleft_max=100000.0',																				$
			'8 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Frequency '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                          legend_theta=No legend_phi=No x_auto=Manual x_min=100.0 x_max=100000.0',																	$
				'0 Frequency '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=100000.0 legend_theta=No legend_phi=No x_auto=Manual x_min=100.0 x_max=100000.0'																	$
		]


		arbre = [ arbre, '</instrument>' ]

	arbre = [ arbre, '4 EPD' ]
	; ---
	; EIS
	; ---
	nomcis = 'MMS-EIS'
	arbre = [ arbre, 																$
		'<instrument name="EIS" id="'+NAME2+':EIS">5 EIS'											]

		arbre = [ arbre, '6 brst' ]
		arbre = [ arbre, '7 l2' ]
		arbre = [ arbre, '8 extof' ]

		; eis_brst_l2_extof_ts
		noproduit = [0]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EIS:BRST_L2_EXTOF_TS">9 timeseries', nomcis, noproduit, SC, tab, NAME3+'_EIS_BRST_L2_EXTOF_TS', 'mms_eis'

		; eis_brst_l2_extof_proton_t0_flux
		noproduit = [1]
		arbre = [ arbre, '9 proton_t0_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_extof_proton_t1_flux
		noproduit = [2]
		arbre = [ arbre, '9 proton_t1_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_extof_proton_t2_flux
		noproduit = [3]
		arbre = [ arbre, '9 proton_t2_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_extof_proton_t3_flux
		noproduit = [4]
		arbre = [ arbre, '9 proton_t3_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_extof_proton_t4_flux
		noproduit = [5]
		arbre = [ arbre, '9 proton_t4_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_extof_proton_t5_flux
		noproduit = [6]
		arbre = [ arbre, '9 proton_t5_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_extof_alpha_t0_flux
		noproduit = [7]
		arbre = [ arbre, '9 alpha_t0_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_extof_alpha_t1_flux
		noproduit = [8]
		arbre = [ arbre, '9 alpha_t1_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_extof_alpha_t2_flux
		noproduit = [9]
		arbre = [ arbre, '9 alpha_t2_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_extof_alpha_t3_flux
		noproduit = [10]
		arbre = [ arbre, '9 alpha_t3_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_extof_alpha_t4_flux
		noproduit = [11]
		arbre = [ arbre, '9 alpha_t4_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_extof_alpha_t5_flux
		noproduit = [12]
		arbre = [ arbre, '9 alpha_t5_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_extof_oxygen_t0_flux
		noproduit = [13]
		arbre = [ arbre, '9 oxygen_t0_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_extof_oxygen_t1_flux
		noproduit = [14]
		arbre = [ arbre, '9 oxygen_t1_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_extof_oxygen_t2_flux
		noproduit = [15]
		arbre = [ arbre, '9 oxygen_t2_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_extof_oxygen_t3_flux
		noproduit = [16]
		arbre = [ arbre, '9 oxygen_t3_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_extof_oxygen_t4_flux
		noproduit = [17]
		arbre = [ arbre, '9 oxygen_t4_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_extof_oxygen_t5_flux
		noproduit = [18]
		arbre = [ arbre, '9 oxygen_t5_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		arbre = [ arbre, '8 phxtof' ]

		; eis_brst_l2_phxtof_ts
		noproduit = [19]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EIS:BRST_L2_PHXTOF_TS">9 timeseries', nomcis, noproduit, SC, tab, NAME3+'_EIS_BRST_L2_PHXTOF_TS', 'mms_eis'

		; eis_brst_l2_phxtof_proton_t0_flux
		noproduit = [20]
		arbre = [ arbre, '9 proton_t0_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_phxtof_proton_t1_flux
		noproduit = [21]
		arbre = [ arbre, '9 proton_t1_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_phxtof_proton_t2_flux
		noproduit = [22]
		arbre = [ arbre, '9 proton_t2_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_phxtof_proton_t3_flux
		noproduit = [23]
		arbre = [ arbre, '9 proton_t3_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_phxtof_proton_t4_flux
		noproduit = [24]
		arbre = [ arbre, '9 proton_t4_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_phxtof_proton_t5_flux
		noproduit = [25]
		arbre = [ arbre, '9 proton_t5_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_phxtof_xoygen_t0_flux
		noproduit = [26]
		arbre = [ arbre, '9 oxygen_t0_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_phxtof_xoygen_t1_flux
		noproduit = [27]
		arbre = [ arbre, '9 oxygen_t1_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_phxtof_xoygen_t2_flux
		noproduit = [28]
		arbre = [ arbre, '9 oxygen_t2_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_phxtof_xoygen_t3_flux
		noproduit = [29]
		arbre = [ arbre, '9 oxygen_t3_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_phxtof_xoygen_t4_flux
		noproduit = [30]
		arbre = [ arbre, '9 oxygen_t4_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_brst_l2_phxtof_xoygen_t5_flux
		noproduit = [31]
		arbre = [ arbre, '9 oxygen_t5_flux ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		arbre = [ arbre, '6 srvy' ]
		arbre = [ arbre, '7 l2' ]
		arbre = [ arbre, '8 electronenergy' ]

		; eis_srvy_l2_electronenergy_ts
		noproduit = [32]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EIS:SRVY_L2_ELECTRONENERGY_TS">9 timeseries', nomcis, noproduit, SC, tab, NAME3+'_EIS_SRVY_L2_ELECTRONENERGY_TS', 'mms_eis'

		; eis_srvy_l2_electronenergy_flux_t0
		noproduit = [33]
		arbre = [ arbre, '9 electron_flux_t0 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_electronenergy_flux_t1
		noproduit = [34]
		arbre = [ arbre, '9 electron_flux_t1 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_electronenergy_flux_t2
		noproduit = [35]
		arbre = [ arbre, '9 electron_flux_t2 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_electronenergy_flux_t3
		noproduit = [36]
		arbre = [ arbre, '9 electron_flux_t3 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_electronenergy_flux_t4
		noproduit = [37]
		arbre = [ arbre, '9 electron_flux_t4 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_electronenergy_flux_t5
		noproduit = [38]
		arbre = [ arbre, '9 electron_flux_t5 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		arbre = [ arbre, '8 extof' ]

		; eis_srvy_l2_extof_ts
		noproduit = [39]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EIS:SRVY_L2_EXTOF_TS">9 timeseries', nomcis, noproduit, SC, tab, NAME3+'_EIS_SRVY_L2_EXTOF_TS', 'mms_eis'

		; eis_srvy_l2_extof_proton_flux_t0
		noproduit = [40]
		arbre = [ arbre, '9 proton_flux_t0 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_extof_proton_flux_t1
		noproduit = [41]
		arbre = [ arbre, '9 proton_flux_t1 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_extof_proton_flux_t2
		noproduit = [42]
		arbre = [ arbre, '9 proton_flux_t2 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_extof_proton_flux_t3
		noproduit = [43]
		arbre = [ arbre, '9 proton_flux_t3 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_extof_proton_flux_t4
		noproduit = [44]
		arbre = [ arbre, '9 proton_flux_t4 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_extof_proton_flux_t5
		noproduit = [45]
		arbre = [ arbre, '9 proton_flux_t5 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_extof_alpha_flux_t0
		noproduit = [46]
		arbre = [ arbre, '9 alpha_flux_t0 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_extof_alpha_flux_t1
		noproduit = [47]
		arbre = [ arbre, '9 alpha_flux_t1 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_extof_alpha_flux_t2
		noproduit = [48]
		arbre = [ arbre, '9 alpha_flux_t2 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_extof_alpha_flux_t3
		noproduit = [49]
		arbre = [ arbre, '9 alpha_flux_t3 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_extof_alpha_flux_t4
		noproduit = [50]
		arbre = [ arbre, '9 alpha_flux_t4 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_extof_alpha_flux_t5
		noproduit = [51]
		arbre = [ arbre, '9 alpha_flux_t5 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_extof_oxygen_flux_t0
		noproduit = [52]
		arbre = [ arbre, '9 oxygen_flux_t0 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_extof_oxygen_flux_t1
		noproduit = [53]
		arbre = [ arbre, '9 oxygen_flux_t1 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_extof_oxygen_flux_t2
		noproduit = [54]
		arbre = [ arbre, '9 oxygen_flux_t2 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_extof_oxygen_flux_t3
		noproduit = [55]
		arbre = [ arbre, '9 oxygen_flux_t3 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_extof_oxygen_flux_t4
		noproduit = [56]
		arbre = [ arbre, '9 oxygen_flux_t4 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_extof_oxygen_flux_t5
		noproduit = [57]
		arbre = [ arbre, '9 oxygen_flux_t5 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		arbre = [ arbre, '8 phxtof' ]

		; eis_srvy_l2_phxtof_ts
		noproduit = [58]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':EIS:SRVY_L2_PHXTOF_TS">9 timeseries', nomcis, noproduit, SC, tab, NAME3+'_EIS_SRVY_L2_PHXTOF_TS', 'mms_eis'

		; eis_srvy_l2_phxtof_proton_flux_t0
		noproduit = [59]
		arbre = [ arbre, '9 proton_flux_t0 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_phxtof_proton_flux_t1
		noproduit = [60]
		arbre = [ arbre, '9 proton_flux_t1 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_phxtof_proton_flux_t2
		noproduit = [61]
		arbre = [ arbre, '9 proton_flux_t2 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_phxtof_proton_flux_t3
		noproduit = [62]
		arbre = [ arbre, '9 proton_flux_t3 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_phxtof_proton_flux_t4
		noproduit = [63]
		arbre = [ arbre, '9 proton_flux_t4 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_phxtof_proton_flux_t5
		noproduit = [64]
		arbre = [ arbre, '9 proton_flux_t5 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_phxtof_oxygen_flux_t0
		noproduit = [65]
		arbre = [ arbre, '9 oxygen_flux_t0 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_phxtof_oxygen_flux_t1
		noproduit = [66]
		arbre = [ arbre, '9 oxygen_flux_t1 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_phxtof_oxygen_flux_t2
		noproduit = [67]
		arbre = [ arbre, '9 oxygen_flux_t2 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_phxtof_oxygen_flux_t3
		noproduit = [68]
		arbre = [ arbre, '9 oxygen_flux_t3 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_phxtof_oxygen_flux_t4
		noproduit = [69]
		arbre = [ arbre, '9 oxygen_flux_t4 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; eis_srvy_l2_phxtof_oxygen_flux_t5
		noproduit = [70]
		arbre = [ arbre, '9 oxygen_flux_t5 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		arbre = [ arbre, '</instrument>' ]

	arbre = [ arbre, '5 FEEPS' ]
	; ------
	; FEEPSE
	; ------
	nomcis = 'MMS-FEEPSE'
	arbre = [ arbre, 																$
		'<instrument name="FEEPSE" id="'+NAME2+':FEEPSE">6 ELECTRON'										]

		arbre = [ arbre, '7 brst' ]
		arbre = [ arbre, '8 l2' ]

		; feeps_brst_l2_electron_ts
		noproduit = [0]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':FEEPSE:BRST_L2_ELECTRON_TS">9 timeseries', nomcis, noproduit, SC, tab, NAME3+'_FEEPSE_BRST_L2_ELECTRON_TS', 'mms_feepse'

		; feeps_brst_l2_electron_intensity_top_1
		noproduit = [1]
		arbre = [ arbre, '9 electron_intensity_top_1 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_electron_intensity_top_2
		noproduit = [2]
		arbre = [ arbre, '9 electron_intensity_top_2 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_electron_intensity_top_3
		noproduit = [3]
		arbre = [ arbre, '9 electron_intensity_top_3 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_electron_intensity_top_4
		noproduit = [4]
		arbre = [ arbre, '9 electron_intensity_top_4 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_electron_intensity_top_5
		noproduit = [5]
		arbre = [ arbre, '9 electron_intensity_top_5 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_electron_intensity_top_9
		noproduit = [6]
		arbre = [ arbre, '9 electron_intensity_top_9 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_electron_intensity_top_10
		noproduit = [7]
		arbre = [ arbre, '9 electron_intensity_top_10 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_electron_intensity_top_11
		noproduit = [8]
		arbre = [ arbre, '9 electron_intensity_top_11 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_electron_intensity_top_12
		noproduit = [9]
		arbre = [ arbre, '9 electron_intensity_top_12 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_electron_intensity_bottom_1
		noproduit = [10]
		arbre = [ arbre, '9 electron_intensity_bottom_1 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_electron_intensity_bottom_2
		noproduit = [11]
		arbre = [ arbre, '9 electron_intensity_bottom_2 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_electron_intensity_bottom_3
		noproduit = [12]
		arbre = [ arbre, '9 electron_intensity_bottom_3 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_electron_intensity_bottom_4
		noproduit = [13]
		arbre = [ arbre, '9 electron_intensity_bottom_4 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_electron_intensity_bottom_5
		noproduit = [14]
		arbre = [ arbre, '9 electron_intensity_bottom_5 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_electron_intensity_bottom_9
		noproduit = [15]
		arbre = [ arbre, '9 electron_intensity_bottom_9 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_electron_intensity_bottom_10
		noproduit = [16]
		arbre = [ arbre, '9 electron_intensity_bottom_10 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_electron_intensity_bottom_11
		noproduit = [17]
		arbre = [ arbre, '9 electron_intensity_bottom_11 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_electron_intensity_bottom_12
		noproduit = [18]
		arbre = [ arbre, '9 electron_intensity_bottom_12 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_electron_intensity_pad
		noproduit = [30]
		arbre = [ arbre, '9 electron_intensity_pad ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  cjf='+unite+' yleft_auto=Manual yleft_min=0.0 yleft_max=180.0 z_showdir=No z_theta=No z_phi=No'																							$
		]

		arbre = [ arbre, '7 srvy' ]
		arbre = [ arbre, '8 l2' ]

		; feeps_srvy_l2_electron_ts
		noproduit = [19]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':FEEPSE:SRVY_L2_ELECTRON_TS">9 timeseries', nomcis, noproduit, SC, tab, NAME3+'_FEEPSE_SRVY_L2_ELECTRON_TS', 'mms_feepse'

		; feeps_srvy_l2_electron_intensity_top_3
		noproduit = [20]
		arbre = [ arbre, '9 electron_intensity_top_3 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_srvy_l2_electron_intensity_top_4
		noproduit = [21]
		arbre = [ arbre, '9 electron_intensity_top_4 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_srvy_l2_electron_intensity_top_5
		noproduit = [22]
		arbre = [ arbre, '9 electron_intensity_top_5 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_srvy_l2_electron_intensity_top_11
		noproduit = [23]
		arbre = [ arbre, '9 electron_intensity_top_11 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_srvy_l2_electron_intensity_top_12
		noproduit = [24]
		arbre = [ arbre, '9 electron_intensity_top_12 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_srvy_l2_electron_intensity_bottom_3
		noproduit = [25]
		arbre = [ arbre, '9 electron_intensity_bottom_3 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_srvy_l2_electron_intensity_bottom_4
		noproduit = [26]
		arbre = [ arbre, '9 electron_intensity_bottom_4 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_srvy_l2_electron_intensity_bottom_5
		noproduit = [27]
		arbre = [ arbre, '9 electron_intensity_bottom_5 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_srvy_l2_electron_intensity_bottom_11
		noproduit = [28]
		arbre = [ arbre, '9 electron_intensity_bottom_11 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_srvy_l2_electron_intensity_bottom_12
		noproduit = [29]
		arbre = [ arbre, '9 electron_intensity_bottom_12 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_srvy_l2_electron_intensity_pad
		noproduit = [31]
		arbre = [ arbre, '9 electron_intensity_pad ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  cjf='+unite+' yleft_auto=Manual yleft_min=0.0 yleft_max=180.0 z_showdir=No z_theta=No z_phi=No'																							$
		]

		arbre = [ arbre, '</instrument>' ]

	; ------
	; FEEPSI
	; ------
	nomcis = 'MMS-FEEPSI'
	arbre = [ arbre, 																$
		'<instrument name="FEEPSI" id="'+NAME2+':FEEPSI">6 ION'										]

		arbre = [ arbre, '7 brst' ]
		arbre = [ arbre, '8 l2' ]

		; feeps_brst_l2_ion_ts
		noproduit = [0]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':FEEPSI:BRST_L2_ION_TS">9 timeseries', nomcis, noproduit, SC, tab, NAME3+'_FEEPSI_BRST_L2_ION_TS', 'mms_feepsi'

		; feeps_brst_l2_ion_intensity_top_6
		noproduit = [1]
		arbre = [ arbre, '9 ion_intensity_top_6 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_ion_intensity_top_7
		noproduit = [2]
		arbre = [ arbre, '9 ion_intensity_top_7 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_ion_intensity_top_8
		noproduit = [3]
		arbre = [ arbre, '9 ion_intensity_top_8 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_ion_intensity_bottom_6
		noproduit = [4]
		arbre = [ arbre, '9 ion_intensity_bottom_6 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_ion_intensity_bottom_7
		noproduit = [5]
		arbre = [ arbre, '9 ion_intensity_bottom_7 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_ion_intensity_bottom_8
		noproduit = [6]
		arbre = [ arbre, '9 ion_intensity_bottom_8 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_brst_l2_ion_intensity_pad
		noproduit = [14]
		arbre = [ arbre, '9 ion_intensity_pad ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  cjf='+unite+' yleft_auto=Manual yleft_min=0.0 yleft_max=180.0 z_showdir=No z_theta=No z_phi=No'																							$
		]

		arbre = [ arbre, '7 srvy' ]
		arbre = [ arbre, '8 l2' ]

		; feeps_srvy_l2_ion_ts
		noproduit = [7]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':FEEPSI:SRVY_L2_ION_TS">9 timeseries', nomcis, noproduit, SC, tab, NAME3+'_FEEPSI_SRVY_L2_ION_TS', 'mms_feepsi'

		; feeps_srvy_l2_ion_intensity_top_6
		noproduit = [8]
		arbre = [ arbre, '9 ion_intensity_top_6 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_srvy_l2_ion_intensity_top_7
		noproduit = [9]
		arbre = [ arbre, '9 ion_intensity_top_7 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_srvy_l2_ion_intensity_top_8
		noproduit = [10]
		arbre = [ arbre, '9 ion_intensity_top_8 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_srvy_l2_ion_intensity_bottom_6
		noproduit = [11]
		arbre = [ arbre, '9 ion_intensity_bottom_6 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_srvy_l2_ion_intensity_bottom_7
		noproduit = [12]
		arbre = [ arbre, '9 ion_intensity_bottom_7 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_srvy_l2_ion_intensity_bottom_8
		noproduit = [13]
		arbre = [ arbre, '9 ion_intensity_bottom_8 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'10 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		; feeps_srvy_l2_ion_intensity_pad
		noproduit = [15]
		arbre = [ arbre, '9 ion_intensity_pad ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'flux->flux'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'10 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  cjf='+unite+' yleft_auto=Manual yleft_min=0.0 yleft_max=180.0 z_showdir=No z_theta=No z_phi=No'																							$
		]

		arbre = [ arbre, '</instrument>' ]

	; ---
	; FGM
	; ---
	nomcis = 'MMS-FGM'
	arbre = [ arbre, 																$
		'<instrument name="FGM" id="'+NAME2+':FGM">4 FGM'											]
		arbre = [ arbre, '5 brst' ]

		; BRST_L2
		noproduit = [0]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':FGM:BRST_L2">6 l2 128S/s', nomcis, noproduit, SC, tab, NAME3+'_FGM_BRST_L2', 'mms_fgm'

		arbre = [ arbre, '5 srvy' ]

		; SRVY_L2
		noproduit = [2]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':FGM:SRVY_L2">6 l2 8 or 16 S/s', nomcis, noproduit, SC, tab, NAME3+'_FGM_SRVY_L2', 'mms_fgm'

	; ---
	; FPI
	; ---
	nomcis = 'MMS-FPI'
	arbre = [ arbre, '4 FPI' ]
	arbre = [ arbre, 															$
		'<instrument name="FPI" id="'+NAME2+':FPI">5 DES/DIS fast sitl'									]
		arbre = [ arbre, '6 fast' ]

		; FASTSITL
		noproduit = [0]
		arbre = [ arbre, '7 sitl res=10s ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]

		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':FPI:FASTSITL">8 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_FPI_FASTSITL', 'mms_fpi', /notime

		; "Particle spectrogram"
		arbre = [ arbre, '8 Particle spectrogram' ]
		unite = 'JE'

		noproduit = [1]
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, '0 electron energy spectrum near +X_DSC '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No' ]

		noproduit = [2]
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, '0 electron energy spectrum near -X_DSC '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No' ]

		noproduit = [3]
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, '0 electron energy spectrum near +Y_DSC '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No' ]

		noproduit = [4]
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, '0 electron energy spectrum near -Y_DSC '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No' ]

		noproduit = [5]
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, '0 electron energy spectrum near +Z_DSC '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No' ]

		noproduit = [6]
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, '0 electron energy spectrum near -Z_DSC '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No' ]

		noproduit = [7]
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, '0 ion energy spectrum near +X_DSC '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No' ]

		noproduit = [8]
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, '0 ion energy spectrum near -X_DSC '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No' ]

		noproduit = [9]
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, '0 ion energy spectrum near +Y_DSC '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No' ]

		noproduit = [10]
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, '0 ion energy spectrum near -Y_DSC '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No' ]

		noproduit = [11]
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, '0 ion energy spectrum near +Z_DSC '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No' ]

		noproduit = [12]
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, '0 ion energy spectrum near -Z_DSC '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No' ]

		noproduit = [13]
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, '0 electron pitch-angle distribution for low energies (0 eV - 200 eV) '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_title=!4&nbsp;a!3&nbsp;(deg) yleft_auto=Manual yleft_min=0 yleft_max=180 yleft_log=Linear z_showdir=No z_theta=No z_phi=No' ]

		noproduit = [14]
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, '0 electron pitch-angle distribution for mid energies (200 eV - 2 keV) '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_title=!4&nbsp;a!3&nbsp;(deg) yleft_auto=Manual yleft_min=0 yleft_max=180 yleft_log=Linear z_showdir=No z_theta=No z_phi=No' ]

		noproduit = [15]
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, '0 electron pitch-angle distribution for high energies (2 keV - 30 keV) '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy cjf='+unite+' yleft_title=!4&nbsp;a!3&nbsp;(deg) yleft_auto=Manual yleft_min=0 yleft_max=180 yleft_log=Linear z_showdir=No z_theta=No z_phi=No' ]

		arbre = [ arbre, '</instrument>' ]


	; ---
	; DES
	; ---
	nomcis = 'MMS-DES'
	arbre = [ arbre, 															$
		'<instrument name="DES" id="'+NAME2+':DES">5 DES'										]
		arbre = [ arbre, '6 brst' ]
		arbre = [ arbre, '7 l1b (unavailable on clweb)' ]

		; DISTTL1B32E
		noproduit = [3]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:DISTTL1B32E">8 Time of dist', nomcis, noproduit, SC, tab, NAME3+'_DES_DISTTL1B32E', 'mms_des'
		arbre = [ arbre, '</instrument>' ]

		; MOMSTL1B
		noproduit = [4]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:MOMSTL1B">8 Time of moms', nomcis, noproduit, SC, tab, NAME3+'_DES_MOMSTL1B', 'mms_des'
		arbre = [ arbre, '</instrument>' ]

		; DES-MOMS BRST L1B
		noproduit = [0]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:MOMSL1B">8 MOMS res=30ms', nomcis, noproduit, SC, tab, NAME3+'_DES_MOMSL1B', 'mms_des'
		arbre = [ arbre, '</instrument>' ]

		; DES-DIST BRST L1B 32E
		noproduit = [1]
		arbre = [ arbre, '8 DIST 32E res=30ms ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:DISTL1B32E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DES_DISTL1B32E', 'mms_des', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																																$
			'9 Particle spectrogram',																																														$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																								$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																								$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																				$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_brst_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',										$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_brst_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																				$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   Bresolution=fgm_brst_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',																$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_brst_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-50000 x_max=50000 yleft_auto=Manual yleft_min=-50000 yleft_max=50000 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=500',	$
			'9 Particle plot',																																															$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_brst_l2 cjf='+unite+' legend_theta=No legend_phi=No',																											$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																				$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																				$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_brst_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																								$
		]

		; 3D MOMENTS
		tab = [	'cl	N_cm3											#  				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Vx_mso_km_sec,Vy_mso_km_sec,Vz_mso_km_sec,*V_km_sec					Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Qx_mso_erg_sec_cm2,Qy_mso_erg_sec_cm2,Qz_mso_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ei_eV_cm3										#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ti_eV											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Ex_mso,Ey_mso,Ez_mso									Ex,Ey,Ez			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxpar_ngse_km_sec,Vypar_ngse_km_sec,Vzpar_ngse_km_sec,*Vpar_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxper_ngse_km_sec,Vyper_ngse_km_sec,Vzper_ngse_km_sec,*Vper_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Elx_ngse_mV_m,Ely_ngse_mV_m,Elz_ngse_mV_m,El_ngse_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pp_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pm_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pt_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Beta											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxalfven_ngse_km_sec,Vyalfven_ngse_km_sec,Vzalfven_ngse_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	An											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ng											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
			;'cl	Bx_mso_nT,By_mso_nT,Bz_mso_nT								Bx,By,Bz			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
		]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:3DMOMENTS32E">9 3D moments', nomcis, noproduit, SC, tab, NAME3+'_DES_3DMOMENTS32E', 'mms_des', /moments, /notime

		; DES-DIST BRST L1B 64E
		noproduit = [2]
		arbre = [ arbre, '8 DIST 64E res=30ms ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:DISTL1B64E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DES_DISTL1B64E', 'mms_des', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																																$
			'9 Particle spectrogram',																																														$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																								$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																											$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																							$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_brst_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',										$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_brst_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																				$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   Bresolution=fgm_brst_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',																$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_brst_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-50000 x_max=50000 yleft_auto=Manual yleft_min=-50000 yleft_max=50000 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=500',	$
			'9 Particle plot',																																															$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_brst_l2 cjf='+unite+' legend_theta=No legend_phi=No',																														$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																							$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																							$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_brst_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																								$
		]

		; 3D MOMENTS
		tab = [	'cl	N_cm3											#  				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Vx_mso_km_sec,Vy_mso_km_sec,Vz_mso_km_sec,*V_km_sec					Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Qx_mso_erg_sec_cm2,Qy_mso_erg_sec_cm2,Qz_mso_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ei_eV_cm3										#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ti_eV											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Ex_mso,Ey_mso,Ez_mso									Ex,Ey,Ez			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxpar_ngse_km_sec,Vypar_ngse_km_sec,Vzpar_ngse_km_sec,*Vpar_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxper_ngse_km_sec,Vyper_ngse_km_sec,Vzper_ngse_km_sec,*Vper_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Elx_ngse_mV_m,Ely_ngse_mV_m,Elz_ngse_mV_m,El_ngse_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pp_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pm_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pt_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Beta											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxalfven_ngse_km_sec,Vyalfven_ngse_km_sec,Vzalfven_ngse_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	An											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ng											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
			;'cl	Bx_mso_nT,By_mso_nT,Bz_mso_nT								Bx,By,Bz			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
		]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:3DMOMENTS64E">9 3D moments', nomcis, noproduit, SC, tab, NAME3+'_DES_3DMOMENTS64E', 'mms_des', /moments, /notime

		; DISTERRL1B32E
		noproduit = [5]
		arbre = [ arbre, '8 DISTERR 32E res=30ms ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:DISTERRL1B32E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DES_DISTERRL1B32E', 'mms_des', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																																$
			'9 Particle spectrogram',																																														$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																								$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																											$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																							$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_brst_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',										$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_brst_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																				$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   Bresolution=fgm_brst_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',																$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_brst_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-50000 x_max=50000 yleft_auto=Manual yleft_min=-50000 yleft_max=50000 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=500',	$
			'9 Particle plot',																																															$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_brst_l2 cjf='+unite+' legend_theta=No legend_phi=No',																														$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																							$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																							$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_brst_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																								$
		]

		arbre = [ arbre, '7 l2' ]

		; DISTTL232E
		noproduit = [12]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:DISTTL232E">8 Time of dist', nomcis, noproduit, SC, tab, NAME3+'_DES_DISTTL232E', 'mms_des'
		arbre = [ arbre, '</instrument>' ]

		; MOMSTL2
		noproduit = [13]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:MOMSTL2">8 Time of moms', nomcis, noproduit, SC, tab, NAME3+'_DES_MOMSTL2', 'mms_des'
		arbre = [ arbre, '</instrument>' ]

		; DES-MOMS BRST L2
		noproduit = [9]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:MOMSL2">8 MOMS res=30ms', nomcis, noproduit, SC, tab, NAME3+'_DES_MOMSL2', 'mms_des'
		arbre = [ arbre, '</instrument>' ]

		; DES-DIST BRST L2 32E
		noproduit = [10]
		arbre = [ arbre, '8 DIST 32E res=30ms ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:DISTL232E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DES_DISTL232E', 'mms_des', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																																$
			'9 Particle spectrogram',																																														$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																								$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																											$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																							$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_brst_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',										$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_brst_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																				$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   Bresolution=fgm_brst_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',																$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_brst_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-50000 x_max=50000 yleft_auto=Manual yleft_min=-50000 yleft_max=50000 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=500',	$
			'9 Particle plot',																																															$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_brst_l2 cjf='+unite+' legend_theta=No legend_phi=No',																														$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																							$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																							$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_brst_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																								$
		]

		; 3D MOMENTS
		tab = [	'cl	N_cm3											#  				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Vx_mso_km_sec,Vy_mso_km_sec,Vz_mso_km_sec,*V_km_sec					Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Qx_mso_erg_sec_cm2,Qy_mso_erg_sec_cm2,Qz_mso_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ei_eV_cm3										#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ti_eV											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Ex_mso,Ey_mso,Ez_mso									Ex,Ey,Ez			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxpar_ngse_km_sec,Vypar_ngse_km_sec,Vzpar_ngse_km_sec,*Vpar_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxper_ngse_km_sec,Vyper_ngse_km_sec,Vzper_ngse_km_sec,*Vper_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Elx_ngse_mV_m,Ely_ngse_mV_m,Elz_ngse_mV_m,El_ngse_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pp_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pm_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pt_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Beta											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxalfven_ngse_km_sec,Vyalfven_ngse_km_sec,Vzalfven_ngse_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	An											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ng											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
			;'cl	Bx_mso_nT,By_mso_nT,Bz_mso_nT								Bx,By,Bz			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
		]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:3DMOMENTS32E">9 3D moments', nomcis, noproduit, SC, tab, NAME3+'_DES_3DMOMENTS32E', 'mms_des', /moments, /notime

		; DES-DIST BRST L2 64E
		noproduit = [11]
		arbre = [ arbre, '8 DIST 64E res=30ms ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:DISTL264E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DES_DISTL264E', 'mms_des', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																																$
			'9 Particle spectrogram',																																														$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																								$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																											$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																							$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_brst_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',										$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_brst_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																				$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   Bresolution=fgm_brst_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',																$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_brst_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-50000 x_max=50000 yleft_auto=Manual yleft_min=-50000 yleft_max=50000 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=500',	$
			'9 Particle plot',																																															$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_brst_l2 cjf='+unite+' legend_theta=No legend_phi=No',																														$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																							$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																							$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_brst_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																								$
		]

		; 3D MOMENTS
		tab = [	'cl	N_cm3											#  				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Vx_mso_km_sec,Vy_mso_km_sec,Vz_mso_km_sec,*V_km_sec					Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Qx_mso_erg_sec_cm2,Qy_mso_erg_sec_cm2,Qz_mso_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ei_eV_cm3										#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ti_eV											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Ex_mso,Ey_mso,Ez_mso									Ex,Ey,Ez			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxpar_ngse_km_sec,Vypar_ngse_km_sec,Vzpar_ngse_km_sec,*Vpar_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxper_ngse_km_sec,Vyper_ngse_km_sec,Vzper_ngse_km_sec,*Vper_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Elx_ngse_mV_m,Ely_ngse_mV_m,Elz_ngse_mV_m,El_ngse_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pp_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pm_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pt_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Beta											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxalfven_ngse_km_sec,Vyalfven_ngse_km_sec,Vzalfven_ngse_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	An											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ng											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
			;'cl	Bx_mso_nT,By_mso_nT,Bz_mso_nT								Bx,By,Bz			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
		]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:3DMOMENTS64E">9 3D moments', nomcis, noproduit, SC, tab, NAME3+'_DES_3DMOMENTS64E', 'mms_des', /moments, /notime

		; DISTERRL232E
		noproduit = [14]
		arbre = [ arbre, '8 DISTERR 32E res=30ms ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:DISTERRL232E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DES_DISTERRL232E', 'mms_des', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																																$
			'9 Particle spectrogram',																																														$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																								$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																											$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																							$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_brst_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',										$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_brst_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																				$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   Bresolution=fgm_brst_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',																$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_brst_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-50000 x_max=50000 yleft_auto=Manual yleft_min=-50000 yleft_max=50000 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=500',	$
			'9 Particle plot',																																															$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_brst_l2 cjf='+unite+' legend_theta=No legend_phi=No',																														$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																							$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																							$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_brst_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																								$
		]

		arbre = [ arbre, '6 fast' ]
		arbre = [ arbre, '7 l1b (unavailable on clweb)' ]

		; DES-MOMS FAST L1B
		noproduit = [6]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:MOMSL1B">8 MOMS res=4.5s', nomcis, noproduit, SC, tab, NAME3+'_DES_MOMSL1B', 'mms_des'
		arbre = [ arbre, '</instrument>' ]

		; DES-DIST FAST L1B 32E
		noproduit = [7]
		arbre = [ arbre, '8 DIST 32E res=4.5s ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:DISTL1B32E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DES_DISTL1B32E', 'mms_des', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																																$
			'9 Particle spectrogram',																																														$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																								$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																											$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																							$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_srvy_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',										$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_srvy_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																				$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta Bresolution=fgm_srvy_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',																	$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_srvy_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-50000 x_max=50000 yleft_auto=Manual yleft_min=-50000 yleft_max=50000 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=500',	$
			'9 Particle plot',																																															$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' legend_theta=No legend_phi=No',																														$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_srvy_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																							$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																							$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																								$
		]

		; 3D MOMENTS
		tab = [	'cl	N_cm3											#  				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Vx_mso_km_sec,Vy_mso_km_sec,Vz_mso_km_sec,*V_km_sec					Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Qx_mso_erg_sec_cm2,Qy_mso_erg_sec_cm2,Qz_mso_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ei_eV_cm3										#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ti_eV											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Ex_mso,Ey_mso,Ez_mso									Ex,Ey,Ez			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxpar_ngse_km_sec,Vypar_ngse_km_sec,Vzpar_ngse_km_sec,*Vpar_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxper_ngse_km_sec,Vyper_ngse_km_sec,Vzper_ngse_km_sec,*Vper_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Elx_ngse_mV_m,Ely_ngse_mV_m,Elz_ngse_mV_m,El_ngse_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pp_nPa											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pm_nPa											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pp_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Beta											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxalfven_ngse_km_sec,Vyalfven_ngse_km_sec,Vzalfven_ngse_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	An											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ng											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
			;'cl	Bx_mso_nT,By_mso_nT,Bz_mso_nT								Bx,By,Bz			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
		]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:3DMOMENTS32E">9 3D moments', nomcis, noproduit, SC, tab, NAME3+'_DES_3DMOMENTS32E', 'mms_des', /moments, /notime

		; DISTERRL1B32E
		noproduit = [8]
		arbre = [ arbre, '8 DISTERR 32E res=4.5s ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:DISTERRL1B32E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DES_DISTERRL1B32E', 'mms_des', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																																$
			'9 Particle spectrogram',																																														$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																								$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																											$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																							$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_srvy_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',										$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_srvy_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																				$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta Bresolution=fgm_srvy_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',																	$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_srvy_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-50000 x_max=50000 yleft_auto=Manual yleft_min=-50000 yleft_max=50000 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=500',	$
			'9 Particle plot',																																															$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' legend_theta=No legend_phi=No',																														$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_srvy_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																							$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																							$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																								$
		]

		arbre = [ arbre, '7 l2' ]

		; DES-MOMS FAST L2
		noproduit = [15]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:MOMSL2">8 MOMS res=4.5s', nomcis, noproduit, SC, tab, NAME3+'_DES_MOMSL2', 'mms_des'
		arbre = [ arbre, '</instrument>' ]

		; DES-DIST FAST L2 32E
		noproduit = [16]
		arbre = [ arbre, '8 DIST 32E res=4.5s ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:DISTL232E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DES_DISTL232E', 'mms_des', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																																$
			'9 Particle spectrogram',																																														$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																								$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																											$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																							$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_srvy_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',										$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_srvy_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																				$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta Bresolution=fgm_srvy_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',																	$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_srvy_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-50000 x_max=50000 yleft_auto=Manual yleft_min=-50000 yleft_max=50000 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=500',	$
			'9 Particle plot',																																															$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' legend_theta=No legend_phi=No',																														$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_srvy_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																							$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																							$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																								$
		]

		; 3D MOMENTS
		tab = [	'cl	N_cm3											#  				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Vx_mso_km_sec,Vy_mso_km_sec,Vz_mso_km_sec,*V_km_sec					Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Qx_mso_erg_sec_cm2,Qy_mso_erg_sec_cm2,Qz_mso_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ei_eV_cm3										#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ti_eV											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Ex_mso,Ey_mso,Ez_mso									Ex,Ey,Ez			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxpar_ngse_km_sec,Vypar_ngse_km_sec,Vzpar_ngse_km_sec,*Vpar_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxper_ngse_km_sec,Vyper_ngse_km_sec,Vzper_ngse_km_sec,*Vper_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Elx_ngse_mV_m,Ely_ngse_mV_m,Elz_ngse_mV_m,El_ngse_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pp_nPa											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pm_nPa											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pt_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Beta											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxalfven_ngse_km_sec,Vyalfven_ngse_km_sec,Vzalfven_ngse_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	An											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ng											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
			;'cl	Bx_mso_nT,By_mso_nT,Bz_mso_nT								Bx,By,Bz			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
		]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:3DMOMENTS32E">9 3D moments', nomcis, noproduit, SC, tab, NAME3+'_DES_3DMOMENTS32E', 'mms_des', /moments, /notime

		; DISTERRL1B32E
		noproduit = [17]
		arbre = [ arbre, '8 DISTERR 32E res=4.5s ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DES:DISTERRL232E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DES_DISTERRL232E', 'mms_des', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																																$
			'9 Particle spectrogram',																																														$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																								$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																											$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																							$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_srvy_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',										$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_srvy_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																				$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   Bresolution=fgm_srvy_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',																$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_srvy_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Manual x_min=-50000 x_max=50000 yleft_auto=Manual yleft_min=-50000 yleft_max=50000 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=500',	$
			'9 Particle plot',																																															$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' legend_theta=No legend_phi=No',																														$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_srvy_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																							$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																							$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																								$
		]

	; ---
	; DIS
	; ---
	nomcis = 'MMS-DIS'
	arbre = [ arbre, 															$
		'<instrument name="DIS" id="'+NAME2+':DIS">5 DIS'										]
		arbre = [ arbre, '6 brst' ]
		arbre = [ arbre, '7 l1b (unavailable on clweb)' ]

		; DISTTL1B32E
		noproduit = [3]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:DISTTL1B32E">8 Time of dist', nomcis, noproduit, SC, tab, NAME3+'_DIS_DISTTL1B32E', 'mms_dis'
		arbre = [ arbre, '</instrument>' ]

		; MOMSTL1B
		noproduit = [4]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:MOMSTL1B">8 Time of moms', nomcis, noproduit, SC, tab, NAME3+'_DIS_MOMSTL1B', 'mms_dis'
		arbre = [ arbre, '</instrument>' ]

		; DIS-MOMS BRST L1B
		noproduit = [0]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:MOMSL1B">8 MOMS res=150ms', nomcis, noproduit, SC, tab, NAME3+'_DIS_MOMSL1B', 'mms_dis'
		arbre = [ arbre, '</instrument>' ]

		; DIS-DIST BRST L1B 32E
		noproduit = [1]
		arbre = [ arbre, '8 DIST 32E res=150ms ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:DISTL1B32E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DIS_DISTL1B32E', 'mms_dis', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																				$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																			$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_brst_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Manual yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',						$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_brst_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   Bresolution=fgm_brst_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',												$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_brst_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Automatic yleft_auto=Automatic z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',						$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_brst_l2 cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_brst_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																				$
		]

		; 3D MOMENTS
		tab = [	'cl	N_cm3											#  				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Vx_mso_km_sec,Vy_mso_km_sec,Vz_mso_km_sec,*V_km_sec					Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Qx_mso_erg_sec_cm2,Qy_mso_erg_sec_cm2,Qz_mso_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ei_eV_cm3										#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ti_eV											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Ex_mso,Ey_mso,Ez_mso									Ex,Ey,Ez			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxpar_ngse_km_sec,Vypar_ngse_km_sec,Vzpar_ngse_km_sec,*Vpar_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxper_ngse_km_sec,Vyper_ngse_km_sec,Vzper_ngse_km_sec,*Vper_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Elx_ngse_mV_m,Ely_ngse_mV_m,Elz_ngse_mV_m,El_ngse_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pp_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pm_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pt_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Beta											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxalfven_ngse_km_sec,Vyalfven_ngse_km_sec,Vzalfven_ngse_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	An											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ng											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
			;'cl	Bx_mso_nT,By_mso_nT,Bz_mso_nT								Bx,By,Bz			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
		]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:3DMOMENTS32E">9 3D moments', nomcis, noproduit, SC, tab, NAME3+'_DIS_3DMOMENTS32E', 'mms_dis', /moments, /notime

		; DIS-DIST BRST L1B 64E
		noproduit = [2]
		arbre = [ arbre, '8 DIST 64E res=150ms ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:DISTL1B64E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DIS_DISTL1B64E', 'mms_dis', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																				$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																			$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_brst_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Manual yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',						$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_brst_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   Bresolution=fgm_brst_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',												$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_brst_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Automatic yleft_auto=Automatic z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',						$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_brst_l2 cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_brst_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																				$
		]

		; 3D MOMENTS
		tab = [	'cl	N_cm3											#  				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Vx_mso_km_sec,Vy_mso_km_sec,Vz_mso_km_sec,*V_km_sec					Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Qx_mso_erg_sec_cm2,Qy_mso_erg_sec_cm2,Qz_mso_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ei_eV_cm3										#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ti_eV											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Ex_mso,Ey_mso,Ez_mso									Ex,Ey,Ez			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxpar_ngse_km_sec,Vypar_ngse_km_sec,Vzpar_ngse_km_sec,*Vpar_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxper_ngse_km_sec,Vyper_ngse_km_sec,Vzper_ngse_km_sec,*Vper_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Elx_ngse_mV_m,Ely_ngse_mV_m,Elz_ngse_mV_m,El_ngse_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pp_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pm_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pt_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Beta											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxalfven_ngse_km_sec,Vyalfven_ngse_km_sec,Vzalfven_ngse_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	An											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ng											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
			;'cl	Bx_mso_nT,By_mso_nT,Bz_mso_nT								Bx,By,Bz			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
		]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:3DMOMENTS64E">9 3D moments', nomcis, noproduit, SC, tab, NAME3+'_DIS_3DMOMENTS64E', 'mms_dis', /moments, /notime

		; DISTERRL1B32E
		noproduit = [5]
		arbre = [ arbre, '8 DISTERR 32E res=150ms ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:DISTERRL1B32E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DIS_DISTERRL1B32E', 'mms_dis', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																				$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																			$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_brst_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Manual yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',						$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_brst_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   Bresolution=fgm_brst_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',												$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_brst_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Automatic yleft_auto=Automatic z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',						$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_brst_l2 cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_brst_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																				$
		]

		arbre = [ arbre, '7 l2' ]

		; DISTTL232E
		noproduit = [12]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:DISTTL232E">8 Time of dist', nomcis, noproduit, SC, tab, NAME3+'_DIS_DISTTL232E', 'mms_dis'
		arbre = [ arbre, '</instrument>' ]

		; MOMSTL2
		noproduit = [13]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:MOMSTL2">8 Time of moms', nomcis, noproduit, SC, tab, NAME3+'_DIS_MOMSTL2', 'mms_dis'
		arbre = [ arbre, '</instrument>' ]

		; DIS-MOMS BRST L2
		noproduit = [9]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:MOMSL2">8 MOMS res=150ms', nomcis, noproduit, SC, tab, NAME3+'_DIS_MOMSL2', 'mms_dis'
		arbre = [ arbre, '</instrument>' ]

		; DIS-DIST BRST L2 32E
		noproduit = [10]
		arbre = [ arbre, '8 DIST 32E res=150ms ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:DISTL232E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DIS_DISTL232E', 'mms_dis', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																				$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																			$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_brst_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Manual yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',						$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_brst_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   Bresolution=fgm_brst_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',												$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_brst_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Automatic yleft_auto=Automatic z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',						$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_brst_l2 cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_brst_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																				$
		]

		; 3D MOMENTS
		tab = [	'cl	N_cm3											#  				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Vx_mso_km_sec,Vy_mso_km_sec,Vz_mso_km_sec,*V_km_sec					Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Qx_mso_erg_sec_cm2,Qy_mso_erg_sec_cm2,Qz_mso_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ei_eV_cm3										#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ti_eV											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Ex_mso,Ey_mso,Ez_mso									Ex,Ey,Ez			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxpar_ngse_km_sec,Vypar_ngse_km_sec,Vzpar_ngse_km_sec,*Vpar_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxper_ngse_km_sec,Vyper_ngse_km_sec,Vzper_ngse_km_sec,*Vper_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Elx_ngse_mV_m,Ely_ngse_mV_m,Elz_ngse_mV_m,El_ngse_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pp_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pm_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pt_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Beta											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxalfven_ngse_km_sec,Vyalfven_ngse_km_sec,Vzalfven_ngse_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	An											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ng											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
			;'cl	Bx_mso_nT,By_mso_nT,Bz_mso_nT								Bx,By,Bz			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
		]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:3DMOMENTS32E">9 3D moments', nomcis, noproduit, SC, tab, NAME3+'_DIS_3DMOMENTS32E', 'mms_dis', /moments, /notime

		; DIS-DIST BRST L2 64E
		noproduit = [11]
		arbre = [ arbre, '8 DIST 64E res=150ms ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:DISTL264E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DIS_DISTL264E', 'mms_dis', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																				$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																			$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_brst_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Manual yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',						$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_brst_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   Bresolution=fgm_brst_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',												$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_brst_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Automatic yleft_auto=Automatic z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',						$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_brst_l2 cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_brst_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																				$
		]

		; 3D MOMENTS
		tab = [	'cl	N_cm3											#  				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Vx_mso_km_sec,Vy_mso_km_sec,Vz_mso_km_sec,*V_km_sec					Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Qx_mso_erg_sec_cm2,Qy_mso_erg_sec_cm2,Qz_mso_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ei_eV_cm3										#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ti_eV											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Ex_mso,Ey_mso,Ez_mso									Ex,Ey,Ez			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxpar_ngse_km_sec,Vypar_ngse_km_sec,Vzpar_ngse_km_sec,*Vpar_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxper_ngse_km_sec,Vyper_ngse_km_sec,Vzper_ngse_km_sec,*Vper_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Elx_ngse_mV_m,Ely_ngse_mV_m,Elz_ngse_mV_m,El_ngse_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pp_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pm_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pt_nPa											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Beta											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxalfven_ngse_km_sec,Vyalfven_ngse_km_sec,Vzalfven_ngse_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	An											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ng											#				count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
			;'cl	Bx_mso_nT,By_mso_nT,Bz_mso_nT								Bx,By,Bz			count2d Bresolution=fgm_brst_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
		]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:3DMOMENTS64E">9 3D moments', nomcis, noproduit, SC, tab, NAME3+'_DIS_3DMOMENTS64E', 'mms_dis', /moments, /notime

		; DISTERRL232E
		noproduit = [14]
		arbre = [ arbre, '8 DISTERR 32E res=150ms ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:DISTERRL232E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DIS_DISTERRL232E', 'mms_dis', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																				$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_brst_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																			$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_brst_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Manual yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',						$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_brst_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   Bresolution=fgm_brst_l2 cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',												$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_brst_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Automatic yleft_auto=Automatic z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',						$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_brst_l2 cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_brst_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_brst_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																				$
		]

		arbre = [ arbre, '6 fast' ]
		arbre = [ arbre, '7 l1b (unavailable on clweb)' ]

		; DIS-MOMS FAST L1B
		noproduit = [6]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:MOMSL1B">8 MOMS res=4.5s', nomcis, noproduit, SC, tab, NAME3+'_DIS_MOMSL1B', 'mms_dis'
		arbre = [ arbre, '</instrument>' ]

		; DIS-DIST FAST L1B 32E
		noproduit = [7]
		arbre = [ arbre, '8 DIST 32E res=4.5s ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:DISTL1B32E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DIS_DISTL1B32E', 'mms_dis', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																				$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																			$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_srvy_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Manual yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',						$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_srvy_l2  pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   cjf='+unite+' Bresolution=fgm_srvy_l2 moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',												$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_srvy_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Automatic yleft_auto=Automatic z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',						$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_srvy_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																				$
		]

		; 3D MOMENTS
		tab = [	'cl	N_cm3											#  				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Vx_mso_km_sec,Vy_mso_km_sec,Vz_mso_km_sec,*V_km_sec					Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Qx_mso_erg_sec_cm2,Qy_mso_erg_sec_cm2,Qz_mso_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ei_eV_cm3										#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ti_eV											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Ex_mso,Ey_mso,Ez_mso									Ex,Ey,Ez			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxpar_ngse_km_sec,Vypar_ngse_km_sec,Vzpar_ngse_km_sec,*Vpar_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxper_ngse_km_sec,Vyper_ngse_km_sec,Vzper_ngse_km_sec,*Vper_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Elx_ngse_mV_m,Ely_ngse_mV_m,Elz_ngse_mV_m,El_ngse_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pp_nPa											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pm_nPa											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pt_nPa											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Beta											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxalfven_ngse_km_sec,Vyalfven_ngse_km_sec,Vzalfven_ngse_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	An											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ng											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
			;'cl	Bx_mso_nT,By_mso_nT,Bz_mso_nT								Bx,By,Bz			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
		]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:3DMOMENTS32E">9 3D moments', nomcis, noproduit, SC, tab, NAME3+'_DIS_3DMOMENTS32E', 'mms_dis', /moments, /notime

		; DISTERRL1B32E
		noproduit = [8]
		arbre = [ arbre, '8 DISTERR 32E res=4.5s ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:DISTERRL1B32E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DIS_DISTERRL1B32E', 'mms_dis', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																				$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																			$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_srvy_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Manual yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',						$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_srvy_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   cjf='+unite+' Bresolution=fgm_srvy_l2 moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',												$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_srvy_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Automatic yleft_auto=Automatic z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',						$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_srvy_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																				$
		]

		arbre = [ arbre, '7 l2' ]

		; DIS-MOMS FAST L2
		noproduit = [15]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:MOMSL2">8 MOMS res=4.5s', nomcis, noproduit, SC, tab, NAME3+'_DIS_MOMSL2', 'mms_dis'
		arbre = [ arbre, '</instrument>' ]

		; DIS-DIST FAST L2 32E
		noproduit = [16]
		arbre = [ arbre, '8 DIST 32E res=4.5s ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:DISTL232E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DIS_DISTL232E', 'mms_dis', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																				$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																			$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_srvy_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Manual yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',						$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_srvy_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   cjf='+unite+' Bresolution=fgm_srvy_l2 moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',												$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_srvy_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Automatic yleft_auto=Automatic z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',						$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_srvy_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																				$
		]

		; 3D MOMENTS
		tab = [	'cl	N_cm3											#  				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec							Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Vx_mso_km_sec,Vy_mso_km_sec,Vz_mso_km_sec,*V_km_sec					Vx,Vy,Vz,|V| 			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3							Ppar,Pper1,Pper2 		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3						Ppar,Pper1,Pper2 		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_eV,Tper1_eV,Tper2_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV								Tpar,Tper1,Tper2 		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2				Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Qx_mso_erg_sec_cm2,Qy_mso_erg_sec_cm2,Qz_mso_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qpar|	count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2			Qxpar,Qypar,Qzpar,|Qper|	count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3			Pxx,Pxy,Pxz,Pyy,Pyz,Pzz		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ei_eV_cm3										#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ti_eV											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ex,Ey,Ez										Ex,Ey,Ez			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			;'cl	Ex_mso,Ey_mso,Ez_mso									Ex,Ey,Ez			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxpar_ngse_km_sec,Vypar_ngse_km_sec,Vzpar_ngse_km_sec,*Vpar_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxper_ngse_km_sec,Vyper_ngse_km_sec,Vzper_ngse_km_sec,*Vper_ngse_km_sec			Vx,Vy,Vz,|V|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Elx_ngse_mV_m,Ely_ngse_mV_m,Elz_ngse_mV_m,El_ngse_mV_m					Elx,Ely,Elz,|El|		count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pp_nPa											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pm_nPa											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Pt_nPa											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Beta											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Vxalfven_ngse_km_sec,Vyalfven_ngse_km_sec,Vzalfven_ngse_km_sec,*Valfven_km_sec		Vx,Vy,Vz,[V|			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	An											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Ng											#				count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual',				$
			'cl	Bx_nT,By_nT,Bz_nT									Bx,By,Bz			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
			;'cl	Bx_mso_nT,By_mso_nT,Bz_mso_nT								Bx,By,Bz			count2d Bresolution=fgm_srvy_l2 type=moments ion_nochamp=H+ emin_=1 emax_=1000000 legend_theta=No legend_phi=No spacecraft_potential_auto=Automatic bulk_speed_auto=Manual'				$
		]
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:3DMOMENTS32E">9 3D moments', nomcis, noproduit, SC, tab, NAME3+'_DIS_3DMOMENTS32E', 'mms_dis', /moments, /notime

		; DISTERRL1B32E
		noproduit = [17]
		arbre = [ arbre, '8 DISTERR 32E res=4.5s ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		; "Timeseries"
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':DIS:DISTERRL1B32E">9 Timeseries', nomcis, noproduit, SC, tab, NAME3+'_DIS_DISTERRL1B32E', 'mms_dis', /notime

		; "Particle spectrogram" et "Particle plot"
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'9 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																				$
				'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta  Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
				'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi    Bresolution=fgm_srvy_l2 cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																			$
				'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle Bresolution=fgm_srvy_l2 cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Manual yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=100 emax_nochamp=100',						$
				'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle Bresolution=fgm_srvy_l2 pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																$
				'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta   cjf='+unite+' Bresolution=fgm_srvy_l2 moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Manual x_min=0 x_max=360 z_showdir=No z_theta=No z_phi=No',												$
				'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=fgm_srvy_l2 log0use=No cjf='+unite+' width_nochamp=0 interp_nochamp=None x_auto=Automatic yleft_auto=Automatic z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No',						$
			'9 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_srvy_l2 cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf Bresolution=fgm_srvy_l2 cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																				$
		]

	; ---
	; HPCA
	; ---
	nomcis = 'MMS-HPCA'
	arbre = [ arbre, 																$
		'<instrument name="HPCA" id="'+NAME2+':HPCA">4 HPCA'											]

		arbre = [ arbre, '5 brst' ]
		arbre = [ arbre, '6 l2' ]

		; moments
		noproduit = [6]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':HPCA:BRST_L2">7 moments', nomcis, noproduit, SC, tab, NAME3+'_HPCA_BRST_L2_MOMENTS', 'mms_hpca'

		; ion_ts
		noproduit = [7]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':HPCA:BRST_L2">7 ion_ts', nomcis, noproduit, SC, tab, NAME3+'_HPCA_BRST_L2_ION_TS', 'mms_hpca'

		noproduit = [8]
		arbre = [ arbre, '7 H+ ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'8 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d ion_nochamp=H+ type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'8 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=H+ type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=H+ type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=H+ type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		noproduit = [9]
		arbre = [ arbre, '7 He+ ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'8 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d ion_nochamp=He+ type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'8 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=He+ type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=He+ type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=He+ type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		noproduit = [10]
		arbre = [ arbre, '7 He++ ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'8 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d ion_nochamp=He++ type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'8 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=He++ type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=He++ type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=He++ type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		noproduit = [11]
		arbre = [ arbre, '7 O+ ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'8 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d ion_nochamp=O+ type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'8 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=O+ type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=O+ type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=O+ type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		arbre = [ arbre, '5 srvy' ]
		arbre = [ arbre, '6 l2' ]

		; moments
		noproduit = [0]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':HPCA:SRVY_L2">7 moments', nomcis, noproduit, SC, tab, NAME3+'_HPCA_SRVY_L2_MOMENTS', 'mms_hpca'

		; ion_ts
		noproduit = [1]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':HPCA:SRVY_L2">7 ion_ts', nomcis, noproduit, SC, tab, NAME3+'_HPCA_SRVY_L2_ION_TS', 'mms_hpca'

		noproduit = [2]
		arbre = [ arbre, '7 H+ ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'8 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d ion_nochamp=H+ type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'8 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=H+ type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=H+ type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=H+ type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		noproduit = [3]
		arbre = [ arbre, '7 He+ ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'8 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d ion_nochamp=He+ type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'8 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=He+ type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=He+ type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=He+ type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		noproduit = [4]
		arbre = [ arbre, '7 He++ ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'8 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d ion_nochamp=He++ type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'8 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=He++ type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=He++ type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=He++ type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

		noproduit = [5]
		arbre = [ arbre, '7 O+ ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC)]
		unite = 'fdist->fdist'
		nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+SC
		arbre = [ arbre, 																																												$
			'8 Particle spectrogram',																																										$
				'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d ion_nochamp=O+ type=time_energy cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																							$
			'8 Particle plot',																																											$
				'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=O+ type=time_cjf cjf='+unite+' legend_theta=No legend_phi=No',																										$
				'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=O+ type=energy_cjf cjf='+unite+'                                        legend_theta=No legend_phi=No x_auto=Automatic',																			$
				'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d ion_nochamp=O+ type=energy_cjf cjf='+unite+' spinaccu=0 time_onespin=No x_dx=5000.0 legend_theta=No legend_phi=No x_auto=Automatic'																			$
		]

	; --
	; SCM
	; --
	nomcis = 'MMS-SCM'
	arbre = [ arbre, 																$
		'<instrument name="SCM" id="'+NAME2+':SCM">4 SCM'											]

		arbre = [ arbre, '5 brst' ]
		arbre = [ arbre, '6 l2' ]

		; schb
		noproduit = [0]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':SCM:BRST_L2_SCHB">7 schb', nomcis, noproduit, SC, tab, NAME3+'_SCM_BRST_L2_SCHB', 'mms_scm'

		; scb
		noproduit = [1]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':SCM:BRST_L2_SCB">7 scb', nomcis, noproduit, SC, tab, NAME3+'_SCM_BRST_L2_SCB', 'mms_scm'

		arbre = [ arbre, '5 comm' ]
		arbre = [ arbre, '6 l2' ]

		; sc128
		noproduit = [2]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':SCM:COMM_L2_SC128">7 sc128', nomcis, noproduit, SC, tab, NAME3+'_SCM_COMM_L2_SC128', 'mms_scm'

		; sc256
		noproduit = [3]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':SCM:COMM_L2_SC256">7 sc256', nomcis, noproduit, SC, tab, NAME3+'_SCM_COMM_L2_SC256', 'mms_scm'

		arbre = [ arbre, '5 fast' ]
		arbre = [ arbre, '6 l2' ]

		; scf
		noproduit = [4]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':SCM:FAST_L2_SCF">7 scf', nomcis, noproduit, SC, tab, NAME3+'_SCM_FAST_L2_SCF', 'mms_scm'

		arbre = [ arbre, '5 slow' ]
		arbre = [ arbre, '6 l2' ]

		; scs
		noproduit = [5]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':SCM:SLOW_L2_SCS">7 scs', nomcis, noproduit, SC, tab, NAME3+'_SCM_SLOW_L2_SCS', 'mms_scm'

		arbre = [ arbre, '5 srvy' ]
		arbre = [ arbre, '6 l2' ]

		; scsrvy
		noproduit = [6]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="'+NAME2+':SCM:SRVY_L2_SCSRVY">7 scsrvy', nomcis, noproduit, SC, tab, NAME3+'_SCM_SRVY_L2_SCSRVY', 'mms_scm'

	; -------
	; Current
	; -------
	arbre = [ arbre, '4 Current' ]

	IF SC EQ "SC1" THEN BEGIN
		arbre = [ arbre, '5 Precomputed Curlometer' ]
		arbre = [ arbre, '6 fgm' ]

			arbre = [ arbre, '7 brst' ]
				nomcis = 'MMS-FGM'
				noproduit = 4
				arbre = [ arbre, 																						$
					'8 l2 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																$
						'0 Jx,Jy,Jz,J GSE#'                 + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 header',			$
						'0 Jx,Jy,Jz,J GSM#'                 + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 header',			$
						'0 div_T_m#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' div_T_m header',							$
						'0 Jxpar,Jypar,Jzpar,Jpar GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 header',	$
						'0 Jxpar,Jypar,Jzpar,Jpar GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 header',	$
						'0 Jxper,Jyper,Jzper,Jper GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 header',	$
						'0 Jxper,Jyper,Jzper,Jper GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 header',	$
						'0 gBx,gBy,gBz,gB GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBx_gse_T_m,gBy_gse_T_m,gBz_gse_T_m,gB_T_m header',			$
						'0 gBx,gBy,gBz,gB GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBx_gsm_T_m,gBy_gsm_T_m,gBz_gsm_T_m,gB_T_m header',			$
						'0 gBxpar,gBypar,gBzpar,gBpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxpar_gse_T_m,gBypar_gse_T_m,gBzpar_gse_T_m,gBpar_T_m header',	$
						'0 gBxpar,gBypar,gBzpar,gBpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxpar_gsm_T_m,gBypar_gsm_T_m,gBzpar_gsm_T_m,gBpar_T_m header',	$
						'0 gBxper,gByper,gBzper,gBper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxper_gse_T_m,gByper_gse_T_m,gBzper_gse_T_m,gBper_T_m header',	$
						'0 gBxper,gByper,gBzper,gBper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxper_gsm_T_m,gByper_gsm_T_m,gBzper_gsm_T_m,gBper_T_m header',	$
						'0 dedsx,dedsy,desdz,deds GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dedsx_gse_T_m,dedsy_gse_T_m,dedsz_gse_T_m,deds_T_m header',		$
						'0 dedsx,dedsy,desdz,deds GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dedsx_gsm_T_m,dedsy_gsm_T_m,dedsz_gsm_T_m,deds_T_m header',		$
						'0 dBx_dx#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBx_dx_T_m header',							$
						'0 dBx_dy#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBx_dy_T_m header',							$
						'0 dBx_dz#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBx_dz_T_m header',							$
						'0 dBy_dx#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBy_dx_T_m header',							$
						'0 dBy_dy#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBy_dy_T_m header',							$
						'0 dBy_dz#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBy_dz_T_m header',							$
						'0 dBz_dx#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBz_dx_T_m header',							$
						'0 dBz_dy#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBz_dy_T_m header',							$
						'0 dBz_dz#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBz_dz_T_m header',							$
						'0 Rc#'                             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rc_rt header',							$
						'0 Rcx,Rcy,Rcz GSE#'                + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rcx_gse_rt,Rcy_gse_rt,Rcz_gse_rt header'				]
				nomcis = 'MMS-FGM'
				noproduit = 6
				arbre = [ arbre, 																				$
					'8 jmax_5m ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),													$
						'0 Jx,Jy,Jz,J GSE#'                 + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse,jy_gse,jz_gse,j header',			$
						'0 Jx,Jy,Jz,J GSM#'                 + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm,jy_gsm,jz_gsm,j header',			$
						'0 div#'                            + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' div header',						$
						'0 Jxpar,Jypar,Jzpar,Jpar GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse,jypar_gse,jzpar_gse,jpar header',		$
						'0 Jxpar,Jypar,Jzpar,Jpar GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm,jypar_gsm,jzpar_gsm,jpar header',		$
						'0 Jxper,Jyper,Jzper,Jper GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse,jyper_gse,jzper_gse,jper header',		$
						'0 Jxper,Jyper,Jzper,Jper GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm,jyper_gsm,jzper_gsm,jper header',		$
						'0 X,Y,Z GSE#'		            + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' xgse,ygse,zgse header',				$
						'0 X,Y,Z GSM#'		            + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' xgsm,ygsm,zgsm header',				$
						'0 dr#'		                    + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dr header'						]


			arbre = [ arbre, '7 srvy' ]
				nomcis = 'MMS-FGM'
				noproduit = 5 
				arbre = [ arbre, 																						$
					'8 l2 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																$
						'0 Jx,Jy,Jz,J GSE#'                 + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 header',			$
						'0 Jx,Jy,Jz,J GSM#'                 + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 header',			$
						'0 div_T_m#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' div_T_m header',							$
						'0 Jxpar,Jypar,Jzpar,Jpar GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 header',	$
						'0 Jxpar,Jypar,Jzpar,Jpar GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 header',	$
						'0 Jxper,Jyper,Jzper,Jper GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 header',	$
						'0 Jxper,Jyper,Jzper,Jper GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 header',	$
						'0 gBx,gBy,gBz,gB GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBx_gse_T_m,gBy_gse_T_m,gBz_gse_T_m,gB_T_m header',			$
						'0 gBx,gBy,gBz,gB GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBx_gsm_T_m,gBy_gsm_T_m,gBz_gsm_T_m,gB_T_m header',			$
						'0 gBxpar,gBypar,gBzpar,gBpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxpar_gse_T_m,gBypar_gse_T_m,gBzpar_gse_T_m,gBpar_T_m header',	$
						'0 gBxpar,gBypar,gBzpar,gBpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxpar_gsm_T_m,gBypar_gsm_T_m,gBzpar_gsm_T_m,gBpar_T_m header',	$
						'0 gBxper,gByper,gBzper,gBper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxper_gse_T_m,gByper_gse_T_m,gBzper_gse_T_m,gBper_T_m header',	$
						'0 gBxper,gByper,gBzper,gBper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxper_gsm_T_m,gByper_gsm_T_m,gBzper_gsm_T_m,gBper_T_m header',	$
						'0 dedsx,dedsy,desdz,deds GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dedsx_gse_T_m,dedsy_gse_T_m,dedsz_gse_T_m,deds_T_m header',		$
						'0 dedsx,dedsy,desdz,deds GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dedsx_gsm_T_m,dedsy_gsm_T_m,dedsz_gsm_T_m,deds_T_m header',		$
						'0 dBx_dx#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBx_dx_T_m header',							$
						'0 dBx_dy#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBx_dy_T_m header',							$
						'0 dBx_dz#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBx_dz_T_m header',							$
						'0 dBy_dx#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBy_dx_T_m header',							$
						'0 dBy_dy#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBy_dy_T_m header',							$
						'0 dBy_dz#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBy_dz_T_m header',							$
						'0 dBz_dx#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBz_dx_T_m header',							$
						'0 dBz_dy#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBz_dy_T_m header',							$
						'0 dBz_dz#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBz_dz_T_m header',							$
						'0 Rc#'                             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rc_rt header',							$
						'0 Rcx,Rcy,Rcz GSE#'                + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rcx_gse_rt,Rcy_gse_rt,Rcz_gse_rt header'				]
				nomcis = 'MMS-FGM'
				noproduit = 7
				arbre = [ arbre, 																				$
					'8 jmax_5m ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),													$
						'0 Jx,Jy,Jz,J GSE#'                 + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse,jy_gse,jz_gse,j header',			$
						'0 Jx,Jy,Jz,J GSM#'                 + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm,jy_gsm,jz_gsm,j header',			$
						'0 div#'                            + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' div header',						$
						'0 Jxpar,Jypar,Jzpar,Jpar GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse,jypar_gse,jzpar_gse,jpar header',		$
						'0 Jxpar,Jypar,Jzpar,Jpar GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm,jypar_gsm,jzpar_gsm,jpar header',		$
						'0 Jxper,Jyper,Jzper,Jper GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse,jyper_gse,jzper_gse,jper header',		$
						'0 Jxper,Jyper,Jzper,Jper GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm,jyper_gsm,jzper_gsm,jper header',		$
						'0 X,Y,Z GSE#'		            + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' xgse,ygse,zgse header',				$
						'0 X,Y,Z GSM#'		            + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' xgsm,ygsm,zgsm header',				$
						'0 dr#'		                    + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dr header'						]
	END

	arbre = [ arbre, '5 Curlometer' ]
		arbre = [ arbre, '6 dfg' ]

			arbre = [ arbre, '7 brst' ]
				nomcis = 'MMS-DFG'
				noproduit = 16
				arbre = [ arbre, 																						$
					'8 l2pre ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),															$
						'0 Jx,Jy,Jz,J GSE#'                 + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 current',			$
						'0 Jx,Jy,Jz,J GSM#'                 + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 current',			$
						'0 div_T_m#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' div_T_m current',							$
						'0 Jxpar,Jypar,Jzpar,Jpar GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 current',	$
						'0 Jxpar,Jypar,Jzpar,Jpar GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 current',	$
						'0 Jxper,Jyper,Jzper,Jper GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 current',	$
						'0 Jxper,Jyper,Jzper,Jper GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 current',	$
						'0 gBx,gBy,gBz,gB GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBx_gse_T_m,gBy_gse_T_m,gBz_gse_T_m,gB_T_m current',			$
						'0 gBx,gBy,gBz,gB GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBx_gsm_T_m,gBy_gsm_T_m,gBz_gsm_T_m,gB_T_m current',			$
						'0 gBxpar,gBypar,gBzpar,gBpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxpar_gse_T_m,gBypar_gse_T_m,gBzpar_gse_T_m,gBpar_T_m current',	$
						'0 gBxpar,gBypar,gBzpar,gBpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxpar_gsm_T_m,gBypar_gsm_T_m,gBzpar_gsm_T_m,gBpar_T_m current',	$
						'0 gBxper,gByper,gBzper,gBper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxper_gse_T_m,gByper_gse_T_m,gBzper_gse_T_m,gBper_T_m current',	$
						'0 gBxper,gByper,gBzper,gBper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxper_gsm_T_m,gByper_gsm_T_m,gBzper_gsm_T_m,gBper_T_m current',	$
						'0 dedsx,dedsy,desdz,deds GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dedsx_gse_T_m,dedsy_gse_T_m,dedsz_gse_T_m,deds_T_m current',		$
						'0 dedsx,dedsy,desdz,deds GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dedsx_gsm_T_m,dedsy_gsm_T_m,dedsz_gsm_T_m,deds_T_m current',		$
						'0 dBx_dx#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBx_dx_T_m current',							$
						'0 dBx_dy#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBx_dy_T_m current',							$
						'0 dBx_dz#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBx_dz_T_m current',							$
						'0 dBy_dx#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBy_dx_T_m current',							$
						'0 dBy_dy#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBy_dy_T_m current',							$
						'0 dBy_dz#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBy_dz_T_m current',							$
						'0 dBz_dx#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBz_dx_T_m current',							$
						'0 dBz_dy#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBz_dy_T_m current',							$
						'0 dBz_dz#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBz_dz_T_m current',							$
						'0 Rc#'                             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rc_rt current',							$
						'0 Rc_lower#'                       + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rc_lower_rt current',						$
						'0 Rc_upper#'                       + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rc_upper_rt current',						$
						'0 Rcx,Rcy,Rcz GSE#'                + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rcx_gse_rt,Rcy_gse_rt,Rcz_gse_rt current',				$
						'0 Curv#'                           + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Curv current',							$
						'0 Curvx,Curvy,Curvz#'              + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Curvx,Curvy,Curvz current'						]

			arbre = [ arbre, '7 srvy' ]
				nomcis = 'MMS-DFG'
				noproduit = 14 
				arbre = [ arbre, 																						$
					'8 l2pre ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),															$
						'0 Jx,Jy,Jz,J GSE#'                 + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 current',			$
						'0 Jx,Jy,Jz,J GSM#'                 + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 current',			$
						'0 div_T_m#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' div_T_m current',							$
						'0 Jxpar,Jypar,Jzpar,Jpar GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 current',	$
						'0 Jxpar,Jypar,Jzpar,Jpar GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 current',	$
						'0 Jxper,Jyper,Jzper,Jper GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 current',	$
						'0 Jxper,Jyper,Jzper,Jper GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 current',	$
						'0 gBx,gBy,gBz,gB GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBx_gse_T_m,gBy_gse_T_m,gBz_gse_T_m,gB_T_m current',			$
						'0 gBx,gBy,gBz,gB GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBx_gsm_T_m,gBy_gsm_T_m,gBz_gsm_T_m,gB_T_m current',			$
						'0 gBxpar,gBypar,gBzpar,gBpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxpar_gse_T_m,gBypar_gse_T_m,gBzpar_gse_T_m,gBpar_T_m current',	$
						'0 gBxpar,gBypar,gBzpar,gBpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxpar_gsm_T_m,gBypar_gsm_T_m,gBzpar_gsm_T_m,gBpar_T_m current',	$
						'0 gBxper,gByper,gBzper,gBper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxper_gse_T_m,gByper_gse_T_m,gBzper_gse_T_m,gBper_T_m current',	$
						'0 gBxper,gByper,gBzper,gBper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxper_gsm_T_m,gByper_gsm_T_m,gBzper_gsm_T_m,gBper_T_m current',	$
						'0 dedsx,dedsy,desdz,deds GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dedsx_gse_T_m,dedsy_gse_T_m,dedsz_gse_T_m,deds_T_m current',		$
						'0 dedsx,dedsy,desdz,deds GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dedsx_gsm_T_m,dedsy_gsm_T_m,dedsz_gsm_T_m,deds_T_m current',		$
						'0 dBx_dx#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBx_dx_T_m current',							$
						'0 dBx_dy#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBx_dy_T_m current',							$
						'0 dBx_dz#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBx_dz_T_m current',							$
						'0 dBy_dx#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBy_dx_T_m current',							$
						'0 dBy_dy#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBy_dy_T_m current',							$
						'0 dBy_dz#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBy_dz_T_m current',							$
						'0 dBz_dx#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBz_dx_T_m current',							$
						'0 dBz_dy#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBz_dy_T_m current',							$
						'0 dBz_dz#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBz_dz_T_m current',							$
						'0 Rc#'                             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rc_rt current',							$
						'0 Rc_lower#'                       + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rc_lower_rt current',						$
						'0 Rc_upper#'                       + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rc_upper_rt current',						$
						'0 Rcx,Rcy,Rcz GSE#'                + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rcx_gse_rt,Rcy_gse_rt,Rcz_gse_rt current',				$
						'0 Curv#'                           + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Curv current',							$
						'0 Curvx,Curvy,Curvz#'              + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Curvx,Curvy,Curvz current'						]

		arbre = [ arbre, '6 fgm' ]

			arbre = [ arbre, '7 brst' ]
				nomcis = 'MMS-FGM'
				noproduit = 0
				arbre = [ arbre, 																						$
					'8 l2 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																$
						'0 Jx,Jy,Jz,J GSE#'                 + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 current',			$
						'0 Jx,Jy,Jz,J GSM#'                 + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 current',			$
						'0 div_T_m#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' div_T_m current',							$
						'0 Jxpar,Jypar,Jzpar,Jpar GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 current',	$
						'0 Jxpar,Jypar,Jzpar,Jpar GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 current',	$
						'0 Jxper,Jyper,Jzper,Jper GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 current',	$
						'0 Jxper,Jyper,Jzper,Jper GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 current',	$
						'0 gBx,gBy,gBz,gB GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBx_gse_T_m,gBy_gse_T_m,gBz_gse_T_m,gB_T_m current',			$
						'0 gBx,gBy,gBz,gB GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBx_gsm_T_m,gBy_gsm_T_m,gBz_gsm_T_m,gB_T_m current',			$
						'0 gBxpar,gBypar,gBzpar,gBpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxpar_gse_T_m,gBypar_gse_T_m,gBzpar_gse_T_m,gBpar_T_m current',	$
						'0 gBxpar,gBypar,gBzpar,gBpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxpar_gsm_T_m,gBypar_gsm_T_m,gBzpar_gsm_T_m,gBpar_T_m current',	$
						'0 gBxper,gByper,gBzper,gBper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxper_gse_T_m,gByper_gse_T_m,gBzper_gse_T_m,gBper_T_m current',	$
						'0 gBxper,gByper,gBzper,gBper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxper_gsm_T_m,gByper_gsm_T_m,gBzper_gsm_T_m,gBper_T_m current',	$
						'0 dedsx,dedsy,desdz,deds GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dedsx_gse_T_m,dedsy_gse_T_m,dedsz_gse_T_m,deds_T_m current',		$
						'0 dedsx,dedsy,desdz,deds GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dedsx_gsm_T_m,dedsy_gsm_T_m,dedsz_gsm_T_m,deds_T_m current',		$
						'0 dBx_dx#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBx_dx_T_m current',							$
						'0 dBx_dy#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBx_dy_T_m current',							$
						'0 dBx_dz#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBx_dz_T_m current',							$
						'0 dBy_dx#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBy_dx_T_m current',							$
						'0 dBy_dy#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBy_dy_T_m current',							$
						'0 dBy_dz#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBy_dz_T_m current',							$
						'0 dBz_dx#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBz_dx_T_m current',							$
						'0 dBz_dy#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBz_dy_T_m current',							$
						'0 dBz_dz#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBz_dz_T_m current',							$
						'0 Rc#'                             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rc_rt current',							$
						'0 Rc_lower#'                       + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rc_lower_rt current',						$
						'0 Rc_upper#'                       + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rc_upper_rt current',						$
						'0 Rcx,Rcy,Rcz GSE#'                + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rcx_gse_rt,Rcy_gse_rt,Rcz_gse_rt current',				$
						'0 Curv#'                           + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Curv current',							$
						'0 Curvx,Curvy,Curvz#'              + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Curvx,Curvy,Curvz current',						$
						'0 MDD_planarity,MDD_elongation#'   + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' MDD_planarity,MDD_elongation current',				$
						'0 MDD_sig_min,MDD_sig_med,MDD_sig_max#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' MDD_sig_min,MDD_sig_med,MDD_sig_max current'						]

			arbre = [ arbre, '7 srvy' ]
				nomcis = 'MMS-FGM'
				noproduit = 2 
				arbre = [ arbre, 																						$
					'8 l2 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																$
						'0 Jx,Jy,Jz,J GSE#'                 + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 current',			$
						'0 Jx,Jy,Jz,J GSM#'                 + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 current',			$
						'0 div_T_m#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' div_T_m current',							$
						'0 Jxpar,Jypar,Jzpar,Jpar GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 current',	$
						'0 Jxpar,Jypar,Jzpar,Jpar GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 current',	$
						'0 Jxper,Jyper,Jzper,Jper GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 current',	$
						'0 Jxper,Jyper,Jzper,Jper GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 current',	$
						'0 gBx,gBy,gBz,gB GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBx_gse_T_m,gBy_gse_T_m,gBz_gse_T_m,gB_T_m current',			$
						'0 gBx,gBy,gBz,gB GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBx_gsm_T_m,gBy_gsm_T_m,gBz_gsm_T_m,gB_T_m current',			$
						'0 gBxpar,gBypar,gBzpar,gBpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxpar_gse_T_m,gBypar_gse_T_m,gBzpar_gse_T_m,gBpar_T_m current',	$
						'0 gBxpar,gBypar,gBzpar,gBpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxpar_gsm_T_m,gBypar_gsm_T_m,gBzpar_gsm_T_m,gBpar_T_m current',	$
						'0 gBxper,gByper,gBzper,gBper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxper_gse_T_m,gByper_gse_T_m,gBzper_gse_T_m,gBper_T_m current',	$
						'0 gBxper,gByper,gBzper,gBper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gBxper_gsm_T_m,gByper_gsm_T_m,gBzper_gsm_T_m,gBper_T_m current',	$
						'0 dedsx,dedsy,desdz,deds GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dedsx_gse_T_m,dedsy_gse_T_m,dedsz_gse_T_m,deds_T_m current',		$
						'0 dedsx,dedsy,desdz,deds GSM#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dedsx_gsm_T_m,dedsy_gsm_T_m,dedsz_gsm_T_m,deds_T_m current',		$
						'0 dBx_dx#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBx_dx_T_m current',							$
						'0 dBx_dy#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBx_dy_T_m current',							$
						'0 dBx_dz#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBx_dz_T_m current',							$
						'0 dBy_dx#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBy_dx_T_m current',							$
						'0 dBy_dy#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBy_dy_T_m current',							$
						'0 dBy_dz#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBy_dz_T_m current',							$
						'0 dBz_dx#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBz_dx_T_m current',							$
						'0 dBz_dy#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBz_dy_T_m current',							$
						'0 dBz_dz#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' dBz_dz_T_m current',							$
						'0 Rc#'                             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rc_rt current',							$
						'0 Rc_lower#'                       + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rc_lower_rt current',						$
						'0 Rc_upper#'                       + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rc_upper_rt current',						$
						'0 Rcx,Rcy,Rcz GSE#'                + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Rcx_gse_rt,Rcy_gse_rt,Rcz_gse_rt current',				$
						'0 Curv#'                           + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Curv current',							$
						'0 Curvx,Curvy,Curvz#'              + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' Curvx,Curvy,Curvz current'						]

	arbre = [ arbre, '5 fpi_nq(vi-ve)' ]
		arbre = [ arbre, '6 brst' ]
			arbre = [ arbre, '7 l1b' ]
				arbre = [ arbre, '8 dfg' ]
					nomcis = 'MMS-DES'
					Bresolution = 'dfg_brst_l2pre'
					noproduit = 0
					arbre = [ arbre, 																															$
						'9 res=' + STRLOWCASE(NAME1) + '_des ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																					$
							'0 Jx,Jy,Jz,J GSE#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jx,Jy,Jz,J GSM#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jxpar,Jypar,Jzpar,Jpar GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxpar,Jypar,Jzpar,Jpar GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gse_A_m2,javg4scy_gse_A_m2,javg4scz_gse_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gsm_A_m2,javg4scy_gsm_A_m2,javg4scz_gsm_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gse_A_m2,javg4scypar_gse_A_m2,javg4sczpar_gse_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gsm_A_m2,javg4scypar_gsm_A_m2,javg4sczpar_gsm_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gse_A_m2,javg4scyper_gse_A_m2,javg4sczper_gse_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gsm_A_m2,javg4scyper_gsm_A_m2,javg4sczper_gsm_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution	]
					nomcis = 'MMS-DIS'
					Bresolution = 'dfg_brst_l2pre'
					noproduit = 0
					arbre = [ arbre, 																												$
						'9 res=' + STRLOWCASE(NAME1) + '_dis ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																			$
							'0 Jx,Jy,Jz,J GSE#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jx,Jy,Jz,J GSM#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jxpar,Jypar,Jzpar,Jpar GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxpar,Jypar,Jzpar,Jpar GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gse_A_m2,javg4scy_gse_A_m2,javg4scz_gse_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gsm_A_m2,javg4scy_gsm_A_m2,javg4scz_gsm_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gse_A_m2,javg4scypar_gse_A_m2,javg4sczpar_gse_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gsm_A_m2,javg4scypar_gsm_A_m2,javg4sczpar_gsm_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gse_A_m2,javg4scyper_gse_A_m2,javg4sczper_gse_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gsm_A_m2,javg4scyper_gsm_A_m2,javg4sczper_gsm_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution	]
				arbre = [ arbre, '8 fgm' ]
					nomcis = 'MMS-DES'
					Bresolution = 'fgm_brst_l2'
					noproduit = 0
					arbre = [ arbre, 																															$
						'9 res=' + STRLOWCASE(NAME1) + '_des ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																					$
							'0 Jx,Jy,Jz,J GSE#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jx,Jy,Jz,J GSM#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jxpar,Jypar,Jzpar,Jpar GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxpar,Jypar,Jzpar,Jpar GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gse_A_m2,javg4scy_gse_A_m2,javg4scz_gse_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gsm_A_m2,javg4scy_gsm_A_m2,javg4scz_gsm_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gse_A_m2,javg4scypar_gse_A_m2,javg4sczpar_gse_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gsm_A_m2,javg4scypar_gsm_A_m2,javg4sczpar_gsm_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gse_A_m2,javg4scyper_gse_A_m2,javg4sczper_gse_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gsm_A_m2,javg4scyper_gsm_A_m2,javg4sczper_gsm_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution	]
					nomcis = 'MMS-DIS'
					Bresolution = 'fgm_brst_l2'
					noproduit = 0
					arbre = [ arbre, 																												$
						'9 res=' + STRLOWCASE(NAME1) + '_dis ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																			$
							'0 Jx,Jy,Jz,J GSE#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jx,Jy,Jz,J GSM#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jxpar,Jypar,Jzpar,Jpar GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxpar,Jypar,Jzpar,Jpar GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gse_A_m2,javg4scy_gse_A_m2,javg4scz_gse_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gsm_A_m2,javg4scy_gsm_A_m2,javg4scz_gsm_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gse_A_m2,javg4scypar_gse_A_m2,javg4sczpar_gse_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gsm_A_m2,javg4scypar_gsm_A_m2,javg4sczpar_gsm_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gse_A_m2,javg4scyper_gse_A_m2,javg4sczper_gse_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gsm_A_m2,javg4scyper_gsm_A_m2,javg4sczper_gsm_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution	]
			arbre = [ arbre, '7 l2' ]
				arbre = [ arbre, '8 dfg' ]
					nomcis = 'MMS-DES'
					Bresolution = 'dfg_brst_l2pre'
					noproduit = 9
					arbre = [ arbre, 																												$
						'9 res=' + STRLOWCASE(NAME1) + '_des ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																				$
							'0 Jx,Jy,Jz,J GSE#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jx,Jy,Jz,J GSM#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jxpar,Jypar,Jzpar,Jpar GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxpar,Jypar,Jzpar,Jpar GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gse_A_m2,javg4scy_gse_A_m2,javg4scz_gse_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gsm_A_m2,javg4scy_gsm_A_m2,javg4scz_gsm_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gse_A_m2,javg4scypar_gse_A_m2,javg4sczpar_gse_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gsm_A_m2,javg4scypar_gsm_A_m2,javg4sczpar_gsm_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gse_A_m2,javg4scyper_gse_A_m2,javg4sczper_gse_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gsm_A_m2,javg4scyper_gsm_A_m2,javg4sczper_gsm_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution	]
					nomcis = 'MMS-DIS'
					Bresolution = 'dfg_brst_l2pre'
					noproduit = 9
					arbre = [ arbre, 																												$
						'9 res=' + STRLOWCASE(NAME1) + '_dis ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																			$
							'0 Jx,Jy,Jz,J GSE#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jx,Jy,Jz,J GSM#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jxpar,Jypar,Jzpar,Jpar GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxpar,Jypar,Jzpar,Jpar GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gse_A_m2,javg4scy_gse_A_m2,javg4scz_gse_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gsm_A_m2,javg4scy_gsm_A_m2,javg4scz_gsm_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gse_A_m2,javg4scypar_gse_A_m2,javg4sczpar_gse_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gsm_A_m2,javg4scypar_gsm_A_m2,javg4sczpar_gsm_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gse_A_m2,javg4scyper_gse_A_m2,javg4sczper_gse_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gsm_A_m2,javg4scyper_gsm_A_m2,javg4sczper_gsm_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution	]
				arbre = [ arbre, '8 fgm' ]
					nomcis = 'MMS-DES'
					Bresolution = 'fgm_brst_l2'
					noproduit = 9
					arbre = [ arbre, 																												$
						'9 res=' + STRLOWCASE(NAME1) + '_des ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																				$
							'0 Jx,Jy,Jz,J GSE#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jx,Jy,Jz,J GSM#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jxpar,Jypar,Jzpar,Jpar GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxpar,Jypar,Jzpar,Jpar GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gse_A_m2,javg4scy_gse_A_m2,javg4scz_gse_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gsm_A_m2,javg4scy_gsm_A_m2,javg4scz_gsm_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gse_A_m2,javg4scypar_gse_A_m2,javg4sczpar_gse_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gsm_A_m2,javg4scypar_gsm_A_m2,javg4sczpar_gsm_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gse_A_m2,javg4scyper_gse_A_m2,javg4sczper_gse_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gsm_A_m2,javg4scyper_gsm_A_m2,javg4sczper_gsm_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution	]
					nomcis = 'MMS-DIS'
					Bresolution = 'fgm_brst_l2'
					noproduit = 9
					arbre = [ arbre, 																												$
						'9 res=' + STRLOWCASE(NAME1) + '_dis ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																			$
							'0 Jx,Jy,Jz,J GSE#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jx,Jy,Jz,J GSM#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jxpar,Jypar,Jzpar,Jpar GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxpar,Jypar,Jzpar,Jpar GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gse_A_m2,javg4scy_gse_A_m2,javg4scz_gse_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gsm_A_m2,javg4scy_gsm_A_m2,javg4scz_gsm_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gse_A_m2,javg4scypar_gse_A_m2,javg4sczpar_gse_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gsm_A_m2,javg4scypar_gsm_A_m2,javg4sczpar_gsm_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gse_A_m2,javg4scyper_gse_A_m2,javg4sczper_gse_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gsm_A_m2,javg4scyper_gsm_A_m2,javg4sczper_gsm_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution	]

		arbre = [ arbre, '6 fast' ]
			arbre = [ arbre, '7 l1b' ]
				arbre = [ arbre, '8 dfg' ]
					nomcis = 'MMS-DES'
					Bresolution = 'dfg_srvy_l2pre'
					noproduit = 6
					arbre = [ arbre, 																												$
						'9 res=' + STRLOWCASE(NAME1) + '_des ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																				$
							'0 Jx,Jy,Jz,J GSE#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jx,Jy,Jz,J GSM#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jxpar,Jypar,Jzpar,Jpar GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxpar,Jypar,Jzpar,Jpar GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gse_A_m2,javg4scy_gse_A_m2,javg4scz_gse_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gsm_A_m2,javg4scy_gsm_A_m2,javg4scz_gsm_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gse_A_m2,javg4scypar_gse_A_m2,javg4sczpar_gse_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gsm_A_m2,javg4scypar_gsm_A_m2,javg4sczpar_gsm_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gse_A_m2,javg4scyper_gse_A_m2,javg4sczper_gse_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gsm_A_m2,javg4scyper_gsm_A_m2,javg4sczper_gsm_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution	]

					nomcis = 'MMS-DIS'
					Bresolution = 'dfg_srvy_l2pre'
					noproduit = 6
					arbre = [ arbre, 																												$
						'9 res=' + STRLOWCASE(NAME1) + '_dis' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																				$
							'0 Jx,Jy,Jz,J GSE#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jx,Jy,Jz,J GSM#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jxpar,Jypar,Jzpar,Jpar GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxpar,Jypar,Jzpar,Jpar GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gse_A_m2,javg4scy_gse_A_m2,javg4scz_gse_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gsm_A_m2,javg4scy_gsm_A_m2,javg4scz_gsm_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gse_A_m2,javg4scypar_gse_A_m2,javg4sczpar_gse_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gsm_A_m2,javg4scypar_gsm_A_m2,javg4sczpar_gsm_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gse_A_m2,javg4scyper_gse_A_m2,javg4sczper_gse_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gsm_A_m2,javg4scyper_gsm_A_m2,javg4sczper_gsm_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution	]
				arbre = [ arbre, '8 fgm' ]
					nomcis = 'MMS-DES'
					Bresolution = 'fgm_srvy_l2'
					noproduit = 6
					arbre = [ arbre, 																												$
						'9 res=' + STRLOWCASE(NAME1) + '_des ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																				$
							'0 Jx,Jy,Jz,J GSE#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jx,Jy,Jz,J GSM#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jxpar,Jypar,Jzpar,Jpar GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxpar,Jypar,Jzpar,Jpar GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gse_A_m2,javg4scy_gse_A_m2,javg4scz_gse_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gsm_A_m2,javg4scy_gsm_A_m2,javg4scz_gsm_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gse_A_m2,javg4scypar_gse_A_m2,javg4sczpar_gse_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gsm_A_m2,javg4scypar_gsm_A_m2,javg4sczpar_gsm_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gse_A_m2,javg4scyper_gse_A_m2,javg4sczper_gse_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gsm_A_m2,javg4scyper_gsm_A_m2,javg4sczper_gsm_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution	]

					nomcis = 'MMS-DIS'
					Bresolution = 'fgm_srvy_l2'
					noproduit = 6
					arbre = [ arbre, 																												$
						'9 res=' + STRLOWCASE(NAME1) + '_dis' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																				$
							'0 Jx,Jy,Jz,J GSE#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jx,Jy,Jz,J GSM#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jxpar,Jypar,Jzpar,Jpar GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxpar,Jypar,Jzpar,Jpar GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gse_A_m2,javg4scy_gse_A_m2,javg4scz_gse_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gsm_A_m2,javg4scy_gsm_A_m2,javg4scz_gsm_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gse_A_m2,javg4scypar_gse_A_m2,javg4sczpar_gse_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gsm_A_m2,javg4scypar_gsm_A_m2,javg4sczpar_gsm_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gse_A_m2,javg4scyper_gse_A_m2,javg4sczper_gse_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gsm_A_m2,javg4scyper_gsm_A_m2,javg4sczper_gsm_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution	]
			arbre = [ arbre, '7 l2' ]
				arbre = [ arbre, '8 dfg' ]
					nomcis = 'MMS-DES'
					Bresolution = 'dfg_srvy_l2pre'
					noproduit = 15
					arbre = [ arbre, 																												$
						'9 res=' + STRLOWCASE(NAME1) + '_des ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																				$
							'0 Jx,Jy,Jz,J GSE#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jx,Jy,Jz,J GSM#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jxpar,Jypar,Jzpar,Jpar GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxpar,Jypar,Jzpar,Jpar GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gse_A_m2,javg4scy_gse_A_m2,javg4scz_gse_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gsm_A_m2,javg4scy_gsm_A_m2,javg4scz_gsm_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gse_A_m2,javg4scypar_gse_A_m2,javg4sczpar_gse_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gsm_A_m2,javg4scypar_gsm_A_m2,javg4sczpar_gsm_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gse_A_m2,javg4scyper_gse_A_m2,javg4sczper_gse_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gsm_A_m2,javg4scyper_gsm_A_m2,javg4sczper_gsm_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution	]

					nomcis = 'MMS-DIS'
					Bresolution = 'dfg_srvy_l2pre'
					noproduit = 15
					arbre = [ arbre, 																												$
						'9 res=' + STRLOWCASE(NAME1) + '_dis' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																				$
							'0 Jx,Jy,Jz,J GSE#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jx,Jy,Jz,J GSM#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jxpar,Jypar,Jzpar,Jpar GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxpar,Jypar,Jzpar,Jpar GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gse_A_m2,javg4scy_gse_A_m2,javg4scz_gse_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gsm_A_m2,javg4scy_gsm_A_m2,javg4scz_gsm_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gse_A_m2,javg4scypar_gse_A_m2,javg4sczpar_gse_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gsm_A_m2,javg4scypar_gsm_A_m2,javg4sczpar_gsm_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gse_A_m2,javg4scyper_gse_A_m2,javg4sczper_gse_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gsm_A_m2,javg4scyper_gsm_A_m2,javg4sczper_gsm_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution	]
				arbre = [ arbre, '8 fgm' ]
					nomcis = 'MMS-DES'
					Bresolution = 'fgm_srvy_l2'
					noproduit = 15
					arbre = [ arbre, 																												$
						'9 res=' + STRLOWCASE(NAME1) + '_des ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																				$
							'0 Jx,Jy,Jz,J GSE#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jx,Jy,Jz,J GSM#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jxpar,Jypar,Jzpar,Jpar GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxpar,Jypar,Jzpar,Jpar GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gse_A_m2,javg4scy_gse_A_m2,javg4scz_gse_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gsm_A_m2,javg4scy_gsm_A_m2,javg4scz_gsm_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gse_A_m2,javg4scypar_gse_A_m2,javg4sczpar_gse_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gsm_A_m2,javg4scypar_gsm_A_m2,javg4sczpar_gsm_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gse_A_m2,javg4scyper_gse_A_m2,javg4sczper_gse_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gsm_A_m2,javg4scyper_gsm_A_m2,javg4sczper_gsm_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution	]

					nomcis = 'MMS-DIS'
					Bresolution = 'fgm_srvy_l2'
					noproduit = 15
					arbre = [ arbre, 																												$
						'9 res=' + STRLOWCASE(NAME1) + '_dis' + get_cldataset_starttime_endtime(nomcis,noproduit,SC),																				$
							'0 Jx,Jy,Jz,J GSE#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gse_A_m2,jy_gse_A_m2,jz_gse_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jx,Jy,Jz,J GSM#'                                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jx_gsm_A_m2,jy_gsm_A_m2,jz_gsm_A_m2,j_A_m2 currentie Bresolution='+Bresolution,						$
							'0 Jxpar,Jypar,Jzpar,Jpar GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gse_A_m2,jypar_gse_A_m2,jzpar_gse_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxpar,Jypar,Jzpar,Jpar GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxpar_gsm_A_m2,jypar_gsm_A_m2,jzpar_gsm_A_m2,jpar_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSE#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gse_A_m2,jyper_gse_A_m2,jzper_gse_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Jxper,Jyper,Jzper,Jper GSM#'                         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' jxper_gsm_A_m2,jyper_gsm_A_m2,jzper_gsm_A_m2,jper_A_m2 currentie Bresolution='+Bresolution,				$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSE#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gse_A_m2,javg4scy_gse_A_m2,javg4scz_gse_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scx,Javg4scy,Javg4scz,Javg4sc GSM#'             + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scx_gsm_A_m2,javg4scy_gsm_A_m2,javg4scz_gsm_A_m2,javg4sc_A_m2 currentie Bresolution='+Bresolution,			$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gse_A_m2,javg4scypar_gse_A_m2,javg4sczpar_gse_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxpar,Javg4scypar,Javg4sczpar,Javg4scpar GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxpar_gsm_A_m2,javg4scypar_gsm_A_m2,javg4sczpar_gsm_A_m2,javg4scpar_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gse_A_m2,javg4scyper_gse_A_m2,javg4sczper_gse_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution,	$
							'0 Javg4scxper,Javg4scyper,Javg4sczper,Javg4scper GSM#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' javg4scxper_gsm_A_m2,javg4scyper_gsm_A_m2,javg4sczper_gsm_A_m2,javg4scper_A_m2 currentie Bresolution='+Bresolution	]

	; --------------------
	; Gradient de pression
	; --------------------
	arbre = [ arbre, '4 Gradpress' ]

	arbre = [ arbre, '5 moms' ]
		arbre = [ arbre, '6 des' ]

			arbre = [ arbre, '7 brst' ]
				nomcis = 'MMS-DES'
				noproduit = 9
				vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/gradpressmom_nom)
				tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # gradpressmom'
				ajouter_dataset, arbre, '<dataset id="'+NAME1+':DES:GRADPRESSBRST">8 l2', nomcis, noproduit, SC, tab, NAME1+'_DES_GRADPRESSBRST', 'mms_des', /gradpressmom
				;arbre = [ arbre, 																									$
				;	'8 l2 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC), 																		$
				;	'0 gPexx_x,gPexx_y,gPexx_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPexx_x_gse,gPexx_y_gse,gPexx_z_gse gradpressmom',				$
				;	'0 gPexx_x,gPexx_y,gPexx_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPexx_x_gse,gPexx_y_gse,gPexx_z_gse gradpressmom',				$
				;	'0 gPexy_x,gPexy_y,gPexy_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPexy_x_gse,gPexy_y_gse,gPexy_z_gse gradpressmom',				$
				;	'0 gPeyz_x,gPeyz_y,gPeyz_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPeyz_x_gse,gPeyz_y_gse,gPeyz_z_gse gradpressmom',				$
				;	'0 gPeyy_x,gPeyy_y,gPeyy_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPeyy_x_gse,gPeyy_y_gse,gPeyy_z_gse gradpressmom',				$
				;	'0 gPeyz_x,gPeyz_y,gPeyz_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPeyz_x_gse,gPeyz_y_gse,gPeyz_z_gse gradpressmom',				$
				;	'0 gPezz_x,gPezz_y,gPezz_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPezz_x_gse,gPezz_y_gse,gPezz_z_gse gradpressmom',				$
				;	'0 gPezy_x,gPezy_y,gPezy_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPezy_x_gse,gPezy_y_gse,gPezy_z_gse gradpressmom',				$
				;	'0 gPezz_x,gPezz_y,gPezz_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPezz_x_gse,gPezz_y_gse,gPezz_z_gse gradpressmom',				$
				;	'0 gTre_x,gTre_y,gTre_z GSE#'                           + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gTre_x_gse,gTre_y_gse,gTre_z_gse gradpressmom',					$
				;	'0 divPe_x,divPe_y,divPe_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' divPe_x_gse,divPe_y_gse,divPe_z_gse gradpressmom',				$
				;	'0 EdivPe_x,EdivPe_y,EdivPe_z GSE#'                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EdivPe_x_gse,EdivPe_y_gse,EdivPe_z_gse gradpressmom',				$
				;	'0 EgTre_x,EgTre_y,EgTre_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EgTre_x_gse,EgTre_y_gse,EgTre_z_gse gradpressmom',				$
				;	'0 gTre_xpar,gTre_ypar,gTre_zpar,gTre_par GSE#'         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gTre_xpar_gse,gTre_ypar_gse,gTre_zpar_gse,gTre_par gradpressmom',		$
				;	'0 gTre_xper,gTre_yper,gTre_zper,gTre_per GSE#'         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gTre_xper_gse,gTre_yper_gse,gTre_zper_gse,gTre_per gradpressmom',		$
				;	'0 divPe_xpar,divPe_ypar,divPe_zpar,divPe_par GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' divPe_xpar_gse,divPe_ypar_gse,divPe_zpar_gse,divPe_par gradpressmom',		$
				;	'0 divPe_xper,divPe_yper,divPe_zper,divPe_per GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' divPe_xper_gse,divPe_yper_gse,divPe_zper_gse,divPe_per gradpressmom',		$
				;	'0 EdivPe_xpar,EdivPe_ypar,EdivPe_zpar,EdivPe_par GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EdivPe_xpar_gse,EdivPe_ypar_gse,EdivPe_zpar_gse,EdivPe_par gradpressmom',	$
				;	'0 EdivPe_xper,EdivPe_yper,EdivPe_zper,EdivPe_per GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EdivPe_xper_gse,EdivPe_yper_gse,EdivPe_zper_gse,EdivPe_per gradpressmom',	$
				;	'0 EgTre_xpar,EgTre_ypar,EgTre_zpar,EgTre_par GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EgTre_xpar_gse,EgTre_ypar_gse,EgTre_zpar_gse,EgTre_par gradpressmom',		$
				;	'0 EgTre_xper,EgTre_yper,EgTre_zper,EgTre_per GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EgTre_xper_gse,EgTre_yper_gse,EgTre_zper_gse,EgTre_per gradpressmom'		]
			arbre = [ arbre, '7 fast' ]
				nomcis = 'MMS-DES'
				noproduit = 15
				vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/gradpressmom_nom)
				tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # gradpressmom'
				ajouter_dataset, arbre, '<dataset id="'+NAME1+':DES:GRADPRESSFAST">8 l2', nomcis, noproduit, SC, tab, NAME1+'_DES_GRADPRESSFAST', 'mms_des', /gradpressmom
				;arbre = [ arbre, 																									$
				;	'8 l2 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC), 																		$
				;	'0 gPexx_x,gPexx_y,gPexx_z GSE#'                       + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPexx_x_gse,gPexx_y_gse,gPexx_z_gse gradpressmom',				$
				;	'0 gPexx_x,gPexx_y,gPexx_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPexx_x_gse,gPexx_y_gse,gPexx_z_gse gradpressmom',				$
				;	'0 gPexy_x,gPexy_y,gPexy_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPexy_x_gse,gPexy_y_gse,gPexy_z_gse gradpressmom',				$
				;	'0 gPeyz_x,gPeyz_y,gPeyz_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPeyz_x_gse,gPeyz_y_gse,gPeyz_z_gse gradpressmom',				$
				;	'0 gPeyy_x,gPeyy_y,gPeyy_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPeyy_x_gse,gPeyy_y_gse,gPeyy_z_gse gradpressmom',				$
				;	'0 gPeyz_x,gPeyz_y,gPeyz_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPeyz_x_gse,gPeyz_y_gse,gPeyz_z_gse gradpressmom',				$
				;	'0 gPezz_x,gPezz_y,gPezz_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPezz_x_gse,gPezz_y_gse,gPezz_z_gse gradpressmom',				$
				;	'0 gPezy_x,gPezy_y,gPezy_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPezy_x_gse,gPezy_y_gse,gPezy_z_gse gradpressmom',				$
				;	'0 gPezz_x,gPezz_y,gPezz_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPezz_x_gse,gPezz_y_gse,gPezz_z_gse gradpressmom',				$
				;	'0 gTre_x,gTre_y,gTre_z GSE#'                           + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gTre_x_gse,gTre_y_gse,gTre_z_gse gradpressmom',					$
				;	'0 divPe_x,divPe_y,divPe_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' divPe_x_gse,divPe_y_gse,divPe_z_gse gradpressmom',				$
				;	'0 EdivPe_x,EdivPe_y,EdivPe_z GSE#'                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EdivPe_x_gse,EdivPe_y_gse,EdivPe_z_gse gradpressmom',				$
				;	'0 EgTre_x,EgTre_y,EgTre_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EgTre_x_gse,EgTre_y_gse,EgTre_z_gse gradpressmom',				$
				;	'0 gTre_xpar,gTre_ypar,gTre_zpar,gTre_par GSE#'         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gTre_xpar_gse,gTre_ypar_gse,gTre_zpar_gse,gTre_par gradpressmom',		$
				;	'0 gTre_xper,gTre_yper,gTre_zper,gTre_per GSE#'         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gTre_xper_gse,gTre_yper_gse,gTre_zper_gse,gTre_per gradpressmom',		$
				;	'0 divPe_xpar,divPe_ypar,divPe_zpar,divPe_par GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' divPe_xpar_gse,divPe_ypar_gse,divPe_zpar_gse,divPe_par gradpressmom',		$
				;	'0 divPe_xper,divPe_yper,divPe_zper,divPe_per GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' divPe_xper_gse,divPe_yper_gse,divPe_zper_gse,divPe_per gradpressmom',		$
				;	'0 EdivPe_xpar,EdivPe_ypar,EdivPe_zpar,EdivPe_par GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EdivPe_xpar_gse,EdivPe_ypar_gse,EdivPe_zpar_gse,EdivPe_par gradpressmom',	$
				;	'0 EdivPe_xper,EdivPe_yper,EdivPe_zper,EdivPe_per GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EdivPe_xper_gse,EdivPe_yper_gse,EdivPe_zper_gse,EdivPe_per gradpressmom',	$
				;	'0 EgTre_xpar,EgTre_ypar,EgTre_zpar,EgTre_par GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EgTre_xpar_gse,EgTre_ypar_gse,EgTre_zpar_gse,EgTre_par gradpressmom',		$
				;	'0 EgTre_xper,EgTre_yper,EgTre_zper,EgTre_per GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EgTre_xper_gse,EgTre_yper_gse,EgTre_zper_gse,EgTre_per gradpressmom'		]
		arbre = [ arbre, '6 dis' ]
			arbre = [ arbre, '7 brst' ]
				nomcis = 'MMS-DIS'
				noproduit = 9
				vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/gradpressmom_nom)
				tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # gradpressmom'
				ajouter_dataset, arbre, '<dataset id="'+NAME1+':DIS:GRADPRESSBRST">8 l2', nomcis, noproduit, SC, tab, NAME1+'_DIS_GRADPRESSBRST', 'mms_des', /gradpressmom
				;arbre = [ arbre, 																									$
				;	'8 l2 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC), 																		$
				;	'0 gPixx_x,gPixx_y,gPixx_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPixx_x_gse,gPixx_y_gse,gPixx_z_gse gradpressmom',				$
				;	'0 gPixx_x,gPixx_y,gPixx_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPixx_x_gse,gPixx_y_gse,gPixx_z_gse gradpressmom',				$
				;	'0 gPixy_x,gPixy_y,gPixy_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPixy_x_gse,gPixy_y_gse,gPixy_z_gse gradpressmom',				$
				;	'0 gPiyz_x,gPiyz_y,gPiyz_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPiyz_x_gse,gPiyz_y_gse,gPiyz_z_gse gradpressmom',				$
				;	'0 gPiyy_x,gPiyy_y,gPiyy_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPiyy_x_gse,gPiyy_y_gse,gPiyy_z_gse gradpressmom',				$
				;	'0 gPiyz_x,gPiyz_y,gPiyz_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPiyz_x_gse,gPiyz_y_gse,gPiyz_z_gse gradpressmom',				$
				;	'0 gPizz_x,gPizz_y,gPizz_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPizz_x_gse,gPizz_y_gse,gPizz_z_gse gradpressmom',				$
				;	'0 gPizy_x,gPizy_y,gPizy_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPizy_x_gse,gPizy_y_gse,gPizy_z_gse gradpressmom',				$
				;	'0 gPizz_x,gPizz_y,gPizz_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPizz_x_gse,gPizz_y_gse,gPizz_z_gse gradpressmom',				$
				;	'0 gTri_x,gTri_y,gTri_z GSE#'                           + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gTri_x_gse,gTri_y_gse,gTri_z_gse gradpressmom',					$
				;	'0 divPi_x,divPi_y,divPi_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' divPi_x_gse,divPi_y_gse,divPi_z_gse gradpressmom',				$
				;	'0 EdivPi_x,EdivPi_y,EdivPi_z GSE#'                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EdivPi_x_gse,EdivPi_y_gse,EdivPi_z_gse gradpressmom',				$
				;	'0 EgTri_x,EgTri_y,EgTri_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EgTri_x_gse,EgTri_y_gse,EgTri_z_gse gradpressmom',				$
				;	'0 gTri_xpar,gTri_ypar,gTri_zpar,gTri_par GSE#'         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gTri_xpar_gse,gTri_ypar_gse,gTri_zpar_gse,gTri_par gradpressmom',		$
				;	'0 gTri_xper,gTri_yper,gTri_zper,gTri_per GSE#'         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gTri_xper_gse,gTri_yper_gse,gTri_zper_gse,gTri_per gradpressmom',		$
				;	'0 divPi_xpar,divPi_ypar,divPi_zpar,divPi_par GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' divPi_xpar_gse,divPi_ypar_gse,divPi_zpar_gse,divPi_par gradpressmom',		$
				;	'0 divPi_xper,divPi_yper,divPi_zper,divPi_per GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' divPi_xper_gse,divPi_yper_gse,divPi_zper_gse,divPi_per gradpressmom',		$
				;	'0 EdivPi_xpar,EdivPi_ypar,EdivPi_zpar,EdivPi_par GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EdivPi_xpar_gse,EdivPi_ypar_gse,EdivPi_zpar_gse,EdivPi_par gradpressmom',	$
				;	'0 EdivPi_xper,EdivPi_yper,EdivPi_zper,EdivPi_per GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EdivPi_xper_gse,EdivPi_yper_gse,EdivPi_zper_gse,EdivPi_per gradpressmom',	$
				;	'0 EgTri_xpar,EgTri_ypar,EgTri_zpar,EgTri_par GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EgTri_xpar_gse,EgTri_ypar_gse,EgTri_zpar_gse,EgTri_par gradpressmom',		$
				;	'0 EgTri_xper,EgTri_yper,EgTri_zper,EgTri_per GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EgTri_xper_gse,EgTri_yper_gse,EgTri_zper_gse,EgTri_per gradpressmom'		]
			arbre = [ arbre, '7 fast' ]
				nomcis = 'MMS-DIS'
				noproduit = 15
				vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/gradpressmom_nom)
				tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # gradpressmom'
				ajouter_dataset, arbre, '<dataset id="'+NAME1+':DIS:GRADPRESSFAST">8 l2', nomcis, noproduit, SC, tab, NAME1+'_DIS_GRADPRESSFAST', 'mms_des', /gradpressmom
				;arbre = [ arbre, 																									$
				;	'8 l2 ' + get_cldataset_starttime_endtime(nomcis,noproduit,SC), 																		$
				;	'0 gPixx_x,gPixx_y,gPixx_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPixx_x_gse,gPixx_y_gse,gPixx_z_gse gradpressmom',				$
				;	'0 gPixx_x,gPixx_y,gPixx_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPixx_x_gse,gPixx_y_gse,gPixx_z_gse gradpressmom',				$
				;	'0 gPixy_x,gPixy_y,gPixy_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPixy_x_gse,gPixy_y_gse,gPixy_z_gse gradpressmom',				$
				;	'0 gPiyz_x,gPiyz_y,gPiyz_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPiyz_x_gse,gPiyz_y_gse,gPiyz_z_gse gradpressmom',				$
				;	'0 gPiyy_x,gPiyy_y,gPiyy_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPiyy_x_gse,gPiyy_y_gse,gPiyy_z_gse gradpressmom',				$
				;	'0 gPiyz_x,gPiyz_y,gPiyz_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPiyz_x_gse,gPiyz_y_gse,gPiyz_z_gse gradpressmom',				$
				;	'0 gPizz_x,gPizz_y,gPizz_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPizz_x_gse,gPizz_y_gse,gPizz_z_gse gradpressmom',				$
				;	'0 gPizy_x,gPizy_y,gPizy_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPizy_x_gse,gPizy_y_gse,gPizy_z_gse gradpressmom',				$
				;	'0 gPizz_x,gPizz_y,gPizz_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gPizz_x_gse,gPizz_y_gse,gPizz_z_gse gradpressmom',				$
				;	'0 gTri_x,gTri_y,gTri_z GSE#'                           + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gTri_x_gse,gTri_y_gse,gTri_z_gse gradpressmom',					$
				;	'0 divPi_x,divPi_y,divPi_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' divPi_x_gse,divPi_y_gse,divPi_z_gse gradpressmom',				$
				;	'0 EdivPi_x,EdivPi_y,EdivPi_z GSE#'                     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EdivPi_x_gse,EdivPi_y_gse,EdivPi_z_gse gradpressmom',				$
				;	'0 EgTri_x,EgTri_y,EgTri_z GSE#'                        + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EgTri_x_gse,EgTri_y_gse,EgTri_z_gse gradpressmom',				$
				;	'0 gTri_xpar,gTri_ypar,gTri_zpar,gTri_par GSE#'         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gTri_xpar_gse,gTri_ypar_gse,gTri_zpar_gse,gTri_par gradpressmom',		$
				;	'0 gTri_xper,gTri_yper,gTri_zper,gTri_per GSE#'         + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' gTri_xper_gse,gTri_yper_gse,gTri_zper_gse,gTri_per gradpressmom',		$
				;	'0 divPi_xpar,divPi_ypar,divPi_zpar,divPi_par GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' divPi_xpar_gse,divPi_ypar_gse,divPi_zpar_gse,divPi_par gradpressmom',		$
				;	'0 divPi_xper,divPi_yper,divPi_zper,divPi_per GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' divPi_xper_gse,divPi_yper_gse,divPi_zper_gse,divPi_per gradpressmom',		$
				;	'0 EdivPi_xpar,EdivPi_ypar,EdivPi_zpar,EdivPi_par GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EdivPi_xpar_gse,EdivPi_ypar_gse,EdivPi_zpar_gse,EdivPi_par gradpressmom',	$
				;	'0 EdivPi_xper,EdivPi_yper,EdivPi_zper,EdivPi_per GSE#' + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EdivPi_xper_gse,EdivPi_yper_gse,EdivPi_zper_gse,EdivPi_per gradpressmom',	$
				;	'0 EgTri_xpar,EgTri_ypar,EgTri_zpar,EgTri_par GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EgTri_xpar_gse,EgTri_ypar_gse,EgTri_zpar_gse,EgTri_par gradpressmom',		$
				;	'0 EgTri_xper,EgTri_yper,EgTri_zper,EgTri_per GSE#'     + nomcis + ' ' + STRJOIN('P'+val_to_str(noproduit),',') + ' ' + SC + ' EgTri_xper_gse,EgTri_yper_gse,EgTri_zper_gse,EgTri_per gradpressmom'		]

	; --------
	; Ohm law
	; --------
	arbre = [ arbre, '4 Basic Equations' ]

	arbre = [ arbre, '5 moms' ]
		arbre = [ arbre, '6 brst' ]
			arbre = [ arbre, '7 l2' ]
				nomcis = 'MMS-DES'
				noproduit = 9

				vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/lawohm_nom)
				tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # lawohm'

				tmp = tab
				FOR i=0L,N_ELEMENTS(tmp)-1 DO BEGIN
					IF chaine_contient(tmp[i],'_ohm') EQ 0 OR chaine_contient(tmp[i],'_ohm_avg') EQ 1 THEN tmp[i] = ''
				END
				tmp = tmp[WHERE(tmp NE '')]
				ajouter_dataset, arbre, '<dataset id="'+NAME1+':DES:OHMBRST">8 Ohm Law', nomcis, noproduit, SC, tmp, NAME1+'_DES_OHMBRST', 'mms_des', /lawohm

				tmp = tab
				FOR i=0L,N_ELEMENTS(tmp)-1 DO BEGIN
					IF chaine_contient(tmp[i],'_ohm_avg') EQ 0 THEN tmp[i] = ''
				END
				tmp = tmp[WHERE(tmp NE '')]
				ajouter_dataset, arbre, '<dataset id="'+NAME1+':DES:OHMAVGBRST">8 Ohm Law avg', nomcis, noproduit, SC, tmp, NAME1+'_DES_OHMAVGBRST', 'mms_des', /lawohm

				tmp = tab
				FOR i=0L,N_ELEMENTS(tmp)-1 DO BEGIN
					IF chaine_contient(tmp[i],'_mom') EQ 0 OR chaine_contient(tmp[i],'_mom_avg') EQ 1 THEN tmp[i] = ''
				END
				tmp = tmp[WHERE(tmp NE '')]
				ajouter_dataset, arbre, '<dataset id="'+NAME1+':DES:MOMBRST">8 Momentum Equation', nomcis, noproduit, SC, tmp, NAME1+'_DES_MOMBRST', 'mms_des', /lawohm

				tmp = tab
				FOR i=0L,N_ELEMENTS(tmp)-1 DO BEGIN
					IF chaine_contient(tmp[i],'_mom_avg') EQ 0 THEN tmp[i] = ''
				END
				tmp = tmp[WHERE(tmp NE '')]
				ajouter_dataset, arbre, '<dataset id="'+NAME1+':DES:MOMAVGBRST">8 Momentum Equation avg', nomcis, noproduit, SC, tmp, NAME1+'_DES_MOMAVGBRST', 'mms_des', /lawohm

				tmp = tab
				FOR i=0L,N_ELEMENTS(tmp)-1 DO BEGIN
					IF chaine_contient(tmp[i],'_ect') EQ 0 OR chaine_contient(tmp[i],'_ect_avg') EQ 1 THEN tmp[i] = ''
				END
				tmp = tmp[WHERE(tmp NE '')]
				ajouter_dataset, arbre, '<dataset id="'+NAME1+':DES:ECTBRST">8 Energy Conversion', nomcis, noproduit, SC, tmp, NAME1+'_DES_ECTBRST', 'mms_des', /lawohm

				tmp = tab
				FOR i=0L,N_ELEMENTS(tmp)-1 DO BEGIN
					IF chaine_contient(tmp[i],'_ect_avg') EQ 0 THEN tmp[i] = ''
				END
				tmp = tmp[WHERE(tmp NE '')]
				ajouter_dataset, arbre, '<dataset id="'+NAME1+':DES:ECTAVGBRST">8 Energy Conversion avg', nomcis, noproduit, SC, tmp, NAME1+'_DES_ECTAVGBRST', 'mms_des', /lawohm

				tmp = tab
				FOR i=0L,N_ELEMENTS(tmp)-1 DO BEGIN
					IF chaine_contient(tmp[i],'_agy') EQ 0 THEN tmp[i] = ''
				END
				tmp = tmp[WHERE(tmp NE '')]
				ajouter_dataset, arbre, '<dataset id="'+NAME1+':DES:AGYBRST">8 Agyrotropy', nomcis, noproduit, SC, tmp, NAME1+'_DES_AGYBRST', 'mms_des', /lawohm
				tmp = tab
				FOR i=0L,N_ELEMENTS(tmp)-1 DO BEGIN
					IF chaine_contient(tmp[i],'_lengths') EQ 0 THEN tmp[i] = ''
				END
				tmp = tmp[WHERE(tmp NE '')]
				ajouter_dataset, arbre, '<dataset id="'+NAME1+':DES:LENGTHSBRST">8 Lengths', nomcis, noproduit, SC, tmp, NAME1+'_DES_LENGTHSBRST', 'mms_des', /lawohm

				tmp = tab
				FOR i=0L,N_ELEMENTS(tmp)-1 DO BEGIN
					IF chaine_contient(tmp[i],'_ecr') EQ 0 THEN tmp[i] = ''
				END
				tmp = tmp[WHERE(tmp NE '')]
				ajouter_dataset, arbre, '<dataset id="'+NAME1+':DES:ECR">8 Energy Conversion Rate', nomcis, noproduit, SC, tmp, NAME1+'_DES_ECRBRST', 'mms_des', /lawohm

	arbre = [ arbre, '</mission>' ]

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_interball_tail
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL INTERBALL-TAIL.
;-------------------------------------------------------------------------------
;
; Trouv dans spase://SMWG/Observatory/Interball-1
;
; <ObservatoryRegion>Heliosphere.NearEarth</ObservatoryRegion>
; <ObservatoryRegion>Earth.Magnetosheath</ObservatoryRegion>
; <ObservatoryRegion>Earth.Magnetosphere</ObservatoryRegion>
; <ObservatoryRegion>Earth.Magnetosphere.Main</ObservatoryRegion>
; <ObservatoryRegion>Earth.Magnetosphere.Polar</ObservatoryRegion>
;

	create_products, 'INTERBALL'

	target  =                       "Earth.Magnetosphere"										; V. Genot
	targets = "Heliosphere.NearEarth Earth.Magnetosheath Earth.Magnetosphere Earth.Magnetosphere.Main Earth.Magnetosphere.Polar"	; spase


	arbre = [												$
		'<mission name="INTERBALL-TAIL" id="INTERBALL-TAIL" target="'+target+'" targets="'+targets+'">3 TAIL',	$
		'<instrument name="ephemeris" id="INTERBALL-TAIL:ephemeris">4 ephemeris']
	tab = [	'cl	X_gsm_Rt,Y_gsm_Rt,Z_gsm_Rt,*Dist_Rt  x,y,z,dist  orbito',	$
		'cl,ws	X_gsm_Rt,Y_gsm_Rt,Z_gsm_Rt           x,y,z       header'	]
	ajouter_dataset, arbre, '<dataset id="INTERBALL-TAIL:EPHEMERIS:ORBIT_FM3I">5 orbit from FM3I', 'INTERBALL-FM3I', 3, 'SC1', tab, 'IT_EPHEMERIS_ORBIT_FM3I', 'interball_fm3i'

	tab = [	'cl	X_gsm_Rt,Y_gsm_Rt,Z_gsm_Rt,*Dist_Rt  x,y,z,dist  orbito',	$
		'cl,ws	X_gsm_Rt,Y_gsm_Rt,Z_gsm_Rt           x,y,z       header'	]
	ajouter_dataset, arbre, '<dataset id="INTERBALL-TAIL:EPHEMERIS:ORBIT_MIFM">5 orbit from MIFM', 'INTERBALL-MIFM', 2, 'SC1', tab, 'IT_EPHEMERIS_ORBIT_MIFM', 'interball_mifm'

	tab = [	'cl	X_gsm_Rt,Y_gsm_Rt,Z_gsm_Rt,*Dist_Rt  x,y,z,dist  orbito',	$
		'cl,ws	X_gsm_Rt,Y_gsm_Rt,Z_gsm_Rt           x,y,z       header'	]
	ajouter_dataset, arbre, '<dataset id="INTERBALL-TAIL:EPHEMERIS:ORBIT_ELECTRON">5 orbit from ELECTRON', 'INTERBALL-ELECTRON', 1, 'SC1', tab, 'IT_EPHEMERIS_ORBIT_ELECTRON', 'interball_electron'


	tab = [	'cl,ws	NORB  			#		header',	$
		'cl,ws	XG,YG,ZG 		x,y,z		header',	$
		'cl,ws	VGX,VGY,VGZ		Vx,Vy,Vz	header',	$
		'cl,ws	ALT  			#		header',	$
		'cl,ws	DLATGR  		#		header',	$
		'cl,ws	DLONR			#		header',	$
		'cl,ws	RRE			#		header',	$
		'cl,ws	THETR			#		header',	$
		'cl,ws	PHIR			#		header',	$
		'cl,ws	XGSE,YGSE,ZGSE		x,y,z		header',	$
		'cl,ws	XGSM,YGSM,ZGSM	 	x,y,z		header',	$
		'cl,ws	XLATGR 			#		header',	$
		'cl,ws	XLONGR 			#		header',	$
		'cl,ws	TGL 			#		header',	$
		'cl,ws	HSL 			#		header',	$
		'cl,ws	BB			#		header',	$
		'cl,ws	BXGSM,BYGSM,BZGSM	Bx,By,Bz	header',	$
		'cl,ws	BXSE,BYSE,BZSE 		Bx,By,Bz	header',	$
		'cl,ws	XLAMB 			#		header',	$
		'cl,ws	TGLC			#		header',	$
		'cl,ws	FL			#		header',	$
		'cl,ws	TGLEQ			#		header',	$
		'cl,ws	REQ			#		header',	$
		'cl,ws	BEQ			#		header',	$
		'cl,ws	FLENGTH 		#		header',	$
		'cl,ws	FLENGTH___2		#		header',	$
		'cl,ws	PHIKV			#		header',	$
		'cl,ws	DMP 			#		header',	$
		'cl,ws	DBS 			#		header',	$
		'cl,ws	DZNSH 			#		header'	]
	ajouter_dataset, arbre, '<dataset id="INTERBALL-TAIL:EPHEMERIS:ORBIT_ELECTRON_DETAILED">5 orbit detailed from ELECTRON', 'INTERBALL-ELECTRON', 9, 'SC1', tab, 'IT_EPHEMERIS_ORBIT_ELECTRON_DETAILED', 'interball_electron'

	arbre = [ arbre, $
		'</instrument>', $
		'<instrument name="FM3I" id="INTERBALL-TAIL:FM3I">4 FM3I']

	tab = [	'cl,ws	Bx_sc_nT,By_sc_nT,Bz_sc_nT,*B_nT  Bx,By,Bz,|B|  header']
	ajouter_dataset, arbre, '<dataset id="INTERBALL-TAIL:FM3I:MAG">5 Magnetic field FM3I coordinates', 'INTERBALL-FM3I', 0, 'SC1', tab, 'IT_FM3I_MAG', 'interball_fm3i'

	tab = [	'cl,ws	Bx_gsm_nT,By_gsm_nT,Bz_gsm_nT,*B_nT  Bx,By,Bz,|B|	header']
	ajouter_dataset, arbre, '<dataset name="Magnetic field GSM coordinates" id="INTERBALL-TAIL:FM3I:GSM">5 Magnetic field GSM coordinates', 'INTERBALL-FM3I', 1, 'SC1', tab, 'IT_FM3I_GSM', 'interball_fm3i'

	tab = [	'cl,ws	ADV_Volt 		# header',	$
		'cl,ws	Temperature1_deg	# header',	$
		'cl,ws	Temperature2_deg	# header']
	ajouter_dataset, arbre, '<dataset id="INTERBALL-TAIL:FM3I:HK">5 Housekeeping', 'INTERBALL-FM3I', 2, 'SC1', tab, 'IT_FM3I_HK', 'interball_fm3i'

	arbre = [ arbre, $
		'</instrument>', $
		'<instrument name="MIFM" id="INTERBALL-TAIL:MIFM">4 MIFM']

	tab = [	'cl,ws	Bx_sc_nT,By_sc_nT,Bz_sc_nT,*B_nT  Bx,By,Bz,|B|	header']
	ajouter_dataset, arbre, '<dataset id="INTERBALL-TAIL:MIFM:MAG">5 Magnetic field MIFM coordinates', 'INTERBALL-MIFM', 0, 'SC1', tab, 'IT_MIFM_MAG', 'interball_mifm'

	tab = [	'cl,ws	Bx_gsm_nT,By_gsm_nT,Bz_gsm_nT,*B_nT  Bx,By,Bz,|B|  header']
	ajouter_dataset, arbre, '<dataset id="INTERBALL-TAIL:MIFM:GSM">5 Magnetic field GSM coordinates', 'INTERBALL-MIFM', 1, 'SC1', tab, 'IT_MIFM_GSM', 'interball_mifm'

	arbre = [ arbre, $
		'</instrument>', $
		'<instrument name="ELECTRON" id="INTERBALL-TAIL:ELECTRON">4 ELECTRON']

	tab = [	'cl,ws	HT_Volt			#	header',	$
		'cl,ws	Temperature_degC	#	header']
	ajouter_dataset, arbre, '<dataset id="INTERBALL-TAIL:ELECTRON:COT">5 Housekeeping from COT', 'INTERBALL-ELECTRON', 0, 'SC1', tab, 'IT_ELECTRON_COT', 'interball_electron'

	tab = [	'cl,ws	Ip_mA			#	header',	$
		'cl,ws	TemperatureC_degC	#	header',	$
		'cl,ws	Temperature1_degC	#	header',	$
		'cl,ws	Temperature2_degC	#	header',	$
		'cl,ws	Vp_Volt			#	header',	$
		'cl,ws	Prom			#	header',	$
		'cl,ws	Mcp_Volt		#	header',	$
		'cl,ws	Plus28V_Volt		#	header',	$
		'cl,ws	Plus10V_Volt		#	header',	$
		'cl,ws	Minus10V_Volt		#	header',	$
		'cl,ws	Plus5V_Volt		#	header',	$
		'cl,ws	Bouchon			#	header']
	ajouter_dataset, arbre, '<dataset id="INTERBALL-TAIL:ELECTRON:TE2">5 Housekeeping from TE2', 'INTERBALL-ELECTRON', 2, 'SC1', tab, 'IT_ELECTRON_TE2', 'interball_electron'

	tab = [	'cl,ws	table				#	header',	$
		'cl,ws	N1_cm3				#	header',	$
		'cl,ws	N2_cm3				#	header',	$
		'cl,ws	N3_cm3				#	header',	$
		'cl,ws	N4_cm3				#	header',	$
		'cl,ws	N5_cm3				#	header',	$
		'cl,ws	N6_cm3				#	header',	$
		'cl,ws	N7_cm3				#	header',	$
		'cl,ws	N8_cm3				#	header',	$
		'cl,ws	F1_cm2_sec_sr_1			#	header',	$
		'cl,ws	F2_cm2_sec_sr_1			#	header',	$
		'cl,ws	F3_cm2_sec_sr_1			#	header',	$
		'cl,ws	F4_cm2_sec_sr_1			#	header',	$
		'cl,ws	F5_cm2_sec_sr_1			#	header',	$
		'cl,ws	F6_cm2_sec_sr_1			#	header',	$
		'cl,ws	F7_cm2_sec_sr_1			#	header',	$
		'cl,ws	F8_cm2_sec_sr_1			#	header',	$
		'cl,ws	Q1_kev_cm_2_sec_1_sr_1		#	header',	$
		'cl,ws	Q2_kev_cm_2_sec_1_sr_1		#	header',	$
		'cl,ws	Q3_kev_cm_2_sec_1_sr_1		#	header',	$
		'cl,ws	Q4_kev_cm_2_sec_1_sr_1		#	header',	$
		'cl,ws	Q5_kev_cm_2_sec_1_sr_1		#	header',	$
		'cl,ws	Q6_kev_cm_2_sec_1_sr_1		#	header',	$
		'cl,ws	Q7_kev_cm_2_sec_1_sr_1		#	header',	$
		'cl,ws	Q8_kev_cm_2_sec_1_sr_1		#	header',	$
		'cl,ws	E1_keV				#	header',	$
		'cl,ws	E2_keV				#	header',	$
		'cl,ws	E3_keV				#	header',	$
		'cl,ws	E4_keV				#	header',	$
		'cl,ws	E5_keV				#	header',	$
		'cl,ws	E6_keV				#	header',	$
		'cl,ws	E7_keV				#	header',	$
		'cl,ws	E8_keV				#	header',	$
		'cl,ws	Summ_count1			#	header',	$
		'cl,ws	Summ_count2			#	header',	$
		'cl,ws	Summ_count3			#	header',	$
		'cl,ws	Summ_count4			#	header',	$
		'cl,ws	Summ_count5			#	header',	$
		'cl,ws	Summ_count6			#	header',	$
		'cl,ws	Summ_count7			#	header',	$
		'cl,ws	Summ_count8			#	header']
	ajouter_dataset, arbre, '<dataset id="INTERBALL-TAIL:ELECTRON:NFQE">5 NFQE', 'INTERBALL-ELECTRON', 3, 'SC1', tab, 'IT_ELECTRON_NFQE', 'interball_electron'

	tab = [	'cl,ws	N_cm3										#			count2d type=moments ion_nochamp=e- legend_theta=No legend_phi=No yleft_log=Log',	$
		'cl,ws	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec						Vx,Vy,Vz,|V|		count2d type=moments ion_nochamp=e- legend_theta=No legend_phi=No',		$
		'cl,ws	Vx_gse_km_sec,Vy_gse_km_sec,Vz_gse_km_sec,*V_km_sec				Vx,Vy,Vz,|V|		count2d type=moments ion_nochamp=e- legend_theta=No legend_phi=No',		$
		'cl,ws	Vx_gsm_km_sec,Vy_gsm_km_sec,Vz_gsm_km_sec,*V_km_sec				Vx,Vy,Vz,|V|		count2d type=moments ion_nochamp=e- legend_theta=No legend_phi=No',		$
		'cl,ws	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3						Ppar,Pper1,Pper2	count2d type=moments ion_nochamp=e- legend_theta=No legend_phi=No',		$
		'cl,ws	Tpar_eV,Tper1_eV,Tper2_eV							Tpar,Tper1,Tper2	count2d type=moments ion_nochamp=e- legend_theta=No legend_phi=No',		$
		'cl,ws	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2			Qx,Qy,Qz,|Q|     	count2d type=moments ion_nochamp=e- legend_theta=No legend_phi=No',		$
		'cl,ws	Qx_gse_erg_sec_cm2,Qy_gse_erg_sec_cm2,Qz_gse_erg_sec_cm2,*Q_erg_sec_cm2		Qx,Qy,Qz,|Q|		count2d type=moments ion_nochamp=e- legend_theta=No legend_phi=No',		$
		'cl,ws	Qx_gsm_erg_sec_cm2,Qy_gsm_erg_sec_cm2,Qz_gsm_erg_sec_cm2,*Q_erg_sec_cm2		Qx,Qy,Qz,|Q|		count2d type=moments ion_nochamp=e- legend_theta=No legend_phi=No',		$
		'cl,ws	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3		Pxx,Pxy,Pxz,Pyy,Pyz,Pzz	count2d type=moments ion_nochamp=e- legend_theta=No legend_phi=No',		$
		'cl,ws	Ei_eV_cm3									#			count2d type=moments ion_nochamp=e- legend_theta=No legend_phi=No',		$
		'cl,ws	Ex_gse,Ey_gse,Ez_gse								Ex,Ey,Ez		count2d type=moments ion_nochamp=e- legend_theta=No legend_phi=No',		$
		'cl,ws	Ex_gsm,Ey_gsm,Ez_gsm								Ex,Ey,Ez		count2d type=moments ion_nochamp=e- legend_theta=No legend_phi=No',		$
		'cl,ws	Pp_nPa										#			count2d type=moments ion_nochamp=e- legend_theta=No legend_phi=No'		]
	ajouter_dataset, arbre, '<dataset id="INTERBALL-TAIL:ELECTRON:3DMOMENTS">5 3D moments', 'INTERBALL-ELECTRON', [4,5,8], 'SC1', tab, 'IT_ELECTRON_3DMOMENTS', 'interball_electron interball_fm3i interball_mifm', /moments

	info1 = [	$
		{ noproduit:4,	nomproduit:'3D_32E' 	},	$
		{ noproduit:5,	nomproduit:'3D_16E' 	},	$
		{ noproduit:8,	nomproduit:'2D_16E' 	}	]

	FOR i=0L,N_ELEMENTS(info1)-1 DO BEGIN
		tab = [	'ws	1d_data 		# count3d type=time_energy spin_average=No cjf=c/s yleft_auto=Manual yleft_min=10 yleft_max=26000 z_showdir=No z_theta=No z_phi=No',	$
			'ws	1d_data 		# count3d type=time_energy spin_average=No cjf=flux yleft_auto=Manual yleft_min=10 yleft_max=26000 z_showdir=No z_theta=No z_phi=No',	$
			'ws	1d_data 		# count3d type=time_energy spin_average=No cjf=JE yleft_auto=Manual yleft_min=10 yleft_max=26000 z_showdir=No z_theta=No z_phi=No']
		ajouter_dataset, arbre, '<dataset id="INTERBALL-TAIL:ELECTRON:'+info1[i].nomproduit+'_SPECTRO_TIME_ENERGY" visibility="ws">5 '+info1[i].nomproduit+' Spectrogram Time Energy', 'INTERBALL-ELECTRON', info1[i].noproduit, 'SC1', tab, 'IT_ELECTRON_'+info1[i].nomproduit+'_SPECTRO_TIME_ENERGY', 'interball_electron', /spectro
	END

	arbre = [ arbre, $
		'5 Particle spectrogram ' + get_cldataset_starttime_endtime('INTERBALL-ELECTRON',[4,5,8],'SC1'),															$
			'0 Time Energy JE#		INTERBALL-ELECTRON P4,P5,P8 SC1 JE count3d type=time_energy spin_average=No cjf=JE yleft_auto=Manual yleft_min=10 yleft_max=26000 z_showdir=No z_theta=No z_phi=No',	$
			'0 Time Theta JE#		INTERBALL-ELECTRON P4,P5,P8 SC1 JE count3d type=time_theta spin_average=No cjf=JE yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',			$
			'0 Time Pitchangle JE#      	INTERBALL-ELECTRON P4,P5,P8 SC1 JE count3d type=time_pitchangle spin_average=No Bresolution=FM3I cjf=JE yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
			'0 Energy Pitchangle JE#	INTERBALL-ELECTRON P4,P5,P8 SC1 JE count3d type=energy_pitchangle cjf=JE z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',									$
			'0 Phi Theta JE#            	INTERBALL-ELECTRON P4,P5,P8 SC1 JE count3d type=phi_theta spin_average=No Bresolution=FM3I cjf=JE yleft_auto=Automatic x_auto=Automatic z_showdir=No z_theta=No z_phi=No',	$
			'0 Distribution Function JE#	INTERBALL-ELECTRON P4,P5,P8 SC1 JE count3d type=Distribution'+STRING(2b)+'Function log0use=Yes spin_average=No Bresolution=FM3I cjf=JE interp_nochamp=TRIGRID x_auto=Manual x_min=-50000.0 x_max=50000.0 yleft_auto=Manual yleft_min=-50000.0 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No',	$
		'5 Particle plot ' + get_cldataset_starttime_endtime('INTERBALL-ELECTRON',[4,5,8],'SC1'),																$
			'0 Time JE#			INTERBALL-ELECTRON P4,P5,P8 SC1 JE  count2d type=time_cjf spin_average=No cjf=JE legend_theta=No legend_phi=No',	$
			'0 Energy JE#			INTERBALL-ELECTRON P4,P5,P8 SC1 JE  count2d type=energy_cjf cjf=JE legend_theta=No legend_phi=No',			$
			'0 Pitchangle c/s#		INTERBALL-ELECTRON P4,P5,P8 SC1 c/s count2d type=pitch_cjf  Bresolution=FM3I cjf=c/s legend_theta=No legend_phi=No',	$
		'</instrument>', $
		'</mission>' $
	]

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_interball_auroral
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL INTERBALL-AURORAL.
;-------------------------------------------------------------------------------

; Trouv dans spase://SMWG/Observatory/Interball-2
;
; <ObservatoryRegion>Heliosphere.NearEarth</ObservatoryRegion>
;

	target  = "Earth.NearSurface.AuroralRegion"	; V. Genot
	targets = "Earth.NearSurface.AuroralRegion"	; V. Genot

	arbre = [													$
		'<mission name="INTERBALL-AURORAL" id="INTERBALL-AURORAL" target="'+target+'" targets="'+targets+'">3 AURORAL',	$
		'<instrument name="ephemeris" id="INTERBALL-AURORAL:ephemeris">4 ephemeris']

	tab = [	'cl	H,Lambda0,MLT,LONG	H,Lambda0,MLT,LONG      orbito',	$
		'cl,ws	H			#			header',	$
		'cl,ws	Lambda0			#			header',	$
		'cl,ws	MLT			#			header',	$
		'cl,ws	LONG			#			header',	$
		'cl,ws	Nb_orbit		#			header'		]
	ajouter_dataset, arbre, '<dataset id="INTERBALL-AURORAL:EPHEMERIS:ORBIT_ELEC">5 orbit from ELEC', 'INTERBALL-ELEC1CH1', 4, 'SC1', tab, 'IA_EPHEMERIS_ORBIT_ELEC', 'interball_elec1ch1'

	tab = [	'cl	H,Lambda0,MLT,LONG	H,Lambda0,MLT,LONG      orbito',	$
		'cl,ws	H			#			header',	$
		'cl,ws	Lambda0			#			header',	$
		'cl,ws	MLT			#			header',	$
		'cl,ws	LONG			#			header',	$
		'cl,ws	Nb_orbit		#			header'		]
	ajouter_dataset, arbre, '<dataset id="INTERBALL-AURORAL:EPHEMERIS:ORBIT_ION">5 orbit from ION', 'INTERBALL-ION1CH1', 21, 'SC1', tab, 'IA_EPHEMERIS_ORBIT_ION', 'interball_ion1ch1'

	arbre = [ arbre, $
		'</instrument>', $
		'<instrument name="IMAP3" id="INTERBALL-AURORAL:IMAP3">4 IMAP3']

	tab = [	'cl,ws	Bx_sc_nT 		#  			header',	$
		'cl,ws	By_sc_nT 		#  			header',	$
		'cl,ws	Bz_sc_nT 		#  			header',	$
		'cl,ws	B_nT 			#  			header',	$
		'cl,ws	Mode 			#  			header'		]
	ajouter_dataset, arbre, '<dataset id="INTERBALL-AURORAL:IMAP3:MAG">5 Magnetic field SC coordinates', 'INTERBALL-IMAP3', 0, 'SC1', tab, 'IT_IMAP3_MAG', 'interball_imap3'

	tab = [	'cl,ws	Bx_gsm_nT 		#  			header',	$
		'cl,ws	By_gsm_nT 		#  			header',	$
		'cl,ws	Bz_gsm_nT 		#  			header',	$
		'cl,ws	B_nT 			#  			header',	$
		'cl,ws	Bxd_nT 			#  			header',	$
		'cl,ws	Byd_nT 			#  			header',	$
		'cl,ws	Bzd_nT 			#  			header',	$
		'cl,ws	Bd_nT 			#  			header',	$
		'cl,ws	Mode 			#  			header'		]
	ajouter_dataset, arbre, '<dataset id="INTERBALL-AURORAL:IMAP3:MAA">5 Magnetic field GSM coordinates', 'INTERBALL-IMAP3', 1, 'SC1', tab, 'IT_IMAP3_MAA', 'interball_imap3'


	FOR x=1L,2 DO BEGIN
		FOR y=1L,2 DO BEGIN
			sx = val_to_str(x)
			sy = val_to_str(y)

			arbre = [ arbre, $
				'</instrument>', $
				'<instrument name="ELEC'+sx+'CH'+sy+'" id="INTERBALL-AURORAL:ELEC'+sx+'CH'+sy+'">4 ELEC'+sx+'CH'+sy]

			; Spectro ELECxCHy uniquement pour webservice
			info1 = [							$
					{ noproduit:0,	nomproduit:'32E_32S' 	},	$
					{ noproduit:1,	nomproduit:'32E_64S' 	},	$
					{ noproduit:2,	nomproduit:'32E_128S' 	}	]

			; 3 units
			FOR i=0L,N_ELEMENTS(info1)-1 DO BEGIN
				tab = [	'ws	1d_data 		# count3d type=time_energy spin_average=No cjf=c/s yleft_auto=Manual yleft_min=10 yleft_max=26000 z_showdir=No z_theta=No z_phi=No',	$
					'ws	1d_data 		# count3d type=time_energy spin_average=No cjf=flux yleft_auto=Manual yleft_min=10 yleft_max=26000 z_showdir=No z_theta=No z_phi=No',	$
					'ws	1d_data 		# count3d type=time_energy spin_average=No cjf=JE yleft_auto=Manual yleft_min=10 yleft_max=26000 z_showdir=No z_theta=No z_phi=No']
				ajouter_dataset, arbre, '<dataset id="INTERBALL-AURORAL:ELEC'+sx+'CH'+sy+':'+info1[i].nomproduit+'_SPECTRO_TIME_ENERGY" visibility="ws">5 '+info1[i].nomproduit+' Spectrogram Time Energy', 'INTERBALL-ELEC'+sx+'CH'+sy, info1[i].noproduit, 'SC1', tab, 'IA_ELEC'+sx+'CH'+sy+'_'+info1[i].nomproduit+'_SPECTRO_TIME_ENERGY', 'interball_elec'+sx+'ch'+sy, /spectro
			END

			arbre = [ arbre, $
				'5 Particle spectrogram ' + get_cldataset_starttime_endtime('INTERBALL-ELEC'+sx+'CH'+sy,[0,1,2],'SC1'),														$
				'0 Time Energy JE#		INTERBALL-ELEC'+sx+'CH'+sy+' P0,P1,P2 SC1 JE count3d type=time_energy spin_average=No cjf=JE yleft_auto=Manual yleft_min=10 yleft_max=26000 z_showdir=No z_theta=No z_phi=No',	$
				'5 Particle plot ' + get_cldataset_starttime_endtime('INTERBALL-ELEC'+sx+'CH'+sy,[0,1,2],'SC1'),														$
				'0 Time JE#			INTERBALL-ELEC'+sx+'CH'+sy+' P0,P1,P2 SC1 JE count2d type=time_cjf spin_average=No cjf=JE legend_theta=No legend_phi=No',							$
				'0 Energy JE#			INTERBALL-ELEC'+sx+'CH'+sy+' P0,P1,P2 SC1 JE count2d type=energy_cjf cjf=JE legend_theta=No legend_phi=No'									$
			]

			tab = [	'cl,ws	pitchangle	#       header' ]
			ajouter_dataset, arbre, '<dataset id="INTERBALL-AURORAL:PITCHANGLE:ELEC'+sx+'CH'+sy+'">5 Pitchangle', 'INTERBALL-ELEC'+sx+'CH'+sy, 3, 'SC1', tab, 'IA_PITCHANGLE_ELEC'+sx+'CH'+sy, 'interball_elec'+sx+'CH'+sy
		END
	END

	tm1 = ['H+','He++','He+','O+']
	tm2 = ['H1','He2', 'He1','O1']
	FOR x=1L,2 DO BEGIN
		FOR y=1L,2 DO BEGIN
			sx = val_to_str(x)
			sy = val_to_str(y)

			arbre = [ arbre, $
				'</instrument>', $
				'<instrument name="ION'+sx+'CH'+sy+'" id="INTERBALL-AURORAL:ION'+sx+'CH'+sy+'">4 ION'+sx+'CH'+sy]

			FOR m=0L,3 DO BEGIN
				sm1 = tm1[m]
				sm2 = tm2[m]

				; Spectro IONxCHyMm uniquement pour webservice
				info1 = [							$
						{ noproduit:5*m+0,	nomproduit:'16E_16S' 	},	$
						{ noproduit:5*m+1,	nomproduit:'16E_32S' 	},	$
						{ noproduit:5*m+2,	nomproduit:'32E_16S' 	},	$
						{ noproduit:5*m+3,	nomproduit:'32E_32S' 	},	$
						{ noproduit:5*m+4,	nomproduit:'32E_64S' 	}	]


				FOR i=0L,N_ELEMENTS(info1)-1 DO BEGIN


					; Certains produits n'ont jamais de donnes
					tmp = 'ION'+sx+'_CH'+sy+'_'+info1[i].nomproduit+'_'+sm2


					IF tmp EQ 'ION1_CH1_32E_64S_He2' THEN CONTINUE
					IF tmp EQ 'ION1_CH1_32E_64S_He1' THEN CONTINUE

					IF tmp EQ 'ION1_CH2_32E_32S_He2' THEN CONTINUE
					IF tmp EQ 'ION1_CH2_32E_64S_He2' THEN CONTINUE
					IF tmp EQ 'ION1_CH2_32E_32S_He1' THEN CONTINUE
					IF tmp EQ 'ION1_CH2_32E_64S_He1' THEN CONTINUE

					IF tmp EQ 'ION2_CH1_32E_64S_He2' THEN CONTINUE
					IF tmp EQ 'ION2_CH1_32E_64S_He1' THEN CONTINUE

					IF tmp EQ 'ION2_CH2_32E_32S_He2' THEN CONTINUE
					IF tmp EQ 'ION2_CH2_32E_64S_He2' THEN CONTINUE
					IF tmp EQ 'ION2_CH2_32E_32S_He1' THEN CONTINUE
					IF tmp EQ 'ION2_CH2_32E_64S_He1' THEN CONTINUE


					; 3 units
					tab = [	'ws	1d_data # count3d type=time_energy ion_nochamp='+sm1+' spin_average=No cjf=c/s  yleft_auto=Manual yleft_min=600 yleft_max=15600 z_showdir=No z_theta=No z_phi=No',	$
						'ws	1d_data # count3d type=time_energy ion_nochamp='+sm1+' spin_average=No cjf=flux yleft_auto=Manual yleft_min=600 yleft_max=15600 z_showdir=No z_theta=No z_phi=No',	$
						'ws	1d_data # count3d type=time_energy ion_nochamp='+sm1+' spin_average=No cjf=JE   yleft_auto=Manual yleft_min=600 yleft_max=15600 z_showdir=No z_theta=No z_phi=No'	$
					]
					ajouter_dataset, arbre, '<dataset id="INTERBALL-AURORAL:ION'+sx+'CH'+sy+':'+info1[i].nomproduit+'_'+sm2+'_SPECTRO_TIME_ENERGY" visibility="ws">5 '+info1[i].nomproduit+' '+sm1+' Spectrogram Time Energy', 'INTERBALL-ION'+sx+'CH'+sy, info1[i].noproduit, 'SC1', tab, 'IA_ION'+sx+'CH'+sy+'_'+info1[i].nomproduit+'_'+sm2+'_SPECTRO_TIME_ENERGY', 'interball_ion'+sx+'ch'+sy, /spectro
				END

			END

			arbre = [ arbre, 																															$
				'5 Particle spectrogram ' + get_cldataset_starttime_endtime('INTERBALL-ION'+sx+'CH'+sy,[0,1,2,3,4],'SC1'),																			$
				'0 Time Energy JE H+#		INTERBALL-ION'+sx+'CH'+sy+' P0,P1,P2,P3,P4      SC1 JE count3d type=time_energy ion_nochamp=H+ spin_average=No cjf=JE yleft_auto=Manual yleft_min=600 yleft_max=15600 z_showdir=No z_theta=No z_phi=No',			$
				'0 Time Energy JE He++#		INTERBALL-ION'+sx+'CH'+sy+' P5,P6,P7,P8,P9      SC1 JE count3d type=time_energy ion_nochamp=He++ spin_average=No cjf=JE yleft_auto=Manual yleft_min=600 yleft_max=15600 z_showdir=No z_theta=No z_phi=No',			$
				'0 Time Energy JE He+#		INTERBALL-ION'+sx+'CH'+sy+' P10,P11,P12,P13,P14 SC1 JE count3d type=time_energy ion_nochamp=He+ spin_average=No cjf=JE yleft_auto=Manual yleft_min=600 yleft_max=15600 z_showdir=No z_theta=No z_phi=No',			$
				'0 Time Energy JE O+#		INTERBALL-ION'+sx+'CH'+sy+' P15,P16,P17,P18,P19 SC1 JE count3d type=time_energy ion_nochamp=O+ spin_average=No cjf=JE yleft_auto=Manual yleft_min=600 yleft_max=15600 z_showdir=No z_theta=No z_phi=No',			$
				'5 Particle plot ' + get_cldataset_starttime_endtime('INTERBALL-ION'+sx+'CH'+sy,[0,1,2,3,4],'SC1'),																				$
				'0 Time JE H+#			INTERBALL-ION'+sx+'CH'+sy+' P0,P1,P2,P3,P4      SC1 JE count2d type=time_cjf ion_nochamp=H+ spin_average=No cjf=JE legend_theta=No legend_phi=No',										$
				'0 Time JE He++#		INTERBALL-ION'+sx+'CH'+sy+' P5,P6,P7,P8,P9      SC1 JE count2d type=time_cjf ion_nochamp=He++ spin_average=No cjf=JE legend_theta=No legend_phi=No',										$
				'0 Time JE He+#			INTERBALL-ION'+sx+'CH'+sy+' P10,P11,P12,P13,P14 SC1 JE count2d type=time_cjf ion_nochamp=He+ spin_average=No cjf=JE legend_theta=No legend_phi=No',										$
				'0 Time JE O+#			INTERBALL-ION'+sx+'CH'+sy+' P15,P16,P17,P18,P19 SC1 JE count2d type=time_cjf ion_nochamp=O+ spin_average=No cjf=JE legend_theta=No legend_phi=No',										$
				'0 Energy JE H+#		INTERBALL-ION'+sx+'CH'+sy+' P0,P1,P2,P3,P4      SC1 JE count2d type=energy_cjf ion_nochamp=H+ cjf=JE legend_theta=No legend_phi=No',												$
				'0 Energy JE He++#		INTERBALL-ION'+sx+'CH'+sy+' P5,P6,P7,P8,P9      SC1 JE count2d type=energy_cjf ion_nochamp=He++ cjf=JE legend_theta=No legend_phi=No',												$
				'0 Energy JE He+#		INTERBALL-ION'+sx+'CH'+sy+' P10,P11,P12,P13,P14 SC1 JE count2d type=energy_cjf ion_nochamp=He+ cjf=JE legend_theta=No legend_phi=No',												$
				'0 Energy JE O+#		INTERBALL-ION'+sx+'CH'+sy+' P15,P16,P17,P18,P19 SC1 JE count2d type=energy_cjf ion_nochamp=O+ cjf=JE legend_theta=No legend_phi=No'												$
			]

			tab = [	'cl,ws	pitchangle	#       header' ]
			ajouter_dataset, arbre, '<dataset id="INTERBALL-AURORAL:PITCHANGLE:ION'+sx+'CH'+sy+'">5 Pitchangle', 'INTERBALL-ION'+sx+'CH'+sy, 20, 'SC1', tab, 'IA_PITCHANGLE_ION'+sx+'CH'+sy, 'interball_ion'+sx+'CH'+sy
		END
	END

	arbre = [ arbre,		$
		'</instrument>', 	$
		'</mission>' 		$
	]

	RETURN, arbre

END

;-------------------------------------------------------------------------------
FUNCTION get_arbre_solar
;-------------------------------------------------------------------------------
; Retourne l'arbre des donnes CL de SOLAR-ORBITER.
;-------------------------------------------------------------------------------
;
	COMMON COMMON_CL, general

	create_products, 'SOLAR'

	p = get(general,'p') ; p[noproduit,nocis,nosat]

	target  = "Heliosphere.NearEarth"			; E. Penou
	targets = "Heliosphere.NearEarth Heliosphere.Inner"	; spase

	arbre = [ '<mission name="SOLAR" id="SOLAR" target="'+target+'" targets="'+targets+'">2 SOLAR-ORBITER' ]

	nomsat = 'SC1'
	nosat = STRMID(nomsat,2)

        nomcis = 'SOLAR-EPHEMERIS'
	arbre = [ arbre, '<instrument name="EPHEMERIS" id="SOLAR:EPHEMERIS">3 EPHEMERIS' ]

		; attitude SOLAR_PAS -> SOLAR_RTN
		noproduit = [0]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="SOLAR:EPHEMERIS:ATTITUDE_PAS_RTN">4 PAS -> RTN', nomcis, noproduit, nomsat, tab, 'SOLAR_EPHEMERIS_ATTITUDE_PAS_RTN', 'solar_ephemeris'

		; V_SOLO_RTN
		noproduit = [1]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="SOLAR:EPHEMERIS:V_SOLO_RTN">4 V_SOLO_RTN', nomcis, noproduit, nomsat, tab, 'SOLAR_EPHEMERIS_V_SOLO_RTN', 'solar_ephemeris'

		; ORBIT
		noproduit = [2]
		vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
		tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
		ajouter_dataset, arbre, '<dataset id="SOLAR:EPHEMERIS:ORBIT">4 ORBIT', nomcis, noproduit, nomsat, tab, 'SOLAR_EPHEMERIS_ORBIT', 'solar_ephemeris'

	arbre = [ arbre, '</instrument>' ]

	nomcis = 'SOLAR-MAG'
	arbre = [ arbre, '<instrument name="MAG" id="SOLAR:MAG">3 MAG' ]

		arbre = [ arbre, '4 l2' ]

			; L2_CDAG
			; -------
			noproduit = 0
			vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
			ajouter_dataset, arbre, '<dataset id="SOLAR:MAG:L2_CDAG">5 CDAG', nomcis, noproduit, nomsat, tab, 'SOLAR_MAG_L2-CDAG', 'solar_mag'

			; L2_RTN-NORMAL
			; ------------
			noproduit = 1
			vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
			ajouter_dataset, arbre, '<dataset id="SOLAR:MAG:L2_RTN-NORMAL">5 RTN-NORMAL', nomcis, noproduit, nomsat, tab, 'SOLAR_MAG_L2_RTN-NORMAL', 'solar_mag'

			; L2_RTN-NORMAL-1-MINUTE
			; ----------------------
			noproduit = 2
			vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
			ajouter_dataset, arbre, '<dataset id="SOLAR:MAG:L2_RTN-NORMAL-1-MINUTE">5 RTN-NORMAL-1-MINUTE', nomcis, noproduit, nomsat, tab, 'SOLAR_MAG_L2_RTN-NORMAL-1-MINUTE', 'solar_mag'

			; L2_RTN-BURST
			; ------------
			noproduit = 3
			vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
			ajouter_dataset, arbre, '<dataset id="SOLAR:MAG:L2_RTN-BURST">5 RTN-BURST', nomcis, noproduit, nomsat, tab, 'SOLAR_MAG_L2_RTN-BURST', 'solar_mag'

			; L2_SRF-NORMAL
			; -------------
			noproduit = 4
			vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
			ajouter_dataset, arbre, '<dataset id="SOLAR:MAG:L2_SRF-NORMAL">5 SRF-NORMAL', nomcis, noproduit, nomsat, tab, 'SOLAR_MAG_L2_SRF-NORMAL', 'solar_mag'

			; L2_SRF-BURST
			; ------------
			noproduit = 5
			vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
			ajouter_dataset, arbre, '<dataset id="SOLAR:MAG:L2_SRF-BURST">5 SRF-BURST', nomcis, noproduit, nomsat, tab, 'SOLAR_MAG_L2_SRF-BURST', 'solar_mag'

	arbre = [ arbre, '</instrument>' ]

	nomcis = 'SOLAR-FORMAGONLY'
	arbre = [ arbre, '<instrument name="FORMAGONLY" id="SOLAR:FORMAGONLY">3 MAG (formagonly)' ]

		arbre = [ arbre, '4 l2' ]

			; L2_RTN-NORMAL-FORMAGONLY
			; ------------------------
			noproduit = 0
			vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
			ajouter_dataset, arbre, '<dataset id="SOLAR:MAG:L2_RTN-NORMAL_FORMAGONLY">5 RTN-NORMAL-FORMAGONLY', nomcis, noproduit, nomsat, tab, 'SOLAR_MAG_L2_RTN-NORMAL-FORMAGONLY', 'solar_mag'

			; L2_RTN-NORMAL-1-MINUTE-FORMAGONLY
			; ---------------------------------
			noproduit = 1
			vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
			ajouter_dataset, arbre, '<dataset id="SOLAR:MAG:RTN-NORMAL-1-MINUTE-FORMAGONLY">5 RTN-NORMAL-1-MINUTE-FORMAGONLY', nomcis, noproduit, nomsat, tab, 'SOLAR_MAG_L2_RTN-NORMAL-1-MINUTE-FORMAGONLY', 'solar_mag'

			; L2_RTN-BURST-FORMAGONLY
			; -----------------------
			noproduit = 2
			vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
			ajouter_dataset, arbre, '<dataset id="SOLAR:MAG:L2_RTN-BURST-FORMAGONLY">5 RTN-BURST-FORMAGONLY', nomcis, noproduit, nomsat, tab, 'SOLAR_MAG_L2_RTN-BURST-FORMAGONLY', 'solar_mag'

			; L2_SRF-NORMAL-FORMAGONLY
			; ------------------------
			noproduit = 3
			vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
			ajouter_dataset, arbre, '<dataset id="SOLAR:MAG:L2_SRF-NORMAL_FORMAGONLY">5 SRF-NORMAL-FORMAGONLY', nomcis, noproduit, nomsat, tab, 'SOLAR_MAG_L2_SRF-NORMAL-FORMAGONLY', 'solar_mag'

	arbre = [ arbre, '</instrument>' ]

	nomcis = 'SOLAR-PAS'
	arbre = [ arbre, '<instrument name="PAS" id="SOLAR:PAS">3 PAS' ]

		arbre = [ arbre, '4 l1' ]

			; HSK
			; ---
			noproduit = 0
			vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
			ajouter_dataset, arbre, '<dataset id="SOLAR:PAS:HSK">5 HSK', nomcis, noproduit, nomsat, tab, 'SOLAR_PAS_HSK', 'solar_pas'

			; CAL
			; ---
			noproduit = 3
			vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header legend_exp=Yes'
			ajouter_dataset, arbre, '<dataset id="SOLAR:PAS:CAL">5 CAL', nomcis, noproduit, nomsat, tab, 'SOLAR_PAS_CAL', 'solar_pas'

			; MOM
			; ---
			noproduit = 2
			vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
			ajouter_dataset, arbre, '<dataset id="SOLAR:PAS:MOM">5 MOM (On board moments)', nomcis, noproduit, nomsat, tab, 'SOLAR_PAS_MOM', 'solar_pas'

			; L1 3D
			; -----
			noproduit = [1]
			arbre = [ arbre, '5 3D ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

			; "Timeseries"
			vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
				; modifier l'entre avec "SOURCE"
				ind = WHERE (STRMID(tab,0,10) EQ "cl SOURCE ")
				tab[ind[0]] = 'cl SOURCE # header hlineon=No'+STRING(2b)+'line yleft_auto=Manual yleft_min=-1 yleft_max=4 yleft_tickv=0'+STRING(2b)+'1'+STRING(2b)+'2'+STRING(2b)+'3 yleft_tickname=Normal'+STRING(2b)+'Snapshot'+STRING(2b)+'Burst'+STRING(2b)+'Trigger'
				; modifier l'entre avec "INFO"
				ind = WHERE (STRMID(tab,0,8) EQ "cl INFO ")
				tab[ind[0]] = 'cl INFO # header hlineon=No'+STRING(2b)+'line yleft_auto=Manual yleft_min=-1 yleft_max=6 yleft_tickv=0'+STRING(2b)+'1'+STRING(2b)+'2'+STRING(2b)+'3'+STRING(2b)+'4'+STRING(2b)+'5 yleft_tickname=Ground'+STRING(2b)+'Normal'+STRING(2b)+'Snapshot'+STRING(2b)+'Burst'+STRING(2b)+'Engineering'+STRING(2b)+'Calib'
				; modifier l'entre avec "FULL_3D"
				ind = WHERE (STRMID(tab,0,11) EQ "cl FULL_3D ")
				tab[ind[0]] = 'cl FULL_3D # header hlineon=No'+STRING(2b)+'line yleft_auto=Manual yleft_min=-0.5 yleft_max=1.5 yleft_tickv=0'+STRING(2b)+'1 yleft_tickname=0'+STRING(2b)+'1'
			ajouter_dataset, arbre, '<dataset id="SOLAR:PAS:3DL1">6 Timeseries', nomcis, noproduit, nomsat, tab, 'SOLAR_3DL1', 'solar_pas', /notime

			; "Particle spectrogram" et "Particle plot"
			unite = 'count'
			nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
			arbre = [ arbre, 																																																			$
				'6 Particle spectrogram',																																																	$
					'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy                        Bresolution=L2_SRF-NORMAL cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																								$
					'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta                         Bresolution=L2_SRF-NORMAL cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																								$
					'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi                           Bresolution=L2_SRF-NORMAL cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																				$
					'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle		       Bresolution=L2_SRF-NORMAL cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=10 emax_nochamp=20000',										$
					'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle                  Bresolution=L2_SRF-NORMAL pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																					$
					'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta                          Bresolution=L2_SRF-NORMAL cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Automatic z_showdir=No z_theta=No z_phi=No',																		$
					'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=L2_SRF-NORMAL log0use=No cjf='+unite+' width_nochamp=1000 interp_nochamp=None x_auto=Manual x_auto=Manual x_min=-1000.0 x_max=1000 yleft_auto=Manual yleft_min=-1000.0 yleft_max=1000.0 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=5',	$
				'6 Particle plot',																																																		$
					'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf                           Bresolution=L2_SRF-NORMAL cjf='+unite+' legend_theta=No legend_phi=No',																											$
					'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf                         Bresolution=L2_SRF-NORMAL cjf='+unite+' x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																							$
					'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf                         Bresolution=L2_SRF-NORMAL cjf='+unite+' spinaccu=0 time_onespin=No x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																				$
					'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf                          Bresolution=L2_SRF-NORMAL cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																								$
			]

			; 3D MOMENTS
			tab = [	'cl	N_cm3												#  					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec								Vx,Vy,Vz,|V| 				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vx_sc_km_sec,Vy_sc_km_sec,Vz_sc_km_sec,*V_km_sec						Vx_sc,Vy_sc,Vz_sc,|V| 			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vr_rtn_km_sec,Vt_rtn_km_sec,Vn_rtn_km_sec,*V_km_sec						Vr,Vt,Vn,|V| 				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3								Ppar,Pper1,Pper2 			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3							Ppar_b,Pper1_b,Pper2_b 			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Tpar_eV,Tper1_eV,Tper2_eV									Tpar,Tper1,Tper2 			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV									Tpar_b,Tper1_b,Tper2_b 			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2					Qx,Qy,Qz,|Q|				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qx_sc_erg_sec_cm2,Qy_sc_erg_sec_cm2,Qz_sc_erg_sec_cm2,*Q_erg_sec_cm2				Qx_sc,Qy_sc,Qz_sc,|Q|			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qr_rtn_erg_sec_cm2,Qt_rtn_erg_sec_cm2,Qn_rtn_erg_sec_cm2,*Q_erg_sec_cm2				Qr,Qt,Qn,|Q|				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2				Qxpar,Qypar,Qzpar,|Qpar|		count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2				Qxpar,Qypar,Qzpar,|Qper|		count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3				Pxx,Pxy,Pxz,Pyy,Pyz,Pzz			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				;'cl	Pxx_eV_cm3_pas,Pxy_eV_cm3_pas,Pxz_eV_cm3_pas,Pyy_eV_cm3_pas,Pyz_eV_cm3_pas,Pzz_eV_cm3_pas	Pxx,Pxy,Pxz,Pyy,Pyz,Pzz			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Pxx_eV_cm3_b,Pxy_eV_cm3_b,Pxz_eV_cm3_b,Pyy_eV_cm3_b,Pyz_eV_cm3_b,Pzz_eV_cm3_b			Pxx_b,Pxy_b,Pxz_b,Pyy_b,Pyz_b,Pzz_b	count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ei_eV_cm3											#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ti_eV												#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ex,Ey,Ez											Ex,Ey,Ez				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ex_sc,Ey_sc,Ez_sc										Ex_sc,Ey_sc,Ez_sc			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Er_rtn,Et_rtn,En_rtn										Er,Et,En				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	EV1x,EV1y,EV1z											EV1x,EV1y,EV1z				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	EV2x,EV2y,EV2z											EV2x,EV2y,EV2z				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	EV3x,EV3y,EV3z											EV3x,EV3y,EV3z				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vxpar_pas_km_sec,Vypar_pas_km_sec,Vzpar_pas_km_sec,*Vpar_pas_km_sec				Vxpar,Vypar,Vzpar,|Vpar|		count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vxper_pas_km_sec,Vyper_pas_km_sec,Vzper_pas_km_sec,*Vper_pas_km_sec				Vxper,Vyper,Vzper,|Vper|		count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Elx_pas_mV_m,Ely_pas_mV_m,Elz_pas_mV_m,El_pas_mV_m						Elx,Ely,Elz,|El|			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Pp_nPa												#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Pm_nPa												#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Pt_nPa												#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Beta												#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	TBD_nPa												#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vxalfven_pas_km_sec,Vyalfven_pas_km_sec,Vzalfven_pas_km_sec,*Valfven_km_sec			Vx,Vy,Vz,[V|				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	An												#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ng												#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Bx_nT,By_nT,Bz_nT										Bx,By,Bz				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Bx_sc_nT,By_sc_nT,Bz_sc_nT									Bx,By,Bz				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Br_rtn_nT,Bt_rtn_nT,Bn_rtn_nT									Br,Bt,Bn				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Scpot_V												#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No'				$
			]
			ajouter_dataset, arbre, '<dataset id="SOLAR:PAS:3DL1MOMENTS">6 3D moments', nomcis, noproduit, nomsat, tab, 'SOLAR_PAS_3DL1MOMENTS', 'solar_pas', /moments, /notime

		arbre = [ arbre, '4 l2' ]

			; L2 MOM
			; ------
			noproduit = 5
			vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
				; modifier l'entre avec "Info"
				ind = WHERE (STRMID(tab,0,8) EQ "cl Info ")
				tab[ind[0]] = 'cl Info # header hlineon=No'+STRING(2b)+'line yleft_auto=Manual yleft_min=-1 yleft_max=6 yleft_tickv=0'+STRING(2b)+'1'+STRING(2b)+'2'+STRING(2b)+'3'+STRING(2b)+'4'+STRING(2b)+'5 yleft_tickname=Ground'+STRING(2b)+'Normal'+STRING(2b)+'Snapshot'+STRING(2b)+'Burst'+STRING(2b)+'Engineering'+STRING(2b)+'Calib'
			ajouter_dataset, arbre, '<dataset id="SOLAR:PAS:MOML2">5 MOM (On ground moments)', nomcis, noproduit, nomsat, tab, 'SOLAR_PAS_MOML2', 'solar_pas'

			; L2 1D
			; -----
			noproduit = [6]
			arbre = [ arbre, '5 1D ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

			; "Timeseries"
			vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
				; modifier l'entre avec "Info"
				ind = WHERE (STRMID(tab,0,8) EQ "cl Info ")
				tab[ind[0]] = 'cl Info # header hlineon=No'+STRING(2b)+'line yleft_auto=Manual yleft_min=-1 yleft_max=6 yleft_tickv=0'+STRING(2b)+'1'+STRING(2b)+'2'+STRING(2b)+'3'+STRING(2b)+'4'+STRING(2b)+'5 yleft_tickname=Ground'+STRING(2b)+'Normal'+STRING(2b)+'Snapshot'+STRING(2b)+'Burst'+STRING(2b)+'Engineering'+STRING(2b)+'Calib'
			ajouter_dataset, arbre, '<dataset id="SOLAR:PAS:1DL2">6 Timeseries', nomcis, noproduit, nomsat, tab, 'SOLAR_1DL2', 'solar_pas', /notime

			; "Particle spectrogram" et "Particle plot"
			unite = 'JE->JE'
			nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
			arbre = [ arbre, 																																															$
				'6 Particle spectrogram',																																													$
					'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy                        Bresolution=L2_SRF-NORMAL cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																				$
				'6 Particle plot',																																														$
					'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf                           Bresolution=L2_SRF-NORMAL cjf='+unite+' legend_theta=No legend_phi=No',																								$
					'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf                         Bresolution=L2_SRF-NORMAL cjf='+unite+' x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																				$
					'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf                         Bresolution=L2_SRF-NORMAL cjf='+unite+' spinaccu=0 time_onespin=No x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic'																	$
			]

			; L2 3D
			; -----
			noproduit = [4]
			arbre = [ arbre, '5 3D ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

			; "Timeseries"
			vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
				; modifier l'entre avec "Info"
				ind = WHERE (STRMID(tab,0,8) EQ "cl Info ")
				tab[ind[0]] = 'cl Info # header hlineon=No'+STRING(2b)+'line yleft_auto=Manual yleft_min=-1 yleft_max=6 yleft_tickv=0'+STRING(2b)+'1'+STRING(2b)+'2'+STRING(2b)+'3'+STRING(2b)+'4'+STRING(2b)+'5 yleft_tickname=Ground'+STRING(2b)+'Normal'+STRING(2b)+'Snapshot'+STRING(2b)+'Burst'+STRING(2b)+'Engineering'+STRING(2b)+'Calib'
			ajouter_dataset, arbre, '<dataset id="SOLAR:PAS:3DL2">6 Timeseries', nomcis, noproduit, nomsat, tab, 'SOLAR_3DL2', 'solar_pas', /notime

			; "Particle spectrogram" et "Particle plot"
			unite = 'fdist->fdist'
			nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
			arbre = [ arbre, 																																																			$
				'6 Particle spectrogram',																																																	$
					'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy                        Bresolution=L2_SRF-NORMAL cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																								$
					'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta                         Bresolution=L2_SRF-NORMAL cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																								$
					'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi                           Bresolution=L2_SRF-NORMAL cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																				$
					'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle 		       Bresolution=L2_SRF-NORMAL cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=10 emax_nochamp=20000',										$
					'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle 		       Bresolution=L2_SRF-NORMAL pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																					$
					'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta                          Bresolution=L2_SRF-NORMAL cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Automatic z_showdir=No z_theta=No z_phi=No',																		$
					'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=L2_SRF-NORMAL log0use=No cjf='+unite+' width_nochamp=1000 interp_nochamp=None x_auto=Manual x_auto=Manual x_min=-1000.0 x_max=1000 yleft_auto=Manual yleft_min=-1000.0 yleft_max=1000.0 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=5',	$
				'6 Particle plot',																																																		$
					'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf                           Bresolution=L2_SRF-NORMAL cjf='+unite+' legend_theta=No legend_phi=No',																											$
					'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf                         Bresolution=L2_SRF-NORMAL cjf='+unite+' x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																							$
					'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf                         Bresolution=L2_SRF-NORMAL cjf='+unite+' spinaccu=0 time_onespin=No x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																				$
					'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf                          Bresolution=L2_SRF-NORMAL cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																								$
			]

			; 3D MOMENTS
			tab = [	'cl	N_cm3												#  					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec								Vx,Vy,Vz,|V| 				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vx_sc_km_sec,Vy_sc_km_sec,Vz_sc_km_sec,*V_km_sec						Vx_sc,Vy_sc,Vz_sc,|V| 			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vr_rtn_km_sec,Vt_rtn_km_sec,Vn_rtn_km_sec,*V_km_sec						Vr,Vt,Vn,|V| 				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3								Ppar,Pper1,Pper2 			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3							Ppar_b,Pper1_b,Pper2_b 			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Tpar_eV,Tper1_eV,Tper2_eV									Tpar,Tper1,Tper2 			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV									Tpar_b,Tper1_b,Tper2_b 			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2					Qx,Qy,Qz,|Q|				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qx_sc_erg_sec_cm2,Qy_sc_erg_sec_cm2,Qz_sc_erg_sec_cm2,*Q_erg_sec_cm2				Qx_sc,Qy_sc,Qz_sc,|Q|			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qr_rtn_erg_sec_cm2,Qt_rtn_erg_sec_cm2,Qn_rtn_erg_sec_cm2,*Q_erg_sec_cm2				Qr,Qt,Qn,|Q|				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2				Qxpar,Qypar,Qzpar,|Qpar|		count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2				Qxpar,Qypar,Qzpar,|Qper|		count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3				Pxx,Pxy,Pxz,Pyy,Pyz,Pzz			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				;'cl	Pxx_eV_cm3_pas,Pxy_eV_cm3_pas,Pxz_eV_cm3_pas,Pyy_eV_cm3_pas,Pyz_eV_cm3_pas,Pzz_eV_cm3_pas	Pxx,Pxy,Pxz,Pyy,Pyz,Pzz			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Pxx_eV_cm3_b,Pxy_eV_cm3_b,Pxz_eV_cm3_b,Pyy_eV_cm3_b,Pyz_eV_cm3_b,Pzz_eV_cm3_b			Pxx_b,Pxy_b,Pxz_b,Pyy_b,Pyz_b,Pzz_b	count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ei_eV_cm3											#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ti_eV												#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ex,Ey,Ez											Ex,Ey,Ez				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ex_sc,Ey_sc,Ez_sc										Ex_sc,Ey_sc,Ez_sc			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Er_rtn,Et_rtn,En_rtn										Er,Et,En				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	EV1x,EV1y,EV1z											EV1x,EV1y,EV1z				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	EV2x,EV2y,EV2z											EV2x,EV2y,EV2z				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	EV3x,EV3y,EV3z											EV3x,EV3y,EV3z				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vxpar_pas_km_sec,Vypar_pas_km_sec,Vzpar_pas_km_sec,*Vpar_pas_km_sec				Vxpar,Vypar,Vzpar,|Vpar|		count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vxper_pas_km_sec,Vyper_pas_km_sec,Vzper_pas_km_sec,*Vper_pas_km_sec				Vxper,Vyper,Vzper,|Vper|		count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Elx_pas_mV_m,Ely_pas_mV_m,Elz_pas_mV_m,El_pas_mV_m						Elx,Ely,Elz,|El|			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Pp_nPa												#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Pm_nPa												#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Pt_nPa												#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Beta												#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	TBD_nPa												#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vxalfven_pas_km_sec,Vyalfven_pas_km_sec,Vzalfven_pas_km_sec,*Valfven_km_sec			Vx,Vy,Vz,[V|				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	An												#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ng												#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Bx_nT,By_nT,Bz_nT										Bx,By,Bz				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Bx_sc_nT,By_sc_nT,Bz_sc_nT									Bx,By,Bz				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Br_rtn_nT,Bt_rtn_nT,Bn_rtn_nT									Br,Bt,Bn				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Scpot_V												#					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No'				$
			]
			ajouter_dataset, arbre, '<dataset id="SOLAR:PAS:3DL2MOMENTS">6 3D moments', nomcis, noproduit, nomsat, tab, 'SOLAR_PAS_3DL2MOMENTS', 'solar_pas', /moments, /notime

		arbre = [ arbre, '4 l3' ]

			; L3 MOM_IMF
			; ----------
			noproduit = 7
			vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
			ajouter_dataset, arbre, '<dataset id="SOLAR:PAS:MOMIMFL3">5 MOM_IMF (On ground moments)', nomcis, noproduit, nomsat, tab, 'SOLAR_PAS_MOMIMFL3', 'solar_pas'

			; L3 MOM_NOIMF
			; ------------
			noproduit = 8
			vars = p[noproduit,nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header'
			ajouter_dataset, arbre, '<dataset id="SOLAR:PAS:MOMNOIMFL3">5 MOM_NOIMF (On ground moments)', nomcis, noproduit, nomsat, tab, 'SOLAR_PAS_MOMNOIMFL3', 'solar_pas'

			; L3 PROTON 3D
			; ------------
			noproduit = [9]
			arbre = [ arbre, '5 3D PROTON ' + get_cldataset_starttime_endtime(nomcis,noproduit,nomsat)]

			; "Timeseries"
			vars = p[noproduit[0],nomcis_string_to_val(nomcis),nosat] -> pgetproperty(/nom)
			tab = 'cl ' + vars[1:N_ELEMENTS(vars)-1] + ' # header yleft_typetitle=Unit'
				; modifier l'entre avec "Info"
				ind = WHERE (STRMID(tab,0,8) EQ "cl Info ")
				tab[ind[0]] = 'cl Info # header hlineon=No'+STRING(2b)+'line yleft_auto=Manual yleft_min=-1 yleft_max=6 yleft_tickv=0'+STRING(2b)+'1'+STRING(2b)+'2'+STRING(2b)+'3'+STRING(2b)+'4'+STRING(2b)+'5 yleft_tickname=Ground'+STRING(2b)+'Normal'+STRING(2b)+'Snapshot'+STRING(2b)+'Burst'+STRING(2b)+'Engineering'+STRING(2b)+'Calib'
			ajouter_dataset, arbre, '<dataset id="SOLAR:PAS:3DPL3">6 Timeseries', nomcis, noproduit, nomsat, tab, 'SOLAR_3DPL3', 'solar_pas', /notime

			; "Particle spectrogram" et "Particle plot"
			unite = 'fdist->fdist'
			nomcis_nomproduit_nomsat = nomcis + ' '+STRJOIN('P'+val_to_str(noproduit),',')+' '+nomsat
			arbre = [ arbre, 																																																			$
				'6 Particle spectrogram',																																																	$
					'0 Time Energy '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_energy                        Bresolution=L2_SRF-NORMAL cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																								$
					'0 Time Theta '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_theta                         Bresolution=L2_SRF-NORMAL cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No',																								$
					'0 Time Phi '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_phi                           Bresolution=L2_SRF-NORMAL cjf='+unite+' yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No moins180plus180=0&nbsp;360',																				$
					'0 Time Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=time_pitchangle 		       Bresolution=L2_SRF-NORMAL cjf='+unite+' pad_nbalphas=16 bulk_speed_auto=Manual spacecraft_potential_auto=Automatic yleft_auto=Automatic z_showdir=No z_theta=No z_phi=No emin_nochamp=10 emax_nochamp=20000',										$
					'0 Energy Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=energy_pitchangle 		       Bresolution=L2_SRF-NORMAL pad_nbalphas=16 cjf='+unite+' z_showdir=No z_theta=No z_phi=No x_log=Log x_auto=Automatic',																					$
					'0 Phi Theta '+unite+'#            	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=phi_theta                          Bresolution=L2_SRF-NORMAL cjf='+unite+' moins180plus180=0&nbsp;360 yleft_auto=Automatic x_auto=Automatic z_showdir=No z_theta=No z_phi=No',																		$
					'0 Distribution Function '+unite+'#	'+nomcis_nomproduit_nomsat+' '+unite+' count3d type=Distribution'+STRING(2b)+'Function Bresolution=L2_SRF-NORMAL log0use=No cjf='+unite+' width_nochamp=1000 interp_nochamp=None x_auto=Manual x_auto=Manual x_min=-1000.0 x_max=1000 yleft_auto=Manual yleft_min=-1000.0 yleft_max=1000.0 z_zauto=Automatic z_showdir=No z_theta=No z_phi=No z_PT=No Vpar_Vperp_step=5',	$
				'6 Particle plot',																																																		$
					'0 Time '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=time_cjf                           Bresolution=L2_SRF-NORMAL cjf='+unite+' legend_theta=No legend_phi=No',																											$
					'0 Energy '+unite+'#			'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf                         Bresolution=L2_SRF-NORMAL cjf='+unite+' x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																							$
					'0 Energy '+unite+' T1-T2#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=energy_cjf                         Bresolution=L2_SRF-NORMAL cjf='+unite+' spinaccu=0 time_onespin=No x_dx=10000.0 legend_theta=No legend_phi=No x_auto=Automatic',																				$
					'0 Pitchangle '+unite+'#		'+nomcis_nomproduit_nomsat+' '+unite+' count2d type=pitch_cjf                          Bresolution=L2_SRF-NORMAL cjf='+unite+' bulk_speed_auto=Automatic legend_theta=No legend_phi=No'																								$
			]

			; 3D MOMENTS
			tab = [	'cl	N_cm3												#  					count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vx_km_sec,Vy_km_sec,Vz_km_sec,*V_km_sec								Vx,Vy,Vz,|V| 				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vx_sc_km_sec,Vy_sc_km_sec,Vz_sc_km_sec,*V_km_sec						Vx_sc,Vy_sc,Vz_sc,|V| 			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Vr_rtn_km_sec,Vt_rtn_km_sec,Vn_rtn_km_sec,*V_km_sec						Vr,Vt,Vn,|V| 				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ppar_eV_cm3,Pper1_eV_cm3,Pper2_eV_cm3								Ppar,Pper1,Pper2 			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Ppar_b_eV_cm3,Pper1_b_eV_cm3,Pper2_b_eV_cm3							Ppar_b,Pper1_b,Pper2_b 			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Tpar_eV,Tper1_eV,Tper2_eV									Tpar,Tper1,Tper2 			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Tpar_b_eV,Tper1_b_eV,Tper2_b_eV									Tpar_b,Tper1_b,Tper2_b 			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qx_erg_sec_cm2,Qy_erg_sec_cm2,Qz_erg_sec_cm2,*Q_erg_sec_cm2					Qx,Qy,Qz,|Q|				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qx_sc_erg_sec_cm2,Qy_sc_erg_sec_cm2,Qz_sc_erg_sec_cm2,*Q_erg_sec_cm2				Qx_sc,Qy_sc,Qz_sc,|Q|			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qr_rtn_erg_sec_cm2,Qt_rtn_erg_sec_cm2,Qn_rtn_erg_sec_cm2,*Q_erg_sec_cm2				Qr,Qt,Qn,|Q|				count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qxpar_erg_sec_cm2,Qypar_erg_sec_cm2,Qzpar_erg_sec_cm2,Qpar_erg_sec_cm2				Qxpar,Qypar,Qzpar,|Qpar|		count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Qxper_erg_sec_cm2,Qyper_erg_sec_cm2,Qzper_erg_sec_cm2,Qper_erg_sec_cm2				Qxpar,Qypar,Qzpar,|Qper|		count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Pxx_eV_cm3,Pxy_eV_cm3,Pxz_eV_cm3,Pyy_eV_cm3,Pyz_eV_cm3,Pzz_eV_cm3				Pxx,Pxy,Pxz,Pyy,Pyz,Pzz			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				;'cl	Pxx_eV_cm3_pas,Pxy_eV_cm3_pas,Pxz_eV_cm3_pas,Pyy_eV_cm3_pas,Pyz_eV_cm3_pas,Pzz_eV_cm3_pas	Pxx,Pxy,Pxz,Pyy,Pyz,Pzz			count2d Bresolution=L2_SRF-NORMAL type=moments emin_=1 emax_=100000 legend_theta=No legend_phi=No',				$
				'cl	Pxx_eV_cm3_b,Pxy_eV_cm3_b,Pxz_eV_cm3_b,Pyy