;-------------------------------------------------------------------------------
FUNCTION analyse_cef,	$
;-------------------------------------------------------------------------------
	filename,	$	; LINT_PROTOTYPE input
	remove_ext,	$	; LINT_PROTOTYPE input
	res			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Lit les symboles dans le fichier filename (cef uniquement) et retourne dans res la table des symboles. Retourne 1 si OK, 0 sinon.
;-------------------------------------------------------------------------------

	code = read_ascii_get_symbols (filename, ATT, NOVARY, SYMBOLS, format, nblignes, nblignes0, $
               	                        /quiet, /noatt, /nonb, remove_ext=remove_ext)
	IF ~code THEN RETURN, 0

        NBDIMS = REPLICATE (1L, N_ELEMENTS(SYMBOLS))
        FOR i=0L,N_ELEMENTS(SYMBOLS)-1 DO NBDIMS[i] = N_ELEMENTS(LONG(string_to_data(SYMBOLS[i].sizes)))
        DATA = SYMBOLS.DATA
        DEPEND_0 = SYMBOLS.DEPEND_0
        DEPEND_1 = SYMBOLS.DEPEND_1
        DEPEND_2 = SYMBOLS.DEPEND_2
        DEPEND_3 = SYMBOLS.DEPEND_3
        DEPEND_4 = SYMBOLS.DEPEND_4

	res = REPLICATE ({ name:'', name1: '', date:'', data:'', value_type:'', nbd:'', nbdims:'', sizes:'', type:'', fieldnam:'', units:'', var_type:'' },N_ELEMENTS(SYMBOLS))
	FOR i=0L,N_ELEMENTS(SYMBOLS)-1 DO BEGIN
		nbdim = 0
        	IF DATA[i] EQ '' AND DEPEND_0[i] NE '' AND DEPEND_1[i] NE '' AND DEPEND_2[i] EQ '' AND DEPEND_3[i] EQ '' AND DEPEND_4[i] EQ '' AND NBDIMS[i] EQ 1 AND SYMBOLS[i].sizes NE '1' THEN nbdim = 1
		IF DATA[i] EQ '' AND DEPEND_0[i] NE '' AND DEPEND_1[i] NE '' AND DEPEND_2[i] NE '' AND DEPEND_3[i] EQ '' AND DEPEND_4[i] EQ '' AND NBDIMS[i] EQ 2 THEN nbdim = 2
		IF DATA[i] EQ '' AND DEPEND_0[i] NE '' AND DEPEND_1[i] NE '' AND DEPEND_2[i] NE '' AND DEPEND_3[i] NE '' AND DEPEND_4[i] EQ '' AND NBDIMS[i] EQ 3 THEN nbdim = 3
		IF DATA[i] EQ '' AND DEPEND_0[i] NE '' AND DEPEND_1[i] NE '' AND DEPEND_2[i] NE '' AND DEPEND_3[i] NE '' AND DEPEND_4[i] NE '' AND NBDIMS[i] EQ 4 THEN nbdim = 4
		res[i].name		= remove_extension(remove_ext,SYMBOLS[i].name)
		res[i].name1		= remove_extension(remove_ext,corriger_nomchamp(SYMBOLS[i].name))
		res[i].nbd		= nbdim
		res[i].nbdims		= NBDIMS[i]
		res[i].sizes		= SYMBOLS[i].sizes
		res[i].date		= remove_extension(remove_ext,STRTRIM(SYMBOLS[i].depend_0,2))
		res[i].value_type	= SYMBOLS[i].value_type
		res[i].data		= remove_extension(remove_ext,STRTRIM(SYMBOLS[i].data,2))
		res[i].fieldnam		= SYMBOLS[i].fieldnam
		res[i].units		= SYMBOLS[i].units
		res[i].var_type		= SYMBOLS[i].var_type
		IF nbdim EQ 1 THEN res[i].type = 'time_energy'
		IF nbdim EQ 2 THEN res[i].type = STRUPCASE(DEPEND_1[i]) EQ 'ENERGY' ? 'time_theta' : 'time_energy'
		IF nbdim EQ 3 THEN res[i].type = STRUPCASE(DEPEND_1[i]) EQ 'ENERGY' ? 'time_theta' : (STRUPCASE(DEPEND_2[i]) EQ 'ENERGY' ? 'time_phi' : 'time_energy')
        END

	RETURN, code

END

;-------------------------------------------------------------------------------
PRO creer_arbre_plugin_caa,	$
;-------------------------------------------------------------------------------
	type_experience	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Lit "resource/plugin_caa.txt" et cre un fichier "resource/arbre_plugin_caa_'+type_experience+'_new'
;-------------------------------------------------------------------------------

	;	type_experience: "NORMAL" ou "ASCII_CEF_CDF"

	nbdatasets = 0L

	warning_datasets = ''
	missing_datasets = ''
	error_datasets = ''

	nom_in = "resource/plugin_caa.txt"
	nom_out = "resource/arbre_plugin_caa_"+type_experience+"_new"
	OPENR, fd, nom_in, /GET_LUN
	OPENW, fd1, nom_out+'.gztmp', /GET_LUN, /COMPRESS

	ligne = ''
	group_sat = ''
	s = ''

	old_group = ""
	old_dataset = ""
	old_sat = ""
	old_exp = ""

	MAX = 20000
	nblignes = 0L
	lignes = REPLICATE ('',MAX)
	infos = REPLICATE ({ trie:'', group:'', sat:'', noproduit:0 }, MAX)

	WHILE ~EOF(fd) DO BEGIN

		READF, fd, ligne
		IF STRCOMPRESS(ligne,/REMOVE_ALL) EQ '' THEN CONTINUE
		IF STRMID(ligne,0,1) EQ ';' THEN CONTINUE

		lignes[nblignes] = ligne

		tmp = STRSPLIT(ligne, /EXTRACT)
		dataset = basename(tmp[0])

		; on trie suivant dataset
		tmp = STRSPLIT(dataset,'_',/EXTRACT)
		;infos[nblignes].trie = dataset
		infos[nblignes].trie = tmp[0]+'_'+tmp[1]+'_'+tmp[2]

		infos[nblignes].group = 'CLUSTER'
		infos[nblignes].sat = STRMID(dataset,0,4)
		infos[nblignes].noproduit = nblignes

		nblignes++

	END

	IF nblignes NE 0 THEN BEGIN
		lignes = lignes[0:nblignes-1]
		infos = infos[0:nblignes-1]
	END

	; trie
	t = SORT(infos.trie)
	lignes = lignes[t]
	infos = infos[t]

	FOR nosat=1L,4 DO BEGIN
	FOR noligne=0L,nblignes-1 DO BEGIN

		ligne = lignes[noligne]
		noproduit = infos[noligne].noproduit

		tmp = STRSPLIT(ligne, /EXTRACT)
		dataset = basename(tmp[0])
		filename = tmp[0]

		pos__ = STRPOS(dataset,'__')
		IF pos__ NE -1 THEN dataset = STRMID(dataset,0,pos__)
		remplacer, dataset, "$SC", val_to_str(nosat)

		group_sat = tmp[0]
		group = 'CLUSTER'
		localname = tmp[1]
		exp = tmp[1]
		label = N_ELEMENTS(tmp) LE 2 ? "" : STRJOIN(tmp[2:*]," ")

		starttime = " 2001-02-01T00:00:00.000Z"	& starttime = STRMID(starttime,1)
		endtime = " 9999-01-01T00:00:00.000Z"	& endtime = STRMID(endtime,1)
		datemin = tu_to_date(STRMID(starttime,0,4),STRMID(starttime,5,2),STRMID(starttime,8,2),STRMID(starttime,11,2),STRMID(starttime,14,2),STRMID(starttime,17,2))
		datemax = tu_to_date(STRMID(endtime,  0,4),STRMID(endtime,  5,2),STRMID(endtime,  8,2),STRMID(endtime,  11,2),STRMID(endtime,  14,2),STRMID(endtime,  17,2))

		tmp = STRSPLIT(dataset,"_",/EXTRACT)
		sat = tmp[0]
		sat = 'C'+val_to_str(nosat)
		nom_experiment = tmp[2]
		exp = tmp[2]

		nbdatasets++

		nomsats = "C1"+STRING(2b)+"C2"+STRING(2b)+"C3"+STRING(2b)+"C4"

		datemin = tu_to_date(2001,1,1,0,0,0)
		datemax = tu_to_date(9999,1,1,0,0,0)

		; F30.0 pour ne pas perdre de prcision lors du passage en STRING
		datemin = val_to_str(datemin,FORMAT='(F30.0)')
		datemax = val_to_str(datemax,FORMAT='(F30.0)')

		;print,val_to_str(nbdatasets)+' '+STRCOMPRESS(group_sat,/REMOVE_ALL)+' '+dataset+' ' +filename
		;continue

		master = localname
		remplacer, localname, 'C$SC', 'C'+val_to_str(nosat)

		IF ~fichier_existe(localname) THEN BEGIN
			missing_datasets = [missing_datasets,localname]
			CONTINUE
		END

		code = analyse_cef(localname,'CAA',res)

		PRINT,val_to_str(nbdatasets)+' '+STRCOMPRESS(group_sat,/REMOVE_ALL)+' '+dataset+' ' +localname
		PRINT
		IF code EQ 0 THEN BEGIN
			error_datasets = [error_datasets,localname]
			CONTINUE
		END

		nbinfos = 0
		sinfo = REPLICATE ({ value_type:'', name:'', name1:'', date:'', data: '', nbd:0, nbdims:0, sizes:'', type:'', libelle:'', units:'', var_type:'' },N_ELEMENTS(res))
		FOR i=0L,N_ELEMENTS(res)-1 DO BEGIN
			IF res[i].VALUE_TYPE EQ 'ISO_TIME' THEN CONTINUE
			IF res[i].VALUE_TYPE EQ 'ISO_TIME_RANGE' THEN CONTINUE
			IF res[i].DATA NE '' THEN CONTINUE

			;IF res[i].value_type EQ 'FLOAT' THEN CONTINUE
			;IF res[i].value_type EQ 'INT' THEN CONTINUE
			;IF res[i].value_type EQ 'DOUBLE' THEN CONTINUE

			sinfo[nbinfos].value_type = res[i].value_type
			sinfo[nbinfos].name = res[i].name
			sinfo[nbinfos].name1 = res[i].name1
			sinfo[nbinfos].nbd = res[i].nbd
			sinfo[nbinfos].nbdims = res[i].nbdims
			sinfo[nbinfos].sizes = res[i].sizes
			sinfo[nbinfos].data = res[i].name
			sinfo[nbinfos].date = res[i].date
			sinfo[nbinfos].type = res[i].type
			sinfo[nbinfos].libelle = res[i].fieldnam
			sinfo[nbinfos].units = res[i].units
			sinfo[nbinfos].var_type = res[i].var_type
			nbinfos++
		END

		IF nbinfos EQ 0 THEN CONTINUE

		IF group NE old_group THEN BEGIN
			PRINTF, fd1, val_to_str(2)+" "+STRUPCASE(group)
			old_group = group
			old_sat = ""
			old_exp = ""
			old_dataset = ""
		END

		IF sat NE old_sat THEN BEGIN
			PRINTF, fd1, val_to_str(3)+" "+STRUPCASE(sat)
			old_sat = sat
			old_exp = ""
			old_dataset = ""
		END

		IF exp NE old_exp THEN BEGIN
			PRINTF, fd1, val_to_str(4)+" "+STRUPCASE(exp)
			old_exp = exp
			old_dataset = ""
		END

		tab_orbit = REPLICATE('',nbinfos)
		tab_timeseries = REPLICATE('',nbinfos)
		tab_spectros = REPLICATE('',nbinfos)
		tab_counts = REPLICATE('',nbinfos)

		FOR i=0L,nbinfos-1 DO BEGIN

			support = STRUPCASE(sinfo[i].VAR_TYPE) EQ 'SUPPORT_DATA' ? "SUPPORT " : ""
			s = ""
			s1 = ""
			IF sinfo[i].nbd LE 1 AND sinfo[i].nbdims LE 1 THEN BEGIN

				IF type_experience EQ "ASCII_CEF_CDF" THEN BEGIN
					s = "header legend_theta=No legend_phi=No nom_sat="+nomsats+" nom_experiment="+nom_experiment
					s += ' selection_date='+sinfo[i].date
					IF sinfo[i].nbd NE 0 THEN BEGIN
						s += ' selection_data='+sinfo[i].data
					END
					s += ' remove_ext=CAA'
					s += ' nosat='+val_to_str(nosat)
					s += ' filename='+filename+'|'+master
					s += ' datemin='+val_to_str(datemin)+' datemax='+val_to_str(datemax)
				END ELSE BEGIN
					s = "header legend_theta=No legend_phi=No"
				END
				IF sinfo[i].sizes GT 1 THEN BEGIN
					s1 = '('+val_to_str(sinfo[i].sizes)+')'
				END ELSE BEGIN
					s1 = '(1)'
				END
				value_type = ''
				IF sinfo[i].value_type EQ 'FLOAT' THEN BEGIN
				END ELSE IF sinfo[i].value_type EQ 'INT' THEN BEGIN
				END ELSE IF sinfo[i].value_type EQ 'DOUBLE' THEN BEGIN
				END ELSE BEGIN
					value_type = sinfo[i].value_type+' '
				END
				s2 = ' ('+sinfo[i].libelle+')'
				IF type_experience EQ "ASCII_CEF_CDF" THEN BEGIN
					timeseries = supprimer_caractere(' '+val_to_str(0)+" "+support+value_type+s1+' '+sinfo[i].name+s2,'#')+"#"+supprimer_caractere("ASCII P-1 SC1 "+sinfo[i].name1+" "+s,'#')
				END ELSE BEGIN
					timeseries = supprimer_caractere(' '+val_to_str(0)+" "+support+value_type+s1+' '+sinfo[i].name+s2,'#')+"#"+supprimer_caractere("PLUGIN_CAA P"+val_to_str(noproduit)+" SC"+val_to_str(nosat)+ " "+sinfo[i].name1+" "+s,'#')
				END
				tab_timeseries[i] = timeseries
			END

			IF sinfo[i].nbd GE 1 THEN BEGIN
				IF type_experience EQ "ASCII_CEF_CDF" THEN BEGIN
					s = "count3d type="+sinfo[i].type+" cjf=flux z_showdir=No z_theta=No z_phi=No z_energy=No nom_sat="+nomsats+" nom_experiment="+nom_experiment
					s += ' selection_data='+sinfo[i].data
					s += ' selection_date='+sinfo[i].date
					s += ' remove_ext=CAA'
					s += ' nosat='+val_to_str(nosat)
					s += ' filename='+filename+'|'+master
					s += ' datemin='+val_to_str(datemin)+' datemax='+val_to_str(datemax)
				END ELSE BEGIN
					s = "count3d type="+sinfo[i].type+" cjf=flux z_showdir=No z_theta=No z_phi=No z_energy=No"
				END
				s1 = '('+sinfo[i].sizes+')'
				s2 = ' ('+sinfo[i].libelle+')'
				IF type_experience EQ "ASCII_CEF_CDF" THEN BEGIN
					spectro = supprimer_caractere(val_to_str(0)+" "+support+s1+' '+sinfo[i].name+s2,'#')+'#'+supprimer_caractere("ASCII P-1 SC1 "+sinfo[i].name+" "+s,'#')
				END ELSE BEGIN
					spectro = supprimer_caractere(val_to_str(0)+" "+support+s1+' '+sinfo[i].name+s2,'#')+'#'+supprimer_caractere("PLUGIN_CAA P"+val_to_str(noproduit)+" SC"+val_to_str(nosat)+" "+sinfo[i].name+" "+s,'#')
				END
				tab_spectros[i] = spectro

				IF type_experience EQ "ASCII_CEF_CDF" THEN BEGIN
					s = "count2d type=time_cjf cjf=JE yleft_typetitle=Wording legend_theta=No legend_phi=No legend_mass=No nom_sat="+nomsats+" nom_experiment="+nom_experiment
					s += ' selection_data='+sinfo[i].data
					s += ' selection_date='+sinfo[i].date
					s += ' remove_ext=CAA'
					s += ' nosat='+val_to_str(nosat)
					s += ' filename='+filename+'|'+master
					s += ' datemin='+val_to_str(datemin)+' datemax='+val_to_str(datemax)
				END ELSE BEGIN
					s = "count2d type=time_cjf cjf=JE yleft_typetitle=Wording legend_theta=No legend_phi=No legend_mass=No"
				END
				s1 = '('+sinfo[i].sizes+')'
				s2 = ' ('+sinfo[i].libelle+')'
				IF type_experience EQ "ASCII_CEF_CDF" THEN BEGIN
					count = supprimer_caractere(val_to_str(0)+" "+support+s1+' '+sinfo[i].name+s2,'#')+'#'+supprimer_caractere("ASCII P-1 SC1 "+sinfo[i].name+" "+s,'#')
				END ELSE BEGIN
					count = supprimer_caractere(val_to_str(0)+" "+support+s1+' '+sinfo[i].name+s2,'#')+'#'+supprimer_caractere("PLUGIN_CAA P"+val_to_str(noproduit)+" SC"+val_to_str(nosat)+" "+sinfo[i].name+" "+s,'#')
				END
				tab_counts[i] = count
			END

		END

		ind_orbits = WHERE (tab_orbit NE '', nb_orbits)
		ind_timeseries = WHERE (tab_timeseries NE '', nb_timeseries)
		ind_spectros = WHERE (tab_spectros NE '', nb_spectros)
		ind_counts = WHERE (tab_counts NE '', nb_counts)

		IF nb_orbits NE 0 OR nb_timeseries NE 0 OR nb_spectros NE 0 OR nb_counts NE 0 THEN BEGIN
			IF dataset NE old_dataset THEN BEGIN
				PRINTF, fd1, val_to_str(5)+" "+dataset+" {"+STRMID(starttime,0,13)+"h "+STRMID(endtime,0,13)+"h}"+" &"+label
				old_dataset = dataset
			END
		END

		IF nb_orbits NE 0 THEN BEGIN
			IF nb_timeseries NE 0 THEN PRINTF, fd1, val_to_str(6)+" Orbit"
			FOR i=0L,N_ELEMENTS(ind_orbits)-1 DO BEGIN
				PRINTF, fd1, tab_orbit[ind_orbits[i]]
			END
		END
		IF nb_timeseries NE 0 THEN BEGIN
			IF nb_orbits NE 0 OR nb_spectros NE 0 THEN PRINTF, fd1, val_to_str(6)+" Timeseries"
			FOR i=0L,N_ELEMENTS(ind_timeseries)-1 DO BEGIN
				PRINTF, fd1, tab_timeseries[ind_timeseries[i]]
			END
		END
		IF nb_spectros NE 0 THEN BEGIN
			PRINTF, fd1, val_to_str(6)+" Particle spectrogram"
			FOR i=0L,N_ELEMENTS(ind_spectros)-1 DO BEGIN
				PRINTF, fd1, tab_spectros[ind_spectros[i]]
			END
		END
		IF nb_counts NE 0 THEN BEGIN
			PRINTF, fd1, val_to_str(6)+" Particle plot"
			FOR i=0L,N_ELEMENTS(ind_spectros)-1 DO BEGIN
				PRINTF, fd1, tab_counts[ind_counts[i]]
			END
		END

	END
	END

	FREE_LUN, fd
	FREE_LUN, fd1
	code = renommer (nom_out+'.gztmp', nom_out+'.gz')
		

	PRINT
	PRINT,'warning_datasets:'
	PRINT,'-----------------'
	FOR i=0L,N_ELEMENTS(warning_datasets)-1 DO BEGIN
		IF warning_datasets[i] NE '' THEN PRINT,warning_datasets[i]
	END

	PRINT
	PRINT,'missing_datasets:'
	PRINT,'-----------------'
	FOR i=0L,N_ELEMENTS(missing_datasets)-1 DO BEGIN
		IF missing_datasets[i] NE '' THEN PRINT,missing_datasets[i]
	END

	PRINT
	PRINT,'error_datasets:'
	PRINT,'---------------'
	FOR i=0L,N_ELEMENTS(error_datasets)-1 DO BEGIN
		IF error_datasets[i] NE '' THEN PRINT,error_datasets[i]
	END

END


;-------------------------------------------------------------------------------
PRO get_arbre_plugin_caa
;-------------------------------------------------------------------------------
; Lit "resource/plugin_caa.txt" et cre "resource/arbre_plugin_caa_NORMAL.gz" et "resource/arbre_plugin_caa_ASCII_CEF_CDF.gz"
;-------------------------------------------------------------------------------

	creer_arbre_plugin_caa, "NORMAL"
	creer_arbre_plugin_caa, "ASCII_CEF_CDF"

END
