;-------------------------------------------------------------------------------
FUNCTION analyse_cdaweb_cxf,	$
;-------------------------------------------------------------------------------
	filename,		$	; LINT_PROTOTYPE input
	remove_ext,		$	; LINT_PROTOTYPE input
	res,			$	; LINT_PROTOTYPE output
	master=master			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Lit les symboles dans le fichier filename (cef ou cdf) et retourne dans res la table des symboles. Retourne 1 si OK, 0 sinon.
;-------------------------------------------------------------------------------

        IF iscef(filename) OR iscefgz(filename) THEN BEGIN
		code = read_ascii_get_symbols (filename, ATT, NOVARY, SYMBOLS, format, nblignes, nblignes0, $
						/quiet, /noatt, /nonb)
		IF ~code THEN RETURN, 0
		IF N_ELEMENTS(master) NE 0 THEN lint_unused = ecrire_master (master, SYMBOLS)
        END ELSE IF iscdf(filename) THEN BEGIN
		selection_date = 'Automatic'
		code = read_cdf_get_symbols (filename, ATT, NOVARY, SYMBOLS, format, nblignes, nblignes0, $
	                                        selection_date=selection_date, $
	                                        /quiet, /noatt, /nonb)
		IF ~code THEN RETURN, 0
		IF N_ELEMENTS(master) NE 0 THEN lint_unused = ecrire_master (master, SYMBOLS)
	END



        NBDIMS = REPLICATE (1L, N_ELEMENTS(SYMBOLS))
        FOR i=0L,N_ELEMENTS(SYMBOLS)-1 DO NBDIMS[i] = N_ELEMENTS(LONG(string_to_data(SYMBOLS[i].sizes)))
        DATA = SYMBOLS.DATA
        DEPEND_0 = SYMBOLS.DEPEND_0
        DEPEND_1 = SYMBOLS.DEPEND_1
        DEPEND_2 = SYMBOLS.DEPEND_2
        DEPEND_3 = SYMBOLS.DEPEND_3
        DEPEND_4 = SYMBOLS.DEPEND_4

	res = REPLICATE ({ name:'', name1:'', date:'', data:'', value_type:'', nbd:'', nbdims:'', sizes:'', type:'', fieldnam:'', units:'', var_type:'' },N_ELEMENTS(SYMBOLS))
	FOR i=0L,N_ELEMENTS(SYMBOLS)-1 DO BEGIN
		nbdim = 0
        	IF DATA[i] EQ '' AND DEPEND_0[i] NE '' AND DEPEND_1[i] NE '' AND DEPEND_2[i] EQ '' AND DEPEND_3[i] EQ '' AND DEPEND_4[i] EQ '' AND NBDIMS[i] EQ 1 AND SYMBOLS[i].sizes NE '1' THEN nbdim = 1
		IF DATA[i] EQ '' AND DEPEND_0[i] NE '' AND DEPEND_1[i] NE '' AND DEPEND_2[i] NE '' AND DEPEND_3[i] EQ '' AND DEPEND_4[i] EQ '' AND NBDIMS[i] EQ 2 THEN nbdim = 2
		IF DATA[i] EQ '' AND DEPEND_0[i] NE '' AND DEPEND_1[i] NE '' AND DEPEND_2[i] NE '' AND DEPEND_3[i] NE '' AND DEPEND_4[i] EQ '' AND NBDIMS[i] EQ 3 THEN nbdim = 3
		IF DATA[i] EQ '' AND DEPEND_0[i] NE '' AND DEPEND_1[i] NE '' AND DEPEND_2[i] NE '' AND DEPEND_3[i] NE '' AND DEPEND_4[i] NE '' AND NBDIMS[i] EQ 4 THEN nbdim = 4
		res[i].name		= remove_extension(remove_ext,SYMBOLS[i].name)
		res[i].name1		= remove_extension(remove_ext,corriger_nomchamp(SYMBOLS[i].name))
		res[i].nbd		= val_to_str(nbdim)
		res[i].nbdims		= val_to_str(NBDIMS[i])
		res[i].sizes		= SYMBOLS[i].sizes
		res[i].date		= remove_extension(remove_ext,STRTRIM(SYMBOLS[i].depend_0,2))
		res[i].value_type	= SYMBOLS[i].value_type
		res[i].data		= remove_extension(remove_ext,STRTRIM(SYMBOLS[i].data,2))
		res[i].fieldnam		= SYMBOLS[i].fieldnam
		res[i].units		= SYMBOLS[i].units
		res[i].var_type		= SYMBOLS[i].var_type
		IF nbdim EQ 1 THEN res[i].type = 'time_energy'
		IF nbdim EQ 2 THEN res[i].type = STRUPCASE(DEPEND_1[i]) EQ 'ENERGY' ? 'time_theta' : 'time_energy'
		IF nbdim EQ 3 THEN res[i].type = STRUPCASE(DEPEND_1[i]) EQ 'ENERGY' ? 'time_theta' : (STRUPCASE(DEPEND_2[i]) EQ 'ENERGY' ? 'time_phi' : 'time_energy')
        END

	RETURN, code

END

;-------------------------------------------------------------------------------
PRO ecrire_html_cdaweb,		$
;-------------------------------------------------------------------------------
	fd,			$	; LINT_PROTOTYPE input
	numero,			$	; LINT_PROTOTYPE input
	group_sat,		$	; LINT_PROTOTYPE input
	exp,			$	; LINT_PROTOTYPE input
	dataset,		$	; LINT_PROTOTYPE input
	day_code_link,		$	; LINT_PROTOTYPE input
	message,		$	; LINT_PROTOTYPE input
	couleur,		$	; LINT_PROTOTYPE input
	strike=strike			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ecrit une ligne dans le fichier html ouvert fd.
;-------------------------------------------------------------------------------

	IF couleur EQ '' THEN BEGIN
		PRINTF, fd, '<TR>'
	END ELSE BEGIN
		PRINTF, fd, '<TR bgcolor="'+couleur+'">'
	END

	PRINTF, fd, '<TD>'
	PRINTF, fd, val_to_str(numero)
	PRINTF, fd, '</TD>'
	PRINTF, fd, '<TD>'
	IF KEYWORD_SET(strike) THEN PRINTF, fd, '<s>'
	PRINTF, fd, '<b>'+group_sat+'</b>'
	IF KEYWORD_SET(strike) THEN PRINTF, fd, '</s>'
	PRINTF, fd, '</TD>'
	PRINTF, fd, '<TD>'
	IF KEYWORD_SET(strike) THEN PRINTF, fd, '<s>'
	PRINTF, fd, '<b>'+exp+'</b>'
	IF KEYWORD_SET(strike) THEN PRINTF, fd, '</s>'
	PRINTF, fd, '</TD>'
	PRINTF, fd, '<TD>'
	IF KEYWORD_SET(strike) THEN PRINTF, fd, '<s>'
	PRINTF, fd, '<b>'+dataset+'</b>'
	IF KEYWORD_SET(strike) THEN PRINTF, fd, '</s>'
	PRINTF, fd, '</TD>'
	PRINTF, fd, '<TD>'
	PRINTF, fd, day_code_link
	PRINTF, fd, '</TD>'
	PRINTF, fd, '<TD>'
	PRINTF, fd, message
	PRINTF, fd, '</TD>'
	PRINTF, fd, '</TR>'

END

;-------------------------------------------------------------------------------
PRO creer_arbre_cdaweb
;-------------------------------------------------------------------------------
; Lit "get_arbre_cdaweb_[01]" et cre "resource/tree/cdaweb_tree.txt.gz", "clweb/log/get_arbre_cdaweb.html" et "resource/master/cdaweb/*"
;-------------------------------------------------------------------------------

	COMMON COMMON_CL, general

	MASTER_PATH = '/home/penou/DATA/CLUSTER/SOFT/CLL3/resource/master/cdaweb'

	; Supprimer tous les fichiers master
	liste = my_findfile(MASTER_PATH+'/*')
	FOR i=0L,N_ELEMENTS(liste)-1 DO BEGIN
		code = detruire (liste[i])
	END

	fichier1_html = '/home/penou/DATA/CLUSTER/SOFT/CLL3/clweb/log/get_arbre_cdaweb.html'
	fichier2_html = '/net_clweb/DATA/CLUSTER/SOFT/CLL3/clweb/log/get_arbre_cdaweb.html'

	nbdatasets = 0L

	warning_datasets = ''
	missing_datasets = ''
	error_datasets = ''

	nb_master_local_cef = 0L
	nb_master_local_cdf = 0L
	nb_master_http_cdf = 0L

	; no=0: istp_public (cdaweb)
	; no=1: pre_istp (cdaweb)
	
	;titres = [	'Public data from current (1992->present) space physics missions',	$
	;		'Public data from older mission'					]

	nom_out = "/home/penou/DATA/CLUSTER/SOFT/CLL3/resource/tree/cdaweb_tree.txt"
	OPENW, fd1, nom_out+'.gz.tmp', /GET_LUN, /COMPRESS

	top1 = nbsec()

	OPENW, fdhtml, fichier1_html, /GET_LUN
	PRINTF, fdhtml, '<html>'
	PRINTF, fdhtml, '<head>'
	PRINTF, fdhtml, '</head>'
	PRINTF, fdhtml, '<body>'
	PRINTF, fdhtml, date_to_str(get_date()) + '<br><br>'
	PRINTF, fdhtml, 'get_arbre_cdaweb_[01] <br><br>'
	PRINTF, fdhtml, "<TABLE border=1 style='border-collapse: collapse;'>"
	PRINTF, fdhtml, '<TR>'
	PRINTF, fdhtml, '<TH>NO</TH>'
	PRINTF, fdhtml, '<TH>GROUP_SAT</TH>'
	PRINTF, fdhtml, '<TH>EXP</TH>'
	PRINTF, fdhtml, '<TH>DATASET</TH>'
	PRINTF, fdhtml, '<TH>DAY,CODE,LINK,MASTER</TH>'
	PRINTF, fdhtml, '<TH>MESSAGE</TH>'
	PRINTF, fdhtml, '<TR>'

	PRINTF, fd1, val_to_str(1)+" CDAWeb"

	numero = 0L

	FOR no=0L,0 DO BEGIN

		nom_in = "get_arbre_cdaweb_"+val_to_str(no)
		OPENR, fd, nom_in, /GET_LUN
		;PRINTF, fd1, val_to_str(2)+" "+titres[no]

		ligne = ''
		group_sat = ''
		s = ''

		old_group = ""
		old_dataset = ""
		old_sat = ""
		old_exp = ""

		MAX = 20000
		nblignes = 0L
		lignes = REPLICATE ('',MAX)
		infos = REPLICATE ({ trie:'', group:'', sat:'' }, MAX)

		WHILE ~EOF(fd) DO BEGIN

			READF, fd, ligne
			lignes[nblignes] = ligne

			tmp = STRSPLIT(ligne,'#',/EXTRACT)

			; on trie suivant les 3 premires colonnes
			infos[nblignes].trie = tmp[0] + '#' + tmp[1] + '#' + tmp[2]

			group_sat = tmp[0]
			dataset = tmp[2]
			tmp = STRSPLIT(group_sat,"_",/EXTRACT)	; group_sat -> infos.group
			infos[nblignes].group = tmp[0]
			tmp = STRSPLIT(dataset,"_",/EXTRACT)	; dataset -> infos.sat
			infos[nblignes].sat = tmp[0]

			nblignes++

		END
	
		IF nblignes NE 0 THEN BEGIN
			lignes = lignes[0:nblignes-1]
			infos = infos[0:nblignes-1]
		END

		; trie
		t = SORT(infos.trie)
		lignes = lignes[t]
		infos = infos[t]

		FOR noligne=0L,nblignes-1 DO BEGIN

			numero++

			PRINT, val_to_str(numero) + ')'

			; ligne -> group_sat + exp + dataset + label + starttime + endtime + filename + YYYYMMDD + vars
			; group_sat -> group
			; dataset -> sat

			ligne = lignes[noligne]

			tmp = STRSPLIT(ligne,'#',/EXTRACT)
			group_sat = tmp[0]
			exp = tmp[1]
			dataset = tmp[2]
			label = tmp[3]
			remplacer, label, '	','' ; supprimer les TAB qui posent problmes dans dynatree de CLWEB	
			starttime = tmp[4]
			endtime = tmp[5]
			filename = tmp[6]	; ex: http://cdaweb.gsfc.nasa.gov/istp_public/data/ace/cris_h2/$YEAR/ac_h2_cris_$YYYYMMDD_v??.cdf
			YYYYMMDD = tmp[7]
			YEAR = STRMID(YYYYMMDD,0,4)
			MONTH = STRMID(YYYYMMDD,4,2)
			DAY = STRMID(YYYYMMDD,6,2)
			DOY = int_str_0(LONG(1+(tu_to_date(YEAR,MONTH,DAY,0,0,0)-tu_to_date(YEAR,1,1,0,0,0))/86400000d),3)
			vars = tmp[8:*]
			tmp = STRSPLIT(group_sat,"_",/EXTRACT)
			group = tmp[0]
			tmp = STRSPLIT(dataset,"_",/EXTRACT)
			sat = tmp[0]
			IF N_ELEMENTS(tmp) LE 2 THEN BEGIN
				nom_experiment = '???' ; arrive sur RBSPB_ECT-HOPE-SCI-L2SA
			END ELSE BEGIN
				nom_experiment = tmp[2]
			END
			
			;IF sat NE 'RBSP-A' THEN CONTINUE

			;IF sat NE 'C1' AND sat NE 'C2' AND sat NE 'C3' AND sat NE 'C4' THEN CONTINUE
			;IF sat NE 'PO' THEN CONTINUE
			;IF tmp[1] NE 'H8' THEN CONTINUE

			; 18/10/2017: gestion des numros de version plus complexes que "v??"
			; ex: "_vxy.cdf', "_vxxx.cdf', "_vx.y.z.cdf', "v1.1.5-07.cdf"
			IF STRMID(filename,STRLEN(filename)-4,1) EQ '.' THEN BEGIN
				fin = STRLEN(filename)-5
				FOR i=fin,0,-1 DO BEGIN
					c = STRMID(filename,i,1)
					IF is_number(c) THEN CONTINUE
					IF c EQ '.' THEN CONTINUE
					IF c EQ '-' THEN CONTINUE
					IF c EQ 'v' OR c EQ 'V' THEN BEGIN
						debut = i+1
						avant = STRMID(filename,0,debut)
						apres = STRMID(filename,fin+1)
						milieu = STRMID(filename,debut,fin-debut+1)
						remplacer, milieu, '0', '?'
						remplacer, milieu, '1', '?'
						remplacer, milieu, '2', '?'
						remplacer, milieu, '3', '?'
						remplacer, milieu, '4', '?'
						remplacer, milieu, '5', '?'
						remplacer, milieu, '6', '?'
						remplacer, milieu, '7', '?'
						remplacer, milieu, '8', '?'
						remplacer, milieu, '9', '?'
						filename = avant + milieu + apres
					END
					BREAK
				END
			END


			datemin = tu_to_date(STRMID(starttime,0,4),STRMID(starttime,5,2),STRMID(starttime,8,2),STRMID(starttime,11,2),STRMID(starttime,14,2),STRMID(starttime,17,2))
			datemax = tu_to_date(STRMID(endtime,  0,4),STRMID(endtime,  5,2),STRMID(endtime,  8,2),STRMID(endtime,  11,2),STRMID(endtime,  14,2),STRMID(endtime,  17,2))

			; F30.0 pour ne pas perdre de prcision lors du passage en STRING
			datemin = val_to_str(datemin,FORMAT='(F30.0)')
			datemax = val_to_str(datemax,FORMAT='(F30.0)')

			nbvars = N_ELEMENTS(vars)
			cdaweb = REPLICATE ({ shortname:'', longname:'' },nbvars)
			FOR i=0L,nbvars-1 DO BEGIN
				tmp = STRSPLIT(vars[i],STRING(2b),/EXTRACT)
				cdaweb[i].shortname = tmp[0]
				cdaweb[i].longname = N_ELEMENTS(tmp) EQ 2 ? tmp[1]:''
			END

			nbdatasets++

			IF STRMID(filename,STRLEN(filename)-4,4) EQ ".mpg" THEN BEGIN
				warning_datasets = [warning_datasets,filename]
				ecrire_html_cdaweb, fdhtml, numero, group_sat, exp, dataset, 'NOT MANAGED', 'mpg extension', '', /strike
				CONTINUE
			END
			IF STRMID(filename,STRLEN(filename)-4,4) EQ ".gif" THEN BEGIN
				warning_datasets = [warning_datasets,filename]
				ecrire_html_cdaweb, fdhtml, numero, group_sat, exp, dataset, 'NOT MANAGED', 'gif extension', '', /strike
				CONTINUE
			END

			msg = '*** arbre_cdaweb ***'

			;IF dataset NE 'IT_K0_ELE' THEN CONTINUE

			master = filename
			IF STRMID(master,STRLEN(master)-4,1) EQ '.' AND STRMID(master,STRLEN(master)-7,1) EQ 'v' THEN BEGIN
				debut = STRMID(master,0,STRLEN(master)-6)
				fin = STRMID(master,STRLEN(master)-3,3);
				master = debut + '??.' + fin
			END


			master_simple = MASTER_PATH +"/"+(STRSPLIT(dataset,/EXTRACT))[0] ;  cause de "AC_OR_SSC *** NO_CACHE_CL ***"

			tmp_themis = ['THA','THB','THC','THD','THE']
			ind_themis = WHERE (tmp_themis EQ sat)
			tmp_stereo = ['STA','STB']
			ind_stereo = WHERE (tmp_stereo EQ sat)
			tmp_cluster = ['C1','C2','C3','C4']
			ind_cluster = WHERE (tmp_cluster EQ sat)
			IF ind_themis[0] NE -1 THEN BEGIN
				nosat = ind_themis[0]+1
				nomsats = "THA THB THC THD THE"
				remplacer, filename, STRLOWCASE(sat), 'th$SC[a b c d e]'
				remplacer, master,   STRLOWCASE(sat), 'th$SC[a b c d e]'

				; bug 'themis' qui devient 'th$SC[a b c d e]mis'
				remplacer, filename, 'th$SC[a b c d e]mis', 'themis'
				remplacer, master, 'th$SC[a b c d e]mis', 'themis'

				snosat = " nosat="+val_to_str(nosat)+" "
				remove_ext = "THEMIS"
			END ELSE IF sat EQ 'THG' THEN BEGIN
				nosat = 1
				nomsats = sat
				snosat = "" 
				remove_ext = "THEMIS"
			END ELSE IF ind_stereo[0] NE -1 THEN BEGIN
				nosat = ind_stereo[0]+1
				nomsats = "STA STB"
				remplacer, filename, STRLOWCASE(sat), 'st$SC[a b]'
				remplacer, master,   STRLOWCASE(sat), 'st$SC[a b]'
				remplacer, filename, STRUPCASE(sat), 'ST$SC[A B]'
				remplacer, master,   STRUPCASE(sat), 'ST$SC[A B]'
				IF chaine_contient(filename,'ahead') THEN BEGIN
					remplacer, filename, 'ahead', '$SC[ahead behind]'
					remplacer, master,   'ahead', '$SC[ahead behind]'
				END ELSE IF chaine_contient(filename,'behind') THEN BEGIN
					remplacer, filename, 'behind', '$SC[ahead behind]'
					remplacer, master,   'behind', '$SC[ahead behind]'
				END
				snosat = " nosat="+val_to_str(nosat)+" "
				remove_ext = ""
			END ELSE IF ind_cluster[0] NE -1 THEN BEGIN
				nosat = ind_cluster[0]+1
				nomsats = "C1 C2 C3 C4"
				remplacer, filename, STRLOWCASE(sat), 'c$SC'
				remplacer, master,   STRLOWCASE(sat), 'c$SC'
				snosat = " nosat="+val_to_str(nosat)+" "
				remove_ext = "CAA"
			END ELSE BEGIN
				nosat = 1
				nomsats = sat
				snosat = "" 
				remove_ext = ""
			END

			tmp = STRSPLIT(nomsats,/EXTRACT)
			nbsats = N_ELEMENTS(tmp)

			link_html = filename
			remplacer, link_html, '$SC', 'C'+val_to_str(nosat)
			remplacer, link_html, '$YYYYMMDD', int_str_0(YEAR,4)+int_str_0(MONTH,2)+int_str_0(DAY,2)
			remplacer, link_html, '$YEAR', int_str_0(YEAR,4)
			remplacer, link_html, '$MONTH', int_str_0(MONTH,2)
			remplacer, link_html, '$DAY', int_str_0(DAY,2)
			remplacer, link_html, '$DOY', int_str_0(DOY,3)

			FOR tentative=1L,10 DO BEGIN

				code = chercher_dernier_fichier (general, 0, 0, '', '', master, LONG(nosat), YYYYMMDD, YEAR, MONTH, DAY, DOY, '', '', '', localname)
				IF tentative NE 1 THEN PRINT,'Tentative #'+val_to_str(tentative)+' '+localname

				IF fichier_existe(localname) THEN BEGIN
					code = get_filelengthc (localname, taille)
					IF taille NE 0 THEN BREAK
				END

			END

			code = get_filelengthc (localname, taille)
			IF taille EQ 0 THEN BEGIN
				missing_datasets = [missing_datasets,localname]
				PRINT,'  MISSING '+localname
				PRINT
				day_code_link = int_str_0(YEAR,4)+'-'+int_str_0(MONTH,2)+'-'+int_str_0(DAY,2)+'<br>'+'PB2'+'<br>'+'<a href="'+link_html+'" target="_blank">link</a>'
				ecrire_html_cdaweb, fdhtml, numero, group_sat, exp, dataset, day_code_link, 'MISSING DATASET', 'ff0000'
				CONTINUE
			END

			code = analyse_cdaweb_cxf(localname,remove_ext,res,master=master_simple+".cef.gz")

			PRINT,val_to_str(nbdatasets)+' '+STRCOMPRESS(group_sat,/REMOVE_ALL)+' '+dataset+' ' +localname
			IF code EQ 0 THEN BEGIN
				error_datasets = [error_datasets,localname]
				PRINT,'  ERROR '+localname
				PRINT
				ecrire_html_cdaweb, fdhtml, numero, group_sat, exp, dataset, 'PB3', 'ERROR analyse_cdaweb_cxf()', 'ff0000'
				CONTINUE
			END

			code_html = ''
			IF nbsats NE 1 THEN BEGIN

				; vrifier que le fichier master existe bien pour tous les satellites pour le jour YYYYMMDD

				FOR nosat1=1L,nbsats DO BEGIN

					IF code_html NE '' THEN code_html += ' '

					IF nosat1 EQ nosat THEN BEGIN
						code_html += '1'
						CONTINUE
					END

					FOR tentative=1L,10 DO BEGIN

						localname = ''
						code = chercher_dernier_fichier (general, 0, 0, '', '', master, nosat1, YYYYMMDD, YEAR, MONTH, DAY, DOY, '', '', '', localname)
						IF tentative NE 1 THEN PRINT,msg +' Tentative #'+val_to_str(tentative)+' '+localname

						IF fichier_existe(localname) THEN BEGIN
							code = get_filelengthc (localname, taille)
							IF taille NE 0 THEN BREAK
						END
		
					END

					code = get_filelengthc (localname, taille)
					IF taille EQ 0 THEN BEGIN
						missing_datasets = [missing_datasets,localname]
						PRINT,'  -> PB '+localname
						code_html += '0'
					END ELSE BEGIN
						PRINT,'  -> OK '+localname
						code_html += '1'
					END

				END

			END ELSE BEGIN
				code_html = 'OK'
			END
			PRINT


			remplacer, master, "$YYYYMMDD", YYYYMMDD
			remplacer, master, "$YEAR", YEAR
			remplacer, master, "$MONTH", MONTH
			remplacer, master, "$DAY", DAY
			remplacer, master, "$DOY", DOY

			SEP = STRING(2b)
			remplacer, filename, ' ', SEP
			remplacer, nomsats, ' ', SEP

			code = analyse_cdaweb_cxf(master_simple+".cef.gz",remove_ext,res1)
			; Comparaison res et res1
			idem = structures_idem (res,res1)
			IF idem THEN BEGIN
				master = master_simple+".cef.gz"
				master_type = "cef"
				nb_master_local_cef++
			END ELSE BEGIN
				; pb avec le fichier "/DATA/downloads_cl/cdaweb.gsfc.nasa.gov/istp_public/data/darn/icew/1994/dn_k0_icew_19940828_v01.cdf"
				code = detruire (master_simple+".cef.gz") ; le master en cef devient inutile
				skeleton = "xxx.skt"
				;code = detruire (master_simple+".cdf")	; pour tre sur de bien le re-crer
				cmd = 'cdf2skt -skeleton ' + skeleton + ' ' + localname
				SPAWN,cmd
				cmd = 'skt2cdf -delete -cdf ' + master_simple + '.cdf ' + skeleton
				SPAWN,cmd
				code = detruire (skeleton)	; pour faire le mnage
				code = analyse_cdaweb_cxf(master_simple+".cdf",remove_ext,res1)
				idem = structures_idem (res,res1)
				IF idem THEN BEGIN
					master = master_simple+".cdf"
					master_type = "cdf"
					nb_master_local_cdf++
				END ELSE BEGIN
					; arrive sur /DATA/downloads_cl/cdaweb.gsfc.nasa.gov/istp_public/data/polar/uvi/uvi_level1/1996/po_level1_uvi_19960320_v01.cdf
					; Making a cdf from skeleton table: "xxx.skt"  to  "/home/penou/DATA/CLUSTER/SOFT/CLL3/resource/master/cdaweb/PO_LEVEL1_UVI.cdf"...
					; Warning: Attribute name: "TITLE          " not ISTP compliant... not recommended
					; Warning: Attribute name: "DATA_TYPE      " not ISTP compliant... not recommended
					; Warning: Attribute name: "CREATED        " not ISTP compliant... not recommended
					; String/substring split across lines.
					;
					; Error at (or before) line number 37 which follows...
					;
					;" } .
					code = detruire (master_simple+".cdf") ; le master en cdf devient inutile
					master_type = "http"
					nb_master_http_cdf++
				END
			END

			texte = STRJOIN(res.name+'['+res.sizes+']','<br>')
			IF code_html NE '1 1 1 1' AND code_html NE 'OK' THEN code_html = '<FONT COLOR="ff7f00">'+code_html+'</FONT>'
			day_code_link = int_str_0(YEAR,4)+'-'+int_str_0(MONTH,2)+'-'+int_str_0(DAY,2)+'<br><br>'+code_html+'<br><br>'+'<a href="'+link_html+'" target="_blank">link</a><br><br>master_'+master_type+' '+basename(master)
			ecrire_html_cdaweb, fdhtml, numero, group_sat, exp, dataset, day_code_link, texte, ''

			master = '$RESOURCE/master/cdaweb/'+basename(master)
			IF ind_themis[0] NE -1 THEN BEGIN
				remplacer, master, sat, 'TH$SC[A B C D E]'
			END ELSE IF ind_stereo[0] NE -1 THEN BEGIN
				remplacer, master, sat, 'ST$SC[A B]'
			END ELSE IF ind_cluster[0] NE -1 THEN BEGIN
				remplacer, master, sat, 'C$SC'
			END
			remplacer, master, ' ', SEP

			nbinfos = 0
			sinfo = REPLICATE ({ value_type:'', name:'', name1:'', longname:'', date:'', data: '', nbd:0, nbdims:0, sizes:'', type:'', libelle:'', units:'', var_type:'' },nbvars+N_ELEMENTS(res))
			FOR i=0L,N_ELEMENTS(res)-1 DO BEGIN
				IF res[i].VALUE_TYPE EQ 'ISO_TIME' THEN CONTINUE
				IF STRUPCASE(STRMID(res[i].name,0,8)) EQ 'TIME_PB5' THEN CONTINUE
				IF res[i].DATA NE '' THEN CONTINUE

				;IF res[i].value_type EQ 'FLOAT' THEN CONTINUE
				;IF res[i].value_type EQ 'INT' THEN CONTINUE
				;IF res[i].value_type EQ 'DOUBLE' THEN CONTINUE

				ind_cdaweb = WHERE (STRMID(STRUPCASE(cdaweb.shortname),0,STRLEN(res[i].name)) EQ STRUPCASE(res[i].name))
				IF ind_cdaweb[0] NE -1 THEN sinfo[nbinfos].longname = '*'+cdaweb[ind_cdaweb[0]].longname+'*'
				sinfo[nbinfos].value_type = res[i].value_type
				sinfo[nbinfos].name = res[i].name
				sinfo[nbinfos].name1 = res[i].name1
				sinfo[nbinfos].nbd = res[i].nbd
				sinfo[nbinfos].nbdims = res[i].nbdims
				sinfo[nbinfos].sizes = res[i].sizes
				sinfo[nbinfos].data = res[i].name
				sinfo[nbinfos].date = res[i].date
				sinfo[nbinfos].type = res[i].type
				sinfo[nbinfos].libelle = res[i].fieldnam
				sinfo[nbinfos].units = res[i].units
				sinfo[nbinfos].var_type = res[i].var_type
				nbinfos++
			END

			IF nbinfos EQ 0 THEN CONTINUE

			IF group NE old_group THEN BEGIN
				ind1 = WHERE (infos.group EQ infos[noligne].group)
				ind2 = UNIQ(infos[ind1].sat)
				nbsats = N_ELEMENTS(ind2)
				PRINTF, fd1, val_to_str(2)+" "+STRUPCASE(group)
				old_group = group
				old_sat = ""
				old_exp = ""
				old_dataset = ""
			END

			IF sat NE old_sat THEN BEGIN
				PRINTF, fd1, val_to_str(3)+" "+STRUPCASE(sat)
				old_sat = sat
				old_exp = ""
				old_dataset = ""
			END

			IF exp NE old_exp THEN BEGIN
				PRINTF, fd1, val_to_str(4)+" "+(exp EQ '00000ephemeris' ? 'ephemeris' : STRUPCASE(exp))
				old_exp = exp
				old_dataset = ""
			END

			IF dataset NE old_dataset THEN BEGIN
				PRINTF, fd1, val_to_str(5)+" "+dataset+" {"+STRMID(starttime,8,2)+"-"+STRMID(starttime,5,2)+"-"+STRMID(starttime,0,4)+" ... "+STRMID(endtime,8,2)+"-"+STRMID(endtime,5,2)+"-"+STRMID(endtime,0,4)+"}"+" "+STRING(4b)+label
				old_dataset = dataset
			END

			tab_orbit = REPLICATE('',nbinfos)
			tab_timeseries = REPLICATE('',nbinfos)
			tab_spectros = REPLICATE('',nbinfos)
			tab_counts = REPLICATE('',nbinfos)

			IF exp EQ '00000ephemeris' THEN BEGIN
				s = "orbito nom_sat="+nomsats+" nom_experiment="+nom_experiment
				IF remove_ext NE '' THEN s += ' remove_ext='+remove_ext
				s += snosat 
				s += " filename="+filename+'|'+master
				s += ' datemin='+val_to_str(datemin)+' datemax='+val_to_str(datemax)
				orbit = val_to_str(0)+' Orbit panel'+"#"+supprimer_caractere("ASCII P-1 SC1 null "+s,'#')
				tab_orbit = orbit
			END

			FOR i=0L,nbinfos-1 DO BEGIN

				support = STRUPCASE(sinfo[i].VAR_TYPE) EQ 'SUPPORT_DATA' ? "SUPPORT " : ""
				s = ""
				s1 = ""
				IF sinfo[i].nbd LE 1 AND sinfo[i].nbdims LE 1 THEN BEGIN
					s = "header legend_theta=No legend_phi=No nom_sat="+nomsats+" nom_experiment="+nom_experiment
					s += ' selection_date='+sinfo[i].date
					IF sinfo[i].nbd NE 0 THEN BEGIN
						s += ' selection_data='+sinfo[i].data
					END
					IF remove_ext NE '' THEN s += ' remove_ext='+remove_ext
					s += snosat
					s += " filename="+filename+'|'+master
					s += ' datemin='+val_to_str(datemin)+' datemax='+val_to_str(datemax)
					IF sinfo[i].sizes GT 1 THEN BEGIN
						s1 = '('+val_to_str(sinfo[i].sizes)+')'
					END ELSE BEGIN
						s1 = '(1)'
					END
					value_type = ''
					IF sinfo[i].value_type EQ 'FLOAT' THEN BEGIN
					END ELSE IF sinfo[i].value_type EQ 'INT' THEN BEGIN
					END ELSE IF sinfo[i].value_type EQ 'DOUBLE' THEN BEGIN
					END ELSE BEGIN
						value_type = sinfo[i].value_type+' '
					END

					s2 = sinfo[i].longname EQ '' ? ('') : (' ('+sinfo[i].longname+')')
					s2 += ' ('+supprimer_caractere(sinfo[i].libelle,'#')+')'
					timeseries = supprimer_caractere(val_to_str(0)+" "+support+value_type+s1+' '+sinfo[i].name+s2,'#')+'#'+supprimer_caractere("ASCII P-1 SC1 "+sinfo[i].name1+" "+s,'#')
					tab_timeseries[i] = timeseries
				END

				IF sinfo[i].nbd GE 1 AND exp NE '00000ephemeris' THEN BEGIN
					s = "count3d type="+sinfo[i].type+" yleft_auto=Manual yleft_log=Log yleft_min=1 yleft_max=40000 cjf=flux z_showdir=No z_theta=No z_phi=No z_energy=No nom_sat="+nomsats+" nom_experiment="+nom_experiment
					s += ' selection_data='+sinfo[i].data
					s += ' selection_date='+sinfo[i].date
					IF remove_ext NE '' THEN s += ' remove_ext='+remove_ext
					s += snosat
					s += " filename="+filename+'|'+master
					s += ' datemin='+val_to_str(datemin)+' datemax='+val_to_str(datemax)
					s1 = '('+sinfo[i].sizes+')'
					s2 = sinfo[i].longname EQ '' ? ('') : (' ('+sinfo[i].longname+')')
					s2 += ' ('+sinfo[i].libelle+')'
					spectro = supprimer_caractere(val_to_str(0)+" "+support+s1+' '+sinfo[i].name+s2,'#')+'#'+supprimer_caractere("ASCII P-1 SC1 "+sinfo[i].name+" "+s,'#')
					tab_spectros[i] = spectro

					s = "count2d type=time_cjf cjf=JE yleft_typetitle=Wording legend_theta=No legend_phi=No legend_mass=No nom_sat="+nomsats+" nom_experiment="+nom_experiment
					s += ' selection_data='+sinfo[i].data
					s += ' selection_date='+sinfo[i].date
					IF remove_ext NE '' THEN s += ' remove_ext='+remove_ext
					s += snosat
					s += " filename="+filename+'|'+master
					s += ' datemin='+val_to_str(datemin)+' datemax='+val_to_str(datemax)
					s1 = '('+sinfo[i].sizes+')'
					s2 = sinfo[i].longname EQ '' ? ('') : (' ('+sinfo[i].longname+')')
					s2 += ' ('+sinfo[i].libelle+')'
					count = supprimer_caractere(val_to_str(0)+" "+support+s1+' '+sinfo[i].name+s2,'#')+'#'+supprimer_caractere("ASCII P-1 SC1 "+sinfo[i].name+" "+s,'#')
					tab_counts[i] = count
				END

			END

			ind_orbits = WHERE (tab_orbit NE '', nb_orbits)
			ind_timeseries = WHERE (tab_timeseries NE '', nb_timeseries)
			ind_spectros = WHERE (tab_spectros NE '', nb_spectros)
			ind_counts = WHERE (tab_counts NE '', nb_counts)

			IF nb_orbits NE 0 THEN BEGIN
				IF nb_timeseries NE 0 THEN PRINTF, fd1, val_to_str(6)+" Orbit"
					FOR i=0L,N_ELEMENTS(ind_orbits)-1 DO BEGIN
						PRINTF, fd1, tab_orbit[ind_orbits[i]]
					END
			END
			IF nb_timeseries NE 0 THEN BEGIN
				IF nb_orbits NE 0 OR nb_spectros NE 0 THEN PRINTF, fd1, val_to_str(6)+" Timeseries"
				FOR i=0L,N_ELEMENTS(ind_timeseries)-1 DO BEGIN
					PRINTF, fd1, tab_timeseries[ind_timeseries[i]]
				END
			END
			IF nb_spectros NE 0 THEN BEGIN
				PRINTF, fd1, val_to_str(6)+" Particle spectrogram"
				FOR i=0L,N_ELEMENTS(ind_spectros)-1 DO BEGIN
					PRINTF, fd1, tab_spectros[ind_spectros[i]]
				END
			END
			IF nb_counts NE 0 THEN BEGIN
				PRINTF, fd1, val_to_str(6)+" Particle plot"
				FOR i=0L,N_ELEMENTS(ind_spectros)-1 DO BEGIN
					PRINTF, fd1, tab_counts[ind_counts[i]]
				END
			END

		END

		FREE_LUN, fd

	END
	FREE_LUN, fd1
	code = renommer (nom_out+'.gz.tmp', nom_out+'.gz')

	PRINTF, fdhtml, '</TABLE>'
	PRINTF, fdhtml, '<br>'


	PRINT
	PRINT,'warning_datasets:'
	PRINT,'-----------------:'
	PRINTF,fdhtml,'<br><br><b><u>warning_datasets:</u></b><br>'
	FOR i=0L,N_ELEMENTS(warning_datasets)-1 DO BEGIN
		IF warning_datasets[i] NE '' THEN BEGIN
			PRINT,warning_datasets[i]
			PRINTF,fdhtml,'&nbsp-&nbsp;'+warning_datasets[i]+'<br>'
		END
	END

	PRINT
	PRINT,'missing_datasets:'
	PRINT,'-----------------'
	PRINTF,fdhtml,'<br><br><b><u>missing_datasets:</u></b><br>'
	FOR i=0L,N_ELEMENTS(missing_datasets)-1 DO BEGIN
		IF missing_datasets[i] NE '' THEN BEGIN
			PRINT,missing_datasets[i]
			PRINTF,fdhtml,'&nbsp-&nbsp;'+missing_datasets[i]+'<br>'
		END
	END

	PRINT
	PRINT,'error_datasets:'
	PRINT,'---------------'
	PRINTF,fdhtml,'<br><br><b><u>error_datasets:</u></b><br>'
	FOR i=0L,N_ELEMENTS(error_datasets)-1 DO BEGIN
		IF error_datasets[i] NE '' THEN BEGIN
			PRINT,error_datasets[i]
			PRINTF,fdhtml,'&nbsp-&nbsp;'+error_datasets[i]+'<br>'
		END
	END

	PRINT
	PRINT,'nb_master_local_cef: '+val_to_str(nb_master_local_cef)
	PRINTF,fdhtml,'<br><br>nb_master_local_cef: '+val_to_str(nb_master_local_cef)+'<br>'
	PRINT,'nb_master_local_cdf: '+val_to_str(nb_master_local_cdf)
	PRINTF,fdhtml,'nb_master_local_cdf: '+val_to_str(nb_master_local_cdf)+'<br>'
	PRINT,'nb_master_http_cdf: '+val_to_str(nb_master_http_cdf)
	PRINTF,fdhtml,'nb_master_http_cdf: '+val_to_str(nb_master_http_cdf)+'<br>'

	top2 = nbsec()

	PRINTF, fdhtml, '<br><br> in ' + duree_to_str(1000d*(top2-top1))

	PRINTF, fdhtml, '</body>'
	PRINTF, fdhtml, '</html>'
	FREE_LUN, fdhtml

	code = copier (fichier1_html, fichier2_html)

END


;-------------------------------------------------------------------------------
PRO get_arbre_cdaweb
;-------------------------------------------------------------------------------
; Lit "get_arbre_cdaweb_[01]" et cre les fichiers "resource/tree/cdaweb_tree.txt.gz.gz", "clweb/log/get_arbre_cdaweb.html" et "resource/master/cdaweb/*"
;-------------------------------------------------------------------------------

	creer_arbre_cdaweb

END
