;-------------------------------------------------------------------------------
FUNCTION analyse_caa_cxf,	$
;-------------------------------------------------------------------------------
	filename,		$	; LINT_PROTOTYPE input
	remove_ext,		$	; LINT_PROTOTYPE input
	res,			$	; LINT_PROTOTYPE output
	master=master			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Lit les symboles dans le fichier filename (cef uniquement) et retourne dans res la table des symboles. Retourne 1 si OK, 0 sinon.
;-------------------------------------------------------------------------------

	code = read_ascii_get_symbols (filename, ATT, NOVARY, SYMBOLS, format, nblignes, nblignes0, $
               	                        /quiet, /noatt, /nonb)
	IF ~code THEN RETURN, 0

	IF N_ELEMENTS(master) NE 0 THEN BEGIN
		lint_unused = ecrire_master (master, SYMBOLS)
	END

        NBDIMS = REPLICATE (1L, N_ELEMENTS(SYMBOLS))
        FOR i=0L,N_ELEMENTS(SYMBOLS)-1 DO NBDIMS[i] = N_ELEMENTS(LONG(string_to_data(SYMBOLS[i].sizes)))
        DATA = SYMBOLS.DATA
        DEPEND_0 = SYMBOLS.DEPEND_0
        DEPEND_1 = SYMBOLS.DEPEND_1
        DEPEND_2 = SYMBOLS.DEPEND_2
        DEPEND_3 = SYMBOLS.DEPEND_3
        DEPEND_4 = SYMBOLS.DEPEND_4

	res = REPLICATE ({ name:'', name1: '', date:'', data:'', value_type:'', nbd:'', nbdims:'', sizes:'', type:'', fieldnam:'', units:'', var_type:'' },N_ELEMENTS(SYMBOLS))
	FOR i=0L,N_ELEMENTS(SYMBOLS)-1 DO BEGIN
		nbdim = 0
        	IF DATA[i] EQ '' AND DEPEND_0[i] NE '' AND DEPEND_1[i] NE '' AND DEPEND_2[i] EQ '' AND DEPEND_3[i] EQ '' AND DEPEND_4[i] EQ '' AND NBDIMS[i] EQ 1 AND SYMBOLS[i].sizes NE '1' THEN nbdim = 1
		IF DATA[i] EQ '' AND DEPEND_0[i] NE '' AND DEPEND_1[i] NE '' AND DEPEND_2[i] NE '' AND DEPEND_3[i] EQ '' AND DEPEND_4[i] EQ '' AND NBDIMS[i] EQ 2 THEN nbdim = 2
		IF DATA[i] EQ '' AND DEPEND_0[i] NE '' AND DEPEND_1[i] NE '' AND DEPEND_2[i] NE '' AND DEPEND_3[i] NE '' AND DEPEND_4[i] EQ '' AND NBDIMS[i] EQ 3 THEN nbdim = 3
		IF DATA[i] EQ '' AND DEPEND_0[i] NE '' AND DEPEND_1[i] NE '' AND DEPEND_2[i] NE '' AND DEPEND_3[i] NE '' AND DEPEND_4[i] NE '' AND NBDIMS[i] EQ 4 THEN nbdim = 4
		res[i].name		= remove_extension(remove_ext,SYMBOLS[i].name)
		res[i].name1		= remove_extension(remove_ext,corriger_nomchamp(SYMBOLS[i].name))
		res[i].nbd		= val_to_str(nbdim)
		res[i].nbdims		= val_to_str(NBDIMS[i])
		res[i].sizes		= SYMBOLS[i].sizes
		res[i].date		= remove_extension(remove_ext,STRTRIM(SYMBOLS[i].depend_0,2))
		res[i].value_type	= SYMBOLS[i].value_type
		res[i].data		= remove_extension(remove_ext,STRTRIM(SYMBOLS[i].data,2))
		res[i].fieldnam		= SYMBOLS[i].fieldnam
		res[i].units		= SYMBOLS[i].units
		res[i].var_type		= SYMBOLS[i].var_type
		IF nbdim EQ 1 THEN res[i].type = 'time_energy'
		IF nbdim EQ 2 THEN res[i].type = STRUPCASE(DEPEND_1[i]) EQ 'ENERGY' ? 'time_theta' : 'time_energy'
		IF nbdim EQ 3 THEN res[i].type = STRUPCASE(DEPEND_1[i]) EQ 'ENERGY' ? 'time_theta' : (STRUPCASE(DEPEND_2[i]) EQ 'ENERGY' ? 'time_phi' : 'time_energy')
        END

	RETURN, code

END

;-------------------------------------------------------------------------------
PRO ecrire_html_caa,		$
;-------------------------------------------------------------------------------
	fd,			$	; LINT_PROTOTYPE input
	numero,			$	; LINT_PROTOTYPE input
	group_sat,		$	; LINT_PROTOTYPE input
	exp,			$	; LINT_PROTOTYPE input
	dataset,		$	; LINT_PROTOTYPE input
	day_code_link,		$	; LINT_PROTOTYPE input
	message,		$	; LINT_PROTOTYPE input
	couleur,		$	; LINT_PROTOTYPE input
	strike=strike			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ecrit une ligne dans le fichier html ouvert fd.
;-------------------------------------------------------------------------------


	IF couleur EQ '' THEN BEGIN
		PRINTF, fd, '<TR>'
	END ELSE BEGIN
		PRINTF, fd, '<TR bgcolor="'+couleur+'">'
	END

	PRINTF, fd, '<TD>'
	PRINTF, fd, val_to_str(numero)
	PRINTF, fd, '</TD>'
	PRINTF, fd, '<TD>'
	IF KEYWORD_SET(strike) THEN PRINTF, fd, '<s>'
	PRINTF, fd, '<b>'+group_sat+'</b>'
	IF KEYWORD_SET(strike) THEN PRINTF, fd, '</s>'
	PRINTF, fd, '</TD>'
	PRINTF, fd, '<TD>'
	IF KEYWORD_SET(strike) THEN PRINTF, fd, '<s>'
	PRINTF, fd, '<b>'+exp+'</b>'
	IF KEYWORD_SET(strike) THEN PRINTF, fd, '</s>'
	PRINTF, fd, '</TD>'
	PRINTF, fd, '<TD>'
	IF KEYWORD_SET(strike) THEN PRINTF, fd, '<s>'
	PRINTF, fd, '<b>'+dataset+'</b>'
	IF KEYWORD_SET(strike) THEN PRINTF, fd, '</s>'
	PRINTF, fd, '</TD>'
	PRINTF, fd, '<TD>'
	PRINTF, fd, day_code_link
	PRINTF, fd, '</TD>'
	PRINTF, fd, '<TD>'
	PRINTF, fd, message
	PRINTF, fd, '</TD>'
	PRINTF, fd, '</TR>'

END

;-------------------------------------------------------------------------------
PRO creer_arbre_caa
;-------------------------------------------------------------------------------
; Lit "get_arbre_caa_0" et cre "resource/tree/caa_tree.gz" et "clweb/log/get_arbre_caa.html"
;-------------------------------------------------------------------------------

	COMMON COMMON_CL, general

	MASTER_PATH = '/home/penou/DATA/CLUSTER/SOFT/CLL3/resource/master/caa'

	nbdatasets = 0L

	warning_datasets = ''
	missing_datasets = ''
	error_datasets = ''

	found_datasets = ''
	pb1_datasets = ''
	pb2_datasets = ''

	nb_master_local_cef = 0L
	nb_master_http_cef = 0L

	fichier1_html = '/home/penou/DATA/CLUSTER/SOFT/CLL3/clweb/log/get_arbre_caa.html'
	fichier2_html =            '/DATA/CLUSTER/SOFT/CLL3/clweb/log/get_arbre_caa.html'

	nom_in = "/home/penou/DATA/CLUSTER/SOFT/CLL3/get_arbre_caa_0"
	nom_out = "/home/penou/DATA/CLUSTER/SOFT/CLL3/resource/tree/caa_tree.txt"
	OPENW, fd1, nom_out+'.gztmp', /GET_LUN, /COMPRESS

	top1 = nbsec()

	OPENW, fdhtml, fichier1_html, /GET_LUN
	PRINTF, fdhtml, '<html>'
	PRINTF, fdhtml, '<head>'
	PRINTF, fdhtml, '</head>'
	PRINTF, fdhtml, '<body>'
	PRINTF, fdhtml, date_to_str(get_date()) + '<br><br>'
	PRINTF, fdhtml, nom_in + '<br><br>'
	PRINTF, fdhtml, "<TABLE border=1 style='border-collapse: collapse;'>"
	PRINTF, fdhtml, '<TR>'
	PRINTF, fdhtml, '<TH>NO</TH>'
	PRINTF, fdhtml, '<TH>GROUP_SAT</TH>'
	PRINTF, fdhtml, '<TH>EXP</TH>'
	PRINTF, fdhtml, '<TH>DATASET</TH>'
	PRINTF, fdhtml, '<TH>DAY,CODE,LINK,MASTER</TH>'
	PRINTF, fdhtml, '<TH>MESSAGE</TH>'
	PRINTF, fdhtml, '<TR>'

	PRINTF, fd1, val_to_str(1)+" CAA"

	OPENR, fd, nom_in, /GET_LUN

	ligne = ''
	group_sat = ''
	s = ''

	old_group = ""
	old_dataset = ""
	old_sat = ""
	old_exp = ""

	MAX = 20000
	nblignes = 0L
	lignes = REPLICATE ('',MAX)
	infos = REPLICATE ({ trie:'', group:'', sat:'' }, MAX)

	WHILE ~EOF(fd) DO BEGIN

		READF, fd, ligne
		lignes[nblignes] = ligne

		tmp = STRSPLIT(ligne,'#',/EXTRACT)

		; on trie suivant les 3 premires colonnes
		infos[nblignes].trie = tmp[0] + '#' + tmp[1] + '#' + tmp[2]

		group_sat = tmp[0]
		dataset = tmp[2]
		tmp = STRSPLIT(group_sat,"_",/EXTRACT)	; group_sat -> group
		infos[nblignes].group = tmp[0]
		tmp = STRSPLIT(dataset,"_",/EXTRACT)	; dataset -> sat
		infos[nblignes].sat = tmp[0]

		nblignes++

	END
	
	IF nblignes NE 0 THEN BEGIN
		lignes = lignes[0:nblignes-1]
		infos = infos[0:nblignes-1]
	END

	; trie
	t = SORT(infos.trie)
	lignes = lignes[t]
	infos = infos[t]


	FOR noligne=0L,nblignes-1 DO BEGIN

		; ligne -> group_sat + exp + dataset + label + starttime + endtime + filename + YYYYMMDD
		; group_sat -> group
		; dataset -> sat

		ligne = lignes[noligne]

		tmp = STRSPLIT(ligne,'#',/EXTRACT)
		group_sat = tmp[0]
		exp = tmp[1]
		dataset = tmp[2]
		found_datasets = [found_datasets,dataset]
		label = STRTRIM(tmp[3],2)
		starttime = tmp[4]
		endtime = tmp[5]
		filename = tmp[6]	; ex: http://cdaweb.gsfc.nasa.gov/istp_public/data/ace/cris_h2/$YEAR/ac_h2_cris_$YYYYMMDD_v??.cdf
		YYYYMMDD = tmp[7]

		numero = noligne+1

		IF YYYYMMDD EQ '00000000' THEN BEGIN
			warning_datasets = [warning_datasets,filename]
			ecrire_html_caa, fdhtml, numero, group_sat, exp, dataset, 'PB1', 'YYYYMMDD==00000000', 'ff0000'
			CONTINUE
		END
		YEAR = STRMID(YYYYMMDD,0,4)
		MONTH = STRMID(YYYYMMDD,4,2)
		DAY = STRMID(YYYYMMDD,6,2)
		DOY = int_str_0(LONG(1+(tu_to_date(YEAR,MONTH,DAY,0,0,0)-tu_to_date(YEAR,1,1,0,0,0))/86400000d),3)
		tmp = STRSPLIT(group_sat,"_",/EXTRACT)
		group = tmp[0]
		tmp = STRSPLIT(dataset,"_",/EXTRACT)
		sat = tmp[0]
		nom_experiment = tmp[2]

		type = tmp[1]
		types_ok     = ['CC', 'CP', 'PP', 'JP', 'SP']
		ind = WHERE (types_ok EQ type)
		IF ind[0] EQ -1 THEN BEGIN
			ecrire_html_caa, fdhtml, numero, group_sat, exp, dataset, 'NOT MANAGED', 'TYPE ' + type+ ' NOT in ['+STRJOIN(types_ok,',')+']', '', /strike
			CONTINUE
		END

		datasets_interdits = ['C1_CP_WBD_WAVEFORM','C2_CP_WBD_WAVEFORM','C3_CP_WBD_WAVEFORM','C4_CP_WBD_WAVEFORM']
		ind = WHERE (datasets_interdits EQ dataset)
		IF ind[0] NE -1 THEN BEGIN
			ecrire_html_caa, fdhtml, numero, group_sat, exp, dataset, 'NOT MANAGED', 'WBD_WAVEFORM NOT MANAGED', '', /strike
			CONTINUE
		END

		nbdatasets++

		datemin = tu_to_date(STRMID(starttime,0,4),STRMID(starttime,5,2),STRMID(starttime,8,2),STRMID(starttime,11,2),STRMID(starttime,14,2),STRMID(starttime,17,2))
		datemax = tu_to_date(STRMID(endtime,  0,4),STRMID(endtime,  5,2),STRMID(endtime,  8,2),STRMID(endtime,  11,2),STRMID(endtime,  14,2),STRMID(endtime,  17,2))

		; F30.0 pour ne pas perdre de prcision lors du passage en STRING
		datemin = val_to_str(datemin,FORMAT='(F30.0)')
		datemax = val_to_str(datemax,FORMAT='(F30.0)')

		msg = '*** arbre_caa ***'

		master = filename
		IF STRMID(master,STRLEN(master)-4,1) EQ '.' AND STRMID(master,STRLEN(master)-7,1) EQ 'v' THEN BEGIN
			debut = STRMID(master,0,STRLEN(master)-6)
			fin = STRMID(master,STRLEN(master)-3,3);
			master = debut + '??.' + fin
		END
		master_simple = MASTER_PATH +"/"+(STRSPLIT(dataset,/EXTRACT))[0]

		IF sat EQ 'C1' THEN BEGIN
			nosat = 1
			nomsats = "C1 C2 C3 C4"
			remplacer, filename, 'C1', 'C$SC'
			remplacer, master,   'C1', 'C$SC'
			snosat = " nosat="+val_to_str(nosat)+" "
		END ELSE IF sat EQ 'C2' THEN BEGIN
			nosat = 2
			nomsats = "C1 C2 C3 C4"
			remplacer, filename, 'C2', 'C$SC'
			remplacer, master,   'C2', 'C$SC'
			snosat = " nosat="+val_to_str(nosat)+" "
		END ELSE IF sat EQ 'C3' THEN BEGIN
			nosat = 3
			nomsats = "C1 C2 C3 C4"
			remplacer, filename, 'C3', 'C$SC'
			remplacer, master,   'C3', 'C$SC'
			snosat = " nosat="+val_to_str(nosat)+" "
		END ELSE IF sat EQ 'C4' THEN  BEGIN
			nosat = 4
			nomsats = "C1 C2 C3 C4"
			remplacer, filename, 'C4', 'C$SC'
			remplacer, master,   'C4', 'C$SC'
			snosat = " nosat="+val_to_str(nosat)+" "
		END ELSE BEGIN
			nosat = 0
			nomsats = sat
			snosat = ""
		END

		tmp = STRSPLIT(nomsats,/EXTRACT)
		nbsats = N_ELEMENTS(tmp)

		link_html = filename
		remplacer, link_html, '$SC', 'C'+val_to_str(nosat)
		remplacer, link_html, '$YYYYMMDD', int_str_0(YEAR,4)+int_str_0(MONTH,2)+int_str_0(DAY,2)
		remplacer, link_html, '$YEAR', int_str_0(YEAR,4)
		remplacer, link_html, '$MONTH', int_str_0(MONTH,2)
		remplacer, link_html, '$DAY', int_str_0(DAY,2)
		remplacer, link_html, '$DOY', int_str_0(DOY,3)

		FOR tentative=1L,10 DO BEGIN

			code = chercher_dernier_fichier (general, 0, 0, '', '', master, LONG(nosat), YYYYMMDD, YEAR, MONTH, DAY, DOY, '', '', '', localname)
			IF tentative NE 1 THEN PRINT,'Tentative #'+val_to_str(tentative)+' '+localname

			IF fichier_existe(localname) THEN BEGIN
				code = get_filelengthc (localname, taille)
				IF taille NE 0 THEN BREAK
			END

		END

		code = get_filelengthc (localname, taille)
		IF taille EQ 0 THEN BEGIN
			missing_datasets = [missing_datasets,localname]
			PRINT,'  MISSING '+localname
			PRINT
			day_code_link = int_str_0(YEAR,4)+'-'+int_str_0(MONTH,2)+'-'+int_str_0(DAY,2)+'<br>'+'PB2'+'<br>'+'<a href="'+link_html+'" target="_blank">link</a>'
			ecrire_html_caa, fdhtml, numero, group_sat, exp, dataset, day_code_link, 'MISSING DATASET', 'ff0000'
			CONTINUE
		END

		code = analyse_caa_cxf(localname,'CAA',res, master=master_simple+".cef.gz")

		PRINT,val_to_str(nbdatasets)+' '+STRCOMPRESS(group_sat,/REMOVE_ALL)+' '+dataset+' ' +localname
		PRINT
		IF code EQ 0 THEN BEGIN
			error_datasets = [error_datasets,localname]
			PRINT,'  ERROR '+localname
			PRINT
			ecrire_html_caa, fdhtml, numero, group_sat, exp, dataset, 'PB3', 'ERROR analyse_caa_cxf()', 'ff0000'
			CONTINUE
		END

		code_html = ''
		IF nbsats NE 1 THEN BEGIN

			; vrifier que le fichier master existe bien pour tous les satellites pour le jour YYYYMMDD

			FOR nosat1=1L,nbsats DO BEGIN

				IF code_html NE '' THEN code_html += ' '

				IF nosat1 EQ nosat THEN BEGIN
					code_html += '1'
					CONTINUE
				END

				FOR tentative=1L,10 DO BEGIN

					localname = ''
					code = chercher_dernier_fichier (general, 0, 0, '', '', master, nosat1, YYYYMMDD, YEAR, MONTH, DAY, DOY, '', '', '', localname)
					IF tentative NE 1 THEN PRINT,msg +' Tentative #'+val_to_str(tentative)+' '+localname

					IF fichier_existe(localname) THEN BEGIN
						code = get_filelengthc (localname, taille)
						IF taille NE 0 THEN BREAK
					END

				END

				code = get_filelengthc (localname, taille)
				IF taille EQ 0 THEN BEGIN
					ind = WHERE (missing_datasets EQ localname)
					IF ind[0] EQ -1 THEN BEGIN
						pb1_datasets = [ pb1_datasets, 'C'+val_to_str(nosat1)+STRMID(dataset,2)]
						pb2_datasets = [ pb2_datasets, localname+' (SC'+val_to_str(nosat)+'=OK)']
					END
					PRINT,'  -> PB '+localname
					code_html += '0'
				END ELSE BEGIN
					PRINT,'  -> OK '+localname
					code_html += '1'
				END

			END
		END

		remplacer, master, "$YYYYMMDD", YYYYMMDD
		remplacer, master, "$YEAR", YEAR
		remplacer, master, "$MONTH", MONTH
		remplacer, master, "$DAY", DAY
		remplacer, master, "$DOY", DOY

		SEP = STRING(2b)
		remplacer, nomsats, ' ', SEP

		code = analyse_caa_cxf(master_simple+".cef.gz","CAA",res1)
		; Comparaison res et res1
		idem = structures_idem (res,res1)
		IF idem THEN BEGIN
			master = master_simple+".cef.gz"
			master_type = "cef"
			nb_master_local_cef++
		END ELSE BEGIN
			master_type = "http"
			nb_master_http_cef++
		END

		texte = STRJOIN(res.name+'['+res.sizes+']','<br>')
		IF code_html NE '1 1 1 1' THEN code_html = '<FONT COLOR="ff7f00">'+code_html+'</FONT>'
		day_code_link = int_str_0(YEAR,4)+'-'+int_str_0(MONTH,2)+'-'+int_str_0(DAY,2)+'<br>'+code_html+'<br>'+'<a href="'+link_html+'" target="_blank">link</a><br>master_'+master_type+' '+basename(master)
		ecrire_html_caa, fdhtml, numero, group_sat, exp, dataset, day_code_link, texte, ''

		master = '$RESOURCE/master/caa/'+basename(master)
		IF nosat NE 0 THEN BEGIN
			remplacer, master, sat, 'C$SC'
		END

		nbinfos = 0
		sinfo = REPLICATE ({ value_type:'', name:'', name1:'', longname:'', date:'', data: '', nbd:0, nbdims:0, sizes:'', type:'', libelle:'', units:'', var_type:'' },N_ELEMENTS(res))
		FOR i=0L,N_ELEMENTS(res)-1 DO BEGIN
			IF res[i].VALUE_TYPE EQ 'ISO_TIME' THEN CONTINUE
			IF res[i].VALUE_TYPE EQ 'ISO_TIME_RANGE' THEN CONTINUE
			IF res[i].DATA NE '' THEN CONTINUE

			;IF res[i].value_type EQ 'FLOAT' THEN CONTINUE
			;IF res[i].value_type EQ 'INT' THEN CONTINUE
			;IF res[i].value_type EQ 'DOUBLE' THEN CONTINUE

			sinfo[nbinfos].value_type = res[i].value_type
			sinfo[nbinfos].name = res[i].name
			sinfo[nbinfos].name1 = res[i].name1
			sinfo[nbinfos].nbd = res[i].nbd
			sinfo[nbinfos].nbdims = res[i].nbdims
			sinfo[nbinfos].sizes = res[i].sizes
			sinfo[nbinfos].data = res[i].name
			sinfo[nbinfos].date = res[i].date
			sinfo[nbinfos].type = res[i].type
			sinfo[nbinfos].libelle = res[i].fieldnam
			sinfo[nbinfos].units = res[i].units
			sinfo[nbinfos].var_type = res[i].var_type
			nbinfos++
		END

		IF nbinfos EQ 0 THEN CONTINUE

		IF group NE old_group THEN BEGIN
			ind1 = WHERE (infos.group EQ infos[noligne].group)
			ind2 = UNIQ(infos[ind1].sat)
			nbsats = N_ELEMENTS(ind2)
			PRINTF, fd1, val_to_str(2)+" "+STRUPCASE(group)
			old_group = group
			old_sat = ""
			old_exp = ""
			old_dataset = ""
		END

		IF sat NE old_sat THEN BEGIN
			PRINTF, fd1, val_to_str(3)+" "+STRUPCASE(sat)
			old_sat = sat
			old_exp = ""
			old_dataset = ""
		END

		IF exp NE old_exp THEN BEGIN
			PRINTF, fd1, val_to_str(4)+" "+(exp EQ '00000ephemeris' ? 'ephemeris' : STRUPCASE(exp))
			old_exp = exp
			old_dataset = ""
		END

		tab_orbit = REPLICATE('',nbinfos)
		tab_timeseries = REPLICATE('',nbinfos)
		tab_spectros = REPLICATE('',nbinfos)
		tab_counts = REPLICATE('',nbinfos)

		IF exp EQ '00000ephemeris' THEN BEGIN
			s = "orbito nom_sat="+nomsats+" nom_experiment="+nom_experiment
			s += ' remove_ext=CAA'
			s += snosat
			s += " filename="+filename+'|'+master
			s += ' datemin='+val_to_str(datemin)+' datemax='+val_to_str(datemax)
			orbit = val_to_str(0)+' Orbit panel'+"#"+supprimer_caractere("ASCII P-1 SC1 null "+s,'#')
			tab_orbit = orbit
		END

		FOR i=0L,nbinfos-1 DO BEGIN

			support = STRUPCASE(sinfo[i].VAR_TYPE) EQ 'SUPPORT_DATA' ? "SUPPORT " : ""
			s = ""
			s1 = ""
			IF sinfo[i].nbd LE 1 AND sinfo[i].nbdims LE 1 THEN BEGIN
				s = "header legend_theta=No legend_phi=No nom_sat="+nomsats+" nom_experiment="+nom_experiment
				s += ' selection_date='+sinfo[i].date
				IF sinfo[i].nbd NE 0 THEN BEGIN
					s += ' selection_data='+sinfo[i].data
				END
				s += ' remove_ext=CAA'
				s += snosat
				s += " filename="+filename+'|'+master
				s += ' datemin='+val_to_str(datemin)+' datemax='+val_to_str(datemax)
				IF sinfo[i].sizes GT 1 THEN BEGIN
					s1 = '('+val_to_str(sinfo[i].sizes)+')'
				END ELSE BEGIN
					s1 = '(1)'
				END
				value_type = ''
				IF sinfo[i].value_type EQ 'FLOAT' THEN BEGIN
				END ELSE IF sinfo[i].value_type EQ 'INT' THEN BEGIN
				END ELSE IF sinfo[i].value_type EQ 'DOUBLE' THEN BEGIN
				END ELSE BEGIN
					value_type = sinfo[i].value_type+' '
				END
				s2 = sinfo[i].longname EQ '' ? ('') : (' ('+sinfo[i].longname+')')
				s2 += ' ('+sinfo[i].libelle+')'
				timeseries = supprimer_caractere(val_to_str(0)+" "+support+value_type+s1+' '+sinfo[i].name+s2,'#')+"#"+supprimer_caractere("ASCII P-1 SC1 "+sinfo[i].name1+" "+s,'#')
				tab_timeseries[i] = timeseries
			END

			IF sinfo[i].nbd GE 1 AND exp NE '00000ephemeris' THEN BEGIN
				s = ""
				s1 = ""
				s = "count3d type="+sinfo[i].type+" yleft_auto=Manual yleft_log=Log yleft_min=1 yleft_max=40000 cjf=flux z_showdir=No z_theta=No z_phi=No z_energy=No nom_sat="+nomsats+" nom_experiment="+nom_experiment
				s += ' selection_data='+sinfo[i].data
				s += ' selection_date='+sinfo[i].date
				s += ' remove_ext=CAA'
				s += snosat
				s += " filename="+filename+'|'+master
				s += ' datemin='+val_to_str(datemin)+' datemax='+val_to_str(datemax)
				s1 = '('+sinfo[i].sizes+')'
				s2 = sinfo[i].longname EQ '' ? ('') : (' ('+sinfo[i].longname+')')
				s2 += ' ('+sinfo[i].libelle+')'
				spectro = supprimer_caractere(val_to_str(0)+" "+support+s1+' '+sinfo[i].name+s2,'#')+'#'+supprimer_caractere("ASCII P-1 SC1 "+sinfo[i].name+" "+s,'#')
				tab_spectros[i] = spectro

				s = ""
				s1 = ""
				s = "count2d type=time_cjf cjf=JE yleft_typetitle=Wording legend_theta=No legend_phi=No legend_mass=No nom_sat="+nomsats+" nom_experiment="+nom_experiment
				s += ' selection_data='+sinfo[i].data
				s += ' selection_date='+sinfo[i].date
				s += ' remove_ext=CAA'
				s += snosat
				s += " filename="+filename+'|'+master
				s += ' datemin='+val_to_str(datemin)+' datemax='+val_to_str(datemax)
				s1 = '('+sinfo[i].sizes+')'
				s2 = sinfo[i].longname EQ '' ? ('') : (' ('+sinfo[i].longname+')')
				s2 += ' ('+sinfo[i].libelle+')'
				count = supprimer_caractere(val_to_str(0)+" "+support+s1+' '+sinfo[i].name+s2,'#')+'#'+supprimer_caractere("ASCII P-1 SC1 "+sinfo[i].name+" "+s,'#')
				tab_counts[i] = count
			END

		END

		ind_orbits = WHERE (tab_orbit NE '', nb_orbits)
		ind_timeseries = WHERE (tab_timeseries NE '', nb_timeseries)
		ind_spectros = WHERE (tab_spectros NE '', nb_spectros)
		ind_counts = WHERE (tab_counts NE '', nb_counts)

		IF nb_orbits NE 0 OR nb_timeseries NE 0 OR nb_spectros NE 0 OR nb_counts NE 0 THEN BEGIN
			IF dataset NE old_dataset THEN BEGIN
				PRINTF, fd1, val_to_str(5)+" "+dataset+" {"+STRMID(starttime,8,2)+"-"+STRMID(starttime,5,2)+"-"+STRMID(starttime,0,4)+" ... "+STRMID(endtime,8,2)+"-"+STRMID(endtime,5,2)+"-"+STRMID(endtime,0,4)+"}"+" "+STRING(4b)+label
				old_dataset = dataset
			END
		END

		IF nb_orbits NE 0 THEN BEGIN
			IF nb_timeseries NE 0 THEN PRINTF, fd1, val_to_str(6)+" Orbit"
			FOR i=0L,N_ELEMENTS(ind_orbits)-1 DO BEGIN
				PRINTF, fd1, tab_orbit[ind_orbits[i]]
			END
		END
		IF nb_timeseries NE 0 THEN BEGIN
			IF nb_orbits NE 0 OR nb_spectros NE 0 THEN PRINTF, fd1, val_to_str(6)+" Timeseries"
			FOR i=0L,N_ELEMENTS(ind_timeseries)-1 DO BEGIN
				PRINTF, fd1, tab_timeseries[ind_timeseries[i]]
			END
		END
		IF nb_spectros NE 0 THEN BEGIN
			PRINTF, fd1, val_to_str(6)+" Particle spectrogram"
			FOR i=0L,N_ELEMENTS(ind_spectros)-1 DO BEGIN
				PRINTF, fd1, tab_spectros[ind_spectros[i]]
			END
		END
		IF nb_counts NE 0 THEN BEGIN
			PRINTF, fd1, val_to_str(6)+" Particle plot"
			FOR i=0L,N_ELEMENTS(ind_spectros)-1 DO BEGIN
				PRINTF, fd1, tab_counts[ind_counts[i]]
			END
		END

	END

	FREE_LUN, fd
	FREE_LUN, fd1
	code = renommer (nom_out+'.gztmp', nom_out+'.gz')

	PRINTF, fdhtml, '</TABLE>'
	PRINTF, fdhtml, '<br>'

	PRINT
	PRINT,'warning_datasets:'
	PRINT,'-----------------'
	PRINTF,fdhtml,'<br><br><b><u>warning_datasets:</u></b><br>'
	FOR i=0L,N_ELEMENTS(warning_datasets)-1 DO BEGIN
		IF warning_datasets[i] NE '' THEN BEGIN
			PRINT,warning_datasets[i]
			PRINTF,fdhtml,'&nbsp-&nbsp;'+warning_datasets[i]+'<br>'
		END
	END

	PRINT
	PRINT,'missing_datasets:'
	PRINT,'-----------------'
	PRINTF,fdhtml,'<br><br><b><u>missing_datasets:</u></b><br>'
	FOR i=0L,N_ELEMENTS(missing_datasets)-1 DO BEGIN
		IF missing_datasets[i] NE '' THEN BEGIN
			PRINT,missing_datasets[i]
			PRINTF,fdhtml,'&nbsp-&nbsp;'+missing_datasets[i]+'<br>'
		END
	END

	PRINT
	PRINT,'error_datasets:'
	PRINT,'---------------'
	PRINTF,fdhtml,'<br><br><b><u>error_datasets:</u></b><br>'
	FOR i=0L,N_ELEMENTS(error_datasets)-1 DO BEGIN
		IF error_datasets[i] NE '' THEN BEGIN
			PRINT,error_datasets[i]
			PRINTF,fdhtml,'&nbsp-&nbsp;'+error_datasets[i]+'<br>'
		END
	END

	PRINT
	PRINT,'pb_datasets:'
	PRINT,'-----------'
	PRINTF,fdhtml,'<br><br><b><u>pb_datasets:</u></b><br>'
	FOR i=0L,N_ELEMENTS(pb1_datasets)-1 DO BEGIN
		IF pb1_datasets[i] NE '' THEN BEGIN
			ind = WHERE (found_datasets EQ pb1_datasets[i])
			IF ind[0] EQ -1 THEN CONTINUE
			PRINT,pb1_datasets[i]+' '+pb2_datasets[i]
			PRINTF,fdhtml,'&nbsp-&nbsp;'+pb2_datasets[i]+'<br>'
		END
	END

	PRINT
	PRINT,'nb_master_local_cef: '+val_to_str(nb_master_local_cef)
	PRINTF,fdhtml,'<br><br>nb_master_local_cef: '+val_to_str(nb_master_local_cef)+'<br>'
        PRINT,'nb_master_http_cef: '+val_to_str(nb_master_http_cef)
        PRINTF,fdhtml,'nb_master_http_cef: '+val_to_str(nb_master_http_cef)+'<br>'
	PRINT

	top2 = nbsec()

	PRINTF, fdhtml, '<br><br> in ' + duree_to_str(1000d*(top2-top1))

	PRINTF, fdhtml, '</body>'
	PRINTF, fdhtml, '</html>'
	FREE_LUN, fdhtml

	code = copier (fichier1_html, fichier2_html)

END


;-------------------------------------------------------------------------------
PRO get_arbre_caa
;-------------------------------------------------------------------------------
; Lit "get_arbre_caa_0" et cre "resource/tree/caa_tree.gz" et "clweb/log/get_arbre_caa.html"
;-------------------------------------------------------------------------------

	creer_arbre_caa

END
