;-------------------------------------------------------------------------------
FUNCTION get_feuille,			$
;-------------------------------------------------------------------------------
	numero,				$	; LINT_PROTOTYPE input
	webservice_erreur,		$	; LINT_PROTOTYPE input
	nb_ok,				$	; LINT_PROTOTYPE input
	nb_pb,				$	; LINT_PROTOTYPE input
	starttime,			$	; LINT_PROTOTYPE input
	stoptime,			$	; LINT_PROTOTYPE input
	time_t1,			$	; LINT_PROTOTYPE input
	time_t2,			$	; LINT_PROTOTYPE input
	datemin,			$	; LINT_PROTOTYPE input
	datemax,			$	; LINT_PROTOTYPE input
	datacenter_name,		$	; LINT_PROTOTYPE input
	mission_name,			$	; LINT_PROTOTYPE input
	mission_id,			$	; LINT_PROTOTYPE input
	instrument_name,		$	; LINT_PROTOTYPE input
	instrument_id,			$	; LINT_PROTOTYPE input
	dataset_name,			$	; LINT_PROTOTYPE input
	dataset_id,			$	; LINT_PROTOTYPE input
	parameter_name,			$	; LINT_PROTOTYPE input
	parameter_id,			$	; LINT_PROTOTYPE input
	parameter_var,			$	; LINT_PROTOTYPE input
	parameter_units,		$	; LINT_PROTOTYPE input
	is_amda,			$	; LINT_PROTOTYPE input
	test_webservice,		$	; LINT_PROTOTYPE input
	fichier_html				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne une chaine de caractre contenant la feuille a mettre dans l'arbre.
; Ecrit des infos dans fichier_html.
;-------------------------------------------------------------------------------

	COMMON COMMON_CL, general

	IF STRPOS(mission_id,' ') NE -1 OR STRPOS(mission_id,'#') NE -1 OR  STRPOS(mission_id,'/') NE -1 THEN BEGIN
		; ex: "Models (Plot Only!)"
		PRINT,'*** WARNING mission_id *** "'+mission_id+'"'
		tmp = mission_id
		remplacer, tmp, ' ', '_'
		remplacer, tmp, '#', '_'
		remplacer, tmp, '/', '_'
		mission_id = tmp
		PRINT,'*** WARNING mission_id => *** "'+mission_id+'"'
	END
	IF STRPOS(instrument_id,' ') NE -1 OR STRPOS(instrument_id,'#') NE -1 OR STRPOS(instrument_id,'/') NE -1 THEN BEGIN
		; ex: "Models (Plot Only!):A2000 B field along orbit"
		PRINT,'*** WARNING instrument_id *** "'+instrument_id+'"'
		tmp = instrument_id
		remplacer, tmp, ' ', '_'
		remplacer, tmp, '#', '_'
		remplacer, tmp, '/', '_'
		instrument_id = tmp
		PRINT,'*** WARNING instrument_id => *** "'+instrument_id+'"'
	END
	IF STRPOS(dataset_id,' ') NE -1 OR STRPOS(dataset_id,'#') NE -1 OR STRPOS(dataset_id,'/') NE -1 THEN BEGIN
		; pas d'exemple
		PRINT,'*** WARNING dataset_id *** "'+dataset_id+'"'
		tmp = dataset_id
		remplacer, tmp, ' ', '_'
		remplacer, tmp, '#', '_'
		remplacer, tmp, '/', '_'
		dataset_id = tmp
		PRINT,'*** WARNING dataset_id => *** "'+dataset_id+'"'
	END
	IF STRPOS(parameter_id,' ') NE -1 OR STRPOS(parameter_id,'#') NE -1 OR STRPOS(parameter_id,'/') NE -1 THEN BEGIN
		; pas d'exemple
		PRINT,'*** WARNING parameter_id *** "'+parameter_id+'"'
		tmp = parameter_id
		remplacer, tmp, ' ', '_'
		remplacer, tmp, '#', '_'
		remplacer, tmp, '/', '_'
		parameter_id = tmp
		PRINT,'*** WARNING parameter_id => *** "'+parameter_id+'"'
	END
	IF STRPOS(parameter_var,' ') NE -1 OR STRPOS(parameter_var,'#') NE -1 THEN BEGIN
		; pas d'exemple
		PRINT,'*** WARNING parameter_var *** "'+parameter_var+'"'
		tmp = parameter_var
		remplacer, tmp, ' ', '_'
		remplacer, tmp, '#', '_'
		parameter_var = tmp
		PRINT,'*** WARNING parameter_var => *** "'+parameter_var+'"'
	END
	IF STRPOS(parameter_units,'#') NE -1 THEN BEGIN
		; pas d'exemple
		PRINT,'*** WARNING parameter_units *** "'+parameter_units+'"'
		tmp = parameter_units
		remplacer, tmp, '#', '_'
		parameter_units = tmp
		PRINT,'*** WARNING parameter_units => *** "'+parameter_units+'"'
	END
	IF STRPOS(parameter_name,'#') NE -1 THEN BEGIN
		; pas d'exemple
		PRINT,'*** WARNING parameter_name *** "'+parameter_name+'"'
		tmp = parameter_name
		remplacer, tmp, '#', '_'
		parameter_name = tmp
		PRINT,'*** WARNING parameter_name => *** "'+parameter_name+'"'
	END

	; nom de fichier:
	; - "xxx,$YYYYMMDD_V01.cef"
	; - "composante1,composante2,composante3,$YYYYMMDD_V01.cef"

	; Ne garde dans mission_id, instrument_id et dataset_id que ce qui suit le dernier ":"

	mission_id	= dernier_element (STRSPLIT (mission_id,	':',/EXTRACT))
	instrument_id	= dernier_element (STRSPLIT (instrument_id,	':',/EXTRACT))
	dataset_id	= dernier_element (STRSPLIT (dataset_id,	':',/EXTRACT))

	IF mission_id EQ '' THEN BEGIN
		; pas d'exemple
		mission_id    = "bug_mission_id"
	END

	IF instrument_id EQ '' THEN BEGIN
		; pas d'exemple
		instrument_id = "bug_instrument_id"
	END

	IF dataset_id EQ '' THEN BEGIN
		; ex: "<dataset att="" name="mit_Raw" xml:id="" sampling="58s" maxSampling="" dataStart="1973/10/31" dataStop="2006/07/26" dataSource="NSSDC" target="">"
		dataset_id    = "bug_dataset_id"
	END

	IF parameter_id EQ '' THEN BEGIN
		; pas d'exemple
		parameter_id  = "bug_parameter_id"
	END

	filename = 'filename=http://'+STRLOWCASE(datacenter_name)+'/'+mission_id+'/'+instrument_id+'/'+dataset_id+'/'+parameter_id+'/$YEAR/$MONTH/'+parameter_id+'_$YYYYMMDD_V01.xml'

	IF is_amda THEN BEGIN
		parameter_var = corriger_nomchamp((STRSPLIT(parameter_name,/EXTRACT))[0])
	END

	nom_sat = 'nom_sat='+mission_name
	nom_experiment = 'nom_experiment='+instrument_name

	IF parameter_var EQ '1d_data' OR parameter_var EQ '2d_data' OR parameter_var EQ '3d_data' OR parameter_var EQ '4d_data' THEN BEGIN
		action = 'ASCII P-1 SC1 '+parameter_var+' count3d type=time_energy yleft_auto=Manual yleft_log=Log yleft_min=1 yleft_max=40000 cjf=flux z_showdir=No z_theta=No z_phi=No z_energy=No'
	END ELSE BEGIN
		action = 'ASCII P-1 SC1 '+parameter_var+' header legend_theta=No legend_phi=No'
	END
	action += ' '+time_t1+' '+time_t2+' '+nom_sat+' '+nom_experiment+' '+filename +' '+ datemin + ' '+datemax

	code_webservice = 0
	messages = ['PB1', 'PB2', 'PB3', 'PB4', 'OK ' ]

	IF is_amda THEN BEGIN

		YYYY = STRMID(starttime,0,4)
		MM = STRMID(starttime,5,2)
		DD = STRMID(starttime,8,2)
		filename = 'http://amda/'+mission_id+'/'+instrument_id+'/'+dataset_id+'/'+parameter_id+'/'+YYYY+'/'+MM+'/'+parameter_id+'_'+YYYY+MM+DD+'_V01.xml'

	END ELSE BEGIN

		url1 = 'http://clweb.irap.omp.eu/getParameter.php?'
		url1 += 'parameterID='+parameter_id
		url1 += '&startTime='+starttime
		url1 += '&stopTime='+stoptime
		url1 += '&outputFormat=VOTable'

	END


	texte = ''

	IF is_amda THEN BEGIN

		localdir = dirname(get(general,'downloads_dir') + STRMID(filename,7)) + '/'

		link_html = filename
		mkdir_p,localdir,/o_write
		traiter_debut_http_special,link_html,localdir,localname,links2,datelinks2,taillelinks2,read_timeout,tmpinfos

		IF test_webservice THEN BEGIN

			IF tmpinfos.is_termine EQ 0 THEN BEGIN

				; le fichier n'existe pas ou a t dtruit car trop vieux: utiliser file_http_copy qui va essayer de le rcuprer

				; attendre 1 seconde pour ne pas exploser AMDA
				WAIT,1

				file_http_copy, filename, localdir, localname=localname, error=error
				IF fichier_existe(localname) AND STRMID(localname,STRLEN(localname)-4) EQ '.tmp' THEN BEGIN
					; renommer le fichier ".tmp"
					code = renommer (localname, STRMID(localname,0,STRLEN(localname)-4))
				END
				PRINT,filename+' error='+val_to_str(error)

			END

		END 

		IF STRMID(localname,STRLEN(localname)-4) EQ '.tmp' THEN BEGIN
			localname = STRMID(localname,0,STRLEN(localname)-4)
		END

		IF fichier_existe(localname) THEN BEGIN
			code_webservice = 2
			code = read_votable (localname, data)
			IF code THEN BEGIN
				code_webservice = 3
				HELP,data,/str
				HELP,data,/str,OUTPUT=texte
				IF N_ELEMENTS(texte) EQ 2 THEN code_webservice = 3 ; il y a une erreur car il y a un seul champ
				IF N_ELEMENTS(texte) NE 2 THEN code_webservice = 4
				texte = STRJOIN(texte[1:*],'<br>')
			END ELSE BEGIN
				PRINT,'=> fichier votable incorrect'
				OPENR, fd1, localname, /GET_LUN
				texte = REPLICATE ('',30)
				ligne = ''
				FOR i=1L,30 DO BEGIN
					IF EOF(fd1) THEN BREAK
					READF, fd1, ligne
					PRINT, 'LIGNE '+val_to_str(i)+' '+ligne
					texte[i-1] = ligne
				END
				FREE_LUN, fd1
				IF i EQ 1 THEN BEGIN
					texte = 'EMPTY FILE'
					PRINT, texte
				END ELSE BEGIN
					texte = htmlspecialchars_encode (texte)
					texte = STRJOIN(texte[WHERE(texte NE '')],'<br>')
				END
			END
		END ELSE BEGIN
			texte = 'NO FILE'
		END

	END ELSE BEGIN

		IF test_webservice THEN BEGIN

			link_html = url1

			cmd = 'wget -q "' + url1 + '" -O output1'
			PRINT, cmd
			SPAWN, cmd

			s = ''
			IF fichier_existe("output1") THEN BEGIN
				OPENR, fd1, 'output1', /GET_LUN
				READF, fd1, s
				FREE_LUN, fd1
				code_webservice = 1
			END
			PRINT,'=> '+s

			IF STRMID(s,0,7) EQ 'http://' THEN BEGIN
				url2 = s
				cmd1 = 'wget -q "' + url2 + '" -O output2'
				PRINT, cmd1
				SPAWN, cmd1
				IF fichier_existe("output2") THEN BEGIN
					code_webservice = 2
					code = read_votable ("output2", data)
					IF code THEN BEGIN
						code_webservice = 3
						HELP,data,/str
						HELP,data,/str,OUTPUT=texte
						IF N_ELEMENTS(texte) EQ 2 THEN code_webservice = 3 ; il y a une erreur car il y a un seul champ
						IF N_ELEMENTS(texte) NE 2 THEN code_webservice = 4
						texte = STRJOIN(texte[1:*],'<br>')
					END ELSE BEGIN
						PRINT,'=> fichier votable incorrect'
						OPENR, fd1, "output2", /GET_LUN
						texte = REPLICATE ('',30)
						ligne = ''
						FOR i=1L,30 DO BEGIN
							IF EOF(fd1) THEN BREAK
							READF, fd1, ligne
							PRINT, 'LIGNE '+val_to_str(i)+' '+ligne
							texte[i-1] = ligne
						END
						FREE_LUN, fd1
						IF i EQ 1 THEN BEGIN
							texte = 'FICHIER VIDE'
							PRINT, texte
						END ELSE BEGIN
							texte = htmlspecialchars_encode (texte)
							texte = STRJOIN(texte[WHERE(texte NE '')],'<br>')
						END
					END
				END ELSE BEGIN
					texte = 'NO FILE ' + s
				END
			END ELSE BEGIN
				texte = s
			END

		END ELSE BEGIN

			link_html = ''
			texte = 'NOT TESTED'

		END

	END

	OPENW, fd, fichier_html, /GET_LUN, /APPEND
	IF code_webservice NE 4 THEN BEGIN
		PRINTF, fd, '<TR bgcolor="ff0000">'
	END ELSE BEGIN
		PRINTF, fd, '<TR>'
	END
	PRINTF, fd, '<TD>'
	PRINTF, fd, val_to_str(numero)
	PRINTF, fd, '</TD>'
	PRINTF, fd, '<TD>'
	PRINTF, fd, '<b>'+mission_id+'</b><br>'+mission_name
	PRINTF, fd, '</TD>'
	PRINTF, fd, '<TD>'
	PRINTF, fd, '<b>'+instrument_id+'</b><br>'+instrument_name
	PRINTF, fd, '</TD>'
	PRINTF, fd, '<TD>'
	PRINTF, fd, '<b>'+dataset_id+'</b><br>'+dataset_name
	PRINTF, fd, '</TD>'
	PRINTF, fd, '<TD>'
	PRINTF, fd, '<b>'+parameter_id+'</b><br>'+parameter_var+'<br>"'+parameter_name+'"<br>'+parameter_units+ (parameter_units EQ '()' ? ' <FONT COLOR="ff7f00">NO UNIT</FONT>':'')
	PRINTF, fd, '</TD>'
	PRINTF, fd, '<TD>'
	PRINTF, fd, STRMID(starttime,0,10)+'<br>'+messages[code_webservice]+'<br>'+'<a href="'+link_html+'" target="_blank">link</a>'
	PRINTF, fd, '</TD>'
	PRINTF, fd, '<TD>'
	PRINTF, fd, texte
	PRINTF, fd, '</TD>'
	PRINTF, fd, '</TR>'
	FREE_LUN, fd

	IF code_webservice EQ 4 THEN BEGIN
		nb_ok++
	END ELSE BEGIN
		nb_pb++
	END

	lint_unused = detruire ("output1")
	lint_unused = detruire ("output2")
	PRINT, '==> ' + messages[code_webservice]
	PRINT, '==> ' +val_to_str(nb_ok) + ' / ' + val_to_str(nb_ok+nb_pb) + ' = ' + val_to_str_2decimales(100.0*nb_ok/(nb_ok+nb_pb))+' % OK'
	PRINT

	IF code_webservice EQ 0 THEN webservice_erreur += '[' + parameter_id + '] '

	IF messages[code_webservice] EQ 'OK ' THEN BEGIN
		RETURN, '0 ' + parameter_name + ' ' + parameter_units + '#' + action
	END ELSE BEGIN
		RETURN, '0 ' + messages[code_webservice]+' '+parameter_name + ' ' + parameter_units + '#' + action
	END

END

;-------------------------------------------------------------------------------
PRO decoder_arbre,		$
;-------------------------------------------------------------------------------
	nom_xml,		$	; LINT_PROTOTYPE input
	nom_racine,		$	; LINT_PROTOTYPE input
	nom_txt,		$	; LINT_PROTOTYPE input
	is_amda,		$	; LINT_PROTOTYPE input
	test_webservice,	$	; LINT_PROTOTYPE input
	fichier_html			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Lit l'arbre nom_xml et cre l'arbre nom_txt.
;-------------------------------------------------------------------------------
;
; 2<dataCenter name="" desc="" xml:id=""
;	3<mission name="" desc="" xml:id=""
;		4<instrument name="" desc="" xml:id=""
;			5<dataset att="" name="" xml:id="" sampling="" dataStart="" dataStop="" dataSource="" target=""
;			5<dataset name="" desc="" xml:id=""
;				6<parameter name="" xml:id="" units=""
;					<component xml:id="" name=""
;
;-------------------------------------------------------------------------------

	top1 = nbsec()

	OPENW, fd, fichier_html, /GET_LUN, /APPEND
	PRINTF, fd, '<html>'
	PRINTF, fd, '<head>'
	PRINTF, fd, '</head>'
	PRINTF, fd, '<body>'
	PRINTF, fd, date_to_str(get_date()) + '<br><br>'
	PRINTF, fd, nom_xml + '<br><br>'
	PRINTF, fd, "<TABLE border=1 style='border-collapse: collapse;'>"
	PRINTF, fd, '<TR>'
	PRINTF, fd, '<TH>NO</TH>'
	PRINTF, fd, '<TH>MISSION(ID,NAME)</TH>'
	PRINTF, fd, '<TH>INSTRUMENT(ID,NAME)</TH>'
	PRINTF, fd, '<TH>DATASET(ID,NAME)</TH>'
	PRINTF, fd, '<TH>PARAMETER(ID,VAR,NAME,UNIT)</TH>'
	PRINTF, fd, '<TH>DAY,CODE,LINK</TH>'
	PRINTF, fd, '<TH>MESSAGE</TH>'
	PRINTF, fd, '<TR>'
	FREE_LUN, fd

	webservice_erreur = ''	
	nb_ok = 0L
	nb_pb = 0L

	numero = 1L

	lint_unused = xml_to_noeud_variable_valeur (nom_xml, dataxml)

	OPENW, fd, nom_txt, /GET_LUN, /COMPRESS

	PRINTF, fd, '1 ' + nom_racine

	last = 1

	nb = N_ELEMENTS(dataxml)
	i = 0L
	WHILE i LT nb DO BEGIN

		IF dataxml[i].noeud EQ 'dataCenter' THEN BEGIN

			datacenter = { name:'', id:'', desc:'' }
			WHILE dataxml[i].noeud EQ 'dataCenter' DO BEGIN
				IF dataxml[i].variable EQ 'name'   THEN datacenter.name  = htmlspecialchars_decode(dataxml[i].valeur)
				IF dataxml[i].variable EQ 'xml:id' THEN datacenter.id    = htmlspecialchars_decode(dataxml[i].valeur)
				IF dataxml[i].variable EQ 'desc'   THEN datacenter.desc  = htmlspecialchars_decode(dataxml[i].valeur,/tooltip)
				i++
			END
			;PRINTF, fd, '2 ' + datacenter.name + (datacenter.desc EQ '' ? '' : (' '+STRING(4b)+datacenter.desc))
			;last = 2

		END ELSE IF dataxml[i].noeud EQ 'mission' THEN BEGIN

			mission = { name:'', id:'', desc:'' }
			WHILE dataxml[i].noeud EQ 'mission' DO BEGIN
				IF dataxml[i].variable EQ 'name'   THEN mission.name = htmlspecialchars_decode(dataxml[i].valeur)
				IF dataxml[i].variable EQ 'xml:id' THEN mission.id   = htmlspecialchars_decode(dataxml[i].valeur)
				IF dataxml[i].variable EQ 'desc'   THEN mission.desc = htmlspecialchars_decode(dataxml[i].valeur,/tooltip)
				i++
			END
			IF last GT 2 THEN PRINTF,fd, '0 Nothing'
			IF last GT 2 THEN PRINT,     '0 Nothing dans ' + nom_xml
			;IF last GT 2 THEN stop
			PRINTF, fd, '2 ' + mission.name + (mission.desc EQ '' ? '' : (' '+STRING(4b)+mission.desc))
			last = 2
			observatory = { name:'', id:'', desc:'' } ; initialis  vide

		END ELSE IF dataxml[i].noeud EQ 'observatory' THEN BEGIN

			observatory = { name:'', id:'', desc:'' }
			WHILE dataxml[i].noeud EQ 'observatory' DO BEGIN
				IF dataxml[i].variable EQ 'name'   THEN observatory.name = htmlspecialchars_decode(dataxml[i].valeur)
				IF dataxml[i].variable EQ 'xml:id' THEN observatory.id   = htmlspecialchars_decode(dataxml[i].valeur)
				IF dataxml[i].variable EQ 'desc'   THEN observatory.desc = htmlspecialchars_decode(dataxml[i].valeur,/tooltip)
				i++
			END
			IF last GT 3 THEN PRINTF,fd, '0 Nothing'
			IF last GT 3 THEN PRINT,     '0 Nothing dans ' + nom_xml
			;IF last GT 3 THEN stop
			PRINTF, fd, '3 ' + observatory.name + (observatory.desc EQ '' ? '' : (' '+STRING(4b)+observatory.desc))
			last = 3

		END ELSE IF dataxml[i].noeud EQ 'instrument' THEN BEGIN

			instrument = { name:'', id:'', desc:'' }
			WHILE dataxml[i].noeud EQ 'instrument' DO BEGIN
				IF dataxml[i].variable EQ 'name'   THEN instrument.name = htmlspecialchars_decode(dataxml[i].valeur)
				IF dataxml[i].variable EQ 'xml:id' THEN instrument.id   = htmlspecialchars_decode(dataxml[i].valeur)
				IF dataxml[i].variable EQ 'desc'   THEN instrument.desc = htmlspecialchars_decode(dataxml[i].valeur,/tooltip)
				i++
			END
			tmp = observatory.name EQ '' ? 3 : 4
			IF last GT tmp THEN PRINTF,fd, '0 Nothing'
			IF last GT tmp THEN PRINT,     '0 Nothing dans ' + nom_xml
			;IF last GT tmp THEN stop
			PRINTF, fd, val_to_str(tmp) + ' ' + instrument.name + (instrument.desc EQ '' ? '' : (' '+STRING(4b)+instrument.desc))
			last = tmp

		END ELSE IF dataxml[i].noeud EQ 'dataset' THEN BEGIN

			dataset = { name:'', id:'', datastart:'', datastop:'', desc:'' }
			WHILE dataxml[i].noeud EQ 'dataset' DO BEGIN
				IF dataxml[i].variable EQ 'name'      THEN dataset.name      = htmlspecialchars_decode(dataxml[i].valeur)
				IF dataxml[i].variable EQ 'xml:id'    THEN dataset.id        = htmlspecialchars_decode(dataxml[i].valeur)
				IF dataxml[i].variable EQ 'desc'      THEN dataset.desc      = htmlspecialchars_decode(dataxml[i].valeur,/tooltip)
				IF dataxml[i].variable EQ 'dataStart' THEN dataset.datastart = htmlspecialchars_decode(dataxml[i].valeur)
				IF dataxml[i].variable EQ 'dataStop'  THEN dataset.datastop  = htmlspecialchars_decode(dataxml[i].valeur)
				i++
			END
			tmp = observatory.name EQ '' ? 4 : 5
			IF last GT tmp THEN PRINTF,fd, '0 Nothing'
			IF last GT tmp THEN PRINT,     '0 Nothing dans ' + nom_xml
			;IF last GT tmp THEN stop
			PRINTF, fd, val_to_str(tmp) + ' ' + dataset.name + ' {' + dataset.datastart + ' ... ' + dataset.datastop + '}'+(dataset.desc EQ '' ? '' : (' '+STRING(4b)+dataset.desc))
			last = tmp

		END ELSE IF dataxml[i].noeud EQ 'parameter' THEN BEGIN

			; ex: "2003/01/01"
			jour	= STRMID(dataset.datastart,8,2)
			mois	= STRMID(dataset.datastart,5,2)
			annee	= STRMID(dataset.datastart,0,4)

			IF ~is_number(annee) || ~is_number(mois) || ~is_number(jour) THEN BEGIN
				; arrive pour AMDA dans "LocalDataBaseParameters.xml"
				; <dataset att="" name="A2000_gsm" xml:id="A2000_gsm" sampling="depending on mission" maxSampling="" dataStart="depending on mission" dataStop="depending on mission"
				jour	= '01'
				mois	= '01'
				annee	= '9999'
			END

			datemin = 'datemin='+val_to_str(LONG64(tu_to_date(annee,mois,jour,0,0,0)))

			; ex: "2011/07/02"
			jour	= STRMID(dataset.datastop,8,2)
			mois	= STRMID(dataset.datastop,5,2)
			annee	= STRMID(dataset.datastop,0,4)

			IF ~is_number(annee) || ~is_number(mois) || ~is_number(jour) THEN BEGIN
				; arrive pour AMDA dans "LocalDataBaseParameters.xml"
				; <dataset att="" name="A2000_gsm" xml:id="A2000_gsm" sampling="depending on mission" maxSampling="" dataStart="depending on mission" dataStop="depending on mission"
				jour	= '01'
				mois	= '01'
				annee	= '9999'
			END
			datemax = 'datemax='+val_to_str(LONG64(tu_to_date(annee,mois,jour,0,0,0)))

			time_t1 = 'time_t1='+val_to_str(jour)+STRING(2b)+val_to_str(mois)+STRING(2b)+val_to_str(annee)
			time_t2 = 'time_t2='+val_to_str(jour)+STRING(2b)+val_to_str(mois)+STRING(2b)+val_to_str(annee)+STRING(2b)+'24'
			starttime = int_str_0(annee,4)+'-'+int_str_0(mois,2)+'-'+int_str_0(jour,2)+'T00:00'
			date = tu_to_date(annee,mois,jour,0,0,0)
	                date_to_tu,date+86400000d,annee,mois,jour,heu,min,sec
			stoptime = int_str_0(annee,4)+'-'+int_str_0(mois,2)+'-'+int_str_0(jour,2)+'T00:00'

			parameter = { name:'', id:'', units:'', var:'', components_name:'', components_id:'', components_var:'' }
			WHILE dataxml[i].noeud NE '/parameter' DO BEGIN
				IF dataxml[i].noeud EQ 'parameter' AND dataxml[i].variable EQ 'name'     THEN parameter.name             = htmlspecialchars_decode(dataxml[i].valeur)
				IF dataxml[i].noeud EQ 'parameter' AND dataxml[i].variable EQ 'units'    THEN parameter.units            = '('+htmlspecialchars_decode(dataxml[i].valeur)+')'
				IF dataxml[i].noeud EQ 'parameter' AND dataxml[i].variable EQ 'var'      THEN parameter.var              = htmlspecialchars_decode(dataxml[i].valeur)
				IF dataxml[i].noeud EQ 'parameter' AND dataxml[i].variable EQ 'xml:id'   THEN parameter.id               = htmlspecialchars_decode(dataxml[i].valeur)
				IF dataxml[i].noeud EQ 'component' AND dataxml[i].variable EQ 'name'     THEN parameter.components_name += (parameter.components_name EQ '' ? '' : ',')+htmlspecialchars_decode(dataxml[i].valeur)
				IF dataxml[i].noeud EQ 'component' AND dataxml[i].variable EQ 'xml:id'   THEN parameter.components_id   += (parameter.components_id   EQ '' ? '' : ',')+htmlspecialchars_decode(dataxml[i].valeur)
				IF dataxml[i].noeud EQ 'component' AND dataxml[i].variable EQ 'var'      THEN parameter.components_var  += (parameter.components_var  EQ '' ? '' : ',')+htmlspecialchars_decode(dataxml[i].valeur)
				i++
			END

			; Correction de parameter.var s'il est vide (pour AMDA)
			IF parameter.var EQ '' THEN parameter.var = parameter.id

			; Correction de parameter.id et de l'ordre des composantes si le parametre dfini des components et que parameter.id contient '(' (pour AMDA)
			pos = STRPOS(parameter.id,'(')
			IF STRLOWCASE(datacenter.name) EQ 'amda' AND parameter.components_name NE '' AND pos NE -1 THEN BEGIN
				; ex:
				;	parameter.id			"t_i_tha"
				;	parameters.components_name	"t_para t_perp1 t_perp2"
				;	parameter.components_id		"t_i_tha(2) t_i_tha(0) t_i_tha(1)"
				;
				;  transformer en
				;
				;	parameter.id			"t_i_tha(0,2)"
				;	parameters.components_name	"t_perp1 t_perp2 t_para"
				;	parameter.components_id		"t_i_tha(0) t_i_tha(1) t_i_tha(2)"

				PRINT,'AVANT parameter.id = '+ parameter.id
				PRINT,'AVANT parameter.components_id = '+ parameter.components_id
				PRINT,'AVANT parameter.components_name = '+ parameter.components_name
				components_name = STRSPLIT(parameter.components_name, ',', /EXTRACT)
				components_id   = STRSPLIT(parameter.components_id,   ',', /EXTRACT)
				nbcomponents    = N_ELEMENTS(components_name)
				components_no   = REPLICATE(-1,nbcomponents)

				FOR j=0L,nbcomponents-1 DO BEGIN
					pos1 = STRPOS(components_id[j],'(',/REVERSE_SEARCH)
					pos2 = STRPOS(components_id[j],')',/REVERSE_SEARCH)
					IF pos1 EQ -1 OR pos2 EQ -1 THEN CONTINUE
					components_no[j] = STRMID(components_id[j],pos1+1,pos2-pos1-1)
				END
				IF (WHERE(components_no NE -1))[0] NE -1 THEN BEGIN
					premier_no = MIN(components_no)
					dernier_no = MAX(components_no)
					parameter.id = STRMID(parameter.id,0,STRPOS(parameter.id,'(')) + '('+val_to_str(premier_no)+':'+val_to_str(dernier_no)+')'
					ordre = REPLICATE(-1,nbcomponents)
					FOR j=premier_no,dernier_no DO BEGIN
						ordre[j-premier_no] = WHERE (components_no EQ j)
					END
					parameter.components_id   = STRJOIN(components_id[ordre],   ',')
					parameter.components_name = STRJOIN(components_name[ordre], ',')
					PRINT,'APRES parameter.id = '+ parameter.id
					PRINT,'APRES parameter.components_id   = '+ parameter.components_id
					PRINT,'APRES parameter.components_name = '+ parameter.components_name
					PRINT,nom_xml
					
				END

			END

			; Correction de parameter.components_var s'il est vide (pour AMDA)
			IF parameter.components_name NE '' AND parameter.components_var EQ '' THEN parameter.components_var = parameter.components_name


			parameter_name = parameter.name
			IF parameter.components_name NE '' THEN parameter_name += ' [' + parameter.components_name + ']'

			; Exception starttime/stoptime pour obtenir des donnes de CLWEB
			IF parameter.id EQ 'IT_EPHEMERIS_ORBIT_ELECTRON_DETAILED(23)' THEN BEGIN ; Hauteur ombre
				starttime = '1997-11-24T00:00'
				stoptime  = '1997-11-25T00:00'
			END ELSE IF parameter.id EQ 'IT_EPHEMERIS_ORBIT_ELECTRON_DETAILED(39)' THEN BEGIN ; Potentiel electrique
				starttime = '1997-11-26T00:00'
				stoptime  = '1997-11-27T00:00'
			END ELSE IF chaine_contient_debut(parameter.id,'IT_FM3I_GSM') THEN BEGIN
				starttime = '1997-11-26T00:00'
				stoptime  = '1997-11-27T00:00'
			END ELSE IF chaine_contient_debut(parameter.id,'IT_MIFM_GSM') THEN BEGIN
				starttime = '1997-11-26T00:00'
				stoptime  = '1997-11-27T00:00'
			END ELSE IF chaine_contient_debut(parameter.id,'IT_ELECTRON_3DMOMENTS') THEN BEGIN
				starttime = '1998-01-02T00:00'
				stoptime  = '1998-01-03T00:00'
			END ELSE IF chaine_contient_debut(parameter.id,'WI_MFI_H0_1M') THEN BEGIN
				starttime = '2009-02-21T00:00'
				stoptime  = '2009-02-22T00:00'
			END ELSE IF chaine_contient_debut(parameter.id,'WI_3DP_PLSP') THEN BEGIN
				starttime = '1994-12-13T00:00'
				stoptime  = '1994-12-14T00:00'
			END ELSE IF chaine_contient_debut(parameter.id,'WI_EPA_K0') THEN BEGIN
				starttime = '1994-12-13T00:00'
				stoptime  = '1994-12-14T00:00'
			END ELSE IF chaine_contient_debut(parameter.id,'WI_SMS_K0') THEN BEGIN
				starttime = '1994-12-29T00:00'
				stoptime  = '1994-12-30T00:00'
			END ELSE IF chaine_contient(parameter.id,'SWEA_3DMOMENTS') THEN BEGIN
				starttime = '2013-01-01T00:00'
				stoptime  = '2013-01-02T00:00'
			END ELSE IF chaine_contient_debut(parameter.id,'DSP1_HIA_MOMENTS_LOWG') OR chaine_contient_debut(parameter.id,'DSP1_HIA_3DMOMENTS_LOWG') THEN BEGIN
				starttime = '2004-02-13T00:00'
				stoptime  = '2004-02-14T00:00'
			END ELSE IF chaine_contient_debut(parameter.id,'DSP1_HIA_MOMENTS_HIGHG') OR chaine_contient_debut(parameter.id,'DSP1_HIA_3DMOMENTS_HIGHG') THEN BEGIN
				starttime = '2007-08-31T00:00'
				stoptime  = '2007-09-01T00:00'
			END ELSE IF chaine_contient(parameter.id,'CODIF_MOMENTS') OR chaine_contient(parameter.id,'CODIF_3DMOMENTS') THEN BEGIN
				starttime = '2002-01-01T00:00'
				stoptime  = '2002-01-02T00:00'
			END ELSE IF chaine_contient(parameter.id,'HIA_MOMENTS') OR chaine_contient(parameter.id,'HIA_3DMOMENTS') THEN BEGIN
				starttime = '2002-01-02T00:00'
				stoptime  = '2002-01-03T00:00'
			END

			;IF mission.name NE 'STEREO-Ahead' AND mission.name NE 'STEREO-Behind' THEN CONTINUE
			;IF instrument.name NE 'PLASTIC' THEN CONTINUE
			;IF mission.name NE 'CLUSTER1' THEN CONTINUE
			;IF chaine_contient_debut(parameter.id,'CLUSTER') EQ 0 THEN CONTINUE
			;IF chaine_contient_debut(parameter.id,'C3_HIA') EQ 0 THEN CONTINUE
			;IF chaine_contient_debut(parameter.id,'DSP1_HIA') EQ 0 THEN CONTINUE

			branche = get_feuille (				$
					numero,				$
					webservice_erreur,		$
					nb_ok,				$
					nb_pb,				$
					starttime,			$
					stoptime,			$
					time_t1,			$
					time_t2,			$
					datemin,			$
					datemax,			$
					datacenter.name,		$
					mission.name,			$
					mission.id,			$
					instrument.name,		$
					instrument.id,			$
					dataset.name,			$
					dataset.id,			$
					parameter_name,			$
					parameter.id,			$
					parameter.var,			$
					parameter.units,		$
					is_amda,			$
					test_webservice,		$
					fichier_html)
			numero++
			PRINTF, fd, branche
			last = 0

			IF parameter.components_name NE '' THEN BEGIN

				components_name = STRSPLIT (parameter.components_name, ',', /EXTRACT)
				components_id   = STRSPLIT (parameter.components_id,   ',', /EXTRACT)
				components_var  = STRSPLIT (parameter.components_var,  ',', /EXTRACT)
				nbcomponents    = N_ELEMENTS(components_name)

				FOR j=0L,nbcomponents-1 DO BEGIN
					; juste pour tester le WebService des composantes
					branche = get_feuille (	 					$
							numero,						$
							webservice_erreur,				$
							nb_ok,						$
							nb_pb,						$
							starttime,					$
							stoptime,					$
							time_t1,					$
							time_t2,					$
							datemin,					$
							datemax,					$
							datacenter.name,				$
							mission.name,					$
							mission.id,					$
							instrument.name,				$
							instrument.id,					$
							dataset.name,					$
							dataset.id,					$
							parameter.name+'  ['+components_name[j]+']',	$
							components_id[j],				$
							components_var[j],				$
							parameter.units,				$
							is_amda,					$
							test_webservice,				$
							fichier_html)
					numero++
				END

			END

			;IF webservice_erreur NE '' THEN PRINT,'PB: ' + webservice_erreur
			

		END ELSE BEGIN

			i++

		END

	END

	IF last NE 0 THEN PRINTF,fd, '0 Nothing'
	IF last NE 0 THEN PRINT,     '0 Nothing'

	FREE_LUN, fd

	IF webservice_erreur NE '' THEN PRINT,'PB: ' + webservice_erreur

	top2 = nbsec()

	OPENW, fd, fichier_html, /GET_LUN, /APPEND
	PRINTF, fd, '</TABLE>'
	PRINTF, fd, '<br>'
	IF (nb_ok+nb_pb) EQ 0 THEN PRINTF, fd, '=> ' +val_to_str(nb_ok) + ' / ' + val_to_str(nb_ok+nb_pb)
	IF (nb_ok+nb_pb) NE 0 THEN PRINTF, fd, '=> ' +val_to_str(nb_ok) + ' / ' + val_to_str(nb_ok+nb_pb) + ' = ' + val_to_str_2decimales(100.0*nb_ok/(nb_ok+nb_pb))+' % OK'

	PRINTF, fd, '<br><br> in ' + duree_to_str(1000d*(top2-top1))

	PRINTF, fd, '</body>'
	PRINTF, fd, '</html>'
	FREE_LUN, fd

END

;-------------------------------------------------------------------------------
PRO get_arbre_amda_clweb,	$
;-------------------------------------------------------------------------------
	amda,			$	; LINT_PROTOTYPE input
	clweb				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Cre les fichiers 'amda_local_tree.txt.gz' et 'amda_remote_tree.txt.gz' si amda==1 ou 'clweb_tree.txt.gz' si clweb==1.
;-------------------------------------------------------------------------------

	; Test du Webservice:
	;  1: pour appeller chaque mthode par http et crer le fichier "get_arbre_amda_local.html" ou "get_arbre_clweb.html"
	;  0: pour ne pas faire d'appel (trs rapide) et crer le fichier "xxx.html"
	test_webservice = 1

	recuperer_xml   = 1

	IF amda EQ 1 THEN BEGIN

		IF recuperer_xml THEN BEGIN

			SPAWN, 'wget "http://cdpp1.cesr.fr/AMDA-NG/php/rest/getObsDataTree.php" -O getAMDAtree.xml'

			lint_unused = xml_to_noeud_variable_valeur ('getAMDAtree.xml', dataxml)

			LocalDataBaseParameters = dataxml[WHERE (dataxml.noeud EQ 'LocalDataBaseParameters')].valeur
			PRINT, LocalDataBaseParameters
			SPAWN, 'wget ' + LocalDataBaseParameters + ' -O LocalDataBaseParameters.xml'

		END

		fichier1_html = '/home/penou/DATA/CLUSTER/SOFT/CLL3/clweb/log/get_arbre_amda_local.html'
		fichier2_html = '/net_clweb/DATA/CLUSTER/SOFT/CLL3/clweb/log/get_arbre_amda_local.html'
		IF ~test_webservice THEN fichier1_html = 'xxx.html'
		lint_unused = detruire (fichier1_html)
		decoder_arbre, 'LocalDataBaseParameters.xml',  'AMDA', '/home/penou/DATA/CLUSTER/SOFT/CLL3/resource/tree/amda_local_tree.txt.gz',  1, test_webservice, fichier1_html
		IF test_webservice THEN lint_unused = copier (fichier1_html, fichier2_html)

	END

	IF clweb EQ 1 THEN BEGIN

		fichier1_html = '/home/penou/DATA/CLUSTER/SOFT/CLL3/clweb/log/get_arbre_clweb.html'
		fichier2_html = '/net_clweb/DATA/CLUSTER/SOFT/CLL3/clweb/log/get_arbre_clweb.html'
		IF ~test_webservice THEN fichier1_html = 'xxx.html'
		lint_unused = detruire (fichier1_html)
		decoder_arbre, '/home/penou/DATA/CLUSTER/SOFT/CLL3/resource/xml/clweb_tree.xml', 'CLWeb (by Web Services)', '/home/penou/DATA/CLUSTER/SOFT/CLL3/resource/tree/clweb_tree.txt.gz', 0, test_webservice, fichier1_html
		IF test_webservice THEN lint_unused = copier (fichier1_html, fichier2_html)

	END

END
