;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: fenetre_timeaxis__define.pro,v $, v $Revision: 1.17 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO fenetre_timeaxis::fenetre_timeaxis_ajouter,	$
;-------------------------------------------------------------------------------
	t1,					$	; LINT_PROTOTYPE input
	t2,					$	; LINT_PROTOTYPE input
	x1,					$	; LINT_PROTOTYPE input
	x2,					$	; LINT_PROTOTYPE input
	y1,					$	; LINT_PROTOTYPE input
	y2,					$	; LINT_PROTOTYPE input
	nolabels,				$	; LINT_PROTOTYPE input
	ticklen,				$	; LINT_PROTOTYPE input
	police,					$	; LINT_PROTOTYPE input
	charsize,				$	; LINT_PROTOTYPE input
	couleur,				$	; LINT_PROTOTYPE input
	format,					$	; LINT_PROTOTYPE input
	jd,					$	; LINT_PROTOTYPE input
	thick						; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Mmorise les paramtres d'un "timeaxis".
;-------------------------------------------------------------------------------

	element = { un_timeaxis, 		$	

		t1:		t1, 		$ 
		t2:		t2, 		$
		x1:		x1, 		$
		x2:		x2, 		$
		y1:		y1, 		$
		y2:		y2, 		$
		nolabels:	nolabels,	$
		ticklen:	ticklen,	$
		police:		police,		$
		charsize:	charsize,	$
		couleur:	couleur,	$
		format:		format,		$
		jd:		jd,		$
		thick:		thick		$

	}

	nb = self.nb
	tab = self.timeaxis
	ajouter_tab1, tab, element, nb
	self.timeaxis = tab
	self.nb = nb

END

;-------------------------------------------------------------------------------
PRO fenetre_timeaxis::fvoir,	$
;-------------------------------------------------------------------------------
	i	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche le "timeaxis" numro i.
;-------------------------------------------------------------------------------

	tmp		= (*self.timeaxis)[i] ; utilisation de tmp sinon c'est trs lent en GDL
	t1		= tmp.t1
	t2		= tmp.t2
	x1		= self -> xn(tmp.x1)
	x2		= self -> xn(tmp.x2)
	y1		= self -> yn(tmp.y1)
	y2		= self -> yn(tmp.y2)
	nolabels	= tmp.nolabels
	ticklen		= tmp.ticklen
	police		= tmp.police
	charsize	= tmp.charsize
	couleur		= tmp.couleur
	format		= tmp.format
	jd		= tmp.jd
	thick		= tmp.thick
	rapps           = libplot_get(/D_NAME) EQ 'PS' ? get(self.general,'postscript_charsize_reduction') : 1.0

	IF !CL.libplot EQ '' && is_fdl() && is_fdl(/RELEASE) GE '0.79.48' AND thick GT 1 THEN thick = 1 + (thick-1)*0.5 ; sinon les caractres sont trop gras

	IF ~self.true THEN BEGIN
		translation = *self.translation
		couleur     = translation[couleur]
	END ELSE BEGIN
		couleur = rvb2no ((*self.rvb)[couleur].r, (*self.rvb)[couleur].v, (*self.rvb)[couleur].b)
	END

	libplot_plot, [t1,t2], [1,2], position=[x1,y1,x2,y2], /nodata, /noerase, xstyle=5, ystyle=5
	libplot_xyouts, 0, 0, police, /normal
	timeaxis,jd=jd,[t1,t2],ticklen=ticklen/(y2-y1),						$
		nolabels=nolabels OR (charsize EQ 0) OR (y1 EQ y2),				$
		charsize=charsize*rapps,color=couleur,FORM=format, THICK=thick, CHARTHICK=thick

	!TIME_COMMENT.x1 = x1
	!TIME_COMMENT.x2 = x2
	IF y1 LT !TIME_COMMENT.y1 THEN !TIME_COMMENT.y1 = y1

END

;-------------------------------------------------------------------------------
PRO fenetre_timeaxis::fenetre__remove_data
;-------------------------------------------------------------------------------
; Supprime toutes les donnes mmorises.
;-------------------------------------------------------------------------------

	PTR_FREE, self.timeaxis
	self.nb = 0

	self -> fen_remove_data

END

;-------------------------------------------------------------------------------
PRO fenetre_timeaxis::cleanup
;-------------------------------------------------------------------------------
; Destructeur de la classe "fenetre_timeaxis".
;-------------------------------------------------------------------------------

	self -> fenetre__remove_data

END

;-------------------------------------------------------------------------------
PRO fenetre_timeaxis__define
;-------------------------------------------------------------------------------
; La classe "fenetre_timeaxis" hrite de "fen".
;-------------------------------------------------------------------------------

	lint_unused = { un_timeaxis,		$

		t1:		0LL,		$
		t2:		0LL,		$
		x1:		0d,		$
		x2:		0d,		$
		y1:		0d,		$
		y2:		0d,		$
		nolabels:	0,		$
		ticklen:	0d,		$
		police:		'',		$
		charsize:	0d,		$
		couleur:	0,		$
		format:		'',		$
		jd:		0d,		$
		thick:		0d 		$

	}

	lint_unused = { fenetre_timeaxis,	$

		INHERITS	fen, 		$
		timeaxis:	PTR_NEW(), 	$
		nb:		0L 		$

	}

END
