;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: fenetre_texte__define.pro,v $, v $Revision: 1.12 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO fenetre_texte::fenetre_texte_ajouter,	$
;-------------------------------------------------------------------------------
	x,					$	; LINT_PROTOTYPE input
	y,					$	; LINT_PROTOTYPE input
	texte,					$	; LINT_PROTOTYPE input
	alignment,				$	; LINT_PROTOTYPE input
	taille,					$	; LINT_PROTOTYPE input
	couleur,				$	; LINT_PROTOTYPE input
	angle,					$	; LINT_PROTOTYPE input
	thick						; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Mmorise les paramtres d'un "texte".
;-------------------------------------------------------------------------------

	element = { un_texte,			$

		x:		x,		$
		y:		y,		$
		texte:		texte,		$
		alignment:	alignment,	$
		taille:		taille,		$
		couleur:	couleur,	$
		angle:		angle,		$
		thick:		thick		$

	}

	nb = self.nb
	tab = self.texte
	ajouter_tab1, tab, element, nb
	self.texte = tab
	self.nb = nb

END

;-------------------------------------------------------------------------------
PRO fenetre_texte::fvoir,	$
;-------------------------------------------------------------------------------
	i	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche le "texte" numro i.
;-------------------------------------------------------------------------------

	tmp		= (*self.texte)[i] ; utilisation de tmp sinon c'est trs lent en GDL
	x		= self -> xn(tmp.x)
	y		= self -> yn(tmp.y)
	texte		= tmp.texte
	alignment	= tmp.alignment
	taille		= tmp.taille
	couleur		= tmp.couleur
	angle		= tmp.angle
	thick		= tmp.thick
	rapps           = libplot_get(/D_NAME) EQ 'PS' ? get(self.general,'postscript_charsize_reduction') : 1.0

	IF !CL.libplot EQ '' && is_fdl() && is_fdl(/RELEASE) GE '0.79.48' AND thick GT 1 THEN thick = 1 + (thick-1)*0.5 ; sinon les caractres sont trop gras
	IF !CL.libplot EQ '' && is_gdl() AND taille EQ 0 THEN taille = 1 ; contrairement  IDL et FDL, GDL n'affiche rien si taille==0

	IF ~self.true THEN BEGIN
		translation = *self.translation
		couleur     = translation[couleur]
	END ELSE BEGIN
		couleur = rvb2no (((*self.rvb).r)[couleur], ((*self.rvb).v)[couleur], ((*self.rvb).b)[couleur])
	END

	IF !CL.libplot EQ '' && is_gdl() THEN BEGIN
		ss = get_string_size (get(self.general,'xsize'),get(self.general,'ysize'),get(self.general,'batch'),get(self.general,'pal'))
		; sparer par '!C' car gdl ne gre pas ce symbole qui signifie retour  la ligne
		texte1 = texte
		remplacer, texte1, '!C', STRING(1b)
		textes = STRSPLIT (texte1, STRING(1b), /EXTRACT) ; STRPSLIT ne sait sparer que par un seul caractre
		FOR i=0L,N_ELEMENTS(textes)-1 DO BEGIN
			; 2*ss car 1*ss n'est pas suffisant ...
			libplot_xyouts, x, y-i*2*ss, textes[i], alignment=alignment, /normal, charsize=taille*rapps, color=couleur, orientation=angle, charthick=thick
		END
	END ELSE BEGIN
		libplot_xyouts, x, y, texte, alignment=alignment, /normal, charsize=taille*rapps, color=couleur, orientation=angle, charthick=thick
	END

END

;-------------------------------------------------------------------------------
PRO fenetre_texte::fenetre__remove_data
;-------------------------------------------------------------------------------
; Supprime toutes les donnes mmorises.
;-------------------------------------------------------------------------------

	PTR_FREE, self.texte
	self.nb = 0

	self -> fen_remove_data

END

;-------------------------------------------------------------------------------
PRO fenetre_texte::cleanup
;-------------------------------------------------------------------------------
; Destructeur de la classe "fenetre_texte".
;-------------------------------------------------------------------------------

	self -> fenetre__remove_data

END

;-------------------------------------------------------------------------------
PRO fenetre_texte__define
;-------------------------------------------------------------------------------
; La classe "fenetre_texte" hrite de "fen".
;-------------------------------------------------------------------------------

	lint_unused = { un_texte, 		$

		x:		0d,		$
		y:		0d,		$
		texte:		'',		$
		alignment:	0d,		$
		taille:		0d,		$
		couleur:	0,		$
		angle:		0d,		$
		thick:		0d		$

	}

	lint_unused = { fenetre_texte, 		$

		INHERITS	fen, 		$
		texte:		PTR_NEW(), 	$
		nb:		0L 		$

	}

END
