	;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: fenetre_showdir__define.pro,v $, v $Revision: 1.11 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO fenetre_showdir::fenetre_showdir_ajouter,	$
;-------------------------------------------------------------------------------
	no,					$	; LINT_PROTOTYPE input
	x,					$	; LINT_PROTOTYPE input
	y,					$	; LINT_PROTOTYPE input
	taille,					$	; LINT_PROTOTYPE input
	couleur						; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Mmorise les paramtres d'un "showdir".
;-------------------------------------------------------------------------------

	element = { un_show_dir,	$

		no:		no,	$
		x:		x,	$
		y:		y,	$
		taille:		taille,	$
		couleur:	couleur	$

	}

	nb = self.nb
	tab = self.showdir
	ajouter_tab1, tab, element, nb
	self.showdir = tab
	self.nb = nb

END

;-------------------------------------------------------------------------------
PRO fenetre_showdir::fvoir,	$
;-------------------------------------------------------------------------------
	i	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche le "showdir" numro i.
;-------------------------------------------------------------------------------

	tmp	= (*self.showdir)[i] ; utilisation de tmp sinon c'est trs lent en GDL
	no	= tmp.no
	x	= self -> xn(tmp.x)
	y	= self -> yn(tmp.y)
	taille	= tmp.taille
	couleur	= tmp.couleur
	rapps   = libplot_get(/D_NAME) EQ 'PS' ? get(self.general,'postscript_charsize_reduction') : 1.0

	IF ~self.true THEN BEGIN
		translation = *self.translation
		couleur     = translation[couleur]
	END ELSE BEGIN
		couleur = rvb2no ((*self.rvb)[couleur].r, (*self.rvb)[couleur].v, (*self.rvb)[couleur].b)
	END

	show_dir, no, x, y, taille*rapps, couleur

END

;-------------------------------------------------------------------------------
PRO fenetre_showdir::fenetre__remove_data
;-------------------------------------------------------------------------------
; Supprime toutes les donnes mmorises.
;-------------------------------------------------------------------------------

	PTR_FREE, self.showdir
	self.nb = 0

	self -> fen_remove_data

END

;-------------------------------------------------------------------------------
PRO fenetre_showdir::cleanup
;-------------------------------------------------------------------------------
; Destructeur de la classe "fenetre_showdir".
;-------------------------------------------------------------------------------

	self -> fenetre__remove_data

END

;-------------------------------------------------------------------------------
PRO fenetre_showdir__define
;-------------------------------------------------------------------------------
; La classe "fenetre_showdir" hrite de "fen".
;-------------------------------------------------------------------------------

	lint_unused = { un_show_dir,		$

		no:		0,		$
		x:		0d,		$
		y:		0d,		$
		taille:		0d,		$
		couleur:	0		$

	}

	lint_unused = { fenetre_showdir, 	$

		INHERITS	fen, 		$
		showdir:	PTR_NEW(), 	$
		nb:		0L 		$

	}

END
