;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: fenetre_palette__define.pro,v $, v $Revision: 1.11 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO fenetre_palette::fenetre_palette_ajouter,	$
;-------------------------------------------------------------------------------
	x1,					$	; LINT_PROTOTYPE input
	x2,					$	; LINT_PROTOTYPE input
	y1,					$	; LINT_PROTOTYPE input
	y2,					$	; LINT_PROTOTYPE input
	xval,					$	; LINT_PROTOTYPE input
	yval,					$	; LINT_PROTOTYPE input
	taille,					$	; LINT_PROTOTYPE input
	epais,					$	; LINT_PROTOTYPE input
	nb,					$	; LINT_PROTOTYPE input
	format,					$	; LINT_PROTOTYPE input
	min,					$	; LINT_PROTOTYPE input
	max,					$	; LINT_PROTOTYPE input
	txt,					$	; LINT_PROTOTYPE input
	xtxt,					$	; LINT_PROTOTYPE input
	ytxt,					$	; LINT_PROTOTYPE input
	couleurs,				$	; LINT_PROTOTYPE input
	couleur						; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Mmorise les paramtres d'une "palette".
;-------------------------------------------------------------------------------

	element = { une_palette,			$
		x1:		x1,			$
		x2:		x2,			$
		y1:		y1,			$
		y2:		y2,			$
		xval:		xval,			$
		yval:		yval,			$
		taille:		taille,			$
		epais:		epais,			$
		nb:		nb,			$
		format:		format,			$
		min:		min,			$
		max:		max,			$
		txt:		txt,			$
		xtxt:		xtxt,			$
		ytxt:		ytxt,			$
		couleurs:	PTR_NEW(couleurs),	$
		couleur:	couleur			$
	}

	nb = self.nb
	tab = self.palette
	ajouter_tab1, tab, element, nb
	self.palette = tab
	self.nb = nb

END

;-------------------------------------------------------------------------------
PRO fenetre_palette::fvoir,	$
;-------------------------------------------------------------------------------
	i	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche la "palette" numro i.
;-------------------------------------------------------------------------------

	tmp		= (*self.palette)[i] ; utilisation de tmp sinon c'est trs lent en GDL
	x1		= self -> xn(tmp.x1)
	x2		= self -> xn(tmp.x2)
	y1		= self -> yn(tmp.y1)
	y2		= self -> yn(tmp.y2)
	xval		= self -> xn(tmp.xval)
	yval		= self -> yn(tmp.yval)
	taille		= tmp.taille
	epais		= tmp.epais
	nb		= tmp.nb
	format		= tmp.format
	min		= tmp.min
	max		= tmp.max
	txt		= tmp.txt
	xtxt		= self -> xn(tmp.xtxt)
	ytxt		= self -> yn(tmp.ytxt)
	couleurs	= *tmp.couleurs
	couleur		= tmp.couleur
	rapps           = libplot_get(/D_NAME) EQ 'PS' ? get(self.general,'postscript_charsize_reduction') : 1.0

	IF ~self.true THEN BEGIN
		translation = *self.translation
		couleurs    = translation[couleurs]
		couleur     = translation[couleur]
	END ELSE BEGIN
		couleurs = rvb2no ((*self.rvb)[couleurs].r, (*self.rvb)[couleurs].v, (*self.rvb)[couleurs].b)
		couleur  = rvb2no ((*self.rvb)[couleur].r,  (*self.rvb)[couleur].v,  (*self.rvb)[couleur].b)
	END

	show_palette, x1, x2, y1, y2, xval, yval, taille*rapps, epais, nb, format, min, max, txt, xtxt, ytxt, couleurs, couleur

END

;-------------------------------------------------------------------------------
PRO fenetre_palette::fenetre__remove_data
;-------------------------------------------------------------------------------
; Supprime toutes les donnes mmorises.
;-------------------------------------------------------------------------------

	FOR i=0L,self.nb-1 DO PTR_FREE, (*self.palette)[i].couleurs
	PTR_FREE, self.palette
	self.nb = 0

	self -> fen_remove_data

END

;-------------------------------------------------------------------------------
PRO fenetre_palette::cleanup
;-------------------------------------------------------------------------------
; Destructeur de la classe "fenetre_palette".
;-------------------------------------------------------------------------------

	self -> fenetre__remove_data

END

;-------------------------------------------------------------------------------
PRO fenetre_palette__define
;-------------------------------------------------------------------------------
; La classe "fenetre_palette" hrite de "fen".
;-------------------------------------------------------------------------------

	lint_unused = { une_palette,		$

		x1:		0d,		$
		x2:		0d,		$
		y1:		0d,		$
		y2:		0d,		$
		xval:		0d,		$
		yval:		0d,		$
		taille:		0d,		$
		epais:		0d,		$
		nb:		0,		$
		format:		'',		$
		min:		0d,		$
		max:		0d,		$
		txt:		'',		$
		xtxt:		0d,		$
		ytxt:		0d,		$
		couleurs:	PTR_NEW(), 	$
		couleur:	0 		$

	}

	lint_unused = { fenetre_palette,	$

		INHERITS	fen,		$
		palette:	PTR_NEW(), 	$
		nb:		0L 		$

	}

END
