;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: fenetre_orbito__define.pro,v $, v $Revision: 1.11 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO fenetre_orbito::fenetre_orbito_ajouter,	$
;-------------------------------------------------------------------------------
	tab_data,				$	; LINT_PROTOTYPE input
	t1,					$	; LINT_PROTOTYPE input
	t2,					$	; LINT_PROTOTYPE input
	x0,					$	; LINT_PROTOTYPE input
	x1,					$	; LINT_PROTOTYPE input
	x2,					$	; LINT_PROTOTYPE input
	y1,					$	; LINT_PROTOTYPE input
	y2,					$	; LINT_PROTOTYPE input
	orb_txt,				$	; LINT_PROTOTYPE input
	tailleorb,				$	; LINT_PROTOTYPE input
	fontorb,				$	; LINT_PROTOTYPE input
	epaisorb,				$	; LINT_PROTOTYPE input
	presence,				$	; LINT_PROTOTYPE input
	couleur						; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Mmorise les paramtres d'un "orbito".
;-------------------------------------------------------------------------------

	element = { une_orbito,				$
		tab_data:	PTR_NEW(tab_data),	$
		t1:		t1,			$
		t2:		t2,			$
		x0:		x0,			$
		x1:		x1,			$
		x2:		x2,			$
		y1:		y1,			$
		y2:		y2,			$
		orb_txt:	PTR_NEW(orb_txt),	$
		tailleorb:	tailleorb,		$
		fontorb:	fontorb,		$
		epaisorb:	epaisorb,		$
		presence:	PTR_NEW(presence),	$
		couleur:	couleur			$
	}

	nb = self.nb
	tab = self.orbito
	ajouter_tab1, tab, element, nb
	self.orbito = tab
	self.nb = nb

END

;-------------------------------------------------------------------------------
PRO fenetre_orbito::fvoir,	$
;-------------------------------------------------------------------------------
	i	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche l'"orbito" numro i.
;-------------------------------------------------------------------------------

	tmp		= (*self.orbito)[i] ; utilisation de tmp sinon c'est trs lent en GDL
	tab_data	= *tmp.tab_data
	t1		= tmp.t1
	t2		= tmp.t2
	x0		= self -> xn(tmp.x0)
	x1		= self -> xn(tmp.x1)
	x2		= self -> xn(tmp.x2)
	y1		= self -> yn(tmp.y1)
	y2		= self -> yn(tmp.y2)
	orb_txt		= *tmp.orb_txt
	tailleorb	= tmp.tailleorb
	fontorb		= tmp.fontorb
	epaisorb	= tmp.epaisorb
	presence	= *tmp.presence
	couleur		= tmp.couleur
	rapps           = libplot_get(/D_NAME) EQ 'PS' ? get(self.general,'postscript_charsize_reduction') : 1.0

	IF ~self.true THEN BEGIN
		translation = *self.translation
		couleur     = translation[couleur]
	END ELSE BEGIN
		couleur = rvb2no ((*self.rvb).r,(*self.rvb).v,(*self.rvb).b)
	END

	ecrire_orbito, tab_data,t1,t2,x0,x1,x2,y1,y2,orb_txt,tailleorb*rapps,fontorb,epaisorb,presence,couleur

END

;-------------------------------------------------------------------------------
PRO fenetre_orbito::fenetre__remove_data
;-------------------------------------------------------------------------------
; Supprime toutes les donnes mmorises.
;-------------------------------------------------------------------------------

	FOR i=0L,self.nb-1 DO BEGIN
		tmp = (*self.orbito)[i] ; utilisation de tmp sinon c'est trs lent en GDL
		PTR_FREE, tmp.tab_data
		PTR_FREE, tmp.orb_txt
		PTR_FREE, tmp.presence
	END
	PTR_FREE, self.orbito
	self.nb = 0

	self -> fen_remove_data


END

;-------------------------------------------------------------------------------
PRO fenetre_orbito::cleanup
;-------------------------------------------------------------------------------
; Destructeur de la classe "fenetre_orbito".
;-------------------------------------------------------------------------------

	self -> fenetre__remove_data

END

;-------------------------------------------------------------------------------
PRO fenetre_orbito__define
;-------------------------------------------------------------------------------
; La classe "fenetre_orbito" hrite de "fen".
;-------------------------------------------------------------------------------

	lint_unused = { une_orbito,		$

		tab_data:	PTR_NEW(),	$
		t1:		0d,		$
		t2:		0d,		$
		x0:		0d,		$
		x1:		0d,		$
		x2:		0d,		$
		y1:		0d,		$
		y2:		0d,		$
		orb_txt:	PTR_NEW(),	$
		tailleorb:	0d,		$
		fontorb:	'',		$
		epaisorb:	0d,		$
		presence:	PTR_NEW(),	$
		couleur:	0		$

	}

	lint_unused = { fenetre_orbito,		$

		INHERITS	fen,		$
		orbito:		PTR_NEW(),	$
		nb:		0L		$

	}

END
