;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: fenetre_image__define.pro,v $, v $Revision: 1.37 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO fenetre_image::fenetre_image_ajouter,	$
;-------------------------------------------------------------------------------
	image,					$	; LINT_PROTOTYPE input
	x1,					$	; LINT_PROTOTYPE input
	x2,					$	; LINT_PROTOTYPE input
	y1,					$	; LINT_PROTOTYPE input
	y2,					$	; LINT_PROTOTYPE input
	true=true,				$	; LINT_PROTOTYPE input
	produit=produit,			$	; LINT_PROTOTYPE input
	trans=trans,				$	; LINT_PROTOTYPE input
	min=min,				$	; LINT_PROTOTYPE input
	max=max,				$	; LINT_PROTOTYPE input
	nb=nb,					$	; LINT_PROTOTYPE input
	type=type,				$	; LINT_PROTOTYPE input
	az=az,					$	; LINT_PROTOTYPE input
	ax=ax,					$	; LINT_PROTOTYPE input
	is3D=is3D,				$	; LINT_PROTOTYPE input
	constraint=constraint,			$	; LINT_PROTOTYPE input
	NO_COPY=NO_COPY,			$	; LINT_PROTOTYPE input
	contoursnb=contoursnb,			$	; LINT_PROTOTYPE input
	interp=interp,				$	; LINT_PROTOTYPE input
	continents=continents,			$	; LINT_PROTOTYPE input
	hires=hires,				$	; LINT_PROTOTYPE input
	moins180plus180=moins180plus180,	$	; LINT_PROTOTYPE input
	mlinethick=mlinethick,			$	; LINT_PROTOTYPE input
	xmin=xmin,				$	; LINT_PROTOTYPE input
	xmax=xmax,				$	; LINT_PROTOTYPE input
	ymin=ymin,				$	; LINT_PROTOTYPE input
	ymax=ymax,				$	; LINT_PROTOTYPE input
	blanc=blanc,				$	; LINT_PROTOTYPE input
	longitude=longitude,			$	; LINT_PROTOTYPE input
	latitude=latitude,			$	; LINT_PROTOTYPE input
	rotation=rotation,			$	; LINT_PROTOTYPE input
	info_B=info_B,				$	; LINT_PROTOTYPE input
	info_U=info_U					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Mmorise les paramtres d'une "image".
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(true) 		EQ 0 THEN true			= 0
	IF N_ELEMENTS(produit) 		EQ 0 THEN produit		= -1
	IF N_ELEMENTS(trans) 		EQ 0 THEN trans			= -1
	IF N_ELEMENTS(min) 		EQ 0 THEN min			= -1
	IF N_ELEMENTS(max) 		EQ 0 THEN max			= -1
	IF N_ELEMENTS(nb) 		EQ 0 THEN nb			= -1
	IF N_ELEMENTS(type) 		EQ 0 THEN type			= 0
	IF N_ELEMENTS(az) 		EQ 0 THEN az			= -1
	IF N_ELEMENTS(ax) 		EQ 0 THEN ax			= -1
	IF N_ELEMENTS(constraint) 	EQ 0 THEN constraint		= 'None'
	IF N_ELEMENTS(is3D) 		EQ 0 THEN is3D			= 0
	IF N_ELEMENTS(contoursnb) 	EQ 0 THEN contoursnb		= -1
	IF N_ELEMENTS(interp) 		EQ 0 THEN interp		= 'congrid'
	IF N_ELEMENTS(continents) 	EQ 0 THEN continents		= 0
	IF N_ELEMENTS(hires)		EQ 0 THEN hires			= 0
	IF N_ELEMENTS(moins180plus180)	EQ 0 THEN moins180plus180	= 1
	IF N_ELEMENTS(mlinethick)	EQ 0 THEN mlinethick		= 2
	IF N_ELEMENTS(xmin) 		EQ 0 THEN xmin			= 0.
	IF N_ELEMENTS(xmax) 		EQ 0 THEN xmax			= 360.
	IF N_ELEMENTS(ymin) 		EQ 0 THEN ymin			= -90.
	IF N_ELEMENTS(ymax) 		EQ 0 THEN ymax			= 90.
	IF N_ELEMENTS(blanc) 		EQ 0 THEN blanc			= -1
	IF N_ELEMENTS(longitude)	EQ 0 THEN longitude		= 0
	IF N_ELEMENTS(latitude)		EQ 0 THEN latitude		= 0
	IF N_ELEMENTS(rotation)		EQ 0 THEN rotation		= 0

	element = { une_image, 							$
		produit:		PTR_NEW(produit,NO_COPY=NO_COPY), 	$
		trans:			PTR_NEW(trans),				$
		min:			min,					$
		max:			max,					$
		nb:			nb,					$
		type:			type,					$
		az:			az,					$
		ax:			ax,					$
		is3D:			is3D,					$
		constraint:		constraint,				$
		imagedata:		PTR_NEW(image,NO_COPY=NO_COPY),		$
		true:			true,					$
		x1:			x1,					$
		x2:			x2,					$
		y1:			y1,					$
		y2:			y2,					$
		contoursnb:		contoursnb,				$
		interp:			interp,					$
		continents:		continents,				$
		hires:			hires,					$
		moins180plus180:	moins180plus180,			$
		mlinethick:		mlinethick,				$
		xmin:			xmin,					$
		xmax:			xmax,					$
		ymin:			ymin,					$
		ymax:			ymax,					$
		blanc:			blanc,					$
		longitude:		longitude,				$
		latitude:		latitude,				$
		rotation:		rotation,				$
		info_B:			PTR_NEW(info_B),			$
		info_U:			PTR_NEW(info_U)				$
	}

	; Attention: ne peut pas utiliser nb car sinon cela va changer la valeur du keyword!
	nbtmp = self.nb
	tab = self.image
	ajouter_tab1, tab, element, nbtmp
	self.image = tab
	self.nb = nbtmp

END

;-------------------------------------------------------------------------------
PRO fenetre_image::get_imagedata,	$
;-------------------------------------------------------------------------------
	i,				$	; LINT_PROTOTYPE input
	imagedata,			$	; LINT_PROTOTYPE output
	x1,				$	; LINT_PROTOTYPE output
	x2,				$	; LINT_PROTOTYPE output
	y1,				$	; LINT_PROTOTYPE output
	y2,				$	; LINT_PROTOTYPE output
	true,				$	; LINT_PROTOTYPE output
	produit,			$	; LINT_PROTOTYPE output
	is3D					; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne certains paramtres de l'image numro "i".
;-------------------------------------------------------------------------------

	tmp		= (*self.image)[i] ; utilisation de tmp sinon c'est trs lent en GDL
	imagedata	= *(tmp.imagedata)
	produit		= *(tmp.produit)
	true		= tmp.true
	is3D		= tmp.is3D
	x1		= self -> xn(tmp.x1)
	x2		= self -> xn(tmp.x2)
	y1		= self -> yn(tmp.y1)
	y2		= self -> yn(tmp.y2)

END

;-------------------------------------------------------------------------------
FUNCTION fenetre_image::cherche_imagedata,	$
;-------------------------------------------------------------------------------
	i,					$	; LINT_PROTOTYPE input
	xn,					$	; LINT_PROTOTYPE input
	yn						; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne 1 si l'iamge numro "i" contient le point (xn,yn).
;-------------------------------------------------------------------------------

	tmp = (*self.image)[i] ; utilisation de tmp sinon c'est trs lent en GDL
	IF xn LT self -> xn(tmp.x1) THEN RETURN, 0
	IF xn GT self -> xn(tmp.x2) THEN RETURN, 0
	IF yn LT self -> yn(tmp.y1) THEN RETURN, 0
	IF yn GT self -> yn(tmp.y2) THEN RETURN, 0

	RETURN, 1

END

;-------------------------------------------------------------------------------
PRO fenetre_image::fvoir,	$
;-------------------------------------------------------------------------------
	i	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche l'"image" numro i.
;-------------------------------------------------------------------------------

	tmp  			= (*self.image)[i] ; utilisation de tmp sinon c'est trs lent en GDL
	imagedata  		= *tmp.imagedata
	produit    		= *tmp.produit
	trans      		= *tmp.trans
	min        		= tmp.min
	max        		= tmp.max
	nb         		= tmp.nb
	type       		= tmp.type
	az         		= tmp.az
	ax         		= tmp.ax
	is3D       		= tmp.is3D
	constraint 		= tmp.constraint
	true       		= tmp.true
	x1         		= self -> xn(tmp.x1)
	x2       	  	= self -> xn(tmp.x2)
	y1         		= self -> yn(tmp.y1)
	y2      		= self -> yn(tmp.y2)
	contoursnb 		= tmp.contoursnb
	interp    	 	= tmp.interp
	continents		= tmp.continents
	hires			= tmp.hires
	moins180plus180		= tmp.moins180plus180
	mlinethick		= tmp.mlinethick
	xmin       		= tmp.xmin
	xmax       		= tmp.xmax
	ymin       		= tmp.ymin
	ymax       		= tmp.ymax
	blanc      		= tmp.blanc
	longitude      		= tmp.longitude
	latitude      		= tmp.latitude
	rotation      		= tmp.rotation
	info_B      		= tmp.info_B
	info_U      		= tmp.info_U

	IF !CL.libplot EQ '' && is_fdl() && is_fdl(/RELEASE) GE '0.79.48' AND mlinethick GT 1 THEN mlinethick = 1 + (mlinethick-1)*0.5 ; sinon les caractres sont trop gras

	translater = 0
	hash_general = self.general -> gethash()

	IF libplot_get(/D_NAME) EQ 'X' OR libplot_get(/D_NAME) EQ 'WIN' THEN BEGIN
		xsize = ROUND(libplot_get(/D_X_VSIZE)*(x2-x1))
		ysize = ROUND(libplot_get(/D_Y_VSIZE)*(y2-y1))
	END ELSE BEGIN
		xsize = 1.0
		ysize = 1.0
	END

	pb = 0
	IF self.code EQ 0 THEN BEGIN
		pb = 1
	END ELSE BEGIN
		IF N_ELEMENTS(imagedata) EQ 1 AND imagedata[0] LT 0 THEN pb = -imagedata[0]
	END

	IF ~pb AND ~self.true AND true AND (libplot_get(/D_NAME) EQ 'X' OR libplot_get(/D_NAME) EQ 'WIN') THEN pb = 6

	IF ~pb THEN BEGIN
		ind = WHERE (imagedata EQ !VALUES.F_INFINITY)
		IF produit[0] NE -1 THEN BEGIN
			IF ~is3D THEN BEGIN
				image = BYTSCL (imagedata, MIN=min, MAX=max, /NAN, TOP=nb-1)
			END ELSE BEGIN
				image = imagedata
			END
			IF ind[0] NE -1 AND blanc NE -1 THEN image[ind] = blanc
			image = trans[image]
		END ELSE BEGIN
			image = imagedata
		END
	END

	IF ~pb AND type NE 0 AND self.true THEN pb = 8

	IF ~pb AND type NE 0 THEN BEGIN

		translation = *self.translation

		IF type EQ 1 THEN BEGIN

			set, self.general, 'contains_image', 1
			shades = translation[image]
			ind = WHERE (imagedata NE !VALUES.F_INFINITY)
			IF ind[0] NE -1 THEN BEGIN
				libplot_set_shading, gouraud=0
				libplot_shade_surf, imagedata, position=[x1,y1,x2,y2], /noerase, /normal, $
							ax=45+ax, az=30+az, xstyle=5, ystyle=5, zstyle=5, min_value=min, max_value=max, shades=shades
			END
			RETURN 

		END ELSE IF type EQ 2 OR type EQ 3 OR type EQ 4 THEN BEGIN

			n_levels = MIN([nb,60])
			IF n_levels LT 1 THEN BEGIN
				pb = 7
			END ELSE BEGIN
				set, self.general, 'contains_image', 1
				ind = INDGEN(n_levels)*(nb-1)/(n_levels-1)
				levels = min + (ind+0.5)*(max-min)/nb
				c_colors = translation[ind]
				ind = WHERE (imagedata NE !VALUES.F_INFINITY)
				IF ind[0] NE -1 THEN BEGIN
					libplot_contour, imagedata, position=[x1,y1,x2,y2], /noerase, /normal, $
								c_colors=c_colors, levels=levels, xstyle=5, ystyle=5, /closed
				END
				IF type EQ 3 OR type EQ 4 THEN BEGIN
					; Juin 2012: rajout BACKGROUND=0 pour avoir du blanc et non du noir dans les fonctions de distributions aux endroits ou il n'y
					; a pas de donnes
					IF ind[0] NE -1 THEN BEGIN
						libplot_contour, imagedata, c_colors=c_colors, levels=levels, /fill, /overplot, background=0, /closed
					END
				END
				IF type EQ 4 THEN BEGIN
					ind = INDGEN(contoursnb)*(nb-1)/(contoursnb-1)
					levels = min + (ind+0.5)*(max-min)/nb
					IF is_fdl() THEN BEGIN
						; sinon erreur
						c_colors = REPLICATE (1, N_ELEMENTS(ind)) ; couleur noire
					END ELSE BEGIN
						c_colors = 1 ; couleur noire
					END
					c_linestyle = 2
					IF ind[0] NE -1 THEN BEGIN
						libplot_contour, imagedata, position=[x1,y1,x2,y2], /noerase, /normal, $
									c_colors=c_colors, levels=levels, xstyle=5, ystyle=5, c_linestyle=c_linestyle, /closed
					END
				END
				IF continents THEN BEGIN
					coul = 1 ; noir
					pal = getq (self.general, hash_general.pal)
					code = pal -> code(coul)
					;MAP_SET, /CYLINDRICAL, 0, 0, /CONTINENTS, COLOR=code, limit=[ymin,xmin,ymax,xmax], position=[x1,y1,x2,y2], /NOERASE
					IF !CL.libplot NE '' OR is_gdl() OR is_fdl() THEN BEGIN
						; MAP_SET ne marche que sous IDL
						my_map_continents, 0, moins180plus180 EQ 1 ? 0 : 180, xmin, xmax, ymin, ymax, hires, mlinethick, code, [x1,y1,x2,y2]
					END ELSE BEGIN
						MAP_SET, HIRES=hires, mlinethick=mlinethick, /CYLINDRICAL, 0, moins180plus180 EQ 1 ? 0 : 180, /CONTINENTS, COLOR=code, limit=[ymin,xmin,ymax,xmax], position=[x1,y1,x2,y2], /NOERASE
					END
				END
				RETURN
			END

		END
	END

	IF ~pb THEN BEGIN
		IF ~self.true THEN BEGIN ; affichage non true color
			IF ~true THEN translater = 1
		END
	END

	IF ~pb AND (libplot_get(/D_NAME) EQ 'X' OR libplot_get(/D_NAME) EQ 'WIN') THEN BEGIN
		IF ~true THEN BEGIN
			nbx = N_ELEMENTS(image[*,0])
			nby = N_ELEMENTS(image[0,*])
			code = get_nbx1_nby1 (constraint,nbx,nby,xsize,ysize,nbx1,nby1)
			IF code EQ 0 THEN BEGIN
				IF nbx1 NE nbx OR nby1 NE nby THEN image = CONGRID (image, nbx1, nby1)
			END
		END ELSE BEGIN
			nbx = N_ELEMENTS(image[0,*,0])
			nby = N_ELEMENTS(image[0,0,*])
			code = get_nbx1_nby1 (constraint,nbx,nby,xsize,ysize,nbx1,nby1)
			IF code EQ 0 THEN BEGIN
				IF nbx1 NE nbx OR nby1 NE nby THEN BEGIN
					; (nbx1, nby1): taille de l'image a creer
					; (nbx, nby): taille de l'image en entree
					IF interp EQ 'None' AND nbx1 GE nbx AND nby1 GE nby THEN BEGIN
						;image1 = REPLICATE (0b, 3, nbx1, nby1)
						;rap = FLOAT(nbx1) / FLOAT (nbx)
						;FOR i = 0L, nbx-1 DO BEGIN
						;	FOR j = 0L, nby-1 DO BEGIN
						;		xdeb = rap*i
						;		xfin = MIN ( [nbx1-1 , xdeb + rap] )
						;		ydeb = rap*j
						;		yfin = MIN ( [nby1-1, ydeb + rap] )
						;		image1 [0, xdeb:xfin, ydeb:yfin] = image [ 0, i, j]
						;		image1 [1, xdeb:xfin, ydeb:yfin] = image [ 1, i, j]
						;		image1 [2, xdeb:xfin, ydeb:yfin] = image [ 2, i, j]
						;	END
						;END
						;image = image1
						image = CONGRID (image, 3, nbx1, nby1)
					END ELSE BEGIN
						image = CONGRID (image, 3, nbx1, nby1)
					END
				END
			END
		END
		IF code EQ -1 THEN pb = 4
	END

	IF translater THEN BEGIN
		translation = *self.translation
		image = translation[image]

	END

	IF pb NE 0 THEN BEGIN ; pb => image noire
		coul = 1 ; noir
		pal = getq (self.general, hash_general.pal)
		code = pal -> code(coul,/rvb)
		IF N_ELEMENTS(code) EQ 1 THEN BEGIN
			image = REPLICATE (code,xsize,ysize) ; image noire 2D sur un device 2D
			true = 0
		END ELSE BEGIN
			image = REPLICATE (0b,3,xsize,ysize) ; image noire 3D sur un device 3D
			image[0,*,*] = code[0]
			image[1,*,*] = code[1]
			image[2,*,*] = code[2]
			true = 1
		END
	END

	set, self.general, 'contains_image', 1
	IF libplot_get(/D_NAME) EQ 'X' OR libplot_get(/D_NAME) EQ 'WIN' THEN BEGIN

		IF self.true AND ~true THEN BEGIN ; image 2D sur un device 3D
			r = BYTE((*self.rvb).r)
			v = BYTE((*self.rvb).v)
			b = BYTE((*self.rvb).b)
			image = [[[r[image]]],[[v[image]]],[[b[image]]]]
			true = 3
		END
		tv_new, image, x1, y1, /normal, true=true, x2=x2, y2=y2

	END ELSE IF libplot_get(/D_NAME) EQ 'PRINTER' THEN BEGIN

		IF self.true AND ~true THEN BEGIN ; image 2D sur un device 3D
			r = BYTE((*self.rvb).r)
			v = BYTE((*self.rvb).v)
			b = BYTE((*self.rvb).b)
			image = [[[r[image]]],[[v[image]]],[[b[image]]]]
			true = 3
		END
		tv_new, image, x1, y1, /normal, xsize=x2-x1, ysize=y2-y1, true=true

	END ELSE BEGIN

		tv_new, image, x1, y1, /normal, xsize=x2-x1, ysize=y2-y1, true=true

	END

	IF type GE 5 AND type LE 8 THEN BEGIN
		IF !CL.libplot NE '' OR is_gdl() OR is_fdl() THEN BEGIN
			; MAP_SET ne marche pas sous GDL et FDL
		END ELSE BEGIN
			MAP_SET, latitude,longitude,rotation, advance=0, /NOERASE, AITOFF=type EQ 5, CYLIN=type EQ 6, MOLL=type EQ 7, HAMMER=type EQ 8, $
	               		XMARGIN=[1,1], YMARGIN=[1,1], /noborder, POSITION=[x1,y1,x2,y2]
		END

		IF !CL.libplot NE '' OR is_gdl() OR is_fdl() THEN BEGIN
			; MAP_GRID ne marche que sous IDL
			my_map_grid, lons=[0,45,90,135,180,225,270,315,360], lats=[-90,-45,0,45,90], COLOR=1, POSITION=[x1,y1,x2,y2] ; tracer des lignes en pointills tous les 45 deg (COLOR=1 pour noir)
		END ELSE BEGIN
			; Bugge car ne trace pas en pointill la longitude 360
			;MAP_GRID, londel=45, latdel=45, COLOR=1 ; tracer des lignes en pointills tous les 45 deg (COLOR=1 pour noir)

			; Ne bugge pas
			MAP_GRID, lons=[0,45,90,135,180,225,270,315,360], lats=[-90,-45,0,45,90], COLOR=1 ; tracer des lignes en pointills tous les 45 deg (COLOR=1 pour noir)
		END

		IF PTR_VALID(info_B) THEN BEGIN
			FOR i=0L,N_ELEMENTS(*info_B)-1 DO BEGIN
				thick = (*info_B)[i].thick
				IF !CL.libplot NE '' OR is_fdl() OR is_gdl() THEN BEGIN
					IF !CL.libplot EQ '' && is_fdl() && is_fdl(/RELEASE) GE '0.79.48' && thick GT 1 THEN thick = 1 + (thick-1)*0.5 ; sinon les caractres sont trop gras
					my_map_plot, (*info_B)[i].longitude, (*info_B)[i].latitude, psym=(*info_B)[i].psym, symsize=(*info_B)[i].size, thick=thick, color=translation[(*info_B)[i].color], position=[x1,y1,x2,y2]
				END ELSE BEGIN
					libplot_plots, (*info_B)[i].longitude, (*info_B)[i].latitude, psym=(*info_B)[i].psym, symsize=(*info_B)[i].size, thick=thick, color=translation[(*info_B)[i].color]
				END
			END
		END
		IF PTR_VALID(info_U) THEN BEGIN
			FOR i=0L,N_ELEMENTS(*info_U)-1 DO BEGIN
				IF (*info_U)[i].longitude GT -1e30 AND (*info_U)[i].latitude GT -1e30 THEN BEGIN
					thick = (*info_U)[i].thick
					IF !CL.libplot NE '' OR is_fdl() OR is_gdl() THEN BEGIN
						IF !CL.libplot EQ '' && is_fdl() && is_fdl(/RELEASE) GE '0.79.48' && thick GT 1 THEN thick = 1 + (thick-1)*0.5 ; sinon les caractres sont trop gras
						my_map_plot, (*info_U)[i].longitude, (*info_U)[i].latitude, psym=(*info_U)[i].psym, symsize=(*info_U)[i].size, thick=thick, color=translation[(*info_U)[i].color], position=[x1,y1,x2,y2]
					END ELSE BEGIN
						libplot_plots, (*info_U)[i].longitude, (*info_U)[i].latitude, psym=(*info_U)[i].psym, symsize=(*info_U)[i].size, thick=thick, color=translation[(*info_U)[i].color]
					END
				END
			END
		END
	END

	IF pb NE 0 THEN BEGIN ; pb => message blanc
		msg = [ 'Too many colors',			$
			'File not found',			$
			'Bad format',				$
			'Image too big',			$
			'Use ps2jpg',				$
			'True color',				$
			'Nbcolors must be greater than 2', 	$
			'Not on true color display'] + ' !!'
		coul = 0 ; blanc
		code = pal -> code(coul)
		libplot_xyouts, (x1+x2)/2, (y1+y2)/2, msg[pb-1], /normal, alignment=0.5, color=code
	END ELSE IF continents THEN BEGIN
		coul = 1 ; noir
		pal = getq (self.general, hash_general.pal)
		code = pal -> code(coul)
		;MAP_SET, /CYLINDRICAL, 0, 0, /CONTINENTS, COLOR=code, limit=[ymin,xmin,ymax,xmax], position=[x1,y1,x2,y2], /NOERASE
		IF !CL.libplot NE '' OR is_fdl() OR is_gdl() THEN BEGIN
			; MAP_SET ne marche que sous IDL
			my_map_continents, 0, moins180plus180 EQ 1 ? 0 : 180, xmin, xmax, ymin, ymax, hires, mlinethick, code, [x1,y1,x2,y2]
		END ELSE BEGIN
			MAP_SET, HIRES=hires, mlinethick=mlinethick, /CYLINDRICAL, 0, moins180plus180 EQ 1 ? 0 : 180, /CONTINENTS, COLOR=code, limit=[ymin,xmin,ymax,xmax], position=[x1,y1,x2,y2], /NOERASE
		END
	END

	IF y2 GT !TIME_COMMENT.y2 THEN !TIME_COMMENT.y2 = y2

END

;-------------------------------------------------------------------------------
PRO fenetre_image::remove,	$
;-------------------------------------------------------------------------------
	i	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Supprime l'image numro i.
;-------------------------------------------------------------------------------

	tmp = (*self.image)[i] ; utilisation de tmp sinon c'est trs lent en GDL
	PTR_FREE, tmp.imagedata
	PTR_FREE, tmp.produit
	PTR_FREE, tmp.trans

	p = self.image
	supprimer_tab, p,i
	self.image = p
	self.nb--

END


;-------------------------------------------------------------------------------
PRO fenetre_image::fenetre__remove_data
;-------------------------------------------------------------------------------
; Supprime toutes les donnes.
;-------------------------------------------------------------------------------

	FOR i=0L,self.nb-1 DO BEGIN
		tmp = (*self.image)[i] ; utilisation de tmp sinon c'est trs lent en GDL
		PTR_FREE, tmp.imagedata
		PTR_FREE, tmp.produit
		PTR_FREE, tmp.trans
	END
	PTR_FREE, self.image  
	self.nb = 0

	self -> fen_remove_data

END

;-------------------------------------------------------------------------------
PRO fenetre_image::cleanup
;-------------------------------------------------------------------------------
; Destructeur de la classe "fenetre_image".
;-------------------------------------------------------------------------------

	self -> fenetre__remove_data

END

;-------------------------------------------------------------------------------
PRO fenetre_image__define
;-------------------------------------------------------------------------------
; La classe "fenetre_image" hrite de "fen".
;-------------------------------------------------------------------------------

	lint_unused = { une_image,			$

		produit:	PTR_NEW(),		$
		trans:		PTR_NEW(),		$
		min:		0.,			$
		max:		0.,			$
		nb:		0L,			$
		type:		0L,			$
		az:		0.,			$
		ax:		0.,			$
		is3D:		0,			$
		constraint:	'',			$
		imagedata:	PTR_NEW(),		$
		true:		0L,			$
		x1:		0d,			$
		x2:		0d,			$
		y1:		0d,			$
		y2:		0d,			$
		contoursnb:	0L,			$
		interp:		'',			$
		continents:	0L,			$
		hires:		0,			$
		moins180plus180:0,			$
		mlinethick:	0.,			$
		xmin:		0.,			$
		xmax:		0.,			$
		ymin:		0.,			$
		ymax:		0.,			$
		blanc:		0L,			$
		longitude:	0.,			$
		latitude:	0.,			$
		rotation:	0.,			$
		info_B:		PTR_NEW(),		$	; structure
		info_U:		PTR_NEW()		$	; structure

	}

	lint_unused = { fenetre_image,			$

		INHERITS 	fen,			$
		image:		PTR_NEW(),		$
		nb:		0L			$

	}

END
