;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: fenetre_courbe__define.pro,v $, v $Revision: 1.30 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO fenetre_courbe::fenetre_courbe_ajouter,	$
;-------------------------------------------------------------------------------
	tabx,					$	; LINT_PROTOTYPE input
	taby,					$	; LINT_PROTOTYPE input
	couleur,				$	; LINT_PROTOTYPE input
	psym1,					$	; LINT_PROTOTYPE input
	psym2,					$	; LINT_PROTOTYPE input
	symsize,				$	; LINT_PROTOTYPE input
	linestyle,				$	; LINT_PROTOTYPE input
	thick,					$	; LINT_PROTOTYPE input
	xmin,					$	; LINT_PROTOTYPE input
	xmax,					$	; LINT_PROTOTYPE input
	xlog,					$	; LINT_PROTOTYPE input
	ymin,					$	; LINT_PROTOTYPE input
	ymax,					$	; LINT_PROTOTYPE input
	ylog,					$	; LINT_PROTOTYPE input
	x1,					$	; LINT_PROTOTYPE input
	x2,					$	; LINT_PROTOTYPE input
	y1,					$	; LINT_PROTOTYPE input
	y2,					$	; LINT_PROTOTYPE input
	tabt=tabt,				$	; LINT_PROTOTYPE input
	plots=plots,				$	; LINT_PROTOTYPE input
	isdata=isdata,				$	; LINT_PROTOTYPE input
	ref=ref,				$	; LINT_PROTOTYPE input
	NO_COPY=NO_COPY,			$	; LINT_PROTOTYPE input
	system=system,				$	; LINT_PROTOTYPE input
	sym=sym						; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Mmorise les paramtres d'une "courbe".
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(plots) 	EQ 0 THEN plots 	= 0
	IF N_ELEMENTS(isdata) 	EQ 0 THEN isdata 	= 0
	IF N_ELEMENTS(ref) 	EQ 0 THEN ref 		= 0
	IF N_ELEMENTS(tabt) 	EQ 0 THEN tabt 		= -1
	IF N_ELEMENTS(system) 	EQ 0 THEN system 	= 0
	IF N_ELEMENTS(sym) 	EQ 0 THEN sym 		= 0

	ind_premier = dernier_element(WHERE (tabx LT xmin))		; derniere valeur < xmin si elle existe
	IF ind_premier[0] EQ -1 THEN BEGIN
		ind_premier = (WHERE (tabx GE xmin))[0]			; sinon premire valeur >= xmin si elle existe
	END
		
	ind_dernier = (WHERE (tabx GT xmax))[0]				; premire valeur > xmax si elle existe
	IF ind_dernier[0] EQ -1 THEN BEGIN
		ind_dernier = dernier_element(WHERE (tabx LE xmax))	; sinon dernire valeur <= xmax si elle existe
	END

	IF ind_premier[0] NE -1 AND ind_dernier[0] NE -1 THEN BEGIN
		premier = tabx[ind_premier]
		dernier = tabx[ind_dernier]
		IF ~ylog THEN BEGIN
			ind1 = WHERE (tabx GE premier AND tabx LE dernier)
		END ELSE BEGIN
			ind1 = WHERE (tabx GE premier AND tabx LE dernier AND taby GT 0)
		END
	END ELSE BEGIN
		ind1 = -1
	END

	IF ind1[0] NE -1 AND ~is_string(taby) THEN BEGIN
		yminauto = MIN(taby[ind1],max=ymaxauto)
		ind = WHERE (taby[ind1] EQ yminauto)
		xminauto = tabx[ind1[ind[0]]]
		nbxminauto = N_ELEMENTS(ind)
		ind = WHERE (taby[ind1] EQ ymaxauto)
		xmaxauto = tabx[ind1[ind[0]]]
		nbxmaxauto = N_ELEMENTS(ind)
		ymoyauto = TOTAL(DOUBLE(taby[ind1])) / N_ELEMENTS(ind1) ; sinon sur MAVEN_NGIMS % Program caused arithmetic error: Floating overflow
	END ELSE BEGIN
		yminauto   = !VALUES.D_INFINITY
		xminauto   = !VALUES.D_INFINITY
		nbxminauto = 0
		ymaxauto   = !VALUES.D_INFINITY
		xmaxauto   = !VALUES.D_INFINITY
		nbxmaxauto = 0
		ymoyauto   = !VALUES.D_INFINITY
	END

	element = { une_courbe,					$

		tabt:		PTR_NEW(tabt,NO_COPY=NO_COPY),	$
		tabx:		PTR_NEW(tabx,NO_COPY=NO_COPY),	$
		taby:		PTR_NEW(taby,NO_COPY=NO_COPY),	$
		couleur:	couleur,			$
		psym1:		psym1,				$
		psym2:		psym2,				$
		symsize:	symsize,			$
		linestyle:	linestyle,			$
		thick:		thick,				$
		xmin:		xmin,				$
		xmax:		xmax,				$
		xlog:		xlog,				$
		ymin:		ymin,				$
		ymax:		ymax,				$
		ylog:		ylog,				$
		x1:		x1,				$
		x2:		x2,				$
		y1:		y1,				$
		y2:		y2,				$
		plots:		plots,				$
		xminauto:	xminauto,			$
		nbxminauto:	nbxminauto,			$
		yminauto:	yminauto,			$
		xmaxauto:	xmaxauto,			$
		nbxmaxauto:	nbxmaxauto,			$
		ymaxauto:	ymaxauto,			$
		ymoyauto:	ymoyauto,			$
		isdata:		isdata,				$
		ref:		ref,				$
		system:		system,				$
		sym:		PTR_NEW(sym)			$

	}
	
	nb = self.nb
	tab = self.courbe
	ajouter_tab1, tab, element, nb
	self.courbe = tab
	self.nb = nb

END

;-------------------------------------------------------------------------------
PRO fenetre_courbe::get_courbe,	$
;-------------------------------------------------------------------------------
	i,			$	; LINT_PROTOTYPE input
	xmin,			$	; LINT_PROTOTYPE output
	xminauto,		$	; LINT_PROTOTYPE output
	nbxminauto,		$	; LINT_PROTOTYPE output
	yminauto,		$	; LINT_PROTOTYPE output
	xmax,			$	; LINT_PROTOTYPE output
	xmaxauto,		$	; LINT_PROTOTYPE output
	nbxmaxauto,		$	; LINT_PROTOTYPE output
	ymaxauto,		$	; LINT_PROTOTYPE output
	isdata,			$	; LINT_PROTOTYPE output
	ymoyauto=ymoyauto		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne certaines valeurs concernant la courbe numro "i".
;-------------------------------------------------------------------------------

	tmp = (*self.courbe)[i] ; utilisation de tmp sinon c'est trs lent en GDL
	ref = tmp.ref*86400*1000

	xmin       = ref + 1d-6*tmp.xmin    	; tmp.xmin est en nanosec
	xminauto   = ref + 1d-6*tmp.xminauto	; tmp.xminauto est en nanosec
	nbxminauto = tmp.nbxminauto
	yminauto   = tmp.yminauto

	xmax       = ref + 1d-6*tmp.xmax    	; tmp.xmax est en nanosec
	xmaxauto   = ref + 1d-6*tmp.xmaxauto	; tmp.xmaxauto est en nanosec
	nbxmaxauto = tmp.nbxmaxauto
	ymaxauto   = tmp.ymaxauto

	isdata   = tmp.isdata

	IF N_ELEMENTS(ymoyauto) NE 0 THEN ymoyauto = tmp.ymoyauto

END

;-------------------------------------------------------------------------------
PRO fenetre_courbe::getyminymax,	$
;-------------------------------------------------------------------------------
	no,				$	; LINT_PROTOTYPE input
	ymin,				$	; LINT_PROTOTYPE output
	ymax					; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne le min et le max de la courbe numro "no".
;-------------------------------------------------------------------------------

	ymin = (*self.courbe)[no].ymin
	ymax = (*self.courbe)[no].ymax

END

;-------------------------------------------------------------------------------
PRO fenetre_courbe::setyminymax,	$
;-------------------------------------------------------------------------------
	no,				$	; LINT_PROTOTYPE input
	ymin,				$	; LINT_PROTOTYPE input
	ymax					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Positionne le min et le max de la courbe numro "no".
;-------------------------------------------------------------------------------

	(*self.courbe)[no].ymin = ymin
	(*self.courbe)[no].ymax = ymax

END

;-------------------------------------------------------------------------------
PRO fenetre_courbe::fvoir,	$
;-------------------------------------------------------------------------------
	i	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche la "courbe" numro "i".
;-------------------------------------------------------------------------------

	tmp 		= (*self.courbe)[i] ; utilisation de tmp sinon c'est trs lent en GDL
	tabt		= *tmp.tabt
	tabx		= *tmp.tabx
	taby		= *tmp.taby
	couleur		= tmp.couleur
	psym1		= tmp.psym1
	psym2		= tmp.psym2
	symsize		= tmp.symsize
	linestyle	= tmp.linestyle
	thick		= tmp.thick
	xmin		= tmp.xmin
	xmax		= tmp.xmax
	xlog		= tmp.xlog
	ymin		= tmp.ymin
	ymax		= tmp.ymax
	ylog		= tmp.ylog
	x1		= self -> xn(tmp.x1)
	x2		= self -> xn(tmp.x2)
	y1		= self -> yn(tmp.y1)
	y2		= self -> yn(tmp.y2)
	plots		= tmp.plots
	system		= tmp.system
	sym		= *tmp.sym
	rapps           = libplot_get(/D_NAME) EQ 'PS' ? get(self.general,'postscript_charsize_reduction') : 1.0

	IF ~self.true THEN BEGIN
		translation = *self.translation
		couleur     = translation[couleur]
	END ELSE BEGIN
		couleur = rvb2no ((*self.rvb)[couleur].r, (*self.rvb)[couleur].v, (*self.rvb)[couleur].b)
	END

	psym = N_ELEMENTS(tabx) EQ 1 ? psym1 : psym2

	IF psym EQ 8 THEN BEGIN
		tmp = N_ELEMENTS(sym)
		tmp1 = (tmp-1)/2
		libplot_usersym, sym[INDGEN(tmp1)], sym[tmp1+INDGEN(tmp1)], FILL=sym[tmp-1] EQ 1
	END

	IF !CL.libplot EQ '' && is_fdl() && is_fdl(/RELEASE) LE '0.79.47' && psym NE 8 THEN symsize *= 2.5 ; sinon les symboles sont trop petits
	IF !CL.libplot EQ '' && is_fdl() && is_fdl(/RELEASE) GE '0.79.48' AND thick GT 1 THEN thick = 1 + 0.5*(thick-1) ; sinon les caractres sont trop gras

	IF tabt[0] NE -1 THEN BEGIN ; vecteurs

		nbx = libplot_get(/D_X_VSIZE)*(x2-x1)
		nby = libplot_get(/D_Y_VSIZE)*(y2-y1)

		FOR i=0L,N_ELEMENTS(tabt)-1 DO BEGIN
			pt1x = tabt[i]
			pt1y = 0.5 * (ymin + ymax)
			pt2y = pt1y + taby[i]
			pt2x = pt1x + tabx[i]*nby/FLOAT(ymax-ymin)*(xmax-xmin)/nbx

			set, self.general, 'contains_courbe', 1
			libplot_plot, [pt1x,pt2x], [pt1y,pt2y], xlog=xlog, ylog=ylog, psym=psym, symsize=symsize,	$
				color=couleur, linestyle=linestyle, thick=thick,					$
				xrange=[xmin,xmax], yrange=[ymin, ymax],						$
				position=[x1,y1,x2,y2], /NOERASE, xstyle=5, ystyle=5

			v = [-tabx[i],-taby[i],0.0]
			theta = ATAN(v[1],v[0])
			R = module_v1(v)*0.1

			pt3x = pt2x + R*COS(theta+30.0*!DTOR)*nby/FLOAT(ymax-ymin)*(xmax-xmin)/nbx
			pt3y = pt2y + R*SIN(theta+30.0*!DTOR)
			pt4x = pt2x + R*COS(theta-30.0*!DTOR)*nby/FLOAT(ymax-ymin)*(xmax-xmin)/nbx
			pt4y = pt2y + R*SIN(theta-30.0*!DTOR)
			libplot_plot, [pt3x,pt2x,pt4x], [pt3y,pt2y,pt4y], xlog=xlog, ylog=ylog, psym=psym, symsize=symsize,	$
				color=couleur, linestyle=linestyle, thick=thick,						$
				xrange=[xmin,xmax], yrange=[ymin, ymax],							$
				position=[x1,y1,x2,y2], /NOERASE, xstyle=5, ystyle=5
		END

	END ELSE IF plots THEN BEGIN

		FOR i=0L,N_ELEMENTS(tabx)-1 DO tabx[i] = self -> xn(tabx[i])
		FOR i=0L,N_ELEMENTS(tabx)-1 DO taby[i] = self -> yn(taby[i])
		set, self.general, 'contains_courbe', 1
		libplot_plots, tabx, taby, psym=psym, symsize=symsize, color=couleur, linestyle=linestyle, thick=thick, /normal

	END ELSE BEGIN

		IF is_string(taby) THEN BEGIN

			ss = get_string_size (libplot_get(/D_X_SIZE), libplot_get(/D_Y_SIZE), libplot_get(/D_NAME) EQ 'PS', get(self.general,'pal'))

			set, self.general, 'contains_courbe', 1
			FOR i=0L,N_ELEMENTS(tabx)-1 DO BEGIN

				; alignment=0.5 est la pour aligner le texte en vertical
				; ss*symsize*rapps*0.5 est la pour centrer le texte en horizontal

				IF x1+(x2-x1)*(tabx[i]-xmin)/(xmax-xmin)+ss*symsize*rapps*0.5 LT x1 THEN CONTINUE	; texte trop  gauche
				IF x1+(x2-x1)*(tabx[i]-xmin)/(xmax-xmin)+ss*symsize*rapps*0.5 GT x2 THEN CONTINUE	; texte trop  droite
				libplot_xyouts, x1+(x2-x1)*(tabx[i]-xmin)/(xmax-xmin)+ss*symsize*rapps*0.5, y1+(y2-y1)*0.5, taby[i], /normal, color=couleur, $
					orientation=90, charthick=thick, charsize=symsize*rapps, alignment=0.5

			END

		END ELSE BEGIN

			; On ne comptabilise pas le trace horizontal en un Y donne
			IF ~system AND tabx[0] LE xmax AND tabx[N_ELEMENTS(tabx)-1] GE xmin THEN set, self.general, 'contains_courbe', 1

			; On ne considere que les traces avec des donnes visibles dans [xmin,xmax]
			mini = MIN(tabx, MAX=maxi)
			IF mini GT xmax OR maxi LT xmin THEN BEGIN
				; courbe invisible
			END ELSE BEGIN
				IF !CL.libplot EQ '' && is_fdl() THEN BEGIN
					;					relier les points	indiquer les symboles
					; pysm == 0: 	"connected points"	1 			0
					; psym <  0: 	"connected symbols"	1			1
					; psym >  0:	"only symbols'		0			1

					
					IF psym LE 0 THEN BEGIN ; relier les points
						code = my_clip (xlog EQ 1 ? ALOG10(tabx) : tabx, ylog EQ 1 ? ALOG10(taby) : taby,	$
								xlog EQ 1 ? ALOG10(xmin) : xmin, xlog EQ 1 ? ALOG10(xmax) : xmax,	$
								ylog EQ 1 ? ALOG10(ymin) : ymin, ylog EQ 1 ? ALOG10(ymax) : ymax,	$
								clipx, clipy)
						IF code EQ 1 THEN BEGIN
							; psym=0 pour relier les points, sans indiquer de symboles
							libplot_plot, xlog ? 10d ^ clipx : clipx, ylog EQ 1 ? 10d ^ clipy : clipy,	$
								xlog=xlog, ylog=ylog, psym=0, symsize=symsize,				$
								color=couleur, linestyle=linestyle, thick=thick,			$
								xrange=[xmin,xmax], yrange=[ymin, ymax],				$
								position=[x1,y1,x2,y2], /NOERASE, xstyle=5, ystyle=5
						END
					END
					IF psym NE 0 THEN BEGIN ; indiquer les symboles
						; pas besoin de CLIPPING: afficher uniquement les points visibles
						ind = WHERE (tabx GE LONG64(xmin) AND tabx LE LONG64(xmax) AND taby GE ymin AND taby LE ymax)
						IF ind[0] NE -1 THEN BEGIN
							; psym=ABS(psym) pour ne pas relier les points mais indiquer les symboles
							libplot_plot, tabx[ind], taby[ind], xlog=xlog, ylog=ylog, psym=ABS(psym), symsize=symsize,	$
								color=couleur, linestyle=linestyle, thick=thick,					$
								xrange=[xmin,xmax], yrange=[ymin,ymax],							$
								position=[x1,y1,x2,y2], /NOERASE, xstyle=5, ystyle=5
						END
					END
				END ELSE BEGIN
					libplot_plot, tabx, taby, xlog=xlog, ylog=ylog, psym=psym, symsize=symsize,	$
							color=couleur, linestyle=linestyle, thick=thick,		$
							xrange=[xmin,xmax], yrange=[ymin,ymax],				$
							position=[x1,y1,x2,y2], /NOERASE, xstyle=5, ystyle=5
				END
			END

		END

	END

	IF y2 GT !TIME_COMMENT.y2 THEN !TIME_COMMENT.y2 = y2

END

;-------------------------------------------------------------------------------
PRO fenetre_courbe::fenetre__remove_data
;-------------------------------------------------------------------------------
; Supprime toutes les donnes mmorises.
;-------------------------------------------------------------------------------

	FOR i=0L,self.nb-1 DO BEGIN
		tmp = (*self.courbe)[i] ; utilisation de tmp sinon c'est trs lent en GDL
		PTR_FREE, tmp.tabt
		PTR_FREE, tmp.tabx
		PTR_FREE, tmp.taby
		PTR_FREE, tmp.sym
	END
	PTR_FREE, self.courbe 
	self.nb = 0

	self -> fen_remove_data

END

;-------------------------------------------------------------------------------
PRO fenetre_courbe::cleanup
;-------------------------------------------------------------------------------
; Destructeur de la classe "fenetre_courbe".
;-------------------------------------------------------------------------------

	self -> fenetre__remove_data

END

;-------------------------------------------------------------------------------
PRO fenetre_courbe__define
;-------------------------------------------------------------------------------
; La classe "fenetre_courbe" hrite de "fen".
;-------------------------------------------------------------------------------

	lint_unused = { une_courbe,		$

		tabt:		PTR_NEW(),	$
		tabx:		PTR_NEW(),	$
		taby:		PTR_NEW(),	$
		couleur:	0,		$
		psym1:		0,		$
		psym2:		0,		$
		symsize:	0d,		$
		linestyle:	0,		$
		thick:		0.,		$
		xmin:		0d,		$
		xmax:		0d,		$
		xlog:		0,		$
		ymin:		0d,		$
		ymax:		0d,		$
		ylog:		0,		$
		x1:		0d,		$
		x2:		0d,		$
		y1:		0d,		$
		y2:		0d,		$
		plots:		0,		$
		xminauto:	0d,		$
		nbxminauto:	0L,		$
		yminauto:	0d,		$
		xmaxauto:	0d,		$
		nbxmaxauto:	0L,		$
		ymaxauto:	0d,		$
		ymoyauto:	0d,		$
		isdata:		0,		$
		ref:		0d,		$
		system:		0, 		$
		sym:		PTR_NEW() 	$

	}

	lint_unused = { fenetre_courbe,		$

		INHERITS	fen,		$
		courbe:		PTR_NEW(),	$
		nb:		0L		$

	}

END
