;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: fenetre_axey__define.pro,v $, v $Revision: 1.18 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO fenetre_axey::fenetre_axey_ajouter,	$
;-------------------------------------------------------------------------------
	xmin,				$	; LINT_PROTOTYPE input
	xmax,				$	; LINT_PROTOTYPE input
	ymin,				$	; LINT_PROTOTYPE input
	ymax,				$	; LINT_PROTOTYPE input
	x0,				$	; LINT_PROTOTYPE input
	y0,				$	; LINT_PROTOTYPE input
	x1,				$	; LINT_PROTOTYPE input
	x2,				$	; LINT_PROTOTYPE input
	y1,				$	; LINT_PROTOTYPE input
	y2,				$	; LINT_PROTOTYPE input
	titre,				$	; LINT_PROTOTYPE input
	libelle,			$	; LINT_PROTOTYPE input
	angle,				$	; LINT_PROTOTYPE input
	ticklen,			$	; LINT_PROTOTYPE input
	log,				$	; LINT_PROTOTYPE input
	ytickv,				$	; LINT_PROTOTYPE input
	yticks,				$	; LINT_PROTOTYPE input
	yminor,				$	; LINT_PROTOTYPE input
	cote,				$	; LINT_PROTOTYPE input
	ytickname,			$	; LINT_PROTOTYPE input
	couleur,			$	; LINT_PROTOTYPE input
	charsize,			$	; LINT_PROTOTYPE input
	ythick,				$	; LINT_PROTOTYPE input
	ytickformat,			$	; LINT_PROTOTYPE input
	yalignment,			$	; LINT_PROTOTYPE input
	nopanel=nopanel				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Mmorise les paramtres d'un "axey".
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(nopanel)	EQ 0 THEN nopanel  = ''

	element = { un_axey, 				$

		xmin:		xmin, 			$
		xmax:		xmax, 			$
		ymin:		ymin, 			$
		ymax:		ymax, 			$
		x0:		x0, 			$
		y0:		y0, 			$
		x1:		x1, 			$
		x2:		x2,			$
		y1:		y1,			$
		y2:		y2,			$
		titre:		titre,			$
		angle:		angle,			$
		ticklen:	ticklen,		$
		log:		log,			$
		ytickv:		PTR_NEW(ytickv),	$
		yticks:		yticks,			$
		yminor:		yminor,			$
		cote:		cote,			$
		ytickname:	PTR_NEW(ytickname),	$
		couleur:	couleur, 		$
		charsize:	charsize, 		$
		ythick:		ythick, 		$
		ytickformat:	ytickformat, 		$
		yalignment:	yalignment, 		$
		libelle:	libelle, 		$
		nopanel:        nopanel 		$

	}

	nb = self.nb
	tab = self.axey
	ajouter_tab1, tab, element, nb
	self.axey = tab
	self.nb = nb

END

;-------------------------------------------------------------------------------
PRO fenetre_axey::getyminymax,	$
;-------------------------------------------------------------------------------
	no,	$	; LINT_PROTOTYPE input
	ymin,	$	; LINT_PROTOTYPE output
	ymax		; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne le min et le max de l'axe numro "no"
;-------------------------------------------------------------------------------

	ymin = (*self.axey)[no].ymin
	ymax = (*self.axey)[no].ymax

END

;-------------------------------------------------------------------------------
PRO fenetre_axey::setyminymax,	$
;-------------------------------------------------------------------------------
	no,	$	; LINT_PROTOTYPE input
	ymin,	$	; LINT_PROTOTYPE input
	ymax		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Positionne le min et le max de l'axe numro "no"
;-------------------------------------------------------------------------------

	(*self.axey)[no].ymin = ymin
	(*self.axey)[no].ymax = ymax

END

;-------------------------------------------------------------------------------
PRO fenetre_axey::fvoir,	$
;-------------------------------------------------------------------------------
	i	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche l'"axey" numro i.
;-------------------------------------------------------------------------------

	tmp		= (*self.axey)[i] ; utilisation de tmp sinon c'est trs lent en GDL
	xmin		= tmp.xmin
	xmax		= tmp.xmax
	ymin		= tmp.ymin
	ymax		= tmp.ymax
	x0		= self -> xn(tmp.x0)
	y0		= self -> yn(tmp.y0)
	x1		= self -> xn(tmp.x1)
	x2		= self -> xn(tmp.x2)
	y1		= self -> yn(tmp.y1)
	y2		= self -> yn(tmp.y2)
	titre		= tmp.titre
	angle		= tmp.angle
	ticklen		= tmp.ticklen
	log		= tmp.log
	ytickv		= *tmp.ytickv
	yticks		= tmp.yticks
	yminor		= tmp.yminor
	cote		= tmp.cote
	ytickname	= *tmp.ytickname
	couleur		= tmp.couleur
	charsize	= tmp.charsize
	ythick		= tmp.ythick
	ytickformat	= tmp.ytickformat
	yalignment	= tmp.yalignment
	libelle		= tmp.libelle
	nopanel		= tmp.nopanel
	rapps           = libplot_get(/D_NAME) EQ 'PS' ? get(self.general,'postscript_charsize_reduction') : 1.0

	IF !CL.libplot EQ '' && is_fdl() && is_fdl(/RELEASE) GE '0.79.48' AND ythick GT 1 THEN ythick = 1 + (ythick-1)*0.5 ; sinon les caractres sont trop gras

	IF !CL.libplot EQ '' && is_gdl() THEN ticklen *= 0.25 ; sinon les valeurs s'crivent sur les traits des graduations de l'axe

	IF ~self.true THEN BEGIN
		translation = *self.translation
		couleur     = translation[couleur]
	END ELSE BEGIN
		couleur = rvb2no ((*self.rvb)[couleur].r, (*self.rvb)[couleur].v, (*self.rvb)[couleur].b)
	END

	IF !CL.libplot EQ '' && is_gdl() && (angle EQ 0 OR angle EQ 90) THEN BEGIN
		ss = get_string_size (get(self.general,'xsize'),get(self.general,'ysize'),get(self.general,'batch'),get(self.general,'pal'))
		; sparer par '!C' car gdl ne gre pas ce symbole qui signifie retour  la ligne
		titre1 = titre
		remplacer, titre1, '!C', STRING(1b)
		titres = STRSPLIT (titre1, STRING(1b), /EXTRACT) ; STRPSLIT ne sait sparer que par un seul caractre
		FOR i=0L,N_ELEMENTS(titres)-1 DO BEGIN
			IF angle EQ 0 THEN BEGIN
				; 2*ss car 1*ss n'est pas suffisant ...
				libplot_xyouts, x0, y0-i*2*ss, titres[i], /normal, orientation=angle, alignment=yalignment, $
					color=couleur, charsize=charsize*rapps, charthick=ythick
			END ELSE BEGIN
				; 2*ss car 1*ss n'est pas suffisant ...
				libplot_xyouts, x0+i*2*ss, y0, titres[i], /normal, orientation=angle, alignment=yalignment, $
					color=couleur, charsize=charsize*rapps, charthick=ythick
			END
		END
	END ELSE BEGIN
		libplot_xyouts, x0, y0, titre, /normal, orientation=angle, alignment=yalignment, $
			color=couleur, charsize=charsize*rapps, charthick=ythick
	END

	IF cote EQ 3 THEN BEGIN
		; correction bug 20180604
		IF N_ELEMENTS(ytickv) GE 2 THEN BEGIN
			ind = WHERE (ytickv GE ymin AND ytickv LE ymax)
			IF ind[0] NE -1 THEN BEGIN
				ytickv = ytickv[ind]
				yticks = N_ELEMENTS(ytickv)-1
			END ELSE BEGIN
				ytickv = 0
				yticks = 0
			END
			IF N_ELEMENTS(ytickname) GE 2 THEN ytickname = ind[0] NE -1 ? ytickname[ind] : 0
		
		END
		IF (is_fdl() OR is_gdl()) && N_ELEMENTS(ytickv) GE 2 THEN BEGIN; && N_ELEMENTS(ytickname) GE 1 && ytickname[0] NE '' THEN BEGIN
			; ne marche pas comme il faut quand on spcifie par exemple ytickv=[0,1] et ytickname=['OFF','ON'] => rien ne s'affiche
			libplot_plots, [x1,x1], [y1,y2], color=couleur, /normal ; ligne verticale en x1
			libplot_plots, [x2,x2], [y1,y2], color=couleur, /normal ; ligne verticale en x2
			ss = !CL.libplot EQ '' ? get_string_size(0,0,1,0) : 0
			FOR i=0L,N_ELEMENTS(ytickv)-1 DO BEGIN
				val = (i LT N_ELEMENTS(ytickname)) && (ytickname[i] NE '') ? ytickname[i] : val_to_str(ytickv[i],/opt)
				libplot_xyouts, x1, y1+(ytickv[i]-ymin)/(ymax-ymin)*(y2-y1)-ss*0.5, val + ' -',	/normal, color=couleur, alignment=1, charsize=charsize*rapps
				libplot_xyouts, x2, y1+(ytickv[i]-ymin)/(ymax-ymin)*(y2-y1)-ss*0.5, '-',	/normal, color=couleur, alignment=0, charsize=charsize*rapps
			END
		END ELSE BEGIN
			; axe Y  gauche et  droite
			libplot_plot, ylog=log, [xmin,xmax], [ymin,ymax], position=[x1,y1,x2,y2],	$
				/normal, /nodata,							$
				/noerase, xstyle=5, ystyle=1,						$
				Yticklen=ticklen,							$
				YTickv=ytickv,								$
				YtickS=yticks,								$
				Ytickname=ytickname,							$
				Yminor=yminor,								$
				Charsize=charsize*rapps,						$
				Color=couleur,								$
				Ythick=ythick,								$
				Charthick=ythick,							$
				Ytickformat=ytickformat
		END
	END ELSE BEGIN
		libplot_plot, ylog=log, [xmin,xmax], [ymin,ymax], position=[x1,y1,x2,y2], /normal, /nodata, /noerase, xstyle=5, ystyle=5
		IF (is_fdl() OR is_gdl()) && N_ELEMENTS(ytickv) GE 2 THEN BEGIN ; && N_ELEMENTS(ytickname) GE 1 && ytickname[0] NE '' THEN BEGIN
			; ne marche pas comme il faut quand on spcifie par exemple ytickv=[0,1] et ytickname=['OFF','ON'] => rien ne s'affiche
			IF cote EQ 1 THEN BEGIN
				libplot_plots, [x1,x1], [y1,y2], color=couleur, /normal ; ligne verticale en x1
			END ELSE BEGIN
				libplot_plots, [x2,x2], [y1,y2], color=couleur, /normal ; ligne verticale en x2
			END
			ss = !CL.libplot EQ '' ? get_string_size(0,0,1,0) : 0
			FOR i=0L,N_ELEMENTS(ytickv)-1 DO BEGIN
				val = (i LT N_ELEMENTS(ytickname)) && (ytickname[i] NE '') ? ytickname[i] : val_to_str(ytickv[i],/opt)
				IF cote EQ 1 THEN BEGIN
					libplot_xyouts, x1, y1+(ytickv[i]-ymin)/(ymax-ymin)*(y2-y1)-ss*0.5, val + ' -',	/normal, color=couleur, alignment=1, charsize=charsize*rapps
				END ELSE BEGIN
					libplot_xyouts, x2, y1+(ytickv[i]-ymin)/(ymax-ymin)*(y2-y1)-ss*0.5, '- ' + val,	/normal, color=couleur, alignment=0, charsize=charsize*rapps
				END
			END
		END ELSE BEGIN
			; arrive uniquement quand Yright ne vaut pas "Like yleft"
			yaxis = cote EQ 1 ? 0 : 1
			x = cote EQ 1 ? xmin : xmax
			libplot_axis, x, yaxis=yaxis, ylog=log, yticklen=ticklen, 			$
				Ytickv=ytickv, Yticks=yticks, Yminor=yminor, Ytickname=ytickname, 	$
				color=couleur, charsize=charsize*rapps, ythick=ythick,			$
				Ytickformat=ytickformat, Charthick=ythick, ystyle=1
		END
	END

	IF libelle NE '' THEN BEGIN

		; afficher le libell en haut	
		IF !CL.libplot EQ '' && is_gdl() THEN BEGIN
			ss = get_string_size (get(self.general,'xsize'),get(self.general,'ysize'),get(self.general,'batch'),get(self.general,'pal'))
			; sparer par '!C' car gdl ne gre pas ce symbole qui signifie retour  la ligne
			libelle1 = libelle
			remplacer, libelle1, '!C', STRING(1b)
			libelles = STRSPLIT (libelle1, STRING(1b), /EXTRACT) ; STRPSLIT ne sait sparer que par un seul caractre
			FOR i=0L,N_ELEMENTS(libelles)-1 DO BEGIN
				; 2*ss car 1*ss n'est pas suffisant ...
				libplot_xyouts, (x2+x1)*0.5, y2-i*2*ss, libelles[i], /normal, orientation=0, alignment=0.5, $
					color=couleur, charsize=charsize*rapps, charthick=ythick
			END
		END ELSE BEGIN
			libplot_xyouts, (x2+x1)*0.5, y2, libelle, /normal, orientation=0, alignment=0.5, $
				color=couleur, charsize=charsize*rapps, charthick=ythick
		END

		; afficher le numro de panneau  gauche
		charthick = 1.5
		IF !CL.libplot EQ '' && is_fdl() && is_fdl(/RELEASE) GE '0.79.48' AND charthick GT 1 THEN charthick = 1 + (charthick-1)*0.5 ; sinon les caractres sont trop gras
		libplot_xyouts, x0 + 0.3*(x1-x0), (y1+y2)*0.5, nopanel, /normal, orientation=0, alignment=0.5, $
			color=couleur, charsize=1.5*rapps, charthick=charthick

	END

END

;-------------------------------------------------------------------------------
PRO fenetre_axey::fenetre__remove_data
;-------------------------------------------------------------------------------
; Supprime toutes les donnes mmorises.
;-------------------------------------------------------------------------------

	FOR i=0L,self.nb-1 DO BEGIN
		tmp = (*self.axey)[i] ; utilisation de tmp sinon c'est trs lent en GDL
		PTR_FREE, tmp.ytickv
		PTR_FREE, tmp.ytickname
	END
	PTR_FREE, self.axey  
	self.nb = 0

	self -> fen_remove_data

END

;-------------------------------------------------------------------------------
PRO fenetre_axey::cleanup
;-------------------------------------------------------------------------------
; Destructeur de la classe "fenetre_axey".
;-------------------------------------------------------------------------------

	self -> fenetre__remove_data

END

;-------------------------------------------------------------------------------
PRO fenetre_axey__define
;-------------------------------------------------------------------------------
; La classe "fenetre_axey" hrite de "fen".
;-------------------------------------------------------------------------------

	lint_unused = { un_axey,		$

		xmin:		0d, 		$
		xmax:		0d, 		$
		ymin:		0d, 		$
		ymax:		0d, 		$
		x0:		0d, 		$
		y0:		0d, 		$
		x1:		0d, 		$
		x2:		0d, 		$
		y1:		0d, 		$
		y2:		0d, 		$
		titre:		'', 		$
		angle:		0d, 		$
		ticklen:	0d, 		$
		log:		0, 		$
		ytickv:		PTR_NEW(),	$
		yticks:		0, 		$
		yminor:		0, 		$
		cote:		0, 		$
		ytickname:	PTR_NEW(),	$
		couleur:	0, 		$
		charsize:	0d, 		$
		ythick:		0d, 		$
		ytickformat:	'', 		$
		yalignment:	0., 		$
		libelle:	'', 		$
		nopanel:	'' 		$

	}

	lint_unused = { fenetre_axey,		$

		INHERITS	fen, 		$
		axey:		PTR_NEW(), 	$
		nb:		0 		$

	}

END
