;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: fenetre_axex__define.pro,v $, v $Revision: 1.9 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO fenetre_axex::fenetre_axex_ajouter,	$
;-------------------------------------------------------------------------------
	xmin,				$	; LINT_PROTOTYPE input
	xmax,				$	; LINT_PROTOTYPE input
	ymin,				$	; LINT_PROTOTYPE input
	ymax,				$	; LINT_PROTOTYPE input
	x1,				$	; LINT_PROTOTYPE input
	x2,				$	; LINT_PROTOTYPE input
	y1,				$	; LINT_PROTOTYPE input
	y2,				$	; LINT_PROTOTYPE input
	titre,				$	; LINT_PROTOTYPE input
	ticklen,			$	; LINT_PROTOTYPE input
	log,				$	; LINT_PROTOTYPE input
	xtickv,				$	; LINT_PROTOTYPE input
	xticks,				$	; LINT_PROTOTYPE input
	xminor,				$	; LINT_PROTOTYPE input
	xtickname,			$	; LINT_PROTOTYPE input
	couleur,			$	; LINT_PROTOTYPE input
	charsize,			$	; LINT_PROTOTYPE input
	xthick,				$	; LINT_PROTOTYPE input
	xtickformat				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Mmorise les paramtres d'un "axex".
;-------------------------------------------------------------------------------

	element = { un_axex,				$

		xmin:		xmin,			$
		xmax:		xmax,			$
		ymin:		ymin,			$
		ymax:		ymax,			$
		x1:		x1,			$ 
		x2:		x2,			$ 
		y1:		y1,			$ 
		y2:		y2,			$ 
		titre:		titre,			$
		ticklen:	ticklen,		$
		log:		log,			$
		xtickv:		PTR_NEW(xtickv),	$
		xticks:		xticks,			$
		xminor:		xminor,			$
		xtickname:	PTR_NEW(xtickname),	$
		couleur:	couleur,		$
		charsize:	charsize,		$
		xthick:		xthick,			$
		xtickformat:	xtickformat		$

	}

	nb = self.nb
	tab = self.axex
	ajouter_tab1, tab, element, nb
	self.axex = tab
	self.nb = nb

END

;-------------------------------------------------------------------------------
PRO fenetre_axex::fvoir,	$
;-------------------------------------------------------------------------------
	i	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche l'"axex" numro i.
;-------------------------------------------------------------------------------

	tmp		= (*self.axex)[i] ; utilisation de tmp sinon c'est trs lent en GDL
	xmin		= tmp.xmin
	xmax		= tmp.xmax
	ymin		= tmp.ymin
	ymax		= tmp.ymax
	x1		= self -> xn(tmp.x1)
	x2		= self -> xn(tmp.x2)
	y1		= self -> yn(tmp.y1)
	y2		= self -> yn(tmp.y2)
	titre		= tmp.titre
	ticklen		= tmp.ticklen
	log		= tmp.log
	xtickv		= *tmp.xtickv
	xticks		= tmp.xticks
	xminor		= tmp.xminor
	xtickname	= *tmp.xtickname
	couleur		= tmp.couleur 
	charsize	= tmp.charsize
	xthick		= tmp.xthick
	xtickformat	= tmp.xtickformat
	rapps		= libplot_get(/D_NAME) EQ 'PS' ? get(self.general,'postscript_charsize_reduction') : 1.0

	IF !CL.libplot EQ '' && is_fdl() && is_fdl(/RELEASE) GE '0.79.48' AND xthick GT 1 THEN xthick = 1 + 0.5*(xthick-1) ; sinon les caractres sont trop gras

	IF ~self.true THEN BEGIN
		translation = *self.translation
		couleur     = translation[couleur]
	END ELSE BEGIN
		couleur = rvb2no ((*self.rvb)[couleur].r, (*self.rvb)[couleur].v, (*self.rvb)[couleur].b)
	END

	IF charsize EQ 0 THEN charsize = 1E-10
	libplot_plot, xlog=log, [xmin,xmax], [ymin,ymax], position=[x1,y1,x2,y2],	$
		/normal, /nodata,							$
		/noerase, xstyle=1, ystyle=5,						$
		xticklen=ticklen/(y2-y1)/100,						$
		xtickv=xtickv,								$
		xticks=xticks,								$
		xtickname=xtickname,							$
		xminor=xminor,								$
		charsize=charsize*rapps,						$
		color=couleur,								$
		xthick=xthick,								$
		charthick=xthick,							$
		xtickformat=xtickformat

	; essayer de positionner le titre comme le fait IDL dans PLOT, xtitle=titre
	; pas vident de savoir ce que fait IDL

	ss = get_string_size(get(self.general,'xsize'),get(self.general,'ysize'),get(self.general,'batch'),get(self.general,'pal'))
	; Un caractre occupe en Y environ 2.5*ss*charsize*rapps

	x = (x1+x2)*0.5

	y = y1
	y -= (y2-y1)*0.05				; laisser 5%
	
	; Si xtickname contient au moins 2 valeurs et qu'elles valent toutes ' ' alors aucun caractre ne sera affich
	ind = WHERE (xtickname EQ ' ')
	IF N_ELEMENTS(ind) GE 2 THEN BEGIN
		; utilis quand xval vaut 'No' (timeseries et count3d)
		; utilis pour tous les panneaux sauf le dernier pour ne pas afficher de valeurs numriques (count3d)
	END ELSE BEGIN
		y -= 5.0*ss*charsize*rapps		; taille des caractres utiliss pour graduer l'axe
	END
	y -= ticklen GT 0 ? 0 : 2.5*ABS(ticklen/100)	; taille des graduations

	; il ne faut pas que y soit hors limite
	ymin = self -> yn (0) + 1.25*ss*charsize*rapps
	IF y LT ymin THEN y = ymin

	libplot_xyouts, x, y, titre, /normal, color=couleur, alignment=0.5, charsize=charsize*rapps

END

;-------------------------------------------------------------------------------
PRO fenetre_axex::fenetre__remove_data
;-------------------------------------------------------------------------------
; Supprime toutes les donnes mmorises.
;-------------------------------------------------------------------------------

	FOR i=0L,self.nb-1 DO BEGIN
		tmp = (*self.axex)[i] ; utilisation de tmp sinon c'est trs lent en GDL
		PTR_FREE, tmp.xtickv
		PTR_FREE, tmp.xtickname
	END
	PTR_FREE, self.axex  
	self.nb = 0

	self -> fen_remove_data

END

;-------------------------------------------------------------------------------
PRO fenetre_axex::cleanup
;-------------------------------------------------------------------------------
; Destructeur de la classe "fenetre_axex".
;-------------------------------------------------------------------------------

	self -> fenetre__remove_data

END

;-------------------------------------------------------------------------------
PRO fenetre_axex__define
;-------------------------------------------------------------------------------
; La classe "fenetre_axex" hrite de "fen".
;-------------------------------------------------------------------------------

	lint_unused = { un_axex,		$

		xmin:		0d,		$
		xmax:		0d,		$
		ymin:		0d,		$
		ymax:		0d,		$
		x1:		0d,		$
		x2:		0d,		$
		y1:		0d,		$
		y2:		0d,		$
		titre:		'',		$
		ticklen:	0d,		$
		log:		0,		$
		xtickv:		PTR_NEW(),	$
		xticks:		0,		$
		xminor:		0,		$
		xtickname:	PTR_NEW(),	$
		couleur:	0,		$
		charsize:	0d,		$
		xthick:		0d,		$
		xtickformat:	''		$

	}

	lint_unused = { fenetre_axex,		$

		INHERITS	fen,		$
		axex:		PTR_NEW(),	$
		nb:		0L		$

	}

END
