;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: fenetre__define.pro,v $, v $Revision: 1.35 $
;
;	Date	: $Date: 2021/07/22 12:55:22 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO fenetre::ecraninfo,	$
;-------------------------------------------------------------------------------
	x1n,		$	; LINT_PROTOTYPE output
	x2n,		$	; LINT_PROTOTYPE output
	y1n,		$	; LINT_PROTOTYPE output
	y2n,		$	; LINT_PROTOTYPE output
	x1ecran,	$	; LINT_PROTOTYPE output
	y1ecran,	$	; LINT_PROTOTYPE output
	x2ecran,	$	; LINT_PROTOTYPE output
	y2ecran,	$	; LINT_PROTOTYPE output
	dxecran,	$	; LINT_PROTOTYPE output
	dyecran			; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne des valeurs qui sont utilises en interne.
;-------------------------------------------------------------------------------

	x1n = self -> xn(0)
	x2n = self -> xn(1)
	y1n = self -> yn(0)
	y2n = self -> yn(1)

	hash_general = self.general -> gethash()
	xsize = getq (self.general, hash_general.xsize)
	ysize = getq (self.general, hash_general.ysize)
	x1ecran = MIN ([FLOOR(xsize*x1n), xsize-1])
	x2ecran = MIN ([CEIL(xsize*x2n), xsize-1])
	y1ecran = MIN ([FLOOR(ysize*y1n), ysize-1])
	y2ecran = MIN ([CEIL(ysize*y2n), ysize-1])

	dxecran = 1+x2ecran-x1ecran
	dyecran = 1+y2ecran-y1ecran

END

;-------------------------------------------------------------------------------
PRO fenetre::getregions_info,	$
;-------------------------------------------------------------------------------
	region,			$	; LINT_PROTOTYPE output
	coul,			$	; LINT_PROTOTYPE output
	taille,			$	; LINT_PROTOTYPE output
	croix				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne des infos concernant les diffrents rgions.
;-------------------------------------------------------------------------------

	region = [ 										$
		'kill', 'max', 'refresh', 							$
		'haut_dep','bas_dep', 'gauche_dep', 'droite_dep', 				$
		'gauche_size','droite_size','bas_size','haut_size', 				$  
		'gauche_haut_size','droite_haut_size','gauche_bas_size','droite_bas_size', 	$
		'centre' 									$
	]
	
	coul = [ 		$
		7, 5, 5, 	$
		5, -5, -5, -5, 	$
		7, 7, 7, 7, 	$
		7, 7, 7, 7, 	$
		7 ]

	taille = [ 		$
		2, 2, 2, 	$
		2, 2, 2, 2, 	$
		2, 2, 2, 2, 	$
		2, 2, 2, 2, 	$
		2 ]

	croix = [ 		$
		1, 0, 0, 	$
		0, 0, 0, 0, 	$
		0, 0, 0, 0, 	$
		0, 0, 0, 0, 	$
		0]

END

;-------------------------------------------------------------------------------
PRO fenetre::getregions,	$
;-------------------------------------------------------------------------------
	region,			$	; LINT_PROTOTYPE input
	x1,			$	; LINT_PROTOTYPE output
	x2,			$	; LINT_PROTOTYPE output
	y1,			$	; LINT_PROTOTYPE output
	y2				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne les coordonnes d'une rgion.
;-------------------------------------------------------------------------------

	self -> ecraninfo, x1n, x2n, y1n, y2n, x1ecran, y1ecran, x2ecran, y2ecran, dxecran, dyecran

	hash_general = self.general -> gethash()
	Lmin = getq (self.general, hash_general.Lext)
	L = getq (self.general, hash_general.Lint)

	;    |------------------------------------------|
	; yj |(12) |          (8)                 |(13) |
	; yi |     |                              |     |
	;    |------------------------------------|-----|
	; yh |     |     |            |     |     |     |
	; yg |     | (5) |  (1)       | (7) | (6) |     |
	;    |     |-----|------------------|-----|     |
	; yf |     |     |                  |     |     |
	;    |     |     |                  |     |     |
	;    |(10) | (3) |                  | (4) |(11) |
	;    |     |     |                  |     |     |
	; ye |     |     |                  |     |     |
	;    |     |------------------------------|     |
	; yd |     |                              |     |
	; yc |     | (2)                          |     |
	;    |-----|------------------------------------|
	; yb |     |                              |     |
	; ya |(14) |        (9)                   |(15) |
	;    |------------------------------------------|
	;     xa xb  xc xd xe        xf xg xh xi xj xk xl


	xa = x1ecran
	xb = x1ecran+Lmin-1
	xc = xb+1
	xd = xb+L
	xe = xd+1
	xf = x2ecran-Lmin-2*L
	xg = xf+1
	xh = xf+L
	xi = xh+1
	xj = xh+L
	xk = xj+1
	xl = x2ecran

	ya = y1ecran
	yb = ya+Lmin-1
	yc = yb+1
	yd = yb+L
	ye = yd+1
	yf = y2ecran-Lmin-L
	yg = yf+1
	yh = yf+L
	yi = yh+1
	yj = y2ecran

	IF region EQ 'haut_dep' THEN BEGIN
		x1 = xe & x2 = xf & y1 = yg & y2 = yh & code = 1 ; (1)
	END ELSE IF region EQ 'bas_dep' THEN BEGIN
		x1 = xc & x2 = xj & y1 = yc & y2 = yd & code = 1 ; (2)
	END ELSE IF region EQ 'gauche_dep' THEN BEGIN
		x1 = xc & x2 = xd & y1 = ye & y2 = yf & code = 1 ; (3)
	END ELSE IF region EQ 'droite_dep' THEN BEGIN
		x1 = xi & x2 = xj & y1 = ye & y2 = yf & code = 1 ; (4)
	END ELSE IF region EQ 'refresh' THEN BEGIN
		x1 = xc & x2 = xd & y1 = yg & y2 = yh & code = 1 ; (5)
	END ELSE IF region EQ 'kill' THEN BEGIN
		x1 = xi & x2 = xj & y1 = yg & y2 = yh & code = 1 ; (6)
	END ELSE IF region EQ 'max' THEN BEGIN
		x1 = xg & x2 = xh & y1 = yg & y2 = yh & code = 1 ; (7)
	END ELSE IF region EQ 'haut_size' THEN BEGIN
		x1 = xc & x2 = xj & y1 = yi & y2 = yj & code = 2 ; (8)
	END ELSE IF region EQ 'bas_size' THEN BEGIN
		x1 = xc & x2 = xj & y1 = ya & y2 = yb & code = 2 ; (9)
	END ELSE IF region EQ 'gauche_size' THEN BEGIN
		x1 = xa & x2 = xb & y1 = yc & y2 = yh & code = 2 ; (10)
	END ELSE IF region EQ 'droite_size' THEN BEGIN
		x1 = xk & x2 = xl & y1 = yc & y2 = yh & code = 2 ; (11)
	END ELSE IF region EQ 'gauche_haut_size' THEN BEGIN
		x1 = xa & x2 = xb & y1 = yi & y2 = yj & code = 2 ; (12)
	END ELSE IF region EQ 'droite_haut_size' THEN BEGIN
		x1 = xk & x2 = xl & y1 = yi & y2 = yj & code = 2 ; (13)
	END ELSE IF region EQ 'gauche_bas_size' THEN BEGIN
		x1 = xa & x2 = xb & y1 = ya & y2 = yb & code = 2 ; (14)
	END ELSE IF region EQ 'droite_bas_size' THEN BEGIN
		x1 = xk & x2 = xl & y1 = ya & y2 = yb & code = 2 ; (15)
	END ELSE IF region EQ 'centre' THEN BEGIN
		x1 = xa & x2 = xl & y1 = ya & y2 = yj & code = 0
	END

	IF code EQ 1 THEN BEGIN
		IF x2ecran-x1ecran+1 LT 2*Lmin+3*L OR y2ecran-y1ecran+1 LT 2*Lmin+1*L THEN x1 = -1
	END ELSE IF code EQ 2 THEN BEGIN
		IF x2ecran-x1ecran+1 LT 3*Lmin OR y2ecran-y1ecran+1 LT 3*Lmin THEN x1 = -1
	END

END

;-------------------------------------------------------------------------------
PRO fenetre::image,	$
;-------------------------------------------------------------------------------
	coul,		$	; LINT_PROTOTYPE input
	x1,		$	; LINT_PROTOTYPE input
	x2,		$	; LINT_PROTOTYPE input
	y1,		$	; LINT_PROTOTYPE input
	y2			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche une image d'une couleur donne.
;-------------------------------------------------------------------------------

	general = self.general

	IF x1 GT x2 OR y1 GT y2 THEN BEGIN
		cl_msg, general, str_bas='WARNING: image too small'
		RETURN
	END

	pal = get (general,'pal')
	code = pal -> code(coul,/rvb)
	IF N_ELEMENTS(code) EQ 1 THEN BEGIN
		image = REPLICATE (code,x2-x1+1,y2-y1+1)
		true = 0
	END ELSE BEGIN
		image = REPLICATE (0b,3,x2-x1+1,y2-y1+1)
		image[0,*,*] = code[0]
		image[1,*,*] = code[1]
		image[2,*,*] = code[2]
		true = 1
	END

	IF get(general, 'batch') THEN BEGIN
		; Transformer (x1,x2,y1,y2) des coordonnes cran en coordonnes normalises
		xsize = get (general, 'xsize')
		ysize = get (general, 'ysize')
		x1n = DOUBLE(x1) / xsize
		y1n = DOUBLE(y1) / ysize
		tv_new, image, x1n, y1n, xsize=DOUBLE(x2-x1+1)/xsize, ysize=DOUBLE(y2-y1+1)/ysize, /normal, true=true
	END ELSE BEGIN
		tv_new, image, x1, y1, /device, true=true
	END

END

;-------------------------------------------------------------------------------
PRO fenetre::image_menu,	$
;-------------------------------------------------------------------------------
	x1,			$	; LINT_PROTOTYPE input
	x2,			$	; LINT_PROTOTYPE input
	y1,			$	; LINT_PROTOTYPE input
	y2,			$	; LINT_PROTOTYPE input
	coul1,			$	; LINT_PROTOTYPE input
	coul2,			$	; LINT_PROTOTYPE input
	taille,			$	; LINT_PROTOTYPE input
	croix				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche les petites images constituant une rgion.
;-------------------------------------------------------------------------------

	general = self.general
	pal = get (general,'pal')

	;    |------------------------------------------|
	; yf |     |                              |     |
	; ye |     |          haut                |     |
	;    |     |------------------------------|-----|
	; yd |  g  |                              |     |
	;    |  a  |                              |     |
	;    |  u  |                              |  d  |
	;    |  c  |                              |  r  |
	;    |  h  |          centre              |  o  |
	;    |  e  |                              |  i  |
	;    |     |                              |  t  |
	;    |     |                              |  e  |
	;    |     |                              |     |
	;    |     |                              |     |
	; yc |     |                              |     |
	;    |-----|------------------------------|     |
	; yb |-|-|-|                              |     |
	; ya |-|-|-|        bas                   |     |
	;    |------------------------------------------|
	;     xa xb xc                          xd xe xf

	xa = x1
	xb = xa+taille-1
	xc = xb+1
	xd = x2-taille
	xe = xd+1
	xf = x2

	ya = y1
	yb = y1+taille-1
	yc = yb+1
	yd = y2-taille
	ye = yd+1
	yf = y2

	IF coul1 NE -1 THEN self -> image, coul1,   xc, xd, yc, yd ; centre

	self -> image, coul2-3, xa, xb, yc, yf ; gauche
	self -> image, coul2-3, xc, xd, ye, yf ; haut
	FOR i=1L,taille DO BEGIN
		self -> image, coul2-3, xa, xa+i-1, ya+i-1, ya+i-1
		self -> image, coul2-3, xe, xe+i-1, ye+i-1, ye+i-1
	END

	self -> image, coul2+3, xe, xf, ya, yd ; droite
	self -> image, coul2+3, xc, xd, ya, yb ; bas
	FOR i=1L,taille-1 DO BEGIN
		self -> image, coul2+3, xa+i, xb, ya+i-1, ya+i-1
		self -> image, coul2+3, xe+i, xf, ye+i-1, ye+i-1
	END

	IF croix THEN BEGIN
		thick = 2
		IF !CL.libplot EQ '' && is_fdl() && is_fdl(/RELEASE) GE '0.79.48' AND thick GT 1 THEN thick = 1 + (thick-1)*0.5 ; sinon les caractres sont trop gras
		IF get(general, 'batch') THEN BEGIN
			; Passer en coordonnes normalises
			xsize = get (general, 'xsize')
			ysize = get (general, 'ysize')
			libplot_plots, DOUBLE([x1+taille+2,x2-taille-2])/xsize, DOUBLE([y1+taille+2,y2-taille-2])/ysize, /normal, color=pal -> code(coul2-3), thick=thick
			libplot_plots, DOUBLE([x1+taille+2,x2-taille-2])/xsize, DOUBLE([y2-taille-2,y1+taille+2])/ysize, /normal, color=pal -> code(coul2-3), thick=thick
		END ELSE BEGIN
			libplot_plots, [x1+taille+2,x2-taille-2], [y1+taille+2,y2-taille-2], /device, color=pal -> code(coul2-3), thick=thick
			libplot_plots, [x1+taille+2,x2-taille-2], [y2-taille-2,y1+taille+2], /device, color=pal -> code(coul2-3), thick=thick
		END
	END

END

;-------------------------------------------------------------------------------
PRO fenetre::fenetre_bordure,	$
;-------------------------------------------------------------------------------
	name,			$	; LINT_PROTOTYPE input
	actif=actif,		$	; LINT_PROTOTYPE input
	selected=selected,	$	; LINT_PROTOTYPE input
	raz=raz				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche les bordures d'un fentre.
;-------------------------------------------------------------------------------

	self -> ecraninfo, x1n, x2n, y1n, y2n, x1ecran, y1ecran, x2ecran, y2ecran, dxecran, dyecran

	general = self.general
	batch = get (general, 'batch')
	pal = get (general,'pal')
	pal -> get_rvb, r,v,b
	true = pal -> true(/nbcolors)
	optiontrue = pal -> true()

	IF N_ELEMENTS(actif)    EQ 0 THEN actif = 0
	IF N_ELEMENTS(selected) EQ 0 THEN selected = 0
	IF N_ELEMENTS(raz) NE 0 THEN BEGIN
		self.selected = 0
		self.actif = 0
		FOR i=0L,N_ELEMENTS(self.image)-1 DO PTR_FREE, self.image[i]
		RETURN
	END

	tab_selected = ['gauche_size','droite_size','bas_size','haut_size','centre']  
	self -> getregions_info, region,coul,taille,croix

	unok = 0
	FOR i=0L,N_ELEMENTS(region)-1 DO BEGIN

		IF is_gdl() THEN BEGIN ; ok
			IF ~batch THEN BEGIN
				; sinon la slection d'un objet prend 20 sec ( cause de tvrd_new)
				; on ne traite que la premire rgion
				IF i NE 0 THEN CONTINUE
			END
		END

		IF coul[i] GT 0 AND (region[i] NE 'centre' OR ~unok) THEN BEGIN
			self -> getregions, region[i], x1,x2,y1,y2

			IF x1 NE -1 THEN unok = 1
			IF (actif OR selected) AND x1 NE -1 THEN BEGIN

				ind = WHERE (tab_selected EQ region[i])
				IF ind[0] EQ -1 THEN BEGIN ; pas zone selected
					coul1 = coul[i]
					coul2 = coul[i]
					ok_affiche = actif AND ~self.actif
					ok_affiche_batch = actif
					mem_affiche = 1
					IF ~actif AND self.actif THEN BEGIN
						IF PTR_VALID(self.image[i]) THEN BEGIN
							tv_new, *self.image[i],x1,y1,true=true AND (!VERSION.OS NE 'Win32' OR optiontrue)
						END
					END
				END ELSE BEGIN 
					coul1 = selected ?  6 : coul[i]
					coul2 = coul1
					IF region[i] EQ 'centre' THEN BEGIN
						IF selected AND actif THEN coul1 = coul[i]
					END
					ok_affiche = 1
					ok_affiche_batch = 1
					mem_affiche = ~self.actif AND ~self.selected
				END
				IF (~batch AND ok_affiche) OR (batch AND ok_affiche_batch) THEN BEGIN
					IF mem_affiche AND x2 GE x1 AND y2 GE y1 THEN BEGIN
						IF ~batch THEN self.image[i] = allocfree (self.image[i], tvrd_new (x1,y1,x2-x1+1,y2-y1+1,r,v,b,optiontrue,true=true))
					END
					self -> image_menu,x1,x2,y1,y2,coul1,coul2,taille[i],croix[i]
				END

			END ELSE BEGIN

				IF PTR_VALID(self.image[i]) THEN BEGIN
					tv_new, *self.image[i],x1,y1,true=true AND (!VERSION.OS NE 'Win32' OR optiontrue)
				END

			END

		END
	END

	IF actif THEN BEGIN
		self -> getregions, 'haut_dep', x1,x2,y1,y2
		IF x1 NE -1 THEN BEGIN
			IF batch THEN BEGIN
				; passer en coordonnes normalises
				; 01/07/2021: je remets cet algo sinon les valeurs ne sont pas bonnes dans clweb et le numro du panneau ne s'affiche pas.
				xsize = get (general, 'xsize')
				ysize = get (general, 'ysize')
				libplot_xyouts, DOUBLE(x1+x2)/2/xsize, DOUBLE(y1+5)/ysize, '!3'+name, /normal, color=pal -> code(0), alignment=0.5
			END ELSE BEGIN
				; passer en coordonnes normalises
				tmp = libplot_convert_coord ((x1+x2)/2, y1+5, /dev, /to_norm)
				libplot_xyouts, tmp[0], tmp[1], '!3'+name, /normal, color=pal -> code(0), alignment=0.5
			END
		END
	END

	self.selected = selected
	self.actif = actif

END


;-------------------------------------------------------------------------------
PRO fenetre::efface
;-------------------------------------------------------------------------------
; Efface le contenu de la fenetre, avec du blanc.
;-------------------------------------------------------------------------------

	self -> ecraninfo, x1n, x2n, y1n, y2n, x1ecran, y1ecran, x2ecran, y2ecran, dxecran, dyecran
	self -> image, 0, x1ecran, x2ecran, y1ecran, y2ecran ; 0=blanc

END


;-------------------------------------------------------------------------------
PRO fenetre::ajouter,	$
;-------------------------------------------------------------------------------
	type	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ajoute une fentre d'un type donn (image, timeaxis, axey, show_dir, texte, palette, courbe, orbito ou axex).
;
; notype: 0 pour ajouter_image
;         1 pour ajouter_timeaxis
;         2 pour ajouter_axey
;         3 pour ajouter_show_dir
;         4 pour ajouter_texte
;         5 pour ajouter_palette
;         6 pour ajouter_courbe
;         7 pour ajouter_orbito
;         8 pour ajouter_axex
;-------------------------------------------------------------------------------

	element = { var_fenetre, type, self.ind[type] }
	nb = self.nb
	tab = self.tab
	ajouter_tab1, tab, element, nb
	self.tab = tab
	self.nb = nb

	self.ind[type]++

END

;-------------------------------------------------------------------------------
PRO fenetre::ajouter_image,				$
;-------------------------------------------------------------------------------
	image,						$	; LINT_PROTOTYPE input
	x1,						$	; LINT_PROTOTYPE input
	x2,						$	; LINT_PROTOTYPE input
	y1,						$	; LINT_PROTOTYPE input
	y2,						$	; LINT_PROTOTYPE input
	true=true,					$	; LINT_PROTOTYPE input
	produit=produit, 				$	; LINT_PROTOTYPE input
	trans=trans,					$	; LINT_PROTOTYPE input
	min=min,					$	; LINT_PROTOTYPE input
	max=max,					$	; LINT_PROTOTYPE input
	nb=nb,						$	; LINT_PROTOTYPE input
	type=type,					$	; LINT_PROTOTYPE input
	az=az,						$	; LINT_PROTOTYPE input
	ax=ax,						$	; LINT_PROTOTYPE input
	is3D=is3D,					$	; LINT_PROTOTYPE input
	constraint=constraint,				$	; LINT_PROTOTYPE input
	NO_COPY=NO_COPY,				$	; LINT_PROTOTYPE input
	contoursnb=contoursnb,				$	; LINT_PROTOTYPE input
	INTERP=INTERP,					$	; LINT_PROTOTYPE input
	CONTINENTS=CONTINENTS,				$	; LINT_PROTOTYPE input
	HIRES=HIRES,					$	; LINT_PROTOTYPE input
	MOINS180PLUS180=MOINS180PLUS180,		$	; LINT_PROTOTYPE input
	MLINETHICK=MLINETHICK,				$	; LINT_PROTOTYPE input
	XMIN=XMIN, 					$	; LINT_PROTOTYPE input
	XMAX=XMAX,			 		$	; LINT_PROTOTYPE input
	YMIN=YMIN, 					$	; LINT_PROTOTYPE input
	YMAX=YMAX, 					$	; LINT_PROTOTYPE input
	blanc=blanc,					$	; LINT_PROTOTYPE input
	longitude=longitude,				$	; LINT_PROTOTYPE input
	latitude=latitude,				$	; LINT_PROTOTYPE input
	rotation=rotation,				$	; LINT_PROTOTYPE input
	info_B=info_B,					$	; LINT_PROTOTYPE input
	info_U=info_U						; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ajoute une "image"  la fentre (code 0).
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(image) EQ 1 AND image[0] EQ -1 THEN RETURN
	self.obj[0] -> fenetre_image_ajouter, image,x1,x2,y1,y2, true=true, produit=produit, 				$
			trans=trans, min=min, max=max, nb=nb, type=type, az=az, ax=ax, is3D=is3D, 			$
			constraint=constraint,NO_COPY=NO_COPY, contoursnb=contoursnb, INTERP=INTERP, 			$
			CONTINENTS=CONTINENTS, HIRES=HIRES, MOINS180PLUS180=MOINS180PLUS180, MLINETHICK=MLINETHICK,	$
			XMIN=XMIN, XMAX=XMAX, YMIN=YMIN, YMAX=YMAX, blanc=blanc,					$
			longitude=longitude, latitude=latitude, rotation=rotation, info_B=info_B, info_U=info_U
	self -> ajouter, 0

END

;-------------------------------------------------------------------------------
PRO fenetre::ajouter_timeaxis,	$
;-------------------------------------------------------------------------------
	t1,			$	; LINT_PROTOTYPE input
	t2,			$	; LINT_PROTOTYPE input
	x1,			$	; LINT_PROTOTYPE input
	x2,			$	; LINT_PROTOTYPE input
	y1,			$	; LINT_PROTOTYPE input
	y2,			$	; LINT_PROTOTYPE input
	nolabels,		$	; LINT_PROTOTYPE input
	ticklen, 		$	; LINT_PROTOTYPE input
	police,			$	; LINT_PROTOTYPE input
	charsize,		$	; LINT_PROTOTYPE input
	couleur,		$	; LINT_PROTOTYPE input
	format, 		$	; LINT_PROTOTYPE input
	jd, 			$	; LINT_PROTOTYPE input
	thick				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ajoute un "time_axis"  la fentre (code 1).
;-------------------------------------------------------------------------------

	self.obj[1] -> fenetre_timeaxis_ajouter, t1, t2, x1, x2, y1, y2, nolabels, ticklen, $
			police, charsize, couleur, format, jd, thick
	self -> ajouter, 1

END

;-------------------------------------------------------------------------------
PRO fenetre::ajouter_axey,	$
;-------------------------------------------------------------------------------
	xmin, 			$	; LINT_PROTOTYPE input
	xmax, 			$	; LINT_PROTOTYPE input
	ymin,			$	; LINT_PROTOTYPE input
	ymax,			$	; LINT_PROTOTYPE input
	x0,			$	; LINT_PROTOTYPE input
	y0,			$	; LINT_PROTOTYPE input
	x1,			$	; LINT_PROTOTYPE input
	x2,			$	; LINT_PROTOTYPE input
	y1,			$	; LINT_PROTOTYPE input
	y2,			$	; LINT_PROTOTYPE input
	titre,			$	; LINT_PROTOTYPE input
	libelle,		$	; LINT_PROTOTYPE input
	angle,			$	; LINT_PROTOTYPE input
	ticklen,		$	; LINT_PROTOTYPE input
	log, 			$	; LINT_PROTOTYPE input
	ytickv, 		$	; LINT_PROTOTYPE input
	yticks, 		$	; LINT_PROTOTYPE input
	yminor, 		$	; LINT_PROTOTYPE input
	cote, 			$	; LINT_PROTOTYPE input
	ytickname, 		$	; LINT_PROTOTYPE input
	couleur, 		$	; LINT_PROTOTYPE input
	charsize, 		$	; LINT_PROTOTYPE input
	ythick, 		$	; LINT_PROTOTYPE input
	ytickformat, 		$	; LINT_PROTOTYPE input
	yalignment, 		$	; LINT_PROTOTYPE input
	nopanel=nopanel			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ajoute un "axey"  la fentre (code 2).
;
; cote: 1 pour un axe a gauche
;       2 pour un axe a droite
;       3 pour les 2 axes
;-------------------------------------------------------------------------------

	self.obj[2] -> fenetre_axey_ajouter, xmin, xmax, ymin,ymax,x0,y0,x1,x2,y1,y2,titre,libelle,angle,	$
				ticklen,log, ytickv, yticks, yminor, cote, ytickname, couleur, charsize, 	$
				ythick, ytickformat, yalignment, nopanel=nopanel
	self -> ajouter, 2

END

;-------------------------------------------------------------------------------
PRO fenetre::ajouter_show_dir, 	$
;-------------------------------------------------------------------------------
	no, 			$	; LINT_PROTOTYPE input
	x, 			$	; LINT_PROTOTYPE input
	y, 			$	; LINT_PROTOTYPE input
	taille,			$	; LINT_PROTOTYPE input
	couleur				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ajoute un 'show_dir'  la fentre (code 3).
;-------------------------------------------------------------------------------

	self.obj[3] -> fenetre_showdir_ajouter, no, x, y, taille, couleur
	self -> ajouter, 3

END

;-------------------------------------------------------------------------------
PRO fenetre::ajouter_texte,	$
;-------------------------------------------------------------------------------
	x, 			$	; LINT_PROTOTYPE input
	y, 			$	; LINT_PROTOTYPE input
	texte, 			$	; LINT_PROTOTYPE input
	alignment,		$	; LINT_PROTOTYPE input
	taille, 		$	; LINT_PROTOTYPE input
	couleur, 		$	; LINT_PROTOTYPE input
	angle, 			$	; LINT_PROTOTYPE input
	thick				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ajoute un "texte"  la fentre (code 4).
;-------------------------------------------------------------------------------

	self.obj[4] -> fenetre_texte_ajouter, x, y, texte, alignment, taille, couleur, $
				angle, thick
	self -> ajouter, 4

END

;-------------------------------------------------------------------------------
PRO fenetre::ajouter_palette,	$
;-------------------------------------------------------------------------------
	x1, 			$	; LINT_PROTOTYPE input
	x2, 			$	; LINT_PROTOTYPE input
	y1, 			$	; LINT_PROTOTYPE input
	y2, 			$	; LINT_PROTOTYPE input
	xval, 			$	; LINT_PROTOTYPE input
	yval, 			$	; LINT_PROTOTYPE input
	taille,			$	; LINT_PROTOTYPE input
	epais, 			$	; LINT_PROTOTYPE input
	nb,			$	; LINT_PROTOTYPE input
	format,			$	; LINT_PROTOTYPE input
	min,			$	; LINT_PROTOTYPE input
	max,			$	; LINT_PROTOTYPE input
	txt,			$	; LINT_PROTOTYPE input
	xtxt,			$	; LINT_PROTOTYPE input
	ytxt,			$	; LINT_PROTOTYPE input
	couleurs,		$	; LINT_PROTOTYPE input
	couleur				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ajoute une "palette"  la fentre (code 5).
;-------------------------------------------------------------------------------

	self.obj[5] -> fenetre_palette_ajouter, x1, x2, y1, y2, xval, yval, taille, epais, $
				nb, format, min, max, txt, xtxt, ytxt, couleurs, couleur
	self -> ajouter, 5

END

;-------------------------------------------------------------------------------
PRO fenetre::ajouter_courbe,	$
;-------------------------------------------------------------------------------
	tabx,			$	; LINT_PROTOTYPE input
	taby,			$	; LINT_PROTOTYPE input
	couleur,		$	; LINT_PROTOTYPE input
	psym1,			$	; LINT_PROTOTYPE input
	psym2,			$	; LINT_PROTOTYPE input
	symsize,		$	; LINT_PROTOTYPE input
	linestyle,		$	; LINT_PROTOTYPE input
	thick,			$	; LINT_PROTOTYPE input
	xmin,			$	; LINT_PROTOTYPE input
	xmax,			$	; LINT_PROTOTYPE input
	xlog,			$	; LINT_PROTOTYPE input
	ymin,			$	; LINT_PROTOTYPE input
	ymax,			$	; LINT_PROTOTYPE input
	ylog,			$	; LINT_PROTOTYPE input
	x1,			$	; LINT_PROTOTYPE input
	x2,			$	; LINT_PROTOTYPE input
	y1,			$	; LINT_PROTOTYPE input
	y2,			$	; LINT_PROTOTYPE input
	nocourbe,		$	; LINT_PROTOTYPE output
	tabt=tabt,		$	; LINT_PROTOTYPE input
	plots=plots,		$	; LINT_PROTOTYPE input
	isdata=isdata,		$	; LINT_PROTOTYPE input
	ref=ref,		$	; LINT_PROTOTYPE input
	NO_COPY=NO_COPY,	$	; LINT_PROTOTYPE input
	system=system,		$	; LINT_PROTOTYPE input
	sym=sym				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ajoute une "courbe"  la fentre (code 6). 
;-------------------------------------------------------------------------------

	self.obj[6] -> fenetre_courbe_ajouter, tabt=tabt, tabx, taby, couleur, psym1, psym2, symsize, 	$
				linestyle, thick, 							$
				xmin, xmax, xlog, ymin, ymax, ylog, x1, x2, y1, y2, plots=plots,	$
				isdata=isdata, ref=ref, NO_COPY=NO_COPY, system=system, sym=sym
	self -> ajouter, 6
	nocourbe = self.ind[6]-1

END

;-------------------------------------------------------------------------------
PRO fenetre::getyminymax_courbe,	$
;-------------------------------------------------------------------------------
	no,				$	; LINT_PROTOTYPE input
	ymin,				$	; LINT_PROTOTYPE output
	ymax					; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne le min et le max d'une courbe.
;-------------------------------------------------------------------------------

	self.obj[6] -> getyminymax, no, ymin,ymax

END

;-------------------------------------------------------------------------------
PRO fenetre::getyminymax_axey,	$
;-------------------------------------------------------------------------------
	no,				$	; LINT_PROTOTYPE input
	ymin,				$	; LINT_PROTOTYPE output
	ymax					; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne le min et le max d'un axey.
;-------------------------------------------------------------------------------

	self.obj[2] -> getyminymax, no, ymin,ymax

END


;-------------------------------------------------------------------------------
PRO fenetre::setyminymax_courbe,	$
;-------------------------------------------------------------------------------
	no,				$	; LINT_PROTOTYPE input
	ymin,				$	; LINT_PROTOTYPE input
	ymax					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Positionne le min et le max d'une courbe.
;-------------------------------------------------------------------------------

	self.obj[6] -> setyminymax, no, ymin,ymax

END

;-------------------------------------------------------------------------------
PRO fenetre::setyminymax_axey,	$
;-------------------------------------------------------------------------------
	no,				$	; LINT_PROTOTYPE input
	ymin,				$	; LINT_PROTOTYPE input
	ymax					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Positionne le min et le max d'un axey.
;-------------------------------------------------------------------------------

	self.obj[2] -> setyminymax, no, ymin,ymax

END

;-------------------------------------------------------------------------------
PRO fenetre::ajouter_orbito,	$
;-------------------------------------------------------------------------------
	tab_data,	 	$	; LINT_PROTOTYPE input
	t1, 			$	; LINT_PROTOTYPE input
	t2, 			$	; LINT_PROTOTYPE input
	x0, 			$	; LINT_PROTOTYPE input
	x1, 			$	; LINT_PROTOTYPE input
	x2, 			$	; LINT_PROTOTYPE input
	y1, 			$	; LINT_PROTOTYPE input
	y2, 			$	; LINT_PROTOTYPE input
	orb_txt, 		$	; LINT_PROTOTYPE input
	tailleorb, 		$	; LINT_PROTOTYPE input
	fontorb, 		$	; LINT_PROTOTYPE input
	epaisorb, 		$	; LINT_PROTOTYPE input
	presence, 		$	; LINT_PROTOTYPE input
	couleur				; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ajoute un "orbito"  la fentre (code 7).
;-------------------------------------------------------------------------------

	self.obj[7] -> fenetre_orbito_ajouter, tab_data, t1, t2, x0, x1, x2, y1, y2, $
				orb_txt, tailleorb, fontorb, epaisorb, presence, couleur
	self -> ajouter, 7

END

;-------------------------------------------------------------------------------
PRO fenetre::ajouter_axex,	$
;-------------------------------------------------------------------------------
	xmin, 			$	; LINT_PROTOTYPE input
	xmax,			$	; LINT_PROTOTYPE input
	ymin,			$	; LINT_PROTOTYPE input
	ymax,			$	; LINT_PROTOTYPE input
	x1,			$	; LINT_PROTOTYPE input
	x2,			$	; LINT_PROTOTYPE input
	y1,			$	; LINT_PROTOTYPE input
	y2,			$	; LINT_PROTOTYPE input
	titre,			$	; LINT_PROTOTYPE input
	ticklen,		$	; LINT_PROTOTYPE input
	log, 			$	; LINT_PROTOTYPE input
	xtickv, 		$	; LINT_PROTOTYPE input
	xticks, 		$	; LINT_PROTOTYPE input
	xminor, 		$	; LINT_PROTOTYPE input
	xtickname, 		$	; LINT_PROTOTYPE input
	couleur, 		$	; LINT_PROTOTYPE input
	charsize, 		$	; LINT_PROTOTYPE input
	xthick,			$	; LINT_PROTOTYPE input
	xtickformat			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Ajoute un "axex"  la fentre (code 8).
;-------------------------------------------------------------------------------

	self.obj[8] -> fenetre_axex_ajouter, xmin, xmax, ymin,ymax,x1,x2,y1,y2,titre,			$
				ticklen, log, xtickv, xticks, xminor, xtickname, couleur, charsize, 	$
				xthick, xtickformat
	self -> ajouter, 8

END

;-------------------------------------------------------------------------------
FUNCTION fenetre::fenetre_alloc_rvb,	$
;-------------------------------------------------------------------------------
	translation	; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Demande  "palette" l'allocation des couleurs.
;-------------------------------------------------------------------------------

	IF PTR_VALID(self.rvb) THEN BEGIN
		IF ~self.true THEN BEGIN
			hash_general = self.general -> gethash()
			pal = getq (self.general, hash_general.pal)
			code = pal -> pal_alloc_rvb (*self.rvb, self.shade_rvb, translation)
			self.translation = allocfree (self.translation, translation) 
			self -> fsetproperty, translation, /translation
		END ELSE BEGIN
			code = 1
		END
	END ELSE BEGIN
		code = 1
	END

	RETURN, code

END

;-------------------------------------------------------------------------------
PRO fenetre::remove_rvb
;-------------------------------------------------------------------------------
; Demande  "palette" la suppression des couleurs.
;-------------------------------------------------------------------------------

	IF PTR_VALID(self.rvb) THEN BEGIN
		IF ~self.true THEN BEGIN
			IF PTR_VALID(self.translation) THEN BEGIN ; objet avec rien a tracer ?
				hash_general = self.general -> gethash()
				pal = getq (self.general, hash_general.pal)
				pal -> free_rvb, *self.translation
			END
		END
	END

END

;-------------------------------------------------------------------------------
FUNCTION fenetre::get_nbimage
;-------------------------------------------------------------------------------
; Retourne le nombre d'images dans la fentre.
;-------------------------------------------------------------------------------

	IF ~PTR_VALID(self.tab) THEN RETURN, 0

	nb = 0L
	FOR i=0L, self.nb-1 DO IF (*self.tab)[i].type EQ 0 THEN nb++

	RETURN, nb

END

;-------------------------------------------------------------------------------
FUNCTION fenetre::get_nbcourbe
;-------------------------------------------------------------------------------
; Retourne le nombre de courbes dans la fentre.
;-------------------------------------------------------------------------------

	IF ~PTR_VALID(self.tab) THEN RETURN, 0

	nb = 0L
	FOR i=0L, self.nb-1 DO IF (*self.tab)[i].type EQ 6 THEN nb++

	RETURN, nb

END

;-------------------------------------------------------------------------------
FUNCTION fenetre::get_nbaxey
;-------------------------------------------------------------------------------
; Retourne le nombre d'axey dans la fentre.
;-------------------------------------------------------------------------------

	IF ~PTR_VALID(self.tab) THEN RETURN, 0

	nb = 0L
	FOR i=0L, self.nb-1 DO IF (*self.tab)[i].type EQ 2 THEN nb++

	RETURN, nb

END

;-------------------------------------------------------------------------------
PRO fenetre::get_imagedata,	$
;-------------------------------------------------------------------------------
	j,			$	; LINT_PROTOTYPE input
	imagedata, 		$	; LINT_PROTOTYPE output
	x1, 			$	; LINT_PROTOTYPE output
	x2, 			$	; LINT_PROTOTYPE output
	y1, 			$	; LINT_PROTOTYPE output
	y2, 			$	; LINT_PROTOTYPE output
	true, 			$	; LINT_PROTOTYPE output
	produit, 		$	; LINT_PROTOTYPE output
	is3D				; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; Retourne l'image numro j de la fentre.
;-------------------------------------------------------------------------------

	self.obj[0] -> get_imagedata, j, imagedata, x1, x2, y1, y2, true, produit, is3D

END

;-------------------------------------------------------------------------------
PRO fenetre::get_courbe,	$
;-------------------------------------------------------------------------------
	i, 			$	; LINT_PROTOTYPE input
	xmin, 			$	; LINT_PROTOTYPE output
	xminauto,		$	; LINT_PROTOTYPE output
	nbxminauto, 		$	; LINT_PROTOTYPE output
	yminauto, 		$	; LINT_PROTOTYPE output
	xmax, 			$	; LINT_PROTOTYPE output
	xmaxauto, 		$	; LINT_PROTOTYPE output
	nbxmaxauto, 		$	; LINT_PROTOTYPE output
	ymaxauto, 		$	; LINT_PROTOTYPE output
	isdata, 		$	; LINT_PROTOTYPE output
	ymoyauto=ymoyauto		; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne la courbe numro "i" de la fentre.
;-------------------------------------------------------------------------------

	self.obj[6] -> get_courbe, i, xmin, xminauto, nbxminauto, yminauto, $
				xmax, xmaxauto, nbxmaxauto, ymaxauto, isdata, ymoyauto=ymoyauto

END

;-------------------------------------------------------------------------------
FUNCTION fenetre::cherche_imagedata,	$
;-------------------------------------------------------------------------------
	j, 				$	; LINT_PROTOTYPE input
	xn, 				$	; LINT_PROTOTYPE input
	yn					; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne 1 si l'image numro "j" de la fentre contient le point (xn,yn).
;-------------------------------------------------------------------------------

	RETURN, self.obj[0] -> cherche_imagedata (j, xn, yn)

END

;-------------------------------------------------------------------------------
PRO fenetre::fenetre_voir,	$
;-------------------------------------------------------------------------------
	novoir=novoir	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche tous les objets contenus dans la fentre (axex, axey, courbe, image, orbito, palette, showdir, texte, timeaxis).
;-------------------------------------------------------------------------------

	IF ~PTR_VALID(self.tab) THEN RETURN

	pal = get(self.general,'pal')
	self.true = pal -> true()
	code = self -> fenetre_alloc_rvb (translation)

	; On averti tous les objets des valeurs de:
	; - gauche, droite, bas, haut
	; - code et translation

	FOR i=0L, N_ELEMENTS(self.objname)-1 DO BEGIN
		IF self.ind[i] NE 0 THEN BEGIN
			self.obj[i] -> fsetproperty, self.gauche, /gauche
			self.obj[i] -> fsetproperty, self.droite, /droite
			self.obj[i] -> fsetproperty, self.bas, /bas
			self.obj[i] -> fsetproperty, self.haut, /haut
			self.obj[i] -> fsetproperty, self.true, /true
			self.obj[i] -> fsetproperty, code, /code
			IF ~self.true THEN BEGIN
				self.obj[i] -> fsetproperty, translation, /translation
			END ELSE BEGIN
				IF PTR_VALID(self.rvb) THEN self.obj[i] -> fsetproperty, *self.rvb, /rvb
			END
		END
	END

	IF N_ELEMENTS(novoir) EQ 0 THEN BEGIN
		FOR i=0L, self.nb-1 DO BEGIN
			tmp = (*self.tab)[i] ; utilisation de tmp sinon c'est trs lent en GDL
			type = tmp.type
			no   = tmp.no
			self.obj[type] -> fvoir, no ; polymorphisme
		END
	END

END


;-------------------------------------------------------------------------------
PRO fenetre::voirandremove_lastimage,	$
;-------------------------------------------------------------------------------
	novoir=novoir	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Affiche la dernire image de la fentre, puis la supprime en mmoire et  l'cran.
;-------------------------------------------------------------------------------

	self -> fenetre_voir, /novoir

	no = self.ind[0]-1
	IF N_ELEMENTS(novoir) EQ 0 THEN BEGIN
		self.obj[0] -> fvoir, no
	END
	self.obj[0] -> remove, no

	i = self.nb-1
	p = self.tab
	supprimer_tab, p, i
	self.tab = p
	self.nb--
	self.ind[0]--

	self -> remove_rvb

END


;-------------------------------------------------------------------------------
PRO fenetre::fenetre_remove_data,	$
;-------------------------------------------------------------------------------
	norvb=norvb	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Supprime toutes les donnes.
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(norvb) EQ 0 THEN self -> remove_rvb
	self -> fen_remove_data

	FOR i=0L,N_ELEMENTS(self.image)-1 DO PTR_FREE, self.image[i]
	PTR_FREE, self.rvb
	FOR i=0L, N_ELEMENTS(self.objname)-1 DO self.obj[i] -> fenetre__remove_data
	self.ind[*]=0
	PTR_FREE, self.tab
	self.nb = 0

END

;-------------------------------------------------------------------------------
PRO fenetre::fenetre_clean
;-------------------------------------------------------------------------------
; Supprime uniquement les donnes image, timeaxis, axey, show_dir, texte, palette, courbe, orbito, axex.
;-------------------------------------------------------------------------------

	FOR i=0L, N_ELEMENTS(self.objname)-1 DO self.obj[i] -> fenetre__remove_data
	self.ind[*]=0
	PTR_FREE, self.tab
	self.nb = 0

END

;-------------------------------------------------------------------------------
PRO fenetre::cleanup
;-------------------------------------------------------------------------------
; Destructeur de la classe "fenetre".
;-------------------------------------------------------------------------------

	self -> fenetre_remove_data
	FOR i=0L, N_ELEMENTS(self.objname)-1 DO BEGIN
		IF OBJ_VALID(self.obj[i]) THEN OBJ_DESTROY, self.obj[i]
	END

END

;-------------------------------------------------------------------------------
FUNCTION fenetre::init,	$
;-------------------------------------------------------------------------------
	general	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Constructeur de la classe "fenetre".
;-------------------------------------------------------------------------------

	code = self -> fen::init (general)

	self.objname = [ $
		'fenetre_image', 	$
		'fenetre_timeaxis', 	$
		'fenetre_axey', 	$
		'fenetre_showdir', 	$
		'fenetre_texte', 	$
		'fenetre_palette', 	$
		'fenetre_courbe', 	$
		'fenetre_orbito', 	$
		'fenetre_axex' 		$
	]

	FOR i=0L, N_ELEMENTS(self.objname)-1 DO BEGIN
		self.obj[i] = OBJ_NEW(self.objname[i],general)
	END

	RETURN, code

END

;-------------------------------------------------------------------------------
PRO fenetre__define
;-------------------------------------------------------------------------------
; La classe "fenetre" hrite de "fen".
;-------------------------------------------------------------------------------

	lint_unused = { var_fenetre,				$ ; Ne pas changer l'ordre! (je sais plus pourquoi ...)

		type:        		0L,			$
		no:          		0L			$

	}

	lint_unused = { fenetre,				$

		INHERITS		fen,			$

		image:			PTRARR(16),		$
		selected:		0,			$
		actif:			0,			$

		obj:			OBJARR(9),		$
		objname:		REPLICATE('',9),	$
		ind:			REPLICATE(0L,9),	$ ; nombre d'lements dans chaque type
		tab:			PTR_NEW(),		$
		nb:			0L			$

	}

END
