;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: fen__define.pro,v $, v $Revision: 1.10 $
;
;	Date	: $Date: 2021/02/11 12:51:37 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
FUNCTION fen::xn,	$
;-------------------------------------------------------------------------------
	x	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne la valeur de x par rapport au device, dans l'espace [0, 1]
;
; x est en valeur normalis dans l'espace [ self.gauche, self.droite ]
;-------------------------------------------------------------------------------

	RETURN, self.gauche + x*(self.droite-self.gauche)

END

;-------------------------------------------------------------------------------
FUNCTION fen::yn,	$
;-------------------------------------------------------------------------------
	y	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Retourne la valeur de y par rapport au device, dans l'espace [0, 1]
;
; y est en valeur normalis dans l'espace [ self.bas, self.haut ]
;-------------------------------------------------------------------------------

	RETURN, self.bas + y*(self.haut-self.bas)

END



;-------------------------------------------------------------------------------
PRO fen::fen_remove_data
;-------------------------------------------------------------------------------
; Supprime les donnes internes.
;-------------------------------------------------------------------------------

	PTR_FREE, self.translation
	PTR_FREE, self.rvb

END

;-------------------------------------------------------------------------------
PRO fen::fsetproperty, $
;-------------------------------------------------------------------------------
	val, 				$	; LINT_PROTOTYPE input
	gauche=gauche, 			$	; LINT_PROTOTYPE input
	droite=droite, 			$	; LINT_PROTOTYPE input
	bas=bas, 			$	; LINT_PROTOTYPE input
	haut=haut, 			$	; LINT_PROTOTYPE input
	code=code, 			$	; LINT_PROTOTYPE input
	true=true, 			$	; LINT_PROTOTYPE input
	rvb=rvb, 			$	; LINT_PROTOTYPE input
	translation=translation, 	$	; LINT_PROTOTYPE input
	shade_rvb=shade_rvb			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Utilis pour mmoriser une proprit.
;-------------------------------------------------------------------------------

	IF N_ELEMENTS(gauche) 		NE 0 THEN self.gauche 		= val
	IF N_ELEMENTS(droite) 		NE 0 THEN self.droite 		= val
	IF N_ELEMENTS(bas) 		NE 0 THEN self.bas 		= val
	IF N_ELEMENTS(haut) 		NE 0 THEN self.haut 		= val
	IF N_ELEMENTS(code) 		NE 0 THEN self.code 		= val
	IF N_ELEMENTS(true) 		NE 0 THEN self.true 		= val
	IF N_ELEMENTS(translation) 	NE 0 THEN self.translation 	= allocfree (self.translation,val)
	IF N_ELEMENTS(rvb) 		NE 0 THEN self.rvb		= allocfree (self.rvb,val)
	IF N_ELEMENTS(shade_rvb) 	NE 0 THEN self.shade_rvb 	= val

END

;-------------------------------------------------------------------------------
PRO fen::cleanup
;-------------------------------------------------------------------------------
; Supprime les donnes internes.
;-------------------------------------------------------------------------------

	self -> fen_remove_data

END

;-------------------------------------------------------------------------------
FUNCTION fen::init,	$
;-------------------------------------------------------------------------------
	general	; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Constructeur de la classe "fen".
;-------------------------------------------------------------------------------

	self.general = general

	RETURN, 1

END

;-------------------------------------------------------------------------------
PRO fen__define
;-------------------------------------------------------------------------------
; La classe 'fen" n'hrite pas d'un autre objet.
;-------------------------------------------------------------------------------

	lint_unused = { fen, $

		gauche:			0., 		$
		droite:			0., 		$
		bas:			0., 		$
		haut:			0., 		$

		code:			0, 		$
		true:			0, 		$
		rvb:			PTR_NEW(), 	$
		shade_rvb:		0, 		$ ; 1 pour la palette utilise pour SHADE_SURF
		translation:		PTR_NEW(), 	$

		device:			OBJ_NEW(), 	$
		general:		OBJ_NEW() 	$

	}

END
