;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: exp_bepi_mmohk__define.pro.configure,v $, v $Revision: 1.2 $
;
;	Date	: $Date: 2021/06/30 13:05:15 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_001_get_numero	; LINT_PROTOTYPE int 0
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne le numro unique de l exprience (entre 1 et 99)
;-------------------------------------------------------------------------------
	RETURN, 		126
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_002_get_groupe, $	; LINT_PROTOTYPE int 0
;-------------------------------------------------------------------------------
	noproduit                                              ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne le numro de groupe du produit (voir le champ no de la structure renvoye par group_exp())
;
; Entres:
; --------
;  - noproduit: (RO) numro du produit
;-------------------------------------------------------------------------------
	RETURN, 		27
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_003_get_listenoms	; LINT_PROTOTYPE STRING 1
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne une liste de noms [nom_court, nom_long, nom_principal, puis un ou plusieurs noms utiliables dans les titres]
;
; Cette liste est mmorise dans le champ listenoms de la strucure T1 du COMMON UTIL_T1.
; Utilis dans cl.pro pour appeller util_ajouter_info_experiment
;-------------------------------------------------------------------------------
	RETURN, 		['MMOHK','BEPI_MMOHK',   'BEPI-MMOHK']
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_004_get_count3d
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne 1 si l exprience doit apparaitre dans la liste Experiment des objets count3d__define, 0 sinon
;
; Utilis dans cl.pro pour appeller util_ajouter_info_experiment
;-------------------------------------------------------------------------------
	RETURN, 		1
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_005_get_timeseries
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne 1 si l exprience doit apparaitre dans la liste Experiment des objets timeseries__define
;
; Utilis dans cl.pro pour appeller util_ajouter_info_experiment
;-------------------------------------------------------------------------------
	RETURN, 		1
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_006_get_container
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne 1 si l exprience doit apparaitre dans la liste Experiment des objets container__define, 0 sinon
;
; Utilis dans cl.pro pour appeller util_ajouter_info_experiment
;-------------------------------------------------------------------------------
	RETURN, 		1
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_007_get_orbitogen
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne 1 si l exprience doit apparaitre dans la liste Experiment des objets orbitogen__define, 0 sinon
;
; Utilis dans cl.pro pour appeller util_ajouter_info_experiment
;-------------------------------------------------------------------------------
	RETURN, 		1
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_008_get_title
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne 1 si l exprience doit apparaitre dans la liste Experiment des objets title__define, 0 sinon
;
; Utilis dans cl.pro pour appeller util_ajouter_info_experiment
;-------------------------------------------------------------------------------
	RETURN, 			1
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_009_get_productsinfo
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne 1 si l exprience doit apparaitre dans Info/Products, 0 sinon
;
; Utilis dans cl.pro pour appeller util_ajouter_info_experiment
;-------------------------------------------------------------------------------
	RETURN, 		1
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_010_get_commentaire
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne un tableau de commentaires, un commentaire par produit, qui seront affichs dans Products des objects.
;
; Utilis dans cl.pro pour appeller util_ajouter_info_experiment
;-------------------------------------------------------------------------------
	RETURN, 		(*self.infos).commentaire
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_011_get_is_valid, $
;-------------------------------------------------------------------------------
	noproduit                                              ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne 1 si le produit est un produit valide, 0 sinon
;
; Entres:
; --------
;  - noproduit: (RO) numro du produit
;-------------------------------------------------------------------------------
	RETURN, 		noproduit LT N_ELEMENTS(*self.infos)
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_012_get_is_spectro, $
;-------------------------------------------------------------------------------
	noproduit                                              ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne 1 si le produit est un produit spectrogramme, 0 sinon
;
; Entres:
; --------
;  - noproduit: (RO) numro du produit
;
; -----------------------------------------------
; Rcapitulatif pour les expriences avec EXP_MOM
; -----------------------------------------------
; 001: GET_CANCOMPUTE2D
; 002: GET_PHI
; 003: GET_XMOY
; 004: GET_ORDRECLUSTER
; 005: GET_COMPUTE_ALL
; 006: GET_MREP2
; 008: AFTER_COMPUTATION
; 009: GET_QUICK_SOLID
; 010: GET_SC_POT_VOLT
; 011: GET_USE_HIA_MASSE
; 012: GET_USE_LONG_VAR
; 013: GET_CORRECT_TABLE
; 014: GET_REP2NAME
; 015: USE_SCPOT
;
;				CALCUL DES MOMENTS			001 002 003 004 005 006 008 009 010 011 012 013 014             015
;
;  ace				non(pas 3D)
;  ascii			OUI(si 3D)	faux(eff?fg?)		!
;  aspera3:	*els*		OUI					1   ok  ok  0    0  1   ok  0   ok  0   0   0   [vide sc mso]   1
;		*ima*		OUI					0   ok  ok  0    1  1   ok  0   ok  0   0   0   [vide sc mso]   0
;		npd1		OUI 		absurde			!
;		npd2		OUI 		absurde			!
;		npi		non(pas 3D)
;  aspera4:	*els*		OUI					1   ok  ok  0    0  1   ok  0   ok  0   0   0   [sc sc vso]     1
;		*ima*		OUI					0   ok  ok  0    1  1   ok  0   ok  0   0   0   [sc sc vso]     0
;		npd1		OUI 		absurde			!
;		npd2		OUI 		absurde			!
;		npi		non(pas 3D)
;  cluster:	*codif*		OUI					0   ok  ok  1    1  1   ok  0   ok  0   0   0   [gse sc gse]    1
;  		*hia*		OUI					0   ok  ok  1    1  1   ok  0   ok  1   0   0   [gse sc gse]    1
;  		*peace*		OUI 		faux(eff?fg?)		1   ok  ok  1    1  x   ok  0   ok  0   0   0   [gse sc gse]    1
;  demeter:	ice		non(pas 3D)
;		idp		non(pas 3D)
;		imsc		non(pas 3D)
;  *dsp*			OUI					0   ok  ok  1    1  1   ok  0   ok  1   0   0   [gse sc gse]    1
;  geotail			non(pas 3D)
;  interball:	*electron*	OUI					0   ok  ok  1    0  1   ok  0   ok  0   0   0   [elec elec gse] 1
;		elecxchy	non(pas 3D)
;		ionxchy		non(pas 3D)
;  mgs				non(pas 3D)
;  plugin_caa			OUI(si 3D) 	faux(eff?fg?)	        !
;  sacc				non(pas 3D)
;  stereo:	let		non(pas 3D)
;		plastic		non(pas 3D)
;		sept		non(pas 3D)
;		sit		non(pas 3D)
;		ste		non(pas 3D)
;		*swea*		OUI					1  ok   ok  0    1  1   ok  0   ok  0   1   0   [sc sc gse rtn] 1
;  themis:	*eesa*		OUI					1  ok   ok  1    1  1   ok  1   ok  0   ok  0   [dsl dsl gse]   1
;		*esst*		OUI					1  ok   ok  1    1  1   ok  0   ok  0   0   0   [dsl dsl gse]   1
;		fbk		non(pas 3D)
;		*iesa*		OUI					1  ok   ok  1    1  1   ok  1   ok  1   ok  0   [dsl dsl gse]   1
;		*isst*		OUI					1  ok   ok  1    1  1   ok  0   ok  1   0   0   [dsl dsl gse]   1
;  wind				non(pas 3D)
;  xmm				non(pas 3D)
;
; ----------------------------------------------
; Rcapitulatif pour les expriences avec EXP_VB
; ----------------------------------------------
; 001: GET_INPUT
; 002: GET_OUT
; 003: GET_MASSE
; 004: GET_DMAX
;
;			001	002	003				004
;
; cluster_codif		ok	ok	[1.,4.,4.,16.]*MASSEPROTON	4000d
; cluster_hia		ok	ok	masseproton			4000d
; dsp			ok	ok	masseproton			4000d
; themis_eesa		ok	ok	masseelectron			4000d
; themis_iesa		ok	ok	masseproton			4000d
;-------------------------------------------------------------------------------
	RETURN, 		(*self.infos)[noproduit].nbangles NE 0
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_013_get_is_aux, $
;-------------------------------------------------------------------------------
	noproduit                                          , $ ; LINT_PROTOTYPE input
	aux_nom                                            , $ ; LINT_PROTOTYPE output
	aux_enreg                                          , $ ; LINT_PROTOTYPE output
	aux_taille                                         , $ ; LINT_PROTOTYPE output
	champB                                             , $ ; LINT_PROTOTYPE output
	moments_board                                          ; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne 1 si le produit permet de calculer des donnes auxilliaires (ex: module vecteur, passage repre gsm).

; Pour toutes les expriences
;
; Entres:
; --------
;  - noproduit: (RO) numro du produit
;
; Sorties:
; --------
;  - aux_nom:       (si ncessaire) noms des champs a afficher dans les widgets pour les donnes auxilliaires
;  - aux_enreg:     (si ncessaire) avec les donnes auxilliaires
;  - aux_taille:    (si ncessaire) d octets de la structure donnes auxilliaires
;  - champB:        1 si ce produit contient des donnes champ magntique
;  - moments_board: 1 si ce produit contient des donnes moments board
;-------------------------------------------------------------------------------
	RETURN, 		0
END

;-------------------------------------------------------------------------------
PRO exp_bepi_mmohk::exp_all_014_get_aux, $
;-------------------------------------------------------------------------------
	general                                            , $ ; LINT_PROTOTYPE input
	noproduit                                          , $ ; LINT_PROTOTYPE input
	nosat                                              , $ ; LINT_PROTOTYPE input
	tmp                                                , $ ; LINT_PROTOTYPE input
	tmpaux                                                 ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Calcule les donnes auxilliaires.
;
; Entres:
; --------
;  - general:   (RO) objet general
;  - noproduit: (RO) numro du produit
;  - nosat:     (RO) numro du satellite
;  - tmp:       (RO) tableau de structure avec les donnes lues
;  - tmpaux:    (RW) tableau de structure avec les donnes auxilliaires  calculer
;
; Sorties:
; --------
;  - tmpaux:    tableau de structure avec les donnes auxilliaires correspondantes calcules
;-------------------------------------------------------------------------------
END
;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_015_get_usefillval, $
;-------------------------------------------------------------------------------
	noproduit                                              ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne 1 si le produit utilise FILLVAL renvoy par EXP_ALL_016_GET_FILLVAL.
;
; Entres:
; --------
;  - noproduit: (RO) numro du produit
;-------------------------------------------------------------------------------
	RETURN, 		1
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_016_get_fillval, $
;-------------------------------------------------------------------------------
	noproduit                                              ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne la valeur de FILLVAL (appele uniquement si le EXP_ALL_015_GET_USEFILLVAL correspondant vaut 1).
;
; Entres:
; --------
;  - noproduit: (RO) numro du produit
;-------------------------------------------------------------------------------
	RETURN, 		-1e31
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_017_get_tfillval, $
;-------------------------------------------------------------------------------
	noproduit                                              ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne le caractre correspondant  FILLVAL (utile si le fichier ascii ne dfinit pas bien FILLVALL).
;
; Entres:
; --------
;  - noproduit: (RO) numro du produit
;-------------------------------------------------------------------------------
	RETURN, 		'*'
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_018_get_dateminmax, $
;-------------------------------------------------------------------------------
	nosat                                                  ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne un tableau [date_debut_donnes, date_fin_donnes] (en nbmsec depuis 1/1/1958)
;
; Entres:
; --------
;  - nosat: (RO) numro du satellite
;-------------------------------------------------------------------------------
	RETURN, 		[tu_to_date(2012,11,20,0,0,0),tu_to_date(9999,1,1,0,0,0)]
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_019_get_nomcalib
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne le nom qui sera utilis lors de l appel  EXP_SPE_014_CALIB_LIRE dans  compute_timeseries et compute_count3d
;-------------------------------------------------------------------------------
	RETURN, 		'BEPI'
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_020_get_version, $
;-------------------------------------------------------------------------------
	noproduit                                              ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne le premier caractre du numro de version dans les nom des fichier de donnes (typiquement V ou v)
;
; Entres:
; --------
;  - noproduit: (RO) numro du produit
;-------------------------------------------------------------------------------
	RETURN, 		'V'
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_021_get_nomproduit, $
;-------------------------------------------------------------------------------
	noproduit                                              ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne le nom du produit qui sera affich  l cran si ncessaire
;
; Entres:
; --------
;  - noproduit: (RO) numro du produit
;-------------------------------------------------------------------------------
	RETURN, 		(*self.infos)[noproduit].nomproduit
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_022_get_repertoire, $
;-------------------------------------------------------------------------------
	racine                                             , $ ; LINT_PROTOTYPE input
	noproduit                                          , $ ; LINT_PROTOTYPE input
	nosat                                                  ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne le rpertoire o se trouve le fichier de donnes
;
; Entres:
; --------
;  - racine:      (RO) racine des donnes (typiquement /DATA)
;  - noproduit:   (RO) numro du produit
;  - nosat:       (RO) numro du satellite
;-------------------------------------------------------------------------------
	RETURN, 		racine + 'MMO-HK/$YEAR/$MONTH/'
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_023_get_fichier, $	; LINT_PROTOTYPE STRING 0
;-------------------------------------------------------------------------------
	noproduit                                          , $ ; LINT_PROTOTYPE input LONG	0
	nosat                                              , $ ; LINT_PROTOTYPE input LONG	0
	version                                                ; LINT_PROTOTYPE input STRING	0
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne le nom du fichier de donnes
;
; Entres:
; --------
;  - noproduit: (RO) numro du produit
;  - nosat:     (RO) numro du satellite
;  - version:   (RO) chaine identifiant la version (ex: V??)
;-------------------------------------------------------------------------------
	RETURN, 		(*self.infos)[noproduit].fichier
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_024_get_non_int_milli, $
;-------------------------------------------------------------------------------
	noproduit                                              ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne 1 ou 2 si la datation des donnes peut contenir des millisecondes non entires, 0 sinon
; 1 pour supprimer les fractions de millisecondes, 2 pour garder les fractions de millisecondes.
;
; Entres:
; --------
;  - noproduit: (RO) numro du produit
;-------------------------------------------------------------------------------
	RETURN, 		1
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_025_get_tabpriorite, $
;-------------------------------------------------------------------------------
	tabpriorite                                            ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne un tableau[nbproduits] de priorits entre 1 (maximale) et 99 (minimale) qui sera utilis si plusieurs produits existent en mme temps dans un spectrogramme
;
; Entres:
; --------
;  - tabpriorite: (RO) tableau[nbproduits] contenant que des 99
;-------------------------------------------------------------------------------
	RETURN, 		REFORM((*self.infos).priorite,N_ELEMENTS(*self.infos))
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_026_get_has_current, $
;-------------------------------------------------------------------------------
	noproduit                                              ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne 1 si le produit permet de calculer current, 0 sinon
;
; Entres:
; --------
;  - noproduit: (RO) numro du produit
;-------------------------------------------------------------------------------
	RETURN, 		0
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_027_get_has_oh, $
;-------------------------------------------------------------------------------
	noproduit                                              ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne 1 si le produit permet de calculer oh, 0 sinon
;
; Entres:
; --------
;  - noproduit: (RO) numro du produit
;-------------------------------------------------------------------------------
	RETURN, 		0
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_028_get_has_vb, $
;-------------------------------------------------------------------------------
	noproduit                                              ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne 1 si le produit permet de calculer vb, 0 sinon
;
; Entres:
; --------
;  - noproduit: (RO) numro du produit
;-------------------------------------------------------------------------------
	RETURN, 		0
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_029_get_nbsensitivity
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne le nombre de sensitivity (1 ou 2)
;-------------------------------------------------------------------------------
	RETURN, 		1
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_030_get_epoch, $
;-------------------------------------------------------------------------------
	nosat                                              , $ ; LINT_PROTOTYPE input
	noproduit                                              ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne un tableau [nom_variable_epoch ou chaine vide, annee_reference_epoch ou chaine vide] (utile pour les fichiers THEMIS)
;
; Entres:
; --------
;  - nosat:     (RO) numro du satellite
;  - noproduit: (RO) numro du produit
;-------------------------------------------------------------------------------
	RETURN, 			['','']
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_031_has_data_to_cldata, $
;-------------------------------------------------------------------------------
	noproduit                                              ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne 1 si la routine EXP_ALL_032_DATA_TO_CLDATA doit tre appele, 0 sinon
;
; Entres:
; --------
;  - noproduit: (RO) numro du produit
;-------------------------------------------------------------------------------
	RETURN,     	0
END

;-------------------------------------------------------------------------------
PRO exp_bepi_mmohk::exp_all_032_data_to_cldata, $
;-------------------------------------------------------------------------------
	noproduit                                          , $ ; LINT_PROTOTYPE input
	nosat                                              , $ ; LINT_PROTOTYPE input
	filename                                           , $ ; LINT_PROTOTYPE input
	tmp                                                , $ ; LINT_PROTOTYPE input
	general                                            , $ ; LINT_PROTOTYPE input
	REC_START                                          , $ ; LINT_PROTOTYPE input
	REC_COUNT                                          , $ ; LINT_PROTOTYPE input
	struct                                             , $ ; LINT_PROTOTYPE input
	ENERGIES                                           , $ ; LINT_PROTOTYPE output
	DT                                                 , $ ; LINT_PROTOTYPE output
	THETA                                              , $ ; LINT_PROTOTYPE output
	PHI                                                , $ ; LINT_PROTOTYPE output
	MASS                                               , $ ; LINT_PROTOTYPE output
	PROPERTY                                           , $ ; LINT_PROTOTYPE output
	UNIT123D                                           , $ ; LINT_PROTOTYPE output
	NAME123D                                           , $ ; LINT_PROTOTYPE output
	NAME_THETA                                         , $ ; LINT_PROTOTYPE output
	UNIT_THETA                                         , $ ; LINT_PROTOTYPE output
	NAME_PHI                                           , $ ; LINT_PROTOTYPE output
	UNIT_PHI                                           , $ ; LINT_PROTOTYPE output
	NAME_ENERGY                                        , $ ; LINT_PROTOTYPE output
	UNIT_ENERGY                                        , $ ; LINT_PROTOTYPE output
	NAME_MASS                                          , $ ; LINT_PROTOTYPE output
	UNIT_MASS                                          , $ ; LINT_PROTOTYPE output
	getinf=getinf                                          ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Traitement particulier des donnes  faire dans cette routine
;
; Entres:
; --------
;  - general:           (RO) objet general
;  - nosat:             (RO) numro du satellite
;  - filename:          (RO) nom du fichier  lire
;  - REC_START:         (RO) enregistrement dbut
;  - REC_COUNT:         (RO) nombre d enregistrements a lire
;  - noproduit:         (RO) numro du produit
;  - tmp:               (RW) tableau de structure de donnes lues (si binaire GETCO==1) ou  lire (si ascii ou cdf)
;
; Sorties:
; --------
;  - tmp:               tableau de structure de donnes lues aprs traitement (si binaire et GETCO==1) ou lecture (si ascii ou cdf)
;  - ENERGIES:          table d energies		(pas obligatoire)
;  - DT:                structure DT			(pas obligatoire)
;  - THETA              table d angles THETA		(pas obligatoire)
;  - PHI:               table d angles PHI		(pas obligatoire)
;  - MASS:              table de MASS			(pas obligatoire)
;  - PROPERTY:          chaine PROPERTY des comptages	(pas obligatoire)
;  - UNIT123D:          chaine UNIT des comptages	(pas obligatoire)
;  - NAME123D:          chaine NAME des comptages	(pas obligatoire)
;  - NAME_THETA:        chaine NAME des angles theta	(pas obligatoire)
;  - UNIT_THETA:        chaine UNIT des angles theta	(pas obligatoire)
;  - NAME_PHI:          chaine NAME des angles phi	(pas obligatoire)
;  - UNIT_PHI:          chaine UNIT des angles phi	(pas obligatoire)
;  - NAME_ENERGY:       chaine NAME des nergies	(pas obligatoire)
;  - UNIT_ENERGY:       chaine UNIT des nergies	(pas obligatoire)
;  - NAME_MASS:         chaine NAME des masses		(pas obligatoire)
;  - UNIT_MASS:         chaine UNIT des masses		(pas obligatoire)
;-------------------------------------------------------------------------------
END
;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_033_get_nbsat
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne le nombre de satellites pour l exprience
;-------------------------------------------------------------------------------
	RETURN, 			1
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_034_get_nosat, $
;-------------------------------------------------------------------------------
	nosat                                                  ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne la chaine de caractre SC suivi du numro du satellite
;
; Entres:
; --------
;  - nosat: (RO) numro du satellite
;-------------------------------------------------------------------------------
	RETURN, 			''
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_035_get_nomsat, $
;-------------------------------------------------------------------------------
	nosat                                                  ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne une chaine de caractre avec le nom du satellite
;
; Entres:
; --------
;  - nosat: (RO) numro du satellite
;-------------------------------------------------------------------------------
	RETURN, 		'BEPI'
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_036_get_nomnosat, $
;-------------------------------------------------------------------------------
	nosat                                                  ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne une chaine de caractre avec SC suivi du numro du satellite puis le nom du satellite entre parenthses
;
; Entres:
; --------
;  - nosat: (RO) numro du satellite
;-------------------------------------------------------------------------------
	RETURN, 		''
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_037_get_mission, $
;-------------------------------------------------------------------------------
	noproduit_dynamique                                , $ ; LINT_PROTOTYPE input
	nosat_dynamique                                        ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne une chaine de caractre avec le nom de la mission
;
; Entres:
; --------
;  - noproduit_dynamique: (RO) numro du produit
;  - nosat_dynamique:     (RO) numro du satellite
;-------------------------------------------------------------------------------
	RETURN, 		"BEPI"
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_038_get_source_name, $
;-------------------------------------------------------------------------------
	noproduit_dynamique                                , $ ; LINT_PROTOTYPE input
	nosat_dynamique                                        ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne une chaine de caractre avec le nom de la mission puis > mission puis spacecraft et le numro du satellite
;
; Entres:
; --------
;  - noproduit_dynamique: (RO) numro du produit
;  - nosat_dynamique:     (RO) numro du satellite
;-------------------------------------------------------------------------------
	RETURN, 		""
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_039_get_descriptor, $
;-------------------------------------------------------------------------------
	noproduit_dynamique                                , $ ; LINT_PROTOTYPE input
	nosat_dynamique                                        ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne une chaine de caractre avec le nom abrge de l exprience puis > puis le nom complet de l exprience
;
; Entres:
; --------
;  - noproduit_dynamique: (RO) numro du produit
;  - nosat_dynamique:     (RO) numro du satellite
;-------------------------------------------------------------------------------
	RETURN, 		""
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_040_get_pi_name, $
;-------------------------------------------------------------------------------
	noproduit_dynamique                                , $ ; LINT_PROTOTYPE input
	nosat_dynamique                                        ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne une chaine de caractre avec le nom du PI de l exprience
;
; Entres:
; --------
;  - noproduit_dynamique: (RO) numro du produit
;  - nosat_dynamique:     (RO) numro du satellite
;-------------------------------------------------------------------------------
	RETURN, 		""
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_041_get_pi_affiliation, $
;-------------------------------------------------------------------------------
	noproduit_dynamique                                , $ ; LINT_PROTOTYPE input
	nosat_dynamique                                        ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne une chaine de caractre avec le nom du labo du PI de l exprience
;
; Entres:
; --------
;  - noproduit_dynamique: (RO) numro du produit
;  - nosat_dynamique:     (RO) numro du satellite
;-------------------------------------------------------------------------------
	RETURN, 	""
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_042_get_txt_cef, $
;-------------------------------------------------------------------------------
	noproduit_dynamique                                , $ ; LINT_PROTOTYPE input
	nosat_dynamique                                        ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne une chaine de caractre commencant par ! avec le nom de l exprience
;
; Entres:
; --------
;  - noproduit_dynamique: (RO) numro du produit
;  - nosat_dynamique:     (RO) numro du satellite
;-------------------------------------------------------------------------------
	RETURN, 		""
END

;exp_all_043_get_shift!
;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_044_get_has_currentie, $
;-------------------------------------------------------------------------------
	noproduit                                              ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne 1 si le produit permet de calculer current avec les ions et les electrons, 0 sinon
;
; Entres:
; --------
;  - noproduit: (RO) numro du produit
;-------------------------------------------------------------------------------
	RETURN, 		0
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_045_get_has_gradpressmom, $
;-------------------------------------------------------------------------------
	noproduit                                              ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne 1 si le produit permet de calculer le gradient de pression avec les moments prcalculs, 0 sinon
;
; Entres:
; --------
;  - noproduit: (RO) numro du produit
;-------------------------------------------------------------------------------
	RETURN, 	0
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::exp_all_046_get_has_lawohm, $
;-------------------------------------------------------------------------------
	noproduit                                              ; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne 1 si le produit permet de calculer les termes de la loi d ohm, 0 sinon
;
; Entres:
; --------
;  - noproduit: (RO) numro du produit
;-------------------------------------------------------------------------------
	RETURN, 		0
END

;-------------------------------------------------------------------------------
PRO exp_bepi_mmohk::exp_all_500_init, $
;-------------------------------------------------------------------------------
	param0                                             , $ ; LINT_PROTOTYPE input
	tab_infos                                          , $ ; LINT_PROTOTYPE output
	tabcommentaire                                     , $ ; LINT_PROTOTYPE output
	current_nom                                        , $ ; LINT_PROTOTYPE output
	current_enreg                                      , $ ; LINT_PROTOTYPE output
	current_taille                                     , $ ; LINT_PROTOTYPE output
	currentie_nom                                      , $ ; LINT_PROTOTYPE output
	currentie_enreg                                    , $ ; LINT_PROTOTYPE output
	currentie_taille                                   , $ ; LINT_PROTOTYPE output
	gradpressmom_enreg                                 , $ ; LINT_PROTOTYPE output
	gradpressmom_taille                                , $ ; LINT_PROTOTYPE output
	gradpressmom_nom                                   , $ ; LINT_PROTOTYPE output
	gradpressmom_unite                                 , $ ; LINT_PROTOTYPE output
	gradpressmom_libelle                               , $ ; LINT_PROTOTYPE output
	lawohm_enreg                                       , $ ; LINT_PROTOTYPE output
	lawohm_taille                                      , $ ; LINT_PROTOTYPE output
	lawohm_nom                                         , $ ; LINT_PROTOTYPE output
	lawohm_unite                                       , $ ; LINT_PROTOTYPE output
	lawohm_libelle                                     , $ ; LINT_PROTOTYPE output
	oh_nom                                             , $ ; LINT_PROTOTYPE output
	oh_enreg                                           , $ ; LINT_PROTOTYPE output
	oh_taille                                          , $ ; LINT_PROTOTYPE output
	vb_nom                                             , $ ; LINT_PROTOTYPE output
	vb_enreg                                           , $ ; LINT_PROTOTYPE output
	vb_taille                                              ; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne des structure des donnes permettant le stockage en mmoire de certaines donnes calcules (current, oh, vb)
;
; Entres:
; --------
;  - param0: (RW) structure avec au moins les champs { h1, so1, o1, he1, he2, o2, ion8, ion16, ion32, ion64 }
;
; Sorties:
; --------
;  - param0:           champs h1, so1, o1, he1, he2, o2, ion8, ion16, ion32, ion64 ventuellement modifis			(pas obligatoire)
;  - tab_infos:        tableau[nbproduits] de structure avec les champs { nbspectres, nbangles, nbangles_a_lire, nbenergies }	(pas obligatoire)
;  - tabcommentaire:   tableau de commentaires, un commentaire par produit							(pas obligatoire)
;  - current_nom:      noms des champs dans la structure current								(pas obligatoire)
;  - current_enreg:    structure pour les donnes current									(pas obligatoire)
;  - current_taille:   nombre d octets dans la structure current								(pas obligatoire)
;  - currentie_nom:    noms des champs dans la structure currentie								(pas obligatoire)
;  - currentie_enreg:  structure pour les donnes currentie									(pas obligatoire)
;  - currentie_taille: nombre d octets dans la structure currentie								(pas obligatoire)
;  - oh_nom:           noms des champs dans la structure oh									(pas obligatoire)
;  - oh_enreg:         structure pour les donnes oh										(pas obligatoire)
;  - oh_taille:        nombre d octets dans les donnes oh									(pas obligatoire)
;  - vb_nom:           noms des champs dans la structure vb									(pas obligatoire)
;  - vb_enreg:         structure pour les donnes vb										(pas obligatoire)
;  - vb_taille:        nombre d octets dans les donnes vb									(pas obligatoire)
;-------------------------------------------------------------------------------
	tab_infos = *self.infos
	tabcommentaire = (*self.infos).commentaire
END
;-------------------------------------------------------------------------------
PRO exp_bepi_mmohk::exp_all_600_get_structure, $
;-------------------------------------------------------------------------------
	infos                                              , $ ; LINT_PROTOTYPE input
	param                                              , $ ; LINT_PROTOTYPE input
	isascii                                            , $ ; LINT_PROTOTYPE output
	iscdf                                              , $ ; LINT_PROTOTYPE output
	isorbito                                           , $ ; LINT_PROTOTYPE output
	libelle                                            , $ ; LINT_PROTOTYPE output
	unite                                              , $ ; LINT_PROTOTYPE output
	classe                                             , $ ; LINT_PROTOTYPE output
	keywords                                           , $ ; LINT_PROTOTYPE output
	nom                                                , $ ; LINT_PROTOTYPE output
	enreg                                              , $ ; LINT_PROTOTYPE output
	enreg0b                                            , $ ; LINT_PROTOTYPE output
	enreg1b                                            , $ ; LINT_PROTOTYPE output
	enreg2b                                            , $ ; LINT_PROTOTYPE output
	taille                                             , $ ; LINT_PROTOTYPE output
	taille1                                            , $ ; LINT_PROTOTYPE output
	taille1b                                           , $ ; LINT_PROTOTYPE output
	enreg1                                             , $ ; LINT_PROTOTYPE output
	enregcoups                                         , $ ; LINT_PROTOTYPE output
	ENERGIES                                           , $ ; LINT_PROTOTYPE output
	THETA                                              , $ ; LINT_PROTOTYPE output
	PHI                                                , $ ; LINT_PROTOTYPE output
	MASS                                               , $ ; LINT_PROTOTYPE output
	DT                                                 , $ ; LINT_PROTOTYPE output
	PROPERTY                                           , $ ; LINT_PROTOTYPE output
	UNIT123D                                           , $ ; LINT_PROTOTYPE output
	NAME123D                                           , $ ; LINT_PROTOTYPE output
	NAME_THETA                                         , $ ; LINT_PROTOTYPE output
	UNIT_THETA                                         , $ ; LINT_PROTOTYPE output
	NAME_PHI                                           , $ ; LINT_PROTOTYPE output
	UNIT_PHI                                           , $ ; LINT_PROTOTYPE output
	NAME_ENERGY                                        , $ ; LINT_PROTOTYPE output
	UNIT_ENERGY                                        , $ ; LINT_PROTOTYPE output
	NAME_MASS                                          , $ ; LINT_PROTOTYPE output
	UNIT_MASS                                              ; LINT_PROTOTYPE output
;-------------------------------------------------------------------------------
; (pour toutes les expriences) Retourne des informations permettant le stockage des donnes en mmoire des donnes lues
;
; Entres:
; --------
;  - infos:  (RO) structure tab_infos[noproduit] renvoye par EXP_ALL_500_INIT
;  - param:  (RO) structure, on est en train de traiter le produit param.noproduit
;
; Sorties:
; --------
;  - isascii :    1 si le produit concerne un fichier ascii, 0 sinon
;  - iscdf:       1 si le produit concerne un fichier cdf, 0 sinon
;  - isorbito:    1 si le produit contient des donnes d orbite, 0 sinon
;  - libelle:     tableau de libells, un libell par champ du fichier de donnes
;  - unite:       tableau d units, une unit par champ du fichier de donnes
;  - classe:      tableau de classe, une classe par champ du fichier de donnes
;  - keywords:    keywords associs
;  - nom:         tableau de noms, un nom par champ du fichier de donnes
;  - enreg:       structure pour les donnes
;  - enreg0b:     structure pour les donnes si on supprime les comptages
;  - enreg1b:     structure pour les donnes si on compresse les comptages sur 1 octet
;  - enreg2b:     structure pour les donnes si on compresse les comptages sur 2 octets
;  - taille:      nombre d octets dans la structure enreg
;  - taille1:     utilis uniquement pour CLUSTER-CODIF P5(WEC) et P6(FGM)
;  - taille1b:    nombre d octets dans la structure enreg1b
;  - enreg1:      utilis uniquement pour CLUSTER-CODIF P5(WEC) et P6(FGM)
;  - enregcoups:  utilis uniquement pour ASPERA3-IMA et ASPERA4-IMA (structure des donnes non compresses)
;  - ENERGIES:    utilis uniquement pour PLUGIN
;  - THETA:       utilis uniquement pour PLUGIN
;  - PHI:         utilis uniquement pour PLUGIN
;  - MASS:        utilis uniquement pour PLUGIN
;  - DT:          utilis uniquement pour PLUGIN
;  - PROPERTY:    utilis uniquement pour PLUGIN
;  - UNIT123D:    utilis uniquement pour PLUGIN
;  - NAME123D:    utilis uniquement pour PLUGIN
;  - NAME_THETA:  utilis uniquement pour PLUGIN
;  - UNIT_THETA:  utilis uniquement pour PLUGIN
;  - NAME_PHI:    utilis uniquement pour PLUGIN
;  - UNIT_PHI:    utilis uniquement pour PLUGIN
;  - NAME_ENERGY: utilis uniquement pour PLUGIN
;  - UNIT_ENERGY: utilis uniquement pour PLUGIN
;  - NAME_MASS:   utilis uniquement pour PLUGIN
;  - UNIT_MASS:   utilis uniquement pour PLUGIN
;-------------------------------------------------------------------------------
	IF param.noproduit EQ 0 THEN BEGIN
		isascii = 1
		tab = [	[ 	'date',			'nbms since 1/1/1958',								'ms',		'double'		],	$
			[	'PCD.SA_V',		'PCD.SA_V',									'V',		'float'			],	$
			[	'PCD.SA_I',		'PCD.SA_I',									'A',		'float'			],	$
			[	'PCD.APR1_I',		'PCD.APR1_I',									'',		'float'			],	$
			[	'PCD.APR2_I',		'PCD.APR2_I',									'',		'float'			],	$
			[	'PCD.LOAD_I',		'PCD.LOAD_I',									'',		'float'			],	$
			[	'PCD.BAT_V',		'PCD.BAT_V',									'',		'float'			],	$
			[	'PCD.CHG_I',		'PCD.CHG_I',									'',		'float'			],	$
			[	'PCD.DCHG_I',		'PCD.DCHG_I',									'',		'float'			],	$
			[	'PCD.BUS_V',		'PCD.BUS_V',									'',		'float'			],	$
			[	'PCD.PCD_P3V',		'PCD.PCD_P3V',									'',		'float'			],	$
			[	'PCD.PCD_P3VL',		'PCD.PCD_P3VL',									'',		'float'			],	$
			[	'PCD.PCD_P12V',		'PCD.PCD_P12V',									'',		'float'			],	$
			[	'PCD.PCD_M12V',		'PCD.PCD_M12V',									'',		'float'			],	$
			[	'PCD.PCD_I',		'PCD.PCD_I',									'',		'float'			],	$
			[	'PCD.DMC_PSU_A_I',	'PCD.DMC_PSU_A_I',								'',		'float'			],	$
			[	'PCD.DMC_PSU_B_I',	'PCD.DMC_PSU_B_I',								'',		'float'			],	$
			[	'PCD.DMC_PSU_C_I',	'PCD.DMC_PSU_C_I',								'',		'float'			],	$
			[	'PCD.EPC_A_I',		'PCD.EPC_A_I',									'',		'float'			],	$
			[	'PCD.EPC_B_I',		'PCD.EPC_B_I',									'',		'float'			],	$
			[	'PCD.DRU_HTR_I',	'PCD.DRU_HTR_I',								'',		'float'			],	$
			[	'PCD.DRU_PSU_A_I',	'PCD.DRU_PSU_A_I',								'',		'float'			],	$
			[	'PCD.DRU_PSU_B_I',	'PCD.DRU_PSU_B_I',								'',		'float'			],	$
			[	'PCD.ADMCE_A_I',	'PCD.ADMCE_A_I',								'',		'float'			],	$
			[	'PCD.ADMCE_B_I',	'PCD.ADMCE_B_I',								'',		'float'			],	$
			[	'PCD.XTRP_A_I',		'PCD.XTRP_A_I',									'',		'float'			],	$
			[	'PCD.ADMCE_B_I',	'PCD.ADMCE_B_I',								'',		'float'			],	$
			[	'PCD.XTRP_A_I',		'PCD.XTRP_A_I',									'',		'float'			],	$
			[	'PCD.XTRP_B_I',		'PCD.XTRP_B_I',									'',		'float'			],	$
			[	'PCD.PSU_MDP1_I',	'PCD.PSU_MDP1_I',								'',		'float'			],	$
			[	'PCD.PSU_MDP2_I',	'PCD.PSU_MDP2_I',								'',		'float'			],	$
			[	'PCD.PSU_PME_I',	'PCD.PSU_PME_I',								'',		'float'			],	$
			[	'PCD.PSU_MGF_I_I',	'PCD.PSU_MGF_I_I',								'',		'float'			],	$
			[	'PCD.PSU_MOTOR_A_I',	'PCD.PSU_MOTOR_A_I',								'',		'float'			],	$
			[	'PCD.PSU_MOTOR_B_I',	'PCD.PSU_MOTOR_B_I',								'',		'float'			],	$
			[	'PCD.PSU_ENA_I',	'PCD.PSU_ENA_I',								'',		'float'			],	$
			[	'PCD.PSU_MEA1_I',	'PCD.PSU_MEA1_I',								'',		'float'			],	$
			[	'PCD.PSU_MEA2_I',	'PCD.PSU_MEA2_I',								'',		'float'			],	$
			[	'PCD.PSU_MSA_I',	'PCD.PSU_MSA_I',								'',		'float'			],	$
			[	'PCD.PSU_MIA_I',	'PCD.PSU_MIA_I',								'',		'float'			],	$
			[	'PCD.PSU_HEP_I_I',	'PCD.PSU_HEP_I_I',								'',		'float'			],	$
			[	'PCD.PSU_HEP_E_I',	'PCD.PSU_HEP_E_I',								'',		'float'			],	$
			[	'PCD.MDM_E_I',		'PCD.MDM_E_I',									'',		'float'			],	$
			[	'PCD.MSASI_I',		'PCD.MSASI_I',									'',		'float'			],	$
			[	'PCD.SURVIVAL_HTR_I',	'PCD.SURVIVAL_HTR_I',								'',		'float'			]	]

	END
	FOR i=0L,N_ELEMENTS(tab[0,*])-1 DO BEGIN
		IF STRMID(tab[0,i],0,1) NE '_' THEN ajouter_champ, tab[0,i], get_typeval(tab[3,i]), nom, enreg, taille, first=i EQ 0
	END
	libelle = REFORM (tab[1,*])
	unite = REFORM (tab[2,*])
END

;-------------------------------------------------------------------------------
FUNCTION exp_bepi_mmohk::init
;-------------------------------------------------------------------------------
; Constructeur de la classe exp_bepi_mmohk
;-------------------------------------------------------------------------------
	lint_unused = { struct_bepi_mmohk, commentaire:'', fichier:'', nomproduit:'', level:'', nbangles:0, nbenergies:0, nbspectres:0, dead:0L, priorite:0 }
	infos = [  $ ;            	commentaire	fichier						nomproduit		level	angles	energ 	spect	dead	priorite
		{ struct_bepi_mmohk,  '0  HK',		'MMO_TLM_$YYYYMMDD_current_data_GM.txt',	'HK',	 		 '1',	0,	 0,	 0,	 0,	99 }	]
        self.infos = PTR_NEW(infos)
	RETURN, 1
END
;-------------------------------------------------------------------------------
PRO exp_bepi_mmohk__define
;-------------------------------------------------------------------------------
; La classe exp_bepi_mmohk hrite de exp
;-------------------------------------------------------------------------------
	lint_unused = { exp_bepi_mmohk,	$

		INHERITS	exp, 		$
		infos:		PTR_NEW()	$

	}
END
