;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: exemple__define.pro,v $, v $Revision: 1.8 $
;
;	Date	: $Date: 2021/04/27 09:48:58 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-----------------------------------------------------------------------------
PRO exemple::compute
;-------------------------------------------------------------------------------
; Visualise l'exemple.
;-------------------------------------------------------------------------------

	; ------------------------ DO NOT MODIFY ---------------------------------------
	fenetre = self.fenetre

	hash_general = self.general -> gethash()

	ntrace = getq (self.general, hash_general.ntrace)
	IF ntrace GE 1 THEN BEGIN
		msg = self -> name()
		str = STRING(msg, FORMAT='(A)')
		cl_msg, self.general, str_bas=" "
		cl_msg, self.general, str_bas=str
	END

	x1 = get (self,'gauche')
	x2 = get (self,'droite')
	y1 = get (self,'bas')
	y2 = get (self,'haut')
	; ------------------------ DO NOT MODIFY ---------------------------------------

	; 2 colors to be used: Red and Blue
	red_rvb		= { var_pal, r:255, v:0, b:  0 } & red = 0
	blue_rvb	= { var_pal, r:  0, v:0, b:255 } & blue = 1
	rvb = [red_rvb, blue_rvb]

	; Colors translation
	trans = INDGEN(N_ELEMENTS(rvb))

	; give rvb to fenetre
	fenetre -> fsetproperty,rvb,/rvb

	; IDL code: plot in rectangular are (x1,y1) to (x2,y2)

	truecolor = libplot_get(/D_N_COLORS) GT 256
	color = ~truecolor ? trans[red] : rvb2no(red_rvb.r,red_rvb.v,red_rvb.b)
	libplot_xyouts, (x1+x2)/2, (y1+y2)/2, 'Red text', /normal, color=color

	color = ~truecolor ? trans[blue] : rvb2no(blue_rvb.r,blue_rvb.v,blue_rvb.b)
	libplot_plot, position=[x1,y1,x2,y2], [1,2,3], [1,2,3], color=color, /noerase

END

;-------------------------------------------------------------------------------
FUNCTION exemple::init,	$
;-------------------------------------------------------------------------------
	no,		$	; LINT_PROTOTYPE input
	container,	$	; LINT_PROTOTYPE input
	order,		$	; LINT_PROTOTYPE input
	general			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Constructeur de la classe "exemple".
;-------------------------------------------------------------------------------

        param = [ { var_obj, 'Data:tmp', 'tmp', 2, PTR_NEW(['FL','2','12']), 'check_supegal_infegal', PTR_NEW([0,1]), PTR_NEW (0.5) } ]

	code = self -> obj::init (no, container, order, param, general=general, /saisissable, graphique=1, /nonbcolors)

	RETURN, code

END


;-------------------------------------------------------------------------------
PRO exemple__define
;-------------------------------------------------------------------------------
; La classe "exemple" hérite de "obj".
;-------------------------------------------------------------------------------

	lint_unused = { exemple, 	$

		INHERITS obj 		$

	}

END
