;-------------------------------------------------------------------------------
;
;	Fichier	: $RCSfile: doc__define.pro,v $, v $Revision: 1.7 $
;
;	Date	: $Date: 2014/03/12 17:01:23 $
;
;	Auteur	: $Author: penou $
;
;	Version : %Z% version %I% de %M% du %G%
;
;-------------------------------------------------------------------------------


;-------------------------------------------------------------------------------
PRO doc::doc_voir
;-------------------------------------------------------------------------------
; Permet d'afficher la doc en mode cl ou CLweb.
;-------------------------------------------------------------------------------

	fichier = self.fichier

	batch = get (self.general, 'batch')
	
	IF batch THEN BEGIN
		; pour CLWeb
		OPENR, fd, fichier, /GET_LUN
		ligne = ''
		s = ''
		WHILE ~EOF(fd) DO BEGIN
			READF, fd, ligne
			s += ligne+'<BR>'
		END
		set, self.general, 'clweb_form',s
		RETURN
	END

	fichier_tmp = get (self.general,'gzip_tmp') + '/' + basename(fichier)
	lint_unused = detruire (fichier_tmp)
	FILE_COPY, fichier, fichier_tmp, /OVERWRITE
	XDISPLAYFILE, fichier_tmp, /EDITABLE
	lint_unused = detruire (fichier_tmp)

END

;-------------------------------------------------------------------------------
FUNCTION doc::init,	$
;-------------------------------------------------------------------------------
	fichier,	$	; LINT_PROTOTYPE input
	general			; LINT_PROTOTYPE input
;-------------------------------------------------------------------------------
; Constructeur de cla classe "doc".
;-------------------------------------------------------------------------------

	self.fichier = fichier  
	self.general = general  

	RETURN, 1

END

;-------------------------------------------------------------------------------
PRO doc__define
;-------------------------------------------------------------------------------
; La classe "doc" n'hrite pas.
;-------------------------------------------------------------------------------

	lint_unused = { doc, 		$

		general: OBJ_NEW(), 	$
		fichier: '' 		$

	}

END
